/* Generated by wayland-scanner 1.23.0 */

#ifndef APPMENU_SERVER_PROTOCOL_H
#define APPMENU_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_appmenu The appmenu protocol
 * @section page_ifaces_appmenu Interfaces
 * - @subpage page_iface_org_kde_kwin_appmenu_manager - appmenu dbus address interface
 * - @subpage page_iface_org_kde_kwin_appmenu - appmenu dbus address interface
 * @section page_copyright_appmenu Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2017 David Edmundson
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_appmenu;
struct org_kde_kwin_appmenu_manager;
struct wl_surface;

#ifndef ORG_KDE_KWIN_APPMENU_MANAGER_INTERFACE
#define ORG_KDE_KWIN_APPMENU_MANAGER_INTERFACE
/**
 * @page page_iface_org_kde_kwin_appmenu_manager org_kde_kwin_appmenu_manager
 * @section page_iface_org_kde_kwin_appmenu_manager_desc Description
 *
 * This interface allows a client to link a window (or wl_surface) to an com.canonical.dbusmenu
 * interface registered on DBus.
 * @section page_iface_org_kde_kwin_appmenu_manager_api API
 * See @ref iface_org_kde_kwin_appmenu_manager.
 */
/**
 * @defgroup iface_org_kde_kwin_appmenu_manager The org_kde_kwin_appmenu_manager interface
 *
 * This interface allows a client to link a window (or wl_surface) to an com.canonical.dbusmenu
 * interface registered on DBus.
 */
extern const struct wl_interface org_kde_kwin_appmenu_manager_interface;
#endif
#ifndef ORG_KDE_KWIN_APPMENU_INTERFACE
#define ORG_KDE_KWIN_APPMENU_INTERFACE
/**
 * @page page_iface_org_kde_kwin_appmenu org_kde_kwin_appmenu
 * @section page_iface_org_kde_kwin_appmenu_desc Description
 *
 * The DBus service name and object path where the appmenu interface is present
 * The object should be registered on the session bus before sending this request.
 * If not applicable, clients should remove this object.
 * @section page_iface_org_kde_kwin_appmenu_api API
 * See @ref iface_org_kde_kwin_appmenu.
 */
/**
 * @defgroup iface_org_kde_kwin_appmenu The org_kde_kwin_appmenu interface
 *
 * The DBus service name and object path where the appmenu interface is present
 * The object should be registered on the session bus before sending this request.
 * If not applicable, clients should remove this object.
 */
extern const struct wl_interface org_kde_kwin_appmenu_interface;
#endif

/**
 * @ingroup iface_org_kde_kwin_appmenu_manager
 * @struct org_kde_kwin_appmenu_manager_interface
 */
struct org_kde_kwin_appmenu_manager_interface {
	/**
	 */
	void (*create)(struct wl_client *client,
		       struct wl_resource *resource,
		       uint32_t id,
		       struct wl_resource *surface);
};


/**
 * @ingroup iface_org_kde_kwin_appmenu_manager
 */
#define ORG_KDE_KWIN_APPMENU_MANAGER_CREATE_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_appmenu
 * @struct org_kde_kwin_appmenu_interface
 */
struct org_kde_kwin_appmenu_interface {
	/**
	 * initialise or update the location of the AppMenu interface
	 *
	 * Set or update the service name and object path. Strings should
	 * be formatted in Latin-1 matching the relevant DBus
	 * specifications.
	 */
	void (*set_address)(struct wl_client *client,
			    struct wl_resource *resource,
			    const char *service_name,
			    const char *object_path);
	/**
	 * release the appmenu object
	 *
	 * 
	 */
	void (*release)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_org_kde_kwin_appmenu
 */
#define ORG_KDE_KWIN_APPMENU_SET_ADDRESS_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_appmenu
 */
#define ORG_KDE_KWIN_APPMENU_RELEASE_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
