// This file was generated by qtwaylandscanner
// source file is /usr/share/deepin-wayland-protocols/dde-security.xml

#include "qwayland-server-dde-security.h"

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")

namespace QtWaylandServer {

    int dde_security::deferred_destroy_global_func(void *data) {
        auto object = static_cast<dde_security *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->dde_security_destroy_global();
        return 0;
    }

    dde_security::dde_security(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    dde_security::dde_security(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    dde_security::dde_security(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    dde_security::dde_security()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    dde_security::~dde_security()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->dde_security_object = nullptr;

        if (m_resource)
            m_resource->dde_security_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void dde_security::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void dde_security::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    dde_security::Resource *dde_security::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    dde_security::Resource *dde_security::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void dde_security::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::dde_security_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = dde_security::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *dde_security::interface()
    {
        return &::dde_security_interface;
    }

    dde_security::Resource *dde_security::dde_security_allocate()
    {
        return new Resource;
    }

    void dde_security::dde_security_destroy_global()
    {
    }

    void dde_security::dde_security_bind_resource(Resource *)
    {
    }

    void dde_security::dde_security_destroy_resource(Resource *)
    {
    }

    void dde_security::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        dde_security *that = static_cast<dde_security *>(data);
        that->add(client, id, version);
    }

    void dde_security::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        dde_security *that = static_cast<dde_security::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void dde_security::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        dde_security *that = resource->dde_security_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->dde_security_destroy_resource(resource);

            that = resource->dde_security_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void dde_security::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 10000);
    }

    dde_security::Resource *dde_security::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::dde_security_interface, version, id);
        return bind(handle);
    }

    dde_security::Resource *dde_security::bind(struct ::wl_resource *handle)
    {
        Resource *resource = dde_security_allocate();
        resource->dde_security_object = this;

        wl_resource_set_implementation(handle, &m_dde_security_interface, resource, destroy_func);
        resource->handle = handle;
        dde_security_bind_resource(resource);
        return resource;
    }
    dde_security::Resource *dde_security::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::dde_security_interface, &m_dde_security_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::dde_security_interface dde_security::m_dde_security_interface = {
        dde_security::handle_get_session,
        dde_security::handle_get_ace_clients
    };

    void dde_security::dde_security_get_session(Resource *, uint32_t, uint32_t )
    {
    }

    void dde_security::dde_security_get_ace_clients(Resource *, uint32_t )
    {
    }


    void dde_security::handle_get_session(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t id,
        uint32_t types)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->dde_security_object)) {
            return;
        }
        static_cast<dde_security *>(r->dde_security_object)->dde_security_get_session(
            r,
            id,
            types);
    }

    void dde_security::handle_get_ace_clients(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t pid)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->dde_security_object)) {
            return;
        }
        static_cast<dde_security *>(r->dde_security_object)->dde_security_get_ace_clients(
            r,
            pid);
    }

    void dde_security::send_ace_clients(uint32_t count, const QByteArray &clients)
    {
        Q_ASSERT_X(m_resource, "dde_security::ace_clients", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call dde_security::ace_clients as it's not initialised");
            return;
        }
        send_ace_clients(
            m_resource->handle,
            count,
            clients);
    }

    void dde_security::send_ace_clients(struct ::wl_resource *resource, uint32_t count, const QByteArray &clients)
    {
        struct wl_array clients_data;
        clients_data.size = clients.size();
        clients_data.data = static_cast<void *>(const_cast<char *>(clients.constData()));
        clients_data.alloc = 0;

        dde_security_send_ace_clients(
            resource,
            count,
            &clients_data);
    }



    int security_session::deferred_destroy_global_func(void *data) {
        auto object = static_cast<security_session *>(data);
        wl_global_destroy(object->m_global);
        object->m_global = nullptr;
        wl_event_source_remove(object->m_globalRemovedEvent);
        object->m_globalRemovedEvent = nullptr;
        wl_list_remove(&object->m_displayDestroyedListener.link);
        object->security_session_destroy_global();
        return 0;
    }

    security_session::security_session(struct ::wl_client *client, int id, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(client, id, version);
    }

    security_session::security_session(struct ::wl_display *display, int version)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(display, version);
    }

    security_session::security_session(struct ::wl_resource *resource)
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
        init(resource);
    }

    security_session::security_session()
        : m_resource_map()
        , m_resource(nullptr)
        , m_global(nullptr)
        , m_display(nullptr)
        , m_globalRemovedEvent(nullptr)
    {
    }

    security_session::~security_session()
    {
        for (auto resource : std::as_const(m_resource_map))
            resource->security_session_object = nullptr;

        if (m_resource)
            m_resource->security_session_object = nullptr;

        if (m_global) {
            if (m_globalRemovedEvent)
                wl_event_source_remove(m_globalRemovedEvent);
            wl_global_destroy(m_global);
            wl_list_remove(&m_displayDestroyedListener.link);
        }
    }

    void security_session::init(struct ::wl_client *client, int id, int version)
    {
        m_resource = bind(client, id, version);
    }

    void security_session::init(struct ::wl_resource *resource)
    {
        m_resource = bind(resource);
    }

    security_session::Resource *security_session::add(struct ::wl_client *client, int version)
    {
        Resource *resource = bind(client, 0, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    security_session::Resource *security_session::add(struct ::wl_client *client, int id, int version)
    {
        Resource *resource = bind(client, id, version);
        m_resource_map.insert(client, resource);
        return resource;
    }

    void security_session::init(struct ::wl_display *display, int version)
    {
        m_display = display;
        m_global = wl_global_create(display, &::security_session_interface, version, this, bind_func);
        m_displayDestroyedListener.notify = security_session::display_destroy_func;
        m_displayDestroyedListener.parent = this;
        wl_display_add_destroy_listener(display, &m_displayDestroyedListener);
    }

    const struct wl_interface *security_session::interface()
    {
        return &::security_session_interface;
    }

    security_session::Resource *security_session::security_session_allocate()
    {
        return new Resource;
    }

    void security_session::security_session_destroy_global()
    {
    }

    void security_session::security_session_bind_resource(Resource *)
    {
    }

    void security_session::security_session_destroy_resource(Resource *)
    {
    }

    void security_session::bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id)
    {
        security_session *that = static_cast<security_session *>(data);
        that->add(client, id, version);
    }

    void security_session::display_destroy_func(struct ::wl_listener *listener, void *data)
    {
        Q_UNUSED(data);
        security_session *that = static_cast<security_session::DisplayDestroyedListener *>(listener)->parent;
        that->m_global = nullptr;
        that->m_globalRemovedEvent = nullptr;
    }

    void security_session::destroy_func(struct ::wl_resource *client_resource)
    {
        Resource *resource = Resource::fromResource(client_resource);
        Q_ASSERT(resource);
        security_session *that = resource->security_session_object;
        if (Q_LIKELY(that)) {
            that->m_resource_map.remove(resource->client(), resource);
            that->security_session_destroy_resource(resource);

            that = resource->security_session_object;
            if (that && that->m_resource == resource)
                that->m_resource = nullptr;
        }
        delete resource;
    }


    void security_session::globalRemove()
    {
        if (!m_global || m_globalRemovedEvent)
            return;

        wl_global_remove(m_global);

        struct wl_event_loop *event_loop = wl_display_get_event_loop(m_display);
        m_globalRemovedEvent = wl_event_loop_add_timer(event_loop, deferred_destroy_global_func, this);
        wl_event_source_timer_update(m_globalRemovedEvent, 10000);
    }

    security_session::Resource *security_session::bind(struct ::wl_client *client, uint32_t id, int version)
    {
        Q_ASSERT_X(!wl_client_get_object(client, id), "QWaylandObject bind", QStringLiteral("binding to object %1 more than once").arg(id).toLocal8Bit().constData());
        struct ::wl_resource *handle = wl_resource_create(client, &::security_session_interface, version, id);
        return bind(handle);
    }

    security_session::Resource *security_session::bind(struct ::wl_resource *handle)
    {
        Resource *resource = security_session_allocate();
        resource->security_session_object = this;

        wl_resource_set_implementation(handle, &m_security_session_interface, resource, destroy_func);
        resource->handle = handle;
        security_session_bind_resource(resource);
        return resource;
    }
    security_session::Resource *security_session::Resource::fromResource(struct ::wl_resource *resource)
    {
        if (Q_UNLIKELY(!resource))
            return nullptr;
        if (wl_resource_instance_of(resource, &::security_session_interface, &m_security_session_interface))
            return static_cast<Resource *>(wl_resource_get_user_data(resource));
        return nullptr;
    }

    const struct ::security_session_interface security_session::m_security_session_interface = {
        security_session::handle_destroy,
        security_session::handle_report_security
    };

    void security_session::security_session_destroy(Resource *)
    {
    }

    void security_session::security_session_report_security(Resource *, uint32_t , uint32_t , uint32_t )
    {
    }


    void security_session::handle_destroy(
        ::wl_client *client,
        struct wl_resource *resource)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->security_session_object)) {
            wl_resource_destroy(resource);
            return;
        }
        static_cast<security_session *>(r->security_session_object)->security_session_destroy(
            r);
    }

    void security_session::handle_report_security(
        ::wl_client *client,
        struct wl_resource *resource,
        uint32_t types,
        uint32_t permission,
        uint32_t serial)
    {
        Q_UNUSED(client);
        Resource *r = Resource::fromResource(resource);
        if (Q_UNLIKELY(!r->security_session_object)) {
            return;
        }
        static_cast<security_session *>(r->security_session_object)->security_session_report_security(
            r,
            types,
            permission,
            serial);
    }

    void security_session::send_verify_security(uint32_t types, uint32_t client, uint32_t target, uint32_t serial)
    {
        Q_ASSERT_X(m_resource, "security_session::verify_security", "Uninitialised resource");
        if (Q_UNLIKELY(!m_resource)) {
            qWarning("could not call security_session::verify_security as it's not initialised");
            return;
        }
        send_verify_security(
            m_resource->handle,
            types,
            client,
            target,
            serial);
    }

    void security_session::send_verify_security(struct ::wl_resource *resource, uint32_t types, uint32_t client, uint32_t target, uint32_t serial)
    {
        security_session_send_verify_security(
            resource,
            types,
            client,
            target,
            serial);
    }

}

QT_WARNING_POP
QT_END_NAMESPACE
