/* modifications-handler.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from modifications-handler.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define MODEL_UTILS_dconf_context_id ((guint16) 2)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	BEHAVIOUR_UNSAFE,
	BEHAVIOUR_SAFE,
	BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT,
	BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT,
	BEHAVIOUR_ALWAYS_DELAY
} Behaviour;

#define TYPE_BEHAVIOUR (behaviour_get_type ())
typedef enum  {
	MODIFICATIONS_MODE_NONE,
	MODIFICATIONS_MODE_TEMPORARY,
	MODIFICATIONS_MODE_DELAYED
} ModificationsMode;

#define TYPE_MODIFICATIONS_MODE (modifications_mode_get_type ())

#define TYPE_MODIFICATIONS_HANDLER (modifications_handler_get_type ())
#define MODIFICATIONS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFICATIONS_HANDLER, ModificationsHandler))
#define MODIFICATIONS_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFICATIONS_HANDLER, ModificationsHandlerClass))
#define IS_MODIFICATIONS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFICATIONS_HANDLER))
#define IS_MODIFICATIONS_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFICATIONS_HANDLER))
#define MODIFICATIONS_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFICATIONS_HANDLER, ModificationsHandlerClass))

typedef struct _ModificationsHandler ModificationsHandler;
typedef struct _ModificationsHandlerClass ModificationsHandlerClass;
typedef struct _ModificationsHandlerPrivate ModificationsHandlerPrivate;

#define TYPE_SETTINGS_MODEL_CORE (settings_model_core_get_type ())
#define SETTINGS_MODEL_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL_CORE, SettingsModelCore))
#define SETTINGS_MODEL_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL_CORE, SettingsModelCoreClass))
#define IS_SETTINGS_MODEL_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL_CORE))
#define IS_SETTINGS_MODEL_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL_CORE))
#define SETTINGS_MODEL_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL_CORE, SettingsModelCoreClass))

typedef struct _SettingsModelCore SettingsModelCore;
typedef struct _SettingsModelCoreClass SettingsModelCoreClass;

#define TYPE_SETTINGS_MODEL (settings_model_get_type ())
#define SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL, SettingsModel))
#define SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL, SettingsModelClass))
#define IS_SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL))
#define IS_SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL))
#define SETTINGS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL, SettingsModelClass))

typedef struct _SettingsModel SettingsModel;
typedef struct _SettingsModelClass SettingsModelClass;
enum  {
	MODIFICATIONS_HANDLER_0_PROPERTY,
	MODIFICATIONS_HANDLER_MODE_PROPERTY,
	MODIFICATIONS_HANDLER_DCONF_CHANGES_COUNT_PROPERTY,
	MODIFICATIONS_HANDLER_GSETTINGS_CHANGES_COUNT_PROPERTY,
	MODIFICATIONS_HANDLER_MODEL_PROPERTY,
	MODIFICATIONS_HANDLER_BEHAVIOUR_PROPERTY,
	MODIFICATIONS_HANDLER_NUM_PROPERTIES
};
static GParamSpec* modifications_handler_properties[MODIFICATIONS_HANDLER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_REGISTRY_VARIANT_DICT (registry_variant_dict_get_type ())
#define REGISTRY_VARIANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDict))
#define REGISTRY_VARIANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDictClass))
#define IS_REGISTRY_VARIANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VARIANT_DICT))
#define IS_REGISTRY_VARIANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VARIANT_DICT))
#define REGISTRY_VARIANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDictClass))

typedef struct _RegistryVariantDict RegistryVariantDict;
typedef struct _RegistryVariantDictClass RegistryVariantDictClass;
typedef enum  {
	PROPERTY_QUERY_HASH = 1 << 0,
	PROPERTY_QUERY_HAS_SCHEMA = 1 << 1,
	PROPERTY_QUERY_KEY_NAME = 1 << 2,
	PROPERTY_QUERY_TYPE_CODE = 1 << 3,
	PROPERTY_QUERY_KEY_VALUE = 1 << 4,
	PROPERTY_QUERY_FIXED_SCHEMA = 1 << 5,
	PROPERTY_QUERY_SCHEMA_ID = 1 << 6,
	PROPERTY_QUERY_SUMMARY = 1 << 7,
	PROPERTY_QUERY_DESCRIPTION = 1 << 8,
	PROPERTY_QUERY_DEFAULT_VALUE = 1 << 9,
	PROPERTY_QUERY_RANGE_TYPE = 1 << 10,
	PROPERTY_QUERY_RANGE_CONTENT = 1 << 11,
	PROPERTY_QUERY_MAXIMUM = 1 << 12,
	PROPERTY_QUERY_MINIMUM = 1 << 13,
	PROPERTY_QUERY_KEY_CONFLICT = 1 << 14,
	PROPERTY_QUERY_IS_DEFAULT = 1 << 15
} PropertyQuery;

#define TYPE_PROPERTY_QUERY (property_query_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block18Data Block18Data;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;

#define TYPE_SIMPLE_SETTING_OBJECT (simple_setting_object_get_type ())
#define SIMPLE_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject))
#define SIMPLE_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObjectClass))
#define IS_SIMPLE_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SETTING_OBJECT))
#define IS_SIMPLE_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SETTING_OBJECT))
#define SIMPLE_SETTING_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObjectClass))

typedef struct _SimpleSettingObject SimpleSettingObject;
typedef struct _SimpleSettingObjectClass SimpleSettingObjectClass;
enum  {
	MODIFICATIONS_HANDLER_LEAVE_DELAY_MODE_SIGNAL,
	MODIFICATIONS_HANDLER_DELAYED_CHANGES_CHANGED_SIGNAL,
	MODIFICATIONS_HANDLER_NUM_SIGNALS
};
static guint modifications_handler_signals[MODIFICATIONS_HANDLER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ModificationsHandler {
	GObject parent_instance;
	ModificationsHandlerPrivate * priv;
};

struct _ModificationsHandlerClass {
	GObjectClass parent_class;
};

struct _ModificationsHandlerPrivate {
	ModificationsMode _mode;
	GHashTable* keys_awaiting_hashtable;
	GHashTable* dconf_changes_set;
	GHashTable* gsettings_changes_set;
	SettingsModel* _model;
	Behaviour _behaviour;
};

struct _Block18Data {
	int _ref_count_;
	ModificationsHandler* self;
	gboolean has_planned_changed;
	gchar* key_path;
};

struct _Block19Data {
	int _ref_count_;
	ModificationsHandler* self;
	GVariant* planned_changed;
	gchar* key_path;
};

struct _Block20Data {
	int _ref_count_;
	ModificationsHandler* self;
	GListStore* delayed_settings_list;
};

static gint ModificationsHandler_private_offset;
static gpointer modifications_handler_parent_class = NULL;

VALA_EXTERN GType behaviour_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType modifications_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType modifications_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ModificationsHandler, g_object_unref)
VALA_EXTERN GType settings_model_core_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsModelCore, g_object_unref)
VALA_EXTERN GType settings_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsModel, g_object_unref)
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
VALA_EXTERN ModificationsHandler* modifications_handler_new (SettingsModel* model);
VALA_EXTERN ModificationsHandler* modifications_handler_construct (GType object_type,
                                                       SettingsModel* model);
VALA_EXTERN gboolean modifications_handler_has_pending_changes (ModificationsHandler* self);
VALA_EXTERN guint modifications_handler_get_dconf_changes_count (ModificationsHandler* self);
VALA_EXTERN guint modifications_handler_get_gsettings_changes_count (ModificationsHandler* self);
VALA_EXTERN gboolean modifications_handler_get_current_delay_mode (ModificationsHandler* self);
VALA_EXTERN ModificationsMode modifications_handler_get_mode (ModificationsHandler* self);
VALA_EXTERN Behaviour modifications_handler_get_behaviour (ModificationsHandler* self);
VALA_EXTERN gboolean modifications_handler_should_delay_apply (ModificationsHandler* self,
                                                   const gchar* type_string);
VALA_EXTERN void modifications_handler_enter_delay_mode (ModificationsHandler* self);
static void modifications_handler_set_mode (ModificationsHandler* self,
                                     ModificationsMode value);
VALA_EXTERN void modifications_handler_add_delayed_setting (ModificationsHandler* self,
                                                const gchar* key_path,
                                                GVariant* new_value,
                                                guint16 context_id);
VALA_EXTERN gboolean model_utils_is_folder_context_id (guint16 context_id);
VALA_EXTERN gboolean model_utils_is_dconf_context_id (guint16 context_id);
VALA_EXTERN void modifications_handler_dismiss_change (ModificationsHandler* self,
                                           const gchar* key_path);
VALA_EXTERN void modifications_handler_path_changed (ModificationsHandler* self);
VALA_EXTERN void modifications_handler_apply_delayed_settings (ModificationsHandler* self);
VALA_EXTERN void modifications_handler_dismiss_delayed_settings (ModificationsHandler* self);
VALA_EXTERN SettingsModel* modifications_handler_get_model (ModificationsHandler* self);
VALA_EXTERN void settings_model_apply_key_value_changes (SettingsModel* self,
                                             GHashTable* changes);
VALA_EXTERN GVariant* modifications_handler_get_key_custom_value (ModificationsHandler* self,
                                                      const gchar* full_name,
                                                      guint16 context_id);
VALA_EXTERN gboolean modifications_handler_key_has_planned_change (ModificationsHandler* self,
                                                       const gchar* key_path);
VALA_EXTERN GVariant* modifications_handler_get_key_planned_value (ModificationsHandler* self,
                                                       const gchar* key_path);
VALA_EXTERN GType registry_variant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistryVariantDict, g_object_unref)
VALA_EXTERN GVariant* settings_model_get_key_properties (SettingsModel* self,
                                             const gchar* key_path,
                                             guint16 key_context_id,
                                             guint16 query);
VALA_EXTERN GType property_query_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RegistryVariantDict* registry_variant_dict_new_from_aqv (GVariant* variant);
VALA_EXTERN RegistryVariantDict* registry_variant_dict_construct_from_aqv (GType object_type,
                                                               GVariant* variant);
VALA_EXTERN gboolean registry_variant_dict_lookup (RegistryVariantDict* self,
                                       guint16 key,
                                       const gchar* format_string,
                                       ...);
VALA_EXTERN void registry_variant_dict_clear (RegistryVariantDict* self);
VALA_EXTERN void modifications_handler_set_dconf_key_value (ModificationsHandler* self,
                                                const gchar* full_name,
                                                GVariant* key_value);
VALA_EXTERN void settings_model_set_dconf_key_value (SettingsModel* self,
                                         const gchar* key_path,
                                         GVariant* key_value);
VALA_EXTERN void modifications_handler_set_gsettings_key_value (ModificationsHandler* self,
                                                    const gchar* full_name,
                                                    guint16 context_id,
                                                    GVariant* key_value);
VALA_EXTERN void settings_model_set_gsettings_key_value (SettingsModel* self,
                                             const gchar* key_path,
                                             guint16 gkey_context_id,
                                             GVariant* key_value);
VALA_EXTERN void modifications_handler_erase_dconf_key (ModificationsHandler* self,
                                            const gchar* full_name);
VALA_EXTERN void settings_model_erase_key (SettingsModel* self,
                               const gchar* key_path);
VALA_EXTERN void modifications_handler_set_to_default (ModificationsHandler* self,
                                           const gchar* full_name,
                                           guint16 context_id);
VALA_EXTERN void settings_model_set_key_to_default (SettingsModel* self,
                                        const gchar* key_path,
                                        guint16 gkey_context_id);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static void __lambda33_ (Block18Data* _data18_,
                  const gchar* key_awaiting,
                  GVariant* planned_value);
static void ___lambda33__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static void __lambda34_ (Block19Data* _data19_,
                  const gchar* key_awaiting,
                  GVariant* planned_value);
static void ___lambda34__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
VALA_EXTERN GListStore* modifications_handler_get_delayed_settings (ModificationsHandler* self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
VALA_EXTERN GType simple_setting_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SimpleSettingObject, g_object_unref)
static void __lambda37_ (Block20Data* _data20_,
                  const gchar* key_path,
                  GVariant* planned_value);
VALA_EXTERN SimpleSettingObject* simple_setting_object_new_from_full_name (guint16 _context_id,
                                                               const gchar* _name,
                                                               const gchar* _full_name,
                                                               gboolean _is_search,
                                                               gboolean _is_pinned);
VALA_EXTERN SimpleSettingObject* simple_setting_object_construct_from_full_name (GType object_type,
                                                                     guint16 _context_id,
                                                                     const gchar* _name,
                                                                     const gchar* _full_name,
                                                                     gboolean _is_search,
                                                                     gboolean _is_pinned);
static void ___lambda37__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void modifications_handler_set_model (ModificationsHandler* self,
                                      SettingsModel* value);
VALA_EXTERN void modifications_handler_set_behaviour (ModificationsHandler* self,
                                          Behaviour value);
static void modifications_handler_finalize (GObject * obj);
static GType modifications_handler_get_type_once (void);
static void _vala_modifications_handler_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_modifications_handler_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
behaviour_get_type_once (void)
{
	static const GEnumValue values[] = {{BEHAVIOUR_UNSAFE, "BEHAVIOUR_UNSAFE", "unsafe"}, {BEHAVIOUR_SAFE, "BEHAVIOUR_SAFE", "safe"}, {BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT, "BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT", "always-confirm-implicit"}, {BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT, "BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT", "always-confirm-explicit"}, {BEHAVIOUR_ALWAYS_DELAY, "BEHAVIOUR_ALWAYS_DELAY", "always-delay"}, {0, NULL, NULL}};
	GType behaviour_type_id;
	behaviour_type_id = g_enum_register_static ("Behaviour", values);
	return behaviour_type_id;
}

GType
behaviour_get_type (void)
{
	static volatile gsize behaviour_type_id__once = 0;
	if (g_once_init_enter (&behaviour_type_id__once)) {
		GType behaviour_type_id;
		behaviour_type_id = behaviour_get_type_once ();
		g_once_init_leave (&behaviour_type_id__once, behaviour_type_id);
	}
	return behaviour_type_id__once;
}

static GType
modifications_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{MODIFICATIONS_MODE_NONE, "MODIFICATIONS_MODE_NONE", "none"}, {MODIFICATIONS_MODE_TEMPORARY, "MODIFICATIONS_MODE_TEMPORARY", "temporary"}, {MODIFICATIONS_MODE_DELAYED, "MODIFICATIONS_MODE_DELAYED", "delayed"}, {0, NULL, NULL}};
	GType modifications_mode_type_id;
	modifications_mode_type_id = g_enum_register_static ("ModificationsMode", values);
	return modifications_mode_type_id;
}

GType
modifications_mode_get_type (void)
{
	static volatile gsize modifications_mode_type_id__once = 0;
	if (g_once_init_enter (&modifications_mode_type_id__once)) {
		GType modifications_mode_type_id;
		modifications_mode_type_id = modifications_mode_get_type_once ();
		g_once_init_leave (&modifications_mode_type_id__once, modifications_mode_type_id);
	}
	return modifications_mode_type_id__once;
}

static inline gpointer
modifications_handler_get_instance_private (ModificationsHandler* self)
{
	return G_STRUCT_MEMBER_P (self, ModificationsHandler_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

ModificationsHandler*
modifications_handler_construct (GType object_type,
                                 SettingsModel* model)
{
	ModificationsHandler * self = NULL;
	g_return_val_if_fail (model != NULL, NULL);
	self = (ModificationsHandler*) g_object_new (object_type, "model", model, NULL);
	return self;
}

ModificationsHandler*
modifications_handler_new (SettingsModel* model)
{
	return modifications_handler_construct (TYPE_MODIFICATIONS_HANDLER, model);
}

gboolean
modifications_handler_has_pending_changes (ModificationsHandler* self)
{
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = modifications_handler_get_dconf_changes_count (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = modifications_handler_get_gsettings_changes_count (self);
	_tmp3_ = _tmp2_;
	result = (_tmp1_ + _tmp3_) != ((guint) 0);
	return result;
}

gboolean
modifications_handler_get_current_delay_mode (ModificationsHandler* self)
{
	gboolean _tmp0_ = FALSE;
	ModificationsMode _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_mode;
	if (_tmp1_ == MODIFICATIONS_MODE_DELAYED) {
		_tmp0_ = TRUE;
	} else {
		Behaviour _tmp2_;
		_tmp2_ = self->priv->_behaviour;
		_tmp0_ = _tmp2_ == BEHAVIOUR_ALWAYS_DELAY;
	}
	result = _tmp0_;
	return result;
}

gboolean
modifications_handler_should_delay_apply (ModificationsHandler* self,
                                          const gchar* type_string)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Behaviour _tmp4_;
	Behaviour _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_string != NULL, FALSE);
	if (modifications_handler_get_current_delay_mode (self)) {
		_tmp1_ = TRUE;
	} else {
		Behaviour _tmp2_;
		_tmp2_ = self->priv->_behaviour;
		_tmp1_ = _tmp2_ == BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Behaviour _tmp3_;
		_tmp3_ = self->priv->_behaviour;
		_tmp0_ = _tmp3_ == BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = self->priv->_behaviour;
	if (_tmp4_ == BEHAVIOUR_UNSAFE) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->_behaviour;
	if (_tmp5_ == BEHAVIOUR_SAFE) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		if (g_strcmp0 (type_string, "b") != 0) {
			_tmp8_ = g_strcmp0 (type_string, "mb") != 0;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			_tmp7_ = g_strcmp0 (type_string, "<enum>") != 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			_tmp6_ = g_strcmp0 (type_string, "<flags>") != 0;
		} else {
			_tmp6_ = FALSE;
		}
		result = _tmp6_;
		return result;
	}
	g_assert_not_reached ();
}

void
modifications_handler_enter_delay_mode (ModificationsHandler* self)
{
	g_return_if_fail (self != NULL);
	modifications_handler_set_mode (self, MODIFICATIONS_MODE_DELAYED);
	g_signal_emit (self, modifications_handler_signals[MODIFICATIONS_HANDLER_DELAYED_CHANGES_CHANGED_SIGNAL], 0);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

void
modifications_handler_add_delayed_setting (ModificationsHandler* self,
                                           const gchar* key_path,
                                           GVariant* new_value,
                                           guint16 context_id)
{
	GHashTable* _tmp0_;
	ModificationsMode _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_path != NULL);
	_vala_return_if_fail (!model_utils_is_folder_context_id (context_id), "!ModelUtils.is_folder_context_id (context_id)");
	_tmp0_ = self->priv->keys_awaiting_hashtable;
	if (!g_hash_table_contains (_tmp0_, key_path)) {
		GHashTable* _tmp5_;
		gchar* _tmp6_;
		GVariant* _tmp7_;
		if (model_utils_is_dconf_context_id (context_id)) {
			GHashTable* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = self->priv->dconf_changes_set;
			_tmp2_ = g_strdup (key_path);
			g_hash_table_add (_tmp1_, _tmp2_);
		} else {
			GHashTable* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = self->priv->gsettings_changes_set;
			_tmp4_ = g_strdup (key_path);
			g_hash_table_insert (_tmp3_, _tmp4_, (gpointer) ((guintptr) context_id));
		}
		_tmp5_ = self->priv->keys_awaiting_hashtable;
		_tmp6_ = g_strdup (key_path);
		_tmp7_ = _g_variant_ref0 (new_value);
		g_hash_table_insert (_tmp5_, _tmp6_, _tmp7_);
	} else {
		GHashTable* _tmp8_;
		gchar* _tmp9_;
		GVariant* _tmp10_;
		_tmp8_ = self->priv->keys_awaiting_hashtable;
		_tmp9_ = g_strdup (key_path);
		_tmp10_ = _g_variant_ref0 (new_value);
		g_hash_table_replace (_tmp8_, _tmp9_, _tmp10_);
	}
	if (modifications_handler_get_current_delay_mode (self)) {
		_tmp11_ = MODIFICATIONS_MODE_DELAYED;
	} else {
		_tmp11_ = MODIFICATIONS_MODE_TEMPORARY;
	}
	modifications_handler_set_mode (self, _tmp11_);
	g_signal_emit (self, modifications_handler_signals[MODIFICATIONS_HANDLER_DELAYED_CHANGES_CHANGED_SIGNAL], 0);
}

void
modifications_handler_dismiss_change (ModificationsHandler* self,
                                      const gchar* key_path)
{
	ModificationsMode _tmp0_;
	GHashTable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key_path != NULL);
	_tmp0_ = self->priv->_mode;
	if (_tmp0_ == MODIFICATIONS_MODE_NONE) {
		ModificationsMode _tmp1_ = 0;
		Behaviour _tmp2_;
		_tmp2_ = self->priv->_behaviour;
		if (_tmp2_ == BEHAVIOUR_ALWAYS_DELAY) {
			_tmp1_ = MODIFICATIONS_MODE_DELAYED;
		} else {
			_tmp1_ = MODIFICATIONS_MODE_TEMPORARY;
		}
		modifications_handler_set_mode (self, _tmp1_);
	}
	_tmp3_ = self->priv->keys_awaiting_hashtable;
	if (g_hash_table_remove (_tmp3_, key_path)) {
		gboolean _tmp4_ = FALSE;
		GHashTable* _tmp5_;
		_tmp5_ = self->priv->gsettings_changes_set;
		if (!g_hash_table_remove (_tmp5_, key_path)) {
			GHashTable* _tmp6_;
			_tmp6_ = self->priv->dconf_changes_set;
			_tmp4_ = !g_hash_table_remove (_tmp6_, key_path);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			g_assert_not_reached ();
		}
	}
	g_signal_emit (self, modifications_handler_signals[MODIFICATIONS_HANDLER_DELAYED_CHANGES_CHANGED_SIGNAL], 0);
}

void
modifications_handler_path_changed (ModificationsHandler* self)
{
	ModificationsMode _tmp0_;
	gboolean _tmp1_ = FALSE;
	Behaviour _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mode;
	if (_tmp0_ != MODIFICATIONS_MODE_TEMPORARY) {
		return;
	}
	_tmp2_ = self->priv->_behaviour;
	if (_tmp2_ == BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT) {
		_tmp1_ = TRUE;
	} else {
		Behaviour _tmp3_;
		_tmp3_ = self->priv->_behaviour;
		_tmp1_ = _tmp3_ == BEHAVIOUR_SAFE;
	}
	if (_tmp1_) {
		modifications_handler_apply_delayed_settings (self);
	} else {
		Behaviour _tmp4_;
		_tmp4_ = self->priv->_behaviour;
		if (_tmp4_ == BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT) {
			modifications_handler_dismiss_delayed_settings (self);
		} else {
			g_assert_not_reached ();
		}
	}
}

void
modifications_handler_apply_delayed_settings (ModificationsHandler* self)
{
	SettingsModel* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	g_return_if_fail (self != NULL);
	modifications_handler_set_mode (self, MODIFICATIONS_MODE_NONE);
	_tmp0_ = self->priv->_model;
	_tmp1_ = self->priv->keys_awaiting_hashtable;
	settings_model_apply_key_value_changes (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->gsettings_changes_set;
	g_hash_table_remove_all (_tmp2_);
	_tmp3_ = self->priv->dconf_changes_set;
	g_hash_table_remove_all (_tmp3_);
	_tmp4_ = self->priv->keys_awaiting_hashtable;
	g_hash_table_remove_all (_tmp4_);
	g_signal_emit (self, modifications_handler_signals[MODIFICATIONS_HANDLER_DELAYED_CHANGES_CHANGED_SIGNAL], 0);
	g_signal_emit (self, modifications_handler_signals[MODIFICATIONS_HANDLER_LEAVE_DELAY_MODE_SIGNAL], 0);
}

void
modifications_handler_dismiss_delayed_settings (ModificationsHandler* self)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	g_return_if_fail (self != NULL);
	modifications_handler_set_mode (self, MODIFICATIONS_MODE_NONE);
	_tmp0_ = self->priv->gsettings_changes_set;
	g_hash_table_remove_all (_tmp0_);
	_tmp1_ = self->priv->dconf_changes_set;
	g_hash_table_remove_all (_tmp1_);
	_tmp2_ = self->priv->keys_awaiting_hashtable;
	g_hash_table_remove_all (_tmp2_);
	g_signal_emit (self, modifications_handler_signals[MODIFICATIONS_HANDLER_DELAYED_CHANGES_CHANGED_SIGNAL], 0);
	g_signal_emit (self, modifications_handler_signals[MODIFICATIONS_HANDLER_LEAVE_DELAY_MODE_SIGNAL], 0);
}

GVariant*
modifications_handler_get_key_custom_value (ModificationsHandler* self,
                                            const gchar* full_name,
                                            guint16 context_id)
{
	gboolean planned_change = FALSE;
	GVariant* planned_value = NULL;
	GVariant* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RegistryVariantDict* properties = NULL;
	SettingsModel* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	RegistryVariantDict* _tmp8_;
	RegistryVariantDict* _tmp9_;
	GVariant* key_value = NULL;
	RegistryVariantDict* _tmp10_;
	GVariant* _tmp11_ = NULL;
	gboolean _tmp12_;
	RegistryVariantDict* _tmp13_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (full_name != NULL, NULL);
	planned_change = modifications_handler_key_has_planned_change (self, full_name);
	_tmp0_ = modifications_handler_get_key_planned_value (self, full_name);
	planned_value = _tmp0_;
	if (planned_change) {
		GVariant* _tmp2_;
		_tmp2_ = planned_value;
		_tmp1_ = _tmp2_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GVariant* _tmp3_;
		GVariant* _tmp4_;
		_tmp3_ = planned_value;
		_tmp4_ = _g_variant_ref0 ((GVariant*) _tmp3_);
		result = _tmp4_;
		_g_variant_unref0 (planned_value);
		return result;
	}
	_tmp5_ = self->priv->_model;
	_tmp6_ = settings_model_get_key_properties (_tmp5_, full_name, context_id, (guint16) PROPERTY_QUERY_KEY_VALUE);
	_tmp7_ = _tmp6_;
	_tmp8_ = registry_variant_dict_new_from_aqv (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp7_);
	properties = _tmp9_;
	_tmp10_ = properties;
	_tmp12_ = registry_variant_dict_lookup (_tmp10_, (guint16) PROPERTY_QUERY_KEY_VALUE, "v", &_tmp11_, NULL);
	_g_variant_unref0 (key_value);
	key_value = _tmp11_;
	if (!_tmp12_) {
		g_assert_not_reached ();
	}
	_tmp13_ = properties;
	registry_variant_dict_clear (_tmp13_);
	result = key_value;
	_g_object_unref0 (properties);
	_g_variant_unref0 (planned_value);
	return result;
}

void
modifications_handler_set_dconf_key_value (ModificationsHandler* self,
                                           const gchar* full_name,
                                           GVariant* key_value)
{
	SettingsModel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	g_return_if_fail (key_value != NULL);
	_tmp0_ = self->priv->_model;
	settings_model_set_dconf_key_value (_tmp0_, full_name, key_value);
}

void
modifications_handler_set_gsettings_key_value (ModificationsHandler* self,
                                               const gchar* full_name,
                                               guint16 context_id,
                                               GVariant* key_value)
{
	SettingsModel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	g_return_if_fail (key_value != NULL);
	_tmp0_ = self->priv->_model;
	settings_model_set_gsettings_key_value (_tmp0_, full_name, context_id, key_value);
}

void
modifications_handler_erase_dconf_key (ModificationsHandler* self,
                                       const gchar* full_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	if (modifications_handler_get_current_delay_mode (self)) {
		modifications_handler_add_delayed_setting (self, full_name, NULL, MODEL_UTILS_dconf_context_id);
	} else {
		Behaviour _tmp0_;
		_tmp0_ = self->priv->_behaviour;
		if (_tmp0_ != BEHAVIOUR_UNSAFE) {
			modifications_handler_set_mode (self, MODIFICATIONS_MODE_DELAYED);
			modifications_handler_add_delayed_setting (self, full_name, NULL, MODEL_UTILS_dconf_context_id);
		} else {
			SettingsModel* _tmp1_;
			_tmp1_ = self->priv->_model;
			settings_model_erase_key (_tmp1_, full_name);
		}
	}
}

void
modifications_handler_set_to_default (ModificationsHandler* self,
                                      const gchar* full_name,
                                      guint16 context_id)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	_vala_return_if_fail (!model_utils_is_folder_context_id (context_id), "!ModelUtils.is_folder_context_id (context_id)");
	_vala_return_if_fail (!model_utils_is_dconf_context_id (context_id), "!ModelUtils.is_dconf_context_id (context_id)");
	if (modifications_handler_get_current_delay_mode (self)) {
		modifications_handler_add_delayed_setting (self, full_name, NULL, context_id);
	} else {
		SettingsModel* _tmp0_;
		_tmp0_ = self->priv->_model;
		settings_model_set_key_to_default (_tmp0_, full_name, context_id);
	}
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		ModificationsHandler* self;
		self = _data18_->self;
		_g_free0 (_data18_->key_path);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
__lambda33_ (Block18Data* _data18_,
             const gchar* key_awaiting,
             GVariant* planned_value)
{
	ModificationsHandler* self;
	self = _data18_->self;
	g_return_if_fail (key_awaiting != NULL);
	if (g_strcmp0 (_data18_->key_path, key_awaiting) == 0) {
		_data18_->has_planned_changed = TRUE;
	}
}

static void
___lambda33__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda33_ (self, (const gchar*) key, (GVariant*) value);
}

gboolean
modifications_handler_key_has_planned_change (ModificationsHandler* self,
                                              const gchar* key_path)
{
	Block18Data* _data18_;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key_path != NULL, FALSE);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_tmp0_ = g_strdup (key_path);
	_g_free0 (_data18_->key_path);
	_data18_->key_path = _tmp0_;
	_tmp1_ = self->priv->keys_awaiting_hashtable;
	if (g_hash_table_contains (_tmp1_, _data18_->key_path)) {
		result = TRUE;
		block18_data_unref (_data18_);
		_data18_ = NULL;
		return result;
	}
	_data18_->has_planned_changed = FALSE;
	_tmp2_ = self->priv->keys_awaiting_hashtable;
	g_hash_table_foreach (_tmp2_, ___lambda33__gh_func, _data18_);
	result = _data18_->has_planned_changed;
	block18_data_unref (_data18_);
	_data18_ = NULL;
	return result;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		ModificationsHandler* self;
		self = _data19_->self;
		_g_variant_unref0 (_data19_->planned_changed);
		_g_free0 (_data19_->key_path);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static void
__lambda34_ (Block19Data* _data19_,
             const gchar* key_awaiting,
             GVariant* planned_value)
{
	ModificationsHandler* self;
	self = _data19_->self;
	g_return_if_fail (key_awaiting != NULL);
	if (g_strcmp0 (_data19_->key_path, key_awaiting) == 0) {
		GVariant* _tmp0_;
		_tmp0_ = _g_variant_ref0 (planned_value);
		_g_variant_unref0 (_data19_->planned_changed);
		_data19_->planned_changed = _tmp0_;
	}
}

static void
___lambda34__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda34_ (self, (const gchar*) key, (GVariant*) value);
}

GVariant*
modifications_handler_get_key_planned_value (ModificationsHandler* self,
                                             const gchar* key_path)
{
	Block19Data* _data19_;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key_path != NULL, NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	_tmp0_ = g_strdup (key_path);
	_g_free0 (_data19_->key_path);
	_data19_->key_path = _tmp0_;
	_tmp1_ = self->priv->keys_awaiting_hashtable;
	if (g_hash_table_contains (_tmp1_, _data19_->key_path)) {
		GHashTable* _tmp2_;
		gconstpointer _tmp3_;
		GVariant* _tmp4_;
		_tmp2_ = self->priv->keys_awaiting_hashtable;
		_tmp3_ = g_hash_table_lookup (_tmp2_, _data19_->key_path);
		_tmp4_ = _g_variant_ref0 ((GVariant*) _tmp3_);
		result = _tmp4_;
		block19_data_unref (_data19_);
		_data19_ = NULL;
		return result;
	}
	_data19_->planned_changed = NULL;
	_tmp5_ = self->priv->keys_awaiting_hashtable;
	g_hash_table_foreach (_tmp5_, ___lambda34__gh_func, _data19_);
	_tmp6_ = _data19_->planned_changed;
	_tmp7_ = _g_variant_ref0 (_tmp6_);
	result = _tmp7_;
	block19_data_unref (_data19_);
	_data19_ = NULL;
	return result;
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		ModificationsHandler* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->delayed_settings_list);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
__lambda37_ (Block20Data* _data20_,
             const gchar* key_path,
             GVariant* planned_value)
{
	ModificationsHandler* self;
	GHashTable* _tmp0_;
	self = _data20_->self;
	g_return_if_fail (key_path != NULL);
	_tmp0_ = self->priv->dconf_changes_set;
	if (g_hash_table_contains (_tmp0_, key_path)) {
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		SimpleSettingObject* _tmp5_;
		SimpleSettingObject* _tmp6_;
		_tmp1_ = strlen (key_path);
		_tmp2_ = _tmp1_;
		_tmp3_ = string_slice (key_path, (glong) (string_last_index_of_char (key_path, (gunichar) '/', 0) + 1), (glong) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = simple_setting_object_new_from_full_name (MODEL_UTILS_dconf_context_id, _tmp4_, key_path, FALSE, FALSE);
		_tmp6_ = _tmp5_;
		g_list_store_append (_data20_->delayed_settings_list, (GObject*) _tmp6_);
		_g_object_unref0 (_tmp6_);
		_g_free0 (_tmp4_);
	} else {
		GHashTable* _tmp7_;
		_tmp7_ = self->priv->gsettings_changes_set;
		if (g_hash_table_contains (_tmp7_, key_path)) {
			GHashTable* _tmp8_;
			gconstpointer _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			SimpleSettingObject* _tmp14_;
			SimpleSettingObject* _tmp15_;
			_tmp8_ = self->priv->gsettings_changes_set;
			_tmp9_ = g_hash_table_lookup (_tmp8_, key_path);
			_tmp10_ = strlen (key_path);
			_tmp11_ = _tmp10_;
			_tmp12_ = string_slice (key_path, (glong) (string_last_index_of_char (key_path, (gunichar) '/', 0) + 1), (glong) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = simple_setting_object_new_from_full_name ((guint16) ((guintptr) _tmp9_), _tmp13_, key_path, FALSE, FALSE);
			_tmp15_ = _tmp14_;
			g_list_store_append (_data20_->delayed_settings_list, (GObject*) _tmp15_);
			_g_object_unref0 (_tmp15_);
			_g_free0 (_tmp13_);
		} else {
			g_assert_not_reached ();
		}
	}
}

static void
___lambda37__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda37_ (self, (const gchar*) key, (GVariant*) value);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GListStore*
modifications_handler_get_delayed_settings (ModificationsHandler* self)
{
	Block20Data* _data20_;
	GListStore* _tmp0_;
	GHashTable* _tmp1_;
	GListStore* _tmp2_;
	GListStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	_tmp0_ = g_list_store_new (TYPE_SIMPLE_SETTING_OBJECT);
	_data20_->delayed_settings_list = _tmp0_;
	_tmp1_ = self->priv->keys_awaiting_hashtable;
	g_hash_table_foreach (_tmp1_, ___lambda37__gh_func, _data20_);
	_tmp2_ = _g_object_ref0 (_data20_->delayed_settings_list);
	result = _tmp2_;
	block20_data_unref (_data20_);
	_data20_ = NULL;
	return result;
}

ModificationsMode
modifications_handler_get_mode (ModificationsHandler* self)
{
	ModificationsMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

static void
modifications_handler_set_mode (ModificationsHandler* self,
                                ModificationsMode value)
{
	g_return_if_fail (self != NULL);
	self->priv->_mode = value;
}

guint
modifications_handler_get_dconf_changes_count (ModificationsHandler* self)
{
	guint result;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->dconf_changes_set;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

guint
modifications_handler_get_gsettings_changes_count (ModificationsHandler* self)
{
	guint result;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->gsettings_changes_set;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

SettingsModel*
modifications_handler_get_model (ModificationsHandler* self)
{
	SettingsModel* result;
	SettingsModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

static void
modifications_handler_set_model (ModificationsHandler* self,
                                 SettingsModel* value)
{
	SettingsModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = modifications_handler_get_model (self);
	if (old_value != value) {
		SettingsModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_model);
		self->priv->_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, modifications_handler_properties[MODIFICATIONS_HANDLER_MODEL_PROPERTY]);
	}
}

Behaviour
modifications_handler_get_behaviour (ModificationsHandler* self)
{
	Behaviour result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_behaviour;
	return result;
}

void
modifications_handler_set_behaviour (ModificationsHandler* self,
                                     Behaviour value)
{
	g_return_if_fail (self != NULL);
	self->priv->_behaviour = value;
}

static void
modifications_handler_class_init (ModificationsHandlerClass * klass,
                                  gpointer klass_data)
{
	modifications_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ModificationsHandler_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_modifications_handler_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_modifications_handler_set_property;
	G_OBJECT_CLASS (klass)->finalize = modifications_handler_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MODIFICATIONS_HANDLER_MODE_PROPERTY, modifications_handler_properties[MODIFICATIONS_HANDLER_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", TYPE_MODIFICATIONS_MODE, MODIFICATIONS_MODE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MODIFICATIONS_HANDLER_DCONF_CHANGES_COUNT_PROPERTY, modifications_handler_properties[MODIFICATIONS_HANDLER_DCONF_CHANGES_COUNT_PROPERTY] = g_param_spec_uint ("dconf-changes-count", "dconf-changes-count", "dconf-changes-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MODIFICATIONS_HANDLER_GSETTINGS_CHANGES_COUNT_PROPERTY, modifications_handler_properties[MODIFICATIONS_HANDLER_GSETTINGS_CHANGES_COUNT_PROPERTY] = g_param_spec_uint ("gsettings-changes-count", "gsettings-changes-count", "gsettings-changes-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MODIFICATIONS_HANDLER_MODEL_PROPERTY, modifications_handler_properties[MODIFICATIONS_HANDLER_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", TYPE_SETTINGS_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MODIFICATIONS_HANDLER_BEHAVIOUR_PROPERTY, modifications_handler_properties[MODIFICATIONS_HANDLER_BEHAVIOUR_PROPERTY] = g_param_spec_enum ("behaviour", "behaviour", "behaviour", TYPE_BEHAVIOUR, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	modifications_handler_signals[MODIFICATIONS_HANDLER_LEAVE_DELAY_MODE_SIGNAL] = g_signal_new ("leave-delay-mode", TYPE_MODIFICATIONS_HANDLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	modifications_handler_signals[MODIFICATIONS_HANDLER_DELAYED_CHANGES_CHANGED_SIGNAL] = g_signal_new ("delayed-changes-changed", TYPE_MODIFICATIONS_HANDLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
modifications_handler_instance_init (ModificationsHandler * self,
                                     gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashFunc _tmp6_;
	GEqualFunc _tmp7_;
	GHashTable* _tmp8_;
	self->priv = modifications_handler_get_instance_private (self);
	self->priv->_mode = MODIFICATIONS_MODE_NONE;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_variant_unref0_);
	self->priv->keys_awaiting_hashtable = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, _g_free0_);
	self->priv->dconf_changes_set = _tmp5_;
	_tmp6_ = g_str_hash;
	_tmp7_ = g_str_equal;
	_tmp8_ = g_hash_table_new_full (_tmp6_, _tmp7_, _g_free0_, NULL);
	self->priv->gsettings_changes_set = _tmp8_;
}

static void
modifications_handler_finalize (GObject * obj)
{
	ModificationsHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MODIFICATIONS_HANDLER, ModificationsHandler);
	_g_hash_table_unref0 (self->priv->keys_awaiting_hashtable);
	_g_hash_table_unref0 (self->priv->dconf_changes_set);
	_g_hash_table_unref0 (self->priv->gsettings_changes_set);
	_g_object_unref0 (self->priv->_model);
	G_OBJECT_CLASS (modifications_handler_parent_class)->finalize (obj);
}

static GType
modifications_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ModificationsHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) modifications_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ModificationsHandler), 0, (GInstanceInitFunc) modifications_handler_instance_init, NULL };
	GType modifications_handler_type_id;
	modifications_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "ModificationsHandler", &g_define_type_info, 0);
	ModificationsHandler_private_offset = g_type_add_instance_private (modifications_handler_type_id, sizeof (ModificationsHandlerPrivate));
	return modifications_handler_type_id;
}

GType
modifications_handler_get_type (void)
{
	static volatile gsize modifications_handler_type_id__once = 0;
	if (g_once_init_enter (&modifications_handler_type_id__once)) {
		GType modifications_handler_type_id;
		modifications_handler_type_id = modifications_handler_get_type_once ();
		g_once_init_leave (&modifications_handler_type_id__once, modifications_handler_type_id);
	}
	return modifications_handler_type_id__once;
}

static void
_vala_modifications_handler_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ModificationsHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MODIFICATIONS_HANDLER, ModificationsHandler);
	switch (property_id) {
		case MODIFICATIONS_HANDLER_MODE_PROPERTY:
		g_value_set_enum (value, modifications_handler_get_mode (self));
		break;
		case MODIFICATIONS_HANDLER_DCONF_CHANGES_COUNT_PROPERTY:
		g_value_set_uint (value, modifications_handler_get_dconf_changes_count (self));
		break;
		case MODIFICATIONS_HANDLER_GSETTINGS_CHANGES_COUNT_PROPERTY:
		g_value_set_uint (value, modifications_handler_get_gsettings_changes_count (self));
		break;
		case MODIFICATIONS_HANDLER_MODEL_PROPERTY:
		g_value_set_object (value, modifications_handler_get_model (self));
		break;
		case MODIFICATIONS_HANDLER_BEHAVIOUR_PROPERTY:
		g_value_set_enum (value, modifications_handler_get_behaviour (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_modifications_handler_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ModificationsHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MODIFICATIONS_HANDLER, ModificationsHandler);
	switch (property_id) {
		case MODIFICATIONS_HANDLER_MODE_PROPERTY:
		modifications_handler_set_mode (self, g_value_get_enum (value));
		break;
		case MODIFICATIONS_HANDLER_MODEL_PROPERTY:
		modifications_handler_set_model (self, g_value_get_object (value));
		break;
		case MODIFICATIONS_HANDLER_BEHAVIOUR_PROPERTY:
		modifications_handler_set_behaviour (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

