/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> const options::minisatDumpDimacs__option_t::type& Options::operator[](
    options::minisatDumpDimacs__option_t) const
{
  return d_holder->minisatDumpDimacs;
}
template <> bool Options::wasSetByUser(options::minisatDumpDimacs__option_t) const
{
  return d_holder->minisatDumpDimacs__setByUser__;
}
template <> void Options::set(
    options::minisatUseElim__option_t,
    const options::minisatUseElim__option_t::type& x)
{
  d_holder->minisatUseElim = x;
}
template <> const options::minisatUseElim__option_t::type& Options::operator[](
    options::minisatUseElim__option_t) const
{
  return d_holder->minisatUseElim;
}
template <> bool Options::wasSetByUser(options::minisatUseElim__option_t) const
{
  return d_holder->minisatUseElim__setByUser__;
}
template <> const options::satRandomFreq__option_t::type& Options::operator[](
    options::satRandomFreq__option_t) const
{
  return d_holder->satRandomFreq;
}
template <> bool Options::wasSetByUser(options::satRandomFreq__option_t) const
{
  return d_holder->satRandomFreq__setByUser__;
}
template <> void Options::set(
    options::satRandomSeed__option_t,
    const options::satRandomSeed__option_t::type& x)
{
  d_holder->satRandomSeed = x;
}
template <> const options::satRandomSeed__option_t::type& Options::operator[](
    options::satRandomSeed__option_t) const
{
  return d_holder->satRandomSeed;
}
template <> bool Options::wasSetByUser(options::satRandomSeed__option_t) const
{
  return d_holder->satRandomSeed__setByUser__;
}
template <> const options::sat_refine_conflicts__option_t::type& Options::operator[](
    options::sat_refine_conflicts__option_t) const
{
  return d_holder->sat_refine_conflicts;
}
template <> bool Options::wasSetByUser(options::sat_refine_conflicts__option_t) const
{
  return d_holder->sat_refine_conflicts__setByUser__;
}
template <> const options::satRestartFirst__option_t::type& Options::operator[](
    options::satRestartFirst__option_t) const
{
  return d_holder->satRestartFirst;
}
template <> bool Options::wasSetByUser(options::satRestartFirst__option_t) const
{
  return d_holder->satRestartFirst__setByUser__;
}
template <> const options::satRestartInc__option_t::type& Options::operator[](
    options::satRestartInc__option_t) const
{
  return d_holder->satRestartInc;
}
template <> bool Options::wasSetByUser(options::satRestartInc__option_t) const
{
  return d_holder->satRestartInc__setByUser__;
}
template <> void Options::set(
    options::satClauseDecay__option_t,
    const options::satClauseDecay__option_t::type& x)
{
  d_holder->satClauseDecay = x;
}
template <> const options::satClauseDecay__option_t::type& Options::operator[](
    options::satClauseDecay__option_t) const
{
  return d_holder->satClauseDecay;
}
template <> bool Options::wasSetByUser(options::satClauseDecay__option_t) const
{
  return d_holder->satClauseDecay__setByUser__;
}
template <> void Options::set(
    options::satVarDecay__option_t,
    const options::satVarDecay__option_t::type& x)
{
  d_holder->satVarDecay = x;
}
template <> const options::satVarDecay__option_t::type& Options::operator[](
    options::satVarDecay__option_t) const
{
  return d_holder->satVarDecay;
}
template <> bool Options::wasSetByUser(options::satVarDecay__option_t) const
{
  return d_holder->satVarDecay__setByUser__;
}


namespace options {

struct minisatDumpDimacs__option_t minisatDumpDimacs;
struct minisatUseElim__option_t minisatUseElim;
struct satRandomFreq__option_t satRandomFreq;
struct satRandomSeed__option_t satRandomSeed;
struct sat_refine_conflicts__option_t sat_refine_conflicts;
struct satRestartFirst__option_t satRestartFirst;
struct satRestartInc__option_t satRestartInc;
struct satClauseDecay__option_t satClauseDecay;
struct satVarDecay__option_t satVarDecay;



}  // namespace options
}  // namespace CVC4
