/*********************                                                        */
/** metakind.h
 **
 ** Copyright 2010-2014  New York University and The University of Iowa,
 ** and as below.
 **
 ** This header file automatically generated by:
 **
 **     /build/cvc4/src/cvc5-1.8/src/expr/mkmetakind /build/cvc4/src/cvc5-1.8/src/expr/metakind_template.h /build/cvc4/src/cvc5-1.8/src/theory/builtin/kinds /build/cvc4/src/cvc5-1.8/src/theory/booleans/kinds /build/cvc4/src/cvc5-1.8/src/theory/uf/kinds /build/cvc4/src/cvc5-1.8/src/theory/arith/kinds /build/cvc4/src/cvc5-1.8/src/theory/bv/kinds /build/cvc4/src/cvc5-1.8/src/theory/fp/kinds /build/cvc4/src/cvc5-1.8/src/theory/arrays/kinds /build/cvc4/src/cvc5-1.8/src/theory/datatypes/kinds /build/cvc4/src/cvc5-1.8/src/theory/sep/kinds /build/cvc4/src/cvc5-1.8/src/theory/sets/kinds /build/cvc4/src/cvc5-1.8/src/theory/strings/kinds /build/cvc4/src/cvc5-1.8/src/theory/quantifiers/kinds
 **
 ** for the CVC4 project.
 **/

/*********************                                                        */
/*! \file metakind_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Andres Noetzli, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Template for the metakind header.
 **
 ** Template for the metakind header.
 **/

#include "cvc4_private.h"

#ifndef CVC4__KIND__METAKIND_H
#define CVC4__KIND__METAKIND_H

#include <iosfwd>

#include "base/check.h"
#include "expr/kind.h"

namespace CVC4 {

namespace expr {
  class NodeValue;
}/* CVC4::expr namespace */

namespace kind {
namespace metakind {

/**
 * Static, compile-time information about types T representing CVC4
 * constants:
 *
 *   typename ConstantMap<T>::OwningTheory
 *
 *     The theory in charge of constructing T when constructing Nodes
 *     with NodeManager::mkConst(T).
 *
 *   typename ConstantMap<T>::kind
 *
 *     The kind to use when constructing Nodes with
 *     NodeManager::mkConst(T).
 */
template <class T>
struct ConstantMap;

/**
 * Static, compile-time information about kinds k and what type their
 * corresponding CVC4 constants are:
 *
 *   typename ConstantMapReverse<k>::T
 *
 *     Constant type for kind k.
 */
template <Kind k>
struct ConstantMapReverse;

/**
 * Static, compile-time mapping from CONSTANT kinds to comparison
 * functors on NodeValue*.  The single element of this structure is:
 *
 *   static bool NodeValueCompare<K, pool>::compare(NodeValue* x, NodeValue* y)
 *
 *     Compares x and y, given that they are both K-kinded (and the
 *     meta-kind of K is CONSTANT).  If pool == true, one of x and y
 *     (but not both) may be a "non-inlined" NodeValue.  If pool ==
 *     false, neither x nor y may be a "non-inlined" NodeValue.
 */
template <Kind k, bool pool>
struct NodeValueConstCompare {
  inline static bool compare(const ::CVC4::expr::NodeValue* x,
                             const ::CVC4::expr::NodeValue* y);
  inline static size_t constHash(const ::CVC4::expr::NodeValue* nv);
};/* NodeValueConstCompare<k, pool> */

struct NodeValueCompare {
  template <bool pool>
  static bool compare(const ::CVC4::expr::NodeValue* nv1,
                      const ::CVC4::expr::NodeValue* nv2);
  static size_t constHash(const ::CVC4::expr::NodeValue* nv);
};/* struct NodeValueCompare */

/**
 * "metakinds" represent the "kinds" of kinds at the meta-level.
 * "metakind" is an ugly name but it's not used by client code, just
 * by the expr package, and the intent here is to keep it from
 * polluting the kind namespace.  For more documentation on what these
 * mean, see src/theory/builtin/kinds.
 */
enum MetaKind_t {
  INVALID = -1, /**< special node non-kinds like NULL_EXPR or LAST_KIND */
  VARIABLE, /**< special node kinds: no operator */
  OPERATOR, /**< operators that get "inlined" */
  PARAMETERIZED, /**< parameterized ops (like APPLYs) that carry extra data */
  CONSTANT, /**< constants */
  NULLARY_OPERATOR /**< nullary operator */
};/* enum MetaKind_t */

}/* CVC4::kind::metakind namespace */

// import MetaKind into the "CVC4::kind" namespace but keep the
// individual MetaKind constants under kind::metakind::
typedef ::CVC4::kind::metakind::MetaKind_t MetaKind;

/**
 * Get the metakind for a particular kind.
 */
MetaKind metaKindOf(Kind k);
}/* CVC4::kind namespace */

namespace expr {

// Comparison predicate
struct NodeValuePoolEq {
  inline bool operator()(const NodeValue* nv1, const NodeValue* nv2) const {
    return ::CVC4::kind::metakind::NodeValueCompare::compare<true>(nv1, nv2);
  }
};

}/* CVC4::expr namespace */
}/* CVC4 namespace */

#include "expr/node_value.h"

#endif /* CVC4__KIND__METAKIND_H */


// #include "theory/builtin/::CVC4::theory::builtin::TheoryBuiltin"
#include "expr/uninterpreted_constant.h"
#include "util/abstract_value.h"
#include "expr/kind.h"
// #include "theory/booleans/::CVC4::theory::booleans::TheoryBool"
#include "util/bool.h"
// #include "theory/uf/::CVC4::theory::uf::TheoryUF"
// #include "theory/arith/::CVC4::theory::arith::TheoryArith"
#include "util/divisible.h"
#include "util/rational.h"
// #include "theory/bv/::CVC4::theory::bv::TheoryBV"
#include "util/bitvector.h"
// #include "theory/fp/::CVC4::theory::fp::TheoryFp"
#include "util/floatingpoint.h"
// #include "theory/arrays/::CVC4::theory::arrays::TheoryArrays"
#include "expr/array_store_all.h"
// #include "theory/datatypes/::CVC4::theory::datatypes::TheoryDatatypes"
#include "expr/datatype.h"
#include "expr/ascription_type.h"
#include "util/tuple.h"
#include "expr/record.h"
// #include "theory/sep/::CVC4::theory::sep::TheorySep"
// #include "theory/sets/::CVC4::theory::sets::TheorySets"
#include "expr/emptyset.h"
// #include "theory/strings/::CVC4::theory::strings::TheoryStrings"
#include "util/string.h"
#include "expr/expr_sequence.h"
#include "util/regexp.h"
// #include "theory/quantifiers/::CVC4::theory::quantifiers::TheoryQuantifiers"

#ifdef CVC4__NODE_MANAGER_NEEDS_CONSTANT_MAP

namespace CVC4 {

namespace expr {

template <>
::CVC4::UninterpretedConstant const& NodeValue::getConst< ::CVC4::UninterpretedConstant >() const;

template <>
::CVC4::AbstractValue const& NodeValue::getConst< ::CVC4::AbstractValue >() const;

template <>
::CVC4::Kind const& NodeValue::getConst< ::CVC4::Kind >() const;

template <>
::CVC4::TypeConstant const& NodeValue::getConst< ::CVC4::TypeConstant >() const;

template <>
bool const& NodeValue::getConst< bool >() const;

template <>
::CVC4::Divisible const& NodeValue::getConst< ::CVC4::Divisible >() const;

template <>
::CVC4::Rational const& NodeValue::getConst< ::CVC4::Rational >() const;

template <>
::CVC4::BitVectorSize const& NodeValue::getConst< ::CVC4::BitVectorSize >() const;

template <>
::CVC4::BitVector const& NodeValue::getConst< ::CVC4::BitVector >() const;

template <>
::CVC4::BitVectorBitOf const& NodeValue::getConst< ::CVC4::BitVectorBitOf >() const;

template <>
::CVC4::BitVectorExtract const& NodeValue::getConst< ::CVC4::BitVectorExtract >() const;

template <>
::CVC4::BitVectorRepeat const& NodeValue::getConst< ::CVC4::BitVectorRepeat >() const;

template <>
::CVC4::BitVectorRotateLeft const& NodeValue::getConst< ::CVC4::BitVectorRotateLeft >() const;

template <>
::CVC4::BitVectorRotateRight const& NodeValue::getConst< ::CVC4::BitVectorRotateRight >() const;

template <>
::CVC4::BitVectorSignExtend const& NodeValue::getConst< ::CVC4::BitVectorSignExtend >() const;

template <>
::CVC4::BitVectorZeroExtend const& NodeValue::getConst< ::CVC4::BitVectorZeroExtend >() const;

template <>
::CVC4::IntToBitVector const& NodeValue::getConst< ::CVC4::IntToBitVector >() const;

template <>
::CVC4::FloatingPoint const& NodeValue::getConst< ::CVC4::FloatingPoint >() const;

template <>
::CVC4::RoundingMode const& NodeValue::getConst< ::CVC4::RoundingMode >() const;

template <>
::CVC4::FloatingPointSize const& NodeValue::getConst< ::CVC4::FloatingPointSize >() const;

template <>
::CVC4::FloatingPointToFPIEEEBitVector const& NodeValue::getConst< ::CVC4::FloatingPointToFPIEEEBitVector >() const;

template <>
::CVC4::FloatingPointToFPFloatingPoint const& NodeValue::getConst< ::CVC4::FloatingPointToFPFloatingPoint >() const;

template <>
::CVC4::FloatingPointToFPReal const& NodeValue::getConst< ::CVC4::FloatingPointToFPReal >() const;

template <>
::CVC4::FloatingPointToFPSignedBitVector const& NodeValue::getConst< ::CVC4::FloatingPointToFPSignedBitVector >() const;

template <>
::CVC4::FloatingPointToFPUnsignedBitVector const& NodeValue::getConst< ::CVC4::FloatingPointToFPUnsignedBitVector >() const;

template <>
::CVC4::FloatingPointToFPGeneric const& NodeValue::getConst< ::CVC4::FloatingPointToFPGeneric >() const;

template <>
::CVC4::FloatingPointToUBV const& NodeValue::getConst< ::CVC4::FloatingPointToUBV >() const;

template <>
::CVC4::FloatingPointToUBVTotal const& NodeValue::getConst< ::CVC4::FloatingPointToUBVTotal >() const;

template <>
::CVC4::FloatingPointToSBV const& NodeValue::getConst< ::CVC4::FloatingPointToSBV >() const;

template <>
::CVC4::FloatingPointToSBVTotal const& NodeValue::getConst< ::CVC4::FloatingPointToSBVTotal >() const;

template <>
::CVC4::ArrayStoreAll const& NodeValue::getConst< ::CVC4::ArrayStoreAll >() const;

template <>
::CVC4::DatatypeIndexConstant const& NodeValue::getConst< ::CVC4::DatatypeIndexConstant >() const;

template <>
::CVC4::AscriptionType const& NodeValue::getConst< ::CVC4::AscriptionType >() const;

template <>
::CVC4::TupleUpdate const& NodeValue::getConst< ::CVC4::TupleUpdate >() const;

template <>
::CVC4::RecordUpdate const& NodeValue::getConst< ::CVC4::RecordUpdate >() const;

template <>
::CVC4::EmptySet const& NodeValue::getConst< ::CVC4::EmptySet >() const;

template <>
::CVC4::String const& NodeValue::getConst< ::CVC4::String >() const;

template <>
::CVC4::ExprSequence const& NodeValue::getConst< ::CVC4::ExprSequence >() const;

template <>
::CVC4::RegExpRepeat const& NodeValue::getConst< ::CVC4::RegExpRepeat >() const;

template <>
::CVC4::RegExpLoop const& NodeValue::getConst< ::CVC4::RegExpLoop >() const;

}/* CVC4::expr namespace */

namespace kind {
namespace metakind {

template <Kind k, bool pool>
inline bool NodeValueConstCompare<k, pool>::compare(const ::CVC4::expr::NodeValue* x,
                                                    const ::CVC4::expr::NodeValue* y) {
  typedef typename ConstantMapReverse<k>::T T;
  if(pool) {
    if(x->d_nchildren == 1) {
      Assert(y->d_nchildren == 0);
      return compare(y, x);
    } else if(y->d_nchildren == 1) {
      Assert(x->d_nchildren == 0);
      return x->getConst<T>() == *reinterpret_cast<T*>(y->d_children[0]);
    }
  }

  Assert(x->d_nchildren == 0);
  Assert(y->d_nchildren == 0);
  return x->getConst<T>() == y->getConst<T>();
}

template <Kind k, bool pool>
inline size_t NodeValueConstCompare<k, pool>::constHash(const ::CVC4::expr::NodeValue* nv) {
  typedef typename ConstantMapReverse<k>::T T;
  return nv->getConst<T>().hash();
}


template <>
struct ConstantMap< ::CVC4::UninterpretedConstant > {
  // typedef THEORY_BUILTIN OwningTheory;
  enum { kind = ::CVC4::kind::UNINTERPRETED_CONSTANT };
};/* ConstantMap< ::CVC4::UninterpretedConstant > */

template <>
struct ConstantMapReverse< ::CVC4::kind::UNINTERPRETED_CONSTANT > {
  typedef ::CVC4::UninterpretedConstant T;
};/* ConstantMapReverse< ::CVC4::kind::UNINTERPRETED_CONSTANT > */
  
template <>
struct ConstantMap< ::CVC4::AbstractValue > {
  // typedef THEORY_BUILTIN OwningTheory;
  enum { kind = ::CVC4::kind::ABSTRACT_VALUE };
};/* ConstantMap< ::CVC4::AbstractValue > */

template <>
struct ConstantMapReverse< ::CVC4::kind::ABSTRACT_VALUE > {
  typedef ::CVC4::AbstractValue T;
};/* ConstantMapReverse< ::CVC4::kind::ABSTRACT_VALUE > */
  
template <>
struct ConstantMap< ::CVC4::Kind > {
  // typedef THEORY_BUILTIN OwningTheory;
  enum { kind = ::CVC4::kind::BUILTIN };
};/* ConstantMap< ::CVC4::Kind > */

template <>
struct ConstantMapReverse< ::CVC4::kind::BUILTIN > {
  typedef ::CVC4::Kind T;
};/* ConstantMapReverse< ::CVC4::kind::BUILTIN > */
  
template <>
struct ConstantMap< ::CVC4::TypeConstant > {
  // typedef THEORY_BUILTIN OwningTheory;
  enum { kind = ::CVC4::kind::TYPE_CONSTANT };
};/* ConstantMap< ::CVC4::TypeConstant > */

template <>
struct ConstantMapReverse< ::CVC4::kind::TYPE_CONSTANT > {
  typedef ::CVC4::TypeConstant T;
};/* ConstantMapReverse< ::CVC4::kind::TYPE_CONSTANT > */
  
template <>
struct ConstantMap< bool > {
  // typedef THEORY_BOOL OwningTheory;
  enum { kind = ::CVC4::kind::CONST_BOOLEAN };
};/* ConstantMap< bool > */

template <>
struct ConstantMapReverse< ::CVC4::kind::CONST_BOOLEAN > {
  typedef bool T;
};/* ConstantMapReverse< ::CVC4::kind::CONST_BOOLEAN > */
  
template <>
struct ConstantMap< ::CVC4::Divisible > {
  // typedef THEORY_ARITH OwningTheory;
  enum { kind = ::CVC4::kind::DIVISIBLE_OP };
};/* ConstantMap< ::CVC4::Divisible > */

template <>
struct ConstantMapReverse< ::CVC4::kind::DIVISIBLE_OP > {
  typedef ::CVC4::Divisible T;
};/* ConstantMapReverse< ::CVC4::kind::DIVISIBLE_OP > */
  
template <>
struct ConstantMap< ::CVC4::Rational > {
  // typedef THEORY_ARITH OwningTheory;
  enum { kind = ::CVC4::kind::CONST_RATIONAL };
};/* ConstantMap< ::CVC4::Rational > */

template <>
struct ConstantMapReverse< ::CVC4::kind::CONST_RATIONAL > {
  typedef ::CVC4::Rational T;
};/* ConstantMapReverse< ::CVC4::kind::CONST_RATIONAL > */
  
template <>
struct ConstantMap< ::CVC4::BitVectorSize > {
  // typedef THEORY_BV OwningTheory;
  enum { kind = ::CVC4::kind::BITVECTOR_TYPE };
};/* ConstantMap< ::CVC4::BitVectorSize > */

template <>
struct ConstantMapReverse< ::CVC4::kind::BITVECTOR_TYPE > {
  typedef ::CVC4::BitVectorSize T;
};/* ConstantMapReverse< ::CVC4::kind::BITVECTOR_TYPE > */
  
template <>
struct ConstantMap< ::CVC4::BitVector > {
  // typedef THEORY_BV OwningTheory;
  enum { kind = ::CVC4::kind::CONST_BITVECTOR };
};/* ConstantMap< ::CVC4::BitVector > */

template <>
struct ConstantMapReverse< ::CVC4::kind::CONST_BITVECTOR > {
  typedef ::CVC4::BitVector T;
};/* ConstantMapReverse< ::CVC4::kind::CONST_BITVECTOR > */
  
template <>
struct ConstantMap< ::CVC4::BitVectorBitOf > {
  // typedef THEORY_BV OwningTheory;
  enum { kind = ::CVC4::kind::BITVECTOR_BITOF_OP };
};/* ConstantMap< ::CVC4::BitVectorBitOf > */

template <>
struct ConstantMapReverse< ::CVC4::kind::BITVECTOR_BITOF_OP > {
  typedef ::CVC4::BitVectorBitOf T;
};/* ConstantMapReverse< ::CVC4::kind::BITVECTOR_BITOF_OP > */
  
template <>
struct ConstantMap< ::CVC4::BitVectorExtract > {
  // typedef THEORY_BV OwningTheory;
  enum { kind = ::CVC4::kind::BITVECTOR_EXTRACT_OP };
};/* ConstantMap< ::CVC4::BitVectorExtract > */

template <>
struct ConstantMapReverse< ::CVC4::kind::BITVECTOR_EXTRACT_OP > {
  typedef ::CVC4::BitVectorExtract T;
};/* ConstantMapReverse< ::CVC4::kind::BITVECTOR_EXTRACT_OP > */
  
template <>
struct ConstantMap< ::CVC4::BitVectorRepeat > {
  // typedef THEORY_BV OwningTheory;
  enum { kind = ::CVC4::kind::BITVECTOR_REPEAT_OP };
};/* ConstantMap< ::CVC4::BitVectorRepeat > */

template <>
struct ConstantMapReverse< ::CVC4::kind::BITVECTOR_REPEAT_OP > {
  typedef ::CVC4::BitVectorRepeat T;
};/* ConstantMapReverse< ::CVC4::kind::BITVECTOR_REPEAT_OP > */
  
template <>
struct ConstantMap< ::CVC4::BitVectorRotateLeft > {
  // typedef THEORY_BV OwningTheory;
  enum { kind = ::CVC4::kind::BITVECTOR_ROTATE_LEFT_OP };
};/* ConstantMap< ::CVC4::BitVectorRotateLeft > */

template <>
struct ConstantMapReverse< ::CVC4::kind::BITVECTOR_ROTATE_LEFT_OP > {
  typedef ::CVC4::BitVectorRotateLeft T;
};/* ConstantMapReverse< ::CVC4::kind::BITVECTOR_ROTATE_LEFT_OP > */
  
template <>
struct ConstantMap< ::CVC4::BitVectorRotateRight > {
  // typedef THEORY_BV OwningTheory;
  enum { kind = ::CVC4::kind::BITVECTOR_ROTATE_RIGHT_OP };
};/* ConstantMap< ::CVC4::BitVectorRotateRight > */

template <>
struct ConstantMapReverse< ::CVC4::kind::BITVECTOR_ROTATE_RIGHT_OP > {
  typedef ::CVC4::BitVectorRotateRight T;
};/* ConstantMapReverse< ::CVC4::kind::BITVECTOR_ROTATE_RIGHT_OP > */
  
template <>
struct ConstantMap< ::CVC4::BitVectorSignExtend > {
  // typedef THEORY_BV OwningTheory;
  enum { kind = ::CVC4::kind::BITVECTOR_SIGN_EXTEND_OP };
};/* ConstantMap< ::CVC4::BitVectorSignExtend > */

template <>
struct ConstantMapReverse< ::CVC4::kind::BITVECTOR_SIGN_EXTEND_OP > {
  typedef ::CVC4::BitVectorSignExtend T;
};/* ConstantMapReverse< ::CVC4::kind::BITVECTOR_SIGN_EXTEND_OP > */
  
template <>
struct ConstantMap< ::CVC4::BitVectorZeroExtend > {
  // typedef THEORY_BV OwningTheory;
  enum { kind = ::CVC4::kind::BITVECTOR_ZERO_EXTEND_OP };
};/* ConstantMap< ::CVC4::BitVectorZeroExtend > */

template <>
struct ConstantMapReverse< ::CVC4::kind::BITVECTOR_ZERO_EXTEND_OP > {
  typedef ::CVC4::BitVectorZeroExtend T;
};/* ConstantMapReverse< ::CVC4::kind::BITVECTOR_ZERO_EXTEND_OP > */
  
template <>
struct ConstantMap< ::CVC4::IntToBitVector > {
  // typedef THEORY_BV OwningTheory;
  enum { kind = ::CVC4::kind::INT_TO_BITVECTOR_OP };
};/* ConstantMap< ::CVC4::IntToBitVector > */

template <>
struct ConstantMapReverse< ::CVC4::kind::INT_TO_BITVECTOR_OP > {
  typedef ::CVC4::IntToBitVector T;
};/* ConstantMapReverse< ::CVC4::kind::INT_TO_BITVECTOR_OP > */
  
template <>
struct ConstantMap< ::CVC4::FloatingPoint > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::CONST_FLOATINGPOINT };
};/* ConstantMap< ::CVC4::FloatingPoint > */

template <>
struct ConstantMapReverse< ::CVC4::kind::CONST_FLOATINGPOINT > {
  typedef ::CVC4::FloatingPoint T;
};/* ConstantMapReverse< ::CVC4::kind::CONST_FLOATINGPOINT > */
  
template <>
struct ConstantMap< ::CVC4::RoundingMode > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::CONST_ROUNDINGMODE };
};/* ConstantMap< ::CVC4::RoundingMode > */

template <>
struct ConstantMapReverse< ::CVC4::kind::CONST_ROUNDINGMODE > {
  typedef ::CVC4::RoundingMode T;
};/* ConstantMapReverse< ::CVC4::kind::CONST_ROUNDINGMODE > */
  
template <>
struct ConstantMap< ::CVC4::FloatingPointSize > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::FLOATINGPOINT_TYPE };
};/* ConstantMap< ::CVC4::FloatingPointSize > */

template <>
struct ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TYPE > {
  typedef ::CVC4::FloatingPointSize T;
};/* ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TYPE > */
  
template <>
struct ConstantMap< ::CVC4::FloatingPointToFPIEEEBitVector > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP };
};/* ConstantMap< ::CVC4::FloatingPointToFPIEEEBitVector > */

template <>
struct ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP > {
  typedef ::CVC4::FloatingPointToFPIEEEBitVector T;
};/* ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_FP_IEEE_BITVECTOR_OP > */
  
template <>
struct ConstantMap< ::CVC4::FloatingPointToFPFloatingPoint > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP };
};/* ConstantMap< ::CVC4::FloatingPointToFPFloatingPoint > */

template <>
struct ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP > {
  typedef ::CVC4::FloatingPointToFPFloatingPoint T;
};/* ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_FP_FLOATINGPOINT_OP > */
  
template <>
struct ConstantMap< ::CVC4::FloatingPointToFPReal > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::FLOATINGPOINT_TO_FP_REAL_OP };
};/* ConstantMap< ::CVC4::FloatingPointToFPReal > */

template <>
struct ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_FP_REAL_OP > {
  typedef ::CVC4::FloatingPointToFPReal T;
};/* ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_FP_REAL_OP > */
  
template <>
struct ConstantMap< ::CVC4::FloatingPointToFPSignedBitVector > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP };
};/* ConstantMap< ::CVC4::FloatingPointToFPSignedBitVector > */

template <>
struct ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP > {
  typedef ::CVC4::FloatingPointToFPSignedBitVector T;
};/* ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_FP_SIGNED_BITVECTOR_OP > */
  
template <>
struct ConstantMap< ::CVC4::FloatingPointToFPUnsignedBitVector > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP };
};/* ConstantMap< ::CVC4::FloatingPointToFPUnsignedBitVector > */

template <>
struct ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP > {
  typedef ::CVC4::FloatingPointToFPUnsignedBitVector T;
};/* ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_FP_UNSIGNED_BITVECTOR_OP > */
  
template <>
struct ConstantMap< ::CVC4::FloatingPointToFPGeneric > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::FLOATINGPOINT_TO_FP_GENERIC_OP };
};/* ConstantMap< ::CVC4::FloatingPointToFPGeneric > */

template <>
struct ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_FP_GENERIC_OP > {
  typedef ::CVC4::FloatingPointToFPGeneric T;
};/* ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_FP_GENERIC_OP > */
  
template <>
struct ConstantMap< ::CVC4::FloatingPointToUBV > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::FLOATINGPOINT_TO_UBV_OP };
};/* ConstantMap< ::CVC4::FloatingPointToUBV > */

template <>
struct ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_UBV_OP > {
  typedef ::CVC4::FloatingPointToUBV T;
};/* ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_UBV_OP > */
  
template <>
struct ConstantMap< ::CVC4::FloatingPointToUBVTotal > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::FLOATINGPOINT_TO_UBV_TOTAL_OP };
};/* ConstantMap< ::CVC4::FloatingPointToUBVTotal > */

template <>
struct ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_UBV_TOTAL_OP > {
  typedef ::CVC4::FloatingPointToUBVTotal T;
};/* ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_UBV_TOTAL_OP > */
  
template <>
struct ConstantMap< ::CVC4::FloatingPointToSBV > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::FLOATINGPOINT_TO_SBV_OP };
};/* ConstantMap< ::CVC4::FloatingPointToSBV > */

template <>
struct ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_SBV_OP > {
  typedef ::CVC4::FloatingPointToSBV T;
};/* ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_SBV_OP > */
  
template <>
struct ConstantMap< ::CVC4::FloatingPointToSBVTotal > {
  // typedef THEORY_FP OwningTheory;
  enum { kind = ::CVC4::kind::FLOATINGPOINT_TO_SBV_TOTAL_OP };
};/* ConstantMap< ::CVC4::FloatingPointToSBVTotal > */

template <>
struct ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_SBV_TOTAL_OP > {
  typedef ::CVC4::FloatingPointToSBVTotal T;
};/* ConstantMapReverse< ::CVC4::kind::FLOATINGPOINT_TO_SBV_TOTAL_OP > */
  
template <>
struct ConstantMap< ::CVC4::ArrayStoreAll > {
  // typedef THEORY_ARRAYS OwningTheory;
  enum { kind = ::CVC4::kind::STORE_ALL };
};/* ConstantMap< ::CVC4::ArrayStoreAll > */

template <>
struct ConstantMapReverse< ::CVC4::kind::STORE_ALL > {
  typedef ::CVC4::ArrayStoreAll T;
};/* ConstantMapReverse< ::CVC4::kind::STORE_ALL > */
  
template <>
struct ConstantMap< ::CVC4::DatatypeIndexConstant > {
  // typedef THEORY_DATATYPES OwningTheory;
  enum { kind = ::CVC4::kind::DATATYPE_TYPE };
};/* ConstantMap< ::CVC4::DatatypeIndexConstant > */

template <>
struct ConstantMapReverse< ::CVC4::kind::DATATYPE_TYPE > {
  typedef ::CVC4::DatatypeIndexConstant T;
};/* ConstantMapReverse< ::CVC4::kind::DATATYPE_TYPE > */
  
template <>
struct ConstantMap< ::CVC4::AscriptionType > {
  // typedef THEORY_DATATYPES OwningTheory;
  enum { kind = ::CVC4::kind::ASCRIPTION_TYPE };
};/* ConstantMap< ::CVC4::AscriptionType > */

template <>
struct ConstantMapReverse< ::CVC4::kind::ASCRIPTION_TYPE > {
  typedef ::CVC4::AscriptionType T;
};/* ConstantMapReverse< ::CVC4::kind::ASCRIPTION_TYPE > */
  
template <>
struct ConstantMap< ::CVC4::TupleUpdate > {
  // typedef THEORY_DATATYPES OwningTheory;
  enum { kind = ::CVC4::kind::TUPLE_UPDATE_OP };
};/* ConstantMap< ::CVC4::TupleUpdate > */

template <>
struct ConstantMapReverse< ::CVC4::kind::TUPLE_UPDATE_OP > {
  typedef ::CVC4::TupleUpdate T;
};/* ConstantMapReverse< ::CVC4::kind::TUPLE_UPDATE_OP > */
  
template <>
struct ConstantMap< ::CVC4::RecordUpdate > {
  // typedef THEORY_DATATYPES OwningTheory;
  enum { kind = ::CVC4::kind::RECORD_UPDATE_OP };
};/* ConstantMap< ::CVC4::RecordUpdate > */

template <>
struct ConstantMapReverse< ::CVC4::kind::RECORD_UPDATE_OP > {
  typedef ::CVC4::RecordUpdate T;
};/* ConstantMapReverse< ::CVC4::kind::RECORD_UPDATE_OP > */
  
template <>
struct ConstantMap< ::CVC4::EmptySet > {
  // typedef THEORY_SETS OwningTheory;
  enum { kind = ::CVC4::kind::EMPTYSET };
};/* ConstantMap< ::CVC4::EmptySet > */

template <>
struct ConstantMapReverse< ::CVC4::kind::EMPTYSET > {
  typedef ::CVC4::EmptySet T;
};/* ConstantMapReverse< ::CVC4::kind::EMPTYSET > */
  
template <>
struct ConstantMap< ::CVC4::String > {
  // typedef THEORY_STRINGS OwningTheory;
  enum { kind = ::CVC4::kind::CONST_STRING };
};/* ConstantMap< ::CVC4::String > */

template <>
struct ConstantMapReverse< ::CVC4::kind::CONST_STRING > {
  typedef ::CVC4::String T;
};/* ConstantMapReverse< ::CVC4::kind::CONST_STRING > */
  
template <>
struct ConstantMap< ::CVC4::ExprSequence > {
  // typedef THEORY_STRINGS OwningTheory;
  enum { kind = ::CVC4::kind::CONST_SEQUENCE };
};/* ConstantMap< ::CVC4::ExprSequence > */

template <>
struct ConstantMapReverse< ::CVC4::kind::CONST_SEQUENCE > {
  typedef ::CVC4::ExprSequence T;
};/* ConstantMapReverse< ::CVC4::kind::CONST_SEQUENCE > */
  
template <>
struct ConstantMap< ::CVC4::RegExpRepeat > {
  // typedef THEORY_STRINGS OwningTheory;
  enum { kind = ::CVC4::kind::REGEXP_REPEAT_OP };
};/* ConstantMap< ::CVC4::RegExpRepeat > */

template <>
struct ConstantMapReverse< ::CVC4::kind::REGEXP_REPEAT_OP > {
  typedef ::CVC4::RegExpRepeat T;
};/* ConstantMapReverse< ::CVC4::kind::REGEXP_REPEAT_OP > */
  
template <>
struct ConstantMap< ::CVC4::RegExpLoop > {
  // typedef THEORY_STRINGS OwningTheory;
  enum { kind = ::CVC4::kind::REGEXP_LOOP_OP };
};/* ConstantMap< ::CVC4::RegExpLoop > */

template <>
struct ConstantMapReverse< ::CVC4::kind::REGEXP_LOOP_OP > {
  typedef ::CVC4::RegExpLoop T;
};/* ConstantMapReverse< ::CVC4::kind::REGEXP_LOOP_OP > */
  

struct NodeValueConstPrinter {
  static void toStream(std::ostream& out,
                              const ::CVC4::expr::NodeValue* nv);
  static void toStream(std::ostream& out, TNode n);
};

/**
 * Cleanup to be performed when a NodeValue zombie is collected, and
 * it has CONSTANT metakind.  This calls the destructor for the underlying
 * C++ type representing the constant value.  See
 * NodeManager::reclaimZombies() for more information.
 *
 * This doesn't support "non-inlined" NodeValues, which shouldn't need this
 * kind of cleanup.
 */
void deleteNodeValueConstant(::CVC4::expr::NodeValue* nv);

unsigned getLowerBoundForKind(::CVC4::Kind k);
unsigned getUpperBoundForKind(::CVC4::Kind k);

}/* CVC4::kind::metakind namespace */

/**
 * Map a kind of the operator to the kind of the enclosing expression. For
 * example, since the kind of functions is just VARIABLE, it should map
 * VARIABLE to APPLY_UF.
 */
Kind operatorToKind(::CVC4::expr::NodeValue* nv);

}/* CVC4::kind namespace */

#line 205 "/build/cvc4/src/cvc5-1.8/src/expr/metakind_template.h"

}/* CVC4 namespace */

#endif /* CVC4__NODE_MANAGER_NEEDS_CONSTANT_MAP */
