/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	certificatesv1 "k8s.io/api/certificates/v1"
)

// CertificateSigningRequestSpecApplyConfiguration represents a declarative configuration of the CertificateSigningRequestSpec type for use
// with apply.
//
// CertificateSigningRequestSpec contains the certificate request.
type CertificateSigningRequestSpecApplyConfiguration struct {
	// request contains an x509 certificate signing request encoded in a "CERTIFICATE REQUEST" PEM block.
	// When serialized as JSON or YAML, the data is additionally base64-encoded.
	Request []byte `json:"request,omitempty"`
	// signerName indicates the requested signer, and is a qualified name.
	//
	// List/watch requests for CertificateSigningRequests can filter on this field using a "spec.signerName=NAME" fieldSelector.
	//
	// Well-known Kubernetes signers are:
	// 1. "kubernetes.io/kube-apiserver-client": issues client certificates that can be used to authenticate to kube-apiserver.
	// Requests for this signer are never auto-approved by kube-controller-manager, can be issued by the "csrsigning" controller in kube-controller-manager.
	// 2. "kubernetes.io/kube-apiserver-client-kubelet": issues client certificates that kubelets use to authenticate to kube-apiserver.
	// Requests for this signer can be auto-approved by the "csrapproving" controller in kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager.
	// 3. "kubernetes.io/kubelet-serving" issues serving certificates that kubelets use to serve TLS endpoints, which kube-apiserver can connect to securely.
	// Requests for this signer are never auto-approved by kube-controller-manager, and can be issued by the "csrsigning" controller in kube-controller-manager.
	//
	// More details are available at https://k8s.io/docs/reference/access-authn-authz/certificate-signing-requests/#kubernetes-signers
	//
	// Custom signerNames can also be specified. The signer defines:
	// 1. Trust distribution: how trust (CA bundles) are distributed.
	// 2. Permitted subjects: and behavior when a disallowed subject is requested.
	// 3. Required, permitted, or forbidden x509 extensions in the request (including whether subjectAltNames are allowed, which types, restrictions on allowed values) and behavior when a disallowed extension is requested.
	// 4. Required, permitted, or forbidden key usages / extended key usages.
	// 5. Expiration/certificate lifetime: whether it is fixed by the signer, configurable by the admin.
	// 6. Whether or not requests for CA certificates are allowed.
	SignerName *string `json:"signerName,omitempty"`
	// expirationSeconds is the requested duration of validity of the issued
	// certificate. The certificate signer may issue a certificate with a different
	// validity duration so a client must check the delta between the notBefore and
	// and notAfter fields in the issued certificate to determine the actual duration.
	//
	// The v1.22+ in-tree implementations of the well-known Kubernetes signers will
	// honor this field as long as the requested duration is not greater than the
	// maximum duration they will honor per the --cluster-signing-duration CLI
	// flag to the Kubernetes controller manager.
	//
	// Certificate signers may not honor this field for various reasons:
	//
	// 1. Old signer that is unaware of the field (such as the in-tree
	// implementations prior to v1.22)
	// 2. Signer whose configured maximum is shorter than the requested duration
	// 3. Signer whose configured minimum is longer than the requested duration
	//
	// The minimum valid value for expirationSeconds is 600, i.e. 10 minutes.
	ExpirationSeconds *int32 `json:"expirationSeconds,omitempty"`
	// usages specifies a set of key usages requested in the issued certificate.
	//
	// Requests for TLS client certificates typically request: "digital signature", "key encipherment", "client auth".
	//
	// Requests for TLS serving certificates typically request: "key encipherment", "digital signature", "server auth".
	//
	// Valid values are:
	// "signing", "digital signature", "content commitment",
	// "key encipherment", "key agreement", "data encipherment",
	// "cert sign", "crl sign", "encipher only", "decipher only", "any",
	// "server auth", "client auth",
	// "code signing", "email protection", "s/mime",
	// "ipsec end system", "ipsec tunnel", "ipsec user",
	// "timestamping", "ocsp signing", "microsoft sgc", "netscape sgc"
	Usages []certificatesv1.KeyUsage `json:"usages,omitempty"`
	// username contains the name of the user that created the CertificateSigningRequest.
	// Populated by the API server on creation and immutable.
	Username *string `json:"username,omitempty"`
	// uid contains the uid of the user that created the CertificateSigningRequest.
	// Populated by the API server on creation and immutable.
	UID *string `json:"uid,omitempty"`
	// groups contains group membership of the user that created the CertificateSigningRequest.
	// Populated by the API server on creation and immutable.
	Groups []string `json:"groups,omitempty"`
	// extra contains extra attributes of the user that created the CertificateSigningRequest.
	// Populated by the API server on creation and immutable.
	Extra map[string]certificatesv1.ExtraValue `json:"extra,omitempty"`
}

// CertificateSigningRequestSpecApplyConfiguration constructs a declarative configuration of the CertificateSigningRequestSpec type for use with
// apply.
func CertificateSigningRequestSpec() *CertificateSigningRequestSpecApplyConfiguration {
	return &CertificateSigningRequestSpecApplyConfiguration{}
}

// WithRequest adds the given value to the Request field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Request field.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithRequest(values ...byte) *CertificateSigningRequestSpecApplyConfiguration {
	for i := range values {
		b.Request = append(b.Request, values[i])
	}
	return b
}

// WithSignerName sets the SignerName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SignerName field is set to the value of the last call.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithSignerName(value string) *CertificateSigningRequestSpecApplyConfiguration {
	b.SignerName = &value
	return b
}

// WithExpirationSeconds sets the ExpirationSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ExpirationSeconds field is set to the value of the last call.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithExpirationSeconds(value int32) *CertificateSigningRequestSpecApplyConfiguration {
	b.ExpirationSeconds = &value
	return b
}

// WithUsages adds the given value to the Usages field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Usages field.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithUsages(values ...certificatesv1.KeyUsage) *CertificateSigningRequestSpecApplyConfiguration {
	for i := range values {
		b.Usages = append(b.Usages, values[i])
	}
	return b
}

// WithUsername sets the Username field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Username field is set to the value of the last call.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithUsername(value string) *CertificateSigningRequestSpecApplyConfiguration {
	b.Username = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithUID(value string) *CertificateSigningRequestSpecApplyConfiguration {
	b.UID = &value
	return b
}

// WithGroups adds the given value to the Groups field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Groups field.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithGroups(values ...string) *CertificateSigningRequestSpecApplyConfiguration {
	for i := range values {
		b.Groups = append(b.Groups, values[i])
	}
	return b
}

// WithExtra puts the entries into the Extra field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Extra field,
// overwriting an existing map entries in Extra field with the same key.
func (b *CertificateSigningRequestSpecApplyConfiguration) WithExtra(entries map[string]certificatesv1.ExtraValue) *CertificateSigningRequestSpecApplyConfiguration {
	if b.Extra == nil && len(entries) > 0 {
		b.Extra = make(map[string]certificatesv1.ExtraValue, len(entries))
	}
	for k, v := range entries {
		b.Extra[k] = v
	}
	return b
}
