/* Generated from library.scm by the CHICKEN compiler
   http://www.call-cc.org
   Version 5.4.0rc1 (prerelease) (rev bc191a47)
   linux-unix-gnu-x86-64 [ 64bit dload ptables ]
   command line: library.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -consult-types-file ./types.db -explicit-use -no-trace -output-file library.c -no-module-registration -emit-import-library chicken.bitwise -emit-import-library chicken.blob -emit-import-library chicken.fixnum -emit-import-library chicken.flonum -emit-import-library chicken.gc -emit-import-library chicken.keyword -emit-import-library chicken.platform -emit-import-library chicken.plist -emit-import-library chicken.process-context
   unit: library
   uses: build-version library
*/
#include "chicken.h"

#include <errno.h>
#include <float.h>

#ifdef HAVE_SYSEXITS_H
# include <sysexits.h>
#endif

#ifndef EX_SOFTWARE
# define EX_SOFTWARE	70
#endif

#define C_close_file(p)	      (C_fclose((C_FILEPTR)(C_port_file(p))), C_SCHEME_UNDEFINED)
#define C_a_f64peek(ptr, c, b, i)  C_flonum(ptr, ((double *)C_data_pointer(b))[ C_unfix(i) ])
#define C_fetch_c_strlen(b, i) C_fix(strlen((C_char *)C_block_item(b, C_unfix(i))))
#define C_asciiz_strlen(str) C_fix(strlen(C_c_string(str)))
#define C_peek_c_string(b, i, to, len) (C_memcpy(C_data_pointer(to), (C_char *)C_block_item(b, C_unfix(i)), C_unfix(len)), C_SCHEME_UNDEFINED)
#define C_free_mptr(p, i)     (C_free((void *)C_block_item(p, C_unfix(i))), C_SCHEME_UNDEFINED)
#define C_free_sptr(p, i)     (C_free((void *)(((C_char **)C_block_item(p, 0))[ C_unfix(i) ])), C_SCHEME_UNDEFINED)

#define C_a_get_current_seconds(ptr, c, dummy)  C_int64_to_num(ptr, time(NULL))
#define C_peek_c_string_at(ptr, i)    ((C_char *)(((C_char **)ptr)[ i ]))

static C_word
fast_read_line_from_file(C_word str, C_word port, C_word size) {
  int n = C_unfix(size);
  int i;
  int c;
  char *buf = C_c_string(str);
  C_FILEPTR fp = C_port_file(port);

  if ((c = C_getc(fp)) == EOF) {
    if (ferror(fp)) {
      clearerr(fp);
      return C_fix(-1);
    } else { /* feof (fp) */
      return C_SCHEME_END_OF_FILE;
    }
  }

  C_ungetc(c, fp);

  for (i = 0; i < n; i++) {
    c = C_getc(fp);

    if(c == EOF && ferror(fp)) {
      clearerr(fp);
      return C_fix(-(i + 1));
    }

    switch (c) {
    case '\r':	if ((c = C_getc(fp)) != '\n') C_ungetc(c, fp);
    case EOF:	clearerr(fp);
    case '\n':	return C_fix(i);
    }
    buf[i] = c;
  }
  return C_SCHEME_FALSE;
}

static C_word
fast_read_string_from_file(C_word dest, C_word port, C_word len, C_word pos)
{
  size_t m;
  int n = C_unfix (len);
  char * buf = ((char *)C_data_pointer (dest) + C_unfix (pos));
  C_FILEPTR fp = C_port_file (port);

  if(feof(fp)) return C_SCHEME_END_OF_FILE;

  m = fread (buf, sizeof (char), n, fp);

  if (m < n) {
    if (ferror(fp)) /* Report to Scheme, which may retry, so clear errors */
      clearerr(fp);
    else if (feof(fp) && 0 == m) /* eof but m > 0? Return data first, below */
      return C_SCHEME_END_OF_FILE; /* Calling again will get us here */
  }

  return C_fix (m);
}

static C_word
shallow_equal(C_word x, C_word y)
{
  /* assumes x and y are non-immediate */
  int i, len = C_header_size(x);

  if(C_header_size(y) != len) return C_SCHEME_FALSE;      
  else return C_mk_bool(!C_memcmp((void *)x, (void *)y, len * sizeof(C_word)));
}

static C_word
signal_debug_event(C_word mode, C_word msg, C_word args)
{
  C_DEBUG_INFO cell;
  C_word av[ 3 ];
  cell.enabled = 1;
  cell.event = C_DEBUG_SIGNAL;
  cell.loc = "";
  cell.val = "";
  av[ 0 ] = mode;
  av[ 1 ] = msg;
  av[ 2 ] = args;
  C_debugger(&cell, 3, av);
  return C_SCHEME_UNDEFINED;
}
                   
static C_word C_i_sleep_until_interrupt(C_word secs)
{
   while(C_i_process_sleep(secs) == C_fix(-1) && errno == EINTR);
   return C_SCHEME_UNDEFINED;
}
                   
#ifdef NO_DLOAD2
# define HAVE_DLOAD 0
#else
# define HAVE_DLOAD 1
#endif

#ifdef C_ENABLE_PTABLES
# define HAVE_PTABLES 1
#else
# define HAVE_PTABLES 0
#endif

#ifdef C_GC_HOOKS
# define HAVE_GCHOOKS 1
#else
# define HAVE_GCHOOKS 0
#endif

#if defined(C_CROSS_CHICKEN) && C_CROSS_CHICKEN
# define IS_CROSS_CHICKEN 1
#else
# define IS_CROSS_CHICKEN 0
#endif


#define C_chdir(str) C_fix(chdir(C_c_string(str)))
#define C_curdir(buf, size) (getcwd(C_c_string(buf), size) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)
#define C_getenventry(i) (environ[ i ])

#ifdef HAVE_CRT_EXTERNS_H
# include <crt_externs.h>
# define environ (*_NSGetEnviron())
#else
extern char **environ;
#endif

#ifdef HAVE_SETENV
# define C_unsetenv(s)    (unsetenv((char *)C_data_pointer(s)), C_SCHEME_TRUE)
# define C_setenv(x, y)   C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
# if defined(_WIN32) && !defined(__CYGWIN__)
#  define C_unsetenv(s)   C_setenv(s, C_SCHEME_FALSE)
# else
#  define C_unsetenv(s)   C_fix(putenv((char *)C_data_pointer(s)))
# endif
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_c_string(x),
       *sy = (y == C_SCHEME_FALSE ? "" : C_c_string(y));
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  int buf_len = n1 + n2 + 2;
  char *buf = (char *)C_malloc(buf_len);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strlcpy(buf, sx, buf_len);
    C_strlcat(buf, "=", buf_len);
    C_strlcat(buf, sy, buf_len);
    return(C_fix(putenv(buf)));
  }
}
#endif



static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_build_2dversion_toplevel)
C_externimport void C_ccall C_build_2dversion_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_library_toplevel)
C_externimport void C_ccall C_library_toplevel(C_word c,C_word *av) C_noret;

static C_TLS C_word lf[1445];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,110,111,116,32,120,41,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,98,111,111,108,101,97,110,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,101,113,63,32,120,32,121,41};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,113,118,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,101,113,117,97,108,63,32,120,32,121,41,0,0,0,0,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,112,97,105,114,63,32,120,41};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,111,110,115,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,97,114,32,120,41,0,0};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,100,114,32,120,41,0,0};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,101,116,45,99,97,114,33,32,120,32,121,41,0,0,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,101,116,45,99,100,114,33,32,120,32,121,41,0,0,0};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,97,100,114,32,120,41,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,100,100,114,32,120,41};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,97,97,114,32,120,41,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,100,97,114,32,120,41,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,100,100,114,32,120,41,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,97,97,114,32,120,41};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,97,100,114,32,120,41};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,100,97,114,32,120,41};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,97,97,114,32,120,41};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,97,100,114,32,120,41};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,100,97,114,32,120,41};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,100,100,114,32,120,41};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,110,117,108,108,63,32,120,41};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,108,105,115,116,32,46,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,108,101,110,103,116,104,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,108,105,115,116,45,116,97,105,108,32,108,115,116,32,105,41};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,108,105,115,116,45,114,101,102,32,108,115,116,32,105,41,0};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,108,115,116,32,114,101,115,116,41,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,114,101,118,101,114,115,101,32,108,115,116,48,41,0,0,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,101,109,113,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,101,109,118,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,109,101,109,98,101,114,32,120,32,108,115,116,41,0,0,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,97,115,115,113,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,97,115,115,118,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,97,115,115,111,99,32,120,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,108,105,115,116,63,32,120,41};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,115,116,114,105,110,103,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,108,101,110,103,116,104,32,115,41};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,114,101,102,32,115,32,105,41,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,115,101,116,33,32,115,32,105,32,99,41,0,0,0,0,0,0};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,116,114,105,110,103,61,63,32,120,32,121,41,0,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,61,63,32,120,32,121,41};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,101,120,97,99,116,45,62,105,110,101,120,97,99,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,97,98,115,32,120,41,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,6),67,95,112,108,117,115,0,0};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,7),67,95,109,105,110,117,115,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,7),67,95,116,105,109,101,115,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,113,117,111,116,105,101,110,116,32,97,32,98,41,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,114,101,109,97,105,110,100,101,114,32,97,32,98,41,0,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,111,100,117,108,111,32,97,32,98,41,0,0,0,0,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,101,118,101,110,63,32,110,41};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,111,100,100,63,32,110,41,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,9),67,95,110,101,113,117,97,108,112,0,0,0,0,0,0,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,10),67,95,103,114,101,97,116,101,114,112,0,0,0,0,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,7),67,95,108,101,115,115,112,0};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,20),67,95,103,114,101,97,116,101,114,95,111,114,95,101,113,117,97,108,95,112,0,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,17),67,95,108,101,115,115,95,111,114,95,101,113,117,97,108,95,112,0,0,0,0,0,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,110,117,109,98,101,114,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,114,101,97,108,63,32,120,41};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,97,116,105,111,110,97,108,63,32,110,41,0,0,0,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,105,110,116,101,103,101,114,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,120,97,99,116,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,105,110,101,120,97,99,116,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,122,101,114,111,63,32,110,41};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,112,111,115,105,116,105,118,101,63,32,110,41,0,0,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,110,101,103,97,116,105,118,101,63,32,110,41,0,0,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,18),67,95,110,117,109,98,101,114,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,115,121,109,98,111,108,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,118,101,99,116,111,114,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,108,101,110,103,116,104,32,118,41};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,114,101,102,32,118,32,105,41,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,115,101,116,33,32,118,32,105,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,104,97,114,63,32,120,41};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,62,105,110,116,101,103,101,114,32,99,41};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,105,110,116,101,103,101,114,45,62,99,104,97,114,32,110,41};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,99,104,97,114,61,63,32,99,49,32,99,50,41,0,0,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,99,104,97,114,62,63,32,99,49,32,99,50,41,0,0,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,99,104,97,114,60,63,32,99,49,32,99,50,41,0,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,62,61,63,32,99,49,32,99,50,41,0,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,60,61,63,32,99,49,32,99,50,41,0,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,117,112,99,97,115,101,32,99,41,0,0};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,100,111,119,110,99,97,115,101,32,99,41};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,117,112,112,101,114,45,99,97,115,101,63,32,99,41,0,0,0,0,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,108,111,119,101,114,45,99,97,115,101,63,32,99,41,0,0,0,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,110,117,109,101,114,105,99,63,32,99,41};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,119,104,105,116,101,115,112,97,99,101,63,32,99,41,0,0,0,0,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,97,108,112,104,97,98,101,116,105,99,63,32,99,41,0,0,0,0,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,112,114,111,99,101,100,117,114,101,63,32,120,41,0,0,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,7),67,95,97,112,112,108,121,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,8),67,95,118,97,108,117,101,115};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,18),67,95,99,97,108,108,95,119,105,116,104,95,118,97,108,117,101,115,0,0,0,0,0,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,105,110,112,117,116,45,112,111,114,116,63,32,120,41,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,111,117,116,112,117,116,45,112,111,114,116,63,32,120,41,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,101,111,102,45,111,98,106,101,99,116,63,32,120,41,0,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,101,118,97,108,32,120,32,46,32,101,110,118,41,0,0,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,105,110,116,101,114,97,99,116,105,111,110,45,101,110,118,105,114,111,110,109,101,110,116,41};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,36),40,115,99,104,101,109,101,35,115,99,104,101,109,101,45,114,101,112,111,114,116,45,101,110,118,105,114,111,110,109,101,110,116,32,110,41,0,0,0,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,110,117,108,108,45,101,110,118,105,114,111,110,109,101,110,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,108,111,97,100,32,102,105,108,101,110,97,109,101,32,46,32,101,118,97,108,117,97,116,111,114,41,0,0,0,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,105,120,110,117,109,63,32,120,41};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,111,110,117,109,63,32,120,41};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,105,103,110,117,109,63,32,120,41};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,97,116,110,117,109,63,32,120,41};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,112,108,120,110,117,109,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,63,32,120,41,0};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,24),67,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,7),40,97,57,52,56,51,41,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,15),40,97,57,52,56,57,32,100,105,118,32,114,101,109,41,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,113,117,111,116,105,101,110,116,38,109,111,100,117,108,111,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,105,110,105,116,101,63,32,120,41};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,102,105,110,105,116,101,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,110,97,110,63,32,120,41,0,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,8),67,95,115,105,103,110,117,109};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,100,100,49,32,110,41,0,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,117,98,49,32,110,41,0,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,114,114,111,114,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,23),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,111,105,100,32,46,32,95,41,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,111,109,105,115,101,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,109,97,107,101,45,112,114,111,109,105,115,101,32,112,114,111,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,7),40,97,57,54,49,51,41,0};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,109,97,107,101,45,112,114,111,109,105,115,101,32,111,98,106,41,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,122,41,0,0,0,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,111,108,100,108,32,102,32,122,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,111,108,100,114,32,102,32,122,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,110,45,101,120,105,116,32,116,104,117,110,107,41,0,0,0,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,105,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,109,101,114,103,101,110,99,121,45,101,120,105,116,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,100,101,110,116,105,116,121,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,101,100,115,41,0,0,0,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,10),40,102,95,57,55,52,51,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,110,106,111,105,110,32,46,32,112,114,101,100,115,41,0,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,101,100,115,41,0,0,0,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,10),40,102,95,57,55,55,54,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,100,105,115,106,111,105,110,32,46,32,112,114,101,100,115,41,0,0};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,12),40,102,95,57,56,50,50,32,46,32,95,41,0,0,0,0};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,12),40,102,95,57,56,50,52,32,46,32,95,41,0,0,0,0};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,110,115,116,97,110,116,108,121,32,46,32,120,115,41,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,12),40,102,95,57,56,51,52,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,105,112,32,112,114,111,99,41};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,15),40,102,95,57,56,52,50,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,108,101,109,101,110,116,32,112,41,0,0,0,0,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,7),40,97,57,56,54,56,41,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,15),40,102,95,57,56,54,51,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,14),40,114,101,99,32,102,48,32,46,32,102,110,115,41,0,0};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,111,115,101,32,46,32,102,110,115,41,0,0,0,0};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,10),40,102,95,57,57,49,52,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,102,110,115,41,0,0,0,0,0,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,32,46,32,102,110,115,41,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,12),40,102,95,57,57,50,57,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,108,105,115,116,45,111,102,63,32,112,114,101,100,41,0,0,0,0};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,12),40,102,95,57,57,55,57,32,46,32,95,41,0,0,0,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,99,115,41,0,0,0,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,15),40,102,95,57,57,57,51,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,97,99,104,32,46,32,112,114,111,99,115,41,0,0,0,0,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,119,112,45,111,98,106,101,99,116,63,32,120,41,0,0,0,0};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,119,101,97,107,45,99,111,110,115,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,119,101,97,107,45,112,97,105,114,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,116,111,109,63,32,120,41,0,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,116,97,105,108,63,32,120,32,121,41};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,9),40,108,111,111,112,32,110,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,116,101,114,115,112,101,114,115,101,32,108,115,116,32,120,41};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,117,116,108,97,115,116,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,108,105,115,116,115,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,97,116,116,101,110,32,46,32,108,105,115,116,115,48,41,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,115,116,115,41,0,0,0,0,0};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,106,111,105,110,32,108,115,116,115,32,46,32,108,115,116,41,0,0};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,98,108,115,116,32,108,115,116,41,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,114,101,115,115,32,98,108,115,116,32,108,115,116,41};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,15),40,102,95,49,48,51,52,57,32,120,32,108,115,116,41,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,117,112,100,97,116,101,33,32,120,32,121,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,117,112,100,97,116,101,32,107,32,118,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,15),40,102,95,49,48,53,52,49,32,120,32,108,115,116,41,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,114,101,102,32,120,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,108,41};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,97,115,115,111,99,32,120,32,108,115,116,32,46,32,116,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,43,32,120,32,121,41};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,45,32,120,32,121,41};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,42,32,120,32,121,41};
static C_char C_TLS li202[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,61,32,120,32,121,41};
static C_char C_TLS li203[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,62,32,120,32,121,41};
static C_char C_TLS li204[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,60,32,120,32,121,41};
static C_char C_TLS li205[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,62,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li206[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,60,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li207[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,105,110,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li208[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,97,120,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li209[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,110,101,103,32,120,41};
static C_char C_TLS li210[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,97,110,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li211[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,105,111,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li212[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,120,111,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li213[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,110,111,116,32,120,41};
static C_char C_TLS li214[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,115,104,108,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li215[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,115,104,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li216[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,111,100,100,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li217[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,101,118,101,110,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li218[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,108,101,110,32,120,41};
static C_char C_TLS li219[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,47,32,120,32,121,41};
static C_char C_TLS li220[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,103,99,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li221[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,111,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li222[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,114,101,109,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li223[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,43,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li224[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,45,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li225[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,42,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li226[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,47,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li227[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,100,101,98,117,103,45,109,111,100,101,63,41,0,0,0,0,0};
static C_char C_TLS li228[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,119,97,114,110,105,110,103,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li229[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,110,111,116,105,99,101,32,109,115,103,32,46,32,97,114,103,115,41};
static C_char C_TLS li230[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,110,97,98,108,101,45,119,97,114,110,105,110,103,115,32,46,32,98,111,111,108,41,0,0,0};
static C_char C_TLS li231[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,101,114,114,111,114,47,101,114,114,110,111,32,101,114,114,32,46,32,97,114,103,115,41,0,0};
static C_char C_TLS li232[] C_aligned={C_lihdr(0,0,4),67,95,103,99,0,0,0,0};
static C_char C_TLS li233[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,101,116,115,108,111,116,32,120,32,105,32,121,41,0,0,0};
static C_char C_TLS li234[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,101,116,105,115,108,111,116,32,120,32,105,32,121,41,0,0};
static C_char C_TLS li235[] C_aligned={C_lihdr(0,0,17),67,95,97,108,108,111,99,97,116,101,95,118,101,99,116,111,114,0,0,0,0,0,0,0};
static C_char C_TLS li236[] C_aligned={C_lihdr(0,0,16),67,95,109,97,107,101,95,115,116,114,117,99,116,117,114,101};
static C_char C_TLS li237[] C_aligned={C_lihdr(0,0,21),67,95,101,110,115,117,114,101,95,104,101,97,112,95,114,101,115,101,114,118,101,0,0,0};
static C_char C_TLS li238[] C_aligned={C_lihdr(0,0,23),67,95,103,101,116,95,115,121,109,98,111,108,95,116,97,98,108,101,95,105,110,102,111,0};
static C_char C_TLS li239[] C_aligned={C_lihdr(0,0,17),67,95,103,101,116,95,109,101,109,111,114,121,95,105,110,102,111,0,0,0,0,0,0,0};
static C_char C_TLS li240[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,115,116,97,114,116,45,116,105,109,101,114,41,0,0,0,0,0};
static C_char C_TLS li241[] C_aligned={C_lihdr(0,0,12),67,95,115,116,111,112,95,116,105,109,101,114,0,0,0,0};
static C_char C_TLS li242[] C_aligned={C_lihdr(0,0,12),67,95,115,116,111,112,95,116,105,109,101,114,0,0,0,0};
static C_char C_TLS li243[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,115,116,111,112,45,116,105,109,101,114,41,0,0,0,0,0,0};
static C_char C_TLS li244[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,105,109,109,101,100,105,97,116,101,63,32,120,41,0,0,0,0};
static C_char C_TLS li245[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,109,101,115,115,97,103,101,32,115,116,114,41,0,0,0,0,0};
static C_char C_TLS li246[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,98,121,116,101,32,120,32,105,41};
static C_char C_TLS li247[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,101,116,98,121,116,101,32,120,32,105,32,110,41,0,0,0};
static C_char C_TLS li248[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,104,97,108,116,32,109,115,103,41};
static C_char C_TLS li249[] C_aligned={C_lihdr(0,0,8),67,95,98,101,99,111,109,101};
static C_char C_TLS li250[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,98,108,111,99,107,45,114,101,102,32,120,32,105,41,0,0,0};
static C_char C_TLS li251[] C_aligned={C_lihdr(0,0,14),67,95,97,112,112,108,121,95,118,97,108,117,101,115,0,0};
static C_char C_TLS li252[] C_aligned={C_lihdr(0,0,14),67,95,99,111,112,121,95,99,108,111,115,117,114,101,0,0};
static C_char C_TLS li253[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,98,108,111,99,107,45,115,101,116,33,32,120,32,105,32,121,41};
static C_char C_TLS li254[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,117,114,114,101,110,116,45,109,105,108,108,105,115,101,99,111,110,100,115,41,0,0,0,0,0};
static C_char C_TLS li255[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,109,105,108,108,105,115,101,99,111,110,100,115,41,0,0,0,0,0};
static C_char C_TLS li256[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,117,114,114,101,110,116,45,115,101,99,111,110,100,115,41,0,0};
static C_char C_TLS li257[] C_aligned={C_lihdr(0,0,23),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,112,117,45,116,105,109,101,41,0};
static C_char C_TLS li258[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,99,104,101,99,107,45,115,116,114,117,99,116,117,114,101,32,120,32,121,32,46,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li259[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,98,108,111,98,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li260[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,112,97,105,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li261[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,108,105,115,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li262[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,115,116,114,105,110,103,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li263[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,110,117,109,98,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li264[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,102,105,120,110,117,109,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li265[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char C_TLS li266[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,101,120,97,99,116,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li267[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,115,121,109,98,111,108,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li268[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,107,101,121,119,111,114,100,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li269[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,118,101,99,116,111,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li270[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,99,104,97,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li271[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,98,111,111,108,101,97,110,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li272[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,99,104,101,99,107,45,108,111,99,97,116,105,118,101,32,120,32,46,32,108,111,99,41,0,0};
static C_char C_TLS li273[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li274[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,45,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char C_TLS li275[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,45,117,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li276[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,114,101,97,108,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li277[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,104,101,99,107,45,114,97,110,103,101,32,105,32,102,114,111,109,32,116,111,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char C_TLS li278[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,99,104,101,99,107,45,115,112,101,99,105,97,108,32,112,116,114,32,46,32,108,111,99,41,0};
static C_char C_TLS li279[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,99,108,111,115,117,114,101,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li280[] C_aligned={C_lihdr(0,0,20),40,108,112,32,112,114,111,109,105,115,101,32,102,111,114,119,97,114,100,41,0,0,0,0};
static C_char C_TLS li281[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,102,111,114,99,101,32,111,98,106,41,0,0,0,0,0,0};
static C_char C_TLS li282[] C_aligned={C_lihdr(0,0,7),67,95,100,108,111,97,100,0};
static C_char C_TLS li283[] C_aligned={C_lihdr(0,0,18),67,95,115,101,116,95,100,108,111,112,101,110,95,102,108,97,103,115,0,0,0,0,0,0};
static C_char C_TLS li284[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,114,114,111,114,45,110,111,116,45,97,45,112,114,111,112,101,114,45,108,105,115,116,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li285[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,110,117,109,98,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li286[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li287[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,101,120,97,99,116,45,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li288[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,101,120,97,99,116,45,117,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li289[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,105,110,101,120,97,99,116,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li290[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,114,101,97,108,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li291[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,98,97,115,101,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li292[] C_aligned={C_lihdr(0,0,11),40,99,111,112,121,32,110,111,100,101,41,0,0,0,0,0};
static C_char C_TLS li293[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,115,116,115,41,0,0,0,0,0};
static C_char C_TLS li294[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,97,112,112,101,110,100,32,46,32,108,115,116,115,41,0,0};
static C_char C_TLS li295[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,108,115,116,32,114,101,115,116,41,0};
static C_char C_TLS li296[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,102,97,115,116,45,114,101,118,101,114,115,101,32,108,115,116,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li297[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,109,97,107,101,45,115,116,114,105,110,103,32,115,105,122,101,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li298[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,109,97,107,101,45,115,116,114,105,110,103,32,115,105,122,101,32,46,32,102,105,108,108,41};
static C_char C_TLS li299[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,32,108,115,41,0,0,0,0,0};
static C_char C_TLS li300[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,108,105,115,116,32,115,41,0};
static C_char C_TLS li301[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,49,53,51,57,32,108,115,116,41};
static C_char C_TLS li302[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,108,105,115,116,45,62,115,116,114,105,110,103,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char C_TLS li303[] C_aligned={C_lihdr(0,0,9),40,105,116,101,114,32,110,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li304[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,114,101,118,101,114,115,101,45,108,105,115,116,45,62,115,116,114,105,110,103,32,108,41,0,0};
static C_char C_TLS li305[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,102,105,108,108,33,32,115,32,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li306[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,111,112,121,32,115,41,0,0};
static C_char C_TLS li307[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,115,117,98,115,116,114,105,110,103,32,115,32,115,116,97,114,116,32,46,32,101,110,100,41};
static C_char C_TLS li308[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,117,98,115,116,114,105,110,103,32,115,32,115,116,97,114,116,32,101,110,100,41,0,0,0};
static C_char C_TLS li309[] C_aligned={C_lihdr(0,0,25),40,99,111,109,112,97,114,101,49,53,57,50,32,115,49,32,115,50,32,108,111,99,32,107,41,0,0,0,0,0,0,0};
static C_char C_TLS li310[] C_aligned={C_lihdr(0,0,22),40,97,49,49,57,48,56,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li311[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,60,63,32,115,49,32,115,50,41,0};
static C_char C_TLS li312[] C_aligned={C_lihdr(0,0,22),40,97,49,49,57,51,50,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li313[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,62,63,32,115,49,32,115,50,41,0};
static C_char C_TLS li314[] C_aligned={C_lihdr(0,0,22),40,97,49,49,57,53,54,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li315[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,60,61,63,32,115,49,32,115,50,41};
static C_char C_TLS li316[] C_aligned={C_lihdr(0,0,22),40,97,49,49,57,55,55,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li317[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,62,61,63,32,115,49,32,115,50,41};
static C_char C_TLS li318[] C_aligned={C_lihdr(0,0,25),40,99,111,109,112,97,114,101,49,54,51,53,32,115,49,32,115,50,32,108,111,99,32,107,41,0,0,0,0,0,0,0};
static C_char C_TLS li319[] C_aligned={C_lihdr(0,0,22),40,97,49,50,48,49,56,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li320[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,60,63,32,115,49,32,115,50,41,0,0,0,0,0,0};
static C_char C_TLS li321[] C_aligned={C_lihdr(0,0,22),40,97,49,50,48,52,50,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li322[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,62,63,32,115,49,32,115,50,41,0,0,0,0,0,0};
static C_char C_TLS li323[] C_aligned={C_lihdr(0,0,22),40,97,49,50,48,54,54,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li324[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,60,61,63,32,115,49,32,115,50,41,0,0,0,0,0};
static C_char C_TLS li325[] C_aligned={C_lihdr(0,0,22),40,97,49,50,48,56,55,32,108,101,110,49,32,108,101,110,50,32,99,109,112,41,0,0};
static C_char C_TLS li326[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,62,61,63,32,115,49,32,115,50,41,0,0,0,0,0};
static C_char C_TLS li327[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,115,116,114,105,110,103,45,97,112,112,101,110,100,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li328[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,115,116,114,115,32,110,41,0,0,0};
static C_char C_TLS li329[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,97,112,112,101,110,100,32,46,32,97,108,108,41,0,0,0,0};
static C_char C_TLS li330[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,32,46,32,99,104,97,114,115,41,0};
static C_char C_TLS li331[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,112,111,115,41,0,0,0,0,0,0};
static C_char C_TLS li332[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,114,97,103,109,101,110,116,115,45,62,115,116,114,105,110,103,32,116,111,116,97,108,32,102,115,41,0,0,0,0,0,0};
static C_char C_TLS li333[] C_aligned={C_lihdr(0,0,20),40,100,111,108,111,111,112,49,55,50,48,32,104,100,32,116,108,32,99,41,0,0,0,0};
static C_char C_TLS li334[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,105,41,0,0,0,0};
static C_char C_TLS li335[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,104,111,112,32,108,115,116,32,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li336[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,43,32,120,32,121,41};
static C_char C_TLS li337[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,45,32,120,32,121,41};
static C_char C_TLS li338[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,42,32,120,32,121,41};
static C_char C_TLS li339[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,47,32,120,32,121,41};
static C_char C_TLS li340[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,42,43,32,120,32,121,32,122,41,0,0,0,0,0};
static C_char C_TLS li341[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,103,99,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li342[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,47,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li343[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,61,32,120,32,121,41};
static C_char C_TLS li344[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,62,32,120,32,121,41};
static C_char C_TLS li345[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,60,32,120,32,121,41};
static C_char C_TLS li346[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,62,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li347[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,60,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li348[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,110,101,103,32,120,41};
static C_char C_TLS li349[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,109,97,120,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li350[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,109,105,110,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li351[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,102,108,111,111,114,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li352[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,114,117,110,99,97,116,101,32,120,41,0,0,0};
static C_char C_TLS li353[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,114,111,117,110,100,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li354[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,101,105,108,105,110,103,32,120,41,0,0,0,0};
static C_char C_TLS li355[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,105,110,32,120,41};
static C_char C_TLS li356[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,111,115,32,120,41};
static C_char C_TLS li357[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,97,110,32,120,41};
static C_char C_TLS li358[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,115,105,110,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li359[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,99,111,115,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li360[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li361[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,50,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li362[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,105,110,104,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li363[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,111,115,104,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li364[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,97,110,104,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li365[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,115,105,110,104,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li366[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,99,111,115,104,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li367[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,104,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li368[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,101,120,112,32,120,41};
static C_char C_TLS li369[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,101,120,112,116,32,120,32,121,41,0,0,0,0,0};
static C_char C_TLS li370[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,108,111,103,32,120,41};
static C_char C_TLS li371[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,113,114,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li372[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,98,115,32,120,41};
static C_char C_TLS li373[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,105,110,116,101,103,101,114,63,32,120,41,0,0,0};
static C_char C_TLS li374[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,108,111,110,117,109,45,112,114,105,110,116,45,112,114,101,99,105,115,105,111,110,32,46,32,114,101,115,116,41,0,0};
static C_char C_TLS li375[] C_aligned={C_lihdr(0,0,18),40,109,97,107,101,45,99,111,109,112,108,101,120,32,114,32,105,41,0,0,0,0,0,0};
static C_char C_TLS li376[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,109,97,107,101,45,114,101,99,116,97,110,103,117,108,97,114,32,114,32,105,41,0,0,0};
static C_char C_TLS li377[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,109,97,107,101,45,112,111,108,97,114,32,114,32,112,104,105,41,0,0,0,0,0,0,0};
static C_char C_TLS li378[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,101,97,108,45,112,97,114,116,32,120,41,0,0,0,0};
static C_char C_TLS li379[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,105,109,97,103,45,112,97,114,116,32,120,41,0,0,0,0};
static C_char C_TLS li380[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,97,110,103,108,101,32,110,41};
static C_char C_TLS li381[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,97,103,110,105,116,117,100,101,32,120,41,0,0,0,0};
static C_char C_TLS li382[] C_aligned={C_lihdr(0,0,10),40,114,97,116,110,117,109,32,110,41,0,0,0,0,0,0};
static C_char C_TLS li383[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,110,117,109,101,114,97,116,111,114,32,110,41,0,0,0,0};
static C_char C_TLS li384[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,100,101,110,111,109,105,110,97,116,111,114,32,110,41,0,0};
static C_char C_TLS li385[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,101,120,116,101,110,100,101,100,45,115,105,103,110,117,109,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li386[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,50,50,57,52,32,120,32,105,41};
static C_char C_TLS li387[] C_aligned={C_lihdr(0,0,13),40,100,101,108,105,118,101,114,32,121,32,100,41,0,0,0};
static C_char C_TLS li388[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,105,110,101,120,97,99,116,45,62,101,120,97,99,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li389[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,97,110,100,0,0,0};
static C_char C_TLS li390[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,105,111,114,0,0,0};
static C_char C_TLS li391[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,120,111,114,0,0,0};
static C_char C_TLS li392[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,98,105,116,119,105,115,101,45,110,111,116,32,110,41,0};
static C_char C_TLS li393[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,98,105,116,45,62,98,111,111,108,101,97,110,32,110,32,105,41,0,0,0,0,0,0};
static C_char C_TLS li394[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,105,110,116,101,103,101,114,45,108,101,110,103,116,104,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li395[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,97,114,105,116,104,109,101,116,105,99,45,115,104,105,102,116,32,110,32,109,41,0,0};
static C_char C_TLS li396[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,97,114,103,115,32,120,41,0,0,0};
static C_char C_TLS li397[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,47,32,97,114,103,49,32,46,32,97,114,103,115,41,0,0};
static C_char C_TLS li398[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,47,45,50,32,120,32,121,41,0};
static C_char C_TLS li399[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,102,108,111,111,114,32,120,41};
static C_char C_TLS li400[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,99,101,105,108,105,110,103,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li401[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,116,114,117,110,99,97,116,101,32,120,41,0,0,0,0,0};
static C_char C_TLS li402[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,114,111,117,110,100,32,120,41};
static C_char C_TLS li403[] C_aligned={C_lihdr(0,0,8),40,115,114,32,120,32,121,41};
static C_char C_TLS li404[] C_aligned={C_lihdr(0,0,24),40,102,105,110,100,45,114,97,116,105,111,45,98,101,116,119,101,101,110,32,120,32,121,41};
static C_char C_TLS li405[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,114,97,116,105,111,110,97,108,105,122,101,32,120,32,101,41};
static C_char C_TLS li406[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,105,32,109,32,120,115,41,0,0,0};
static C_char C_TLS li407[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,97,120,32,120,49,32,46,32,120,115,41,0,0,0,0};
static C_char C_TLS li408[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,105,32,109,32,120,115,41,0,0,0};
static C_char C_TLS li409[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,105,110,32,120,49,32,46,32,120,115,41,0,0,0,0};
static C_char C_TLS li410[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,101,120,112,32,110,41,0,0};
static C_char C_TLS li411[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,108,111,103,45,49,32,120,41,0};
static C_char C_TLS li412[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,108,111,103,32,97,32,46,32,114,101,115,116,41,0,0,0};
static C_char C_TLS li413[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,115,105,110,32,110,41,0,0};
static C_char C_TLS li414[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,111,115,32,110,41,0,0};
static C_char C_TLS li415[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,116,97,110,32,110,41,0,0};
static C_char C_TLS li416[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,97,115,105,110,32,110,41,0};
static C_char C_TLS li417[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,97,99,111,115,32,110,41,0};
static C_char C_TLS li418[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,97,116,97,110,32,110,32,46,32,114,101,115,116,41,0,0};
static C_char C_TLS li419[] C_aligned={C_lihdr(0,0,8),40,97,49,52,56,52,49,41};
static C_char C_TLS li420[] C_aligned={C_lihdr(0,0,34),67,95,117,95,105,110,116,101,103,101,114,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114,0,0,0,0,0,0};
static C_char C_TLS li421[] C_aligned={C_lihdr(0,0,8),40,97,49,52,56,55,50,41};
static C_char C_TLS li422[] C_aligned={C_lihdr(0,0,20),40,97,49,52,56,56,56,32,113,50,54,54,50,32,117,50,54,54,52,41,0,0,0,0};
static C_char C_TLS li423[] C_aligned={C_lihdr(0,0,22),40,97,49,52,56,53,53,32,115,94,50,54,52,50,32,114,94,50,54,52,52,41,0,0};
static C_char C_TLS li424[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,115,113,114,116,32,97,41,0,0,0,0};
static C_char C_TLS li425[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,115,113,114,116,32,120,41,0,0,0,0,0};
static C_char C_TLS li426[] C_aligned={C_lihdr(0,0,8),40,97,49,53,48,50,57,41};
static C_char C_TLS li427[] C_aligned={C_lihdr(0,0,14),40,97,49,53,48,51,53,32,115,94,50,32,114,41,0,0};
static C_char C_TLS li428[] C_aligned={C_lihdr(0,0,8),40,97,49,53,48,53,55,41};
static C_char C_TLS li429[] C_aligned={C_lihdr(0,0,8),40,97,49,53,48,56,49,41};
static C_char C_TLS li430[] C_aligned={C_lihdr(0,0,16),40,97,49,53,48,57,51,32,100,115,94,50,32,100,114,41};
static C_char C_TLS li431[] C_aligned={C_lihdr(0,0,16),40,97,49,53,48,54,57,32,110,115,94,50,32,110,114,41};
static C_char C_TLS li432[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,113,114,116,47,108,111,99,32,108,111,99,32,110,41,0,0};
static C_char C_TLS li433[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,115,113,114,116,32,120,41,0};
static C_char C_TLS li434[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,110,116,104,45,114,111,111,116,32,107,32,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li435[] C_aligned={C_lihdr(0,0,10),40,108,112,32,103,48,32,103,49,41,0,0,0,0,0,0};
static C_char C_TLS li436[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,110,116,104,45,114,111,111,116,47,108,111,99,32,108,111,99,32,107,32,110,41,0,0,0,0,0,0};
static C_char C_TLS li437[] C_aligned={C_lihdr(0,0,11),40,108,112,32,114,101,115,32,101,50,41,0,0,0,0,0};
static C_char C_TLS li438[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,105,110,116,101,103,101,114,45,112,111,119,101,114,32,98,97,115,101,32,101,41,0,0,0,0};
static C_char C_TLS li439[] C_aligned={C_lihdr(0,0,14),40,108,111,103,45,101,120,112,116,32,97,32,98,41,0,0};
static C_char C_TLS li440[] C_aligned={C_lihdr(0,0,15),40,115,108,111,119,45,101,120,112,116,32,97,32,98,41,0};
static C_char C_TLS li441[] C_aligned={C_lihdr(0,0,8),40,97,49,53,52,53,48,41};
static C_char C_TLS li442[] C_aligned={C_lihdr(0,0,15),40,97,49,53,52,54,50,32,100,115,94,110,32,114,41,0};
static C_char C_TLS li443[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,120,112,116,32,97,32,98,41,0,0,0,0,0,0,0};
static C_char C_TLS li444[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,105,110,116,101,114,110,97,108,45,103,99,100,32,108,111,99,32,97,32,98,41,0,0,0,0};
static C_char C_TLS li445[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,103,99,100,32,97,32,98,41,0};
static C_char C_TLS li446[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,104,101,97,100,32,110,101,120,116,41};
static C_char C_TLS li447[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,103,99,100,32,46,32,110,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li448[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,108,99,109,32,120,32,121,41,0};
static C_char C_TLS li449[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,104,101,97,100,32,110,101,120,116,41};
static C_char C_TLS li450[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,108,99,109,32,46,32,110,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li451[] C_aligned={C_lihdr(0,0,34),67,95,117,95,105,110,116,101,103,101,114,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114,0,0,0,0,0,0};
static C_char C_TLS li452[] C_aligned={C_lihdr(0,0,8),40,97,49,53,56,49,51,41};
static C_char C_TLS li453[] C_aligned={C_lihdr(0,0,22),40,97,49,53,56,49,57,32,104,105,50,56,52,55,32,108,111,50,56,52,57,41,0,0};
static C_char C_TLS li454[] C_aligned={C_lihdr(0,0,61),40,35,35,115,121,115,35,105,110,116,101,103,101,114,45,62,115,116,114,105,110,103,47,114,101,99,117,114,115,105,118,101,32,110,32,98,97,115,101,32,101,120,112,101,99,116,101,100,45,115,116,114,105,110,103,45,115,105,122,101,41,0,0,0};
static C_char C_TLS li455[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,101,120,116,101,110,100,101,100,45,110,117,109,98,101,114,45,62,115,116,114,105,110,103,32,110,32,98,97,115,101,41,0,0};
static C_char C_TLS li456[] C_aligned={C_lihdr(0,0,20),40,114,111,117,110,100,45,113,117,111,116,105,101,110,116,32,110,32,100,41,0,0,0,0};
static C_char C_TLS li457[] C_aligned={C_lihdr(0,0,13),40,103,111,45,105,110,101,120,97,99,116,33,41,0,0,0};
static C_char C_TLS li458[] C_aligned={C_lihdr(0,0,23),40,115,97,102,101,45,101,120,112,111,110,101,110,116,32,118,97,108,117,101,32,101,41,0};
static C_char C_TLS li459[] C_aligned={C_lihdr(0,0,6),40,108,112,32,105,41,0,0};
static C_char C_TLS li460[] C_aligned={C_lihdr(0,0,19),40,115,99,97,110,45,100,105,103,105,116,115,32,115,116,97,114,116,41,0,0,0,0,0};
static C_char C_TLS li461[] C_aligned={C_lihdr(0,0,6),40,108,112,32,105,41,0,0};
static C_char C_TLS li462[] C_aligned={C_lihdr(0,0,19),40,115,99,97,110,45,104,97,115,104,101,115,32,115,116,97,114,116,41,0,0,0,0,0};
static C_char C_TLS li463[] C_aligned={C_lihdr(0,0,46),40,115,99,97,110,45,100,105,103,105,116,115,43,104,97,115,104,101,115,32,115,116,97,114,116,32,110,101,103,63,32,97,108,108,45,104,97,115,104,101,115,45,111,107,63,41,0,0};
static C_char C_TLS li464[] C_aligned={C_lihdr(0,0,21),40,115,99,97,110,45,101,120,112,111,110,101,110,116,32,115,116,97,114,116,41,0,0,0};
static C_char C_TLS li465[] C_aligned={C_lihdr(0,0,43),40,115,99,97,110,45,100,101,99,105,109,97,108,45,116,97,105,108,32,115,116,97,114,116,32,110,101,103,63,32,100,101,99,105,109,97,108,45,104,101,97,100,41,0,0,0,0,0};
static C_char C_TLS li466[] C_aligned={C_lihdr(0,0,23),40,115,99,97,110,45,117,114,101,97,108,32,115,116,97,114,116,32,110,101,103,63,41,0};
static C_char C_TLS li467[] C_aligned={C_lihdr(0,0,17),40,115,99,97,110,45,114,101,97,108,32,115,116,97,114,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li468[] C_aligned={C_lihdr(0,0,50),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,99,111,109,112,110,117,109,32,114,97,100,105,120,32,115,116,114,32,111,102,102,115,101,116,32,101,120,97,99,116,110,101,115,115,41,0,0,0,0,0,0};
static C_char C_TLS li469[] C_aligned={C_lihdr(0,0,32),40,115,99,97,110,45,112,114,101,102,105,120,32,105,32,101,120,110,101,115,115,32,114,97,100,105,120,32,108,101,110,41};
static C_char C_TLS li470[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,110,117,109,98,101,114,32,115,116,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li471[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,110,117,109,98,101,114,32,115,116,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li472[] C_aligned={C_lihdr(0,0,18),67,95,102,105,120,110,117,109,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char C_TLS li473[] C_aligned={C_lihdr(0,0,18),67,95,102,108,111,110,117,109,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char C_TLS li474[] C_aligned={C_lihdr(0,0,19),67,95,105,110,116,101,103,101,114,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0};
static C_char C_TLS li475[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li476[] C_aligned={C_lihdr(0,0,25),40,99,111,109,112,97,114,101,45,115,108,111,116,115,32,120,32,121,32,115,116,97,114,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li477[] C_aligned={C_lihdr(0,0,10),40,119,97,108,107,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li478[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,113,117,97,108,61,63,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li479[] C_aligned={C_lihdr(0,0,18),67,95,115,116,114,105,110,103,95,116,111,95,115,121,109,98,111,108,0,0,0,0,0,0};
static C_char C_TLS li480[] C_aligned={C_lihdr(0,0,19),67,95,115,116,114,105,110,103,95,116,111,95,107,101,121,119,111,114,100,0,0,0,0,0};
static C_char C_TLS li481[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,105,110,116,101,114,110,101,100,45,115,121,109,98,111,108,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li482[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0,0,0};
static C_char C_TLS li483[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,115,121,109,98,111,108,45,62,115,116,114,105,110,103,32,115,41};
static C_char C_TLS li484[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,115,121,109,98,111,108,45,62,115,116,114,105,110,103,32,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li485[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0,0};
static C_char C_TLS li486[] C_aligned={C_lihdr(0,0,13),67,95,109,97,107,101,95,115,121,109,98,111,108,0,0,0};
static C_char C_TLS li487[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,116,114,105,110,103,45,62,117,110,105,110,116,101,114,110,101,100,45,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0};
static C_char C_TLS li488[] C_aligned={C_lihdr(0,0,13),67,95,109,97,107,101,95,115,121,109,98,111,108,0,0,0};
static C_char C_TLS li489[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,110,115,121,109,32,46,32,115,116,114,45,111,114,45,115,121,109,41,0,0,0,0,0,0};
static C_char C_TLS li490[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,51,52,53,57,32,103,51,52,55,49,41,0,0,0,0};
static C_char C_TLS li491[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,121,109,98,111,108,45,97,112,112,101,110,100,32,46,32,115,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li492[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,107,101,121,119,111,114,100,63,32,120,41,0,0,0,0};
static C_char C_TLS li493[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,115,116,114,105,110,103,45,62,107,101,121,119,111,114,100,32,115,41,0,0,0,0,0};
static C_char C_TLS li494[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,107,101,121,119,111,114,100,45,62,115,116,114,105,110,103,32,107,119,41,0,0,0,0};
static C_char C_TLS li495[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,103,101,116,45,107,101,121,119,111,114,100,32,107,101,121,32,97,114,103,115,32,46,32,114,101,115,116,41,0,0,0};
static C_char C_TLS li496[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,109,97,107,101,45,98,108,111,98,32,115,105,122,101,41,0,0};
static C_char C_TLS li497[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,98,108,111,98,35,109,97,107,101,45,98,108,111,98,32,115,105,122,101,41,0,0,0};
static C_char C_TLS li498[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,108,111,98,35,98,108,111,98,63,32,120,41,0,0};
static C_char C_TLS li499[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,108,111,98,35,98,108,111,98,45,115,105,122,101,32,98,118,41,0,0,0,0,0};
static C_char C_TLS li500[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,98,108,111,98,35,115,116,114,105,110,103,45,62,98,108,111,98,32,115,41,0,0,0};
static C_char C_TLS li501[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,108,111,98,35,98,108,111,98,45,62,115,116,114,105,110,103,32,98,118,41,0,0};
static C_char C_TLS li502[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,108,111,98,35,98,108,111,98,61,63,32,98,49,32,98,50,41,0,0,0,0,0};
static C_char C_TLS li503[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,109,97,107,101,45,118,101,99,116,111,114,32,115,105,122,101,32,46,32,102,105,108,108,41};
static C_char C_TLS li504[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li505[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,108,105,115,116,45,62,118,101,99,116,111,114,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char C_TLS li506[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li507[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,62,108,105,115,116,32,118,41,0};
static C_char C_TLS li508[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,118,101,99,116,111,114,32,46,32,120,115,41,0,0,0,0};
static C_char C_TLS li509[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,51,53,57,55,41,0,0,0,0};
static C_char C_TLS li510[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,102,105,108,108,33,32,118,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li511[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,51,54,48,57,41,0,0,0,0};
static C_char C_TLS li512[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,101,99,116,111,114,45,99,111,112,121,33,32,102,114,111,109,32,116,111,32,46,32,110,41,0};
static C_char C_TLS li513[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,51,54,52,48,41,0,0,0,0};
static C_char C_TLS li514[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,117,98,118,101,99,116,111,114,32,118,32,105,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li515[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,101,99,116,111,114,45,114,101,115,105,122,101,32,118,32,110,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li516[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,51,54,54,56,41,0,0,0,0};
static C_char C_TLS li517[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,118,101,99,116,111,114,45,114,101,115,105,122,101,32,118,32,110,32,105,110,105,116,41,0,0};
static C_char C_TLS li518[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,61,63,32,120,32,121,41,0,0};
static C_char C_TLS li519[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,62,63,32,120,32,121,41,0,0};
static C_char C_TLS li520[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,60,63,32,120,32,121,41,0,0};
static C_char C_TLS li521[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,62,61,63,32,120,32,121,41,0};
static C_char C_TLS li522[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,60,61,63,32,120,32,121,41,0};
static C_char C_TLS li523[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li524[] C_aligned={C_lihdr(0,0,15),40,108,111,111,107,117,112,45,99,104,97,114,32,99,41,0};
static C_char C_TLS li525[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,104,97,114,45,110,97,109,101,32,120,32,46,32,121,41,0,0};
static C_char C_TLS li526[] C_aligned={C_lihdr(0,0,9),67,95,99,97,108,108,95,99,99,0,0,0,0,0,0,0};
static C_char C_TLS li527[] C_aligned={C_lihdr(0,0,19),67,95,99,97,108,108,95,119,105,116,104,95,99,116,104,117,108,104,117,0,0,0,0,0};
static C_char C_TLS li528[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li529[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,102,111,114,45,101,97,99,104,32,112,32,108,115,116,48,41,0};
static C_char C_TLS li530[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li531[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,109,97,112,32,112,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char C_TLS li532[] C_aligned={C_lihdr(0,0,9),40,108,112,32,108,115,116,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li533[] C_aligned={C_lihdr(0,0,14),40,97,49,56,57,55,48,32,101,109,112,116,121,41,0,0};
static C_char C_TLS li534[] C_aligned={C_lihdr(0,0,24),40,109,97,112,115,97,102,101,51,55,52,52,32,112,32,108,115,116,115,32,108,111,99,41};
static C_char C_TLS li535[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,51,55,54,52,32,103,51,55,55,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li536[] C_aligned={C_lihdr(0,0,10),40,97,49,57,48,57,50,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li537[] C_aligned={C_lihdr(0,0,10),40,97,49,57,48,57,56,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li538[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,97,108,108,41,0,0,0,0,0,0};
static C_char C_TLS li539[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,102,111,114,45,101,97,99,104,32,102,110,32,108,115,116,49,32,46,32,108,115,116,115,41};
static C_char C_TLS li540[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,51,55,57,50,32,103,51,56,48,52,41,0,0,0,0};
static C_char C_TLS li541[] C_aligned={C_lihdr(0,0,10),40,97,49,57,49,57,51,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li542[] C_aligned={C_lihdr(0,0,10),40,97,49,57,49,57,57,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li543[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,97,108,108,41,0,0,0,0,0,0};
static C_char C_TLS li544[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,109,97,112,32,102,110,32,108,115,116,49,32,46,32,108,115,116,115,41,0,0,0,0,0};
static C_char C_TLS li545[] C_aligned={C_lihdr(0,0,18),40,97,49,57,50,49,57,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li546[] C_aligned={C_lihdr(0,0,40),40,115,99,104,101,109,101,35,100,121,110,97,109,105,99,45,119,105,110,100,32,98,101,102,111,114,101,32,116,104,117,110,107,32,97,102,116,101,114,41};
static C_char C_TLS li547[] C_aligned={C_lihdr(0,0,24),40,99,111,110,116,105,110,117,97,116,105,111,110,32,46,32,114,101,115,117,108,116,115,41};
static C_char C_TLS li548[] C_aligned={C_lihdr(0,0,13),40,97,49,57,50,52,51,32,99,111,110,116,41,0,0,0};
static C_char C_TLS li549[] C_aligned={C_lihdr(0,0,44),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,99,117,114,114,101,110,116,45,99,111,110,116,105,110,117,97,116,105,111,110,32,112,114,111,99,41,0,0,0,0};
static C_char C_TLS li550[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,100,121,110,97,109,105,99,45,117,110,119,105,110,100,32,119,105,110,100,115,32,110,41,0,0};
static C_char C_TLS li551[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,111,114,116,63,32,120,41,0,0};
static C_char C_TLS li552[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,112,117,116,45,112,111,114,116,45,111,112,101,110,63,32,112,41,0,0,0,0,0,0,0};
static C_char C_TLS li553[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,117,116,112,117,116,45,112,111,114,116,45,111,112,101,110,63,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li554[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,111,114,116,45,99,108,111,115,101,100,63,32,112,41,0,0,0};
static C_char C_TLS li555[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,109,97,107,101,45,112,111,114,116,32,105,47,111,32,99,108,97,115,115,32,110,97,109,101,32,116,121,112,101,41,0,0,0};
static C_char C_TLS li556[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li557[] C_aligned={C_lihdr(0,0,10),40,97,51,51,48,48,50,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li558[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li559[] C_aligned={C_lihdr(0,0,10),40,97,51,51,48,52,49,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li560[] C_aligned={C_lihdr(0,0,12),40,97,51,51,48,56,48,32,112,32,99,41,0,0,0,0};
static C_char C_TLS li561[] C_aligned={C_lihdr(0,0,12),40,97,51,51,48,56,51,32,112,32,115,41,0,0,0,0};
static C_char C_TLS li562[] C_aligned={C_lihdr(0,0,12),40,97,51,51,48,56,54,32,112,32,100,41,0,0,0,0};
static C_char C_TLS li563[] C_aligned={C_lihdr(0,0,10),40,97,51,51,48,57,50,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li564[] C_aligned={C_lihdr(0,0,10),40,97,51,51,48,57,53,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li565[] C_aligned={C_lihdr(0,0,8),40,97,51,51,49,51,53,41};
static C_char C_TLS li566[] C_aligned={C_lihdr(0,0,20),40,108,111,111,112,32,114,101,109,32,97,99,116,32,115,116,97,114,116,41,0,0,0,0};
static C_char C_TLS li567[] C_aligned={C_lihdr(0,0,23),40,97,51,51,48,57,56,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0};
static C_char C_TLS li568[] C_aligned={C_lihdr(0,0,8),40,97,51,51,50,57,53,41};
static C_char C_TLS li569[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,108,101,110,32,108,105,109,105,116,32,98,117,102,102,101,114,32,114,101,115,117,108,116,32,102,41};
static C_char C_TLS li570[] C_aligned={C_lihdr(0,0,17),40,97,51,51,49,57,54,32,112,32,114,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li571[] C_aligned={C_lihdr(0,0,16),67,95,111,112,101,110,95,102,105,108,101,95,112,111,114,116};
static C_char C_TLS li572[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,112,117,116,45,112,111,114,116,32,120,32,111,112,101,110,32,46,32,108,111,99,41,0,0,0};
static C_char C_TLS li573[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,99,104,101,99,107,45,111,117,116,112,117,116,45,112,111,114,116,32,120,32,111,112,101,110,32,46,32,108,111,99,41,0,0};
static C_char C_TLS li574[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,112,111,114,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char C_TLS li575[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,99,104,101,99,107,45,111,112,101,110,45,112,111,114,116,32,120,32,46,32,108,111,99,41,0};
static C_char C_TLS li576[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,51,57,55,54,41,0,0,0,0,0,0};
static C_char C_TLS li577[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,99,117,114,114,101,110,116,45,105,110,112,117,116,45,112,111,114,116,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char C_TLS li578[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,52,48,48,49,41,0,0,0,0,0,0};
static C_char C_TLS li579[] C_aligned={C_lihdr(0,0,35),40,115,99,104,101,109,101,35,99,117,114,114,101,110,116,45,111,117,116,112,117,116,45,112,111,114,116,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li580[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,52,48,50,54,41,0,0,0,0,0,0};
static C_char C_TLS li581[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,117,114,114,101,110,116,45,101,114,114,111,114,45,112,111,114,116,32,46,32,97,114,103,115,41};
static C_char C_TLS li582[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,116,116,121,45,112,111,114,116,63,32,112,111,114,116,41,0,0};
static C_char C_TLS li583[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,112,111,114,116,45,100,97,116,97,32,112,111,114,116,41,0,0};
static C_char C_TLS li584[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,115,101,116,45,112,111,114,116,45,100,97,116,97,33,32,112,111,114,116,32,100,97,116,97,41};
static C_char C_TLS li585[] C_aligned={C_lihdr(0,0,18),40,100,111,108,111,111,112,52,48,54,51,32,109,111,100,101,115,41,0,0,0,0,0,0};
static C_char C_TLS li586[] C_aligned={C_lihdr(0,0,25),40,111,112,101,110,32,110,97,109,101,32,105,110,112,32,109,111,100,101,115,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li587[] C_aligned={C_lihdr(0,0,20),40,99,108,111,115,101,32,112,111,114,116,32,105,110,112,32,108,111,99,41,0,0,0,0};
static C_char C_TLS li588[] C_aligned={C_lihdr(0,0,36),40,115,99,104,101,109,101,35,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,32,110,97,109,101,32,46,32,109,111,100,101,41,0,0,0,0};
static C_char C_TLS li589[] C_aligned={C_lihdr(0,0,37),40,115,99,104,101,109,101,35,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,32,110,97,109,101,32,46,32,109,111,100,101,41,0,0,0};
static C_char C_TLS li590[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,99,108,111,115,101,45,105,110,112,117,116,45,112,111,114,116,32,112,111,114,116,41,0,0};
static C_char C_TLS li591[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,99,108,111,115,101,45,111,117,116,112,117,116,45,112,111,114,116,32,112,111,114,116,41,0};
static C_char C_TLS li592[] C_aligned={C_lihdr(0,0,8),40,97,49,57,56,51,54,41};
static C_char C_TLS li593[] C_aligned={C_lihdr(0,0,18),40,97,49,57,56,52,50,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li594[] C_aligned={C_lihdr(0,0,43),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,102,105,108,101,32,110,97,109,101,32,112,32,46,32,109,111,100,101,41,0,0,0,0,0};
static C_char C_TLS li595[] C_aligned={C_lihdr(0,0,8),40,97,49,57,56,54,48,41};
static C_char C_TLS li596[] C_aligned={C_lihdr(0,0,18),40,97,49,57,56,54,54,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li597[] C_aligned={C_lihdr(0,0,44),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,102,105,108,101,32,110,97,109,101,32,112,32,46,32,109,111,100,101,41,0,0,0,0};
static C_char C_TLS li598[] C_aligned={C_lihdr(0,0,8),40,97,49,57,56,56,52,41};
static C_char C_TLS li599[] C_aligned={C_lihdr(0,0,18),40,97,49,57,56,57,53,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li600[] C_aligned={C_lihdr(0,0,8),40,97,49,57,56,56,57,41};
static C_char C_TLS li601[] C_aligned={C_lihdr(0,0,8),40,97,49,57,57,48,52,41};
static C_char C_TLS li602[] C_aligned={C_lihdr(0,0,46),40,115,99,104,101,109,101,35,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,102,105,108,101,32,115,116,114,32,116,104,117,110,107,32,46,32,109,111,100,101,41,0,0};
static C_char C_TLS li603[] C_aligned={C_lihdr(0,0,8),40,97,49,57,57,49,56,41};
static C_char C_TLS li604[] C_aligned={C_lihdr(0,0,18),40,97,49,57,57,50,57,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li605[] C_aligned={C_lihdr(0,0,8),40,97,49,57,57,50,51,41};
static C_char C_TLS li606[] C_aligned={C_lihdr(0,0,8),40,97,49,57,57,51,56,41};
static C_char C_TLS li607[] C_aligned={C_lihdr(0,0,45),40,115,99,104,101,109,101,35,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,102,105,108,101,32,115,116,114,32,116,104,117,110,107,32,46,32,109,111,100,101,41,0,0,0};
static C_char C_TLS li608[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,102,105,108,101,45,101,120,105,115,116,115,63,32,110,97,109,101,32,102,105,108,101,63,32,100,105,114,63,32,108,111,99,41};
static C_char C_TLS li609[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,102,108,117,115,104,45,111,117,116,112,117,116,32,112,111,114,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li610[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,117,115,104,45,111,117,116,112,117,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li611[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,112,111,114,116,45,108,105,110,101,32,112,111,114,116,41,0,0};
static C_char C_TLS li612[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,52,49,57,50,32,105,41,0,0};
static C_char C_TLS li613[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li614[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,100,101,99,111,114,97,116,101,45,108,97,109,98,100,97,32,112,114,111,99,32,112,114,101,100,32,100,101,99,111,114,97,116,111,114,41,0,0,0,0,0};
static C_char C_TLS li615[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li616[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,108,97,109,98,100,97,45,100,101,99,111,114,97,116,105,111,110,32,112,114,111,99,32,112,114,101,100,41,0,0,0,0,0};
static C_char C_TLS li617[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,109,97,107,101,45,108,97,109,98,100,97,45,105,110,102,111,32,115,116,114,41,0,0,0,0};
static C_char C_TLS li618[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,63,32,120,41,0,0};
static C_char C_TLS li619[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,32,112,114,111,99,41};
static C_char C_TLS li620[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,45,62,115,116,114,105,110,103,32,105,110,102,111,41};
static C_char C_TLS li621[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,111,99,101,100,117,114,101,45,105,110,102,111,114,109,97,116,105,111,110,32,120,41,0,0};
static C_char C_TLS li622[] C_aligned={C_lihdr(0,0,12),40,97,50,48,50,49,54,32,112,32,105,41,0,0,0,0};
static C_char C_TLS li623[] C_aligned={C_lihdr(0,0,10),40,97,50,48,50,50,54,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li624[] C_aligned={C_lihdr(0,0,15),40,97,50,48,50,52,50,32,112,114,111,99,32,105,41,0};
static C_char C_TLS li625[] C_aligned={C_lihdr(0,0,48),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,116,101,114,45,119,105,116,104,45,115,101,116,116,101,114,32,103,101,116,32,115,101,116,32,46,32,114,101,115,116,41};
static C_char C_TLS li626[] C_aligned={C_lihdr(0,0,11),40,102,95,50,48,52,57,57,32,120,41,0,0,0,0,0};
static C_char C_TLS li627[] C_aligned={C_lihdr(0,0,28),40,97,115,115,105,103,110,32,118,97,108,32,110,32,99,111,110,118,101,114,116,63,32,115,101,116,63,41,0,0,0,0};
static C_char C_TLS li628[] C_aligned={C_lihdr(0,0,24),40,98,111,100,121,52,51,52,51,32,99,111,110,118,101,114,116,63,32,115,101,116,63,41};
static C_char C_TLS li629[] C_aligned={C_lihdr(0,0,24),40,100,101,102,45,115,101,116,63,52,51,52,54,32,37,99,111,110,118,101,114,116,63,41};
static C_char C_TLS li630[] C_aligned={C_lihdr(0,0,18),40,100,101,102,45,99,111,110,118,101,114,116,63,52,51,52,53,41,0,0,0,0,0,0};
static C_char C_TLS li631[] C_aligned={C_lihdr(0,0,15),40,97,50,48,51,57,48,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li632[] C_aligned={C_lihdr(0,0,12),40,97,50,48,52,55,50,32,118,97,108,41,0,0,0,0};
static C_char C_TLS li633[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,98,97,115,101,35,109,97,107,101,45,112,97,114,97,109,101,116,101,114,32,105,110,105,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li634[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,114,101,97,100,121,63,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li635[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,114,101,97,100,45,99,104,97,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li636[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,114,101,97,100,45,99,104,97,114,45,48,32,112,41,0,0,0};
static C_char C_TLS li637[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,114,101,97,100,45,99,104,97,114,47,112,111,114,116,32,112,111,114,116,41,0,0,0,0,0};
static C_char C_TLS li638[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,112,101,101,107,45,99,104,97,114,45,48,32,112,41,0,0,0};
static C_char C_TLS li639[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,112,101,101,107,45,99,104,97,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li640[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,101,97,100,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li641[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,114,101,97,100,45,112,114,111,109,112,116,45,104,111,111,107,41};
static C_char C_TLS li642[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,105,110,102,105,120,45,108,105,115,116,45,104,111,111,107,32,108,115,116,41,0,0,0,0,0};
static C_char C_TLS li643[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,115,104,97,114,112,45,110,117,109,98,101,114,45,104,111,111,107,32,112,111,114,116,32,110,41};
static C_char C_TLS li644[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,101,97,100,45,119,97,114,110,105,110,103,32,112,111,114,116,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char C_TLS li645[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,114,101,97,100,45,101,114,114,111,114,32,112,111,114,116,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char C_TLS li646[] C_aligned={C_lihdr(0,0,11),40,102,95,50,48,55,55,54,32,99,41,0,0,0,0,0};
static C_char C_TLS li647[] C_aligned={C_lihdr(0,0,21),40,105,110,102,111,32,99,108,97,115,115,32,100,97,116,97,32,118,97,108,41,0,0,0};
static C_char C_TLS li648[] C_aligned={C_lihdr(0,0,8),40,115,107,105,112,32,99,41};
static C_char C_TLS li649[] C_aligned={C_lihdr(0,0,13),40,115,107,105,112,45,116,111,45,101,111,108,41,0,0,0};
static C_char C_TLS li650[] C_aligned={C_lihdr(0,0,22),40,114,101,115,101,114,118,101,100,45,99,104,97,114,97,99,116,101,114,32,99,41,0,0};
static C_char C_TLS li651[] C_aligned={C_lihdr(0,0,29),40,114,101,97,100,45,117,110,114,101,115,101,114,118,101,100,45,99,104,97,114,45,48,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li652[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,99,41};
static C_char C_TLS li653[] C_aligned={C_lihdr(0,0,10),40,114,45,115,112,97,99,101,115,41,0,0,0,0,0,0};
static C_char C_TLS li654[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,115,101,113,32,110,41,0,0,0,0};
static C_char C_TLS li655[] C_aligned={C_lihdr(0,0,22),40,114,45,117,115,101,113,117,101,110,99,101,32,117,32,110,32,98,97,115,101,41,0,0};
static C_char C_TLS li656[] C_aligned={C_lihdr(0,0,10),40,108,112,32,105,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li657[] C_aligned={C_lihdr(0,0,25),40,114,45,99,111,110,115,45,99,111,100,101,112,111,105,110,116,32,99,112,32,108,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li658[] C_aligned={C_lihdr(0,0,14),40,101,97,116,45,119,115,32,99,32,110,108,63,41,0,0};
static C_char C_TLS li659[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li660[] C_aligned={C_lihdr(0,0,15),40,114,45,115,116,114,105,110,103,32,116,101,114,109,41,0};
static C_char C_TLS li661[] C_aligned={C_lihdr(0,0,19),40,115,116,97,114,116,105,110,103,45,108,105,110,101,32,109,115,103,41,0,0,0,0,0};
static C_char C_TLS li662[] C_aligned={C_lihdr(0,0,11),40,102,95,50,49,53,57,54,32,99,41,0,0,0,0,0};
static C_char C_TLS li663[] C_aligned={C_lihdr(0,0,15),40,97,50,49,55,49,49,32,116,111,107,32,107,119,41,0};
static C_char C_TLS li664[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,97,115,116,41,0,0,0,0,0};
static C_char C_TLS li665[] C_aligned={C_lihdr(0,0,15),40,97,50,49,53,57,50,32,114,101,116,117,114,110,41,0};
static C_char C_TLS li666[] C_aligned={C_lihdr(0,0,18),40,114,45,108,105,115,116,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char C_TLS li667[] C_aligned={C_lihdr(0,0,10),40,114,45,118,101,99,116,111,114,41,0,0,0,0,0,0};
static C_char C_TLS li668[] C_aligned={C_lihdr(0,0,15),40,97,50,49,56,51,57,32,116,111,107,32,107,119,41,0};
static C_char C_TLS li669[] C_aligned={C_lihdr(0,0,26),40,114,45,110,117,109,98,101,114,32,114,97,100,105,120,32,101,120,97,99,116,110,101,115,115,41,0,0,0,0,0,0};
static C_char C_TLS li670[] C_aligned={C_lihdr(0,0,31),40,114,45,110,117,109,98,101,114,45,119,105,116,104,45,101,120,97,99,116,110,101,115,115,32,114,97,100,105,120,41,0};
static C_char C_TLS li671[] C_aligned={C_lihdr(0,0,31),40,114,45,110,117,109,98,101,114,45,119,105,116,104,45,114,97,100,105,120,32,101,120,97,99,116,110,101,115,115,41,0};
static C_char C_TLS li672[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li673[] C_aligned={C_lihdr(0,0,9),40,114,45,116,111,107,101,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li674[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char C_TLS li675[] C_aligned={C_lihdr(0,0,10),40,114,45,100,105,103,105,116,115,41,0,0,0,0,0,0};
static C_char C_TLS li676[] C_aligned={C_lihdr(0,0,15),40,97,50,50,49,51,55,32,115,116,114,32,107,119,41,0};
static C_char C_TLS li677[] C_aligned={C_lihdr(0,0,10),40,114,45,115,121,109,98,111,108,41,0,0,0,0,0,0};
static C_char C_TLS li678[] C_aligned={C_lihdr(0,0,18),40,108,111,111,112,32,108,115,116,32,115,107,119,32,113,116,100,41,0,0,0,0,0,0};
static C_char C_TLS li679[] C_aligned={C_lihdr(0,0,12),40,114,45,120,116,111,107,101,110,32,107,41,0,0,0,0};
static C_char C_TLS li680[] C_aligned={C_lihdr(0,0,8),40,114,45,99,104,97,114,41};
static C_char C_TLS li681[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li682[] C_aligned={C_lihdr(0,0,11),40,114,45,99,111,109,109,101,110,116,41,0,0,0,0,0};
static C_char C_TLS li683[] C_aligned={C_lihdr(0,0,14),40,114,45,101,120,116,45,115,121,109,98,111,108,41,0,0};
static C_char C_TLS li684[] C_aligned={C_lihdr(0,0,11),40,114,45,113,117,111,116,101,32,113,41,0,0,0,0,0};
static C_char C_TLS li685[] C_aligned={C_lihdr(0,0,8),40,97,50,50,55,54,55,41};
static C_char C_TLS li686[] C_aligned={C_lihdr(0,0,13),40,97,50,50,55,55,51,32,46,32,120,115,41,0,0,0};
static C_char C_TLS li687[] C_aligned={C_lihdr(0,0,8),40,97,50,50,56,57,52,41};
static C_char C_TLS li688[] C_aligned={C_lihdr(0,0,13),40,97,50,50,57,48,48,32,46,32,120,115,41,0,0,0};
static C_char C_TLS li689[] C_aligned={C_lihdr(0,0,8),40,97,50,50,57,54,53,41};
static C_char C_TLS li690[] C_aligned={C_lihdr(0,0,13),40,97,50,50,57,55,49,32,46,32,120,115,41,0,0,0};
static C_char C_TLS li691[] C_aligned={C_lihdr(0,0,8),40,97,50,51,48,55,57,41};
static C_char C_TLS li692[] C_aligned={C_lihdr(0,0,8),40,97,50,51,48,56,52,41};
static C_char C_TLS li693[] C_aligned={C_lihdr(0,0,8),40,97,50,51,48,57,48,41};
static C_char C_TLS li694[] C_aligned={C_lihdr(0,0,8),40,97,50,51,50,51,51,41};
static C_char C_TLS li695[] C_aligned={C_lihdr(0,0,15),40,97,50,51,50,52,52,32,115,116,114,32,107,119,41,0};
static C_char C_TLS li696[] C_aligned={C_lihdr(0,0,8),40,97,50,51,50,51,56,41};
static C_char C_TLS li697[] C_aligned={C_lihdr(0,0,8),40,97,50,51,50,55,51,41};
static C_char C_TLS li698[] C_aligned={C_lihdr(0,0,8),40,97,50,51,51,57,50,41};
static C_char C_TLS li699[] C_aligned={C_lihdr(0,0,13),40,97,50,51,51,57,56,32,46,32,120,115,41,0,0,0};
static C_char C_TLS li700[] C_aligned={C_lihdr(0,0,9),40,114,101,97,100,114,101,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li701[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,114,101,97,100,32,112,111,114,116,32,105,110,102,111,104,97,110,100,108,101,114,41,0,0,0};
static C_char C_TLS li702[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,99,104,97,114,45,62,117,116,102,56,45,115,116,114,105,110,103,32,99,41,0,0,0,0,0};
static C_char C_TLS li703[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,117,110,105,99,111,100,101,45,115,117,114,114,111,103,97,116,101,63,32,110,41,0,0,0,0};
static C_char C_TLS li704[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,115,117,114,114,111,103,97,116,101,115,45,62,99,111,100,101,112,111,105,110,116,32,104,105,32,108,111,41,0,0,0,0,0};
static C_char C_TLS li705[] C_aligned={C_lihdr(0,0,7),40,104,101,120,32,99,41,0};
static C_char C_TLS li706[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,104,41,0,0,0,0};
static C_char C_TLS li707[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,101,97,100,45,98,121,116,101,118,101,99,116,111,114,45,108,105,116,101,114,97,108,32,112,111,114,116,41,0,0,0,0};
static C_char C_TLS li708[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,117,115,101,114,45,114,101,97,100,45,104,111,111,107,32,99,104,97,114,32,112,111,114,116,41};
static C_char C_TLS li709[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,119,114,105,116,101,45,99,104,97,114,45,48,32,99,32,112,41};
static C_char C_TLS li710[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,119,114,105,116,101,45,99,104,97,114,47,112,111,114,116,32,99,32,112,111,114,116,41,0,0};
static C_char C_TLS li711[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,119,114,105,116,101,45,99,104,97,114,32,99,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li712[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,110,101,119,108,105,110,101,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li713[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,119,114,105,116,101,32,120,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li714[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,100,105,115,112,108,97,121,32,120,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li715[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,49,52,57,32,103,53,49,53,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li716[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li717[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,49,56,49,32,103,53,49,56,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li718[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,42,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char C_TLS li719[] C_aligned={C_lihdr(0,0,17),40,111,117,116,115,116,114,32,112,111,114,116,32,115,116,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li720[] C_aligned={C_lihdr(0,0,17),40,111,117,116,99,104,114,32,112,111,114,116,32,99,104,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li721[] C_aligned={C_lihdr(0,0,17),40,111,117,116,115,121,109,32,112,111,114,116,32,115,121,109,41,0,0,0,0,0,0,0};
static C_char C_TLS li722[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li723[] C_aligned={C_lihdr(0,0,25),40,111,117,116,114,101,97,100,97,98,108,101,115,121,109,32,112,111,114,116,32,115,116,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li724[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li725[] C_aligned={C_lihdr(0,0,22),40,115,121,109,45,105,115,45,114,101,97,100,97,98,108,101,63,32,115,116,114,41,0,0};
static C_char C_TLS li726[] C_aligned={C_lihdr(0,0,10),40,103,53,51,52,55,32,99,110,41,0,0,0,0,0,0};
static C_char C_TLS li727[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,53,51,54,56,32,105,32,99,41};
static C_char C_TLS li728[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,53,51,57,56,32,120,41,0,0};
static C_char C_TLS li729[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,53,52,49,50,32,105,41,0,0};
static C_char C_TLS li730[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,53,52,51,54,32,105,32,99,41};
static C_char C_TLS li731[] C_aligned={C_lihdr(0,0,7),40,111,117,116,32,120,41,0};
static C_char C_TLS li732[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,112,114,105,110,116,32,120,32,114,101,97,100,97,98,108,101,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li733[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,112,114,111,99,101,100,117,114,101,45,62,115,116,114,105,110,103,32,120,41,0,0,0,0,0};
static C_char C_TLS li734[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,101,99,111,114,100,45,112,114,105,110,116,101,114,32,116,121,112,101,41,0,0,0,0,0,0};
static C_char C_TLS li735[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,101,116,45,114,101,99,111,114,100,45,112,114,105,110,116,101,114,33,32,116,121,112,101,32,112,114,111,99,41,0,0,0,0};
static C_char C_TLS li736[] C_aligned={C_lihdr(0,0,8),40,97,50,53,52,56,50,41};
static C_char C_TLS li737[] C_aligned={C_lihdr(0,0,11),40,97,50,53,52,55,54,32,101,120,41,0,0,0,0,0};
static C_char C_TLS li738[] C_aligned={C_lihdr(0,0,8),40,97,50,53,53,51,51,41};
static C_char C_TLS li739[] C_aligned={C_lihdr(0,0,8),40,97,50,53,53,52,56,41};
static C_char C_TLS li740[] C_aligned={C_lihdr(0,0,15),40,97,50,53,53,52,50,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li741[] C_aligned={C_lihdr(0,0,8),40,97,50,53,53,50,55,41};
static C_char C_TLS li742[] C_aligned={C_lihdr(0,0,10),40,97,50,53,52,55,48,32,107,41,0,0,0,0,0,0};
static C_char C_TLS li743[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,117,115,101,114,45,112,114,105,110,116,45,104,111,111,107,32,120,32,114,101,97,100,97,98,108,101,32,112,111,114,116,41,0};
static C_char C_TLS li744[] C_aligned={C_lihdr(0,0,8),40,97,50,53,54,49,53,41};
static C_char C_TLS li745[] C_aligned={C_lihdr(0,0,8),40,97,50,53,54,53,56,41};
static C_char C_TLS li746[] C_aligned={C_lihdr(0,0,8),40,97,50,53,54,54,52,41};
static C_char C_TLS li747[] C_aligned={C_lihdr(0,0,15),40,97,50,53,54,48,57,32,114,101,116,117,114,110,41,0};
static C_char C_TLS li748[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,119,105,116,104,45,112,114,105,110,116,45,108,101,110,103,116,104,45,108,105,109,105,116,32,108,105,109,105,116,32,116,104,117,110,107,41,0,0,0,0,0};
static C_char C_TLS li749[] C_aligned={C_lihdr(0,0,15),40,99,104,101,99,107,53,53,53,54,32,112,32,110,41,0};
static C_char C_TLS li750[] C_aligned={C_lihdr(0,0,10),40,97,51,50,52,57,57,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li751[] C_aligned={C_lihdr(0,0,10),40,97,51,50,53,50,52,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li752[] C_aligned={C_lihdr(0,0,12),40,97,51,50,53,52,50,32,112,32,99,41,0,0,0,0};
static C_char C_TLS li753[] C_aligned={C_lihdr(0,0,14),40,97,51,50,53,54,49,32,112,32,115,116,114,41,0,0};
static C_char C_TLS li754[] C_aligned={C_lihdr(0,0,10),40,97,51,50,53,56,48,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li755[] C_aligned={C_lihdr(0,0,10),40,97,51,50,53,56,51,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li756[] C_aligned={C_lihdr(0,0,23),40,97,51,50,53,56,54,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0};
static C_char C_TLS li757[] C_aligned={C_lihdr(0,0,12),40,97,51,50,54,54,49,32,112,111,115,41,0,0,0,0};
static C_char C_TLS li758[] C_aligned={C_lihdr(0,0,8),40,97,51,50,54,53,49,41};
static C_char C_TLS li759[] C_aligned={C_lihdr(0,0,29),40,97,51,50,54,55,48,32,110,101,120,116,32,108,105,110,101,32,102,117,108,108,45,108,105,110,101,63,41,0,0,0};
static C_char C_TLS li760[] C_aligned={C_lihdr(0,0,16),40,97,51,50,54,50,55,32,112,32,108,105,109,105,116,41};
static C_char C_TLS li761[] C_aligned={C_lihdr(0,0,10),40,97,51,50,55,49,49,32,112,41,0,0,0,0,0,0};
static C_char C_TLS li762[] C_aligned={C_lihdr(0,0,37),40,99,111,112,121,38,97,112,112,101,110,100,32,98,117,102,32,111,102,102,115,101,116,32,112,111,115,32,111,108,100,45,108,105,110,101,41,0,0,0};
static C_char C_TLS li763[] C_aligned={C_lihdr(0,0,8),40,97,50,53,55,56,50,41};
static C_char C_TLS li764[] C_aligned={C_lihdr(0,0,25),40,97,50,53,55,56,56,32,98,117,102,32,111,102,102,115,101,116,32,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li765[] C_aligned={C_lihdr(0,0,8),40,97,50,53,56,52,54,41};
static C_char C_TLS li766[] C_aligned={C_lihdr(0,0,25),40,97,50,53,56,53,50,32,98,117,102,32,111,102,102,115,101,116,32,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li767[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,98,117,102,32,111,102,102,115,101,116,32,112,111,115,32,108,105,109,105,116,32,108,105,110,101,41};
static C_char C_TLS li768[] C_aligned={C_lihdr(0,0,56),40,35,35,115,121,115,35,115,99,97,110,45,98,117,102,102,101,114,45,108,105,110,101,32,98,117,102,32,108,105,109,105,116,32,115,116,97,114,116,45,112,111,115,32,101,111,115,45,104,97,110,100,108,101,114,41};
static C_char C_TLS li769[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,112,101,110,45,105,110,112,117,116,45,115,116,114,105,110,103,32,115,116,114,105,110,103,41,0};
static C_char C_TLS li770[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,112,101,110,45,111,117,116,112,117,116,45,115,116,114,105,110,103,41,0,0,0,0,0,0,0};
static C_char C_TLS li771[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,45,111,117,116,112,117,116,45,115,116,114,105,110,103,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li772[] C_aligned={C_lihdr(0,0,9),40,103,53,54,56,54,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li773[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,54,56,53,32,103,53,54,57,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li774[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,112,114,105,110,116,45,116,111,45,115,116,114,105,110,103,32,120,115,41,0,0,0,0,0,0};
static C_char C_TLS li775[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,111,105,110,116,101,114,45,62,115,116,114,105,110,103,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li776[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li777[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,45,99,97,108,108,45,99,104,97,105,110,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char C_TLS li778[] C_aligned={C_lihdr(0,0,8),40,97,50,54,51,48,52,41};
static C_char C_TLS li779[] C_aligned={C_lihdr(0,0,12),40,103,53,55,53,53,32,105,110,102,111,41,0,0,0,0};
static C_char C_TLS li780[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,55,53,52,32,103,53,55,54,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li781[] C_aligned={C_lihdr(0,0,49),40,35,35,115,121,115,35,114,101,97,108,108,121,45,112,114,105,110,116,45,99,97,108,108,45,99,104,97,105,110,32,112,111,114,116,32,99,104,97,105,110,32,104,101,97,100,101,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li782[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,45,99,97,108,108,45,99,104,97,105,110,32,46,32,114,101,115,116,41,0,0};
static C_char C_TLS li783[] C_aligned={C_lihdr(0,0,7),40,98,114,101,97,107,41,0};
static C_char C_TLS li784[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,117,115,101,114,45,105,110,116,101,114,114,117,112,116,45,104,111,111,107,41,0,0,0,0,0};
static C_char C_TLS li785[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,56,49,52,32,103,53,56,50,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li786[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li787[] C_aligned={C_lihdr(0,0,21),40,99,108,101,97,110,117,112,45,98,101,102,111,114,101,45,101,120,105,116,41,0,0,0};
static C_char C_TLS li788[] C_aligned={C_lihdr(0,0,8),40,97,50,54,54,51,51,41};
static C_char C_TLS li789[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,56,56,53,32,103,53,56,57,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li790[] C_aligned={C_lihdr(0,0,47),40,35,35,115,121,115,35,115,105,103,110,97,108,45,104,111,111,107,47,101,114,114,110,111,32,109,111,100,101,32,101,114,114,110,111,32,109,115,103,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li791[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,115,105,103,110,97,108,45,104,111,111,107,32,109,111,100,101,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li792[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,97,98,111,114,116,32,120,41,0,0,0,0,0};
static C_char C_TLS li793[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,115,105,103,110,97,108,32,120,41,0,0,0,0};
static C_char C_TLS li794[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,117,114,114,101,110,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,99,41,0,0,0,0,0};
static C_char C_TLS li795[] C_aligned={C_lihdr(0,0,8),40,97,50,55,48,57,55,41};
static C_char C_TLS li796[] C_aligned={C_lihdr(0,0,8),40,97,50,55,49,48,49,41};
static C_char C_TLS li797[] C_aligned={C_lihdr(0,0,56),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,119,105,116,104,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,104,97,110,100,108,101,114,32,116,104,117,110,107,41};
static C_char C_TLS li798[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,54,48,52,50,41,0,0,0,0,0,0};
static C_char C_TLS li799[] C_aligned={C_lihdr(0,0,52),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,117,114,114,101,110,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char C_TLS li800[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,112,115,41,0,0,0,0};
static C_char C_TLS li801[] C_aligned={C_lihdr(0,0,69),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,112,114,111,112,45,108,105,115,116,45,62,107,105,110,100,45,112,114,101,102,105,120,101,100,45,112,114,111,112,45,108,105,115,116,32,108,111,99,32,107,105,110,100,32,112,108,105,115,116,41,0,0,0};
static C_char C_TLS li802[] C_aligned={C_lihdr(0,0,56),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,109,97,107,101,45,112,114,111,112,101,114,116,121,45,99,111,110,100,105,116,105,111,110,32,107,105,110,100,32,46,32,112,114,111,112,115,41};
static C_char C_TLS li803[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,48,56,54,41,0,0,0,0,0};
static C_char C_TLS li804[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,49,51,49,32,103,54,49,52,51,41,0,0,0,0};
static C_char C_TLS li805[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,49,48,52,32,103,54,49,49,54,41,0,0,0,0};
static C_char C_TLS li806[] C_aligned={C_lihdr(0,0,55),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,109,97,107,101,45,99,111,109,112,111,115,105,116,101,45,99,111,110,100,105,116,105,111,110,32,99,49,32,46,32,99,111,110,100,115,41,0};
static C_char C_TLS li807[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,49,57,49,32,103,54,50,48,51,41,0,0,0,0};
static C_char C_TLS li808[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,49,54,52,32,103,54,49,55,54,41,0,0,0,0};
static C_char C_TLS li809[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,32,97,114,103,49,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li810[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,63,32,120,41};
static C_char C_TLS li811[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,112,115,41,0,0,0,0};
static C_char C_TLS li812[] C_aligned={C_lihdr(0,0,9),40,103,54,50,50,55,32,107,41,0,0,0,0,0,0,0};
static C_char C_TLS li813[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,54,50,50,49,32,103,54,50,51,51,41,0,0,0,0};
static C_char C_TLS li814[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,62,108,105,115,116,32,120,41,0,0,0};
static C_char C_TLS li815[] C_aligned={C_lihdr(0,0,11),40,102,95,50,55,54,50,48,32,99,41,0,0,0,0,0};
static C_char C_TLS li816[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,112,114,101,100,105,99,97,116,101,32,107,105,110,100,41,0,0,0,0};
static C_char C_TLS li817[] C_aligned={C_lihdr(0,0,11),40,102,95,50,55,54,52,55,32,99,41,0,0,0,0,0};
static C_char C_TLS li818[] C_aligned={C_lihdr(0,0,67),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,112,114,111,112,101,114,116,121,45,97,99,99,101,115,115,111,114,32,107,105,110,100,32,112,114,111,112,32,46,32,101,114,114,45,100,101,102,41,0,0,0,0,0};
static C_char C_TLS li819[] C_aligned={C_lihdr(0,0,64),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,103,101,116,45,99,111,110,100,105,116,105,111,110,45,112,114,111,112,101,114,116,121,32,99,32,107,105,110,100,32,112,114,111,112,32,46,32,101,114,114,45,100,101,102,41};
static C_char C_TLS li820[] C_aligned={C_lihdr(0,0,8),40,97,50,55,55,49,51,41};
static C_char C_TLS li821[] C_aligned={C_lihdr(0,0,9),40,103,54,50,57,50,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li822[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,50,57,49,32,103,54,50,57,56,41,0,0,0,0,0,0,0};
static C_char C_TLS li823[] C_aligned={C_lihdr(0,0,21),40,119,114,105,116,101,97,114,103,115,32,97,114,103,115,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li824[] C_aligned={C_lihdr(0,0,11),40,103,54,51,51,53,32,109,115,103,41,0,0,0,0,0};
static C_char C_TLS li825[] C_aligned={C_lihdr(0,0,22),40,98,111,100,121,54,51,49,50,32,112,111,114,116,32,104,101,97,100,101,114,41,0,0};
static C_char C_TLS li826[] C_aligned={C_lihdr(0,0,22),40,100,101,102,45,104,101,97,100,101,114,54,51,49,53,32,37,112,111,114,116,41,0,0};
static C_char C_TLS li827[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,112,111,114,116,54,51,49,52,41,0,0};
static C_char C_TLS li828[] C_aligned={C_lihdr(0,0,49),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,112,114,105,110,116,45,101,114,114,111,114,45,109,101,115,115,97,103,101,32,101,120,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li829[] C_aligned={C_lihdr(0,0,47),40,35,35,115,121,115,35,115,104,111,119,45,101,120,99,101,112,116,105,111,110,45,119,97,114,110,105,110,103,32,101,120,110,32,99,97,117,115,101,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li830[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,101,114,114,111,114,45,104,111,111,107,32,99,111,100,101,32,108,111,99,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char C_TLS li831[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,116,114,117,99,116,117,114,101,63,32,120,32,115,41,0,0};
static C_char C_TLS li832[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,103,101,110,101,114,105,99,45,115,116,114,117,99,116,117,114,101,63,32,120,41,0,0,0,0};
static C_char C_TLS li833[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,115,108,111,116,32,120,32,105,41};
static C_char C_TLS li834[] C_aligned={C_lihdr(0,0,14),40,35,35,115,121,115,35,115,105,122,101,32,120,41,0,0};
static C_char C_TLS li835[] C_aligned={C_lihdr(0,0,14),67,95,109,97,107,101,95,112,111,105,110,116,101,114,0,0};
static C_char C_TLS li836[] C_aligned={C_lihdr(0,0,21),67,95,109,97,107,101,95,116,97,103,103,101,100,95,112,111,105,110,116,101,114,0,0,0};
static C_char C_TLS li837[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,112,111,105,110,116,101,114,63,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li838[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,115,101,116,45,112,111,105,110,116,101,114,45,97,100,100,114,101,115,115,33,32,112,116,114,32,97,100,100,114,41,0,0,0};
static C_char C_TLS li839[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,98,121,116,101,118,101,99,116,111,114,63,32,120,41,0,0,0};
static C_char C_TLS li840[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,112,98,121,116,101,118,101,99,116,111,114,32,115,41,0,0,0};
static C_char C_TLS li841[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,112,101,114,109,97,110,101,110,116,63,32,120,41,0,0,0,0};
static C_char C_TLS li842[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,98,108,111,99,107,45,97,100,100,114,101,115,115,32,120,41,0};
static C_char C_TLS li843[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,108,111,99,97,116,105,118,101,63,32,120,41,0,0,0,0,0};
static C_char C_TLS li844[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,115,114,102,105,45,52,45,118,101,99,116,111,114,63,32,120,41};
static C_char C_TLS li845[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,110,117,108,108,45,112,111,105,110,116,101,114,41,0,0,0,0};
static C_char C_TLS li846[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,110,117,108,108,45,112,111,105,110,116,101,114,63,32,120,41,0};
static C_char C_TLS li847[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,97,100,100,114,101,115,115,45,62,112,111,105,110,116,101,114,32,97,100,100,114,41,0,0,0};
static C_char C_TLS li848[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,112,111,105,110,116,101,114,45,62,97,100,100,114,101,115,115,32,112,116,114,41,0,0,0,0};
static C_char C_TLS li849[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,109,97,107,101,45,99,45,115,116,114,105,110,103,32,115,116,114,32,46,32,114,101,115,116,41};
static C_char C_TLS li850[] C_aligned={C_lihdr(0,0,21),67,95,112,101,101,107,95,115,105,103,110,101,100,95,105,110,116,101,103,101,114,0,0,0};
static C_char C_TLS li851[] C_aligned={C_lihdr(0,0,23),67,95,112,101,101,107,95,117,110,115,105,103,110,101,100,95,105,110,116,101,103,101,114,0};
static C_char C_TLS li852[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,102,105,120,110,117,109,32,98,32,105,41,0};
static C_char C_TLS li853[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,98,121,116,101,32,112,116,114,32,105,41,0};
static C_char C_TLS li854[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,118,101,99,116,111,114,45,62,115,116,114,117,99,116,117,114,101,33,32,118,101,99,41,0,0};
static C_char C_TLS li855[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,100,111,117,98,108,101,32,98,32,105,41,0};
static C_char C_TLS li856[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,101,101,107,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0,0};
static C_char C_TLS li857[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,112,101,101,107,45,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0,0};
static C_char C_TLS li858[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0};
static C_char C_TLS li859[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0};
static C_char C_TLS li860[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,112,111,107,101,45,99,45,115,116,114,105,110,103,32,98,32,105,32,115,41,0,0,0,0,0};
static C_char C_TLS li861[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,112,111,107,101,45,105,110,116,101,103,101,114,32,98,32,105,32,110,41,0,0,0,0,0,0};
static C_char C_TLS li862[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,111,107,101,45,100,111,117,98,108,101,32,98,32,105,32,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li863[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li864[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,112,101,101,107,45,99,45,115,116,114,105,110,103,45,108,105,115,116,32,112,116,114,32,110,41};
static C_char C_TLS li865[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li866[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,99,45,115,116,114,105,110,103,45,108,105,115,116,32,112,116,114,32,110,41,0,0,0,0,0,0,0};
static C_char C_TLS li867[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,118,101,99,116,111,114,45,62,99,108,111,115,117,114,101,33,32,118,101,99,32,97,100,100,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li868[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,121,109,98,111,108,45,104,97,115,45,116,111,112,108,101,118,101,108,45,98,105,110,100,105,110,103,63,32,115,41,0,0};
static C_char C_TLS li869[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,99,111,112,121,45,98,121,116,101,115,32,102,114,111,109,32,116,111,32,111,102,102,115,101,116,49,32,111,102,102,115,101,116,50,32,98,121,116,101,115,41};
static C_char C_TLS li870[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,99,111,112,121,45,119,111,114,100,115,32,102,114,111,109,32,116,111,32,111,102,102,115,101,116,49,32,111,102,102,115,101,116,50,32,119,111,114,100,115,41};
static C_char C_TLS li871[] C_aligned={C_lihdr(0,0,51),40,35,35,115,121,115,35,99,111,109,112,97,114,101,45,98,121,116,101,115,32,102,114,111,109,32,116,111,32,111,102,102,115,101,116,49,32,111,102,102,115,101,116,50,32,98,121,116,101,115,41,0,0,0,0,0};
static C_char C_TLS li872[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,98,108,111,99,107,45,112,111,105,110,116,101,114,32,120,41,0};
static C_char C_TLS li873[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,99,104,97,114,45,97,114,103,117,109,101,110,116,32,120,41,0};
static C_char C_TLS li874[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,102,105,120,110,117,109,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li875[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,102,108,111,110,117,109,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li876[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,98,108,111,99,107,45,97,114,103,117,109,101,110,116,32,120,41};
static C_char C_TLS li877[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,116,114,117,99,116,45,119,114,97,112,112,101,114,45,97,114,103,117,109,101,110,116,32,116,32,120,41,0,0,0,0,0};
static C_char C_TLS li878[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,116,114,105,110,103,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li879[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,121,109,98,111,108,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li880[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,112,111,105,110,116,101,114,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li881[] C_aligned={C_lihdr(0,0,44),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,116,97,103,103,101,100,45,112,111,105,110,116,101,114,45,97,114,103,117,109,101,110,116,32,120,32,116,120,41,0,0,0,0};
static C_char C_TLS li882[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,114,97,110,103,101,100,45,105,110,116,101,103,101,114,45,97,114,103,117,109,101,110,116,32,111,98,106,32,115,105,122,101,41};
static C_char C_TLS li883[] C_aligned={C_lihdr(0,0,57),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,117,110,115,105,103,110,101,100,45,114,97,110,103,101,100,45,105,110,116,101,103,101,114,45,97,114,103,117,109,101,110,116,32,111,98,106,32,115,105,122,101,41,0,0,0,0,0,0,0};
static C_char C_TLS li884[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,100,101,102,97,117,108,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,97,114,103,41,0,0,0};
static C_char C_TLS li885[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,109,97,107,101,45,116,104,114,101,97,100,32,116,104,117,110,107,32,115,116,97,116,101,32,110,97,109,101,32,113,41,0,0};
static C_char C_TLS li886[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,109,97,107,101,45,109,117,116,101,120,32,105,100,32,111,119,110,101,114,41,0,0,0,0,0};
static C_char C_TLS li887[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,115,99,104,101,100,117,108,101,41};
static C_char C_TLS li888[] C_aligned={C_lihdr(0,0,8),40,97,50,57,49,48,51,41};
static C_char C_TLS li889[] C_aligned={C_lihdr(0,0,15),40,97,50,57,48,57,52,32,114,101,116,117,114,110,41,0};
static C_char C_TLS li890[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,116,104,114,101,97,100,45,121,105,101,108,100,33,41,0,0,0};
static C_char C_TLS li891[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,107,105,108,108,45,111,116,104,101,114,45,116,104,114,101,97,100,115,32,116,104,117,110,107,41};
static C_char C_TLS li892[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,114,101,115,117,109,101,45,116,104,114,101,97,100,45,111,110,45,101,118,101,110,116,32,116,41};
static C_char C_TLS li893[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,115,117,115,112,101,110,100,45,116,104,114,101,97,100,45,111,110,45,101,118,101,110,116,32,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li894[] C_aligned={C_lihdr(0,0,12),40,97,50,57,49,51,48,32,46,32,95,41,0,0,0,0};
static C_char C_TLS li895[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,108,101,101,112,45,117,110,116,105,108,45,105,110,116,101,114,114,117,112,116,41,0,0,0};
static C_char C_TLS li896[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,109,97,107,101,45,101,118,101,110,116,45,113,117,101,117,101,41};
static C_char C_TLS li897[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,97,100,100,45,101,118,101,110,116,45,116,111,45,113,117,101,117,101,33,32,113,32,101,41,0};
static C_char C_TLS li898[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,103,101,116,45,110,101,120,116,45,101,118,101,110,116,32,113,41};
static C_char C_TLS li899[] C_aligned={C_lihdr(0,0,7),40,97,103,97,105,110,41,0};
static C_char C_TLS li900[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,119,97,105,116,45,102,111,114,45,110,101,120,116,45,101,118,101,110,116,32,113,41,0,0,0};
static C_char C_TLS li901[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,108,101,101,112,45,104,111,111,107,32,110,41,0,0,0,0,0};
static C_char C_TLS li902[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,108,101,101,112,32,110,41,0,0};
static C_char C_TLS li903[] C_aligned={C_lihdr(0,0,16),67,95,99,111,110,116,101,120,116,95,115,119,105,116,99,104};
static C_char C_TLS li904[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,114,101,97,115,111,110,41,0,0,0};
static C_char C_TLS li905[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,32,115,116,97,116,101,41,0,0,0,0,0};
static C_char C_TLS li906[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,100,105,115,112,97,116,99,104,45,105,110,116,101,114,114,117,112,116,32,107,41,0,0,0,0};
static C_char C_TLS li907[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,117,112,100,97,116,101,45,101,114,114,110,111,41,0,0,0,0};
static C_char C_TLS li908[] C_aligned={C_lihdr(0,0,13),40,35,35,115,121,115,35,101,114,114,110,111,41,0,0,0};
static C_char C_TLS li909[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,54,55,54,48,32,99,41,0,0};
static C_char C_TLS li910[] C_aligned={C_lihdr(0,0,13),40,114,101,97,100,108,110,32,112,111,114,116,41,0,0,0};
static C_char C_TLS li911[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li912[] C_aligned={C_lihdr(0,0,36),40,114,101,97,100,45,101,115,99,97,112,101,100,45,115,101,120,112,32,112,111,114,116,32,115,107,105,112,45,98,114,97,99,101,63,41,0,0,0,0};
static C_char C_TLS li913[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,54,55,57,53,32,108,110,41,0};
static C_char C_TLS li914[] C_aligned={C_lihdr(0,0,15),40,103,101,116,47,99,108,101,97,114,45,115,116,114,41,0};
static C_char C_TLS li915[] C_aligned={C_lihdr(0,0,27),40,108,111,111,112,50,32,108,115,116,32,110,101,120,116,45,115,116,114,105,110,103,32,97,99,99,41,0,0,0,0,0};
static C_char C_TLS li916[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char C_TLS li917[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,117,115,101,114,45,114,101,97,100,45,104,111,111,107,32,99,104,97,114,32,112,111,114,116,41};
static C_char C_TLS li918[] C_aligned={C_lihdr(0,0,47),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,41,0};
static C_char C_TLS li919[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,45,104,111,111,107,32,100,105,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li920[] C_aligned={C_lihdr(0,0,71),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,32,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,54,57,49,52,41,0};
static C_char C_TLS li921[] C_aligned={C_lihdr(0,0,59),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,115,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,33,32,118,97,114,32,118,97,108,41,0,0,0,0,0};
static C_char C_TLS li922[] C_aligned={C_lihdr(0,0,57),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,117,110,115,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,33,32,118,97,114,41,0,0,0,0,0,0,0};
static C_char C_TLS li923[] C_aligned={C_lihdr(0,0,8),40,115,99,97,110,32,106,41};
static C_char C_TLS li924[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char C_TLS li925[] C_aligned={C_lihdr(0,0,51),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li926[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,101,120,101,99,117,116,97,98,108,101,45,112,97,116,104,110,97,109,101,41,0,0,0};
static C_char C_TLS li927[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,97,114,103,99,43,97,114,103,118,41,0,0,0,0,0};
static C_char C_TLS li928[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,54,57,53,54,32,105,32,118,41};
static C_char C_TLS li929[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,97,114,103,118,41,0,0};
static C_char C_TLS li930[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,103,99,35,99,117,114,114,101,110,116,45,103,99,45,109,105,108,108,105,115,101,99,111,110,100,115,41,0,0,0,0};
static C_char C_TLS li931[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,103,99,35,115,101,116,45,103,99,45,114,101,112,111,114,116,33,32,102,108,97,103,41};
static C_char C_TLS li932[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,103,99,35,109,101,109,111,114,121,45,115,116,97,116,105,115,116,105,99,115,41,0,0};
static C_char C_TLS li933[] C_aligned={C_lihdr(0,0,20),67,95,114,101,103,105,115,116,101,114,95,102,105,110,97,108,105,122,101,114,0,0,0,0};
static C_char C_TLS li934[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,105,110,105,116,45,102,105,110,97,108,105,122,101,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char C_TLS li935[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,103,99,35,102,105,110,97,108,105,122,101,114,63,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li936[] C_aligned={C_lihdr(0,0,11),40,104,97,110,100,108,101,114,32,111,41,0,0,0,0,0};
static C_char C_TLS li937[] C_aligned={C_lihdr(0,0,10),40,104,97,110,100,108,101,32,111,41,0,0,0,0,0,0};
static C_char C_TLS li938[] C_aligned={C_lihdr(0,0,15),40,97,51,48,50,54,52,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li939[] C_aligned={C_lihdr(0,0,15),40,97,51,48,50,56,53,32,112,114,111,99,32,105,41,0};
static C_char C_TLS li940[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,48,51,53,32,103,55,48,52,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li941[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,103,99,35,109,97,107,101,45,102,105,110,97,108,105,122,101,114,32,46,32,111,98,106,101,99,116,115,41,0,0,0};
static C_char C_TLS li942[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,48,55,55,32,103,55,48,56,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li943[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,103,99,35,97,100,100,45,116,111,45,102,105,110,97,108,105,122,101,114,32,102,32,46,32,111,98,106,101,99,116,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li944[] C_aligned={C_lihdr(0,0,8),40,97,51,48,52,52,57,41};
static C_char C_TLS li945[] C_aligned={C_lihdr(0,0,11),40,97,51,48,52,52,51,32,101,120,41,0,0,0,0,0};
static C_char C_TLS li946[] C_aligned={C_lihdr(0,0,8),40,97,51,48,52,54,49,41};
static C_char C_TLS li947[] C_aligned={C_lihdr(0,0,8),40,97,51,48,52,56,52,41};
static C_char C_TLS li948[] C_aligned={C_lihdr(0,0,15),40,97,51,48,52,55,56,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li949[] C_aligned={C_lihdr(0,0,8),40,97,51,48,52,53,53,41};
static C_char C_TLS li950[] C_aligned={C_lihdr(0,0,10),40,97,51,48,52,51,55,32,107,41,0,0,0,0,0,0};
static C_char C_TLS li951[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,55,49,48,57,32,105,41,0,0};
static C_char C_TLS li952[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,117,110,45,112,101,110,100,105,110,103,45,102,105,110,97,108,105,122,101,114,115,32,115,116,97,116,101,41,0,0,0,0};
static C_char C_TLS li953[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li954[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,102,111,114,99,101,45,102,105,110,97,108,105,122,101,114,115,41};
static C_char C_TLS li955[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,103,99,35,103,99,32,46,32,97,114,103,41,0,0,0};
static C_char C_TLS li956[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,109,97,107,101,45,108,111,99,97,116,105,118,101,32,111,98,106,32,105,110,100,101,120,32,119,101,97,107,63,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char C_TLS li957[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,112,117,116,33,32,115,121,109,32,112,114,111,112,32,118,97,108,41,0,0,0,0,0,0,0};
static C_char C_TLS li958[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,103,101,116,32,115,121,109,32,112,114,111,112,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char C_TLS li959[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,112,116,108,41,0,0,0,0,0,0};
static C_char C_TLS li960[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,114,101,109,112,114,111,112,33,32,115,121,109,32,112,114,111,112,41,0,0,0,0,0,0,0};
static C_char C_TLS li961[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,108,105,115,116,41,0,0,0,0};
static C_char C_TLS li962[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,103,101,116,45,112,114,111,112,101,114,116,105,101,115,32,115,121,109,32,112,114,111,112,115,41};
static C_char C_TLS li963[] C_aligned={C_lihdr(0,0,10),40,112,110,117,109,32,110,117,109,41,0,0,0,0,0,0};
static C_char C_TLS li964[] C_aligned={C_lihdr(0,0,14),40,114,111,117,110,100,45,116,111,32,120,32,121,41,0,0};
static C_char C_TLS li965[] C_aligned={C_lihdr(0,0,12),40,112,109,101,109,32,98,121,116,101,115,41,0,0,0,0};
static C_char C_TLS li966[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,100,105,115,112,108,97,121,45,116,105,109,101,115,32,105,110,102,111,41,0,0,0,0,0,0};
static C_char C_TLS li967[] C_aligned={C_lihdr(0,0,17),67,95,100,117,109,112,95,104,101,97,112,95,115,116,97,116,101,0,0,0,0,0,0,0};
static C_char C_TLS li968[] C_aligned={C_lihdr(0,0,21),67,95,102,105,108,116,101,114,95,104,101,97,112,95,111,98,106,101,99,116,115,0,0,0};
static C_char C_TLS li969[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,111,102,116,119,97,114,101,45,116,121,112,101,41};
static C_char C_TLS li970[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,109,97,99,104,105,110,101,45,116,121,112,101,41,0};
static C_char C_TLS li971[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,109,97,99,104,105,110,101,45,98,121,116,101,45,111,114,100,101,114,41,0,0,0};
static C_char C_TLS li972[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,111,102,116,119,97,114,101,45,118,101,114,115,105,111,110,41,0,0,0,0,0};
static C_char C_TLS li973[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,98,117,105,108,100,45,112,108,97,116,102,111,114,109,41,0,0,0,0,0,0,0};
static C_char C_TLS li974[] C_aligned={C_lihdr(0,0,7),40,115,116,114,32,120,41,0};
static C_char C_TLS li975[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,105,99,107,101,110,45,118,101,114,115,105,111,110,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char C_TLS li976[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,105,99,107,101,110,45,104,111,109,101,41,0};
static C_char C_TLS li977[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,115,116,97,114,116,32,112,111,115,41};
static C_char C_TLS li978[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,115,112,108,105,116,45,112,97,116,104,32,112,97,116,104,41,0};
static C_char C_TLS li979[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,111,112,45,115,101,112,97,114,97,116,111,114,32,115,116,114,41,0,0,0};
static C_char C_TLS li980[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,105,110,99,108,117,100,101,45,112,97,116,104,41,0};
static C_char C_TLS li981[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,45,62,102,101,97,116,117,114,101,45,105,100,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li982[] C_aligned={C_lihdr(0,0,9),40,99,104,101,99,107,32,102,41,0,0,0,0,0,0,0};
static C_char C_TLS li983[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,53,54,50,32,103,55,53,54,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li984[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,114,101,103,105,115,116,101,114,45,102,101,97,116,117,114,101,33,32,46,32,102,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li985[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,102,102,115,41,0,0,0,0,0,0};
static C_char C_TLS li986[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,53,56,53,32,103,55,53,57,55,41,0,0,0,0};
static C_char C_TLS li987[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,117,110,114,101,103,105,115,116,101,114,45,102,101,97,116,117,114,101,33,32,46,32,102,115,41,0,0,0,0,0};
static C_char C_TLS li988[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,102,101,97,116,117,114,101,115,41,0,0,0,0,0};
static C_char C_TLS li989[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,105,100,115,41,0,0,0,0,0,0};
static C_char C_TLS li990[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,102,101,97,116,117,114,101,63,32,46,32,105,100,115,41,0,0,0,0,0,0,0};
static C_char C_TLS li991[] C_aligned={C_lihdr(0,0,16),67,95,114,101,116,117,114,110,95,116,111,95,104,111,115,116};
static C_char C_TLS li992[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,121,115,116,101,109,45,99,111,110,102,105,103,45,100,105,114,101,99,116,111,114,121,41,0,0,0,0,0,0};
static C_char C_TLS li993[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,121,115,116,101,109,45,99,97,99,104,101,45,100,105,114,101,99,116,111,114,121,41,0,0,0,0,0,0,0};
static C_char C_TLS li994[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,53,48,53,32,103,55,53,49,55,41,0,0,0,0};
static C_char C_TLS li995[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,52,54,51,41,0,0,0,0,0};
static C_char C_TLS li996[] C_aligned={C_lihdr(0,0,12),40,97,51,50,48,53,53,32,110,101,119,41,0,0,0,0};
static C_char C_TLS li997[] C_aligned={C_lihdr(0,0,16),67,95,98,117,105,108,100,95,112,108,97,116,102,111,114,109};
static C_char C_TLS li998[] C_aligned={C_lihdr(0,0,18),67,95,115,111,102,116,119,97,114,101,95,118,101,114,115,105,111,110,0,0,0,0,0,0};
static C_char C_TLS li999[] C_aligned={C_lihdr(0,0,20),67,95,109,97,99,104,105,110,101,95,98,121,116,101,95,111,114,100,101,114,0,0,0,0};
static C_char C_TLS li1000[] C_aligned={C_lihdr(0,0,14),67,95,109,97,99,104,105,110,101,95,116,121,112,101,0,0};
static C_char C_TLS li1001[] C_aligned={C_lihdr(0,0,15),67,95,115,111,102,116,119,97,114,101,95,116,121,112,101,0};
static C_char C_TLS li1002[] C_aligned={C_lihdr(0,0,12),40,97,51,50,49,53,52,32,115,121,109,41,0,0,0,0};
static C_char C_TLS li1003[] C_aligned={C_lihdr(0,0,16),40,97,51,50,49,54,51,32,115,121,109,32,108,115,116,41};
static C_char C_TLS li1004[] C_aligned={C_lihdr(0,0,10),40,97,51,50,50,48,51,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li1005[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li1006[] C_aligned={C_lihdr(0,0,19),40,102,51,56,51,54,56,32,120,54,57,55,55,51,56,51,54,55,41,0,0,0,0,0};
static C_char C_TLS li1007[] C_aligned={C_lihdr(0,0,19),40,102,51,56,51,55,52,32,120,54,57,54,51,51,56,51,55,51,41,0,0,0,0,0};
static C_char C_TLS li1008[] C_aligned={C_lihdr(0,0,19),40,102,51,56,51,56,48,32,120,54,57,54,51,51,56,51,55,57,41,0,0,0,0,0};
static C_char C_TLS li1009[] C_aligned={C_lihdr(0,0,8),40,97,51,50,50,56,55,41};
static C_char C_TLS li1010[] C_aligned={C_lihdr(0,0,12),40,97,51,50,51,49,50,32,100,105,114,41,0,0,0,0};
static C_char C_TLS li1011[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,57,53,51,32,103,53,57,54,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li1012[] C_aligned={C_lihdr(0,0,8),40,97,51,50,51,52,53,41};
static C_char C_TLS li1013[] C_aligned={C_lihdr(0,0,9),40,103,53,57,55,57,32,120,41,0,0,0,0,0,0,0};
static C_char C_TLS li1014[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,53,57,55,56,32,103,53,57,56,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li1015[] C_aligned={C_lihdr(0,0,15),40,97,51,50,52,53,55,32,46,32,97,114,103,115,41,0};
static C_char C_TLS li1016[] C_aligned={C_lihdr(0,0,19),40,97,51,50,51,49,56,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char C_TLS li1017[] C_aligned={C_lihdr(0,0,8),40,97,51,50,52,54,48,41};
static C_char C_TLS li1018[] C_aligned={C_lihdr(0,0,8),40,97,51,50,52,54,57,41};
static C_char C_TLS li1019[] C_aligned={C_lihdr(0,0,15),40,97,51,50,52,55,53,32,46,32,114,101,115,116,41,0};
static C_char C_TLS li1020[] C_aligned={C_lihdr(0,0,10),40,97,51,50,55,51,57,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li1021[] C_aligned={C_lihdr(0,0,14),40,97,51,50,55,52,56,32,120,32,105,32,121,41,0,0};
static C_char C_TLS li1022[] C_aligned={C_lihdr(0,0,12),40,97,51,50,55,53,56,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1023[] C_aligned={C_lihdr(0,0,12),40,97,51,50,55,54,56,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1024[] C_aligned={C_lihdr(0,0,12),40,97,51,50,55,55,56,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1025[] C_aligned={C_lihdr(0,0,12),40,97,51,50,55,56,56,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1026[] C_aligned={C_lihdr(0,0,12),40,97,51,50,55,57,56,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1027[] C_aligned={C_lihdr(0,0,12),40,97,51,50,56,48,56,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1028[] C_aligned={C_lihdr(0,0,12),40,97,51,50,56,49,56,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1029[] C_aligned={C_lihdr(0,0,12),40,97,51,50,56,50,56,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1030[] C_aligned={C_lihdr(0,0,12),40,97,51,50,56,51,56,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1031[] C_aligned={C_lihdr(0,0,12),40,97,51,50,56,52,56,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1032[] C_aligned={C_lihdr(0,0,12),40,97,51,50,56,53,56,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1033[] C_aligned={C_lihdr(0,0,12),40,97,51,50,56,54,56,32,120,32,121,41,0,0,0,0};
static C_char C_TLS li1034[] C_aligned={C_lihdr(0,0,10),40,97,51,50,57,48,50,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li1035[] C_aligned={C_lihdr(0,0,13),40,97,51,50,56,55,56,32,112,114,111,99,41,0,0,0};
static C_char C_TLS li1036[] C_aligned={C_lihdr(0,0,10),40,97,51,50,57,49,56,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li1037[] C_aligned={C_lihdr(0,0,10),40,97,51,50,57,55,51,32,120,41,0,0,0,0,0,0};
static C_char C_TLS li1038[] C_aligned={C_lihdr(0,0,15),40,97,51,50,57,56,57,32,112,114,111,99,32,105,41,0};
static C_char C_TLS li1039[] C_aligned={C_lihdr(0,0,16),40,97,51,50,57,52,52,32,103,101,116,32,115,101,116,41};
static C_char C_TLS li1040[] C_aligned={C_lihdr(0,0,15),40,97,51,50,57,51,52,32,112,114,111,99,32,105,41,0};
static C_char C_TLS li1041[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub6952(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word i=(C_word )(C_a0);
C_return(C_main_argv[C_unfix(i)]);
C_ret:
#undef return

return C_r;}

/* from chicken.process-context#executable-pathname in k29927 in k29289 in k29069 in k27700 in k27697 in k27694 in k26927 in k26591 in k26587 in k26583 in k25449 in k24279 in k24275 in k24271 in k20708 in k20704 in k20700 in k20696 in k20692 in k20332 in k20328 in ... */
C_regparm static C_word C_fcall stub6944(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_mpointer(&C_a,(void*)C_executable_pathname());
return C_r;}

/* from k29980 */
C_regparm static C_word C_fcall stub6932(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k29938 in chicken.process-context#get-environment-variable in k29927 in k29289 in k29069 in k27700 in k27697 in k27694 in k26927 in k26591 in k26587 in k26583 in k25449 in k24279 in k24275 in k24271 in k20708 in k20704 in k20700 in k20696 in k20692 in k20332 in ... */
C_regparm static C_word C_fcall stub6915(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_c_string(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenv(t0));
return C_r;}

/* from k28937 */
C_regparm static C_word C_fcall stub6582(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
C_free(t0);
return C_r;}

/* from k28928 */
C_regparm static C_word C_fcall stub6574(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mpointer(&C_a,(void*)C_peek_c_string_at(t0,t1));
return C_r;}

/* from k28876 */
C_regparm static C_word C_fcall stub6555(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mpointer(&C_a,(void*)C_peek_c_string_at(t0,t1));
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub5708(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word x=(C_word )(C_a0);
C_return((C_char *)x);
C_ret:
#undef return

return C_r;}

/* from k16025 */
C_regparm static C_word C_fcall stub2905(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
double t0=(double )C_c_double(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_flonum(&C_a,ldexp(t0,t1));
return C_r;}

C_noret_decl(f35157)
static void C_ccall f35157(C_word c,C_word *av) C_noret;
C_noret_decl(f35726)
static void C_ccall f35726(C_word c,C_word *av) C_noret;
C_noret_decl(f35941)
static void C_ccall f35941(C_word c,C_word *av) C_noret;
C_noret_decl(f35945)
static void C_ccall f35945(C_word c,C_word *av) C_noret;
C_noret_decl(f38368)
static void C_ccall f38368(C_word c,C_word *av) C_noret;
C_noret_decl(f38374)
static void C_ccall f38374(C_word c,C_word *av) C_noret;
C_noret_decl(f38380)
static void C_ccall f38380(C_word c,C_word *av) C_noret;
C_noret_decl(f_10018)
static void C_ccall f_10018(C_word c,C_word *av) C_noret;
C_noret_decl(f_10027)
static void C_ccall f_10027(C_word c,C_word *av) C_noret;
C_noret_decl(f_10030)
static void C_ccall f_10030(C_word c,C_word *av) C_noret;
C_noret_decl(f_10033)
static void C_ccall f_10033(C_word c,C_word *av) C_noret;
C_noret_decl(f_10036)
static void C_ccall f_10036(C_word c,C_word *av) C_noret;
C_noret_decl(f_10039)
static void C_ccall f_10039(C_word c,C_word *av) C_noret;
C_noret_decl(f_10048)
static C_word C_fcall f_10048(C_word t0,C_word t1);
C_noret_decl(f_10067)
static void C_ccall f_10067(C_word c,C_word *av) C_noret;
C_noret_decl(f_10073)
static void C_fcall f_10073(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10098)
static void C_ccall f_10098(C_word c,C_word *av) C_noret;
C_noret_decl(f_10100)
static void C_ccall f_10100(C_word c,C_word *av) C_noret;
C_noret_decl(f_10109)
static void C_fcall f_10109(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10130)
static void C_ccall f_10130(C_word c,C_word *av) C_noret;
C_noret_decl(f_10132)
static void C_ccall f_10132(C_word c,C_word *av) C_noret;
C_noret_decl(f_10138)
static void C_fcall f_10138(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_10164)
static void C_ccall f_10164(C_word c,C_word *av) C_noret;
C_noret_decl(f_10171)
static void C_ccall f_10171(C_word c,C_word *av) C_noret;
C_noret_decl(f_10173)
static void C_ccall f_10173(C_word c,C_word *av) C_noret;
C_noret_decl(f_10185)
static void C_fcall f_10185(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10220)
static void C_ccall f_10220(C_word c,C_word *av) C_noret;
C_noret_decl(f_10230)
static void C_ccall f_10230(C_word c,C_word *av) C_noret;
C_noret_decl(f_10239)
static void C_fcall f_10239(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_10281)
static void C_ccall f_10281(C_word c,C_word *av) C_noret;
C_noret_decl(f_10310)
static void C_ccall f_10310(C_word c,C_word *av) C_noret;
C_noret_decl(f_10317)
static void C_fcall f_10317(C_word t0,C_word t1) C_noret;
C_noret_decl(f_10320)
static void C_ccall f_10320(C_word c,C_word *av) C_noret;
C_noret_decl(f_10349)
static void C_ccall f_10349(C_word c,C_word *av) C_noret;
C_noret_decl(f_10355)
static void C_fcall f_10355(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10371)
static void C_ccall f_10371(C_word c,C_word *av) C_noret;
C_noret_decl(f_10396)
static void C_ccall f_10396(C_word c,C_word *av) C_noret;
C_noret_decl(f_10405)
static void C_fcall f_10405(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10446)
static void C_ccall f_10446(C_word c,C_word *av) C_noret;
C_noret_decl(f_10468)
static void C_ccall f_10468(C_word c,C_word *av) C_noret;
C_noret_decl(f_10500)
static void C_ccall f_10500(C_word c,C_word *av) C_noret;
C_noret_decl(f_10516)
static void C_fcall f_10516(C_word t0,C_word t1) C_noret;
C_noret_decl(f_10519)
static void C_ccall f_10519(C_word c,C_word *av) C_noret;
C_noret_decl(f_10541)
static void C_ccall f_10541(C_word c,C_word *av) C_noret;
C_noret_decl(f_10547)
static void C_fcall f_10547(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10572)
static void C_ccall f_10572(C_word c,C_word *av) C_noret;
C_noret_decl(f_10612)
static void C_ccall f_10612(C_word c,C_word *av) C_noret;
C_noret_decl(f_10624)
static void C_fcall f_10624(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_10643)
static void C_ccall f_10643(C_word c,C_word *av) C_noret;
C_noret_decl(f_10665)
static void C_ccall f_10665(C_word c,C_word *av) C_noret;
C_noret_decl(f_10668)
static void C_ccall f_10668(C_word c,C_word *av) C_noret;
C_noret_decl(f_10671)
static void C_ccall f_10671(C_word c,C_word *av) C_noret;
C_noret_decl(f_10674)
static void C_ccall f_10674(C_word c,C_word *av) C_noret;
C_noret_decl(f_10680)
static void C_ccall f_10680(C_word c,C_word *av) C_noret;
C_noret_decl(f_10683)
static void C_ccall f_10683(C_word c,C_word *av) C_noret;
C_noret_decl(f_10686)
static void C_ccall f_10686(C_word c,C_word *av) C_noret;
C_noret_decl(f_10689)
static void C_ccall f_10689(C_word c,C_word *av) C_noret;
C_noret_decl(f_10692)
static void C_ccall f_10692(C_word c,C_word *av) C_noret;
C_noret_decl(f_10695)
static void C_ccall f_10695(C_word c,C_word *av) C_noret;
C_noret_decl(f_10698)
static void C_ccall f_10698(C_word c,C_word *av) C_noret;
C_noret_decl(f_10701)
static void C_ccall f_10701(C_word c,C_word *av) C_noret;
C_noret_decl(f_10704)
static void C_ccall f_10704(C_word c,C_word *av) C_noret;
C_noret_decl(f_10707)
static void C_ccall f_10707(C_word c,C_word *av) C_noret;
C_noret_decl(f_10710)
static void C_ccall f_10710(C_word c,C_word *av) C_noret;
C_noret_decl(f_10713)
static void C_ccall f_10713(C_word c,C_word *av) C_noret;
C_noret_decl(f_10716)
static void C_ccall f_10716(C_word c,C_word *av) C_noret;
C_noret_decl(f_10719)
static void C_ccall f_10719(C_word c,C_word *av) C_noret;
C_noret_decl(f_10722)
static void C_ccall f_10722(C_word c,C_word *av) C_noret;
C_noret_decl(f_10725)
static void C_ccall f_10725(C_word c,C_word *av) C_noret;
C_noret_decl(f_10728)
static void C_ccall f_10728(C_word c,C_word *av) C_noret;
C_noret_decl(f_10731)
static void C_ccall f_10731(C_word c,C_word *av) C_noret;
C_noret_decl(f_10734)
static void C_ccall f_10734(C_word c,C_word *av) C_noret;
C_noret_decl(f_10737)
static void C_ccall f_10737(C_word c,C_word *av) C_noret;
C_noret_decl(f_10740)
static void C_ccall f_10740(C_word c,C_word *av) C_noret;
C_noret_decl(f_10743)
static void C_ccall f_10743(C_word c,C_word *av) C_noret;
C_noret_decl(f_10746)
static void C_ccall f_10746(C_word c,C_word *av) C_noret;
C_noret_decl(f_10749)
static void C_ccall f_10749(C_word c,C_word *av) C_noret;
C_noret_decl(f_10753)
static void C_ccall f_10753(C_word c,C_word *av) C_noret;
C_noret_decl(f_10755)
static void C_ccall f_10755(C_word c,C_word *av) C_noret;
C_noret_decl(f_10760)
static void C_ccall f_10760(C_word c,C_word *av) C_noret;
C_noret_decl(f_10769)
static void C_ccall f_10769(C_word c,C_word *av) C_noret;
C_noret_decl(f_10781)
static void C_ccall f_10781(C_word c,C_word *av) C_noret;
C_noret_decl(f_10795)
static void C_ccall f_10795(C_word c,C_word *av) C_noret;
C_noret_decl(f_10811)
static void C_ccall f_10811(C_word c,C_word *av) C_noret;
C_noret_decl(f_10814)
static void C_ccall f_10814(C_word c,C_word *av) C_noret;
C_noret_decl(f_10822)
static void C_ccall f_10822(C_word c,C_word *av) C_noret;
C_noret_decl(f_10826)
static void C_ccall f_10826(C_word c,C_word *av) C_noret;
C_noret_decl(f_10828)
static void C_ccall f_10828(C_word c,C_word *av) C_noret;
C_noret_decl(f_10832)
static void C_ccall f_10832(C_word c,C_word *av) C_noret;
C_noret_decl(f_10835)
static void C_ccall f_10835(C_word c,C_word *av) C_noret;
C_noret_decl(f_10846)
static void C_ccall f_10846(C_word c,C_word *av) C_noret;
C_noret_decl(f_10848)
static void C_ccall f_10848(C_word c,C_word *av) C_noret;
C_noret_decl(f_10855)
static void C_ccall f_10855(C_word c,C_word *av) C_noret;
C_noret_decl(f_10858)
static void C_ccall f_10858(C_word c,C_word *av) C_noret;
C_noret_decl(f_10861)
static void C_ccall f_10861(C_word c,C_word *av) C_noret;
C_noret_decl(f_10866)
static void C_ccall f_10866(C_word c,C_word *av) C_noret;
C_noret_decl(f_10870)
static void C_ccall f_10870(C_word c,C_word *av) C_noret;
C_noret_decl(f_10875)
static void C_ccall f_10875(C_word c,C_word *av) C_noret;
C_noret_decl(f_10879)
static void C_ccall f_10879(C_word c,C_word *av) C_noret;
C_noret_decl(f_10882)
static void C_ccall f_10882(C_word c,C_word *av) C_noret;
C_noret_decl(f_10910)
static void C_ccall f_10910(C_word c,C_word *av) C_noret;
C_noret_decl(f_10913)
static void C_ccall f_10913(C_word c,C_word *av) C_noret;
C_noret_decl(f_10916)
static void C_ccall f_10916(C_word c,C_word *av) C_noret;
C_noret_decl(f_10919)
static void C_ccall f_10919(C_word c,C_word *av) C_noret;
C_noret_decl(f_10936)
static void C_ccall f_10936(C_word c,C_word *av) C_noret;
C_noret_decl(f_10947)
static void C_ccall f_10947(C_word c,C_word *av) C_noret;
C_noret_decl(f_10959)
static void C_ccall f_10959(C_word c,C_word *av) C_noret;
C_noret_decl(f_10970)
static void C_ccall f_10970(C_word c,C_word *av) C_noret;
C_noret_decl(f_10981)
static void C_ccall f_10981(C_word c,C_word *av) C_noret;
C_noret_decl(f_10992)
static void C_ccall f_10992(C_word c,C_word *av) C_noret;
C_noret_decl(f_11003)
static void C_ccall f_11003(C_word c,C_word *av) C_noret;
C_noret_decl(f_11014)
static void C_ccall f_11014(C_word c,C_word *av) C_noret;
C_noret_decl(f_11025)
static void C_ccall f_11025(C_word c,C_word *av) C_noret;
C_noret_decl(f_11036)
static void C_ccall f_11036(C_word c,C_word *av) C_noret;
C_noret_decl(f_11047)
static void C_ccall f_11047(C_word c,C_word *av) C_noret;
C_noret_decl(f_11058)
static void C_ccall f_11058(C_word c,C_word *av) C_noret;
C_noret_decl(f_11069)
static void C_ccall f_11069(C_word c,C_word *av) C_noret;
C_noret_decl(f_11080)
static void C_ccall f_11080(C_word c,C_word *av) C_noret;
C_noret_decl(f_11091)
static void C_ccall f_11091(C_word c,C_word *av) C_noret;
C_noret_decl(f_11102)
static void C_ccall f_11102(C_word c,C_word *av) C_noret;
C_noret_decl(f_11119)
static void C_ccall f_11119(C_word c,C_word *av) C_noret;
C_noret_decl(f_11136)
static void C_ccall f_11136(C_word c,C_word *av) C_noret;
C_noret_decl(f_11160)
static void C_ccall f_11160(C_word c,C_word *av) C_noret;
C_noret_decl(f_11177)
static void C_ccall f_11177(C_word c,C_word *av) C_noret;
C_noret_decl(f_11181)
static void C_ccall f_11181(C_word c,C_word *av) C_noret;
C_noret_decl(f_11207)
static void C_ccall f_11207(C_word c,C_word *av) C_noret;
C_noret_decl(f_11227)
static void C_ccall f_11227(C_word c,C_word *av) C_noret;
C_noret_decl(f_11238)
static void C_ccall f_11238(C_word c,C_word *av) C_noret;
C_noret_decl(f_11250)
static void C_fcall f_11250(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11284)
static void C_ccall f_11284(C_word c,C_word *av) C_noret;
C_noret_decl(f_11299)
static void C_fcall f_11299(C_word t0,C_word t1) C_noret;
C_noret_decl(f_11366)
static void C_ccall f_11366(C_word c,C_word *av) C_noret;
C_noret_decl(f_11382)
static void C_ccall f_11382(C_word c,C_word *av) C_noret;
C_noret_decl(f_11398)
static void C_ccall f_11398(C_word c,C_word *av) C_noret;
C_noret_decl(f_11414)
static void C_ccall f_11414(C_word c,C_word *av) C_noret;
C_noret_decl(f_11430)
static void C_ccall f_11430(C_word c,C_word *av) C_noret;
C_noret_decl(f_11446)
static void C_ccall f_11446(C_word c,C_word *av) C_noret;
C_noret_decl(f_11462)
static void C_ccall f_11462(C_word c,C_word *av) C_noret;
C_noret_decl(f_11478)
static void C_ccall f_11478(C_word c,C_word *av) C_noret;
C_noret_decl(f_11494)
static void C_ccall f_11494(C_word c,C_word *av) C_noret;
C_noret_decl(f_11506)
static void C_fcall f_11506(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_11525)
static void C_fcall f_11525(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_11556)
static void C_ccall f_11556(C_word c,C_word *av) C_noret;
C_noret_decl(f_11573)
static void C_ccall f_11573(C_word c,C_word *av) C_noret;
C_noret_decl(f_11579)
static void C_fcall f_11579(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11603)
static void C_ccall f_11603(C_word c,C_word *av) C_noret;
C_noret_decl(f_11623)
static void C_ccall f_11623(C_word c,C_word *av) C_noret;
C_noret_decl(f_11627)
static void C_ccall f_11627(C_word c,C_word *av) C_noret;
C_noret_decl(f_11630)
static void C_ccall f_11630(C_word c,C_word *av) C_noret;
C_noret_decl(f_11659)
static void C_ccall f_11659(C_word c,C_word *av) C_noret;
C_noret_decl(f_11675)
static void C_fcall f_11675(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11697)
static void C_ccall f_11697(C_word c,C_word *av) C_noret;
C_noret_decl(f_11713)
static void C_ccall f_11713(C_word c,C_word *av) C_noret;
C_noret_decl(f_11718)
static C_word C_fcall f_11718(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_11749)
static void C_ccall f_11749(C_word c,C_word *av) C_noret;
C_noret_decl(f_11760)
static void C_ccall f_11760(C_word c,C_word *av) C_noret;
C_noret_decl(f_11769)
static C_word C_fcall f_11769(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_11798)
static void C_ccall f_11798(C_word c,C_word *av) C_noret;
C_noret_decl(f_11811)
static void C_ccall f_11811(C_word c,C_word *av) C_noret;
C_noret_decl(f_11821)
static void C_ccall f_11821(C_word c,C_word *av) C_noret;
C_noret_decl(f_11823)
static void C_ccall f_11823(C_word c,C_word *av) C_noret;
C_noret_decl(f_11830)
static void C_ccall f_11830(C_word c,C_word *av) C_noret;
C_noret_decl(f_11833)
static void C_fcall f_11833(C_word t0,C_word t1) C_noret;
C_noret_decl(f_11842)
static void C_fcall f_11842(C_word t0,C_word t1) C_noret;
C_noret_decl(f_11868)
static void C_ccall f_11868(C_word c,C_word *av) C_noret;
C_noret_decl(f_11873)
static void C_ccall f_11873(C_word c,C_word *av) C_noret;
C_noret_decl(f_11877)
static void C_ccall f_11877(C_word c,C_word *av) C_noret;
C_noret_decl(f_11882)
static void C_ccall f_11882(C_word c,C_word *av) C_noret;
C_noret_decl(f_11903)
static void C_ccall f_11903(C_word c,C_word *av) C_noret;
C_noret_decl(f_11909)
static void C_ccall f_11909(C_word c,C_word *av) C_noret;
C_noret_decl(f_11927)
static void C_ccall f_11927(C_word c,C_word *av) C_noret;
C_noret_decl(f_11933)
static void C_ccall f_11933(C_word c,C_word *av) C_noret;
C_noret_decl(f_11951)
static void C_ccall f_11951(C_word c,C_word *av) C_noret;
C_noret_decl(f_11957)
static void C_ccall f_11957(C_word c,C_word *av) C_noret;
C_noret_decl(f_11972)
static void C_ccall f_11972(C_word c,C_word *av) C_noret;
C_noret_decl(f_11978)
static void C_ccall f_11978(C_word c,C_word *av) C_noret;
C_noret_decl(f_11992)
static void C_ccall f_11992(C_word c,C_word *av) C_noret;
C_noret_decl(f_12013)
static void C_ccall f_12013(C_word c,C_word *av) C_noret;
C_noret_decl(f_12019)
static void C_ccall f_12019(C_word c,C_word *av) C_noret;
C_noret_decl(f_12037)
static void C_ccall f_12037(C_word c,C_word *av) C_noret;
C_noret_decl(f_12043)
static void C_ccall f_12043(C_word c,C_word *av) C_noret;
C_noret_decl(f_12061)
static void C_ccall f_12061(C_word c,C_word *av) C_noret;
C_noret_decl(f_12067)
static void C_ccall f_12067(C_word c,C_word *av) C_noret;
C_noret_decl(f_12082)
static void C_ccall f_12082(C_word c,C_word *av) C_noret;
C_noret_decl(f_12088)
static void C_ccall f_12088(C_word c,C_word *av) C_noret;
C_noret_decl(f_12103)
static void C_ccall f_12103(C_word c,C_word *av) C_noret;
C_noret_decl(f_12113)
static void C_ccall f_12113(C_word c,C_word *av) C_noret;
C_noret_decl(f_12119)
static void C_ccall f_12119(C_word c,C_word *av) C_noret;
C_noret_decl(f_12123)
static void C_ccall f_12123(C_word c,C_word *av) C_noret;
C_noret_decl(f_12125)
static void C_fcall f_12125(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_12136)
static void C_ccall f_12136(C_word c,C_word *av) C_noret;
C_noret_decl(f_12148)
static void C_ccall f_12148(C_word c,C_word *av) C_noret;
C_noret_decl(f_12158)
static void C_ccall f_12158(C_word c,C_word *av) C_noret;
C_noret_decl(f_12164)
static void C_ccall f_12164(C_word c,C_word *av) C_noret;
C_noret_decl(f_12168)
static void C_ccall f_12168(C_word c,C_word *av) C_noret;
C_noret_decl(f_12173)
static C_word C_fcall f_12173(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12199)
static void C_ccall f_12199(C_word c,C_word *av) C_noret;
C_noret_decl(f_12203)
static void C_ccall f_12203(C_word c,C_word *av) C_noret;
C_noret_decl(f_12206)
static void C_ccall f_12206(C_word c,C_word *av) C_noret;
C_noret_decl(f_12214)
static void C_fcall f_12214(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_12235)
static void C_fcall f_12235(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_12249)
static void C_ccall f_12249(C_word c,C_word *av) C_noret;
C_noret_decl(f_12253)
static void C_ccall f_12253(C_word c,C_word *av) C_noret;
C_noret_decl(f_12294)
static void C_ccall f_12294(C_word c,C_word *av) C_noret;
C_noret_decl(f_12316)
static void C_ccall f_12316(C_word c,C_word *av) C_noret;
C_noret_decl(f_12318)
static void C_ccall f_12318(C_word c,C_word *av) C_noret;
C_noret_decl(f_12340)
static void C_ccall f_12340(C_word c,C_word *av) C_noret;
C_noret_decl(f_12342)
static void C_ccall f_12342(C_word c,C_word *av) C_noret;
C_noret_decl(f_12364)
static void C_ccall f_12364(C_word c,C_word *av) C_noret;
C_noret_decl(f_12366)
static void C_ccall f_12366(C_word c,C_word *av) C_noret;
C_noret_decl(f_12388)
static void C_ccall f_12388(C_word c,C_word *av) C_noret;
C_noret_decl(f_12390)
static void C_ccall f_12390(C_word c,C_word *av) C_noret;
C_noret_decl(f_12394)
static void C_ccall f_12394(C_word c,C_word *av) C_noret;
C_noret_decl(f_12397)
static void C_fcall f_12397(C_word t0,C_word t1) C_noret;
C_noret_decl(f_12415)
static void C_ccall f_12415(C_word c,C_word *av) C_noret;
C_noret_decl(f_12437)
static void C_ccall f_12437(C_word c,C_word *av) C_noret;
C_noret_decl(f_12439)
static void C_ccall f_12439(C_word c,C_word *av) C_noret;
C_noret_decl(f_12461)
static void C_ccall f_12461(C_word c,C_word *av) C_noret;
C_noret_decl(f_12463)
static void C_ccall f_12463(C_word c,C_word *av) C_noret;
C_noret_decl(f_12485)
static void C_ccall f_12485(C_word c,C_word *av) C_noret;
C_noret_decl(f_12487)
static void C_ccall f_12487(C_word c,C_word *av) C_noret;
C_noret_decl(f_12509)
static void C_ccall f_12509(C_word c,C_word *av) C_noret;
C_noret_decl(f_12511)
static void C_ccall f_12511(C_word c,C_word *av) C_noret;
C_noret_decl(f_12533)
static void C_ccall f_12533(C_word c,C_word *av) C_noret;
C_noret_decl(f_12535)
static void C_ccall f_12535(C_word c,C_word *av) C_noret;
C_noret_decl(f_12557)
static void C_ccall f_12557(C_word c,C_word *av) C_noret;
C_noret_decl(f_12559)
static void C_ccall f_12559(C_word c,C_word *av) C_noret;
C_noret_decl(f_12581)
static void C_ccall f_12581(C_word c,C_word *av) C_noret;
C_noret_decl(f_12583)
static void C_ccall f_12583(C_word c,C_word *av) C_noret;
C_noret_decl(f_12599)
static void C_ccall f_12599(C_word c,C_word *av) C_noret;
C_noret_decl(f_12601)
static void C_ccall f_12601(C_word c,C_word *av) C_noret;
C_noret_decl(f_12623)
static void C_ccall f_12623(C_word c,C_word *av) C_noret;
C_noret_decl(f_12625)
static void C_ccall f_12625(C_word c,C_word *av) C_noret;
C_noret_decl(f_12647)
static void C_ccall f_12647(C_word c,C_word *av) C_noret;
C_noret_decl(f_12649)
static void C_ccall f_12649(C_word c,C_word *av) C_noret;
C_noret_decl(f_12665)
static void C_ccall f_12665(C_word c,C_word *av) C_noret;
C_noret_decl(f_12667)
static void C_ccall f_12667(C_word c,C_word *av) C_noret;
C_noret_decl(f_12683)
static void C_ccall f_12683(C_word c,C_word *av) C_noret;
C_noret_decl(f_12685)
static void C_ccall f_12685(C_word c,C_word *av) C_noret;
C_noret_decl(f_12701)
static void C_ccall f_12701(C_word c,C_word *av) C_noret;
C_noret_decl(f_12703)
static void C_ccall f_12703(C_word c,C_word *av) C_noret;
C_noret_decl(f_12719)
static void C_ccall f_12719(C_word c,C_word *av) C_noret;
C_noret_decl(f_12721)
static void C_ccall f_12721(C_word c,C_word *av) C_noret;
C_noret_decl(f_12737)
static void C_ccall f_12737(C_word c,C_word *av) C_noret;
C_noret_decl(f_12739)
static void C_ccall f_12739(C_word c,C_word *av) C_noret;
C_noret_decl(f_12755)
static void C_ccall f_12755(C_word c,C_word *av) C_noret;
C_noret_decl(f_12757)
static void C_ccall f_12757(C_word c,C_word *av) C_noret;
C_noret_decl(f_12773)
static void C_ccall f_12773(C_word c,C_word *av) C_noret;
C_noret_decl(f_12775)
static void C_ccall f_12775(C_word c,C_word *av) C_noret;
C_noret_decl(f_12791)
static void C_ccall f_12791(C_word c,C_word *av) C_noret;
C_noret_decl(f_12793)
static void C_ccall f_12793(C_word c,C_word *av) C_noret;
C_noret_decl(f_12809)
static void C_ccall f_12809(C_word c,C_word *av) C_noret;
C_noret_decl(f_12811)
static void C_ccall f_12811(C_word c,C_word *av) C_noret;
C_noret_decl(f_12827)
static void C_ccall f_12827(C_word c,C_word *av) C_noret;
C_noret_decl(f_12829)
static void C_ccall f_12829(C_word c,C_word *av) C_noret;
C_noret_decl(f_12851)
static void C_ccall f_12851(C_word c,C_word *av) C_noret;
C_noret_decl(f_12853)
static void C_ccall f_12853(C_word c,C_word *av) C_noret;
C_noret_decl(f_12869)
static void C_ccall f_12869(C_word c,C_word *av) C_noret;
C_noret_decl(f_12871)
static void C_ccall f_12871(C_word c,C_word *av) C_noret;
C_noret_decl(f_12887)
static void C_ccall f_12887(C_word c,C_word *av) C_noret;
C_noret_decl(f_12889)
static void C_ccall f_12889(C_word c,C_word *av) C_noret;
C_noret_decl(f_12905)
static void C_ccall f_12905(C_word c,C_word *av) C_noret;
C_noret_decl(f_12907)
static void C_ccall f_12907(C_word c,C_word *av) C_noret;
C_noret_decl(f_12923)
static void C_ccall f_12923(C_word c,C_word *av) C_noret;
C_noret_decl(f_12925)
static void C_ccall f_12925(C_word c,C_word *av) C_noret;
C_noret_decl(f_12941)
static void C_ccall f_12941(C_word c,C_word *av) C_noret;
C_noret_decl(f_12943)
static void C_ccall f_12943(C_word c,C_word *av) C_noret;
C_noret_decl(f_12959)
static void C_ccall f_12959(C_word c,C_word *av) C_noret;
C_noret_decl(f_12961)
static void C_ccall f_12961(C_word c,C_word *av) C_noret;
C_noret_decl(f_12977)
static void C_ccall f_12977(C_word c,C_word *av) C_noret;
C_noret_decl(f_12979)
static void C_ccall f_12979(C_word c,C_word *av) C_noret;
C_noret_decl(f_13001)
static void C_ccall f_13001(C_word c,C_word *av) C_noret;
C_noret_decl(f_13003)
static void C_ccall f_13003(C_word c,C_word *av) C_noret;
C_noret_decl(f_13019)
static void C_ccall f_13019(C_word c,C_word *av) C_noret;
C_noret_decl(f_13021)
static void C_ccall f_13021(C_word c,C_word *av) C_noret;
C_noret_decl(f_13037)
static void C_ccall f_13037(C_word c,C_word *av) C_noret;
C_noret_decl(f_13039)
static void C_ccall f_13039(C_word c,C_word *av) C_noret;
C_noret_decl(f_13055)
static void C_ccall f_13055(C_word c,C_word *av) C_noret;
C_noret_decl(f_13057)
static void C_ccall f_13057(C_word c,C_word *av) C_noret;
C_noret_decl(f_13073)
static void C_ccall f_13073(C_word c,C_word *av) C_noret;
C_noret_decl(f_13075)
static void C_ccall f_13075(C_word c,C_word *av) C_noret;
C_noret_decl(f_13085)
static void C_ccall f_13085(C_word c,C_word *av) C_noret;
C_noret_decl(f_13097)
static void C_fcall f_13097(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13107)
static void C_ccall f_13107(C_word c,C_word *av) C_noret;
C_noret_decl(f_13111)
static void C_ccall f_13111(C_word c,C_word *av) C_noret;
C_noret_decl(f_13133)
static void C_ccall f_13133(C_word c,C_word *av) C_noret;
C_noret_decl(f_13137)
static void C_ccall f_13137(C_word c,C_word *av) C_noret;
C_noret_decl(f_13140)
static void C_ccall f_13140(C_word c,C_word *av) C_noret;
C_noret_decl(f_13145)
static void C_ccall f_13145(C_word c,C_word *av) C_noret;
C_noret_decl(f_13149)
static void C_ccall f_13149(C_word c,C_word *av) C_noret;
C_noret_decl(f_13152)
static void C_ccall f_13152(C_word c,C_word *av) C_noret;
C_noret_decl(f_13155)
static void C_ccall f_13155(C_word c,C_word *av) C_noret;
C_noret_decl(f_13168)
static void C_ccall f_13168(C_word c,C_word *av) C_noret;
C_noret_decl(f_13191)
static void C_ccall f_13191(C_word c,C_word *av) C_noret;
C_noret_decl(f_13217)
static void C_ccall f_13217(C_word c,C_word *av) C_noret;
C_noret_decl(f_13226)
static void C_ccall f_13226(C_word c,C_word *av) C_noret;
C_noret_decl(f_13231)
static void C_ccall f_13231(C_word c,C_word *av) C_noret;
C_noret_decl(f_13233)
static void C_ccall f_13233(C_word c,C_word *av) C_noret;
C_noret_decl(f_13277)
static C_word C_fcall f_13277(C_word *a,C_word t0,C_word t1);
C_noret_decl(f_13323)
static void C_ccall f_13323(C_word c,C_word *av) C_noret;
C_noret_decl(f_13347)
static void C_ccall f_13347(C_word c,C_word *av) C_noret;
C_noret_decl(f_13351)
static void C_ccall f_13351(C_word c,C_word *av) C_noret;
C_noret_decl(f_13369)
static void C_ccall f_13369(C_word c,C_word *av) C_noret;
C_noret_decl(f_13393)
static void C_ccall f_13393(C_word c,C_word *av) C_noret;
C_noret_decl(f_13397)
static void C_ccall f_13397(C_word c,C_word *av) C_noret;
C_noret_decl(f_13415)
static void C_ccall f_13415(C_word c,C_word *av) C_noret;
C_noret_decl(f_13456)
static void C_fcall f_13456(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13467)
static void C_ccall f_13467(C_word c,C_word *av) C_noret;
C_noret_decl(f_13473)
static void C_fcall f_13473(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13477)
static void C_ccall f_13477(C_word c,C_word *av) C_noret;
C_noret_decl(f_13491)
static void C_ccall f_13491(C_word c,C_word *av) C_noret;
C_noret_decl(f_13504)
static void C_ccall f_13504(C_word c,C_word *av) C_noret;
C_noret_decl(f_13508)
static void C_ccall f_13508(C_word c,C_word *av) C_noret;
C_noret_decl(f_13525)
static void C_ccall f_13525(C_word c,C_word *av) C_noret;
C_noret_decl(f_13529)
static void C_ccall f_13529(C_word c,C_word *av) C_noret;
C_noret_decl(f_13535)
static void C_ccall f_13535(C_word c,C_word *av) C_noret;
C_noret_decl(f_13539)
static void C_ccall f_13539(C_word c,C_word *av) C_noret;
C_noret_decl(f_13579)
static void C_ccall f_13579(C_word c,C_word *av) C_noret;
C_noret_decl(f_13583)
static void C_ccall f_13583(C_word c,C_word *av) C_noret;
C_noret_decl(f_13605)
static void C_ccall f_13605(C_word c,C_word *av) C_noret;
C_noret_decl(f_13608)
static void C_ccall f_13608(C_word c,C_word *av) C_noret;
C_noret_decl(f_13611)
static void C_ccall f_13611(C_word c,C_word *av) C_noret;
C_noret_decl(f_13614)
static void C_ccall f_13614(C_word c,C_word *av) C_noret;
C_noret_decl(f_13617)
static void C_ccall f_13617(C_word c,C_word *av) C_noret;
C_noret_decl(f_13638)
static void C_ccall f_13638(C_word c,C_word *av) C_noret;
C_noret_decl(f_13640)
static void C_fcall f_13640(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13658)
static void C_ccall f_13658(C_word c,C_word *av) C_noret;
C_noret_decl(f_13668)
static void C_ccall f_13668(C_word c,C_word *av) C_noret;
C_noret_decl(f_13672)
static void C_ccall f_13672(C_word c,C_word *av) C_noret;
C_noret_decl(f_13710)
static void C_ccall f_13710(C_word c,C_word *av) C_noret;
C_noret_decl(f_13713)
static void C_ccall f_13713(C_word c,C_word *av) C_noret;
C_noret_decl(f_13716)
static void C_ccall f_13716(C_word c,C_word *av) C_noret;
C_noret_decl(f_13719)
static void C_ccall f_13719(C_word c,C_word *av) C_noret;
C_noret_decl(f_13725)
static void C_ccall f_13725(C_word c,C_word *av) C_noret;
C_noret_decl(f_13728)
static void C_ccall f_13728(C_word c,C_word *av) C_noret;
C_noret_decl(f_13776)
static void C_ccall f_13776(C_word c,C_word *av) C_noret;
C_noret_decl(f_13780)
static void C_ccall f_13780(C_word c,C_word *av) C_noret;
C_noret_decl(f_13857)
static void C_ccall f_13857(C_word c,C_word *av) C_noret;
C_noret_decl(f_13896)
static void C_ccall f_13896(C_word c,C_word *av) C_noret;
C_noret_decl(f_13951)
static void C_ccall f_13951(C_word c,C_word *av) C_noret;
C_noret_decl(f_13996)
static void C_ccall f_13996(C_word c,C_word *av) C_noret;
C_noret_decl(f_14041)
static void C_ccall f_14041(C_word c,C_word *av) C_noret;
C_noret_decl(f_14078)
static void C_ccall f_14078(C_word c,C_word *av) C_noret;
C_noret_decl(f_14098)
static void C_ccall f_14098(C_word c,C_word *av) C_noret;
C_noret_decl(f_14122)
static void C_fcall f_14122(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_14125)
static void C_fcall f_14125(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_14129)
static void C_ccall f_14129(C_word c,C_word *av) C_noret;
C_noret_decl(f_14132)
static void C_ccall f_14132(C_word c,C_word *av) C_noret;
C_noret_decl(f_14150)
static void C_ccall f_14150(C_word c,C_word *av) C_noret;
C_noret_decl(f_14173)
static void C_ccall f_14173(C_word c,C_word *av) C_noret;
C_noret_decl(f_14177)
static void C_ccall f_14177(C_word c,C_word *av) C_noret;
C_noret_decl(f_14200)
static void C_ccall f_14200(C_word c,C_word *av) C_noret;
C_noret_decl(f_14204)
static void C_ccall f_14204(C_word c,C_word *av) C_noret;
C_noret_decl(f_14236)
static void C_ccall f_14236(C_word c,C_word *av) C_noret;
C_noret_decl(f_14272)
static void C_ccall f_14272(C_word c,C_word *av) C_noret;
C_noret_decl(f_14276)
static void C_ccall f_14276(C_word c,C_word *av) C_noret;
C_noret_decl(f_14295)
static void C_ccall f_14295(C_word c,C_word *av) C_noret;
C_noret_decl(f_14297)
static void C_ccall f_14297(C_word c,C_word *av) C_noret;
C_noret_decl(f_14304)
static void C_fcall f_14304(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_14341)
static void C_ccall f_14341(C_word c,C_word *av) C_noret;
C_noret_decl(f_14348)
static void C_fcall f_14348(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_14385)
static void C_ccall f_14385(C_word c,C_word *av) C_noret;
C_noret_decl(f_14403)
static void C_ccall f_14403(C_word c,C_word *av) C_noret;
C_noret_decl(f_14412)
static void C_ccall f_14412(C_word c,C_word *av) C_noret;
C_noret_decl(f_14417)
static void C_ccall f_14417(C_word c,C_word *av) C_noret;
C_noret_decl(f_14430)
static void C_ccall f_14430(C_word c,C_word *av) C_noret;
C_noret_decl(f_14456)
static void C_ccall f_14456(C_word c,C_word *av) C_noret;
C_noret_decl(f_14464)
static void C_ccall f_14464(C_word c,C_word *av) C_noret;
C_noret_decl(f_14468)
static void C_ccall f_14468(C_word c,C_word *av) C_noret;
C_noret_decl(f_14472)
static void C_ccall f_14472(C_word c,C_word *av) C_noret;
C_noret_decl(f_14476)
static void C_ccall f_14476(C_word c,C_word *av) C_noret;
C_noret_decl(f_14479)
static void C_ccall f_14479(C_word c,C_word *av) C_noret;
C_noret_decl(f_14493)
static void C_ccall f_14493(C_word c,C_word *av) C_noret;
C_noret_decl(f_14497)
static void C_ccall f_14497(C_word c,C_word *av) C_noret;
C_noret_decl(f_14508)
static void C_ccall f_14508(C_word c,C_word *av) C_noret;
C_noret_decl(f_14532)
static void C_ccall f_14532(C_word c,C_word *av) C_noret;
C_noret_decl(f_14536)
static void C_ccall f_14536(C_word c,C_word *av) C_noret;
C_noret_decl(f_14542)
static void C_ccall f_14542(C_word c,C_word *av) C_noret;
C_noret_decl(f_14566)
static void C_ccall f_14566(C_word c,C_word *av) C_noret;
C_noret_decl(f_14570)
static void C_ccall f_14570(C_word c,C_word *av) C_noret;
C_noret_decl(f_14576)
static void C_ccall f_14576(C_word c,C_word *av) C_noret;
C_noret_decl(f_14593)
static void C_ccall f_14593(C_word c,C_word *av) C_noret;
C_noret_decl(f_14597)
static void C_ccall f_14597(C_word c,C_word *av) C_noret;
C_noret_decl(f_14601)
static void C_ccall f_14601(C_word c,C_word *av) C_noret;
C_noret_decl(f_14611)
static void C_fcall f_14611(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14617)
static void C_fcall f_14617(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14624)
static void C_ccall f_14624(C_word c,C_word *av) C_noret;
C_noret_decl(f_14636)
static void C_ccall f_14636(C_word c,C_word *av) C_noret;
C_noret_decl(f_14659)
static void C_ccall f_14659(C_word c,C_word *av) C_noret;
C_noret_decl(f_14663)
static void C_ccall f_14663(C_word c,C_word *av) C_noret;
C_noret_decl(f_14673)
static void C_fcall f_14673(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14679)
static void C_fcall f_14679(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14686)
static void C_ccall f_14686(C_word c,C_word *av) C_noret;
C_noret_decl(f_14701)
static void C_ccall f_14701(C_word c,C_word *av) C_noret;
C_noret_decl(f_14705)
static void C_ccall f_14705(C_word c,C_word *av) C_noret;
C_noret_decl(f_14738)
static void C_ccall f_14738(C_word c,C_word *av) C_noret;
C_noret_decl(f_14742)
static void C_ccall f_14742(C_word c,C_word *av) C_noret;
C_noret_decl(f_14759)
static void C_ccall f_14759(C_word c,C_word *av) C_noret;
C_noret_decl(f_14769)
static void C_ccall f_14769(C_word c,C_word *av) C_noret;
C_noret_decl(f_14842)
static void C_ccall f_14842(C_word c,C_word *av) C_noret;
C_noret_decl(f_14856)
static void C_ccall f_14856(C_word c,C_word *av) C_noret;
C_noret_decl(f_14873)
static void C_ccall f_14873(C_word c,C_word *av) C_noret;
C_noret_decl(f_14889)
static void C_ccall f_14889(C_word c,C_word *av) C_noret;
C_noret_decl(f_14960)
static void C_ccall f_14960(C_word c,C_word *av) C_noret;
C_noret_decl(f_14964)
static void C_ccall f_14964(C_word c,C_word *av) C_noret;
C_noret_decl(f_14969)
static void C_ccall f_14969(C_word c,C_word *av) C_noret;
C_noret_decl(f_14979)
static void C_ccall f_14979(C_word c,C_word *av) C_noret;
C_noret_decl(f_14983)
static void C_ccall f_14983(C_word c,C_word *av) C_noret;
C_noret_decl(f_14998)
static void C_ccall f_14998(C_word c,C_word *av) C_noret;
C_noret_decl(f_15002)
static void C_ccall f_15002(C_word c,C_word *av) C_noret;
C_noret_decl(f_15019)
static void C_ccall f_15019(C_word c,C_word *av) C_noret;
C_noret_decl(f_15030)
static void C_ccall f_15030(C_word c,C_word *av) C_noret;
C_noret_decl(f_15036)
static void C_ccall f_15036(C_word c,C_word *av) C_noret;
C_noret_decl(f_15047)
static void C_ccall f_15047(C_word c,C_word *av) C_noret;
C_noret_decl(f_15058)
static void C_ccall f_15058(C_word c,C_word *av) C_noret;
C_noret_decl(f_15070)
static void C_ccall f_15070(C_word c,C_word *av) C_noret;
C_noret_decl(f_15082)
static void C_ccall f_15082(C_word c,C_word *av) C_noret;
C_noret_decl(f_15094)
static void C_ccall f_15094(C_word c,C_word *av) C_noret;
C_noret_decl(f_15111)
static void C_ccall f_15111(C_word c,C_word *av) C_noret;
C_noret_decl(f_15118)
static void C_ccall f_15118(C_word c,C_word *av) C_noret;
C_noret_decl(f_15122)
static void C_ccall f_15122(C_word c,C_word *av) C_noret;
C_noret_decl(f_15124)
static void C_ccall f_15124(C_word c,C_word *av) C_noret;
C_noret_decl(f_15130)
static void C_ccall f_15130(C_word c,C_word *av) C_noret;
C_noret_decl(f_15134)
static void C_ccall f_15134(C_word c,C_word *av) C_noret;
C_noret_decl(f_15137)
static void C_ccall f_15137(C_word c,C_word *av) C_noret;
C_noret_decl(f_15142)
static void C_ccall f_15142(C_word c,C_word *av) C_noret;
C_noret_decl(f_15152)
static void C_fcall f_15152(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15172)
static void C_ccall f_15172(C_word c,C_word *av) C_noret;
C_noret_decl(f_15187)
static void C_fcall f_15187(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15217)
static void C_ccall f_15217(C_word c,C_word *av) C_noret;
C_noret_decl(f_15228)
static void C_ccall f_15228(C_word c,C_word *av) C_noret;
C_noret_decl(f_15244)
static void C_ccall f_15244(C_word c,C_word *av) C_noret;
C_noret_decl(f_15248)
static void C_ccall f_15248(C_word c,C_word *av) C_noret;
C_noret_decl(f_15252)
static void C_ccall f_15252(C_word c,C_word *av) C_noret;
C_noret_decl(f_15268)
static void C_ccall f_15268(C_word c,C_word *av) C_noret;
C_noret_decl(f_15286)
static void C_ccall f_15286(C_word c,C_word *av) C_noret;
C_noret_decl(f_15297)
static void C_fcall f_15297(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15319)
static void C_ccall f_15319(C_word c,C_word *av) C_noret;
C_noret_decl(f_15336)
static void C_ccall f_15336(C_word c,C_word *av) C_noret;
C_noret_decl(f_15339)
static void C_fcall f_15339(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15351)
static void C_ccall f_15351(C_word c,C_word *av) C_noret;
C_noret_decl(f_15353)
static void C_fcall f_15353(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_15374)
static void C_ccall f_15374(C_word c,C_word *av) C_noret;
C_noret_decl(f_15405)
static void C_ccall f_15405(C_word c,C_word *av) C_noret;
C_noret_decl(f_15409)
static void C_ccall f_15409(C_word c,C_word *av) C_noret;
C_noret_decl(f_15444)
static void C_ccall f_15444(C_word c,C_word *av) C_noret;
C_noret_decl(f_15451)
static void C_ccall f_15451(C_word c,C_word *av) C_noret;
C_noret_decl(f_15463)
static void C_ccall f_15463(C_word c,C_word *av) C_noret;
C_noret_decl(f_15483)
static void C_ccall f_15483(C_word c,C_word *av) C_noret;
C_noret_decl(f_15487)
static void C_ccall f_15487(C_word c,C_word *av) C_noret;
C_noret_decl(f_15507)
static void C_fcall f_15507(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15527)
static void C_ccall f_15527(C_word c,C_word *av) C_noret;
C_noret_decl(f_15531)
static void C_ccall f_15531(C_word c,C_word *av) C_noret;
C_noret_decl(f_15535)
static void C_ccall f_15535(C_word c,C_word *av) C_noret;
C_noret_decl(f_15542)
static void C_ccall f_15542(C_word c,C_word *av) C_noret;
C_noret_decl(f_15558)
static void C_ccall f_15558(C_word c,C_word *av) C_noret;
C_noret_decl(f_15562)
static void C_ccall f_15562(C_word c,C_word *av) C_noret;
C_noret_decl(f_15603)
static void C_fcall f_15603(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15636)
static void C_ccall f_15636(C_word c,C_word *av) C_noret;
C_noret_decl(f_15665)
static void C_ccall f_15665(C_word c,C_word *av) C_noret;
C_noret_decl(f_15673)
static void C_ccall f_15673(C_word c,C_word *av) C_noret;
C_noret_decl(f_15679)
static void C_ccall f_15679(C_word c,C_word *av) C_noret;
C_noret_decl(f_15699)
static void C_fcall f_15699(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15724)
static void C_ccall f_15724(C_word c,C_word *av) C_noret;
C_noret_decl(f_15730)
static void C_ccall f_15730(C_word c,C_word *av) C_noret;
C_noret_decl(f_15734)
static void C_ccall f_15734(C_word c,C_word *av) C_noret;
C_noret_decl(f_15744)
static void C_ccall f_15744(C_word c,C_word *av) C_noret;
C_noret_decl(f_15764)
static void C_fcall f_15764(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15785)
static void C_ccall f_15785(C_word c,C_word *av) C_noret;
C_noret_decl(f_15802)
static void C_ccall f_15802(C_word c,C_word *av) C_noret;
C_noret_decl(f_15809)
static void C_ccall f_15809(C_word c,C_word *av) C_noret;
C_noret_decl(f_15814)
static void C_ccall f_15814(C_word c,C_word *av) C_noret;
C_noret_decl(f_15820)
static void C_ccall f_15820(C_word c,C_word *av) C_noret;
C_noret_decl(f_15824)
static void C_ccall f_15824(C_word c,C_word *av) C_noret;
C_noret_decl(f_15827)
static void C_ccall f_15827(C_word c,C_word *av) C_noret;
C_noret_decl(f_15834)
static void C_ccall f_15834(C_word c,C_word *av) C_noret;
C_noret_decl(f_15855)
static void C_ccall f_15855(C_word c,C_word *av) C_noret;
C_noret_decl(f_15869)
static void C_ccall f_15869(C_word c,C_word *av) C_noret;
C_noret_decl(f_15873)
static void C_ccall f_15873(C_word c,C_word *av) C_noret;
C_noret_decl(f_15910)
static void C_ccall f_15910(C_word c,C_word *av) C_noret;
C_noret_decl(f_15918)
static void C_ccall f_15918(C_word c,C_word *av) C_noret;
C_noret_decl(f_15947)
static void C_ccall f_15947(C_word c,C_word *av) C_noret;
C_noret_decl(f_15950)
static void C_ccall f_15950(C_word c,C_word *av) C_noret;
C_noret_decl(f_15965)
static void C_ccall f_15965(C_word c,C_word *av) C_noret;
C_noret_decl(f_15968)
static void C_fcall f_15968(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15975)
static void C_ccall f_15975(C_word c,C_word *av) C_noret;
C_noret_decl(f_15986)
static void C_ccall f_15986(C_word c,C_word *av) C_noret;
C_noret_decl(f_16004)
static void C_ccall f_16004(C_word c,C_word *av) C_noret;
C_noret_decl(f_16029)
static void C_fcall f_16029(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_16044)
static void C_ccall f_16044(C_word c,C_word *av) C_noret;
C_noret_decl(f_16072)
static void C_fcall f_16072(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_16076)
static C_word C_fcall f_16076(C_word t0,C_word t1);
C_noret_decl(f_16090)
static void C_fcall f_16090(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_16150)
static void C_ccall f_16150(C_word c,C_word *av) C_noret;
C_noret_decl(f_16170)
static void C_fcall f_16170(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_16176)
static void C_fcall f_16176(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_16239)
static void C_fcall f_16239(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16278)
static void C_fcall f_16278(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_16284)
static void C_fcall f_16284(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_16328)
static void C_fcall f_16328(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_16332)
static void C_ccall f_16332(C_word c,C_word *av) C_noret;
C_noret_decl(f_16335)
static void C_ccall f_16335(C_word c,C_word *av) C_noret;
C_noret_decl(f_16384)
static void C_fcall f_16384(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_16399)
static void C_fcall f_16399(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16408)
static void C_ccall f_16408(C_word c,C_word *av) C_noret;
C_noret_decl(f_16442)
static void C_fcall f_16442(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_16452)
static void C_ccall f_16452(C_word c,C_word *av) C_noret;
C_noret_decl(f_16461)
static void C_fcall f_16461(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16473)
static void C_fcall f_16473(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16482)
static void C_ccall f_16482(C_word c,C_word *av) C_noret;
C_noret_decl(f_16494)
static void C_ccall f_16494(C_word c,C_word *av) C_noret;
C_noret_decl(f_16500)
static void C_fcall f_16500(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16506)
static void C_ccall f_16506(C_word c,C_word *av) C_noret;
C_noret_decl(f_16548)
static void C_ccall f_16548(C_word c,C_word *av) C_noret;
C_noret_decl(f_16656)
static void C_fcall f_16656(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_16663)
static void C_fcall f_16663(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16676)
static void C_ccall f_16676(C_word c,C_word *av) C_noret;
C_noret_decl(f_16734)
static void C_fcall f_16734(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16752)
static void C_ccall f_16752(C_word c,C_word *av) C_noret;
C_noret_decl(f_16762)
static void C_ccall f_16762(C_word c,C_word *av) C_noret;
C_noret_decl(f_16798)
static void C_ccall f_16798(C_word c,C_word *av) C_noret;
C_noret_decl(f_16824)
static void C_ccall f_16824(C_word c,C_word *av) C_noret;
C_noret_decl(f_16835)
static void C_ccall f_16835(C_word c,C_word *av) C_noret;
C_noret_decl(f_17002)
static void C_fcall f_17002(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_17017)
static void C_fcall f_17017(C_word t0,C_word t1) C_noret;
C_noret_decl(f_17075)
static void C_fcall f_17075(C_word t0,C_word t1) C_noret;
C_noret_decl(f_17116)
static void C_ccall f_17116(C_word c,C_word *av) C_noret;
C_noret_decl(f_17194)
static void C_ccall f_17194(C_word c,C_word *av) C_noret;
C_noret_decl(f_17242)
static void C_ccall f_17242(C_word c,C_word *av) C_noret;
C_noret_decl(f_17245)
static void C_ccall f_17245(C_word c,C_word *av) C_noret;
C_noret_decl(f_17257)
static void C_ccall f_17257(C_word c,C_word *av) C_noret;
C_noret_decl(f_17344)
static void C_ccall f_17344(C_word c,C_word *av) C_noret;
C_noret_decl(f_17412)
static void C_ccall f_17412(C_word c,C_word *av) C_noret;
C_noret_decl(f_17492)
static void C_ccall f_17492(C_word c,C_word *av) C_noret;
C_noret_decl(f_17502)
static void C_ccall f_17502(C_word c,C_word *av) C_noret;
C_noret_decl(f_17511)
static void C_fcall f_17511(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_17747)
static void C_ccall f_17747(C_word c,C_word *av) C_noret;
C_noret_decl(f_17793)
static void C_ccall f_17793(C_word c,C_word *av) C_noret;
C_noret_decl(f_17796)
static void C_fcall f_17796(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_17823)
static void C_fcall f_17823(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_17847)
static void C_ccall f_17847(C_word c,C_word *av) C_noret;
C_noret_decl(f_17864)
static void C_fcall f_17864(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_17965)
static void C_ccall f_17965(C_word c,C_word *av) C_noret;
C_noret_decl(f_17968)
static void C_ccall f_17968(C_word c,C_word *av) C_noret;
C_noret_decl(f_17977)
static void C_ccall f_17977(C_word c,C_word *av) C_noret;
C_noret_decl(f_17983)
static void C_ccall f_17983(C_word c,C_word *av) C_noret;
C_noret_decl(f_17994)
static void C_ccall f_17994(C_word c,C_word *av) C_noret;
C_noret_decl(f_17996)
static void C_ccall f_17996(C_word c,C_word *av) C_noret;
C_noret_decl(f_18007)
static void C_ccall f_18007(C_word c,C_word *av) C_noret;
C_noret_decl(f_18009)
static void C_ccall f_18009(C_word c,C_word *av) C_noret;
C_noret_decl(f_18020)
static void C_ccall f_18020(C_word c,C_word *av) C_noret;
C_noret_decl(f_18022)
static void C_ccall f_18022(C_word c,C_word *av) C_noret;
C_noret_decl(f_18039)
static void C_ccall f_18039(C_word c,C_word *av) C_noret;
C_noret_decl(f_18043)
static void C_ccall f_18043(C_word c,C_word *av) C_noret;
C_noret_decl(f_18047)
static void C_ccall f_18047(C_word c,C_word *av) C_noret;
C_noret_decl(f_18056)
static void C_ccall f_18056(C_word c,C_word *av) C_noret;
C_noret_decl(f_18076)
static void C_ccall f_18076(C_word c,C_word *av) C_noret;
C_noret_decl(f_18084)
static void C_ccall f_18084(C_word c,C_word *av) C_noret;
C_noret_decl(f_18099)
static void C_ccall f_18099(C_word c,C_word *av) C_noret;
C_noret_decl(f_18101)
static void C_fcall f_18101(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18126)
static void C_ccall f_18126(C_word c,C_word *av) C_noret;
C_noret_decl(f_18135)
static void C_ccall f_18135(C_word c,C_word *av) C_noret;
C_noret_decl(f_18138)
static void C_ccall f_18138(C_word c,C_word *av) C_noret;
C_noret_decl(f_18147)
static void C_ccall f_18147(C_word c,C_word *av) C_noret;
C_noret_decl(f_18154)
static void C_ccall f_18154(C_word c,C_word *av) C_noret;
C_noret_decl(f_18165)
static void C_ccall f_18165(C_word c,C_word *av) C_noret;
C_noret_decl(f_18172)
static void C_ccall f_18172(C_word c,C_word *av) C_noret;
C_noret_decl(f_18196)
static void C_ccall f_18196(C_word c,C_word *av) C_noret;
C_noret_decl(f_18200)
static void C_ccall f_18200(C_word c,C_word *av) C_noret;
C_noret_decl(f_18202)
static void C_ccall f_18202(C_word c,C_word *av) C_noret;
C_noret_decl(f_18206)
static void C_ccall f_18206(C_word c,C_word *av) C_noret;
C_noret_decl(f_18211)
static void C_ccall f_18211(C_word c,C_word *av) C_noret;
C_noret_decl(f_18217)
static void C_ccall f_18217(C_word c,C_word *av) C_noret;
C_noret_decl(f_18221)
static void C_ccall f_18221(C_word c,C_word *av) C_noret;
C_noret_decl(f_18226)
static void C_ccall f_18226(C_word c,C_word *av) C_noret;
C_noret_decl(f_18236)
static void C_ccall f_18236(C_word c,C_word *av) C_noret;
C_noret_decl(f_18238)
static void C_ccall f_18238(C_word c,C_word *av) C_noret;
C_noret_decl(f_18242)
static void C_ccall f_18242(C_word c,C_word *av) C_noret;
C_noret_decl(f_18248)
static void C_ccall f_18248(C_word c,C_word *av) C_noret;
C_noret_decl(f_18250)
static void C_ccall f_18250(C_word c,C_word *av) C_noret;
C_noret_decl(f_18254)
static void C_ccall f_18254(C_word c,C_word *av) C_noret;
C_noret_decl(f_18257)
static void C_ccall f_18257(C_word c,C_word *av) C_noret;
C_noret_decl(f_18273)
static void C_ccall f_18273(C_word c,C_word *av) C_noret;
C_noret_decl(f_18277)
static void C_ccall f_18277(C_word c,C_word *av) C_noret;
C_noret_decl(f_18280)
static void C_ccall f_18280(C_word c,C_word *av) C_noret;
C_noret_decl(f_18302)
static void C_ccall f_18302(C_word c,C_word *av) C_noret;
C_noret_decl(f_18318)
static void C_ccall f_18318(C_word c,C_word *av) C_noret;
C_noret_decl(f_18323)
static C_word C_fcall f_18323(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_18354)
static void C_ccall f_18354(C_word c,C_word *av) C_noret;
C_noret_decl(f_18363)
static void C_fcall f_18363(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18381)
static void C_ccall f_18381(C_word c,C_word *av) C_noret;
C_noret_decl(f_18387)
static void C_ccall f_18387(C_word c,C_word *av) C_noret;
C_noret_decl(f_18393)
static void C_ccall f_18393(C_word c,C_word *av) C_noret;
C_noret_decl(f_18402)
static C_word C_fcall f_18402(C_word t0,C_word t1);
C_noret_decl(f_18421)
static void C_ccall f_18421(C_word c,C_word *av) C_noret;
C_noret_decl(f_18440)
static void C_ccall f_18440(C_word c,C_word *av) C_noret;
C_noret_decl(f_18443)
static void C_ccall f_18443(C_word c,C_word *av) C_noret;
C_noret_decl(f_18448)
static C_word C_fcall f_18448(C_word t0,C_word t1);
C_noret_decl(f_18490)
static void C_ccall f_18490(C_word c,C_word *av) C_noret;
C_noret_decl(f_18509)
static void C_ccall f_18509(C_word c,C_word *av) C_noret;
C_noret_decl(f_18512)
static void C_ccall f_18512(C_word c,C_word *av) C_noret;
C_noret_decl(f_18515)
static void C_ccall f_18515(C_word c,C_word *av) C_noret;
C_noret_decl(f_18520)
static C_word C_fcall f_18520(C_word t0,C_word t1);
C_noret_decl(f_18561)
static void C_ccall f_18561(C_word c,C_word *av) C_noret;
C_noret_decl(f_18571)
static void C_ccall f_18571(C_word c,C_word *av) C_noret;
C_noret_decl(f_18582)
static void C_fcall f_18582(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_18586)
static void C_ccall f_18586(C_word c,C_word *av) C_noret;
C_noret_decl(f_18589)
static void C_ccall f_18589(C_word c,C_word *av) C_noret;
C_noret_decl(f_18594)
static C_word C_fcall f_18594(C_word t0,C_word t1);
C_noret_decl(f_18621)
static void C_ccall f_18621(C_word c,C_word *av) C_noret;
C_noret_decl(f_18635)
static void C_ccall f_18635(C_word c,C_word *av) C_noret;
C_noret_decl(f_18646)
static void C_ccall f_18646(C_word c,C_word *av) C_noret;
C_noret_decl(f_18657)
static void C_ccall f_18657(C_word c,C_word *av) C_noret;
C_noret_decl(f_18668)
static void C_ccall f_18668(C_word c,C_word *av) C_noret;
C_noret_decl(f_18681)
static void C_ccall f_18681(C_word c,C_word *av) C_noret;
C_noret_decl(f_18683)
static void C_fcall f_18683(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18696)
static C_word C_fcall f_18696(C_word t0,C_word t1);
C_noret_decl(f_18724)
static void C_ccall f_18724(C_word c,C_word *av) C_noret;
C_noret_decl(f_18737)
static void C_ccall f_18737(C_word c,C_word *av) C_noret;
C_noret_decl(f_18755)
static void C_ccall f_18755(C_word c,C_word *av) C_noret;
C_noret_decl(f_18758)
static void C_ccall f_18758(C_word c,C_word *av) C_noret;
C_noret_decl(f_18841)
static void C_ccall f_18841(C_word c,C_word *av) C_noret;
C_noret_decl(f_18844)
static void C_ccall f_18844(C_word c,C_word *av) C_noret;
C_noret_decl(f_18847)
static void C_ccall f_18847(C_word c,C_word *av) C_noret;
C_noret_decl(f_18850)
static void C_ccall f_18850(C_word c,C_word *av) C_noret;
C_noret_decl(f_18853)
static void C_ccall f_18853(C_word c,C_word *av) C_noret;
C_noret_decl(f_18856)
static void C_ccall f_18856(C_word c,C_word *av) C_noret;
C_noret_decl(f_18859)
static void C_ccall f_18859(C_word c,C_word *av) C_noret;
C_noret_decl(f_18862)
static void C_ccall f_18862(C_word c,C_word *av) C_noret;
C_noret_decl(f_18865)
static void C_ccall f_18865(C_word c,C_word *av) C_noret;
C_noret_decl(f_18868)
static void C_ccall f_18868(C_word c,C_word *av) C_noret;
C_noret_decl(f_18871)
static void C_ccall f_18871(C_word c,C_word *av) C_noret;
C_noret_decl(f_18874)
static void C_ccall f_18874(C_word c,C_word *av) C_noret;
C_noret_decl(f_18877)
static void C_ccall f_18877(C_word c,C_word *av) C_noret;
C_noret_decl(f_18880)
static void C_ccall f_18880(C_word c,C_word *av) C_noret;
C_noret_decl(f_18885)
static void C_ccall f_18885(C_word c,C_word *av) C_noret;
C_noret_decl(f_18891)
static void C_fcall f_18891(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18907)
static void C_ccall f_18907(C_word c,C_word *av) C_noret;
C_noret_decl(f_18923)
static void C_ccall f_18923(C_word c,C_word *av) C_noret;
C_noret_decl(f_18929)
static void C_fcall f_18929(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18949)
static void C_ccall f_18949(C_word c,C_word *av) C_noret;
C_noret_decl(f_18953)
static void C_ccall f_18953(C_word c,C_word *av) C_noret;
C_noret_decl(f_18965)
static void C_ccall f_18965(C_word c,C_word *av) C_noret;
C_noret_decl(f_18971)
static void C_ccall f_18971(C_word c,C_word *av) C_noret;
C_noret_decl(f_18977)
static void C_fcall f_18977(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19009)
static void C_ccall f_19009(C_word c,C_word *av) C_noret;
C_noret_decl(f_19013)
static void C_ccall f_19013(C_word c,C_word *av) C_noret;
C_noret_decl(f_19023)
static void C_ccall f_19023(C_word c,C_word *av) C_noret;
C_noret_decl(f_19038)
static void C_fcall f_19038(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19048)
static void C_ccall f_19048(C_word c,C_word *av) C_noret;
C_noret_decl(f_19068)
static void C_fcall f_19068(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19075)
static void C_ccall f_19075(C_word c,C_word *av) C_noret;
C_noret_decl(f_19084)
static void C_ccall f_19084(C_word c,C_word *av) C_noret;
C_noret_decl(f_19091)
static void C_ccall f_19091(C_word c,C_word *av) C_noret;
C_noret_decl(f_19093)
static void C_ccall f_19093(C_word c,C_word *av) C_noret;
C_noret_decl(f_19099)
static void C_ccall f_19099(C_word c,C_word *av) C_noret;
C_noret_decl(f_19105)
static void C_ccall f_19105(C_word c,C_word *av) C_noret;
C_noret_decl(f_19123)
static void C_fcall f_19123(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19148)
static void C_ccall f_19148(C_word c,C_word *av) C_noret;
C_noret_decl(f_19164)
static void C_fcall f_19164(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19171)
static void C_ccall f_19171(C_word c,C_word *av) C_noret;
C_noret_decl(f_19184)
static void C_ccall f_19184(C_word c,C_word *av) C_noret;
C_noret_decl(f_19188)
static void C_ccall f_19188(C_word c,C_word *av) C_noret;
C_noret_decl(f_19192)
static void C_ccall f_19192(C_word c,C_word *av) C_noret;
C_noret_decl(f_19194)
static void C_ccall f_19194(C_word c,C_word *av) C_noret;
C_noret_decl(f_19200)
static void C_ccall f_19200(C_word c,C_word *av) C_noret;
C_noret_decl(f_19207)
static void C_ccall f_19207(C_word c,C_word *av) C_noret;
C_noret_decl(f_19211)
static void C_ccall f_19211(C_word c,C_word *av) C_noret;
C_noret_decl(f_19220)
static void C_ccall f_19220(C_word c,C_word *av) C_noret;
C_noret_decl(f_19228)
static void C_ccall f_19228(C_word c,C_word *av) C_noret;
C_noret_decl(f_19238)
static void C_ccall f_19238(C_word c,C_word *av) C_noret;
C_noret_decl(f_19244)
static void C_ccall f_19244(C_word c,C_word *av) C_noret;
C_noret_decl(f_19247)
static void C_ccall f_19247(C_word c,C_word *av) C_noret;
C_noret_decl(f_19251)
static void C_ccall f_19251(C_word c,C_word *av) C_noret;
C_noret_decl(f_19278)
static void C_fcall f_19278(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19294)
static void C_ccall f_19294(C_word c,C_word *av) C_noret;
C_noret_decl(f_19300)
static void C_ccall f_19300(C_word c,C_word *av) C_noret;
C_noret_decl(f_19323)
static void C_ccall f_19323(C_word c,C_word *av) C_noret;
C_noret_decl(f_19336)
static void C_ccall f_19336(C_word c,C_word *av) C_noret;
C_noret_decl(f_19342)
static void C_ccall f_19342(C_word c,C_word *av) C_noret;
C_noret_decl(f_19347)
static void C_ccall f_19347(C_word c,C_word *av) C_noret;
C_noret_decl(f_19352)
static void C_ccall f_19352(C_word c,C_word *av) C_noret;
C_noret_decl(f_19356)
static void C_ccall f_19356(C_word c,C_word *av) C_noret;
C_noret_decl(f_19365)
static void C_ccall f_19365(C_word c,C_word *av) C_noret;
C_noret_decl(f_19396)
static void C_ccall f_19396(C_word c,C_word *av) C_noret;
C_noret_decl(f_19400)
static void C_ccall f_19400(C_word c,C_word *av) C_noret;
C_noret_decl(f_19404)
static void C_ccall f_19404(C_word c,C_word *av) C_noret;
C_noret_decl(f_19407)
static void C_ccall f_19407(C_word c,C_word *av) C_noret;
C_noret_decl(f_19410)
static void C_ccall f_19410(C_word c,C_word *av) C_noret;
C_noret_decl(f_19413)
static void C_ccall f_19413(C_word c,C_word *av) C_noret;
C_noret_decl(f_19415)
static void C_ccall f_19415(C_word c,C_word *av) C_noret;
C_noret_decl(f_19426)
static void C_ccall f_19426(C_word c,C_word *av) C_noret;
C_noret_decl(f_19437)
static void C_ccall f_19437(C_word c,C_word *av) C_noret;
C_noret_decl(f_19448)
static void C_ccall f_19448(C_word c,C_word *av) C_noret;
C_noret_decl(f_19459)
static void C_ccall f_19459(C_word c,C_word *av) C_noret;
C_noret_decl(f_19472)
static void C_ccall f_19472(C_word c,C_word *av) C_noret;
C_noret_decl(f_19474)
static C_word C_fcall f_19474(C_word t0,C_word t1);
C_noret_decl(f_19480)
static C_word C_fcall f_19480(C_word t0);
C_noret_decl(f_19485)
static C_word C_fcall f_19485(C_word t0);
C_noret_decl(f_19520)
static void C_ccall f_19520(C_word c,C_word *av) C_noret;
C_noret_decl(f_19533)
static void C_ccall f_19533(C_word c,C_word *av) C_noret;
C_noret_decl(f_19535)
static C_word C_fcall f_19535(C_word t0,C_word t1);
C_noret_decl(f_19541)
static C_word C_fcall f_19541(C_word t0);
C_noret_decl(f_19546)
static C_word C_fcall f_19546(C_word t0);
C_noret_decl(f_19581)
static void C_ccall f_19581(C_word c,C_word *av) C_noret;
C_noret_decl(f_19594)
static void C_ccall f_19594(C_word c,C_word *av) C_noret;
C_noret_decl(f_19596)
static C_word C_fcall f_19596(C_word t0,C_word t1);
C_noret_decl(f_19602)
static C_word C_fcall f_19602(C_word t0);
C_noret_decl(f_19607)
static C_word C_fcall f_19607(C_word t0);
C_noret_decl(f_19642)
static void C_ccall f_19642(C_word c,C_word *av) C_noret;
C_noret_decl(f_19654)
static void C_ccall f_19654(C_word c,C_word *av) C_noret;
C_noret_decl(f_19656)
static void C_ccall f_19656(C_word c,C_word *av) C_noret;
C_noret_decl(f_19662)
static void C_ccall f_19662(C_word c,C_word *av) C_noret;
C_noret_decl(f_19668)
static void C_fcall f_19668(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_19678)
static void C_ccall f_19678(C_word c,C_word *av) C_noret;
C_noret_decl(f_19681)
static void C_ccall f_19681(C_word c,C_word *av) C_noret;
C_noret_decl(f_19684)
static void C_ccall f_19684(C_word c,C_word *av) C_noret;
C_noret_decl(f_19687)
static void C_ccall f_19687(C_word c,C_word *av) C_noret;
C_noret_decl(f_19694)
static void C_ccall f_19694(C_word c,C_word *av) C_noret;
C_noret_decl(f_19698)
static void C_ccall f_19698(C_word c,C_word *av) C_noret;
C_noret_decl(f_19702)
static void C_ccall f_19702(C_word c,C_word *av) C_noret;
C_noret_decl(f_19706)
static void C_ccall f_19706(C_word c,C_word *av) C_noret;
C_noret_decl(f_19712)
static void C_fcall f_19712(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19725)
static void C_ccall f_19725(C_word c,C_word *av) C_noret;
C_noret_decl(f_19767)
static void C_fcall f_19767(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_19771)
static void C_ccall f_19771(C_word c,C_word *av) C_noret;
C_noret_decl(f_19804)
static void C_ccall f_19804(C_word c,C_word *av) C_noret;
C_noret_decl(f_19810)
static void C_ccall f_19810(C_word c,C_word *av) C_noret;
C_noret_decl(f_19816)
static void C_ccall f_19816(C_word c,C_word *av) C_noret;
C_noret_decl(f_19822)
static void C_ccall f_19822(C_word c,C_word *av) C_noret;
C_noret_decl(f_19828)
static void C_ccall f_19828(C_word c,C_word *av) C_noret;
C_noret_decl(f_19832)
static void C_ccall f_19832(C_word c,C_word *av) C_noret;
C_noret_decl(f_19837)
static void C_ccall f_19837(C_word c,C_word *av) C_noret;
C_noret_decl(f_19843)
static void C_ccall f_19843(C_word c,C_word *av) C_noret;
C_noret_decl(f_19847)
static void C_ccall f_19847(C_word c,C_word *av) C_noret;
C_noret_decl(f_19852)
static void C_ccall f_19852(C_word c,C_word *av) C_noret;
C_noret_decl(f_19856)
static void C_ccall f_19856(C_word c,C_word *av) C_noret;
C_noret_decl(f_19861)
static void C_ccall f_19861(C_word c,C_word *av) C_noret;
C_noret_decl(f_19867)
static void C_ccall f_19867(C_word c,C_word *av) C_noret;
C_noret_decl(f_19871)
static void C_ccall f_19871(C_word c,C_word *av) C_noret;
C_noret_decl(f_19876)
static void C_ccall f_19876(C_word c,C_word *av) C_noret;
C_noret_decl(f_19880)
static void C_ccall f_19880(C_word c,C_word *av) C_noret;
C_noret_decl(f_19885)
static void C_ccall f_19885(C_word c,C_word *av) C_noret;
C_noret_decl(f_19890)
static void C_ccall f_19890(C_word c,C_word *av) C_noret;
C_noret_decl(f_19896)
static void C_ccall f_19896(C_word c,C_word *av) C_noret;
C_noret_decl(f_19900)
static void C_ccall f_19900(C_word c,C_word *av) C_noret;
C_noret_decl(f_19905)
static void C_ccall f_19905(C_word c,C_word *av) C_noret;
C_noret_decl(f_19910)
static void C_ccall f_19910(C_word c,C_word *av) C_noret;
C_noret_decl(f_19914)
static void C_ccall f_19914(C_word c,C_word *av) C_noret;
C_noret_decl(f_19919)
static void C_ccall f_19919(C_word c,C_word *av) C_noret;
C_noret_decl(f_19924)
static void C_ccall f_19924(C_word c,C_word *av) C_noret;
C_noret_decl(f_19930)
static void C_ccall f_19930(C_word c,C_word *av) C_noret;
C_noret_decl(f_19934)
static void C_ccall f_19934(C_word c,C_word *av) C_noret;
C_noret_decl(f_19939)
static void C_ccall f_19939(C_word c,C_word *av) C_noret;
C_noret_decl(f_19944)
static void C_ccall f_19944(C_word c,C_word *av) C_noret;
C_noret_decl(f_19949)
static void C_ccall f_19949(C_word c,C_word *av) C_noret;
C_noret_decl(f_19970)
static void C_ccall f_19970(C_word c,C_word *av) C_noret;
C_noret_decl(f_19977)
static void C_ccall f_19977(C_word c,C_word *av) C_noret;
C_noret_decl(f_19983)
static void C_ccall f_19983(C_word c,C_word *av) C_noret;
C_noret_decl(f_20001)
static void C_ccall f_20001(C_word c,C_word *av) C_noret;
C_noret_decl(f_20010)
static void C_ccall f_20010(C_word c,C_word *av) C_noret;
C_noret_decl(f_20023)
static void C_fcall f_20023(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20031)
static void C_ccall f_20031(C_word c,C_word *av) C_noret;
C_noret_decl(f_20036)
static void C_fcall f_20036(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20073)
static void C_ccall f_20073(C_word c,C_word *av) C_noret;
C_noret_decl(f_20085)
static void C_ccall f_20085(C_word c,C_word *av) C_noret;
C_noret_decl(f_20095)
static void C_fcall f_20095(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20111)
static void C_ccall f_20111(C_word c,C_word *av) C_noret;
C_noret_decl(f_20124)
static void C_ccall f_20124(C_word c,C_word *av) C_noret;
C_noret_decl(f_20131)
static void C_ccall f_20131(C_word c,C_word *av) C_noret;
C_noret_decl(f_20133)
static void C_ccall f_20133(C_word c,C_word *av) C_noret;
C_noret_decl(f_20146)
static void C_ccall f_20146(C_word c,C_word *av) C_noret;
C_noret_decl(f_20152)
static void C_ccall f_20152(C_word c,C_word *av) C_noret;
C_noret_decl(f_20159)
static void C_ccall f_20159(C_word c,C_word *av) C_noret;
C_noret_decl(f_20161)
static void C_ccall f_20161(C_word c,C_word *av) C_noret;
C_noret_decl(f_20165)
static void C_ccall f_20165(C_word c,C_word *av) C_noret;
C_noret_decl(f_20168)
static void C_ccall f_20168(C_word c,C_word *av) C_noret;
C_noret_decl(f_20178)
static void C_ccall f_20178(C_word c,C_word *av) C_noret;
C_noret_decl(f_20182)
static void C_ccall f_20182(C_word c,C_word *av) C_noret;
C_noret_decl(f_20190)
static void C_ccall f_20190(C_word c,C_word *av) C_noret;
C_noret_decl(f_20193)
static void C_ccall f_20193(C_word c,C_word *av) C_noret;
C_noret_decl(f_20200)
static void C_ccall f_20200(C_word c,C_word *av) C_noret;
C_noret_decl(f_20203)
static void C_ccall f_20203(C_word c,C_word *av) C_noret;
C_noret_decl(f_20206)
static void C_ccall f_20206(C_word c,C_word *av) C_noret;
C_noret_decl(f_20209)
static void C_ccall f_20209(C_word c,C_word *av) C_noret;
C_noret_decl(f_20217)
static void C_ccall f_20217(C_word c,C_word *av) C_noret;
C_noret_decl(f_20225)
static void C_ccall f_20225(C_word c,C_word *av) C_noret;
C_noret_decl(f_20227)
static void C_ccall f_20227(C_word c,C_word *av) C_noret;
C_noret_decl(f_20243)
static void C_ccall f_20243(C_word c,C_word *av) C_noret;
C_noret_decl(f_20270)
static void C_ccall f_20270(C_word c,C_word *av) C_noret;
C_noret_decl(f_20274)
static void C_ccall f_20274(C_word c,C_word *av) C_noret;
C_noret_decl(f_20278)
static void C_ccall f_20278(C_word c,C_word *av) C_noret;
C_noret_decl(f_20282)
static void C_ccall f_20282(C_word c,C_word *av) C_noret;
C_noret_decl(f_20286)
static void C_ccall f_20286(C_word c,C_word *av) C_noret;
C_noret_decl(f_20290)
static void C_ccall f_20290(C_word c,C_word *av) C_noret;
C_noret_decl(f_20294)
static void C_ccall f_20294(C_word c,C_word *av) C_noret;
C_noret_decl(f_20298)
static void C_ccall f_20298(C_word c,C_word *av) C_noret;
C_noret_decl(f_20302)
static void C_ccall f_20302(C_word c,C_word *av) C_noret;
C_noret_decl(f_20306)
static void C_ccall f_20306(C_word c,C_word *av) C_noret;
C_noret_decl(f_20310)
static void C_ccall f_20310(C_word c,C_word *av) C_noret;
C_noret_decl(f_20314)
static void C_ccall f_20314(C_word c,C_word *av) C_noret;
C_noret_decl(f_20318)
static void C_ccall f_20318(C_word c,C_word *av) C_noret;
C_noret_decl(f_20322)
static void C_ccall f_20322(C_word c,C_word *av) C_noret;
C_noret_decl(f_20326)
static void C_ccall f_20326(C_word c,C_word *av) C_noret;
C_noret_decl(f_20330)
static void C_ccall f_20330(C_word c,C_word *av) C_noret;
C_noret_decl(f_20334)
static void C_ccall f_20334(C_word c,C_word *av) C_noret;
C_noret_decl(f_20341)
static void C_ccall f_20341(C_word c,C_word *av) C_noret;
C_noret_decl(f_20348)
static void C_ccall f_20348(C_word c,C_word *av) C_noret;
C_noret_decl(f_20349)
static void C_fcall f_20349(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_20353)
static void C_fcall f_20353(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20356)
static void C_ccall f_20356(C_word c,C_word *av) C_noret;
C_noret_decl(f_20372)
static void C_ccall f_20372(C_word c,C_word *av) C_noret;
C_noret_decl(f_20383)
static void C_fcall f_20383(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20391)
static void C_ccall f_20391(C_word c,C_word *av) C_noret;
C_noret_decl(f_20403)
static void C_fcall f_20403(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20412)
static void C_fcall f_20412(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20417)
static void C_fcall f_20417(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20473)
static void C_ccall f_20473(C_word c,C_word *av) C_noret;
C_noret_decl(f_20487)
static void C_ccall f_20487(C_word c,C_word *av) C_noret;
C_noret_decl(f_20499)
static void C_ccall f_20499(C_word c,C_word *av) C_noret;
C_noret_decl(f_20505)
static void C_ccall f_20505(C_word c,C_word *av) C_noret;
C_noret_decl(f_20530)
static void C_ccall f_20530(C_word c,C_word *av) C_noret;
C_noret_decl(f_20548)
static void C_ccall f_20548(C_word c,C_word *av) C_noret;
C_noret_decl(f_20552)
static void C_ccall f_20552(C_word c,C_word *av) C_noret;
C_noret_decl(f_20608)
static void C_ccall f_20608(C_word c,C_word *av) C_noret;
C_noret_decl(f_20617)
static void C_ccall f_20617(C_word c,C_word *av) C_noret;
C_noret_decl(f_20630)
static void C_ccall f_20630(C_word c,C_word *av) C_noret;
C_noret_decl(f_20642)
static void C_ccall f_20642(C_word c,C_word *av) C_noret;
C_noret_decl(f_20660)
static void C_ccall f_20660(C_word c,C_word *av) C_noret;
C_noret_decl(f_20680)
static void C_ccall f_20680(C_word c,C_word *av) C_noret;
C_noret_decl(f_20683)
static void C_ccall f_20683(C_word c,C_word *av) C_noret;
C_noret_decl(f_20686)
static void C_ccall f_20686(C_word c,C_word *av) C_noret;
C_noret_decl(f_20694)
static void C_ccall f_20694(C_word c,C_word *av) C_noret;
C_noret_decl(f_20698)
static void C_ccall f_20698(C_word c,C_word *av) C_noret;
C_noret_decl(f_20702)
static void C_ccall f_20702(C_word c,C_word *av) C_noret;
C_noret_decl(f_20706)
static void C_ccall f_20706(C_word c,C_word *av) C_noret;
C_noret_decl(f_20710)
static void C_ccall f_20710(C_word c,C_word *av) C_noret;
C_noret_decl(f_20712)
static void C_ccall f_20712(C_word c,C_word *av) C_noret;
C_noret_decl(f_20720)
static void C_ccall f_20720(C_word c,C_word *av) C_noret;
C_noret_decl(f_20723)
static void C_ccall f_20723(C_word c,C_word *av) C_noret;
C_noret_decl(f_20733)
static void C_ccall f_20733(C_word c,C_word *av) C_noret;
C_noret_decl(f_20735)
static void C_ccall f_20735(C_word c,C_word *av) C_noret;
C_noret_decl(f_20743)
static void C_ccall f_20743(C_word c,C_word *av) C_noret;
C_noret_decl(f_20746)
static void C_ccall f_20746(C_word c,C_word *av) C_noret;
C_noret_decl(f_20756)
static void C_ccall f_20756(C_word c,C_word *av) C_noret;
C_noret_decl(f_20758)
static void C_ccall f_20758(C_word c,C_word *av) C_noret;
C_noret_decl(f_20762)
static void C_ccall f_20762(C_word c,C_word *av) C_noret;
C_noret_decl(f_20765)
static void C_ccall f_20765(C_word c,C_word *av) C_noret;
C_noret_decl(f_20768)
static void C_ccall f_20768(C_word c,C_word *av) C_noret;
C_noret_decl(f_20771)
static void C_ccall f_20771(C_word c,C_word *av) C_noret;
C_noret_decl(f_20774)
static void C_ccall f_20774(C_word c,C_word *av) C_noret;
C_noret_decl(f_20776)
static void C_ccall f_20776(C_word c,C_word *av) C_noret;
C_noret_decl(f_20782)
static void C_fcall f_20782(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_20791)
static void C_fcall f_20791(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20799)
static void C_ccall f_20799(C_word c,C_word *av) C_noret;
C_noret_decl(f_20801)
static void C_fcall f_20801(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20815)
static void C_ccall f_20815(C_word c,C_word *av) C_noret;
C_noret_decl(f_20828)
static void C_fcall f_20828(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20832)
static void C_ccall f_20832(C_word c,C_word *av) C_noret;
C_noret_decl(f_20837)
static void C_fcall f_20837(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20841)
static void C_ccall f_20841(C_word c,C_word *av) C_noret;
C_noret_decl(f_20852)
static void C_fcall f_20852(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20855)
static void C_fcall f_20855(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20863)
static void C_ccall f_20863(C_word c,C_word *av) C_noret;
C_noret_decl(f_20865)
static void C_fcall f_20865(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20878)
static void C_ccall f_20878(C_word c,C_word *av) C_noret;
C_noret_decl(f_20885)
static void C_ccall f_20885(C_word c,C_word *av) C_noret;
C_noret_decl(f_20894)
static void C_ccall f_20894(C_word c,C_word *av) C_noret;
C_noret_decl(f_20901)
static void C_ccall f_20901(C_word c,C_word *av) C_noret;
C_noret_decl(f_20903)
static void C_fcall f_20903(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_20909)
static void C_fcall f_20909(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20919)
static void C_ccall f_20919(C_word c,C_word *av) C_noret;
C_noret_decl(f_20922)
static void C_ccall f_20922(C_word c,C_word *av) C_noret;
C_noret_decl(f_20932)
static void C_ccall f_20932(C_word c,C_word *av) C_noret;
C_noret_decl(f_20935)
static void C_ccall f_20935(C_word c,C_word *av) C_noret;
C_noret_decl(f_20963)
static void C_fcall f_20963(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20967)
static void C_ccall f_20967(C_word c,C_word *av) C_noret;
C_noret_decl(f_20975)
static void C_fcall f_20975(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21000)
static void C_fcall f_21000(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21008)
static void C_ccall f_21008(C_word c,C_word *av) C_noret;
C_noret_decl(f_21010)
static void C_fcall f_21010(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21027)
static void C_ccall f_21027(C_word c,C_word *av) C_noret;
C_noret_decl(f_21040)
static void C_ccall f_21040(C_word c,C_word *av) C_noret;
C_noret_decl(f_21057)
static void C_ccall f_21057(C_word c,C_word *av) C_noret;
C_noret_decl(f_21074)
static void C_ccall f_21074(C_word c,C_word *av) C_noret;
C_noret_decl(f_21091)
static void C_ccall f_21091(C_word c,C_word *av) C_noret;
C_noret_decl(f_21108)
static void C_ccall f_21108(C_word c,C_word *av) C_noret;
C_noret_decl(f_21125)
static void C_ccall f_21125(C_word c,C_word *av) C_noret;
C_noret_decl(f_21142)
static void C_ccall f_21142(C_word c,C_word *av) C_noret;
C_noret_decl(f_21162)
static void C_ccall f_21162(C_word c,C_word *av) C_noret;
C_noret_decl(f_21170)
static void C_ccall f_21170(C_word c,C_word *av) C_noret;
C_noret_decl(f_21179)
static void C_ccall f_21179(C_word c,C_word *av) C_noret;
C_noret_decl(f_21185)
static void C_ccall f_21185(C_word c,C_word *av) C_noret;
C_noret_decl(f_21191)
static void C_fcall f_21191(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21194)
static void C_ccall f_21194(C_word c,C_word *av) C_noret;
C_noret_decl(f_21197)
static void C_ccall f_21197(C_word c,C_word *av) C_noret;
C_noret_decl(f_21207)
static void C_ccall f_21207(C_word c,C_word *av) C_noret;
C_noret_decl(f_21211)
static void C_ccall f_21211(C_word c,C_word *av) C_noret;
C_noret_decl(f_21228)
static void C_ccall f_21228(C_word c,C_word *av) C_noret;
C_noret_decl(f_21233)
static void C_ccall f_21233(C_word c,C_word *av) C_noret;
C_noret_decl(f_21240)
static void C_ccall f_21240(C_word c,C_word *av) C_noret;
C_noret_decl(f_21244)
static void C_ccall f_21244(C_word c,C_word *av) C_noret;
C_noret_decl(f_21253)
static void C_ccall f_21253(C_word c,C_word *av) C_noret;
C_noret_decl(f_21259)
static void C_ccall f_21259(C_word c,C_word *av) C_noret;
C_noret_decl(f_21269)
static void C_ccall f_21269(C_word c,C_word *av) C_noret;
C_noret_decl(f_21273)
static void C_ccall f_21273(C_word c,C_word *av) C_noret;
C_noret_decl(f_21282)
static void C_fcall f_21282(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21289)
static void C_ccall f_21289(C_word c,C_word *av) C_noret;
C_noret_decl(f_21302)
static void C_fcall f_21302(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21307)
static void C_fcall f_21307(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21324)
static void C_ccall f_21324(C_word c,C_word *av) C_noret;
C_noret_decl(f_21339)
static void C_ccall f_21339(C_word c,C_word *av) C_noret;
C_noret_decl(f_21352)
static void C_ccall f_21352(C_word c,C_word *av) C_noret;
C_noret_decl(f_21374)
static void C_ccall f_21374(C_word c,C_word *av) C_noret;
C_noret_decl(f_21377)
static void C_ccall f_21377(C_word c,C_word *av) C_noret;
C_noret_decl(f_21406)
static void C_fcall f_21406(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21416)
static void C_ccall f_21416(C_word c,C_word *av) C_noret;
C_noret_decl(f_21432)
static void C_ccall f_21432(C_word c,C_word *av) C_noret;
C_noret_decl(f_21443)
static void C_ccall f_21443(C_word c,C_word *av) C_noret;
C_noret_decl(f_21450)
static void C_ccall f_21450(C_word c,C_word *av) C_noret;
C_noret_decl(f_21548)
static void C_ccall f_21548(C_word c,C_word *av) C_noret;
C_noret_decl(f_21554)
static void C_fcall f_21554(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21563)
static void C_fcall f_21563(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21577)
static void C_ccall f_21577(C_word c,C_word *av) C_noret;
C_noret_decl(f_21580)
static void C_ccall f_21580(C_word c,C_word *av) C_noret;
C_noret_decl(f_21591)
static void C_ccall f_21591(C_word c,C_word *av) C_noret;
C_noret_decl(f_21593)
static void C_ccall f_21593(C_word c,C_word *av) C_noret;
C_noret_decl(f_21596)
static void C_ccall f_21596(C_word c,C_word *av) C_noret;
C_noret_decl(f_21613)
static void C_ccall f_21613(C_word c,C_word *av) C_noret;
C_noret_decl(f_21618)
static void C_fcall f_21618(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21622)
static void C_ccall f_21622(C_word c,C_word *av) C_noret;
C_noret_decl(f_21625)
static void C_fcall f_21625(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21628)
static void C_ccall f_21628(C_word c,C_word *av) C_noret;
C_noret_decl(f_21638)
static void C_ccall f_21638(C_word c,C_word *av) C_noret;
C_noret_decl(f_21656)
static void C_ccall f_21656(C_word c,C_word *av) C_noret;
C_noret_decl(f_21659)
static void C_ccall f_21659(C_word c,C_word *av) C_noret;
C_noret_decl(f_21668)
static void C_fcall f_21668(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21671)
static void C_ccall f_21671(C_word c,C_word *av) C_noret;
C_noret_decl(f_21674)
static void C_ccall f_21674(C_word c,C_word *av) C_noret;
C_noret_decl(f_21680)
static void C_ccall f_21680(C_word c,C_word *av) C_noret;
C_noret_decl(f_21693)
static void C_ccall f_21693(C_word c,C_word *av) C_noret;
C_noret_decl(f_21697)
static void C_ccall f_21697(C_word c,C_word *av) C_noret;
C_noret_decl(f_21701)
static void C_ccall f_21701(C_word c,C_word *av) C_noret;
C_noret_decl(f_21712)
static void C_ccall f_21712(C_word c,C_word *av) C_noret;
C_noret_decl(f_21716)
static void C_ccall f_21716(C_word c,C_word *av) C_noret;
C_noret_decl(f_21719)
static void C_ccall f_21719(C_word c,C_word *av) C_noret;
C_noret_decl(f_21747)
static void C_ccall f_21747(C_word c,C_word *av) C_noret;
C_noret_decl(f_21803)
static void C_ccall f_21803(C_word c,C_word *av) C_noret;
C_noret_decl(f_21807)
static void C_ccall f_21807(C_word c,C_word *av) C_noret;
C_noret_decl(f_21814)
static void C_ccall f_21814(C_word c,C_word *av) C_noret;
C_noret_decl(f_21816)
static void C_fcall f_21816(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21820)
static void C_ccall f_21820(C_word c,C_word *av) C_noret;
C_noret_decl(f_21834)
static void C_fcall f_21834(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_21840)
static void C_ccall f_21840(C_word c,C_word *av) C_noret;
C_noret_decl(f_21847)
static void C_ccall f_21847(C_word c,C_word *av) C_noret;
C_noret_decl(f_21854)
static void C_ccall f_21854(C_word c,C_word *av) C_noret;
C_noret_decl(f_21875)
static void C_ccall f_21875(C_word c,C_word *av) C_noret;
C_noret_decl(f_21904)
static void C_fcall f_21904(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21914)
static void C_ccall f_21914(C_word c,C_word *av) C_noret;
C_noret_decl(f_21917)
static void C_ccall f_21917(C_word c,C_word *av) C_noret;
C_noret_decl(f_21953)
static void C_ccall f_21953(C_word c,C_word *av) C_noret;
C_noret_decl(f_21955)
static void C_fcall f_21955(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21965)
static void C_ccall f_21965(C_word c,C_word *av) C_noret;
C_noret_decl(f_21968)
static void C_ccall f_21968(C_word c,C_word *av) C_noret;
C_noret_decl(f_22020)
static void C_ccall f_22020(C_word c,C_word *av) C_noret;
C_noret_decl(f_22022)
static void C_fcall f_22022(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22030)
static void C_ccall f_22030(C_word c,C_word *av) C_noret;
C_noret_decl(f_22032)
static void C_fcall f_22032(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_22042)
static void C_fcall f_22042(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22057)
static void C_ccall f_22057(C_word c,C_word *av) C_noret;
C_noret_decl(f_22064)
static void C_ccall f_22064(C_word c,C_word *av) C_noret;
C_noret_decl(f_22086)
static void C_fcall f_22086(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22094)
static void C_ccall f_22094(C_word c,C_word *av) C_noret;
C_noret_decl(f_22096)
static void C_fcall f_22096(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_22112)
static void C_ccall f_22112(C_word c,C_word *av) C_noret;
C_noret_decl(f_22119)
static void C_ccall f_22119(C_word c,C_word *av) C_noret;
C_noret_decl(f_22132)
static void C_fcall f_22132(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22138)
static void C_ccall f_22138(C_word c,C_word *av) C_noret;
C_noret_decl(f_22142)
static void C_ccall f_22142(C_word c,C_word *av) C_noret;
C_noret_decl(f_22149)
static void C_ccall f_22149(C_word c,C_word *av) C_noret;
C_noret_decl(f_22157)
static void C_fcall f_22157(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_22162)
static void C_fcall f_22162(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22167)
static void C_fcall f_22167(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_22171)
static void C_ccall f_22171(C_word c,C_word *av) C_noret;
C_noret_decl(f_22180)
static void C_fcall f_22180(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22186)
static void C_fcall f_22186(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22193)
static void C_ccall f_22193(C_word c,C_word *av) C_noret;
C_noret_decl(f_22210)
static void C_ccall f_22210(C_word c,C_word *av) C_noret;
C_noret_decl(f_22216)
static void C_fcall f_22216(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22226)
static void C_ccall f_22226(C_word c,C_word *av) C_noret;
C_noret_decl(f_22277)
static void C_ccall f_22277(C_word c,C_word *av) C_noret;
C_noret_decl(f_22286)
static void C_ccall f_22286(C_word c,C_word *av) C_noret;
C_noret_decl(f_22293)
static void C_ccall f_22293(C_word c,C_word *av) C_noret;
C_noret_decl(f_22297)
static void C_ccall f_22297(C_word c,C_word *av) C_noret;
C_noret_decl(f_22301)
static void C_ccall f_22301(C_word c,C_word *av) C_noret;
C_noret_decl(f_22310)
static void C_ccall f_22310(C_word c,C_word *av) C_noret;
C_noret_decl(f_22321)
static void C_ccall f_22321(C_word c,C_word *av) C_noret;
C_noret_decl(f_22343)
static void C_ccall f_22343(C_word c,C_word *av) C_noret;
C_noret_decl(f_22402)
static void C_ccall f_22402(C_word c,C_word *av) C_noret;
C_noret_decl(f_22406)
static void C_ccall f_22406(C_word c,C_word *av) C_noret;
C_noret_decl(f_22408)
static void C_fcall f_22408(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22412)
static void C_ccall f_22412(C_word c,C_word *av) C_noret;
C_noret_decl(f_22415)
static void C_ccall f_22415(C_word c,C_word *av) C_noret;
C_noret_decl(f_22427)
static void C_ccall f_22427(C_word c,C_word *av) C_noret;
C_noret_decl(f_22447)
static void C_fcall f_22447(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22453)
static void C_ccall f_22453(C_word c,C_word *av) C_noret;
C_noret_decl(f_22463)
static void C_ccall f_22463(C_word c,C_word *av) C_noret;
C_noret_decl(f_22592)
static void C_fcall f_22592(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22599)
static void C_ccall f_22599(C_word c,C_word *av) C_noret;
C_noret_decl(f_22617)
static void C_fcall f_22617(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22623)
static void C_fcall f_22623(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_22627)
static void C_ccall f_22627(C_word c,C_word *av) C_noret;
C_noret_decl(f_22663)
static void C_ccall f_22663(C_word c,C_word *av) C_noret;
C_noret_decl(f_22686)
static void C_ccall f_22686(C_word c,C_word *av) C_noret;
C_noret_decl(f_22704)
static void C_fcall f_22704(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22708)
static void C_ccall f_22708(C_word c,C_word *av) C_noret;
C_noret_decl(f_22715)
static void C_ccall f_22715(C_word c,C_word *av) C_noret;
C_noret_decl(f_22717)
static void C_fcall f_22717(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_22721)
static void C_ccall f_22721(C_word c,C_word *av) C_noret;
C_noret_decl(f_22732)
static void C_ccall f_22732(C_word c,C_word *av) C_noret;
C_noret_decl(f_22748)
static void C_ccall f_22748(C_word c,C_word *av) C_noret;
C_noret_decl(f_22751)
static void C_ccall f_22751(C_word c,C_word *av) C_noret;
C_noret_decl(f_22754)
static void C_ccall f_22754(C_word c,C_word *av) C_noret;
C_noret_decl(f_22768)
static void C_ccall f_22768(C_word c,C_word *av) C_noret;
C_noret_decl(f_22774)
static void C_ccall f_22774(C_word c,C_word *av) C_noret;
C_noret_decl(f_22796)
static void C_ccall f_22796(C_word c,C_word *av) C_noret;
C_noret_decl(f_22808)
static void C_ccall f_22808(C_word c,C_word *av) C_noret;
C_noret_decl(f_22820)
static void C_ccall f_22820(C_word c,C_word *av) C_noret;
C_noret_decl(f_22829)
static void C_ccall f_22829(C_word c,C_word *av) C_noret;
C_noret_decl(f_22839)
static void C_ccall f_22839(C_word c,C_word *av) C_noret;
C_noret_decl(f_22848)
static void C_ccall f_22848(C_word c,C_word *av) C_noret;
C_noret_decl(f_22851)
static void C_ccall f_22851(C_word c,C_word *av) C_noret;
C_noret_decl(f_22869)
static void C_ccall f_22869(C_word c,C_word *av) C_noret;
C_noret_decl(f_22872)
static void C_ccall f_22872(C_word c,C_word *av) C_noret;
C_noret_decl(f_22895)
static void C_ccall f_22895(C_word c,C_word *av) C_noret;
C_noret_decl(f_22901)
static void C_ccall f_22901(C_word c,C_word *av) C_noret;
C_noret_decl(f_22929)
static void C_ccall f_22929(C_word c,C_word *av) C_noret;
C_noret_decl(f_22952)
static void C_ccall f_22952(C_word c,C_word *av) C_noret;
C_noret_decl(f_22966)
static void C_ccall f_22966(C_word c,C_word *av) C_noret;
C_noret_decl(f_22972)
static void C_ccall f_22972(C_word c,C_word *av) C_noret;
C_noret_decl(f_22997)
static void C_ccall f_22997(C_word c,C_word *av) C_noret;
C_noret_decl(f_23009)
static void C_ccall f_23009(C_word c,C_word *av) C_noret;
C_noret_decl(f_23021)
static void C_ccall f_23021(C_word c,C_word *av) C_noret;
C_noret_decl(f_23033)
static void C_ccall f_23033(C_word c,C_word *av) C_noret;
C_noret_decl(f_23045)
static void C_ccall f_23045(C_word c,C_word *av) C_noret;
C_noret_decl(f_23057)
static void C_ccall f_23057(C_word c,C_word *av) C_noret;
C_noret_decl(f_23069)
static void C_ccall f_23069(C_word c,C_word *av) C_noret;
C_noret_decl(f_23072)
static void C_ccall f_23072(C_word c,C_word *av) C_noret;
C_noret_decl(f_23075)
static void C_ccall f_23075(C_word c,C_word *av) C_noret;
C_noret_decl(f_23080)
static void C_ccall f_23080(C_word c,C_word *av) C_noret;
C_noret_decl(f_23085)
static void C_ccall f_23085(C_word c,C_word *av) C_noret;
C_noret_decl(f_23091)
static void C_ccall f_23091(C_word c,C_word *av) C_noret;
C_noret_decl(f_23133)
static void C_ccall f_23133(C_word c,C_word *av) C_noret;
C_noret_decl(f_23145)
static void C_ccall f_23145(C_word c,C_word *av) C_noret;
C_noret_decl(f_23148)
static void C_ccall f_23148(C_word c,C_word *av) C_noret;
C_noret_decl(f_23160)
static void C_ccall f_23160(C_word c,C_word *av) C_noret;
C_noret_decl(f_23172)
static void C_ccall f_23172(C_word c,C_word *av) C_noret;
C_noret_decl(f_23175)
static void C_ccall f_23175(C_word c,C_word *av) C_noret;
C_noret_decl(f_23187)
static void C_ccall f_23187(C_word c,C_word *av) C_noret;
C_noret_decl(f_23199)
static void C_ccall f_23199(C_word c,C_word *av) C_noret;
C_noret_decl(f_23202)
static void C_ccall f_23202(C_word c,C_word *av) C_noret;
C_noret_decl(f_23211)
static void C_ccall f_23211(C_word c,C_word *av) C_noret;
C_noret_decl(f_23226)
static void C_ccall f_23226(C_word c,C_word *av) C_noret;
C_noret_decl(f_23229)
static void C_ccall f_23229(C_word c,C_word *av) C_noret;
C_noret_decl(f_23234)
static void C_ccall f_23234(C_word c,C_word *av) C_noret;
C_noret_decl(f_23239)
static void C_ccall f_23239(C_word c,C_word *av) C_noret;
C_noret_decl(f_23245)
static void C_ccall f_23245(C_word c,C_word *av) C_noret;
C_noret_decl(f_23274)
static void C_ccall f_23274(C_word c,C_word *av) C_noret;
C_noret_decl(f_23286)
static void C_ccall f_23286(C_word c,C_word *av) C_noret;
C_noret_decl(f_23289)
static void C_ccall f_23289(C_word c,C_word *av) C_noret;
C_noret_decl(f_23292)
static void C_ccall f_23292(C_word c,C_word *av) C_noret;
C_noret_decl(f_23307)
static void C_ccall f_23307(C_word c,C_word *av) C_noret;
C_noret_decl(f_23316)
static void C_ccall f_23316(C_word c,C_word *av) C_noret;
C_noret_decl(f_23319)
static void C_ccall f_23319(C_word c,C_word *av) C_noret;
C_noret_decl(f_23325)
static void C_fcall f_23325(C_word t0,C_word t1) C_noret;
C_noret_decl(f_23328)
static void C_ccall f_23328(C_word c,C_word *av) C_noret;
C_noret_decl(f_23334)
static void C_ccall f_23334(C_word c,C_word *av) C_noret;
C_noret_decl(f_23358)
static void C_ccall f_23358(C_word c,C_word *av) C_noret;
C_noret_decl(f_23377)
static void C_ccall f_23377(C_word c,C_word *av) C_noret;
C_noret_decl(f_23393)
static void C_ccall f_23393(C_word c,C_word *av) C_noret;
C_noret_decl(f_23399)
static void C_ccall f_23399(C_word c,C_word *av) C_noret;
C_noret_decl(f_23471)
static void C_ccall f_23471(C_word c,C_word *av) C_noret;
C_noret_decl(f_23483)
static void C_ccall f_23483(C_word c,C_word *av) C_noret;
C_noret_decl(f_23561)
static void C_ccall f_23561(C_word c,C_word *av) C_noret;
C_noret_decl(f_23637)
static void C_ccall f_23637(C_word c,C_word *av) C_noret;
C_noret_decl(f_23802)
static void C_ccall f_23802(C_word c,C_word *av) C_noret;
C_noret_decl(f_23814)
static void C_ccall f_23814(C_word c,C_word *av) C_noret;
C_noret_decl(f_23876)
static void C_ccall f_23876(C_word c,C_word *av) C_noret;
C_noret_decl(f_23879)
static void C_fcall f_23879(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_23925)
static void C_fcall f_23925(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23929)
static void C_ccall f_23929(C_word c,C_word *av) C_noret;
C_noret_decl(f_23947)
static void C_ccall f_23947(C_word c,C_word *av) C_noret;
C_noret_decl(f_24011)
static void C_ccall f_24011(C_word c,C_word *av) C_noret;
C_noret_decl(f_24022)
static void C_ccall f_24022(C_word c,C_word *av) C_noret;
C_noret_decl(f_24024)
static void C_ccall f_24024(C_word c,C_word *av) C_noret;
C_noret_decl(f_24037)
static void C_ccall f_24037(C_word c,C_word *av) C_noret;
C_noret_decl(f_24049)
static void C_ccall f_24049(C_word c,C_word *av) C_noret;
C_noret_decl(f_24069)
static void C_ccall f_24069(C_word c,C_word *av) C_noret;
C_noret_decl(f_24076)
static void C_ccall f_24076(C_word c,C_word *av) C_noret;
C_noret_decl(f_24085)
static void C_ccall f_24085(C_word c,C_word *av) C_noret;
C_noret_decl(f_24097)
static void C_ccall f_24097(C_word c,C_word *av) C_noret;
C_noret_decl(f_24118)
static void C_ccall f_24118(C_word c,C_word *av) C_noret;
C_noret_decl(f_24133)
static void C_ccall f_24133(C_word c,C_word *av) C_noret;
C_noret_decl(f_24151)
static void C_ccall f_24151(C_word c,C_word *av) C_noret;
C_noret_decl(f_24169)
static void C_ccall f_24169(C_word c,C_word *av) C_noret;
C_noret_decl(f_24188)
static void C_fcall f_24188(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24198)
static void C_ccall f_24198(C_word c,C_word *av) C_noret;
C_noret_decl(f_24212)
static void C_ccall f_24212(C_word c,C_word *av) C_noret;
C_noret_decl(f_24215)
static void C_ccall f_24215(C_word c,C_word *av) C_noret;
C_noret_decl(f_24220)
static void C_ccall f_24220(C_word c,C_word *av) C_noret;
C_noret_decl(f_24239)
static void C_fcall f_24239(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24249)
static void C_ccall f_24249(C_word c,C_word *av) C_noret;
C_noret_decl(f_24263)
static void C_ccall f_24263(C_word c,C_word *av) C_noret;
C_noret_decl(f_24266)
static void C_ccall f_24266(C_word c,C_word *av) C_noret;
C_noret_decl(f_24273)
static void C_ccall f_24273(C_word c,C_word *av) C_noret;
C_noret_decl(f_24277)
static void C_ccall f_24277(C_word c,C_word *av) C_noret;
C_noret_decl(f_24281)
static void C_ccall f_24281(C_word c,C_word *av) C_noret;
C_noret_decl(f_24283)
static void C_ccall f_24283(C_word c,C_word *av) C_noret;
C_noret_decl(f_24290)
static void C_ccall f_24290(C_word c,C_word *av) C_noret;
C_noret_decl(f_24293)
static void C_ccall f_24293(C_word c,C_word *av) C_noret;
C_noret_decl(f_24296)
static void C_ccall f_24296(C_word c,C_word *av) C_noret;
C_noret_decl(f_24298)
static void C_fcall f_24298(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_24308)
static void C_ccall f_24308(C_word c,C_word *av) C_noret;
C_noret_decl(f_24314)
static void C_ccall f_24314(C_word c,C_word *av) C_noret;
C_noret_decl(f_24326)
static void C_ccall f_24326(C_word c,C_word *av) C_noret;
C_noret_decl(f_24329)
static void C_ccall f_24329(C_word c,C_word *av) C_noret;
C_noret_decl(f_24332)
static void C_ccall f_24332(C_word c,C_word *av) C_noret;
C_noret_decl(f_24349)
static void C_ccall f_24349(C_word c,C_word *av) C_noret;
C_noret_decl(f_24370)
static void C_fcall f_24370(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_24374)
static void C_ccall f_24374(C_word c,C_word *av) C_noret;
C_noret_decl(f_24387)
static void C_ccall f_24387(C_word c,C_word *av) C_noret;
C_noret_decl(f_24390)
static void C_ccall f_24390(C_word c,C_word *av) C_noret;
C_noret_decl(f_24399)
static void C_ccall f_24399(C_word c,C_word *av) C_noret;
C_noret_decl(f_24402)
static void C_ccall f_24402(C_word c,C_word *av) C_noret;
C_noret_decl(f_24430)
static void C_fcall f_24430(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_24434)
static void C_ccall f_24434(C_word c,C_word *av) C_noret;
C_noret_decl(f_24443)
static void C_ccall f_24443(C_word c,C_word *av) C_noret;
C_noret_decl(f_24454)
static void C_fcall f_24454(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_24461)
static void C_ccall f_24461(C_word c,C_word *av) C_noret;
C_noret_decl(f_24466)
static void C_fcall f_24466(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24488)
static void C_ccall f_24488(C_word c,C_word *av) C_noret;
C_noret_decl(f_24494)
static void C_ccall f_24494(C_word c,C_word *av) C_noret;
C_noret_decl(f_24497)
static void C_ccall f_24497(C_word c,C_word *av) C_noret;
C_noret_decl(f_24508)
static void C_ccall f_24508(C_word c,C_word *av) C_noret;
C_noret_decl(f_24517)
static void C_ccall f_24517(C_word c,C_word *av) C_noret;
C_noret_decl(f_24520)
static void C_ccall f_24520(C_word c,C_word *av) C_noret;
C_noret_decl(f_24543)
static void C_fcall f_24543(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24592)
static void C_fcall f_24592(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24608)
static void C_fcall f_24608(C_word t0,C_word t1) C_noret;
C_noret_decl(f_24615)
static void C_ccall f_24615(C_word c,C_word *av) C_noret;
C_noret_decl(f_24627)
static void C_fcall f_24627(C_word t0,C_word t1) C_noret;
C_noret_decl(f_24732)
static void C_ccall f_24732(C_word c,C_word *av) C_noret;
C_noret_decl(f_24737)
static void C_fcall f_24737(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24792)
static void C_ccall f_24792(C_word c,C_word *av) C_noret;
C_noret_decl(f_24798)
static void C_ccall f_24798(C_word c,C_word *av) C_noret;
C_noret_decl(f_24802)
static void C_fcall f_24802(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24825)
static void C_ccall f_24825(C_word c,C_word *av) C_noret;
C_noret_decl(f_24832)
static void C_ccall f_24832(C_word c,C_word *av) C_noret;
C_noret_decl(f_24851)
static void C_ccall f_24851(C_word c,C_word *av) C_noret;
C_noret_decl(f_24887)
static void C_ccall f_24887(C_word c,C_word *av) C_noret;
C_noret_decl(f_24899)
static void C_ccall f_24899(C_word c,C_word *av) C_noret;
C_noret_decl(f_24905)
static void C_ccall f_24905(C_word c,C_word *av) C_noret;
C_noret_decl(f_24927)
static void C_ccall f_24927(C_word c,C_word *av) C_noret;
C_noret_decl(f_24934)
static void C_ccall f_24934(C_word c,C_word *av) C_noret;
C_noret_decl(f_24944)
static void C_ccall f_24944(C_word c,C_word *av) C_noret;
C_noret_decl(f_24953)
static void C_ccall f_24953(C_word c,C_word *av) C_noret;
C_noret_decl(f_24959)
static void C_fcall f_24959(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_24972)
static void C_ccall f_24972(C_word c,C_word *av) C_noret;
C_noret_decl(f_25010)
static void C_ccall f_25010(C_word c,C_word *av) C_noret;
C_noret_decl(f_25076)
static void C_ccall f_25076(C_word c,C_word *av) C_noret;
C_noret_decl(f_25079)
static void C_ccall f_25079(C_word c,C_word *av) C_noret;
C_noret_decl(f_25086)
static void C_ccall f_25086(C_word c,C_word *av) C_noret;
C_noret_decl(f_25126)
static void C_ccall f_25126(C_word c,C_word *av) C_noret;
C_noret_decl(f_25129)
static void C_ccall f_25129(C_word c,C_word *av) C_noret;
C_noret_decl(f_25138)
static void C_fcall f_25138(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25151)
static void C_ccall f_25151(C_word c,C_word *av) C_noret;
C_noret_decl(f_25160)
static void C_ccall f_25160(C_word c,C_word *av) C_noret;
C_noret_decl(f_25170)
static void C_ccall f_25170(C_word c,C_word *av) C_noret;
C_noret_decl(f_25173)
static void C_ccall f_25173(C_word c,C_word *av) C_noret;
C_noret_decl(f_25199)
static void C_ccall f_25199(C_word c,C_word *av) C_noret;
C_noret_decl(f_25205)
static void C_ccall f_25205(C_word c,C_word *av) C_noret;
C_noret_decl(f_25210)
static void C_fcall f_25210(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25223)
static void C_ccall f_25223(C_word c,C_word *av) C_noret;
C_noret_decl(f_25226)
static void C_ccall f_25226(C_word c,C_word *av) C_noret;
C_noret_decl(f_25237)
static void C_ccall f_25237(C_word c,C_word *av) C_noret;
C_noret_decl(f_25259)
static void C_ccall f_25259(C_word c,C_word *av) C_noret;
C_noret_decl(f_25271)
static void C_ccall f_25271(C_word c,C_word *av) C_noret;
C_noret_decl(f_25274)
static void C_ccall f_25274(C_word c,C_word *av) C_noret;
C_noret_decl(f_25281)
static void C_ccall f_25281(C_word c,C_word *av) C_noret;
C_noret_decl(f_25290)
static void C_ccall f_25290(C_word c,C_word *av) C_noret;
C_noret_decl(f_25293)
static void C_ccall f_25293(C_word c,C_word *av) C_noret;
C_noret_decl(f_25337)
static void C_ccall f_25337(C_word c,C_word *av) C_noret;
C_noret_decl(f_25340)
static void C_ccall f_25340(C_word c,C_word *av) C_noret;
C_noret_decl(f_25349)
static void C_fcall f_25349(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_25362)
static void C_ccall f_25362(C_word c,C_word *av) C_noret;
C_noret_decl(f_25365)
static void C_ccall f_25365(C_word c,C_word *av) C_noret;
C_noret_decl(f_25390)
static void C_ccall f_25390(C_word c,C_word *av) C_noret;
C_noret_decl(f_25394)
static void C_ccall f_25394(C_word c,C_word *av) C_noret;
C_noret_decl(f_25404)
static void C_ccall f_25404(C_word c,C_word *av) C_noret;
C_noret_decl(f_25407)
static void C_ccall f_25407(C_word c,C_word *av) C_noret;
C_noret_decl(f_25422)
static void C_ccall f_25422(C_word c,C_word *av) C_noret;
C_noret_decl(f_25429)
static void C_ccall f_25429(C_word c,C_word *av) C_noret;
C_noret_decl(f_25451)
static void C_ccall f_25451(C_word c,C_word *av) C_noret;
C_noret_decl(f_25453)
static void C_ccall f_25453(C_word c,C_word *av) C_noret;
C_noret_decl(f_25466)
static void C_ccall f_25466(C_word c,C_word *av) C_noret;
C_noret_decl(f_25471)
static void C_ccall f_25471(C_word c,C_word *av) C_noret;
C_noret_decl(f_25477)
static void C_ccall f_25477(C_word c,C_word *av) C_noret;
C_noret_decl(f_25483)
static void C_ccall f_25483(C_word c,C_word *av) C_noret;
C_noret_decl(f_25487)
static void C_ccall f_25487(C_word c,C_word *av) C_noret;
C_noret_decl(f_25490)
static void C_ccall f_25490(C_word c,C_word *av) C_noret;
C_noret_decl(f_25505)
static void C_ccall f_25505(C_word c,C_word *av) C_noret;
C_noret_decl(f_25508)
static void C_ccall f_25508(C_word c,C_word *av) C_noret;
C_noret_decl(f_25526)
static void C_ccall f_25526(C_word c,C_word *av) C_noret;
C_noret_decl(f_25528)
static void C_ccall f_25528(C_word c,C_word *av) C_noret;
C_noret_decl(f_25534)
static void C_ccall f_25534(C_word c,C_word *av) C_noret;
C_noret_decl(f_25543)
static void C_ccall f_25543(C_word c,C_word *av) C_noret;
C_noret_decl(f_25549)
static void C_ccall f_25549(C_word c,C_word *av) C_noret;
C_noret_decl(f_25556)
static void C_ccall f_25556(C_word c,C_word *av) C_noret;
C_noret_decl(f_25559)
static void C_ccall f_25559(C_word c,C_word *av) C_noret;
C_noret_decl(f_25562)
static void C_ccall f_25562(C_word c,C_word *av) C_noret;
C_noret_decl(f_25571)
static void C_ccall f_25571(C_word c,C_word *av) C_noret;
C_noret_decl(f_25587)
static void C_ccall f_25587(C_word c,C_word *av) C_noret;
C_noret_decl(f_25602)
static void C_ccall f_25602(C_word c,C_word *av) C_noret;
C_noret_decl(f_25604)
static void C_ccall f_25604(C_word c,C_word *av) C_noret;
C_noret_decl(f_25610)
static void C_ccall f_25610(C_word c,C_word *av) C_noret;
C_noret_decl(f_25616)
static void C_ccall f_25616(C_word c,C_word *av) C_noret;
C_noret_decl(f_25620)
static void C_ccall f_25620(C_word c,C_word *av) C_noret;
C_noret_decl(f_25623)
static void C_ccall f_25623(C_word c,C_word *av) C_noret;
C_noret_decl(f_25626)
static void C_ccall f_25626(C_word c,C_word *av) C_noret;
C_noret_decl(f_25630)
static void C_ccall f_25630(C_word c,C_word *av) C_noret;
C_noret_decl(f_25634)
static void C_ccall f_25634(C_word c,C_word *av) C_noret;
C_noret_decl(f_25638)
static void C_ccall f_25638(C_word c,C_word *av) C_noret;
C_noret_decl(f_25641)
static void C_ccall f_25641(C_word c,C_word *av) C_noret;
C_noret_decl(f_25644)
static void C_ccall f_25644(C_word c,C_word *av) C_noret;
C_noret_decl(f_25647)
static void C_ccall f_25647(C_word c,C_word *av) C_noret;
C_noret_decl(f_25659)
static void C_ccall f_25659(C_word c,C_word *av) C_noret;
C_noret_decl(f_25665)
static void C_ccall f_25665(C_word c,C_word *av) C_noret;
C_noret_decl(f_25669)
static void C_ccall f_25669(C_word c,C_word *av) C_noret;
C_noret_decl(f_25672)
static void C_ccall f_25672(C_word c,C_word *av) C_noret;
C_noret_decl(f_25675)
static void C_ccall f_25675(C_word c,C_word *av) C_noret;
C_noret_decl(f_25678)
static void C_ccall f_25678(C_word c,C_word *av) C_noret;
C_noret_decl(f_25681)
static void C_ccall f_25681(C_word c,C_word *av) C_noret;
C_noret_decl(f_25684)
static void C_ccall f_25684(C_word c,C_word *av) C_noret;
C_noret_decl(f_25689)
static void C_ccall f_25689(C_word c,C_word *av) C_noret;
C_noret_decl(f_25711)
static void C_ccall f_25711(C_word c,C_word *av) C_noret;
C_noret_decl(f_25717)
static void C_ccall f_25717(C_word c,C_word *av) C_noret;
C_noret_decl(f_25720)
static void C_ccall f_25720(C_word c,C_word *av) C_noret;
C_noret_decl(f_25745)
static void C_ccall f_25745(C_word c,C_word *av) C_noret;
C_noret_decl(f_25748)
static void C_fcall f_25748(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_25755)
static void C_ccall f_25755(C_word c,C_word *av) C_noret;
C_noret_decl(f_25768)
static void C_fcall f_25768(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_25778)
static void C_ccall f_25778(C_word c,C_word *av) C_noret;
C_noret_decl(f_25783)
static void C_ccall f_25783(C_word c,C_word *av) C_noret;
C_noret_decl(f_25789)
static void C_ccall f_25789(C_word c,C_word *av) C_noret;
C_noret_decl(f_25816)
static void C_ccall f_25816(C_word c,C_word *av) C_noret;
C_noret_decl(f_25822)
static void C_fcall f_25822(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25833)
static void C_ccall f_25833(C_word c,C_word *av) C_noret;
C_noret_decl(f_25842)
static void C_ccall f_25842(C_word c,C_word *av) C_noret;
C_noret_decl(f_25847)
static void C_ccall f_25847(C_word c,C_word *av) C_noret;
C_noret_decl(f_25853)
static void C_ccall f_25853(C_word c,C_word *av) C_noret;
C_noret_decl(f_25877)
static void C_ccall f_25877(C_word c,C_word *av) C_noret;
C_noret_decl(f_25885)
static void C_ccall f_25885(C_word c,C_word *av) C_noret;
C_noret_decl(f_25902)
static void C_ccall f_25902(C_word c,C_word *av) C_noret;
C_noret_decl(f_25942)
static void C_ccall f_25942(C_word c,C_word *av) C_noret;
C_noret_decl(f_25949)
static void C_ccall f_25949(C_word c,C_word *av) C_noret;
C_noret_decl(f_25961)
static void C_ccall f_25961(C_word c,C_word *av) C_noret;
C_noret_decl(f_25965)
static void C_ccall f_25965(C_word c,C_word *av) C_noret;
C_noret_decl(f_25978)
static void C_ccall f_25978(C_word c,C_word *av) C_noret;
C_noret_decl(f_25980)
static void C_ccall f_25980(C_word c,C_word *av) C_noret;
C_noret_decl(f_26014)
static void C_ccall f_26014(C_word c,C_word *av) C_noret;
C_noret_decl(f_26018)
static void C_ccall f_26018(C_word c,C_word *av) C_noret;
C_noret_decl(f_26019)
static void C_fcall f_26019(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26029)
static void C_ccall f_26029(C_word c,C_word *av) C_noret;
C_noret_decl(f_26034)
static void C_fcall f_26034(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26044)
static void C_ccall f_26044(C_word c,C_word *av) C_noret;
C_noret_decl(f_26057)
static void C_ccall f_26057(C_word c,C_word *av) C_noret;
C_noret_decl(f_26068)
static void C_ccall f_26068(C_word c,C_word *av) C_noret;
C_noret_decl(f_26072)
static void C_ccall f_26072(C_word c,C_word *av) C_noret;
C_noret_decl(f_26076)
static void C_ccall f_26076(C_word c,C_word *av) C_noret;
C_noret_decl(f_26098)
static void C_ccall f_26098(C_word c,C_word *av) C_noret;
C_noret_decl(f_26102)
static void C_ccall f_26102(C_word c,C_word *av) C_noret;
C_noret_decl(f_26110)
static void C_ccall f_26110(C_word c,C_word *av) C_noret;
C_noret_decl(f_26126)
static void C_ccall f_26126(C_word c,C_word *av) C_noret;
C_noret_decl(f_26137)
static void C_fcall f_26137(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26156)
static void C_fcall f_26156(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26167)
static void C_ccall f_26167(C_word c,C_word *av) C_noret;
C_noret_decl(f_26178)
static void C_ccall f_26178(C_word c,C_word *av) C_noret;
C_noret_decl(f_26264)
static void C_ccall f_26264(C_word c,C_word *av) C_noret;
C_noret_decl(f_26274)
static void C_ccall f_26274(C_word c,C_word *av) C_noret;
C_noret_decl(f_26275)
static void C_fcall f_26275(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26288)
static void C_ccall f_26288(C_word c,C_word *av) C_noret;
C_noret_decl(f_26291)
static void C_ccall f_26291(C_word c,C_word *av) C_noret;
C_noret_decl(f_26294)
static void C_ccall f_26294(C_word c,C_word *av) C_noret;
C_noret_decl(f_26297)
static void C_ccall f_26297(C_word c,C_word *av) C_noret;
C_noret_decl(f_26305)
static void C_ccall f_26305(C_word c,C_word *av) C_noret;
C_noret_decl(f_26312)
static void C_fcall f_26312(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26315)
static void C_ccall f_26315(C_word c,C_word *av) C_noret;
C_noret_decl(f_26318)
static void C_ccall f_26318(C_word c,C_word *av) C_noret;
C_noret_decl(f_26341)
static void C_ccall f_26341(C_word c,C_word *av) C_noret;
C_noret_decl(f_26346)
static void C_fcall f_26346(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26356)
static void C_ccall f_26356(C_word c,C_word *av) C_noret;
C_noret_decl(f_26369)
static void C_ccall f_26369(C_word c,C_word *av) C_noret;
C_noret_decl(f_26400)
static void C_ccall f_26400(C_word c,C_word *av) C_noret;
C_noret_decl(f_26410)
static void C_ccall f_26410(C_word c,C_word *av) C_noret;
C_noret_decl(f_26460)
static void C_ccall f_26460(C_word c,C_word *av) C_noret;
C_noret_decl(f_26463)
static void C_ccall f_26463(C_word c,C_word *av) C_noret;
C_noret_decl(f_26482)
static void C_fcall f_26482(C_word t0) C_noret;
C_noret_decl(f_26487)
static void C_ccall f_26487(C_word c,C_word *av) C_noret;
C_noret_decl(f_26493)
static void C_ccall f_26493(C_word c,C_word *av) C_noret;
C_noret_decl(f_26496)
static void C_ccall f_26496(C_word c,C_word *av) C_noret;
C_noret_decl(f_26505)
static void C_ccall f_26505(C_word c,C_word *av) C_noret;
C_noret_decl(f_26511)
static void C_ccall f_26511(C_word c,C_word *av) C_noret;
C_noret_decl(f_26530)
static void C_fcall f_26530(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26549)
static void C_ccall f_26549(C_word c,C_word *av) C_noret;
C_noret_decl(f_26554)
static void C_fcall f_26554(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26564)
static void C_ccall f_26564(C_word c,C_word *av) C_noret;
C_noret_decl(f_26578)
static void C_ccall f_26578(C_word c,C_word *av) C_noret;
C_noret_decl(f_26585)
static void C_ccall f_26585(C_word c,C_word *av) C_noret;
C_noret_decl(f_26589)
static void C_ccall f_26589(C_word c,C_word *av) C_noret;
C_noret_decl(f_26593)
static void C_ccall f_26593(C_word c,C_word *av) C_noret;
C_noret_decl(f_26595)
static void C_ccall f_26595(C_word c,C_word *av) C_noret;
C_noret_decl(f_26621)
static void C_ccall f_26621(C_word c,C_word *av) C_noret;
C_noret_decl(f_26624)
static void C_ccall f_26624(C_word c,C_word *av) C_noret;
C_noret_decl(f_26627)
static void C_ccall f_26627(C_word c,C_word *av) C_noret;
C_noret_decl(f_26634)
static void C_ccall f_26634(C_word c,C_word *av) C_noret;
C_noret_decl(f_26638)
static void C_ccall f_26638(C_word c,C_word *av) C_noret;
C_noret_decl(f_26644)
static void C_ccall f_26644(C_word c,C_word *av) C_noret;
C_noret_decl(f_26649)
static void C_fcall f_26649(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26659)
static void C_ccall f_26659(C_word c,C_word *av) C_noret;
C_noret_decl(f_26697)
static void C_fcall f_26697(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26700)
static void C_fcall f_26700(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26720)
static void C_fcall f_26720(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26738)
static void C_ccall f_26738(C_word c,C_word *av) C_noret;
C_noret_decl(f_26872)
static void C_ccall f_26872(C_word c,C_word *av) C_noret;
C_noret_decl(f_26889)
static void C_ccall f_26889(C_word c,C_word *av) C_noret;
C_noret_decl(f_26904)
static void C_ccall f_26904(C_word c,C_word *av) C_noret;
C_noret_decl(f_26908)
static void C_ccall f_26908(C_word c,C_word *av) C_noret;
C_noret_decl(f_26921)
static void C_ccall f_26921(C_word c,C_word *av) C_noret;
C_noret_decl(f_26929)
static void C_ccall f_26929(C_word c,C_word *av) C_noret;
C_noret_decl(f_26932)
static void C_ccall f_26932(C_word c,C_word *av) C_noret;
C_noret_decl(f_26936)
static void C_ccall f_26936(C_word c,C_word *av) C_noret;
C_noret_decl(f_26975)
static void C_ccall f_26975(C_word c,C_word *av) C_noret;
C_noret_decl(f_26978)
static void C_ccall f_26978(C_word c,C_word *av) C_noret;
C_noret_decl(f_26985)
static void C_ccall f_26985(C_word c,C_word *av) C_noret;
C_noret_decl(f_26989)
static void C_ccall f_26989(C_word c,C_word *av) C_noret;
C_noret_decl(f_27015)
static void C_ccall f_27015(C_word c,C_word *av) C_noret;
C_noret_decl(f_27046)
static void C_ccall f_27046(C_word c,C_word *av) C_noret;
C_noret_decl(f_27049)
static void C_ccall f_27049(C_word c,C_word *av) C_noret;
C_noret_decl(f_27061)
static void C_ccall f_27061(C_word c,C_word *av) C_noret;
C_noret_decl(f_27064)
static void C_ccall f_27064(C_word c,C_word *av) C_noret;
C_noret_decl(f_27067)
static void C_ccall f_27067(C_word c,C_word *av) C_noret;
C_noret_decl(f_27092)
static void C_ccall f_27092(C_word c,C_word *av) C_noret;
C_noret_decl(f_27098)
static void C_ccall f_27098(C_word c,C_word *av) C_noret;
C_noret_decl(f_27102)
static void C_ccall f_27102(C_word c,C_word *av) C_noret;
C_noret_decl(f_27106)
static void C_ccall f_27106(C_word c,C_word *av) C_noret;
C_noret_decl(f_27119)
static void C_ccall f_27119(C_word c,C_word *av) C_noret;
C_noret_decl(f_27121)
static C_word C_fcall f_27121(C_word t0,C_word t1);
C_noret_decl(f_27127)
static C_word C_fcall f_27127(C_word t0);
C_noret_decl(f_27132)
static C_word C_fcall f_27132(C_word t0);
C_noret_decl(f_27167)
static void C_fcall f_27167(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_27173)
static void C_fcall f_27173(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27189)
static void C_fcall f_27189(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27211)
static void C_ccall f_27211(C_word c,C_word *av) C_noret;
C_noret_decl(f_27235)
static void C_ccall f_27235(C_word c,C_word *av) C_noret;
C_noret_decl(f_27247)
static void C_ccall f_27247(C_word c,C_word *av) C_noret;
C_noret_decl(f_27249)
static void C_ccall f_27249(C_word c,C_word *av) C_noret;
C_noret_decl(f_27268)
static void C_ccall f_27268(C_word c,C_word *av) C_noret;
C_noret_decl(f_27272)
static void C_ccall f_27272(C_word c,C_word *av) C_noret;
C_noret_decl(f_27284)
static void C_ccall f_27284(C_word c,C_word *av) C_noret;
C_noret_decl(f_27286)
static void C_fcall f_27286(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27330)
static void C_ccall f_27330(C_word c,C_word *av) C_noret;
C_noret_decl(f_27332)
static void C_fcall f_27332(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27366)
static C_word C_fcall f_27366(C_word t0);
C_noret_decl(f_27389)
static void C_ccall f_27389(C_word c,C_word *av) C_noret;
C_noret_decl(f_27396)
static void C_ccall f_27396(C_word c,C_word *av) C_noret;
C_noret_decl(f_27406)
static void C_ccall f_27406(C_word c,C_word *av) C_noret;
C_noret_decl(f_27408)
static void C_fcall f_27408(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27458)
static void C_ccall f_27458(C_word c,C_word *av) C_noret;
C_noret_decl(f_27460)
static void C_fcall f_27460(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27485)
static void C_ccall f_27485(C_word c,C_word *av) C_noret;
C_noret_decl(f_27494)
static void C_ccall f_27494(C_word c,C_word *av) C_noret;
C_noret_decl(f_27500)
static void C_ccall f_27500(C_word c,C_word *av) C_noret;
C_noret_decl(f_27504)
static void C_ccall f_27504(C_word c,C_word *av) C_noret;
C_noret_decl(f_27508)
static void C_fcall f_27508(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27516)
static void C_ccall f_27516(C_word c,C_word *av) C_noret;
C_noret_decl(f_27522)
static void C_fcall f_27522(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27553)
static void C_ccall f_27553(C_word c,C_word *av) C_noret;
C_noret_decl(f_27578)
static void C_fcall f_27578(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27603)
static void C_ccall f_27603(C_word c,C_word *av) C_noret;
C_noret_decl(f_27613)
static void C_ccall f_27613(C_word c,C_word *av) C_noret;
C_noret_decl(f_27618)
static void C_ccall f_27618(C_word c,C_word *av) C_noret;
C_noret_decl(f_27620)
static void C_ccall f_27620(C_word c,C_word *av) C_noret;
C_noret_decl(f_27627)
static void C_ccall f_27627(C_word c,C_word *av) C_noret;
C_noret_decl(f_27639)
static void C_ccall f_27639(C_word c,C_word *av) C_noret;
C_noret_decl(f_27647)
static void C_ccall f_27647(C_word c,C_word *av) C_noret;
C_noret_decl(f_27685)
static void C_ccall f_27685(C_word c,C_word *av) C_noret;
C_noret_decl(f_27689)
static void C_ccall f_27689(C_word c,C_word *av) C_noret;
C_noret_decl(f_27696)
static void C_ccall f_27696(C_word c,C_word *av) C_noret;
C_noret_decl(f_27699)
static void C_ccall f_27699(C_word c,C_word *av) C_noret;
C_noret_decl(f_27702)
static void C_ccall f_27702(C_word c,C_word *av) C_noret;
C_noret_decl(f_27703)
static void C_fcall f_27703(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27705)
static void C_fcall f_27705(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27709)
static void C_ccall f_27709(C_word c,C_word *av) C_noret;
C_noret_decl(f_27714)
static void C_ccall f_27714(C_word c,C_word *av) C_noret;
C_noret_decl(f_27726)
static void C_fcall f_27726(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27736)
static void C_ccall f_27736(C_word c,C_word *av) C_noret;
C_noret_decl(f_27748)
static void C_ccall f_27748(C_word c,C_word *av) C_noret;
C_noret_decl(f_27750)
static void C_fcall f_27750(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_27757)
static void C_ccall f_27757(C_word c,C_word *av) C_noret;
C_noret_decl(f_27760)
static void C_ccall f_27760(C_word c,C_word *av) C_noret;
C_noret_decl(f_27769)
static void C_ccall f_27769(C_word c,C_word *av) C_noret;
C_noret_decl(f_27772)
static void C_ccall f_27772(C_word c,C_word *av) C_noret;
C_noret_decl(f_27775)
static void C_ccall f_27775(C_word c,C_word *av) C_noret;
C_noret_decl(f_27790)
static void C_ccall f_27790(C_word c,C_word *av) C_noret;
C_noret_decl(f_27796)
static void C_ccall f_27796(C_word c,C_word *av) C_noret;
C_noret_decl(f_27804)
static void C_fcall f_27804(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27808)
static void C_ccall f_27808(C_word c,C_word *av) C_noret;
C_noret_decl(f_27811)
static void C_ccall f_27811(C_word c,C_word *av) C_noret;
C_noret_decl(f_27814)
static void C_ccall f_27814(C_word c,C_word *av) C_noret;
C_noret_decl(f_27827)
static void C_ccall f_27827(C_word c,C_word *av) C_noret;
C_noret_decl(f_27831)
static void C_ccall f_27831(C_word c,C_word *av) C_noret;
C_noret_decl(f_27852)
static void C_ccall f_27852(C_word c,C_word *av) C_noret;
C_noret_decl(f_27868)
static void C_ccall f_27868(C_word c,C_word *av) C_noret;
C_noret_decl(f_27871)
static void C_ccall f_27871(C_word c,C_word *av) C_noret;
C_noret_decl(f_27877)
static void C_ccall f_27877(C_word c,C_word *av) C_noret;
C_noret_decl(f_27899)
static void C_fcall f_27899(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27904)
static void C_fcall f_27904(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27939)
static void C_ccall f_27939(C_word c,C_word *av) C_noret;
C_noret_decl(f_27949)
static void C_ccall f_27949(C_word c,C_word *av) C_noret;
C_noret_decl(f_27952)
static void C_ccall f_27952(C_word c,C_word *av) C_noret;
C_noret_decl(f_27955)
static void C_ccall f_27955(C_word c,C_word *av) C_noret;
C_noret_decl(f_27958)
static void C_ccall f_27958(C_word c,C_word *av) C_noret;
C_noret_decl(f_27961)
static void C_ccall f_27961(C_word c,C_word *av) C_noret;
C_noret_decl(f_27964)
static void C_ccall f_27964(C_word c,C_word *av) C_noret;
C_noret_decl(f_27971)
static void C_ccall f_27971(C_word c,C_word *av) C_noret;
C_noret_decl(f_27974)
static void C_ccall f_27974(C_word c,C_word *av) C_noret;
C_noret_decl(f_27977)
static void C_ccall f_27977(C_word c,C_word *av) C_noret;
C_noret_decl(f_27988)
static void C_ccall f_27988(C_word c,C_word *av) C_noret;
C_noret_decl(f_28011)
static void C_ccall f_28011(C_word c,C_word *av) C_noret;
C_noret_decl(f_28022)
static void C_ccall f_28022(C_word c,C_word *av) C_noret;
C_noret_decl(f_28026)
static void C_ccall f_28026(C_word c,C_word *av) C_noret;
C_noret_decl(f_28048)
static void C_ccall f_28048(C_word c,C_word *av) C_noret;
C_noret_decl(f_28059)
static void C_ccall f_28059(C_word c,C_word *av) C_noret;
C_noret_decl(f_28063)
static void C_ccall f_28063(C_word c,C_word *av) C_noret;
C_noret_decl(f_28562)
static void C_ccall f_28562(C_word c,C_word *av) C_noret;
C_noret_decl(f_28573)
static void C_ccall f_28573(C_word c,C_word *av) C_noret;
C_noret_decl(f_28577)
static void C_ccall f_28577(C_word c,C_word *av) C_noret;
C_noret_decl(f_28694)
static void C_ccall f_28694(C_word c,C_word *av) C_noret;
C_noret_decl(f_28697)
static void C_ccall f_28697(C_word c,C_word *av) C_noret;
C_noret_decl(f_28700)
static void C_ccall f_28700(C_word c,C_word *av) C_noret;
C_noret_decl(f_28703)
static void C_ccall f_28703(C_word c,C_word *av) C_noret;
C_noret_decl(f_28708)
static void C_ccall f_28708(C_word c,C_word *av) C_noret;
C_noret_decl(f_28711)
static void C_ccall f_28711(C_word c,C_word *av) C_noret;
C_noret_decl(f_28714)
static void C_ccall f_28714(C_word c,C_word *av) C_noret;
C_noret_decl(f_28717)
static void C_ccall f_28717(C_word c,C_word *av) C_noret;
C_noret_decl(f_28720)
static void C_ccall f_28720(C_word c,C_word *av) C_noret;
C_noret_decl(f_28723)
static void C_ccall f_28723(C_word c,C_word *av) C_noret;
C_noret_decl(f_28726)
static void C_ccall f_28726(C_word c,C_word *av) C_noret;
C_noret_decl(f_28729)
static void C_ccall f_28729(C_word c,C_word *av) C_noret;
C_noret_decl(f_28732)
static void C_ccall f_28732(C_word c,C_word *av) C_noret;
C_noret_decl(f_28736)
static void C_ccall f_28736(C_word c,C_word *av) C_noret;
C_noret_decl(f_28738)
static void C_ccall f_28738(C_word c,C_word *av) C_noret;
C_noret_decl(f_28746)
static void C_ccall f_28746(C_word c,C_word *av) C_noret;
C_noret_decl(f_28748)
static void C_ccall f_28748(C_word c,C_word *av) C_noret;
C_noret_decl(f_28752)
static void C_ccall f_28752(C_word c,C_word *av) C_noret;
C_noret_decl(f_28754)
static void C_ccall f_28754(C_word c,C_word *av) C_noret;
C_noret_decl(f_28761)
static void C_ccall f_28761(C_word c,C_word *av) C_noret;
C_noret_decl(f_28771)
static void C_ccall f_28771(C_word c,C_word *av) C_noret;
C_noret_decl(f_28796)
static void C_ccall f_28796(C_word c,C_word *av) C_noret;
C_noret_decl(f_28799)
static void C_ccall f_28799(C_word c,C_word *av) C_noret;
C_noret_decl(f_28802)
static void C_ccall f_28802(C_word c,C_word *av) C_noret;
C_noret_decl(f_28805)
static void C_ccall f_28805(C_word c,C_word *av) C_noret;
C_noret_decl(f_28808)
static void C_ccall f_28808(C_word c,C_word *av) C_noret;
C_noret_decl(f_28818)
static void C_ccall f_28818(C_word c,C_word *av) C_noret;
C_noret_decl(f_28824)
static void C_ccall f_28824(C_word c,C_word *av) C_noret;
C_noret_decl(f_28828)
static void C_ccall f_28828(C_word c,C_word *av) C_noret;
C_noret_decl(f_28830)
static void C_ccall f_28830(C_word c,C_word *av) C_noret;
C_noret_decl(f_28840)
static void C_ccall f_28840(C_word c,C_word *av) C_noret;
C_noret_decl(f_28846)
static void C_ccall f_28846(C_word c,C_word *av) C_noret;
C_noret_decl(f_28850)
static void C_ccall f_28850(C_word c,C_word *av) C_noret;
C_noret_decl(f_28852)
static void C_ccall f_28852(C_word c,C_word *av) C_noret;
C_noret_decl(f_28857)
static void C_ccall f_28857(C_word c,C_word *av) C_noret;
C_noret_decl(f_28859)
static void C_ccall f_28859(C_word c,C_word *av) C_noret;
C_noret_decl(f_28862)
static void C_ccall f_28862(C_word c,C_word *av) C_noret;
C_noret_decl(f_28882)
static void C_ccall f_28882(C_word c,C_word *av) C_noret;
C_noret_decl(f_28888)
static void C_fcall f_28888(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28898)
static void C_ccall f_28898(C_word c,C_word *av) C_noret;
C_noret_decl(f_28908)
static void C_ccall f_28908(C_word c,C_word *av) C_noret;
C_noret_decl(f_28943)
static void C_ccall f_28943(C_word c,C_word *av) C_noret;
C_noret_decl(f_28947)
static void C_ccall f_28947(C_word c,C_word *av) C_noret;
C_noret_decl(f_28952)
static void C_fcall f_28952(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28962)
static void C_ccall f_28962(C_word c,C_word *av) C_noret;
C_noret_decl(f_28972)
static void C_ccall f_28972(C_word c,C_word *av) C_noret;
C_noret_decl(f_28981)
static void C_ccall f_28981(C_word c,C_word *av) C_noret;
C_noret_decl(f_28984)
static void C_ccall f_28984(C_word c,C_word *av) C_noret;
C_noret_decl(f_28987)
static void C_ccall f_28987(C_word c,C_word *av) C_noret;
C_noret_decl(f_28994)
static void C_ccall f_28994(C_word c,C_word *av) C_noret;
C_noret_decl(f_29001)
static void C_ccall f_29001(C_word c,C_word *av) C_noret;
C_noret_decl(f_29004)
static void C_ccall f_29004(C_word c,C_word *av) C_noret;
C_noret_decl(f_29008)
static void C_ccall f_29008(C_word c,C_word *av) C_noret;
C_noret_decl(f_29010)
static void C_ccall f_29010(C_word c,C_word *av) C_noret;
C_noret_decl(f_29013)
static void C_ccall f_29013(C_word c,C_word *av) C_noret;
C_noret_decl(f_29016)
static void C_ccall f_29016(C_word c,C_word *av) C_noret;
C_noret_decl(f_29019)
static void C_ccall f_29019(C_word c,C_word *av) C_noret;
C_noret_decl(f_29022)
static void C_ccall f_29022(C_word c,C_word *av) C_noret;
C_noret_decl(f_29025)
static void C_ccall f_29025(C_word c,C_word *av) C_noret;
C_noret_decl(f_29028)
static void C_ccall f_29028(C_word c,C_word *av) C_noret;
C_noret_decl(f_29031)
static void C_ccall f_29031(C_word c,C_word *av) C_noret;
C_noret_decl(f_29034)
static void C_ccall f_29034(C_word c,C_word *av) C_noret;
C_noret_decl(f_29037)
static void C_ccall f_29037(C_word c,C_word *av) C_noret;
C_noret_decl(f_29040)
static void C_ccall f_29040(C_word c,C_word *av) C_noret;
C_noret_decl(f_29044)
static void C_ccall f_29044(C_word c,C_word *av) C_noret;
C_noret_decl(f_29047)
static void C_ccall f_29047(C_word c,C_word *av) C_noret;
C_noret_decl(f_29063)
static void C_ccall f_29063(C_word c,C_word *av) C_noret;
C_noret_decl(f_29071)
static void C_ccall f_29071(C_word c,C_word *av) C_noret;
C_noret_decl(f_29074)
static void C_ccall f_29074(C_word c,C_word *av) C_noret;
C_noret_decl(f_29080)
static void C_ccall f_29080(C_word c,C_word *av) C_noret;
C_noret_decl(f_29089)
static void C_ccall f_29089(C_word c,C_word *av) C_noret;
C_noret_decl(f_29095)
static void C_ccall f_29095(C_word c,C_word *av) C_noret;
C_noret_decl(f_29104)
static void C_ccall f_29104(C_word c,C_word *av) C_noret;
C_noret_decl(f_29110)
static void C_ccall f_29110(C_word c,C_word *av) C_noret;
C_noret_decl(f_29116)
static void C_ccall f_29116(C_word c,C_word *av) C_noret;
C_noret_decl(f_29119)
static void C_ccall f_29119(C_word c,C_word *av) C_noret;
C_noret_decl(f_29125)
static void C_ccall f_29125(C_word c,C_word *av) C_noret;
C_noret_decl(f_29131)
static void C_ccall f_29131(C_word c,C_word *av) C_noret;
C_noret_decl(f_29134)
static void C_ccall f_29134(C_word c,C_word *av) C_noret;
C_noret_decl(f_29140)
static void C_ccall f_29140(C_word c,C_word *av) C_noret;
C_noret_decl(f_29179)
static void C_ccall f_29179(C_word c,C_word *av) C_noret;
C_noret_decl(f_29222)
static void C_ccall f_29222(C_word c,C_word *av) C_noret;
C_noret_decl(f_29229)
static void C_ccall f_29229(C_word c,C_word *av) C_noret;
C_noret_decl(f_29234)
static void C_fcall f_29234(C_word t0,C_word t1) C_noret;
C_noret_decl(f_29250)
static void C_ccall f_29250(C_word c,C_word *av) C_noret;
C_noret_decl(f_29276)
static void C_ccall f_29276(C_word c,C_word *av) C_noret;
C_noret_decl(f_29279)
static void C_ccall f_29279(C_word c,C_word *av) C_noret;
C_noret_decl(f_29283)
static void C_ccall f_29283(C_word c,C_word *av) C_noret;
C_noret_decl(f_29286)
static void C_ccall f_29286(C_word c,C_word *av) C_noret;
C_noret_decl(f_29291)
static void C_ccall f_29291(C_word c,C_word *av) C_noret;
C_noret_decl(f_29293)
static void C_ccall f_29293(C_word c,C_word *av) C_noret;
C_noret_decl(f_29297)
static void C_ccall f_29297(C_word c,C_word *av) C_noret;
C_noret_decl(f_29324)
static void C_fcall f_29324(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29334)
static void C_ccall f_29334(C_word c,C_word *av) C_noret;
C_noret_decl(f_29343)
static void C_ccall f_29343(C_word c,C_word *av) C_noret;
C_noret_decl(f_29350)
static void C_ccall f_29350(C_word c,C_word *av) C_noret;
C_noret_decl(f_29354)
static void C_ccall f_29354(C_word c,C_word *av) C_noret;
C_noret_decl(f_29368)
static void C_fcall f_29368(C_word t0,C_word t1) C_noret;
C_noret_decl(f_29372)
static void C_ccall f_29372(C_word c,C_word *av) C_noret;
C_noret_decl(f_29379)
static void C_ccall f_29379(C_word c,C_word *av) C_noret;
C_noret_decl(f_29381)
static void C_fcall f_29381(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29403)
static void C_ccall f_29403(C_word c,C_word *av) C_noret;
C_noret_decl(f_29410)
static void C_ccall f_29410(C_word c,C_word *av) C_noret;
C_noret_decl(f_29415)
static void C_fcall f_29415(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29419)
static void C_ccall f_29419(C_word c,C_word *av) C_noret;
C_noret_decl(f_29422)
static void C_ccall f_29422(C_word c,C_word *av) C_noret;
C_noret_decl(f_29425)
static void C_ccall f_29425(C_word c,C_word *av) C_noret;
C_noret_decl(f_29430)
static void C_fcall f_29430(C_word t0,C_word t1) C_noret;
C_noret_decl(f_29434)
static void C_ccall f_29434(C_word c,C_word *av) C_noret;
C_noret_decl(f_29460)
static void C_ccall f_29460(C_word c,C_word *av) C_noret;
C_noret_decl(f_29473)
static void C_ccall f_29473(C_word c,C_word *av) C_noret;
C_noret_decl(f_29476)
static void C_ccall f_29476(C_word c,C_word *av) C_noret;
C_noret_decl(f_29485)
static void C_ccall f_29485(C_word c,C_word *av) C_noret;
C_noret_decl(f_29488)
static void C_ccall f_29488(C_word c,C_word *av) C_noret;
C_noret_decl(f_29491)
static void C_ccall f_29491(C_word c,C_word *av) C_noret;
C_noret_decl(f_29497)
static void C_ccall f_29497(C_word c,C_word *av) C_noret;
C_noret_decl(f_29504)
static void C_ccall f_29504(C_word c,C_word *av) C_noret;
C_noret_decl(f_29506)
static void C_fcall f_29506(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29519)
static void C_ccall f_29519(C_word c,C_word *av) C_noret;
C_noret_decl(f_29532)
static void C_ccall f_29532(C_word c,C_word *av) C_noret;
C_noret_decl(f_29535)
static void C_ccall f_29535(C_word c,C_word *av) C_noret;
C_noret_decl(f_29538)
static void C_ccall f_29538(C_word c,C_word *av) C_noret;
C_noret_decl(f_29545)
static void C_ccall f_29545(C_word c,C_word *av) C_noret;
C_noret_decl(f_29598)
static void C_ccall f_29598(C_word c,C_word *av) C_noret;
C_noret_decl(f_29601)
static void C_ccall f_29601(C_word c,C_word *av) C_noret;
C_noret_decl(f_29604)
static void C_ccall f_29604(C_word c,C_word *av) C_noret;
C_noret_decl(f_29606)
static void C_fcall f_29606(C_word t0,C_word t1) C_noret;
C_noret_decl(f_29610)
static void C_ccall f_29610(C_word c,C_word *av) C_noret;
C_noret_decl(f_29614)
static void C_ccall f_29614(C_word c,C_word *av) C_noret;
C_noret_decl(f_29620)
static void C_ccall f_29620(C_word c,C_word *av) C_noret;
C_noret_decl(f_29625)
static void C_fcall f_29625(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29629)
static void C_ccall f_29629(C_word c,C_word *av) C_noret;
C_noret_decl(f_29641)
static void C_ccall f_29641(C_word c,C_word *av) C_noret;
C_noret_decl(f_29653)
static void C_ccall f_29653(C_word c,C_word *av) C_noret;
C_noret_decl(f_29660)
static void C_ccall f_29660(C_word c,C_word *av) C_noret;
C_noret_decl(f_29666)
static void C_fcall f_29666(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_29680)
static void C_ccall f_29680(C_word c,C_word *av) C_noret;
C_noret_decl(f_29719)
static void C_ccall f_29719(C_word c,C_word *av) C_noret;
C_noret_decl(f_29738)
static void C_ccall f_29738(C_word c,C_word *av) C_noret;
C_noret_decl(f_29761)
static void C_ccall f_29761(C_word c,C_word *av) C_noret;
C_noret_decl(f_29770)
static void C_ccall f_29770(C_word c,C_word *av) C_noret;
C_noret_decl(f_29777)
static void C_ccall f_29777(C_word c,C_word *av) C_noret;
C_noret_decl(f_29794)
static void C_ccall f_29794(C_word c,C_word *av) C_noret;
C_noret_decl(f_29802)
static void C_ccall f_29802(C_word c,C_word *av) C_noret;
C_noret_decl(f_29813)
static void C_ccall f_29813(C_word c,C_word *av) C_noret;
C_noret_decl(f_29821)
static void C_ccall f_29821(C_word c,C_word *av) C_noret;
C_noret_decl(f_29828)
static void C_ccall f_29828(C_word c,C_word *av) C_noret;
C_noret_decl(f_29890)
static void C_ccall f_29890(C_word c,C_word *av) C_noret;
C_noret_decl(f_29897)
static void C_ccall f_29897(C_word c,C_word *av) C_noret;
C_noret_decl(f_29900)
static void C_ccall f_29900(C_word c,C_word *av) C_noret;
C_noret_decl(f_29910)
static void C_ccall f_29910(C_word c,C_word *av) C_noret;
C_noret_decl(f_29914)
static void C_ccall f_29914(C_word c,C_word *av) C_noret;
C_noret_decl(f_29918)
static void C_ccall f_29918(C_word c,C_word *av) C_noret;
C_noret_decl(f_29921)
static void C_ccall f_29921(C_word c,C_word *av) C_noret;
C_noret_decl(f_29929)
static void C_ccall f_29929(C_word c,C_word *av) C_noret;
C_noret_decl(f_29931)
static void C_ccall f_29931(C_word c,C_word *av) C_noret;
C_noret_decl(f_29940)
static void C_ccall f_29940(C_word c,C_word *av) C_noret;
C_noret_decl(f_29946)
static void C_ccall f_29946(C_word c,C_word *av) C_noret;
C_noret_decl(f_29957)
static void C_ccall f_29957(C_word c,C_word *av) C_noret;
C_noret_decl(f_29961)
static void C_ccall f_29961(C_word c,C_word *av) C_noret;
C_noret_decl(f_29963)
static void C_ccall f_29963(C_word c,C_word *av) C_noret;
C_noret_decl(f_29971)
static void C_ccall f_29971(C_word c,C_word *av) C_noret;
C_noret_decl(f_29983)
static void C_ccall f_29983(C_word c,C_word *av) C_noret;
C_noret_decl(f_29989)
static void C_fcall f_29989(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29993)
static void C_ccall f_29993(C_word c,C_word *av) C_noret;
C_noret_decl(f_30001)
static void C_fcall f_30001(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30019)
static void C_ccall f_30019(C_word c,C_word *av) C_noret;
C_noret_decl(f_30027)
static void C_ccall f_30027(C_word c,C_word *av) C_noret;
C_noret_decl(f_30031)
static void C_ccall f_30031(C_word c,C_word *av) C_noret;
C_noret_decl(f_30049)
static void C_ccall f_30049(C_word c,C_word *av) C_noret;
C_noret_decl(f_30056)
static void C_ccall f_30056(C_word c,C_word *av) C_noret;
C_noret_decl(f_30068)
static void C_ccall f_30068(C_word c,C_word *av) C_noret;
C_noret_decl(f_30076)
static void C_ccall f_30076(C_word c,C_word *av) C_noret;
C_noret_decl(f_30082)
static void C_fcall f_30082(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_30104)
static void C_ccall f_30104(C_word c,C_word *av) C_noret;
C_noret_decl(f_30108)
static void C_ccall f_30108(C_word c,C_word *av) C_noret;
C_noret_decl(f_30112)
static void C_ccall f_30112(C_word c,C_word *av) C_noret;
C_noret_decl(f_30114)
static void C_ccall f_30114(C_word c,C_word *av) C_noret;
C_noret_decl(f_30117)
static void C_ccall f_30117(C_word c,C_word *av) C_noret;
C_noret_decl(f_30120)
static void C_ccall f_30120(C_word c,C_word *av) C_noret;
C_noret_decl(f_30124)
static void C_ccall f_30124(C_word c,C_word *av) C_noret;
C_noret_decl(f_30127)
static void C_ccall f_30127(C_word c,C_word *av) C_noret;
C_noret_decl(f_30149)
static void C_ccall f_30149(C_word c,C_word *av) C_noret;
C_noret_decl(f_30155)
static void C_ccall f_30155(C_word c,C_word *av) C_noret;
C_noret_decl(f_30159)
static void C_ccall f_30159(C_word c,C_word *av) C_noret;
C_noret_decl(f_30176)
static void C_ccall f_30176(C_word c,C_word *av) C_noret;
C_noret_decl(f_30186)
static void C_ccall f_30186(C_word c,C_word *av) C_noret;
C_noret_decl(f_30190)
static void C_ccall f_30190(C_word c,C_word *av) C_noret;
C_noret_decl(f_30194)
static void C_ccall f_30194(C_word c,C_word *av) C_noret;
C_noret_decl(f_30206)
static void C_ccall f_30206(C_word c,C_word *av) C_noret;
C_noret_decl(f_30216)
static void C_ccall f_30216(C_word c,C_word *av) C_noret;
C_noret_decl(f_30225)
static void C_ccall f_30225(C_word c,C_word *av) C_noret;
C_noret_decl(f_30241)
static void C_ccall f_30241(C_word c,C_word *av) C_noret;
C_noret_decl(f_30245)
static void C_ccall f_30245(C_word c,C_word *av) C_noret;
C_noret_decl(f_30247)
static void C_ccall f_30247(C_word c,C_word *av) C_noret;
C_noret_decl(f_30253)
static void C_ccall f_30253(C_word c,C_word *av) C_noret;
C_noret_decl(f_30260)
static void C_ccall f_30260(C_word c,C_word *av) C_noret;
C_noret_decl(f_30265)
static void C_ccall f_30265(C_word c,C_word *av) C_noret;
C_noret_decl(f_30286)
static void C_ccall f_30286(C_word c,C_word *av) C_noret;
C_noret_decl(f_30296)
static void C_fcall f_30296(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30306)
static void C_ccall f_30306(C_word c,C_word *av) C_noret;
C_noret_decl(f_30319)
static void C_ccall f_30319(C_word c,C_word *av) C_noret;
C_noret_decl(f_30323)
static void C_ccall f_30323(C_word c,C_word *av) C_noret;
C_noret_decl(f_30326)
static void C_ccall f_30326(C_word c,C_word *av) C_noret;
C_noret_decl(f_30334)
static void C_fcall f_30334(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30344)
static void C_ccall f_30344(C_word c,C_word *av) C_noret;
C_noret_decl(f_30366)
static void C_ccall f_30366(C_word c,C_word *av) C_noret;
C_noret_decl(f_30370)
static void C_ccall f_30370(C_word c,C_word *av) C_noret;
C_noret_decl(f_30401)
static void C_ccall f_30401(C_word c,C_word *av) C_noret;
C_noret_decl(f_30404)
static void C_ccall f_30404(C_word c,C_word *av) C_noret;
C_noret_decl(f_30407)
static void C_ccall f_30407(C_word c,C_word *av) C_noret;
C_noret_decl(f_30413)
static void C_fcall f_30413(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30426)
static void C_ccall f_30426(C_word c,C_word *av) C_noret;
C_noret_decl(f_30429)
static void C_ccall f_30429(C_word c,C_word *av) C_noret;
C_noret_decl(f_30438)
static void C_ccall f_30438(C_word c,C_word *av) C_noret;
C_noret_decl(f_30444)
static void C_ccall f_30444(C_word c,C_word *av) C_noret;
C_noret_decl(f_30450)
static void C_ccall f_30450(C_word c,C_word *av) C_noret;
C_noret_decl(f_30456)
static void C_ccall f_30456(C_word c,C_word *av) C_noret;
C_noret_decl(f_30462)
static void C_ccall f_30462(C_word c,C_word *av) C_noret;
C_noret_decl(f_30479)
static void C_ccall f_30479(C_word c,C_word *av) C_noret;
C_noret_decl(f_30485)
static void C_ccall f_30485(C_word c,C_word *av) C_noret;
C_noret_decl(f_30500)
static void C_ccall f_30500(C_word c,C_word *av) C_noret;
C_noret_decl(f_30504)
static void C_ccall f_30504(C_word c,C_word *av) C_noret;
C_noret_decl(f_30508)
static void C_ccall f_30508(C_word c,C_word *av) C_noret;
C_noret_decl(f_30512)
static void C_ccall f_30512(C_word c,C_word *av) C_noret;
C_noret_decl(f_30533)
static void C_ccall f_30533(C_word c,C_word *av) C_noret;
C_noret_decl(f_30535)
static void C_ccall f_30535(C_word c,C_word *av) C_noret;
C_noret_decl(f_30541)
static void C_fcall f_30541(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30545)
static void C_ccall f_30545(C_word c,C_word *av) C_noret;
C_noret_decl(f_30554)
static void C_ccall f_30554(C_word c,C_word *av) C_noret;
C_noret_decl(f_30563)
static void C_ccall f_30563(C_word c,C_word *av) C_noret;
C_noret_decl(f_30606)
static void C_ccall f_30606(C_word c,C_word *av) C_noret;
C_noret_decl(f_30628)
static void C_ccall f_30628(C_word c,C_word *av) C_noret;
C_noret_decl(f_30641)
static void C_ccall f_30641(C_word c,C_word *av) C_noret;
C_noret_decl(f_30666)
static void C_ccall f_30666(C_word c,C_word *av) C_noret;
C_noret_decl(f_30682)
static void C_ccall f_30682(C_word c,C_word *av) C_noret;
C_noret_decl(f_30698)
static void C_ccall f_30698(C_word c,C_word *av) C_noret;
C_noret_decl(f_30714)
static void C_ccall f_30714(C_word c,C_word *av) C_noret;
C_noret_decl(f_30730)
static void C_ccall f_30730(C_word c,C_word *av) C_noret;
C_noret_decl(f_30746)
static void C_ccall f_30746(C_word c,C_word *av) C_noret;
C_noret_decl(f_30762)
static void C_ccall f_30762(C_word c,C_word *av) C_noret;
C_noret_decl(f_30778)
static void C_ccall f_30778(C_word c,C_word *av) C_noret;
C_noret_decl(f_30794)
static void C_ccall f_30794(C_word c,C_word *av) C_noret;
C_noret_decl(f_30810)
static void C_ccall f_30810(C_word c,C_word *av) C_noret;
C_noret_decl(f_30817)
static void C_ccall f_30817(C_word c,C_word *av) C_noret;
C_noret_decl(f_30858)
static void C_ccall f_30858(C_word c,C_word *av) C_noret;
C_noret_decl(f_30870)
static void C_ccall f_30870(C_word c,C_word *av) C_noret;
C_noret_decl(f_30876)
static void C_ccall f_30876(C_word c,C_word *av) C_noret;
C_noret_decl(f_30895)
static void C_ccall f_30895(C_word c,C_word *av) C_noret;
C_noret_decl(f_30897)
static void C_ccall f_30897(C_word c,C_word *av) C_noret;
C_noret_decl(f_30920)
static C_word C_fcall f_30920(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_30966)
static void C_ccall f_30966(C_word c,C_word *av) C_noret;
C_noret_decl(f_30968)
static void C_ccall f_30968(C_word c,C_word *av) C_noret;
C_noret_decl(f_30975)
static void C_fcall f_30975(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30987)
static void C_fcall f_30987(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31031)
static void C_ccall f_31031(C_word c,C_word *av) C_noret;
C_noret_decl(f_31046)
static void C_fcall f_31046(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31054)
static void C_ccall f_31054(C_word c,C_word *av) C_noret;
C_noret_decl(f_31060)
static void C_fcall f_31060(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31068)
static void C_ccall f_31068(C_word c,C_word *av) C_noret;
C_noret_decl(f_31072)
static void C_ccall f_31072(C_word c,C_word *av) C_noret;
C_noret_decl(f_31080)
static void C_ccall f_31080(C_word c,C_word *av) C_noret;
C_noret_decl(f_31082)
static void C_fcall f_31082(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31092)
static void C_ccall f_31092(C_word c,C_word *av) C_noret;
C_noret_decl(f_31099)
static void C_ccall f_31099(C_word c,C_word *av) C_noret;
C_noret_decl(f_31103)
static void C_ccall f_31103(C_word c,C_word *av) C_noret;
C_noret_decl(f_31114)
static void C_ccall f_31114(C_word c,C_word *av) C_noret;
C_noret_decl(f_31121)
static void C_ccall f_31121(C_word c,C_word *av) C_noret;
C_noret_decl(f_31125)
static void C_ccall f_31125(C_word c,C_word *av) C_noret;
C_noret_decl(f_31136)
static void C_ccall f_31136(C_word c,C_word *av) C_noret;
C_noret_decl(f_31143)
static void C_ccall f_31143(C_word c,C_word *av) C_noret;
C_noret_decl(f_31147)
static void C_ccall f_31147(C_word c,C_word *av) C_noret;
C_noret_decl(f_31152)
static void C_ccall f_31152(C_word c,C_word *av) C_noret;
C_noret_decl(f_31158)
static void C_ccall f_31158(C_word c,C_word *av) C_noret;
C_noret_decl(f_31161)
static void C_ccall f_31161(C_word c,C_word *av) C_noret;
C_noret_decl(f_31164)
static void C_ccall f_31164(C_word c,C_word *av) C_noret;
C_noret_decl(f_31170)
static void C_ccall f_31170(C_word c,C_word *av) C_noret;
C_noret_decl(f_31179)
static void C_ccall f_31179(C_word c,C_word *av) C_noret;
C_noret_decl(f_31188)
static void C_ccall f_31188(C_word c,C_word *av) C_noret;
C_noret_decl(f_31194)
static void C_ccall f_31194(C_word c,C_word *av) C_noret;
C_noret_decl(f_31197)
static void C_ccall f_31197(C_word c,C_word *av) C_noret;
C_noret_decl(f_31200)
static void C_ccall f_31200(C_word c,C_word *av) C_noret;
C_noret_decl(f_31212)
static void C_ccall f_31212(C_word c,C_word *av) C_noret;
C_noret_decl(f_31215)
static void C_ccall f_31215(C_word c,C_word *av) C_noret;
C_noret_decl(f_31218)
static void C_ccall f_31218(C_word c,C_word *av) C_noret;
C_noret_decl(f_31221)
static void C_ccall f_31221(C_word c,C_word *av) C_noret;
C_noret_decl(f_31233)
static void C_ccall f_31233(C_word c,C_word *av) C_noret;
C_noret_decl(f_31236)
static void C_ccall f_31236(C_word c,C_word *av) C_noret;
C_noret_decl(f_31239)
static void C_ccall f_31239(C_word c,C_word *av) C_noret;
C_noret_decl(f_31242)
static void C_ccall f_31242(C_word c,C_word *av) C_noret;
C_noret_decl(f_31251)
static void C_ccall f_31251(C_word c,C_word *av) C_noret;
C_noret_decl(f_31254)
static void C_ccall f_31254(C_word c,C_word *av) C_noret;
C_noret_decl(f_31267)
static void C_ccall f_31267(C_word c,C_word *av) C_noret;
C_noret_decl(f_31268)
static void C_ccall f_31268(C_word c,C_word *av) C_noret;
C_noret_decl(f_31273)
static void C_ccall f_31273(C_word c,C_word *av) C_noret;
C_noret_decl(f_31274)
static void C_ccall f_31274(C_word c,C_word *av) C_noret;
C_noret_decl(f_31279)
static void C_ccall f_31279(C_word c,C_word *av) C_noret;
C_noret_decl(f_31280)
static void C_ccall f_31280(C_word c,C_word *av) C_noret;
C_noret_decl(f_31285)
static void C_ccall f_31285(C_word c,C_word *av) C_noret;
C_noret_decl(f_31286)
static void C_ccall f_31286(C_word c,C_word *av) C_noret;
C_noret_decl(f_31291)
static void C_ccall f_31291(C_word c,C_word *av) C_noret;
C_noret_decl(f_31292)
static void C_ccall f_31292(C_word c,C_word *av) C_noret;
C_noret_decl(f_31297)
static void C_fcall f_31297(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31299)
static void C_ccall f_31299(C_word c,C_word *av) C_noret;
C_noret_decl(f_31309)
static void C_ccall f_31309(C_word c,C_word *av) C_noret;
C_noret_decl(f_31312)
static void C_ccall f_31312(C_word c,C_word *av) C_noret;
C_noret_decl(f_31315)
static void C_ccall f_31315(C_word c,C_word *av) C_noret;
C_noret_decl(f_31318)
static void C_ccall f_31318(C_word c,C_word *av) C_noret;
C_noret_decl(f_31320)
static void C_fcall f_31320(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31334)
static void C_ccall f_31334(C_word c,C_word *av) C_noret;
C_noret_decl(f_31342)
static void C_ccall f_31342(C_word c,C_word *av) C_noret;
C_noret_decl(f_31346)
static void C_ccall f_31346(C_word c,C_word *av) C_noret;
C_noret_decl(f_31350)
static void C_ccall f_31350(C_word c,C_word *av) C_noret;
C_noret_decl(f_31354)
static void C_ccall f_31354(C_word c,C_word *av) C_noret;
C_noret_decl(f_31360)
static void C_ccall f_31360(C_word c,C_word *av) C_noret;
C_noret_decl(f_31367)
static void C_ccall f_31367(C_word c,C_word *av) C_noret;
C_noret_decl(f_31371)
static void C_ccall f_31371(C_word c,C_word *av) C_noret;
C_noret_decl(f_31375)
static void C_ccall f_31375(C_word c,C_word *av) C_noret;
C_noret_decl(f_31379)
static void C_ccall f_31379(C_word c,C_word *av) C_noret;
C_noret_decl(f_31399)
static void C_ccall f_31399(C_word c,C_word *av) C_noret;
C_noret_decl(f_31418)
static void C_ccall f_31418(C_word c,C_word *av) C_noret;
C_noret_decl(f_31421)
static void C_ccall f_31421(C_word c,C_word *av) C_noret;
C_noret_decl(f_31424)
static void C_ccall f_31424(C_word c,C_word *av) C_noret;
C_noret_decl(f_31427)
static void C_ccall f_31427(C_word c,C_word *av) C_noret;
C_noret_decl(f_31436)
static void C_ccall f_31436(C_word c,C_word *av) C_noret;
C_noret_decl(f_31446)
static void C_ccall f_31446(C_word c,C_word *av) C_noret;
C_noret_decl(f_31468)
static void C_ccall f_31468(C_word c,C_word *av) C_noret;
C_noret_decl(f_31474)
static void C_fcall f_31474(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_31494)
static void C_ccall f_31494(C_word c,C_word *av) C_noret;
C_noret_decl(f_31509)
static void C_ccall f_31509(C_word c,C_word *av) C_noret;
C_noret_decl(f_31513)
static void C_ccall f_31513(C_word c,C_word *av) C_noret;
C_noret_decl(f_31536)
static void C_ccall f_31536(C_word c,C_word *av) C_noret;
C_noret_decl(f_31540)
static void C_ccall f_31540(C_word c,C_word *av) C_noret;
C_noret_decl(f_31542)
static void C_ccall f_31542(C_word c,C_word *av) C_noret;
C_noret_decl(f_31572)
static void C_ccall f_31572(C_word c,C_word *av) C_noret;
C_noret_decl(f_31575)
static void C_ccall f_31575(C_word c,C_word *av) C_noret;
C_noret_decl(f_31577)
static void C_ccall f_31577(C_word c,C_word *av) C_noret;
C_noret_decl(f_31595)
static void C_ccall f_31595(C_word c,C_word *av) C_noret;
C_noret_decl(f_31602)
static void C_ccall f_31602(C_word c,C_word *av) C_noret;
C_noret_decl(f_31624)
static void C_ccall f_31624(C_word c,C_word *av) C_noret;
C_noret_decl(f_31629)
static void C_fcall f_31629(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31644)
static void C_ccall f_31644(C_word c,C_word *av) C_noret;
C_noret_decl(f_31647)
static void C_ccall f_31647(C_word c,C_word *av) C_noret;
C_noret_decl(f_31650)
static void C_ccall f_31650(C_word c,C_word *av) C_noret;
C_noret_decl(f_31653)
static void C_ccall f_31653(C_word c,C_word *av) C_noret;
C_noret_decl(f_31656)
static void C_ccall f_31656(C_word c,C_word *av) C_noret;
C_noret_decl(f_31659)
static void C_ccall f_31659(C_word c,C_word *av) C_noret;
C_noret_decl(f_31662)
static void C_fcall f_31662(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31665)
static void C_fcall f_31665(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31668)
static void C_fcall f_31668(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31671)
static void C_fcall f_31671(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31679)
static void C_ccall f_31679(C_word c,C_word *av) C_noret;
C_noret_decl(f_31682)
static void C_ccall f_31682(C_word c,C_word *av) C_noret;
C_noret_decl(f_31687)
static void C_ccall f_31687(C_word c,C_word *av) C_noret;
C_noret_decl(f_31693)
static void C_ccall f_31693(C_word c,C_word *av) C_noret;
C_noret_decl(f_31706)
static void C_ccall f_31706(C_word c,C_word *av) C_noret;
C_noret_decl(f_31708)
static void C_fcall f_31708(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31731)
static void C_ccall f_31731(C_word c,C_word *av) C_noret;
C_noret_decl(f_31738)
static void C_ccall f_31738(C_word c,C_word *av) C_noret;
C_noret_decl(f_31742)
static void C_ccall f_31742(C_word c,C_word *av) C_noret;
C_noret_decl(f_31744)
static void C_fcall f_31744(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31773)
static void C_ccall f_31773(C_word c,C_word *av) C_noret;
C_noret_decl(f_31775)
static void C_fcall f_31775(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31800)
static void C_ccall f_31800(C_word c,C_word *av) C_noret;
C_noret_decl(f_31809)
static void C_ccall f_31809(C_word c,C_word *av) C_noret;
C_noret_decl(f_31812)
static void C_ccall f_31812(C_word c,C_word *av) C_noret;
C_noret_decl(f_31818)
static void C_fcall f_31818(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31842)
static void C_ccall f_31842(C_word c,C_word *av) C_noret;
C_noret_decl(f_31849)
static void C_ccall f_31849(C_word c,C_word *av) C_noret;
C_noret_decl(f_31853)
static void C_ccall f_31853(C_word c,C_word *av) C_noret;
C_noret_decl(f_31865)
static void C_ccall f_31865(C_word c,C_word *av) C_noret;
C_noret_decl(f_31873)
static void C_ccall f_31873(C_word c,C_word *av) C_noret;
C_noret_decl(f_31877)
static void C_ccall f_31877(C_word c,C_word *av) C_noret;
C_noret_decl(f_31886)
static void C_ccall f_31886(C_word c,C_word *av) C_noret;
C_noret_decl(f_31895)
static void C_ccall f_31895(C_word c,C_word *av) C_noret;
C_noret_decl(f_31905)
static void C_ccall f_31905(C_word c,C_word *av) C_noret;
C_noret_decl(f_31913)
static void C_ccall f_31913(C_word c,C_word *av) C_noret;
C_noret_decl(f_31917)
static void C_ccall f_31917(C_word c,C_word *av) C_noret;
C_noret_decl(f_31921)
static void C_ccall f_31921(C_word c,C_word *av) C_noret;
C_noret_decl(f_31927)
static void C_ccall f_31927(C_word c,C_word *av) C_noret;
C_noret_decl(f_31931)
static void C_ccall f_31931(C_word c,C_word *av) C_noret;
C_noret_decl(f_31935)
static void C_ccall f_31935(C_word c,C_word *av) C_noret;
C_noret_decl(f_31957)
static void C_ccall f_31957(C_word c,C_word *av) C_noret;
C_noret_decl(f_31961)
static void C_ccall f_31961(C_word c,C_word *av) C_noret;
C_noret_decl(f_31965)
static void C_ccall f_31965(C_word c,C_word *av) C_noret;
C_noret_decl(f_31969)
static void C_ccall f_31969(C_word c,C_word *av) C_noret;
C_noret_decl(f_31973)
static void C_ccall f_31973(C_word c,C_word *av) C_noret;
C_noret_decl(f_31981)
static void C_ccall f_31981(C_word c,C_word *av) C_noret;
C_noret_decl(f_31989)
static void C_fcall f_31989(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32014)
static void C_ccall f_32014(C_word c,C_word *av) C_noret;
C_noret_decl(f_32031)
static void C_ccall f_32031(C_word c,C_word *av) C_noret;
C_noret_decl(f_32035)
static void C_ccall f_32035(C_word c,C_word *av) C_noret;
C_noret_decl(f_32038)
static void C_ccall f_32038(C_word c,C_word *av) C_noret;
C_noret_decl(f_32041)
static void C_ccall f_32041(C_word c,C_word *av) C_noret;
C_noret_decl(f_32051)
static void C_ccall f_32051(C_word c,C_word *av) C_noret;
C_noret_decl(f_32054)
static void C_ccall f_32054(C_word c,C_word *av) C_noret;
C_noret_decl(f_32056)
static void C_ccall f_32056(C_word c,C_word *av) C_noret;
C_noret_decl(f_32073)
static C_word C_fcall f_32073(C_word t0);
C_noret_decl(f_32100)
static void C_ccall f_32100(C_word c,C_word *av) C_noret;
C_noret_decl(f_32109)
static void C_ccall f_32109(C_word c,C_word *av) C_noret;
C_noret_decl(f_32129)
static void C_ccall f_32129(C_word c,C_word *av) C_noret;
C_noret_decl(f_32133)
static void C_ccall f_32133(C_word c,C_word *av) C_noret;
C_noret_decl(f_32137)
static void C_ccall f_32137(C_word c,C_word *av) C_noret;
C_noret_decl(f_32141)
static void C_ccall f_32141(C_word c,C_word *av) C_noret;
C_noret_decl(f_32145)
static void C_ccall f_32145(C_word c,C_word *av) C_noret;
C_noret_decl(f_32149)
static void C_ccall f_32149(C_word c,C_word *av) C_noret;
C_noret_decl(f_32153)
static void C_ccall f_32153(C_word c,C_word *av) C_noret;
C_noret_decl(f_32155)
static void C_ccall f_32155(C_word c,C_word *av) C_noret;
C_noret_decl(f_32164)
static void C_ccall f_32164(C_word c,C_word *av) C_noret;
C_noret_decl(f_32174)
static void C_ccall f_32174(C_word c,C_word *av) C_noret;
C_noret_decl(f_32199)
static void C_ccall f_32199(C_word c,C_word *av) C_noret;
C_noret_decl(f_32202)
static void C_ccall f_32202(C_word c,C_word *av) C_noret;
C_noret_decl(f_32204)
static void C_ccall f_32204(C_word c,C_word *av) C_noret;
C_noret_decl(f_32220)
static void C_fcall f_32220(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32258)
static void C_ccall f_32258(C_word c,C_word *av) C_noret;
C_noret_decl(f_32282)
static void C_ccall f_32282(C_word c,C_word *av) C_noret;
C_noret_decl(f_32286)
static void C_ccall f_32286(C_word c,C_word *av) C_noret;
C_noret_decl(f_32288)
static void C_ccall f_32288(C_word c,C_word *av) C_noret;
C_noret_decl(f_32292)
static void C_ccall f_32292(C_word c,C_word *av) C_noret;
C_noret_decl(f_32295)
static void C_ccall f_32295(C_word c,C_word *av) C_noret;
C_noret_decl(f_32308)
static void C_ccall f_32308(C_word c,C_word *av) C_noret;
C_noret_decl(f_32313)
static void C_ccall f_32313(C_word c,C_word *av) C_noret;
C_noret_decl(f_32319)
static void C_ccall f_32319(C_word c,C_word *av) C_noret;
C_noret_decl(f_32323)
static void C_ccall f_32323(C_word c,C_word *av) C_noret;
C_noret_decl(f_32332)
static void C_ccall f_32332(C_word c,C_word *av) C_noret;
C_noret_decl(f_32335)
static void C_ccall f_32335(C_word c,C_word *av) C_noret;
C_noret_decl(f_32338)
static void C_ccall f_32338(C_word c,C_word *av) C_noret;
C_noret_decl(f_32341)
static void C_ccall f_32341(C_word c,C_word *av) C_noret;
C_noret_decl(f_32344)
static void C_ccall f_32344(C_word c,C_word *av) C_noret;
C_noret_decl(f_32346)
static void C_ccall f_32346(C_word c,C_word *av) C_noret;
C_noret_decl(f_32356)
static void C_ccall f_32356(C_word c,C_word *av) C_noret;
C_noret_decl(f_32368)
static void C_ccall f_32368(C_word c,C_word *av) C_noret;
C_noret_decl(f_32376)
static void C_fcall f_32376(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32386)
static void C_ccall f_32386(C_word c,C_word *av) C_noret;
C_noret_decl(f_32402)
static void C_ccall f_32402(C_word c,C_word *av) C_noret;
C_noret_decl(f_32408)
static void C_ccall f_32408(C_word c,C_word *av) C_noret;
C_noret_decl(f_32411)
static void C_ccall f_32411(C_word c,C_word *av) C_noret;
C_noret_decl(f_32414)
static void C_ccall f_32414(C_word c,C_word *av) C_noret;
C_noret_decl(f_32415)
static void C_fcall f_32415(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32419)
static void C_ccall f_32419(C_word c,C_word *av) C_noret;
C_noret_decl(f_32425)
static void C_ccall f_32425(C_word c,C_word *av) C_noret;
C_noret_decl(f_32429)
static void C_ccall f_32429(C_word c,C_word *av) C_noret;
C_noret_decl(f_32431)
static void C_fcall f_32431(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32441)
static void C_ccall f_32441(C_word c,C_word *av) C_noret;
C_noret_decl(f_32458)
static void C_ccall f_32458(C_word c,C_word *av) C_noret;
C_noret_decl(f_32461)
static void C_ccall f_32461(C_word c,C_word *av) C_noret;
C_noret_decl(f_32465)
static void C_ccall f_32465(C_word c,C_word *av) C_noret;
C_noret_decl(f_32470)
static void C_ccall f_32470(C_word c,C_word *av) C_noret;
C_noret_decl(f_32476)
static void C_ccall f_32476(C_word c,C_word *av) C_noret;
C_noret_decl(f_32483)
static void C_ccall f_32483(C_word c,C_word *av) C_noret;
C_noret_decl(f_32492)
static void C_ccall f_32492(C_word c,C_word *av) C_noret;
C_noret_decl(f_32500)
static void C_ccall f_32500(C_word c,C_word *av) C_noret;
C_noret_decl(f_32525)
static void C_ccall f_32525(C_word c,C_word *av) C_noret;
C_noret_decl(f_32543)
static void C_ccall f_32543(C_word c,C_word *av) C_noret;
C_noret_decl(f_32547)
static void C_ccall f_32547(C_word c,C_word *av) C_noret;
C_noret_decl(f_32562)
static void C_ccall f_32562(C_word c,C_word *av) C_noret;
C_noret_decl(f_32566)
static void C_ccall f_32566(C_word c,C_word *av) C_noret;
C_noret_decl(f_32581)
static void C_ccall f_32581(C_word c,C_word *av) C_noret;
C_noret_decl(f_32584)
static void C_ccall f_32584(C_word c,C_word *av) C_noret;
C_noret_decl(f_32587)
static void C_ccall f_32587(C_word c,C_word *av) C_noret;
C_noret_decl(f_32597)
static void C_fcall f_32597(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32628)
static void C_ccall f_32628(C_word c,C_word *av) C_noret;
C_noret_decl(f_32652)
static void C_ccall f_32652(C_word c,C_word *av) C_noret;
C_noret_decl(f_32662)
static void C_ccall f_32662(C_word c,C_word *av) C_noret;
C_noret_decl(f_32671)
static void C_ccall f_32671(C_word c,C_word *av) C_noret;
C_noret_decl(f_32712)
static void C_ccall f_32712(C_word c,C_word *av) C_noret;
C_noret_decl(f_32731)
static void C_ccall f_32731(C_word c,C_word *av) C_noret;
C_noret_decl(f_32740)
static void C_ccall f_32740(C_word c,C_word *av) C_noret;
C_noret_decl(f_32744)
static void C_ccall f_32744(C_word c,C_word *av) C_noret;
C_noret_decl(f_32749)
static void C_ccall f_32749(C_word c,C_word *av) C_noret;
C_noret_decl(f_32759)
static void C_ccall f_32759(C_word c,C_word *av) C_noret;
C_noret_decl(f_32769)
static void C_ccall f_32769(C_word c,C_word *av) C_noret;
C_noret_decl(f_32779)
static void C_ccall f_32779(C_word c,C_word *av) C_noret;
C_noret_decl(f_32789)
static void C_ccall f_32789(C_word c,C_word *av) C_noret;
C_noret_decl(f_32799)
static void C_ccall f_32799(C_word c,C_word *av) C_noret;
C_noret_decl(f_32809)
static void C_ccall f_32809(C_word c,C_word *av) C_noret;
C_noret_decl(f_32819)
static void C_ccall f_32819(C_word c,C_word *av) C_noret;
C_noret_decl(f_32829)
static void C_ccall f_32829(C_word c,C_word *av) C_noret;
C_noret_decl(f_32839)
static void C_ccall f_32839(C_word c,C_word *av) C_noret;
C_noret_decl(f_32849)
static void C_ccall f_32849(C_word c,C_word *av) C_noret;
C_noret_decl(f_32859)
static void C_ccall f_32859(C_word c,C_word *av) C_noret;
C_noret_decl(f_32869)
static void C_ccall f_32869(C_word c,C_word *av) C_noret;
C_noret_decl(f_32879)
static void C_ccall f_32879(C_word c,C_word *av) C_noret;
C_noret_decl(f_32895)
static void C_ccall f_32895(C_word c,C_word *av) C_noret;
C_noret_decl(f_32903)
static void C_ccall f_32903(C_word c,C_word *av) C_noret;
C_noret_decl(f_32919)
static void C_ccall f_32919(C_word c,C_word *av) C_noret;
C_noret_decl(f_32935)
static void C_ccall f_32935(C_word c,C_word *av) C_noret;
C_noret_decl(f_32945)
static void C_ccall f_32945(C_word c,C_word *av) C_noret;
C_noret_decl(f_32955)
static void C_ccall f_32955(C_word c,C_word *av) C_noret;
C_noret_decl(f_32974)
static void C_ccall f_32974(C_word c,C_word *av) C_noret;
C_noret_decl(f_32990)
static void C_ccall f_32990(C_word c,C_word *av) C_noret;
C_noret_decl(f_33003)
static void C_ccall f_33003(C_word c,C_word *av) C_noret;
C_noret_decl(f_33009)
static void C_ccall f_33009(C_word c,C_word *av) C_noret;
C_noret_decl(f_33019)
static void C_ccall f_33019(C_word c,C_word *av) C_noret;
C_noret_decl(f_33035)
static void C_ccall f_33035(C_word c,C_word *av) C_noret;
C_noret_decl(f_33039)
static void C_ccall f_33039(C_word c,C_word *av) C_noret;
C_noret_decl(f_33042)
static void C_ccall f_33042(C_word c,C_word *av) C_noret;
C_noret_decl(f_33048)
static void C_ccall f_33048(C_word c,C_word *av) C_noret;
C_noret_decl(f_33058)
static void C_ccall f_33058(C_word c,C_word *av) C_noret;
C_noret_decl(f_33074)
static void C_ccall f_33074(C_word c,C_word *av) C_noret;
C_noret_decl(f_33078)
static void C_ccall f_33078(C_word c,C_word *av) C_noret;
C_noret_decl(f_33081)
static void C_ccall f_33081(C_word c,C_word *av) C_noret;
C_noret_decl(f_33084)
static void C_ccall f_33084(C_word c,C_word *av) C_noret;
C_noret_decl(f_33087)
static void C_ccall f_33087(C_word c,C_word *av) C_noret;
C_noret_decl(f_33093)
static void C_ccall f_33093(C_word c,C_word *av) C_noret;
C_noret_decl(f_33096)
static void C_ccall f_33096(C_word c,C_word *av) C_noret;
C_noret_decl(f_33099)
static void C_ccall f_33099(C_word c,C_word *av) C_noret;
C_noret_decl(f_33109)
static void C_fcall f_33109(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_33125)
static void C_ccall f_33125(C_word c,C_word *av) C_noret;
C_noret_decl(f_33136)
static void C_ccall f_33136(C_word c,C_word *av) C_noret;
C_noret_decl(f_33159)
static void C_ccall f_33159(C_word c,C_word *av) C_noret;
C_noret_decl(f_33163)
static void C_ccall f_33163(C_word c,C_word *av) C_noret;
C_noret_decl(f_33197)
static void C_ccall f_33197(C_word c,C_word *av) C_noret;
C_noret_decl(f_33201)
static void C_ccall f_33201(C_word c,C_word *av) C_noret;
C_noret_decl(f_33204)
static void C_fcall f_33204(C_word t0,C_word t1) C_noret;
C_noret_decl(f_33217)
static void C_fcall f_33217(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_33250)
static void C_ccall f_33250(C_word c,C_word *av) C_noret;
C_noret_decl(f_33265)
static void C_ccall f_33265(C_word c,C_word *av) C_noret;
C_noret_decl(f_33269)
static void C_ccall f_33269(C_word c,C_word *av) C_noret;
C_noret_decl(f_33282)
static void C_ccall f_33282(C_word c,C_word *av) C_noret;
C_noret_decl(f_33296)
static void C_ccall f_33296(C_word c,C_word *av) C_noret;
C_noret_decl(f_33304)
static void C_ccall f_33304(C_word c,C_word *av) C_noret;
C_noret_decl(f_33308)
static void C_ccall f_33308(C_word c,C_word *av) C_noret;
C_noret_decl(f_33319)
static void C_ccall f_33319(C_word c,C_word *av) C_noret;
C_noret_decl(f_33323)
static void C_ccall f_33323(C_word c,C_word *av) C_noret;
C_noret_decl(f_33337)
static void C_ccall f_33337(C_word c,C_word *av) C_noret;
C_noret_decl(f_33369)
static void C_ccall f_33369(C_word c,C_word *av) C_noret;
C_noret_decl(f_8836)
static void C_ccall f_8836(C_word c,C_word *av) C_noret;
C_noret_decl(f_8838)
static void C_ccall f_8838(C_word c,C_word *av) C_noret;
C_noret_decl(f_8841)
static void C_ccall f_8841(C_word c,C_word *av) C_noret;
C_noret_decl(f_8844)
static void C_ccall f_8844(C_word c,C_word *av) C_noret;
C_noret_decl(f_8847)
static void C_ccall f_8847(C_word c,C_word *av) C_noret;
C_noret_decl(f_8850)
static void C_ccall f_8850(C_word c,C_word *av) C_noret;
C_noret_decl(f_8853)
static void C_ccall f_8853(C_word c,C_word *av) C_noret;
C_noret_decl(f_8856)
static void C_ccall f_8856(C_word c,C_word *av) C_noret;
C_noret_decl(f_8859)
static void C_ccall f_8859(C_word c,C_word *av) C_noret;
C_noret_decl(f_8862)
static void C_ccall f_8862(C_word c,C_word *av) C_noret;
C_noret_decl(f_8865)
static void C_ccall f_8865(C_word c,C_word *av) C_noret;
C_noret_decl(f_8868)
static void C_ccall f_8868(C_word c,C_word *av) C_noret;
C_noret_decl(f_8871)
static void C_ccall f_8871(C_word c,C_word *av) C_noret;
C_noret_decl(f_8874)
static void C_ccall f_8874(C_word c,C_word *av) C_noret;
C_noret_decl(f_8877)
static void C_ccall f_8877(C_word c,C_word *av) C_noret;
C_noret_decl(f_8880)
static void C_ccall f_8880(C_word c,C_word *av) C_noret;
C_noret_decl(f_8883)
static void C_ccall f_8883(C_word c,C_word *av) C_noret;
C_noret_decl(f_8886)
static void C_ccall f_8886(C_word c,C_word *av) C_noret;
C_noret_decl(f_8889)
static void C_ccall f_8889(C_word c,C_word *av) C_noret;
C_noret_decl(f_8892)
static void C_ccall f_8892(C_word c,C_word *av) C_noret;
C_noret_decl(f_8906)
static void C_ccall f_8906(C_word c,C_word *av) C_noret;
C_noret_decl(f_8913)
static void C_ccall f_8913(C_word c,C_word *av) C_noret;
C_noret_decl(f_8920)
static void C_ccall f_8920(C_word c,C_word *av) C_noret;
C_noret_decl(f_8934)
static void C_ccall f_8934(C_word c,C_word *av) C_noret;
C_noret_decl(f_8941)
static void C_ccall f_8941(C_word c,C_word *av) C_noret;
C_noret_decl(f_8955)
static void C_ccall f_8955(C_word c,C_word *av) C_noret;
C_noret_decl(f_8969)
static void C_ccall f_8969(C_word c,C_word *av) C_noret;
C_noret_decl(f_8987)
static void C_ccall f_8987(C_word c,C_word *av) C_noret;
C_noret_decl(f_8998)
static void C_ccall f_8998(C_word c,C_word *av) C_noret;
C_noret_decl(f_9009)
static void C_ccall f_9009(C_word c,C_word *av) C_noret;
C_noret_decl(f_9016)
static void C_ccall f_9016(C_word c,C_word *av) C_noret;
C_noret_decl(f_9027)
static void C_ccall f_9027(C_word c,C_word *av) C_noret;
C_noret_decl(f_9031)
static void C_ccall f_9031(C_word c,C_word *av) C_noret;
C_noret_decl(f_9038)
static void C_ccall f_9038(C_word c,C_word *av) C_noret;
C_noret_decl(f_9056)
static void C_ccall f_9056(C_word c,C_word *av) C_noret;
C_noret_decl(f_9067)
static void C_ccall f_9067(C_word c,C_word *av) C_noret;
C_noret_decl(f_9078)
static void C_ccall f_9078(C_word c,C_word *av) C_noret;
C_noret_decl(f_9085)
static void C_ccall f_9085(C_word c,C_word *av) C_noret;
C_noret_decl(f_9103)
static void C_ccall f_9103(C_word c,C_word *av) C_noret;
C_noret_decl(f_9114)
static void C_ccall f_9114(C_word c,C_word *av) C_noret;
C_noret_decl(f_9132)
static void C_ccall f_9132(C_word c,C_word *av) C_noret;
C_noret_decl(f_9138)
static void C_ccall f_9138(C_word c,C_word *av) C_noret;
C_noret_decl(f_9141)
static void C_ccall f_9141(C_word c,C_word *av) C_noret;
C_noret_decl(f_9144)
static void C_ccall f_9144(C_word c,C_word *av) C_noret;
C_noret_decl(f_9147)
static void C_ccall f_9147(C_word c,C_word *av) C_noret;
C_noret_decl(f_9150)
static void C_ccall f_9150(C_word c,C_word *av) C_noret;
C_noret_decl(f_9156)
static void C_fcall f_9156(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_9189)
static void C_ccall f_9189(C_word c,C_word *av) C_noret;
C_noret_decl(f_9192)
static void C_ccall f_9192(C_word c,C_word *av) C_noret;
C_noret_decl(f_9195)
static void C_ccall f_9195(C_word c,C_word *av) C_noret;
C_noret_decl(f_9198)
static void C_ccall f_9198(C_word c,C_word *av) C_noret;
C_noret_decl(f_9201)
static void C_ccall f_9201(C_word c,C_word *av) C_noret;
C_noret_decl(f_9204)
static void C_ccall f_9204(C_word c,C_word *av) C_noret;
C_noret_decl(f_9207)
static void C_ccall f_9207(C_word c,C_word *av) C_noret;
C_noret_decl(f_9210)
static void C_ccall f_9210(C_word c,C_word *av) C_noret;
C_noret_decl(f_9213)
static void C_ccall f_9213(C_word c,C_word *av) C_noret;
C_noret_decl(f_9216)
static void C_ccall f_9216(C_word c,C_word *av) C_noret;
C_noret_decl(f_9219)
static void C_ccall f_9219(C_word c,C_word *av) C_noret;
C_noret_decl(f_9222)
static void C_ccall f_9222(C_word c,C_word *av) C_noret;
C_noret_decl(f_9225)
static void C_ccall f_9225(C_word c,C_word *av) C_noret;
C_noret_decl(f_9229)
static void C_ccall f_9229(C_word c,C_word *av) C_noret;
C_noret_decl(f_9232)
static void C_ccall f_9232(C_word c,C_word *av) C_noret;
C_noret_decl(f_9238)
static void C_ccall f_9238(C_word c,C_word *av) C_noret;
C_noret_decl(f_9241)
static void C_ccall f_9241(C_word c,C_word *av) C_noret;
C_noret_decl(f_9244)
static void C_ccall f_9244(C_word c,C_word *av) C_noret;
C_noret_decl(f_9247)
static void C_ccall f_9247(C_word c,C_word *av) C_noret;
C_noret_decl(f_9250)
static void C_ccall f_9250(C_word c,C_word *av) C_noret;
C_noret_decl(f_9258)
static void C_ccall f_9258(C_word c,C_word *av) C_noret;
C_noret_decl(f_9262)
static void C_ccall f_9262(C_word c,C_word *av) C_noret;
C_noret_decl(f_9265)
static void C_ccall f_9265(C_word c,C_word *av) C_noret;
C_noret_decl(f_9268)
static void C_ccall f_9268(C_word c,C_word *av) C_noret;
C_noret_decl(f_9271)
static void C_ccall f_9271(C_word c,C_word *av) C_noret;
C_noret_decl(f_9274)
static void C_ccall f_9274(C_word c,C_word *av) C_noret;
C_noret_decl(f_9277)
static void C_ccall f_9277(C_word c,C_word *av) C_noret;
C_noret_decl(f_9280)
static void C_ccall f_9280(C_word c,C_word *av) C_noret;
C_noret_decl(f_9283)
static void C_ccall f_9283(C_word c,C_word *av) C_noret;
C_noret_decl(f_9287)
static void C_ccall f_9287(C_word c,C_word *av) C_noret;
C_noret_decl(f_9290)
static void C_ccall f_9290(C_word c,C_word *av) C_noret;
C_noret_decl(f_9293)
static void C_ccall f_9293(C_word c,C_word *av) C_noret;
C_noret_decl(f_9296)
static void C_ccall f_9296(C_word c,C_word *av) C_noret;
C_noret_decl(f_9299)
static void C_ccall f_9299(C_word c,C_word *av) C_noret;
C_noret_decl(f_9307)
static void C_ccall f_9307(C_word c,C_word *av) C_noret;
C_noret_decl(f_9310)
static void C_ccall f_9310(C_word c,C_word *av) C_noret;
C_noret_decl(f_9317)
static void C_ccall f_9317(C_word c,C_word *av) C_noret;
C_noret_decl(f_9321)
static void C_ccall f_9321(C_word c,C_word *av) C_noret;
C_noret_decl(f_9324)
static void C_ccall f_9324(C_word c,C_word *av) C_noret;
C_noret_decl(f_9327)
static void C_ccall f_9327(C_word c,C_word *av) C_noret;
C_noret_decl(f_9330)
static void C_ccall f_9330(C_word c,C_word *av) C_noret;
C_noret_decl(f_9333)
static void C_ccall f_9333(C_word c,C_word *av) C_noret;
C_noret_decl(f_9336)
static void C_ccall f_9336(C_word c,C_word *av) C_noret;
C_noret_decl(f_9339)
static void C_ccall f_9339(C_word c,C_word *av) C_noret;
C_noret_decl(f_9345)
static void C_ccall f_9345(C_word c,C_word *av) C_noret;
C_noret_decl(f_9356)
static void C_ccall f_9356(C_word c,C_word *av) C_noret;
C_noret_decl(f_9362)
static void C_ccall f_9362(C_word c,C_word *av) C_noret;
C_noret_decl(f_9368)
static void C_ccall f_9368(C_word c,C_word *av) C_noret;
C_noret_decl(f_9374)
static void C_ccall f_9374(C_word c,C_word *av) C_noret;
C_noret_decl(f_9380)
static void C_ccall f_9380(C_word c,C_word *av) C_noret;
C_noret_decl(f_9386)
static void C_ccall f_9386(C_word c,C_word *av) C_noret;
C_noret_decl(f_9393)
static void C_ccall f_9393(C_word c,C_word *av) C_noret;
C_noret_decl(f_9399)
static void C_ccall f_9399(C_word c,C_word *av) C_noret;
C_noret_decl(f_9415)
static void C_ccall f_9415(C_word c,C_word *av) C_noret;
C_noret_decl(f_9426)
static void C_ccall f_9426(C_word c,C_word *av) C_noret;
C_noret_decl(f_9432)
static void C_ccall f_9432(C_word c,C_word *av) C_noret;
C_noret_decl(f_9438)
static void C_ccall f_9438(C_word c,C_word *av) C_noret;
C_noret_decl(f_9444)
static void C_ccall f_9444(C_word c,C_word *av) C_noret;
C_noret_decl(f_9450)
static void C_ccall f_9450(C_word c,C_word *av) C_noret;
C_noret_decl(f_9459)
static void C_ccall f_9459(C_word c,C_word *av) C_noret;
C_noret_decl(f_9462)
static void C_ccall f_9462(C_word c,C_word *av) C_noret;
C_noret_decl(f_9465)
static void C_ccall f_9465(C_word c,C_word *av) C_noret;
C_noret_decl(f_9468)
static void C_ccall f_9468(C_word c,C_word *av) C_noret;
C_noret_decl(f_9471)
static void C_ccall f_9471(C_word c,C_word *av) C_noret;
C_noret_decl(f_9474)
static void C_ccall f_9474(C_word c,C_word *av) C_noret;
C_noret_decl(f_9478)
static void C_ccall f_9478(C_word c,C_word *av) C_noret;
C_noret_decl(f_9484)
static void C_ccall f_9484(C_word c,C_word *av) C_noret;
C_noret_decl(f_9490)
static void C_ccall f_9490(C_word c,C_word *av) C_noret;
C_noret_decl(f_9525)
static void C_ccall f_9525(C_word c,C_word *av) C_noret;
C_noret_decl(f_9528)
static void C_ccall f_9528(C_word c,C_word *av) C_noret;
C_noret_decl(f_9531)
static void C_ccall f_9531(C_word c,C_word *av) C_noret;
C_noret_decl(f_9539)
static void C_ccall f_9539(C_word c,C_word *av) C_noret;
C_noret_decl(f_9545)
static void C_ccall f_9545(C_word c,C_word *av) C_noret;
C_noret_decl(f_9552)
static void C_ccall f_9552(C_word c,C_word *av) C_noret;
C_noret_decl(f_9567)
static void C_ccall f_9567(C_word c,C_word *av) C_noret;
C_noret_decl(f_9590)
static void C_ccall f_9590(C_word c,C_word *av) C_noret;
C_noret_decl(f_9596)
static void C_ccall f_9596(C_word c,C_word *av) C_noret;
C_noret_decl(f_9602)
static void C_ccall f_9602(C_word c,C_word *av) C_noret;
C_noret_decl(f_9609)
static void C_ccall f_9609(C_word c,C_word *av) C_noret;
C_noret_decl(f_9614)
static void C_ccall f_9614(C_word c,C_word *av) C_noret;
C_noret_decl(f_9617)
static void C_ccall f_9617(C_word c,C_word *av) C_noret;
C_noret_decl(f_9626)
static void C_fcall f_9626(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_9644)
static void C_ccall f_9644(C_word c,C_word *av) C_noret;
C_noret_decl(f_9654)
static void C_ccall f_9654(C_word c,C_word *av) C_noret;
C_noret_decl(f_9663)
static void C_fcall f_9663(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9681)
static void C_ccall f_9681(C_word c,C_word *av) C_noret;
C_noret_decl(f_9694)
static void C_ccall f_9694(C_word c,C_word *av) C_noret;
C_noret_decl(f_9701)
static void C_ccall f_9701(C_word c,C_word *av) C_noret;
C_noret_decl(f_9708)
static void C_ccall f_9708(C_word c,C_word *av) C_noret;
C_noret_decl(f_9719)
static void C_ccall f_9719(C_word c,C_word *av) C_noret;
C_noret_decl(f_9726)
static void C_ccall f_9726(C_word c,C_word *av) C_noret;
C_noret_decl(f_9738)
static void C_ccall f_9738(C_word c,C_word *av) C_noret;
C_noret_decl(f_9741)
static void C_ccall f_9741(C_word c,C_word *av) C_noret;
C_noret_decl(f_9743)
static void C_ccall f_9743(C_word c,C_word *av) C_noret;
C_noret_decl(f_9749)
static void C_fcall f_9749(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9765)
static void C_ccall f_9765(C_word c,C_word *av) C_noret;
C_noret_decl(f_9774)
static void C_ccall f_9774(C_word c,C_word *av) C_noret;
C_noret_decl(f_9776)
static void C_ccall f_9776(C_word c,C_word *av) C_noret;
C_noret_decl(f_9782)
static void C_fcall f_9782(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9795)
static void C_ccall f_9795(C_word c,C_word *av) C_noret;
C_noret_decl(f_9811)
static void C_ccall f_9811(C_word c,C_word *av) C_noret;
C_noret_decl(f_9822)
static void C_ccall f_9822(C_word c,C_word *av) C_noret;
C_noret_decl(f_9824)
static void C_ccall f_9824(C_word c,C_word *av) C_noret;
C_noret_decl(f_9832)
static void C_ccall f_9832(C_word c,C_word *av) C_noret;
C_noret_decl(f_9834)
static void C_ccall f_9834(C_word c,C_word *av) C_noret;
C_noret_decl(f_9840)
static void C_ccall f_9840(C_word c,C_word *av) C_noret;
C_noret_decl(f_9842)
static void C_ccall f_9842(C_word c,C_word *av) C_noret;
C_noret_decl(f_9850)
static void C_ccall f_9850(C_word c,C_word *av) C_noret;
C_noret_decl(f_9852)
static void C_ccall f_9852(C_word c,C_word *av) C_noret;
C_noret_decl(f_9855)
static void C_ccall f_9855(C_word c,C_word *av) C_noret;
C_noret_decl(f_9863)
static void C_ccall f_9863(C_word c,C_word *av) C_noret;
C_noret_decl(f_9869)
static void C_ccall f_9869(C_word c,C_word *av) C_noret;
C_noret_decl(f_9877)
static void C_ccall f_9877(C_word c,C_word *av) C_noret;
C_noret_decl(f_9888)
static void C_ccall f_9888(C_word c,C_word *av) C_noret;
C_noret_decl(f_9900)
static void C_fcall f_9900(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9914)
static void C_ccall f_9914(C_word c,C_word *av) C_noret;
C_noret_decl(f_9922)
static void C_ccall f_9922(C_word c,C_word *av) C_noret;
C_noret_decl(f_9925)
static void C_ccall f_9925(C_word c,C_word *av) C_noret;
C_noret_decl(f_9927)
static void C_ccall f_9927(C_word c,C_word *av) C_noret;
C_noret_decl(f_9929)
static void C_ccall f_9929(C_word c,C_word *av) C_noret;
C_noret_decl(f_9935)
static void C_fcall f_9935(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_9954)
static void C_ccall f_9954(C_word c,C_word *av) C_noret;
C_noret_decl(f_9971)
static void C_ccall f_9971(C_word c,C_word *av) C_noret;
C_noret_decl(f_9979)
static void C_ccall f_9979(C_word c,C_word *av) C_noret;
C_noret_decl(f_9993)
static void C_ccall f_9993(C_word c,C_word *av) C_noret;
C_noret_decl(f_9999)
static void C_fcall f_9999(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(C_library_toplevel)
C_externexport void C_ccall C_library_toplevel(C_word c,C_word *av) C_noret;

C_noret_decl(trf_10073)
static void C_ccall trf_10073(C_word c,C_word *av) C_noret;
static void C_ccall trf_10073(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10073(t0,t1,t2);}

C_noret_decl(trf_10109)
static void C_ccall trf_10109(C_word c,C_word *av) C_noret;
static void C_ccall trf_10109(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10109(t0,t1,t2);}

C_noret_decl(trf_10138)
static void C_ccall trf_10138(C_word c,C_word *av) C_noret;
static void C_ccall trf_10138(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_10138(t0,t1,t2,t3);}

C_noret_decl(trf_10185)
static void C_ccall trf_10185(C_word c,C_word *av) C_noret;
static void C_ccall trf_10185(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10185(t0,t1,t2);}

C_noret_decl(trf_10239)
static void C_ccall trf_10239(C_word c,C_word *av) C_noret;
static void C_ccall trf_10239(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_10239(t0,t1,t2,t3);}

C_noret_decl(trf_10317)
static void C_ccall trf_10317(C_word c,C_word *av) C_noret;
static void C_ccall trf_10317(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_10317(t0,t1);}

C_noret_decl(trf_10355)
static void C_ccall trf_10355(C_word c,C_word *av) C_noret;
static void C_ccall trf_10355(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10355(t0,t1,t2);}

C_noret_decl(trf_10405)
static void C_ccall trf_10405(C_word c,C_word *av) C_noret;
static void C_ccall trf_10405(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10405(t0,t1,t2);}

C_noret_decl(trf_10516)
static void C_ccall trf_10516(C_word c,C_word *av) C_noret;
static void C_ccall trf_10516(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_10516(t0,t1);}

C_noret_decl(trf_10547)
static void C_ccall trf_10547(C_word c,C_word *av) C_noret;
static void C_ccall trf_10547(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10547(t0,t1,t2);}

C_noret_decl(trf_10624)
static void C_ccall trf_10624(C_word c,C_word *av) C_noret;
static void C_ccall trf_10624(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_10624(t0,t1,t2);}

C_noret_decl(trf_11250)
static void C_ccall trf_11250(C_word c,C_word *av) C_noret;
static void C_ccall trf_11250(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11250(t0,t1,t2,t3);}

C_noret_decl(trf_11299)
static void C_ccall trf_11299(C_word c,C_word *av) C_noret;
static void C_ccall trf_11299(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_11299(t0,t1);}

C_noret_decl(trf_11506)
static void C_ccall trf_11506(C_word c,C_word *av) C_noret;
static void C_ccall trf_11506(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_11506(t0,t1,t2);}

C_noret_decl(trf_11525)
static void C_ccall trf_11525(C_word c,C_word *av) C_noret;
static void C_ccall trf_11525(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_11525(t0,t1,t2);}

C_noret_decl(trf_11579)
static void C_ccall trf_11579(C_word c,C_word *av) C_noret;
static void C_ccall trf_11579(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11579(t0,t1,t2,t3);}

C_noret_decl(trf_11675)
static void C_ccall trf_11675(C_word c,C_word *av) C_noret;
static void C_ccall trf_11675(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11675(t0,t1,t2,t3);}

C_noret_decl(trf_11833)
static void C_ccall trf_11833(C_word c,C_word *av) C_noret;
static void C_ccall trf_11833(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_11833(t0,t1);}

C_noret_decl(trf_11842)
static void C_ccall trf_11842(C_word c,C_word *av) C_noret;
static void C_ccall trf_11842(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_11842(t0,t1);}

C_noret_decl(trf_12125)
static void C_ccall trf_12125(C_word c,C_word *av) C_noret;
static void C_ccall trf_12125(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_12125(t0,t1,t2,t3);}

C_noret_decl(trf_12214)
static void C_ccall trf_12214(C_word c,C_word *av) C_noret;
static void C_ccall trf_12214(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_12214(t0,t1,t2,t3);}

C_noret_decl(trf_12235)
static void C_ccall trf_12235(C_word c,C_word *av) C_noret;
static void C_ccall trf_12235(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_12235(t0,t1,t2,t3,t4);}

C_noret_decl(trf_12397)
static void C_ccall trf_12397(C_word c,C_word *av) C_noret;
static void C_ccall trf_12397(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_12397(t0,t1);}

C_noret_decl(trf_13097)
static void C_ccall trf_13097(C_word c,C_word *av) C_noret;
static void C_ccall trf_13097(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13097(t0,t1,t2);}

C_noret_decl(trf_13456)
static void C_ccall trf_13456(C_word c,C_word *av) C_noret;
static void C_ccall trf_13456(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13456(t0,t1,t2,t3);}

C_noret_decl(trf_13473)
static void C_ccall trf_13473(C_word c,C_word *av) C_noret;
static void C_ccall trf_13473(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13473(t0,t1,t2,t3);}

C_noret_decl(trf_13640)
static void C_ccall trf_13640(C_word c,C_word *av) C_noret;
static void C_ccall trf_13640(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13640(t0,t1,t2,t3);}

C_noret_decl(trf_14122)
static void C_ccall trf_14122(C_word c,C_word *av) C_noret;
static void C_ccall trf_14122(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_14122(t0,t1,t2);}

C_noret_decl(trf_14125)
static void C_ccall trf_14125(C_word c,C_word *av) C_noret;
static void C_ccall trf_14125(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_14125(t0,t1,t2,t3);}

C_noret_decl(trf_14304)
static void C_ccall trf_14304(C_word c,C_word *av) C_noret;
static void C_ccall trf_14304(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_14304(t0,t1,t2,t3,t4);}

C_noret_decl(trf_14348)
static void C_ccall trf_14348(C_word c,C_word *av) C_noret;
static void C_ccall trf_14348(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_14348(t0,t1,t2,t3,t4);}

C_noret_decl(trf_14611)
static void C_ccall trf_14611(C_word c,C_word *av) C_noret;
static void C_ccall trf_14611(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14611(t0,t1);}

C_noret_decl(trf_14617)
static void C_ccall trf_14617(C_word c,C_word *av) C_noret;
static void C_ccall trf_14617(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14617(t0,t1);}

C_noret_decl(trf_14673)
static void C_ccall trf_14673(C_word c,C_word *av) C_noret;
static void C_ccall trf_14673(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14673(t0,t1);}

C_noret_decl(trf_14679)
static void C_ccall trf_14679(C_word c,C_word *av) C_noret;
static void C_ccall trf_14679(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14679(t0,t1);}

C_noret_decl(trf_15152)
static void C_ccall trf_15152(C_word c,C_word *av) C_noret;
static void C_ccall trf_15152(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15152(t0,t1);}

C_noret_decl(trf_15187)
static void C_ccall trf_15187(C_word c,C_word *av) C_noret;
static void C_ccall trf_15187(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15187(t0,t1,t2,t3);}

C_noret_decl(trf_15297)
static void C_ccall trf_15297(C_word c,C_word *av) C_noret;
static void C_ccall trf_15297(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15297(t0,t1,t2,t3);}

C_noret_decl(trf_15339)
static void C_ccall trf_15339(C_word c,C_word *av) C_noret;
static void C_ccall trf_15339(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15339(t0,t1,t2);}

C_noret_decl(trf_15353)
static void C_ccall trf_15353(C_word c,C_word *av) C_noret;
static void C_ccall trf_15353(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_15353(t0,t1,t2);}

C_noret_decl(trf_15507)
static void C_ccall trf_15507(C_word c,C_word *av) C_noret;
static void C_ccall trf_15507(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15507(t0,t1);}

C_noret_decl(trf_15603)
static void C_ccall trf_15603(C_word c,C_word *av) C_noret;
static void C_ccall trf_15603(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15603(t0,t1,t2,t3);}

C_noret_decl(trf_15699)
static void C_ccall trf_15699(C_word c,C_word *av) C_noret;
static void C_ccall trf_15699(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15699(t0,t1,t2,t3);}

C_noret_decl(trf_15764)
static void C_ccall trf_15764(C_word c,C_word *av) C_noret;
static void C_ccall trf_15764(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15764(t0,t1,t2,t3);}

C_noret_decl(trf_15968)
static void C_ccall trf_15968(C_word c,C_word *av) C_noret;
static void C_ccall trf_15968(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15968(t0,t1);}

C_noret_decl(trf_16029)
static void C_ccall trf_16029(C_word c,C_word *av) C_noret;
static void C_ccall trf_16029(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_16029(t0,t1,t2);}

C_noret_decl(trf_16072)
static void C_ccall trf_16072(C_word c,C_word *av) C_noret;
static void C_ccall trf_16072(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_16072(t0,t1,t2,t3,t4);}

C_noret_decl(trf_16090)
static void C_ccall trf_16090(C_word c,C_word *av) C_noret;
static void C_ccall trf_16090(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_16090(t0,t1,t2,t3);}

C_noret_decl(trf_16170)
static void C_ccall trf_16170(C_word c,C_word *av) C_noret;
static void C_ccall trf_16170(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_16170(t0,t1,t2);}

C_noret_decl(trf_16176)
static void C_ccall trf_16176(C_word c,C_word *av) C_noret;
static void C_ccall trf_16176(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_16176(t0,t1,t2);}

C_noret_decl(trf_16239)
static void C_ccall trf_16239(C_word c,C_word *av) C_noret;
static void C_ccall trf_16239(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16239(t0,t1);}

C_noret_decl(trf_16278)
static void C_ccall trf_16278(C_word c,C_word *av) C_noret;
static void C_ccall trf_16278(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_16278(t0,t1,t2);}

C_noret_decl(trf_16284)
static void C_ccall trf_16284(C_word c,C_word *av) C_noret;
static void C_ccall trf_16284(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_16284(t0,t1,t2);}

C_noret_decl(trf_16328)
static void C_ccall trf_16328(C_word c,C_word *av) C_noret;
static void C_ccall trf_16328(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_16328(t0,t1,t2,t3,t4);}

C_noret_decl(trf_16384)
static void C_ccall trf_16384(C_word c,C_word *av) C_noret;
static void C_ccall trf_16384(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_16384(t0,t1,t2);}

C_noret_decl(trf_16399)
static void C_ccall trf_16399(C_word c,C_word *av) C_noret;
static void C_ccall trf_16399(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16399(t0,t1);}

C_noret_decl(trf_16442)
static void C_ccall trf_16442(C_word c,C_word *av) C_noret;
static void C_ccall trf_16442(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_16442(t0,t1,t2,t3,t4);}

C_noret_decl(trf_16461)
static void C_ccall trf_16461(C_word c,C_word *av) C_noret;
static void C_ccall trf_16461(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16461(t0,t1);}

C_noret_decl(trf_16473)
static void C_ccall trf_16473(C_word c,C_word *av) C_noret;
static void C_ccall trf_16473(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16473(t0,t1);}

C_noret_decl(trf_16500)
static void C_ccall trf_16500(C_word c,C_word *av) C_noret;
static void C_ccall trf_16500(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16500(t0,t1);}

C_noret_decl(trf_16656)
static void C_ccall trf_16656(C_word c,C_word *av) C_noret;
static void C_ccall trf_16656(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_16656(t0,t1,t2,t3);}

C_noret_decl(trf_16663)
static void C_ccall trf_16663(C_word c,C_word *av) C_noret;
static void C_ccall trf_16663(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16663(t0,t1);}

C_noret_decl(trf_16734)
static void C_ccall trf_16734(C_word c,C_word *av) C_noret;
static void C_ccall trf_16734(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16734(t0,t1);}

C_noret_decl(trf_17002)
static void C_ccall trf_17002(C_word c,C_word *av) C_noret;
static void C_ccall trf_17002(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_17002(t0,t1,t2);}

C_noret_decl(trf_17017)
static void C_ccall trf_17017(C_word c,C_word *av) C_noret;
static void C_ccall trf_17017(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_17017(t0,t1);}

C_noret_decl(trf_17075)
static void C_ccall trf_17075(C_word c,C_word *av) C_noret;
static void C_ccall trf_17075(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_17075(t0,t1);}

C_noret_decl(trf_17511)
static void C_ccall trf_17511(C_word c,C_word *av) C_noret;
static void C_ccall trf_17511(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_17511(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_17796)
static void C_ccall trf_17796(C_word c,C_word *av) C_noret;
static void C_ccall trf_17796(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_17796(t0,t1,t2,t3,t4);}

C_noret_decl(trf_17823)
static void C_ccall trf_17823(C_word c,C_word *av) C_noret;
static void C_ccall trf_17823(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_17823(t0,t1,t2);}

C_noret_decl(trf_17864)
static void C_ccall trf_17864(C_word c,C_word *av) C_noret;
static void C_ccall trf_17864(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_17864(t0,t1,t2,t3);}

C_noret_decl(trf_18101)
static void C_ccall trf_18101(C_word c,C_word *av) C_noret;
static void C_ccall trf_18101(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18101(t0,t1,t2);}

C_noret_decl(trf_18363)
static void C_ccall trf_18363(C_word c,C_word *av) C_noret;
static void C_ccall trf_18363(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18363(t0,t1,t2);}

C_noret_decl(trf_18582)
static void C_ccall trf_18582(C_word c,C_word *av) C_noret;
static void C_ccall trf_18582(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_18582(t0,t1,t2,t3);}

C_noret_decl(trf_18683)
static void C_ccall trf_18683(C_word c,C_word *av) C_noret;
static void C_ccall trf_18683(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18683(t0,t1,t2);}

C_noret_decl(trf_18891)
static void C_ccall trf_18891(C_word c,C_word *av) C_noret;
static void C_ccall trf_18891(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18891(t0,t1,t2);}

C_noret_decl(trf_18929)
static void C_ccall trf_18929(C_word c,C_word *av) C_noret;
static void C_ccall trf_18929(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18929(t0,t1,t2);}

C_noret_decl(trf_18977)
static void C_ccall trf_18977(C_word c,C_word *av) C_noret;
static void C_ccall trf_18977(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18977(t0,t1,t2);}

C_noret_decl(trf_19038)
static void C_ccall trf_19038(C_word c,C_word *av) C_noret;
static void C_ccall trf_19038(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19038(t0,t1,t2);}

C_noret_decl(trf_19068)
static void C_ccall trf_19068(C_word c,C_word *av) C_noret;
static void C_ccall trf_19068(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19068(t0,t1,t2);}

C_noret_decl(trf_19123)
static void C_ccall trf_19123(C_word c,C_word *av) C_noret;
static void C_ccall trf_19123(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19123(t0,t1,t2);}

C_noret_decl(trf_19164)
static void C_ccall trf_19164(C_word c,C_word *av) C_noret;
static void C_ccall trf_19164(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19164(t0,t1,t2);}

C_noret_decl(trf_19278)
static void C_ccall trf_19278(C_word c,C_word *av) C_noret;
static void C_ccall trf_19278(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19278(t0,t1,t2);}

C_noret_decl(trf_19668)
static void C_ccall trf_19668(C_word c,C_word *av) C_noret;
static void C_ccall trf_19668(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_19668(t0,t1,t2,t3,t4);}

C_noret_decl(trf_19712)
static void C_ccall trf_19712(C_word c,C_word *av) C_noret;
static void C_ccall trf_19712(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19712(t0,t1,t2);}

C_noret_decl(trf_19767)
static void C_ccall trf_19767(C_word c,C_word *av) C_noret;
static void C_ccall trf_19767(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19767(t0,t1,t2,t3);}

C_noret_decl(trf_20023)
static void C_ccall trf_20023(C_word c,C_word *av) C_noret;
static void C_ccall trf_20023(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20023(t0,t1,t2);}

C_noret_decl(trf_20036)
static void C_ccall trf_20036(C_word c,C_word *av) C_noret;
static void C_ccall trf_20036(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20036(t0,t1,t2);}

C_noret_decl(trf_20095)
static void C_ccall trf_20095(C_word c,C_word *av) C_noret;
static void C_ccall trf_20095(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20095(t0,t1,t2);}

C_noret_decl(trf_20349)
static void C_ccall trf_20349(C_word c,C_word *av) C_noret;
static void C_ccall trf_20349(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_20349(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_20353)
static void C_ccall trf_20353(C_word c,C_word *av) C_noret;
static void C_ccall trf_20353(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20353(t0,t1);}

C_noret_decl(trf_20383)
static void C_ccall trf_20383(C_word c,C_word *av) C_noret;
static void C_ccall trf_20383(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20383(t0,t1);}

C_noret_decl(trf_20403)
static void C_ccall trf_20403(C_word c,C_word *av) C_noret;
static void C_ccall trf_20403(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20403(t0,t1,t2,t3);}

C_noret_decl(trf_20412)
static void C_ccall trf_20412(C_word c,C_word *av) C_noret;
static void C_ccall trf_20412(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20412(t0,t1,t2);}

C_noret_decl(trf_20417)
static void C_ccall trf_20417(C_word c,C_word *av) C_noret;
static void C_ccall trf_20417(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20417(t0,t1);}

C_noret_decl(trf_20782)
static void C_ccall trf_20782(C_word c,C_word *av) C_noret;
static void C_ccall trf_20782(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_20782(t0,t1,t2,t3,t4);}

C_noret_decl(trf_20791)
static void C_ccall trf_20791(C_word c,C_word *av) C_noret;
static void C_ccall trf_20791(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20791(t0,t1);}

C_noret_decl(trf_20801)
static void C_ccall trf_20801(C_word c,C_word *av) C_noret;
static void C_ccall trf_20801(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20801(t0,t1,t2);}

C_noret_decl(trf_20828)
static void C_ccall trf_20828(C_word c,C_word *av) C_noret;
static void C_ccall trf_20828(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20828(t0,t1,t2);}

C_noret_decl(trf_20837)
static void C_ccall trf_20837(C_word c,C_word *av) C_noret;
static void C_ccall trf_20837(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20837(t0,t1,t2);}

C_noret_decl(trf_20852)
static void C_ccall trf_20852(C_word c,C_word *av) C_noret;
static void C_ccall trf_20852(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20852(t0,t1);}

C_noret_decl(trf_20855)
static void C_ccall trf_20855(C_word c,C_word *av) C_noret;
static void C_ccall trf_20855(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20855(t0,t1);}

C_noret_decl(trf_20865)
static void C_ccall trf_20865(C_word c,C_word *av) C_noret;
static void C_ccall trf_20865(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20865(t0,t1,t2);}

C_noret_decl(trf_20903)
static void C_ccall trf_20903(C_word c,C_word *av) C_noret;
static void C_ccall trf_20903(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_20903(t0,t1,t2,t3,t4);}

C_noret_decl(trf_20909)
static void C_ccall trf_20909(C_word c,C_word *av) C_noret;
static void C_ccall trf_20909(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20909(t0,t1,t2,t3);}

C_noret_decl(trf_20963)
static void C_ccall trf_20963(C_word c,C_word *av) C_noret;
static void C_ccall trf_20963(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20963(t0,t1,t2);}

C_noret_decl(trf_20975)
static void C_ccall trf_20975(C_word c,C_word *av) C_noret;
static void C_ccall trf_20975(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20975(t0,t1,t2,t3);}

C_noret_decl(trf_21000)
static void C_ccall trf_21000(C_word c,C_word *av) C_noret;
static void C_ccall trf_21000(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21000(t0,t1,t2);}

C_noret_decl(trf_21010)
static void C_ccall trf_21010(C_word c,C_word *av) C_noret;
static void C_ccall trf_21010(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_21010(t0,t1,t2,t3);}

C_noret_decl(trf_21191)
static void C_ccall trf_21191(C_word c,C_word *av) C_noret;
static void C_ccall trf_21191(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21191(t0,t1);}

C_noret_decl(trf_21282)
static void C_ccall trf_21282(C_word c,C_word *av) C_noret;
static void C_ccall trf_21282(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21282(t0,t1);}

C_noret_decl(trf_21302)
static void C_ccall trf_21302(C_word c,C_word *av) C_noret;
static void C_ccall trf_21302(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21302(t0,t1);}

C_noret_decl(trf_21307)
static void C_ccall trf_21307(C_word c,C_word *av) C_noret;
static void C_ccall trf_21307(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_21307(t0,t1,t2,t3);}

C_noret_decl(trf_21406)
static void C_ccall trf_21406(C_word c,C_word *av) C_noret;
static void C_ccall trf_21406(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21406(t0,t1);}

C_noret_decl(trf_21554)
static void C_ccall trf_21554(C_word c,C_word *av) C_noret;
static void C_ccall trf_21554(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_21554(t0,t1,t2,t3);}

C_noret_decl(trf_21563)
static void C_ccall trf_21563(C_word c,C_word *av) C_noret;
static void C_ccall trf_21563(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21563(t0,t1,t2);}

C_noret_decl(trf_21618)
static void C_ccall trf_21618(C_word c,C_word *av) C_noret;
static void C_ccall trf_21618(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21618(t0,t1,t2);}

C_noret_decl(trf_21625)
static void C_ccall trf_21625(C_word c,C_word *av) C_noret;
static void C_ccall trf_21625(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21625(t0,t1);}

C_noret_decl(trf_21668)
static void C_ccall trf_21668(C_word c,C_word *av) C_noret;
static void C_ccall trf_21668(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21668(t0,t1);}

C_noret_decl(trf_21816)
static void C_ccall trf_21816(C_word c,C_word *av) C_noret;
static void C_ccall trf_21816(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21816(t0,t1);}

C_noret_decl(trf_21834)
static void C_ccall trf_21834(C_word c,C_word *av) C_noret;
static void C_ccall trf_21834(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_21834(t0,t1,t2,t3);}

C_noret_decl(trf_21904)
static void C_ccall trf_21904(C_word c,C_word *av) C_noret;
static void C_ccall trf_21904(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21904(t0,t1,t2);}

C_noret_decl(trf_21955)
static void C_ccall trf_21955(C_word c,C_word *av) C_noret;
static void C_ccall trf_21955(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21955(t0,t1,t2);}

C_noret_decl(trf_22022)
static void C_ccall trf_22022(C_word c,C_word *av) C_noret;
static void C_ccall trf_22022(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22022(t0,t1);}

C_noret_decl(trf_22032)
static void C_ccall trf_22032(C_word c,C_word *av) C_noret;
static void C_ccall trf_22032(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_22032(t0,t1,t2,t3);}

C_noret_decl(trf_22042)
static void C_ccall trf_22042(C_word c,C_word *av) C_noret;
static void C_ccall trf_22042(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22042(t0,t1);}

C_noret_decl(trf_22086)
static void C_ccall trf_22086(C_word c,C_word *av) C_noret;
static void C_ccall trf_22086(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22086(t0,t1);}

C_noret_decl(trf_22096)
static void C_ccall trf_22096(C_word c,C_word *av) C_noret;
static void C_ccall trf_22096(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_22096(t0,t1,t2,t3);}

C_noret_decl(trf_22132)
static void C_ccall trf_22132(C_word c,C_word *av) C_noret;
static void C_ccall trf_22132(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22132(t0,t1);}

C_noret_decl(trf_22157)
static void C_ccall trf_22157(C_word c,C_word *av) C_noret;
static void C_ccall trf_22157(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_22157(t0,t1,t2);}

C_noret_decl(trf_22162)
static void C_ccall trf_22162(C_word c,C_word *av) C_noret;
static void C_ccall trf_22162(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22162(t0,t1);}

C_noret_decl(trf_22167)
static void C_ccall trf_22167(C_word c,C_word *av) C_noret;
static void C_ccall trf_22167(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_22167(t0,t1,t2,t3,t4);}

C_noret_decl(trf_22180)
static void C_ccall trf_22180(C_word c,C_word *av) C_noret;
static void C_ccall trf_22180(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22180(t0,t1);}

C_noret_decl(trf_22186)
static void C_ccall trf_22186(C_word c,C_word *av) C_noret;
static void C_ccall trf_22186(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22186(t0,t1);}

C_noret_decl(trf_22216)
static void C_ccall trf_22216(C_word c,C_word *av) C_noret;
static void C_ccall trf_22216(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22216(t0,t1);}

C_noret_decl(trf_22408)
static void C_ccall trf_22408(C_word c,C_word *av) C_noret;
static void C_ccall trf_22408(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22408(t0,t1);}

C_noret_decl(trf_22447)
static void C_ccall trf_22447(C_word c,C_word *av) C_noret;
static void C_ccall trf_22447(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22447(t0,t1);}

C_noret_decl(trf_22592)
static void C_ccall trf_22592(C_word c,C_word *av) C_noret;
static void C_ccall trf_22592(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22592(t0,t1);}

C_noret_decl(trf_22617)
static void C_ccall trf_22617(C_word c,C_word *av) C_noret;
static void C_ccall trf_22617(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22617(t0,t1);}

C_noret_decl(trf_22623)
static void C_ccall trf_22623(C_word c,C_word *av) C_noret;
static void C_ccall trf_22623(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_22623(t0,t1,t2);}

C_noret_decl(trf_22704)
static void C_ccall trf_22704(C_word c,C_word *av) C_noret;
static void C_ccall trf_22704(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22704(t0,t1);}

C_noret_decl(trf_22717)
static void C_ccall trf_22717(C_word c,C_word *av) C_noret;
static void C_ccall trf_22717(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_22717(t0,t1,t2);}

C_noret_decl(trf_23325)
static void C_ccall trf_23325(C_word c,C_word *av) C_noret;
static void C_ccall trf_23325(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_23325(t0,t1);}

C_noret_decl(trf_23879)
static void C_ccall trf_23879(C_word c,C_word *av) C_noret;
static void C_ccall trf_23879(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23879(t0,t1,t2);}

C_noret_decl(trf_23925)
static void C_ccall trf_23925(C_word c,C_word *av) C_noret;
static void C_ccall trf_23925(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23925(t0,t1,t2,t3);}

C_noret_decl(trf_24188)
static void C_ccall trf_24188(C_word c,C_word *av) C_noret;
static void C_ccall trf_24188(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24188(t0,t1,t2);}

C_noret_decl(trf_24239)
static void C_ccall trf_24239(C_word c,C_word *av) C_noret;
static void C_ccall trf_24239(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24239(t0,t1,t2);}

C_noret_decl(trf_24298)
static void C_ccall trf_24298(C_word c,C_word *av) C_noret;
static void C_ccall trf_24298(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_24298(t0,t1,t2,t3);}

C_noret_decl(trf_24370)
static void C_ccall trf_24370(C_word c,C_word *av) C_noret;
static void C_ccall trf_24370(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_24370(t0,t1,t2,t3);}

C_noret_decl(trf_24430)
static void C_ccall trf_24430(C_word c,C_word *av) C_noret;
static void C_ccall trf_24430(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_24430(t0,t1,t2,t3);}

C_noret_decl(trf_24454)
static void C_ccall trf_24454(C_word c,C_word *av) C_noret;
static void C_ccall trf_24454(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_24454(t0,t1,t2,t3);}

C_noret_decl(trf_24466)
static void C_ccall trf_24466(C_word c,C_word *av) C_noret;
static void C_ccall trf_24466(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24466(t0,t1,t2);}

C_noret_decl(trf_24543)
static void C_ccall trf_24543(C_word c,C_word *av) C_noret;
static void C_ccall trf_24543(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24543(t0,t1,t2);}

C_noret_decl(trf_24592)
static void C_ccall trf_24592(C_word c,C_word *av) C_noret;
static void C_ccall trf_24592(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24592(t0,t1,t2);}

C_noret_decl(trf_24608)
static void C_ccall trf_24608(C_word c,C_word *av) C_noret;
static void C_ccall trf_24608(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_24608(t0,t1);}

C_noret_decl(trf_24627)
static void C_ccall trf_24627(C_word c,C_word *av) C_noret;
static void C_ccall trf_24627(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_24627(t0,t1);}

C_noret_decl(trf_24737)
static void C_ccall trf_24737(C_word c,C_word *av) C_noret;
static void C_ccall trf_24737(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24737(t0,t1,t2);}

C_noret_decl(trf_24802)
static void C_ccall trf_24802(C_word c,C_word *av) C_noret;
static void C_ccall trf_24802(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24802(t0,t1,t2);}

C_noret_decl(trf_24959)
static void C_ccall trf_24959(C_word c,C_word *av) C_noret;
static void C_ccall trf_24959(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_24959(t0,t1,t2,t3);}

C_noret_decl(trf_25138)
static void C_ccall trf_25138(C_word c,C_word *av) C_noret;
static void C_ccall trf_25138(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25138(t0,t1,t2);}

C_noret_decl(trf_25210)
static void C_ccall trf_25210(C_word c,C_word *av) C_noret;
static void C_ccall trf_25210(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25210(t0,t1,t2);}

C_noret_decl(trf_25349)
static void C_ccall trf_25349(C_word c,C_word *av) C_noret;
static void C_ccall trf_25349(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_25349(t0,t1,t2,t3);}

C_noret_decl(trf_25748)
static void C_ccall trf_25748(C_word c,C_word *av) C_noret;
static void C_ccall trf_25748(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_25748(t0,t1,t2,t3,t4);}

C_noret_decl(trf_25768)
static void C_ccall trf_25768(C_word c,C_word *av) C_noret;
static void C_ccall trf_25768(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_25768(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_25822)
static void C_ccall trf_25822(C_word c,C_word *av) C_noret;
static void C_ccall trf_25822(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25822(t0,t1);}

C_noret_decl(trf_26019)
static void C_ccall trf_26019(C_word c,C_word *av) C_noret;
static void C_ccall trf_26019(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26019(t0,t1,t2);}

C_noret_decl(trf_26034)
static void C_ccall trf_26034(C_word c,C_word *av) C_noret;
static void C_ccall trf_26034(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26034(t0,t1,t2);}

C_noret_decl(trf_26137)
static void C_ccall trf_26137(C_word c,C_word *av) C_noret;
static void C_ccall trf_26137(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26137(t0,t1,t2);}

C_noret_decl(trf_26156)
static void C_ccall trf_26156(C_word c,C_word *av) C_noret;
static void C_ccall trf_26156(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26156(t0,t1);}

C_noret_decl(trf_26275)
static void C_ccall trf_26275(C_word c,C_word *av) C_noret;
static void C_ccall trf_26275(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26275(t0,t1,t2);}

C_noret_decl(trf_26312)
static void C_ccall trf_26312(C_word c,C_word *av) C_noret;
static void C_ccall trf_26312(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26312(t0,t1);}

C_noret_decl(trf_26346)
static void C_ccall trf_26346(C_word c,C_word *av) C_noret;
static void C_ccall trf_26346(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26346(t0,t1,t2);}

C_noret_decl(trf_26482)
static void C_ccall trf_26482(C_word c,C_word *av) C_noret;
static void C_ccall trf_26482(C_word c,C_word *av){
C_word t0=av[0];
f_26482(t0);}

C_noret_decl(trf_26530)
static void C_ccall trf_26530(C_word c,C_word *av) C_noret;
static void C_ccall trf_26530(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26530(t0,t1);}

C_noret_decl(trf_26554)
static void C_ccall trf_26554(C_word c,C_word *av) C_noret;
static void C_ccall trf_26554(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26554(t0,t1,t2);}

C_noret_decl(trf_26649)
static void C_ccall trf_26649(C_word c,C_word *av) C_noret;
static void C_ccall trf_26649(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26649(t0,t1,t2);}

C_noret_decl(trf_26697)
static void C_ccall trf_26697(C_word c,C_word *av) C_noret;
static void C_ccall trf_26697(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26697(t0,t1);}

C_noret_decl(trf_26700)
static void C_ccall trf_26700(C_word c,C_word *av) C_noret;
static void C_ccall trf_26700(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26700(t0,t1);}

C_noret_decl(trf_26720)
static void C_ccall trf_26720(C_word c,C_word *av) C_noret;
static void C_ccall trf_26720(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26720(t0,t1);}

C_noret_decl(trf_27167)
static void C_ccall trf_27167(C_word c,C_word *av) C_noret;
static void C_ccall trf_27167(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_27167(t0,t1,t2,t3);}

C_noret_decl(trf_27173)
static void C_ccall trf_27173(C_word c,C_word *av) C_noret;
static void C_ccall trf_27173(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27173(t0,t1,t2);}

C_noret_decl(trf_27189)
static void C_ccall trf_27189(C_word c,C_word *av) C_noret;
static void C_ccall trf_27189(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27189(t0,t1);}

C_noret_decl(trf_27286)
static void C_ccall trf_27286(C_word c,C_word *av) C_noret;
static void C_ccall trf_27286(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27286(t0,t1,t2);}

C_noret_decl(trf_27332)
static void C_ccall trf_27332(C_word c,C_word *av) C_noret;
static void C_ccall trf_27332(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27332(t0,t1,t2);}

C_noret_decl(trf_27408)
static void C_ccall trf_27408(C_word c,C_word *av) C_noret;
static void C_ccall trf_27408(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27408(t0,t1,t2);}

C_noret_decl(trf_27460)
static void C_ccall trf_27460(C_word c,C_word *av) C_noret;
static void C_ccall trf_27460(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27460(t0,t1,t2);}

C_noret_decl(trf_27508)
static void C_ccall trf_27508(C_word c,C_word *av) C_noret;
static void C_ccall trf_27508(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27508(t0,t1,t2);}

C_noret_decl(trf_27522)
static void C_ccall trf_27522(C_word c,C_word *av) C_noret;
static void C_ccall trf_27522(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27522(t0,t1,t2);}

C_noret_decl(trf_27578)
static void C_ccall trf_27578(C_word c,C_word *av) C_noret;
static void C_ccall trf_27578(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27578(t0,t1,t2);}

C_noret_decl(trf_27703)
static void C_ccall trf_27703(C_word c,C_word *av) C_noret;
static void C_ccall trf_27703(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27703(t0,t1,t2);}

C_noret_decl(trf_27705)
static void C_ccall trf_27705(C_word c,C_word *av) C_noret;
static void C_ccall trf_27705(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27705(t0,t1,t2);}

C_noret_decl(trf_27726)
static void C_ccall trf_27726(C_word c,C_word *av) C_noret;
static void C_ccall trf_27726(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27726(t0,t1,t2);}

C_noret_decl(trf_27750)
static void C_ccall trf_27750(C_word c,C_word *av) C_noret;
static void C_ccall trf_27750(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_27750(t0,t1,t2,t3);}

C_noret_decl(trf_27804)
static void C_ccall trf_27804(C_word c,C_word *av) C_noret;
static void C_ccall trf_27804(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27804(t0,t1,t2);}

C_noret_decl(trf_27899)
static void C_ccall trf_27899(C_word c,C_word *av) C_noret;
static void C_ccall trf_27899(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27899(t0,t1,t2);}

C_noret_decl(trf_27904)
static void C_ccall trf_27904(C_word c,C_word *av) C_noret;
static void C_ccall trf_27904(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27904(t0,t1);}

C_noret_decl(trf_28888)
static void C_ccall trf_28888(C_word c,C_word *av) C_noret;
static void C_ccall trf_28888(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28888(t0,t1,t2);}

C_noret_decl(trf_28952)
static void C_ccall trf_28952(C_word c,C_word *av) C_noret;
static void C_ccall trf_28952(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28952(t0,t1,t2);}

C_noret_decl(trf_29234)
static void C_ccall trf_29234(C_word c,C_word *av) C_noret;
static void C_ccall trf_29234(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_29234(t0,t1);}

C_noret_decl(trf_29324)
static void C_ccall trf_29324(C_word c,C_word *av) C_noret;
static void C_ccall trf_29324(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29324(t0,t1,t2);}

C_noret_decl(trf_29368)
static void C_ccall trf_29368(C_word c,C_word *av) C_noret;
static void C_ccall trf_29368(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_29368(t0,t1);}

C_noret_decl(trf_29381)
static void C_ccall trf_29381(C_word c,C_word *av) C_noret;
static void C_ccall trf_29381(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29381(t0,t1,t2);}

C_noret_decl(trf_29415)
static void C_ccall trf_29415(C_word c,C_word *av) C_noret;
static void C_ccall trf_29415(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29415(t0,t1,t2);}

C_noret_decl(trf_29430)
static void C_ccall trf_29430(C_word c,C_word *av) C_noret;
static void C_ccall trf_29430(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_29430(t0,t1);}

C_noret_decl(trf_29506)
static void C_ccall trf_29506(C_word c,C_word *av) C_noret;
static void C_ccall trf_29506(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29506(t0,t1,t2);}

C_noret_decl(trf_29606)
static void C_ccall trf_29606(C_word c,C_word *av) C_noret;
static void C_ccall trf_29606(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_29606(t0,t1);}

C_noret_decl(trf_29625)
static void C_ccall trf_29625(C_word c,C_word *av) C_noret;
static void C_ccall trf_29625(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29625(t0,t1,t2);}

C_noret_decl(trf_29666)
static void C_ccall trf_29666(C_word c,C_word *av) C_noret;
static void C_ccall trf_29666(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_29666(t0,t1,t2,t3,t4);}

C_noret_decl(trf_29989)
static void C_ccall trf_29989(C_word c,C_word *av) C_noret;
static void C_ccall trf_29989(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29989(t0,t1,t2);}

C_noret_decl(trf_30001)
static void C_ccall trf_30001(C_word c,C_word *av) C_noret;
static void C_ccall trf_30001(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30001(t0,t1,t2);}

C_noret_decl(trf_30082)
static void C_ccall trf_30082(C_word c,C_word *av) C_noret;
static void C_ccall trf_30082(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_30082(t0,t1,t2,t3);}

C_noret_decl(trf_30296)
static void C_ccall trf_30296(C_word c,C_word *av) C_noret;
static void C_ccall trf_30296(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30296(t0,t1,t2);}

C_noret_decl(trf_30334)
static void C_ccall trf_30334(C_word c,C_word *av) C_noret;
static void C_ccall trf_30334(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30334(t0,t1,t2);}

C_noret_decl(trf_30413)
static void C_ccall trf_30413(C_word c,C_word *av) C_noret;
static void C_ccall trf_30413(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30413(t0,t1,t2);}

C_noret_decl(trf_30541)
static void C_ccall trf_30541(C_word c,C_word *av) C_noret;
static void C_ccall trf_30541(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30541(t0,t1);}

C_noret_decl(trf_30975)
static void C_ccall trf_30975(C_word c,C_word *av) C_noret;
static void C_ccall trf_30975(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30975(t0,t1);}

C_noret_decl(trf_30987)
static void C_ccall trf_30987(C_word c,C_word *av) C_noret;
static void C_ccall trf_30987(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30987(t0,t1,t2);}

C_noret_decl(trf_31046)
static void C_ccall trf_31046(C_word c,C_word *av) C_noret;
static void C_ccall trf_31046(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31046(t0,t1);}

C_noret_decl(trf_31060)
static void C_ccall trf_31060(C_word c,C_word *av) C_noret;
static void C_ccall trf_31060(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31060(t0,t1,t2);}

C_noret_decl(trf_31082)
static void C_ccall trf_31082(C_word c,C_word *av) C_noret;
static void C_ccall trf_31082(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31082(t0,t1,t2);}

C_noret_decl(trf_31297)
static void C_ccall trf_31297(C_word c,C_word *av) C_noret;
static void C_ccall trf_31297(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31297(t0,t1);}

C_noret_decl(trf_31320)
static void C_ccall trf_31320(C_word c,C_word *av) C_noret;
static void C_ccall trf_31320(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31320(t0,t1);}

C_noret_decl(trf_31474)
static void C_ccall trf_31474(C_word c,C_word *av) C_noret;
static void C_ccall trf_31474(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_31474(t0,t1,t2,t3);}

C_noret_decl(trf_31629)
static void C_ccall trf_31629(C_word c,C_word *av) C_noret;
static void C_ccall trf_31629(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31629(t0,t1);}

C_noret_decl(trf_31662)
static void C_ccall trf_31662(C_word c,C_word *av) C_noret;
static void C_ccall trf_31662(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31662(t0,t1);}

C_noret_decl(trf_31665)
static void C_ccall trf_31665(C_word c,C_word *av) C_noret;
static void C_ccall trf_31665(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31665(t0,t1);}

C_noret_decl(trf_31668)
static void C_ccall trf_31668(C_word c,C_word *av) C_noret;
static void C_ccall trf_31668(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31668(t0,t1);}

C_noret_decl(trf_31671)
static void C_ccall trf_31671(C_word c,C_word *av) C_noret;
static void C_ccall trf_31671(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31671(t0,t1);}

C_noret_decl(trf_31708)
static void C_ccall trf_31708(C_word c,C_word *av) C_noret;
static void C_ccall trf_31708(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31708(t0,t1,t2);}

C_noret_decl(trf_31744)
static void C_ccall trf_31744(C_word c,C_word *av) C_noret;
static void C_ccall trf_31744(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31744(t0,t1,t2);}

C_noret_decl(trf_31775)
static void C_ccall trf_31775(C_word c,C_word *av) C_noret;
static void C_ccall trf_31775(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31775(t0,t1,t2);}

C_noret_decl(trf_31818)
static void C_ccall trf_31818(C_word c,C_word *av) C_noret;
static void C_ccall trf_31818(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31818(t0,t1,t2);}

C_noret_decl(trf_31989)
static void C_ccall trf_31989(C_word c,C_word *av) C_noret;
static void C_ccall trf_31989(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31989(t0,t1,t2);}

C_noret_decl(trf_32220)
static void C_ccall trf_32220(C_word c,C_word *av) C_noret;
static void C_ccall trf_32220(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32220(t0,t1,t2);}

C_noret_decl(trf_32376)
static void C_ccall trf_32376(C_word c,C_word *av) C_noret;
static void C_ccall trf_32376(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32376(t0,t1,t2);}

C_noret_decl(trf_32415)
static void C_ccall trf_32415(C_word c,C_word *av) C_noret;
static void C_ccall trf_32415(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32415(t0,t1,t2);}

C_noret_decl(trf_32431)
static void C_ccall trf_32431(C_word c,C_word *av) C_noret;
static void C_ccall trf_32431(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32431(t0,t1,t2);}

C_noret_decl(trf_32597)
static void C_ccall trf_32597(C_word c,C_word *av) C_noret;
static void C_ccall trf_32597(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32597(t0,t1);}

C_noret_decl(trf_33109)
static void C_ccall trf_33109(C_word c,C_word *av) C_noret;
static void C_ccall trf_33109(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_33109(t0,t1,t2,t3,t4);}

C_noret_decl(trf_33204)
static void C_ccall trf_33204(C_word c,C_word *av) C_noret;
static void C_ccall trf_33204(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_33204(t0,t1);}

C_noret_decl(trf_33217)
static void C_ccall trf_33217(C_word c,C_word *av) C_noret;
static void C_ccall trf_33217(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_33217(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_9156)
static void C_ccall trf_9156(C_word c,C_word *av) C_noret;
static void C_ccall trf_9156(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_9156(t0,t1,t2,t3);}

C_noret_decl(trf_9626)
static void C_ccall trf_9626(C_word c,C_word *av) C_noret;
static void C_ccall trf_9626(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_9626(t0,t1,t2,t3);}

C_noret_decl(trf_9663)
static void C_ccall trf_9663(C_word c,C_word *av) C_noret;
static void C_ccall trf_9663(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9663(t0,t1,t2);}

C_noret_decl(trf_9749)
static void C_ccall trf_9749(C_word c,C_word *av) C_noret;
static void C_ccall trf_9749(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9749(t0,t1,t2);}

C_noret_decl(trf_9782)
static void C_ccall trf_9782(C_word c,C_word *av) C_noret;
static void C_ccall trf_9782(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9782(t0,t1,t2);}

C_noret_decl(trf_9900)
static void C_ccall trf_9900(C_word c,C_word *av) C_noret;
static void C_ccall trf_9900(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9900(t0,t1,t2);}

C_noret_decl(trf_9935)
static void C_ccall trf_9935(C_word c,C_word *av) C_noret;
static void C_ccall trf_9935(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9935(t0,t1,t2);}

C_noret_decl(trf_9999)
static void C_ccall trf_9999(C_word c,C_word *av) C_noret;
static void C_ccall trf_9999(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_9999(t0,t1,t2);}

/* f35157 in chicken.base#emergency-exit in k8834 */
static void C_ccall f35157(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f35157,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_exit_runtime(C_fix(0));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f35726 in chicken.base#exit in k8834 */
static void C_ccall f35726(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f35726,c,av);}
/* library.scm:731: g673 */
t2=t1;{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(0);
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* f35941 in chicken.base#gensym in k10751 in k8834 */
static void C_ccall f35941(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f35941,c,av);}
/* library.scm:2771: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[421]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[421]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[660];
av2[3]=t1;
tp(4,av2);}}

/* f35945 in k18054 in chicken.base#gensym in k10751 in k8834 */
static void C_ccall f35945(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f35945,c,av);}
/* library.scm:2771: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[421]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[421]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* f38368 in k32197 in k30106 in k29927 in k29289 in k29069 in k27700 in k27697 in k27694 in k26927 in k26591 in k26587 in k26583 in k25449 in k24279 in k24275 in k24271 in k20708 in k20704 in k20700 in k20696 in k20692 in ... */
static void C_ccall f38368(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f38368,c,av);}
t3=C_i_check_list_2(t2,lf[1407]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* f38374 in k32284 in k29927 in k29289 in k29069 in k27700 in k27697 in k27694 in k26927 in k26591 in k26587 in k26583 in k25449 in k24279 in k24275 in k24271 in k20708 in k20704 in k20700 in k20696 in k20692 in k20332 in ... */
static void C_ccall f38374(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f38374,c,av);}
t3=C_i_check_string_2(t2,lf[1410]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* f38380 in k32280 in k32284 in k29927 in k29289 in k29069 in k27700 in k27697 in k27694 in k26927 in k26591 in k26587 in k26583 in k25449 in k24279 in k24275 in k24271 in k20708 in k20704 in k20700 in k20696 in k20692 in ... */
static void C_ccall f38380(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f38380,c,av);}
t3=C_i_check_string_2(t2,lf[1410]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k10016 in loop */
static void C_ccall f_10018(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_10018,c,av);}
/* library.scm:817: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_9999(t2,((C_word*)t0)[3],((C_word*)t0)[4]);}

/* chicken.base#bwp-object? in k8834 */
static void C_ccall f_10027(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10027,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_bwpp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#weak-cons in k8834 */
static void C_ccall f_10030(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_10030,c,av);}
a=C_alloc(3);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_weak_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.base#weak-pair? in k8834 */
static void C_ccall f_10033(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10033,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_weak_pairp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#atom? in k8834 */
static void C_ccall f_10036(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10036,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_not_pair_p(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#tail? in k8834 */
static void C_ccall f_10039(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_10039,c,av);}
a=C_alloc(4);
t4=C_i_check_list_2(t3,lf[252]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10048,a[2]=t2,a[3]=((C_word)li177),tmp=(C_word)a,a+=4,tmp);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
  f_10048(t5,t3)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* loop in chicken.base#tail? in k8834 */
static C_word C_fcall f_10048(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_overflow_check;
loop:{}
if(C_truep(C_eqp(((C_word*)t0)[2],t1))){
return(C_SCHEME_TRUE);}
else{
t2=(C_truep(C_blockp(t1))?C_pairp(t1):C_SCHEME_FALSE);
if(C_truep(t2)){
t4=C_slot(t1,C_fix(1));
t1=t4;
goto loop;}
else{
return(C_SCHEME_FALSE);}}}

/* chicken.base#intersperse in k8834 */
static void C_ccall f_10067(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_10067,c,av);}
a=C_alloc(7);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_10073,a[2]=t3,a[3]=t5,a[4]=((C_word)li179),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_10073(t7,t1,t2);}

/* loop in chicken.base#intersperse in k8834 */
static void C_fcall f_10073(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_10073,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_eqp(t2,C_SCHEME_END_OF_LIST))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_cdr(t2);
if(C_truep(C_eqp(t3,C_SCHEME_END_OF_LIST))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_10098,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:846: loop */
t7=t5;
t8=t3;
t1=t7;
t2=t8;
goto loop;}}}

/* k10096 in loop in chicken.base#intersperse in k8834 */
static void C_ccall f_10098(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_10098,c,av);}
a=C_alloc(6);
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[4],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#butlast in k8834 */
static void C_ccall f_10100(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_10100,c,av);}
a=C_alloc(6);
t3=C_i_check_pair_2(t2,lf[255]);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10109,a[2]=t5,a[3]=((C_word)li181),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_10109(t7,t1,t2);}

/* loop in chicken.base#butlast in k8834 */
static void C_fcall f_10109(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_10109,3,t0,t1,t2);}
a=C_alloc(4);
t3=C_slot(t2,C_fix(1));
t4=(C_truep(C_blockp(t3))?C_pairp(t3):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_slot(t2,C_fix(0));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10130,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* library.scm:853: loop */
t8=t6;
t9=t3;
t1=t8;
t2=t9;
goto loop;}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k10128 in loop in chicken.base#butlast in k8834 */
static void C_ccall f_10130(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_10130,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#flatten in k8834 */
static void C_ccall f_10132(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,4)))){
C_save_and_reclaim((void*)f_10132,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10138,a[2]=t4,a[3]=((C_word)li183),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_10138(t6,t1,t2,C_SCHEME_END_OF_LIST);}

/* loop in chicken.base#flatten in k8834 */
static void C_fcall f_10138(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_10138,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
if(C_truep(C_i_listp(t4))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_10164,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:863: loop */
t8=t6;
t9=t5;
t10=t3;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10171,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:864: loop */
t8=t6;
t9=t5;
t10=t3;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* k10162 in loop in chicken.base#flatten in k8834 */
static void C_ccall f_10164(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_10164,c,av);}
/* library.scm:863: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_10138(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k10169 in loop in chicken.base#flatten in k8834 */
static void C_ccall f_10171(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_10171,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#join in k8834 */
static void C_ccall f_10173(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +7,c,3)))){
C_save_and_reclaim((void*)f_10173,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+7);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=C_i_pairp(t3);
t5=(C_truep(t4)?C_get_rest_arg(c,3,av,3,t0):C_SCHEME_END_OF_LIST);
t6=C_i_check_list_2(t5,lf[258]);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_10185,a[2]=t5,a[3]=t8,a[4]=((C_word)li185),tmp=(C_word)a,a+=5,tmp));
t10=((C_word*)t8)[1];
f_10185(t10,t1,t2);}

/* loop in chicken.base#join in k8834 */
static void C_fcall f_10185(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_10185,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_pairp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:874: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
if(C_truep(C_i_nullp(t5))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_10220,a[2]=t1,a[3]=t4,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* library.scm:880: loop */
t8=t6;
t9=t5;
t1=t8;
t2=t9;
goto loop;}}}}

/* k10218 in loop in chicken.base#join in k8834 */
static void C_ccall f_10220(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_10220,c,av);}
/* library.scm:880: ##sys#append */
t2=*((C_word*)lf[259]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* chicken.base#compress in k8834 */
static void C_ccall f_10230(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_10230,c,av);}
a=C_alloc(7);
t4=lf[261];
t5=C_i_check_list_2(t3,lf[262]);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_10239,a[2]=t4,a[3]=t7,a[4]=((C_word)li187),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_10239(t9,t1,t2,t3);}

/* loop in chicken.base#compress in k8834 */
static void C_fcall f_10239(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,5)))){
C_save_and_reclaim_args((void *)trf_10239,4,t0,t1,t2,t3);}
a=C_alloc(4);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_i_pairp(t2);
if(C_truep(C_i_not(t4))){
/* library.scm:889: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word av2[6];
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[263];
av2[3]=lf[262];
av2[4]=((C_word*)t0)[2];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}
else{
t5=C_i_pairp(t3);
if(C_truep(C_i_not(t5))){
/* library.scm:891: ##sys#signal-hook */
t6=C_fast_retrieve(lf[194]);{
C_word av2[6];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[263];
av2[3]=lf[262];
av2[4]=((C_word*)t0)[2];
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(6,av2);}}
else{
if(C_truep(C_slot(t2,C_fix(0)))){
t6=C_slot(t3,C_fix(0));
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10281,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* library.scm:893: loop */
t9=t7;
t10=C_slot(t2,C_fix(1));
t11=C_slot(t3,C_fix(1));
t1=t9;
t2=t10;
t3=t11;
goto loop;}
else{
/* library.scm:894: loop */
t9=t1;
t10=C_slot(t2,C_fix(1));
t11=C_slot(t3,C_fix(1));
t1=t9;
t2=t10;
t3=t11;
goto loop;}}}}}

/* k10279 in loop in chicken.base#compress in k8834 */
static void C_ccall f_10281(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_10281,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#alist-update! in k8834 */
static void C_ccall f_10310(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_10310,c,av);}
a=C_alloc(10);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?*((C_word*)lf[5]+1):C_get_rest_arg(c,5,av,5,t0));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10317,a[2]=t3,a[3]=t1,a[4]=t4,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t8=C_eqp(*((C_word*)lf[4]+1),t6);
if(C_truep(t8)){
t9=t7;
f_10317(t9,*((C_word*)lf[52]+1));}
else{
t9=C_eqp(*((C_word*)lf[5]+1),t6);
if(C_truep(t9)){
t10=t7;
f_10317(t10,*((C_word*)lf[53]+1));}
else{
t10=C_eqp(*((C_word*)lf[6]+1),t6);
t11=t7;
f_10317(t11,(C_truep(t10)?*((C_word*)lf[54]+1):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10349,a[2]=t6,a[3]=((C_word)li190),tmp=(C_word)a,a+=4,tmp)));}}}

/* k10315 in chicken.base#alist-update! in k8834 */
static void C_fcall f_10317(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_10317,2,t0,t1);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10320,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:911: aq */
t3=t1;{
C_word av2[4];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k10318 in k10315 in chicken.base#alist-update! in k8834 */
static void C_ccall f_10320(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_10320,c,av);}
a=C_alloc(6);
if(C_truep(t1)){
t2=C_i_setslot(t1,C_fix(1),((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=C_a_i_cons(&a,2,((C_word*)t0)[5],((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,t2,((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* f_10349 in chicken.base#alist-update! in k8834 */
static void C_ccall f_10349(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_10349,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10355,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li189),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_10355(t7,t1,t3);}

/* loop */
static void C_fcall f_10355(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_10355,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10371,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_i_pairp(t3))){
/* library.scm:908: cmp */
t5=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(4,av2);}}
else{
/* library.scm:910: loop */
t6=t1;
t7=C_slot(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k10369 in loop */
static void C_ccall f_10371(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_10371,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:910: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_10355(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.base#alist-update in k8834 */
static void C_ccall f_10396(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_10396,c,av);}
a=C_alloc(9);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?*((C_word*)lf[5]+1):C_get_rest_arg(c,5,av,5,t0));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_10405,a[2]=t2,a[3]=t3,a[4]=t8,a[5]=t6,a[6]=((C_word)li192),tmp=(C_word)a,a+=7,tmp));
t10=((C_word*)t8)[1];
f_10405(t10,t1,t4);}

/* loop in chicken.base#alist-update in k8834 */
static void C_fcall f_10405(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,4)))){
C_save_and_reclaim_args((void *)trf_10405,3,t0,t1,t2);}
a=C_alloc(8);
if(C_truep(C_i_nullp(t2))){
t3=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_a_i_list1(&a,1,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_pairp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:923: chicken.base#error */
t4=*((C_word*)lf[193]+1);{
C_word av2[5];
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[266];
av2[3]=lf[267];
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_pairp(t4);
if(C_truep(C_i_not(t5))){
/* library.scm:927: chicken.base#error */
t6=*((C_word*)lf[193]+1);{
C_word av2[5];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[266];
av2[3]=lf[268];
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_10446,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t1,a[6]=t4,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* library.scm:928: cmp */
t7=((C_word*)t0)[5];{
C_word av2[4];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[2];
av2[3]=C_slot(t4,C_fix(0));
((C_proc)C_fast_retrieve_proc(t7))(4,av2);}}}}}

/* k10444 in loop in chicken.base#alist-update in k8834 */
static void C_ccall f_10446(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_10446,c,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_slot(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_slot(((C_word*)t0)[6],C_fix(0));
t3=C_slot(((C_word*)t0)[6],C_fix(1));
t4=C_a_i_cons(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10468,a[2]=((C_word*)t0)[5],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:932: loop */
t6=((C_word*)((C_word*)t0)[7])[1];
f_10405(t6,t5,C_slot(((C_word*)t0)[4],C_fix(1)));}}

/* k10466 in k10444 in loop in chicken.base#alist-update in k8834 */
static void C_ccall f_10468(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_10468,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#alist-ref in k8834 */
static void C_ccall f_10500(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_10500,c,av);}
a=C_alloc(10);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?*((C_word*)lf[5]+1):C_get_rest_arg(c,4,av,4,t0));
t6=C_rest_nullp(c,4);
t7=C_rest_nullp(c,5);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_get_rest_arg(c,5,av,4,t0));
t9=C_rest_nullp(c,5);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10516,a[2]=t1,a[3]=t8,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=C_eqp(*((C_word*)lf[4]+1),t5);
if(C_truep(t11)){
t12=t10;
f_10516(t12,*((C_word*)lf[52]+1));}
else{
t12=C_eqp(*((C_word*)lf[5]+1),t5);
if(C_truep(t12)){
t13=t10;
f_10516(t13,*((C_word*)lf[53]+1));}
else{
t13=C_eqp(*((C_word*)lf[6]+1),t5);
t14=t10;
f_10516(t14,(C_truep(t13)?*((C_word*)lf[54]+1):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10541,a[2]=t5,a[3]=((C_word)li195),tmp=(C_word)a,a+=4,tmp)));}}}

/* k10514 in chicken.base#alist-ref in k8834 */
static void C_fcall f_10516(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_10516,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10519,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:950: aq */
t3=t1;{
C_word av2[4];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k10517 in k10514 in chicken.base#alist-ref in k8834 */
static void C_ccall f_10519(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10519,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?C_slot(t1,C_fix(1)):((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_10541 in chicken.base#alist-ref in k8834 */
static void C_ccall f_10541(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_10541,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10547,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li194),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_10547(t7,t1,t3);}

/* loop */
static void C_fcall f_10547(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,4)))){
C_save_and_reclaim_args((void *)trf_10547,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=C_i_check_pair_2(t3,lf[270]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10572,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:946: cmp */
t6=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(0));
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}
else{
/* library.scm:949: chicken.base#error */
t3=*((C_word*)lf[193]+1);{
C_word av2[5];
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[270];
av2[3]=lf[271];
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}}}

/* k10570 in loop */
static void C_ccall f_10572(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_10572,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:948: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_10547(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.base#rassoc in k8834 */
static void C_ccall f_10612(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +8,c,3)))){
C_save_and_reclaim((void*)f_10612,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+8);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t5=C_i_check_list_2(t3,lf[273]);
t6=C_i_pairp(t4);
t7=(C_truep(t6)?C_get_rest_arg(c,4,av,4,t0):*((C_word*)lf[5]+1));
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10624,a[2]=t9,a[3]=t7,a[4]=t2,a[5]=((C_word)li197),tmp=(C_word)a,a+=6,tmp));
t11=((C_word*)t9)[1];
f_10624(t11,t1,t3);}

/* loop in chicken.base#rassoc in k8834 */
static void C_fcall f_10624(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_10624,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=C_i_check_pair_2(t3,lf[273]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10643,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:963: tst */
t6=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(1));
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k10641 in loop in chicken.base#rassoc in k8834 */
static void C_ccall f_10643(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_10643,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:965: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_10624(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.fixnum#fx+ in k8834 */
static void C_ccall f_10665(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10665,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_plus(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx- in k8834 */
static void C_ccall f_10668(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10668,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_difference(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx* in k8834 */
static void C_ccall f_10671(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10671,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_times(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx= in k8834 */
static void C_ccall f_10674(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10674,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_eqp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx> in k8834 */
static void C_ccall f_10680(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10680,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_greaterp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx< in k8834 */
static void C_ccall f_10683(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10683,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_lessp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx>= in k8834 */
static void C_ccall f_10686(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10686,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_greater_or_equal_p(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx<= in k8834 */
static void C_ccall f_10689(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10689,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_less_or_equal_p(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmin in k8834 */
static void C_ccall f_10692(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10692,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_min(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmax in k8834 */
static void C_ccall f_10695(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10695,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_max(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxneg in k8834 */
static void C_ccall f_10698(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10698,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fixnum_negate(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxand in k8834 */
static void C_ccall f_10701(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10701,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_and(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxior in k8834 */
static void C_ccall f_10704(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10704,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_or(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxxor in k8834 */
static void C_ccall f_10707(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10707,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_xor(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxnot in k8834 */
static void C_ccall f_10710(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10710,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fixnum_not(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxshl in k8834 */
static void C_ccall f_10713(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10713,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_shift_left(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxshr in k8834 */
static void C_ccall f_10716(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10716,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_shift_right(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxodd? in k8834 */
static void C_ccall f_10719(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10719,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnumoddp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxeven? in k8834 */
static void C_ccall f_10722(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10722,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnumevenp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxlen in k8834 */
static void C_ccall f_10725(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10725,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnum_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fx/ in k8834 */
static void C_ccall f_10728(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10728,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_divide(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxgcd in k8834 */
static void C_ccall f_10731(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10731,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_gcd(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmod in k8834 */
static void C_ccall f_10734(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10734,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_modulo(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxrem in k8834 */
static void C_ccall f_10737(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10737,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_remainder_checked(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx+? in k8834 */
static void C_ccall f_10740(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10740,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_plus(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx-? in k8834 */
static void C_ccall f_10743(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10743,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_difference(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx*? in k8834 */
static void C_ccall f_10746(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10746,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_times(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx/? in k8834 */
static void C_ccall f_10749(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10749,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_quotient(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k10751 in k8834 */
static void C_ccall f_10753(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word t181;
C_word t182;
C_word t183;
C_word t184;
C_word t185;
C_word t186;
C_word t187;
C_word t188;
C_word t189;
C_word t190;
C_word t191;
C_word t192;
C_word t193;
C_word t194;
C_word t195;
C_word t196;
C_word t197;
C_word t198;
C_word t199;
C_word t200;
C_word t201;
C_word t202;
C_word t203;
C_word t204;
C_word t205;
C_word t206;
C_word t207;
C_word t208;
C_word t209;
C_word t210;
C_word t211;
C_word t212;
C_word t213;
C_word t214;
C_word t215;
C_word t216;
C_word t217;
C_word t218;
C_word t219;
C_word t220;
C_word t221;
C_word t222;
C_word t223;
C_word t224;
C_word t225;
C_word t226;
C_word t227;
C_word t228;
C_word t229;
C_word t230;
C_word t231;
C_word t232;
C_word t233;
C_word t234;
C_word t235;
C_word t236;
C_word t237;
C_word t238;
C_word t239;
C_word t240;
C_word t241;
C_word t242;
C_word t243;
C_word t244;
C_word t245;
C_word t246;
C_word t247;
C_word t248;
C_word t249;
C_word t250;
C_word t251;
C_word t252;
C_word t253;
C_word t254;
C_word t255;
C_word t256;
C_word t257;
C_word t258;
C_word t259;
C_word t260;
C_word t261;
C_word t262;
C_word t263;
C_word t264;
C_word t265;
C_word t266;
C_word t267;
C_word t268;
C_word t269;
C_word t270;
C_word t271;
C_word t272;
C_word t273;
C_word t274;
C_word t275;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(752,c,6)))){
C_save_and_reclaim((void *)f_10753,c,av);}
a=C_alloc(752);
t2=C_mutate((C_word*)lf[308]+1 /* (set! ##sys#debug-mode? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10755,a[2]=((C_word)li227),tmp=(C_word)a,a+=3,tmp));
t3=C_set_block_item(lf[309] /* ##sys#warnings-enabled */,0,C_SCHEME_TRUE);
t4=C_set_block_item(lf[310] /* ##sys#notices-enabled */,0,C_i_debug_modep());
t5=C_mutate((C_word*)lf[311]+1 /* (set! chicken.base#warning ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10760,a[2]=((C_word)li228),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[313]+1 /* (set! chicken.base#notice ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10769,a[2]=((C_word)li229),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[315]+1 /* (set! chicken.base#enable-warnings ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10781,a[2]=((C_word)li230),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[155]+1 /* (set! ##sys#error ...) */,*((C_word*)lf[193]+1));
t9=C_mutate((C_word*)lf[316]+1 /* (set! ##sys#warn ...) */,*((C_word*)lf[311]+1));
t10=C_mutate((C_word*)lf[317]+1 /* (set! ##sys#notice ...) */,*((C_word*)lf[313]+1));
t11=C_mutate((C_word*)lf[318]+1 /* (set! ##sys#error/errno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10795,a[2]=((C_word)li231),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[320]+1 /* (set! ##sys#gc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_gc,a[2]=((C_word)li232),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[321]+1 /* (set! ##sys#setslot ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10811,a[2]=((C_word)li233),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[322]+1 /* (set! ##sys#setislot ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10814,a[2]=((C_word)li234),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[323]+1 /* (set! ##sys#allocate-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_allocate_vector,a[2]=((C_word)li235),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate((C_word*)lf[324]+1 /* (set! ##sys#make-structure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_make_structure,a[2]=((C_word)li236),tmp=(C_word)a,a+=3,tmp));
t17=C_mutate((C_word*)lf[325]+1 /* (set! ##sys#ensure-heap-reserve ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_ensure_heap_reserve,a[2]=((C_word)li237),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate((C_word*)lf[326]+1 /* (set! ##sys#symbol-table-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_get_symbol_table_info,a[2]=((C_word)li238),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[327]+1 /* (set! ##sys#memory-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_get_memory_info,a[2]=((C_word)li239),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[328]+1 /* (set! ##sys#start-timer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10822,a[2]=((C_word)li240),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[329]+1 /* (set! ##sys#stop-timer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10828,a[2]=((C_word)li243),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate((C_word*)lf[330]+1 /* (set! ##sys#immediate? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10848,a[2]=((C_word)li244),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[331]+1 /* (set! ##sys#message ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10855,a[2]=((C_word)li245),tmp=(C_word)a,a+=3,tmp));
t24=C_mutate((C_word*)lf[332]+1 /* (set! ##sys#byte ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10858,a[2]=((C_word)li246),tmp=(C_word)a,a+=3,tmp));
t25=C_mutate((C_word*)lf[333]+1 /* (set! ##sys#setbyte ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10861,a[2]=((C_word)li247),tmp=(C_word)a,a+=3,tmp));
t26=C_mutate((C_word*)lf[334]+1 /* (set! ##sys#void ...) */,*((C_word*)lf[196]+1));
t27=C_set_block_item(lf[246] /* ##sys#undefined-value */,0,C_SCHEME_UNDEFINED);
t28=C_mutate((C_word*)lf[335]+1 /* (set! ##sys#halt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10866,a[2]=((C_word)li248),tmp=(C_word)a,a+=3,tmp));
t29=C_mutate((C_word*)lf[336]+1 /* (set! ##sys#become! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_become,a[2]=((C_word)li249),tmp=(C_word)a,a+=3,tmp));
t30=C_mutate((C_word*)lf[337]+1 /* (set! ##sys#block-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10870,a[2]=((C_word)li250),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[338]+1 /* (set! ##sys#apply-values ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_apply_values,a[2]=((C_word)li251),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate((C_word*)lf[339]+1 /* (set! ##sys#copy-closure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_copy_closure,a[2]=((C_word)li252),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[340]+1 /* (set! ##sys#block-set! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10875,a[2]=((C_word)li253),tmp=(C_word)a,a+=3,tmp));
t34=C_a_i_provide(&a,1,lf[343]);
t35=C_mutate((C_word*)lf[344]+1 /* (set! chicken.time#current-milliseconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10910,a[2]=((C_word)li254),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[345]+1 /* (set! chicken.time#current-process-milliseconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10913,a[2]=((C_word)li255),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[346]+1 /* (set! chicken.time#current-seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10916,a[2]=((C_word)li256),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[347]+1 /* (set! chicken.time#cpu-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10919,a[2]=((C_word)li257),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[348]+1 /* (set! ##sys#check-structure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10936,a[2]=((C_word)li258),tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[349]+1 /* (set! ##sys#check-blob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10947,a[2]=((C_word)li259),tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[350]+1 /* (set! ##sys#check-byte-vector ...) */,*((C_word*)lf[349]+1));
t42=C_mutate((C_word*)lf[351]+1 /* (set! ##sys#check-pair ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10959,a[2]=((C_word)li260),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[352]+1 /* (set! ##sys#check-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10970,a[2]=((C_word)li261),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[353]+1 /* (set! ##sys#check-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10981,a[2]=((C_word)li262),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[354]+1 /* (set! ##sys#check-number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10992,a[2]=((C_word)li263),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[102]+1 /* (set! ##sys#check-fixnum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11003,a[2]=((C_word)li264),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[355]+1 /* (set! ##sys#check-exact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11014,a[2]=((C_word)li265),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[356]+1 /* (set! ##sys#check-inexact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11025,a[2]=((C_word)li266),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[357]+1 /* (set! ##sys#check-symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11036,a[2]=((C_word)li267),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[358]+1 /* (set! ##sys#check-keyword ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11047,a[2]=((C_word)li268),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[359]+1 /* (set! ##sys#check-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11058,a[2]=((C_word)li269),tmp=(C_word)a,a+=3,tmp));
t52=C_mutate((C_word*)lf[360]+1 /* (set! ##sys#check-char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11069,a[2]=((C_word)li270),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate((C_word*)lf[361]+1 /* (set! ##sys#check-boolean ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11080,a[2]=((C_word)li271),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[362]+1 /* (set! ##sys#check-locative ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11091,a[2]=((C_word)li272),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[363]+1 /* (set! ##sys#check-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11102,a[2]=((C_word)li273),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[365]+1 /* (set! ##sys#check-exact-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11119,a[2]=((C_word)li274),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[367]+1 /* (set! ##sys#check-exact-uinteger ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11136,a[2]=((C_word)li275),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[369]+1 /* (set! ##sys#check-real ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11160,a[2]=((C_word)li276),tmp=(C_word)a,a+=3,tmp));
t59=C_mutate((C_word*)lf[341]+1 /* (set! ##sys#check-range ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11177,a[2]=((C_word)li277),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[372]+1 /* (set! ##sys#check-special ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11207,a[2]=((C_word)li278),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[374]+1 /* (set! ##sys#check-closure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11227,a[2]=((C_word)li279),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[375]+1 /* (set! scheme#force ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11238,a[2]=((C_word)li281),tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[377]+1 /* (set! ##sys#dload ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_dload,a[2]=((C_word)li282),tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[378]+1 /* (set! ##sys#set-dlopen-flags! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_set_dlopen_flags,a[2]=((C_word)li283),tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[47]+1 /* (set! ##sys#error-not-a-proper-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11366,a[2]=((C_word)li284),tmp=(C_word)a,a+=3,tmp));
t66=C_mutate((C_word*)lf[379]+1 /* (set! ##sys#error-bad-number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11382,a[2]=((C_word)li285),tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[364]+1 /* (set! ##sys#error-bad-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11398,a[2]=((C_word)li286),tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[366]+1 /* (set! ##sys#error-bad-exact-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11414,a[2]=((C_word)li287),tmp=(C_word)a,a+=3,tmp));
t69=C_mutate((C_word*)lf[368]+1 /* (set! ##sys#error-bad-exact-uinteger ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11430,a[2]=((C_word)li288),tmp=(C_word)a,a+=3,tmp));
t70=C_mutate((C_word*)lf[380]+1 /* (set! ##sys#error-bad-inexact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11446,a[2]=((C_word)li289),tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[370]+1 /* (set! ##sys#error-bad-real ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11462,a[2]=((C_word)li290),tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[381]+1 /* (set! ##sys#error-bad-base ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11478,a[2]=((C_word)li291),tmp=(C_word)a,a+=3,tmp));
t73=C_mutate((C_word*)lf[382]+1 /* (set! scheme#append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11494,a[2]=((C_word)li294),tmp=(C_word)a,a+=3,tmp));
t74=C_mutate((C_word*)lf[384]+1 /* (set! ##sys#fast-reverse ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11573,a[2]=((C_word)li296),tmp=(C_word)a,a+=3,tmp));
t75=C_mutate((C_word*)lf[385]+1 /* (set! ##sys#make-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11603,a[2]=((C_word)li297),tmp=(C_word)a,a+=3,tmp));
t76=C_mutate((C_word*)lf[386]+1 /* (set! scheme#make-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11623,a[2]=((C_word)li298),tmp=(C_word)a,a+=3,tmp));
t77=C_mutate((C_word*)lf[390]+1 /* (set! scheme#string->list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11659,a[2]=((C_word)li300),tmp=(C_word)a,a+=3,tmp));
t78=C_mutate((C_word*)lf[392]+1 /* (set! ##sys#string->list ...) */,*((C_word*)lf[390]+1));
t79=C_mutate((C_word*)lf[393]+1 /* (set! scheme#list->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11697,a[2]=((C_word)li302),tmp=(C_word)a,a+=3,tmp));
t80=C_mutate((C_word*)lf[395]+1 /* (set! ##sys#list->string ...) */,*((C_word*)lf[393]+1));
t81=C_mutate((C_word*)lf[396]+1 /* (set! ##sys#reverse-list->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11749,a[2]=((C_word)li304),tmp=(C_word)a,a+=3,tmp));
t82=C_mutate((C_word*)lf[398]+1 /* (set! scheme#string-fill! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11798,a[2]=((C_word)li305),tmp=(C_word)a,a+=3,tmp));
t83=C_mutate((C_word*)lf[400]+1 /* (set! scheme#string-copy ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11811,a[2]=((C_word)li306),tmp=(C_word)a,a+=3,tmp));
t84=C_mutate((C_word*)lf[402]+1 /* (set! scheme#substring ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11823,a[2]=((C_word)li307),tmp=(C_word)a,a+=3,tmp));
t85=C_mutate((C_word*)lf[404]+1 /* (set! ##sys#substring ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11873,a[2]=((C_word)li308),tmp=(C_word)a,a+=3,tmp));
t86=C_SCHEME_UNDEFINED;
t87=(*a=C_VECTOR_TYPE|1,a[1]=t86,tmp=(C_word)a,a+=2,tmp);
t88=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11882,a[2]=((C_word)li309),tmp=(C_word)a,a+=3,tmp);
t89=C_set_block_item(t87,0,t88);
t90=C_mutate((C_word*)lf[405]+1 /* (set! scheme#string<? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11903,a[2]=t87,a[3]=((C_word)li311),tmp=(C_word)a,a+=4,tmp));
t91=C_mutate((C_word*)lf[407]+1 /* (set! scheme#string>? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11927,a[2]=t87,a[3]=((C_word)li313),tmp=(C_word)a,a+=4,tmp));
t92=C_mutate((C_word*)lf[409]+1 /* (set! scheme#string<=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11951,a[2]=t87,a[3]=((C_word)li315),tmp=(C_word)a,a+=4,tmp));
t93=C_mutate((C_word*)lf[411]+1 /* (set! scheme#string>=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11972,a[2]=t87,a[3]=((C_word)li317),tmp=(C_word)a,a+=4,tmp));
t94=C_SCHEME_UNDEFINED;
t95=(*a=C_VECTOR_TYPE|1,a[1]=t94,tmp=(C_word)a,a+=2,tmp);
t96=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11992,a[2]=((C_word)li318),tmp=(C_word)a,a+=3,tmp);
t97=C_set_block_item(t95,0,t96);
t98=C_mutate((C_word*)lf[413]+1 /* (set! scheme#string-ci<? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12013,a[2]=t95,a[3]=((C_word)li320),tmp=(C_word)a,a+=4,tmp));
t99=C_mutate((C_word*)lf[415]+1 /* (set! scheme#string-ci>? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12037,a[2]=t95,a[3]=((C_word)li322),tmp=(C_word)a,a+=4,tmp));
t100=C_mutate((C_word*)lf[417]+1 /* (set! scheme#string-ci<=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12061,a[2]=t95,a[3]=((C_word)li324),tmp=(C_word)a,a+=4,tmp));
t101=C_mutate((C_word*)lf[419]+1 /* (set! scheme#string-ci>=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12082,a[2]=t95,a[3]=((C_word)li326),tmp=(C_word)a,a+=4,tmp));
t102=C_mutate((C_word*)lf[421]+1 /* (set! ##sys#string-append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12103,a[2]=((C_word)li327),tmp=(C_word)a,a+=3,tmp));
t103=C_mutate((C_word*)lf[422]+1 /* (set! scheme#string-append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12119,a[2]=((C_word)li329),tmp=(C_word)a,a+=3,tmp));
t104=C_mutate((C_word*)lf[424]+1 /* (set! scheme#string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12158,a[2]=((C_word)li330),tmp=(C_word)a,a+=3,tmp));
t105=C_mutate((C_word*)lf[425]+1 /* (set! ##sys#fragments->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12164,a[2]=((C_word)li332),tmp=(C_word)a,a+=3,tmp));
t106=C_mutate((C_word*)lf[426]+1 /* (set! chicken.base#chop ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12199,a[2]=((C_word)li335),tmp=(C_word)a,a+=3,tmp));
t107=C_a_i_provide(&a,1,lf[429]);
t108=C_mutate((C_word*)lf[430]+1 /* (set! chicken.flonum#maximum-flonum ...) */,C_flonum(&a,DBL_MAX));
t109=C_mutate((C_word*)lf[431]+1 /* (set! chicken.flonum#minimum-flonum ...) */,C_flonum(&a,DBL_MIN));
t110=C_set_block_item(lf[432] /* chicken.flonum#flonum-radix */,0,C_fix((C_word)FLT_RADIX));
t111=C_mutate((C_word*)lf[433]+1 /* (set! chicken.flonum#flonum-epsilon ...) */,C_flonum(&a,DBL_EPSILON));
t112=C_set_block_item(lf[434] /* chicken.flonum#flonum-precision */,0,C_fix((C_word)DBL_MANT_DIG));
t113=C_set_block_item(lf[435] /* chicken.flonum#flonum-decimal-precision */,0,C_fix((C_word)DBL_DIG));
t114=C_set_block_item(lf[436] /* chicken.flonum#flonum-maximum-exponent */,0,C_fix((C_word)DBL_MAX_EXP));
t115=C_set_block_item(lf[437] /* chicken.flonum#flonum-minimum-exponent */,0,C_fix((C_word)DBL_MIN_EXP));
t116=C_set_block_item(lf[438] /* chicken.flonum#flonum-maximum-decimal-exponent */,0,C_fix((C_word)DBL_MAX_10_EXP));
t117=C_set_block_item(lf[439] /* chicken.flonum#flonum-minimum-decimal-exponent */,0,C_fix((C_word)DBL_MIN_10_EXP));
t118=C_mutate((C_word*)lf[440]+1 /* (set! chicken.flonum#fp+ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12294,a[2]=((C_word)li336),tmp=(C_word)a,a+=3,tmp));
t119=C_mutate((C_word*)lf[442]+1 /* (set! chicken.flonum#fp- ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12318,a[2]=((C_word)li337),tmp=(C_word)a,a+=3,tmp));
t120=C_mutate((C_word*)lf[444]+1 /* (set! chicken.flonum#fp* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12342,a[2]=((C_word)li338),tmp=(C_word)a,a+=3,tmp));
t121=C_mutate((C_word*)lf[446]+1 /* (set! chicken.flonum#fp/ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12366,a[2]=((C_word)li339),tmp=(C_word)a,a+=3,tmp));
t122=C_mutate((C_word*)lf[448]+1 /* (set! chicken.flonum#fp*+ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12390,a[2]=((C_word)li340),tmp=(C_word)a,a+=3,tmp));
t123=C_mutate((C_word*)lf[450]+1 /* (set! chicken.flonum#fpgcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12415,a[2]=((C_word)li341),tmp=(C_word)a,a+=3,tmp));
t124=C_mutate((C_word*)lf[452]+1 /* (set! chicken.flonum#fp/? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12439,a[2]=((C_word)li342),tmp=(C_word)a,a+=3,tmp));
t125=C_mutate((C_word*)lf[454]+1 /* (set! chicken.flonum#fp= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12463,a[2]=((C_word)li343),tmp=(C_word)a,a+=3,tmp));
t126=C_mutate((C_word*)lf[456]+1 /* (set! chicken.flonum#fp> ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12487,a[2]=((C_word)li344),tmp=(C_word)a,a+=3,tmp));
t127=C_mutate((C_word*)lf[458]+1 /* (set! chicken.flonum#fp< ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12511,a[2]=((C_word)li345),tmp=(C_word)a,a+=3,tmp));
t128=C_mutate((C_word*)lf[460]+1 /* (set! chicken.flonum#fp>= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12535,a[2]=((C_word)li346),tmp=(C_word)a,a+=3,tmp));
t129=C_mutate((C_word*)lf[462]+1 /* (set! chicken.flonum#fp<= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12559,a[2]=((C_word)li347),tmp=(C_word)a,a+=3,tmp));
t130=C_mutate((C_word*)lf[464]+1 /* (set! chicken.flonum#fpneg ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12583,a[2]=((C_word)li348),tmp=(C_word)a,a+=3,tmp));
t131=C_mutate((C_word*)lf[466]+1 /* (set! chicken.flonum#fpmax ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12601,a[2]=((C_word)li349),tmp=(C_word)a,a+=3,tmp));
t132=C_mutate((C_word*)lf[468]+1 /* (set! chicken.flonum#fpmin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12625,a[2]=((C_word)li350),tmp=(C_word)a,a+=3,tmp));
t133=C_mutate((C_word*)lf[470]+1 /* (set! chicken.flonum#fpfloor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12649,a[2]=((C_word)li351),tmp=(C_word)a,a+=3,tmp));
t134=C_mutate((C_word*)lf[472]+1 /* (set! chicken.flonum#fptruncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12667,a[2]=((C_word)li352),tmp=(C_word)a,a+=3,tmp));
t135=C_mutate((C_word*)lf[474]+1 /* (set! chicken.flonum#fpround ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12685,a[2]=((C_word)li353),tmp=(C_word)a,a+=3,tmp));
t136=C_mutate((C_word*)lf[476]+1 /* (set! chicken.flonum#fpceiling ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12703,a[2]=((C_word)li354),tmp=(C_word)a,a+=3,tmp));
t137=C_mutate((C_word*)lf[478]+1 /* (set! chicken.flonum#fpsin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12721,a[2]=((C_word)li355),tmp=(C_word)a,a+=3,tmp));
t138=C_mutate((C_word*)lf[480]+1 /* (set! chicken.flonum#fpcos ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12739,a[2]=((C_word)li356),tmp=(C_word)a,a+=3,tmp));
t139=C_mutate((C_word*)lf[482]+1 /* (set! chicken.flonum#fptan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12757,a[2]=((C_word)li357),tmp=(C_word)a,a+=3,tmp));
t140=C_mutate((C_word*)lf[484]+1 /* (set! chicken.flonum#fpasin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12775,a[2]=((C_word)li358),tmp=(C_word)a,a+=3,tmp));
t141=C_mutate((C_word*)lf[486]+1 /* (set! chicken.flonum#fpacos ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12793,a[2]=((C_word)li359),tmp=(C_word)a,a+=3,tmp));
t142=C_mutate((C_word*)lf[488]+1 /* (set! chicken.flonum#fpatan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12811,a[2]=((C_word)li360),tmp=(C_word)a,a+=3,tmp));
t143=C_mutate((C_word*)lf[490]+1 /* (set! chicken.flonum#fpatan2 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12829,a[2]=((C_word)li361),tmp=(C_word)a,a+=3,tmp));
t144=C_mutate((C_word*)lf[492]+1 /* (set! chicken.flonum#fpsinh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12853,a[2]=((C_word)li362),tmp=(C_word)a,a+=3,tmp));
t145=C_mutate((C_word*)lf[494]+1 /* (set! chicken.flonum#fpcosh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12871,a[2]=((C_word)li363),tmp=(C_word)a,a+=3,tmp));
t146=C_mutate((C_word*)lf[496]+1 /* (set! chicken.flonum#fptanh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12889,a[2]=((C_word)li364),tmp=(C_word)a,a+=3,tmp));
t147=C_mutate((C_word*)lf[498]+1 /* (set! chicken.flonum#fpasinh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12907,a[2]=((C_word)li365),tmp=(C_word)a,a+=3,tmp));
t148=C_mutate((C_word*)lf[500]+1 /* (set! chicken.flonum#fpacosh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12925,a[2]=((C_word)li366),tmp=(C_word)a,a+=3,tmp));
t149=C_mutate((C_word*)lf[502]+1 /* (set! chicken.flonum#fpatanh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12943,a[2]=((C_word)li367),tmp=(C_word)a,a+=3,tmp));
t150=C_mutate((C_word*)lf[504]+1 /* (set! chicken.flonum#fpexp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12961,a[2]=((C_word)li368),tmp=(C_word)a,a+=3,tmp));
t151=C_mutate((C_word*)lf[506]+1 /* (set! chicken.flonum#fpexpt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12979,a[2]=((C_word)li369),tmp=(C_word)a,a+=3,tmp));
t152=C_mutate((C_word*)lf[508]+1 /* (set! chicken.flonum#fplog ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13003,a[2]=((C_word)li370),tmp=(C_word)a,a+=3,tmp));
t153=C_mutate((C_word*)lf[510]+1 /* (set! chicken.flonum#fpsqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13021,a[2]=((C_word)li371),tmp=(C_word)a,a+=3,tmp));
t154=C_mutate((C_word*)lf[512]+1 /* (set! chicken.flonum#fpabs ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13039,a[2]=((C_word)li372),tmp=(C_word)a,a+=3,tmp));
t155=C_mutate((C_word*)lf[514]+1 /* (set! chicken.flonum#fpinteger? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13057,a[2]=((C_word)li373),tmp=(C_word)a,a+=3,tmp));
t156=C_mutate((C_word*)lf[516]+1 /* (set! chicken.flonum#flonum-print-precision ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13075,a[2]=((C_word)li374),tmp=(C_word)a,a+=3,tmp));
t157=C_mutate((C_word*)lf[518]+1 /* (set! ##sys#number? ...) */,*((C_word*)lf[77]+1));
t158=C_mutate((C_word*)lf[519]+1 /* (set! ##sys#integer? ...) */,*((C_word*)lf[81]+1));
t159=C_mutate((C_word*)lf[520]+1 /* (set! ##sys#exact? ...) */,*((C_word*)lf[82]+1));
t160=C_mutate((C_word*)lf[521]+1 /* (set! ##sys#inexact? ...) */,*((C_word*)lf[83]+1));
t161=C_mutate(&lf[522] /* (set! make-complex ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13097,a[2]=((C_word)li375),tmp=(C_word)a,a+=3,tmp));
t162=C_mutate((C_word*)lf[524]+1 /* (set! scheme#make-rectangular ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13133,a[2]=((C_word)li376),tmp=(C_word)a,a+=3,tmp));
t163=C_mutate((C_word*)lf[526]+1 /* (set! scheme#make-polar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13145,a[2]=((C_word)li377),tmp=(C_word)a,a+=3,tmp));
t164=C_mutate((C_word*)lf[528]+1 /* (set! scheme#real-part ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13168,a[2]=((C_word)li378),tmp=(C_word)a,a+=3,tmp));
t165=C_mutate((C_word*)lf[530]+1 /* (set! scheme#imag-part ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13191,a[2]=((C_word)li379),tmp=(C_word)a,a+=3,tmp));
t166=C_mutate((C_word*)lf[532]+1 /* (set! scheme#angle ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13217,a[2]=((C_word)li380),tmp=(C_word)a,a+=3,tmp));
t167=C_mutate((C_word*)lf[534]+1 /* (set! scheme#magnitude ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13233,a[2]=((C_word)li381),tmp=(C_word)a,a+=3,tmp));
t168=C_mutate(&lf[537] /* (set! ratnum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13277,a[2]=((C_word)li382),tmp=(C_word)a,a+=3,tmp));
t169=C_mutate((C_word*)lf[538]+1 /* (set! scheme#numerator ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13323,a[2]=((C_word)li383),tmp=(C_word)a,a+=3,tmp));
t170=C_mutate((C_word*)lf[542]+1 /* (set! scheme#denominator ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13369,a[2]=((C_word)li384),tmp=(C_word)a,a+=3,tmp));
t171=C_mutate((C_word*)lf[546]+1 /* (set! ##sys#extended-signum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13415,a[2]=((C_word)li385),tmp=(C_word)a,a+=3,tmp));
t172=C_mutate((C_word*)lf[540]+1 /* (set! scheme#inexact->exact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13539,a[2]=((C_word)li388),tmp=(C_word)a,a+=3,tmp));
t173=C_mutate((C_word*)lf[553]+1 /* (set! ##sys#exact->inexact ...) */,*((C_word*)lf[62]+1));
t174=C_mutate((C_word*)lf[554]+1 /* (set! ##sys#inexact->exact ...) */,*((C_word*)lf[540]+1));
t175=C_a_i_provide(&a,1,lf[555]);
t176=C_mutate((C_word*)lf[556]+1 /* (set! chicken.bitwise#bitwise-and ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_bitwise_and,a[2]=((C_word)li389),tmp=(C_word)a,a+=3,tmp));
t177=C_mutate((C_word*)lf[557]+1 /* (set! chicken.bitwise#bitwise-ior ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_bitwise_ior,a[2]=((C_word)li390),tmp=(C_word)a,a+=3,tmp));
t178=C_mutate((C_word*)lf[558]+1 /* (set! chicken.bitwise#bitwise-xor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_bitwise_xor,a[2]=((C_word)li391),tmp=(C_word)a,a+=3,tmp));
t179=C_mutate((C_word*)lf[559]+1 /* (set! chicken.bitwise#bitwise-not ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13605,a[2]=((C_word)li392),tmp=(C_word)a,a+=3,tmp));
t180=C_mutate((C_word*)lf[560]+1 /* (set! chicken.bitwise#bit->boolean ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13608,a[2]=((C_word)li393),tmp=(C_word)a,a+=3,tmp));
t181=C_mutate((C_word*)lf[561]+1 /* (set! chicken.bitwise#integer-length ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13611,a[2]=((C_word)li394),tmp=(C_word)a,a+=3,tmp));
t182=C_mutate((C_word*)lf[562]+1 /* (set! chicken.bitwise#arithmetic-shift ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13614,a[2]=((C_word)li395),tmp=(C_word)a,a+=3,tmp));
t183=C_mutate((C_word*)lf[563]+1 /* (set! scheme#/ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13617,a[2]=((C_word)li397),tmp=(C_word)a,a+=3,tmp));
t184=C_mutate((C_word*)lf[548]+1 /* (set! ##sys#/-2 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13668,a[2]=((C_word)li398),tmp=(C_word)a,a+=3,tmp));
t185=C_mutate((C_word*)lf[566]+1 /* (set! scheme#floor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13951,a[2]=((C_word)li399),tmp=(C_word)a,a+=3,tmp));
t186=C_mutate((C_word*)lf[568]+1 /* (set! scheme#ceiling ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13996,a[2]=((C_word)li400),tmp=(C_word)a,a+=3,tmp));
t187=C_mutate((C_word*)lf[570]+1 /* (set! scheme#truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14041,a[2]=((C_word)li401),tmp=(C_word)a,a+=3,tmp));
t188=C_mutate((C_word*)lf[572]+1 /* (set! scheme#round ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14078,a[2]=((C_word)li402),tmp=(C_word)a,a+=3,tmp));
t189=C_mutate(&lf[574] /* (set! find-ratio-between ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14122,a[2]=((C_word)li404),tmp=(C_word)a,a+=3,tmp));
t190=C_mutate((C_word*)lf[576]+1 /* (set! scheme#rationalize ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14272,a[2]=((C_word)li405),tmp=(C_word)a,a+=3,tmp));
t191=C_mutate((C_word*)lf[577]+1 /* (set! scheme#max ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14297,a[2]=((C_word)li407),tmp=(C_word)a,a+=3,tmp));
t192=C_mutate((C_word*)lf[579]+1 /* (set! scheme#min ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14341,a[2]=((C_word)li409),tmp=(C_word)a,a+=3,tmp));
t193=C_mutate((C_word*)lf[581]+1 /* (set! scheme#exp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14385,a[2]=((C_word)li410),tmp=(C_word)a,a+=3,tmp));
t194=C_mutate((C_word*)lf[583]+1 /* (set! ##sys#log-1 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14430,a[2]=((C_word)li411),tmp=(C_word)a,a+=3,tmp));
t195=C_mutate((C_word*)lf[587]+1 /* (set! scheme#log ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14479,a[2]=((C_word)li412),tmp=(C_word)a,a+=3,tmp));
t196=C_mutate((C_word*)lf[588]+1 /* (set! scheme#sin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14508,a[2]=((C_word)li413),tmp=(C_word)a,a+=3,tmp));
t197=C_mutate((C_word*)lf[592]+1 /* (set! scheme#cos ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14542,a[2]=((C_word)li414),tmp=(C_word)a,a+=3,tmp));
t198=C_mutate((C_word*)lf[594]+1 /* (set! scheme#tan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14576,a[2]=((C_word)li415),tmp=(C_word)a,a+=3,tmp));
t199=C_mutate((C_word*)lf[596]+1 /* (set! scheme#asin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14601,a[2]=((C_word)li416),tmp=(C_word)a,a+=3,tmp));
t200=C_a_i_asin(&a,1,C_fix(1));
t201=C_mutate((C_word*)lf[601]+1 /* (set! scheme#acos ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14663,a[2]=t200,a[3]=((C_word)li417),tmp=(C_word)a,a+=4,tmp));
t202=C_mutate((C_word*)lf[603]+1 /* (set! scheme#atan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14705,a[2]=((C_word)li418),tmp=(C_word)a,a+=3,tmp));
t203=C_mutate((C_word*)lf[605]+1 /* (set! ##sys#exact-integer-sqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14769,a[2]=((C_word)li424),tmp=(C_word)a,a+=3,tmp));
t204=C_mutate((C_word*)lf[607]+1 /* (set! chicken.base#exact-integer-sqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14960,a[2]=((C_word)li425),tmp=(C_word)a,a+=3,tmp));
t205=C_mutate((C_word*)lf[599]+1 /* (set! ##sys#sqrt/loc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14969,a[2]=((C_word)li432),tmp=(C_word)a,a+=3,tmp));
t206=C_mutate((C_word*)lf[535]+1 /* (set! scheme#sqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15124,a[2]=((C_word)li433),tmp=(C_word)a,a+=3,tmp));
t207=C_mutate((C_word*)lf[610]+1 /* (set! chicken.base#exact-integer-nth-root ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15130,a[2]=((C_word)li434),tmp=(C_word)a,a+=3,tmp));
t208=C_mutate((C_word*)lf[611]+1 /* (set! ##sys#exact-integer-nth-root/loc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15142,a[2]=((C_word)li436),tmp=(C_word)a,a+=3,tmp));
t209=C_mutate((C_word*)lf[550]+1 /* (set! ##sys#integer-power ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15268,a[2]=((C_word)li438),tmp=(C_word)a,a+=3,tmp));
t210=C_mutate((C_word*)lf[552]+1 /* (set! scheme#expt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15336,a[2]=((C_word)li443),tmp=(C_word)a,a+=3,tmp));
t211=C_mutate(&lf[564] /* (set! ##sys#internal-gcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15603,a[2]=((C_word)li444),tmp=(C_word)a,a+=3,tmp));
t212=C_mutate((C_word*)lf[615]+1 /* (set! ##sys#gcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15673,a[2]=((C_word)li445),tmp=(C_word)a,a+=3,tmp));
t213=C_mutate((C_word*)lf[617]+1 /* (set! scheme#gcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15679,a[2]=((C_word)li447),tmp=(C_word)a,a+=3,tmp));
t214=C_mutate((C_word*)lf[618]+1 /* (set! ##sys#lcm ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15730,a[2]=((C_word)li448),tmp=(C_word)a,a+=3,tmp));
t215=C_mutate((C_word*)lf[620]+1 /* (set! scheme#lcm ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15744,a[2]=((C_word)li450),tmp=(C_word)a,a+=3,tmp));
t216=C_mutate((C_word*)lf[621]+1 /* (set! ##sys#integer->string/recursive ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15802,a[2]=((C_word)li454),tmp=(C_word)a,a+=3,tmp));
t217=C_mutate((C_word*)lf[623]+1 /* (set! ##sys#extended-number->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15855,a[2]=((C_word)li455),tmp=(C_word)a,a+=3,tmp));
t218=C_mutate(&lf[629] /* (set! round-quotient ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16029,a[2]=((C_word)li456),tmp=(C_word)a,a+=3,tmp));
t219=C_mutate(&lf[630] /* (set! ##sys#string->compnum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16072,a[2]=((C_word)li468),tmp=(C_word)a,a+=3,tmp));
t220=C_mutate((C_word*)lf[639]+1 /* (set! scheme#string->number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17492,a[2]=((C_word)li470),tmp=(C_word)a,a+=3,tmp));
t221=C_mutate((C_word*)lf[641]+1 /* (set! ##sys#string->number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17747,a[2]=((C_word)li471),tmp=(C_word)a,a+=3,tmp));
t222=C_mutate((C_word*)lf[642]+1 /* (set! ##sys#fixnum->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_fixnum_to_string,a[2]=((C_word)li472),tmp=(C_word)a,a+=3,tmp));
t223=C_mutate((C_word*)lf[643]+1 /* (set! ##sys#flonum->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_flonum_to_string,a[2]=((C_word)li473),tmp=(C_word)a,a+=3,tmp));
t224=C_mutate((C_word*)lf[644]+1 /* (set! ##sys#integer->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_integer_to_string,a[2]=((C_word)li474),tmp=(C_word)a,a+=3,tmp));
t225=C_mutate((C_word*)lf[622]+1 /* (set! ##sys#number->string ...) */,*((C_word*)lf[87]+1));
t226=C_mutate((C_word*)lf[645]+1 /* (set! chicken.base#equal=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17793,a[2]=((C_word)li478),tmp=(C_word)a,a+=3,tmp));
t227=C_mutate((C_word*)lf[646]+1 /* (set! ##sys#snafu ...) */,lf[647]);
t228=C_mutate((C_word*)lf[648]+1 /* (set! ##sys#intern-symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_string_to_symbol,a[2]=((C_word)li479),tmp=(C_word)a,a+=3,tmp));
t229=C_mutate((C_word*)lf[649]+1 /* (set! ##sys#intern-keyword ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_string_to_keyword,a[2]=((C_word)li480),tmp=(C_word)a,a+=3,tmp));
t230=C_mutate((C_word*)lf[650]+1 /* (set! ##sys#interned-symbol? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17965,a[2]=((C_word)li481),tmp=(C_word)a,a+=3,tmp));
t231=C_mutate((C_word*)lf[651]+1 /* (set! ##sys#string->symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17968,a[2]=((C_word)li482),tmp=(C_word)a,a+=3,tmp));
t232=C_mutate((C_word*)lf[652]+1 /* (set! ##sys#symbol->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17977,a[2]=((C_word)li483),tmp=(C_word)a,a+=3,tmp));
t233=C_mutate((C_word*)lf[653]+1 /* (set! scheme#symbol->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17983,a[2]=((C_word)li484),tmp=(C_word)a,a+=3,tmp));
t234=*((C_word*)lf[400]+1);
t235=C_mutate((C_word*)lf[655]+1 /* (set! scheme#string->symbol ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17996,a[2]=t234,a[3]=((C_word)li485),tmp=(C_word)a,a+=4,tmp));
t236=*((C_word*)lf[400]+1);
t237=C_mutate((C_word*)lf[657]+1 /* (set! chicken.base#string->uninterned-symbol ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18009,a[2]=t236,a[3]=((C_word)li487),tmp=(C_word)a,a+=4,tmp));
t238=C_fix(-1);
t239=(*a=C_VECTOR_TYPE|1,a[1]=t238,tmp=(C_word)a,a+=2,tmp);
t240=C_mutate((C_word*)lf[659]+1 /* (set! chicken.base#gensym ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18022,a[2]=t239,a[3]=((C_word)li489),tmp=(C_word)a,a+=4,tmp));
t241=*((C_word*)lf[422]+1);
t242=C_mutate((C_word*)lf[663]+1 /* (set! chicken.base#symbol-append ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18076,a[2]=t241,a[3]=((C_word)li491),tmp=(C_word)a,a+=4,tmp));
t243=C_a_i_provide(&a,1,lf[665]);
t244=C_mutate((C_word*)lf[666]+1 /* (set! chicken.keyword#keyword? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18135,a[2]=((C_word)li492),tmp=(C_word)a,a+=3,tmp));
t245=C_mutate((C_word*)lf[667]+1 /* (set! chicken.keyword#string->keyword ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18138,a[2]=((C_word)li493),tmp=(C_word)a,a+=3,tmp));
t246=*((C_word*)lf[666]+1);
t247=C_mutate((C_word*)lf[669]+1 /* (set! chicken.keyword#keyword->string ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18147,a[2]=t246,a[3]=((C_word)li494),tmp=(C_word)a,a+=4,tmp));
t248=C_a_i_list1(&a,1,lf[672]);
t249=C_mutate((C_word*)lf[673]+1 /* (set! chicken.keyword#get-keyword ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18165,a[2]=t248,a[3]=((C_word)li495),tmp=(C_word)a,a+=4,tmp));
t250=C_mutate((C_word*)lf[675]+1 /* (set! ##sys#get-keyword ...) */,*((C_word*)lf[673]+1));
t251=C_a_i_provide(&a,1,lf[676]);
t252=C_mutate((C_word*)lf[677]+1 /* (set! ##sys#make-blob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18196,a[2]=((C_word)li496),tmp=(C_word)a,a+=3,tmp));
t253=C_mutate((C_word*)lf[678]+1 /* (set! chicken.blob#make-blob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18202,a[2]=((C_word)li497),tmp=(C_word)a,a+=3,tmp));
t254=C_mutate((C_word*)lf[680]+1 /* (set! chicken.blob#blob? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18211,a[2]=((C_word)li498),tmp=(C_word)a,a+=3,tmp));
t255=C_mutate((C_word*)lf[681]+1 /* (set! chicken.blob#blob-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18217,a[2]=((C_word)li499),tmp=(C_word)a,a+=3,tmp));
t256=C_mutate((C_word*)lf[683]+1 /* (set! chicken.blob#string->blob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18226,a[2]=((C_word)li500),tmp=(C_word)a,a+=3,tmp));
t257=C_mutate((C_word*)lf[685]+1 /* (set! chicken.blob#blob->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18238,a[2]=((C_word)li501),tmp=(C_word)a,a+=3,tmp));
t258=C_mutate((C_word*)lf[687]+1 /* (set! chicken.blob#blob=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18250,a[2]=((C_word)li502),tmp=(C_word)a,a+=3,tmp));
t259=C_mutate((C_word*)lf[93]+1 /* (set! scheme#make-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18273,a[2]=((C_word)li503),tmp=(C_word)a,a+=3,tmp));
t260=C_mutate((C_word*)lf[691]+1 /* (set! ##sys#make-vector ...) */,*((C_word*)lf[93]+1));
t261=C_mutate((C_word*)lf[94]+1 /* (set! scheme#list->vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18302,a[2]=((C_word)li505),tmp=(C_word)a,a+=3,tmp));
t262=C_mutate((C_word*)lf[95]+1 /* (set! scheme#vector->list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18354,a[2]=((C_word)li507),tmp=(C_word)a,a+=3,tmp));
t263=C_mutate((C_word*)lf[96]+1 /* (set! scheme#vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18387,a[2]=((C_word)li508),tmp=(C_word)a,a+=3,tmp));
t264=C_mutate((C_word*)lf[97]+1 /* (set! scheme#vector-fill! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18393,a[2]=((C_word)li510),tmp=(C_word)a,a+=3,tmp));
t265=C_mutate((C_word*)lf[206]+1 /* (set! chicken.base#vector-copy! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18421,a[2]=((C_word)li512),tmp=(C_word)a,a+=3,tmp));
t266=C_mutate((C_word*)lf[207]+1 /* (set! chicken.base#subvector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18490,a[2]=((C_word)li514),tmp=(C_word)a,a+=3,tmp));
t267=C_mutate((C_word*)lf[208]+1 /* (set! chicken.base#vector-resize ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18561,a[2]=((C_word)li515),tmp=(C_word)a,a+=3,tmp));
t268=C_mutate(&lf[699] /* (set! ##sys#vector-resize ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18582,a[2]=((C_word)li517),tmp=(C_word)a,a+=3,tmp));
t269=C_mutate((C_word*)lf[113]+1 /* (set! scheme#char-ci=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18621,a[2]=((C_word)li518),tmp=(C_word)a,a+=3,tmp));
t270=C_mutate((C_word*)lf[114]+1 /* (set! scheme#char-ci>? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18635,a[2]=((C_word)li519),tmp=(C_word)a,a+=3,tmp));
t271=C_mutate((C_word*)lf[115]+1 /* (set! scheme#char-ci<? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18646,a[2]=((C_word)li520),tmp=(C_word)a,a+=3,tmp));
t272=C_mutate((C_word*)lf[116]+1 /* (set! scheme#char-ci>=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18657,a[2]=((C_word)li521),tmp=(C_word)a,a+=3,tmp));
t273=C_mutate((C_word*)lf[117]+1 /* (set! scheme#char-ci<=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18668,a[2]=((C_word)li522),tmp=(C_word)a,a+=3,tmp));
t274=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18681,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:2994: scheme#make-vector */
t275=*((C_word*)lf[93]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t275;
av2[1]=t274;
av2[2]=C_fix(37);
av2[3]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t275+1)))(4,av2);}}

/* ##sys#debug-mode? in k10751 in k8834 */
static void C_ccall f_10755(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10755,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_debug_modep();
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#warning in k10751 in k8834 */
static void C_ccall f_10760(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_10760,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(*((C_word*)lf[309]+1))){{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fast_retrieve(lf[194]);
av2[3]=lf[312];
av2[4]=t2;
av2[5]=t3;
C_apply(6,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* chicken.base#notice in k10751 in k8834 */
static void C_ccall f_10769(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_10769,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(C_truep(*((C_word*)lf[310]+1))?*((C_word*)lf[309]+1):C_SCHEME_FALSE);
if(C_truep(t4)){{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fast_retrieve(lf[194]);
av2[3]=lf[314];
av2[4]=t2;
av2[5]=t3;
C_apply(6,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* chicken.base#enable-warnings in k10751 in k8834 */
static void C_ccall f_10781(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10781,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
if(C_truep(C_i_pairp(t2))){
t3=C_mutate((C_word*)lf[309]+1 /* (set! ##sys#warnings-enabled ...) */,C_get_rest_arg(c,2,av,2,t0));
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=*((C_word*)lf[309]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[309]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* ##sys#error/errno in k10751 in k8834 */
static void C_ccall f_10795(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,6)))){
C_save_and_reclaim((void*)f_10795,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
if(C_truep(C_i_pairp(t3))){{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fast_retrieve(lf[319]);
av2[3]=lf[195];
av2[4]=t2;
av2[5]=C_SCHEME_FALSE;
av2[6]=t3;
C_apply(7,av2);}}
else{
/* library.scm:1055: ##sys#signal-hook/errno */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[319]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[319]+1);
av2[1]=t1;
av2[2]=lf[195];
av2[3]=t2;
av2[4]=C_SCHEME_FALSE;
tp(5,av2);}}}

/* ##sys#setslot in k10751 in k8834 */
static void C_ccall f_10811(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10811,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_setslot(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#setislot in k10751 in k8834 */
static void C_ccall f_10814(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10814,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_set_i_slot(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#start-timer in k10751 in k8834 */
static void C_ccall f_10822(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_10822,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10826,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1069: ##sys#gc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[320]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[320]+1);
av2[1]=t2;
av2[2]=C_SCHEME_TRUE;
tp(3,av2);}}

/* k10824 in ##sys#start-timer in k10751 in k8834 */
static void C_ccall f_10826(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10826,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_start_timer();
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#stop-timer in k10751 in k8834 */
static void C_ccall f_10828(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_10828,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_stop_timer,a[2]=((C_word)li241),tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_10832,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1073: g1217 */
t4=t2;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)C_fast_retrieve_proc(t4))(2,av2);}}

/* k10830 in ##sys#stop-timer in k10751 in k8834 */
static void C_ccall f_10832(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_10832,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10835,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1076: ##sys#gc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[320]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[320]+1);
av2[1]=t2;
av2[2]=C_SCHEME_TRUE;
tp(3,av2);}}

/* k10833 in k10830 in ##sys#stop-timer in k10751 in k8834 */
static void C_ccall f_10835(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_10835,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_stop_timer,a[2]=((C_word)li242),tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_10846,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1077: g1219 */
t4=t2;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)C_fast_retrieve_proc(t4))(2,av2);}}

/* k10844 in k10833 in k10830 in ##sys#stop-timer in k10751 in k8834 */
static void C_ccall f_10846(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10846,c,av);}
t2=C_slot(t1,C_fix(6));
t3=C_i_setslot(((C_word*)t0)[2],C_fix(6),t2);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#immediate? in k10751 in k8834 */
static void C_ccall f_10848(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10848,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_not(C_blockp(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#message in k10751 in k8834 */
static void C_ccall f_10855(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10855,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_message(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#byte in k10751 in k8834 */
static void C_ccall f_10858(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10858,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_subbyte(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#setbyte in k10751 in k8834 */
static void C_ccall f_10861(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10861,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_setbyte(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#halt in k10751 in k8834 */
static void C_ccall f_10866(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10866,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_halt(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#block-ref in k10751 in k8834 */
static void C_ccall f_10870(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10870,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_block_ref(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#block-set! in k10751 in k8834 */
static void C_ccall f_10875(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_10875,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10879,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=C_i_not(C_blockp(t2));
if(C_truep(t6)){
if(C_truep(t6)){
/* library.scm:1096: ##sys#signal-hook */
t7=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=lf[263];
av2[3]=lf[340];
av2[4]=lf[342];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}
else{
t7=t5;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_UNDEFINED;
f_10879(2,av2);}}}
else{
t7=(C_truep(C_specialp(t2))?C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t7)){
if(C_truep(t7)){
/* library.scm:1096: ##sys#signal-hook */
t8=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t5;
av2[2]=lf[263];
av2[3]=lf[340];
av2[4]=lf[342];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}
else{
t8=t5;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_10879(2,av2);}}}
else{
if(C_truep(C_byteblockp(t2))){
/* library.scm:1096: ##sys#signal-hook */
t8=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t5;
av2[2]=lf[263];
av2[3]=lf[340];
av2[4]=lf[342];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}
else{
t8=t5;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_10879(2,av2);}}}}}

/* k10877 in ##sys#block-set! in k10751 in k8834 */
static void C_ccall f_10879(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_10879,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_10882,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1097: ##sys#check-range */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[341]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[341]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_fix(0);
av2[4]=C_block_size(((C_word*)t0)[3]);
av2[5]=lf[340];
tp(6,av2);}}

/* k10880 in k10877 in ##sys#block-set! in k10751 in k8834 */
static void C_ccall f_10882(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_10882,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_setslot(((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#current-milliseconds in k10751 in k8834 */
static void C_ccall f_10910(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_10910,c,av);}
a=C_alloc(7);
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_current_milliseconds(&a,1,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#current-process-milliseconds in k10751 in k8834 */
static void C_ccall f_10913(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_10913,c,av);}
a=C_alloc(7);
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_current_process_milliseconds(&a,1,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#current-seconds in k10751 in k8834 */
static void C_ccall f_10916(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_10916,c,av);}
a=C_alloc(7);
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_get_current_seconds(&a,1,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#cpu-time in k10751 in k8834 */
static void C_ccall f_10919(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_10919,c,av);}
a=C_alloc(11);
t2=C_a_i_vector2(&a,2,C_SCHEME_FALSE,C_SCHEME_FALSE);
t3=C_a_i_cpu_time(&a,1,t2);
/* library.scm:1130: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_slot(t2,C_fix(0));
av2[3]=C_slot(t2,C_fix(1));
C_values(4,av2);}}

/* ##sys#check-structure in k10751 in k8834 */
static void C_ccall f_10936(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10936,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=C_i_pairp(t4);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_check_structure_2(t2,t3,C_get_rest_arg(c,4,av,4,t0)):C_i_check_structure(t2,t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#check-blob in k10751 in k8834 */
static void C_ccall f_10947(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10947,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_bytevector_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_bytevector(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-pair in k10751 in k8834 */
static void C_ccall f_10959(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10959,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_pair_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_pair(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-list in k10751 in k8834 */
static void C_ccall f_10970(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10970,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_list_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_list(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-string in k10751 in k8834 */
static void C_ccall f_10981(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10981,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_string_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_string(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-number in k10751 in k8834 */
static void C_ccall f_10992(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_10992,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_number_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_number(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-fixnum in k10751 in k8834 */
static void C_ccall f_11003(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_11003,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_fixnum_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_fixnum(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-exact in k10751 in k8834 */
static void C_ccall f_11014(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_11014,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_exact_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_exact(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-inexact in k10751 in k8834 */
static void C_ccall f_11025(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_11025,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_inexact_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_inexact(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-symbol in k10751 in k8834 */
static void C_ccall f_11036(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_11036,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_symbol_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_symbol(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-keyword in k10751 in k8834 */
static void C_ccall f_11047(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_11047,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_keyword_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_keyword(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-vector in k10751 in k8834 */
static void C_ccall f_11058(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_11058,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_vector_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_vector(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-char in k10751 in k8834 */
static void C_ccall f_11069(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_11069,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_char_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_char(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-boolean in k10751 in k8834 */
static void C_ccall f_11080(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_11080,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_boolean_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_boolean(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-locative in k10751 in k8834 */
static void C_ccall f_11091(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_11091,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_locative_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_locative(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-integer in k10751 in k8834 */
static void C_ccall f_11102(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_11102,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_integerp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1213: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1213: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-exact-integer in k10751 in k8834 */
static void C_ccall f_11119(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_11119,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_exact_integerp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1217: ##sys#error-bad-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[366]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1217: ##sys#error-bad-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[366]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[366]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-exact-uinteger in k10751 in k8834 */
static void C_ccall f_11136(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_11136,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_not(C_i_exact_integerp(t2));
t5=(C_truep(t4)?t4:C_i_integer_negativep(t2));
if(C_truep(t5)){
if(C_truep(C_i_pairp(t3))){
/* library.scm:1222: ##sys#error-bad-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[368]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[368]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1222: ##sys#error-bad-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[368]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[368]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* ##sys#check-real in k10751 in k8834 */
static void C_ccall f_11160(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_11160,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_realp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1226: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[370]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1226: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[370]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-range in k10751 in k8834 */
static void C_ccall f_11177(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +7,c,3)))){
C_save_and_reclaim((void*)f_11177,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+7);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_11181,a[2]=t3,a[3]=t2,a[4]=t4,a[5]=t1,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1229: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}

/* k11179 in ##sys#check-range in k10751 in k8834 */
static void C_ccall f_11181(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_11181,c,av);}
t2=C_fixnum_less_or_equal_p(((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(C_truep(t2)?C_fixnum_lessp(((C_word*)t0)[3],((C_word*)t0)[4]):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_OUT_OF_RANGE_ERROR);
if(C_truep(C_i_pairp(((C_word*)t0)[6]))){
/* library.scm:1231: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
av2[3]=C_u_i_car(((C_word*)t0)[6]);
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[4];
tp(7,av2);}}
else{
/* library.scm:1231: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
av2[3]=C_SCHEME_FALSE;
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[4];
tp(7,av2);}}}}

/* ##sys#check-special in k10751 in k8834 */
static void C_ccall f_11207(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_11207,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(C_truep(C_blockp(t2))?C_specialp(t2):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1237: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word av2[6];
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[263];
av2[3]=C_get_rest_arg(c,3,av,3,t0);
av2[4]=lf[373];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}
else{
/* library.scm:1237: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[263];
av2[3]=C_SCHEME_FALSE;
av2[4]=lf[373];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}}}

/* ##sys#check-closure in k10751 in k8834 */
static void C_ccall f_11227(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_11227,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_closure_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_closure(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#force in k10751 in k8834 */
static void C_ccall f_11238(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_11238,c,av);}
a=C_alloc(6);
if(C_truep(C_i_structurep(t2,lf[218]))){
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11250,a[2]=t4,a[3]=((C_word)li280),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_11250(t6,t1,t2,C_SCHEME_FALSE);}
else{
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* lp in scheme#force in k10751 in k8834 */
static void C_fcall f_11250(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_11250,4,t0,t1,t2,t3);}
a=C_alloc(6);
t4=C_slot(t2,C_fix(1));
if(C_truep(C_i_nullp(t4))){
/* library.scm:1250: ##sys#values */{
C_word av2[2];
av2[0]=0;
av2[1]=t1;
C_values(2,av2);}}
else{
if(C_truep(C_i_pairp(t4))){{
C_word av2[3];
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
C_apply_values(3,av2);}}
else{
if(C_truep(C_i_closurep(t4))){
t5=(C_truep(t3)?C_i_setslot(t3,C_fix(1),t2):C_SCHEME_UNDEFINED);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11284,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1254: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t6;
av2[2]=t4;
av2[3]=*((C_word*)lf[376]+1);
C_call_with_values(4,av2);}}
else{
if(C_truep(C_i_structurep(t4,lf[218]))){
/* library.scm:1266: lp */
t8=t1;
t9=t4;
t10=t3;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}}}}

/* k11282 in lp in scheme#force in k10751 in k8834 */
static void C_ccall f_11284(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_11284,c,av);}
a=C_alloc(6);
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=C_i_closurep(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1256: lp */
t4=((C_word*)((C_word*)t0)[3])[1];
f_11250(t4,((C_word*)t0)[4],((C_word*)t0)[2],((C_word*)t0)[5]);}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11299,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t5=C_i_nullp(t1);
if(C_truep(C_i_not(t5))){
t6=C_i_cdr(t1);
t7=C_i_nullp(t6);
t8=t4;
f_11299(t8,(C_truep(t7)?C_i_structurep(C_slot(t1,C_fix(0)),lf[218]):C_SCHEME_FALSE));}
else{
t6=t4;
f_11299(t6,C_SCHEME_FALSE);}}}

/* k11297 in k11282 in lp in scheme#force in k10751 in k8834 */
static void C_fcall f_11299(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,3)))){
C_save_and_reclaim_args((void *)trf_11299,2,t0,t1);}
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(0));
t3=C_slot(t2,C_fix(1));
t4=C_i_setslot(((C_word*)t0)[3],C_fix(1),t3);
/* library.scm:1261: lp */
t5=((C_word*)((C_word*)t0)[4])[1];
f_11250(t5,((C_word*)t0)[5],((C_word*)t0)[3],t2);}
else{
t2=C_i_setslot(((C_word*)t0)[3],C_fix(1),((C_word*)t0)[2]);{
C_word av2[3];
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=((C_word*)t0)[2];
C_apply_values(3,av2);}}}

/* ##sys#error-not-a-proper-list in k10751 in k8834 */
static void C_ccall f_11366(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11366,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_NOT_A_PROPER_LIST_ERROR);
/* library.scm:1276: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_NOT_A_PROPER_LIST_ERROR);
/* library.scm:1276: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-number in k10751 in k8834 */
static void C_ccall f_11382(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11382,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_NUMBER_ERROR);
/* library.scm:1280: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_NUMBER_ERROR);
/* library.scm:1280: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-integer in k10751 in k8834 */
static void C_ccall f_11398(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11398,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1284: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1284: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-exact-integer in k10751 in k8834 */
static void C_ccall f_11414(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11414,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1288: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1288: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-exact-uinteger in k10751 in k8834 */
static void C_ccall f_11430(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11430,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_UINTEGER_ERROR);
/* library.scm:1292: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_UINTEGER_ERROR);
/* library.scm:1292: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-inexact in k10751 in k8834 */
static void C_ccall f_11446(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11446,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_CANT_REPRESENT_INEXACT_ERROR);
/* library.scm:1296: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_CANT_REPRESENT_INEXACT_ERROR);
/* library.scm:1296: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-real in k10751 in k8834 */
static void C_ccall f_11462(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11462,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_REAL_ERROR);
/* library.scm:1300: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_REAL_ERROR);
/* library.scm:1300: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-base in k10751 in k8834 */
static void C_ccall f_11478(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11478,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_BAD_BASE_ERROR);
/* library.scm:1304: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_BAD_BASE_ERROR);
/* library.scm:1304: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[5];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* scheme#append in k10751 in k8834 */
static void C_ccall f_11494(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_11494,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11506,a[2]=t5,a[3]=((C_word)li293),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_11506(t7,t1,t2);}}

/* loop in scheme#append in k10751 in k8834 */
static void C_fcall f_11506(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,3)))){
C_save_and_reclaim_args((void *)trf_11506,3,t0,t1,t2);}
a=C_alloc(8);
t3=C_slot(t2,C_fix(1));
t4=C_eqp(t3,C_SCHEME_END_OF_LIST);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_slot(t2,C_fix(0));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=C_slot(t2,C_fix(0));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11525,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t7,a[5]=((C_word)li292),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_11525(t9,t1,t5);}}

/* copy in loop in scheme#append in k10751 in k8834 */
static void C_fcall f_11525(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_11525,3,t0,t1,t2);}
a=C_alloc(4);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
/* library.scm:1315: loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_11506(t4,t1,C_slot(((C_word*)t0)[3],C_fix(1)));}
else{
if(C_truep(C_i_pairp(t2))){
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11556,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1317: copy */
t7=t5;
t8=C_slot(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}
else{
/* library.scm:1319: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=C_slot(((C_word*)t0)[3],C_fix(0));
av2[3]=lf[383];
tp(4,av2);}}}}

/* k11554 in copy in loop in scheme#append in k10751 in k8834 */
static void C_ccall f_11556(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_11556,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#fast-reverse in k10751 in k8834 */
static void C_ccall f_11573(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_11573,c,av);}
a=C_alloc(6);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11579,a[2]=t4,a[3]=((C_word)li295),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_11579(t6,t1,t2,C_SCHEME_END_OF_LIST);}

/* loop in ##sys#fast-reverse in k10751 in k8834 */
static void C_fcall f_11579(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_11579,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_i_pairp(t2))){
t4=C_slot(t2,C_fix(1));
t5=C_slot(t2,C_fix(0));
t6=C_a_i_cons(&a,2,t5,t3);
/* library.scm:1325: loop */
t8=t1;
t9=t4;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* ##sys#make-string in k10751 in k8834 */
static void C_ccall f_11603(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_11603,c,av);}
if(C_truep(C_rest_nullp(c,3))){
/* library.scm:1332: ##sys#allocate-vector */
t3=*((C_word*)lf[323]+1);{
C_word av2[6];
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_make_character(32);
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
/* library.scm:1332: ##sys#allocate-vector */
t3=*((C_word*)lf[323]+1);{
C_word av2[6];
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_get_rest_arg(c,3,av,3,t0);
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}

/* scheme#make-string in k10751 in k8834 */
static void C_ccall f_11623(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_11623,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11627,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1339: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[387];
tp(4,av2);}}

/* k11625 in scheme#make-string in k10751 in k8834 */
static void C_ccall f_11627(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_11627,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11630,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_lessp(((C_word*)t0)[4],C_fix(0)))){
/* library.scm:1341: ##sys#signal-hook */
t3=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[388];
av2[3]=lf[387];
av2[4]=lf[389];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_11630(2,av2);}}}

/* k11628 in k11625 in scheme#make-string in k10751 in k8834 */
static void C_ccall f_11630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_11630,c,av);}
if(C_truep(C_i_nullp(((C_word*)t0)[2]))){
/* library.scm:1332: ##sys#allocate-vector */
t2=*((C_word*)lf[323]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_TRUE;
av2[4]=C_make_character(32);
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}
else{
t2=C_i_car(((C_word*)t0)[2]);
t3=C_i_check_char_2(t2,lf[387]);
/* library.scm:1332: ##sys#allocate-vector */
t4=*((C_word*)lf[323]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_TRUE;
av2[4]=t2;
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}

/* scheme#string->list in k10751 in k8834 */
static void C_ccall f_11659(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_11659,c,av);}
a=C_alloc(7);
t3=C_i_check_string_2(t2,lf[391]);
t4=C_block_size(t2);
t5=C_fixnum_difference(t4,C_fix(1));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11675,a[2]=t2,a[3]=t7,a[4]=((C_word)li299),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_11675(t9,t1,t5,C_SCHEME_END_OF_LIST);}

/* loop in scheme#string->list in k10751 in k8834 */
static void C_fcall f_11675(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_11675,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fixnum_difference(t2,C_fix(1));
t5=C_subchar(((C_word*)t0)[2],t2);
t6=C_a_i_cons(&a,2,t5,t3);
/* library.scm:1357: loop */
t8=t1;
t9=t4;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}

/* scheme#list->string in k10751 in k8834 */
static void C_ccall f_11697(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_11697,c,av);}
a=C_alloc(5);
t3=C_i_listp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1365: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[394];
tp(4,av2);}}
else{
t4=C_i_length(t2);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11713,a[2]=t4,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1367: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[385]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[385]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}}

/* k11711 in scheme#list->string in k10751 in k8834 */
static void C_ccall f_11713(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_11713,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11718,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li301),tmp=(C_word)a,a+=5,tmp);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_11718(t2,C_fix(0),((C_word*)t0)[4])
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* doloop1539 in k11711 in scheme#list->string in k10751 in k8834 */
static C_word C_fcall f_11718(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
return(((C_word*)t0)[3]);}
else{
t3=C_slot(t2,C_fix(0));
t4=C_i_check_char_2(t3,lf[394]);
t5=C_setsubchar(((C_word*)t0)[3],t1,t3);
t7=C_fixnum_plus(t1,C_fix(1));
t8=C_slot(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}}

/* ##sys#reverse-list->string in k10751 in k8834 */
static void C_ccall f_11749(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_11749,c,av);}
a=C_alloc(5);
if(C_truep(C_i_listp(t2))){
t3=C_u_i_length(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11760,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1382: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[385]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[385]+1);
av2[1]=t4;
av2[2]=t3;
tp(3,av2);}}
else{
/* library.scm:1390: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[397];
tp(4,av2);}}}

/* k11758 in ##sys#reverse-list->string in k10751 in k8834 */
static void C_ccall f_11760(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_11760,c,av);}
a=C_alloc(4);
t2=C_fixnum_difference(((C_word*)t0)[2],C_fix(1));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11769,a[2]=t1,a[3]=((C_word)li303),tmp=(C_word)a,a+=4,tmp);
t4=(
  f_11769(t3,((C_word*)t0)[3],t2)
);
t5=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* iter in k11758 in ##sys#reverse-list->string in k10751 in k8834 */
static C_word C_fcall f_11769(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t2,C_fix(0)))){
t3=C_slot(t1,C_fix(0));
t4=C_i_check_char_2(t3,lf[397]);
t5=C_setsubchar(((C_word*)t0)[2],t2,t3);
t7=C_slot(t1,C_fix(1));
t8=C_fixnum_difference(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}
else{
t3=C_SCHEME_UNDEFINED;
return(t3);}}

/* scheme#string-fill! in k10751 in k8834 */
static void C_ccall f_11798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11798,c,av);}
t4=C_i_check_string_2(t2,lf[399]);
t5=C_i_check_char_2(t3,lf[399]);
t6=C_block_size(t2);
t7=C_set_memory(t2,t3,t6);
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}

/* scheme#string-copy in k10751 in k8834 */
static void C_ccall f_11811(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_11811,c,av);}
a=C_alloc(5);
t3=C_i_check_string_2(t2,lf[401]);
t4=C_block_size(t2);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11821,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1403: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[385]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[385]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}

/* k11819 in scheme#string-copy in k10751 in k8834 */
static void C_ccall f_11821(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11821,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#substring in k10751 in k8834 */
static void C_ccall f_11823(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_11823,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=C_i_check_string_2(t2,lf[403]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11830,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1410: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t6;
av2[2]=t3;
av2[3]=lf[403];
tp(4,av2);}}

/* k11828 in scheme#substring in k10751 in k8834 */
static void C_ccall f_11830(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_11830,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11833,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=C_u_i_car(((C_word*)t0)[5]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11868,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1413: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[403];
tp(4,av2);}}
else{
t3=t2;
f_11833(t3,C_block_size(((C_word*)t0)[2]));}}

/* k11831 in k11828 in scheme#substring in k10751 in k8834 */
static void C_fcall f_11833(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_11833,2,t0,t1);}
a=C_alloc(6);
t2=C_block_size(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11842,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnum_less_or_equal_p(((C_word*)t0)[4],t1))){
t4=C_fixnum_greater_or_equal_p(((C_word*)t0)[4],C_fix(0));
t5=t3;
f_11842(t5,(C_truep(t4)?C_fixnum_less_or_equal_p(t1,t2):C_SCHEME_FALSE));}
else{
t4=t3;
f_11842(t4,C_SCHEME_FALSE);}}

/* k11840 in k11831 in k11828 in scheme#substring in k10751 in k8834 */
static void C_fcall f_11842(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,5)))){
C_save_and_reclaim_args((void *)trf_11842,2,t0,t1);}
if(C_truep(t1)){
/* library.scm:1420: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[404]+1));
C_word av2[5];
av2[0]=*((C_word*)lf[404]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
tp(5,av2);}}
else{
t2=C_fix((C_word)C_OUT_OF_RANGE_ERROR);
/* library.scm:1421: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[6];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t2;
av2[3]=lf[403];
av2[4]=((C_word*)t0)[4];
av2[5]=((C_word*)t0)[5];
tp(6,av2);}}}

/* k11866 in k11828 in scheme#substring in k10751 in k8834 */
static void C_ccall f_11868(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11868,c,av);}
t2=((C_word*)t0)[2];
f_11833(t2,((C_word*)t0)[3]);}

/* ##sys#substring in k10751 in k8834 */
static void C_ccall f_11873(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_11873,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11877,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1426: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[385]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[385]+1);
av2[1]=t5;
av2[2]=C_fixnum_difference(t4,t3);
tp(3,av2);}}

/* k11875 in ##sys#substring in k10751 in k8834 */
static void C_ccall f_11877(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11877,c,av);}
t2=C_substring_copy(((C_word*)t0)[2],t1,((C_word*)t0)[3],((C_word*)t0)[4],C_fix(0));
t3=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* compare1592 in k10751 in k8834 */
static void C_ccall f_11882(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11882,c,av);}
t6=C_i_check_string_2(t2,t4);
t7=C_i_check_string_2(t3,t4);
t8=C_block_size(t2);
t9=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t8,t9))){
/* library.scm:1436: k */
t10=t5;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
av2[4]=C_string_compare(t2,t3,t8);
((C_proc)C_fast_retrieve_proc(t10))(5,av2);}}
else{
/* library.scm:1436: k */
t10=t5;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
av2[4]=C_string_compare(t2,t3,t9);
((C_proc)C_fast_retrieve_proc(t10))(5,av2);}}}

/* scheme#string<? in k10751 in k8834 */
static void C_ccall f_11903(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11903,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11909,a[2]=((C_word)li310),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1444: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[406];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11908 in scheme#string<? in k10751 in k8834 */
static void C_ccall f_11909(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11909,c,av);}
t5=C_fixnum_lessp(t4,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t2,t3);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t4,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string>? in k10751 in k8834 */
static void C_ccall f_11927(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11927,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11933,a[2]=((C_word)li312),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1451: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[408];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11932 in scheme#string>? in k10751 in k8834 */
static void C_ccall f_11933(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11933,c,av);}
t5=C_fixnum_greaterp(t4,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t3,t2);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t4,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string<=? in k10751 in k8834 */
static void C_ccall f_11951(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11951,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11957,a[2]=((C_word)li314),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1458: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[410];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11956 in scheme#string<=? in k10751 in k8834 */
static void C_ccall f_11957(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11957,c,av);}
t5=C_eqp(t4,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_less_or_equal_p(t2,t3):C_fixnum_lessp(t4,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* scheme#string>=? in k10751 in k8834 */
static void C_ccall f_11972(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_11972,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11978,a[2]=((C_word)li316),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1465: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[412];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a11977 in scheme#string>=? in k10751 in k8834 */
static void C_ccall f_11978(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11978,c,av);}
t5=C_eqp(t4,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_greater_or_equal_p(t2,t3):C_fixnum_greaterp(t4,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* compare1635 in k10751 in k8834 */
static void C_ccall f_11992(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_11992,c,av);}
t6=C_i_check_string_2(t2,t4);
t7=C_i_check_string_2(t3,t4);
t8=C_block_size(t2);
t9=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t8,t9))){
/* library.scm:1478: k */
t10=t5;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
av2[4]=C_string_compare_case_insensitive(t2,t3,t8);
((C_proc)C_fast_retrieve_proc(t10))(5,av2);}}
else{
/* library.scm:1478: k */
t10=t5;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
av2[4]=C_string_compare_case_insensitive(t2,t3,t9);
((C_proc)C_fast_retrieve_proc(t10))(5,av2);}}}

/* scheme#string-ci<? in k10751 in k8834 */
static void C_ccall f_12013(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_12013,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12019,a[2]=((C_word)li319),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1486: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[414];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a12018 in scheme#string-ci<? in k10751 in k8834 */
static void C_ccall f_12019(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12019,c,av);}
t5=C_fixnum_lessp(t4,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t2,t3);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t4,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string-ci>? in k10751 in k8834 */
static void C_ccall f_12037(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_12037,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12043,a[2]=((C_word)li321),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1493: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[416];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a12042 in scheme#string-ci>? in k10751 in k8834 */
static void C_ccall f_12043(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12043,c,av);}
t5=C_fixnum_greaterp(t4,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t3,t2);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t4,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string-ci<=? in k10751 in k8834 */
static void C_ccall f_12061(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_12061,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12067,a[2]=((C_word)li323),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1500: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[418];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a12066 in scheme#string-ci<=? in k10751 in k8834 */
static void C_ccall f_12067(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12067,c,av);}
t5=C_eqp(t4,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_less_or_equal_p(t2,t3):C_fixnum_lessp(t4,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* scheme#string-ci>=? in k10751 in k8834 */
static void C_ccall f_12082(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_12082,c,av);}
a=C_alloc(3);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12088,a[2]=((C_word)li325),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1507: compare */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=lf[420];
av2[5]=t4;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* a12087 in scheme#string-ci>=? in k10751 in k8834 */
static void C_ccall f_12088(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12088,c,av);}
t5=C_eqp(t4,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_greater_or_equal_p(t2,t3):C_fixnum_greaterp(t4,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#string-append in k10751 in k8834 */
static void C_ccall f_12103(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_12103,c,av);}
a=C_alloc(7);
t4=C_block_size(t2);
t5=C_block_size(t3);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_12113,a[2]=t2,a[3]=t4,a[4]=t3,a[5]=t5,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1517: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[385]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[385]+1);
av2[1]=t6;
av2[2]=C_fixnum_plus(t4,t5);
tp(3,av2);}}

/* k12111 in ##sys#string-append in k10751 in k8834 */
static void C_ccall f_12113(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12113,c,av);}
t2=C_substring_copy(((C_word*)t0)[2],t1,C_fix(0),((C_word*)t0)[3],C_fix(0));
t3=C_substring_copy(((C_word*)t0)[4],t1,C_fix(0),((C_word*)t0)[5],((C_word*)t0)[3]);
t4=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#string-append in k10751 in k8834 */
static void C_ccall f_12119(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +13,c,4)))){
C_save_and_reclaim((void*)f_12119,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+13);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t3=C_SCHEME_FALSE;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12123,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12125,a[2]=t4,a[3]=t7,a[4]=((C_word)li328),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_12125(t9,t5,t2,C_fix(0));}

/* k12121 in scheme#string-append in k10751 in k8834 */
static void C_ccall f_12123(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12123,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)((C_word*)t0)[3])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop in scheme#string-append in k10751 in k8834 */
static void C_fcall f_12125(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_12125,4,t0,t1,t2,t3);}
a=C_alloc(7);
t4=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12136,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1527: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[385]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[385]+1);
av2[1]=t5;
av2[2]=t3;
tp(3,av2);}}
else{
t5=C_slot(t2,C_fix(0));
t6=C_i_check_string_2(t5,lf[423]);
t7=C_block_size(t5);
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_12148,a[2]=t1,a[3]=t5,a[4]=((C_word*)t0)[2],a[5]=t7,a[6]=t3,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1531: loop */
t10=t8;
t11=C_slot(t2,C_fix(1));
t12=C_fixnum_plus(t3,t7);
t1=t10;
t2=t11;
t3=t12;
goto loop;}}

/* k12134 in loop in scheme#string-append in k10751 in k8834 */
static void C_ccall f_12136(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12136,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k12146 in loop in scheme#string-append in k10751 in k8834 */
static void C_ccall f_12148(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12148,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_substring_copy(((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1],C_fix(0),((C_word*)t0)[5],((C_word*)t0)[6]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#string in k10751 in k8834 */
static void C_ccall f_12158(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,2)))){
C_save_and_reclaim((void*)f_12158,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
/* ##sys#list->string */
t3=*((C_word*)lf[395]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* ##sys#fragments->string in k10751 in k8834 */
static void C_ccall f_12164(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12164,c,av);}
a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12168,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1540: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[385]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[385]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k12166 in ##sys#fragments->string in k10751 in k8834 */
static void C_ccall f_12168(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_12168,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12173,a[2]=t1,a[3]=((C_word)li331),tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_12173(t2,((C_word*)t0)[3],C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* loop in k12166 in ##sys#fragments->string in k10751 in k8834 */
static C_word C_fcall f_12173(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t1))){
return(((C_word*)t0)[2]);}
else{
t3=C_slot(t1,C_fix(0));
t4=C_block_size(t3);
t5=C_substring_copy(t3,((C_word*)t0)[2],C_fix(0),t4,t2);
t7=C_slot(t1,C_fix(1));
t8=C_fixnum_plus(t2,t4);
t1=t7;
t2=t8;
goto loop;}}

/* chicken.base#chop in k10751 in k8834 */
static void C_ccall f_12199(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_12199,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12203,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1551: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[427];
tp(4,av2);}}

/* k12201 in chicken.base#chop in k10751 in k8834 */
static void C_ccall f_12203(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_12203,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12206,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_less_or_equal_p(((C_word*)t0)[3],C_fix(0)))){
/* library.scm:1552: ##sys#error */
t3=*((C_word*)lf[155]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[427];
av2[3]=lf[428];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_12206(2,av2);}}}

/* k12204 in k12201 in chicken.base#chop in k10751 in k8834 */
static void C_ccall f_12206(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_12206,c,av);}
a=C_alloc(7);
t2=C_i_length(((C_word*)t0)[2]);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12214,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word)li334),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_12214(t6,((C_word*)t0)[4],((C_word*)t0)[2],t2);}

/* loop in k12204 in k12201 in chicken.base#chop in k10751 in k8834 */
static void C_fcall f_12214(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,5)))){
C_save_and_reclaim_args((void *)trf_12214,4,t0,t1,t2,t3);}
a=C_alloc(9);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(t3,((C_word*)t0)[2]))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_a_i_list1(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_12235,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t5,a[6]=((C_word)li333),tmp=(C_word)a,a+=7,tmp));
t7=((C_word*)t5)[1];
f_12235(t7,t1,C_SCHEME_END_OF_LIST,t2,((C_word*)t0)[2]);}}}

/* doloop1720 in loop in k12204 in k12201 in chicken.base#chop in k10751 in k8834 */
static void C_fcall f_12235(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_12235,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
t5=C_eqp(t4,C_fix(0));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_12249,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* library.scm:1562: scheme#reverse */
t7=*((C_word*)lf[46]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
t6=C_slot(t3,C_fix(0));
t7=C_a_i_cons(&a,2,t6,t2);
t9=t1;
t10=t7;
t11=C_slot(t3,C_fix(1));
t12=C_fixnum_difference(t4,C_fix(1));
t1=t9;
t2=t10;
t3=t11;
t4=t12;
goto loop;}}

/* k12247 in doloop1720 in loop in k12204 in k12201 in chicken.base#chop in k10751 in k8834 */
static void C_ccall f_12249(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_12249,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12253,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1562: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_12214(t3,t2,((C_word*)t0)[4],C_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[6]));}

/* k12251 in k12247 in doloop1720 in loop in k12204 in k12201 in chicken.base#chop in k10751 in k8834 */
static void C_ccall f_12253(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_12253,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp+ in k10751 in k8834 */
static void C_ccall f_12294(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12294,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12316,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_plus(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[441];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12314 in chicken.flonum#fp+ in k10751 in k8834 */
static void C_ccall f_12316(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12316,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_plus(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp- in k10751 in k8834 */
static void C_ccall f_12318(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12318,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12340,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_difference(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[443];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12338 in chicken.flonum#fp- in k10751 in k8834 */
static void C_ccall f_12340(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12340,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_difference(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp* in k10751 in k8834 */
static void C_ccall f_12342(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12342,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12364,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_times(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[445];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12362 in chicken.flonum#fp* in k10751 in k8834 */
static void C_ccall f_12364(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12364,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_times(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp/ in k10751 in k8834 */
static void C_ccall f_12366(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12366,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12388,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_quotient(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[447];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12386 in chicken.flonum#fp/ in k10751 in k8834 */
static void C_ccall f_12388(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12388,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_quotient(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp*+ in k10751 in k8834 */
static void C_ccall f_12390(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(13,c,2)))){
C_save_and_reclaim((void *)f_12390,c,av);}
a=C_alloc(13);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_12394,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_12397,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_i_flonump(t2))){
t7=C_i_flonump(t3);
t8=t6;
f_12397(t8,(C_truep(t7)?C_i_flonump(t4):C_SCHEME_FALSE));}
else{
t7=t6;
f_12397(t7,C_SCHEME_FALSE);}}

/* k12392 in chicken.flonum#fp*+ in k10751 in k8834 */
static void C_ccall f_12394(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12394,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_multiply_add(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]),C_flonum_magnitude(((C_word*)t0)[5])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k12395 in chicken.flonum#fp*+ in k10751 in k8834 */
static void C_fcall f_12397(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,6)))){
C_save_and_reclaim_args((void *)trf_12397,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_multiply_add(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]),C_flonum_magnitude(((C_word*)t0)[5])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1613: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word av2[7];
av2[0]=*((C_word*)lf[371]+1);
av2[1]=((C_word*)t0)[6];
av2[2]=t2;
av2[3]=lf[449];
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[5];
tp(7,av2);}}}

/* chicken.flonum#fpgcd in k10751 in k8834 */
static void C_ccall f_12415(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12415,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12437,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_gcd(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[451];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12435 in chicken.flonum#fpgcd in k10751 in k8834 */
static void C_ccall f_12437(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12437,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_gcd(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp/? in k10751 in k8834 */
static void C_ccall f_12439(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12439,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12461,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_quotient_checked(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[453];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12459 in chicken.flonum#fp/? in k10751 in k8834 */
static void C_ccall f_12461(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12461,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_quotient_checked(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp= in k10751 in k8834 */
static void C_ccall f_12463(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12463,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12485,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_equalp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[455];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12483 in chicken.flonum#fp= in k10751 in k8834 */
static void C_ccall f_12485(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12485,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_equalp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp> in k10751 in k8834 */
static void C_ccall f_12487(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12487,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12509,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_greaterp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[457];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12507 in chicken.flonum#fp> in k10751 in k8834 */
static void C_ccall f_12509(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12509,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_greaterp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp< in k10751 in k8834 */
static void C_ccall f_12511(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12511,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12533,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_lessp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[459];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12531 in chicken.flonum#fp< in k10751 in k8834 */
static void C_ccall f_12533(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12533,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_lessp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp>= in k10751 in k8834 */
static void C_ccall f_12535(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12535,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12557,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_greater_or_equal_p(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[461];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12555 in chicken.flonum#fp>= in k10751 in k8834 */
static void C_ccall f_12557(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12557,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_greater_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp<= in k10751 in k8834 */
static void C_ccall f_12559(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12559,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12581,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[463];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12579 in chicken.flonum#fp<= in k10751 in k8834 */
static void C_ccall f_12581(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12581,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpneg in k10751 in k8834 */
static void C_ccall f_12583(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12583,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12599,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_flonum_negate(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[465];
av2[4]=t2;
tp(5,av2);}}}

/* k12597 in chicken.flonum#fpneg in k10751 in k8834 */
static void C_ccall f_12599(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12599,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_negate(&a,1,((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpmax in k10751 in k8834 */
static void C_ccall f_12601(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12601,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12623,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_i_flonum_max(t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[467];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12621 in chicken.flonum#fpmax in k10751 in k8834 */
static void C_ccall f_12623(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12623,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_flonum_max(((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpmin in k10751 in k8834 */
static void C_ccall f_12625(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_12625,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12647,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_i_flonum_min(t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[469];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12645 in chicken.flonum#fpmin in k10751 in k8834 */
static void C_ccall f_12647(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12647,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_flonum_min(((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpfloor in k10751 in k8834 */
static void C_ccall f_12649(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12649,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12665,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_floor(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[471];
av2[4]=t2;
tp(5,av2);}}}

/* k12663 in chicken.flonum#fpfloor in k10751 in k8834 */
static void C_ccall f_12665(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12665,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_floor(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptruncate in k10751 in k8834 */
static void C_ccall f_12667(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12667,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12683,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_trunc(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[473];
av2[4]=t2;
tp(5,av2);}}}

/* k12681 in chicken.flonum#fptruncate in k10751 in k8834 */
static void C_ccall f_12683(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12683,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_trunc(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpround in k10751 in k8834 */
static void C_ccall f_12685(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12685,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12701,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_round(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[475];
av2[4]=t2;
tp(5,av2);}}}

/* k12699 in chicken.flonum#fpround in k10751 in k8834 */
static void C_ccall f_12701(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12701,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_round(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpceiling in k10751 in k8834 */
static void C_ccall f_12703(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12703,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12719,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_ceil(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[477];
av2[4]=t2;
tp(5,av2);}}}

/* k12717 in chicken.flonum#fpceiling in k10751 in k8834 */
static void C_ccall f_12719(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12719,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ceil(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsin in k10751 in k8834 */
static void C_ccall f_12721(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12721,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12737,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sin(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[479];
av2[4]=t2;
tp(5,av2);}}}

/* k12735 in chicken.flonum#fpsin in k10751 in k8834 */
static void C_ccall f_12737(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12737,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sin(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpcos in k10751 in k8834 */
static void C_ccall f_12739(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12739,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12755,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_cos(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[481];
av2[4]=t2;
tp(5,av2);}}}

/* k12753 in chicken.flonum#fpcos in k10751 in k8834 */
static void C_ccall f_12755(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12755,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_cos(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptan in k10751 in k8834 */
static void C_ccall f_12757(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12757,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12773,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_tan(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[483];
av2[4]=t2;
tp(5,av2);}}}

/* k12771 in chicken.flonum#fptan in k10751 in k8834 */
static void C_ccall f_12773(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12773,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_tan(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpasin in k10751 in k8834 */
static void C_ccall f_12775(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12775,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12791,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_asin(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[485];
av2[4]=t2;
tp(5,av2);}}}

/* k12789 in chicken.flonum#fpasin in k10751 in k8834 */
static void C_ccall f_12791(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12791,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_asin(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpacos in k10751 in k8834 */
static void C_ccall f_12793(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12793,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12809,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_acos(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[487];
av2[4]=t2;
tp(5,av2);}}}

/* k12807 in chicken.flonum#fpacos in k10751 in k8834 */
static void C_ccall f_12809(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12809,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_acos(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatan in k10751 in k8834 */
static void C_ccall f_12811(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12811,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12827,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_atan(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[489];
av2[4]=t2;
tp(5,av2);}}}

/* k12825 in chicken.flonum#fpatan in k10751 in k8834 */
static void C_ccall f_12827(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12827,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atan(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatan2 in k10751 in k8834 */
static void C_ccall f_12829(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12829,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12851,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_atan2(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[491];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12849 in chicken.flonum#fpatan2 in k10751 in k8834 */
static void C_ccall f_12851(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12851,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atan2(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsinh in k10751 in k8834 */
static void C_ccall f_12853(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12853,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12869,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sinh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[493];
av2[4]=t2;
tp(5,av2);}}}

/* k12867 in chicken.flonum#fpsinh in k10751 in k8834 */
static void C_ccall f_12869(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12869,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sinh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpcosh in k10751 in k8834 */
static void C_ccall f_12871(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12871,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12887,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_cosh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[495];
av2[4]=t2;
tp(5,av2);}}}

/* k12885 in chicken.flonum#fpcosh in k10751 in k8834 */
static void C_ccall f_12887(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12887,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_cosh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptanh in k10751 in k8834 */
static void C_ccall f_12889(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12889,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12905,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_tanh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[497];
av2[4]=t2;
tp(5,av2);}}}

/* k12903 in chicken.flonum#fptanh in k10751 in k8834 */
static void C_ccall f_12905(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12905,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_tanh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpasinh in k10751 in k8834 */
static void C_ccall f_12907(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12907,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12923,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_asinh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[499];
av2[4]=t2;
tp(5,av2);}}}

/* k12921 in chicken.flonum#fpasinh in k10751 in k8834 */
static void C_ccall f_12923(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12923,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_asinh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpacosh in k10751 in k8834 */
static void C_ccall f_12925(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12925,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12941,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_acosh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[501];
av2[4]=t2;
tp(5,av2);}}}

/* k12939 in chicken.flonum#fpacosh in k10751 in k8834 */
static void C_ccall f_12941(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12941,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_acosh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatanh in k10751 in k8834 */
static void C_ccall f_12943(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12943,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12959,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_atanh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[503];
av2[4]=t2;
tp(5,av2);}}}

/* k12957 in chicken.flonum#fpatanh in k10751 in k8834 */
static void C_ccall f_12959(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12959,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atanh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpexp in k10751 in k8834 */
static void C_ccall f_12961(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_12961,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12977,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_exp(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[505];
av2[4]=t2;
tp(5,av2);}}}

/* k12975 in chicken.flonum#fpexp in k10751 in k8834 */
static void C_ccall f_12977(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_12977,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_exp(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpexpt in k10751 in k8834 */
static void C_ccall f_12979(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_12979,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13001,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_expt(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1593: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[507];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k12999 in chicken.flonum#fpexpt in k10751 in k8834 */
static void C_ccall f_13001(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_13001,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_expt(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fplog in k10751 in k8834 */
static void C_ccall f_13003(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_13003,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13019,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_log(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[509];
av2[4]=t2;
tp(5,av2);}}}

/* k13017 in chicken.flonum#fplog in k10751 in k8834 */
static void C_ccall f_13019(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_13019,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_log(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsqrt in k10751 in k8834 */
static void C_ccall f_13021(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_13021,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13037,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sqrt(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[511];
av2[4]=t2;
tp(5,av2);}}}

/* k13035 in chicken.flonum#fpsqrt in k10751 in k8834 */
static void C_ccall f_13037(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_13037,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sqrt(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpabs in k10751 in k8834 */
static void C_ccall f_13039(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_13039,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13055,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_fabs(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[513];
av2[4]=t2;
tp(5,av2);}}}

/* k13053 in chicken.flonum#fpabs in k10751 in k8834 */
static void C_ccall f_13055(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_13055,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_fabs(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpinteger? in k10751 in k8834 */
static void C_ccall f_13057(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_13057,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13073,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_fpintegerp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:1589: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[515];
av2[4]=t2;
tp(5,av2);}}}

/* k13071 in chicken.flonum#fpinteger? in k10751 in k8834 */
static void C_ccall f_13073(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13073,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_u_i_fpintegerp(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#flonum-print-precision in k10751 in k8834 */
static void C_ccall f_13075(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_13075,c,av);}
a=C_alloc(5);
t2=C_rest_nullp(c,2);
t3=(C_truep(t2)?C_SCHEME_FALSE:C_get_rest_arg(c,2,av,2,t0));
t4=C_get_print_precision();
if(C_truep(t3)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13085,a[2]=t3,a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1752: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=lf[517];
tp(4,av2);}}
else{
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k13083 in chicken.flonum#flonum-print-precision in k10751 in k8834 */
static void C_ccall f_13085(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13085,c,av);}
t2=C_set_print_precision(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* make-complex in k10751 in k8834 */
static void C_fcall f_13097(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_13097,3,t1,t2,t3);}
a=C_alloc(5);
t4=C_eqp(t3,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13107,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t4)){
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=t4;
f_13107(2,av2);}}
else{
if(C_truep(C_i_flonump(t3))){
/* library.scm:1772: chicken.flonum#fp= */
t6=*((C_word*)lf[454]+1);{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=t3;
av2[3]=lf[523];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
f_13107(2,av2);}}}}

/* k13105 in make-complex in k10751 in k8834 */
static void C_ccall f_13107(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_13107,c,av);}
a=C_alloc(5);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13111,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_inexactp(((C_word*)t0)[4]))){
/* library.scm:1775: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
f_13111(2,av2);}}}}

/* k13109 in k13105 in make-complex in k10751 in k8834 */
static void C_ccall f_13111(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,1)))){
C_save_and_reclaim((void *)f_13111,c,av);}
a=C_alloc(14);
if(C_truep(C_i_inexactp(((C_word*)t0)[2]))){
t2=C_a_i_exact_to_inexact(&a,1,((C_word*)t0)[3]);
t3=C_a_i_cplxnum(&a,2,t1,t2);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_a_i_cplxnum(&a,2,t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scheme#make-rectangular in k10751 in k8834 */
static void C_ccall f_13133(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_13133,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13137,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1780: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[369]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[369]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[525];
tp(4,av2);}}

/* k13135 in scheme#make-rectangular in k10751 in k8834 */
static void C_ccall f_13137(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_13137,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13140,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1781: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[369]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[369]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[525];
tp(4,av2);}}

/* k13138 in k13135 in scheme#make-rectangular in k10751 in k8834 */
static void C_ccall f_13140(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13140,c,av);}
/* library.scm:1782: make-complex */
f_13097(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);}

/* scheme#make-polar in k10751 in k8834 */
static void C_ccall f_13145(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_13145,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13149,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1786: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[369]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[369]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[527];
tp(4,av2);}}

/* k13147 in scheme#make-polar in k10751 in k8834 */
static void C_ccall f_13149(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_13149,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13152,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1787: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[369]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[369]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[527];
tp(4,av2);}}

/* k13150 in k13147 in scheme#make-polar in k10751 in k8834 */
static void C_ccall f_13152(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13152,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13155,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1788: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13153 in k13150 in k13147 in scheme#make-polar in k10751 in k8834 */
static void C_ccall f_13155(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(74,c,3)))){
C_save_and_reclaim((void *)f_13155,c,av);}
a=C_alloc(74);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],C_a_i_cos(&a,1,t1));
t3=C_s_a_i_times(&a,2,((C_word*)t0)[2],C_a_i_sin(&a,1,t1));
/* library.scm:1789: make-complex */
f_13097(((C_word*)t0)[3],t2,t3);}

/* scheme#real-part in k10751 in k8834 */
static void C_ccall f_13168(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13168,c,av);}
if(C_truep(C_i_cplxnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1797: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[529];
tp(4,av2);}}}}

/* scheme#imag-part in k10751 in k8834 */
static void C_ccall f_13191(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13191,c,av);}
if(C_truep(C_i_cplxnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_cplxnum_imag(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=lf[523];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1804: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[531];
tp(4,av2);}}}}}

/* scheme#angle in k10751 in k8834 */
static void C_ccall f_13217(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13217,c,av);}
a=C_alloc(4);
t3=C_i_check_number_2(t2,lf[533]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13226,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1810: scheme#imag-part */
t5=*((C_word*)lf[530]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k13224 in scheme#angle in k10751 in k8834 */
static void C_ccall f_13226(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_13226,c,av);}
a=C_alloc(15);
t2=C_a_i_exact_to_inexact(&a,1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13231,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1811: scheme#real-part */
t4=*((C_word*)lf[528]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k13229 in k13224 in scheme#angle in k10751 in k8834 */
static void C_ccall f_13231(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,1)))){
C_save_and_reclaim((void *)f_13231,c,av);}
a=C_alloc(15);
t2=C_a_i_exact_to_inexact(&a,1,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_atan2(&a,2,((C_word*)t0)[3],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#magnitude in k10751 in k8834 */
static void C_ccall f_13233(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(95,c,3)))){
C_save_and_reclaim((void *)f_13233,c,av);}
a=C_alloc(95);
if(C_truep(C_i_cplxnump(t2))){
t3=C_u_i_cplxnum_real(t2);
t4=C_u_i_cplxnum_imag(t2);
t5=C_s_a_i_times(&a,2,t3,t3);
t6=C_s_a_i_times(&a,2,t4,t4);
t7=C_s_a_i_plus(&a,2,t5,t6);
/* library.scm:1818: scheme#sqrt */
t8=*((C_word*)lf[535]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t1;
av2[2]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1820: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[536];
tp(4,av2);}}}}

/* ratnum in k10751 in k8834 */
static C_word C_fcall f_13277(C_word *a,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;{}
switch(t2){
case C_fix(1):
return(t1);
case C_fix(-1):
return(C_s_a_u_i_integer_negate(&a,1,t1));
default:
if(C_truep(C_i_negativep(t2))){
t3=C_s_a_u_i_integer_negate(&a,1,t1);
t4=C_s_a_u_i_integer_negate(&a,1,t2);
return(C_a_i_ratnum(&a,2,t3,t4));}
else{
return(C_a_i_ratnum(&a,2,t1,t2));}}}

/* scheme#numerator in k10751 in k8834 */
static void C_ccall f_13323(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_13323,c,av);}
a=C_alloc(6);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_i_not(C_i_finitep(t2)))){
/* library.scm:1840: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[539];
tp(4,av2);}}
else{
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13347,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13351,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1842: scheme#inexact->exact */
t5=*((C_word*)lf[540]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_ratnum_num(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1844: ##sys#signal-hook */
t3=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[263];
av2[3]=lf[539];
av2[4]=lf[541];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}}}

/* k13345 in scheme#numerator in k10751 in k8834 */
static void C_ccall f_13347(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,1)))){
C_save_and_reclaim((void *)f_13347,c,av);}
a=C_alloc(11);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_exact_to_inexact(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k13349 in scheme#numerator in k10751 in k8834 */
static void C_ccall f_13351(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13351,c,av);}
/* library.scm:1842: scheme#numerator */
t2=*((C_word*)lf[538]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* scheme#denominator in k10751 in k8834 */
static void C_ccall f_13369(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_13369,c,av);}
a=C_alloc(6);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_i_not(C_i_finitep(t2)))){
/* library.scm:1852: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[543];
tp(4,av2);}}
else{
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=lf[544];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13393,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13397,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1854: scheme#inexact->exact */
t5=*((C_word*)lf[540]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_ratnum_denom(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:1856: ##sys#signal-hook */
t3=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[263];
av2[3]=lf[539];
av2[4]=lf[545];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}}}

/* k13391 in scheme#denominator in k10751 in k8834 */
static void C_ccall f_13393(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,1)))){
C_save_and_reclaim((void *)f_13393,c,av);}
a=C_alloc(11);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_exact_to_inexact(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k13395 in scheme#denominator in k10751 in k8834 */
static void C_ccall f_13397(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13397,c,av);}
/* library.scm:1854: scheme#denominator */
t2=*((C_word*)lf[542]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* ##sys#extended-signum in k10751 in k8834 */
static void C_ccall f_13415(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(26,c,3)))){
C_save_and_reclaim((void *)f_13415,c,av);}
a=C_alloc(26);
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_integer_signum(C_u_i_ratnum_num(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_cplxnump(t2))){
t3=C_u_i_cplxnum_imag(t2);
t4=C_a_i_exact_to_inexact(&a,1,t3);
t5=C_u_i_cplxnum_real(t2);
t6=C_a_i_exact_to_inexact(&a,1,t5);
t7=C_flonum(&a,C_atan2(C_flonum_magnitude(t4),C_flonum_magnitude(t6)));
/* library.scm:1863: scheme#make-polar */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[526]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[526]+1);
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=t7;
tp(4,av2);}}
else{
/* library.scm:1864: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[547];
tp(4,av2);}}}}

/* doloop2294 in deliver in scheme#inexact->exact in k10751 in k8834 */
static void C_fcall f_13456(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_13456,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_u_i_fpintegerp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13467,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1872: chicken.flonum#fp* */
t5=*((C_word*)lf[444]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[551];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k13465 in doloop2294 in deliver in scheme#inexact->exact in k10751 in k8834 */
static void C_ccall f_13467(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13467,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_13456(t2,((C_word*)t0)[3],t1,C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}

/* deliver in scheme#inexact->exact in k10751 in k8834 */
static void C_fcall f_13473(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,0,4)))){
C_save_and_reclaim_args((void *)trf_13473,4,t0,t1,t2,t3);}
a=C_alloc(15);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13477,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13508,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13456,a[2]=t7,a[3]=((C_word)li386),tmp=(C_word)a,a+=4,tmp));
t9=((C_word*)t7)[1];
f_13456(t9,t5,t2,C_fix(0));}

/* k13475 in deliver in scheme#inexact->exact in k10751 in k8834 */
static void C_ccall f_13477(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_13477,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_13504,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* library.scm:1878: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13489 in k13502 in k13475 in deliver in scheme#inexact->exact in k10751 in k8834 */
static void C_ccall f_13491(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13491,c,av);}
/* library.scm:1880: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* k13502 in k13475 in deliver in scheme#inexact->exact in k10751 in k8834 */
static void C_ccall f_13504(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(42,c,3)))){
C_save_and_reclaim((void *)f_13504,c,av);}
a=C_alloc(42);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
if(C_truep(C_i_finitep(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13491,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=C_s_a_u_i_flo_to_int(&a,1,t2);
/* library.scm:1880: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}
else{
/* library.scm:1881: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[380]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[6];
av2[3]=lf[549];
tp(4,av2);}}}

/* k13506 in deliver in scheme#inexact->exact in k10751 in k8834 */
static void C_ccall f_13508(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13508,c,av);}
/* library.scm:1877: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[550]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(2);
av2[3]=t1;
tp(4,av2);}}

/* k13523 in k13527 in k13533 in scheme#inexact->exact in k10751 in k8834 */
static void C_ccall f_13525(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13525,c,av);}
/* library.scm:1885: deliver */
t2=((C_word*)t0)[2];
f_13473(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k13527 in k13533 in scheme#inexact->exact in k10751 in k8834 */
static void C_ccall f_13529(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,3)))){
C_save_and_reclaim((void *)f_13529,c,av);}
a=C_alloc(38);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13525,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1888: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[550]+1);
av2[1]=t3;
av2[2]=C_fix(2);
av2[3]=*((C_word*)lf[434]+1);
tp(4,av2);}}

/* k13533 in scheme#inexact->exact in k10751 in k8834 */
static void C_ccall f_13535(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_13535,c,av);}
a=C_alloc(5);
t2=(C_truep(t1)?C_ub_i_flonum_greaterp(C_flonum_magnitude(((C_word*)t0)[2]),(double)-1.0):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13529,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1885: scheme#expt */
t4=*((C_word*)lf[552]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[551];
av2[3]=*((C_word*)lf[434]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}
else{
/* library.scm:1889: deliver */
t3=((C_word*)t0)[3];
f_13473(t3,((C_word*)t0)[4],((C_word*)t0)[2],C_fix(1));}}

/* scheme#inexact->exact in k10751 in k8834 */
static void C_ccall f_13539(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_13539,c,av);}
a=C_alloc(9);
if(C_truep(C_i_exactp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_u_i_flo_to_int(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_u_i_flonum_finitep(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13473,a[2]=t2,a[3]=((C_word)li387),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13535,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1883: chicken.flonum#fp< */
t5=*((C_word*)lf[458]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[544];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}
else{
/* library.scm:1897: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[549];
tp(4,av2);}}}}
else{
if(C_truep(C_i_cplxnump(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13579,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1899: scheme#inexact->exact */
t4=*((C_word*)lf[540]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
/* library.scm:1901: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[549];
tp(4,av2);}}}}}

/* k13577 in scheme#inexact->exact in k10751 in k8834 */
static void C_ccall f_13579(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13579,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13583,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1900: scheme#inexact->exact */
t3=*((C_word*)lf[540]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_u_i_cplxnum_imag(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13581 in k13577 in scheme#inexact->exact in k10751 in k8834 */
static void C_ccall f_13583(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13583,c,av);}
/* library.scm:1899: make-complex */
f_13097(((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* chicken.bitwise#bitwise-not in k10751 in k8834 */
static void C_ccall f_13605(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_13605,c,av);}
a=C_alloc(5);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_bitwise_not(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.bitwise#bit->boolean in k10751 in k8834 */
static void C_ccall f_13608(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13608,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_bit_to_bool(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.bitwise#integer-length in k10751 in k8834 */
static void C_ccall f_13611(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13611,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_integer_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.bitwise#arithmetic-shift in k10751 in k8834 */
static void C_ccall f_13614(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_13614,c,av);}
a=C_alloc(5);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_arithmetic_shift(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#/ in k10751 in k8834 */
static void C_ccall f_13617(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_13617,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
if(C_truep(C_rest_nullp(c,3))){
/* library.scm:1936: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=t2;
tp(4,av2);}}
else{
t4=C_slot(t3,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13638,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1938: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=C_slot(t3,C_fix(0));
tp(4,av2);}}}

/* k13636 in scheme#/ in k10751 in k8834 */
static void C_ccall f_13638(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_13638,c,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13640,a[2]=t3,a[3]=((C_word)li396),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_13640(t5,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* loop in k13636 in scheme#/ in k10751 in k8834 */
static void C_fcall f_13640(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_13640,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13658,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1942: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[548]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=C_slot(t2,C_fix(0));
tp(4,av2);}}}

/* k13656 in loop in k13636 in scheme#/ in k10751 in k8834 */
static void C_ccall f_13658(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13658,c,av);}
/* library.scm:1941: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_13640(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* ##sys#/-2 in k10751 in k8834 */
static void C_ccall f_13668(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_13668,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13672,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,C_fix(0));
if(C_truep(t5)){
t6=C_fix((C_word)C_DIVISION_BY_ZERO_ERROR);
/* library.scm:1949: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[371]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[371]+1);
av2[1]=t4;
av2[2]=t6;
av2[3]=lf[565];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}
else{
t6=t4;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_13672(2,av2);}}}

/* k13670 in ##sys#/-2 in k10751 in k8834 */
static void C_ccall f_13672(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(117,c,4)))){
C_save_and_reclaim((void *)f_13672,c,av);}
a=C_alloc(117);
t2=(C_truep(C_i_exact_integerp(((C_word*)t0)[2]))?C_i_exact_integerp(((C_word*)t0)[3]):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=C_s_a_u_i_integer_gcd(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=C_s_a_u_i_integer_quotient(&a,2,((C_word*)t0)[2],t3);
t5=C_s_a_u_i_integer_quotient(&a,2,((C_word*)t0)[3],t3);
/* library.scm:1952: ratnum */
t6=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:1952: ratnum */
  f_13277(C_a_i(&a,21),t4,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t3=C_i_cplxnump(((C_word*)t0)[2]);
t4=(C_truep(t3)?t3:C_i_cplxnump(((C_word*)t0)[3]));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13710,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1955: scheme#real-part */
t6=*((C_word*)lf[528]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t5=C_i_flonump(((C_word*)t0)[2]);
t6=(C_truep(t5)?t5:C_i_flonump(((C_word*)t0)[3]));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13776,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1963: scheme#exact->inexact */
t8=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t8;
av2[1]=t7;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(((C_word*)t0)[2]))){
if(C_truep(C_i_ratnump(((C_word*)t0)[3]))){
t7=C_u_i_ratnum_num(((C_word*)t0)[2]);
t8=C_u_i_ratnum_denom(((C_word*)t0)[2]);
t9=C_u_i_ratnum_num(((C_word*)t0)[3]);
t10=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t11=C_s_a_u_i_integer_gcd(&a,2,t7,t9);
t12=C_s_a_u_i_integer_gcd(&a,2,t8,t10);
t13=C_s_a_i_quotient(&a,2,t7,t11);
t14=C_s_a_i_quotient(&a,2,t10,t12);
t15=C_s_a_i_times(&a,2,t13,t14);
t16=C_s_a_i_quotient(&a,2,t8,t12);
t17=C_s_a_i_quotient(&a,2,t9,t11);
t18=C_s_a_i_times(&a,2,t16,t17);
/* library.scm:1973: ratnum */
t19=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t19;
av2[1]=(
/* library.scm:1973: ratnum */
  f_13277(C_a_i(&a,21),t15,t18)
);
((C_proc)(void*)(*((C_word*)t19+1)))(2,av2);}}
else{
t7=C_u_i_ratnum_num(((C_word*)t0)[2]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13857,a[2]=t7,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1979: ##sys#internal-gcd */
f_15603(t8,lf[565],t7,((C_word*)t0)[3]);}}
else{
if(C_truep(C_i_ratnump(((C_word*)t0)[3]))){
t7=C_u_i_ratnum_num(((C_word*)t0)[3]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13896,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t7,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1990: ##sys#internal-gcd */
f_15603(t8,lf[565],((C_word*)t0)[2],t7);}
else{
t7=C_i_numberp(((C_word*)t0)[2]);
if(C_truep(C_i_not(t7))){
/* library.scm:1996: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[379]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[2];
av2[3]=lf[565];
tp(4,av2);}}
else{
/* library.scm:1997: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[379]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[565];
tp(4,av2);}}}}}}}}

/* k13708 in k13670 in ##sys#/-2 in k10751 in k8834 */
static void C_ccall f_13710(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_13710,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13713,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1955: scheme#imag-part */
t3=*((C_word*)lf[530]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13711 in k13708 in k13670 in ##sys#/-2 in k10751 in k8834 */
static void C_ccall f_13713(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_13713,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13716,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1956: scheme#real-part */
t3=*((C_word*)lf[528]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13714 in k13711 in k13708 in k13670 in ##sys#/-2 in k10751 in k8834 */
static void C_ccall f_13716(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_13716,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13719,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1956: scheme#imag-part */
t3=*((C_word*)lf[530]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13717 in k13714 in k13711 in k13708 in k13670 in ##sys#/-2 in k10751 in k8834 */
static void C_ccall f_13719(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(198,c,3)))){
C_save_and_reclaim((void *)f_13719,c,av);}
a=C_alloc(198);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],((C_word*)t0)[2]);
t3=C_s_a_i_times(&a,2,t1,t1);
t4=C_s_a_i_plus(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_13725,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=t4,tmp=(C_word)a,a+=8,tmp);
t6=C_s_a_i_times(&a,2,((C_word*)t0)[5],((C_word*)t0)[2]);
t7=C_s_a_i_times(&a,2,((C_word*)t0)[4],t1);
t8=C_s_a_i_plus(&a,2,t6,t7);
/* library.scm:1958: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=t5;
av2[2]=t8;
av2[3]=t4;
tp(4,av2);}}

/* k13723 in k13717 in k13714 in k13711 in k13708 in k13670 in ##sys#/-2 in k10751 in k8834 */
static void C_ccall f_13725(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(99,c,3)))){
C_save_and_reclaim((void *)f_13725,c,av);}
a=C_alloc(99);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13728,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_times(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
t4=C_s_a_i_times(&a,2,((C_word*)t0)[5],((C_word*)t0)[6]);
t5=C_s_a_i_minus(&a,2,t3,t4);
/* library.scm:1959: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=t2;
av2[2]=t5;
av2[3]=((C_word*)t0)[7];
tp(4,av2);}}

/* k13726 in k13723 in k13717 in k13714 in k13711 in k13708 in k13670 in ##sys#/-2 in k10751 in k8834 */
static void C_ccall f_13728(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13728,c,av);}
/* library.scm:1960: make-complex */
f_13097(((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* k13774 in k13670 in ##sys#/-2 in k10751 in k8834 */
static void C_ccall f_13776(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13776,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13780,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1963: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k13778 in k13774 in k13670 in ##sys#/-2 in k10751 in k8834 */
static void C_ccall f_13780(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13780,c,av);}
/* library.scm:1963: chicken.flonum#fp/ */
t2=*((C_word*)lf[446]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k13855 in k13670 in ##sys#/-2 in k10751 in k8834 */
static void C_ccall f_13857(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(64,c,3)))){
C_save_and_reclaim((void *)f_13857,c,av);}
a=C_alloc(64);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_quotient(&a,2,((C_word*)t0)[4],t1);
t5=C_s_a_i_times(&a,2,t3,t4);
if(C_truep(C_i_flonump(t5))){
/* library.scm:1983: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}
else{
/* library.scm:1984: ratnum */
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:1984: ratnum */
  f_13277(C_a_i(&a,21),t2,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k13894 in k13670 in ##sys#/-2 in k10751 in k8834 */
static void C_ccall f_13896(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(64,c,3)))){
C_save_and_reclaim((void *)f_13896,c,av);}
a=C_alloc(64);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_times(&a,2,t2,t3);
t5=C_s_a_i_quotient(&a,2,((C_word*)t0)[4],t1);
if(C_truep(C_i_flonump(t5))){
/* library.scm:1994: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
av2[3]=t5;
tp(4,av2);}}
else{
/* library.scm:1995: ratnum */
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:1995: ratnum */
  f_13277(C_a_i(&a,21),t4,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* scheme#floor in k10751 in k8834 */
static void C_ccall f_13951(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_13951,c,av);}
a=C_alloc(34);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:2002: chicken.flonum#fpfloor */
t3=*((C_word*)lf[470]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=C_s_a_i_quotient(&a,2,t3,t4);
t6=C_i_greater_or_equalp(t3,C_fix(0));
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?t5:C_s_a_i_minus(&a,2,t5,C_fix(1)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:2007: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[370]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[567];
tp(4,av2);}}}}}

/* scheme#ceiling in k10751 in k8834 */
static void C_ccall f_13996(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_13996,c,av);}
a=C_alloc(34);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:2012: chicken.flonum#fpceiling */
t3=*((C_word*)lf[476]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=C_s_a_i_quotient(&a,2,t3,t4);
t6=C_i_greater_or_equalp(t3,C_fix(0));
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_s_a_i_plus(&a,2,t5,C_fix(1)):t5);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:2017: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[370]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[569];
tp(4,av2);}}}}}

/* scheme#truncate in k10751 in k8834 */
static void C_ccall f_14041(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_14041,c,av);}
a=C_alloc(5);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:2022: chicken.flonum#fptruncate */
t3=*((C_word*)lf[472]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_s_a_i_quotient(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* library.scm:2026: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[370]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[571];
tp(4,av2);}}}}}

/* scheme#round in k10751 in k8834 */
static void C_ccall f_14078(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(36,c,3)))){
C_save_and_reclaim((void *)f_14078,c,av);}
a=C_alloc(36);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_flonum_round_proper(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_a_i_ratnum(&a,2,C_fix(1),C_fix(2));
t4=C_s_a_i_plus(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14098,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2035: scheme#floor */
t6=*((C_word*)lf[566]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
/* library.scm:2037: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[370]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[573];
tp(4,av2);}}}}}

/* k14096 in scheme#round in k10751 in k8834 */
static void C_ccall f_14098(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_14098,c,av);}
a=C_alloc(29);
t2=C_i_nequalp(t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(t2)?(C_truep(C_i_oddp(t1))?C_s_a_i_minus(&a,2,t1,C_fix(1)):t1):t1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* find-ratio-between in k10751 in k8834 */
static void C_fcall f_14122(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(67,0,4)))){
C_save_and_reclaim_args((void *)trf_14122,3,t1,t2,t3);}
a=C_alloc(67);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14125,a[2]=t5,a[3]=((C_word)li403),tmp=(C_word)a,a+=4,tmp));
if(C_truep(C_i_lessp(t3,t2))){
/* library.scm:2050: find-ratio-between */
t12=t1;
t13=t3;
t14=t2;
t1=t12;
t2=t13;
t3=t14;
goto loop;}
else{
t7=C_i_lessp(t2,t3);
if(C_truep(C_i_not(t7))){
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_a_i_list2(&a,2,t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
if(C_truep(C_i_positivep(t2))){
/* library.scm:2052: sr */
t8=((C_word*)t5)[1];
f_14125(t8,t1,t2,t3);}
else{
if(C_truep(C_i_negativep(t3))){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14236,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t9=C_s_a_i_negate(&a,1,t3);
t10=C_s_a_i_negate(&a,1,t2);
/* library.scm:2053: sr */
t11=((C_word*)t5)[1];
f_14125(t11,t8,t9,t10);}
else{
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=lf[575];
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}}}

/* sr in find-ratio-between in k10751 in k8834 */
static void C_fcall f_14125(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,2)))){
C_save_and_reclaim_args((void *)trf_14125,4,t0,t1,t2,t3);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14129,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14204,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2041: scheme#floor */
t6=*((C_word*)lf[566]+1);{
C_word av2[3];
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k14127 in sr in find-ratio-between in k10751 in k8834 */
static void C_ccall f_14129(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_14129,c,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_14132,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14200,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2042: scheme#floor */
t4=*((C_word*)lf[566]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k14130 in k14127 in sr in find-ratio-between in k10751 in k8834 */
static void C_ccall f_14132(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(39,c,3)))){
C_save_and_reclaim((void *)f_14132,c,av);}
a=C_alloc(39);
t2=C_i_lessp(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_i_not(t2))){
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_list2(&a,2,((C_word*)t0)[2],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_nequalp(((C_word*)t0)[2],t1))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14150,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14173,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=C_s_a_i_minus(&a,2,((C_word*)t0)[6],t1);
/* library.scm:2045: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=t4;
av2[2]=C_fix(1);
av2[3]=t5;
tp(4,av2);}}
else{
t3=C_s_a_i_plus(&a,2,C_fix(1),((C_word*)t0)[2]);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_list2(&a,2,t3,C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* k14148 in k14130 in k14127 in sr in find-ratio-between in k10751 in k8834 */
static void C_ccall f_14150(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(68,c,1)))){
C_save_and_reclaim((void *)f_14150,c,av);}
a=C_alloc(68);
t2=C_i_cadr(t1);
t3=C_u_i_car(t1);
t4=C_s_a_i_times(&a,2,((C_word*)t0)[2],t3);
t5=C_s_a_i_plus(&a,2,t2,t4);
t6=C_u_i_car(t1);
t7=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_list2(&a,2,t5,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* k14171 in k14130 in k14127 in sr in find-ratio-between in k10751 in k8834 */
static void C_ccall f_14173(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_14173,c,av);}
a=C_alloc(34);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14177,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=C_s_a_i_minus(&a,2,((C_word*)t0)[4],((C_word*)t0)[5]);
/* library.scm:2046: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=t2;
av2[2]=C_fix(1);
av2[3]=t3;
tp(4,av2);}}

/* k14175 in k14171 in k14130 in k14127 in sr in find-ratio-between in k10751 in k8834 */
static void C_ccall f_14177(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14177,c,av);}
/* library.scm:2045: sr */
t2=((C_word*)((C_word*)t0)[2])[1];
f_14125(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k14198 in k14127 in sr in find-ratio-between in k10751 in k8834 */
static void C_ccall f_14200(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14200,c,av);}
/* library.scm:2042: scheme#inexact->exact */
t2=*((C_word*)lf[540]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k14202 in sr in find-ratio-between in k10751 in k8834 */
static void C_ccall f_14204(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14204,c,av);}
/* library.scm:2041: scheme#inexact->exact */
t2=*((C_word*)lf[540]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k14234 in find-ratio-between in k10751 in k8834 */
static void C_ccall f_14236(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(35,c,1)))){
C_save_and_reclaim((void *)f_14236,c,av);}
a=C_alloc(35);
t2=C_i_car(t1);
t3=C_s_a_i_negate(&a,1,t2);
t4=C_i_cadr(t1);
t5=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_a_i_list2(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#rationalize in k10751 in k8834 */
static void C_ccall f_14272(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(66,c,3)))){
C_save_and_reclaim((void *)f_14272,c,av);}
a=C_alloc(66);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14276,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14295,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=C_s_a_i_minus(&a,2,t2,t3);
t7=C_s_a_i_plus(&a,2,t2,t3);
/* library.scm:2057: find-ratio-between */
f_14122(t5,t6,t7);}

/* k14274 in scheme#rationalize in k10751 in k8834 */
static void C_ccall f_14276(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14276,c,av);}
t2=C_i_inexactp(((C_word*)t0)[2]);
if(C_truep(t2)){
if(C_truep(t2)){
/* library.scm:2063: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
if(C_truep(C_i_inexactp(((C_word*)t0)[4]))){
/* library.scm:2063: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}}

/* k14293 in scheme#rationalize in k10751 in k8834 */
static void C_ccall f_14295(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14295,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[548]+1);
av2[3]=t1;
C_apply(4,av2);}}

/* scheme#max in k10751 in k8834 */
static void C_ccall f_14297(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,5)))){
C_save_and_reclaim((void*)f_14297,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_flonump(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14304,a[2]=t6,a[3]=((C_word)li406),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_14304(t8,t1,t4,t2,t3);}

/* loop in scheme#max in k10751 in k8834 */
static void C_fcall f_14304(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_14304,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=C_i_check_number_2(t3,lf[578]);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t2)?C_a_i_exact_to_inexact(&a,1,t3):t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=(C_truep(t2)?t2:C_i_flonump(t6));
t8=C_i_greaterp(t6,t3);
t9=(C_truep(t8)?t6:t3);
/* library.scm:2073: loop */
t11=t1;
t12=t7;
t13=t9;
t14=C_slot(t4,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}}

/* scheme#min in k10751 in k8834 */
static void C_ccall f_14341(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,5)))){
C_save_and_reclaim((void*)f_14341,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_flonump(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14348,a[2]=t6,a[3]=((C_word)li408),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_14348(t8,t1,t4,t2,t3);}

/* loop in scheme#min in k10751 in k8834 */
static void C_fcall f_14348(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_14348,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=C_i_check_number_2(t3,lf[580]);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t2)?C_a_i_exact_to_inexact(&a,1,t3):t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=(C_truep(t2)?t2:C_i_flonump(t6));
t8=C_i_lessp(t6,t3);
t9=(C_truep(t8)?t6:t3);
/* library.scm:2084: loop */
t11=t1;
t12=t7;
t13=t9;
t14=C_slot(t4,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}}

/* scheme#exp in k10751 in k8834 */
static void C_ccall f_14385(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_14385,c,av);}
a=C_alloc(15);
t3=C_i_check_number_2(t2,lf[582]);
if(C_truep(C_i_cplxnump(t2))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14403,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2093: scheme#exact->inexact */
t5=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_flonum(&a,C_exp(C_flonum_magnitude(t4)));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k14401 in scheme#exp in k10751 in k8834 */
static void C_ccall f_14403(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,2)))){
C_save_and_reclaim((void *)f_14403,c,av);}
a=C_alloc(12);
t2=C_a_i_exp(&a,1,t1);
t3=C_u_i_cplxnum_imag(((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14412,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14417,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2096: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k14410 in k14401 in scheme#exp in k10751 in k8834 */
static void C_ccall f_14412(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_14412,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k14415 in k14401 in scheme#exp in k10751 in k8834 */
static void C_ccall f_14417(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,3)))){
C_save_and_reclaim((void *)f_14417,c,av);}
a=C_alloc(19);
t2=C_a_i_cos(&a,1,t1);
t3=C_a_i_exact_to_inexact(&a,1,((C_word*)t0)[2]);
t4=C_a_i_sin(&a,1,t3);
/* library.scm:2095: make-complex */
f_13097(((C_word*)t0)[3],t2,t4);}

/* ##sys#log-1 in k10751 in k8834 */
static void C_ccall f_14430(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_14430,c,av);}
a=C_alloc(7);
t3=C_eqp(t2,C_fix(0));
if(C_truep(t3)){
/* library.scm:2103: ##sys#signal-hook */
t4=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[584];
av2[3]=lf[585];
av2[4]=lf[586];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}
else{
t4=C_i_cplxnump(t2);
t5=(C_truep(t4)?t4:C_i_negativep(t2));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14456,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14472,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2106: scheme#magnitude */
t8=*((C_word*)lf[534]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14476,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2109: scheme#exact->inexact */
t7=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}}

/* k14454 in ##sys#log-1 in k10751 in k8834 */
static void C_ccall f_14456(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_14456,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14464,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2107: make-complex */
f_13097(t2,C_fix(0),C_fix(1));}

/* k14462 in k14454 in ##sys#log-1 in k10751 in k8834 */
static void C_ccall f_14464(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_14464,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14468,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2107: scheme#angle */
t3=*((C_word*)lf[532]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k14466 in k14462 in k14454 in ##sys#log-1 in k10751 in k8834 */
static void C_ccall f_14468(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(62,c,1)))){
C_save_and_reclaim((void *)f_14468,c,av);}
a=C_alloc(62);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_plus(&a,2,((C_word*)t0)[4],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k14470 in ##sys#log-1 in k10751 in k8834 */
static void C_ccall f_14472(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14472,c,av);}
/* library.scm:2106: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[583]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[583]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* k14474 in ##sys#log-1 in k10751 in k8834 */
static void C_ccall f_14476(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_14476,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_log(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#log in k10751 in k8834 */
static void C_ccall f_14479(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_14479,c,av);}
a=C_alloc(4);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14493,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2113: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[583]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[583]+1);
av2[1]=t5;
av2[2]=t2;
tp(3,av2);}}
else{
/* library.scm:2113: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[583]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[583]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}}

/* k14491 in scheme#log in k10751 in k8834 */
static void C_ccall f_14493(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_14493,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14497,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2113: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[583]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[583]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* k14495 in k14491 in scheme#log in k10751 in k8834 */
static void C_ccall f_14497(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14497,c,av);}
/* library.scm:2113: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* scheme#sin in k10751 in k8834 */
static void C_ccall f_14508(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(37,c,2)))){
C_save_and_reclaim((void *)f_14508,c,av);}
a=C_alloc(37);
t3=C_i_check_number_2(t2,lf[589]);
if(C_truep(C_i_cplxnump(t2))){
t4=C_s_a_i_times(&a,2,lf[590],t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14532,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2120: scheme#exp */
t6=*((C_word*)lf[581]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_sin(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k14530 in scheme#sin in k10751 in k8834 */
static void C_ccall f_14532(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14532,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14536,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_negate(&a,1,((C_word*)t0)[3]);
/* library.scm:2120: scheme#exp */
t4=*((C_word*)lf[581]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k14534 in k14530 in scheme#sin in k10751 in k8834 */
static void C_ccall f_14536(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_14536,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2120: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=lf[591];
tp(4,av2);}}

/* scheme#cos in k10751 in k8834 */
static void C_ccall f_14542(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(37,c,2)))){
C_save_and_reclaim((void *)f_14542,c,av);}
a=C_alloc(37);
t3=C_i_check_number_2(t2,lf[593]);
if(C_truep(C_i_cplxnump(t2))){
t4=C_s_a_i_times(&a,2,lf[590],t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14566,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2128: scheme#exp */
t6=*((C_word*)lf[581]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_cos(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k14564 in scheme#cos in k10751 in k8834 */
static void C_ccall f_14566(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14566,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14570,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_negate(&a,1,((C_word*)t0)[3]);
/* library.scm:2128: scheme#exp */
t4=*((C_word*)lf[581]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k14568 in k14564 in scheme#cos in k10751 in k8834 */
static void C_ccall f_14570(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_14570,c,av);}
a=C_alloc(29);
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2128: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=C_fix(2);
tp(4,av2);}}

/* scheme#tan in k10751 in k8834 */
static void C_ccall f_14576(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_14576,c,av);}
a=C_alloc(15);
t3=C_i_check_number_2(t2,lf[595]);
if(C_truep(C_i_cplxnump(t2))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14593,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2135: scheme#sin */
t5=*((C_word*)lf[588]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_tan(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k14591 in scheme#tan in k10751 in k8834 */
static void C_ccall f_14593(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_14593,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14597,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2135: scheme#cos */
t3=*((C_word*)lf[592]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k14595 in k14591 in scheme#tan in k10751 in k8834 */
static void C_ccall f_14597(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14597,c,av);}
/* library.scm:2135: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* scheme#asin in k10751 in k8834 */
static void C_ccall f_14601(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_14601,c,av);}
a=C_alloc(8);
t3=C_i_check_number_2(t2,lf[597]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14611,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14659,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2142: chicken.flonum#fp>= */
t6=*((C_word*)lf[460]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=lf[600];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t5=t4;
f_14611(t5,C_SCHEME_FALSE);}}

/* k14609 in scheme#asin in k10751 in k8834 */
static void C_fcall f_14611(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_14611,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_a_i_asin(&a,1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14617,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t3=C_fixnum_greater_or_equal_p(((C_word*)t0)[2],C_fix(-1));
t4=t2;
f_14617(t4,(C_truep(t3)?C_fixnum_less_or_equal_p(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE));}
else{
t3=t2;
f_14617(t3,C_SCHEME_FALSE);}}}

/* k14615 in k14609 in scheme#asin in k10751 in k8834 */
static void C_fcall f_14617(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(102,0,3)))){
C_save_and_reclaim_args((void *)trf_14617,2,t0,t1);}
a=C_alloc(102);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_a_i_asin(&a,1,C_a_i_fix_to_flo(&a,1,((C_word*)t0)[3]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14624,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=C_s_a_i_times(&a,2,lf[590],((C_word*)t0)[3]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14636,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_s_a_i_times(&a,2,((C_word*)t0)[3],((C_word*)t0)[3]);
t6=C_s_a_i_minus(&a,2,C_fix(1),t5);
/* library.scm:2151: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[599]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[599]+1);
av2[1]=t4;
av2[2]=lf[597];
av2[3]=t6;
tp(4,av2);}}}

/* k14622 in k14615 in k14609 in scheme#asin in k10751 in k8834 */
static void C_ccall f_14624(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_14624,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,lf[598],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k14634 in k14615 in k14609 in scheme#asin in k10751 in k8834 */
static void C_ccall f_14636(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,2)))){
C_save_and_reclaim((void *)f_14636,c,av);}
a=C_alloc(29);
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2149: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[583]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[583]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
tp(3,av2);}}

/* k14657 in scheme#asin in k10751 in k8834 */
static void C_ccall f_14659(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14659,c,av);}
t2=((C_word*)t0)[2];
f_14611(t2,(C_truep(t1)?C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),(double)1.0):C_SCHEME_FALSE));}

/* scheme#acos in k10751 in k8834 */
static void C_ccall f_14663(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_14663,c,av);}
a=C_alloc(9);
t3=C_i_check_number_2(t2,lf[602]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14673,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_flonump(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14701,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2159: chicken.flonum#fp>= */
t6=*((C_word*)lf[460]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=lf[600];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t5=t4;
f_14673(t5,C_SCHEME_FALSE);}}

/* k14671 in scheme#acos in k10751 in k8834 */
static void C_fcall f_14673(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_14673,2,t0,t1);}
a=C_alloc(5);
if(C_truep(t1)){
t2=C_a_i_acos(&a,1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14679,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t3=C_fixnum_greater_or_equal_p(((C_word*)t0)[2],C_fix(-1));
t4=t2;
f_14679(t4,(C_truep(t3)?C_fixnum_less_or_equal_p(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE));}
else{
t3=t2;
f_14679(t3,C_SCHEME_FALSE);}}}

/* k14677 in k14671 in scheme#acos in k10751 in k8834 */
static void C_fcall f_14679(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_14679,2,t0,t1);}
a=C_alloc(8);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_a_i_acos(&a,1,C_a_i_fix_to_flo(&a,1,((C_word*)t0)[3]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14686,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2166: scheme#asin */
t3=*((C_word*)lf[596]+1);{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}

/* k14684 in k14677 in k14671 in scheme#acos in k10751 in k8834 */
static void C_ccall f_14686(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_14686,c,av);}
a=C_alloc(29);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_minus(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k14699 in scheme#acos in k10751 in k8834 */
static void C_ccall f_14701(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14701,c,av);}
t2=((C_word*)t0)[2];
f_14673(t2,(C_truep(t1)?C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),(double)1.0):C_SCHEME_FALSE));}

/* scheme#atan in k10751 in k8834 */
static void C_ccall f_14705(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(66,c,3)))){
C_save_and_reclaim((void *)f_14705,c,av);}
a=C_alloc(66);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_i_check_number_2(t2,lf[604]);
if(C_truep(C_i_cplxnump(t2))){
if(C_truep(t4)){
/* library.scm:2173: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[370]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[604];
tp(4,av2);}}
else{
t6=C_s_a_i_times(&a,2,lf[590],t2);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14738,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
t8=C_s_a_i_plus(&a,2,C_fix(1),t6);
/* library.scm:2175: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[583]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[583]+1);
av2[1]=t7;
av2[2]=t8;
tp(3,av2);}}}
else{
if(C_truep(t4)){
t6=C_a_i_exact_to_inexact(&a,1,t2);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14759,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2179: scheme#exact->inexact */
t8=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
t6=C_a_i_exact_to_inexact(&a,1,t2);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_atan(&a,1,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* k14736 in scheme#atan in k10751 in k8834 */
static void C_ccall f_14738(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_14738,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14742,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_minus(&a,2,C_fix(1),((C_word*)t0)[3]);
/* library.scm:2176: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[583]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[583]+1);
av2[1]=t2;
av2[2]=t3;
tp(3,av2);}}

/* k14740 in k14736 in scheme#atan in k10751 in k8834 */
static void C_ccall f_14742(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_14742,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2175: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=lf[591];
tp(4,av2);}}

/* k14757 in scheme#atan in k10751 in k8834 */
static void C_ccall f_14759(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_14759,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_atan2(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#exact-integer-sqrt in k10751 in k8834 */
static void C_ccall f_14769(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_14769,c,av);}
a=C_alloc(10);
t3=C_fixnump(t2);
t4=(C_truep(t3)?C_fixnum_less_or_equal_p(t2,C_fix(4)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_eqp(t2,C_fix(0));
t6=(C_truep(t5)?t5:C_eqp(t2,C_fix(1)));
if(C_truep(t6)){
/* library.scm:2191: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_fix(0);
C_values(4,av2);}}
else{
switch(t2){
case C_fix(2):
/* library.scm:2192: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=C_fix(1);
C_values(4,av2);}
case C_fix(3):
/* library.scm:2193: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=C_fix(2);
C_values(4,av2);}
case C_fix(4):
/* library.scm:2194: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(2);
av2[3]=C_fix(0);
C_values(4,av2);}
default:
/* library.scm:2195: chicken.base#error */
t7=*((C_word*)lf[193]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[606];
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}}
else{
t5=C_fixnum_plus(C_i_integer_length(t2),C_fix(1));
t6=C_fixnum_shift_right(t5,C_fix(2));
t7=C_fixnum_shift_left(t6,C_fix(1));
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14842,a[2]=t7,a[3]=t2,a[4]=((C_word)li419),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14856,a[2]=t6,a[3]=t2,a[4]=((C_word)li423),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2196: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
C_call_with_values(4,av2);}}}

/* a14841 in ##sys#exact-integer-sqrt in k10751 in k8834 */
static void C_ccall f_14842(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_14842,c,av);}
a=C_alloc(5);
t2=C_fixnum_negate(((C_word*)t0)[2]);
t3=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[3],t2);
/* library.scm:2199: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[605]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[605]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}

/* a14855 in ##sys#exact-integer-sqrt in k10751 in k8834 */
static void C_ccall f_14856(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(38,c,4)))){
C_save_and_reclaim((void *)f_14856,c,av);}
a=C_alloc(38);
t4=C_s_a_i_arithmetic_shift(&a,2,C_fix(1),((C_word*)t0)[2]);
t5=C_s_a_u_i_integer_minus(&a,2,t4,C_fix(1));
t6=C_s_a_i_bitwise_and(&a,2,((C_word*)t0)[3],t5);
t7=C_fixnum_negate(((C_word*)t0)[2]);
t8=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[3],t7);
t9=C_s_a_i_bitwise_and(&a,2,t8,t5);
t10=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_14873,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t9,a[5]=t2,a[6]=((C_word)li421),tmp=(C_word)a,a+=7,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14889,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li422),tmp=(C_word)a,a+=6,tmp);
/* library.scm:2196: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t10;
av2[3]=t11;
C_call_with_values(4,av2);}}

/* a14872 in a14855 in ##sys#exact-integer-sqrt in k10751 in k8834 */
static void C_ccall f_14873(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(18,c,3)))){
C_save_and_reclaim((void *)f_14873,c,av);}
a=C_alloc(18);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_u_integer_quotient_and_remainder,a[2]=((C_word)li420),tmp=(C_word)a,a+=3,tmp);
t3=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=C_s_a_u_i_integer_plus(&a,2,t3,((C_word*)t0)[4]);
t5=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[5],C_fix(1));
/* library.scm:2196: g2666 */
t6=t2;{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}

/* a14888 in a14855 in ##sys#exact-integer-sqrt in k10751 in k8834 */
static void C_ccall f_14889(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(222,c,3)))){
C_save_and_reclaim((void *)f_14889,c,av);}
a=C_alloc(222);
t4=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t5=C_s_a_i_plus(&a,2,t4,t2);
t6=C_s_a_i_arithmetic_shift(&a,2,t3,((C_word*)t0)[3]);
t7=C_s_a_i_times(&a,2,t2,t2);
t8=C_s_a_i_minus(&a,2,((C_word*)t0)[4],t7);
t9=C_s_a_i_plus(&a,2,t6,t8);
if(C_truep(C_i_negativep(t9))){
t10=C_s_a_i_minus(&a,2,t5,C_fix(1));
t11=C_s_a_i_arithmetic_shift(&a,2,t5,C_fix(1));
t12=C_s_a_i_plus(&a,2,t9,t11);
t13=C_s_a_i_minus(&a,2,t12,C_fix(1));
/* library.scm:2210: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t10;
av2[3]=t13;
C_values(4,av2);}}
else{
/* library.scm:2212: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t9;
C_values(4,av2);}}}

/* chicken.base#exact-integer-sqrt in k10751 in k8834 */
static void C_ccall f_14960(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_14960,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14964,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2216: ##sys#check-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[367]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[367]+1);
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[608];
tp(4,av2);}}

/* k14962 in chicken.base#exact-integer-sqrt in k10751 in k8834 */
static void C_ccall f_14964(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_14964,c,av);}
/* library.scm:2217: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[605]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[605]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_14969(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(32,c,4)))){
C_save_and_reclaim((void *)f_14969,c,av);}
a=C_alloc(32);
if(C_truep(C_i_cplxnump(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14979,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_u_i_cplxnum_imag(t3);
t6=C_a_i_exact_to_inexact(&a,1,t5);
t7=C_u_i_cplxnum_real(t3);
t8=C_a_i_exact_to_inexact(&a,1,t7);
t9=C_flonum(&a,C_atan2(C_flonum_magnitude(t6),C_flonum_magnitude(t8)));
/* library.scm:2223: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[548]+1);
av2[1]=t4;
av2[2]=t9;
av2[3]=C_fix(2);
tp(4,av2);}}
else{
if(C_truep(C_i_negativep(t3))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15019,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=C_s_a_i_negate(&a,1,t3);
/* library.scm:2228: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t4;
av2[2]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
if(C_truep(C_i_exact_integerp(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15030,a[2]=t3,a[3]=((C_word)li426),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15036,a[2]=t3,a[3]=((C_word)li427),tmp=(C_word)a,a+=4,tmp);
/* library.scm:2230: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}
else{
if(C_truep(C_i_ratnump(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15058,a[2]=t3,a[3]=((C_word)li428),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15070,a[2]=t3,a[3]=t2,a[4]=((C_word)li431),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2235: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15122,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2243: scheme#exact->inexact */
t5=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}}}

/* k14977 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_14979(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_14979,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14983,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2224: scheme#magnitude */
t3=*((C_word*)lf[534]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k14981 in k14977 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_14983(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_14983,c,av);}
a=C_alloc(9);
t2=C_a_i_sqrt(&a,1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15002,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2225: scheme#cos */
t4=*((C_word*)lf[592]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k14996 in k15000 in k14981 in k14977 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_14998(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,3)))){
C_save_and_reclaim((void *)f_14998,c,av);}
a=C_alloc(33);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2225: make-complex */
f_13097(((C_word*)t0)[3],((C_word*)t0)[4],t2);}

/* k15000 in k14981 in k14977 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_15002(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,2)))){
C_save_and_reclaim((void *)f_15002,c,av);}
a=C_alloc(38);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14998,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2225: scheme#sin */
t4=*((C_word*)lf[588]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k15017 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_15019(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_15019,c,av);}
a=C_alloc(4);
t2=C_a_i_sqrt(&a,1,t1);
/* library.scm:2227: make-complex */
f_13097(((C_word*)t0)[2],lf[523],t2);}

/* a15029 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_15030(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_15030,c,av);}
/* library.scm:2230: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[605]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[605]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
tp(3,av2);}}

/* a15035 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_15036(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_15036,c,av);}
a=C_alloc(3);
t4=C_eqp(C_fix(0),t3);
if(C_truep(t4)){
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15047,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2233: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* k15045 in a15035 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_15047(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_15047,c,av);}
a=C_alloc(4);
t2=C_a_i_sqrt(&a,1,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a15057 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_15058(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_15058,c,av);}
/* library.scm:2235: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[605]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[605]+1);
av2[1]=t1;
av2[2]=C_u_i_ratnum_num(((C_word*)t0)[2]);
tp(3,av2);}}

/* a15069 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_15070(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_15070,c,av);}
a=C_alloc(10);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15082,a[2]=((C_word*)t0)[2],a[3]=((C_word)li429),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15094,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=((C_word)li430),tmp=(C_word)a,a+=6,tmp);
/* library.scm:2237: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
C_call_with_values(4,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15118,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2242: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* a15081 in a15069 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_15082(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_15082,c,av);}
/* library.scm:2238: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[605]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[605]+1);
av2[1]=t1;
av2[2]=C_u_i_ratnum_denom(((C_word*)t0)[2]);
tp(3,av2);}}

/* a15093 in a15069 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_15094(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_15094,c,av);}
a=C_alloc(4);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
/* library.scm:2240: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[548]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
tp(4,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15111,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2241: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* k15109 in a15093 in a15069 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_15111(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15111,c,av);}
/* library.scm:2241: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[599]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[599]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* k15116 in a15069 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_15118(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15118,c,av);}
/* library.scm:2242: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[599]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[599]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* k15120 in ##sys#sqrt/loc in k10751 in k8834 */
static void C_ccall f_15122(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_15122,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_sqrt(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#sqrt in k10751 in k8834 */
static void C_ccall f_15124(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15124,c,av);}
/* library.scm:2245: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[599]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[599]+1);
av2[1]=t1;
av2[2]=lf[609];
av2[3]=t2;
tp(4,av2);}}

/* chicken.base#exact-integer-nth-root in k10751 in k8834 */
static void C_ccall f_15130(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_15130,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15134,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2249: ##sys#check-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[367]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[367]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[612];
tp(4,av2);}}

/* k15132 in chicken.base#exact-integer-nth-root in k10751 in k8834 */
static void C_ccall f_15134(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_15134,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15137,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2250: ##sys#check-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[367]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[367]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[612];
tp(4,av2);}}

/* k15135 in k15132 in chicken.base#exact-integer-nth-root in k10751 in k8834 */
static void C_ccall f_15137(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15137,c,av);}
/* library.scm:2251: ##sys#exact-integer-nth-root/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[611]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[611]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[612];
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
tp(5,av2);}}

/* ##sys#exact-integer-nth-root/loc in k10751 in k8834 */
static void C_ccall f_15142(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_15142,c,av);}
a=C_alloc(5);
t5=C_eqp(C_fix(0),t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15152,a[2]=t1,a[3]=t3,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t5)){
t7=t6;
f_15152(t7,t5);}
else{
t7=C_eqp(C_fix(1),t3);
t8=t6;
f_15152(t8,(C_truep(t7)?t7:C_eqp(C_fix(1),t4)));}}

/* k15150 in ##sys#exact-integer-nth-root/loc in k10751 in k8834 */
static void C_fcall f_15152(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,0,3)))){
C_save_and_reclaim_args((void *)trf_15152,2,t0,t1);}
a=C_alloc(29);
if(C_truep(t1)){
/* library.scm:2257: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=C_fix(0);
C_values(4,av2);}}
else{
t2=C_i_integer_length(((C_word*)t0)[3]);
if(C_truep(C_i_lessp(t2,((C_word*)t0)[4]))){
t3=C_s_a_i_minus(&a,2,((C_word*)t0)[3],C_fix(1));
/* library.scm:2260: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(1);
av2[3]=t3;
C_values(4,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15172,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15248,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15252,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[548]+1);
av2[1]=t5;
av2[2]=C_fixnum_plus(t2,C_fix(1));
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}}}

/* k15170 in k15150 in ##sys#exact-integer-nth-root/loc in k10751 in k8834 */
static void C_ccall f_15172(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(75,c,3)))){
C_save_and_reclaim((void *)f_15172,c,av);}
a=C_alloc(75);
t2=C_s_a_i_arithmetic_shift(&a,2,C_fix(1),t1);
t3=C_s_a_i_minus(&a,2,((C_word*)t0)[2],C_fix(1));
t4=C_s_a_i_times(&a,2,t3,t2);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_15244,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word*)t0)[2],a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=t2,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2268: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[550]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=t3;
tp(4,av2);}}

/* lp in k15242 in k15170 in k15150 in ##sys#exact-integer-nth-root/loc in k10751 in k8834 */
static void C_fcall f_15187(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(41,0,3)))){
C_save_and_reclaim_args((void *)trf_15187,4,t0,t1,t2,t3);}
a=C_alloc(41);
if(C_truep(C_i_lessp(t3,t2))){
t4=C_s_a_i_times(&a,2,((C_word*)t0)[2],t3);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_15217,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,a[7]=t3,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2273: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[550]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=((C_word*)t0)[2];
tp(4,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15228,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2275: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[550]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}}

/* k15215 in lp in k15242 in k15170 in k15150 in ##sys#exact-integer-nth-root/loc in k10751 in k8834 */
static void C_ccall f_15217(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(39,c,3)))){
C_save_and_reclaim((void *)f_15217,c,av);}
a=C_alloc(39);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_s_a_i_plus(&a,2,((C_word*)t0)[3],t2);
t4=C_s_a_i_quotient(&a,2,t3,((C_word*)t0)[4]);
/* library.scm:2271: lp */
t5=((C_word*)((C_word*)t0)[5])[1];
f_15187(t5,((C_word*)t0)[6],((C_word*)t0)[7],t4);}

/* k15226 in lp in k15242 in k15170 in k15150 in ##sys#exact-integer-nth-root/loc in k10751 in k8834 */
static void C_ccall f_15228(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_15228,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2275: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
C_values(4,av2);}}

/* k15242 in k15170 in k15150 in ##sys#exact-integer-nth-root/loc in k10751 in k8834 */
static void C_ccall f_15244(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(48,c,4)))){
C_save_and_reclaim((void *)f_15244,c,av);}
a=C_alloc(48);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_s_a_i_plus(&a,2,((C_word*)t0)[3],t2);
t4=C_s_a_i_quotient(&a,2,t3,((C_word*)t0)[4]);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15187,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],a[5]=t6,a[6]=((C_word)li435),tmp=(C_word)a,a+=7,tmp));
t8=((C_word*)t6)[1];
f_15187(t8,((C_word*)t0)[6],((C_word*)t0)[7],t4);}

/* k15246 in k15150 in ##sys#exact-integer-nth-root/loc in k10751 in k8834 */
static void C_ccall f_15248(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_15248,c,av);}
/* library.scm:2262: scheme#inexact->exact */
t2=*((C_word*)lf[540]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k15250 in k15150 in ##sys#exact-integer-nth-root/loc in k10751 in k8834 */
static void C_ccall f_15252(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_15252,c,av);}
/* library.scm:2262: scheme#ceiling */
t2=*((C_word*)lf[568]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* ##sys#integer-power in k10751 in k8834 */
static void C_ccall f_15268(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_15268,c,av);}
a=C_alloc(8);
if(C_truep(C_i_negativep(t3))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15286,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=C_s_a_u_i_integer_negate(&a,1,t3);
/* library.scm:2280: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[550]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15297,a[2]=t5,a[3]=t2,a[4]=((C_word)li437),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_15297(t7,t1,C_fix(1),t3);}}

/* k15284 in ##sys#integer-power in k10751 in k8834 */
static void C_ccall f_15286(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15286,c,av);}
/* library.scm:2280: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(1);
av2[3]=t1;
tp(4,av2);}}

/* lp in ##sys#integer-power in k10751 in k8834 */
static void C_fcall f_15297(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(62,0,3)))){
C_save_and_reclaim_args((void *)trf_15297,4,t0,t1,t2,t3);}
a=C_alloc(62);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_evenp(t3))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15319,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=C_s_a_i_arithmetic_shift(&a,2,t3,C_fix(-1));
/* library.scm:2285: lp */
t8=t5;
t9=C_fix(1);
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t5=C_s_a_i_times(&a,2,t2,((C_word*)t0)[3]);
t6=C_s_a_i_minus(&a,2,t3,C_fix(1));
/* library.scm:2287: lp */
t8=t1;
t9=t5;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* k15317 in lp in ##sys#integer-power in k10751 in k8834 */
static void C_ccall f_15319(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(66,c,1)))){
C_save_and_reclaim((void *)f_15319,c,av);}
a=C_alloc(66);
t2=C_s_a_i_times(&a,2,t1,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#expt in k10751 in k8834 */
static void C_ccall f_15336(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(21,c,4)))){
C_save_and_reclaim((void *)f_15336,c,av);}
a=C_alloc(21);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15339,a[2]=((C_word)li439),tmp=(C_word)a,a+=3,tmp));
t9=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15353,a[2]=((C_word)li440),tmp=(C_word)a,a+=3,tmp));
t10=C_i_numberp(t2);
if(C_truep(C_i_not(t10))){
/* library.scm:2299: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[613];
tp(4,av2);}}
else{
t11=C_i_numberp(t3);
if(C_truep(C_i_not(t11))){
/* library.scm:2300: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=lf[613];
tp(4,av2);}}
else{
t12=C_i_ratnump(t2);
t13=(C_truep(t12)?C_i_not(C_i_inexactp(t3)):C_SCHEME_FALSE);
if(C_truep(t13)){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15405,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2304: scheme#expt */
t15=*((C_word*)lf[552]+1);{
C_word *av2=av;
av2[0]=t15;
av2[1]=t14;
av2[2]=C_u_i_ratnum_num(t2);
av2[3]=t3;
((C_proc)(void*)(*((C_word*)t15+1)))(4,av2);}}
else{
if(C_truep(C_i_ratnump(t3))){
if(C_truep(C_i_exact_integerp(t2))){
if(C_truep(C_i_negativep(t2))){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15444,a[2]=t3,a[3]=t5,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2311: scheme#exact->inexact */
t15=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t15;
av2[1]=t14;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t15+1)))(3,av2);}}
else{
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15451,a[2]=t2,a[3]=t3,a[4]=((C_word)li441),tmp=(C_word)a,a+=5,tmp);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15463,a[2]=t3,a[3]=t2,a[4]=((C_word)li442),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2312: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t14;
av2[3]=t15;
C_call_with_values(4,av2);}}}
else{
if(C_truep(C_i_flonump(t2))){
t14=C_a_i_exact_to_inexact(&a,1,t3);
/* library.scm:2321: log-expt */
f_15339(t1,t2,t14);}
else{
/* library.scm:2322: slow-expt */
f_15353(t1,t2,t3);}}}
else{
t14=C_i_cplxnump(t3);
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15507,a[2]=t7,a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
if(C_truep(t14)){
t16=t15;
f_15507(t16,t14);}
else{
t16=C_i_cplxnump(t2);
t17=t15;
f_15507(t17,(C_truep(t16)?C_i_not(C_i_integerp(t3)):C_SCHEME_FALSE));}}}}}}

/* log-expt in scheme#expt in k10751 in k8834 */
static void C_fcall f_15339(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_15339,3,t1,t2,t3);}
a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15351,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2292: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[583]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[583]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k15349 in log-expt in scheme#expt in k10751 in k8834 */
static void C_ccall f_15351(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_15351,c,av);}
a=C_alloc(33);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2292: scheme#exp */
t3=*((C_word*)lf[581]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* slow-expt in scheme#expt in k10751 in k8834 */
static void C_fcall f_15353(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,6)))){
C_save_and_reclaim_args((void *)trf_15353,3,t1,t2,t3);}
a=C_alloc(4);
t4=C_eqp(C_fix(0),t2);
if(C_truep(t4)){
/* library.scm:2295: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word av2[7];
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[584];
av2[3]=lf[613];
av2[4]=lf[614];
av2[5]=t2;
av2[6]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(7,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15374,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2298: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[583]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[583]+1);
av2[1]=t5;
av2[2]=t2;
tp(3,av2);}}}

/* k15372 in slow-expt in scheme#expt in k10751 in k8834 */
static void C_ccall f_15374(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_15374,c,av);}
a=C_alloc(33);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2298: scheme#exp */
t3=*((C_word*)lf[581]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15403 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15405(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,3)))){
C_save_and_reclaim((void *)f_15405,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15409,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_negate(&a,1,((C_word*)t0)[4]);
/* library.scm:2305: scheme#expt */
t5=*((C_word*)lf[552]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=t3;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k15407 in k15403 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15409(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_15409,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k15442 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15444(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_15444,c,av);}
a=C_alloc(11);
t2=C_a_i_exact_to_inexact(&a,1,((C_word*)t0)[2]);
/* library.scm:2311: log-expt */
f_15339(((C_word*)t0)[4],t1,t2);}

/* a15450 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15451(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15451,c,av);}
/* library.scm:2313: ##sys#exact-integer-nth-root/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[611]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[611]+1);
av2[1]=t1;
av2[2]=lf[613];
av2[3]=((C_word*)t0)[2];
av2[4]=C_u_i_ratnum_denom(((C_word*)t0)[3]);
tp(5,av2);}}

/* a15462 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15463(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_15463,c,av);}
a=C_alloc(4);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
/* library.scm:2316: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[550]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_u_i_ratnum_num(((C_word*)t0)[2]);
tp(4,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15483,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2318: scheme#exact->inexact */
t6=*((C_word*)lf[62]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* k15481 in a15462 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15483(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_15483,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15487,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2319: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15485 in k15481 in a15462 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15487(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_15487,c,av);}
a=C_alloc(4);
t2=C_a_i_flonum_expt(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k15505 in scheme#expt in k10751 in k8834 */
static void C_fcall f_15507(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_15507,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
/* library.scm:2324: slow-expt */
f_15353(((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t2=(C_truep(C_i_flonump(((C_word*)t0)[5]))?C_i_not(C_u_i_fpintegerp(((C_word*)t0)[5])):C_SCHEME_FALSE);
if(C_truep(t2)){
if(C_truep(C_i_negativep(((C_word*)t0)[4]))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15527,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2328: scheme#exact->inexact */
t4=*((C_word*)lf[62]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15535,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2330: scheme#exact->inexact */
t4=*((C_word*)lf[62]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}}
else{
if(C_truep(C_i_flonump(((C_word*)t0)[4]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15542,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2332: scheme#exact->inexact */
t4=*((C_word*)lf[62]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t3=C_i_inexactp(((C_word*)t0)[4]);
t4=(C_truep(t3)?t3:C_i_inexactp(((C_word*)t0)[5]));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15558,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15562,a[2]=t5,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2336: scheme#inexact->exact */
t7=*((C_word*)lf[540]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
/* library.scm:2337: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[550]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}}}}}

/* k15525 in k15505 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15527(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_15527,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15531,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2328: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15529 in k15525 in k15505 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15531(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15531,c,av);}
/* library.scm:2328: log-expt */
f_15339(((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k15533 in k15505 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15535(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_15535,c,av);}
a=C_alloc(4);
t2=C_a_i_flonum_expt(&a,2,t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k15540 in k15505 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15542(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_15542,c,av);}
a=C_alloc(4);
t2=C_a_i_flonum_expt(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k15556 in k15505 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15558(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_15558,c,av);}
/* library.scm:2336: scheme#exact->inexact */
t2=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k15560 in k15505 in scheme#expt in k10751 in k8834 */
static void C_ccall f_15562(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15562,c,av);}
/* library.scm:2336: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[550]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* ##sys#internal-gcd in k10751 in k8834 */
static void C_fcall f_15603(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_15603,4,t1,t2,t3,t4);}
a=C_alloc(5);
if(C_truep(C_i_exact_integerp(t3))){
if(C_truep(C_i_exact_integerp(t4))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_s_a_u_i_integer_gcd(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=(C_truep(C_i_flonump(t4))?C_u_i_fpintegerp(t4):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15636,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2345: scheme#inexact->exact */
t7=*((C_word*)lf[540]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
/* library.scm:2346: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t2;
tp(4,av2);}}}}
else{
t5=(C_truep(C_i_flonump(t3))?C_u_i_fpintegerp(t3):C_SCHEME_FALSE);
if(C_truep(t5)){
if(C_truep(C_i_flonump(t4))){
t6=C_a_i_flonum_gcd(&a,2,t3,t4);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
if(C_truep(C_i_exact_integerp(t4))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15665,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2352: scheme#inexact->exact */
t7=*((C_word*)lf[540]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
/* library.scm:2353: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t2;
tp(4,av2);}}}}
else{
/* library.scm:2354: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=t2;
tp(4,av2);}}}}

/* k15634 in ##sys#internal-gcd in k10751 in k8834 */
static void C_ccall f_15636(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_15636,c,av);}
a=C_alloc(5);
t2=C_s_a_u_i_integer_gcd(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2345: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15663 in ##sys#internal-gcd in k10751 in k8834 */
static void C_ccall f_15665(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_15665,c,av);}
a=C_alloc(5);
t2=C_s_a_u_i_integer_gcd(&a,2,t1,((C_word*)t0)[2]);
/* library.scm:2352: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* ##sys#gcd in k10751 in k8834 */
static void C_ccall f_15673(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15673,c,av);}
/* library.scm:2356: ##sys#internal-gcd */
f_15603(t1,lf[616],t2,t3);}

/* scheme#gcd in k10751 in k8834 */
static void C_ccall f_15679(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,4)))){
C_save_and_reclaim((void*)f_15679,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15699,a[2]=t7,a[3]=((C_word)li446),tmp=(C_word)a,a+=4,tmp));
t9=((C_word*)t7)[1];
f_15699(t9,t1,t4,t5);}}

/* loop in scheme#gcd in k10751 in k8834 */
static void C_fcall f_15699(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_15699,4,t0,t1,t2,t3);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t3))){
if(C_truep(C_i_integerp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* library.scm:2365: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[616];
tp(4,av2);}}}
else{
t4=C_slot(t3,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15724,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2367: ##sys#internal-gcd */
f_15603(t5,lf[616],t2,t4);}}

/* k15722 in loop in scheme#gcd in k10751 in k8834 */
static void C_ccall f_15724(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15724,c,av);}
/* library.scm:2367: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_15699(t2,((C_word*)t0)[3],t1,C_slot(((C_word*)t0)[4],C_fix(1)));}

/* ##sys#lcm in k10751 in k8834 */
static void C_ccall f_15730(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_15730,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15734,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2371: ##sys#internal-gcd */
f_15603(t4,lf[619],t2,t3);}

/* k15732 in ##sys#lcm in k10751 in k8834 */
static void C_ccall f_15734(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(45,c,1)))){
C_save_and_reclaim((void *)f_15734,c,av);}
a=C_alloc(45);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_s_a_i_quotient(&a,2,t2,t1);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_abs(&a,1,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#lcm in k10751 in k8834 */
static void C_ccall f_15744(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,4)))){
C_save_and_reclaim((void*)f_15744,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
if(C_truep(C_rest_nullp(c,2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_slot(t2,C_fix(0));
t4=C_slot(t2,C_fix(1));
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15764,a[2]=t6,a[3]=((C_word)li449),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_15764(t8,t1,t3,t4);}}

/* loop in scheme#lcm in k10751 in k8834 */
static void C_fcall f_15764(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_15764,4,t0,t1,t2,t3);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t3))){
if(C_truep(C_i_integerp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* library.scm:2381: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[364]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[364]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[619];
tp(4,av2);}}}
else{
t4=C_slot(t3,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15785,a[2]=t2,a[3]=t4,a[4]=((C_word*)t0)[2],a[5]=t1,a[6]=t3,tmp=(C_word)a,a+=7,tmp);
/* library.scm:2383: ##sys#internal-gcd */
f_15603(t5,lf[619],t2,t4);}}

/* k15783 in loop in scheme#lcm in k10751 in k8834 */
static void C_ccall f_15785(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,3)))){
C_save_and_reclaim((void *)f_15785,c,av);}
a=C_alloc(38);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_s_a_i_quotient(&a,2,t2,t1);
/* library.scm:2384: loop */
t4=((C_word*)((C_word*)t0)[4])[1];
f_15764(t4,((C_word*)t0)[5],t3,C_slot(((C_word*)t0)[6],C_fix(1)));}

/* ##sys#integer->string/recursive in k10751 in k8834 */
static void C_ccall f_15802(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_15802,c,av);}
a=C_alloc(6);
t5=C_fixnum_plus(t4,C_fix(1));
t6=C_fixnum_shift_right(t5,C_fix(1));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15809,a[2]=t2,a[3]=t6,a[4]=t3,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2391: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[550]+1);
av2[1]=t7;
av2[2]=t3;
av2[3]=t6;
tp(4,av2);}}

/* k15807 in ##sys#integer->string/recursive in k10751 in k8834 */
static void C_ccall f_15809(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_15809,c,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15814,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li452),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15820,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word)li453),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2390: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a15813 in k15807 in ##sys#integer->string/recursive in k10751 in k8834 */
static void C_ccall f_15814(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_15814,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_u_integer_quotient_and_remainder,a[2]=((C_word)li451),tmp=(C_word)a,a+=3,tmp);
/* library.scm:2390: g2851 */
t3=t2;{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t3))(4,av2);}}

/* a15819 in k15807 in ##sys#integer->string/recursive in k10751 in k8834 */
static void C_ccall f_15820(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_15820,c,av);}
a=C_alloc(6);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15824,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[622]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[622]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* k15822 in a15819 in k15807 in ##sys#integer->string/recursive in k10751 in k8834 */
static void C_ccall f_15824(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,3)))){
C_save_and_reclaim((void *)f_15824,c,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15827,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=C_s_a_i_abs(&a,1,((C_word*)t0)[4]);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[622]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[622]+1);
av2[1]=t2;
av2[2]=t3;
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}

/* k15825 in k15822 in a15819 in k15807 in ##sys#integer->string/recursive in k10751 in k8834 */
static void C_ccall f_15827(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_15827,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15834,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=C_block_size(t1);
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[385]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[385]+1);
av2[1]=t2;
av2[2]=C_fixnum_difference(((C_word*)t0)[4],t3);
av2[3]=C_make_character(48);
tp(4,av2);}}

/* k15832 in k15825 in k15822 in a15819 in k15807 in ##sys#integer->string/recursive in k10751 in k8834 */
static void C_ccall f_15834(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15834,c,av);}
/* library.scm:2396: scheme#string-append */
t2=*((C_word*)lf[422]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* ##sys#extended-number->string in k10751 in k8834 */
static void C_ccall f_15855(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_15855,c,av);}
a=C_alloc(5);
if(C_truep(C_i_ratnump(t2))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15869,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[622]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[622]+1);
av2[1]=t4;
av2[2]=C_u_i_ratnum_num(t2);
av2[3]=t3;
tp(4,av2);}}
else{
if(C_truep(C_i_cplxnump(t2))){
t4=C_u_i_cplxnum_real(t2);
t5=C_u_i_cplxnum_imag(t2);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15910,a[2]=t5,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[622]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[622]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=t3;
tp(4,av2);}}
else{
/* library.scm:2418: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[628];
tp(4,av2);}}}}

/* k15867 in ##sys#extended-number->string in k10751 in k8834 */
static void C_ccall f_15869(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_15869,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15873,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[622]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[622]+1);
av2[1]=t2;
av2[2]=C_u_i_ratnum_denom(((C_word*)t0)[3]);
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}

/* k15871 in k15867 in ##sys#extended-number->string in k10751 in k8834 */
static void C_ccall f_15873(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15873,c,av);}
/* library.scm:2406: string-append */
t2=*((C_word*)lf[422]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[624];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k15908 in ##sys#extended-number->string in k10751 in k8834 */
static void C_ccall f_15910(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_15910,c,av);}
a=C_alloc(5);
t2=(C_truep(C_i_finitep(((C_word*)t0)[2]))?(C_truep(C_i_positivep(((C_word*)t0)[2]))?lf[625]:lf[626]):lf[626]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15918,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[622]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[622]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}

/* k15916 in k15908 in ##sys#extended-number->string in k10751 in k8834 */
static void C_ccall f_15918(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15918,c,av);}
/* library.scm:2413: string-append */
t2=*((C_word*)lf[422]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
av2[5]=lf[627];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k15945 in safe-exponent in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_15947(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(44,c,1)))){
C_save_and_reclaim((void *)f_15947,c,av);}
a=C_alloc(44);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=C_a_i_exact_to_inexact(&a,1,t2);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k15948 in safe-exponent in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_15950(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,3)))){
C_save_and_reclaim((void *)f_15950,c,av);}
a=C_alloc(13);
t2=C_fixnum_difference(C_i_integer_length(((C_word*)t0)[2]),C_i_integer_length(t1));
t3=C_fixnum_difference(t2,*((C_word*)lf[434]+1));
t4=t3;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
if(C_truep(C_fixnum_lessp(((C_word*)t5)[1],C_fix(0)))){
t6=C_fixnum_negate(((C_word*)t5)[1]);
t7=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],t6);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15965,a[2]=t5,a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2437: round-quotient */
f_16029(t8,t7,t1);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16004,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2444: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[550]+1);
av2[1]=t6;
av2[2]=C_fix(10);
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}}

/* k15963 in k15948 in safe-exponent in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_15965(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(44,c,3)))){
C_save_and_reclaim((void *)f_15965,c,av);}
a=C_alloc(44);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15968,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=((C_word*)t3)[1];
t6=C_i_integer_length(t5);
t7=*((C_word*)lf[434]+1);
if(C_truep(C_fixnum_greaterp(t6,*((C_word*)lf[434]+1)))){
t8=C_fixnum_plus(C_fix(1),((C_word*)((C_word*)t0)[2])[1]);
t9=C_set_block_item(((C_word*)t0)[2],0,t8);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15986,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t11=C_s_a_i_times(&a,2,((C_word*)t0)[4],C_fix(2));
/* library.scm:2441: round-quotient */
f_16029(t10,((C_word*)t0)[5],t11);}
else{
t8=t4;
f_15968(t8,C_SCHEME_UNDEFINED);}}

/* k15966 in k15963 in k15948 in safe-exponent in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_15968(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_15968,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15975,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2442: scheme#exact->inexact */
t3=*((C_word*)lf[62]+1);{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[4])[1];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k15973 in k15966 in k15963 in k15948 in safe-exponent in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_15975(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_15975,c,av);}
a=C_alloc(6);
t2=((C_word*)((C_word*)t0)[2])[1];
t3=C_a_i_bytevector(&a,1,C_fix(4));
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=stub2905(t3,C_i_foreign_flonum_argumentp(t1),C_i_foreign_fixnum_argumentp(t2));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k15984 in k15963 in k15948 in safe-exponent in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_15986(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15986,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];
f_15968(t3,t2);}

/* k16002 in k15948 in safe-exponent in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16004(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_16004,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* round-quotient in k10751 in k8834 */
static void C_fcall f_16029(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(63,0,3)))){
C_save_and_reclaim_args((void *)trf_16029,3,t1,t2,t3);}
a=C_alloc(63);
t4=C_s_a_u_i_integer_quotient(&a,2,t2,t3);
t5=(C_truep(C_i_evenp(t4))?*((C_word*)lf[73]+1):*((C_word*)lf[75]+1));
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_16044,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=C_s_a_i_remainder(&a,2,t2,t3);
t8=C_s_a_i_abs(&a,1,t7);
t9=C_s_a_i_times(&a,2,t8,C_fix(2));
t10=C_s_a_i_abs(&a,1,t3);
/* library.scm:2451: g2918 */
t11=t5;{
C_word av2[4];
av2[0]=t11;
av2[1]=t6;
av2[2]=t9;
av2[3]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(4,av2);}}

/* k16042 in round-quotient in k10751 in k8834 */
static void C_ccall f_16044(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_16044,c,av);}
a=C_alloc(29);
if(C_truep(t1)){
t2=C_eqp(C_i_negativep(((C_word*)t0)[2]),C_i_negativep(((C_word*)t0)[3]));
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(t2)?C_s_a_i_plus(&a,2,((C_word*)t0)[5],C_fix(1)):C_s_a_i_plus(&a,2,((C_word*)t0)[5],C_fix(-1)));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16072(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(87,0,5)))){
C_save_and_reclaim_args((void *)trf_16072,5,t1,t2,t3,t4,t5);}
a=C_alloc(87);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_SCHEME_UNDEFINED;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=C_set_block_item(t8,0,C_SCHEME_FALSE);
t14=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16076,a[2]=t6,a[3]=t8,a[4]=((C_word)li457),tmp=(C_word)a,a+=5,tmp));
t15=C_set_block_item(t12,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16090,a[2]=t6,a[3]=((C_word)li458),tmp=(C_word)a,a+=4,tmp));
t16=C_block_size(t3);
t17=C_fixnum_difference(t2,C_fix(1));
t18=C_fixnum_plus(C_fix(48),t17);
t19=C_make_character(C_unfix(t18));
t20=C_fixnum_difference(t2,C_fix(11));
t21=C_fixnum_plus(C_fix(97),t20);
t22=C_make_character(C_unfix(t21));
t23=C_fixnum_difference(t2,C_fix(11));
t24=C_fixnum_plus(C_fix(65),t23);
t25=C_make_character(C_unfix(t24));
t26=C_SCHEME_FALSE;
t27=(*a=C_VECTOR_TYPE|1,a[1]=t26,tmp=(C_word)a,a+=2,tmp);
t28=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_16170,a[2]=t16,a[3]=t3,a[4]=t2,a[5]=t19,a[6]=t22,a[7]=t25,a[8]=((C_word)li460),tmp=(C_word)a,a+=9,tmp);
t29=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16278,a[2]=t16,a[3]=t3,a[4]=((C_word)li462),tmp=(C_word)a,a+=5,tmp);
t30=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_16328,a[2]=t3,a[3]=t2,a[4]=t27,a[5]=t10,a[6]=t29,a[7]=t28,a[8]=((C_word)li463),tmp=(C_word)a,a+=9,tmp);
t31=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16384,a[2]=t16,a[3]=t3,a[4]=t2,a[5]=t28,a[6]=((C_word)li464),tmp=(C_word)a,a+=7,tmp);
t32=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_16442,a[2]=t16,a[3]=t3,a[4]=t12,a[5]=t31,a[6]=t30,a[7]=((C_word)li465),tmp=(C_word)a,a+=8,tmp);
t33=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_16656,a[2]=t10,a[3]=t32,a[4]=t3,a[5]=t2,a[6]=t16,a[7]=t12,a[8]=t31,a[9]=t27,a[10]=t6,a[11]=t30,a[12]=((C_word)li466),tmp=(C_word)a,a+=13,tmp);
t34=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_17002,a[2]=t16,a[3]=t3,a[4]=t33,a[5]=t10,a[6]=((C_word)li467),tmp=(C_word)a,a+=7,tmp);
t35=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_17242,a[2]=t6,a[3]=t8,a[4]=t1,a[5]=t3,a[6]=t16,a[7]=t4,a[8]=t27,a[9]=t34,tmp=(C_word)a,a+=10,tmp);
/* library.scm:2637: scan-real */
t36=t34;
f_17002(t36,t35,t4);}

/* go-inexact! in ##sys#string->compnum in k10751 in k8834 */
static C_word C_fcall f_16076(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;{}
t2=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[631]);
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_mutate(((C_word *)((C_word*)t0)[2])+1,lf[632]);
t4=((C_word*)((C_word*)t0)[3])[1];
if(C_truep(t4)){
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t4);
return(t5);}
else{
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
return(t5);}}}

/* safe-exponent in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16090(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,0,3)))){
C_save_and_reclaim_args((void *)trf_16090,4,t0,t1,t2,t3);}
a=C_alloc(12);
if(C_truep(t3)){
if(C_truep(C_i_not(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_i_greaterp(t3,C_fix(10000)))){
t4=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[632]);
if(C_truep(t4)){
if(C_truep(C_i_zerop(t2))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=lf[523];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=C_i_greaterp(t2,lf[523]);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?lf[633]:lf[634]);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t4=C_fixnum_negate(C_fix(10000));
if(C_truep(C_i_lessp(t3,t4))){
t5=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[632]);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?lf[523]:C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t5=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[632]);
if(C_truep(t5)){
if(C_truep(C_i_not(C_i_negativep(t3)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15947,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2430: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[550]+1);
av2[1]=t6;
av2[2]=C_fix(10);
av2[3]=t3;
tp(4,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15950,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=C_s_a_i_abs(&a,1,t3);
/* library.scm:2431: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[550]+1);
av2[1]=t6;
av2[2]=C_fix(10);
av2[3]=t7;
tp(4,av2);}}}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16150,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2476: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[550]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[550]+1);
av2[1]=t6;
av2[2]=C_fix(10);
av2[3]=t3;
tp(4,av2);}}}}}}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k16148 in safe-exponent in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16150(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_16150,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scan-digits in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16170(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,0,3)))){
C_save_and_reclaim_args((void *)trf_16170,3,t0,t1,t2);}
a=C_alloc(13);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_16176,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t4,a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word)li459),tmp=(C_word)a,a+=11,tmp));
t6=((C_word*)t4)[1];
f_16176(t6,t1,t2);}

/* lp in scan-digits in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16176(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_16176,3,t0,t1,t2);}
a=C_alloc(6);
t3=C_eqp(t2,((C_word*)t0)[2]);
if(C_truep(t3)){
t4=C_fixnum_greaterp(t2,((C_word*)t0)[3]);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_a_i_cons(&a,2,t2,C_SCHEME_FALSE):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_subchar(((C_word*)t0)[4],t2);
if(C_truep(C_fixnum_less_or_equal_p(((C_word*)t0)[5],C_fix(10)))){
t5=C_i_char_greater_or_equal_p(t4,C_make_character(48));
t6=(C_truep(t5)?C_u_i_char_less_or_equal_p(t4,((C_word*)t0)[6]):C_SCHEME_FALSE);
if(C_truep(t6)){
/* library.scm:2500: lp */
t10=t1;
t11=C_fixnum_plus(t2,C_fix(1));
t1=t10;
t2=t11;
goto loop;}
else{
t7=C_fixnum_greaterp(t2,((C_word*)t0)[3]);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=(C_truep(t7)?C_a_i_cons(&a,2,t2,t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}
else{
t5=C_i_char_greater_or_equal_p(t4,C_make_character(48));
t6=(C_truep(t5)?C_u_i_char_less_or_equal_p(t4,C_make_character(57)):C_SCHEME_FALSE);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_16239,a[2]=((C_word*)t0)[7],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t8=t7;
f_16239(t8,t6);}
else{
t8=(C_truep(C_u_i_char_greater_or_equal_p(t4,C_make_character(97)))?C_u_i_char_less_or_equal_p(t4,((C_word*)t0)[8]):C_SCHEME_FALSE);
t9=t7;
f_16239(t9,(C_truep(t8)?t8:(C_truep(C_u_i_char_greater_or_equal_p(t4,C_make_character(65)))?C_u_i_char_less_or_equal_p(t4,((C_word*)t0)[9]):C_SCHEME_FALSE)));}}}}

/* k16237 in lp in scan-digits in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16239(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,2)))){
C_save_and_reclaim_args((void *)trf_16239,2,t0,t1);}
a=C_alloc(3);
if(C_truep(t1)){
/* library.scm:2505: lp */
t2=((C_word*)((C_word*)t0)[2])[1];
f_16176(t2,((C_word*)t0)[3],C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}
else{
t2=C_fixnum_greaterp(((C_word*)t0)[4],((C_word*)t0)[5]);
t3=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t3;
av2[1]=(C_truep(t2)?C_a_i_cons(&a,2,((C_word*)t0)[4],((C_word*)t0)[4]):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scan-hashes in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16278(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,3)))){
C_save_and_reclaim_args((void *)trf_16278,3,t0,t1,t2);}
a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16284,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word)li461),tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_16284(t6,t1,t2);}

/* lp in scan-hashes in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16284(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,2)))){
C_save_and_reclaim_args((void *)trf_16284,3,t0,t1,t2);}
a=C_alloc(3);
t3=C_eqp(t2,((C_word*)t0)[2]);
if(C_truep(t3)){
t4=C_fixnum_greaterp(t2,((C_word*)t0)[3]);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_a_i_cons(&a,2,t2,C_SCHEME_FALSE):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_subchar(((C_word*)t0)[4],t2);
t5=C_eqp(t4,C_make_character(35));
if(C_truep(t5)){
/* library.scm:2514: lp */
t8=t1;
t9=C_fixnum_plus(t2,C_fix(1));
t1=t8;
t2=t9;
goto loop;}
else{
t6=C_fixnum_greaterp(t2,((C_word*)t0)[3]);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(C_truep(t6)?C_a_i_cons(&a,2,t2,t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* scan-digits+hashes in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16328(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,2)))){
C_save_and_reclaim_args((void *)trf_16328,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_16332,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=t1,a[9]=((C_word*)t0)[6],a[10]=t4,tmp=(C_word)a,a+=11,tmp);
if(C_truep(C_i_not(((C_word*)((C_word*)t0)[4])[1]))){
/* library.scm:2518: scan-digits */
t6=((C_word*)t0)[7];
f_16170(t6,t5,t2);}
else{
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
f_16332(2,av2);}}}

/* k16330 in scan-digits+hashes in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16332(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_16332,c,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_16335,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
if(C_truep(t1)){
if(C_truep(C_i_cdr(t1))){
/* library.scm:2520: scan-hashes */
t3=((C_word*)t0)[9];
f_16278(t3,t2,C_u_i_cdr(t1));}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_16335(2,av2);}}}
else{
if(C_truep(((C_word*)t0)[10])){
/* library.scm:2521: scan-hashes */
t3=((C_word*)t0)[9];
f_16278(t3,t2,((C_word*)t0)[3]);}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_16335(2,av2);}}}}

/* k16333 in k16330 in scan-digits+hashes in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16335(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,1)))){
C_save_and_reclaim((void *)f_16335,c,av);}
a=C_alloc(9);
t2=(C_truep(t1)?t1:((C_word*)t0)[2]);
if(C_truep(t2)){
t3=C_i_car(t2);
t4=C_s_a_i_digits_to_integer(&a,5,((C_word*)t0)[3],((C_word*)t0)[4],t3,((C_word*)t0)[5],((C_word*)t0)[6]);
if(C_truep(t4)){
if(C_truep(t1)){
t5=C_set_block_item(((C_word*)t0)[7],0,C_SCHEME_TRUE);
t6=(
/* library.scm:2529: go-inexact! */
  f_16076(((C_word*)((C_word*)t0)[8])[1],((C_word*)t0)[6])
);
t7=C_u_i_cdr(t2);
t8=((C_word*)t0)[9];{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_a_i_cons(&a,2,t4,t7);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t5=C_u_i_cdr(t2);
t6=((C_word*)t0)[9];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_a_i_cons(&a,2,t4,t5);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}
else{
t5=((C_word*)t0)[9];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t3=((C_word*)t0)[9];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scan-exponent in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16384(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,2)))){
C_save_and_reclaim_args((void *)trf_16384,3,t0,t1,t2);}
a=C_alloc(7);
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[2]))){
t3=C_subchar(((C_word*)t0)[3],t2);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16399,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t5=C_eqp(t3,C_make_character(43));
if(C_truep(t5)){
t6=t4;
f_16399(t6,lf[636]);}
else{
t6=C_eqp(t3,C_make_character(45));
t7=t4;
f_16399(t7,(C_truep(t6)?lf[635]:C_SCHEME_FALSE));}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k16397 in scan-exponent in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16399(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,2)))){
C_save_and_reclaim_args((void *)trf_16399,2,t0,t1);}
a=C_alloc(7);
t2=(C_truep(t1)?C_fixnum_plus(((C_word*)t0)[2],C_fix(1)):((C_word*)t0)[2]);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16408,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* library.scm:2537: scan-digits */
t4=((C_word*)t0)[6];
f_16170(t4,t3,t2);}
else{
t3=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k16406 in k16397 in scan-exponent in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16408(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,1)))){
C_save_and_reclaim((void *)f_16408,c,av);}
a=C_alloc(9);
if(C_truep(t1)){
t2=C_i_car(t1);
t3=C_eqp(((C_word*)t0)[2],lf[635]);
t4=C_s_a_i_digits_to_integer(&a,5,((C_word*)t0)[3],((C_word*)t0)[4],t2,((C_word*)t0)[5],t3);
t5=C_u_i_cdr(t1);
t6=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_a_i_cons(&a,2,t4,t5);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t2=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* scan-decimal-tail in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16442(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,4)))){
C_save_and_reclaim_args((void *)trf_16442,5,t0,t1,t2,t3,t4);}
a=C_alloc(9);
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[2]))){
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_16452,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=t1,a[6]=((C_word*)t0)[4],a[7]=t4,a[8]=((C_word*)t0)[5],tmp=(C_word)a,a+=9,tmp);
/* library.scm:2545: scan-digits+hashes */
t6=((C_word*)t0)[6];
f_16328(t6,t5,t2,t3,t4);}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k16450 in scan-decimal-tail in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16452(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,2)))){
C_save_and_reclaim((void *)f_16452,c,av);}
a=C_alloc(11);
t2=(C_truep(t1)?C_i_cdr(t1):((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_16461,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[2],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],tmp=(C_word)a,a+=11,tmp);
if(C_truep(((C_word*)t0)[7])){
t4=t3;
f_16461(t4,((C_word*)t0)[7]);}
else{
t4=C_i_not(t2);
t5=t3;
f_16461(t5,(C_truep(t4)?t4:C_fixnum_greaterp(t2,((C_word*)t0)[2])));}}

/* k16459 in k16450 in scan-decimal-tail in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16461(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,2)))){
C_save_and_reclaim_args((void *)trf_16461,2,t0,t1);}
a=C_alloc(10);
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[2])?C_subchar(((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE);
t3=C_eqp(t2,C_make_character(101));
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_16473,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],tmp=(C_word)a,a+=10,tmp);
if(C_truep(t3)){
t5=t4;
f_16473(t5,t3);}
else{
t5=C_eqp(t2,C_make_character(115));
if(C_truep(t5)){
t6=t4;
f_16473(t6,t5);}
else{
t6=C_eqp(t2,C_make_character(102));
if(C_truep(t6)){
t7=t4;
f_16473(t7,t6);}
else{
t7=C_eqp(t2,C_make_character(100));
if(C_truep(t7)){
t8=t4;
f_16473(t8,t7);}
else{
t8=C_eqp(t2,C_make_character(108));
if(C_truep(t8)){
t9=t4;
f_16473(t9,t8);}
else{
t9=C_eqp(t2,C_make_character(69));
if(C_truep(t9)){
t10=t4;
f_16473(t10,t9);}
else{
t10=C_eqp(t2,C_make_character(83));
if(C_truep(t10)){
t11=t4;
f_16473(t11,t10);}
else{
t11=C_eqp(t2,C_make_character(70));
if(C_truep(t11)){
t12=t4;
f_16473(t12,t11);}
else{
t12=C_eqp(t2,C_make_character(68));
t13=t4;
f_16473(t13,(C_truep(t12)?t12:C_eqp(t2,C_make_character(76))));}}}}}}}}}
else{
t2=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16471 in k16459 in k16450 in scan-decimal-tail in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16473(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_16473,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[2],((C_word*)t0)[3]))){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16482,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],tmp=(C_word)a,a+=7,tmp);
/* library.scm:2553: scan-exponent */
t3=((C_word*)t0)[9];
f_16384(t3,t2,C_fixnum_plus(((C_word*)t0)[3],C_fix(1)));}
else{
t2=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}
else{
t2=(C_truep(((C_word*)t0)[3])?((C_word*)t0)[3]:((C_word*)t0)[2]);
t3=(C_truep(((C_word*)t0)[4])?C_fixnum_difference(((C_word*)t0)[7],t2):C_SCHEME_FALSE);
t4=(C_truep(((C_word*)t0)[4])?C_i_car(((C_word*)t0)[4]):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16548,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2563: safe-exponent */
t6=((C_word*)((C_word*)t0)[6])[1];
f_16090(t6,t5,t4,t3);}}

/* k16480 in k16471 in k16459 in k16450 in scan-decimal-tail in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16482(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_16482,c,av);}
a=C_alloc(8);
if(C_truep(t1)){
t2=C_i_car(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_16494,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t2,a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* library.scm:2555: safe-exponent */
t4=((C_word*)((C_word*)t0)[4])[1];
f_16090(t4,t3,((C_word*)t0)[6],t2);}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16492 in k16480 in k16471 in k16459 in k16450 in scan-decimal-tail in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16494(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_16494,c,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16500,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=C_i_cdr(((C_word*)t0)[2]);
t4=t2;
f_16500(t4,C_fixnum_difference(((C_word*)t0)[6],C_fixnum_difference(t3,((C_word*)t0)[7])));}
else{
t3=t2;
f_16500(t3,C_SCHEME_FALSE);}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16498 in k16492 in k16480 in k16471 in k16459 in k16450 in scan-decimal-tail in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16500(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_16500,2,t0,t1);}
a=C_alloc(5);
t2=(C_truep(((C_word*)t0)[2])?C_i_car(((C_word*)t0)[2]):C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16506,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2558: safe-exponent */
t4=((C_word*)((C_word*)t0)[6])[1];
f_16090(t4,t3,t2,t1);}

/* k16504 in k16498 in k16492 in k16480 in k16471 in k16459 in k16450 in scan-decimal-tail in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16506(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(32,c,1)))){
C_save_and_reclaim((void *)f_16506,c,av);}
a=C_alloc(32);
if(C_truep(t1)){
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_cdr(((C_word*)t0)[3]);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_u_i_cdr(((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[2],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k16546 in k16471 in k16459 in k16450 in scan-decimal-tail in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16548(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(32,c,1)))){
C_save_and_reclaim((void *)f_16548,c,av);}
a=C_alloc(32);
t2=(C_truep(((C_word*)t0)[2])?((C_word*)t0)[2]:C_fix(0));
if(C_truep(t1)){
t3=C_s_a_i_plus(&a,2,t2,t1);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t3,((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,t2,((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* scan-ureal in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16656(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,0,2)))){
C_save_and_reclaim_args((void *)trf_16656,4,t0,t1,t2,t3);}
a=C_alloc(15);
t4=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_16663,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t2,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],a[11]=((C_word*)t0)[8],a[12]=((C_word*)t0)[9],a[13]=((C_word*)t0)[10],a[14]=((C_word*)t0)[11],tmp=(C_word)a,a+=15,tmp);
t5=C_fixnum_plus(t2,C_fix(1));
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[6],t5))){
t6=C_eqp(((C_word*)t0)[5],C_fix(10));
t7=t4;
f_16663(t7,(C_truep(t6)?C_eqp(C_subchar(((C_word*)t0)[4],t2),C_make_character(46)):C_SCHEME_FALSE));}
else{
t6=t4;
f_16663(t6,C_SCHEME_FALSE);}}

/* k16661 in scan-ureal in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16663(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,0,4)))){
C_save_and_reclaim_args((void *)trf_16663,2,t0,t1);}
a=C_alloc(14);
if(C_truep(t1)){
t2=(
/* library.scm:2571: go-inexact! */
  f_16076(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3])
);
/* library.scm:2572: scan-decimal-tail */
t3=((C_word*)t0)[4];
f_16442(t3,((C_word*)t0)[5],C_fixnum_plus(((C_word*)t0)[6],C_fix(1)),((C_word*)t0)[3],C_SCHEME_FALSE);}
else{
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_16676,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
/* library.scm:2573: scan-digits+hashes */
t3=((C_word*)t0)[14];
f_16328(t3,t2,((C_word*)t0)[6],((C_word*)t0)[3],C_SCHEME_FALSE);}}

/* k16674 in k16661 in scan-ureal in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16676(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,4)))){
C_save_and_reclaim((void *)f_16676,c,av);}
a=C_alloc(14);
if(C_truep(t1)){
t2=C_i_cdr(t1);
t3=(C_truep(t2)?C_subchar(((C_word*)t0)[2],C_u_i_cdr(t1)):C_SCHEME_FALSE);
t4=C_eqp(t3,C_make_character(46));
if(C_truep(t4)){
t5=(
/* library.scm:2576: go-inexact! */
  f_16076(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[4])
);
t6=C_eqp(((C_word*)t0)[5],C_fix(10));
if(C_truep(t6)){
t7=C_fixnum_plus(C_u_i_cdr(t1),C_fix(1));
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[6],t7))){
/* library.scm:2579: scan-decimal-tail */
t8=((C_word*)t0)[7];
f_16442(t8,((C_word*)t0)[8],C_fixnum_plus(C_u_i_cdr(t1),C_fix(1)),((C_word*)t0)[4],C_u_i_car(t1));}
else{
t8=C_u_i_car(t1);
t9=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t9;
av2[1]=C_a_i_cons(&a,2,t8,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}
else{
t7=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}
else{
t5=C_eqp(t3,C_make_character(101));
t6=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_16734,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t1,a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=t3,a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[12],a[13]=((C_word*)t0)[13],tmp=(C_word)a,a+=14,tmp);
if(C_truep(t5)){
t7=t6;
f_16734(t7,t5);}
else{
t7=C_eqp(t3,C_make_character(115));
if(C_truep(t7)){
t8=t6;
f_16734(t8,t7);}
else{
t8=C_eqp(t3,C_make_character(102));
if(C_truep(t8)){
t9=t6;
f_16734(t9,t8);}
else{
t9=C_eqp(t3,C_make_character(100));
if(C_truep(t9)){
t10=t6;
f_16734(t10,t9);}
else{
t10=C_eqp(t3,C_make_character(108));
if(C_truep(t10)){
t11=t6;
f_16734(t11,t10);}
else{
t11=C_eqp(t3,C_make_character(69));
if(C_truep(t11)){
t12=t6;
f_16734(t12,t11);}
else{
t12=C_eqp(t3,C_make_character(83));
if(C_truep(t12)){
t13=t6;
f_16734(t13,t12);}
else{
t13=C_eqp(t3,C_make_character(70));
if(C_truep(t13)){
t14=t6;
f_16734(t14,t13);}
else{
t14=C_eqp(t3,C_make_character(68));
t15=t6;
f_16734(t15,(C_truep(t14)?t14:C_eqp(t3,C_make_character(76))));}}}}}}}}}}
else{
t2=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16732 in k16674 in k16661 in scan-ureal in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_16734(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,4)))){
C_save_and_reclaim_args((void *)trf_16734,2,t0,t1);}
a=C_alloc(5);
if(C_truep(t1)){
t2=(
/* library.scm:2583: go-inexact! */
  f_16076(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3])
);
t3=C_eqp(((C_word*)t0)[4],C_fix(10));
if(C_truep(t3)){
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[5],C_u_i_cdr(((C_word*)t0)[6])))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16752,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2586: scan-exponent */
t5=((C_word*)t0)[9];
f_16384(t5,t4,C_fixnum_plus(C_u_i_cdr(((C_word*)t0)[6]),C_fix(1)));}
else{
t4=((C_word*)t0)[7];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t4=((C_word*)t0)[7];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t2=C_eqp(((C_word*)t0)[10],C_make_character(47));
if(C_truep(t2)){
t3=C_set_block_item(((C_word*)t0)[11],0,C_SCHEME_FALSE);
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[5],C_u_i_cdr(((C_word*)t0)[6])))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16798,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[12],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2593: scan-digits+hashes */
t5=((C_word*)t0)[13];
f_16328(t5,t4,C_fixnum_plus(C_u_i_cdr(((C_word*)t0)[6]),C_fix(1)),C_SCHEME_FALSE,C_SCHEME_FALSE);}
else{
t4=((C_word*)t0)[7];{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t3=((C_word*)t0)[7];{
C_word av2[2];
av2[0]=t3;
av2[1]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}}

/* k16750 in k16732 in k16674 in k16661 in scan-ureal in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16752(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_16752,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_u_i_car(((C_word*)t0)[2]);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16762,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2588: safe-exponent */
t4=((C_word*)((C_word*)t0)[4])[1];
f_16090(t4,t3,t2,C_i_car(t1));}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16760 in k16750 in k16732 in k16674 in k16661 in scan-ureal in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16762(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_16762,c,av);}
a=C_alloc(3);
if(C_truep(t1)){
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16796 in k16732 in k16674 in k16661 in scan-ureal in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_16798,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_u_i_car(((C_word*)t0)[2]);
if(C_truep(t2)){
t3=C_i_car(t1);
if(C_truep(t3)){
t4=C_eqp(t3,C_fix(0));
if(C_truep(C_i_not(t4))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16824,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2597: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[548]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[548]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=t3;
tp(4,av2);}}
else{
t5=C_eqp(((C_word*)((C_word*)t0)[4])[1],lf[631]);
if(C_truep(C_i_not(t5))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16835,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2601: chicken.base#signum */
t7=*((C_word*)lf[185]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
t6=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}}
else{
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k16822 in k16796 in k16732 in k16674 in k16661 in scan-ureal in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16824(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_16824,c,av);}
a=C_alloc(3);
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k16833 in k16796 in k16732 in k16674 in k16661 in scan-ureal in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_16835(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_16835,c,av);}
a=C_alloc(7);
switch(t1){
case C_fix(-1):
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,lf[634],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
case C_fix(0):
t2=C_flonum(&a,C_ub_i_flonum_quotient((double)0.0,(double)0.0));
t3=C_u_i_cdr(((C_word*)t0)[2]);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}
case C_fix(1):
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,lf[633],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
default:
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* scan-real in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_17002(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_17002,3,t0,t1,t2);}
a=C_alloc(8);
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[2]))){
t3=C_subchar(((C_word*)t0)[3],t2);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_17017,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
t5=C_eqp(t3,C_make_character(43));
if(C_truep(t5)){
t6=t4;
f_17017(t6,lf[636]);}
else{
t6=C_eqp(t3,C_make_character(45));
t7=t4;
f_17017(t7,(C_truep(t6)?lf[635]:C_SCHEME_FALSE));}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k17015 in scan-real in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_17017(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_17017,2,t0,t1);}
a=C_alloc(11);
t2=(C_truep(t1)?C_fixnum_plus(((C_word*)t0)[2],C_fix(1)):((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[3]))){
t3=C_subchar(((C_word*)t0)[4],t2);
t4=C_eqp(t3,C_make_character(105));
t5=(C_truep(t4)?t4:C_eqp(t3,C_make_character(73)));
if(C_truep(t5)){
if(C_truep(t1)){
t6=C_fixnum_plus(t2,C_fix(1));
t7=C_eqp(t6,((C_word*)t0)[3]);
if(C_truep(t7)){
t8=C_eqp(t1,lf[635]);
t9=(C_truep(t8)?C_a_i_cons(&a,2,C_fix(-1),t2):C_a_i_cons(&a,2,C_fix(1),t2));
if(C_truep(t9)){
t10=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t10;
av2[1]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}
else{
/* library.scm:2626: scan-ureal */
t10=((C_word*)t0)[6];
f_16656(t10,((C_word*)t0)[5],t2,C_eqp(t1,lf[635]));}}
else{
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_17075,a[2]=((C_word*)t0)[7],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t9=C_fixnum_plus(t2,C_fix(5));
if(C_truep(C_fixnum_less_or_equal_p(t9,((C_word*)t0)[3]))){
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17116,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2620: scheme#substring */
t11=*((C_word*)lf[402]+1);{
C_word av2[5];
av2[0]=t11;
av2[1]=t10;
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
av2[4]=C_fixnum_plus(t2,C_fix(5));
((C_proc)(void*)(*((C_word*)t11+1)))(5,av2);}}
else{
t10=t8;
f_17075(t10,C_SCHEME_FALSE);}}}
else{
/* library.scm:2626: scan-ureal */
t6=((C_word*)t0)[6];
f_16656(t6,((C_word*)t0)[5],t2,C_eqp(t1,lf[635]));}}
else{
t6=C_eqp(t3,C_make_character(110));
t7=(C_truep(t6)?t6:C_eqp(t3,C_make_character(78)));
if(C_truep(t7)){
if(C_truep(t1)){
t8=C_fixnum_plus(t2,C_fix(5));
if(C_truep(C_fixnum_less_or_equal_p(t8,((C_word*)t0)[3]))){
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_17194,a[2]=((C_word*)t0)[7],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* library.scm:2630: scheme#substring */
t10=*((C_word*)lf[402]+1);{
C_word av2[5];
av2[0]=t10;
av2[1]=t9;
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
av2[4]=C_fixnum_plus(t2,C_fix(5));
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}
else{
/* library.scm:2635: scan-ureal */
t9=((C_word*)t0)[6];
f_16656(t9,((C_word*)t0)[5],t2,C_eqp(t1,lf[635]));}}
else{
/* library.scm:2635: scan-ureal */
t8=((C_word*)t0)[6];
f_16656(t8,((C_word*)t0)[5],t2,C_eqp(t1,lf[635]));}}
else{
/* library.scm:2636: scan-ureal */
t8=((C_word*)t0)[6];
f_16656(t8,((C_word*)t0)[5],t2,C_eqp(t1,lf[635]));}}}
else{
t3=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k17073 in k17015 in scan-real in ##sys#string->compnum in k10751 in k8834 */
static void C_fcall f_17075(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_17075,2,t0,t1);}
a=C_alloc(3);
if(C_truep(t1)){
t2=(
/* library.scm:2621: go-inexact! */
  f_16076(((C_word*)((C_word*)t0)[2])[1],C_eqp(((C_word*)t0)[3],lf[635]))
);
t3=C_eqp(((C_word*)t0)[3],lf[635]);
t4=(C_truep(t3)?lf[634]:lf[633]);
t5=C_fixnum_plus(((C_word*)t0)[4],C_fix(5));
if(C_truep(C_fixnum_lessp(t5,((C_word*)t0)[5]))){
t6=C_fixnum_plus(((C_word*)t0)[4],C_fix(5));
t7=C_a_i_cons(&a,2,t4,t6);
if(C_truep(t7)){
t8=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
/* library.scm:2626: scan-ureal */
t8=((C_word*)t0)[7];
f_16656(t8,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[635]));}}
else{
t6=C_a_i_cons(&a,2,t4,C_SCHEME_FALSE);
if(C_truep(t6)){
t7=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:2626: scan-ureal */
t7=((C_word*)t0)[7];
f_16656(t7,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[635]));}}}
else{
/* library.scm:2626: scan-ureal */
t2=((C_word*)t0)[7];
f_16656(t2,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[635]));}}

/* k17114 in k17015 in scan-real in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_17116(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17116,c,av);}
t2=((C_word*)t0)[2];
f_17075(t2,C_i_string_ci_equal_p(t1,lf[637]));}

/* k17192 in k17015 in scan-real in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_17194(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_17194,c,av);}
a=C_alloc(7);
if(C_truep(C_i_string_ci_equal_p(t1,lf[638]))){
t2=(
/* library.scm:2631: go-inexact! */
  f_16076(((C_word*)((C_word*)t0)[2])[1],C_eqp(((C_word*)t0)[3],lf[635]))
);
t3=C_flonum(&a,C_ub_i_flonum_quotient((double)0.0,(double)0.0));
t4=C_fixnum_plus(((C_word*)t0)[4],C_fix(5));
if(C_truep(C_fixnum_lessp(t4,((C_word*)t0)[5]))){
t5=C_fixnum_plus(((C_word*)t0)[4],C_fix(5));
t6=C_a_i_cons(&a,2,t3,t5);
if(C_truep(t6)){
t7=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:2635: scan-ureal */
t7=((C_word*)t0)[7];
f_16656(t7,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[635]));}}
else{
t5=C_a_i_cons(&a,2,t3,C_SCHEME_FALSE);
if(C_truep(t5)){
t6=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
/* library.scm:2635: scan-ureal */
t6=((C_word*)t0)[7];
f_16656(t6,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[635]));}}}
else{
/* library.scm:2635: scan-ureal */
t2=((C_word*)t0)[7];
f_16656(t2,((C_word*)t0)[6],((C_word*)t0)[4],C_eqp(((C_word*)t0)[3],lf[635]));}}

/* k17240 in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_17242(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_17242,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17245,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t1)){
t3=C_i_cdr(t1);
t4=(C_truep(t3)?C_subchar(((C_word*)t0)[5],C_u_i_cdr(t1)):C_SCHEME_FALSE);
t5=C_eqp(t4,C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t2;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_u_i_car(t1);
f_17245(2,av2);}}
else{
t6=C_eqp(t4,C_make_character(105));
t7=(C_truep(t6)?t6:C_eqp(t4,C_make_character(73)));
if(C_truep(t7)){
t8=C_fixnum_plus(C_u_i_cdr(t1),C_fix(1));
t9=C_eqp(((C_word*)t0)[6],t8);
if(C_truep(t9)){
t10=C_eqp(C_subchar(((C_word*)t0)[5],((C_word*)t0)[7]),C_make_character(43));
if(C_truep(t10)){
if(C_truep(t10)){
/* library.scm:2643: scheme#make-rectangular */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[524]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[524]+1);
av2[1]=t2;
av2[2]=C_fix(0);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t11=t2;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_FALSE;
f_17245(2,av2);}}}
else{
t11=C_eqp(C_subchar(((C_word*)t0)[5],((C_word*)t0)[7]),C_make_character(45));
if(C_truep(t11)){
/* library.scm:2643: scheme#make-rectangular */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[524]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[524]+1);
av2[1]=t2;
av2[2]=C_fix(0);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t12=t2;{
C_word *av2=av;
av2[0]=t12;
av2[1]=C_SCHEME_FALSE;
f_17245(2,av2);}}}}
else{
t10=t2;{
C_word *av2=av;
av2[0]=t10;
av2[1]=C_SCHEME_FALSE;
f_17245(2,av2);}}}
else{
t8=C_eqp(t4,C_make_character(43));
t9=(C_truep(t8)?t8:C_eqp(t4,C_make_character(45)));
if(C_truep(t9)){
t10=C_set_block_item(((C_word*)t0)[8],0,C_SCHEME_FALSE);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17344,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[5],a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2646: scan-real */
t12=((C_word*)t0)[9];
f_17002(t12,t11,C_u_i_cdr(t1));}
else{
t10=C_eqp(t4,C_make_character(64));
if(C_truep(t10)){
t11=C_set_block_item(((C_word*)t0)[8],0,C_SCHEME_FALSE);
t12=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17412,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2654: scan-real */
t13=((C_word*)t0)[9];
f_17002(t13,t12,C_fixnum_plus(C_u_i_cdr(t1),C_fix(1)));}
else{
t11=t2;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_FALSE;
f_17245(2,av2);}}}}}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_17245(2,av2);}}}

/* k17243 in k17240 in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_17245(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17245,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_eqp(((C_word*)((C_word*)t0)[2])[1],lf[632]);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17257,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2659: scheme#exact->inexact */
t4=*((C_word*)lf[62]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_i_finitep(t1))?t1:C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k17255 in k17243 in k17240 in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_17257(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17257,c,av);}
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
if(C_truep(C_u_i_zerop2(t1))){
/* library.scm:2662: chicken.flonum#fpneg */
t2=*((C_word*)lf[464]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k17342 in k17240 in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_17344(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17344,c,av);}
if(C_truep(t1)){
if(C_truep(C_i_cdr(t1))){
t2=C_fixnum_plus(C_u_i_cdr(t1),C_fix(1));
t3=C_eqp(((C_word*)t0)[2],t2);
if(C_truep(t3)){
t4=C_u_i_cdr(t1);
t5=C_eqp(C_subchar(((C_word*)t0)[3],t4),C_make_character(105));
if(C_truep(t5)){
if(C_truep(t5)){
/* library.scm:2651: scheme#make-rectangular */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[524]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[524]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=C_u_i_car(((C_word*)t0)[5]);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t6=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
f_17245(2,av2);}}}
else{
t6=C_u_i_cdr(t1);
t7=C_eqp(C_subchar(((C_word*)t0)[3],t6),C_make_character(73));
if(C_truep(t7)){
/* library.scm:2651: scheme#make-rectangular */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[524]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[524]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=C_u_i_car(((C_word*)t0)[5]);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t8=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_FALSE;
f_17245(2,av2);}}}}
else{
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
f_17245(2,av2);}}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
f_17245(2,av2);}}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
f_17245(2,av2);}}}

/* k17410 in k17240 in ##sys#string->compnum in k10751 in k8834 */
static void C_ccall f_17412(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17412,c,av);}
if(C_truep(t1)){
t2=C_i_cdr(t1);
if(C_truep(C_i_not(t2))){
/* library.scm:2656: scheme#make-polar */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[526]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[526]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=C_u_i_car(((C_word*)t0)[3]);
av2[3]=C_u_i_car(t1);
tp(4,av2);}}
else{
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
f_17245(2,av2);}}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
f_17245(2,av2);}}}

/* scheme#string->number in k10751 in k8834 */
static void C_ccall f_17492(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_17492,c,av);}
a=C_alloc(5);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_fix(10):C_get_rest_arg(c,3,av,3,t0));
t5=C_i_check_string_2(t2,lf[640]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17502,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(t4))){
if(C_truep(C_fixnum_lessp(C_fix(1),t4))){
if(C_truep(C_fixnum_lessp(t4,C_fix(37)))){
t7=t6;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_UNDEFINED;
f_17502(2,av2);}}
else{
/* library.scm:2671: ##sys#error-bad-base */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[381]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[381]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=lf[640];
tp(4,av2);}}}
else{
/* library.scm:2671: ##sys#error-bad-base */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[381]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[381]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=lf[640];
tp(4,av2);}}}
else{
/* library.scm:2671: ##sys#error-bad-base */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[381]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[381]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=lf[640];
tp(4,av2);}}}

/* k17500 in scheme#string->number in k10751 in k8834 */
static void C_ccall f_17502(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,6)))){
C_save_and_reclaim((void *)f_17502,c,av);}
a=C_alloc(8);
t2=C_block_size(((C_word*)t0)[2]);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17511,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word)li469),tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f_17511(t6,((C_word*)t0)[4],C_fix(0),C_SCHEME_FALSE,C_SCHEME_FALSE,t2);}

/* scan-prefix in k17500 in scheme#string->number in k10751 in k8834 */
static void C_fcall f_17511(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(0,0,5)))){
C_save_and_reclaim_args((void *)trf_17511,6,t0,t1,t2,t3,t4,t5);}
t6=C_fixnum_plus(t2,C_fix(2));
t7=C_fixnum_lessp(t6,t5);
t8=(C_truep(t7)?C_eqp(C_subchar(((C_word*)t0)[2],t2),C_make_character(35)):C_SCHEME_FALSE);
if(C_truep(t8)){
t9=C_fixnum_plus(t2,C_fix(1));
t10=C_subchar(((C_word*)t0)[2],t9);
t11=C_eqp(t10,C_make_character(105));
t12=(C_truep(t11)?t11:C_eqp(t10,C_make_character(73)));
if(C_truep(t12)){
if(C_truep(C_i_not(t3))){
/* library.scm:2678: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=lf[632];
t27=t4;
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t13=t1;{
C_word av2[2];
av2[0]=t13;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t13+1)))(2,av2);}}}
else{
t13=C_eqp(t10,C_make_character(101));
t14=(C_truep(t13)?t13:C_eqp(t10,C_make_character(69)));
if(C_truep(t14)){
if(C_truep(C_i_not(t3))){
/* library.scm:2679: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=lf[631];
t27=t4;
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t15=t1;{
C_word av2[2];
av2[0]=t15;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t15+1)))(2,av2);}}}
else{
t15=C_eqp(t10,C_make_character(98));
t16=(C_truep(t15)?t15:C_eqp(t10,C_make_character(66)));
if(C_truep(t16)){
if(C_truep(C_i_not(t4))){
/* library.scm:2680: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=t3;
t27=C_fix(2);
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t17=t1;{
C_word av2[2];
av2[0]=t17;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t17+1)))(2,av2);}}}
else{
t17=C_eqp(t10,C_make_character(111));
t18=(C_truep(t17)?t17:C_eqp(t10,C_make_character(79)));
if(C_truep(t18)){
if(C_truep(C_i_not(t4))){
/* library.scm:2681: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=t3;
t27=C_fix(8);
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t19=t1;{
C_word av2[2];
av2[0]=t19;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t19+1)))(2,av2);}}}
else{
t19=C_eqp(t10,C_make_character(100));
t20=(C_truep(t19)?t19:C_eqp(t10,C_make_character(68)));
if(C_truep(t20)){
if(C_truep(C_i_not(t4))){
/* library.scm:2682: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=t3;
t27=C_fix(10);
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t21=t1;{
C_word av2[2];
av2[0]=t21;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t21+1)))(2,av2);}}}
else{
t21=C_eqp(t10,C_make_character(120));
t22=(C_truep(t21)?t21:C_eqp(t10,C_make_character(88)));
if(C_truep(t22)){
if(C_truep(C_i_not(t4))){
/* library.scm:2683: scan-prefix */
t24=t1;
t25=C_fixnum_plus(t2,C_fix(2));
t26=t3;
t27=C_fix(16);
t28=t5;
t1=t24;
t2=t25;
t3=t26;
t4=t27;
t5=t28;
goto loop;}
else{
t23=t1;{
C_word av2[2];
av2[0]=t23;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t23+1)))(2,av2);}}}
else{
t23=t1;{
C_word av2[2];
av2[0]=t23;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t23+1)))(2,av2);}}}}}}}}
else{
if(C_truep(t4)){
/* library.scm:2685: ##sys#string->compnum */
f_16072(t1,t4,((C_word*)t0)[2],t2,t3);}
else{
/* library.scm:2685: ##sys#string->compnum */
f_16072(t1,((C_word*)t0)[4],((C_word*)t0)[2],t2,t3);}}}

/* ##sys#string->number in k10751 in k8834 */
static void C_ccall f_17747(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_17747,c,av);}
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_fix(10):C_get_rest_arg(c,3,av,3,t0));
t5=C_rest_nullp(c,3);
t6=C_rest_nullp(c,4);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,3,t0));
if(C_truep(C_rest_nullp(c,4))){
/* library.scm:2688: ##sys#string->compnum */
f_16072(t1,t4,t2,C_fix(0),t7);}
else{
/* library.scm:2688: ##sys#string->compnum */
f_16072(t1,t4,t2,C_fix(0),t7);}}

/* chicken.base#equal=? in k10751 in k8834 */
static void C_ccall f_17793(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(12,c,5)))){
C_save_and_reclaim((void *)f_17793,c,av);}
a=C_alloc(12);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17796,a[2]=t7,a[3]=((C_word)li476),tmp=(C_word)a,a+=4,tmp));
t9=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17864,a[2]=t5,a[3]=((C_word)li477),tmp=(C_word)a,a+=4,tmp));
/* library.scm:2731: walk */
t10=((C_word*)t7)[1];
f_17864(t10,t1,t2,t3);}

/* compare-slots in chicken.base#equal=? in k10751 in k8834 */
static void C_fcall f_17796(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,3)))){
C_save_and_reclaim_args((void *)trf_17796,5,t0,t1,t2,t3,t4);}
a=C_alloc(10);
t5=C_block_size(t2);
t6=C_block_size(t3);
t7=C_eqp(t5,t6);
if(C_truep(t7)){
t8=C_fixnum_less_or_equal_p(t5,t4);
if(C_truep(t8)){
t9=t1;{
C_word av2[2];
av2[0]=t9;
av2[1]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t9=C_fixnum_difference(t5,C_fix(1));
t10=C_SCHEME_UNDEFINED;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=C_set_block_item(t11,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_17823,a[2]=t9,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=t3,a[6]=t11,a[7]=((C_word)li475),tmp=(C_word)a,a+=8,tmp));
t13=((C_word*)t11)[1];
f_17823(t13,t1,t4);}}
else{
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* loop in compare-slots in chicken.base#equal=? in k10751 in k8834 */
static void C_fcall f_17823(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_17823,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,((C_word*)t0)[2]);
if(C_truep(t3)){
/* library.scm:2705: walk */
t4=((C_word*)((C_word*)t0)[3])[1];
f_17864(t4,t1,C_slot(((C_word*)t0)[4],t2),C_slot(((C_word*)t0)[5],t2));}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17847,a[2]=((C_word*)t0)[6],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2706: walk */
t5=((C_word*)((C_word*)t0)[3])[1];
f_17864(t5,t4,C_slot(((C_word*)t0)[4],t2),C_slot(((C_word*)t0)[5],t2));}}

/* k17845 in loop in compare-slots in chicken.base#equal=? in k10751 in k8834 */
static void C_ccall f_17847(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17847,c,av);}
if(C_truep(t1)){
/* library.scm:2707: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_17823(t2,((C_word*)t0)[3],C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* walk in chicken.base#equal=? in k10751 in k8834 */
static void C_fcall f_17864(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,4)))){
C_save_and_reclaim_args((void *)trf_17864,4,t0,t1,t2,t3);}
t4=C_eqp(t2,t3);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t5=C_i_numberp(t3);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_nequalp(t2,t3):C_eqp(t2,t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
if(C_truep(C_i_not(C_blockp(t2)))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_not(C_blockp(t3)))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_not(C_sametypep(t2,t3)))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_specialp(t2))){
if(C_truep(C_specialp(t3))){
if(C_truep(C_closurep(t2))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=shallow_equal(t2,t3);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* library.scm:2721: compare-slots */
t5=((C_word*)((C_word*)t0)[2])[1];
f_17796(t5,t1,t2,t3,C_fix(1));}}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
if(C_truep(C_byteblockp(t2))){
if(C_truep(C_byteblockp(t3))){
t5=C_block_size(t2);
t6=C_block_size(t3);
t7=C_eqp(t5,t6);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=(C_truep(t7)?C_substring_compare(t2,t3,C_fix(0),C_fix(0),t5):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t5=C_block_size(t2);
t6=C_block_size(t3);
t7=C_eqp(t5,t6);
if(C_truep(t7)){
/* library.scm:2730: compare-slots */
t8=((C_word*)((C_word*)t0)[2])[1];
f_17796(t8,t1,t2,t3,C_fix(0));}
else{
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}}}}}}}

/* ##sys#interned-symbol? in k10751 in k8834 */
static void C_ccall f_17965(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17965,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_lookup_symbol(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#string->symbol in k10751 in k8834 */
static void C_ccall f_17968(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17968,c,av);}
t3=C_i_check_string(t2);
/* library.scm:2743: ##sys#intern-symbol */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
C_string_to_symbol(3,av2);}}

/* ##sys#symbol->string in k10751 in k8834 */
static void C_ccall f_17977(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17977,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_slot(t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#symbol->string in k10751 in k8834 */
static void C_ccall f_17983(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17983,c,av);}
a=C_alloc(3);
t3=C_i_check_symbol_2(t2,lf[654]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17994,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2751: ##sys#symbol->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[652]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[652]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k17992 in scheme#symbol->string in k10751 in k8834 */
static void C_ccall f_17994(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17994,c,av);}
/* library.scm:2751: scheme#string-copy */
t2=*((C_word*)lf[400]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* scheme#string->symbol in k10751 in k8834 */
static void C_ccall f_17996(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17996,c,av);}
a=C_alloc(3);
t3=C_i_check_string_2(t2,lf[656]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18007,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2757: string-copy */
t5=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k18005 in scheme#string->symbol in k10751 in k8834 */
static void C_ccall f_18007(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18007,c,av);}
/* library.scm:2757: ##sys#intern-symbol */{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
C_string_to_symbol(3,av2);}}

/* chicken.base#string->uninterned-symbol in k10751 in k8834 */
static void C_ccall f_18009(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_18009,c,av);}
a=C_alloc(7);
t3=C_i_check_string_2(t2,lf[658]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_make_symbol,a[2]=((C_word)li486),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18020,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2763: string-copy */
t6=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k18018 in chicken.base#string->uninterned-symbol in k10751 in k8834 */
static void C_ccall f_18020(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18020,c,av);}
/* library.scm:2761: g3436 */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* chicken.base#gensym in k10751 in k8834 */
static void C_ccall f_18022(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +17,c,5)))){
C_save_and_reclaim((void*)f_18022,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+17);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t3=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=C_set_block_item(((C_word*)t0)[2],0,t3);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_make_symbol,a[2]=((C_word)li488),tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18039,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18043,a[2]=t6,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t8=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f35941,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2780: ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[622]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[622]+1);
av2[1]=t9;
av2[2]=((C_word*)((C_word*)t0)[2])[1];
tp(3,av2);}}
else{
t9=C_get_rest_arg(c,2,av,2,t0);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18056,a[2]=t6,a[3]=((C_word*)t0)[2],a[4]=t7,a[5]=t9,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t9))){
if(C_truep(C_stringp(t9))){
t11=t10;{
C_word *av2=av;
av2[0]=t11;
av2[1]=t9;
f_18056(2,av2);}}
else{
if(C_truep(C_symbolp(t9))){
/* library.scm:2777: ##sys#symbol->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[652]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[652]+1);
av2[1]=t10;
av2[2]=t9;
tp(3,av2);}}
else{
/* library.scm:2768: ##sys#signal-hook */
t11=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t11;
av2[1]=t10;
av2[2]=lf[263];
av2[3]=lf[661];
av2[4]=lf[662];
av2[5]=t9;
((C_proc)(void*)(*((C_word*)t11+1)))(6,av2);}}}}
else{
t11=t10;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_FALSE;
f_18056(2,av2);}}}}

/* k18037 in chicken.base#gensym in k10751 in k8834 */
static void C_ccall f_18039(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18039,c,av);}
/* library.scm:2768: g3443 */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* k18041 in chicken.base#gensym in k10751 in k8834 */
static void C_ccall f_18043(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18043,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18047,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2780: ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[622]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[622]+1);
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
tp(3,av2);}}

/* k18045 in k18041 in chicken.base#gensym in k10751 in k8834 */
static void C_ccall f_18047(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18047,c,av);}
/* library.scm:2771: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[421]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[421]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* k18054 in chicken.base#gensym in k10751 in k8834 */
static void C_ccall f_18056(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_18056,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f35945,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2780: ##sys#number->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[622]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[622]+1);
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
tp(3,av2);}}
else{
/* library.scm:2768: ##sys#signal-hook */
t2=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[263];
av2[3]=lf[661];
av2[4]=lf[662];
av2[5]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* chicken.base#symbol-append in k10751 in k8834 */
static void C_ccall f_18076(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +20,c,3)))){
C_save_and_reclaim((void*)f_18076,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+20);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18084,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=C_a_i_cons(&a,2,C_SCHEME_UNDEFINED,C_SCHEME_END_OF_LIST);
t5=t4;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=((C_word*)t6)[1];
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18099,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18101,a[2]=t6,a[3]=t10,a[4]=t7,a[5]=((C_word)li490),tmp=(C_word)a,a+=6,tmp));
t12=((C_word*)t10)[1];
f_18101(t12,t8,t2);}

/* k18082 in chicken.base#symbol-append in k10751 in k8834 */
static void C_ccall f_18084(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18084,c,av);}
/* library.scm:2785: ##sys#intern-symbol */{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
C_string_to_symbol(3,av2);}}

/* k18097 in chicken.base#symbol-append in k10751 in k8834 */
static void C_ccall f_18099(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18099,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
C_apply(4,av2);}}

/* map-loop3459 in chicken.base#symbol-append in k10751 in k8834 */
static void C_fcall f_18101(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_18101,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18126,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=C_slot(t2,C_fix(0));
t5=C_i_check_symbol_2(t4,lf[664]);
/* library.scm:2790: ##sys#symbol->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[652]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[652]+1);
av2[1]=t3;
av2[2]=t4;
tp(3,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_slot(((C_word*)t0)[4],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k18124 in map-loop3459 in chicken.base#symbol-append in k10751 in k8834 */
static void C_ccall f_18126(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_18126,c,av);}
a=C_alloc(3);
t2=C_a_i_cons(&a,2,t1,C_SCHEME_END_OF_LIST);
t3=C_i_setslot(((C_word*)((C_word*)t0)[2])[1],C_fix(1),t2);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,t2);
t5=((C_word*)((C_word*)t0)[3])[1];
f_18101(t5,((C_word*)t0)[4],C_slot(((C_word*)t0)[5],C_fix(1)));}

/* chicken.keyword#keyword? in k10751 in k8834 */
static void C_ccall f_18135(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18135,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_keywordp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.keyword#string->keyword in k10751 in k8834 */
static void C_ccall f_18138(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18138,c,av);}
t3=C_i_check_string_2(t2,lf[668]);
/* library.scm:2807: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[649]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[649]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}

/* chicken.keyword#keyword->string in k10751 in k8834 */
static void C_ccall f_18147(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18147,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18154,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2812: keyword? */
t4=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k18152 in chicken.keyword#keyword->string in k10751 in k8834 */
static void C_ccall f_18154(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_18154,c,av);}
if(C_truep(t1)){
/* library.scm:2813: ##sys#symbol->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[652]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[652]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}
else{
/* library.scm:2814: ##sys#signal-hook */
t2=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[263];
av2[3]=lf[670];
av2[4]=lf[671];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* chicken.keyword#get-keyword in k10751 in k8834 */
static void C_ccall f_18165(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_18165,c,av);}
a=C_alloc(7);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18172,a[2]=t3,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=t5,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* library.scm:2819: ##sys#check-keyword */
t7=*((C_word*)lf[358]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[674];
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k18170 in chicken.keyword#get-keyword in k10751 in k8834 */
static void C_ccall f_18172(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18172,c,av);}
t2=C_i_check_list_2(((C_word*)t0)[2],lf[674]);
t3=C_i_get_keyword(((C_word*)t0)[3],((C_word*)t0)[2],((C_word*)t0)[4]);
t4=C_eqp(t3,((C_word*)t0)[4]);
if(C_truep(t4)){
if(C_truep(((C_word*)t0)[5])){
/* library.scm:2823: thunk */
t5=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t5;
av2[1]=((C_word*)t0)[6];
((C_proc)C_fast_retrieve_proc(t5))(2,av2);}}
else{
t5=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t5=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* ##sys#make-blob in k10751 in k8834 */
static void C_ccall f_18196(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_18196,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18200,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2839: ##sys#allocate-vector */
t4=*((C_word*)lf[323]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_SCHEME_FALSE;
av2[5]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}

/* k18198 in ##sys#make-blob in k10751 in k8834 */
static void C_ccall f_18200(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18200,c,av);}
t2=C_string_to_bytevector(t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.blob#make-blob in k10751 in k8834 */
static void C_ccall f_18202(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_18202,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18206,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2844: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[679];
tp(4,av2);}}

/* k18204 in chicken.blob#make-blob in k10751 in k8834 */
static void C_ccall f_18206(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18206,c,av);}
/* library.scm:2845: ##sys#make-blob */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[677]);
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[677]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* chicken.blob#blob? in k10751 in k8834 */
static void C_ccall f_18211(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18211,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_bytevectorp(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.blob#blob-size in k10751 in k8834 */
static void C_ccall f_18217(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_18217,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18221,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2852: ##sys#check-blob */
t4=*((C_word*)lf[349]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[682];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k18219 in chicken.blob#blob-size in k10751 in k8834 */
static void C_ccall f_18221(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18221,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_block_size(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.blob#string->blob in k10751 in k8834 */
static void C_ccall f_18226(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_18226,c,av);}
a=C_alloc(5);
t3=C_i_check_string_2(t2,lf[684]);
t4=C_block_size(t2);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18236,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2858: ##sys#make-blob */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[677]);
C_word *av2=av;
av2[0]=*((C_word*)lf[677]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}

/* k18234 in chicken.blob#string->blob in k10751 in k8834 */
static void C_ccall f_18236(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18236,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.blob#blob->string in k10751 in k8834 */
static void C_ccall f_18238(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_18238,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18242,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2863: ##sys#check-blob */
t4=*((C_word*)lf[349]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[686];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k18240 in chicken.blob#blob->string in k10751 in k8834 */
static void C_ccall f_18242(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_18242,c,av);}
a=C_alloc(5);
t2=C_block_size(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18248,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2865: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[385]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[385]+1);
av2[1]=t3;
av2[2]=t2;
tp(3,av2);}}

/* k18246 in k18240 in chicken.blob#blob->string in k10751 in k8834 */
static void C_ccall f_18248(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18248,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.blob#blob=? in k10751 in k8834 */
static void C_ccall f_18250(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_18250,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18254,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2870: ##sys#check-blob */
t5=*((C_word*)lf[349]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[688];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k18252 in chicken.blob#blob=? in k10751 in k8834 */
static void C_ccall f_18254(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_18254,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18257,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2871: ##sys#check-blob */
t3=*((C_word*)lf[349]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[688];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18255 in k18252 in chicken.blob#blob=? in k10751 in k8834 */
static void C_ccall f_18257(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18257,c,av);}
t2=C_block_size(((C_word*)t0)[2]);
t3=C_block_size(((C_word*)t0)[3]);
t4=C_eqp(t3,t2);
t5=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_zerop(C_string_compare(((C_word*)t0)[2],((C_word*)t0)[3],t2)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#make-vector in k10751 in k8834 */
static void C_ccall f_18273(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_18273,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18277,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2883: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[689];
tp(4,av2);}}

/* k18275 in scheme#make-vector in k10751 in k8834 */
static void C_ccall f_18277(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_18277,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18280,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_lessp(((C_word*)t0)[4],C_fix(0)))){
/* library.scm:2884: ##sys#error */
t3=*((C_word*)lf[155]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[689];
av2[3]=lf[690];
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_18280(2,av2);}}}

/* k18278 in k18275 in scheme#make-vector in k10751 in k8834 */
static void C_ccall f_18280(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_18280,c,av);}
if(C_truep(C_i_nullp(((C_word*)t0)[2]))){
t2=C_SCHEME_UNDEFINED;
/* library.scm:2885: ##sys#allocate-vector */
t3=*((C_word*)lf[323]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
/* library.scm:2885: ##sys#allocate-vector */
t2=*((C_word*)lf[323]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_FALSE;
av2[4]=C_i_car(((C_word*)t0)[2]);
av2[5]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* scheme#list->vector in k10751 in k8834 */
static void C_ccall f_18302(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_18302,c,av);}
a=C_alloc(4);
t3=C_i_listp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:2897: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[692];
tp(4,av2);}}
else{
t4=C_i_length(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18318,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2899: ##sys#make-vector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[691]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[691]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}}

/* k18316 in scheme#list->vector in k10751 in k8834 */
static void C_ccall f_18318(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_18318,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18323,a[2]=t1,a[3]=((C_word)li504),tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_18323(t2,((C_word*)t0)[3],C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* loop in k18316 in scheme#list->vector in k10751 in k8834 */
static C_word C_fcall f_18323(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t1))){
return(((C_word*)t0)[2]);}
else{
t3=C_slot(t1,C_fix(0));
t4=C_i_setslot(((C_word*)t0)[2],t2,t3);
t6=C_slot(t1,C_fix(1));
t7=C_fixnum_plus(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}

/* scheme#vector->list in k10751 in k8834 */
static void C_ccall f_18354(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_18354,c,av);}
a=C_alloc(8);
t3=C_i_check_vector_2(t2,lf[693]);
t4=C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18363,a[2]=t4,a[3]=t2,a[4]=t6,a[5]=((C_word)li506),tmp=(C_word)a,a+=6,tmp));
t8=((C_word*)t6)[1];
f_18363(t8,t1,C_fix(0));}

/* loop in scheme#vector->list in k10751 in k8834 */
static void C_fcall f_18363(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_18363,3,t0,t1,t2);}
a=C_alloc(4);
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[2]))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_slot(((C_word*)t0)[3],t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18381,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2916: loop */
t6=t4;
t7=C_fixnum_plus(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}

/* k18379 in loop in scheme#vector->list in k10751 in k8834 */
static void C_ccall f_18381(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_18381,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#vector in k10751 in k8834 */
static void C_ccall f_18387(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,2)))){
C_save_and_reclaim((void*)f_18387,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
/* library.scm:2918: scheme#list->vector */
t3=*((C_word*)lf[94]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* scheme#vector-fill! in k10751 in k8834 */
static void C_ccall f_18393(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_18393,c,av);}
a=C_alloc(6);
t4=C_i_check_vector_2(t2,lf[694]);
t5=C_block_size(t2);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18402,a[2]=t5,a[3]=t2,a[4]=t3,a[5]=((C_word)li509),tmp=(C_word)a,a+=6,tmp);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(
  f_18402(t6,C_fix(0))
);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* doloop3597 in scheme#vector-fill! in k10751 in k8834 */
static C_word C_fcall f_18402(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
t2=C_SCHEME_UNDEFINED;
return(t2);}
else{
t2=C_i_setslot(((C_word*)t0)[3],t1,((C_word*)t0)[4]);
t4=C_fixnum_plus(t1,C_fix(1));
t1=t4;
goto loop;}}

/* chicken.base#vector-copy! in k10751 in k8834 */
static void C_ccall f_18421(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +8,c,3)))){
C_save_and_reclaim((void*)f_18421,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+8);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t5=C_i_check_vector_2(t2,lf[695]);
t6=C_i_check_vector_2(t3,lf[695]);
t7=C_block_size(t2);
t8=C_block_size(t3);
t9=C_i_pairp(t4);
t10=(C_truep(t9)?C_get_rest_arg(c,4,av,4,t0):C_i_fixnum_min(t8,t7));
t11=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_18440,a[2]=t10,a[3]=t2,a[4]=t3,a[5]=t1,a[6]=t8,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2935: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t11;
av2[2]=t10;
av2[3]=lf[695];
tp(4,av2);}}

/* k18438 in chicken.base#vector-copy! in k10751 in k8834 */
static void C_ccall f_18440(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,7)))){
C_save_and_reclaim((void *)f_18440,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18443,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=C_fixnum_greaterp(((C_word*)t0)[2],((C_word*)t0)[6]);
t4=(C_truep(t3)?t3:C_fixnum_greaterp(((C_word*)t0)[2],((C_word*)t0)[7]));
if(C_truep(t4)){
/* library.scm:2937: ##sys#signal-hook */
t5=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 8) {
  av2=av;
} else {
  av2=C_alloc(8);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=lf[388];
av2[3]=lf[695];
av2[4]=lf[696];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
av2[7]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t5+1)))(8,av2);}}
else{
t5=t2;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_18443(2,av2);}}}

/* k18441 in k18438 in chicken.base#vector-copy! in k10751 in k8834 */
static void C_ccall f_18443(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_18443,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18448,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li511),tmp=(C_word)a,a+=6,tmp);
t3=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_18448(t2,C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* doloop3609 in k18441 in k18438 in chicken.base#vector-copy! in k10751 in k8834 */
static C_word C_fcall f_18448(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
t2=C_SCHEME_UNDEFINED;
return(t2);}
else{
t2=C_slot(((C_word*)t0)[3],t1);
t3=C_i_setslot(((C_word*)t0)[4],t1,t2);
t5=C_fixnum_plus(t1,C_fix(1));
t1=t5;
goto loop;}}

/* chicken.base#subvector in k10751 in k8834 */
static void C_ccall f_18490(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,5)))){
C_save_and_reclaim((void *)f_18490,c,av);}
a=C_alloc(8);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=C_i_check_vector_2(t2,lf[697]);
t7=C_block_size(t2);
t8=(C_truep(t5)?t5:t7);
t9=C_fixnum_difference(t8,t3);
t10=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_18509,a[2]=t9,a[3]=t3,a[4]=t2,a[5]=t1,a[6]=t8,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2950: ##sys#check-range */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[341]+1));
C_word av2[6];
av2[0]=*((C_word*)lf[341]+1);
av2[1]=t10;
av2[2]=t3;
av2[3]=C_fix(0);
av2[4]=C_fixnum_plus(t7,C_fix(1));
av2[5]=lf[697];
tp(6,av2);}}

/* k18507 in chicken.base#subvector in k10751 in k8834 */
static void C_ccall f_18509(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_18509,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18512,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:2951: ##sys#check-range */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[341]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[341]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=C_fix(0);
av2[4]=C_fixnum_plus(((C_word*)t0)[7],C_fix(1));
av2[5]=lf[697];
tp(6,av2);}}

/* k18510 in k18507 in chicken.base#subvector in k10751 in k8834 */
static void C_ccall f_18512(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_18512,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18515,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* library.scm:2952: scheme#make-vector */
t3=*((C_word*)lf[93]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k18513 in k18510 in k18507 in chicken.base#subvector in k10751 in k8834 */
static void C_ccall f_18515(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_18515,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18520,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word)li513),tmp=(C_word)a,a+=7,tmp);
t3=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_18520(t2,C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* doloop3640 in k18513 in k18510 in k18507 in chicken.base#subvector in k10751 in k8834 */
static C_word C_fcall f_18520(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
return(((C_word*)t0)[3]);}
else{
t2=C_fixnum_plus(t1,((C_word*)t0)[4]);
t3=C_slot(((C_word*)t0)[5],t2);
t4=C_i_setslot(((C_word*)t0)[3],t1,t3);
t6=C_fixnum_plus(t1,C_fix(1));
t1=t6;
goto loop;}}

/* chicken.base#vector-resize in k10751 in k8834 */
static void C_ccall f_18561(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_18561,c,av);}
a=C_alloc(6);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=C_i_check_vector_2(t2,lf[698]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18571,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2960: ##sys#check-fixnum */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[102]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[102]+1);
av2[1]=t7;
av2[2]=t3;
av2[3]=lf[698];
tp(4,av2);}}

/* k18569 in chicken.base#vector-resize in k10751 in k8834 */
static void C_ccall f_18571(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_18571,c,av);}
/* library.scm:2961: ##sys#vector-resize */
f_18582(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}

/* ##sys#vector-resize in k10751 in k8834 */
static void C_fcall f_18582(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18582,4,t1,t2,t3,t4);}
a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18586,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2964: ##sys#make-vector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[691]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[691]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=t4;
tp(4,av2);}}

/* k18584 in ##sys#vector-resize in k10751 in k8834 */
static void C_ccall f_18586(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_18586,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18589,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2965: scheme#min */
t3=*((C_word*)lf[579]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_block_size(((C_word*)t0)[2]);
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18587 in k18584 in ##sys#vector-resize in k10751 in k8834 */
static void C_ccall f_18589(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_18589,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18594,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word)li516),tmp=(C_word)a,a+=6,tmp);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(
  f_18594(t2,C_fix(0))
);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* doloop3668 in k18587 in k18584 in ##sys#vector-resize in k10751 in k8834 */
static C_word C_fcall f_18594(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)t0)[2]))){
return(((C_word*)t0)[3]);}
else{
t2=C_slot(((C_word*)t0)[4],t1);
t3=C_i_setslot(((C_word*)t0)[3],t1,t2);
t5=C_fixnum_plus(t1,C_fix(1));
t1=t5;
goto loop;}}

/* scheme#char-ci=? in k10751 in k8834 */
static void C_ccall f_18621(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18621,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_eqp(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-ci>? in k10751 in k8834 */
static void C_ccall f_18635(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18635,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_greaterp(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-ci<? in k10751 in k8834 */
static void C_ccall f_18646(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18646,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_lessp(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-ci>=? in k10751 in k8834 */
static void C_ccall f_18657(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18657,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_greater_or_equal_p(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-ci<=? in k10751 in k8834 */
static void C_ccall f_18668(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18668,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_less_or_equal_p(C_u_i_char_downcase(t2),C_u_i_char_downcase(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k18679 in k10751 in k8834 */
static void C_ccall f_18681(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,3)))){
C_save_and_reclaim((void *)f_18681,c,av);}
a=C_alloc(15);
t2=C_SCHEME_END_OF_LIST;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18683,a[2]=t1,a[3]=((C_word)li524),tmp=(C_word)a,a+=4,tmp);
t5=C_mutate((C_word*)lf[199]+1 /* (set! chicken.base#char-name ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18724,a[2]=t4,a[3]=t3,a[4]=t1,a[5]=((C_word)li525),tmp=(C_word)a,a+=6,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18841,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3034: chicken.base#char-name */
t7=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=lf[1444];
av2[3]=C_make_character(32);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* lookup-char in k18679 in k10751 in k8834 */
static void C_fcall f_18683(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_18683,3,t0,t1,t2);}
a=C_alloc(4);
t3=C_fix(C_character_code(t2));
t4=C_fixnum_modulo(t3,C_fix(37));
t5=C_slot(((C_word*)t0)[2],t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18696,a[2]=t2,a[3]=((C_word)li523),tmp=(C_word)a,a+=4,tmp);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(
  f_18696(t6,t5)
);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* loop in lookup-char in k18679 in k10751 in k8834 */
static C_word C_fcall f_18696(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=C_slot(t2,C_fix(0));
t4=C_eqp(t3,((C_word*)t0)[2]);
if(C_truep(t4)){
return(t2);}
else{
t6=C_slot(t1,C_fix(1));
t1=t6;
goto loop;}}
else{
return(C_SCHEME_FALSE);}}

/* chicken.base#char-name in k18679 in k10751 in k8834 */
static void C_ccall f_18724(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +8,c,5)))){
C_save_and_reclaim((void*)f_18724,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+8);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_pairp(t3);
t5=(C_truep(t4)?C_get_rest_arg(c,3,av,3,t0):C_SCHEME_FALSE);
if(C_truep(C_charp(t2))){
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18737,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:3008: lookup-char */
t7=((C_word*)t0)[2];
f_18683(t7,t6,t2);}
else{
if(C_truep(t5)){
t6=C_i_check_symbol_2(t2,lf[700]);
t7=C_i_check_char_2(t5,lf[700]);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_18755,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t5,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[2],tmp=(C_word)a,a+=8,tmp);
t9=C_slot(t2,C_fix(1));
t10=C_block_size(t9);
if(C_truep(C_fixnum_lessp(t10,C_fix(2)))){
/* library.scm:3014: ##sys#signal-hook */
t11=C_fast_retrieve(lf[194]);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t11;
av2[1]=t8;
av2[2]=lf[263];
av2[3]=lf[700];
av2[4]=lf[701];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t11+1)))(6,av2);}}
else{
t11=t8;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_UNDEFINED;
f_18755(2,av2);}}}
else{
t6=C_i_check_symbol_2(t2,lf[700]);
t7=C_i_assq(t2,((C_word*)((C_word*)t0)[3])[1]);
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=(C_truep(t7)?C_slot(t7,C_fix(1)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}

/* k18735 in chicken.base#char-name in k18679 in k10751 in k8834 */
static void C_ccall f_18737(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18737,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?C_slot(t1,C_fix(1)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k18753 in chicken.base#char-name in k18679 in k10751 in k8834 */
static void C_ccall f_18755(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_18755,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18758,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* library.scm:3015: lookup-char */
t3=((C_word*)t0)[7];
f_18683(t3,t2,((C_word*)t0)[5]);}

/* k18756 in k18753 in chicken.base#char-name in k18679 in k10751 in k8834 */
static void C_ccall f_18758(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,1)))){
C_save_and_reclaim((void *)f_18758,c,av);}
a=C_alloc(12);
if(C_truep(t1)){
t2=C_i_assq(((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1]);
t3=C_i_setslot(t1,C_fix(1),((C_word*)t0)[2]);
if(C_truep(t2)){
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_set_i_slot(t2,C_fix(1),((C_word*)t0)[5]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[5]);
t5=C_a_i_cons(&a,2,t4,((C_word*)((C_word*)t0)[3])[1]);
t6=C_mutate(((C_word *)((C_word*)t0)[3])+1,t5);
t7=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}
else{
t2=C_fix(C_character_code(((C_word*)t0)[5]));
t3=C_fixnum_modulo(t2,C_fix(37));
t4=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[5]);
t5=C_a_i_cons(&a,2,t4,((C_word*)((C_word*)t0)[3])[1]);
t6=C_mutate(((C_word *)((C_word*)t0)[3])+1,t5);
t7=C_a_i_cons(&a,2,((C_word*)t0)[5],((C_word*)t0)[2]);
t8=C_slot(((C_word*)t0)[6],t3);
t9=C_a_i_cons(&a,2,t7,t8);
t10=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t10;
av2[1]=C_i_setslot(((C_word*)t0)[6],t3,t9);
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18841(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18841,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18844,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3035: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1443];
av2[3]=C_make_character(9);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18844(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18844,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18847,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3036: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1442];
av2[3]=C_make_character(10);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18847(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18847,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18850,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3037: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1441];
av2[3]=C_make_character(10);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18850(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18850,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18853,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3038: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1440];
av2[3]=C_make_character(11);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18853(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18853,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18856,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3039: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1439];
av2[3]=C_make_character(127);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18856(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18856,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18859,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3040: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1438];
av2[3]=C_make_character(27);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18859(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18859,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18862,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3041: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1437];
av2[3]=C_make_character(27);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18862(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18862,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18865,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3042: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1436];
av2[3]=C_make_character(7);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18865(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18865,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18868,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3043: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1435];
av2[3]=C_make_character(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18868(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18868,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18871,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3044: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1434];
av2[3]=C_make_character(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18871(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18871,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18874,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3045: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1433];
av2[3]=C_make_character(13);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18874(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18874,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18877,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3046: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1432];
av2[3]=C_make_character(12);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18877(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18877,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18880,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3047: chicken.base#char-name */
t3=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[1431];
av2[3]=C_make_character(8);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18880(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(93,c,6)))){
C_save_and_reclaim((void *)f_18880,c,av);}
a=C_alloc(93);
t2=C_mutate((C_word*)lf[702]+1 /* (set! ##sys#call-with-current-continuation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_call_cc,a[2]=((C_word)li526),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[703]+1 /* (set! ##sys#call-with-cthulhu ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_call_with_cthulhu,a[2]=((C_word)li527),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[704]+1 /* (set! ##sys#call-with-values ...) */,*((C_word*)lf[131]+1));
t5=C_mutate((C_word*)lf[705]+1 /* (set! ##sys#for-each ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18885,a[2]=((C_word)li529),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[707]+1 /* (set! ##sys#map ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18923,a[2]=((C_word)li531),tmp=(C_word)a,a+=3,tmp));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18965,a[2]=((C_word)li534),tmp=(C_word)a,a+=3,tmp);
t10=C_set_block_item(t8,0,t9);
t11=C_mutate((C_word*)lf[170]+1 /* (set! scheme#for-each ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19023,a[2]=t8,a[3]=((C_word)li539),tmp=(C_word)a,a+=4,tmp));
t12=C_mutate((C_word*)lf[171]+1 /* (set! scheme#map ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19105,a[2]=t8,a[3]=((C_word)li544),tmp=(C_word)a,a+=4,tmp));
t13=C_set_block_item(lf[709] /* ##sys#dynamic-winds */,0,C_SCHEME_END_OF_LIST);
t14=C_mutate((C_word*)lf[172]+1 /* (set! scheme#dynamic-wind ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19207,a[2]=((C_word)li546),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[710]+1 /* (set! ##sys#dynamic-wind ...) */,*((C_word*)lf[172]+1));
t16=C_mutate((C_word*)lf[132]+1 /* (set! scheme#call-with-current-continuation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19238,a[2]=((C_word)li549),tmp=(C_word)a,a+=3,tmp));
t17=C_mutate((C_word*)lf[198]+1 /* (set! chicken.base#call/cc ...) */,*((C_word*)lf[132]+1));
t18=C_mutate(&lf[711] /* (set! ##sys#dynamic-unwind ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19278,a[2]=((C_word)li550),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[209]+1 /* (set! chicken.base#port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19336,a[2]=((C_word)li551),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[211]+1 /* (set! chicken.base#input-port-open? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19342,a[2]=((C_word)li552),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[212]+1 /* (set! chicken.base#output-port-open? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19347,a[2]=((C_word)li553),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate((C_word*)lf[210]+1 /* (set! chicken.base#port-closed? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19352,a[2]=((C_word)li554),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[716]+1 /* (set! ##sys#make-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19365,a[2]=((C_word)li555),tmp=(C_word)a,a+=3,tmp));
t24=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_33003,a[2]=((C_word)li557),tmp=(C_word)a,a+=3,tmp);
t25=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_33042,a[2]=((C_word)li559),tmp=(C_word)a,a+=3,tmp);
t26=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_33081,a[2]=((C_word)li560),tmp=(C_word)a,a+=3,tmp);
t27=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_33084,a[2]=((C_word)li561),tmp=(C_word)a,a+=3,tmp);
t28=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_33087,a[2]=((C_word)li562),tmp=(C_word)a,a+=3,tmp);
t29=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_33093,a[2]=((C_word)li563),tmp=(C_word)a,a+=3,tmp);
t30=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_33096,a[2]=((C_word)li564),tmp=(C_word)a,a+=3,tmp);
t31=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_33099,a[2]=((C_word)li567),tmp=(C_word)a,a+=3,tmp);
t32=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_33197,a[2]=((C_word)li570),tmp=(C_word)a,a+=3,tmp);
t33=C_a_i_vector(&a,10,t24,t25,t26,t27,t28,t29,t30,t31,t32,C_SCHEME_FALSE);
t34=C_mutate((C_word*)lf[730]+1 /* (set! ##sys#stream-port-class ...) */,t33);
t35=C_mutate((C_word*)lf[731]+1 /* (set! ##sys#open-file-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_open_file_port,a[2]=((C_word)li571),tmp=(C_word)a,a+=3,tmp));
t36=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19396,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3329: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[716]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[716]+1);
av2[1]=t36;
av2[2]=C_fix(1);
av2[3]=C_fast_retrieve(lf[730]);
av2[4]=lf[1430];
av2[5]=lf[749];
tp(6,av2);}}

/* ##sys#for-each in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18885(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_18885,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18891,a[2]=t5,a[3]=t2,a[4]=t3,a[5]=((C_word)li528),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_18891(t7,t1,t3);}

/* loop in ##sys#for-each in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_fcall f_18891(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18891,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18907,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3060: p */
t5=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}
else{
/* library.scm:3062: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[706];
tp(4,av2);}}}}

/* k18905 in loop in ##sys#for-each in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18907(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18907,c,av);}
/* library.scm:3061: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_18891(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}

/* ##sys#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18923(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_18923,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18929,a[2]=t5,a[3]=t2,a[4]=t3,a[5]=((C_word)li530),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_18929(t7,t1,t3);}

/* loop in ##sys#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_fcall f_18929(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18929,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18949,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3068: p */
t5=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}
else{
/* library.scm:3069: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[708];
tp(4,av2);}}}}

/* k18947 in loop in ##sys#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18949(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18949,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18953,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3068: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_18929(t3,t2,C_slot(((C_word*)t0)[4],C_fix(1)));}

/* k18951 in k18947 in loop in ##sys#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18953(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_18953,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* mapsafe3744 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18965(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_18965,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18971,a[2]=t2,a[3]=t4,a[4]=t3,a[5]=((C_word)li533),tmp=(C_word)a,a+=6,tmp);
/* library.scm:3073: scheme#call-with-current-continuation */
t6=*((C_word*)lf[132]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t1;
av2[2]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* a18970 in mapsafe3744 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_18971(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_18971,c,av);}
a=C_alloc(9);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18977,a[2]=t2,a[3]=t4,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word)li532),tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_18977(t6,t1,((C_word*)t0)[4]);}

/* lp in a18970 in mapsafe3744 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_fcall f_18977(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_18977,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_eqp(t4,C_SCHEME_END_OF_LIST);
if(C_truep(t5)){
/* library.scm:3079: empty */
t6=((C_word*)t0)[2];{
C_word av2[3];
av2[0]=t6;
av2[1]=t1;
av2[2]=C_SCHEME_END_OF_LIST;
((C_proc)C_fast_retrieve_proc(t6))(3,av2);}}
else{
if(C_truep(C_i_pairp(t4))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19009,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3081: p */
t7=((C_word*)t0)[4];{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t4;
((C_proc)C_fast_retrieve_proc(t7))(3,av2);}}
else{
/* library.scm:3082: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[47]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[47]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}}}}

/* k19007 in lp in a18970 in mapsafe3744 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19009(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_19009,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19013,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3081: lp */
t3=((C_word*)((C_word*)t0)[3])[1];
f_18977(t3,t2,C_slot(((C_word*)t0)[4],C_fix(1)));}

/* k19011 in k19007 in lp in a18970 in mapsafe3744 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 in ... */
static void C_ccall f_19013(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_19013,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#for-each in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19023(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +11,c,3)))){
C_save_and_reclaim((void*)f_19023,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+11);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
if(C_truep(C_rest_nullp(c,4))){
t5=C_i_check_list_2(t3,lf[706]);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19038,a[2]=t7,a[3]=t2,a[4]=((C_word)li535),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_19038(t9,t1,t3);}
else{
t5=C_a_i_cons(&a,2,t3,t4);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19068,a[2]=t7,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li538),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_19068(t9,t1,t5);}}

/* for-each-loop3764 in scheme#for-each in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_fcall f_19038(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_19038,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19048,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3087: g3765 */
t4=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k19046 in for-each-loop3764 in scheme#for-each in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19048(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19048,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_19038(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}

/* loop in scheme#for-each in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_fcall f_19068(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,4)))){
C_save_and_reclaim_args((void *)trf_19068,3,t0,t1,t2);}
a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19075,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t2,a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19099,a[2]=((C_word)li537),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3090: mapsafe */
t5=((C_word*)((C_word*)t0)[3])[1];{
C_word av2[5];
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
av2[3]=t2;
av2[4]=lf[706];
((C_proc)C_fast_retrieve_proc(t5))(5,av2);}}

/* k19073 in loop in scheme#for-each in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19075(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_19075,c,av);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t1))){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19084,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=t1;
C_apply(4,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k19082 in k19073 in loop in scheme#for-each in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19084(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_19084,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19091,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19093,a[2]=((C_word)li536),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3093: mapsafe */
t4=((C_word*)((C_word*)t0)[4])[1];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
av2[3]=((C_word*)t0)[5];
av2[4]=lf[706];
((C_proc)C_fast_retrieve_proc(t4))(5,av2);}}

/* k19089 in k19082 in k19073 in loop in scheme#for-each in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 in ... */
static void C_ccall f_19091(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19091,c,av);}
/* library.scm:3093: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_19068(t2,((C_word*)t0)[3],t1);}

/* a19092 in k19082 in k19073 in loop in scheme#for-each in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 in ... */
static void C_ccall f_19093(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19093,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a19098 in loop in scheme#for-each in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19099(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19099,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19105(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +14,c,3)))){
C_save_and_reclaim((void*)f_19105,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+14);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
if(C_truep(C_rest_nullp(c,4))){
t5=C_a_i_cons(&a,2,C_SCHEME_UNDEFINED,C_SCHEME_END_OF_LIST);
t6=t5;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=((C_word*)t7)[1];
t9=C_i_check_list_2(t3,lf[708]);
t10=C_SCHEME_UNDEFINED;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=C_set_block_item(t11,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19123,a[2]=t7,a[3]=t11,a[4]=t2,a[5]=t8,a[6]=((C_word)li540),tmp=(C_word)a,a+=7,tmp));
t13=((C_word*)t11)[1];
f_19123(t13,t1,t3);}
else{
t5=C_a_i_cons(&a,2,t3,t4);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19164,a[2]=t7,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li543),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_19164(t9,t1,t5);}}

/* map-loop3792 in scheme#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_fcall f_19123(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_19123,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19148,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:3098: g3798 */
t4=((C_word*)t0)[4];{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_slot(((C_word*)t0)[5],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k19146 in map-loop3792 in scheme#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19148(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_19148,c,av);}
a=C_alloc(3);
t2=C_a_i_cons(&a,2,t1,C_SCHEME_END_OF_LIST);
t3=C_i_setslot(((C_word*)((C_word*)t0)[2])[1],C_fix(1),t2);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,t2);
t5=((C_word*)((C_word*)t0)[3])[1];
f_19123(t5,((C_word*)t0)[4],C_slot(((C_word*)t0)[5],C_fix(1)));}

/* loop in scheme#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_fcall f_19164(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,4)))){
C_save_and_reclaim_args((void *)trf_19164,3,t0,t1,t2);}
a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19171,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19200,a[2]=((C_word)li542),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3101: mapsafe */
t5=((C_word*)((C_word*)t0)[3])[1];{
C_word av2[5];
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
av2[3]=t2;
av2[4]=lf[708];
((C_proc)C_fast_retrieve_proc(t5))(5,av2);}}

/* k19169 in loop in scheme#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19171(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_19171,c,av);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t1))){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19184,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=t1;
C_apply(4,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k19182 in k19169 in loop in scheme#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19184(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,4)))){
C_save_and_reclaim((void *)f_19184,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19188,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19192,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19194,a[2]=((C_word)li541),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3104: mapsafe */
t5=((C_word*)((C_word*)t0)[4])[1];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
av2[3]=((C_word*)t0)[5];
av2[4]=lf[708];
((C_proc)C_fast_retrieve_proc(t5))(5,av2);}}

/* k19186 in k19182 in k19169 in loop in scheme#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 in ... */
static void C_ccall f_19188(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_19188,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k19190 in k19182 in k19169 in loop in scheme#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 in ... */
static void C_ccall f_19192(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19192,c,av);}
/* library.scm:3104: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_19164(t2,((C_word*)t0)[3],t1);}

/* a19193 in k19182 in k19169 in loop in scheme#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 in ... */
static void C_ccall f_19194(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19194,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a19199 in loop in scheme#map in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19200(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19200,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#dynamic-wind in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19207(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_19207,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19211,a[2]=t2,a[3]=t4,a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* library.scm:3124: before */
t6=t2;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)C_fast_retrieve_proc(t6))(2,av2);}}

/* k19209 in scheme#dynamic-wind in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19211(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,3)))){
C_save_and_reclaim((void *)f_19211,c,av);}
a=C_alloc(10);
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_a_i_cons(&a,2,t2,C_fast_retrieve(lf[709]));
t4=C_mutate((C_word*)lf[709]+1 /* (set! ##sys#dynamic-winds ...) */,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19220,a[2]=((C_word*)t0)[3],a[3]=((C_word)li545),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3126: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[5];
av2[3]=t5;
C_call_with_values(4,av2);}}

/* a19219 in k19209 in scheme#dynamic-wind in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19220(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_19220,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_slot(C_fast_retrieve(lf[709]),C_fix(1));
t4=C_mutate((C_word*)lf[709]+1 /* (set! ##sys#dynamic-winds ...) */,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19228,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3130: after */
t6=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)C_fast_retrieve_proc(t6))(2,av2);}}

/* k19226 in a19219 in k19209 in scheme#dynamic-wind in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19228(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19228,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* scheme#call-with-current-continuation in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19238(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_19238,c,av);}
a=C_alloc(5);
t3=C_fast_retrieve(lf[709]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19244,a[2]=t3,a[3]=t2,a[4]=((C_word)li548),tmp=(C_word)a,a+=5,tmp);
/* library.scm:3138: ##sys#call-with-current-continuation */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
C_call_cc(3,av2);}}

/* a19243 in scheme#call-with-current-continuation in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19244(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19244,c,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19247,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li547),tmp=(C_word)a,a+=5,tmp);
/* library.scm:3144: proc */
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}

/* continuation in a19243 in scheme#call-with-current-continuation in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19247(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_19247,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+5);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19251,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fast_retrieve(lf[709]),((C_word*)t0)[3]);
if(C_truep(t4)){{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
C_apply(4,av2);}}
else{
t5=C_i_length(C_fast_retrieve(lf[709]));
t6=C_i_length(((C_word*)t0)[3]);
/* library.scm:3142: ##sys#dynamic-unwind */
f_19278(t3,((C_word*)t0)[3],C_fixnum_difference(t5,t6));}}

/* k19249 in continuation in a19243 in scheme#call-with-current-continuation in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19251(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19251,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
C_apply(4,av2);}}

/* ##sys#dynamic-unwind in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_fcall f_19278(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_19278,3,t1,t2,t3);}
a=C_alloc(5);
t4=C_eqp(C_fast_retrieve(lf[709]),t2);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19294,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3151: ##sys#dynamic-unwind */
t11=t5;
t12=C_slot(t2,C_fix(1));
t13=C_fixnum_plus(t3,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
goto loop;}
else{
t5=C_slot(C_fast_retrieve(lf[709]),C_fix(0));
t6=C_slot(t5,C_fix(1));
t7=C_slot(C_fast_retrieve(lf[709]),C_fix(1));
t8=C_mutate((C_word*)lf[709]+1 /* (set! ##sys#dynamic-winds ...) */,t7);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19323,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3157: after */
t10=t6;{
C_word av2[2];
av2[0]=t10;
av2[1]=t9;
((C_proc)C_fast_retrieve_proc(t10))(2,av2);}}}}

/* k19292 in ##sys#dynamic-unwind in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19294(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_19294,c,av);}
a=C_alloc(4);
t2=C_slot(((C_word*)t0)[2],C_fix(0));
t3=C_slot(t2,C_fix(0));
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19300,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:3149: g3852 */
t5=t3;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)C_fast_retrieve_proc(t5))(2,av2);}}

/* k19298 in k19292 in ##sys#dynamic-unwind in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19300(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19300,c,av);}
t2=C_mutate((C_word*)lf[709]+1 /* (set! ##sys#dynamic-winds ...) */,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k19321 in ##sys#dynamic-unwind in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19323(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19323,c,av);}
/* library.scm:3158: ##sys#dynamic-unwind */
f_19278(((C_word*)t0)[2],((C_word*)t0)[3],C_fixnum_difference(((C_word*)t0)[4],C_fix(1)));}

/* chicken.base#port? in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19336(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19336,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_portp(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#input-port-open? in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19342(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19342,c,av);}
t3=C_i_check_port(t2,C_fix(1),lf[712]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_input_port_openp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.base#output-port-open? in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19347(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19347,c,av);}
t3=C_i_check_port(t2,C_fix(2),lf[713]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_output_port_openp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.base#port-closed? in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19352(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19352,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19356,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3180: ##sys#check-port */
t4=*((C_word*)lf[714]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[715];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k19354 in chicken.base#port-closed? in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19356(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19356,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_eqp(C_slot(((C_word*)t0)[3],C_fix(8)),C_fix(0));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#make-port in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19365(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(17,c,1)))){
C_save_and_reclaim((void *)f_19365,c,av);}
a=C_alloc(17);
t6=C_a_i_port(&a,0);
t7=C_i_set_i_slot(t6,C_fix(1),t2);
t8=C_i_setslot(t6,C_fix(2),t3);
t9=C_i_setslot(t6,C_fix(3),t4);
t10=C_i_set_i_slot(t6,C_fix(4),C_fix(1));
t11=C_i_set_i_slot(t6,C_fix(5),C_fix(0));
t12=C_i_setslot(t6,C_fix(7),t5);
t13=C_i_setslot(t6,C_fix(8),t2);
t14=t1;{
C_word *av2=av;
av2[0]=t14;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t14+1)))(2,av2);}}

/* k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19396(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_19396,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[732]+1 /* (set! ##sys#standard-input ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19400,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3330: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[716]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[716]+1);
av2[1]=t3;
av2[2]=C_fix(2);
av2[3]=C_fast_retrieve(lf[730]);
av2[4]=lf[1429];
av2[5]=lf[749];
tp(6,av2);}}

/* k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19400(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_19400,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[733]+1 /* (set! ##sys#standard-output ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19404,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3331: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[716]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[716]+1);
av2[1]=t3;
av2[2]=C_fix(2);
av2[3]=C_fast_retrieve(lf[730]);
av2[4]=lf[1428];
av2[5]=lf[749];
tp(6,av2);}}

/* k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19404(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_19404,c,av);}
a=C_alloc(3);
t2=C_mutate((C_word*)lf[734]+1 /* (set! ##sys#standard-error ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19407,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3333: ##sys#open-file-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[731]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[731]+1);
av2[1]=t3;
av2[2]=*((C_word*)lf[732]+1);
av2[3]=C_fix(0);
av2[4]=C_SCHEME_FALSE;
tp(5,av2);}}

/* k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 */
static void C_ccall f_19407(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_19407,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19410,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3334: ##sys#open-file-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[731]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[731]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[733]+1);
av2[3]=C_fix(1);
av2[4]=C_SCHEME_FALSE;
tp(5,av2);}}

/* k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in k8834 in ... */
static void C_ccall f_19410(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_19410,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19413,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3335: ##sys#open-file-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[731]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[731]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[734]+1);
av2[3]=C_fix(2);
av2[4]=C_SCHEME_FALSE;
tp(5,av2);}}

/* k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in k10751 in ... */
static void C_ccall f_19413(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(119,c,6)))){
C_save_and_reclaim((void *)f_19413,c,av);}
a=C_alloc(119);
t2=C_mutate((C_word*)lf[735]+1 /* (set! ##sys#check-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19415,a[2]=((C_word)li572),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[736]+1 /* (set! ##sys#check-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19426,a[2]=((C_word)li573),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[714]+1 /* (set! ##sys#check-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19437,a[2]=((C_word)li574),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[737]+1 /* (set! ##sys#check-open-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19448,a[2]=((C_word)li575),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[135]+1 /* (set! scheme#current-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19459,a[2]=((C_word)li577),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[136]+1 /* (set! scheme#current-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19520,a[2]=((C_word)li579),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[192]+1 /* (set! chicken.base#current-error-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19581,a[2]=((C_word)li581),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[741]+1 /* (set! ##sys#tty-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19642,a[2]=((C_word)li582),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[743]+1 /* (set! ##sys#port-data ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19656,a[2]=((C_word)li583),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[744]+1 /* (set! ##sys#set-port-data! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19662,a[2]=((C_word)li584),tmp=(C_word)a,a+=3,tmp));
t12=C_SCHEME_UNDEFINED;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_SCHEME_UNDEFINED;
t15=(*a=C_VECTOR_TYPE|1,a[1]=t14,tmp=(C_word)a,a+=2,tmp);
t16=C_set_block_item(t13,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19668,a[2]=((C_word)li586),tmp=(C_word)a,a+=3,tmp));
t17=C_set_block_item(t15,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19767,a[2]=((C_word)li587),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate((C_word*)lf[137]+1 /* (set! scheme#open-input-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19804,a[2]=t13,a[3]=((C_word)li588),tmp=(C_word)a,a+=4,tmp));
t19=C_mutate((C_word*)lf[138]+1 /* (set! scheme#open-output-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19810,a[2]=t13,a[3]=((C_word)li589),tmp=(C_word)a,a+=4,tmp));
t20=C_mutate((C_word*)lf[139]+1 /* (set! scheme#close-input-port ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19816,a[2]=t15,a[3]=((C_word)li590),tmp=(C_word)a,a+=4,tmp));
t21=C_mutate((C_word*)lf[140]+1 /* (set! scheme#close-output-port ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19822,a[2]=t15,a[3]=((C_word)li591),tmp=(C_word)a,a+=4,tmp));
t22=*((C_word*)lf[137]+1);
t23=C_mutate((C_word*)lf[141]+1 /* (set! scheme#call-with-input-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19828,a[2]=t22,a[3]=((C_word)li594),tmp=(C_word)a,a+=4,tmp));
t24=*((C_word*)lf[138]+1);
t25=C_mutate((C_word*)lf[142]+1 /* (set! scheme#call-with-output-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19852,a[2]=t24,a[3]=((C_word)li597),tmp=(C_word)a,a+=4,tmp));
t26=*((C_word*)lf[137]+1);
t27=C_mutate((C_word*)lf[143]+1 /* (set! scheme#with-input-from-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19876,a[2]=t26,a[3]=((C_word)li602),tmp=(C_word)a,a+=4,tmp));
t28=*((C_word*)lf[138]+1);
t29=C_mutate((C_word*)lf[144]+1 /* (set! scheme#with-output-to-file ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19910,a[2]=t28,a[3]=((C_word)li607),tmp=(C_word)a,a+=4,tmp));
t30=C_mutate((C_word*)lf[762]+1 /* (set! ##sys#file-exists? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19944,a[2]=((C_word)li608),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[765]+1 /* (set! ##sys#flush-output ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19970,a[2]=((C_word)li609),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate((C_word*)lf[216]+1 /* (set! chicken.base#flush-output ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19983,a[2]=((C_word)li610),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[767]+1 /* (set! ##sys#port-line ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20001,a[2]=((C_word)li611),tmp=(C_word)a,a+=3,tmp));
t34=C_mutate((C_word*)lf[768]+1 /* (set! ##sys#decorate-lambda ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20010,a[2]=((C_word)li614),tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[769]+1 /* (set! ##sys#lambda-decoration ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20085,a[2]=((C_word)li616),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[770]+1 /* (set! ##sys#make-lambda-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20124,a[2]=((C_word)li617),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[771]+1 /* (set! ##sys#lambda-info? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20133,a[2]=((C_word)li618),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[772]+1 /* (set! ##sys#lambda-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20146,a[2]=((C_word)li619),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[773]+1 /* (set! ##sys#lambda-info->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20152,a[2]=((C_word)li620),tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[202]+1 /* (set! chicken.base#procedure-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20161,a[2]=((C_word)li621),tmp=(C_word)a,a+=3,tmp));
t41=C_a_i_vector1(&a,1,lf[776]);
t42=C_mutate(&lf[777] /* (set! setter-tag ...) */,t41);
t43=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20190,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t44=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32879,a[2]=((C_word)li1035),tmp=(C_word)a,a+=3,tmp);
t45=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32919,a[2]=((C_word)li1036),tmp=(C_word)a,a+=3,tmp);
t46=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_32935,a[2]=((C_word)li1040),tmp=(C_word)a,a+=3,tmp);
/* library.scm:3565: ##sys#decorate-lambda */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[768]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[768]+1);
av2[1]=t43;
av2[2]=t44;
av2[3]=t45;
av2[4]=t46;
tp(5,av2);}}

/* ##sys#check-input-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19415(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_19415,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=C_i_pairp(t4);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_check_port_2(t2,C_fix(1),t3,C_get_rest_arg(c,4,av,4,t0)):C_i_check_port(t2,C_fix(1),t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#check-output-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19426(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_19426,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=C_i_pairp(t4);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_check_port_2(t2,C_fix(2),t3,C_get_rest_arg(c,4,av,4,t0)):C_i_check_port(t2,C_fix(2),t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#check-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19437(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_19437,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_port_2(t2,C_fix(0),C_SCHEME_FALSE,C_get_rest_arg(c,3,av,3,t0)):C_i_check_port(t2,C_fix(0),C_SCHEME_FALSE));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-open-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19448(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_19448,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_port_2(t2,C_fix(0),C_SCHEME_TRUE,C_get_rest_arg(c,3,av,3,t0)):C_i_check_port(t2,C_fix(0),C_SCHEME_TRUE));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#current-input-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19459(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_19459,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+5);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t2))){
t3=*((C_word*)lf[732]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[732]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19472,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3362: ##sys#check-port */
t5=*((C_word*)lf[714]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[738];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k19470 in scheme#current-input-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in ... */
static void C_ccall f_19472(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_19472,c,av);}
a=C_alloc(10);
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19474,a[2]=((C_word*)t0)[3],a[3]=((C_word)li576),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19480,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19485,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
t6=(
/* library.scm:3363: def-convert?3978 */
  f_19485(t5)
);
t7=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t7;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_i_car(t2);
t7=C_u_i_cdr(t2);
if(C_truep(C_i_nullp(t7))){
t8=(
/* library.scm:3363: def-set?3979 */
  f_19480(t4)
);
t9=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t8=C_i_car(t7);
t9=C_u_i_cdr(t7);
t10=(
/* library.scm:3363: body3976 */
  f_19474(t3,t8)
);
t11=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t11;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}}

/* body3976 in k19470 in scheme#current-input-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static C_word C_fcall f_19474(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_overflow_check;{}
if(C_truep(t1)){
t2=C_mutate((C_word*)lf[732]+1 /* (set! ##sys#standard-input ...) */,((C_word*)t0)[2]);
return(t2);}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* def-set?3979 in k19470 in scheme#current-input-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static C_word C_fcall f_19480(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3363: body3976 */
  f_19474(((C_word*)t0)[2],C_SCHEME_TRUE)
));}

/* def-convert?3978 in k19470 in scheme#current-input-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static C_word C_fcall f_19485(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3363: def-set?3979 */
  f_19480(((C_word*)t0)[2])
));}

/* scheme#current-output-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19520(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_19520,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+5);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t2))){
t3=*((C_word*)lf[733]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[733]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19533,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3372: ##sys#check-port */
t5=*((C_word*)lf[714]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[739];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k19531 in scheme#current-output-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in ... */
static void C_ccall f_19533(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_19533,c,av);}
a=C_alloc(10);
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19535,a[2]=((C_word*)t0)[3],a[3]=((C_word)li578),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19541,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19546,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
t6=(
/* library.scm:3373: def-convert?4003 */
  f_19546(t5)
);
t7=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t7;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_i_car(t2);
t7=C_u_i_cdr(t2);
if(C_truep(C_i_nullp(t7))){
t8=(
/* library.scm:3373: def-set?4004 */
  f_19541(t4)
);
t9=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t8=C_i_car(t7);
t9=C_u_i_cdr(t7);
t10=(
/* library.scm:3373: body4001 */
  f_19535(t3,t8)
);
t11=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t11;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}}

/* body4001 in k19531 in scheme#current-output-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static C_word C_fcall f_19535(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_overflow_check;{}
if(C_truep(t1)){
t2=C_mutate((C_word*)lf[733]+1 /* (set! ##sys#standard-output ...) */,((C_word*)t0)[2]);
return(t2);}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* def-set?4004 in k19531 in scheme#current-output-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static C_word C_fcall f_19541(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3373: body4001 */
  f_19535(((C_word*)t0)[2],C_SCHEME_TRUE)
));}

/* def-convert?4003 in k19531 in scheme#current-output-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static C_word C_fcall f_19546(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3373: def-set?4004 */
  f_19541(((C_word*)t0)[2])
));}

/* chicken.base#current-error-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19581(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_19581,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+5);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t2))){
t3=*((C_word*)lf[734]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[734]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19594,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3382: ##sys#check-port */
t5=*((C_word*)lf[714]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[740];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k19592 in chicken.base#current-error-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in ... */
static void C_ccall f_19594(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_19594,c,av);}
a=C_alloc(10);
t2=C_u_i_cdr(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19596,a[2]=((C_word*)t0)[3],a[3]=((C_word)li580),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19602,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19607,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
t6=(
/* library.scm:3383: def-convert?4028 */
  f_19607(t5)
);
t7=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t7;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_i_car(t2);
t7=C_u_i_cdr(t2);
if(C_truep(C_i_nullp(t7))){
t8=(
/* library.scm:3383: def-set?4029 */
  f_19602(t4)
);
t9=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t8=C_i_car(t7);
t9=C_u_i_cdr(t7);
t10=(
/* library.scm:3383: body4026 */
  f_19596(t3,t8)
);
t11=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t11;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}}

/* body4026 in k19592 in chicken.base#current-error-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static C_word C_fcall f_19596(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_overflow_check;{}
if(C_truep(t1)){
t2=C_mutate((C_word*)lf[734]+1 /* (set! ##sys#standard-error ...) */,((C_word*)t0)[2]);
return(t2);}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* def-set?4029 in k19592 in chicken.base#current-error-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static C_word C_fcall f_19602(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3383: body4026 */
  f_19596(((C_word*)t0)[2],C_SCHEME_TRUE)
));}

/* def-convert?4028 in k19592 in chicken.base#current-error-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static C_word C_fcall f_19607(C_word t0){
C_word tmp;
C_word t1;
C_stack_overflow_check;{}
return((
/* library.scm:3383: def-set?4029 */
  f_19602(((C_word*)t0)[2])
));}

/* ##sys#tty-port? in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19642(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19642,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19654,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3388: ##sys#peek-unsigned-integer */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[742]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[742]+1);
av2[1]=t3;
av2[2]=t2;
av2[3]=C_fix(0);
tp(4,av2);}}

/* k19652 in ##sys#tty-port? in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in ... */
static void C_ccall f_19654(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19654,c,av);}
t2=C_i_not(C_i_zerop(t1));
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(t2)?C_tty_portp(((C_word*)t0)[3]):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#port-data in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19656,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_slot(t2,C_fix(9));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#set-port-data! in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19662(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19662,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_setslot(t2,C_fix(9),t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* open in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_fcall f_19668(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(22,0,3)))){
C_save_and_reclaim_args((void *)trf_19668,5,t1,t2,t3,t4,t5);}
a=C_alloc(22);
t6=C_i_check_string_2(t2,t5);
t7=(C_truep(t3)?lf[745]:lf[746]);
t8=t7;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=lf[747];
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_19678,a[2]=t1,a[3]=t5,a[4]=t2,a[5]=t9,a[6]=t11,a[7]=t3,tmp=(C_word)a,a+=8,tmp);
t13=C_SCHEME_UNDEFINED;
t14=(*a=C_VECTOR_TYPE|1,a[1]=t13,tmp=(C_word)a,a+=2,tmp);
t15=C_set_block_item(t14,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_19712,a[2]=t14,a[3]=t11,a[4]=t3,a[5]=t5,a[6]=t9,a[7]=((C_word)li585),tmp=(C_word)a,a+=8,tmp));
t16=((C_word*)t14)[1];
f_19712(t16,t12,t4);}

/* k19676 in open in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in ... */
static void C_ccall f_19678(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_19678,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19681,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[7])){
/* library.scm:3410: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[716]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[716]+1);
av2[1]=t2;
av2[2]=C_fix(1);
av2[3]=C_fast_retrieve(lf[730]);
av2[4]=((C_word*)t0)[4];
av2[5]=lf[749];
tp(6,av2);}}
else{
/* library.scm:3410: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[716]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[716]+1);
av2[1]=t2;
av2[2]=C_fix(2);
av2[3]=C_fast_retrieve(lf[730]);
av2[4]=((C_word*)t0)[4];
av2[5]=lf[749];
tp(6,av2);}}}

/* k19679 in k19676 in open in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static void C_ccall f_19681(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,c,3)))){
C_save_and_reclaim((void *)f_19681,c,av);}
a=C_alloc(16);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19684,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19687,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19706,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* library.scm:3411: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[421]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[421]+1);
av2[1]=t4;
av2[2]=((C_word*)((C_word*)t0)[5])[1];
av2[3]=((C_word*)((C_word*)t0)[6])[1];
tp(4,av2);}}

/* k19682 in k19679 in k19676 in open in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in ... */
static void C_ccall f_19684(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19684,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k19685 in k19679 in k19676 in open in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in ... */
static void C_ccall f_19687(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19687,c,av);}
a=C_alloc(5);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19694,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
/* library.scm:3412: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[722]);
C_word *av2=av;
av2[0]=*((C_word*)lf[722]+1);
av2[1]=t2;
tp(2,av2);}}}

/* k19692 in k19685 in k19679 in k19676 in open in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in ... */
static void C_ccall f_19694(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,3)))){
C_save_and_reclaim((void *)f_19694,c,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19698,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19702,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[721]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)strerror(errno));
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k19696 in k19692 in k19685 in k19679 in k19676 in open in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in ... */
static void C_ccall f_19698(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_19698,c,av);}
/* library.scm:3412: ##sys#signal-hook/errno */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[319]);
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[319]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[718];
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
av2[5]=t1;
av2[6]=((C_word*)t0)[5];
tp(7,av2);}}

/* k19700 in k19692 in k19685 in k19679 in k19676 in open in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in ... */
static void C_ccall f_19702(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19702,c,av);}
/* library.scm:3413: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[421]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[421]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[748];
av2[3]=t1;
tp(4,av2);}}

/* k19704 in k19679 in k19676 in open in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in ... */
static void C_ccall f_19706(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_19706,c,av);}
/* library.scm:3411: ##sys#open-file-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[731]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[731]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
tp(5,av2);}}

/* doloop4063 in open in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in ... */
static void C_fcall f_19712(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,4)))){
C_save_and_reclaim_args((void *)trf_19712,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_slot(t2,C_fix(0));
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19725,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,lf[750]);
if(C_truep(t5)){
t6=C_mutate(((C_word *)((C_word*)t0)[3])+1,lf[751]);
t10=t1;
t11=C_slot(t2,C_fix(1));
t1=t10;
t2=t11;
goto loop;}
else{
t6=C_eqp(t3,lf[752]);
if(C_truep(t6)){
t7=C_mutate(((C_word *)((C_word*)t0)[3])+1,lf[753]);
t10=t1;
t11=C_slot(t2,C_fix(1));
t1=t10;
t2=t11;
goto loop;}
else{
t7=C_eqp(t3,lf[754]);
if(C_truep(t7)){
if(C_truep(((C_word*)t0)[4])){
/* library.scm:3407: ##sys#error */
t8=*((C_word*)lf[155]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t4;
av2[2]=((C_word*)t0)[5];
av2[3]=lf[755];
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}
else{
t8=C_mutate(((C_word *)((C_word*)t0)[6])+1,lf[756]);
t10=t1;
t11=C_slot(t2,C_fix(1));
t1=t10;
t2=t11;
goto loop;}}
else{
/* library.scm:3409: ##sys#error */
t8=*((C_word*)lf[155]+1);{
C_word av2[5];
av2[0]=t8;
av2[1]=t4;
av2[2]=((C_word*)t0)[5];
av2[3]=lf[757];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t8+1)))(5,av2);}}}}}}

/* k19723 in doloop4063 in open in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static void C_ccall f_19725(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19725,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_19712(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}

/* close in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_fcall f_19767(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_19767,4,t1,t2,t3,t4);}
a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19771,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:3418: ##sys#check-port */
t6=*((C_word*)lf[714]+1);{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}

/* k19769 in close in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in ... */
static void C_ccall f_19771(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_19771,c,av);}
t2=(C_truep(((C_word*)t0)[2])?C_fix(1):C_fix(2));
if(C_truep(C_port_openp(((C_word*)t0)[3],t2))){
t3=C_slot(((C_word*)t0)[3],C_fix(8));
t4=C_fixnum_not(t2);
t5=C_fixnum_and(t3,t4);
t6=C_i_set_i_slot(((C_word*)t0)[3],C_fix(8),t5);
t7=C_slot(((C_word*)t0)[3],C_fix(2));
/* library.scm:3421: g4083 */
t8=C_slot(t7,C_fix(4));{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
((C_proc)C_fast_retrieve_proc(t8))(4,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* scheme#open-input-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19804(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_19804,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
/* library.scm:3425: open */
f_19668(t1,t2,C_SCHEME_TRUE,t3,lf[758]);}

/* scheme#open-output-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19810(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_19810,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
/* library.scm:3426: open */
f_19668(t1,t2,C_SCHEME_FALSE,t3,lf[759]);}

/* scheme#close-input-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19816(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_19816,c,av);}
/* library.scm:3427: close */
f_19767(t1,t2,C_SCHEME_TRUE,lf[760]);}

/* scheme#close-output-port in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19822(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_19822,c,av);}
/* library.scm:3428: close */
f_19767(t1,t2,C_SCHEME_FALSE,lf[761]);}

/* scheme#call-with-input-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19828(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_19828,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19832,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k19830 in scheme#call-with-input-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in ... */
static void C_ccall f_19832(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_19832,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19837,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li592),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19843,a[2]=t1,a[3]=((C_word)li593),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3435: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a19836 in k19830 in scheme#call-with-input-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static void C_ccall f_19837(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19837,c,av);}
/* library.scm:3436: p */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* a19842 in k19830 in scheme#call-with-input-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static void C_ccall f_19843(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_19843,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19847,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3438: close-input-port */
t4=*((C_word*)lf[139]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k19845 in a19842 in k19830 in scheme#call-with-input-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in ... */
static void C_ccall f_19847(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19847,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* scheme#call-with-output-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19852(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_19852,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19856,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k19854 in scheme#call-with-output-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in ... */
static void C_ccall f_19856(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_19856,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19861,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li595),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19867,a[2]=t1,a[3]=((C_word)li596),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3446: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a19860 in k19854 in scheme#call-with-output-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static void C_ccall f_19861(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19861,c,av);}
/* library.scm:3447: p */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* a19866 in k19854 in scheme#call-with-output-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static void C_ccall f_19867(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_19867,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19871,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3449: close-output-port */
t4=*((C_word*)lf[140]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k19869 in a19866 in k19854 in scheme#call-with-output-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in ... */
static void C_ccall f_19871(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19871,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* scheme#with-input-from-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in k18679 in ... */
static void C_ccall f_19876(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_19876,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19880,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k19878 in scheme#with-input-from-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in k18839 in ... */
static void C_ccall f_19880(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,4)))){
C_save_and_reclaim((void *)f_19880,c,av);}
a=C_alloc(19);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19885,a[2]=t5,a[3]=t3,a[4]=((C_word)li598),tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19890,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word)li600),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19905,a[2]=t3,a[3]=t5,a[4]=((C_word)li601),tmp=(C_word)a,a+=5,tmp);
/* library.scm:3457: ##sys#dynamic-wind */
t9=*((C_word*)lf[710]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
av2[2]=t6;
av2[3]=t7;
av2[4]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}

/* a19884 in k19878 in scheme#with-input-from-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static void C_ccall f_19885(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_19885,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[732]+1));
t3=C_mutate((C_word*)lf[732]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a19889 in k19878 in scheme#with-input-from-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static void C_ccall f_19890(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19890,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19896,a[2]=((C_word*)t0)[2],a[3]=((C_word)li599),tmp=(C_word)a,a+=4,tmp);
/* library.scm:3458: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* a19895 in a19889 in k19878 in scheme#with-input-from-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in ... */
static void C_ccall f_19896(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_19896,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19900,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:3460: close-input-port */
t4=*((C_word*)lf[139]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k19898 in a19895 in a19889 in k19878 in scheme#with-input-from-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in ... */
static void C_ccall f_19900(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19900,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* a19904 in k19878 in scheme#with-input-from-file in k19411 in k19408 in k19405 in k19402 in k19398 in k19394 in k18878 in k18875 in k18872 in k18869 in k18866 in k18863 in k18860 in k18857 in k18854 in k18851 in k18848 in k18845 in k18842 in ... */
static void C_ccall f_19905(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand