// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/registry/owner/v1/organization_service.proto

//go:build !protoopaque

package ownerv1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListOrganizationsRequest_Order int32

const (
	ListOrganizationsRequest_ORDER_UNSPECIFIED ListOrganizationsRequest_Order = 0
	// Order by create_time newest to oldest.
	ListOrganizationsRequest_ORDER_CREATE_TIME_DESC ListOrganizationsRequest_Order = 1
	// Order by create_time oldest to newest.
	ListOrganizationsRequest_ORDER_CREATE_TIME_ASC ListOrganizationsRequest_Order = 2
)

// Enum value maps for ListOrganizationsRequest_Order.
var (
	ListOrganizationsRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
	}
	ListOrganizationsRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
	}
)

func (x ListOrganizationsRequest_Order) Enum() *ListOrganizationsRequest_Order {
	p := new(ListOrganizationsRequest_Order)
	*p = x
	return p
}

func (x ListOrganizationsRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListOrganizationsRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_owner_v1_organization_service_proto_enumTypes[0].Descriptor()
}

func (ListOrganizationsRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_owner_v1_organization_service_proto_enumTypes[0]
}

func (x ListOrganizationsRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type GetOrganizationsRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Organizations to request.
	OrganizationRefs []*OrganizationRef `protobuf:"bytes,1,rep,name=organization_refs,json=organizationRefs,proto3" json:"organization_refs,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *GetOrganizationsRequest) Reset() {
	*x = GetOrganizationsRequest{}
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrganizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationsRequest) ProtoMessage() {}

func (x *GetOrganizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetOrganizationsRequest) GetOrganizationRefs() []*OrganizationRef {
	if x != nil {
		return x.OrganizationRefs
	}
	return nil
}

func (x *GetOrganizationsRequest) SetOrganizationRefs(v []*OrganizationRef) {
	x.OrganizationRefs = v
}

type GetOrganizationsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Organizations to request.
	OrganizationRefs []*OrganizationRef
}

func (b0 GetOrganizationsRequest_builder) Build() *GetOrganizationsRequest {
	m0 := &GetOrganizationsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.OrganizationRefs = b.OrganizationRefs
	return m0
}

type GetOrganizationsResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The retrieved Organizations in the same order as requested.
	Organizations []*Organization `protobuf:"bytes,1,rep,name=organizations,proto3" json:"organizations,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetOrganizationsResponse) Reset() {
	*x = GetOrganizationsResponse{}
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetOrganizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOrganizationsResponse) ProtoMessage() {}

func (x *GetOrganizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *GetOrganizationsResponse) GetOrganizations() []*Organization {
	if x != nil {
		return x.Organizations
	}
	return nil
}

func (x *GetOrganizationsResponse) SetOrganizations(v []*Organization) {
	x.Organizations = v
}

type GetOrganizationsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The retrieved Organizations in the same order as requested.
	Organizations []*Organization
}

func (b0 GetOrganizationsResponse_builder) Build() *GetOrganizationsResponse {
	m0 := &GetOrganizationsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Organizations = b.Organizations
	return m0
}

type ListOrganizationsRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The ids of the specific Users to list Organizations for.
	//
	// If this is empty, all Organizations are listed, but this functionality
	// is limited to Users with the necessary permissions.
	UserRefs []*UserRef `protobuf:"bytes,3,rep,name=user_refs,json=userRefs,proto3" json:"user_refs,omitempty"`
	// The order to return the Organizations.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order         ListOrganizationsRequest_Order `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.owner.v1.ListOrganizationsRequest_Order" json:"order,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListOrganizationsRequest) Reset() {
	*x = ListOrganizationsRequest{}
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationsRequest) ProtoMessage() {}

func (x *ListOrganizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListOrganizationsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOrganizationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListOrganizationsRequest) GetUserRefs() []*UserRef {
	if x != nil {
		return x.UserRefs
	}
	return nil
}

func (x *ListOrganizationsRequest) GetOrder() ListOrganizationsRequest_Order {
	if x != nil {
		return x.Order
	}
	return ListOrganizationsRequest_ORDER_UNSPECIFIED
}

func (x *ListOrganizationsRequest) SetPageSize(v uint32) {
	x.PageSize = v
}

func (x *ListOrganizationsRequest) SetPageToken(v string) {
	x.PageToken = v
}

func (x *ListOrganizationsRequest) SetUserRefs(v []*UserRef) {
	x.UserRefs = v
}

func (x *ListOrganizationsRequest) SetOrder(v ListOrganizationsRequest_Order) {
	x.Order = v
}

type ListOrganizationsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string
	// The ids of the specific Users to list Organizations for.
	//
	// If this is empty, all Organizations are listed, but this functionality
	// is limited to Users with the necessary permissions.
	UserRefs []*UserRef
	// The order to return the Organizations.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListOrganizationsRequest_Order
}

func (b0 ListOrganizationsRequest_builder) Build() *ListOrganizationsRequest {
	m0 := &ListOrganizationsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.PageSize = b.PageSize
	x.PageToken = b.PageToken
	x.UserRefs = b.UserRefs
	x.Order = b.Order
	return m0
}

type ListOrganizationsResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The listed Organizations.
	Organizations []*Organization `protobuf:"bytes,2,rep,name=organizations,proto3" json:"organizations,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListOrganizationsResponse) Reset() {
	*x = ListOrganizationsResponse{}
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListOrganizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOrganizationsResponse) ProtoMessage() {}

func (x *ListOrganizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListOrganizationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListOrganizationsResponse) GetOrganizations() []*Organization {
	if x != nil {
		return x.Organizations
	}
	return nil
}

func (x *ListOrganizationsResponse) SetNextPageToken(v string) {
	x.NextPageToken = v
}

func (x *ListOrganizationsResponse) SetOrganizations(v []*Organization) {
	x.Organizations = v
}

type ListOrganizationsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string
	// The listed Organizations.
	Organizations []*Organization
}

func (b0 ListOrganizationsResponse_builder) Build() *ListOrganizationsResponse {
	m0 := &ListOrganizationsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.NextPageToken = b.NextPageToken
	x.Organizations = b.Organizations
	return m0
}

type CreateOrganizationsRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Organizations to create.
	Values        []*CreateOrganizationsRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateOrganizationsRequest) Reset() {
	*x = CreateOrganizationsRequest{}
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateOrganizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrganizationsRequest) ProtoMessage() {}

func (x *CreateOrganizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateOrganizationsRequest) GetValues() []*CreateOrganizationsRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *CreateOrganizationsRequest) SetValues(v []*CreateOrganizationsRequest_Value) {
	x.Values = v
}

type CreateOrganizationsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Organizations to create.
	Values []*CreateOrganizationsRequest_Value
}

func (b0 CreateOrganizationsRequest_builder) Build() *CreateOrganizationsRequest {
	m0 := &CreateOrganizationsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.Values = b.Values
	return m0
}

type CreateOrganizationsResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The created Organizations in the same order as given on the request.
	Organizations []*Organization `protobuf:"bytes,1,rep,name=organizations,proto3" json:"organizations,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateOrganizationsResponse) Reset() {
	*x = CreateOrganizationsResponse{}
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateOrganizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrganizationsResponse) ProtoMessage() {}

func (x *CreateOrganizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateOrganizationsResponse) GetOrganizations() []*Organization {
	if x != nil {
		return x.Organizations
	}
	return nil
}

func (x *CreateOrganizationsResponse) SetOrganizations(v []*Organization) {
	x.Organizations = v
}

type CreateOrganizationsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The created Organizations in the same order as given on the request.
	Organizations []*Organization
}

func (b0 CreateOrganizationsResponse_builder) Build() *CreateOrganizationsResponse {
	m0 := &CreateOrganizationsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Organizations = b.Organizations
	return m0
}

type UpdateOrganizationsRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Organizations to update.
	Values        []*UpdateOrganizationsRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateOrganizationsRequest) Reset() {
	*x = UpdateOrganizationsRequest{}
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationsRequest) ProtoMessage() {}

func (x *UpdateOrganizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateOrganizationsRequest) GetValues() []*UpdateOrganizationsRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *UpdateOrganizationsRequest) SetValues(v []*UpdateOrganizationsRequest_Value) {
	x.Values = v
}

type UpdateOrganizationsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Organizations to update.
	Values []*UpdateOrganizationsRequest_Value
}

func (b0 UpdateOrganizationsRequest_builder) Build() *UpdateOrganizationsRequest {
	m0 := &UpdateOrganizationsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.Values = b.Values
	return m0
}

type UpdateOrganizationsResponse struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The updated Organizations in the same order as given on the request.
	Organizations []*Organization `protobuf:"bytes,1,rep,name=organizations,proto3" json:"organizations,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateOrganizationsResponse) Reset() {
	*x = UpdateOrganizationsResponse{}
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationsResponse) ProtoMessage() {}

func (x *UpdateOrganizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateOrganizationsResponse) GetOrganizations() []*Organization {
	if x != nil {
		return x.Organizations
	}
	return nil
}

func (x *UpdateOrganizationsResponse) SetOrganizations(v []*Organization) {
	x.Organizations = v
}

type UpdateOrganizationsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The updated Organizations in the same order as given on the request.
	Organizations []*Organization
}

func (b0 UpdateOrganizationsResponse_builder) Build() *UpdateOrganizationsResponse {
	m0 := &UpdateOrganizationsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Organizations = b.Organizations
	return m0
}

type DeleteOrganizationsRequest struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The Organizations to delete.
	OrganizationRefs []*OrganizationRef `protobuf:"bytes,1,rep,name=organization_refs,json=organizationRefs,proto3" json:"organization_refs,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *DeleteOrganizationsRequest) Reset() {
	*x = DeleteOrganizationsRequest{}
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteOrganizationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOrganizationsRequest) ProtoMessage() {}

func (x *DeleteOrganizationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DeleteOrganizationsRequest) GetOrganizationRefs() []*OrganizationRef {
	if x != nil {
		return x.OrganizationRefs
	}
	return nil
}

func (x *DeleteOrganizationsRequest) SetOrganizationRefs(v []*OrganizationRef) {
	x.OrganizationRefs = v
}

type DeleteOrganizationsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The Organizations to delete.
	OrganizationRefs []*OrganizationRef
}

func (b0 DeleteOrganizationsRequest_builder) Build() *DeleteOrganizationsRequest {
	m0 := &DeleteOrganizationsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.OrganizationRefs = b.OrganizationRefs
	return m0
}

type DeleteOrganizationsResponse struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteOrganizationsResponse) Reset() {
	*x = DeleteOrganizationsResponse{}
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteOrganizationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOrganizationsResponse) ProtoMessage() {}

func (x *DeleteOrganizationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DeleteOrganizationsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DeleteOrganizationsResponse_builder) Build() *DeleteOrganizationsResponse {
	m0 := &DeleteOrganizationsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

// An individual request to create an Organization.
type CreateOrganizationsRequest_Value struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The name of the Organization.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The configurable description of the Organization.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The configurable URL that represents the homepage for an Organization.
	Url string `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	// The verification status of the Organization.
	//
	// If not set, the Organization will default to VERIFICATION_STATUS_UNVERIFIED.
	VerificationStatus OrganizationVerificationStatus `protobuf:"varint,4,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.registry.owner.v1.OrganizationVerificationStatus" json:"verification_status,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *CreateOrganizationsRequest_Value) Reset() {
	*x = CreateOrganizationsRequest_Value{}
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateOrganizationsRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrganizationsRequest_Value) ProtoMessage() {}

func (x *CreateOrganizationsRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *CreateOrganizationsRequest_Value) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateOrganizationsRequest_Value) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateOrganizationsRequest_Value) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *CreateOrganizationsRequest_Value) GetVerificationStatus() OrganizationVerificationStatus {
	if x != nil {
		return x.VerificationStatus
	}
	return OrganizationVerificationStatus_ORGANIZATION_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *CreateOrganizationsRequest_Value) SetName(v string) {
	x.Name = v
}

func (x *CreateOrganizationsRequest_Value) SetDescription(v string) {
	x.Description = v
}

func (x *CreateOrganizationsRequest_Value) SetUrl(v string) {
	x.Url = v
}

func (x *CreateOrganizationsRequest_Value) SetVerificationStatus(v OrganizationVerificationStatus) {
	x.VerificationStatus = v
}

type CreateOrganizationsRequest_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the Organization.
	Name string
	// The configurable description of the Organization.
	Description string
	// The configurable URL that represents the homepage for an Organization.
	Url string
	// The verification status of the Organization.
	//
	// If not set, the Organization will default to VERIFICATION_STATUS_UNVERIFIED.
	VerificationStatus OrganizationVerificationStatus
}

func (b0 CreateOrganizationsRequest_Value_builder) Build() *CreateOrganizationsRequest_Value {
	m0 := &CreateOrganizationsRequest_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.Name = b.Name
	x.Description = b.Description
	x.Url = b.Url
	x.VerificationStatus = b.VerificationStatus
	return m0
}

// An individual request to update an Organization.
type UpdateOrganizationsRequest_Value struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// The organization to update.
	OrganizationRef *OrganizationRef `protobuf:"bytes,1,opt,name=organization_ref,json=organizationRef,proto3" json:"organization_ref,omitempty"`
	// The configurable description of the Organization.
	Description *string `protobuf:"bytes,2,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// The configurable URL that represents the homepage for an Organization.
	Url *string `protobuf:"bytes,3,opt,name=url,proto3,oneof" json:"url,omitempty"`
	// The verification status of the Organization.
	VerificationStatus *OrganizationVerificationStatus `protobuf:"varint,4,opt,name=verification_status,json=verificationStatus,proto3,enum=buf.registry.owner.v1.OrganizationVerificationStatus,oneof" json:"verification_status,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *UpdateOrganizationsRequest_Value) Reset() {
	*x = UpdateOrganizationsRequest_Value{}
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateOrganizationsRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOrganizationsRequest_Value) ProtoMessage() {}

func (x *UpdateOrganizationsRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_owner_v1_organization_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *UpdateOrganizationsRequest_Value) GetOrganizationRef() *OrganizationRef {
	if x != nil {
		return x.OrganizationRef
	}
	return nil
}

func (x *UpdateOrganizationsRequest_Value) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *UpdateOrganizationsRequest_Value) GetUrl() string {
	if x != nil && x.Url != nil {
		return *x.Url
	}
	return ""
}

func (x *UpdateOrganizationsRequest_Value) GetVerificationStatus() OrganizationVerificationStatus {
	if x != nil && x.VerificationStatus != nil {
		return *x.VerificationStatus
	}
	return OrganizationVerificationStatus_ORGANIZATION_VERIFICATION_STATUS_UNSPECIFIED
}

func (x *UpdateOrganizationsRequest_Value) SetOrganizationRef(v *OrganizationRef) {
	x.OrganizationRef = v
}

func (x *UpdateOrganizationsRequest_Value) SetDescription(v string) {
	x.Description = &v
}

func (x *UpdateOrganizationsRequest_Value) SetUrl(v string) {
	x.Url = &v
}

func (x *UpdateOrganizationsRequest_Value) SetVerificationStatus(v OrganizationVerificationStatus) {
	x.VerificationStatus = &v
}

func (x *UpdateOrganizationsRequest_Value) HasOrganizationRef() bool {
	if x == nil {
		return false
	}
	return x.OrganizationRef != nil
}

func (x *UpdateOrganizationsRequest_Value) HasDescription() bool {
	if x == nil {
		return false
	}
	return x.Description != nil
}

func (x *UpdateOrganizationsRequest_Value) HasUrl() bool {
	if x == nil {
		return false
	}
	return x.Url != nil
}

func (x *UpdateOrganizationsRequest_Value) HasVerificationStatus() bool {
	if x == nil {
		return false
	}
	return x.VerificationStatus != nil
}

func (x *UpdateOrganizationsRequest_Value) ClearOrganizationRef() {
	x.OrganizationRef = nil
}

func (x *UpdateOrganizationsRequest_Value) ClearDescription() {
	x.Description = nil
}

func (x *UpdateOrganizationsRequest_Value) ClearUrl() {
	x.Url = nil
}

func (x *UpdateOrganizationsRequest_Value) ClearVerificationStatus() {
	x.VerificationStatus = nil
}

type UpdateOrganizationsRequest_Value_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The organization to update.
	OrganizationRef *OrganizationRef
	// The configurable description of the Organization.
	Description *string
	// The configurable URL that represents the homepage for an Organization.
	Url *string
	// The verification status of the Organization.
	VerificationStatus *OrganizationVerificationStatus
}

func (b0 UpdateOrganizationsRequest_Value_builder) Build() *UpdateOrganizationsRequest_Value {
	m0 := &UpdateOrganizationsRequest_Value{}
	b, x := &b0, m0
	_, _ = b, x
	x.OrganizationRef = b.OrganizationRef
	x.Description = b.Description
	x.Url = b.Url
	x.VerificationStatus = b.VerificationStatus
	return m0
}

var File_buf_registry_owner_v1_organization_service_proto protoreflect.FileDescriptor

const file_buf_registry_owner_v1_organization_service_proto_rawDesc = "" +
	"\n" +
	"0buf/registry/owner/v1/organization_service.proto\x12\x15buf.registry.owner.v1\x1a(buf/registry/owner/v1/organization.proto\x1a buf/registry/owner/v1/user.proto\x1a\x1bbuf/validate/validate.proto\"{\n" +
	"\x17GetOrganizationsRequest\x12`\n" +
	"\x11organization_refs\x18\x01 \x03(\v2&.buf.registry.owner.v1.OrganizationRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x10organizationRefs\"o\n" +
	"\x18GetOrganizationsResponse\x12S\n" +
	"\rorganizations\x18\x01 \x03(\v2#.buf.registry.owner.v1.OrganizationB\b\xbaH\x05\x92\x01\x02\b\x01R\rorganizations\"\xd5\x02\n" +
	"\x18ListOrganizationsRequest\x12%\n" +
	"\tpage_size\x18\x01 \x01(\rB\b\xbaH\x05*\x03\x18\xfa\x01R\bpageSize\x12'\n" +
	"\n" +
	"page_token\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\tpageToken\x12;\n" +
	"\tuser_refs\x18\x03 \x03(\v2\x1e.buf.registry.owner.v1.UserRefR\buserRefs\x12U\n" +
	"\x05order\x18\x04 \x01(\x0e25.buf.registry.owner.v1.ListOrganizationsRequest.OrderB\b\xbaH\x05\x82\x01\x02\x10\x01R\x05order\"U\n" +
	"\x05Order\x12\x15\n" +
	"\x11ORDER_UNSPECIFIED\x10\x00\x12\x1a\n" +
	"\x16ORDER_CREATE_TIME_DESC\x10\x01\x12\x19\n" +
	"\x15ORDER_CREATE_TIME_ASC\x10\x02\"\x98\x01\n" +
	"\x19ListOrganizationsResponse\x120\n" +
	"\x0fnext_page_token\x18\x01 \x01(\tB\b\xbaH\x05r\x03\x18\x80 R\rnextPageToken\x12I\n" +
	"\rorganizations\x18\x02 \x03(\v2#.buf.registry.owner.v1.OrganizationR\rorganizations\"\x81\x03\n" +
	"\x1aCreateOrganizationsRequest\x12\\\n" +
	"\x06values\x18\x01 \x03(\v27.buf.registry.owner.v1.CreateOrganizationsRequest.ValueB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x06values\x1a\x84\x02\n" +
	"\x05Value\x12;\n" +
	"\x04name\x18\x01 \x01(\tB'\xbaH$\xc8\x01\x01r\x1f\x10\x02\x18 2\x19^[a-z][a-z0-9-]*[a-z0-9]$R\x04name\x12*\n" +
	"\vdescription\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02R\vdescription\x12 \n" +
	"\x03url\x18\x03 \x01(\tB\x0e\xbaH\v\xd8\x01\x01r\x06\x18\xff\x01\x88\x01\x01R\x03url\x12p\n" +
	"\x13verification_status\x18\x04 \x01(\x0e25.buf.registry.owner.v1.OrganizationVerificationStatusB\b\xbaH\x05\x82\x01\x02\x10\x01R\x12verificationStatus\"r\n" +
	"\x1bCreateOrganizationsResponse\x12S\n" +
	"\rorganizations\x18\x01 \x03(\v2#.buf.registry.owner.v1.OrganizationB\b\xbaH\x05\x92\x01\x02\b\x01R\rorganizations\"\xa2\x04\n" +
	"\x1aUpdateOrganizationsRequest\x12\\\n" +
	"\x06values\x18\x01 \x03(\v27.buf.registry.owner.v1.UpdateOrganizationsRequest.ValueB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x06values\x1a\xa5\x03\n" +
	"\x05Value\x12Y\n" +
	"\x10organization_ref\x18\x01 \x01(\v2&.buf.registry.owner.v1.OrganizationRefB\x06\xbaH\x03\xc8\x01\x01R\x0forganizationRef\x12/\n" +
	"\vdescription\x18\x02 \x01(\tB\b\xbaH\x05r\x03\x18\xde\x02H\x00R\vdescription\x88\x01\x01\x12g\n" +
	"\x03url\x18\x03 \x01(\tBP\xbaHM\xba\x01E\n" +
	"\furi_or_empty\x12\x19value must be a valid URI\x1a\x1athis == '' || this.isUri()r\x03\x18\xff\x01H\x01R\x03url\x88\x01\x01\x12w\n" +
	"\x13verification_status\x18\x04 \x01(\x0e25.buf.registry.owner.v1.OrganizationVerificationStatusB\n" +
	"\xbaH\a\x82\x01\x04\x10\x01 \x00H\x02R\x12verificationStatus\x88\x01\x01B\x0e\n" +
	"\f_descriptionB\x06\n" +
	"\x04_urlB\x16\n" +
	"\x14_verification_status\"r\n" +
	"\x1bUpdateOrganizationsResponse\x12S\n" +
	"\rorganizations\x18\x01 \x03(\v2#.buf.registry.owner.v1.OrganizationB\b\xbaH\x05\x92\x01\x02\b\x01R\rorganizations\"~\n" +
	"\x1aDeleteOrganizationsRequest\x12`\n" +
	"\x11organization_refs\x18\x01 \x03(\v2&.buf.registry.owner.v1.OrganizationRefB\v\xbaH\b\x92\x01\x05\b\x01\x10\xfa\x01R\x10organizationRefs\"\x1d\n" +
	"\x1bDeleteOrganizationsResponse2\x98\x05\n" +
	"\x13OrganizationService\x12x\n" +
	"\x10GetOrganizations\x12..buf.registry.owner.v1.GetOrganizationsRequest\x1a/.buf.registry.owner.v1.GetOrganizationsResponse\"\x03\x90\x02\x01\x12{\n" +
	"\x11ListOrganizations\x12/.buf.registry.owner.v1.ListOrganizationsRequest\x1a0.buf.registry.owner.v1.ListOrganizationsResponse\"\x03\x90\x02\x01\x12\x81\x01\n" +
	"\x13CreateOrganizations\x121.buf.registry.owner.v1.CreateOrganizationsRequest\x1a2.buf.registry.owner.v1.CreateOrganizationsResponse\"\x03\x90\x02\x02\x12\x81\x01\n" +
	"\x13UpdateOrganizations\x121.buf.registry.owner.v1.UpdateOrganizationsRequest\x1a2.buf.registry.owner.v1.UpdateOrganizationsResponse\"\x03\x90\x02\x02\x12\x81\x01\n" +
	"\x13DeleteOrganizations\x121.buf.registry.owner.v1.DeleteOrganizationsRequest\x1a2.buf.registry.owner.v1.DeleteOrganizationsResponse\"\x03\x90\x02\x02BUZSbuf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/owner/v1;ownerv1b\x06proto3"

var file_buf_registry_owner_v1_organization_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_buf_registry_owner_v1_organization_service_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_buf_registry_owner_v1_organization_service_proto_goTypes = []any{
	(ListOrganizationsRequest_Order)(0),      // 0: buf.registry.owner.v1.ListOrganizationsRequest.Order
	(*GetOrganizationsRequest)(nil),          // 1: buf.registry.owner.v1.GetOrganizationsRequest
	(*GetOrganizationsResponse)(nil),         // 2: buf.registry.owner.v1.GetOrganizationsResponse
	(*ListOrganizationsRequest)(nil),         // 3: buf.registry.owner.v1.ListOrganizationsRequest
	(*ListOrganizationsResponse)(nil),        // 4: buf.registry.owner.v1.ListOrganizationsResponse
	(*CreateOrganizationsRequest)(nil),       // 5: buf.registry.owner.v1.CreateOrganizationsRequest
	(*CreateOrganizationsResponse)(nil),      // 6: buf.registry.owner.v1.CreateOrganizationsResponse
	(*UpdateOrganizationsRequest)(nil),       // 7: buf.registry.owner.v1.UpdateOrganizationsRequest
	(*UpdateOrganizationsResponse)(nil),      // 8: buf.registry.owner.v1.UpdateOrganizationsResponse
	(*DeleteOrganizationsRequest)(nil),       // 9: buf.registry.owner.v1.DeleteOrganizationsRequest
	(*DeleteOrganizationsResponse)(nil),      // 10: buf.registry.owner.v1.DeleteOrganizationsResponse
	(*CreateOrganizationsRequest_Value)(nil), // 11: buf.registry.owner.v1.CreateOrganizationsRequest.Value
	(*UpdateOrganizationsRequest_Value)(nil), // 12: buf.registry.owner.v1.UpdateOrganizationsRequest.Value
	(*OrganizationRef)(nil),                  // 13: buf.registry.owner.v1.OrganizationRef
	(*Organization)(nil),                     // 14: buf.registry.owner.v1.Organization
	(*UserRef)(nil),                          // 15: buf.registry.owner.v1.UserRef
	(OrganizationVerificationStatus)(0),      // 16: buf.registry.owner.v1.OrganizationVerificationStatus
}
var file_buf_registry_owner_v1_organization_service_proto_depIdxs = []int32{
	13, // 0: buf.registry.owner.v1.GetOrganizationsRequest.organization_refs:type_name -> buf.registry.owner.v1.OrganizationRef
	14, // 1: buf.registry.owner.v1.GetOrganizationsResponse.organizations:type_name -> buf.registry.owner.v1.Organization
	15, // 2: buf.registry.owner.v1.ListOrganizationsRequest.user_refs:type_name -> buf.registry.owner.v1.UserRef
	0,  // 3: buf.registry.owner.v1.ListOrganizationsRequest.order:type_name -> buf.registry.owner.v1.ListOrganizationsRequest.Order
	14, // 4: buf.registry.owner.v1.ListOrganizationsResponse.organizations:type_name -> buf.registry.owner.v1.Organization
	11, // 5: buf.registry.owner.v1.CreateOrganizationsRequest.values:type_name -> buf.registry.owner.v1.CreateOrganizationsRequest.Value
	14, // 6: buf.registry.owner.v1.CreateOrganizationsResponse.organizations:type_name -> buf.registry.owner.v1.Organization
	12, // 7: buf.registry.owner.v1.UpdateOrganizationsRequest.values:type_name -> buf.registry.owner.v1.UpdateOrganizationsRequest.Value
	14, // 8: buf.registry.owner.v1.UpdateOrganizationsResponse.organizations:type_name -> buf.registry.owner.v1.Organization
	13, // 9: buf.registry.owner.v1.DeleteOrganizationsRequest.organization_refs:type_name -> buf.registry.owner.v1.OrganizationRef
	16, // 10: buf.registry.owner.v1.CreateOrganizationsRequest.Value.verification_status:type_name -> buf.registry.owner.v1.OrganizationVerificationStatus
	13, // 11: buf.registry.owner.v1.UpdateOrganizationsRequest.Value.organization_ref:type_name -> buf.registry.owner.v1.OrganizationRef
	16, // 12: buf.registry.owner.v1.UpdateOrganizationsRequest.Value.verification_status:type_name -> buf.registry.owner.v1.OrganizationVerificationStatus
	1,  // 13: buf.registry.owner.v1.OrganizationService.GetOrganizations:input_type -> buf.registry.owner.v1.GetOrganizationsRequest
	3,  // 14: buf.registry.owner.v1.OrganizationService.ListOrganizations:input_type -> buf.registry.owner.v1.ListOrganizationsRequest
	5,  // 15: buf.registry.owner.v1.OrganizationService.CreateOrganizations:input_type -> buf.registry.owner.v1.CreateOrganizationsRequest
	7,  // 16: buf.registry.owner.v1.OrganizationService.UpdateOrganizations:input_type -> buf.registry.owner.v1.UpdateOrganizationsRequest
	9,  // 17: buf.registry.owner.v1.OrganizationService.DeleteOrganizations:input_type -> buf.registry.owner.v1.DeleteOrganizationsRequest
	2,  // 18: buf.registry.owner.v1.OrganizationService.GetOrganizations:output_type -> buf.registry.owner.v1.GetOrganizationsResponse
	4,  // 19: buf.registry.owner.v1.OrganizationService.ListOrganizations:output_type -> buf.registry.owner.v1.ListOrganizationsResponse
	6,  // 20: buf.registry.owner.v1.OrganizationService.CreateOrganizations:output_type -> buf.registry.owner.v1.CreateOrganizationsResponse
	8,  // 21: buf.registry.owner.v1.OrganizationService.UpdateOrganizations:output_type -> buf.registry.owner.v1.UpdateOrganizationsResponse
	10, // 22: buf.registry.owner.v1.OrganizationService.DeleteOrganizations:output_type -> buf.registry.owner.v1.DeleteOrganizationsResponse
	18, // [18:23] is the sub-list for method output_type
	13, // [13:18] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_buf_registry_owner_v1_organization_service_proto_init() }
func file_buf_registry_owner_v1_organization_service_proto_init() {
	if File_buf_registry_owner_v1_organization_service_proto != nil {
		return
	}
	file_buf_registry_owner_v1_organization_proto_init()
	file_buf_registry_owner_v1_user_proto_init()
	file_buf_registry_owner_v1_organization_service_proto_msgTypes[11].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_registry_owner_v1_organization_service_proto_rawDesc), len(file_buf_registry_owner_v1_organization_service_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_owner_v1_organization_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_owner_v1_organization_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_owner_v1_organization_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_owner_v1_organization_service_proto_msgTypes,
	}.Build()
	File_buf_registry_owner_v1_organization_service_proto = out.File
	file_buf_registry_owner_v1_organization_service_proto_goTypes = nil
	file_buf_registry_owner_v1_organization_service_proto_depIdxs = nil
}
