/* unified-privacy-files.c generated by valac 0.56.17, the Vala compiler
 * generated from unified-privacy-files.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; intend-tabs-mode: t -*- */
/* alm
 *
 * Copyright (C) 2012 Seif Lotfy <seif@lotfy.com>
 * Copyright (C) 2012 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright (C) 2012 Intel Corp.
 *               Authored by: Seif Lotfy <seif.lotfy@collabora.co.uk>
 * Copyright (C) 2012 Stefano Candori <stefano.candori@gmail.com>
 *
 * alm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * alm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <zeitgeist-datamodel.h>
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#define ALM_FILES_CELL_RENDERER_PIXBUF_SIZE 24
#define ALM_FILES_CELL_RENDERER_xspacing 3
#define ALM_FILES_CELL_RENDERER_default_width 60
#define ALM_FILES_CELL_RENDERER_renderer_height 50
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ALM_TYPE_FILE_TYPE_BLACKLIST (alm_file_type_blacklist_get_type ())
#define ALM_FILE_TYPE_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklist))
#define ALM_FILE_TYPE_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklistClass))
#define ALM_IS_FILE_TYPE_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_FILE_TYPE_BLACKLIST))
#define ALM_IS_FILE_TYPE_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_FILE_TYPE_BLACKLIST))
#define ALM_FILE_TYPE_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklistClass))

typedef struct _AlmFileTypeBlacklist AlmFileTypeBlacklist;
typedef struct _AlmFileTypeBlacklistClass AlmFileTypeBlacklistClass;
typedef struct _AlmFileTypeBlacklistPrivate AlmFileTypeBlacklistPrivate;

#define ALM_TYPE_BLACKLIST (alm_blacklist_get_type ())
#define ALM_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_BLACKLIST, AlmBlacklist))
#define ALM_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_BLACKLIST, AlmBlacklistClass))
#define ALM_IS_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_BLACKLIST))
#define ALM_IS_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_BLACKLIST))
#define ALM_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_BLACKLIST, AlmBlacklistClass))

typedef struct _AlmBlacklist AlmBlacklist;
typedef struct _AlmBlacklistClass AlmBlacklistClass;
#define _alm_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (alm_blacklist_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AlmParamSpecFileTypeBlacklist AlmParamSpecFileTypeBlacklist;

#define ALM_TYPE_PATH_BLACKLIST (alm_path_blacklist_get_type ())
#define ALM_PATH_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklist))
#define ALM_PATH_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklistClass))
#define ALM_IS_PATH_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_PATH_BLACKLIST))
#define ALM_IS_PATH_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_PATH_BLACKLIST))
#define ALM_PATH_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklistClass))

typedef struct _AlmPathBlacklist AlmPathBlacklist;
typedef struct _AlmPathBlacklistClass AlmPathBlacklistClass;
typedef struct _AlmPathBlacklistPrivate AlmPathBlacklistPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _AlmParamSpecPathBlacklist AlmParamSpecPathBlacklist;
enum  {
	ALM_PATH_BLACKLIST_FOLDER_ADDED_SIGNAL,
	ALM_PATH_BLACKLIST_FOLDER_REMOVED_SIGNAL,
	ALM_PATH_BLACKLIST_NUM_SIGNALS
};
static guint alm_path_blacklist_signals[ALM_PATH_BLACKLIST_NUM_SIGNALS] = {0};

#define ALM_TYPE_FILES_CELL_RENDERER (alm_files_cell_renderer_get_type ())
#define ALM_FILES_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRenderer))
#define ALM_FILES_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRendererClass))
#define ALM_IS_FILES_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_FILES_CELL_RENDERER))
#define ALM_IS_FILES_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_FILES_CELL_RENDERER))
#define ALM_FILES_CELL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRendererClass))

typedef struct _AlmFilesCellRenderer AlmFilesCellRenderer;
typedef struct _AlmFilesCellRendererClass AlmFilesCellRendererClass;
typedef struct _AlmFilesCellRendererPrivate AlmFilesCellRendererPrivate;
enum  {
	ALM_FILES_CELL_RENDERER_0_PROPERTY,
	ALM_FILES_CELL_RENDERER_PIXBUF_PROPERTY,
	ALM_FILES_CELL_RENDERER_TEXT_PROPERTY,
	ALM_FILES_CELL_RENDERER_PATH_PROPERTY,
	ALM_FILES_CELL_RENDERER_NUM_PROPERTIES
};
static GParamSpec* alm_files_cell_renderer_properties[ALM_FILES_CELL_RENDERER_NUM_PROPERTIES];
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

struct _AlmFileTypeBlacklist {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlmFileTypeBlacklistPrivate * priv;
};

struct _AlmFileTypeBlacklistClass {
	GTypeClass parent_class;
	void (*finalize) (AlmFileTypeBlacklist *self);
};

struct _AlmFileTypeBlacklistPrivate {
	AlmBlacklist* blacklist_interface;
	GeeHashMap* checkboxes;
};

struct _AlmParamSpecFileTypeBlacklist {
	GParamSpec parent_instance;
};

struct _AlmPathBlacklist {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AlmPathBlacklistPrivate * priv;
};

struct _AlmPathBlacklistClass {
	GTypeClass parent_class;
	void (*finalize) (AlmPathBlacklist *self);
};

struct _AlmPathBlacklistPrivate {
	AlmBlacklist* blacklist_interface;
	GeeHashSet* all_blocked_folder;
};

struct _AlmParamSpecPathBlacklist {
	GParamSpec parent_instance;
};

struct _AlmFilesCellRenderer {
	GtkCellRenderer parent_instance;
	AlmFilesCellRendererPrivate * priv;
};

struct _AlmFilesCellRendererClass {
	GtkCellRendererClass parent_class;
};

struct _AlmFilesCellRendererPrivate {
	GtkWidget* current_widget;
	GdkPixbuf* pixbuf_;
	gchar* text_;
	gchar* path_;
};

static gint AlmFileTypeBlacklist_private_offset;
static gpointer alm_file_type_blacklist_parent_class = NULL;
VALA_EXTERN gchar* alm_file_type_blacklist_interpretation_prefix;
gchar* alm_file_type_blacklist_interpretation_prefix = NULL;
static gint AlmPathBlacklist_private_offset;
static gpointer alm_path_blacklist_parent_class = NULL;
VALA_EXTERN gchar* alm_path_blacklist_folder_prefix;
gchar* alm_path_blacklist_folder_prefix = NULL;
static gchar* alm_path_blacklist_suffix;
static gchar* alm_path_blacklist_suffix = NULL;
static gint AlmFilesCellRenderer_private_offset;
static gpointer alm_files_cell_renderer_parent_class = NULL;

VALA_EXTERN gpointer alm_file_type_blacklist_ref (gpointer instance);
VALA_EXTERN void alm_file_type_blacklist_unref (gpointer instance);
VALA_EXTERN GParamSpec* alm_param_spec_file_type_blacklist (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void alm_value_set_file_type_blacklist (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void alm_value_take_file_type_blacklist (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer alm_value_get_file_type_blacklist (const GValue* value);
VALA_EXTERN GType alm_file_type_blacklist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmFileTypeBlacklist, alm_file_type_blacklist_unref)
VALA_EXTERN gpointer alm_blacklist_ref (gpointer instance);
VALA_EXTERN void alm_blacklist_unref (gpointer instance);
VALA_EXTERN GParamSpec* alm_param_spec_blacklist (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void alm_value_set_blacklist (GValue* value,
                              gpointer v_object);
VALA_EXTERN void alm_value_take_blacklist (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer alm_value_get_blacklist (const GValue* value);
VALA_EXTERN GType alm_blacklist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmBlacklist, alm_blacklist_unref)
VALA_EXTERN AlmFileTypeBlacklist* alm_file_type_blacklist_new (AlmBlacklist* blacklist_inter,
                                                   GeeHashMap* all_checkboxes);
VALA_EXTERN AlmFileTypeBlacklist* alm_file_type_blacklist_construct (GType object_type,
                                                         AlmBlacklist* blacklist_inter,
                                                         GeeHashMap* all_checkboxes);
static gchar* alm_file_type_blacklist_get_name (AlmFileTypeBlacklist* self,
                                         const gchar* interpretation);
VALA_EXTERN void alm_file_type_blacklist_populate_file_types (AlmFileTypeBlacklist* self);
VALA_EXTERN GHashTable* alm_blacklist_get_all_templates (AlmBlacklist* self);
VALA_EXTERN void alm_file_type_blacklist_block (AlmFileTypeBlacklist* self,
                                    const gchar* interpretation);
VALA_EXTERN void alm_blacklist_add_template (AlmBlacklist* self,
                                 const gchar* blacklist_id,
                                 ZeitgeistEvent* blacklist_template);
VALA_EXTERN void alm_file_type_blacklist_unblock (AlmFileTypeBlacklist* self,
                                      const gchar* interpretation);
VALA_EXTERN void alm_blacklist_remove_template (AlmBlacklist* self,
                                    const gchar* blacklist_id);
static void alm_file_type_blacklist_finalize (AlmFileTypeBlacklist * obj);
static GType alm_file_type_blacklist_get_type_once (void);
VALA_EXTERN gpointer alm_path_blacklist_ref (gpointer instance);
VALA_EXTERN void alm_path_blacklist_unref (gpointer instance);
VALA_EXTERN GParamSpec* alm_param_spec_path_blacklist (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void alm_value_set_path_blacklist (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void alm_value_take_path_blacklist (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer alm_value_get_path_blacklist (const GValue* value);
VALA_EXTERN GType alm_path_blacklist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmPathBlacklist, alm_path_blacklist_unref)
VALA_EXTERN AlmPathBlacklist* alm_path_blacklist_new (AlmBlacklist* blacklist_inter);
VALA_EXTERN AlmPathBlacklist* alm_path_blacklist_construct (GType object_type,
                                                AlmBlacklist* blacklist_inter);
static void alm_path_blacklist_on_blacklist_added (AlmPathBlacklist* self,
                                            const gchar* blacklist_id,
                                            ZeitgeistEvent* ev);
static void _alm_path_blacklist_on_blacklist_added_alm_blacklist_template_added (AlmBlacklist* _sender,
                                                                          const gchar* blacklist_id,
                                                                          ZeitgeistEvent* blacklist_template,
                                                                          gpointer self);
static void alm_path_blacklist_on_blacklist_removed (AlmPathBlacklist* self,
                                              const gchar* blacklist_id,
                                              ZeitgeistEvent* ev);
static void _alm_path_blacklist_on_blacklist_removed_alm_blacklist_template_removed (AlmBlacklist* _sender,
                                                                              const gchar* blacklist_id,
                                                                              ZeitgeistEvent* blacklist_template,
                                                                              gpointer self);
static void alm_path_blacklist_get_blocked_folder (AlmPathBlacklist* self);
VALA_EXTERN gboolean alm_path_blacklist_is_duplicate (AlmPathBlacklist* self,
                                          const gchar* path);
static gchar* alm_path_blacklist_get_folder (AlmPathBlacklist* self,
                                      ZeitgeistEvent* ev);
VALA_EXTERN void alm_path_blacklist_block (AlmPathBlacklist* self,
                               const gchar* folder);
VALA_EXTERN void alm_path_blacklist_unblock (AlmPathBlacklist* self,
                                 const gchar* folder);
VALA_EXTERN GeeHashSet* alm_path_blacklist_get_all_folders (AlmPathBlacklist* self);
static void alm_path_blacklist_finalize (AlmPathBlacklist * obj);
static GType alm_path_blacklist_get_type_once (void);
VALA_EXTERN GType alm_files_cell_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmFilesCellRenderer, g_object_unref)
VALA_EXTERN AlmFilesCellRenderer* alm_files_cell_renderer_new (void);
VALA_EXTERN AlmFilesCellRenderer* alm_files_cell_renderer_construct (GType object_type);
static PangoLayout* alm_files_cell_renderer_get_text_layout (AlmFilesCellRenderer* self,
                                                      GtkWidget* widget,
                                                      GdkRectangle* cell_area,
                                                      GtkCellRendererState flags,
                                                      const gchar* text,
                                                      gboolean bold,
                                                      gint size);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void alm_files_cell_renderer_real_get_size (GtkCellRenderer* base,
                                            GtkWidget* widget,
                                            GdkRectangle* cell_area,
                                            gint* x_offset,
                                            gint* y_offset,
                                            gint* width,
                                            gint* height);
static void alm_files_cell_renderer_do_get_size (AlmFilesCellRenderer* self,
                                          GtkWidget* widget,
                                          GdkRectangle* cell_area,
                                          PangoLayout* layout,
                                          gint* x_offset,
                                          gint* y_offset);
static void alm_files_cell_renderer_real_render (GtkCellRenderer* base,
                                          cairo_t* cr,
                                          GtkWidget* widget,
                                          GdkRectangle* background_area,
                                          GdkRectangle* cell_area,
                                          GtkCellRendererState flags);
VALA_EXTERN const gchar* alm_files_cell_renderer_get_text (AlmFilesCellRenderer* self);
VALA_EXTERN const gchar* alm_files_cell_renderer_get_path (AlmFilesCellRenderer* self);
VALA_EXTERN GdkPixbuf* alm_files_cell_renderer_get_pixbuf (AlmFilesCellRenderer* self);
static void alm_files_cell_renderer_real_get_preferred_width (GtkCellRenderer* base,
                                                       GtkWidget* widget,
                                                       gint* min_width,
                                                       gint* nat_width);
static void alm_files_cell_renderer_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                                  GtkWidget* widget,
                                                                  gint width,
                                                                  gint* minimum_height,
                                                                  gint* natural_height);
static void alm_files_cell_renderer_real_get_preferred_height (GtkCellRenderer* base,
                                                        GtkWidget* widget,
                                                        gint* minimum_size,
                                                        gint* natural_size);
VALA_EXTERN void alm_files_cell_renderer_set_pixbuf (AlmFilesCellRenderer* self,
                                         GdkPixbuf* value);
VALA_EXTERN void alm_files_cell_renderer_set_text (AlmFilesCellRenderer* self,
                                       const gchar* value);
VALA_EXTERN void alm_files_cell_renderer_set_path (AlmFilesCellRenderer* self,
                                       const gchar* value);
static void alm_files_cell_renderer_finalize (GObject * obj);
static GType alm_files_cell_renderer_get_type_once (void);
static void _vala_alm_files_cell_renderer_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_alm_files_cell_renderer_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
alm_file_type_blacklist_get_instance_private (AlmFileTypeBlacklist* self)
{
	return G_STRUCT_MEMBER_P (self, AlmFileTypeBlacklist_private_offset);
}

static gpointer
_alm_blacklist_ref0 (gpointer self)
{
	return self ? alm_blacklist_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

AlmFileTypeBlacklist*
alm_file_type_blacklist_construct (GType object_type,
                                   AlmBlacklist* blacklist_inter,
                                   GeeHashMap* all_checkboxes)
{
	AlmFileTypeBlacklist* self = NULL;
	AlmBlacklist* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_val_if_fail (blacklist_inter != NULL, NULL);
	g_return_val_if_fail (all_checkboxes != NULL, NULL);
	self = (AlmFileTypeBlacklist*) g_type_create_instance (object_type);
	_tmp0_ = _alm_blacklist_ref0 (blacklist_inter);
	_alm_blacklist_unref0 (self->priv->blacklist_interface);
	self->priv->blacklist_interface = _tmp0_;
	_tmp1_ = _g_object_ref0 (all_checkboxes);
	_g_object_unref0 (self->priv->checkboxes);
	self->priv->checkboxes = _tmp1_;
	return self;
}

AlmFileTypeBlacklist*
alm_file_type_blacklist_new (AlmBlacklist* blacklist_inter,
                             GeeHashMap* all_checkboxes)
{
	return alm_file_type_blacklist_construct (ALM_TYPE_FILE_TYPE_BLACKLIST, blacklist_inter, all_checkboxes);
}

static gchar*
alm_file_type_blacklist_get_name (AlmFileTypeBlacklist* self,
                                  const gchar* interpretation)
{
	gchar** names = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint names_length1;
	gint _names_size_;
	gchar* name = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (interpretation != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (interpretation, "#", 0);
	names = _tmp1_;
	names_length1 = _vala_array_length (_tmp0_);
	_names_size_ = names_length1;
	_tmp2_ = names[names_length1 - 1];
	_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
	name = _tmp3_;
	_tmp4_ = alm_file_type_blacklist_interpretation_prefix;
	_tmp5_ = g_strdup_printf ("%s%s", _tmp4_, name);
	result = _tmp5_;
	_g_free0 (name);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
alm_file_type_blacklist_populate_file_types (AlmFileTypeBlacklist* self)
{
	AlmBlacklist* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = alm_blacklist_get_all_templates (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_hash_table_get_keys (_tmp2_);
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp3_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			gchar* _tmp4_;
			gchar* key = NULL;
			_tmp4_ = g_strdup ((const gchar*) key_it->data);
			key = _tmp4_;
			{
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = key;
				_tmp6_ = alm_file_type_blacklist_interpretation_prefix;
				if (g_str_has_prefix (_tmp5_, _tmp6_)) {
					gchar* inter = NULL;
					AlmBlacklist* _tmp7_;
					GHashTable* _tmp8_;
					GHashTable* _tmp9_;
					const gchar* _tmp10_;
					gconstpointer _tmp11_;
					ZeitgeistSubject* _tmp12_;
					ZeitgeistSubject* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gboolean _tmp18_ = FALSE;
					GeeHashMap* _tmp19_;
					const gchar* _tmp20_;
					GeeHashMap* _tmp21_;
					const gchar* _tmp22_;
					gpointer _tmp23_;
					GtkCheckButton* _tmp24_;
					_tmp7_ = self->priv->blacklist_interface;
					_tmp8_ = alm_blacklist_get_all_templates (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = key;
					_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
					_tmp12_ = zeitgeist_event_get_subject ((ZeitgeistEvent*) _tmp11_, 0);
					_tmp13_ = _tmp12_;
					_tmp14_ = zeitgeist_subject_get_interpretation (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strdup (_tmp15_);
					_tmp17_ = _tmp16_;
					_g_object_unref0 (_tmp13_);
					inter = _tmp17_;
					_tmp19_ = self->priv->checkboxes;
					_tmp20_ = inter;
					if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp19_, _tmp20_)) {
						_tmp18_ = FALSE;
					} else {
						_tmp18_ = TRUE;
					}
					_tmp21_ = self->priv->checkboxes;
					_tmp22_ = inter;
					_tmp23_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp21_, _tmp22_);
					_tmp24_ = (GtkCheckButton*) _tmp23_;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp24_, _tmp18_);
					_g_object_unref0 (_tmp24_);
					_g_free0 (inter);
				}
				_g_free0 (key);
			}
		}
		(key_collection == NULL) ? NULL : (key_collection = (g_list_free (key_collection), NULL));
	}
}

void
alm_file_type_blacklist_block (AlmFileTypeBlacklist* self,
                               const gchar* interpretation)
{
	ZeitgeistEvent* ev = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistSubject* sub = NULL;
	ZeitgeistSubject* _tmp1_;
	AlmBlacklist* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interpretation != NULL);
	_tmp0_ = zeitgeist_event_new ();
	ev = _tmp0_;
	_tmp1_ = zeitgeist_subject_new ();
	sub = _tmp1_;
	zeitgeist_subject_set_interpretation (sub, interpretation);
	zeitgeist_event_add_subject (ev, sub);
	_tmp2_ = self->priv->blacklist_interface;
	_tmp3_ = alm_file_type_blacklist_get_name (self, interpretation);
	_tmp4_ = _tmp3_;
	alm_blacklist_add_template (_tmp2_, _tmp4_, ev);
	_g_free0 (_tmp4_);
	_g_object_unref0 (sub);
	_g_object_unref0 (ev);
}

void
alm_file_type_blacklist_unblock (AlmFileTypeBlacklist* self,
                                 const gchar* interpretation)
{
	AlmBlacklist* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interpretation != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = alm_file_type_blacklist_get_name (self, interpretation);
	_tmp2_ = _tmp1_;
	alm_blacklist_remove_template (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
alm_value_file_type_blacklist_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
alm_value_file_type_blacklist_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		alm_file_type_blacklist_unref (value->data[0].v_pointer);
	}
}

static void
alm_value_file_type_blacklist_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = alm_file_type_blacklist_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
alm_value_file_type_blacklist_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
alm_value_file_type_blacklist_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AlmFileTypeBlacklist * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = alm_file_type_blacklist_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
alm_value_file_type_blacklist_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	AlmFileTypeBlacklist ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = alm_file_type_blacklist_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
alm_param_spec_file_type_blacklist (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	AlmParamSpecFileTypeBlacklist* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ALM_TYPE_FILE_TYPE_BLACKLIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
alm_value_get_file_type_blacklist (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_FILE_TYPE_BLACKLIST), NULL);
	return value->data[0].v_pointer;
}

void
alm_value_set_file_type_blacklist (GValue* value,
                                   gpointer v_object)
{
	AlmFileTypeBlacklist * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_FILE_TYPE_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALM_TYPE_FILE_TYPE_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		alm_file_type_blacklist_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alm_file_type_blacklist_unref (old);
	}
}

void
alm_value_take_file_type_blacklist (GValue* value,
                                    gpointer v_object)
{
	AlmFileTypeBlacklist * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_FILE_TYPE_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALM_TYPE_FILE_TYPE_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alm_file_type_blacklist_unref (old);
	}
}

static void
alm_file_type_blacklist_class_init (AlmFileTypeBlacklistClass * klass,
                                    gpointer klass_data)
{
	gchar* _tmp0_;
	alm_file_type_blacklist_parent_class = g_type_class_peek_parent (klass);
	((AlmFileTypeBlacklistClass *) klass)->finalize = alm_file_type_blacklist_finalize;
	g_type_class_adjust_private_offset (klass, &AlmFileTypeBlacklist_private_offset);
	_tmp0_ = g_strdup ("interpretation-");
	alm_file_type_blacklist_interpretation_prefix = _tmp0_;
}

static void
alm_file_type_blacklist_instance_init (AlmFileTypeBlacklist * self,
                                       gpointer klass)
{
	self->priv = alm_file_type_blacklist_get_instance_private (self);
	self->ref_count = 1;
}

static void
alm_file_type_blacklist_finalize (AlmFileTypeBlacklist * obj)
{
	AlmFileTypeBlacklist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklist);
	g_signal_handlers_destroy (self);
	_alm_blacklist_unref0 (self->priv->blacklist_interface);
	_g_object_unref0 (self->priv->checkboxes);
}

static GType
alm_file_type_blacklist_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { alm_value_file_type_blacklist_init, alm_value_file_type_blacklist_free_value, alm_value_file_type_blacklist_copy_value, alm_value_file_type_blacklist_peek_pointer, "p", alm_value_file_type_blacklist_collect_value, "p", alm_value_file_type_blacklist_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AlmFileTypeBlacklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_file_type_blacklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmFileTypeBlacklist), 0, (GInstanceInitFunc) alm_file_type_blacklist_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType alm_file_type_blacklist_type_id;
	alm_file_type_blacklist_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AlmFileTypeBlacklist", &g_define_type_info, &g_define_type_fundamental_info, 0);
	AlmFileTypeBlacklist_private_offset = g_type_add_instance_private (alm_file_type_blacklist_type_id, sizeof (AlmFileTypeBlacklistPrivate));
	return alm_file_type_blacklist_type_id;
}

GType
alm_file_type_blacklist_get_type (void)
{
	static volatile gsize alm_file_type_blacklist_type_id__once = 0;
	if (g_once_init_enter (&alm_file_type_blacklist_type_id__once)) {
		GType alm_file_type_blacklist_type_id;
		alm_file_type_blacklist_type_id = alm_file_type_blacklist_get_type_once ();
		g_once_init_leave (&alm_file_type_blacklist_type_id__once, alm_file_type_blacklist_type_id);
	}
	return alm_file_type_blacklist_type_id__once;
}

gpointer
alm_file_type_blacklist_ref (gpointer instance)
{
	AlmFileTypeBlacklist * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
alm_file_type_blacklist_unref (gpointer instance)
{
	AlmFileTypeBlacklist * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ALM_FILE_TYPE_BLACKLIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
alm_path_blacklist_get_instance_private (AlmPathBlacklist* self)
{
	return G_STRUCT_MEMBER_P (self, AlmPathBlacklist_private_offset);
}

static void
_alm_path_blacklist_on_blacklist_added_alm_blacklist_template_added (AlmBlacklist* _sender,
                                                                     const gchar* blacklist_id,
                                                                     ZeitgeistEvent* blacklist_template,
                                                                     gpointer self)
{
	alm_path_blacklist_on_blacklist_added ((AlmPathBlacklist*) self, blacklist_id, blacklist_template);
}

static void
_alm_path_blacklist_on_blacklist_removed_alm_blacklist_template_removed (AlmBlacklist* _sender,
                                                                         const gchar* blacklist_id,
                                                                         ZeitgeistEvent* blacklist_template,
                                                                         gpointer self)
{
	alm_path_blacklist_on_blacklist_removed ((AlmPathBlacklist*) self, blacklist_id, blacklist_template);
}

AlmPathBlacklist*
alm_path_blacklist_construct (GType object_type,
                              AlmBlacklist* blacklist_inter)
{
	AlmPathBlacklist* self = NULL;
	AlmBlacklist* _tmp0_;
	AlmBlacklist* _tmp1_;
	AlmBlacklist* _tmp2_;
	g_return_val_if_fail (blacklist_inter != NULL, NULL);
	self = (AlmPathBlacklist*) g_type_create_instance (object_type);
	_tmp0_ = _alm_blacklist_ref0 (blacklist_inter);
	_alm_blacklist_unref0 (self->priv->blacklist_interface);
	self->priv->blacklist_interface = _tmp0_;
	_tmp1_ = self->priv->blacklist_interface;
	g_signal_connect (_tmp1_, "template-added", (GCallback) _alm_path_blacklist_on_blacklist_added_alm_blacklist_template_added, self);
	_tmp2_ = self->priv->blacklist_interface;
	g_signal_connect (_tmp2_, "template-removed", (GCallback) _alm_path_blacklist_on_blacklist_removed_alm_blacklist_template_removed, self);
	alm_path_blacklist_get_blocked_folder (self);
	return self;
}

AlmPathBlacklist*
alm_path_blacklist_new (AlmBlacklist* blacklist_inter)
{
	return alm_path_blacklist_construct (ALM_TYPE_PATH_BLACKLIST, blacklist_inter);
}

gboolean
alm_path_blacklist_is_duplicate (AlmPathBlacklist* self,
                                 const gchar* path)
{
	GeeHashSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = self->priv->all_blocked_folder;
	result = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, path);
	return result;
}

static void
alm_path_blacklist_get_blocked_folder (AlmPathBlacklist* self)
{
	GeeHashSet* _tmp0_;
	AlmBlacklist* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->all_blocked_folder);
	self->priv->all_blocked_folder = _tmp0_;
	_tmp1_ = self->priv->blacklist_interface;
	_tmp2_ = alm_blacklist_get_all_templates (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_get_keys (_tmp3_);
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp4_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			gchar* _tmp5_;
			gchar* key = NULL;
			_tmp5_ = g_strdup ((const gchar*) key_it->data);
			key = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = key;
				_tmp7_ = alm_path_blacklist_folder_prefix;
				if (g_str_has_prefix (_tmp6_, _tmp7_)) {
					gchar* folder = NULL;
					AlmBlacklist* _tmp8_;
					GHashTable* _tmp9_;
					GHashTable* _tmp10_;
					const gchar* _tmp11_;
					gconstpointer _tmp12_;
					gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp8_ = self->priv->blacklist_interface;
					_tmp9_ = alm_blacklist_get_all_templates (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = key;
					_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
					_tmp13_ = alm_path_blacklist_get_folder (self, (ZeitgeistEvent*) _tmp12_);
					folder = _tmp13_;
					_tmp14_ = folder;
					if (_tmp14_ != NULL) {
						GeeHashSet* _tmp15_;
						const gchar* _tmp16_;
						_tmp15_ = self->priv->all_blocked_folder;
						_tmp16_ = folder;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
					}
					_g_free0 (folder);
				}
				_g_free0 (key);
			}
		}
		(key_collection == NULL) ? NULL : (key_collection = (g_list_free (key_collection), NULL));
	}
}

static void
alm_path_blacklist_on_blacklist_added (AlmPathBlacklist* self,
                                       const gchar* blacklist_id,
                                       ZeitgeistEvent* ev)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = alm_path_blacklist_folder_prefix;
	if (g_str_has_prefix (blacklist_id, _tmp0_)) {
		gchar* uri = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = alm_path_blacklist_get_folder (self, ev);
		uri = _tmp1_;
		_tmp2_ = uri;
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_;
			GeeHashSet* _tmp4_;
			const gchar* _tmp5_;
			_tmp3_ = uri;
			g_signal_emit (self, alm_path_blacklist_signals[ALM_PATH_BLACKLIST_FOLDER_ADDED_SIGNAL], 0, _tmp3_);
			_tmp4_ = self->priv->all_blocked_folder;
			_tmp5_ = uri;
			if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, _tmp5_)) {
				GeeHashSet* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = self->priv->all_blocked_folder;
				_tmp7_ = uri;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
			}
		}
		_g_free0 (uri);
	}
}

static void
alm_path_blacklist_on_blacklist_removed (AlmPathBlacklist* self,
                                         const gchar* blacklist_id,
                                         ZeitgeistEvent* ev)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = alm_path_blacklist_folder_prefix;
	if (g_str_has_prefix (blacklist_id, _tmp0_)) {
		gchar* uri = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = alm_path_blacklist_get_folder (self, ev);
		uri = _tmp1_;
		_tmp2_ = uri;
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_;
			GeeHashSet* _tmp4_;
			const gchar* _tmp5_;
			_tmp3_ = uri;
			g_signal_emit (self, alm_path_blacklist_signals[ALM_PATH_BLACKLIST_FOLDER_REMOVED_SIGNAL], 0, _tmp3_);
			_tmp4_ = self->priv->all_blocked_folder;
			_tmp5_ = uri;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, _tmp5_)) {
				GeeHashSet* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = self->priv->all_blocked_folder;
				_tmp7_ = uri;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, _tmp7_);
			}
		}
		_g_free0 (uri);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
alm_path_blacklist_get_folder (AlmPathBlacklist* self,
                               ZeitgeistEvent* ev)
{
	ZeitgeistSubject* sub = NULL;
	ZeitgeistSubject* _tmp0_;
	gchar* uri = NULL;
	ZeitgeistSubject* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GFile* blocked_uri = NULL;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_ = NULL;
	GFile* _tmp11_;
	gchar* final_path = NULL;
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ev != NULL, NULL);
	_tmp0_ = zeitgeist_event_get_subject (ev, 0);
	sub = _tmp0_;
	_tmp1_ = sub;
	_tmp2_ = zeitgeist_subject_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	uri = _tmp4_;
	_tmp5_ = uri;
	_tmp6_ = alm_path_blacklist_suffix;
	_tmp7_ = string_replace (_tmp5_, _tmp6_, "");
	_g_free0 (uri);
	uri = _tmp7_;
	_tmp8_ = uri;
	_tmp9_ = g_file_new_for_uri (_tmp8_);
	blocked_uri = _tmp9_;
	_tmp11_ = blocked_uri;
	if (g_file_query_exists (_tmp11_, NULL)) {
		GFile* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = blocked_uri;
		_tmp13_ = g_file_get_path (_tmp12_);
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp13_;
	} else {
		_g_free0 (_tmp10_);
		_tmp10_ = NULL;
	}
	_tmp14_ = g_strdup (_tmp10_);
	final_path = _tmp14_;
	result = final_path;
	_g_free0 (_tmp10_);
	_g_object_unref0 (blocked_uri);
	_g_free0 (uri);
	_g_object_unref0 (sub);
	return result;
}

void
alm_path_blacklist_block (AlmPathBlacklist* self,
                          const gchar* folder)
{
	ZeitgeistEvent* ev = NULL;
	ZeitgeistEvent* _tmp0_;
	ZeitgeistSubject* sub = NULL;
	ZeitgeistSubject* _tmp1_;
	GFile* block_path = NULL;
	GFile* _tmp2_;
	gchar* uri = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ZeitgeistSubject* _tmp9_;
	const gchar* _tmp10_;
	ZeitgeistEvent* _tmp11_;
	ZeitgeistSubject* _tmp12_;
	AlmBlacklist* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	ZeitgeistEvent* _tmp17_;
	GeeHashSet* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = zeitgeist_event_new ();
	ev = _tmp0_;
	_tmp1_ = zeitgeist_subject_new ();
	sub = _tmp1_;
	_tmp2_ = g_file_new_for_path (folder);
	block_path = _tmp2_;
	_tmp3_ = block_path;
	_tmp4_ = g_file_get_uri (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = alm_path_blacklist_suffix;
	_tmp7_ = g_strdup_printf ("%s%s", _tmp5_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp5_);
	uri = _tmp8_;
	_tmp9_ = sub;
	_tmp10_ = uri;
	zeitgeist_subject_set_uri (_tmp9_, _tmp10_);
	_tmp11_ = ev;
	_tmp12_ = sub;
	zeitgeist_event_add_subject (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->blacklist_interface;
	_tmp14_ = alm_path_blacklist_folder_prefix;
	_tmp15_ = g_strdup_printf ("%s%s", _tmp14_, folder);
	_tmp16_ = _tmp15_;
	_tmp17_ = ev;
	alm_blacklist_add_template (_tmp13_, _tmp16_, _tmp17_);
	_g_free0 (_tmp16_);
	_tmp18_ = self->priv->all_blocked_folder;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp18_, folder)) {
		GeeHashSet* _tmp19_;
		_tmp19_ = self->priv->all_blocked_folder;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, folder);
	}
	_g_free0 (uri);
	_g_object_unref0 (block_path);
	_g_object_unref0 (sub);
	_g_object_unref0 (ev);
}

void
alm_path_blacklist_unblock (AlmPathBlacklist* self,
                            const gchar* folder)
{
	AlmBlacklist* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GeeHashSet* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = self->priv->blacklist_interface;
	_tmp1_ = alm_path_blacklist_folder_prefix;
	_tmp2_ = g_strdup_printf ("%s%s", _tmp1_, folder);
	_tmp3_ = _tmp2_;
	alm_blacklist_remove_template (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->all_blocked_folder;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, folder)) {
		GeeHashSet* _tmp5_;
		_tmp5_ = self->priv->all_blocked_folder;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp5_, folder);
	}
}

GeeHashSet*
alm_path_blacklist_get_all_folders (AlmPathBlacklist* self)
{
	GeeHashSet* result;
	GeeHashSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->all_blocked_folder;
	result = _tmp0_;
	return result;
}

static void
alm_value_path_blacklist_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
alm_value_path_blacklist_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		alm_path_blacklist_unref (value->data[0].v_pointer);
	}
}

static void
alm_value_path_blacklist_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = alm_path_blacklist_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
alm_value_path_blacklist_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
alm_value_path_blacklist_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AlmPathBlacklist * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = alm_path_blacklist_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
alm_value_path_blacklist_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	AlmPathBlacklist ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = alm_path_blacklist_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
alm_param_spec_path_blacklist (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	AlmParamSpecPathBlacklist* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ALM_TYPE_PATH_BLACKLIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
alm_value_get_path_blacklist (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_PATH_BLACKLIST), NULL);
	return value->data[0].v_pointer;
}

void
alm_value_set_path_blacklist (GValue* value,
                              gpointer v_object)
{
	AlmPathBlacklist * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_PATH_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALM_TYPE_PATH_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		alm_path_blacklist_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alm_path_blacklist_unref (old);
	}
}

void
alm_value_take_path_blacklist (GValue* value,
                               gpointer v_object)
{
	AlmPathBlacklist * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ALM_TYPE_PATH_BLACKLIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ALM_TYPE_PATH_BLACKLIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		alm_path_blacklist_unref (old);
	}
}

static void
alm_path_blacklist_class_init (AlmPathBlacklistClass * klass,
                               gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	alm_path_blacklist_parent_class = g_type_class_peek_parent (klass);
	((AlmPathBlacklistClass *) klass)->finalize = alm_path_blacklist_finalize;
	g_type_class_adjust_private_offset (klass, &AlmPathBlacklist_private_offset);
	alm_path_blacklist_signals[ALM_PATH_BLACKLIST_FOLDER_ADDED_SIGNAL] = g_signal_new ("folder-added", ALM_TYPE_PATH_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	alm_path_blacklist_signals[ALM_PATH_BLACKLIST_FOLDER_REMOVED_SIGNAL] = g_signal_new ("folder-removed", ALM_TYPE_PATH_BLACKLIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	_tmp0_ = g_strdup ("dir-");
	alm_path_blacklist_folder_prefix = _tmp0_;
	_tmp1_ = g_strdup ("/*");
	alm_path_blacklist_suffix = _tmp1_;
}

static void
alm_path_blacklist_instance_init (AlmPathBlacklist * self,
                                  gpointer klass)
{
	self->priv = alm_path_blacklist_get_instance_private (self);
	self->ref_count = 1;
}

static void
alm_path_blacklist_finalize (AlmPathBlacklist * obj)
{
	AlmPathBlacklist * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklist);
	g_signal_handlers_destroy (self);
	_alm_blacklist_unref0 (self->priv->blacklist_interface);
	_g_object_unref0 (self->priv->all_blocked_folder);
}

static GType
alm_path_blacklist_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { alm_value_path_blacklist_init, alm_value_path_blacklist_free_value, alm_value_path_blacklist_copy_value, alm_value_path_blacklist_peek_pointer, "p", alm_value_path_blacklist_collect_value, "p", alm_value_path_blacklist_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AlmPathBlacklistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_path_blacklist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmPathBlacklist), 0, (GInstanceInitFunc) alm_path_blacklist_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType alm_path_blacklist_type_id;
	alm_path_blacklist_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AlmPathBlacklist", &g_define_type_info, &g_define_type_fundamental_info, 0);
	AlmPathBlacklist_private_offset = g_type_add_instance_private (alm_path_blacklist_type_id, sizeof (AlmPathBlacklistPrivate));
	return alm_path_blacklist_type_id;
}

GType
alm_path_blacklist_get_type (void)
{
	static volatile gsize alm_path_blacklist_type_id__once = 0;
	if (g_once_init_enter (&alm_path_blacklist_type_id__once)) {
		GType alm_path_blacklist_type_id;
		alm_path_blacklist_type_id = alm_path_blacklist_get_type_once ();
		g_once_init_leave (&alm_path_blacklist_type_id__once, alm_path_blacklist_type_id);
	}
	return alm_path_blacklist_type_id__once;
}

gpointer
alm_path_blacklist_ref (gpointer instance)
{
	AlmPathBlacklist * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
alm_path_blacklist_unref (gpointer instance)
{
	AlmPathBlacklist * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ALM_PATH_BLACKLIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
alm_files_cell_renderer_get_instance_private (AlmFilesCellRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, AlmFilesCellRenderer_private_offset);
}

AlmFilesCellRenderer*
alm_files_cell_renderer_construct (GType object_type)
{
	AlmFilesCellRenderer * self = NULL;
	self = (AlmFilesCellRenderer*) g_object_new (object_type, NULL);
	return self;
}

AlmFilesCellRenderer*
alm_files_cell_renderer_new (void)
{
	return alm_files_cell_renderer_construct (ALM_TYPE_FILES_CELL_RENDERER);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static PangoLayout*
alm_files_cell_renderer_get_text_layout (AlmFilesCellRenderer* self,
                                         GtkWidget* widget,
                                         GdkRectangle* cell_area,
                                         GtkCellRendererState flags,
                                         const gchar* text,
                                         gboolean bold,
                                         gint size)
{
	PangoLayout* layout = NULL;
	gint xpad = 0;
	PangoAttrList* attr_list = NULL;
	PangoAttrList* _tmp0_;
	PangoLayout* _tmp1_;
	PangoAttrSize* attr = NULL;
	PangoAttrSize* _tmp2_;
	PangoAttrSize* _tmp3_;
	PangoAttrSize* _tmp4_;
	PangoAttrSize* _tmp5_;
	PangoAttrSize* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	PangoAttrList* _tmp9_;
	PangoAttrSize* _tmp10_;
	PangoLayout* _tmp17_;
	PangoAttrList* _tmp18_;
	gint _tmp19_ = 0;
	PangoLayout* _tmp20_;
	PangoRectangle rect = {0};
	gint width = 0;
	gint text_width = 0;
	PangoLayout* _tmp21_;
	PangoRectangle _tmp22_ = {0};
	PangoRectangle _tmp23_;
	PangoLayout* _tmp24_;
	PangoAlignment align = 0;
	PangoLayout* _tmp25_;
	PangoLayout* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = pango_attr_list_new ();
	attr_list = _tmp0_;
	_tmp1_ = gtk_widget_create_pango_layout (widget, text);
	_g_object_unref0 (layout);
	layout = _tmp1_;
	_tmp2_ = (PangoAttrSize*) pango_attr_size_new (size * PANGO_SCALE);
	attr = _tmp2_;
	_tmp3_ = attr;
	_tmp3_->absolute = (guint) 1;
	_tmp4_ = attr;
	((PangoAttribute*) _tmp4_)->start_index = (guint) 0;
	_tmp5_ = attr;
	_tmp6_ = attr;
	_tmp7_ = strlen (text);
	_tmp8_ = _tmp7_;
	((PangoAttribute*) _tmp5_)->end_index = ((PangoAttribute*) _tmp6_)->start_index + _tmp8_;
	_tmp9_ = attr_list;
	_tmp10_ = attr;
	attr = NULL;
	pango_attr_list_insert (_tmp9_, (PangoAttribute*) _tmp10_);
	if (bold) {
		PangoFontDescription* desc = NULL;
		PangoFontDescription* _tmp11_;
		PangoFontDescription* _tmp12_;
		PangoAttrFontDesc* attr_f = NULL;
		PangoFontDescription* _tmp13_;
		PangoAttrFontDesc* _tmp14_;
		PangoAttrList* _tmp15_;
		PangoAttrFontDesc* _tmp16_;
		_tmp11_ = pango_font_description_new ();
		desc = _tmp11_;
		_tmp12_ = desc;
		pango_font_description_set_weight (_tmp12_, PANGO_WEIGHT_BOLD);
		_tmp13_ = desc;
		_tmp14_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (_tmp13_);
		attr_f = _tmp14_;
		_tmp15_ = attr_list;
		_tmp16_ = attr_f;
		attr_f = NULL;
		pango_attr_list_insert (_tmp15_, (PangoAttribute*) _tmp16_);
		_pango_attribute_destroy0 (attr_f);
		__vala_PangoFontDescription_free0 (desc);
	}
	_tmp17_ = layout;
	_tmp18_ = attr_list;
	pango_layout_set_attributes (_tmp17_, _tmp18_);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp19_, NULL);
	xpad = _tmp19_;
	_tmp20_ = layout;
	pango_layout_set_ellipsize (_tmp20_, PANGO_ELLIPSIZE_END);
	_tmp21_ = layout;
	pango_layout_get_extents (_tmp21_, NULL, &_tmp22_);
	rect = _tmp22_;
	_tmp23_ = rect;
	text_width = _tmp23_.width;
	if (cell_area != NULL) {
		width = ((*cell_area).width - xpad) * PANGO_SCALE;
	} else {
		width = ALM_FILES_CELL_RENDERER_default_width * PANGO_SCALE;
	}
	width = MIN (width, text_width);
	_tmp24_ = layout;
	pango_layout_set_width (_tmp24_, width);
	if (gtk_widget_get_direction (widget) == GTK_TEXT_DIR_RTL) {
		align = PANGO_ALIGN_RIGHT;
	} else {
		align = PANGO_ALIGN_LEFT;
	}
	_tmp25_ = layout;
	pango_layout_set_alignment (_tmp25_, align);
	result = layout;
	_pango_attribute_destroy0 (attr);
	_pango_attr_list_unref0 (attr_list);
	return result;
}

static void
alm_files_cell_renderer_real_get_size (GtkCellRenderer* base,
                                       GtkWidget* widget,
                                       GdkRectangle* cell_area,
                                       gint* x_offset,
                                       gint* y_offset,
                                       gint* width,
                                       gint* height)
{
	AlmFilesCellRenderer * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	_vala_height = 0;
	_vala_width = _vala_height;
	_vala_y_offset = _vala_width;
	_vala_x_offset = _vala_y_offset;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static void
alm_files_cell_renderer_do_get_size (AlmFilesCellRenderer* self,
                                     GtkWidget* widget,
                                     GdkRectangle* cell_area,
                                     PangoLayout* layout,
                                     gint* x_offset,
                                     gint* y_offset)
{
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	PangoRectangle rect = {0};
	gint xpad = 0;
	gint ypad = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	PangoRectangle _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, &_tmp1_);
	xpad = _tmp0_;
	ypad = _tmp1_;
	pango_layout_get_pixel_extents (layout, NULL, &_tmp2_);
	rect = _tmp2_;
	if (cell_area != NULL) {
		PangoRectangle _tmp3_;
		_tmp3_ = rect;
		rect.width = MIN (_tmp3_.width, ((*cell_area).width - (2 * xpad)) + ALM_FILES_CELL_RENDERER_xspacing);
		if (gtk_widget_get_direction (widget) == GTK_TEXT_DIR_RTL) {
			PangoRectangle _tmp4_;
			_tmp4_ = rect;
			_vala_x_offset = (*cell_area).width - (_tmp4_.width + xpad);
		} else {
			_vala_x_offset = xpad;
		}
		_vala_x_offset = MAX (_vala_x_offset, 0);
	} else {
		_vala_x_offset = 0;
	}
	_vala_y_offset = ypad;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
}

static void
alm_files_cell_renderer_real_render (GtkCellRenderer* base,
                                     cairo_t* cr,
                                     GtkWidget* widget,
                                     GdkRectangle* background_area,
                                     GdkRectangle* cell_area,
                                     GtkCellRendererState flags)
{
	AlmFilesCellRenderer * self;
	GtkStyleContext* context = NULL;
	PangoLayout* text_layout = NULL;
	PangoLayout* path_layout = NULL;
	gint text_x_offset = 0;
	gint path_x_offset = 0;
	gint text_y_offset = 0;
	gint path_y_offset = 0;
	gint xpad = 0;
	PangoRectangle text_rect = {0};
	PangoRectangle path_rect = {0};
	GtkWidget* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	gint font_size = 0;
	PangoFontDescription* _tmp3_;
	gint _tmp4_ = 0;
	GdkRectangle _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	PangoLayout* _tmp8_;
	GdkRectangle _tmp9_;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	PangoRectangle _tmp12_ = {0};
	PangoRectangle _tmp13_;
	GdkRectangle _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	PangoLayout* _tmp17_;
	GdkRectangle _tmp18_;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	PangoRectangle _tmp21_ = {0};
	PangoRectangle _tmp22_;
	GdkRectangle _tmp23_;
	GdkPixbuf* _tmp24_;
	GdkPixbuf* _tmp25_;
	GdkRectangle _tmp26_;
	GdkRectangle _tmp27_;
	GdkRectangle _tmp28_;
	GdkPixbuf* _tmp29_;
	GdkPixbuf* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	GdkRectangle _tmp33_;
	GdkRectangle _tmp34_;
	GdkRectangle _tmp35_;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	text_x_offset = 0;
	path_x_offset = 0;
	text_y_offset = 0;
	path_y_offset = 0;
	_tmp0_ = _g_object_ref0 (widget);
	_g_object_unref0 (self->priv->current_widget);
	self->priv->current_widget = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context (widget);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (context);
	context = _tmp2_;
	_tmp3_ = gtk_style_context_get_font (context, GTK_STATE_FLAG_NORMAL);
	font_size = pango_font_description_get_size (_tmp3_) / PANGO_SCALE;
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp4_, NULL);
	xpad = _tmp4_;
	_tmp5_ = *cell_area;
	_tmp6_ = alm_files_cell_renderer_get_text (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = alm_files_cell_renderer_get_text_layout (self, widget, &_tmp5_, flags, _tmp7_, TRUE, font_size);
	_g_object_unref0 (text_layout);
	text_layout = _tmp8_;
	_tmp9_ = *cell_area;
	alm_files_cell_renderer_do_get_size (self, widget, &_tmp9_, text_layout, &_tmp10_, &_tmp11_);
	text_x_offset = _tmp10_;
	text_y_offset = _tmp11_;
	pango_layout_get_pixel_extents (text_layout, NULL, &_tmp12_);
	text_rect = _tmp12_;
	_tmp13_ = text_rect;
	text_x_offset = text_x_offset - _tmp13_.x;
	_tmp14_ = *cell_area;
	_tmp15_ = alm_files_cell_renderer_get_path (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = alm_files_cell_renderer_get_text_layout (self, widget, &_tmp14_, flags, _tmp16_, FALSE, font_size - 1);
	_g_object_unref0 (path_layout);
	path_layout = _tmp17_;
	_tmp18_ = *cell_area;
	alm_files_cell_renderer_do_get_size (self, widget, &_tmp18_, path_layout, &_tmp19_, &_tmp20_);
	path_x_offset = _tmp19_;
	path_y_offset = _tmp20_;
	pango_layout_get_pixel_extents (path_layout, NULL, &_tmp21_);
	path_rect = _tmp21_;
	_tmp22_ = path_rect;
	path_x_offset = path_x_offset - _tmp22_.x;
	cairo_save (cr);
	_tmp23_ = *cell_area;
	gdk_cairo_rectangle (cr, &_tmp23_);
	cairo_clip (cr);
	_tmp24_ = alm_files_cell_renderer_get_pixbuf (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = *cell_area;
	_tmp27_ = *cell_area;
	gdk_cairo_set_source_pixbuf (cr, _tmp25_, (gdouble) _tmp26_.x, (gdouble) _tmp27_.y);
	cairo_paint (cr);
	_tmp28_ = *cell_area;
	_tmp29_ = alm_files_cell_renderer_get_pixbuf (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = gdk_pixbuf_get_width (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = *cell_area;
	gtk_render_layout (context, cr, (gdouble) (((_tmp28_.x + text_x_offset) + _tmp32_) + ALM_FILES_CELL_RENDERER_xspacing), (gdouble) ((_tmp33_.y + text_y_offset) + 2), text_layout);
	_tmp34_ = *cell_area;
	_tmp35_ = *cell_area;
	gtk_render_layout (context, cr, (gdouble) (_tmp34_.x + path_x_offset), (gdouble) ((((_tmp35_.y + path_y_offset) + ALM_FILES_CELL_RENDERER_renderer_height) - 11) - (pango_layout_get_baseline (path_layout) / PANGO_SCALE)), path_layout);
	cairo_restore (cr);
	_g_object_unref0 (path_layout);
	_g_object_unref0 (text_layout);
	_g_object_unref0 (context);
}

static void
alm_files_cell_renderer_real_get_preferred_width (GtkCellRenderer* base,
                                                  GtkWidget* widget,
                                                  gint* min_width,
                                                  gint* nat_width)
{
	AlmFilesCellRenderer * self;
	gint _vala_min_width = 0;
	gint _vala_nat_width = 0;
	gint xpad = 0;
	gint _tmp0_ = 0;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, NULL);
	xpad = _tmp0_;
	_vala_min_width = xpad + ALM_FILES_CELL_RENDERER_default_width;
	_vala_nat_width = _vala_min_width;
	if (min_width) {
		*min_width = _vala_min_width;
	}
	if (nat_width) {
		*nat_width = _vala_nat_width;
	}
}

static void
alm_files_cell_renderer_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                             GtkWidget* widget,
                                                             gint width,
                                                             gint* minimum_height,
                                                             gint* natural_height)
{
	AlmFilesCellRenderer * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	gint ypad = 0;
	gint _tmp0_ = 0;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, NULL, &_tmp0_);
	ypad = _tmp0_;
	_vala_minimum_height = ALM_FILES_CELL_RENDERER_renderer_height + ypad;
	_vala_natural_height = ALM_FILES_CELL_RENDERER_renderer_height + ypad;
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

static void
alm_files_cell_renderer_real_get_preferred_height (GtkCellRenderer* base,
                                                   GtkWidget* widget,
                                                   gint* minimum_size,
                                                   gint* natural_size)
{
	AlmFilesCellRenderer * self;
	gint _vala_minimum_size = 0;
	gint _vala_natural_size = 0;
	gint min_width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = (AlmFilesCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_preferred_width ((GtkCellRenderer*) self, widget, &_tmp0_, NULL);
	min_width = _tmp0_;
	gtk_cell_renderer_get_preferred_height_for_width ((GtkCellRenderer*) self, widget, min_width, &_tmp1_, &_tmp2_);
	_vala_minimum_size = _tmp1_;
	_vala_natural_size = _tmp2_;
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}

GdkPixbuf*
alm_files_cell_renderer_get_pixbuf (AlmFilesCellRenderer* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pixbuf_;
	result = _tmp0_;
	return result;
}

void
alm_files_cell_renderer_set_pixbuf (AlmFilesCellRenderer* self,
                                    GdkPixbuf* value)
{
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->pixbuf_);
	self->priv->pixbuf_ = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, alm_files_cell_renderer_properties[ALM_FILES_CELL_RENDERER_PIXBUF_PROPERTY]);
}

const gchar*
alm_files_cell_renderer_get_text (AlmFilesCellRenderer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->text_;
	result = _tmp0_;
	return result;
}

void
alm_files_cell_renderer_set_text (AlmFilesCellRenderer* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->text_);
	self->priv->text_ = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, alm_files_cell_renderer_properties[ALM_FILES_CELL_RENDERER_TEXT_PROPERTY]);
}

const gchar*
alm_files_cell_renderer_get_path (AlmFilesCellRenderer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->path_;
	result = _tmp0_;
	return result;
}

void
alm_files_cell_renderer_set_path (AlmFilesCellRenderer* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->path_);
	self->priv->path_ = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, alm_files_cell_renderer_properties[ALM_FILES_CELL_RENDERER_PATH_PROPERTY]);
}

static void
alm_files_cell_renderer_class_init (AlmFilesCellRendererClass * klass,
                                    gpointer klass_data)
{
	alm_files_cell_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AlmFilesCellRenderer_private_offset);
	((GtkCellRendererClass *) klass)->get_size = (void (*) (GtkCellRenderer*, GtkWidget*, GdkRectangle*, gint*, gint*, gint*, gint*)) alm_files_cell_renderer_real_get_size;
	((GtkCellRendererClass *) klass)->render = (void (*) (GtkCellRenderer*, cairo_t*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) alm_files_cell_renderer_real_render;
	((GtkCellRendererClass *) klass)->get_preferred_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) alm_files_cell_renderer_real_get_preferred_width;
	((GtkCellRendererClass *) klass)->get_preferred_height_for_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint, gint*, gint*)) alm_files_cell_renderer_real_get_preferred_height_for_width;
	((GtkCellRendererClass *) klass)->get_preferred_height = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) alm_files_cell_renderer_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_alm_files_cell_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_alm_files_cell_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = alm_files_cell_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALM_FILES_CELL_RENDERER_PIXBUF_PROPERTY, alm_files_cell_renderer_properties[ALM_FILES_CELL_RENDERER_PIXBUF_PROPERTY] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALM_FILES_CELL_RENDERER_TEXT_PROPERTY, alm_files_cell_renderer_properties[ALM_FILES_CELL_RENDERER_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALM_FILES_CELL_RENDERER_PATH_PROPERTY, alm_files_cell_renderer_properties[ALM_FILES_CELL_RENDERER_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
alm_files_cell_renderer_instance_init (AlmFilesCellRenderer * self,
                                       gpointer klass)
{
	self->priv = alm_files_cell_renderer_get_instance_private (self);
}

static void
alm_files_cell_renderer_finalize (GObject * obj)
{
	AlmFilesCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRenderer);
	_g_object_unref0 (self->priv->current_widget);
	_g_object_unref0 (self->priv->pixbuf_);
	_g_free0 (self->priv->text_);
	_g_free0 (self->priv->path_);
	G_OBJECT_CLASS (alm_files_cell_renderer_parent_class)->finalize (obj);
}

static GType
alm_files_cell_renderer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AlmFilesCellRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_files_cell_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmFilesCellRenderer), 0, (GInstanceInitFunc) alm_files_cell_renderer_instance_init, NULL };
	GType alm_files_cell_renderer_type_id;
	alm_files_cell_renderer_type_id = g_type_register_static (gtk_cell_renderer_get_type (), "AlmFilesCellRenderer", &g_define_type_info, 0);
	AlmFilesCellRenderer_private_offset = g_type_add_instance_private (alm_files_cell_renderer_type_id, sizeof (AlmFilesCellRendererPrivate));
	return alm_files_cell_renderer_type_id;
}

GType
alm_files_cell_renderer_get_type (void)
{
	static volatile gsize alm_files_cell_renderer_type_id__once = 0;
	if (g_once_init_enter (&alm_files_cell_renderer_type_id__once)) {
		GType alm_files_cell_renderer_type_id;
		alm_files_cell_renderer_type_id = alm_files_cell_renderer_get_type_once ();
		g_once_init_leave (&alm_files_cell_renderer_type_id__once, alm_files_cell_renderer_type_id);
	}
	return alm_files_cell_renderer_type_id__once;
}

static void
_vala_alm_files_cell_renderer_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	AlmFilesCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRenderer);
	switch (property_id) {
		case ALM_FILES_CELL_RENDERER_PIXBUF_PROPERTY:
		g_value_set_object (value, alm_files_cell_renderer_get_pixbuf (self));
		break;
		case ALM_FILES_CELL_RENDERER_TEXT_PROPERTY:
		g_value_set_string (value, alm_files_cell_renderer_get_text (self));
		break;
		case ALM_FILES_CELL_RENDERER_PATH_PROPERTY:
		g_value_set_string (value, alm_files_cell_renderer_get_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_alm_files_cell_renderer_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	AlmFilesCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ALM_TYPE_FILES_CELL_RENDERER, AlmFilesCellRenderer);
	switch (property_id) {
		case ALM_FILES_CELL_RENDERER_PIXBUF_PROPERTY:
		alm_files_cell_renderer_set_pixbuf (self, g_value_get_object (value));
		break;
		case ALM_FILES_CELL_RENDERER_TEXT_PROPERTY:
		alm_files_cell_renderer_set_text (self, g_value_get_string (value));
		break;
		case ALM_FILES_CELL_RENDERER_PATH_PROPERTY:
		alm_files_cell_renderer_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

