// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A9__F278

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x)xyzw" };
#else
{ R"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊bf16@16_96_F_T_3_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1201)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x14d22ea5u, 0x1dfe44e1u, 334, 83 }, // 14d22ea51dfe44e1 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_16_16_False__CO__wave1_warp2_stg1--Arch_gfx1201
    { 0x3837ecafu, 0xea18d1e7u, 334, 16 }, // 3837ecafea18d1e7 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_16_16_False__CO__wave2_warp2_stg1--Arch_gfx1201
    { 0x3095f14du, 0x40c67468u, 334, 33 }, // 3095f14d40c67468 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_16_16_False__CO__wave3_warp2_stg1--Arch_gfx1201
    { 0xe172a3bfu, 0x4a30a955u, 334, 50 }, // e172a3bf4a30a955 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_16_16_False__CO__wave4_warp2_stg1--Arch_gfx1201
    { 0x5120f4f2u, 0x9f62a452u, 219, 202 }, // 5120f4f29f62a452 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_32_16_False__CO__wave1_warp4_stg1--Arch_gfx1201
    { 0x286b551cu, 0xc88d69e0u, 219, 116 }, // 286b551cc88d69e0 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_32_16_False__CO__wave2_warp4_stg1--Arch_gfx1201
    { 0xdfeff781u, 0xc25692cbu, 219, 167 }, // dfeff781c25692cb = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_32_16_False__CO__wave3_warp4_stg1--Arch_gfx1201
    { 0x06af629fu, 0x90096a87u, 219, 133 }, // 06af629f90096a87 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_32_16_False__CO__wave4_warp4_stg1--Arch_gfx1201
    { 0xcfef5996u, 0xf21c40dfu, 350, 202 }, // cfef5996f21c40df = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1201
    { 0xdebf6419u, 0x773150beu, 350, 116 }, // debf6419773150be = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_32_32_False__CO__wave2_warp4_stg1--Arch_gfx1201
    { 0xa3b60749u, 0x8c79371au, 350, 167 }, // a3b607498c79371a = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_32_32_False__CO__wave3_warp4_stg1--Arch_gfx1201
    { 0x17c5f3c6u, 0x2939fa07u, 350, 133 }, // 17c5f3c62939fa07 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_32_32_False__CO__wave4_warp4_stg1--Arch_gfx1201
    { 0x4156c118u, 0xc80184acu, 235, 202 }, // 4156c118c80184ac = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_64_32_False__CO__wave1_warp4_stg1--Arch_gfx1201
    { 0x595aa42bu, 0x1cf5829du, 235, 116 }, // 595aa42b1cf5829d = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_64_32_False__CO__wave2_warp4_stg1--Arch_gfx1201
    { 0x8f2e7146u, 0x2673a1c9u, 235, 167 }, // 8f2e71462673a1c9 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊bf16@16_96_F_T_3_0___gfx120x__P__2_2_64_32_False__CO__wave3_warp4_stg1--Arch_gfx1201
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1201_mod0
{{ 0, 0, 1, 1, 2, 3, 0, 1, 1, 3},
 { 5, 7, 7, 7, 7, 7,11,11,10,11},
 { 4, 7,11,11,11,11,11,11,11,11},
 { 4,11,11,11,11,11,11,11,11,11},
 { 4, 9,11,11,11,11,11,11,11,11},
 { 5,13, 9,13,13,11,11, 8,11,11},
 { 6,13,12,13,13,12,13,13,13,13},
 { 6,13,12,12,12,12,12,13,13,13},
 { 7,12,12,12,12,13,13,13,13,13},
 { 7,14,14,12,13,13,14,13,12,12}}
// End of GPU gfx1201_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A9__F278 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 5;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 5;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*bf16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 96
// Head_dim = 96
// PADDED_HEAD = False
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 3
// Window_left = "i32"
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = "*i32"
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1201_mod0') AND inputs$Q_dtype = 'torch.bfloat16' AND inputs$BLOCK_DMODEL = 96 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = True AND inputs$CAUSAL_TYPE = 3 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

