//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/transport_sockets/tls/cert_mappers/sni/v3/config.proto

package sniv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on SNI with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *SNI) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on SNI with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in SNIMultiError, or nil if none found.
func (m *SNI) ValidateAll() error {
	return m.validate(true)
}

func (m *SNI) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetDefaultValue()) < 1 {
		err := SNIValidationError{
			field:  "DefaultValue",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return SNIMultiError(errors)
	}

	return nil
}

// SNIMultiError is an error wrapping multiple validation errors returned by
// SNI.ValidateAll() if the designated constraints aren't met.
type SNIMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m SNIMultiError) Error() string {
	msgs := make([]string, 0, len(m))
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m SNIMultiError) AllErrors() []error { return m }

// SNIValidationError is the validation error returned by SNI.Validate if the
// designated constraints aren't met.
type SNIValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e SNIValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e SNIValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e SNIValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e SNIValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e SNIValidationError) ErrorName() string { return "SNIValidationError" }

// Error satisfies the builtin error interface
func (e SNIValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sSNI.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = SNIValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = SNIValidationError{}
