#include "map.h"

// clang-format off
const char MAP_SVG[] =
    "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
    "<svg width=\"2133.3\" height=\"1066.7\" preserveAspectRatio=\"none\" xmlns=\"http://www.w3.org/2000/svg\">"
        "<path fill=\"%s\" d=\"M-1 1050v-16.667l25.667.014c18.878.011 27.398.54 32.212 2 4.073 1.236 12.022 1.986 21.043 1.986 10.144 0 15.986.625 19.455 2.084 4.112 1.728 8.254 1.926 24.291 1.156 32.158-1.544 34.318-2.408 10.721-4.289-11.337-.903-21.203-2.234-21.926-2.956-2.239-2.24 3.968-6.623 11.363-8.025 3.78-.717 12.12-1.304 18.535-1.304 11.26 0 11.684-.11 12.276-3.208.514-2.69-.027-3.337-3.345-4-2.176-.435-5.683-.791-7.79-.791-2.11 0-3.834-.517-3.834-1.148 0-1.548 11.48-2.827 25.503-2.84 8.728-.01 11.915-.508 13.21-2.069 2.835-3.416-.184-4.724-13.54-5.866-9.38-.803-15.007-2.132-22.507-5.315-12.21-5.183-13.508-6.321-10.088-8.845 2.065-1.524 5.916-1.736 19.333-1.064 17.684.885 16.793 1.008 51.172-7.076 7.929-1.864 15.99-3.089 17.914-2.721 1.924.368 6.536-.095 10.25-1.03 3.714-.933 13.652-2.055 22.086-2.492 8.433-.438 17.429-1.412 19.99-2.165 6.368-1.872 19.476-1.725 22.644.253 2.05 1.28 3.803 1.26 8.315-.096 3.145-.945 7.368-2.044 9.384-2.44 2.017-.398 3.667-1.554 3.667-2.571 0-2.374 4.415-2.359 18.173.062 5.962 1.05 23.362 2.31 38.667 2.802 30.239.972 37 1.712 53.16 5.819 7.897 2.006 15.084 2.722 27.668 2.756 16.912.045 20.106-.892 14-4.107-1.65-.87-3.3-2.023-3.667-2.564-.366-.541-2.916-1.92-5.666-3.066s-5-2.594-5-3.221 2.075-3.152 4.612-5.61l4.612-4.47 18.388-.35c16.79-.318 19.092-.068 26.493 2.876 8.93 3.552 11.984 3.885 17.258 1.88 2.764-1.052 4.856-.76 9.59 1.333 4.678 2.07 8.965 2.682 18.883 2.698 7.766.012 14.936.778 18.164 1.941 8.91 3.21 15.911 2.616 20.954-1.777 5.712-4.977 14.118-6.277 23.057-3.565 8.676 2.631 9.177 2.575 6.832-.772-2.664-3.804-1.475-6.18 3.602-7.194 2.322-.464 6.207-1.46 8.633-2.211 3.987-1.236 4.33-1.738 3.562-5.231-.738-3.36-.356-4.056 2.923-5.332 2.37-.922 7.856-1.146 14.77-.604 6.05.475 10.999.382 10.996-.206-.003-.588-1.23-3.077-2.725-5.53-2.119-3.475-2.376-4.874-1.165-6.333.855-1.03 2.058-1.873 2.674-1.873 3.236 0 16.806-6.15 22.906-10.381 6.718-4.659 7.536-4.873 21.648-5.65 12.992-.714 15.56-1.28 22.487-4.953 8.657-4.59 10.857-4.478 12.136.62.942 3.75-.79 5.619-5.29 5.711-1.467.03-9.267 1.73-17.333 3.777-14.163 3.593-14.653 3.839-14.258 7.146.379 3.173-.283 3.634-9 6.282-9.778 2.97-10.468 3.823-8.108 10.028 1.114 2.93 2.117 3.423 7 3.44 6.988.026 7.625.474 11.32 7.98 3.808 7.737 5.205 18.503 2.813 21.674-2.211 2.93-25.957 11.091-35.766 12.292-4.034.494-16.728 1.116-28.21 1.382s-23.181.935-26 1.485l-5.123 1 5.333 1.648c2.933.906 7.283 1.694 9.667 1.75 4.648.11 5.84 2.111 1.985 3.335-1.291.41-8.888 1.946-16.88 3.415-7.994 1.468-14.758 2.894-15.03 3.167-.274.273 2.455.888 6.064 1.367s9.479 2.509 13.045 4.511c6.276 3.524 7.165 3.645 27.816 3.767 20.328.12 21.66.292 28.289 3.666 3.826 1.948 8.626 3.554 10.667 3.57 3.33.026 7.095 1.549 17.71 7.161 3.912 2.068 17.098.951 26.668-2.258 13.496-4.527 20.787-5.294 43.518-4.58 25.106.788 44.162-.749 55.149-4.45 9.415-3.17 21.182-5.215 30.578-5.312 7.325-.076 20.483-2.14 15.539-2.437-1.402-.084-5.902-1.122-10-2.306-15.092-4.36-16.59-5.832-9.117-8.956 2.383-.996 5.157-2.804 6.163-4.018 1.33-1.604 4.061-2.218 10-2.247 13.627-.07 26.53-2.295 34.214-5.903 5.915-2.777 8.548-3.28 13.957-2.669 7.52.85 26.07-2.07 32.848-5.17 6.764-3.093 19.446-8.105 29.152-11.52 4.767-1.678 9.867-4.424 11.333-6.103 3.97-4.544 12.634-5.401 42.667-4.221 14.667.576 28.167 1.085 30 1.131 1.833.047 7.833-.575 13.333-1.382 27.852-4.083 36.218-4.478 44.128-2.084 6.454 1.954 8.848 2.065 16.353.758 5.095-.887 23.242-1.527 43.156-1.523 45.064.011 68.203-2.333 81.577-8.263 3.547-1.572 8.24-1.885 21.333-1.42 17.686.629 24.974-.734 47.086-8.804 4.198-1.533 9.598-2.794 12-2.804 2.402-.009 11.867-1.201 21.033-2.649 26.493-4.184 35.688-3.66 60.922 3.466 4.757 1.343 12.78 1.903 25.647 1.79 17.055-.15 19.142.094 23.411 2.732 5.278 3.261 5.264 3.197 2.778 13.596-.997 4.171-1.497 7.9-1.11 8.286.385.386 6.391-2.366 13.346-6.115 12.305-6.634 12.972-6.826 24.825-7.144 9.896-.266 13.556-.977 19.514-3.79 4.07-1.92 9.72-3.468 12.694-3.475 2.948-.007 9.548-1.144 14.667-2.526 10.978-2.966 36.226-4.445 70.645-4.14 17.12.153 26.681-.364 33.333-1.801 19.652-4.245 27.342-4.646 60.661-3.157 17.967.803 58.196 1.312 89.398 1.133 40.897-.236 57.83.109 60.667 1.234 2.165.859 12.336 2.01 22.602 2.558 14.202.759 21.537 1.851 30.667 4.569 8.758 2.606 16.143 3.757 27.333 4.257 27.611 1.236 65.825 6.772 87.306 12.647 5.119 1.4 11.728 2.546 14.687 2.546 6.777 0 17.182 5.344 17.757 9.12.23 1.508-.241 3.973-1.047 5.478-1.368 2.556-2.673 2.735-19.92 2.735-20.457 0-20.108-.138-23.439 9.303-2.42 6.863-1.422 8.634 6.148 10.902 2.846.853 5.175 2.054 5.175 2.67 0 .615-2.167 3.517-4.816 6.45-4.756 5.263-4.907 5.32-12 4.486-8.241-.968-9.226.568-4.342 6.776 3.564 4.531 7.112 5.934 20.492 8.103 18.673 3.027 26.543 4.685 31.333 6.602 2.567 1.027 11.267 2.222 19.333 2.656 8.067.433 19.617 1.155 25.667 1.604l11 .815v35.633H.039zm750.33-36.773c-3.368-1.961-2.873-3.712 1.333-4.725 6.829-1.644 16.085-7.075 18.974-11.131l2.875-4.037h15.045c13.453 0 15.525.322 19.576 3.043 2.994 2.011 4.676 4.3 4.96 6.747.785 6.772-1.168 7.543-19.097 7.543-11.509 0-17.756.592-21.127 2-5.427 2.268-19.027 2.606-22.539.56zm-639-5.227c-1.467-.63-4.767-1.197-7.333-1.26-5.817-.142-8.632-1.836-7.585-4.565 1.348-3.514 7.639-4.063 20.685-1.807 13.543 2.342 17.248 4.136 14.753 7.143-1.704 2.053-16.082 2.397-20.52.49zm532.99-3c1.364-4.171 26.344-10.43 26.344-6.6 0 2.127-3.275 4.268-6.6 4.314-1.87.026-4.9.905-6.733 1.953-4.255 2.432-13.776 2.676-13.011.333zm11.011-141.75c-3.667-1.766-8.849-3.218-11.516-3.228-6.768-.024-16.891-7.063-21.063-14.647-5.629-10.23-5.9-18.37-1.199-36.034 2.245-8.435 4.913-16.957 5.93-18.937 1.27-2.472 1.848-8.553 1.848-19.405 0-14.184.342-16.49 3.333-22.492 1.833-3.678 5.043-8.603 7.133-10.945 3.5-3.92 3.864-5.34 4.6-17.908.44-7.508 1.729-18.45 2.866-24.317 1.359-7.008 2.068-18.288 2.068-32.886v-22.22l-6.333-4.613c-3.483-2.538-10.047-5.956-14.585-7.596-8.332-3.012-10.236-5.098-12.985-14.232-.477-1.584-2.291-3.814-4.032-4.955-1.741-1.14-3.588-4.044-4.104-6.453-1.052-4.912-8.903-18.341-12.768-21.838-1.39-1.258-2.526-2.818-2.526-3.467s-1.3-2.939-2.888-5.087c-2.668-3.61-2.767-4.446-1.298-11.011 1.333-5.956 1.252-8.065-.505-13.04-1.152-3.264-1.788-7.162-1.412-8.661.977-3.9 10.233-17.678 16.07-23.922 5.277-5.644 6.825-10.932 5.032-17.181-.985-3.432-2.266-4.166-12.351-7.078-6.19-1.786-16.141-5.54-22.117-8.34-8.918-4.179-11.671-6.237-15.364-11.486-10.067-14.306-21.904-21.934-34.037-21.934-3.9 0-5.703-1.019-9.873-5.58-4.814-5.268-5.35-5.507-9.512-4.251-2.426.731-5.911.903-7.745.38-1.833-.522-5.19-1.01-7.46-1.083-2.295-.073-5.197-1.316-6.54-2.8-1.327-1.466-3.27-2.666-4.316-2.666-4.022 0-22.503-7.108-25.529-9.82-1.748-1.565-5.498-5.75-8.333-9.3-4.22-5.282-5.155-7.514-5.155-12.299 0-5.105-.49-6.1-3.877-7.85-5.583-2.888-29.45-29.37-34.607-38.397-2.408-4.217-4.784-7.648-5.28-7.625-.496.024-2.018.888-3.382 1.92-2.358 1.787-2.216 2.194 2.885 8.292 8.69 10.388 25.595 36.232 25.595 39.128 0 2.666-.012 2.666-5.33-.047-4.272-2.18-6.258-4.564-10.016-12.027-4.54-9.015-4.845-9.309-9.671-9.329-6.67-.027-7.639-.989-7.716-7.662-.056-4.894-.91-6.558-6.157-12-3.35-3.474-7.806-9.439-9.902-13.254-3.75-6.825-5.531-8.342-12.94-11.028-2.307-.836-4.45-3.07-5.613-5.855-1.034-2.477-4.466-7.531-7.625-11.232-3.16-3.701-8.036-10.529-10.837-15.172l-5.093-8.443.76-16.415c.747-16.16.696-16.552-3.262-25.282-2.212-4.877-4.751-9.331-5.643-9.898-.893-.567-4.136-1.04-7.208-1.051-5.58-.02-5.585-.026-6.471-5.932-.778-5.186-1.77-6.572-8.082-11.292-3.957-2.96-7.195-5.128-7.195-4.818 0 .31.688 2.073 1.53 3.92 1.18 2.59 1.142 3.821-.164 5.395-.93 1.122-2.173 2.04-2.76 2.04-2.68 0-9.93-7.82-12.32-13.29-1.453-3.323-5.82-9.688-9.704-14.142-7.009-8.037-12.716-11.682-24.94-15.931-3.497-1.216-7.109-2.961-8.027-3.88-2.664-2.664-27.02-3.482-38.497-1.293-5.382 1.026-12.916 1.867-16.743 1.867-6.883.001-7.016.08-12.346 7.295-5.938 8.037-8.748 10.04-14.087 10.04-3.167 0-3.47-.385-2.703-3.44.78-3.108.57-3.348-2.188-2.488-7.013 2.185-9.054 3.286-9.073 4.895-.04 3.374-2.364 5.253-8.086 6.539-3.205.72-6.26 2.01-6.79 2.865-.529.856-4.743 1.968-9.366 2.47-17.573 1.91-26.183 3.732-40.03 8.467-13.987 4.783-19.683 5.492-20.643 2.571-.275-.838 4.482-2.75 11.23-4.513 6.438-1.682 19.806-6.317 29.706-10.299 9.9-3.982 20.728-8.015 24.062-8.961 8.688-2.467 12.165-4.611 11.67-7.196-.358-1.875-2.45-2.306-12.747-2.627l-12.318-.383v-7.9h-8.576c-7.944 0-8.779-.285-11.333-3.873-3.41-4.788-3.414-5.613-.063-12.18 2.638-5.172 2.843-5.28 9.924-5.28 5.928 0 7.6-.527 9.276-2.92 1.124-1.606 1.797-3.168 1.494-3.47-.302-.303-5.565.117-11.694.932-9.416 1.253-12.103 1.156-17.336-.627-13.448-4.582-9.594-8.916 9.273-10.427 11.78-.944 15.035-1.737 15.035-3.664 0-2.067-6.472-3.825-14.087-3.825-7.654 0-8.164-.527-5.71-5.911 1.636-3.592 2.64-4.07 11.387-5.429 3.075-.477 6.331-1.76 7.237-2.852 2.68-3.23 8.72-5.807 13.607-5.807 2.51 0 7.116-.9 10.234-2 9.255-3.266 19.202-2.735 50 2.67 6.6 1.159 22.467 2.429 35.26 2.823 19.68.607 24.062 1.127 28.47 3.376 4.324 2.206 6.948 2.542 15.408 1.973 19.376-1.302 32.008-3.026 33.945-4.634 1.069-.887 5.92-1.985 10.782-2.439 6.963-.65 9.97-.315 14.177 1.582 4.593 2.071 5.801 2.16 8.653.634 2.95-1.579 3.655-1.455 6.397 1.12 2.891 2.716 4.367 2.895 23.995 2.895 22.96 0 22.94.008 18.155-7.843l-2.75-4.509-8.245.866c-4.536.476-10.566 1.23-13.402 1.673-4.787.75-19.778-2.494-22.585-4.887-.591-.503.57-4.387 2.58-8.632l3.653-7.716 18.902.893c14.405.68 20.77 1.58 26.754 3.777 7.17 2.635 10.398 2.884 37.185 2.869 16.133-.01 30.818-.273 32.634-.587 2.984-.516 3.431.03 4.667 5.7.751 3.45 1.966 6.82 2.7 7.49 1.92 1.753 13.932 5.572 17.528 5.572 3.88 0 2.998 2.642-1.893 5.675l-3.636 2.254 3.334.029c1.833.016 5.733-1.45 8.666-3.256 3.813-2.349 7.289-3.297 12.191-3.327 6.18-.037 8.476-1.293 8.476-4.634 0-.206-3.45-.764-7.666-1.242-10.618-1.202-27.325-4.904-29.333-6.5-2.225-1.77-2.126-4.999.153-4.999 1.001 0 3.251-1.12 5-2.49 1.75-1.368 5.28-2.819 7.847-3.222 2.566-.403 7.19-1.5 10.275-2.437 5.016-1.524 5.893-1.445 8.316.747 1.49 1.348 3.436 4.465 4.326 6.927 2.037 5.632 3.27 5.675 4.089.142 1.5-10.127-2.38-11.667-29.384-11.667-11.648 0-21.553-.376-22.013-.836-.46-.46.013-2.477 1.05-4.482 2.39-4.624 5.92-5.225 30.178-5.146 18.21.06 22.824-.556 17.688-2.36-3.899-1.37-13.852-7.722-13.855-8.843-.001-.55 3.747-.996 8.33-.991 6.074.006 9.42.727 12.334 2.658 2.2 1.457 5.4 2.653 7.111 2.658 4.616.013 2.802 3.219-2.27 4.009-3.622.564-5.764 2.294-3.497 2.825 2.682.627 28.811-1.997 29.402-2.954.41-.663 1.91-1.205 3.333-1.205 4.05 0 3.052-1.939-2.412-4.687-3.834-1.927-8.167-2.55-18.582-2.673-13.96-.163-23.401-2.734-24.96-6.796-1.049-2.733 5.9-5.74 18.29-7.912 6.005-1.053 13.619-2.774 16.919-3.824 12.28-3.908 48.17-6.258 98-6.418 78.564-.251 76.247-.396 71.848 4.495-1.384 1.538-3.715 3.288-5.182 3.888-2.518 1.03-2.497 1.096.376 1.176 1.674.046 5.065-.76 7.535-1.792 7.822-3.269 21.991-4.697 48.11-4.85 17.294-.1 28.314-.795 34.667-2.186 21.85-4.782 121.72-6.474 138.42-2.344 4.276 1.058 10.132 1.923 13.013 1.923 3.668 0 5.935.83 7.559 2.767 4.207 5.017 6.432 5.47 11.67 2.38 4.5-2.655 5.36-2.736 12.043-1.133 4.85 1.164 11.559 1.461 20.569.912 12.769-.778 13.372-.694 13.372 1.862 0 3.384-9.242 7.808-16.4 7.85-2.786.015-6.76.905-8.831 1.975-2.07 1.071-6.09 2.072-8.934 2.224-8.937.478-14.232 5.163-5.835 5.163 4.214 0 5.388 1.848 2 3.149-2.613 1.002-2.583 3.517.041 3.517 2.809 0 3.8 3.228 2.014 6.563-.886 1.655-2.806 2.77-4.77 2.77-1.807 0-3.285.668-3.285 1.483 0 .977 1.622 1.177 4.762.588 4.587-.86 4.747-.758 4.334 2.763-.313 2.666-1.398 3.914-4.003 4.605-1.965.521-7.065 3.443-11.333 6.493-7.62 5.446-7.772 5.68-8.427 13.011l-.667 7.465-8.836 2.414c-4.86 1.327-11.699 3.936-15.199 5.796-5.044 2.682-8.272 3.383-15.583 3.383-9.021 0-14.328 1.489-28.382 7.961a5248.784 5248.784 0 01-13.333 6.107c-4.433 2.023-12.756 4.307-18.667 5.124l-10.667 1.475-.666 4.667c-.532 3.719-1.681 5.208-5.663 7.333-2.748 1.467-4.998 3.209-5 3.871-.001.663-1.522 4.413-3.376 8.333-3.878 8.196-6.487 8.956-15.303 4.458-2.88-1.47-8.406-3.323-12.28-4.12-12.418-2.552-27.426-14.965-29.871-24.707-.424-1.687-2.36-3.554-4.435-4.277-3.782-1.319-5.405-5.397-5.405-13.582 0-4.142 1.952-5.31 8.874-5.31 3.739 0 4.555-.459 4.145-2.333-.282-1.288-1.37-2.078-2.431-1.763-1.057.313-4.471.823-7.588 1.134-5.657.563-5.667.556-5.667-3.927 0-4.93-5.09-13.506-9.378-15.801-1.463-.783-4.161-3.802-5.995-6.707-1.835-2.906-5.684-6.984-8.554-9.064l-5.22-3.78-27.37-.816c-20.84-.621-28.321-1.308-31.36-2.88-2.194-1.134-6.331-2.062-9.194-2.062-3.677 0-6.24-.96-8.733-3.27-4.458-4.131-4.433-5.54.139-7.842 5.837-2.94 10.698-3.826 26.333-4.795 13.984-.867 15.32-1.515 6.924-3.36-2.934-.645-3.568-1.373-2.934-3.37.713-2.247.368-2.42-2.924-1.463-2.053.597-5.894 1.996-8.535 3.109-2.642 1.112-7.442 2.444-10.667 2.958-12.477 1.99-19.343 4.672-22.34 8.727-2.384 3.224-3.915 3.972-8.128 3.972-6.283 0-11.613 4.057-16.672 12.69l-3.503 5.977h-56.922l-9.15 4.202c-9.536 4.38-15.15 8.507-15.15 11.137 0 2.089 10.446 9.38 15.035 10.495 2.035.495 6.007 2.984 8.828 5.532 4.222 3.815 6.16 4.63 10.966 4.613 3.21-.012 6.738-.622 7.838-1.358 3.511-2.346-4.273-7.951-11.074-7.973-9.473-.031-11.592-1.09-11.592-5.79 0-6.075 4.174-15.256 7.32-16.102 4.933-1.326 54.757-.776 62.769.693 4.351.798 14.812 3.711 23.245 6.475 8.433 2.763 19.779 6.098 25.213 7.412 7.397 1.788 11.166 3.55 15 7.014 2.816 2.544 5.12 5.435 5.12 6.424 0 2.23 4.165 4.558 8.152 4.558 4.713 0 21.437 5.78 22.158 7.659.357.932-.33 3.19-1.527 5.018-1.734 2.646-3.325 3.339-7.813 3.4-3.1.042-8.036.532-10.97 1.088l-5.333 1.01 4.055.957c5.102 1.205 9.578 8.573 7.53 12.397-3.502 6.545-6.052 7.456-18.506 6.616-26.007-1.756-26.678-1.913-29.658-6.964-1.485-2.518-3.57-4.912-4.632-5.32-1.062-.407-8.59-.228-16.73.399-16.977 1.307-19.275.694-17.26-4.606 1.84-4.84 3.377-5.61 11.239-5.634 4.056-.012 8.005-.906 10-2.264 5.087-3.461 10.813-9.715 10.04-10.965-.813-1.317-10.691.331-15.722 2.623-1.92.875-5.036 1.203-6.923.73-3.757-.943-4.604-4.076-1.432-5.293 2.987-1.146 2.439-5.866-.8-6.894-3.163-1.003-4.72.155-5.419 4.028-.807 4.474-4.403 3.893-5.826-.943-1.74-5.91-5.592-6.291-10.613-1.05-3.375 3.522-3.698 4.464-2.301 6.701 2.253 3.608 2.165 3.751-2.605 4.222-3.322.328-4.508 1.255-5.522 4.32-1.101 3.323-.848 4.26 1.711 6.333 1.652 1.337 4.345 2.432 5.983 2.432 3.444 0 8.07 4.492 6.777 6.582-.517.838-5.99 1.418-13.385 1.418-6.9 0-12.879.597-13.333 1.333-1.189 1.924-9.071 1.64-11.902-.43-2.268-1.659-2.28-2.015-.22-6 2.1-4.06 2.082-4.237-.408-4.237-1.43 0-4.381 1.5-6.56 3.334-2.179 1.833-5.179 3.333-6.667 3.333-1.488 0-5.456 2.1-8.819 4.667-3.362 2.566-6.763 4.666-7.557 4.666-.793 0-3.896 2.1-6.895 4.667-2.998 2.567-5.847 4.667-6.331 4.667-1.37 0-3.637 5.806-2.994 7.666.317.917 1.876 1.676 3.464 1.688 3.993.028 5.824 1.424 7.44 5.673 1.293 3.403 1.901 3.64 9.34 3.64 5.452 0 9.345.81 12.366 2.575 7.237 4.226 22.284 9.386 30.022 10.296 6.339.745 7.756 1.491 11.371 5.99 2.271 2.826 4.894 5.138 5.828 5.138 2.674 0 3.427 2.322 1.666 5.141-1.39 2.225-1.072 3.05 2.288 5.945l3.902 3.362 1.072-2.868c.613-1.641.47-4.19-.334-5.954-1.708-3.75-1.791-9.618-.172-12.176.773-1.222.532-2.543-.687-3.762-2.877-2.877-2.295-4.882 2.752-9.474 5.6-5.097 6.499-5.183 8.488-.818 2.232 4.898 1.972 5.822-2.12 7.56l-3.666 1.558 3.78.509c5.823.784 7.553-.462 7.553-5.441 0-4.616-2.572-7.96-8.33-10.83-4.694-2.34-4.484-5.59.423-6.57 3.805-.762 4.134-1.204 3.354-4.513-.475-2.018-1.218-6.17-1.65-9.229-.782-5.528-.758-5.567 4.375-6.992 9.964-2.767 16.675-1.836 27.968 3.88 5.79 2.93 11.916 5.33 13.615 5.333 4.761.009 8.246 2.454 8.246 5.786 0 4.622 2.561 6.22 9.973 6.22 6.014 0 7.267-.524 11.175-4.667 2.421-2.567 4.9-4.667 5.507-4.667 2.954 0 12.042 7.505 13.237 10.93 2.2 6.309 13.296 18.404 16.885 18.404 1.717 0 6.432 2.698 10.486 6 4.052 3.3 7.954 6 8.672 6 2.401 0 4.066 5.09 4.066 12.436 0 7.826 1.08 9.086 6.84 7.984 2.95-.564 3.85.32 7.734 7.608 3.79 7.112 4.185 8.707 2.87 11.595-1.68 3.686-2.755 3.704-28.11.48-5.5-.7-10.75-1.309-11.668-1.354-3.101-.153-1.69-4.472 3.778-11.56 3.948-5.118 5.206-7.808 4.577-9.79-1.033-3.255-3.695-3.536-6.094-.645-2.695 3.247-8.708 5.912-13.34 5.912-3.797 0-4.13.32-3.394 3.252.45 1.788.352 3.538-.215 3.89s-5.682-1.204-11.365-3.454c-9.312-3.687-10.693-3.914-13.973-2.295-3.612 1.783-3.586 1.803 3.278 2.565 3.805.422 7.31 1.16 7.79 1.638.478.48.1 3.001-.841 5.604-.942 2.603-1.303 5.141-.804 5.64 1.762 1.763 11.01 2.601 16.924 1.534 7.738-1.396 9.346-.67 9.346 4.22 0 5.303-3.63 7.55-15.167 9.385-5.042.803-10.951 2.381-13.13 3.508-3.247 1.68-5.084 1.783-10.166.572-5.242-1.249-7.34-1.085-13.536 1.058-7.297 2.523-7.332 2.562-7.027 7.71.27 4.555-.228 5.52-4.168 8.077-2.462 1.598-7.045 3.597-10.186 4.442-12.668 3.411-17.285 9.739-17.285 23.686v9.384l-6.253 2.131c-3.44 1.172-7.676 3.478-9.415 5.125-1.738 1.647-6.274 4.495-10.08 6.328-7.898 3.805-9.258 7.488-5.863 15.875 2.435 6.015 4.944 16.502 4.944 20.663 0 5.184-4.243 9.358-8.441 8.304-2.34-.587-3.559-1.787-3.559-3.503 0-1.436-1.428-3.546-3.173-4.69-1.895-1.241-3.858-4.522-4.87-8.14-2.1-7.5-4.347-9.842-9.438-9.842-2.177 0-6.31-1.2-9.185-2.667-6.986-3.564-8.644-3.38-12 1.334-3.366 4.726-6.655 5.037-19.394 1.837-5.787-1.453-9.155-1.73-10.274-.844-.916.725-5.682 2.636-10.59 4.246-7.981 2.618-9.084 3.41-10.428 7.485-.828 2.506-1.135 5.154-.684 5.884.451.73.074 4.94-.837 9.353-1.43 6.926-1.357 8.896.542 14.365 1.21 3.487 2.837 8.834 3.617 11.882 1.755 6.867 6.2 8.832 17.22 7.61 8.463-.94 15.38-5.196 16.648-10.245.654-2.606 2.099-3.457 7.824-4.602 7.689-1.54 13.513-.926 15.649 1.647 2.112 2.545.06 13.645-3.489 18.875-1.726 2.544-3.138 5.17-3.138 5.836 0 1.481 7.78 3.81 16.389 4.908 8.158 1.039 9.29 3.131 9.192 16.979-.065 9.126.402 11.517 3.035 15.549 2.664 4.08 4.59 5.204 13.417 7.824 15.533 4.611 27.344 1.8 33.054-7.865 1.406-2.38 3.505-4.058 5.076-4.058 1.473 0 3.99-.71 5.591-1.577s7.396-1.713 12.876-1.88c8.342-.253 10.614.161 13.962 2.545 5.228 3.722 20.715 6.413 26.57 4.616 3.846-1.18 5.143-.81 11.59 3.314 3.991 2.554 9.914 6.862 13.16 9.575 3.247 2.712 8.175 6.09 10.951 7.507 2.777 1.416 5.69 3.773 6.473 5.238 1.207 2.255 2.794 2.662 10.389 2.662 8.243 0 9.636.439 17.316 5.457 8.839 5.775 11.206 9.047 13.693 18.926 1.907 7.574 4.058 9.506 12.876 11.567 3.819.892 10.419 3.75 14.667 6.35 4.248 2.601 9.823 5.191 12.39 5.756 19.895 4.377 31.558 8.278 35.305 11.809 2.216 2.088 5.825 4.22 8.021 4.74 5.564 1.314 7.34 3.122 7.34 7.471 0 2.063.599 5.323 1.33 7.245 1.662 4.373.137 7.46-9.847 19.93-8.345 10.421-12.792 21.494-12.857 32.007-.03 4.779-.998 8.294-3.327 12.074-1.806 2.934-3.288 7.003-3.291 9.043-.02 10.225-8.458 19.115-22.618 23.827-20.962 6.976-29.39 13.083-29.39 21.298 0 5.033-3.018 10.888-9.537 18.498-2.827 3.3-7.087 8.653-9.468 11.896-2.38 3.243-7.028 7.853-10.328 10.245-4.89 3.545-7.294 4.365-13 4.438l-7 .088v5.837c0 3.21-.863 7.905-1.92 10.432-2.237 5.356-8.147 7.732-19.234 7.732-4.584 0-6.848.55-6.853 1.666-.004.917-.592 3.772-1.307 6.345-1.26 4.536-1.475 4.665-7.068 4.22-7.349-.585-10.303 2.132-6.28 5.773 3.708 3.356 3.362 4.506-2.035 6.761-4.16 1.738-4.53 2.276-3.23 4.703 2.145 4.008.688 6.268-4.693 7.278-4.285.803-10.047 5.787-10.047 8.69 0 .592 2.55 1.262 5.667 1.487 5.42.392 5.65.585 5.273 4.41-.558 5.675-11.338 15.212-17.273 15.282-5.668.067-5.532 1.783.935 11.788 4.84 7.49 5.874 8.327 12.742 10.323 9.465 2.752 9.324 5.255-.583 10.273-8.707 4.41-12.032 4.45-20.76.245zM688.97 51.2c-.443-.443-1.593-.49-2.556-.105-1.063.426-.747.742.806.806 1.405.058 2.193-.258 1.75-.7zm156.69 805.84c-4.31-2.078-3.696-3.706 1.4-3.706 4.17 0 7.6 1.926 7.6 4.267 0 1.502-5.424 1.164-9-.56zm-138.67-14.414c-1.65-.663-3-2.125-3-3.248 0-1.64 1.83-2.043 9.255-2.043 9.804 0 12.946 1.76 8.694 4.869-2.769 2.024-10.426 2.24-14.95.422zm767.22-14.18c-.489-.49-.889-2.356-.889-4.149 0-3.041.335-3.198 5-2.34 6.308 1.159 7.921 2.66 5.714 5.32-1.713 2.065-8.162 2.831-9.825 1.168zm585.9-15.456c-.688-1.81-2.497-3.617-4.02-4.015-1.608-.42-2.77-1.813-2.77-3.32 0-3.85 5.054-8.62 15.052-14.212 4.895-2.737 11.345-7.754 14.332-11.148 5.268-5.985 5.65-6.166 12.69-6.001 5.47.128 7.26-.298 7.26-1.728 0-1.043-.836-1.897-1.858-1.897-3.644 0-4.744-7.954-1.476-10.667 1.127-.935 2-3.841 2-6.653 0-4.348-.689-5.449-5.333-8.522-3.247-2.149-5.333-4.566-5.333-6.177 0-5.931 11.068-1.041 19.56 8.641 5.902 6.73 6.914 7.345 12.107 7.36 5.372.017 5.666.22 5.666 3.922 0 3.7-1.987 6.768-5.872 9.066-.957.566-3.327 3.568-5.268 6.671-2.348 3.754-4.754 5.89-7.194 6.382-2.016.407-5.766 1.874-8.332 3.26-3.682 1.988-4.612 3.26-4.405 6.03.22 2.967-.636 3.894-5.546 5.998-3.207 1.375-6.188 3.691-6.658 5.174-1.292 4.068-9.719 10.848-13.485 10.848-1.833 0-4.803.963-6.6 2.14-3.129 2.05-3.318 2.002-4.517-1.151zm-127.15-20.726c-2.817-.558-7.043-8.382-8.381-15.515-.96-5.117-.954-5.126 2.889-4.244 11.757 2.698 13.973 2.65 14.749-.317.41-1.569 1.276-2.853 1.923-2.853.648 0 1.618-.15 2.156-.333 1.921-.655 2.576 9.8 1.003 16.01-1.516 5.981-1.883 6.361-6.792 7.022-2.854.384-6.25.488-7.547.23zm1.025-26.919c-1.466-.555-7.737-1.457-13.934-2.005-16.85-1.49-19.763-2.872-25.325-12.015-5.438-8.94-7.405-10.17-8.607-5.381-.64 2.552-1.715 3.39-4.34 3.39-3.344 0-3.457-.238-2.704-5.726.431-3.15.996-6.6 1.255-7.667.26-1.067-.394.01-1.451 2.394-1.086 2.449-2.913 4.333-4.201 4.333-2.217 0-6.693-3.905-6.693-5.84 0-1.845-10.033-10.308-14.496-12.226-5.38-2.313-9.097-2.389-24.1-.491-16.465 2.083-21.312 3.565-22.875 6.995-1.788 3.925-9.467 6.139-18.232 5.257-5.454-.548-7.597-.2-9.529 1.548-3.01 2.725-14.78 4.059-21.977 2.491-6.449-1.405-8.821-4.576-6.365-8.509 2.962-4.743.62-16.46-6.02-30.12-5.036-10.363-5.71-12.667-4.415-15.086 1.152-2.152 1.147-3.314-.02-4.72-1.188-1.431-.977-4.087.907-11.426 1.996-7.77 3.08-9.816 5.789-10.922 1.833-.748 5.733-2.436 8.667-3.75 2.933-1.313 9.233-3.36 14-4.548 19.897-4.958 21.333-5.756 21.333-11.85 0-5.32 2.762-9.298 7.946-11.446 2.23-.923 4.054-2.565 4.054-3.649s1.863-3.71 4.14-5.838c3.385-3.161 5.316-3.868 10.572-3.868 3.612 0 7.217.787 8.226 1.795.987.988 4.03 2.215 6.761 2.727 4.948.929 4.967.915 4.967-3.632 0-2.51.9-5.31 2-6.223 2.595-2.154 2.56-5.021-.067-5.57-1.802-.375-1.825-.76-.18-2.999 2.752-3.744 17.943-4.808 20.414-1.429 1.463 2.001 3.232 2.259 11.76 1.711l10.04-.644-.86 5.465c-.892 5.68-3.883 11.465-5.927 11.465-2.986 0-.737 3.894 3.001 5.197 2.3.802 4.914 2.46 5.809 3.682.894 1.224 4.262 2.576 7.485 3.006 4.77.637 5.937 1.339 6.284 3.782.555 3.908 2.968 3.748 5.986-.397 1.738-2.388 2.581-6.565 3.017-14.958 1.264-24.321 3.758-32.135 7.473-23.416.884 2.074 2.817 5.143 4.296 6.82 1.514 1.714 3.006 5.795 3.412 9.332.69 5.991.942 6.317 5.39 6.953 4.034.576 4.718 1.208 5.046 4.666.706 7.435 5.918 19.973 9.859 23.715 2.151 2.044 5.528 4.05 7.503 4.46 3.595.745 8.488 6.315 14.785 16.83 1.757 2.934 5.807 7.793 9 10.798l5.807 5.464v11.634c0 19.473-3.588 31.168-11.997 39.1-5.5 5.187-8.003 10.104-8.003 15.726 0 5.295-2.5 7.892-10 10.385-2.933.976-6.233 2.458-7.333 3.295-3.524 2.68-4.612 2.968-7.333 1.937zm-753.93-27.254c-.688-.83-3.38-6.556-5.983-12.727s-6.612-13.559-8.911-16.419c-6.087-7.574-11.235-22.243-13.672-38.958-1.534-10.523-2.756-15.029-4.334-15.986-5.332-3.234-9.62-7.581-11.17-11.324-1.515-3.657-1.34-4.528 1.827-9.098 2.176-3.141 3.502-6.849 3.502-9.795 0-2.699 1.7-7.927 3.949-12.14 3.763-7.052 3.897-7.863 2.85-17.206-1.182-10.529-3.948-16.99-13.764-32.146-3.767-5.817-7.492-9.86-10.442-11.333-5.842-2.918-6.219-5.31-2.2-13.956 3.878-8.346 5.497-19.829 3.194-22.665-2.193-2.7-12.08-6.334-17.28-6.35-2.369-.006-7.516-1.506-11.44-3.333-8.428-3.923-22.302-4.534-29.994-1.32-2.633 1.1-7.27 2-10.304 2-3.035 0-9.14.939-13.566 2.086-10.482 2.716-23.778 1.537-30.351-2.69-2.575-1.657-8.875-7.936-14-13.955-5.125-6.018-11.627-12.337-14.45-14.04-2.821-1.705-7.467-5.927-10.323-9.383L968 461.069l.742-32.2c.408-17.71.998-33.481 1.31-35.047.314-1.566 9.873-12.248 21.245-23.738 18.035-18.223 20.784-21.57 21.524-26.2 1.139-7.123 4.623-11.201 11.962-14.004 5.712-2.182 6.056-2.587 5.319-6.272-.433-2.167-.788-4.764-.788-5.773 0-1.264-1.757-1.84-5.667-1.853-7.43-.027-8.613-.936-10.84-8.338-1.626-5.405-1.616-6.433.076-7.837 1.543-1.28 1.761-3.61 1.049-11.215-1.423-15.182-1.343-15.275 13.14-15.159 6.733.054 15.544.573 19.577 1.154 10.465 1.509 13.333.118 13.333-6.462 0-4.6-.728-5.866-5.667-9.864-3.117-2.523-8.548-5.843-12.07-7.379-5.758-2.51-6.258-3.065-4.953-5.503 1.078-2.014 2.787-2.71 6.658-2.71 2.864 0 5.535-.53 5.935-1.176.4-.647 4.735-1.605 9.634-2.13 9.39-1.006 15.13-2.93 15.13-5.073 0-1.323-6.731-.795-22.668 1.78-15.683 2.533-22.667 2.95-22.667 1.356 0-.82 1.375-2.012 3.055-2.651 3.972-1.51 6.757-4.92 5.576-6.83-1.518-2.456 3.384-11.753 6.436-12.206 1.498-.222 2.971-1.154 3.273-2.07.733-2.225-11.136-2.282-12.509-.061-.546.884-1.188 3.39-1.426 5.57-.538 4.912-.498 4.873-8.133 7.773-12.348 4.69-24.573 2.11-20.548-4.337.903-1.445 1.204-4.303.713-6.758-.951-4.758 1.786-7.854 6.944-7.854 1.58 0 3.932-1.172 5.228-2.604 1.72-1.9 3.397-2.395 6.207-1.833 3.262.652 3.85.344 3.85-2.016 0-1.533-1.2-3.429-2.666-4.214-1.721-.92-2.667-2.792-2.667-5.274 0-3.21.678-3.996 4.09-4.746 2.25-.494 4.446-1.826 4.881-2.96.697-1.814.99-1.79 2.449.206 1.056 1.445 1.974 1.754 2.53.854.481-.777 2.789-1.432 5.129-1.456 2.34-.023 5.332-.86 6.65-1.859 1.317-.999 3.554-1.513 4.972-1.143 2.322.608 2.386.945.649 3.425-1.749 2.497-1.655 2.888 1.016 4.22 3.811 1.9 4.578 6.079 1.524 8.311-1.32.966-1.744 1.755-.943 1.755.8 0 2.673 2.063 4.16 4.584 1.488 2.521 4.471 5.497 6.63 6.613 2.158 1.117 4.244 3.254 4.635 4.75.488 1.866 1.81 2.72 4.212 2.72 4.321 0 5.556 2.834 3.45 7.918-.882 2.13-1.4 4.867-1.152 6.085.346 1.696 3.026.143 11.462-6.643 8.95-7.2 12.246-9.053 17.613-9.901 9.22-1.458 10.709-3.07 10.709-11.597 0-6.69.234-7.202 3.667-8.036 2.016-.49 4.85-1.701 6.296-2.692 5.07-3.472 7.37-2.336 7.37 3.643 0 6.223 3.044 6.807 3.762.722.308-2.612-.715-4.798-3.65-7.799-3.47-3.55-4.525-3.964-7.094-2.787-16.453 7.543-17.911 7.519-26.408-.43-5.864-5.484-6.607-6.8-6.59-11.666.012-3.016.462-6.117 1-6.89 1.475-2.115 12.14-7.335 19.43-9.51 7.48-2.23 16.569-8.45 27.003-18.476l7.371-7.082-3.745-.503c-3.531-.473-3.364-.675 2.92-3.524 3.668-1.663 7.568-3.815 8.668-4.783 1.1-.967 4.7-2.184 8-2.704s8.615-2.08 11.813-3.468 11.597-3.076 18.667-3.752c7.07-.676 14.543-1.88 16.607-2.677 2.064-.797 9.03-1.448 15.479-1.448 10.414 0 12.545.437 19.052 3.91 5.003 2.67 10.876 4.388 18.52 5.418 6.157.83 16.026 2.97 21.93 4.756s12.85 3.249 15.435 3.249c5.672 0 10.497 4.482 10.497 9.752 0 3.072.555 3.581 3.913 3.581 2.152 0 5.498-.603 7.435-1.339 3.145-1.196 3.48-1.944 3.132-7l-.39-5.66 7.955.47c9.728.575 10.74 1.118 7.91 4.244-4.73 5.227 1.68 7.093 9.012 2.623 2.4-1.463 5.9-2.663 7.777-2.666 1.877-.003 4.577-.886 6-1.963 1.424-1.077 4.149-1.977 6.056-2 1.907-.023 5.42-.723 7.807-1.555 3.257-1.135 6.05-1.123 11.199.051 4.624 1.054 10.988 1.221 19.526.513 12.75-1.058 15.644-2.777 8.006-4.756-2.747-.712-4.006-1.864-4.006-3.667 0-3.153 1.247-3.257 7.539-.628 2.953 1.234 9.035 2 15.878 2 6.1 0 11.463.6 11.916 1.333s2.618 1.333 4.812 1.333c2.193 0 5.798.937 8.01 2.08s5.033 1.847 6.267 1.56c1.753-.406 1.468-.896-1.304-2.24-2.432-1.18-3.816-3.144-4.398-6.25-1.01-5.378-.162-7.15 3.419-7.15 1.457 0 4.074-1.425 5.816-3.168 5.982-5.982 11.093-8.832 15.838-8.832 2.594 0 5.11.637 5.59 1.416s2.37 1.983 4.195 2.677c3.075 1.17 3.242 1.679 2.279 6.918-1.462 7.943-.828 14.713 1.498 16.015 3.163 1.77 2.3 5.8-2.022 9.437-7.032 5.916-4.478 6.773 3.88 1.3 6.03-3.947 6.684-6.23 2.962-10.343-1.37-1.514-2.857-5.592-3.304-9.061-.677-5.247-.364-6.728 1.86-8.8 1.624-1.513 2.341-3.353 1.828-4.69-.67-1.749-.013-2.202 3.203-2.202 3.847 0 7.442 2.279 8.473 5.372.312.936 2.154.717 5.41-.643 2.714-1.134 6.239-2.062 7.831-2.062 1.593 0 3.705-1.05 4.693-2.334 1.695-2.2 1.93-2.173 4.147.474 2.54 3.033 7.017 5.148 7.017 3.315 0-.621-.9-1.876-2-2.789-3.88-3.22-2.338-5.333 3.889-5.333 3.239 0 6.102-.639 6.362-1.42.26-.78 3.16-1.743 6.444-2.14 3.285-.395 8.372-1.78 11.305-3.077 5.392-2.383 14.35-4.093 35.75-6.827 7.425-.95 13.952-2.673 17.736-4.685 7.975-4.24 19.906-4.532 21.18-.518 1.338 4.216 9.814 3.572 17.548-1.333l6.308-4h-7.661c-4.66 0-9.332-.89-11.928-2.273-2.347-1.25-8.467-2.706-13.6-3.235-5.133-.53-13.682-1.394-18.997-1.92-11.791-1.169-13.965-3.064-9.098-7.932 2.127-2.127 4.368-3.193 5.784-2.752 1.27.396 4.677-.099 7.569-1.1 3.199-1.108 8.42-1.587 13.333-1.224 11.799.874 13.68 1.449 14.458 4.421.558 2.136 1.813 2.682 6.16 2.682 4.992 0 5.458.296 5.458 3.476 0 2.793.458 3.284 2.333 2.5 1.283-.538 4.433-1.427 7-1.976 2.567-.55 5.717-1.439 7-1.976 1.66-.694 2.333-.357 2.333 1.166 0 1.564 1.273 2.143 4.709 2.143 5.209 0 7.319 2.754 4.61 6.017-1.41 1.7-.881 1.983 3.688 1.983 4.875 0 13.073 2.502 15.191 4.636.476.48 6.917 1.052 14.313 1.272 16.355.485 17.62 1.264 16.561 10.194l-.777 6.565 7.852.176c18.002.403 25.866 1.07 28.364 2.408 1.456.779 5.916 1.416 9.912 1.416 6.29 0 7.365-.38 8.007-2.838.706-2.7 1.28-2.796 11.822-1.967 25.878 2.035 24.881 1.744 27.888 8.142 1.484 3.157 3.837 6.77 5.229 8.03 2.53 2.29 3.055 2.21 9.296-1.4 2.354-1.361 7.838-1.95 18.667-2.006 9.89-.05 17.226-.766 20.667-2.016 3.491-1.268 13.623-2.226 29.333-2.773l24-.835 16.783 5.498c16.542 5.42 17.062 5.498 36.147 5.498 18.253 0 19.635.184 24.09 3.208 4.35 2.952 6.072 3.216 21.654 3.318 9.31.061 19.586-.558 22.835-1.376 5.062-1.274 6.267-1.162 8.421.788 1.966 1.78 3.1 1.961 5.204.835 3.832-2.05 20.266-1.776 33.532.56 6.234 1.099 13.883 1.998 17 1.999l5.667.002v10.588c0 5.823-.565 10.937-1.256 11.364-2.536 1.567-3.095 12.168-.87 16.472 1.17 2.26 2.126 4.37 2.126 4.687 0 .317-3.75.948-8.333 1.401-23.202 2.293-27.458 3.096-35 6.6-7.542 3.505-23.386 6.014-39 6.175-2.384.025-4.334.691-4.334 1.481 0 2.507-7.875 9.465-9.545 8.433-1.076-.664-1.296-.246-.695 1.32.484 1.262.052 4.21-.96 6.553-2.24 5.187-21.926 24.3-35.133 34.11-5.317 3.95-9.667 7.658-9.667 8.24 0 1.732-7.874 6.81-9.244 5.963-2.314-1.43 1.333-8.528 5.688-11.071l4.223-2.467v-17.382c0-19.457.393-20.498 8.67-22.978 3.166-.948 8.13-4.284 12.104-8.136 5.884-5.7 6.552-6.876 5.268-9.274-1.592-2.975-2.405-3.154-13.302-2.93-10.587.217-15.91 2.309-16.852 6.62-.427 1.96-.993 4.273-1.256 5.14-.352 1.16-9.045 1.552-32.889 1.486-37.091-.104-37.876.056-53.563 10.9-5.334 3.688-11.157 6.747-12.939 6.799-1.782.051-4.349.53-5.703 1.062-1.998.786-2.124 1.229-.667 2.34 2.08 1.59 15.192 5.837 18.015 5.837 1.052 0 3.63.888 5.729 1.973 2.924 1.512 3.666 2.681 3.175 5-.562 2.66-.46 2.744.851.694 2.346-3.67 6.51-2.926 7.459 1.333.45 2.017 1.66 5.557 2.692 7.868 2.767 6.201 2.463 13.334-.603 14.135-3.146.823-4.478 7.184-2.019 9.643 1.007 1.007 1.83 3.413 1.83 5.348 0 2.94-.45 3.376-2.73 2.652-1.548-.491-3.664-.097-4.885.91-1.96 1.618-2.048 1.061-.976-6.223 1.605-10.904 1.26-22.26-.795-26.097l-1.702-3.181-1.23 3.306c-.675 1.818-2.08 5.004-3.122 7.08-1.041 2.077-1.893 6.315-1.893 9.42 0 5.108-.432 5.85-4.537 7.809-2.495 1.19-6.446 4.539-8.78 7.443-2.334 2.904-8.19 8.767-13.014 13.028-8.327 7.356-9.226 7.797-17.772 8.71-11.387 1.217-16.903 4.04-19.354 9.904-1.365 3.266-2.767 4.584-4.895 4.598-6.933.048-7.106 2.161-.694 8.483 6.527 6.434 8.77 12.98 7.08 20.669-.736 3.353-1.634 4.014-6.445 4.747-12.02 1.83-18.407 2.309-20.432 1.532-1.925-.74-1.922-1.103.031-4.084 3.224-4.921 2.606-10.59-2.054-18.847-3.975-7.043-4.42-7.395-8.334-6.594-14.982 3.065-18.452 2.249-13.535-3.185 1.092-1.206 1.483-2.864.898-3.81-1.51-2.444-10.94 2.075-15.406 7.385l-3.544 4.211 3.328 2.18c2.813 1.844 4.025 1.928 7.85.544 3.66-1.323 5.644-1.28 10.399.224 7.768 2.457 7.62 5.28-.415 7.947-5.994 1.99-11.709 5.876-11.709 7.963 0 1.454 11.868 18.746 15.712 22.893l3.348 3.611-4.84 9.722c-6.13 12.31-24.283 31.215-37.824 39.39-8.998 5.431-9.836 5.666-20.225 5.666h-10.838l-.02 6.333c-.023 7.095-.702 8.595-4.892 10.8-7.582 3.991-11.03-1.596-4.92-7.974 3.037-3.17 3.475-4.361 2.283-6.208-3.194-4.946-20.667-.111-21.531 5.958-.69 4.85 9.899 22.132 14.545 23.738 1.172.405 2.822 2.254 3.666 4.107 1.892 4.151 2.02 18.517.196 21.925-.737 1.378-4.916 4.41-9.285 6.74-4.37 2.328-8.88 5.662-10.024 7.407s-3.265 3.173-4.715 3.173c-2.187 0-2.636-.91-2.636-5.333 0-3.928-.545-5.333-2.066-5.333-1.137 0-4.229-2.1-6.872-4.667-2.642-2.567-5.325-4.667-5.962-4.667-.637 0-1.84-1.5-2.676-3.333-2.813-6.174-8.492-3.295-11.568 5.866-1.868 5.56-1.992 13.468-.211 13.468.72 0 2.797 2.934 4.615 6.52 2.39 4.72 5.16 7.663 10.022 10.654 6.643 4.088 6.718 4.21 6.718 10.9 0 7.472 1.21 10.464 6.862 16.971 4.25 4.892 4.695 6.696 1.918 7.761-3.072 1.18-21.827-18.75-25.535-27.134-1.748-3.953-4.994-9.878-7.213-13.166-7.632-11.308-8.032-12.74-8.032-28.735 0-17.744-2.163-29.105-5.541-29.105-2.342 0-6.46 3.362-6.46 5.274 0 1.959-5.162 2.479-7.517.757-1.747-1.278-2.233-3.328-2-8.435.305-6.681.22-6.836-8.783-15.983l-9.09-9.236-10.638 1.741c-5.851.958-10.788 1.773-10.971 1.812-.184.039-.334 1.23-.334 2.646 0 1.417-1.95 3.934-4.333 5.594-2.383 1.66-7.033 5.364-10.333 8.231-3.3 2.868-9.438 6.953-13.64 9.079-4.201 2.126-8.484 5.212-9.516 6.86-1.052 1.677-2.165 8.014-2.531 14.411-.739 12.912-2.288 16.685-10.638 25.908l-5.81 6.418-6.551-10.511c-3.603-5.781-9.644-18.103-13.424-27.383-3.78-9.28-7.402-17.692-8.048-18.694-.646-1.002-1.475-6.022-1.841-11.155l-.667-9.333-6.171-.4c-7.658-.496-14.152-5.68-21.83-17.427l-5.332-8.16-50.315-.015-4.556-4c-2.506-2.2-5.77-4-7.255-4-4.466 0 11.318 18.182 18.568 21.391l5.776 2.557-2.646 3.693c-1.455 2.03-4.263 5.193-6.24 7.026-1.976 1.833-4.67 5.433-5.988 8-3.338 6.505-5.867 8.38-17.619 13.06-5.65 2.25-13.75 6.445-18 9.322-5.283 3.575-11.943 6.403-21.06 8.94-7.333 2.04-14.677 4.927-16.32 6.414-2.494 2.258-3.528 2.457-6.269 1.208-1.805-.822-4.3-3.471-5.542-5.886-1.243-2.415-4.572-7.026-7.397-10.246-4.59-5.231-5.138-6.614-5.138-12.981 0-7.545-.602-8.242-12.667-14.663-1.808-.963-3.526-4.6-5.334-11.3-1.596-5.914-4.684-12.82-7.693-17.207-2.765-4.03-5.638-9.578-6.385-12.328-1.26-4.642-1.712-4.999-6.306-4.98-8.043.033-8.797 1.21-5.606 8.755 1.526 3.607 5.41 10.458 8.63 15.224 3.4 5.03 7.09 12.804 8.797 18.528 2.551 8.553 4.115 11.12 11.784 19.333 21.544 23.076 23.716 25.822 25.251 31.917 2.183 8.668 3.899 8.85 27.056 2.864 11.381-2.942 15.848-1.724 17.54 4.782 1.908 7.345.338 13.37-6.237 23.937-3.39 5.447-6.163 10.657-6.163 11.578 0 .92-2.25 2.838-5 4.262s-8 5.746-11.667 9.606c-13.512 14.223-22.79 22.728-27.483 25.195-5.964 3.135-8.271 8.055-10.471 22.329l-1.696 10.997 5.492 8.429c5.343 8.201 5.49 8.732 5.46 19.669-.046 16.142-1.504 21.123-7.57 25.87-2.786 2.181-7.435 6.28-10.33 9.109s-7.47 6.27-10.167 7.645c-5.88 3-6.9 6.626-4.897 17.4 1.29 6.934 1.15 7.984-1.672 12.55-1.694 2.741-5.881 8.185-9.305 12.098-3.76 4.296-7.68 10.82-9.896 16.47-3.148 8.023-4.653 10.058-10.568 14.285-3.794 2.71-9 6.905-11.568 9.32-3.589 3.374-6.833 4.838-14 6.319-11.186 2.31-40.072 2.493-41.921.264zm206.28-352.45c3.836-.388 6.33-1.495 7.667-3.403 2.967-4.236 2.495-4.9-3.485-4.9-4.353 0-6.225-.815-9.201-4-2.055-2.2-4.94-4-6.409-4-1.756 0-3.876-2.056-6.187-6-3.775-6.441-4.926-6.909-10.037-4.08l-3.3 1.827 7.966 7.887c4.382 4.338 9.016 8.276 10.3 8.751 1.636.606 2.333 2.313 2.333 5.715 0 4.126.349 4.697 2.333 3.815 1.283-.57 4.892-1.295 8.02-1.611zm-201.8-33.113c1.407-.54 2.11-2.482 2.11-5.836 0-9.748.528-9.767 35.741-1.291 21.07 5.071 21.851 5.161 25.267 2.918 2.027-1.33 7.237-2.598 12.258-2.981l8.733-.667 5.962-11.739c4.991-9.828 5.642-11.941 4-12.98-1.08-.682-10.662-1.367-21.295-1.52s-20.833-.409-22.667-.565c-1.834-.157-4.149-.34-5.145-.407-1.256-.085-1.553-1.15-.97-3.474.795-3.166-3.649-13.952-6.219-15.094-.55-.244-1-1.894-1-3.666 0-2.854-.591-3.222-5.17-3.222-3.874 0-5.668.747-7.15 2.981-1.71 2.576-2.278 2.735-4.163 1.17-1.884-1.563-2.183-1.483-2.183.58 0 2.857 3.72 7.269 6.128 7.269 3.493 0 3.039 2.5-1.545 8.503-5.986 7.841-8.951 7.956-12.742.497-1.583-3.117-4.162-6.867-5.731-8.334-1.569-1.466-4.635-7.309-6.815-12.983l-3.962-10.317-6.374-.016c-5.88-.016-6.87-.528-12.748-6.595-6.47-6.678-12.617-9.55-15.108-7.059-2.135 2.135.037 6.802 4.155 8.932 2.054 1.062 4.056 3.156 4.447 4.652s1.685 2.72 2.874 2.72c2.903 0 18.087 7.73 18.087 9.208 0 .643-1.563 1.561-3.473 2.041-3.487.875-3.636 1.838-1.202 7.75.75 1.821.293 2.334-2.077 2.334-3.672 0-7.915-3.57-7.915-6.661 0-2.56-10.268-8.545-17.162-10.004-2.472-.524-7.122-2.803-10.333-5.067-5.284-3.724-6.385-5.145-6.042-7.795.06-.474-1.96-1.25-4.49-1.724-5.21-.977-9.973.983-9.973 4.105 0 1.763-1.63 2.019-10.333 1.62l-10.333-.474-.428 3.736c-.454 3.958-4.243 6.264-10.294 6.264-4.046 0-7.56 5.136-8.544 12.489-.523 3.903-1.438 5.611-3.185 5.947-1.349.26-4.523 1.877-7.055 3.596-2.532 1.718-7.533 4.096-11.112 5.285-5.89 1.957-10.58 5.297-9.238 6.582 1.517 1.452 21.785-1.95 29.24-4.908 7.865-3.121 10.477-3.439 29.95-3.644 24.403-.257 34.84.776 35.906 3.554.403 1.05 1.373 5.913 2.154 10.805.782 4.892 2.138 9.35 3.014 9.907.876.557 5.203 1.022 9.614 1.033 6.972.018 9.24.737 17.333 5.494 7.607 4.47 11.495 6.504 14.87 7.776.124.046 1.174-.28 2.334-.725zm74.776-25.857c-1.528-2.472.794-4 6.079-4 5.658 0 6.829 1.73 2.676 3.954-3.276 1.753-7.686 1.776-8.755.046zm-112.09-12.68c-5.213-2.289-7.948-5.392-5.879-6.671 2.579-1.593 13.214.688 14.453 3.1 2.716 5.288-1.07 6.866-8.574 3.571zm-28.242-12.763c-4.279-1.621-4.331-9.896-.069-11.01 3.88-1.015 6.403 1.265 6.403 5.788 0 4.695-2.432 6.701-6.333 5.223zm-35.667-1.222c-1.087-1.76.507-4.256 2.092-3.277 1.62 1.001 1.61 4.61-.013 4.61-.69 0-1.625-.6-2.078-1.333zm34.89-14.222c-1.546-1.545-.975-2.972 1.777-4.445 2.34-1.252 2.667-1.014 2.667 1.953 0 3.181-2.406 4.53-4.445 2.492zm264.11 27.875c2.75-1 1.994-10.78-1.178-15.236-1.565-2.197-3.145-6.66-3.512-9.916-.557-4.94-1.647-6.785-6.571-11.12-5.885-5.18-5.898-5.21-3.832-9.204 1.556-3.008 3.156-4.112 6.416-4.426 3.253-.314 4.445-1.133 4.749-3.264.695-4.872-7.497-4.794-18.398.175-5.011 2.284-10.078 4.956-11.26 5.936-1.927 1.6-1.94 2.015-.118 4.027 1.117 1.234 2.559 5.07 3.204 8.524 1.234 6.601 4.175 10.917 8.342 12.239 3.164 1.004 3.114 3.071-.176 7.277-3.31 4.232-3.303 6.273.04 11.757 2.66 4.364 2.82 4.42 11.662 4.13 4.93-.163 9.715-.568 10.631-.9zm-143.95-22.405c1.754-1.23 4.098-1.73 5.708-1.219 1.566.497 4.83-.136 7.652-1.485 6.914-3.305 17.361-3.921 25.115-1.482 9.82 3.087 28.737 3.938 32.288 1.45 4.843-3.391 3.502-6.661-5.07-12.354-4.356-2.894-9.1-5.636-10.543-6.094-3.69-1.171-4.615-4.57-2.232-8.205 2.104-3.211 2.762-8.526 1.056-8.526-2.86 0-15.026 6.068-15.026 7.495 0 .918 1.945 1.858 4.322 2.088 2.758.266 4.475 1.223 4.744 2.643.358 1.892-1.114 2.29-9.844 2.666-10.872.468-15.222-1.056-15.222-5.33 0-3.507-11.81-6.038-15-3.214-1.283 1.136-2.333 2.641-2.333 3.345 0 .703-3 4.742-6.667 8.974-6.991 8.07-8.102 11.164-4.504 12.545 1.602.615 1.956 1.861 1.367 4.81-.901 4.505-.074 4.879 4.188 1.893zm150.95-.375c0-.62-1.215-2.225-2.699-3.568-2.148-1.945-3.031-2.104-4.333-.784-1.294 1.312-1.095 2.057.953 3.568 2.866 2.116 6.078 2.53 6.078.784zm36.348-19.207c3.734-1.754 4.615-4.305 3.858-11.165l-.46-4.165-8.54 4.746c-8.463 4.704-10.209 7.383-6.94 10.651 2.073 2.073 7.593 2.043 12.082-.066zm-259.36-62.667c.989-.782 5.161-.937 10.333-.383 5.36.574 8.675.434 8.675-.366 0-.712 1.534-1.68 3.41-2.15 2.612-.656 3.219-1.455 2.596-3.418-.71-2.232 2.177-8.66 4.796-10.683.475-.366 1.273-2.556 1.774-4.866.758-3.497 1.701-4.347 5.637-5.086 2.6-.487 4.492-1.12 4.206-1.407-.286-.286-5.123-.92-10.749-1.41-9.652-.841-10.455-.7-14.249 2.49-2.21 1.861-6.135 4.082-8.72 4.935-4.98 1.643-5.597 2.582-3.244 4.934 3.045 3.045-5.613 12.41-11.473 12.41-1.645 0-3.737.9-4.65 2-.913 1.1-3.201 2-5.085 2-3.298 0-3.329.073-.837 1.959 2.818 2.131 14.478 1.496 17.58-.959zm8.342-14.101c0-2.67 5.238-8.232 7.753-8.232 2.422 0 1.884 3.254-1.183 7.153-3.194 4.06-6.57 4.615-6.57 1.079zm38.667-2.232c0-1.111-1.185-2-2.667-2-2.95 0-3.612 2.062-1 3.117 2.902 1.17 3.667.937 3.667-1.117zm-26.719-19.333c5.868 0 7.357-2.834 5.247-9.984-1.507-5.103-2.185-5.887-4.485-5.19-1.49.452-3.657 1.651-4.815 2.665-1.158 1.013-2.61 1.842-3.228 1.842-2.376 0-6 4.555-6 7.54 0 2.426.73 3.127 3.255 3.127 1.79 0 3.7.72 4.244 1.6.77 1.247 1.108 1.247 1.523 0 .293-.88 2.21-1.6 4.259-1.6zm842.72 1.333c0-.733-.564-1.333-1.255-1.333-.69 0-1.625.6-2.078 1.333-.453.733.11 1.333 1.254 1.333s2.079-.6 2.079-1.333zm-772.32-1.667c-.656-2.004-9.902-4.552-11.331-3.123-.554.554.156 1.859 1.578 2.899 3.264 2.387 10.516 2.554 9.753.224zm24.324-2.012c0-1.544-5.473-4.625-6.461-3.638-.477.478.296 1.72 1.718 2.76 2.853 2.085 4.743 2.435 4.743.878zm-77.905-17.8c4.726-2.279 8.87-4.591 9.208-5.138.337-.546-.833-1.653-2.6-2.458-4.375-1.993-10.303 1.046-13.886 7.12-1.5 2.541-2.409 4.621-2.02 4.621.388 0 4.572-1.865 9.298-4.144zm76.796-6.527c.533-1.6 8.104-1.84 19.163-.61 6.526.726 8.39.49 9.83-1.244 1.578-1.901 1.335-2.051-2.185-1.347-2.196.44-7.612-.233-12.162-1.51-7.36-2.065-17.773-2.158-19.755-.177-.923.924 2.047 6.227 3.488 6.227.646 0 1.376-.603 1.621-1.34zm51.655 537.46c-4.236-2.272-4.637-3.092-6.347-12.997-1.822-10.548-1.818-10.584 1.625-15.658 2.712-3.997 3.158-5.633 2.081-7.644-.753-1.408-1.19-5.987-.97-10.177l.399-7.618 8.903-4.345c8.106-3.955 9.462-5.24 15.138-14.347 3.429-5.501 6.647-10.003 7.151-10.003.505 0 2.543 3.21 4.53 7.134 4.554 8.994 4.847 19.125.822 28.423-1.535 3.544-5.498 14.844-8.808 25.11s-6.628 19.418-7.374 20.334c-.746.916-2.822 1.666-4.613 1.666s-4.328.573-5.637 1.273c-1.694.907-3.68.576-6.9-1.151zm606.57-95.638c-5.301-5.302-7.113-6.273-12.703-6.81-6.01-.578-6.644-.355-8.104 2.85-1.35 2.962-2.426 3.473-7.28 3.455-6.378-.022-8.139-.852-9.475-4.466-.82-2.216-1.864-2.386-9.57-1.56-9.422 1.009-10.492.13-5.316-4.37 4.618-4.016 4.3-12.24-.476-12.258-1.205-.005-3.99-1.201-6.19-2.658s-5.561-2.653-7.469-2.658c-1.907-.005-5.207-.56-7.333-1.232-2.126-.673-5.469-1.573-7.429-2-2.514-.547-3.987-2.052-5.005-5.11-.806-2.424-3.496-5.731-6.103-7.506-2.564-1.744-4.662-3.617-4.662-4.161 0-.545 3.026-1.391 6.724-1.882 5.788-.768 7.264-.466 10.594 2.162 2.127 1.68 3.901 4.054 3.942 5.278.28 8.457 6.887 8.82 15.53.852 5.86-5.402 6.208-5.531 10.305-3.847 2.331.96 6.939 2.63 10.239 3.714 3.3 1.084 9.3 3.349 13.333 5.033 4.033 1.685 9.48 3.742 12.105 4.571 3.369 1.065 5.329 2.774 6.667 5.814 1.042 2.368 3.607 5.118 5.7 6.11 3.205 1.522 3.688 2.397 3.06 5.54-.641 3.202.175 4.558 5.733 9.528 3.565 3.186 7.438 6.567 8.608 7.513 3.567 2.883 2.405 4.28-3.557 4.28-4.984 0-6.446-.76-11.867-6.182zm-203.12-4.7c-3.667-.655-11.767-1.757-18-2.448-7.653-.849-13.606-2.404-18.333-4.789-7.42-3.744-7.938-4.41-5.4-6.947 2.372-2.372 7.156-1.949 13.278 1.174 4.474 2.283 8.168 2.815 20.837 3 10.967.16 15.558.705 15.953 1.892.333 1-.69 1.71-2.556 1.772-1.988.068-2.39.371-1.111.841 3.207 1.18 6.666 4.643 5.89 5.899-.8 1.294-1.207 1.279-10.557-.393zm-60.919-27.012c-5.639-5.442-11.556-12.492-13.15-15.666-1.594-3.175-4.63-7.388-6.747-9.364-2.277-2.124-3.85-4.965-3.85-6.953 0-2.118-1.106-3.953-2.99-4.961-5.598-2.997-15.663-13.753-15.67-16.75 0-1.606.443-3.158.993-3.448 2.152-1.135 13.553 3.244 14.262 5.478 1.105 3.48 11.687 11.831 18.277 14.424 3.187 1.254 7.744 3.743 10.127 5.532 3.597 2.7 4.334 4.14 4.334 8.47 0 3.83.652 5.473 2.45 6.176 1.348.526 4.43 2.637 6.85 4.691 4.02 3.413 4.456 4.532 5.062 13l.662 9.266h-5.179c-4.63-.001-6.266-1.05-15.432-9.896zm100.01 5.106c.308-2.633-.226-6.255-1.185-8.047-1.381-2.58-1.414-4.171-.16-7.64.871-2.409 1.584-5.388 1.584-6.619 0-3.336 6.166-2.962 7.053.428.73 2.795 4.201 3.619 5.614 1.334 1.268-2.053 6-1.58 6 .6 0 1.064-.999 2.493-2.22 3.175-2.034 1.14-1.967 1.862.816 8.718 3.415 8.415 2.922 11.908-1.59 11.267-2.304-.327-3.5-1.985-5.116-7.094-1.16-3.666-2.66-6.523-3.333-6.348-.673.175-1.404 3.625-1.624 7.666-.36 6.613-.7 7.35-3.399 7.35-2.657 0-2.935-.547-2.44-4.79zm-32.916-6.329c-.88-1.06-5.301-2.31-9.926-2.806-4.586-.491-9.049-1.332-9.918-1.87-3.151-1.947-7.917-13.047-8.785-20.463l-.888-7.59 5.638-.41c4.468-.325 5.979-1.102 7.281-3.744 1.268-2.57 2.952-3.485 7.365-4 4.834-.563 6.004-1.309 7.547-4.812 1.18-2.677 3.873-5.139 7.605-6.952 3.179-1.544 6.776-4.329 7.994-6.188 2.706-4.13 4.14-4.19 11.116-.467 6.027 3.217 6.74 5.752 2.976 10.573-3.751 4.803-4.531 8.696-2.736 13.66 1.375 3.802 1.286 4.974-.578 7.635-1.212 1.73-2.203 4.43-2.203 6.001 0 1.572-1.27 4.473-2.824 6.448-1.554 1.975-3.54 6.406-4.414 9.847-1.576 6.202-1.641 6.259-7.626 6.653-4.021.265-6.566-.241-7.624-1.516zm63.259-56.549c-.554-.55-1.806-2.908-2.782-5.24-1.403-3.351-2.686-4.331-6.113-4.668-2.386-.234-4.55-1.072-4.808-1.862-.643-1.964 5.45-4.563 10.698-4.563 2.704 0 5.186-1.026 6.668-2.757 3.336-3.896 5.193-2.686 7.05 4.59 1.558 6.11 1.506 6.363-1.566 7.53-1.747.665-3.56 2.73-4.026 4.59-.83 3.308-3.117 4.371-5.121 2.38zm-264.8-8.445c-1.838-6.825-.6-13.222 2.557-13.222 2.557 0 8.14 8.857 8.14 12.915 0 3.412-2.529 5.752-6.216 5.752-2.4 0-3.314-1.111-4.481-5.445zm253.33-13.567c-2.47-2.652-3.622-10.22-1.828-12.014.442-.442 2.293-.238 4.112.454 4.539 1.726 6.453.225 3.656-2.866-2.014-2.226-2.036-2.595-.199-3.3 1.138-.437 3.77-.6 5.848-.361 3.6.412 3.76.718 3.362 6.432-.634 9.095-1.21 10.115-6.98 12.382-5.115 2.01-5.45 1.98-7.971-.727zm-11.093-26.49c-3.57-5.454-4.664-12.312-2.205-13.832.733-.453 1.333-3.488 1.333-6.745 0-4.786.455-5.922 2.37-5.922 6.673 0 10.731 8.042 6.297 12.476-1.335 1.335-2 4.669-2 10.017 0 4.41-.508 8.33-1.128 8.714s-2.72-1.735-4.667-4.707zm-1177.4-23.605c-1.114-1.802 2.627-4.532 5.462-3.986 3.736.72 2.873 4.37-1.143 4.835-1.948.225-3.891-.157-4.319-.849zm34.806-.56c-1.226-.917-2.39-3.167-2.588-5-.328-3.048.14-3.37 5.452-3.751 3.349-.24 7.67.465 10.202 1.667 2.415 1.146 5.1 2.083 5.967 2.083s1.329.75 1.026 1.667c-.331 1.004-3.553 1.825-8.11 2.066-4.16.22-7.562.97-7.562 1.667 0 1.744-1.73 1.586-4.386-.4zm-38.243-15.182c-2.546-1.807-4.946-3.718-5.333-4.246-1.331-1.816-8.168-4.24-11.958-4.24-3.204 0-5.413-1.95-5.413-4.776 0-.306 2.968-.557 6.596-.557 4.475 0 8.612 1.072 12.865 3.333 3.448 1.833 7.145 3.333 8.217 3.333 2.654 0 17.655 8.089 17.655 9.52 0 .63-4.05 1.096-9 1.033-7.31-.093-9.87-.731-13.63-3.4zm-36.038-8.28c0-.619 1.157-2.173 2.571-3.453 3.18-2.878 8.096-1.662 8.096 2.004 0 2.117-.951 2.576-5.334 2.576-2.933 0-5.333-.507-5.333-1.126zm1214.3-2.98c-3.314-1.93-2.893-7.734.809-11.165 1.728-1.602 3.43-3.77 3.783-4.82.545-1.622.973-1.634 2.858-.078 2.696 2.226 2.739 3.253.36 8.635-1.022 2.311-2.203 5.252-2.625 6.535-.873 2.653-1.87 2.825-5.185.893zm58.337-53.214c-.463-1.46-.417-3.343.103-4.183.533-.863-.438-2.57-2.228-3.921-3.766-2.84-3.441-3.29 3.112-4.3 8.258-1.275 11.196 3.613 6.722 11.186-2.64 4.47-6.484 5.076-7.708 1.218zm10.306-12.012c-.916-1.467-2.596-2.667-3.733-2.667-3.172 0-.92-2.487 4.181-4.619 2.517-1.051 4.576-2.542 4.576-3.313 0-.842 3.614-1.401 9.056-1.401 8.971 0 9.11-.056 14.944-6 3.238-3.3 6.513-6.003 7.277-6.007 3.41-.016 8.93-6.531 11.292-13.327 3.94-11.334 9.717-10.64 11.308 1.358.931 7.017-.635 11.975-3.782 11.975-2.273 0-3.429 2.933-3.429 8.7 0 5.806-3.943 8.633-12.038 8.633-4.424 0-7.357.92-10.629 3.334-5.478 4.042-7.765 4.199-9.088.624-.962-2.6-1.186-2.546-5.53 1.333-5.423 4.841-11.857 5.456-14.405 1.376zm47.691-52.513c0-1.89 1.305-4.035 3.214-5.286 1.768-1.159 3.915-4.228 4.77-6.82 1.203-3.646 2.278-4.714 4.74-4.714 1.818 0 3.794 1.143 4.61 2.666.945 1.766 2.791 2.667 5.467 2.667 5.3 0 9.199 2.176 9.199 5.135 0 1.62-2.321 3.336-7.301 5.4-6.357 2.635-7.92 2.822-12.084 1.448-4.026-1.329-5.155-1.241-7.137.553-3.36 3.04-5.478 2.635-5.478-1.05zm-1305.3-100.74c0-2.244.6-4.079 1.333-4.079s1.334 1.465 1.334 3.255-.6 3.625-1.334 4.078c-.778.481-1.333-.875-1.333-3.254zm0-13.812c0-2.474 2.792-4.934 5.6-4.934 3.007 0 3.242 4.725.29 5.858-3.43 1.316-5.89.93-5.89-.924zm-20-4.934c0-2.203.889-2.666 5.111-2.666 2.811 0 5.506.394 5.989.877 1.766 1.766-2.216 4.456-6.597 4.456-3.614 0-4.503-.526-4.503-2.667zm376.78-3.823c-.393-.636-3.559-1.477-7.035-1.869-3.476-.392-6.555-1.416-6.841-2.275-.287-.86-2.557-3.416-5.044-5.679-7.287-6.631-5.701-9.02 5.986-9.02 3.46 0 6.861.557 7.558 1.239.782.765 4.073.452 8.6-.818 8.336-2.338 32.884-2.454 35.638-.169.932.774 1.695 3.423 1.695 5.886 0 3.783-.569 4.614-3.666 5.357-2.017.483-5.467 1.795-7.667 2.914-7.95 4.045-27.62 7.03-29.224 4.434zm-916.78-9.526c-3.3-1.324-9.493-2.826-13.763-3.338-4.445-.532-8.05-1.68-8.436-2.685-.37-.965-1.567-2.097-2.658-2.516-1.51-.58-1.773-.096-1.101 2.02.702 2.212.38 2.684-1.58 2.31-2.115-.405-2.516-2.007-2.848-11.382l-.386-10.91 5.053.717c10.619 1.507 23.75 5.789 25.458 8.301 1.395 2.053 2.798 2.417 7.1 1.84 5.756-.772 19.425 1.928 20.769 4.102 1.042 1.687-4.49 6.223-7.589 6.223-1.547 0-2.626 1.37-3.152 4-.726 3.63-1.265 3.987-5.834 3.862-2.768-.076-7.733-1.221-11.033-2.545zm1324-25.317c0-2.134.889-2.667 4.444-2.667 2.445 0 4.84.395 5.322.877 1.649 1.649-2.086 4.456-5.93 4.456-2.947 0-3.836-.618-3.836-2.666zm35.333-8.602c-4.4-.92-9.665-2.353-11.701-3.183-4.127-1.683-6.416-5.732-3.743-6.623.936-.312 4.619-3.158 8.184-6.325 14.64-13 30.608-18.86 54.593-20.028 8.434-.41 19.035-1.683 23.56-2.828 8.89-2.25 17.045-1.567 18.232 1.527 1.259 3.28-2.664 4.892-14.71 6.048-16.73 1.604-27.015 4.156-48.353 11.996-6.199 2.277-12.049 4.787-13 5.576-2.822 2.342-1.995 5.358 2.496 9.108 7.67 6.403 1.46 8.292-15.558 4.732zm510.27-16.998c-2.796-2.796-1.952-5.362 1.4-4.259 1.65.543 5.05 1.336 7.557 1.761 2.507.426 4.807 1.522 5.111 2.436.74 2.217-11.858 2.272-14.068.062zm-1518.9-9.048c-5.226-1.462-13.532-2.476-20.921-2.555-6.74-.072-12.625-.73-13.079-1.464-.453-.733-2.889-1.333-5.412-1.333-3.033 0-4.588-.63-4.588-1.857 0-2.199 2.856-3.476 7.776-3.477 1.956 0 6.714-1.2 10.572-2.667 3.858-1.466 9.334-2.666 12.17-2.666s7.253-.876 9.816-1.947c5.217-2.18 6.332-1.68 6.332 2.836 0 3.275 1.99 3.939 5.334 1.778 1.333-.862 1.444-1.3.333-1.313-3.693-.045-1.326-4.14 3.949-6.831 4.82-2.46 7.108-2.763 16.151-2.143 12.808.878 15.072 2.502 9.826 7.046-3.128 2.71-5.15 3.241-12.333 3.241-6.75 0-8.593.43-8.593 2 0 1.251 1.264 2 3.376 2 1.856 0 3.72.9 4.142 2 1.389 3.619 7.587 2.385 10.087-2.008 2.751-4.835 7.429-5.28 12.911-1.226 2.058 1.521 6.234 3.1 9.28 3.509 7.026.942 7.252 3.773.538 6.728-7.728 3.4-45.93 3.632-57.667.349zm1500.3.39c-.917-.347-1.667-1.781-1.667-3.186 0-2.31 1.184-2.588 12.333-2.89 26.545-.717 37.441.634 33.6 4.165-1.35 1.242-41.459 2.973-44.267 1.91zm54.333-1.075c-1.437-1.732-.788-1.998 4.837-1.986 8.559.02 16.496 1.38 16.496 2.827 0 .637-4.427 1.159-9.837 1.159-7.117 0-10.296-.553-11.496-2zm-782.23-11.405c-4.525-2.114-8.61-4.462-9.079-5.22-.467-.756-2.654-1.375-4.86-1.375-6.49 0-9.166-2.154-9.166-7.38 0-2.746.676-4.667 1.666-4.736.917-.063 9.046-.018 18.064.101 13.928.184 18.592-.335 30.975-3.447 13.672-3.436 14.731-3.526 17.042-1.435 1.923 1.74 5.127 2.23 14.583 2.23 13.73 0 16.337.633 16.337 3.968 0 2.904-5.492 3.961-21.333 4.108-9.009.083-10.65.38-8 1.45 16.216 6.548 17.211 9.446 3.879 11.288-9.943 1.375-13.212.331-13.212-4.217 0-1.034-1.444-2.242-3.21-2.685-3.34-.839-8.79 1.277-8.79 3.412 0 1.801-11.136 8.029-14.117 7.895-1.402-.064-6.252-1.844-10.778-3.957zm-694.61-4.378c-1.372-.772-5.452-2.073-9.067-2.89-6.178-1.397-10.42-4.78-8.456-6.744.483-.483 4.662-1.163 9.286-1.512 14.092-1.06 35.463 6.01 30.892 10.22-1.877 1.73-19.916 2.466-22.655.925zm19.171-11.172c-2.037-.309-3.667-1.406-3.667-2.467 0-2.14 6.16-2.615 9.171-.707 1.757 1.113 1.003 4.345-.916 3.929-.507-.11-2.571-.45-4.588-.755zm877.67-.486c-10.907-1.184-20.205-3.924-20.176-5.945.029-2 5.275-3.004 16.446-3.148 5.649-.073 11.799-.83 13.667-1.68 2.563-1.168 4.22-1.172 6.759-.016 2.798 1.275 3.219 2.15 2.506 5.214-.966 4.16-4.032 7.102-7.124 6.838-1.143-.097-6.578-.666-12.078-1.263zm25-2.07c-3.161-.928-2.964-3.156.28-3.156 1.436 0 4.032-1.532 5.768-3.404 2.971-3.204 4.105-3.441 19.354-4.052 13.697-.549 16.729-.302 19.634 1.602 3.279 2.149 3.615 2.12 7.313-.614 4.17-3.083 7.978-3.61 11.669-1.613 1.273.69 4.004 1.61 6.068 2.047 2.935.622 3.662 1.438 3.333 3.748-.366 2.577-1.521 3.08-9.086 3.953-10.83 1.25-61.178 2.415-64.333 1.489z\" />"
    "</svg>";
// clang-format on
