/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioContext.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAudioContextOptions.h"
#include "JSAudioTimestamp.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

#if ENABLE(MEDIA_STREAM)
#include "JSMediaStream.h"
#include "JSMediaStreamAudioDestinationNode.h"
#include "JSMediaStreamAudioSourceNode.h"
#endif

#if ENABLE(VIDEO)
#include "JSHTMLMediaElement.h"
#include "JSMediaElementAudioSourceNode.h"
#endif

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsAudioContextPrototypeFunction_getOutputTimestamp);
static JSC_DECLARE_HOST_FUNCTION(jsAudioContextPrototypeFunction_suspend);
static JSC_DECLARE_HOST_FUNCTION(jsAudioContextPrototypeFunction_resume);
static JSC_DECLARE_HOST_FUNCTION(jsAudioContextPrototypeFunction_close);
#if ENABLE(VIDEO)
static JSC_DECLARE_HOST_FUNCTION(jsAudioContextPrototypeFunction_createMediaElementSource);
#endif
#if ENABLE(MEDIA_STREAM)
static JSC_DECLARE_HOST_FUNCTION(jsAudioContextPrototypeFunction_createMediaStreamSource);
#endif
#if ENABLE(MEDIA_STREAM)
static JSC_DECLARE_HOST_FUNCTION(jsAudioContextPrototypeFunction_createMediaStreamDestination);
#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAudioContextConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioContext_baseLatency);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioContext_outputLatency);

class JSAudioContextPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioContextPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioContextPrototype>(vm)) JSAudioContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioContextPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioContextPrototype, JSAudioContextPrototype::Base);

using JSAudioContextDOMConstructor = JSDOMConstructor<JSAudioContext>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSAudioContextDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSAudioContextDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    RefPtr context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "AudioContext"_s);
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto contextOptionsConversionResult = convert<IDLDictionary<AudioContextOptions>>(*lexicalGlobalObject, argument0.value());
    if (contextOptionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = AudioContext::create(document.get(), contextOptionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<AudioContext>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<AudioContext>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSAudioContextDOMConstructorConstruct, JSAudioContextDOMConstructor::construct);

template<> const ClassInfo JSAudioContextDOMConstructor::s_info = { "AudioContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioContextDOMConstructor) };

template<> JSValue JSAudioContextDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSBaseAudioContext::getConstructor(vm, &globalObject);
}

template<> void JSAudioContextDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioContext"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAudioContext::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 10> JSAudioContextPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioContextConstructor, 0 } },
    HashTableValue { "baseLatency"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioContext_baseLatency, 0 } },
    HashTableValue { "outputLatency"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioContext_outputLatency, 0 } },
    HashTableValue { "getOutputTimestamp"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioContextPrototypeFunction_getOutputTimestamp, 0 } },
    HashTableValue { "suspend"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioContextPrototypeFunction_suspend, 0 } },
    HashTableValue { "resume"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioContextPrototypeFunction_resume, 0 } },
    HashTableValue { "close"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioContextPrototypeFunction_close, 0 } },
#if ENABLE(VIDEO)
    HashTableValue { "createMediaElementSource"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioContextPrototypeFunction_createMediaElementSource, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STREAM)
    HashTableValue { "createMediaStreamSource"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioContextPrototypeFunction_createMediaStreamSource, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STREAM)
    HashTableValue { "createMediaStreamDestination"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioContextPrototypeFunction_createMediaStreamDestination, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
};

const ClassInfo JSAudioContextPrototype::s_info = { "AudioContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioContextPrototype) };

void JSAudioContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioContext::info(), JSAudioContextPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAudioContext::s_info = { "AudioContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioContext) };

JSAudioContext::JSAudioContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioContext>&& impl)
    : JSBaseAudioContext(structure, globalObject, WTFMove(impl))
{
}

Ref<AudioContext> JSAudioContext::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, AudioContext>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSAudioContext::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAudioContextPrototype::createStructure(vm, &globalObject, JSBaseAudioContext::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSAudioContextPrototype::create(vm, &globalObject, structure);
}

JSObject* JSAudioContext::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioContext>(vm, globalObject);
}

JSValue JSAudioContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioContextDOMConstructor, DOMConstructorID::AudioContext>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioContextConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioContextPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioContext::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsAudioContext_baseLatencyGetter(JSGlobalObject& lexicalGlobalObject, JSAudioContext& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.baseLatency())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioContext_baseLatency, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioContext>::get<jsAudioContext_baseLatencyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioContext_outputLatencyGetter(JSGlobalObject& lexicalGlobalObject, JSAudioContext& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.outputLatency())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioContext_outputLatency, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioContext>::get<jsAudioContext_outputLatencyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunction_getOutputTimestampBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<AudioTimestamp>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getOutputTimestamp())));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioContextPrototypeFunction_getOutputTimestamp, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunction_getOutputTimestampBody>(*lexicalGlobalObject, *callFrame, "getOutputTimestamp");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunction_suspendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSAudioContext>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.suspendRendering(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioContextPrototypeFunction_suspend, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSAudioContext>::call<jsAudioContextPrototypeFunction_suspendBody>(*lexicalGlobalObject, *callFrame, "suspend");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunction_resumeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSAudioContext>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.resumeRendering(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioContextPrototypeFunction_resume, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSAudioContext>::call<jsAudioContextPrototypeFunction_resumeBody>(*lexicalGlobalObject, *callFrame, "resume");
}

static inline JSC::EncodedJSValue jsAudioContextPrototypeFunction_closeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSAudioContext>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.close(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioContextPrototypeFunction_close, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSAudioContext>::call<jsAudioContextPrototypeFunction_closeBody>(*lexicalGlobalObject, *callFrame, "close");
}

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsAudioContextPrototypeFunction_createMediaElementSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mediaElementConversionResult = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "mediaElement"_s, "AudioContext"_s, "createMediaElementSource"_s, "HTMLMediaElement"_s); });
    if (mediaElementConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<MediaElementAudioSourceNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createMediaElementSource(*mediaElementConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioContextPrototypeFunction_createMediaElementSource, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunction_createMediaElementSourceBody>(*lexicalGlobalObject, *callFrame, "createMediaElementSource");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsAudioContextPrototypeFunction_createMediaStreamSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto mediaStreamConversionResult = convert<IDLInterface<MediaStream>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "mediaStream"_s, "AudioContext"_s, "createMediaStreamSource"_s, "MediaStream"_s); });
    if (mediaStreamConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<MediaStreamAudioSourceNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createMediaStreamSource(*mediaStreamConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioContextPrototypeFunction_createMediaStreamSource, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunction_createMediaStreamSourceBody>(*lexicalGlobalObject, *callFrame, "createMediaStreamSource");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsAudioContextPrototypeFunction_createMediaStreamDestinationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<MediaStreamAudioDestinationNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createMediaStreamDestination())));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioContextPrototypeFunction_createMediaStreamDestination, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioContext>::call<jsAudioContextPrototypeFunction_createMediaStreamDestinationBody>(*lexicalGlobalObject, *callFrame, "createMediaStreamDestination");
}

#endif

JSC::GCClient::IsoSubspace* JSAudioContext::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAudioContext, UseCustomHeapCellType::No>(vm, "JSAudioContext"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAudioContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAudioContext = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAudioContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAudioContext = std::forward<decltype(space)>(space); }
    );
}

void JSAudioContext::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioContext*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSAudioContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsAudioContext = jsCast<JSAudioContext*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsAudioContext->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAudioContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioContext = static_cast<JSAudioContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAudioContext->protectedWrapped().ptr(), jsAudioContext);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioContext@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12AudioContextE[]; }
#endif
template<std::same_as<AudioContext> T>
static inline void verifyVTable(AudioContext* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7AudioContext@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12AudioContextE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // AudioContext has subclasses. If AudioContext has subclasses that get passed
        // to toJS() we currently require AudioContext you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioContext>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<AudioContext>(impl.ptr());
#endif
    return createWrapper<AudioContext>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioContext& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

AudioContext* JSAudioContext::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioContext*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
