/*
 * plus60k.h - +60K EXPANSION HACK emulation.
 *
 * Written by
 *  Marco van den Heuvel <blackystardust68@yahoo.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef VICE_PLUS60K_H
#define VICE_PLUS60K_H

#include "types.h"

extern int plus60k_enabled;
extern int plus60k_base;

int plus60k_resources_init(void);
void plus60k_resources_shutdown(void);
int plus60k_cmdline_options_init(void);
void plus60k_init(void);
void plus60k_reset(void);
void plus60k_shutdown(void);

void plus60k_ram_inject(uint16_t addr, uint8_t value);
void plus60k_vicii_mem_vbank_store(uint16_t addr, uint8_t value);
void plus60k_vicii_mem_vbank_39xx_store(uint16_t addr, uint8_t value);
void plus60k_vicii_mem_vbank_3fxx_store(uint16_t addr, uint8_t value);
void plus60k_ram_hi_store(uint16_t addr, uint8_t value);
uint8_t plus60k_ram_read(uint16_t addr);
void plus60k_ram_store(uint16_t addr, uint8_t value);

int set_plus60k_enabled(int value, int disable_reset);

int plus60k_snapshot_write(struct snapshot_s *s);
int plus60k_snapshot_read(struct snapshot_s *s);

#endif
