const char utils_symtab_lua[] =
"-- Parser of LuaJIT's symtab binary stream.\n"
"-- The format spec can be found in <src/lj_memprof.h>.\n"
"--\n"
"-- Major portions taken verbatim or adapted from the LuaVela.\n"
"-- Copyright (C) 2015-2019 IPONWEB Ltd.\n"
"\n"
"local bit = require \"bit\"\n"
"\n"
"local avl = require \"utils.avl\"\n"
"\n"
"local band = bit.band\n"
"local string_format = string.format\n"
"\n"
"local LJS_MAGIC = \"ljs\"\n"
"local LJS_CURRENT_VERSION = 0x3\n"
"local LJS_EPILOGUE_HEADER = 0x80\n"
"local LJS_SYMTYPE_MASK = 0x03\n"
"\n"
"local SYMTAB_LFUNC = 0\n"
"local SYMTAB_CFUNC = 1\n"
"local SYMTAB_TRACE = 2\n"
"\n"
"local M = {}\n"
"\n"
"function M.loc(args)\n"
"  local loc = {\n"
"    addr = args.addr or 0,\n"
"    line = args.line or 0,\n"
"    traceno = args.traceno or 0,\n"
"  }\n"
"\n"
"  return loc\n"
"end\n"
"\n"
"-- Parse a single entry in a symtab: lfunc symbol.\n"
"function M.parse_sym_lfunc(reader, symtab)\n"
"  local sym_addr = reader:read_uleb128()\n"
"  local sym_chunk = reader:read_string()\n"
"  local sym_line = reader:read_uleb128()\n"
"\n"
"  symtab.lfunc[sym_addr] = symtab.lfunc[sym_addr] or {}\n"
"\n"
"  if sym_chunk:find('\\n') and not symtab.alias[sym_chunk] then\n"
"    table.insert(symtab.alias, sym_chunk)\n"
"    symtab.alias[sym_chunk] = string_format(\n"
"      \"function_alias_%d\", #symtab.alias\n"
"    )\n"
"  end\n"
"\n"
"  symtab.lfunc[sym_addr] = {\n"
"    source = sym_chunk,\n"
"    linedefined = sym_line,\n"
"  }\n"
"end\n"
"\n"
"function M.parse_sym_trace(reader, symtab)\n"
"  local traceno = reader:read_uleb128()\n"
"  local sym_addr = reader:read_uleb128()\n"
"  local sym_line = reader:read_uleb128()\n"
"\n"
"  symtab.trace[traceno] = symtab.trace[traceno] or {}\n"
"\n"
"  symtab.trace[traceno] = {\n"
"    start = M.loc({ addr = sym_addr, line = sym_line })\n"
"  }\n"
"end\n"
"\n"
"-- Parse a single entry in a symtab: .so library\n"
"function M.parse_sym_cfunc(reader, symtab)\n"
"  local addr = reader:read_uleb128()\n"
"  local name = reader:read_string()\n"
"\n"
"  symtab.cfunc = avl.insert(symtab.cfunc, addr, {\n"
"    name = name\n"
"  })\n"
"end\n"
"\n"
"local parsers = {\n"
"  [SYMTAB_LFUNC] = M.parse_sym_lfunc,\n"
"  [SYMTAB_TRACE] = M.parse_sym_trace,\n"
"  [SYMTAB_CFUNC] = M.parse_sym_cfunc,\n"
"}\n"
"\n"
"function M.parse(reader)\n"
"  local symtab = {\n"
"    lfunc = {},\n"
"    trace = {},\n"
"    alias = {},\n"
"    cfunc = nil,\n"
"  }\n"
"  local magic = reader:read_octets(3)\n"
"  local version = reader:read_octets(1)\n"
"\n"
"  -- Dummy-consume reserved bytes.\n"
"  local _ = reader:read_octets(3)\n"
"\n"
"  if magic ~= LJS_MAGIC then\n"
"    error(\"Bad LuaJIT symbol table format prologue: \" .. tostring(magic))\n"
"  end\n"
"\n"
"  if string.byte(version) ~= LJS_CURRENT_VERSION then\n"
"    error(string_format(\n"
"         \"LuaJIT symbol table format version mismatch: \"..\n"
"         \"the tool expects %d, but your data is %d\",\n"
"         LJS_CURRENT_VERSION,\n"
"         string.byte(version)\n"
"    ))\n"
"\n"
"  end\n"
"\n"
"  while not reader:eof() do\n"
"    local header = reader:read_octet()\n"
"    local is_final = band(header, LJS_EPILOGUE_HEADER) ~= 0\n"
"\n"
"    if is_final then\n"
"      break\n"
"    end\n"
"\n"
"    local sym_type = band(header, LJS_SYMTYPE_MASK)\n"
"    if parsers[sym_type] then\n"
"      parsers[sym_type](reader, symtab)\n"
"    end\n"
"  end\n"
"\n"
"  return symtab\n"
"end\n"
"\n"
"function M.id(loc)\n"
"  return string_format(\n"
"    \"f%#xl%dt%dg\", loc.addr, loc.line, loc.traceno\n"
"  )\n"
"end\n"
"\n"
"local function demangle_trace(symtab, loc)\n"
"  local traceno = loc.traceno\n"
"\n"
"  assert(traceno ~= 0, \"Location is a trace\")\n"
"\n"
"  local trace_str = string_format(\"TRACE [%d]\", traceno)\n"
"  local trace = symtab.trace[traceno]\n"
"\n"
"  if trace then\n"
"    assert(trace.start.traceno == 0, \"Trace start is not a trace\")\n"
"    return trace_str..\" started at \"..M.demangle(symtab, trace.start)\n"
"  end\n"
"  return trace_str\n"
"end\n"
"\n"
"function M.demangle(symtab, loc)\n"
"  if loc.traceno ~= 0 and loc.traceno ~= nil then\n"
"    return demangle_trace(symtab, loc)\n"
"  end\n"
"\n"
"  local addr = loc.addr\n"
"\n"
"  if addr == 0 then\n"
"    return \"INTERNAL\"\n"
"  end\n"
"\n"
"  if symtab.lfunc[addr] then\n"
"    local source = symtab.lfunc[addr].source\n"
"    return string_format(\"%s:%d\", symtab.alias[source] or source, loc.line)\n"
"  end\n"
"\n"
"  local key, value = avl.floor(symtab.cfunc, addr)\n"
"\n"
"  if key then\n"
"    return string_format(\"%s:%#x\", value.name, key)\n"
"  end\n"
"\n"
"  return string_format(\"CFUNC %#x\", addr)\n"
"end\n"
"\n"
"return M\n"
""
;
