const char fio_lua[] =
"-- fio.lua (internal file)\n"
"\n"
"local minifio = require('internal.minifio')\n"
"local fio = require('fio')\n"
"local ffi = require('ffi')\n"
"local buffer = require('buffer')\n"
"local fiber = require('fiber')\n"
"local errno = require('errno')\n"
"local schedule_task = fiber._internal.schedule_task\n"
"local cord_ibuf_take = buffer.internal.cord_ibuf_take\n"
"local cord_ibuf_put = buffer.internal.cord_ibuf_put\n"
"\n"
"ffi.cdef[[\n"
"    int umask(int mask);\n"
"    char *dirname(char *path);\n"
"    int chdir(const char *path);\n"
"\n"
"    struct fio_handle {\n"
"        int fh;\n"
"    };\n"
"]]\n"
"\n"
"local const_char_ptr_t = ffi.typeof('const char *')\n"
"\n"
"local internal = fio.internal\n"
"fio.internal = nil\n"
"\n"
"local function sprintf(fmt, ...)\n"
"    if select('#', ...) == 0 then\n"
"        return fmt\n"
"    end\n"
"    return string.format(fmt, ...)\n"
"end\n"
"\n"
"local fio_methods = {}\n"
"\n"
"-- read() -> str\n"
"-- read(buf) -> len\n"
"-- read(size) -> str\n"
"-- read(buf, size) -> len\n"
"fio_methods.read = function(self, buf, size)\n"
"    local tmpbuf\n"
"    if (not ffi.istype(const_char_ptr_t, buf) and buf == nil) or\n"
"        (ffi.istype(const_char_ptr_t, buf) and size == nil) then\n"
"        local st, err = self:stat()\n"
"        if st == nil then\n"
"            return nil, err\n"
"        end\n"
"        size = st.size\n"
"    end\n"
"    if not ffi.istype(const_char_ptr_t, buf) then\n"
"        size = buf or size\n"
"        tmpbuf = buffer.ibuf()\n"
"        buf = tmpbuf:reserve(size)\n"
"    end\n"
"    local res, err = internal.read(self.fh, buf, size)\n"
"    if res == nil then\n"
"        if tmpbuf ~= nil then\n"
"            tmpbuf:recycle()\n"
"        end\n"
"        return nil, err\n"
"    end\n"
"    if tmpbuf ~= nil then\n"
"        tmpbuf:alloc(res)\n"
"        res = ffi.string(tmpbuf.rpos, tmpbuf:size())\n"
"        tmpbuf:recycle()\n"
"    end\n"
"    return res\n"
"end\n"
"\n"
"-- write(str)\n"
"-- write(buf, len)\n"
"fio_methods.write = function(self, data, len)\n"
"    if not ffi.istype(const_char_ptr_t, data) then\n"
"        data = tostring(data)\n"
"        len = #data\n"
"    end\n"
"    local res, err = internal.write(self.fh, data, len)\n"
"    if err ~= nil then\n"
"        return false, err\n"
"    end\n"
"    return res >= 0\n"
"end\n"
"\n"
"-- pwrite(str, offset)\n"
"-- pwrite(buf, len, offset)\n"
"fio_methods.pwrite = function(self, data, len, offset)\n"
"    if not ffi.istype(const_char_ptr_t, data) then\n"
"        data = tostring(data)\n"
"        offset = len\n"
"        len = #data\n"
"    end\n"
"    local res, err = internal.pwrite(self.fh, data, len, offset)\n"
"    if err ~= nil then\n"
"        return false, err\n"
"    end\n"
"    return res >= 0\n"
"end\n"
"\n"
"-- pread(size, offset) -> str\n"
"-- pread(buf, size, offset) -> len\n"
"fio_methods.pread = function(self, buf, size, offset)\n"
"    local tmpbuf\n"
"    local has_buf = ffi.istype(const_char_ptr_t, buf)\n"
"    if not has_buf then\n"
"        offset = size\n"
"        size = buf\n"
"    end\n"
"    if type(size) ~= 'number' or (type(offset) ~= 'number' and offset ~= nil) then\n"
"        error('Usage: fh:pread(buf, size[, offset]) or fh:pread(size[, offset])')\n"
"    end\n"
"    if not has_buf then\n"
"        tmpbuf = buffer.ibuf()\n"
"        buf = tmpbuf:reserve(size)\n"
"    end\n"
"    local res, err = internal.pread(self.fh, buf, size, offset)\n"
"    if res == nil then\n"
"        if tmpbuf ~= nil then\n"
"            tmpbuf:recycle()\n"
"        end\n"
"        return nil, err\n"
"    end\n"
"    if tmpbuf ~= nil then\n"
"        tmpbuf:alloc(res)\n"
"        res = ffi.string(tmpbuf.rpos, tmpbuf:size())\n"
"        tmpbuf:recycle()\n"
"    end\n"
"    return res\n"
"end\n"
"\n"
"fio_methods.truncate = function(self, length)\n"
"    if length == nil then\n"
"        length = 0\n"
"    end\n"
"    return internal.ftruncate(self.fh, length)\n"
"end\n"
"\n"
"fio_methods.seek = function(self, offset, whence)\n"
"    if whence == nil then\n"
"        whence = 'SEEK_SET'\n"
"    end\n"
"    if type(whence) == 'string' then\n"
"        if fio.c.seek[whence] == nil then\n"
"            error(sprintf(\"fio.seek(): unknown whence: %s\", whence))\n"
"        end\n"
"        whence = fio.c.seek[whence]\n"
"    else\n"
"        whence = tonumber(whence)\n"
"    end\n"
"\n"
"    local res = internal.lseek(self.fh, tonumber(offset), whence)\n"
"    return tonumber(res)\n"
"end\n"
"\n"
"fio_methods.close = function(self)\n"
"    local res, err = internal.close(self.fh)\n"
"    if err ~= nil then\n"
"        return false, err\n"
"    end\n"
"    self.fh = -1\n"
"    return res\n"
"end\n"
"\n"
"fio_methods.fsync = function(self)\n"
"    return internal.fsync(self.fh)\n"
"end\n"
"\n"
"fio_methods.fdatasync = function(self)\n"
"    return internal.fdatasync(self.fh)\n"
"end\n"
"\n"
"fio_methods.stat = function(self)\n"
"    return internal.fstat(self.fh)\n"
"end\n"
"\n"
"fio_methods.__serialize = function(self)\n"
"    return {fh = self.fh}\n"
"end\n"
"\n"
"local fio_mt = {\n"
"    __index = fio_methods,\n"
"    __gc = function(obj)\n"
"        if obj.fh >= 0 then\n"
"            -- FFI GC can't yield. Internal.close() yields.\n"
"            -- Collect the garbage later, in a worker fiber.\n"
"            schedule_task(internal.close, obj.fh)\n"
"        end\n"
"    end,\n"
"}\n"
"\n"
"ffi.metatype('struct fio_handle', fio_mt)\n"
"\n"
"fio.open = function(path, flags, mode)\n"
"    local iflag = 0\n"
"    local imode = 0\n"
"    if type(path) ~= 'string' then\n"
"        error(\"Usage: fio.open(path[, flags[, mode]])\")\n"
"    end\n"
"    if type(flags) ~= 'table' then\n"
"        flags = { flags }\n"
"    end\n"
"    if type(mode) ~= 'table' then\n"
"        mode = { mode or (bit.band(0x1FF, fio.umask())) }\n"
"    end\n"
"\n"
"\n"
"    for _, flag in pairs(flags) do\n"
"        if type(flag) == 'number' then\n"
"            iflag = bit.bor(iflag, flag)\n"
"        else\n"
"            if fio.c.flag[ flag ] == nil then\n"
"                error(sprintf(\"fio.open(): unknown flag: %s\", flag))\n"
"            end\n"
"            iflag = bit.bor(iflag, fio.c.flag[ flag ])\n"
"        end\n"
"    end\n"
"\n"
"    for _, m in pairs(mode) do\n"
"        if type(m) == 'string' then\n"
"            if fio.c.mode[m] == nil then\n"
"                error(sprintf(\"fio.open(): unknown mode: %s\", m))\n"
"            end\n"
"            imode = bit.bor(imode, fio.c.mode[m])\n"
"        else\n"
"            imode = bit.bor(imode, tonumber(m))\n"
"        end\n"
"    end\n"
"\n"
"    local fh, err = internal.open(tostring(path), iflag, imode)\n"
"    if err ~= nil then\n"
"        return nil, err\n"
"    end\n"
"    local ok, res = pcall(ffi.new, 'struct fio_handle', fh)\n"
"    if not ok then\n"
"        internal.close(fh)\n"
"        -- This is OOM.\n"
"        return error(res)\n"
"    end\n"
"    return res\n"
"end\n"
"\n"
"-- Expose several functions implemented as part of the minifio\n"
"-- module.\n"
"for name, func in pairs(minifio.expose_from_fio) do\n"
"    fio[name] = func\n"
"end\n"
"\n"
"-- List of functions exposed from fio, but defined in minifio.\n"
"--\n"
"-- Without the list a reader should be aware of the fio/minifio\n"
"-- splitting in order to find an implementation of a function by\n"
"-- its name. Let's make a reader's life a bit easier.\n"
"assert(type(fio.cwd) == 'function')\n"
"assert(type(fio.pathjoin) == 'function')\n"
"assert(type(fio.abspath) == 'function')\n"
"\n"
"fio.basename = function(path, suffix)\n"
"    if type(path) ~= 'string' then\n"
"        error(\"Usage: fio.basename(path[, suffix])\")\n"
"    end\n"
"\n"
"    path = tostring(path)\n"
"    path = string.gsub(path, '.*/', '')\n"
"\n"
"    if suffix ~= nil then\n"
"        suffix = tostring(suffix)\n"
"        if #suffix > 0 then\n"
"            suffix = string.gsub(suffix, '(.)', '[%1]')\n"
"            path = string.gsub(path, suffix, '')\n"
"        end\n"
"    end\n"
"\n"
"    return path\n"
"end\n"
"\n"
"fio.dirname = function(path)\n"
"    if type(path) ~= 'string' then\n"
"        error(\"Usage: fio.dirname(path)\")\n"
"    end\n"
"    -- Can't just cast path to char * - on Linux dirname modifies\n"
"    -- its argument.\n"
"    local bsize = #path + 1\n"
"    local ibuf = cord_ibuf_take()\n"
"    local cpath = ibuf:alloc(bsize)\n"
"    ffi.copy(cpath, ffi.cast('const char *', path), bsize)\n"
"    path = ffi.string(ffi.C.dirname(cpath))\n"
"    cord_ibuf_put(ibuf)\n"
"    return path\n"
"end\n"
"\n"
"fio.umask = function(umask)\n"
"\n"
"    if umask == nil then\n"
"        local old = ffi.C.umask(0)\n"
"        ffi.C.umask(old)\n"
"        return old\n"
"    end\n"
"\n"
"    umask = tonumber(umask)\n"
"\n"
"    return ffi.C.umask(tonumber(umask))\n"
"\n"
"end\n"
"\n"
"fio.chdir = function(path)\n"
"    if type(path)~='string' then\n"
"        error(\"Usage: fio.chdir(path)\")\n"
"    end\n"
"    return ffi.C.chdir(path) == 0\n"
"end\n"
"\n"
"fio.listdir = function(path)\n"
"    if type(path) ~= 'string' then\n"
"        error(\"Usage: fio.listdir(path)\")\n"
"    end\n"
"    local str, err = internal.listdir(path)\n"
"    if err ~= nil then\n"
"        return nil, string.format(\"can't listdir %s: %s\", path, err)\n"
"    end\n"
"    local t = {}\n"
"    if str == \"\" then\n"
"        return t\n"
"    end\n"
"    local names = string.split(str, \"\\n\")\n"
"    for _, name in ipairs(names) do\n"
"        table.insert(t, name)\n"
"    end\n"
"    return t\n"
"end\n"
"\n"
"fio.mktree = function(path, mode)\n"
"    if type(path) ~= \"string\" then\n"
"        error(\"Usage: fio.mktree(path[, mode])\")\n"
"    end\n"
"    path = fio.abspath(path)\n"
"\n"
"    local path = string.gsub(path, '^/', '')\n"
"    local dirs = string.split(path, \"/\")\n"
"\n"
"    local current_dir = \"/\"\n"
"    for _, dir in ipairs(dirs) do\n"
"        current_dir = fio.pathjoin(current_dir, dir)\n"
"        local stat = fio.stat(current_dir)\n"
"        if stat == nil then\n"
"            local _, err = fio.mkdir(current_dir, mode)\n"
"            -- fio.stat() and fio.mkdir() above are separate calls\n"
"            -- and a file system may be changed between them. So\n"
"            -- if the error here is due to an existing directory,\n"
"            -- the function should not report an error.\n"
"            if err ~= nil and not fio.path.is_dir(current_dir) then\n"
"                return false, string.format(\"Error creating directory %s: %s\",\n"
"                    current_dir, tostring(err))\n"
"            end\n"
"        elseif not stat:is_dir() then\n"
"            return false, string.format(\"Error creating directory %s: %s\",\n"
"                current_dir, errno.strerror(errno.EEXIST))\n"
"        end\n"
"    end\n"
"    return true\n"
"end\n"
"\n"
"fio.rmtree = function(path)\n"
"    if type(path) ~= 'string' then\n"
"        error(\"Usage: fio.rmtree(path)\")\n"
"    end\n"
"    path = fio.abspath(path)\n"
"    local ls, err = fio.listdir(path)\n"
"    if err ~= nil then\n"
"        return nil, err\n"
"    end\n"
"    for _, f in ipairs(ls) do\n"
"        local tmppath = fio.pathjoin(path, f)\n"
"        local st = fio.lstat(tmppath)\n"
"        if st then\n"
"            if st:is_dir() then\n"
"                _, err = fio.rmtree(tmppath)\n"
"            else\n"
"                _, err = fio.unlink(tmppath)\n"
"            end\n"
"            if err ~= nil  then\n"
"                return nil, err\n"
"            end\n"
"        end\n"
"    end\n"
"    local _, err = fio.rmdir(path)\n"
"    if err ~= nil then\n"
"        return false, string.format(\"failed to remove %s: %s\", path, err)\n"
"    end\n"
"    return true\n"
"end\n"
"\n"
"fio.copyfile = function(from, to)\n"
"    if type(from) ~= 'string' or type(to) ~= 'string' then\n"
"        error('Usage: fio.copyfile(from, to)')\n"
"    end\n"
"    local st = fio.stat(to)\n"
"    if st and st:is_dir() then\n"
"        to = fio.pathjoin(to, fio.basename(from))\n"
"    end\n"
"    local _, err = internal.copyfile(from, to)\n"
"    if err ~= nil then\n"
"        return false, string.format(\"failed to copy %s to %s: %s\", from, to, err)\n"
"    end\n"
"    return true\n"
"end\n"
"\n"
"fio.copytree = function(from, to)\n"
"    if type(from) ~= 'string' or type(to) ~= 'string' then\n"
"        error('Usage: fio.copytree(from, to)')\n"
"    end\n"
"    local st = fio.stat(from)\n"
"    if not st then\n"
"        return false, string.format(\"Directory %s does not exist\", from)\n"
"    end\n"
"    if not st:is_dir() then\n"
"        return false, errno.strerror(errno.ENOTDIR)\n"
"    end\n"
"    local ls, err = fio.listdir(from)\n"
"    if err ~= nil then\n"
"        return false, err\n"
"    end\n"
"\n"
"    -- create tree of destination\n"
"    local _, reason = fio.mktree(to)\n"
"    if reason ~= nil then\n"
"        return false, reason\n"
"    end\n"
"    for _, f in ipairs(ls) do\n"
"        local ffrom = fio.pathjoin(from, f)\n"
"        local fto = fio.pathjoin(to, f)\n"
"        local st = fio.lstat(ffrom)\n"
"        if st and st:is_dir() then\n"
"            _, reason = fio.copytree(ffrom, fto)\n"
"            if reason ~= nil then\n"
"                return false, reason\n"
"            end\n"
"        end\n"
"        if st:is_reg() then\n"
"            _, reason = fio.copyfile(ffrom, fto)\n"
"            if reason ~= nil then\n"
"                return false, reason\n"
"            end\n"
"        end\n"
"        if st:is_link() then\n"
"            local link_to, reason = fio.readlink(ffrom)\n"
"            if reason ~= nil then\n"
"                return false, reason\n"
"            end\n"
"            _, reason = fio.symlink(link_to, fto)\n"
"            if reason ~= nil then\n"
"                return false, \"can't create symlink in place of existing file \"..fto\n"
"            end\n"
"        end\n"
"    end\n"
"    return true\n"
"end\n"
"\n"
"local function check_time(time, name)\n"
"    if time ~= nil and type(time) ~= 'number' then\n"
"        error('fio.utime: ' .. name .. ' should be a number', 2)\n"
"    end\n"
"end\n"
"\n"
"fio.utime = function(path, atime, mtime)\n"
"    if type(path) ~= 'string' then\n"
"        error('Usage: fio.utime(filepath[, atime[, mtime]])')\n"
"    end\n"
"\n"
"    check_time(atime, 'atime')\n"
"    check_time(mtime, 'mtime')\n"
"\n"
"    local current_time = fiber.time()\n"
"    atime = atime or current_time\n"
"    mtime = mtime or atime\n"
"\n"
"    return internal.utime(path, atime, mtime)\n"
"end\n"
"\n"
"fio.path = {}\n"
"fio.path.is_file = function(filename)\n"
"    local fs = fio.stat(filename)\n"
"    return fs ~= nil and fs:is_reg() or false\n"
"end\n"
"\n"
"fio.path.is_link = function(filename)\n"
"    local fs = fio.lstat(filename)\n"
"    return fs ~= nil and fs:is_link() or false\n"
"end\n"
"\n"
"fio.path.is_dir = function(filename)\n"
"    local fs = fio.stat(filename)\n"
"    return fs ~= nil and fs:is_dir() or false\n"
"end\n"
"\n"
"fio.path.exists = function(filename)\n"
"    return fio.stat(filename) ~= nil\n"
"end\n"
"\n"
"fio.path.lexists = function(filename)\n"
"    return fio.lstat(filename) ~= nil\n"
"end\n"
"\n"
"return fio\n"
""
;
