const char schema_lua[] =
"-- schema.lua (internal file)\n"
"--\n"
"local ffi = require('ffi')\n"
"local msgpack = require('msgpack')\n"
"local fun = require('fun')\n"
"local log = require('log')\n"
"local buffer = require('buffer')\n"
"local fiber = require('fiber')\n"
"local session = box.session\n"
"local internal = box.internal\n"
"local utf8 = require('utf8')\n"
"local utils = require('internal.utils')\n"
"\n"
"local check_param = utils.check_param\n"
"local check_param_table = utils.check_param_table\n"
"local update_param_table = utils.update_param_table\n"
"\n"
"local function setmap(table)\n"
"    return setmetatable(table, { __serialize = 'map' })\n"
"end\n"
"\n"
"local builtin = ffi.C\n"
"\n"
"-- performance fixup for hot functions\n"
"local tuple_encode = box.internal.tuple.encode\n"
"local tuple_bless = box.internal.tuple.bless\n"
"local is_tuple = box.tuple.is\n"
"assert(tuple_encode ~= nil and tuple_bless ~= nil and is_tuple ~= nil)\n"
"local cord_ibuf_take = buffer.internal.cord_ibuf_take\n"
"local cord_ibuf_put = buffer.internal.cord_ibuf_put\n"
"\n"
"local INT64_MIN = tonumber64('-9223372036854775808')\n"
"local INT64_MAX = tonumber64('9223372036854775807')\n"
"\n"
"ffi.cdef[[\n"
"    extern bool box_read_ffi_is_disabled;\n"
"    struct space *space_by_id(uint32_t id);\n"
"    void space_run_triggers(struct space *space, bool yesno);\n"
"    size_t space_bsize(struct space *space);\n"
"\n"
"    typedef struct tuple box_tuple_t;\n"
"    typedef struct iterator box_iterator_t;\n"
"\n"
"    box_iterator_t *\n"
"    box_index_iterator_after(uint32_t space_id, uint32_t index_id, int type,\n"
"                             const char *key, const char *key_end,\n"
"                             const char *packed_pos,\n"
"                             const char *packed_pos_end);\n"
"    int\n"
"    box_iterator_next(box_iterator_t *itr, box_tuple_t **result);\n"
"    void\n"
"    box_iterator_free(box_iterator_t *itr);\n"
"    ssize_t\n"
"    box_index_len(uint32_t space_id, uint32_t index_id);\n"
"    ssize_t\n"
"    box_index_bsize(uint32_t space_id, uint32_t index_id);\n"
"    int\n"
"    box_index_random(uint32_t space_id, uint32_t index_id, uint32_t rnd,\n"
"                     box_tuple_t **result);\n"
"    int\n"
"    box_index_get(uint32_t space_id, uint32_t index_id, const char *key,\n"
"                  const char *key_end, box_tuple_t **result);\n"
"    int\n"
"    box_index_min(uint32_t space_id, uint32_t index_id, const char *key,\n"
"                  const char *key_end, box_tuple_t **result);\n"
"    int\n"
"    box_index_max(uint32_t space_id, uint32_t index_id, const char *key,\n"
"                  const char *key_end, box_tuple_t **result);\n"
"    ssize_t\n"
"    box_index_count(uint32_t space_id, uint32_t index_id, int type,\n"
"                    const char *key, const char *key_end);\n"
"    size_t\n"
"    box_region_used(void);\n"
"    void\n"
"    box_region_truncate(size_t size);\n"
"    bool\n"
"    box_txn();\n"
"    int64_t\n"
"    box_txn_id();\n"
"    int\n"
"    box_txn_isolation();\n"
"    int\n"
"    box_txn_begin();\n"
"    int\n"
"    box_txn_set_timeout(double timeout);\n"
"    void\n"
"    memtx_tx_story_gc_step();\n"
"    int\n"
"    box_sequence_current(uint32_t seq_id, int64_t *result);\n"
"    typedef struct txn_savepoint box_txn_savepoint_t;\n"
"\n"
"    box_txn_savepoint_t *\n"
"    box_txn_savepoint();\n"
"\n"
"    struct port {\n"
"        const struct port_vtab *vtab;\n"
"        char pad[68];\n"
"    };\n"
"\n"
"    struct port_c_entry {\n"
"        struct port_c_entry *next;\n"
"        union {\n"
"            struct tuple *tuple;\n"
"            char *mp;\n"
"        };\n"
"        uint32_t mp_size;\n"
"        struct tuple_format *mp_format;\n"
"    };\n"
"\n"
"    struct port_c {\n"
"        const struct port_vtab *vtab;\n"
"        struct port_c_entry *first;\n"
"        struct port_c_entry *last;\n"
"        struct port_c_entry first_entry;\n"
"        int size;\n"
"    };\n"
"\n"
"    void\n"
"    port_destroy(struct port *port);\n"
"\n"
"    int\n"
"    box_index_tuple_position(uint32_t space_id, uint32_t index_id,\n"
"                             const char *tuple, const char *tuple_end,\n"
"                             const char **pos, const char **pos_end);\n"
"\n"
"    int\n"
"    box_select_ffi(uint32_t space_id, uint32_t index_id, const char *key,\n"
"                   const char *key_end, const char **packed_pos,\n"
"                   const char **packed_pos_end, bool update_pos,\n"
"                   struct port *port, int64_t iterator, uint64_t offset,\n"
"                   uint64_t limit);\n"
"\n"
"    enum priv_type {\n"
"        PRIV_R = 1,\n"
"        PRIV_W = 2,\n"
"        PRIV_X = 4,\n"
"        PRIV_S = 8,\n"
"        PRIV_U = 16,\n"
"        PRIV_C = 32,\n"
"        PRIV_D = 64,\n"
"        PRIV_A = 128,\n"
"        PRIV_REFERENCE = 256,\n"
"        PRIV_TRIGGER = 512,\n"
"        PRIV_INSERT = 1024,\n"
"        PRIV_UPDATE = 2048,\n"
"        PRIV_DELETE = 4096,\n"
"        PRIV_GRANT = 8192,\n"
"        PRIV_REVOKE = 16384,\n"
"        PRIV_ALL  = 4294967295\n"
"    };\n"
"\n"
"]]\n"
"\n"
"box.priv = {\n"
"    [\"R\"] = builtin.PRIV_R,\n"
"    [\"W\"] = builtin.PRIV_W,\n"
"    [\"X\"] = builtin.PRIV_X,\n"
"    [\"S\"] = builtin.PRIV_S,\n"
"    [\"U\"] = builtin.PRIV_U,\n"
"    [\"C\"] = builtin.PRIV_C,\n"
"    [\"D\"] = builtin.PRIV_D,\n"
"    [\"A\"] = builtin.PRIV_A,\n"
"    [\"REFERENCE\"] = builtin.PRIV_REFERENCE,\n"
"    [\"TRIGGER\"] = builtin.PRIV_TRIGGER,\n"
"    [\"INSERT\"] = builtin.PRIV_INSERT,\n"
"    [\"UPDATE\"] = builtin.PRIV_UPDATE,\n"
"    [\"DELETE\"] = builtin.PRIV_DELETE,\n"
"    [\"GRANT\"]= builtin.PRIV_GRANT,\n"
"    [\"REVOKE\"] = builtin.PRIV_REVOKE,\n"
"    [\"ALL\"] = builtin.PRIV_ALL\n"
"}\n"
"\n"
"local function user_or_role_resolve(user)\n"
"    local _vuser = box.space[box.schema.VUSER_ID]\n"
"    local tuple\n"
"    if type(user) == 'string' then\n"
"        tuple = _vuser.index.name:get{user}\n"
"    else\n"
"        tuple = _vuser:get{user}\n"
"    end\n"
"    if tuple == nil then\n"
"        return nil\n"
"    end\n"
"    return tuple.id\n"
"end\n"
"\n"
"local function role_resolve(name_or_id)\n"
"    local _vuser = box.space[box.schema.VUSER_ID]\n"
"    local tuple\n"
"    if type(name_or_id) == 'string' then\n"
"        tuple = _vuser.index.name:get{name_or_id}\n"
"    elseif type(name_or_id) ~= 'nil' then\n"
"        tuple = _vuser:get{name_or_id}\n"
"    end\n"
"    if tuple == nil or tuple.type ~= 'role' then\n"
"        return nil\n"
"    else\n"
"        return tuple.id\n"
"    end\n"
"end\n"
"\n"
"local function user_resolve(name_or_id)\n"
"    local _vuser = box.space[box.schema.VUSER_ID]\n"
"    local tuple\n"
"    if type(name_or_id) == 'string' then\n"
"        tuple = _vuser.index.name:get{name_or_id}\n"
"    elseif type(name_or_id) ~= 'nil' then\n"
"        tuple = _vuser:get{name_or_id}\n"
"    end\n"
"    if tuple == nil or tuple.type ~= 'user' then\n"
"        return nil\n"
"    else\n"
"        return tuple.id\n"
"    end\n"
"end\n"
"\n"
"local function sequence_resolve(name_or_id)\n"
"    local _vsequence = box.space[box.schema.VSEQUENCE_ID]\n"
"    local tuple\n"
"    if type(name_or_id) == 'string' then\n"
"        tuple = _vsequence.index.name:get{name_or_id}\n"
"    elseif type(name_or_id) ~= 'nil' then\n"
"        tuple = _vsequence:get{name_or_id}\n"
"    end\n"
"    if tuple ~= nil then\n"
"        return tuple.id, tuple\n"
"    else\n"
"        return nil\n"
"    end\n"
"end\n"
"\n"
"-- Revoke all privileges associated with the given object.\n"
"local function revoke_object_privs(object_type, object_id)\n"
"    local _vpriv = box.space[box.schema.VPRIV_ID]\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    local privs = _vpriv.index.object:select{object_type, object_id}\n"
"    for _, tuple in pairs(privs) do\n"
"        local uid = tuple.grantee\n"
"        _priv:delete{uid, object_type, object_id}\n"
"    end\n"
"end\n"
"\n"
"local function feedback_save_event(event)\n"
"    if internal.feedback_daemon ~= nil then\n"
"        internal.feedback_daemon.save_event(event)\n"
"    end\n"
"end\n"
"\n"
"-- Public isolation level map string -> number.\n"
"box.txn_isolation_level = {\n"
"    ['default'] = 0,\n"
"    ['DEFAULT'] = 0,\n"
"    ['read-committed'] = 1,\n"
"    ['READ_COMMITTED'] = 1,\n"
"    ['read-confirmed'] = 2,\n"
"    ['READ_CONFIRMED'] = 2,\n"
"    ['best-effort'] = 3,\n"
"    ['BEST_EFFORT'] = 3,\n"
"    ['linearizable'] = 4,\n"
"    ['LINEARIZABLE'] = 4,\n"
"}\n"
"\n"
"-- Create private isolation level map anything-correct -> number.\n"
"local function create_txn_isolation_level_map()\n"
"    local res = {}\n"
"    for k,v in pairs(box.txn_isolation_level) do\n"
"        res[k] = v\n"
"        res[v] = v\n"
"    end\n"
"    return res\n"
"end\n"
"\n"
"-- Private isolation level map anything-correct -> number.\n"
"local txn_isolation_level_map = create_txn_isolation_level_map()\n"
"box.internal.txn_isolation_level_map = txn_isolation_level_map\n"
"\n"
"-- Convert to numeric the value of txn isolation level, raise if failed.\n"
"local function normalize_txn_isolation_level(txn_isolation)\n"
"    txn_isolation = txn_isolation_level_map[txn_isolation]\n"
"    if txn_isolation == nil then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"                  \"txn_isolation must be one of box.txn_isolation_level\" ..\n"
"                  \" (keys or values)\")\n"
"    end\n"
"    return txn_isolation\n"
"end\n"
"\n"
"box.internal.normalize_txn_isolation_level = normalize_txn_isolation_level\n"
"\n"
"local begin_options = {\n"
"    timeout = function(timeout)\n"
"        if type(timeout) ~= \"number\" or timeout <= 0 then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      \"timeout must be a number greater than 0\")\n"
"        end\n"
"        return true\n"
"    end,\n"
"    txn_isolation = normalize_txn_isolation_level,\n"
"}\n"
"\n"
"box.begin = function(options)\n"
"    local timeout\n"
"    local txn_isolation\n"
"    if options then\n"
"        check_param_table(options, begin_options)\n"
"        timeout = options.timeout\n"
"        txn_isolation = options.txn_isolation and\n"
"                        normalize_txn_isolation_level(options.txn_isolation)\n"
"    end\n"
"    if builtin.box_txn_begin() == -1 then\n"
"        box.error()\n"
"    end\n"
"    if timeout then\n"
"        assert(builtin.box_txn_set_timeout(timeout) == 0)\n"
"    end\n"
"    if txn_isolation and\n"
"       internal.txn_set_isolation(txn_isolation) ~= 0 then\n"
"        box.rollback()\n"
"        box.error()\n"
"    end\n"
"end\n"
"\n"
"box.is_in_txn = builtin.box_txn\n"
"\n"
"box.internal.memtx_tx_gc = function(step_num)\n"
"    if type(step_num) ~= 'number' or step_num < 1 then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"                  \"step_num must be a number not less than 1\")\n"
"    end\n"
"    for _ = 1, step_num do\n"
"        builtin.memtx_tx_story_gc_step()\n"
"    end\n"
"end\n"
"\n"
"box.txn_id = function()\n"
"    local id = builtin.box_txn_id()\n"
"    if -1 == id then\n"
"        return nil\n"
"    end\n"
"    return tonumber(id)\n"
"end\n"
"\n"
"box.internal.txn_isolation = function()\n"
"    local lvl = builtin.box_txn_isolation()\n"
"    return lvl ~= -1 and lvl or nil\n"
"end\n"
"\n"
"box.savepoint = function()\n"
"    local csavepoint = builtin.box_txn_savepoint()\n"
"    if csavepoint == nil then\n"
"        box.error()\n"
"    end\n"
"    return { csavepoint=csavepoint, txn_id=builtin.box_txn_id() }\n"
"end\n"
"\n"
"local function atomic_tail(status, ...)\n"
"    if not status then\n"
"        box.rollback()\n"
"        error((...), 2)\n"
"     end\n"
"     box.commit()\n"
"     return ...\n"
"end\n"
"\n"
"box.atomic = function(arg0, arg1, ...)\n"
"    -- There are two cases:\n"
"    -- 1. arg0 is a function (callable in general) while arg1,... are arguments.\n"
"    -- 2. arg0 is an options table, arg1 - a function and ... are arguments.\n"
"    -- The simplest way to distinguish that cases (without any other checks\n"
"    -- for correctness) is to check that arg0 is not a callable table.\n"
"    local arg0_is_noncallable_table = false\n"
"    if type(arg0) == 'table' then\n"
"        local mt = debug.getmetatable(arg0)\n"
"        arg0_is_noncallable_table = mt == nil or mt.__call == nil\n"
"    end\n"
"    if arg0_is_noncallable_table then\n"
"        box.begin(arg0)\n"
"        return atomic_tail(pcall(arg1, ...))\n"
"    else\n"
"        box.begin()\n"
"        return atomic_tail(pcall(arg0, arg1, ...))\n"
"    end\n"
"end\n"
"\n"
"-- box.commit yields, so it's defined as Lua/C binding\n"
"-- box.rollback and box.rollback_to_savepoint yields as well\n"
"\n"
"-- Check and normalize constraint definition.\n"
"-- Given constraint @a constr is expected to be either a func name or\n"
"--  a table with function names and/or consraint name:function name pairs.\n"
"-- In case of error box.error.ILLEGAL_PARAMS is raised, and @a error_prefix\n"
"--  is added before string message.\n"
"local function normalize_constraint(constr, error_prefix)\n"
"    if type(constr) == 'string' then\n"
"        -- Short form of field constraint - just name of func,\n"
"        -- e.g.: {...constraint = \"func_name\"}\n"
"        local found = box.space._func.index.name:get(constr)\n"
"        if not found then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      error_prefix .. \"constraint function \" ..\n"
"                      \"was not found by name '\" .. constr .. \"'\")\n"
"        end\n"
"        -- normalize form of constraint.\n"
"        return {[constr] = found.id}\n"
"    elseif type(constr) == 'table' then\n"
"        -- Long form of field constraint - a table with:\n"
"        -- 1) func names 2) constraint name -> func name pairs.\n"
"        -- e.g.: {..., constraint = {func1, name2 = func2, ...}}\n"
"        local result = {}\n"
"        for constr_key, constr_func in pairs(constr) do\n"
"            if type(constr_func) ~= 'string' then\n"
"                box.error(box.error.ILLEGAL_PARAMS,\n"
"                          error_prefix .. \"constraint function \" ..\n"
"                          \"is expected to be a string, \" ..\n"
"                          \"but got \" .. type(constr_func))\n"
"            end\n"
"            local found = box.space._func.index.name:get(constr_func)\n"
"            if not found then\n"
"                box.error(box.error.ILLEGAL_PARAMS,\n"
"                          error_prefix .. \"constraint function \" ..\n"
"                          \"was not found by name '\" .. constr_func .. \"'\")\n"
"            end\n"
"            local constr_name = nil\n"
"            if type(constr_key) == 'number' then\n"
"                -- 1) func name only.\n"
"                constr_name = constr_func\n"
"            elseif type(constr_key) == 'string' then\n"
"                -- 2) constraint name + func name pair.\n"
"                constr_name = constr_key\n"
"            else\n"
"                -- what are you\?\n"
"                box.error(box.error.ILLEGAL_PARAMS,\n"
"                          error_prefix .. \"constraint name \" ..\n"
"                          \"is expected to be a string, \" ..\n"
"                          \"but got \" .. type(constr_key))\n"
"            end\n"
"            -- normalize form of constraint pair.\n"
"            result[constr_name] = found.id\n"
"        end\n"
"        -- return normalized form of constraints.\n"
"        return result\n"
"    elseif constr then\n"
"        -- unrecognized form of constraint.\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"                  error_prefix .. \"constraint must be string or table\")\n"
"    end\n"
"    return nil\n"
"end\n"
"\n"
"-- Helper of normalize_foreign_key.\n"
"-- Check and normalize one foreign key definition.\n"
"-- If not is_complex, field is expected to be a numeric ID or string name of\n"
"--  foreign field.\n"
"-- If is_complex, field is expected to be a table with local field ->\n"
"--  foreign field mapping.\n"
"-- If fkey_same_space, the foreign key refers to the same space.\n"
"local function normalize_foreign_key_one(def, error_prefix, is_complex,\n"
"                                         fkey_same_space)\n"
"    if def.field == nil then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"                  error_prefix .. \"foreign key: field must be specified\")\n"
"    end\n"
"    if def.space ~= nil and\n"
"       type(def.space) ~= 'string' and type(def.space) ~= 'number' then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"                  error_prefix .. \"foreign key: space must be string or number\")\n"
"    end\n"
"    local field = def.field\n"
"    if not is_complex then\n"
"        if type(field) ~= 'string' and type(field) ~= 'number' then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      error_prefix .. \"foreign key: field must be string or number\")\n"
"        end\n"
"        if type(field) == 'number' then\n"
"            -- convert to zero-based index.\n"
"            field = field - 1\n"
"        end\n"
"    else\n"
"        if type(field) ~= 'table' then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      error_prefix .. \"foreign key: field must be a table \" ..\n"
"                      \"with local field -> foreign field mapping\")\n"
"        end\n"
"        local count = 0\n"
"        local converted = {}\n"
"        for k,v in pairs(field) do\n"
"            count = count + 1\n"
"            if type(k) ~= 'string' and type(k) ~= 'number' then\n"
"                box.error(box.error.ILLEGAL_PARAMS,\n"
"                          error_prefix .. \"foreign key: local field must be \"\n"
"                          .. \"string or number\")\n"
"            end\n"
"            if type(k) == 'number' then\n"
"                -- convert to zero-based index.\n"
"                k = k - 1\n"
"            end\n"
"            if type(v) ~= 'string' and type(v) ~= 'number' then\n"
"                box.error(box.error.ILLEGAL_PARAMS,\n"
"                          error_prefix .. \"foreign key: foreign field must be \"\n"
"                          .. \"string or number\")\n"
"            end\n"
"            if type(v) == 'number' then\n"
"                -- convert to zero-based index.\n"
"                v = v - 1\n"
"            end\n"
"            converted[k] = v\n"
"        end\n"
"        if count < 1 then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      error_prefix .. \"foreign key: field must be a table \" ..\n"
"                      \"with local field -> foreign field mapping\")\n"
"        end\n"
"        field = setmap(converted)\n"
"    end\n"
"    if not box.space[def.space] and not fkey_same_space then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"                  error_prefix .. \"foreign key: space \" .. tostring(def.space)\n"
"                  .. \" was not found\")\n"
"    end\n"
"    for k in pairs(def) do\n"
"        if k ~= 'space' and k ~= 'field' then\n"
"            box.error(box.error.ILLEGAL_PARAMS, error_prefix ..\n"
"                      \"foreign key: unexpected parameter '\" ..\n"
"                      tostring(k) .. \"'\")\n"
"        end\n"
"    end\n"
"    if fkey_same_space then\n"
"        return {field = field}\n"
"    else\n"
"        return {space = box.space[def.space].id, field = field}\n"
"    end\n"
"end\n"
"\n"
"-- Check and normalize foreign key definition.\n"
"-- Given definition @a fkey is expected to be one of:\n"
"-- {space=.., field=..}\n"
"-- {fkey_name={space=.., field=..}, }\n"
"-- If not is_complex, field is expected to be a numeric ID or string name of\n"
"--  foreign field.\n"
"-- If is_complex, field is expected to be a table with local field ->\n"
"--  foreign field mapping.\n"
"-- @a space_id and @a space_name - ID and name of a space, which contains the\n"
"--  foreign key.\n"
"-- In case of error box.error.ILLEGAL_PARAMS is raised, and @a error_prefix\n"
"--  is added before string message.\n"
"local function normalize_foreign_key(space_id, space_name, fkey, error_prefix,\n"
"                                     is_complex)\n"
"    if fkey == nil then\n"
"        return nil\n"
"    end\n"
"    if type(fkey) ~= 'table' then\n"
"        -- unrecognized form\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"                  error_prefix .. \"foreign key must be a table\")\n"
"    end\n"
"    if fkey.field ~= nil and\n"
"        (type(fkey.space) ~= 'table' or type(fkey.field) ~= 'table') then\n"
"        -- the first, short form.\n"
"        local fkey_same_space = (fkey.space == nil or\n"
"                                 fkey.space == space_id or\n"
"                                 fkey.space == space_name)\n"
"        fkey = normalize_foreign_key_one(fkey, error_prefix, is_complex,\n"
"                                         fkey_same_space)\n"
"        local fkey_name = fkey_same_space and space_name or\n"
"                          box.space[fkey.space].name\n"
"        return {[fkey_name] = fkey}\n"
"    end\n"
"    -- the second, detailed form.\n"
"    local result = {}\n"
"    for k,v in pairs(fkey) do\n"
"        if type(k) ~= 'string' then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      error_prefix .. \"foreign key name must be a string\")\n"
"        end\n"
"        if type(v) ~= 'table' then\n"
"            -- unrecognized form\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      error_prefix .. \"foreign key definition must be a table \"\n"
"                      .. \"with 'space' and 'field' members\")\n"
"        end\n"
"        local fkey_same_space = (v.space == nil or\n"
"                                 v.space == space_id or\n"
"                                 v.space == space_name)\n"
"        v = normalize_foreign_key_one(v, error_prefix, is_complex,\n"
"                                      fkey_same_space)\n"
"        result[k] = v\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"local function normalize_format(space_id, space_name, format)\n"
"    local result = {}\n"
"    for i, given in ipairs(format) do\n"
"        local field = {}\n"
"        if type(given) ~= \"table\" then\n"
"            field.name = given\n"
"        else\n"
"            for k, v in pairs(given) do\n"
"                if k == 1 then\n"
"                    if given.name then\n"
"                        if not given.type then\n"
"                            field.type = v\n"
"                        else\n"
"                            field[1] = v\n"
"                        end\n"
"                    else\n"
"                        field.name = v\n"
"                    end\n"
"                elseif k == 2 and not given.type and not given.name then\n"
"                    field.type = v\n"
"                elseif k == 'collation' then\n"
"                    local coll = box.space._collation.index.name:get{v}\n"
"                    if not coll then\n"
"                        box.error(box.error.ILLEGAL_PARAMS,\n"
"                            \"format[\" .. i .. \"]: collation \" ..\n"
"                            \"was not found by name '\" .. v .. \"'\")\n"
"                    end\n"
"                    field[k] = coll.id\n"
"                elseif k == 'constraint' then\n"
"                    field[k] = normalize_constraint(v, \"format[\" .. i .. \"]: \")\n"
"                elseif k == 'foreign_key' then\n"
"                    field[k] = normalize_foreign_key(space_id, space_name,\n"
"                                                     v, \"format[\" .. i .. \"]: \")\n"
"                else\n"
"                    field[k] = v\n"
"                end\n"
"            end\n"
"        end\n"
"        if type(field.name) ~= 'string' then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                \"format[\" .. i .. \"]: name (string) is expected\")\n"
"        end\n"
"        if field.type == nil then\n"
"            field.type = 'any'\n"
"        elseif type(field.type) ~= 'string' then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                \"format[\" .. i .. \"]: type must be a string\")\n"
"        end\n"
"        table.insert(result, field)\n"
"    end\n"
"    return result\n"
"end\n"
"box.internal.space.normalize_format = normalize_format -- for space.upgrade\n"
"\n"
"local function denormalize_foreign_key_one(fkey)\n"
"    assert(type(fkey.field) == 'string' or type(fkey.field) == 'number')\n"
"    local result = fkey\n"
"    if type(fkey.field) == 'number' then\n"
"        -- convert to one-based index\n"
"        result.field = result.field + 1\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"local function denormalize_foreign_key(fkey)\n"
"    local result = setmap{}\n"
"    for k, v in pairs(fkey) do\n"
"        result[k] = denormalize_foreign_key_one(v)\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"-- Convert zero-based foreign key field numbers to one-based\n"
"local function denormalize_format(format)\n"
"    local result = setmetatable({}, { __serialize = 'seq' })\n"
"    for i, f in ipairs(format) do\n"
"        result[i] = f\n"
"        for k, v in pairs(f) do\n"
"            if k == 'foreign_key' then\n"
"                result[i][k] = denormalize_foreign_key(v)\n"
"            end\n"
"        end\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"box.schema.space = {}\n"
"box.schema.space.create = function(name, options)\n"
"    check_param(name, 'name', 'string')\n"
"    local options_template = {\n"
"        if_not_exists = 'boolean',\n"
"        engine = 'string',\n"
"        id = 'number',\n"
"        field_count = 'number',\n"
"        user = 'string, number',\n"
"        format = 'table',\n"
"        is_local = 'boolean',\n"
"        temporary = 'boolean',\n"
"        is_sync = 'boolean',\n"
"        defer_deletes = 'boolean',\n"
"        constraint = 'string, table',\n"
"        foreign_key = 'table',\n"
"    }\n"
"    local options_defaults = {\n"
"        engine = 'memtx',\n"
"        field_count = 0,\n"
"        temporary = false,\n"
"    }\n"
"    check_param_table(options, options_template)\n"
"    options = update_param_table(options, options_defaults)\n"
"    if options.engine == 'vinyl' then\n"
"        options = update_param_table(options, {\n"
"            defer_deletes = box.cfg.vinyl_defer_deletes,\n"
"        })\n"
"    end\n"
"\n"
"    local _space = box.space[box.schema.SPACE_ID]\n"
"    if box.space[name] then\n"
"        if options.if_not_exists then\n"
"            return box.space[name], \"not created\"\n"
"        else\n"
"            box.error(box.error.SPACE_EXISTS, name)\n"
"        end\n"
"    end\n"
"    local id = options.id\n"
"    if not id then\n"
"        id = internal.generate_space_id()\n"
"    end\n"
"    local uid = session.euid()\n"
"    if options.user then\n"
"        uid = user_or_role_resolve(options.user)\n"
"        if uid == nil then\n"
"            box.error(box.error.NO_SUCH_USER, options.user)\n"
"        end\n"
"    end\n"
"    local format = options.format and options.format or {}\n"
"    check_param(format, 'format', 'table')\n"
"    format = normalize_format(id, name, format)\n"
"    local constraint = normalize_constraint(options.constraint, '')\n"
"    local foreign_key = normalize_foreign_key(id, name, options.foreign_key, '',\n"
"                                              true)\n"
"    -- filter out global parameters from the options array\n"
"    local space_options = setmap({\n"
"        group_id = options.is_local and 1 or nil,\n"
"        temporary = options.temporary and true or nil,\n"
"        is_sync = options.is_sync,\n"
"        defer_deletes = options.defer_deletes and true or nil,\n"
"        constraint = constraint,\n"
"        foreign_key = foreign_key,\n"
"    })\n"
"    _space:insert{id, uid, name, options.engine, options.field_count,\n"
"        space_options, format}\n"
"\n"
"    feedback_save_event('create_space')\n"
"    return box.space[id], \"created\"\n"
"end\n"
"\n"
"-- space format - the metadata about space fields\n"
"function box.schema.space.format(id, format)\n"
"    local _space = box.space._space\n"
"    local _vspace = box.space._vspace\n"
"    check_param(id, 'id', 'number')\n"
"\n"
"    local tuple = _vspace:get(id)\n"
"    if tuple == nil then\n"
"        box.error(box.error.NO_SUCH_SPACE, '#' .. tostring(id))\n"
"    end\n"
"\n"
"    if format == nil then\n"
"        return denormalize_format(tuple.format)\n"
"    else\n"
"        check_param(format, 'format', 'table')\n"
"        format = normalize_format(id, tuple.name, format)\n"
"        _space:update(id, {{'=', 7, format}})\n"
"    end\n"
"end\n"
"\n"
"function box.schema.space.upgrade(id)\n"
"    check_param(id, 'id', 'number')\n"
"    box.error(box.error.UNSUPPORTED, \"Community edition\", \"space upgrade\")\n"
"end\n"
"\n"
"box.schema.create_space = box.schema.space.create\n"
"\n"
"box.schema.space.drop = function(space_id, space_name, opts)\n"
"    check_param(space_id, 'space_id', 'number')\n"
"    opts = opts or {}\n"
"    check_param_table(opts, { if_exists = 'boolean' })\n"
"    local _space = box.space[box.schema.SPACE_ID]\n"
"    local _index = box.space[box.schema.INDEX_ID]\n"
"    local _trigger = box.space[box.schema.TRIGGER_ID]\n"
"    local _vindex = box.space[box.schema.VINDEX_ID]\n"
"    local _truncate = box.space[box.schema.TRUNCATE_ID]\n"
"    local _space_sequence = box.space[box.schema.SPACE_SEQUENCE_ID]\n"
"    local _func_index = box.space[box.schema.FUNC_INDEX_ID]\n"
"    local sequence_tuple = _space_sequence:delete{space_id}\n"
"    if sequence_tuple ~= nil and sequence_tuple.is_generated == true then\n"
"        -- Delete automatically generated sequence.\n"
"        box.schema.sequence.drop(sequence_tuple.sequence_id)\n"
"    end\n"
"    for _, t in _trigger.index.space_id:pairs({space_id}) do\n"
"        _trigger:delete({t.name})\n"
"    end\n"
"    for _, t in _func_index.index.primary:pairs({space_id}) do\n"
"        _func_index:delete({space_id, t.index_id})\n"
"    end\n"
"    local keys = _vindex:select(space_id)\n"
"    for i = #keys, 1, -1 do\n"
"        local v = keys[i]\n"
"        _index:delete{v.id, v.iid}\n"
"    end\n"
"    revoke_object_privs('space', space_id)\n"
"    _truncate:delete{space_id}\n"
"    if _space:delete{space_id} == nil then\n"
"        if space_name == nil then\n"
"            space_name = '#'..tostring(space_id)\n"
"        end\n"
"        if not opts.if_exists then\n"
"            box.error(box.error.NO_SUCH_SPACE, space_name)\n"
"        end\n"
"    end\n"
"\n"
"    feedback_save_event('drop_space')\n"
"end\n"
"\n"
"box.schema.space.rename = function(space_id, space_name)\n"
"    check_param(space_id, 'space_id', 'number')\n"
"    check_param(space_name, 'space_name', 'string')\n"
"\n"
"    local _space = box.space[box.schema.SPACE_ID]\n"
"    _space:update(space_id, {{\"=\", 3, space_name}})\n"
"end\n"
"\n"
"local alter_space_template = {\n"
"    field_count = 'number',\n"
"    user = 'string, number',\n"
"    format = 'table',\n"
"    temporary = 'boolean',\n"
"    is_sync = 'boolean',\n"
"    defer_deletes = 'boolean',\n"
"    name = 'string',\n"
"    constraint = 'string, table',\n"
"    foreign_key = 'table',\n"
"}\n"
"\n"
"box.schema.space.alter = function(space_id, options)\n"
"    local space = box.space[space_id]\n"
"    if not space then\n"
"        box.error(box.error.NO_SUCH_SPACE, '#'..tostring(space_id))\n"
"    end\n"
"    check_param_table(options, alter_space_template)\n"
"\n"
"    local _space = box.space._space\n"
"    local tuple = _space:get({space.id})\n"
"    assert(tuple ~= nil)\n"
"\n"
"    local owner\n"
"    if options.user then\n"
"        owner = user_or_role_resolve(options.user)\n"
"        if not owner then\n"
"            box.error(box.error.NO_SUCH_USER, options.user)\n"
"        end\n"
"    else\n"
"        owner = tuple.owner\n"
"    end\n"
"\n"
"    local name = options.name or tuple.name\n"
"    local field_count = options.field_count or tuple.field_count\n"
"    local flags = tuple.flags\n"
"\n"
"    if options.temporary ~= nil then\n"
"        flags.temporary = options.temporary\n"
"    end\n"
"\n"
"    if options.is_sync ~= nil then\n"
"        flags.is_sync = options.is_sync\n"
"    end\n"
"\n"
"    if options.defer_deletes ~= nil then\n"
"        flags.defer_deletes = options.defer_deletes\n"
"    end\n"
"\n"
"    local format\n"
"    if options.format ~= nil then\n"
"        format = normalize_format(space_id, tuple.name, options.format)\n"
"    else\n"
"        format = tuple.format\n"
"    end\n"
"\n"
"    if options.constraint ~= nil then\n"
"        if table.equals(options.constraint, {}) then\n"
"            options.constraint = nil\n"
"        end\n"
"        flags.constraint = normalize_constraint(options.constraint, '')\n"
"    end\n"
"\n"
"    if options.foreign_key ~= nil then\n"
"        if table.equals(options.foreign_key, {}) then\n"
"            options.foreign_key = nil\n"
"        end\n"
"        flags.foreign_key = normalize_foreign_key(space_id, name,\n"
"                                                  options.foreign_key, '', true)\n"
"    end\n"
"\n"
"    tuple = tuple:totable()\n"
"    tuple[2] = owner\n"
"    tuple[3] = name\n"
"    tuple[5] = field_count\n"
"    tuple[6] = flags\n"
"    tuple[7] = format\n"
"    _space:replace(tuple)\n"
"end\n"
"\n"
"box.schema.index = {}\n"
"\n"
"local function update_index_parts_1_6_0(parts)\n"
"    local result = {}\n"
"    if #parts % 2 ~= 0 then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"                  \"options.parts: expected field_no (number), type (string) pairs\")\n"
"    end\n"
"    local i = 0\n"
"    for _ in pairs(parts) do\n"
"        i = i + 1\n"
"        if parts[i] == nil then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      \"options.parts: expected field_no (number), type (string) pairs\")\n"
"        end\n"
"        if i % 2 == 0 then\n"
"            goto continue\n"
"        end\n"
"        if type(parts[i]) ~= \"number\" then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      \"options.parts: expected field_no (number), type (string) pairs\")\n"
"        elseif parts[i] == 0 then\n"
"            -- Lua uses one-based field numbers but _space is zero-based\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      \"invalid index parts: field_no must be one-based\")\n"
"        end\n"
"        if type(parts[i + 1]) ~= \"string\" then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      \"options.parts: expected field_no (number), type (string) pairs\")\n"
"        end\n"
"        table.insert(result, {field = parts[i], type = parts[i + 1]})\n"
"        ::continue::\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"--\n"
"-- Get field index by format field name.\n"
"--\n"
"local function format_field_index_by_name(format, name)\n"
"    for k, v in pairs(format) do\n"
"        if v.name == name then\n"
"            return k\n"
"        end\n"
"    end\n"
"    return nil\n"
"end\n"
"\n"
"--\n"
"-- Get field 0-based index and relative JSON path to data by\n"
"-- field 1-based index or full JSON path. A particular case of a\n"
"-- full JSON path is the format field name.\n"
"--\n"
"local function format_field_resolve(format, path, what)\n"
"    assert(type(path) == 'number' or type(path) == 'string')\n"
"    local idx\n"
"    local relative_path = nil\n"
"    local field_name\n"
"    -- Path doesn't require resolve.\n"
"    if type(path) == 'number' then\n"
"        idx = path\n"
"        goto done\n"
"    end\n"
"    -- An attempt to interpret a path as the full field name.\n"
"    idx = format_field_index_by_name(format, path)\n"
"    if idx ~= nil then\n"
"        relative_path = nil\n"
"        goto done\n"
"    end\n"
"    -- Check if the initial part of the JSON path is a token of\n"
"    -- the form [%d].\n"
"    field_name = string.match(path, \"^%[(%d+)%]\")\n"
"    idx = tonumber(field_name)\n"
"    if idx ~= nil then\n"
"        relative_path = string.sub(path, string.len(field_name) + 3)\n"
"        goto done\n"
"    end\n"
"    -- Check if the initial part of the JSON path is a token of\n"
"    -- the form [\"%s\"] or ['%s'].\n"
"    field_name = string.match(path, '^%[\"([^%]]+)\"%]') or\n"
"                 string.match(path, \"^%['([^%]]+)'%]\")\n"
"    idx = format_field_index_by_name(format, field_name)\n"
"    if idx ~= nil then\n"
"        relative_path = string.sub(path, string.len(field_name) + 5)\n"
"        goto done\n"
"    end\n"
"    -- Check if the initial part of the JSON path is a string\n"
"    -- token: assume that it ends with .*[ or .*.\n"
"    field_name = string.match(path, \"^([^.[]+)\")\n"
"    idx = format_field_index_by_name(format, field_name)\n"
"    if idx ~= nil then\n"
"        relative_path = string.sub(path, string.len(field_name) + 1)\n"
"        goto done\n"
"    end\n"
"    -- Can't resolve field index by path.\n"
"    assert(idx == nil)\n"
"    box.error(box.error.ILLEGAL_PARAMS, what .. \": \" ..\n"
"              \"field was not found by name '\" .. path .. \"'\")\n"
"\n"
"::done::\n"
"    if idx <= 0 then\n"
"        box.error(box.error.ILLEGAL_PARAMS, what .. \": \" ..\n"
"                  \"field (number) must be one-based\")\n"
"    end\n"
"    return idx - 1, relative_path\n"
"end\n"
"\n"
"local function update_index_parts(format, parts)\n"
"    if type(parts) ~= \"table\" then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"        \"options.parts parameter should be a table\")\n"
"    end\n"
"    if #parts == 0 then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"        \"options.parts must have at least one part\")\n"
"    end\n"
"    if type(parts[1]) == 'number' and\n"
"            (parts[2] == nil or type(parts[2]) == 'string') then\n"
"        if parts[3] == nil then\n"
"            parts = {parts} -- one part only\n"
"        else\n"
"            parts = update_index_parts_1_6_0(parts)\n"
"        end\n"
"    end\n"
"\n"
"    local result = {}\n"
"    local i = 0\n"
"    for _ in pairs(parts) do\n"
"        i = i + 1\n"
"        if parts[i] == nil then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                    \"options.parts: unexpected option(s)\")\n"
"        end\n"
"        local part = {}\n"
"        if type(parts[i]) ~= \"table\" then\n"
"            part.field = parts[i]\n"
"        else\n"
"            for k, v in pairs(parts[i]) do\n"
"                -- Support {1, 'unsigned', collation='xx'} shortcut\n"
"                if k == 1 or k == 'field' then\n"
"                    part.field = v;\n"
"                elseif k == 2 or k == 'type' then\n"
"                    part.type = v;\n"
"                elseif k == 'collation' then\n"
"                    -- find ID by name\n"
"                    local coll = box.space._collation.index.name:get{v}\n"
"                    if not coll then\n"
"                        coll = box.space._collation.index.name:get{v:lower()}\n"
"                    end\n"
"                    if not coll then\n"
"                        box.error(box.error.ILLEGAL_PARAMS,\n"
"                            \"options.parts[\" .. i .. \"]: collation was not found by name '\" .. v .. \"'\")\n"
"                    end\n"
"                    part[k] = coll[1]\n"
"                elseif k == 'is_nullable' then\n"
"                    part[k] = v\n"
"                elseif k == 'exclude_null' then\n"
"                    if type(v) ~= 'boolean' then\n"
"                        box.error(box.error.ILLEGAL_PARAMS,\n"
"                                \"options.parts[\" .. i .. \"]: \" ..\n"
"                                \"type (boolean) is expected\")\n"
"                    end\n"
"                    part[k] = v\n"
"                else\n"
"                    part[k] = v\n"
"                end\n"
"            end\n"
"        end\n"
"        if type(part.field) == 'number' or type(part.field) == 'string' then\n"
"            local idx, path = format_field_resolve(format, part.field,\n"
"                                                   \"options.parts[\" .. i .. \"]\")\n"
"            part.field = idx\n"
"            part.path = path or part.path\n"
"        else\n"
"            box.error(box.error.ILLEGAL_PARAMS, \"options.parts[\" .. i .. \"]: \" ..\n"
"                      \"field (name or number) is expected\")\n"
"        end\n"
"        local fmt = format[part.field + 1]\n"
"        if part.type == nil then\n"
"            if fmt and fmt.type then\n"
"                part.type = fmt.type\n"
"            else\n"
"                part.type = 'scalar'\n"
"            end\n"
"        elseif type(part.type) ~= 'string' then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      \"options.parts[\" .. i .. \"]: type (string) is expected\")\n"
"        end\n"
"        if part.collation == nil and fmt then\n"
"            part.collation = fmt.collation\n"
"        end\n"
"        if part.is_nullable == nil then\n"
"            if fmt and fmt.is_nullable then\n"
"                part.is_nullable = true\n"
"            end\n"
"        elseif type(part.is_nullable) ~= 'boolean' then\n"
"            box.error(box.error.ILLEGAL_PARAMS,\n"
"                      \"options.parts[\" .. i .. \"]: type (boolean) is expected\")\n"
"        end\n"
"        if (not part.is_nullable) and part.exclude_null then\n"
"            if part.is_nullable ~= nil then\n"
"                box.error(box.error.ILLEGAL_PARAMS,\n"
"                       \"options.parts[\" .. i .. \"]: exclude_null=true and \" ..\n"
"                       \"is_nullable=false are incompatible\")\n"
"            end\n"
"            part.is_nullable = true\n"
"        end\n"
"        if part.action == nil then\n"
"            if fmt and fmt.action ~= nil then\n"
"                part.action = fmt.action\n"
"            end\n"
"        end\n"
"        if type(parts[i]) == \"table\" then\n"
"            local first_illegal_index = 3\n"
"            if parts[i].field ~= nil then\n"
"                first_illegal_index = first_illegal_index - 1\n"
"            end\n"
"            if parts[i].type ~= nil then\n"
"                first_illegal_index = first_illegal_index - 1\n"
"            end\n"
"            if parts[i][first_illegal_index] ~= nil then\n"
"                box.error(box.error.ILLEGAL_PARAMS,\n"
"                        \"options.parts[\" .. i .. \"]: unexpected option \" .. parts[i][first_illegal_index])\n"
"            end\n"
"        end\n"
"        table.insert(result, part)\n"
"    end\n"
"    return result\n"
"end\n"
"\n"
"--\n"
"-- Convert index parts into 1.6.6 format if they\n"
"-- don't use any extra option beside type and field.\n"
"--\n"
"local function try_simplify_index_parts(parts)\n"
"    local new_parts = {}\n"
"    for i, part in pairs(parts) do\n"
"        for k in pairs(part) do\n"
"            if k ~= 'field' and k ~= 'type' then\n"
"                return parts\n"
"            end\n"
"        end\n"
"        new_parts[i] = {part.field, part.type}\n"
"    end\n"
"    return new_parts\n"
"end\n"
"\n"
"--\n"
"-- Raise an error if a sequence isn't compatible with a given\n"
"-- index definition.\n"
"--\n"
"local function space_sequence_check(sequence, parts, space_name, index_name)\n"
"    local sequence_part = nil\n"
"    if sequence.field ~= nil then\n"
"        sequence.path = sequence.path or ''\n"
"        -- Look up the index part corresponding to the given field.\n"
"        for _, part in ipairs(parts) do\n"
"            local field = part.field or part[1]\n"
"            local path = part.path or ''\n"
"            if sequence.field == field and sequence.path == path then\n"
"                sequence_part = part\n"
"                break\n"
"            end\n"
"        end\n"
"        if sequence_part == nil then\n"
"            box.error(box.error.MODIFY_INDEX, index_name, space_name,\n"
"                      \"sequence field must be a part of the index\")\n"
"        end\n"
"    else\n"
"        -- If the sequence field is omitted, use the first\n"
"        -- indexed field.\n"
"        sequence_part = parts[1]\n"
"        sequence.field = sequence_part.field or sequence_part[1]\n"
"        sequence.path = sequence_part.path or ''\n"
"    end\n"
"    -- Check the type of the auto-increment field.\n"
"    local t = sequence_part.type or sequence_part[2]\n"
"    if t ~= 'integer' and t ~= 'unsigned' then\n"
"        box.error(box.error.MODIFY_INDEX, index_name, space_name,\n"
"                  \"sequence cannot be used with a non-integer key\")\n"
"    end\n"
"end\n"
"\n"
"--\n"
"-- The first stage of a space sequence modification operation.\n"
"-- Called before altering the space definition. Checks sequence\n"
"-- options and detaches the old sequence from the space.\n"
"-- Returns a proxy object that is supposed to be passed to\n"
"-- space_sequence_alter_commit() to complete the operation.\n"
"--\n"
"local function space_sequence_alter_prepare(format, parts, options,\n"
"                                            space_id, index_id,\n"
"                                            space_name, index_name)\n"
"    local _space_sequence = box.space[box.schema.SPACE_SEQUENCE_ID]\n"
"\n"
"    -- A sequence can only be attached to a primary index.\n"
"    if index_id ~= 0 then\n"
"        -- Ignore 'sequence = false' for secondary indexes.\n"
"        if not options.sequence then\n"
"            return nil\n"
"        end\n"
"        box.error(box.error.MODIFY_INDEX, index_name, space_name,\n"
"                  \"sequence cannot be used with a secondary key\")\n"
"    end\n"
"\n"
"    -- Look up the currently attached sequence, if any.\n"
"    local old_sequence\n"
"    local tuple = _space_sequence:get(space_id)\n"
"    if tuple ~= nil then\n"
"        old_sequence = {\n"
"            id = tuple.sequence_id,\n"
"            is_generated = tuple.is_generated,\n"
"            field = tuple.field,\n"
"            path = tuple.path,\n"
"        }\n"
"    else\n"
"        old_sequence = nil\n"
"    end\n"
"\n"
"    if options.sequence == nil then\n"
"        -- No sequence option, just check that the old sequence\n"
"        -- is compatible with the new index definition.\n"
"        if old_sequence ~= nil and old_sequence.field ~= nil then\n"
"            space_sequence_check(old_sequence, parts, space_name, index_name)\n"
"        end\n"
"        return nil\n"
"    end\n"
"\n"
"    -- Convert the provided option to the table format.\n"
"    local new_sequence\n"
"    if type(options.sequence) == 'table' then\n"
"        -- Sequence is given as a table, just copy it.\n"
"        -- Silently ignore unknown fields.\n"
"        new_sequence = {\n"
"            id = options.sequence.id,\n"
"            field = options.sequence.field,\n"
"        }\n"
"    elseif options.sequence == true then\n"
"        -- Create an auto-generated sequence.\n"
"        new_sequence = {}\n"
"    elseif options.sequence == false then\n"
"        -- Drop the currently attached sequence.\n"
"        new_sequence = nil\n"
"    else\n"
"        -- Attach a sequence with the given id.\n"
"        new_sequence = {id = options.sequence}\n"
"    end\n"
"\n"
"    if new_sequence ~= nil then\n"
"        -- Resolve the sequence name.\n"
"        if new_sequence.id ~= nil then\n"
"            local id = sequence_resolve(new_sequence.id)\n"
"            if id == nil then\n"
"                box.error(box.error.NO_SUCH_SEQUENCE, new_sequence.id)\n"
"            end\n"
"            local tuple = _space_sequence.index.sequence:select(id)[1]\n"
"            if tuple ~= nil and tuple.is_generated then\n"
"                box.error(box.error.ALTER_SPACE, space_name,\n"
"                          \"can not attach generated sequence\")\n"
"            end\n"
"            new_sequence.id = id\n"
"        end\n"
"        -- Resolve the sequence field.\n"
"        if new_sequence.field ~= nil then\n"
"            local field, path = format_field_resolve(format, new_sequence.field,\n"
"                                                     \"sequence field\")\n"
"            new_sequence.field = field\n"
"            new_sequence.path = path\n"
"        end\n"
"        -- Inherit omitted options from the attached sequence.\n"
"        if old_sequence ~= nil then\n"
"            if new_sequence.id == nil and old_sequence.is_generated then\n"
"                new_sequence.id = old_sequence.id\n"
"                new_sequence.is_generated = true\n"
"            end\n"
"            if new_sequence.field == nil then\n"
"                new_sequence.field = old_sequence.field\n"
"                new_sequence.path = old_sequence.path\n"
"            end\n"
"        end\n"
"        -- Check that the sequence is compatible with\n"
"        -- the index definition.\n"
"        space_sequence_check(new_sequence, parts, space_name, index_name)\n"
"        -- If sequence id is omitted, we are supposed to create\n"
"        -- a new auto-generated sequence for the given space.\n"
"        if new_sequence.id == nil then\n"
"            local seq = box.schema.sequence.create(space_name .. '_seq')\n"
"            new_sequence.id = seq.id\n"
"            new_sequence.is_generated = true\n"
"        end\n"
"        new_sequence.is_generated = new_sequence.is_generated or false\n"
"    end\n"
"\n"
"    if old_sequence ~= nil then\n"
"        -- Detach the old sequence before altering the space.\n"
"        _space_sequence:delete(space_id)\n"
"    end\n"
"\n"
"    return {\n"
"        space_id = space_id,\n"
"        new_sequence = new_sequence,\n"
"        old_sequence = old_sequence,\n"
"    }\n"
"end\n"
"\n"
"--\n"
"-- The second stage of a space sequence modification operation.\n"
"-- Called after altering the space definition. Attaches the sequence\n"
"-- to the space and drops the old sequence if required. 'proxy' is\n"
"-- an object returned by space_sequence_alter_prepare().\n"
"--\n"
"local function space_sequence_alter_commit(proxy)\n"
"    local _space_sequence = box.space[box.schema.SPACE_SEQUENCE_ID]\n"
"\n"
"    if proxy == nil then\n"
"        -- No sequence option, nothing to do.\n"
"        return\n"
"    end\n"
"\n"
"    local space_id = proxy.space_id\n"
"    local old_sequence = proxy.old_sequence\n"
"    local new_sequence = proxy.new_sequence\n"
"\n"
"    if new_sequence ~= nil then\n"
"        -- Attach the new sequence.\n"
"        _space_sequence:insert{space_id, new_sequence.id,\n"
"                               new_sequence.is_generated,\n"
"                               new_sequence.field, new_sequence.path}\n"
"    end\n"
"\n"
"    if old_sequence ~= nil and old_sequence.is_generated and\n"
"       (new_sequence == nil or old_sequence.id ~= new_sequence.id) then\n"
"        -- Drop automatically generated sequence.\n"
"        box.schema.sequence.drop(old_sequence.id)\n"
"    end\n"
"end\n"
"\n"
"-- Historically, some properties of an index\n"
"-- are stored as tuple fields, others in a\n"
"-- single field containing msgpack map.\n"
"-- This is the map.\n"
"local index_options = {\n"
"    unique = 'boolean',\n"
"    dimension = 'number',\n"
"    distance = 'string',\n"
"    run_count_per_level = 'number',\n"
"    run_size_ratio = 'number',\n"
"    range_size = 'number',\n"
"    page_size = 'number',\n"
"    bloom_fpr = 'number',\n"
"    func = 'number, string',\n"
"    hint = 'boolean',\n"
"}\n"
"\n"
"local function jsonpaths_from_idx_parts(parts)\n"
"    local paths = {}\n"
"\n"
"    for _, part in pairs(parts) do\n"
"        if type(part.path) == 'string' then\n"
"            table.insert(paths, part.path)\n"
"        end\n"
"    end\n"
"\n"
"    return paths\n"
"end\n"
"\n"
"local function is_multikey_index(parts)\n"
"    for _, path in pairs(jsonpaths_from_idx_parts(parts)) do\n"
"        if path:find('[*]', 1, true) then\n"
"            return true\n"
"        end\n"
"    end\n"
"\n"
"    return false\n"
"end\n"
"\n"
"--\n"
"-- check_param_table() template for alter index,\n"
"-- includes all index options.\n"
"--\n"
"local alter_index_template = {\n"
"    id = 'number',\n"
"    name = 'string',\n"
"    type = 'string',\n"
"    parts = 'table',\n"
"    sequence = 'boolean, number, string, table',\n"
"}\n"
"for k, v in pairs(index_options) do\n"
"    alter_index_template[k] = v\n"
"end\n"
"\n"
"--\n"
"-- check_param_table() template for create_index(), includes\n"
"-- all index options and if_not_exists specifier\n"
"--\n"
"local create_index_template = table.deepcopy(alter_index_template)\n"
"create_index_template.if_not_exists = \"boolean\"\n"
"\n"
"-- Find a function id by given function name\n"
"local function func_id_by_name(func_name)\n"
"    local func = box.space._func.index.name:get(func_name)\n"
"    if func == nil then\n"
"        box.error(box.error.NO_SUCH_FUNCTION, func_name)\n"
"    end\n"
"    return func.id\n"
"end\n"
"box.internal.func_id_by_name = func_id_by_name -- for space.upgrade\n"
"\n"
"box.schema.index.create = function(space_id, name, options)\n"
"    check_param(space_id, 'space_id', 'number')\n"
"    check_param(name, 'name', 'string')\n"
"    check_param_table(options, create_index_template)\n"
"    local space = box.space[space_id]\n"
"    if not space then\n"
"        box.error(box.error.NO_SUCH_SPACE, '#'..tostring(space_id))\n"
"    end\n"
"    local format = space:format()\n"
"\n"
"    local options_defaults = {\n"
"        type = 'tree',\n"
"    }\n"
"    options = update_param_table(options, options_defaults)\n"
"    local type_dependent_defaults = {\n"
"        rtree = {parts = { 2, 'array' }, unique = false},\n"
"        bitset = {parts = { 2, 'unsigned' }, unique = false},\n"
"        other = {parts = { 1, 'unsigned' }, unique = true},\n"
"    }\n"
"    options_defaults = type_dependent_defaults[options.type]\n"
"            or type_dependent_defaults.other\n"
"    if not options.parts then\n"
"        local fieldno = options_defaults.parts[1]\n"
"        if #format >= fieldno then\n"
"            local t = format[fieldno].type\n"
"            if t ~= 'any' then\n"
"                options.parts = {{fieldno, format[fieldno].type}}\n"
"            end\n"
"        end\n"
"    end\n"
"    options = update_param_table(options, options_defaults)\n"
"    if space.engine == 'vinyl' then\n"
"        options_defaults = {\n"
"            page_size = box.cfg.vinyl_page_size,\n"
"            range_size = box.cfg.vinyl_range_size,\n"
"            run_count_per_level = box.cfg.vinyl_run_count_per_level,\n"
"            run_size_ratio = box.cfg.vinyl_run_size_ratio,\n"
"            bloom_fpr = box.cfg.vinyl_bloom_fpr\n"
"        }\n"
"    else\n"
"        options_defaults = {}\n"
"    end\n"
"    options = update_param_table(options, options_defaults)\n"
"    if options.hint and options.func then\n"
"        box.error(box.error.MODIFY_INDEX, name, space.name,\n"
"                \"functional index can't use hints\")\n"
"    end\n"
"\n"
"    local _index = box.space[box.schema.INDEX_ID]\n"
"    local _vindex = box.space[box.schema.VINDEX_ID]\n"
"    if _vindex.index.name:get{space_id, name} then\n"
"        if options.if_not_exists then\n"
"            return space.index[name], \"not created\"\n"
"        else\n"
"            box.error(box.error.INDEX_EXISTS, name)\n"
"        end\n"
"    end\n"
"\n"
"    local iid = 0\n"
"    if options.id then\n"
"        iid = options.id\n"
"    else\n"
"        -- max\n"
"        local tuple = _vindex.index[0]\n"
"            :select(space_id, { limit = 1, iterator = 'LE' })[1]\n"
"        if tuple then\n"
"            local id = tuple.id\n"
"            if id == space_id then\n"
"                iid = tuple.iid + 1\n"
"            end\n"
"        end\n"
"    end\n"
"    local parts = update_index_parts(format, options.parts)\n"
"    -- create_index() options contains type, parts, etc,\n"
"    -- stored separately. Remove these members from index_opts\n"
"    local index_opts = {\n"
"            dimension = options.dimension,\n"
"            unique = options.unique,\n"
"            distance = options.distance,\n"
"            page_size = options.page_size,\n"
"            range_size = options.range_size,\n"
"            run_count_per_level = options.run_count_per_level,\n"
"            run_size_ratio = options.run_size_ratio,\n"
"            bloom_fpr = options.bloom_fpr,\n"
"            func = options.func,\n"
"            hint = options.hint,\n"
"    }\n"
"    local field_type_aliases = {\n"
"        num = 'unsigned'; -- Deprecated since 1.7.2\n"
"        uint = 'unsigned';\n"
"        str = 'string';\n"
"        int = 'integer';\n"
"        ['*'] = 'any';\n"
"    };\n"
"    for _, part in pairs(parts) do\n"
"        local field_type = part.type:lower()\n"
"        part.type = field_type_aliases[field_type] or field_type\n"
"        if field_type == 'num' then\n"
"            log.warn(\"field type '%s' is deprecated since Tarantool 1.7, \"..\n"
"                     \"please use '%s' instead\", field_type, part.type)\n"
"        end\n"
"    end\n"
"    -- save parts in old format if possible\n"
"    parts = try_simplify_index_parts(parts)\n"
"    if options.hint and is_multikey_index(parts) then\n"
"        box.error(box.error.MODIFY_INDEX, name, space.name,\n"
"                \"multikey index can't use hints\")\n"
"    end\n"
"    if index_opts.func ~= nil and type(index_opts.func) == 'string' then\n"
"        index_opts.func = func_id_by_name(index_opts.func)\n"
"    end\n"
"    local sequence_proxy = space_sequence_alter_prepare(format, parts, options,\n"
"                                                        space_id, iid,\n"
"                                                        space.name, name)\n"
"    _index:insert{space_id, iid, name, options.type, index_opts, parts}\n"
"    space_sequence_alter_commit(sequence_proxy)\n"
"    if index_opts.func ~= nil then\n"
"        local _func_index = box.space[box.schema.FUNC_INDEX_ID]\n"
"        _func_index:insert{space_id, iid, index_opts.func}\n"
"    end\n"
"\n"
"    feedback_save_event('create_index')\n"
"    return space.index[name]\n"
"end\n"
"\n"
"box.schema.index.drop = function(space_id, index_id)\n"
"    check_param(space_id, 'space_id', 'number')\n"
"    check_param(index_id, 'index_id', 'number')\n"
"    if index_id == 0 then\n"
"        local _space_sequence = box.space[box.schema.SPACE_SEQUENCE_ID]\n"
"        local sequence_tuple = _space_sequence:delete{space_id}\n"
"        if sequence_tuple ~= nil and sequence_tuple.is_generated == true then\n"
"            -- Delete automatically generated sequence.\n"
"            box.schema.sequence.drop(sequence_tuple.sequence_id)\n"
"        end\n"
"    end\n"
"    local _index = box.space[box.schema.INDEX_ID]\n"
"    local _func_index = box.space[box.schema.FUNC_INDEX_ID]\n"
"    for _, v in box.space._func_index:pairs{space_id, index_id} do\n"
"        _func_index:delete({v.space_id, v.index_id})\n"
"    end\n"
"    _index:delete{space_id, index_id}\n"
"\n"
"    feedback_save_event('drop_index')\n"
"end\n"
"\n"
"box.schema.index.rename = function(space_id, index_id, name)\n"
"    check_param(space_id, 'space_id', 'number')\n"
"    check_param(index_id, 'index_id', 'number')\n"
"    check_param(name, 'name', 'string')\n"
"\n"
"    local _index = box.space[box.schema.INDEX_ID]\n"
"    _index:update({space_id, index_id}, {{\"=\", 3, name}})\n"
"end\n"
"\n"
"box.schema.index.alter = function(space_id, index_id, options)\n"
"    local space = box.space[space_id]\n"
"    if space == nil then\n"
"        box.error(box.error.NO_SUCH_SPACE, '#'..tostring(space_id))\n"
"    end\n"
"    if space.index[index_id] == nil then\n"
"        box.error(box.error.NO_SUCH_INDEX_ID, index_id, space.name)\n"
"    end\n"
"    if options == nil then\n"
"        return\n"
"    end\n"
"\n"
"    check_param_table(options, alter_index_template)\n"
"\n"
"    if type(space_id) ~= \"number\" then\n"
"        space_id = space.id\n"
"    end\n"
"    if type(index_id) ~= \"number\" then\n"
"        index_id = space.index[index_id].id\n"
"    end\n"
"    local format = space:format()\n"
"    local _index = box.space[box.schema.INDEX_ID]\n"
"    if options.id ~= nil then\n"
"        local can_update_field = {id = true, name = true, type = true }\n"
"        local can_update = true\n"
"        local cant_update_fields = ''\n"
"        for k, _ in pairs(options) do\n"
"            if not can_update_field[k] then\n"
"                can_update = false\n"
"                cant_update_fields = cant_update_fields .. ' ' .. k\n"
"            end\n"
"        end\n"
"        if not can_update then\n"
"            box.error(box.error.PROC_LUA,\n"
"                      \"Don't know how to update both id and\" ..\n"
"                       cant_update_fields)\n"
"        end\n"
"        local ops = {}\n"
"        local function add_op(value, field_no)\n"
"            if value then\n"
"                table.insert(ops, {'=', field_no, value})\n"
"            end\n"
"        end\n"
"        add_op(options.id, 2)\n"
"        add_op(options.name, 3)\n"
"        add_op(options.type, 4)\n"
"        _index:update({space_id, index_id}, ops)\n"
"        return\n"
"    end\n"
"    local tuple = _index:get{space_id, index_id }\n"
"    local parts = {}\n"
"    local index_opts = {}\n"
"    if type(tuple.opts) == 'number' then\n"
"        -- old format\n"
"        index_opts.unique = tuple[5] == 1\n"
"        local part_count = tuple[6]\n"
"        for i = 1, part_count do\n"
"            table.insert(parts, {tuple[2 * i + 4], tuple[2 * i + 5]});\n"
"        end\n"
"    else\n"
"        -- new format\n"
"        index_opts = tuple.opts\n"
"        parts = tuple.parts\n"
"    end\n"
"    if options.name == nil then\n"
"        options.name = tuple.name\n"
"    end\n"
"    if options.type == nil then\n"
"        options.type = tuple.type\n"
"    end\n"
"    for k, _ in pairs(index_options) do\n"
"        if options[k] ~= nil then\n"
"            index_opts[k] = options[k]\n"
"        end\n"
"    end\n"
"    if options.hint and options.func then\n"
"        box.error(box.error.MODIFY_INDEX, space.index[index_id].name,\n"
"                                          space.name,\n"
"                \"functional index can't use hints\")\n"
"    end\n"
"    if options.parts then\n"
"        parts = update_index_parts(format, options.parts)\n"
"        -- save parts in old format if possible\n"
"        parts = try_simplify_index_parts(parts)\n"
"    end\n"
"    if options.hint and is_multikey_index(parts) then\n"
"        box.error(box.error.MODIFY_INDEX, space.index[index_id].name,\n"
"                                          space.name,\n"
"                \"multikey index can't use hints\")\n"
"    end\n"
"    if index_opts.func ~= nil and type(index_opts.func) == 'string' then\n"
"        index_opts.func = func_id_by_name(index_opts.func)\n"
"    end\n"
"    local sequence_proxy = space_sequence_alter_prepare(format, parts, options,\n"
"                                                        space_id, index_id,\n"
"                                                        space.name, options.name)\n"
"    _index:replace{space_id, index_id, options.name, options.type,\n"
"                   index_opts, parts}\n"
"    if index_opts.func ~= nil then\n"
"        local _func_index = box.space[box.schema.FUNC_INDEX_ID]\n"
"        _func_index:insert{space_id, index_id, index_opts.func}\n"
"    end\n"
"    space_sequence_alter_commit(sequence_proxy)\n"
"end\n"
"\n"
"-- a static box_tuple_t ** instance for calling box_index_* API\n"
"local ptuple = ffi.new('box_tuple_t *[1]')\n"
"\n"
"local function keify(key)\n"
"    if key == nil then\n"
"        return {}\n"
"    elseif type(key) == \"table\" or is_tuple(key) then\n"
"        return key\n"
"    end\n"
"    return {key}\n"
"end\n"
"\n"
"local iterator_t = ffi.typeof('struct iterator')\n"
"ffi.metatype(iterator_t, {\n"
"    __tostring = function(self)\n"
"        return \"<iterator state>\"\n"
"    end;\n"
"})\n"
"\n"
"local iterator_gen_luac = function(param, state) -- luacheck: no unused args\n"
"    local tuple = internal.iterator_next(state)\n"
"    if tuple ~= nil then\n"
"        return state, tuple -- new state, value\n"
"    else\n"
"        return nil\n"
"    end\n"
"end\n"
"\n"
"local iterator_gen = function(param, state) -- luacheck: no unused args\n"
"    if builtin.box_read_ffi_is_disabled then\n"
"        return iterator_gen_luac(param, state)\n"
"    end\n"
"    --[[\n"
"        index:pairs() mostly conforms to the Lua for-in loop conventions and\n"
"        tries to follow the best practices of Lua community.\n"
"\n"
"        - this generating function is stateless.\n"
"\n"
"        - *param* should contain **immutable** data needed to fully define\n"
"          an iterator. *param* is opaque for users. Currently it contains keybuf\n"
"          string just to prevent GC from collecting it. In future some other\n"
"          variables like space_id, index_id, sc_version will be stored here.\n"
"\n"
"        - *state* should contain **immutable** transient state of an iterator.\n"
"          *state* is opaque for users. Currently it contains `struct iterator`\n"
"          cdata that is modified during iteration. This is a sad limitation of\n"
"          underlying C API. Moreover, the separation of *param* and *state* is\n"
"          not properly implemented here. These drawbacks can be fixed in\n"
"          future without changing this API.\n"
"\n"
"        Please check out http://www.lua.org/pil/7.3.html for details.\n"
"    --]]\n"
"    if not ffi.istype(iterator_t, state) then\n"
"        error('usage: next(param, state)')\n"
"    end\n"
"    -- next() modifies state in-place\n"
"    if builtin.box_iterator_next(state, ptuple) ~= 0 then\n"
"        return box.error() -- error\n"
"    elseif ptuple[0] ~= nil then\n"
"        return state, tuple_bless(ptuple[0]) -- new state, value\n"
"    else\n"
"        return nil\n"
"    end\n"
"end\n"
"\n"
"-- global struct port instance to use by select()/get()\n"
"local port = ffi.new('struct port')\n"
"local port_c = ffi.cast('struct port_c *', port)\n"
"\n"
"-- Helper function to check space:method() usage\n"
"local function check_space_arg(space, method)\n"
"    if type(space) ~= 'table' or space.id == nil then\n"
"        local fmt = 'Use space:%s(...) instead of space.%s(...)'\n"
"        error(string.format(fmt, method, method))\n"
"    end\n"
"end\n"
"box.internal.check_space_arg = check_space_arg -- for net.box\n"
"\n"
"-- Helper function for nicer error messages\n"
"-- in some cases when space object is misused\n"
"-- Takes time so should not be used for DML.\n"
"local function check_space_exists(space)\n"
"    local s = box.space[space.id]\n"
"    if s == nil then\n"
"        box.error(box.error.NO_SUCH_SPACE, space.name)\n"
"    end\n"
"end\n"
"\n"
"-- Helper function to check index:method() usage\n"
"local function check_index_arg(index, method)\n"
"    if type(index) ~= 'table' or index.id == nil then\n"
"        local fmt = 'Use index:%s(...) instead of index.%s(...)'\n"
"        error(string.format(fmt, method, method))\n"
"    end\n"
"end\n"
"box.internal.check_index_arg = check_index_arg -- for net.box\n"
"\n"
"-- Helper function to check that space have primary key and return it\n"
"local function check_primary_index(space)\n"
"    local pk = space.index[0]\n"
"    if pk == nil then\n"
"        box.error(box.error.NO_SUCH_INDEX_ID, 0, space.name)\n"
"    end\n"
"    return pk\n"
"end\n"
"box.internal.check_primary_index = check_primary_index -- for net.box\n"
"\n"
"local internal_schema_version_warn_once = false\n"
"box.internal.schema_version = function()\n"
"    if not internal_schema_version_warn_once then\n"
"        internal_schema_version_warn_once = true\n"
"        log.warn('box.internal.schema_version will be removed, please use box.info.schema_version instead')\n"
"    end\n"
"    return box.info.schema_version\n"
"end\n"
"\n"
"local function check_iterator_type(opts, key_is_nil)\n"
"    local opts_type = type(opts)\n"
"    if opts ~= nil and opts_type ~= \"table\" and opts_type ~= \"string\" and opts_type ~= \"number\" then\n"
"        box.error(box.error.ITERATOR_TYPE, opts)\n"
"    end\n"
"\n"
"    local itype\n"
"    if opts_type == \"table\" and opts.iterator then\n"
"        if type(opts.iterator) == \"number\" then\n"
"            itype = opts.iterator\n"
"        elseif type(opts.iterator) == \"string\" then\n"
"            itype = box.index[string.upper(opts.iterator)]\n"
"            if itype == nil then\n"
"                box.error(box.error.ITERATOR_TYPE, opts.iterator)\n"
"            end\n"
"        else\n"
"            box.error(box.error.ITERATOR_TYPE, tostring(opts.iterator))\n"
"        end\n"
"    elseif opts_type == \"number\" then\n"
"        itype = opts\n"
"    elseif opts_type == \"string\" then\n"
"        itype = box.index[string.upper(opts)]\n"
"        if itype == nil then\n"
"            box.error(box.error.ITERATOR_TYPE, opts)\n"
"        end\n"
"    else\n"
"        -- Use ALL for {} and nil keys and EQ for other keys\n"
"        itype = key_is_nil and box.index.ALL or box.index.EQ\n"
"    end\n"
"    return itype\n"
"end\n"
"\n"
"internal.check_iterator_type = check_iterator_type\n"
"\n"
"local function check_pairs_opts(opts, key_is_nil)\n"
"    local iterator = check_iterator_type(opts, key_is_nil)\n"
"    local after = nil\n"
"    if opts ~= nil and type(opts) == \"table\" then\n"
"        if opts.after ~= nil then\n"
"            after = opts.after\n"
"            if after ~= nil and type(after) ~= \"string\" and type(after) ~= \"table\"\n"
"              and not is_tuple(after) then\n"
"                box.error(box.error.ITERATOR_POSITION)\n"
"            end\n"
"        end\n"
"    end\n"
"    return iterator, after\n"
"end\n"
"\n"
"-- pointer to iterator position used by select(), pairs() and tuple_pos()\n"
"local iterator_pos = ffi.new('const char *[1]')\n"
"local iterator_pos_end = ffi.new('const char *[1]')\n"
"\n"
"-- Argument pos must be a string, table or tuple, returns two C pointers:\n"
"-- begin and end of position.\n"
"local function normalize_position(index, pos, ret_pos, ret_pos_end)\n"
"    if pos == nil then\n"
"        ret_pos[0] = nil\n"
"        ret_pos_end[0] = nil\n"
"    elseif type(pos) == \"string\" then\n"
"        ret_pos[0] = pos\n"
"        ret_pos_end[0] = ret_pos[0] + #pos\n"
"    else\n"
"        local tuple_ibuf = cord_ibuf_take()\n"
"        local tuple, tuple_end = tuple_encode(tuple_ibuf, pos)\n"
"        local nok = builtin.box_index_tuple_position(index.space_id, index.id,\n"
"                                                     tuple, tuple_end,\n"
"                                                     ret_pos, ret_pos_end) ~= 0\n"
"        cord_ibuf_put(tuple_ibuf)\n"
"        if nok then\n"
"            box.error()\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local base_index_mt = {}\n"
"base_index_mt.__index = base_index_mt\n"
"--\n"
"-- Inherit engine specific index metatables from a base one.\n"
"--\n"
"local vinyl_index_mt = {}\n"
"vinyl_index_mt.__index = vinyl_index_mt\n"
"local memtx_index_mt = {}\n"
"memtx_index_mt.__index = memtx_index_mt\n"
"--\n"
"-- When a new method is added below to base index mt, the same\n"
"-- method is added both to vinyl and memtx index mt.\n"
"--\n"
"setmetatable(base_index_mt, {\n"
"    __newindex = function(t, k, v)\n"
"        vinyl_index_mt[k] = v\n"
"        memtx_index_mt[k] = v\n"
"        rawset(t, k, v)\n"
"    end\n"
"})\n"
"-- __len and __index\n"
"base_index_mt.len = function(index)\n"
"    check_index_arg(index, 'len')\n"
"    local ret = builtin.box_index_len(index.space_id, index.id)\n"
"    if ret == -1 then\n"
"        box.error()\n"
"    end\n"
"    return tonumber(ret)\n"
"end\n"
"-- index.bsize\n"
"base_index_mt.bsize = function(index)\n"
"    check_index_arg(index, 'bsize')\n"
"    local ret = builtin.box_index_bsize(index.space_id, index.id)\n"
"    if ret == -1 then\n"
"        box.error()\n"
"    end\n"
"    return tonumber(ret)\n"
"end\n"
"-- index.fselect - formatted select.\n"
"-- Options can be passed through opts, fselect_opts and global variables.\n"
"-- If an option is in opts table or set in global variable - it must have\n"
"-- prefix 'fselect_'. If an option is on fselect_opts table - it may or\n"
"-- may not have the prefix.\n"
"-- Options:\n"
"-- type:\n"
"--   'sql' - like mysql result (default)\n"
"--   'gh' (or 'github' or 'markdown') - markdown syntax, for pasting to github.\n"
"--   'jira' syntax (for pasting to jira)\n"
"-- columns: array with desired columns (numbers or names).\n"
"-- widths: array with desired widths of columns.\n"
"-- max_width: limit entire length of a row string, longest fields will be cut.\n"
"--  Set to 0 (default) to detect and use screen width. Set to -1 for no limit.\n"
"-- print: (default - false) - print each line instead of adding to result.\n"
"-- use_nbsp: (default - true) - add invisible spaces to improve readability\n"
"--  in YAML output. Not applicabble when print=true.\n"
"base_index_mt.fselect = function(index, key, opts, fselect_opts)\n"
"    -- Options.\n"
"    if type(opts) == 'string' and fselect_opts == nil then\n"
"        fselect_opts = {columns = opts}\n"
"        opts = nil\n"
"    elseif type(fselect_opts) == 'string' then\n"
"        fselect_opts = {columns = fselect_opts}\n"
"    elseif type(fselect_opts) ~= 'table' then\n"
"        fselect_opts = {}\n"
"    end\n"
"\n"
"    -- Get global value, like _G[name] but wrapped with pcall for strict mode.\n"
"    local function get_global(name)\n"
"        local function internal() return _G[name] end\n"
"        local success,result = pcall(internal)\n"
"        return success and result or nil\n"
"    end\n"
"    -- Get a value from `opts` table and remove it from the table.\n"
"    local function grab_from_opts(name)\n"
"        if type(opts) ~= 'table' then return nil end\n"
"        local res = opts[name]\n"
"        if res ~= nil then opts[name] = nil end\n"
"        return res\n"
"    end\n"
"    -- Find an option in opts, fselect_opts or _G by given name.\n"
"    -- In opts and _G the value is searched with 'fselect_' prefix;\n"
"    -- In fselect_opts - with or without prefix.\n"
"    local function get_opt(name, default, expected_types)\n"
"        local expected_types_set = {}\n"
"        for _, v in pairs(expected_types:split(',')) do\n"
"            expected_types_set[v:strip()] = true\n"
"        end\n"
"        local prefix_name = 'fselect_' .. name\n"
"        local variants = {fselect_opts[prefix_name], fselect_opts[name],\n"
"            grab_from_opts(prefix_name), get_global(prefix_name), default }\n"
"        local min_i = 0\n"
"        local min_v = nil\n"
"        for i,v in pairs(variants) do\n"
"            -- Can't use ipairs since it's an array with nils.\n"
"            -- Have to sort by i, because pairs() doesn't provide order.\n"
"            if expected_types_set[type(v)] and (i < min_i or min_v == nil) then\n"
"                min_i = i\n"
"                min_v = v\n"
"            end\n"
"        end\n"
"        return min_v\n"
"    end\n"
"\n"
"    local fselect_type = get_opt('type', 'sql', 'string')\n"
"    if fselect_type == 'gh' or fselect_type == 'github' then\n"
"        fselect_type = 'markdown'\n"
"    end\n"
"    if fselect_type ~= 'sql' and fselect_type ~= 'markdown' and fselect_type ~= 'jira' then\n"
"        fselect_type = 'sql'\n"
"    end\n"
"    local columns = get_opt('columns', nil, 'table, string')\n"
"    local widths = get_opt('widths', {}, 'table')\n"
"    local default_max_width = 0\n"
"    if #widths > 0 then default_max_width = -1 end\n"
"    local max_width = get_opt('max_width', default_max_width, 'number')\n"
"    local use_print = get_opt('print', false, 'boolean')\n"
"    local use_nbsp = get_opt('use_nbsp', true, 'boolean')\n"
"    local min_col_width = 5\n"
"    local max_col_width = 1000\n"
"    if use_print then use_nbsp = false end\n"
"\n"
"    -- Convert comma separated columns into array, to numbers if possible\n"
"    if type(columns) == 'string' then\n"
"        columns = columns:split(',');\n"
"    end\n"
"    if columns then\n"
"        local res_columns = {}\n"
"        for _, str in ipairs(columns) do\n"
"            if tonumber(str) then\n"
"                table.insert(res_columns, tonumber(str))\n"
"            else\n"
"                table.insert(res_columns, str:strip())\n"
"            end\n"
"        end\n"
"        columns = res_columns\n"
"    end\n"
"\n"
"    -- Screen size autodetection.\n"
"    local function detect_width()\n"
"        local ffi = require('ffi')\n"
"        ffi.cdef('void tnt_rl_get_screen_size(int *rows, int *cols);')\n"
"        local colsp = ffi.new('int[1]')\n"
"        ffi.C.tnt_rl_get_screen_size(nil, colsp)\n"
"        return colsp[0]\n"
"    end\n"
"    if max_width == 0 then\n"
"        max_width = detect_width()\n"
"        -- YAML uses several additinal symbols in output, we should shink line.\n"
"        local waste_size = use_print and 0 or 5\n"
"        if max_width > waste_size then\n"
"            max_width = max_width - waste_size\n"
"        else\n"
"            max_width = fselect_type == 'sql' and 140 or 260\n"
"        end\n"
"    end\n"
"\n"
"    -- select and stringify.\n"
"    local tab = { }\n"
"    local json = require('json')\n"
"    for _, t in index:pairs(key, opts) do\n"
"        local row = { }\n"
"        if columns then\n"
"            for _, c in ipairs(columns) do\n"
"                table.insert(row, json.encode(t[c]))\n"
"            end\n"
"        else\n"
"            for _, f in t:pairs() do\n"
"                table.insert(row, json.encode(f))\n"
"            end\n"
"        end\n"
"        table.insert(tab, row)\n"
"    end\n"
"    local num_rows = #tab\n"
"    local num_cols = 1\n"
"    for i = 1, num_rows do\n"
"        num_cols = math.max(num_cols, #tab[i])\n"
"    end\n"
"\n"
"    -- The JSON encoder above passes through invalid UTF-8 characters untouched.\n"
"    -- Replace such strings with the <binary> tag.\n"
"    for j = 1,num_cols do\n"
"        for i = 1,num_rows do\n"
"            if tab[i][j] then\n"
"                local _, err = utf8.len(tab[i][j])\n"
"                if err then\n"
"                    tab[i][j] = '<binary>'\n"
"                end\n"
"            end\n"
"        end\n"
"    end\n"
"\n"
"    local fmt = box.space[index.space_id]:format()\n"
"    local names = {}\n"
"    if columns then\n"
"        for _, c in ipairs(columns) do\n"
"            if type(c) == 'string' then\n"
"                table.insert(names, c)\n"
"            elseif fmt[c] then\n"
"                table.insert(names, fmt[c].name)\n"
"            else\n"
"                table.insert(names, 'col' .. tostring(c))\n"
"            end\n"
"        end\n"
"    else\n"
"        num_cols = math.max(num_cols, #fmt)\n"
"        for c = 1, num_cols do\n"
"            table.insert(names, fmt[c] and fmt[c].name or 'col' .. tostring(c))\n"
"        end\n"
"    end\n"
"\n"
"    local real_width = num_cols + 1 -- including '|' symbols\n"
"    for j = 1,num_cols do\n"
"        if type(widths[j]) ~= 'number' then\n"
"            local width = utf8.len(names[j])\n"
"            if fselect_type == 'jira' then\n"
"                width = width + 1\n"
"            end\n"
"            for i = 1,num_rows do\n"
"                if tab[i][j] then\n"
"                    width = math.max(width, utf8.len(tab[i][j]))\n"
"                end\n"
"            end\n"
"            widths[j] = width\n"
"        end\n"
"        widths[j] = math.max(widths[j], min_col_width)\n"
"        widths[j] = math.min(widths[j], max_col_width)\n"
"        real_width = real_width + widths[j]\n"
"    end\n"
"\n"
"    -- cut some columns if its width is too big\n"
"    while max_width > 0 and real_width > max_width do\n"
"        local max_j = 1\n"
"        for j = 2,num_cols do\n"
"            if widths[j] >= widths[max_j] then max_j = j end\n"
"        end\n"
"        widths[max_j] = widths[max_j] - 1\n"
"        real_width = real_width - 1\n"
"    end\n"
"\n"
"    local header_row_delim = fselect_type == 'jira' and '||' or '|'\n"
"    local result_row_delim = '|'\n"
"    local delim_row_delim = fselect_type == 'sql' and '+' or '|'\n"
"\n"
"    local delim_row = delim_row_delim\n"
"    for j = 1,num_cols do\n"
"        delim_row = delim_row .. string.rep('-', widths[j]) .. delim_row_delim\n"
"    end\n"
"\n"
"    -- format string - cut or fill with spaces to make is exactly n symbols.\n"
"    -- also replace spaces with non-break spaces.\n"
"    local fmt_str = function(x, n)\n"
"        if not x then x = '' end\n"
"        local str\n"
"        local x_len = utf8.len(x)\n"
"        if x_len <= n then\n"
"            local add = n - x_len\n"
"            local addl = math.floor(add/2)\n"
"            local addr = math.ceil(add/2)\n"
"            str = string.rep(' ', addl) .. x .. string.rep(' ', addr)\n"
"        else\n"
"            str = x:sub(1, n)\n"
"        end\n"
"        return str\n"
"    end\n"
"\n"
"    local res = {}\n"
"\n"
"    -- insert into res a string with formatted row.\n"
"    local res_insert = function(row, is_header)\n"
"        local delim = is_header and header_row_delim or result_row_delim\n"
"        local str_row = delim\n"
"        local shrink = fselect_type == 'jira' and is_header and 1 or 0\n"
"        for j = 1,num_cols do\n"
"            str_row = str_row .. fmt_str(row[j], widths[j] - shrink) .. delim\n"
"        end\n"
"        table.insert(res, str_row)\n"
"    end\n"
"\n"
"    -- format result\n"
"    if fselect_type == 'sql' then\n"
"        table.insert(res, delim_row)\n"
"    end\n"
"    res_insert(names, true)\n"
"    if fselect_type ~= 'jira' then\n"
"        table.insert(res, delim_row)\n"
"    end\n"
"    for i = 1,num_rows do\n"
"        res_insert(tab[i], false)\n"
"    end\n"
"    if fselect_type == 'sql' then\n"
"        table.insert(res, delim_row)\n"
"    end\n"
"    if use_print then\n"
"        for _,line in ipairs(res) do\n"
"            print(line)\n"
"        end\n"
"        return {}\n"
"    end\n"
"    if use_nbsp then\n"
"        -- Hack that prevents YAML encoder from quoting output string.\n"
"        for i,line in ipairs(res) do\n"
"            line = line:gsub(' ', '\\u{00a0}')\n"
"            line = line:gsub('|', '\\u{01c0}')\n"
"            res[i] = line\n"
"        end\n"
"    end\n"
"    return res\n"
"end\n"
"base_index_mt.gselect = function(index, key, opts, fselect_opts)\n"
"    if type(fselect_opts) ~= 'table' then fselect_opts = {} end\n"
"    fselect_opts['type'] = 'gh'\n"
"    return base_index_mt.fselect(index, key, opts, fselect_opts)\n"
"end\n"
"base_index_mt.jselect = function(index, key, opts, fselect_opts)\n"
"    if type(fselect_opts) ~= 'table' then fselect_opts = {} end\n"
"    fselect_opts['type'] = 'jira'\n"
"    return base_index_mt.fselect(index, key, opts, fselect_opts)\n"
"end\n"
"-- Lua 5.2 compatibility\n"
"base_index_mt.__len = base_index_mt.len\n"
"-- min and max\n"
"base_index_mt.min_ffi = function(index, key)\n"
"    if builtin.box_read_ffi_is_disabled then\n"
"        return base_index_mt.min_luac(index, key)\n"
"    end\n"
"    check_index_arg(index, 'min')\n"
"    local ibuf = cord_ibuf_take()\n"
"    local pkey, pkey_end = tuple_encode(ibuf, key)\n"
"    local nok = builtin.box_index_min(index.space_id, index.id, pkey, pkey_end,\n"
"                                      ptuple) ~= 0\n"
"    cord_ibuf_put(ibuf)\n"
"    if nok then\n"
"        box.error() -- error\n"
"    elseif ptuple[0] ~= nil then\n"
"        return tuple_bless(ptuple[0])\n"
"    else\n"
"        return\n"
"    end\n"
"end\n"
"base_index_mt.min_luac = function(index, key)\n"
"    check_index_arg(index, 'min')\n"
"    key = keify(key)\n"
"    return internal.min(index.space_id, index.id, key);\n"
"end\n"
"base_index_mt.max_ffi = function(index, key)\n"
"    if builtin.box_read_ffi_is_disabled then\n"
"        return base_index_mt.max_luac(index, key)\n"
"    end\n"
"    check_index_arg(index, 'max')\n"
"    local ibuf = cord_ibuf_take()\n"
"    local pkey, pkey_end = tuple_encode(ibuf, key)\n"
"    local nok = builtin.box_index_max(index.space_id, index.id, pkey, pkey_end,\n"
"                                      ptuple) ~= 0\n"
"    cord_ibuf_put(ibuf)\n"
"    if nok then\n"
"        box.error() -- error\n"
"    elseif ptuple[0] ~= nil then\n"
"        return tuple_bless(ptuple[0])\n"
"    else\n"
"        return\n"
"    end\n"
"end\n"
"base_index_mt.max_luac = function(index, key)\n"
"    check_index_arg(index, 'max')\n"
"    key = keify(key)\n"
"    return internal.max(index.space_id, index.id, key);\n"
"end\n"
"base_index_mt.random_ffi = function(index, rnd)\n"
"    if builtin.box_read_ffi_is_disabled then\n"
"        return base_index_mt.random_luac(index, rnd)\n"
"    end\n"
"    check_index_arg(index, 'random')\n"
"    rnd = rnd or math.random()\n"
"    if builtin.box_index_random(index.space_id, index.id, rnd,\n"
"                                ptuple) ~= 0 then\n"
"        box.error() -- error\n"
"    elseif ptuple[0] ~= nil then\n"
"        return tuple_bless(ptuple[0])\n"
"    else\n"
"        return\n"
"    end\n"
"end\n"
"base_index_mt.random_luac = function(index, rnd)\n"
"    check_index_arg(index, 'random')\n"
"    rnd = rnd or math.random()\n"
"    return internal.random(index.space_id, index.id, rnd);\n"
"end\n"
"-- iteration\n"
"base_index_mt.pairs_ffi = function(index, key, opts)\n"
"    check_index_arg(index, 'pairs')\n"
"    local ibuf = cord_ibuf_take()\n"
"    local pkey, pkey_end = tuple_encode(ibuf, key)\n"
"    local svp = builtin.box_region_used()\n"
"    local itype, after = check_pairs_opts(opts, pkey + 1 >= pkey_end)\n"
"    normalize_position(index, after, iterator_pos, iterator_pos_end)\n"
"\n"
"    local keybuf = ffi.string(pkey, pkey_end - pkey)\n"
"    cord_ibuf_put(ibuf)\n"
"    local pkeybuf = ffi.cast('const char *', keybuf)\n"
"    local cdata = builtin.box_index_iterator_after(index.space_id, index.id,\n"
"        itype, pkeybuf, pkeybuf + #keybuf, iterator_pos[0], iterator_pos_end[0]);\n"
"    builtin.box_region_truncate(svp)\n"
"    if cdata == nil then\n"
"        box.error()\n"
"    end\n"
"    return fun.wrap(iterator_gen, keybuf,\n"
"        ffi.gc(cdata, builtin.box_iterator_free))\n"
"end\n"
"base_index_mt.pairs_luac = function(index, key, opts)\n"
"    check_index_arg(index, 'pairs')\n"
"    key = keify(key)\n"
"    local itype, after = check_pairs_opts(opts, #key == 0)\n"
"    local keymp = msgpack.encode(key)\n"
"    local keybuf = ffi.string(keymp, #keymp)\n"
"    local cdata = internal.iterator(index.space_id, index.id, itype, keymp,\n"
"        after);\n"
"    return fun.wrap(iterator_gen_luac, keybuf,\n"
"        ffi.gc(cdata, builtin.box_iterator_free))\n"
"end\n"
"\n"
"-- index subtree size\n"
"base_index_mt.count_ffi = function(index, key, opts)\n"
"    check_index_arg(index, 'count')\n"
"    local ibuf = cord_ibuf_take()\n"
"    local pkey, pkey_end = tuple_encode(ibuf, key)\n"
"    local itype = check_iterator_type(opts, pkey + 1 >= pkey_end);\n"
"    local count = builtin.box_index_count(index.space_id, index.id,\n"
"        itype, pkey, pkey_end);\n"
"    cord_ibuf_put(ibuf)\n"
"    if count == -1 then\n"
"        box.error()\n"
"    end\n"
"    return tonumber(count)\n"
"end\n"
"base_index_mt.count_luac = function(index, key, opts)\n"
"    check_index_arg(index, 'count')\n"
"    key = keify(key)\n"
"    local itype = check_iterator_type(opts, #key == 0);\n"
"    return internal.count(index.space_id, index.id, itype, key);\n"
"end\n"
"\n"
"base_index_mt.get_ffi = function(index, key)\n"
"    if builtin.box_read_ffi_is_disabled then\n"
"        return base_index_mt.get_luac(index, key)\n"
"    end\n"
"    check_index_arg(index, 'get')\n"
"    local ibuf = cord_ibuf_take()\n"
"    local key, key_end = tuple_encode(ibuf, key)\n"
"    local nok = builtin.box_index_get(index.space_id, index.id, key, key_end,\n"
"                                      ptuple) ~= 0\n"
"    cord_ibuf_put(ibuf)\n"
"    if nok then\n"
"        return box.error() -- error\n"
"    elseif ptuple[0] ~= nil then\n"
"        return tuple_bless(ptuple[0])\n"
"    else\n"
"        return\n"
"    end\n"
"end\n"
"base_index_mt.get_luac = function(index, key)\n"
"    check_index_arg(index, 'get')\n"
"    key = keify(key)\n"
"    return internal.get(index.space_id, index.id, key)\n"
"end\n"
"\n"
"local function check_select_opts(opts, key_is_nil)\n"
"    local offset = 0\n"
"    local limit = 4294967295\n"
"    local iterator = check_iterator_type(opts, key_is_nil)\n"
"    local fullscan = false\n"
"    local after = nil\n"
"    local fetch_pos = false\n"
"    if opts ~= nil and type(opts) == \"table\" then\n"
"        if opts.offset ~= nil then\n"
"            offset = opts.offset\n"
"        end\n"
"        if opts.limit ~= nil then\n"
"            limit = opts.limit\n"
"        end\n"
"        if opts.fullscan ~= nil then\n"
"            fullscan = opts.fullscan\n"
"        end\n"
"        if opts.after ~= nil then\n"
"            after = opts.after\n"
"            if type(after) ~= \"string\" and type(after) ~= \"table\" and\n"
"                    not is_tuple(after) then\n"
"                box.error(box.error.ITERATOR_POSITION)\n"
"            end\n"
"        end\n"
"        if opts.fetch_pos ~= nil then\n"
"            fetch_pos = opts.fetch_pos\n"
"        end\n"
"    end\n"
"    return iterator, offset, limit, fullscan, after, fetch_pos\n"
"end\n"
"\n"
"box.internal.check_select_opts = check_select_opts -- for net.box\n"
"\n"
"local function is_select_long(sid, key_is_nil, itype, limit, offset,\n"
"                                   fullscan)\n"
"    local point_iter = itype == box.index.EQ or itype == box.index.REQ\n"
"    local window = offset + limit\n"
"    return sid >= 512 and\n"
"           (key_is_nil or not point_iter) and\n"
"           (not fullscan and window > 1000)\n"
"end\n"
"\n"
"box.internal.is_select_long = is_select_long -- for read views\n"
"\n"
"local log_long_select_rl = log.internal.ratelimit.new()\n"
"local function log_long_select(space)\n"
"    log_long_select_rl:log_crit(\n"
"        \"Potentially long select from space '%s' (%d)\\n %s\",\n"
"        space.name, space.id, debug.traceback())\n"
"end\n"
"\n"
"base_index_mt.select_ffi = function(index, key, opts)\n"
"    if builtin.box_read_ffi_is_disabled then\n"
"        return base_index_mt.select_luac(index, key, opts)\n"
"    end\n"
"    local nok\n"
"    check_index_arg(index, 'select')\n"
"    local ibuf = cord_ibuf_take()\n"
"    local key, key_end = tuple_encode(ibuf, key)\n"
"    local key_is_nil = key + 1 >= key_end\n"
"    local new_position = nil\n"
"    local iterator, offset, limit, fullscan, after, fetch_pos =\n"
"        check_select_opts(opts, key_is_nil)\n"
"    local sid = index.space_id\n"
"    if is_select_long(sid, key_is_nil, iterator, limit, offset,\n"
"                      fullscan) then\n"
"        log_long_select(box.space[sid])\n"
"    end\n"
"    local region_svp = builtin.box_region_used()\n"
"    normalize_position(index, after, iterator_pos, iterator_pos_end)\n"
"    nok = builtin.box_select_ffi(sid, index.id, key, key_end,\n"
"                                 iterator_pos, iterator_pos_end, fetch_pos,\n"
"                                 port, iterator, offset, limit) ~= 0\n"
"    if not nok and fetch_pos and iterator_pos[0] ~= nil then\n"
"        new_position = ffi.string(iterator_pos[0],\n"
"                                  iterator_pos_end[0] - iterator_pos[0])\n"
"    end\n"
"    builtin.box_region_truncate(region_svp)\n"
"    cord_ibuf_put(ibuf)\n"
"    if nok then\n"
"        return box.error()\n"
"    end\n"
"\n"
"    local ret = {}\n"
"    local entry = port_c.first\n"
"    for i=1,tonumber(port_c.size),1 do\n"
"        ret[i] = tuple_bless(entry.tuple)\n"
"        entry = entry.next\n"
"    end\n"
"    builtin.port_destroy(port);\n"
"    if fetch_pos then\n"
"        return ret, new_position\n"
"    end\n"
"    return ret\n"
"end\n"
"\n"
"base_index_mt.select_luac = function(index, key, opts)\n"
"    check_index_arg(index, 'select')\n"
"    local key = keify(key)\n"
"    local key_is_nil = #key == 0\n"
"    local iterator, offset, limit, fullscan, after, fetch_pos =\n"
"        check_select_opts(opts, key_is_nil)\n"
"    local sid = index.space_id\n"
"    if is_select_long(sid, key_is_nil, iterator, limit, offset,\n"
"                      fullscan) then\n"
"        log_long_select(box.space[sid])\n"
"    end\n"
"    return internal.select(sid, index.id, iterator,\n"
"        offset, limit, key, after, fetch_pos)\n"
"end\n"
"\n"
"base_index_mt.update = function(index, key, ops)\n"
"    check_index_arg(index, 'update')\n"
"    return internal.update(index.space_id, index.id, keify(key), ops);\n"
"end\n"
"base_index_mt.delete = function(index, key)\n"
"    check_index_arg(index, 'delete')\n"
"    return internal.delete(index.space_id, index.id, keify(key));\n"
"end\n"
"\n"
"base_index_mt.stat = function(index)\n"
"    return internal.stat(index.space_id, index.id);\n"
"end\n"
"\n"
"base_index_mt.compact = function(index)\n"
"    return internal.compact(index.space_id, index.id)\n"
"end\n"
"\n"
"base_index_mt.drop = function(index)\n"
"    check_index_arg(index, 'drop')\n"
"    return box.schema.index.drop(index.space_id, index.id)\n"
"end\n"
"base_index_mt.rename = function(index, name)\n"
"    check_index_arg(index, 'rename')\n"
"    return box.schema.index.rename(index.space_id, index.id, name)\n"
"end\n"
"base_index_mt.alter = function(index, options)\n"
"    check_index_arg(index, 'alter')\n"
"    if index.id == nil or index.space_id == nil then\n"
"        box.error(box.error.PROC_LUA, \"Usage: index:alter{opts}\")\n"
"    end\n"
"    return box.schema.index.alter(index.space_id, index.id, options)\n"
"end\n"
"base_index_mt.tuple_pos = function(index, tuple)\n"
"    check_index_arg(index, 'tuple_pos')\n"
"    if not tuple then\n"
"        box.error(box.error.PROC_LUA, \"Usage index:tuple_pos(tuple)\")\n"
"    end\n"
"    local region_svp = builtin.box_region_used()\n"
"    local ibuf = cord_ibuf_take()\n"
"    local data, data_end = tuple_encode(ibuf, tuple)\n"
"    local nok = builtin.box_index_tuple_position(index.space_id, index.id,\n"
"                                                 data, data_end, iterator_pos,\n"
"                                                 iterator_pos_end) ~= 0\n"
"    cord_ibuf_put(ibuf)\n"
"    if nok then\n"
"        box.error()\n"
"    end\n"
"    local ret = ffi.string(iterator_pos[0],\n"
"                           iterator_pos_end[0] - iterator_pos[0])\n"
"    builtin.box_region_truncate(region_svp)\n"
"    return ret\n"
"end\n"
"\n"
"local read_ops = {'select', 'get', 'min', 'max', 'count', 'random', 'pairs'}\n"
"for _, op in ipairs(read_ops) do\n"
"    vinyl_index_mt[op] = base_index_mt[op..'_luac']\n"
"    memtx_index_mt[op] = base_index_mt[op..'_ffi']\n"
"end\n"
"-- Lua 5.2 compatibility\n"
"vinyl_index_mt.__pairs = vinyl_index_mt.pairs\n"
"vinyl_index_mt.__ipairs = vinyl_index_mt.pairs\n"
"memtx_index_mt.__pairs = memtx_index_mt.pairs\n"
"memtx_index_mt.__ipairs = memtx_index_mt.pairs\n"
"\n"
"local space_mt = {}\n"
"space_mt.len = function(space)\n"
"    check_space_arg(space, 'len')\n"
"    local pk = space.index[0]\n"
"    if pk == nil then\n"
"        return 0 -- empty space without indexes, return 0\n"
"    end\n"
"    return space.index[0]:len()\n"
"end\n"
"space_mt.count = function(space, key, opts)\n"
"    check_space_arg(space, 'count')\n"
"    local pk = space.index[0]\n"
"    if pk == nil then\n"
"        return 0 -- empty space without indexes, return 0\n"
"    end\n"
"    return pk:count(key, opts)\n"
"end\n"
"space_mt.bsize = function(space)\n"
"    check_space_arg(space, 'bsize')\n"
"    local s = builtin.space_by_id(space.id)\n"
"    if s == nil then\n"
"        box.error(box.error.NO_SUCH_SPACE, space.name)\n"
"    end\n"
"    return builtin.space_bsize(s)\n"
"end\n"
"\n"
"space_mt.get = function(space, key)\n"
"    check_space_arg(space, 'get')\n"
"    return check_primary_index(space):get(key)\n"
"end\n"
"space_mt.select = function(space, key, opts)\n"
"    check_space_arg(space, 'select')\n"
"    return check_primary_index(space):select(key, opts)\n"
"end\n"
"space_mt.fselect = function(space, key, opts, fselect_opts)\n"
"    check_space_arg(space, 'select')\n"
"    return check_primary_index(space):fselect(key, opts, fselect_opts)\n"
"end\n"
"space_mt.gselect = function(space, key, opts, fselect_opts)\n"
"    check_space_arg(space, 'select')\n"
"    return check_primary_index(space):gselect(key, opts, fselect_opts)\n"
"end\n"
"space_mt.jselect = function(space, key, opts, fselect_opts)\n"
"    check_space_arg(space, 'select')\n"
"    return check_primary_index(space):jselect(key, opts, fselect_opts)\n"
"end\n"
"space_mt.insert = function(space, tuple)\n"
"    check_space_arg(space, 'insert')\n"
"    return internal.insert(space.id, tuple);\n"
"end\n"
"space_mt.replace = function(space, tuple)\n"
"    check_space_arg(space, 'replace')\n"
"    return internal.replace(space.id, tuple);\n"
"end\n"
"space_mt.put = space_mt.replace; -- put is an alias for replace\n"
"space_mt.update = function(space, key, ops)\n"
"    check_space_arg(space, 'update')\n"
"    return check_primary_index(space):update(key, ops)\n"
"end\n"
"space_mt.upsert = function(space, tuple_key, ops, deprecated)\n"
"    check_space_arg(space, 'upsert')\n"
"    if deprecated ~= nil then\n"
"        local msg = \"Error: extra argument in upsert call: \"\n"
"        msg = msg .. tostring(deprecated)\n"
"        msg = msg .. \". Usage :upsert(tuple, operations)\"\n"
"        box.error(box.error.PROC_LUA, msg)\n"
"    end\n"
"    return internal.upsert(space.id, tuple_key, ops);\n"
"end\n"
"space_mt.delete = function(space, key)\n"
"    check_space_arg(space, 'delete')\n"
"    return check_primary_index(space):delete(key)\n"
"end\n"
"-- Assumes that spaceno has a TREE (NUM) primary key\n"
"-- inserts a tuple after getting the next value of the\n"
"-- primary key and returns it back to the user\n"
"space_mt.auto_increment = function(space, tuple)\n"
"    check_space_arg(space, 'auto_increment')\n"
"    local max_tuple = check_primary_index(space):max()\n"
"    local max = 0\n"
"    if max_tuple ~= nil then\n"
"        max = max_tuple[1]\n"
"    end\n"
"    table.insert(tuple, 1, max + 1)\n"
"    return space:insert(tuple)\n"
"end\n"
"space_mt.pairs = function(space, key, opts)\n"
"    check_space_arg(space, 'pairs')\n"
"    local pk = space.index[0]\n"
"    if pk == nil then\n"
"        -- empty space without indexes, return empty iterator\n"
"        return fun.iter({})\n"
"    end\n"
"    return pk:pairs(key, opts)\n"
"end\n"
"space_mt.__pairs = space_mt.pairs -- Lua 5.2 compatibility\n"
"space_mt.__ipairs = space_mt.pairs -- Lua 5.2 compatibility\n"
"space_mt.truncate = function(space)\n"
"    check_space_arg(space, 'truncate')\n"
"    return internal.truncate(space.id)\n"
"end\n"
"space_mt.format = function(space, format)\n"
"    check_space_arg(space, 'format')\n"
"    return box.schema.space.format(space.id, format)\n"
"end\n"
"space_mt.upgrade = function(space, ...)\n"
"    check_space_arg(space, 'upgrade')\n"
"    return box.schema.space.upgrade(space.id, ...)\n"
"end\n"
"space_mt.drop = function(space)\n"
"    check_space_arg(space, 'drop')\n"
"    check_space_exists(space)\n"
"    return box.schema.space.drop(space.id, space.name)\n"
"end\n"
"space_mt.rename = function(space, name)\n"
"    check_space_arg(space, 'rename')\n"
"    check_space_exists(space)\n"
"    return box.schema.space.rename(space.id, name)\n"
"end\n"
"space_mt.alter = function(space, options)\n"
"    check_space_arg(space, 'alter')\n"
"    check_space_exists(space)\n"
"    return box.schema.space.alter(space.id, options)\n"
"end\n"
"space_mt.create_index = function(space, name, options)\n"
"    check_space_arg(space, 'create_index')\n"
"    check_space_exists(space)\n"
"    return box.schema.index.create(space.id, name, options)\n"
"end\n"
"space_mt.run_triggers = function(space, yesno)\n"
"    check_space_arg(space, 'run_triggers')\n"
"    local s = builtin.space_by_id(space.id)\n"
"    if s == nil then\n"
"        box.error(box.error.NO_SUCH_SPACE, space.name)\n"
"    end\n"
"    builtin.space_run_triggers(s, yesno)\n"
"end\n"
"space_mt.frommap = box.internal.space.frommap\n"
"space_mt.__index = space_mt\n"
"\n"
"box.schema.index_mt = base_index_mt\n"
"box.schema.memtx_index_mt = memtx_index_mt\n"
"box.schema.vinyl_index_mt = vinyl_index_mt\n"
"box.schema.space_mt = space_mt\n"
"\n"
"--\n"
"-- Wrap a global space/index metatable into a space/index local\n"
"-- one. Routinely this metatable just indexes the global one. When\n"
"-- a user attempts to extend a space or index methods via local\n"
"-- space/index metatable instead of from box.schema mt, the local\n"
"-- metatable is transformed. Its __index metamethod starts looking\n"
"-- up at first in self, and only then into the global mt.\n"
"--\n"
"local function wrap_schema_object_mt(name)\n"
"    local global_mt = box.schema[name]\n"
"    local mt = {\n"
"        __index = global_mt,\n"
"        __ipairs = global_mt.__ipairs,\n"
"        __pairs = global_mt.__pairs\n"
"    }\n"
"    local mt_mt = {}\n"
"    mt_mt.__newindex = function(self, k, v)\n"
"        mt_mt.__newindex = nil\n"
"        mt.__index = function(self, k)\n"
"            return mt[k] or box.schema[name][k]\n"
"        end\n"
"        rawset(mt, k, v)\n"
"    end\n"
"    setmetatable(mt, mt_mt)\n"
"    return mt\n"
"end\n"
"\n"
"function box.schema.space.bless(space)\n"
"    local index_mt_name\n"
"    if space.engine == 'vinyl' then\n"
"        index_mt_name = 'vinyl_index_mt'\n"
"    else\n"
"        index_mt_name = 'memtx_index_mt'\n"
"    end\n"
"    local space_mt = wrap_schema_object_mt('space_mt')\n"
"\n"
"    setmetatable(space, space_mt)\n"
"    if type(space.index) == 'table' and space.enabled then\n"
"        for j, index in pairs(space.index) do\n"
"            if type(j) == 'number' then\n"
"                setmetatable(index, wrap_schema_object_mt(index_mt_name))\n"
"            end\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local sequence_mt = {}\n"
"sequence_mt.__index = sequence_mt\n"
"\n"
"sequence_mt.next = function(self)\n"
"    return internal.sequence.next(self.id)\n"
"end\n"
"\n"
"sequence_mt.current = function(self)\n"
"    local ai64 = ffi.new('int64_t[1]')\n"
"    local rc = builtin.box_sequence_current(self.id, ai64)\n"
"    if rc < 0 then\n"
"        box.error(box.error.last())\n"
"    end\n"
"    return ai64[0]\n"
"end\n"
"\n"
"sequence_mt.set = function(self, value)\n"
"    return internal.sequence.set(self.id, value)\n"
"end\n"
"\n"
"sequence_mt.reset = function(self)\n"
"    return internal.sequence.reset(self.id)\n"
"end\n"
"\n"
"sequence_mt.alter = function(self, opts)\n"
"    box.schema.sequence.alter(self.id, opts)\n"
"end\n"
"\n"
"sequence_mt.drop = function(self)\n"
"    box.schema.sequence.drop(self.id)\n"
"end\n"
"\n"
"box.sequence = {}\n"
"box.schema.sequence = {}\n"
"\n"
"function box.schema.sequence.bless(seq)\n"
"    setmetatable(seq, {__index = sequence_mt})\n"
"end\n"
"\n"
"local sequence_options = {\n"
"    step = 'number',\n"
"    min = 'number',\n"
"    max = 'number',\n"
"    start = 'number',\n"
"    cache = 'number',\n"
"    cycle = 'boolean',\n"
"}\n"
"\n"
"local create_sequence_options = table.deepcopy(sequence_options)\n"
"create_sequence_options.if_not_exists = 'boolean'\n"
"\n"
"local alter_sequence_options = table.deepcopy(sequence_options)\n"
"alter_sequence_options.name = 'string'\n"
"\n"
"box.schema.sequence.create = function(name, opts)\n"
"    opts = opts or {}\n"
"    check_param(name, 'name', 'string')\n"
"    check_param_table(opts, create_sequence_options)\n"
"    local ascending = not opts.step or opts.step > 0\n"
"    local options_defaults = {\n"
"        step = 1,\n"
"        min = ascending and 1 or INT64_MIN,\n"
"        max = ascending and INT64_MAX or -1,\n"
"        start = ascending and (opts.min or 1) or (opts.max or -1),\n"
"        cache = 0,\n"
"        cycle = false,\n"
"    }\n"
"    opts = update_param_table(opts, options_defaults)\n"
"    local id = sequence_resolve(name)\n"
"    if id ~= nil then\n"
"        if not opts.if_not_exists then\n"
"            box.error(box.error.SEQUENCE_EXISTS, name)\n"
"        end\n"
"        return box.sequence[name], 'not created'\n"
"    end\n"
"    local _sequence = box.space[box.schema.SEQUENCE_ID]\n"
"    _sequence:auto_increment{session.euid(), name, opts.step, opts.min,\n"
"                             opts.max, opts.start, opts.cache, opts.cycle}\n"
"    return box.sequence[name]\n"
"end\n"
"\n"
"box.schema.sequence.alter = function(name, opts)\n"
"    check_param_table(opts, alter_sequence_options)\n"
"    local id, tuple = sequence_resolve(name)\n"
"    if id == nil then\n"
"        box.error(box.error.NO_SUCH_SEQUENCE, name)\n"
"    end\n"
"    if opts == nil then\n"
"        return\n"
"    end\n"
"    local seq = {}\n"
"    seq.id, seq.uid, seq.name, seq.step, seq.min, seq.max,\n"
"        seq.start, seq.cache, seq.cycle = tuple:unpack()\n"
"    opts = update_param_table(opts, seq)\n"
"    local _sequence = box.space[box.schema.SEQUENCE_ID]\n"
"    _sequence:replace{seq.id, seq.uid, opts.name, opts.step, opts.min,\n"
"                      opts.max, opts.start, opts.cache, opts.cycle}\n"
"end\n"
"\n"
"box.schema.sequence.drop = function(name, opts)\n"
"    opts = opts or {}\n"
"    check_param_table(opts, {if_exists = 'boolean'})\n"
"    local id = sequence_resolve(name)\n"
"    if id == nil then\n"
"        if not opts.if_exists then\n"
"            box.error(box.error.NO_SUCH_SEQUENCE, name)\n"
"        end\n"
"        return\n"
"    end\n"
"    revoke_object_privs('sequence', id)\n"
"    local _sequence = box.space[box.schema.SEQUENCE_ID]\n"
"    local _sequence_data = box.space[box.schema.SEQUENCE_DATA_ID]\n"
"    _sequence_data:delete{id}\n"
"    _sequence:delete{id}\n"
"end\n"
"\n"
"local function privilege_parse(privs)\n"
"    -- TODO: introduce a global privilege -> bit mapping\?\n"
"    local privs_map = {\n"
"        read      = box.priv.R,\n"
"        write     = box.priv.W,\n"
"        execute   = box.priv.X,\n"
"        session   = box.priv.S,\n"
"        usage     = box.priv.U,\n"
"        create    = box.priv.C,\n"
"        drop      = box.priv.D,\n"
"        alter     = box.priv.A,\n"
"        reference = box.priv.REFERENECE,\n"
"        trigger   = box.priv.TRIGGER,\n"
"        insert    = box.priv.INSERT,\n"
"        update    = box.priv.UPDATE,\n"
"        delete    = box.priv.DELETE\n"
"    }\n"
"    local privs_cp = string.lower(privs):gsub('^[%A]*', '')\n"
"\n"
"    local mask = 0\n"
"    -- TODO: prove correctness formally (e.g. via a FSA)\?\n"
"    repeat\n"
"        local matched = false\n"
"        -- TODO: replace this with one group pattern when Lua patterns start\n"
"        -- supporting disjunction (e.g. '|')\n"
"        for priv, bit in pairs(privs_map) do\n"
"            privs_cp = string.gsub(privs_cp, '^' .. priv .. '[%A]*',\n"
"                                   function()\n"
"                                       matched = true\n"
"                                       mask = mask + bit\n"
"                                       privs_map[priv] = 0\n"
"                                       return ''\n"
"                                   end)\n"
"        end\n"
"    until (not matched)\n"
"\n"
"    if privs_cp ~= '' then\n"
"        mask = 0\n"
"    end\n"
"\n"
"    return mask\n"
"end\n"
"\n"
"local function privilege_resolve(privs)\n"
"    if type(privs) == 'string' then\n"
"        return privilege_parse(privs)\n"
"    elseif type(privs) == 'number' then -- TODO: assert type(privs)\?\n"
"        return privs\n"
"    end\n"
"    return 0\n"
"end\n"
"\n"
"-- allowed combination of privilege bits for object\n"
"local priv_object_combo = {\n"
"    [\"universe\"] = box.priv.ALL,\n"
"-- sic: we allow to grant 'execute' on space. This is a legacy\n"
"-- bug, please fix it in 2.0\n"
"    [\"space\"]    = bit.bxor(box.priv.ALL, box.priv.S,\n"
"                            box.priv.REVOKE, box.priv.GRANT),\n"
"    [\"sequence\"] = bit.bor(box.priv.R, box.priv.W, box.priv.U,\n"
"                           box.priv.C, box.priv.A, box.priv.D),\n"
"    [\"function\"] = bit.bor(box.priv.X, box.priv.U,\n"
"                           box.priv.C, box.priv.D),\n"
"    [\"role\"]     = bit.bor(box.priv.X, box.priv.U,\n"
"                           box.priv.C, box.priv.D),\n"
"    [\"user\"]     = bit.bor(box.priv.C, box.priv.A,\n"
"                           box.priv.D),\n"
"}\n"
"\n"
"--\n"
"-- Resolve privilege hex by name and check\n"
"-- that bits are allowed for this object type\n"
"--\n"
"local function privilege_check(privilege, object_type)\n"
"    local priv_hex = privilege_resolve(privilege)\n"
"    if priv_object_combo[object_type] == nil then\n"
"        box.error(box.error.UNKNOWN_SCHEMA_OBJECT, object_type)\n"
"    elseif type(priv_hex) ~= 'number' or priv_hex == 0 or\n"
"           bit.band(priv_hex, priv_object_combo[object_type] or 0) ~= priv_hex then\n"
"        box.error(box.error.UNSUPPORTED_PRIV, object_type, privilege)\n"
"    end\n"
"    return priv_hex\n"
"end\n"
"\n"
"local function privilege_name(privilege)\n"
"    local names = {}\n"
"    if bit.band(privilege, box.priv.R) ~= 0 then\n"
"        table.insert(names, \"read\")\n"
"    end\n"
"    if bit.band(privilege, box.priv.W) ~= 0 then\n"
"        table.insert(names, \"write\")\n"
"    end\n"
"    if bit.band(privilege, box.priv.X) ~= 0 then\n"
"        table.insert(names, \"execute\")\n"
"    end\n"
"    if bit.band(privilege, box.priv.S) ~= 0 then\n"
"        table.insert(names, \"session\")\n"
"    end\n"
"    if bit.band(privilege, box.priv.U) ~= 0 then\n"
"        table.insert(names, \"usage\")\n"
"    end\n"
"    if bit.band(privilege, box.priv.C) ~= 0 then\n"
"        table.insert(names, \"create\")\n"
"    end\n"
"    if bit.band(privilege, box.priv.D) ~= 0 then\n"
"        table.insert(names, \"drop\")\n"
"    end\n"
"    if bit.band(privilege, box.priv.A) ~= 0 then\n"
"        table.insert(names, \"alter\")\n"
"    end\n"
"    if bit.band(privilege, box.priv.REFERENCE) ~= 0 then\n"
"        table.insert(names, \"reference\")\n"
"    end\n"
"    if bit.band(privilege, box.priv.TRIGGER) ~= 0 then\n"
"        table.insert(names, \"trigger\")\n"
"    end\n"
"    if bit.band(privilege, box.priv.INSERT) ~= 0 then\n"
"        table.insert(names, \"insert\")\n"
"    end\n"
"    if bit.band(privilege, box.priv.UPDATE) ~= 0 then\n"
"        table.insert(names, \"update\")\n"
"    end\n"
"    if bit.band(privilege, box.priv.DELETE) ~= 0 then\n"
"        table.insert(names, \"delete\")\n"
"    end\n"
"    return table.concat(names, \",\")\n"
"end\n"
"\n"
"local function object_resolve(object_type, object_name)\n"
"    if object_name ~= nil and type(object_name) ~= 'string'\n"
"            and type(object_name) ~= 'number' then\n"
"        box.error(box.error.ILLEGAL_PARAMS, \"wrong object name type\")\n"
"    end\n"
"    if object_type == 'universe' then\n"
"        return 0\n"
"    end\n"
"    if object_type == 'space' then\n"
"        if object_name == '' then\n"
"            return ''\n"
"        end\n"
"        local space = box.space[object_name]\n"
"        if  space == nil then\n"
"            box.error(box.error.NO_SUCH_SPACE, object_name)\n"
"        end\n"
"        return space.id\n"
"    end\n"
"    if object_type == 'function' then\n"
"        if object_name == '' then\n"
"            return ''\n"
"        end\n"
"        local _vfunc = box.space[box.schema.VFUNC_ID]\n"
"        local func\n"
"        if type(object_name) == 'string' then\n"
"            func = _vfunc.index.name:get{object_name}\n"
"        else\n"
"            func = _vfunc:get{object_name}\n"
"        end\n"
"        if func then\n"
"            return func.id\n"
"        else\n"
"            box.error(box.error.NO_SUCH_FUNCTION, object_name)\n"
"        end\n"
"    end\n"
"    if object_type == 'sequence' then\n"
"        if object_name == '' then\n"
"            return ''\n"
"        end\n"
"        local seq = sequence_resolve(object_name)\n"
"        if seq == nil then\n"
"            box.error(box.error.NO_SUCH_SEQUENCE, object_name)\n"
"        end\n"
"        return seq\n"
"    end\n"
"    if object_type == 'role' or object_type == 'user' then\n"
"        if object_name == '' then\n"
"            return ''\n"
"        end\n"
"        local _vuser = box.space[box.schema.VUSER_ID]\n"
"        local role_or_user\n"
"        if type(object_name) == 'string' then\n"
"            role_or_user = _vuser.index.name:get{object_name}\n"
"        else\n"
"            role_or_user = _vuser:get{object_name}\n"
"        end\n"
"        if role_or_user and role_or_user.type == object_type then\n"
"            return role_or_user.id\n"
"        elseif object_type == 'role' then\n"
"            box.error(box.error.NO_SUCH_ROLE, object_name)\n"
"        else\n"
"            box.error(box.error.NO_SUCH_USER, object_name)\n"
"        end\n"
"    end\n"
"\n"
"    box.error(box.error.UNKNOWN_SCHEMA_OBJECT, object_type)\n"
"end\n"
"\n"
"local function object_name(object_type, object_id)\n"
"    if object_type == 'universe' or object_id == '' then\n"
"        return \"\"\n"
"    end\n"
"    local space\n"
"    if object_type == 'space' then\n"
"        space = box.space._vspace\n"
"    elseif object_type == 'sequence' then\n"
"        space = box.space._sequence\n"
"    elseif object_type == 'function' then\n"
"        space = box.space._vfunc\n"
"    elseif object_type == 'role' or object_type == 'user' then\n"
"        space = box.space._vuser\n"
"    else\n"
"        box.error(box.error.UNKNOWN_SCHEMA_OBJECT, object_type)\n"
"    end\n"
"    return space:get{object_id}.name\n"
"end\n"
"\n"
"box.schema.func = {}\n"
"box.schema.func.create = function(name, opts)\n"
"    opts = opts or {}\n"
"    check_param_table(opts, { setuid = 'boolean',\n"
"                              if_not_exists = 'boolean',\n"
"                              language = 'string', body = 'string',\n"
"                              is_deterministic = 'boolean',\n"
"                              is_sandboxed = 'boolean',\n"
"                              is_multikey = 'boolean', aggregate = 'string',\n"
"                              takes_raw_args = 'boolean',\n"
"                              comment = 'string',\n"
"                              param_list = 'table', returns = 'string',\n"
"                              exports = 'table', opts = 'table' })\n"
"    local _func = box.space[box.schema.FUNC_ID]\n"
"    local _vfunc = box.space[box.schema.VFUNC_ID]\n"
"    local func = _vfunc.index.name:get{name}\n"
"    if func then\n"
"        if not opts.if_not_exists then\n"
"            box.error(box.error.FUNCTION_EXISTS, name)\n"
"        end\n"
"        return\n"
"    end\n"
"    local datetime = os.date(\"%Y-%m-%d %H:%M:%S\")\n"
"    opts = update_param_table(opts, { setuid = false, language = 'lua',\n"
"                    body = '', routine_type = 'function', returns = 'any',\n"
"                    param_list = {}, aggregate = 'none', sql_data_access = 'none',\n"
"                    is_deterministic = false, is_sandboxed = false,\n"
"                    is_null_call = true, exports = {'LUA'}, opts = setmap{},\n"
"                    comment = '', created = datetime, last_altered = datetime})\n"
"    opts.language = string.upper(opts.language)\n"
"    opts.setuid = opts.setuid and 1 or 0\n"
"    if opts.is_multikey then\n"
"        opts.opts.is_multikey = opts.is_multikey\n"
"    end\n"
"    if opts.takes_raw_args then\n"
"        opts.opts.takes_raw_args = opts.takes_raw_args\n"
"    end\n"
"    _func:auto_increment{session.euid(), name, opts.setuid, opts.language,\n"
"                         opts.body, opts.routine_type, opts.param_list,\n"
"                         opts.returns, opts.aggregate, opts.sql_data_access,\n"
"                         opts.is_deterministic, opts.is_sandboxed,\n"
"                         opts.is_null_call, opts.exports, opts.opts,\n"
"                         opts.comment, opts.created, opts.last_altered}\n"
"end\n"
"\n"
"box.schema.func.drop = function(name, opts)\n"
"    opts = opts or {}\n"
"    check_param_table(opts, { if_exists = 'boolean' })\n"
"    local _func = box.space[box.schema.FUNC_ID]\n"
"    local _vfunc = box.space[box.schema.VFUNC_ID]\n"
"    local fid\n"
"    local tuple\n"
"    if type(name) == 'string' then\n"
"        tuple = _vfunc.index.name:get{name}\n"
"    else\n"
"        tuple = _vfunc:get{name}\n"
"    end\n"
"    if tuple then\n"
"        fid = tuple.id\n"
"    end\n"
"    if fid == nil then\n"
"        if not opts.if_exists then\n"
"            box.error(box.error.NO_SUCH_FUNCTION, name)\n"
"        end\n"
"        return\n"
"    end\n"
"    revoke_object_privs('function', fid)\n"
"    _func:delete{fid}\n"
"end\n"
"\n"
"function box.schema.func.exists(name_or_id)\n"
"    local _vfunc = box.space[box.schema.VFUNC_ID]\n"
"    local tuple = nil\n"
"    if type(name_or_id) == 'string' then\n"
"        tuple = _vfunc.index.name:get{name_or_id}\n"
"    elseif type(name_or_id) == 'number' then\n"
"        tuple = _vfunc:get{name_or_id}\n"
"    end\n"
"    return tuple ~= nil\n"
"end\n"
"\n"
"-- Helper function to check func:method() usage\n"
"local function check_func_arg(func, method)\n"
"    if type(func) ~= 'table' or func.name == nil then\n"
"        local fmt = 'Use func:%s(...) instead of func.%s(...)'\n"
"        error(string.format(fmt, method, method))\n"
"    end\n"
"end\n"
"\n"
"local func_mt = {}\n"
"\n"
"func_mt.drop = function(func, opts)\n"
"    check_func_arg(func, 'drop')\n"
"    box.schema.func.drop(func.name, opts)\n"
"end\n"
"\n"
"func_mt.call = function(func, args)\n"
"    check_func_arg(func, 'call')\n"
"    args = args or {}\n"
"    if type(args) ~= 'table' then\n"
"        error('Use func:call(table)')\n"
"    end\n"
"    return box.schema.func.call(func.name, unpack(args, 1, table.maxn(args)))\n"
"end\n"
"\n"
"function box.schema.func.bless(func)\n"
"    setmetatable(func, {__index = func_mt})\n"
"end\n"
"\n"
"box.schema.func.reload = internal.module_reload\n"
"box.schema.func.call = internal.func_call\n"
"\n"
"box.internal.collation = {}\n"
"box.internal.collation.create = function(name, coll_type, locale, opts)\n"
"    opts = opts or setmap{}\n"
"    if type(name) ~= 'string' then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"        \"name (first arg) must be a string\")\n"
"    end\n"
"    if type(coll_type) ~= 'string' then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"        \"type (second arg) must be a string\")\n"
"    end\n"
"    if type(locale) ~= 'string' then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"        \"locale (third arg) must be a string\")\n"
"    end\n"
"    if type(opts) ~= 'table' then\n"
"        box.error(box.error.ILLEGAL_PARAMS,\n"
"        \"options (fourth arg) must be a table or nil\")\n"
"    end\n"
"    local lua_opts = {if_not_exists = opts.if_not_exists }\n"
"    check_param_table(lua_opts, {if_not_exists = 'boolean'})\n"
"    opts.if_not_exists = nil\n"
"    local collation_defaults = {\n"
"        strength = \"tertiary\",\n"
"    }\n"
"    opts = update_param_table(opts, collation_defaults)\n"
"    opts = setmap(opts)\n"
"\n"
"    local _coll = box.space[box.schema.COLLATION_ID]\n"
"    if lua_opts.if_not_exists then\n"
"        local coll = _coll.index.name:get{name}\n"
"        if coll then\n"
"            return\n"
"        end\n"
"    end\n"
"    _coll:auto_increment{name, session.euid(), coll_type, locale, opts}\n"
"end\n"
"\n"
"box.internal.collation.drop = function(name, opts)\n"
"    opts = opts or {}\n"
"    check_param_table(opts, { if_exists = 'boolean' })\n"
"\n"
"    local _coll = box.space[box.schema.COLLATION_ID]\n"
"    if opts.if_exists then\n"
"        local coll = _coll.index.name:get{name}\n"
"        if not coll then\n"
"            return\n"
"        end\n"
"    end\n"
"    _coll.index.name:delete{name}\n"
"end\n"
"\n"
"box.internal.collation.exists = function(name)\n"
"    local _coll = box.space[box.schema.COLLATION_ID]\n"
"    local coll = _coll.index.name:get{name}\n"
"    return not not coll\n"
"end\n"
"\n"
"box.internal.collation.id_by_name = function(name)\n"
"    local _coll = box.space[box.schema.COLLATION_ID]\n"
"    local coll = _coll.index.name:get{name}\n"
"    return coll.id\n"
"end\n"
"\n"
"box.schema.user = {}\n"
"\n"
"box.schema.user.password = function(password)\n"
"    return internal.prepare_auth(box.cfg.auth_type, password)\n"
"end\n"
"\n"
"local function prepare_auth_list(password)\n"
"    return {\n"
"        [box.cfg.auth_type] = internal.prepare_auth(box.cfg.auth_type, password)\n"
"    }\n"
"end\n"
"\n"
"local function prepare_auth_history(uid)\n"
"    if internal.prepare_auth_history ~= nil then\n"
"        return internal.prepare_auth_history(uid)\n"
"    else\n"
"        return {}\n"
"    end\n"
"end\n"
"\n"
"local function check_password(password, auth_history)\n"
"    if internal.check_password ~= nil then\n"
"        internal.check_password(password, auth_history)\n"
"    end\n"
"end\n"
"\n"
"local function chpasswd(uid, new_password)\n"
"    local _user = box.space[box.schema.USER_ID]\n"
"    local auth_history = prepare_auth_history(uid)\n"
"    check_password(new_password, auth_history)\n"
"    _user:update({uid}, {{'=', 5, prepare_auth_list(new_password)},\n"
"                         {'=', 6, auth_history},\n"
"                         {'=', 7, math.floor(fiber.time())}})\n"
"end\n"
"\n"
"box.schema.user.passwd = function(name, new_password)\n"
"    if name == nil then\n"
"        box.error(box.error.PROC_LUA, \"Usage: box.schema.user.passwd([user,] password)\")\n"
"    end\n"
"    if new_password == nil then\n"
"        -- change password for current user\n"
"        new_password = name\n"
"        box.session.su('admin', chpasswd, session.uid(), new_password)\n"
"    else\n"
"        -- change password for other user\n"
"        local uid = user_resolve(name)\n"
"        if uid == nil then\n"
"            box.error(box.error.NO_SUCH_USER, name)\n"
"        end\n"
"        return chpasswd(uid, new_password)\n"
"    end\n"
"end\n"
"\n"
"box.schema.user.create = function(name, opts)\n"
"    local uid = user_or_role_resolve(name)\n"
"    opts = opts or {}\n"
"    check_param_table(opts, { password = 'string', if_not_exists = 'boolean' })\n"
"    if uid then\n"
"        if not opts.if_not_exists then\n"
"            box.error(box.error.USER_EXISTS, name)\n"
"        end\n"
"        return\n"
"    end\n"
"    local auth_list\n"
"    if opts.password then\n"
"        check_password(opts.password)\n"
"        auth_list = prepare_auth_list(opts.password)\n"
"    else\n"
"        auth_list = setmap({})\n"
"    end\n"
"    local _user = box.space[box.schema.USER_ID]\n"
"    uid = _user:auto_increment{session.euid(), name, 'user', auth_list, {},\n"
"                               math.floor(fiber.time())}.id\n"
"    -- grant role 'public' to the user\n"
"    box.schema.user.grant(uid, 'public')\n"
"    -- Grant privilege 'alter' on itself, so that it can\n"
"    -- change its password or username.\n"
"    box.schema.user.grant(uid, 'alter', 'user', uid)\n"
"    -- we have to grant global privileges from setuid function, since\n"
"    -- only admin has the ownership over universe and we don't have\n"
"    -- grant option\n"
"    box.session.su('admin', box.schema.user.grant, uid, 'session,usage', 'universe',\n"
"                   nil, {if_not_exists=true})\n"
"end\n"
"\n"
"box.schema.user.exists = function(name)\n"
"    if user_resolve(name) then\n"
"        return true\n"
"    else\n"
"        return false\n"
"    end\n"
"end\n"
"\n"
"local function grant(uid, name, privilege, object_type,\n"
"                     object_name, options)\n"
"    -- From user point of view, role is the same thing\n"
"    -- as a privilege. Allow syntax grant(user, role).\n"
"    if object_name == nil then\n"
"        if object_type == nil then\n"
"            -- sic: avoid recursion, to not bother with roles\n"
"            -- named 'execute'\n"
"            object_type = 'role'\n"
"            object_name = privilege\n"
"            privilege = 'execute'\n"
"        else\n"
"            -- Allow syntax grant(user, priv, entity)\n"
"            -- for entity grants.\n"
"            object_name = ''\n"
"        end\n"
"    end\n"
"    local privilege_hex = privilege_check(privilege, object_type)\n"
"\n"
"    local oid = object_resolve(object_type, object_name)\n"
"    options = options or {}\n"
"    if options.grantor == nil then\n"
"        options.grantor = session.euid()\n"
"    else\n"
"        options.grantor = user_or_role_resolve(options.grantor)\n"
"    end\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    local _vpriv = box.space[box.schema.VPRIV_ID]\n"
"    -- add the granted privilege to the current set\n"
"    local tuple = _vpriv:get{uid, object_type, oid}\n"
"    local old_privilege\n"
"    if tuple ~= nil then\n"
"        old_privilege = tuple.privilege\n"
"    else\n"
"        old_privilege = 0\n"
"    end\n"
"    privilege_hex = bit.bor(privilege_hex, old_privilege)\n"
"    privilege_hex = tonumber(ffi.cast('uint32_t', privilege_hex))\n"
"    -- do not execute a replace if it does not change anything\n"
"    -- XXX bug if we decide to add a grant option: new grantor\n"
"    -- replaces the old one, old grantor is lost\n"
"    if privilege_hex ~= old_privilege then\n"
"        _priv:replace{options.grantor, uid, object_type, oid, privilege_hex}\n"
"    elseif not options.if_not_exists then\n"
"            if object_type == 'role' and object_name ~= '' and\n"
"               privilege == 'execute' then\n"
"                box.error(box.error.ROLE_GRANTED, name, object_name)\n"
"            else\n"
"                if object_type ~= 'universe' then\n"
"                    object_name = string.format(\" '%s'\", object_name)\n"
"                end\n"
"                box.error(box.error.PRIV_GRANTED, name, privilege,\n"
"                          object_type, object_name)\n"
"            end\n"
"    end\n"
"end\n"
"\n"
"local function revoke(uid, name, privilege, object_type, object_name, options)\n"
"    -- From user point of view, role is the same thing\n"
"    -- as a privilege. Allow syntax revoke(user, role).\n"
"    if object_name == nil then\n"
"        if object_type == nil then\n"
"            object_type = 'role'\n"
"            object_name = privilege\n"
"            privilege = 'execute'\n"
"        else\n"
"            -- Allow syntax revoke(user, privilege, entity)\n"
"            -- to revoke entity privileges.\n"
"            object_name = ''\n"
"        end\n"
"    end\n"
"    local privilege_hex = privilege_check(privilege, object_type)\n"
"    options = options or {}\n"
"    local oid = object_resolve(object_type, object_name)\n"
"    local _priv = box.space[box.schema.PRIV_ID]\n"
"    local _vpriv = box.space[box.schema.VPRIV_ID]\n"
"    local tuple = _vpriv:get{uid, object_type, oid}\n"
"    -- system privileges of admin and guest can't be revoked\n"
"    if tuple == nil then\n"
"        if options.if_exists then\n"
"            return\n"
"        end\n"
"        if object_type == 'role' and object_name ~= '' and\n"
"           privilege == 'execute' then\n"
"            box.error(box.error.ROLE_NOT_GRANTED, name, object_name)\n"
"        else\n"
"            box.error(box.error.PRIV_NOT_GRANTED, name, privilege,\n"
"                      object_type, object_name)\n"
"        end\n"
"    end\n"
"    local old_privilege = tuple.privilege\n"
"    local grantor = tuple.grantor\n"
"    -- sic:\n"
"    -- a user may revoke more than he/she granted\n"
"    -- (erroneous user input)\n"
"    --\n"
"    privilege_hex = bit.band(old_privilege, bit.bnot(privilege_hex))\n"
"    -- give an error if we're not revoking anything\n"
"    if privilege_hex == old_privilege then\n"
"        if options.if_exists then\n"
"            return\n"
"        end\n"
"        box.error(box.error.PRIV_NOT_GRANTED, name, privilege,\n"
"                  object_type, object_name)\n"
"    end\n"
"    if privilege_hex ~= 0 then\n"
"        _priv:replace{grantor, uid, object_type, oid, privilege_hex}\n"
"    else\n"
"        _priv:delete{uid, object_type, oid}\n"
"    end\n"
"end\n"
"\n"
"local function drop(uid)\n"
"    -- recursive delete of user data\n"
"    local _vpriv = box.space[box.schema.VPRIV_ID]\n"
"    local spaces = box.space[box.schema.VSPACE_ID].index.owner:select{uid}\n"
"    for _, tuple in pairs(spaces) do\n"
"        box.space[tuple.id]:drop()\n"
"    end\n"
"    local funcs = box.space[box.schema.VFUNC_ID].index.owner:select{uid}\n"
"    for _, tuple in pairs(funcs) do\n"
"        box.schema.func.drop(tuple.id)\n"
"    end\n"
"    -- if this is a role, revoke this role from whoever it was granted to\n"
"    local grants = _vpriv.index.object:select{'role', uid}\n"
"    for _, tuple in pairs(grants) do\n"
"        revoke(tuple.grantee, tuple.grantee, uid)\n"
"    end\n"
"    local sequences = box.space[box.schema.VSEQUENCE_ID].index.owner:select{uid}\n"
"    for _, tuple in pairs(sequences) do\n"
"        box.schema.sequence.drop(tuple.id)\n"
"    end\n"
"    -- xxx: hack, we have to revoke session and usage privileges\n"
"    -- of a user using a setuid function in absence of create/drop\n"
"    -- privileges and grant option\n"
"    if box.space._vuser:get{uid}.type == 'user' then\n"
"        box.session.su('admin', box.schema.user.revoke, uid,\n"
"                       'session,usage', 'universe', nil, {if_exists = true})\n"
"    end\n"
"    local privs = _vpriv.index.primary:select{uid}\n"
"\n"
"    for _, tuple in pairs(privs) do\n"
"        -- we need an additional box.session.su() here, because of\n"
"        -- unnecessary check for privilege PRIV_REVOKE in priv_def_check()\n"
"        box.session.su(\"admin\", revoke, uid, uid, tuple.privilege,\n"
"                       tuple.object_type, tuple.object_id)\n"
"    end\n"
"    box.space[box.schema.USER_ID]:delete{uid}\n"
"end\n"
"\n"
"box.schema.user.grant = function(user_name, ...)\n"
"    local uid = user_resolve(user_name)\n"
"    if uid == nil then\n"
"        box.error(box.error.NO_SUCH_USER, user_name)\n"
"    end\n"
"    return grant(uid, user_name, ...)\n"
"end\n"
"\n"
"box.schema.user.revoke = function(user_name, ...)\n"
"    local uid = user_resolve(user_name)\n"
"    if uid == nil then\n"
"        box.error(box.error.NO_SUCH_USER, user_name)\n"
"    end\n"
"    return revoke(uid, user_name, ...)\n"
"end\n"
"\n"
"box.schema.user.enable = function(user)\n"
"    box.schema.user.grant(user, \"session,usage\", \"universe\", nil,\n"
"                            {if_not_exists = true})\n"
"end\n"
"\n"
"box.schema.user.disable = function(user)\n"
"    box.schema.user.revoke(user, \"session,usage\", \"universe\", nil,\n"
"                            {if_exists = true})\n"
"end\n"
"\n"
"box.schema.user.drop = function(name, opts)\n"
"    opts = opts or {}\n"
"    check_param_table(opts, { if_exists = 'boolean' })\n"
"    local uid = user_resolve(name)\n"
"    if uid ~= nil then\n"
"        if uid >= box.schema.SYSTEM_USER_ID_MIN and\n"
"           uid <= box.schema.SYSTEM_USER_ID_MAX then\n"
"            -- gh-1205: box.schema.user.info fails\n"
"            box.error(box.error.DROP_USER, name,\n"
"                      \"the user or the role is a system\")\n"
"        end\n"
"        if uid == box.session.uid() or uid == box.session.euid() then\n"
"            box.error(box.error.DROP_USER, name,\n"
"                      \"the user is active in the current session\")\n"
"        end\n"
"        return drop(uid)\n"
"    end\n"
"    if not opts.if_exists then\n"
"        box.error(box.error.NO_SUCH_USER, name)\n"
"    end\n"
"    return\n"
"end\n"
"\n"
"local function info(id)\n"
"    local _priv = box.space._vpriv\n"
"    local privs = {}\n"
"    for _, v in pairs(_priv:select{id}) do\n"
"        table.insert(\n"
"            privs,\n"
"            {privilege_name(v.privilege), v.object_type,\n"
"             object_name(v.object_type, v.object_id)}\n"
"        )\n"
"    end\n"
"    return privs\n"
"end\n"
"\n"
"box.schema.user.info = function(user_name)\n"
"    local uid\n"
"    if user_name == nil then\n"
"        uid = box.session.euid()\n"
"    else\n"
"        uid = user_resolve(user_name)\n"
"        if uid == nil then\n"
"            box.error(box.error.NO_SUCH_USER, user_name)\n"
"        end\n"
"    end\n"
"    return info(uid)\n"
"end\n"
"\n"
"box.schema.role = {}\n"
"\n"
"box.schema.role.exists = function(name)\n"
"    if role_resolve(name) then\n"
"        return true\n"
"    else\n"
"        return false\n"
"    end\n"
"end\n"
"\n"
"box.schema.role.create = function(name, opts)\n"
"    opts = opts or {}\n"
"    check_param_table(opts, { if_not_exists = 'boolean' })\n"
"    local uid = user_or_role_resolve(name)\n"
"    if uid then\n"
"        if not opts.if_not_exists then\n"
"            box.error(box.error.ROLE_EXISTS, name)\n"
"        end\n"
"        return\n"
"    end\n"
"    local _user = box.space[box.schema.USER_ID]\n"
"    _user:auto_increment{session.euid(), name, 'role', setmap({}), {},\n"
"                         math.floor(fiber.time())}\n"
"end\n"
"\n"
"box.schema.role.drop = function(name, opts)\n"
"    opts = opts or {}\n"
"    check_param_table(opts, { if_exists = 'boolean' })\n"
"    local uid = role_resolve(name)\n"
"    if uid == nil then\n"
"        if not opts.if_exists then\n"
"            box.error(box.error.NO_SUCH_ROLE, name)\n"
"        end\n"
"        return\n"
"    end\n"
"    if uid >= box.schema.SYSTEM_USER_ID_MIN and\n"
"       uid <= box.schema.SYSTEM_USER_ID_MAX or uid == box.schema.SUPER_ROLE_ID then\n"
"        -- gh-1205: box.schema.user.info fails\n"
"        box.error(box.error.DROP_USER, name, \"the user or the role is a system\")\n"
"    end\n"
"    return drop(uid)\n"
"end\n"
"\n"
"local function role_check_grant_revoke_of_sys_priv(priv)\n"
"    priv = string.lower(priv)\n"
"    if (type(priv) == 'string' and (priv:match(\"session\") or priv:match(\"usage\"))) or\n"
"        (type(priv) == \"number\" and (bit.band(priv, 8) ~= 0 or bit.band(priv, 16) ~= 0)) then\n"
"        box.error(box.error.GRANT, \"system privilege can not be granted to role\")\n"
"    end\n"
"end\n"
"\n"
"box.schema.role.grant = function(user_name, ...)\n"
"    local uid = role_resolve(user_name)\n"
"    if uid == nil then\n"
"        box.error(box.error.NO_SUCH_ROLE, user_name)\n"
"    end\n"
"    role_check_grant_revoke_of_sys_priv(...)\n"
"    return grant(uid, user_name, ...)\n"
"end\n"
"box.schema.role.revoke = function(user_name, ...)\n"
"    local uid = role_resolve(user_name)\n"
"    if uid == nil then\n"
"        box.error(box.error.NO_SUCH_ROLE, user_name)\n"
"    end\n"
"    role_check_grant_revoke_of_sys_priv(...)\n"
"    return revoke(uid, user_name, ...)\n"
"end\n"
"box.schema.role.info = function(role_name)\n"
"    local rid = role_resolve(role_name)\n"
"    if rid == nil then\n"
"        box.error(box.error.NO_SUCH_ROLE, role_name)\n"
"    end\n"
"    return info(rid)\n"
"end\n"
"\n"
"--\n"
"-- once\n"
"--\n"
"box.once = function(key, func, ...)\n"
"    if type(key) ~= 'string' or type(func) ~= 'function' then\n"
"        box.error(box.error.ILLEGAL_PARAMS, \"Usage: box.once(key, func, ...)\")\n"
"    end\n"
"\n"
"    local key = \"once\"..key\n"
"    if box.space._schema:get{key} ~= nil then\n"
"        return\n"
"    end\n"
"    box.ctl.wait_rw()\n"
"    box.space._schema:put{key}\n"
"    return func(...)\n"
"end\n"
"\n"
"--\n"
"-- nice output when typing box.space in admin console\n"
"--\n"
"box.space = {}\n"
"\n"
"local function box_space_mt(tab)\n"
"    local t = {}\n"
"    for k,v in pairs(tab) do\n"
"        -- skip system spaces and views\n"
"        if type(k) == 'string' and #k > 0 and k:sub(1,1) ~= '_' then\n"
"            t[k] = {\n"
"                engine = v.engine,\n"
"                is_local = v.is_local,\n"
"                temporary = v.temporary,\n"
"                is_sync = v.is_sync,\n"
"            }\n"
"        end\n"
"    end\n"
"    return t\n"
"end\n"
"\n"
"setmetatable(box.space, { __serialize = box_space_mt })\n"
"\n"
"local function check_read_view_arg(rv, method)\n"
"    if type(rv) ~= 'table' then\n"
"        local fmt = 'Use read_view:%s(...) instead of read_view.%s(...)'\n"
"        error(string.format(fmt, method, method), 3)\n"
"    end\n"
"end\n"
"\n"
"local read_view_methods = {}\n"
"\n"
"--\n"
"-- Returns a read view info table:\n"
"--  - 'id' - unique read view identifier.\n"
"--  - 'name' - read view name.\n"
"--  - 'is_system' - true if the read view is used for system purposes.\n"
"--  - 'timestamp' - fiber.clock() at the time of read view open.\n"
"--  - 'vclock' - box.info.vclock at the time of read view open.\n"
"--  - 'signature' - box.info.signature at the time of read view open.\n"
"--  - 'status' - 'open' or 'closed'.\n"
"--\n"
"function read_view_methods:info()\n"
"    check_read_view_arg(self, 'info')\n"
"    return {\n"
"        id = self.id,\n"
"        name = self.name,\n"
"        is_system = self.is_system,\n"
"        timestamp = self.timestamp,\n"
"        vclock = self.vclock,\n"
"        signature = self.signature,\n"
"        status = self.status,\n"
"    }\n"
"end\n"
"\n"
"--\n"
"-- Function stub. Implemented in Tarantool EE.\n"
"--\n"
"function box.internal.read_view_close()\n"
"    error('read view is busy', 3)\n"
"end\n"
"\n"
"--\n"
"-- Closes a read view.\n"
"--\n"
"function read_view_methods:close()\n"
"    check_read_view_arg(self, 'close')\n"
"    if self.status == 'closed' then\n"
"        error('read view is closed', 2)\n"
"    end\n"
"    box.internal.read_view_close(self)\n"
"end\n"
"\n"
"local read_view_properties = {\n"
"    -- System read views are closed asynchronously so we have to query\n"
"    -- the status.\n"
"    status = box.internal.read_view_status,\n"
"}\n"
"\n"
"local read_view_mt = {\n"
"    __index = function(self, key)\n"
"        if rawget(self, key) ~= nil then\n"
"            return rawget(self, key)\n"
"        elseif read_view_properties[key] ~= nil then\n"
"            return read_view_properties[key](self)\n"
"        elseif read_view_methods[key] ~= nil then\n"
"            return read_view_methods[key]\n"
"        end\n"
"    end,\n"
"    __autocomplete = function(self)\n"
"        -- Make sure that everything that can be returned by __index is\n"
"        -- auto-completed in console. Replace property callbacks with scalars\n"
"        -- so that they are auto-completed as data members, not as methods.\n"
"        return fun.tomap(fun.chain(fun.map(function(k) return k, true end,\n"
"                                           fun.iter(read_view_properties)),\n"
"                                   fun.iter(read_view_methods)))\n"
"    end,\n"
"    __serialize = read_view_methods.info,\n"
"}\n"
"\n"
"box.read_view = {}\n"
"\n"
"--\n"
"-- Function stub. Implemented in Tarantool EE.\n"
"--\n"
"function box.read_view.open()\n"
"    box.error(box.error.UNSUPPORTED, \"Community edition\", \"read view\")\n"
"end\n"
"\n"
"--\n"
"-- Table of open read views: id -> read view object.\n"
"--\n"
"-- We use weak ref, because we don't want to pin a read view object after\n"
"-- the user drops the last reference to it.\n"
"--\n"
"local read_view_registry = setmetatable({}, {__mode = 'v'})\n"
"\n"
"--\n"
"-- Sets a metatable for a new read view object and adds it to the registry so\n"
"-- that it can be returned by box.read_view_list().\n"
"--\n"
"-- Used in the Tarantool EE source code.\n"
"--\n"
"function box.internal.read_view_register(rv)\n"
"    assert(rv.id ~= nil)\n"
"    assert(read_view_registry[rv.id] == nil)\n"
"    assert(getmetatable(rv) == nil)\n"
"    setmetatable(rv, read_view_mt)\n"
"    read_view_registry[rv.id] = rv\n"
"    return rv\n"
"end\n"
"\n"
"--\n"
"-- Returns an array of all open read views sorted by id, ascending.\n"
"--\n"
"-- Since read view ids grow incrementally and never wrap around,\n"
"-- the most recent read view will always be last.\n"
"--\n"
"function box.read_view.list()\n"
"    local list = {}\n"
"    for _, rv in ipairs(internal.read_view_list()) do\n"
"        local registered_rv = read_view_registry[rv.id]\n"
"        if registered_rv == nil then\n"
"            -- This is a new read view object that hasn't been used from Lua\n"
"            -- yet. Add it to the registry for the next listing to return the\n"
"            -- same object.\n"
"            registered_rv = box.internal.read_view_register(rv)\n"
"        end\n"
"        table.insert(list, registered_rv)\n"
"    end\n"
"    table.sort(list, function(rv1, rv2) return rv1.id < rv2.id end)\n"
"    return list\n"
"end\n"
"\n"
"box.NULL = msgpack.NULL\n"
""
;
