/* timer.c generated by valac 0.56.17, the Vala compiler
 * generated from timer.vala, do not modify */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <time.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define PDFPC_TYPE_TIMER (pdfpc_timer_get_type ())
#define PDFPC_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_TYPE_TIMER, pdfpcTimer))
#define PDFPC_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_TYPE_TIMER, pdfpcTimerClass))
#define PDFPC_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_TYPE_TIMER))
#define PDFPC_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_TYPE_TIMER))
#define PDFPC_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_TYPE_TIMER, pdfpcTimerClass))

typedef struct _pdfpcTimer pdfpcTimer;
typedef struct _pdfpcTimerClass pdfpcTimerClass;
typedef struct _pdfpcTimerPrivate pdfpcTimerPrivate;
typedef enum  {
	PDFPC_TIMER_STATE_Stopped,
	PDFPC_TIMER_STATE_PreTalk,
	PDFPC_TIMER_STATE_Running,
	PDFPC_TIMER_STATE_Paused
} pdfpcTimerState;

#define PDFPC_TIMER_TYPE_STATE (pdfpc_timer_state_get_type ())
typedef enum  {
	PDFPC_TIMER_MODE_Clock,
	PDFPC_TIMER_MODE_CountUp,
	PDFPC_TIMER_MODE_CountDown
} pdfpcTimerMode;

#define PDFPC_TIMER_TYPE_MODE (pdfpc_timer_mode_get_type ())
enum  {
	PDFPC_TIMER_0_PROPERTY,
	PDFPC_TIMER_DURATION_PROPERTY,
	PDFPC_TIMER_NUM_PROPERTIES
};
static GParamSpec* pdfpc_timer_properties[PDFPC_TIMER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	PDFPC_TIMER_CHANGE_SIGNAL,
	PDFPC_TIMER_NUM_SIGNALS
};
static guint pdfpc_timer_signals[PDFPC_TIMER_NUM_SIGNALS] = {0};

struct _pdfpcTimer {
	GObject parent_instance;
	pdfpcTimerPrivate * priv;
	time_t intended_start_time;
	time_t start_time;
	pdfpcTimerState state;
	pdfpcTimerMode mode;
	time_t now;
	gint running_time;
};

struct _pdfpcTimerClass {
	GObjectClass parent_class;
};

struct _pdfpcTimerPrivate {
	gint _duration;
};

static gint pdfpcTimer_private_offset;
static gpointer pdfpc_timer_parent_class = NULL;

VALA_EXTERN time_t pdfpc_parse_time (const gchar* t);
VALA_EXTERN GType pdfpc_timer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcTimer, g_object_unref)
VALA_EXTERN GType pdfpc_timer_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pdfpc_timer_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN pdfpcTimer* pdfpc_timer_new (gint duration,
                             const gchar* start_time_str,
                             const gchar* end_time_str);
VALA_EXTERN pdfpcTimer* pdfpc_timer_construct (GType object_type,
                                   gint duration,
                                   const gchar* start_time_str,
                                   const gchar* end_time_str);
VALA_EXTERN void pdfpc_timer_set_duration (pdfpcTimer* self,
                               gint value);
VALA_EXTERN gint pdfpc_timer_get_duration (pdfpcTimer* self);
VALA_EXTERN gboolean pdfpc_timer_on_timeout (pdfpcTimer* self);
static gboolean _pdfpc_timer_on_timeout_gsource_func (gpointer self);
VALA_EXTERN pdfpcTimerMode pdfpc_timer_get_mode (pdfpcTimer* self);
VALA_EXTERN gboolean pdfpc_timer_set_mode (pdfpcTimer* self,
                               pdfpcTimerMode new_mode);
VALA_EXTERN void pdfpc_timer_update (pdfpcTimer* self);
VALA_EXTERN void pdfpc_timer_cycle_mode (pdfpcTimer* self);
VALA_EXTERN void pdfpc_timer_start (pdfpcTimer* self);
VALA_EXTERN void pdfpc_timer_run (pdfpcTimer* self);
VALA_EXTERN gboolean pdfpc_timer_toggle_pause (pdfpcTimer* self);
VALA_EXTERN gboolean pdfpc_timer_is_paused (pdfpcTimer* self);
VALA_EXTERN void pdfpc_timer_reset (pdfpcTimer* self);
VALA_EXTERN gboolean pdfpc_timer_is_running (pdfpcTimer* self);
static void g_cclosure_user_marshal_VOID__INT_ENUM_STRING (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static void pdfpc_timer_finalize (GObject * obj);
static GType pdfpc_timer_get_type_once (void);
static void _vala_pdfpc_timer_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_pdfpc_timer_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
     * Auxiliary function to parse time string, returning Unix time
     */
time_t
pdfpc_parse_time (const gchar* t)
{
	gint hours = 0;
	gint minutes = 0;
	GDateTime* dt_now = NULL;
	GTimeZone* _tmp0_;
	GTimeZone* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gint hours_now = 0;
	GDateTime* _tmp4_;
	gint minutes_now = 0;
	GDateTime* _tmp5_;
	gint seconds_now = 0;
	GDateTime* _tmp6_;
	gint diff_minutes = 0;
	GDateTime* dt = NULL;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	time_t result;
	g_return_val_if_fail (t != NULL, 0);
	hours = 0;
	minutes = 0;
	sscanf (t, "%d:%d", &hours, &minutes);
	_tmp0_ = g_time_zone_new_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_new_now (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_time_zone_unref0 (_tmp1_);
	dt_now = _tmp3_;
	_tmp4_ = dt_now;
	hours_now = g_date_time_get_hour (_tmp4_);
	_tmp5_ = dt_now;
	minutes_now = g_date_time_get_minute (_tmp5_);
	_tmp6_ = dt_now;
	seconds_now = g_date_time_get_second (_tmp6_);
	diff_minutes = (60 * (hours - hours_now)) + (minutes - minutes_now);
	if (diff_minutes < 0) {
		diff_minutes += 60 * 24;
	}
	_tmp7_ = dt_now;
	_tmp8_ = g_date_time_add_minutes (_tmp7_, diff_minutes);
	dt = _tmp8_;
	_tmp9_ = dt;
	_tmp10_ = g_date_time_add_seconds (_tmp9_, (gdouble) (-seconds_now));
	_g_date_time_unref0 (dt);
	dt = _tmp10_;
	_tmp11_ = dt;
	result = (time_t) g_date_time_to_unix (_tmp11_);
	_g_date_time_unref0 (dt);
	_g_date_time_unref0 (dt_now);
	return result;
}

static inline gpointer
pdfpc_timer_get_instance_private (pdfpcTimer* self)
{
	return G_STRUCT_MEMBER_P (self, pdfpcTimer_private_offset);
}

/**
         * Display mode
         */
static GType
pdfpc_timer_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{PDFPC_TIMER_MODE_Clock, "PDFPC_TIMER_MODE_Clock", "clock"}, {PDFPC_TIMER_MODE_CountUp, "PDFPC_TIMER_MODE_CountUp", "countup"}, {PDFPC_TIMER_MODE_CountDown, "PDFPC_TIMER_MODE_CountDown", "countdown"}, {0, NULL, NULL}};
	GType pdfpc_timer_mode_type_id;
	pdfpc_timer_mode_type_id = g_enum_register_static ("pdfpcTimerMode", values);
	return pdfpc_timer_mode_type_id;
}

GType
pdfpc_timer_mode_get_type (void)
{
	static volatile gsize pdfpc_timer_mode_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_timer_mode_type_id__once)) {
		GType pdfpc_timer_mode_type_id;
		pdfpc_timer_mode_type_id = pdfpc_timer_mode_get_type_once ();
		g_once_init_leave (&pdfpc_timer_mode_type_id__once, pdfpc_timer_mode_type_id);
	}
	return pdfpc_timer_mode_type_id__once;
}

/**
         * Operational state
         */
static GType
pdfpc_timer_state_get_type_once (void)
{
	static const GEnumValue values[] = {{PDFPC_TIMER_STATE_Stopped, "PDFPC_TIMER_STATE_Stopped", "stopped"}, {PDFPC_TIMER_STATE_PreTalk, "PDFPC_TIMER_STATE_PreTalk", "pretalk"}, {PDFPC_TIMER_STATE_Running, "PDFPC_TIMER_STATE_Running", "running"}, {PDFPC_TIMER_STATE_Paused, "PDFPC_TIMER_STATE_Paused", "paused"}, {0, NULL, NULL}};
	GType pdfpc_timer_state_type_id;
	pdfpc_timer_state_type_id = g_enum_register_static ("pdfpcTimerState", values);
	return pdfpc_timer_state_type_id;
}

GType
pdfpc_timer_state_get_type (void)
{
	static volatile gsize pdfpc_timer_state_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_timer_state_type_id__once)) {
		GType pdfpc_timer_state_type_id;
		pdfpc_timer_state_type_id = pdfpc_timer_state_get_type_once ();
		g_once_init_leave (&pdfpc_timer_state_type_id__once, pdfpc_timer_state_type_id);
	}
	return pdfpc_timer_state_type_id__once;
}

/**
         * Constructor
         */
static gboolean
_pdfpc_timer_on_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = pdfpc_timer_on_timeout ((pdfpcTimer*) self);
	return result;
}

pdfpcTimer*
pdfpc_timer_construct (GType object_type,
                       gint duration,
                       const gchar* start_time_str,
                       const gchar* end_time_str)
{
	pdfpcTimer * self = NULL;
	time_t intended_end_time = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	time_t _tmp2_;
	gboolean _tmp3_ = FALSE;
	gint _tmp5_;
	self = (pdfpcTimer*) g_object_new (object_type, NULL);
	intended_end_time = (time_t) 0;
	if (start_time_str != NULL) {
		_tmp1_ = end_time_str != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = duration > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_printerr ("Start and stop times given, duration is ignored\n");
	}
	pdfpc_timer_set_duration (self, duration);
	_tmp2_ = time (NULL);
	self->now = _tmp2_;
	if (start_time_str != NULL) {
		self->intended_start_time = pdfpc_parse_time (start_time_str);
	}
	if (end_time_str != NULL) {
		intended_end_time = pdfpc_parse_time (end_time_str);
	}
	if (self->intended_start_time > ((time_t) 0)) {
		_tmp3_ = intended_end_time > ((time_t) 0);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		if (self->intended_start_time >= intended_end_time) {
			intended_end_time += (time_t) (24 * 3600);
		}
		pdfpc_timer_set_duration (self, (gint) (intended_end_time - self->intended_start_time));
	} else {
		gboolean _tmp4_ = FALSE;
		if (intended_end_time > ((time_t) 0)) {
			_tmp4_ = duration > 0;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			self->intended_start_time = intended_end_time - duration;
		}
	}
	if (self->intended_start_time > ((time_t) 0)) {
		self->state = PDFPC_TIMER_STATE_PreTalk;
	}
	_tmp5_ = self->priv->_duration;
	if (_tmp5_ > 0) {
		self->mode = PDFPC_TIMER_MODE_CountDown;
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _pdfpc_timer_on_timeout_gsource_func, g_object_ref (self), g_object_unref);
	return self;
}

pdfpcTimer*
pdfpc_timer_new (gint duration,
                 const gchar* start_time_str,
                 const gchar* end_time_str)
{
	return pdfpc_timer_construct (PDFPC_TYPE_TIMER, duration, start_time_str, end_time_str);
}

/**
         * Get mode
         */
pdfpcTimerMode
pdfpc_timer_get_mode (pdfpcTimer* self)
{
	pdfpcTimerMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->mode;
	return result;
}

/**
         * Set mode, returning true/false on success/failure.
         * If the mode changes, update the view.
         */
gboolean
pdfpc_timer_set_mode (pdfpcTimer* self,
                      pdfpcTimerMode new_mode)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (new_mode == PDFPC_TIMER_MODE_CountDown) {
		gint _tmp1_;
		_tmp1_ = self->priv->_duration;
		_tmp0_ = _tmp1_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (self->mode != new_mode) {
		self->mode = new_mode;
		pdfpc_timer_update (self);
	}
	result = TRUE;
	return result;
}

/**
         * Cycle the mode (count up/count down/current time)
         */
void
pdfpc_timer_cycle_mode (pdfpcTimer* self)
{
	g_return_if_fail (self != NULL);
	switch (self->mode) {
		case PDFPC_TIMER_MODE_Clock:
		{
			pdfpc_timer_set_mode (self, PDFPC_TIMER_MODE_CountUp);
			break;
		}
		case PDFPC_TIMER_MODE_CountUp:
		{
			if (pdfpc_timer_set_mode (self, PDFPC_TIMER_MODE_CountDown) != TRUE) {
				pdfpc_timer_set_mode (self, PDFPC_TIMER_MODE_Clock);
			}
			break;
		}
		case PDFPC_TIMER_MODE_CountDown:
		{
			pdfpc_timer_set_mode (self, PDFPC_TIMER_MODE_Clock);
			break;
		}
		default:
		break;
	}
}

/**
         * Start the timer
         */
void
pdfpc_timer_start (pdfpcTimer* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->state != PDFPC_TIMER_STATE_Stopped) {
		_tmp0_ = self->state != PDFPC_TIMER_STATE_PreTalk;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	self->start_time = self->now;
	self->state = PDFPC_TIMER_STATE_Running;
}

/**
         * Start or continue running
         */
void
pdfpc_timer_run (pdfpcTimer* self)
{
	g_return_if_fail (self != NULL);
	switch (self->state) {
		case PDFPC_TIMER_STATE_Stopped:
		case PDFPC_TIMER_STATE_PreTalk:
		{
			pdfpc_timer_start (self);
			break;
		}
		case PDFPC_TIMER_STATE_Running:
		{
			break;
		}
		default:
		{
			self->start_time = self->now - self->running_time;
			self->state = PDFPC_TIMER_STATE_Running;
			break;
		}
	}
}

/**
         * Toggle the pause mode. Return true if the timer is paused.
         */
gboolean
pdfpc_timer_toggle_pause (pdfpcTimer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	switch (self->state) {
		case PDFPC_TIMER_STATE_Paused:
		{
			pdfpc_timer_run (self);
			break;
		}
		case PDFPC_TIMER_STATE_Running:
		{
			self->state = PDFPC_TIMER_STATE_Paused;
			break;
		}
		default:
		{
			break;
		}
	}
	result = pdfpc_timer_is_paused (self);
	return result;
}

/**
         * Reset the timer to its initial value
         *
         * Furthermore the stop state will be restored
         * If the countdown is running the countdown value is recalculated. The
         * timer is not stopped in such situation.
         *
         * In presentation mode the time will be reset to the initial
         * presentation time.
         */
void
pdfpc_timer_reset (pdfpcTimer* self)
{
	g_return_if_fail (self != NULL);
	if (self->state == PDFPC_TIMER_STATE_PreTalk) {
		return;
	}
	if (self->intended_start_time > ((time_t) 0)) {
		if (self->now < self->intended_start_time) {
			self->start_time = self->intended_start_time;
			self->state = PDFPC_TIMER_STATE_PreTalk;
		} else {
		}
	} else {
		self->state = PDFPC_TIMER_STATE_Stopped;
	}
	pdfpc_timer_update (self);
}

/**
         * Return true if the timer has been (manually) paused
         */
gboolean
pdfpc_timer_is_paused (pdfpcTimer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->state == PDFPC_TIMER_STATE_Paused;
	return result;
}

/**
         * Return true if the timer is running
         */
gboolean
pdfpc_timer_is_running (pdfpcTimer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->state == PDFPC_TIMER_STATE_Running;
	return result;
}

/**
         * Update the timer on every timeout step
         */
gboolean
pdfpc_timer_on_timeout (pdfpcTimer* self)
{
	time_t _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = time (NULL);
	self->now = _tmp0_;
	if (self->intended_start_time > ((time_t) 0)) {
		_tmp1_ = self->now > self->intended_start_time;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		pdfpc_timer_start (self);
	}
	if (self->mode == PDFPC_TIMER_MODE_Clock) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->state == PDFPC_TIMER_STATE_PreTalk;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->state == PDFPC_TIMER_STATE_Running;
	}
	if (_tmp2_) {
		pdfpc_timer_update (self);
	}
	result = TRUE;
	return result;
}

/**
         * Update and format time label
         */
void
pdfpc_timer_update (pdfpcTimer* self)
{
	guint hours = 0U;
	guint minutes = 0U;
	guint seconds = 0U;
	gint timeInSecs = 0;
	gchar* prefix = NULL;
	gchar* _tmp5_;
	gint _tmp7_ = 0;
	gint talk_time = 0;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	switch (self->state) {
		case PDFPC_TIMER_STATE_PreTalk:
		{
			self->running_time = (gint) (self->now - self->intended_start_time);
			break;
		}
		case PDFPC_TIMER_STATE_Running:
		{
			self->running_time = (gint) (self->now - self->start_time);
			break;
		}
		case PDFPC_TIMER_STATE_Stopped:
		{
			self->running_time = 0;
			break;
		}
		default:
		{
			break;
		}
	}
	hours = (guint) 0;
	minutes = (guint) 0;
	seconds = (guint) 0;
	timeInSecs = 0;
	switch (self->mode) {
		case PDFPC_TIMER_MODE_Clock:
		{
			GDateTime* dt = NULL;
			GDateTime* _tmp0_;
			GDateTime* _tmp1_;
			GDateTime* _tmp2_;
			GDateTime* _tmp3_;
			_tmp0_ = g_date_time_new_now_local ();
			dt = _tmp0_;
			_tmp1_ = dt;
			seconds = (guint) g_date_time_get_second (_tmp1_);
			_tmp2_ = dt;
			minutes = (guint) g_date_time_get_minute (_tmp2_);
			_tmp3_ = dt;
			hours = (guint) g_date_time_get_hour (_tmp3_);
			_g_date_time_unref0 (dt);
			break;
		}
		case PDFPC_TIMER_MODE_CountUp:
		{
			timeInSecs = self->running_time;
			break;
		}
		case PDFPC_TIMER_MODE_CountDown:
		{
			switch (self->state) {
				case PDFPC_TIMER_STATE_PreTalk:
				{
					timeInSecs = self->running_time;
					break;
				}
				default:
				{
					gint _tmp4_;
					_tmp4_ = self->priv->_duration;
					timeInSecs = _tmp4_ - self->running_time;
					break;
				}
			}
			break;
		}
		default:
		break;
	}
	_tmp5_ = g_strdup ("");
	prefix = _tmp5_;
	if (timeInSecs != 0) {
		if (timeInSecs < 0) {
			gchar* _tmp6_;
			timeInSecs = -timeInSecs;
			_tmp6_ = g_strdup ("-");
			_g_free0 (prefix);
			prefix = _tmp6_;
		}
		hours = (guint) (timeInSecs / 3600);
		minutes = (guint) ((timeInSecs / 60) % 60);
		seconds = (guint) (timeInSecs % 60);
	}
	if (self->running_time > 0) {
		_tmp7_ = self->running_time;
	} else {
		_tmp7_ = 0;
	}
	talk_time = _tmp7_;
	_tmp8_ = prefix;
	_tmp9_ = g_strdup_printf ("%s%.2u:%.2u:%.2u", _tmp8_, hours, minutes, seconds);
	_tmp10_ = _tmp9_;
	g_signal_emit (self, pdfpc_timer_signals[PDFPC_TIMER_CHANGE_SIGNAL], 0, talk_time, self->state, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (prefix);
}

gint
pdfpc_timer_get_duration (pdfpcTimer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_duration;
	return result;
}

void
pdfpc_timer_set_duration (pdfpcTimer* self,
                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = pdfpc_timer_get_duration (self);
	if (old_value != value) {
		self->priv->_duration = value;
		g_object_notify_by_pspec ((GObject *) self, pdfpc_timer_properties[PDFPC_TIMER_DURATION_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__INT_ENUM_STRING (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_ENUM_STRING) (gpointer data1, gint arg_1, gint arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__INT_ENUM_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_ENUM_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_enum (param_values + 2), g_value_get_string (param_values + 3), data2);
}

static void
pdfpc_timer_class_init (pdfpcTimerClass * klass,
                        gpointer klass_data)
{
	pdfpc_timer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &pdfpcTimer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pdfpc_timer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pdfpc_timer_set_property;
	G_OBJECT_CLASS (klass)->finalize = pdfpc_timer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PDFPC_TIMER_DURATION_PROPERTY, pdfpc_timer_properties[PDFPC_TIMER_DURATION_PROPERTY] = g_param_spec_int ("duration", "duration", "duration", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Signal: fired when the timer label changes
	         */
	pdfpc_timer_signals[PDFPC_TIMER_CHANGE_SIGNAL] = g_signal_new ("change", PDFPC_TYPE_TIMER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_ENUM_STRING, G_TYPE_NONE, 3, G_TYPE_INT, PDFPC_TIMER_TYPE_STATE, G_TYPE_STRING);
}

static void
pdfpc_timer_instance_init (pdfpcTimer * self,
                           gpointer klass)
{
	self->priv = pdfpc_timer_get_instance_private (self);
	self->intended_start_time = (time_t) 0;
	self->priv->_duration = 0;
	self->start_time = (time_t) 0;
	self->state = PDFPC_TIMER_STATE_Stopped;
	self->mode = PDFPC_TIMER_MODE_CountUp;
	self->now = (time_t) 0;
	self->running_time = 0;
}

static void
pdfpc_timer_finalize (GObject * obj)
{
	pdfpcTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PDFPC_TYPE_TIMER, pdfpcTimer);
	G_OBJECT_CLASS (pdfpc_timer_parent_class)->finalize (obj);
}

/**
     * The timer object
     */
static GType
pdfpc_timer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (pdfpcTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcTimer), 0, (GInstanceInitFunc) pdfpc_timer_instance_init, NULL };
	GType pdfpc_timer_type_id;
	pdfpc_timer_type_id = g_type_register_static (G_TYPE_OBJECT, "pdfpcTimer", &g_define_type_info, 0);
	pdfpcTimer_private_offset = g_type_add_instance_private (pdfpc_timer_type_id, sizeof (pdfpcTimerPrivate));
	return pdfpc_timer_type_id;
}

GType
pdfpc_timer_get_type (void)
{
	static volatile gsize pdfpc_timer_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_timer_type_id__once)) {
		GType pdfpc_timer_type_id;
		pdfpc_timer_type_id = pdfpc_timer_get_type_once ();
		g_once_init_leave (&pdfpc_timer_type_id__once, pdfpc_timer_type_id);
	}
	return pdfpc_timer_type_id__once;
}

static void
_vala_pdfpc_timer_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	pdfpcTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PDFPC_TYPE_TIMER, pdfpcTimer);
	switch (property_id) {
		case PDFPC_TIMER_DURATION_PROPERTY:
		g_value_set_int (value, pdfpc_timer_get_duration (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pdfpc_timer_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	pdfpcTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PDFPC_TYPE_TIMER, pdfpcTimer);
	switch (property_id) {
		case PDFPC_TIMER_DURATION_PROPERTY:
		pdfpc_timer_set_duration (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

