/* ZoomWidget.c generated by valac 0.56.18, the Vala compiler
 * generated from ZoomWidget.vala, do not modify */

/*
* Copyright (c) 2021 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ZOOM_WIDGET (zoom_widget_get_type ())
#define ZOOM_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ZOOM_WIDGET, ZoomWidget))
#define ZOOM_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ZOOM_WIDGET, ZoomWidgetClass))
#define IS_ZOOM_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ZOOM_WIDGET))
#define IS_ZOOM_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ZOOM_WIDGET))
#define ZOOM_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ZOOM_WIDGET, ZoomWidgetClass))

typedef struct _ZoomWidget ZoomWidget;
typedef struct _ZoomWidgetClass ZoomWidgetClass;
typedef struct _ZoomWidgetPrivate ZoomWidgetPrivate;
enum  {
	ZOOM_WIDGET_0_PROPERTY,
	ZOOM_WIDGET_MIN_PROPERTY,
	ZOOM_WIDGET_MAX_PROPERTY,
	ZOOM_WIDGET_STEP_PROPERTY,
	ZOOM_WIDGET_VALUE_PROPERTY,
	ZOOM_WIDGET_FACTOR_PROPERTY,
	ZOOM_WIDGET_NUM_PROPERTIES
};
static GParamSpec* zoom_widget_properties[ZOOM_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	ZOOM_WIDGET_ZOOM_CHANGED_SIGNAL,
	ZOOM_WIDGET_NUM_SIGNALS
};
static guint zoom_widget_signals[ZOOM_WIDGET_NUM_SIGNALS] = {0};

struct _ZoomWidget {
	GtkBox parent_instance;
	ZoomWidgetPrivate * priv;
};

struct _ZoomWidgetClass {
	GtkBoxClass parent_class;
};

struct _ZoomWidgetPrivate {
	GtkButton* _zoom_out;
	GtkButton* _zoom_actual;
	GtkButton* _zoom_in;
	gint _min;
	gint _max;
	gint _value;
	gint _step;
};

static gint ZoomWidget_private_offset;
static gpointer zoom_widget_parent_class = NULL;

VALA_EXTERN GType zoom_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZoomWidget, g_object_unref)
VALA_EXTERN ZoomWidget* zoom_widget_new (gint min,
                             gint max,
                             gint step,
                             gboolean fill);
VALA_EXTERN ZoomWidget* zoom_widget_construct (GType object_type,
                                   gint min,
                                   gint max,
                                   gint step,
                                   gboolean fill);
VALA_EXTERN void zoom_widget_set_min (ZoomWidget* self,
                          gint value);
VALA_EXTERN void zoom_widget_set_max (ZoomWidget* self,
                          gint value);
VALA_EXTERN void zoom_widget_set_step (ZoomWidget* self,
                           gint value);
VALA_EXTERN gchar* utils_tooltip_with_accel (const gchar* tooltip,
                                 const gchar* accel);
VALA_EXTERN void zoom_widget_zoom_out (ZoomWidget* self);
static void _zoom_widget_zoom_out_gtk_button_clicked (GtkButton* _sender,
                                               gpointer self);
VALA_EXTERN void zoom_widget_zoom_actual (ZoomWidget* self);
static void _zoom_widget_zoom_actual_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self);
VALA_EXTERN void zoom_widget_zoom_in (ZoomWidget* self);
static void _zoom_widget_zoom_in_gtk_button_clicked (GtkButton* _sender,
                                              gpointer self);
static void zoom_widget_update_state (ZoomWidget* self);
VALA_EXTERN gint zoom_widget_get_value (ZoomWidget* self);
VALA_EXTERN gint zoom_widget_get_max (ZoomWidget* self);
VALA_EXTERN gint zoom_widget_get_min (ZoomWidget* self);
VALA_EXTERN gint zoom_widget_get_step (ZoomWidget* self);
VALA_EXTERN void zoom_widget_set_value (ZoomWidget* self,
                            gint value);
VALA_EXTERN gdouble zoom_widget_get_factor (ZoomWidget* self);
static void zoom_widget_finalize (GObject * obj);
static GType zoom_widget_get_type_once (void);
static void _vala_zoom_widget_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_zoom_widget_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
zoom_widget_get_instance_private (ZoomWidget* self)
{
	return G_STRUCT_MEMBER_P (self, ZoomWidget_private_offset);
}

static void
_zoom_widget_zoom_out_gtk_button_clicked (GtkButton* _sender,
                                          gpointer self)
{
	zoom_widget_zoom_out ((ZoomWidget*) self);
}

static void
_zoom_widget_zoom_actual_gtk_button_clicked (GtkButton* _sender,
                                             gpointer self)
{
	zoom_widget_zoom_actual ((ZoomWidget*) self);
}

static void
_zoom_widget_zoom_in_gtk_button_clicked (GtkButton* _sender,
                                         gpointer self)
{
	zoom_widget_zoom_in ((ZoomWidget*) self);
}

ZoomWidget*
zoom_widget_construct (GType object_type,
                       gint min,
                       gint max,
                       gint step,
                       gboolean fill)
{
	ZoomWidget * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkButton* _tmp21_;
	self = (ZoomWidget*) g_object_new (object_type, NULL);
	zoom_widget_set_min (self, min);
	zoom_widget_set_max (self, max);
	zoom_widget_set_step (self, step);
	gtk_box_set_homogeneous ((GtkBox*) self, TRUE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, GTK_STYLE_CLASS_LINKED);
	_tmp1_ = (GtkButton*) gtk_button_new_from_icon_name ("zoom-out-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_zoom_out);
	self->priv->_zoom_out = _tmp1_;
	_tmp2_ = self->priv->_zoom_out;
	gtk_button_set_relief (_tmp2_, GTK_RELIEF_NORMAL);
	_tmp3_ = self->priv->_zoom_out;
	_tmp4_ = utils_tooltip_with_accel (_ ("Zoom Out"), "<Control>minus");
	_tmp5_ = _tmp4_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp3_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->_zoom_out;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) _zoom_widget_zoom_out_gtk_button_clicked, self, 0);
	_tmp7_ = (GtkButton*) gtk_button_new_with_label ("100%");
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->_zoom_actual);
	self->priv->_zoom_actual = _tmp7_;
	_tmp8_ = self->priv->_zoom_actual;
	gtk_button_set_relief (_tmp8_, GTK_RELIEF_NORMAL);
	_tmp9_ = self->priv->_zoom_actual;
	_tmp10_ = utils_tooltip_with_accel (_ ("Zoom Actual"), "<Control>0");
	_tmp11_ = _tmp10_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp9_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->_zoom_actual;
	g_signal_connect_object (_tmp12_, "clicked", (GCallback) _zoom_widget_zoom_actual_gtk_button_clicked, self, 0);
	_tmp13_ = (GtkButton*) gtk_button_new_from_icon_name ("zoom-in-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->_zoom_in);
	self->priv->_zoom_in = _tmp13_;
	_tmp14_ = self->priv->_zoom_in;
	gtk_button_set_relief (_tmp14_, GTK_RELIEF_NORMAL);
	_tmp15_ = self->priv->_zoom_in;
	_tmp16_ = utils_tooltip_with_accel (_ ("Zoom In"), "<Control>plus");
	_tmp17_ = _tmp16_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp15_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = self->priv->_zoom_in;
	g_signal_connect_object (_tmp18_, "clicked", (GCallback) _zoom_widget_zoom_in_gtk_button_clicked, self, 0);
	_tmp19_ = self->priv->_zoom_out;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp19_, FALSE, fill, (guint) 0);
	_tmp20_ = self->priv->_zoom_actual;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp20_, FALSE, fill, (guint) 0);
	_tmp21_ = self->priv->_zoom_in;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp21_, FALSE, fill, (guint) 0);
	zoom_widget_update_state (self);
	return self;
}

ZoomWidget*
zoom_widget_new (gint min,
                 gint max,
                 gint step,
                 gboolean fill)
{
	return zoom_widget_construct (TYPE_ZOOM_WIDGET, min, max, step, fill);
}

static void
zoom_widget_update_state (ZoomWidget* self)
{
	GtkButton* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkButton* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GtkButton* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_zoom_in;
	_tmp1_ = zoom_widget_get_value (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = zoom_widget_get_max (self);
	_tmp4_ = _tmp3_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_ < _tmp4_);
	_tmp5_ = self->priv->_zoom_out;
	_tmp6_ = zoom_widget_get_value (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = zoom_widget_get_min (self);
	_tmp9_ = _tmp8_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp7_ > _tmp9_);
	_tmp10_ = self->priv->_zoom_actual;
	_tmp11_ = zoom_widget_get_value (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%d%%", _tmp12_);
	_tmp14_ = _tmp13_;
	gtk_button_set_label (_tmp10_, _tmp14_);
	_g_free0 (_tmp14_);
}

void
zoom_widget_zoom_in (ZoomWidget* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = zoom_widget_get_value (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_step;
	zoom_widget_set_value (self, _tmp1_ + _tmp2_);
}

void
zoom_widget_zoom_actual (ZoomWidget* self)
{
	g_return_if_fail (self != NULL);
	zoom_widget_set_value (self, 100);
}

void
zoom_widget_zoom_out (ZoomWidget* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = zoom_widget_get_value (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_step;
	zoom_widget_set_value (self, _tmp1_ - _tmp2_);
}

gint
zoom_widget_get_min (ZoomWidget* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_min;
	return result;
}

void
zoom_widget_set_min (ZoomWidget* self,
                     gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_min = value;
	value = self->priv->_value;
	g_object_notify_by_pspec ((GObject *) self, zoom_widget_properties[ZOOM_WIDGET_MIN_PROPERTY]);
}

gint
zoom_widget_get_max (ZoomWidget* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_max;
	return result;
}

void
zoom_widget_set_max (ZoomWidget* self,
                     gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_max = value;
	value = self->priv->_value;
	g_object_notify_by_pspec ((GObject *) self, zoom_widget_properties[ZOOM_WIDGET_MAX_PROPERTY]);
}

gint
zoom_widget_get_step (ZoomWidget* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_step;
	return result;
}

void
zoom_widget_set_step (ZoomWidget* self,
                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = zoom_widget_get_step (self);
	if (old_value != value) {
		self->priv->_step = value;
		g_object_notify_by_pspec ((GObject *) self, zoom_widget_properties[ZOOM_WIDGET_STEP_PROPERTY]);
	}
}

gint
zoom_widget_get_value (ZoomWidget* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_value;
	return result;
}

void
zoom_widget_set_value (ZoomWidget* self,
                       gint value)
{
	gint orig_value = 0;
	gint _tmp0_ = 0;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	orig_value = self->priv->_value;
	_tmp1_ = zoom_widget_get_min (self);
	_tmp2_ = _tmp1_;
	if (value < _tmp2_) {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = zoom_widget_get_min (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		gint _tmp5_ = 0;
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = zoom_widget_get_max (self);
		_tmp7_ = _tmp6_;
		if (value > _tmp7_) {
			gint _tmp8_;
			gint _tmp9_;
			_tmp8_ = zoom_widget_get_max (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_;
		} else {
			_tmp5_ = value;
		}
		_tmp0_ = _tmp5_;
	}
	self->priv->_value = _tmp0_;
	if (orig_value != self->priv->_value) {
		gdouble _tmp10_;
		gdouble _tmp11_;
		zoom_widget_update_state (self);
		_tmp10_ = zoom_widget_get_factor (self);
		_tmp11_ = _tmp10_;
		g_signal_emit (self, zoom_widget_signals[ZOOM_WIDGET_ZOOM_CHANGED_SIGNAL], 0, _tmp11_);
	}
	g_object_notify_by_pspec ((GObject *) self, zoom_widget_properties[ZOOM_WIDGET_VALUE_PROPERTY]);
}

gdouble
zoom_widget_get_factor (ZoomWidget* self)
{
	gdouble result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = zoom_widget_get_value (self);
	_tmp1_ = _tmp0_;
	result = ((gdouble) _tmp1_) / 100;
	return result;
}

static void
zoom_widget_class_init (ZoomWidgetClass * klass,
                        gpointer klass_data)
{
	zoom_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZoomWidget_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_zoom_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zoom_widget_set_property;
	G_OBJECT_CLASS (klass)->finalize = zoom_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZOOM_WIDGET_MIN_PROPERTY, zoom_widget_properties[ZOOM_WIDGET_MIN_PROPERTY] = g_param_spec_int ("min", "min", "min", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZOOM_WIDGET_MAX_PROPERTY, zoom_widget_properties[ZOOM_WIDGET_MAX_PROPERTY] = g_param_spec_int ("max", "max", "max", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZOOM_WIDGET_STEP_PROPERTY, zoom_widget_properties[ZOOM_WIDGET_STEP_PROPERTY] = g_param_spec_int ("step", "step", "step", G_MININT, G_MAXINT, 25, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZOOM_WIDGET_VALUE_PROPERTY, zoom_widget_properties[ZOOM_WIDGET_VALUE_PROPERTY] = g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZOOM_WIDGET_FACTOR_PROPERTY, zoom_widget_properties[ZOOM_WIDGET_FACTOR_PROPERTY] = g_param_spec_double ("factor", "factor", "factor", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	zoom_widget_signals[ZOOM_WIDGET_ZOOM_CHANGED_SIGNAL] = g_signal_new ("zoom-changed", TYPE_ZOOM_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
}

static void
zoom_widget_instance_init (ZoomWidget * self,
                           gpointer klass)
{
	self->priv = zoom_widget_get_instance_private (self);
	self->priv->_min = 100;
	self->priv->_max = 400;
	self->priv->_value = 100;
	self->priv->_step = 25;
}

static void
zoom_widget_finalize (GObject * obj)
{
	ZoomWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ZOOM_WIDGET, ZoomWidget);
	_g_object_unref0 (self->priv->_zoom_out);
	_g_object_unref0 (self->priv->_zoom_actual);
	_g_object_unref0 (self->priv->_zoom_in);
	G_OBJECT_CLASS (zoom_widget_parent_class)->finalize (obj);
}

static GType
zoom_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZoomWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zoom_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZoomWidget), 0, (GInstanceInitFunc) zoom_widget_instance_init, NULL };
	GType zoom_widget_type_id;
	zoom_widget_type_id = g_type_register_static (gtk_box_get_type (), "ZoomWidget", &g_define_type_info, 0);
	ZoomWidget_private_offset = g_type_add_instance_private (zoom_widget_type_id, sizeof (ZoomWidgetPrivate));
	return zoom_widget_type_id;
}

GType
zoom_widget_get_type (void)
{
	static volatile gsize zoom_widget_type_id__once = 0;
	if (g_once_init_enter (&zoom_widget_type_id__once)) {
		GType zoom_widget_type_id;
		zoom_widget_type_id = zoom_widget_get_type_once ();
		g_once_init_leave (&zoom_widget_type_id__once, zoom_widget_type_id);
	}
	return zoom_widget_type_id__once;
}

static void
_vala_zoom_widget_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	ZoomWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ZOOM_WIDGET, ZoomWidget);
	switch (property_id) {
		case ZOOM_WIDGET_MIN_PROPERTY:
		g_value_set_int (value, zoom_widget_get_min (self));
		break;
		case ZOOM_WIDGET_MAX_PROPERTY:
		g_value_set_int (value, zoom_widget_get_max (self));
		break;
		case ZOOM_WIDGET_STEP_PROPERTY:
		g_value_set_int (value, zoom_widget_get_step (self));
		break;
		case ZOOM_WIDGET_VALUE_PROPERTY:
		g_value_set_int (value, zoom_widget_get_value (self));
		break;
		case ZOOM_WIDGET_FACTOR_PROPERTY:
		g_value_set_double (value, zoom_widget_get_factor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_zoom_widget_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	ZoomWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ZOOM_WIDGET, ZoomWidget);
	switch (property_id) {
		case ZOOM_WIDGET_MIN_PROPERTY:
		zoom_widget_set_min (self, g_value_get_int (value));
		break;
		case ZOOM_WIDGET_MAX_PROPERTY:
		zoom_widget_set_max (self, g_value_get_int (value));
		break;
		case ZOOM_WIDGET_STEP_PROPERTY:
		zoom_widget_set_step (self, g_value_get_int (value));
		break;
		case ZOOM_WIDGET_VALUE_PROPERTY:
		zoom_widget_set_value (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

