/* Selection.c generated by valac 0.56.18, the Vala compiler
 * generated from Selection.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SELECTION (selection_get_type ())
#define SELECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SELECTION, Selection))
#define SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SELECTION, SelectionClass))
#define IS_SELECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SELECTION))
#define IS_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SELECTION))
#define SELECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SELECTION, SelectionClass))

typedef struct _Selection Selection;
typedef struct _SelectionClass SelectionClass;
typedef struct _SelectionPrivate SelectionPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_CONNECTION (connection_get_type ())
#define CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONNECTION, Connection))
#define CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONNECTION, ConnectionClass))
#define IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONNECTION))
#define IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONNECTION))
#define CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONNECTION, ConnectionClass))

typedef struct _Connection Connection;
typedef struct _ConnectionClass ConnectionClass;

#define TYPE_STICKER (sticker_get_type ())
#define STICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STICKER, Sticker))
#define STICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STICKER, StickerClass))
#define IS_STICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STICKER))
#define IS_STICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STICKER))
#define STICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STICKER, StickerClass))

typedef struct _Sticker Sticker;
typedef struct _StickerClass StickerClass;

#define TYPE_NODE_GROUP (node_group_get_type ())
#define NODE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_GROUP, NodeGroup))
#define NODE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_GROUP, NodeGroupClass))
#define IS_NODE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_GROUP))
#define IS_NODE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_GROUP))
#define NODE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_GROUP, NodeGroupClass))

typedef struct _NodeGroup NodeGroup;
typedef struct _NodeGroupClass NodeGroupClass;

#define TYPE_CALLOUT (callout_get_type ())
#define CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALLOUT, Callout))
#define CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALLOUT, CalloutClass))
#define IS_CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALLOUT))
#define IS_CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALLOUT))
#define CALLOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALLOUT, CalloutClass))

typedef struct _Callout Callout;
typedef struct _CalloutClass CalloutClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef enum  {
	NODE_MODE_NONE = 0,
	NODE_MODE_CURRENT,
	NODE_MODE_SELECTED,
	NODE_MODE_EDITABLE,
	NODE_MODE_ATTACHABLE,
	NODE_MODE_DROPPABLE,
	NODE_MODE_HIGHLIGHTED
} NodeMode;

#define TYPE_NODE_MODE (node_mode_get_type ())
typedef enum  {
	CONN_MODE_NONE = 0,
	CONN_MODE_LINKING,
	CONN_MODE_CONNECTING,
	CONN_MODE_SELECTED,
	CONN_MODE_ADJUSTING,
	CONN_MODE_EDITABLE,
	CONN_MODE_DROPPABLE
} ConnMode;

#define TYPE_CONN_MODE (conn_mode_get_type ())
typedef enum  {
	STICKER_MODE_NONE = 0,
	STICKER_MODE_SELECTED,
	STICKER_MODE_DROPPABLE
} StickerMode;

#define TYPE_STICKER_MODE (sticker_mode_get_type ())
typedef enum  {
	GROUP_MODE_NONE = 0,
	GROUP_MODE_SELECTED
} GroupMode;

#define TYPE_GROUP_MODE (group_mode_get_type ())
typedef enum  {
	CALLOUT_MODE_NONE = 0,
	CALLOUT_MODE_SELECTED,
	CALLOUT_MODE_EDITABLE,
	CALLOUT_MODE_HIDING,
	CALLOUT_MODE_HIDDEN
} CalloutMode;

#define TYPE_CALLOUT_MODE (callout_mode_get_type ())
#define _sticker_unref0(var) ((var == NULL) ? NULL : (var = (sticker_unref (var), NULL)))

#define TYPE_IMAGE_MANAGER (image_manager_get_type ())
#define IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_MANAGER, ImageManager))
#define IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_MANAGER, ImageManagerClass))
#define IS_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_MANAGER))
#define IS_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_MANAGER))
#define IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_MANAGER, ImageManagerClass))

typedef struct _ImageManager ImageManager;
typedef struct _ImageManagerClass ImageManagerClass;

#define TYPE_LAYOUT (layout_get_type ())
#define LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAYOUT, Layout))
#define LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAYOUT, LayoutClass))
#define IS_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAYOUT))
#define IS_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAYOUT))
#define LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAYOUT, LayoutClass))

typedef struct _Layout Layout;
typedef struct _LayoutClass LayoutClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
typedef struct _ParamSpecSelection ParamSpecSelection;
enum  {
	SELECTION_SELECTION_CHANGED_SIGNAL,
	SELECTION_NUM_SIGNALS
};
static guint selection_signals[SELECTION_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Selection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SelectionPrivate * priv;
};

struct _SelectionClass {
	GTypeClass parent_class;
	void (*finalize) (Selection *self);
};

struct _SelectionPrivate {
	DrawArea* _da;
	GArray* _nodes;
	GArray* _conns;
	GArray* _stickers;
	GArray* _groups;
	GArray* _callouts;
};

struct _ParamSpecSelection {
	GParamSpec parent_instance;
};

static gint Selection_private_offset;
static gpointer selection_parent_class = NULL;

VALA_EXTERN gpointer selection_ref (gpointer instance);
VALA_EXTERN void selection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_selection (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_selection (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_selection (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_selection (const GValue* value);
VALA_EXTERN GType selection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Selection, selection_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GType connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Connection, g_object_unref)
VALA_EXTERN gpointer sticker_ref (gpointer instance);
VALA_EXTERN void sticker_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_sticker (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_sticker (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_sticker (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_sticker (const GValue* value);
VALA_EXTERN GType sticker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Sticker, sticker_unref)
VALA_EXTERN GType node_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeGroup, g_object_unref)
VALA_EXTERN GType callout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Callout, g_object_unref)
VALA_EXTERN Selection* selection_new (DrawArea* da);
VALA_EXTERN Selection* selection_construct (GType object_type,
                                DrawArea* da);
static void _g_object_unref0_ (gpointer var);
static void _vala_Node_free_function_content_of (gpointer data);
static void _vala_Connection_free_function_content_of (gpointer data);
static void _sticker_unref0_ (gpointer var);
static void _vala_Sticker_free_function_content_of (gpointer data);
static void _vala_NodeGroup_free_function_content_of (gpointer data);
static void _vala_Callout_free_function_content_of (gpointer data);
VALA_EXTERN gboolean selection_is_node_selected (Selection* self,
                                     Node* node);
VALA_EXTERN GType node_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NodeMode node_get_mode (Node* self);
VALA_EXTERN gboolean node_mode_is_selected (NodeMode self);
VALA_EXTERN gboolean selection_is_connection_selected (Selection* self,
                                           Connection* conn);
VALA_EXTERN GType conn_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ConnMode connection_get_mode (Connection* self);
VALA_EXTERN gboolean selection_is_sticker_selected (Selection* self,
                                        Sticker* sticker);
VALA_EXTERN GType sticker_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN StickerMode sticker_get_mode (Sticker* self);
VALA_EXTERN gboolean selection_is_group_selected (Selection* self,
                                      NodeGroup* group);
VALA_EXTERN GType group_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GroupMode node_group_get_mode (NodeGroup* self);
VALA_EXTERN gboolean selection_is_callout_selected (Selection* self,
                                        Callout* callout);
VALA_EXTERN GType callout_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN CalloutMode callout_get_mode (Callout* self);
VALA_EXTERN gboolean callout_mode_is_selected (CalloutMode self);
VALA_EXTERN gboolean selection_is_current_node (Selection* self,
                                    Node* node);
VALA_EXTERN gboolean selection_is_current_connection (Selection* self,
                                          Connection* conn);
VALA_EXTERN gboolean selection_is_current_sticker (Selection* self,
                                       Sticker* sticker);
VALA_EXTERN gboolean selection_is_current_group (Selection* self,
                                     NodeGroup* group);
VALA_EXTERN gboolean selection_is_current_callout (Selection* self,
                                       Callout* callout);
VALA_EXTERN Node* selection_current_node (Selection* self);
VALA_EXTERN Connection* selection_current_connection (Selection* self);
VALA_EXTERN Sticker* selection_current_sticker (Selection* self);
VALA_EXTERN NodeGroup* selection_current_group (Selection* self);
VALA_EXTERN Callout* selection_current_callout (Selection* self);
VALA_EXTERN void selection_set_current_node (Selection* self,
                                 Node* node,
                                 gdouble clear_alpha);
VALA_EXTERN gboolean selection_clear (Selection* self,
                          gboolean signal_change,
                          gdouble alpha);
VALA_EXTERN gboolean selection_add_node (Selection* self,
                             Node* node,
                             gboolean signal_change);
VALA_EXTERN void selection_set_current_connection (Selection* self,
                                       Connection* conn,
                                       gdouble clear_alpha);
VALA_EXTERN gboolean selection_add_connection (Selection* self,
                                   Connection* conn);
VALA_EXTERN void selection_set_current_sticker (Selection* self,
                                    Sticker* sticker,
                                    gdouble clear_alpha);
VALA_EXTERN gboolean selection_add_sticker (Selection* self,
                                Sticker* sticker);
VALA_EXTERN void selection_set_current_group (Selection* self,
                                  NodeGroup* group,
                                  gdouble clear_alpha);
VALA_EXTERN gboolean selection_add_group (Selection* self,
                              NodeGroup* group);
VALA_EXTERN void selection_set_current_callout (Selection* self,
                                    Callout* callout,
                                    gdouble clear_alpha);
VALA_EXTERN gboolean selection_add_callout (Selection* self,
                                Callout* callout);
VALA_EXTERN Node* node_get_parent (Node* self);
VALA_EXTERN gboolean node_get_folded (Node* self);
VALA_EXTERN void draw_area_set_node_mode (DrawArea* self,
                              Node* node,
                              NodeMode mode,
                              gboolean undoable);
VALA_EXTERN gboolean selection_add_child_nodes (Selection* self,
                                    Node* node,
                                    gboolean signal_change);
VALA_EXTERN GArray* node_children (Node* self);
VALA_EXTERN gboolean selection_add_node_tree (Selection* self,
                                  Node* node,
                                  gboolean signal_change);
static gboolean selection_add_node_tree_helper (Selection* self,
                                         Node* node);
VALA_EXTERN gboolean selection_add_nodes_at_level (Selection* self,
                                       Node* node,
                                       gboolean signal_change);
VALA_EXTERN guint node_get_level (Node* self);
VALA_EXTERN Node* node_get_root (Node* self);
static gboolean selection_add_nodes_at_level_helper (Selection* self,
                                              Node* node,
                                              guint level,
                                              guint curr_level);
VALA_EXTERN void draw_area_set_connection_mode (DrawArea* self,
                                    Connection* conn,
                                    ConnMode mode,
                                    gboolean undoable);
VALA_EXTERN void sticker_set_mode (Sticker* self,
                       StickerMode value);
VALA_EXTERN void node_group_set_mode (NodeGroup* self,
                          GroupMode value);
VALA_EXTERN void callout_set_mode (Callout* self,
                       CalloutMode value);
VALA_EXTERN gboolean selection_remove_node (Selection* self,
                                Node* node,
                                gdouble alpha,
                                gboolean signal_change);
VALA_EXTERN void node_set_alpha (Node* self,
                     gdouble value);
VALA_EXTERN gboolean selection_remove_child_nodes (Selection* self,
                                       Node* node,
                                       gdouble alpha);
VALA_EXTERN gboolean selection_remove_node_tree (Selection* self,
                                     Node* node,
                                     gdouble alpha);
VALA_EXTERN gboolean selection_remove_node_tree_helper (Selection* self,
                                            Node* node,
                                            gdouble alpha);
VALA_EXTERN gboolean selection_remove_nodes_at_level (Selection* self,
                                          Node* node,
                                          gdouble alpha);
static gboolean selection_remove_nodes_at_level_helper (Selection* self,
                                                 Node* node,
                                                 gdouble alpha,
                                                 guint level,
                                                 guint curr_level);
VALA_EXTERN gboolean selection_remove_connection (Selection* self,
                                      Connection* conn,
                                      gdouble alpha);
VALA_EXTERN void connection_set_alpha (Connection* self,
                           gdouble value);
VALA_EXTERN gboolean selection_remove_sticker (Selection* self,
                                   Sticker* sticker,
                                   gdouble alpha);
VALA_EXTERN gboolean selection_remove_group (Selection* self,
                                 NodeGroup* group,
                                 gdouble alpha);
VALA_EXTERN gboolean selection_remove_callout (Selection* self,
                                   Callout* callout,
                                   gdouble alpha);
VALA_EXTERN gboolean selection_clear_nodes (Selection* self,
                                gboolean signal_change,
                                gdouble alpha);
VALA_EXTERN gboolean selection_clear_connections (Selection* self,
                                      gboolean signal_change,
                                      gdouble alpha);
VALA_EXTERN gboolean selection_clear_stickers (Selection* self,
                                   gboolean signal_change);
VALA_EXTERN gboolean selection_clear_groups (Selection* self,
                                 gboolean signal_change);
VALA_EXTERN gboolean selection_clear_callouts (Selection* self,
                                   gboolean signal_change,
                                   gdouble alpha);
VALA_EXTERN void draw_area_set_callout_mode (DrawArea* self,
                                 Callout* callout,
                                 CalloutMode mode,
                                 gboolean undoable);
VALA_EXTERN void callout_set_alpha (Callout* self,
                        gdouble value);
VALA_EXTERN gint selection_num_nodes (Selection* self);
VALA_EXTERN gint selection_num_connections (Selection* self);
VALA_EXTERN gint selection_num_stickers (Selection* self);
VALA_EXTERN gint selection_num_groups (Selection* self);
VALA_EXTERN gint selection_num_callouts (Selection* self);
VALA_EXTERN GArray* selection_nodes (Selection* self);
VALA_EXTERN GArray* selection_nodes_copy (Selection* self);
VALA_EXTERN GArray* selection_ordered_nodes (Selection* self);
static void selection_ordered_nodes_helper (Selection* self,
                                     GArray* children,
                                     GArray** nodes);
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
VALA_EXTERN gboolean node_traversable (Node* self);
VALA_EXTERN GArray* selection_connections (Selection* self);
VALA_EXTERN GArray* selection_stickers (Selection* self);
VALA_EXTERN GArray* selection_groups (Selection* self);
VALA_EXTERN GArray* selection_callouts (Selection* self);
VALA_EXTERN void selection_get_parents (Selection* self,
                            GArray** parents);
VALA_EXTERN gboolean node_is_root (Node* self);
VALA_EXTERN gpointer image_manager_ref (gpointer instance);
VALA_EXTERN void image_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_image_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_image_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_image_manager (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_image_manager (const GValue* value);
VALA_EXTERN GType image_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageManager, image_manager_unref)
VALA_EXTERN void selection_get_subtrees (Selection* self,
                             GArray** subtrees,
                             ImageManager* im);
VALA_EXTERN GType layout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Layout, g_object_unref)
VALA_EXTERN Layout* node_get_layout (Node* self);
VALA_EXTERN Node* node_new (DrawArea* da,
                Layout* layout);
VALA_EXTERN Node* node_construct (GType object_type,
                      DrawArea* da,
                      Layout* layout);
VALA_EXTERN void node_copy_variables (Node* self,
                          Node* n,
                          ImageManager* im);
static void selection_get_subtrees_helper (Selection* self,
                                    Node* old_parent,
                                    Node* new_parent,
                                    ImageManager* im);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN void node_attach (Node* self,
                  Node* parent,
                  gint index,
                  Theme* theme,
                  gboolean set_side);
static void selection_finalize (Selection * obj);
static GType selection_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
selection_get_instance_private (Selection* self)
{
	return G_STRUCT_MEMBER_P (self, Selection_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_Node_free_function_content_of (gpointer data)
{
	Node* self;
	self = *((Node**) data);
	_g_object_unref0_ (self);
}

static void
_vala_Connection_free_function_content_of (gpointer data)
{
	Connection* self;
	self = *((Connection**) data);
	_g_object_unref0_ (self);
}

static void
_sticker_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (sticker_unref (var), NULL));
}

static void
_vala_Sticker_free_function_content_of (gpointer data)
{
	Sticker* self;
	self = *((Sticker**) data);
	_sticker_unref0_ (self);
}

static void
_vala_NodeGroup_free_function_content_of (gpointer data)
{
	NodeGroup* self;
	self = *((NodeGroup**) data);
	_g_object_unref0_ (self);
}

static void
_vala_Callout_free_function_content_of (gpointer data)
{
	Callout* self;
	self = *((Callout**) data);
	_g_object_unref0_ (self);
}

Selection*
selection_construct (GType object_type,
                     DrawArea* da)
{
	Selection* self = NULL;
	DrawArea* _tmp0_;
	GArray* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	GArray* _tmp4_;
	GArray* _tmp5_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (Selection*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = g_array_new (TRUE, TRUE, sizeof (Node*));
	g_array_set_clear_func (_tmp1_, (GDestroyNotify) _vala_Node_free_function_content_of);
	_g_array_unref0 (self->priv->_nodes);
	self->priv->_nodes = _tmp1_;
	_tmp2_ = g_array_new (TRUE, TRUE, sizeof (Connection*));
	g_array_set_clear_func (_tmp2_, (GDestroyNotify) _vala_Connection_free_function_content_of);
	_g_array_unref0 (self->priv->_conns);
	self->priv->_conns = _tmp2_;
	_tmp3_ = g_array_new (TRUE, TRUE, sizeof (Sticker*));
	g_array_set_clear_func (_tmp3_, (GDestroyNotify) _vala_Sticker_free_function_content_of);
	_g_array_unref0 (self->priv->_stickers);
	self->priv->_stickers = _tmp3_;
	_tmp4_ = g_array_new (TRUE, TRUE, sizeof (NodeGroup*));
	g_array_set_clear_func (_tmp4_, (GDestroyNotify) _vala_NodeGroup_free_function_content_of);
	_g_array_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp4_;
	_tmp5_ = g_array_new (TRUE, TRUE, sizeof (Callout*));
	g_array_set_clear_func (_tmp5_, (GDestroyNotify) _vala_Callout_free_function_content_of);
	_g_array_unref0 (self->priv->_callouts);
	self->priv->_callouts = _tmp5_;
	return self;
}

Selection*
selection_new (DrawArea* da)
{
	return selection_construct (TYPE_SELECTION, da);
}

gboolean
selection_is_node_selected (Selection* self,
                            Node* node)
{
	NodeMode _tmp0_;
	NodeMode _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node_get_mode (node);
	_tmp1_ = _tmp0_;
	result = node_mode_is_selected (_tmp1_);
	return result;
}

gboolean
selection_is_connection_selected (Selection* self,
                                  Connection* conn)
{
	ConnMode _tmp0_;
	ConnMode _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (conn != NULL, FALSE);
	_tmp0_ = connection_get_mode (conn);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == CONN_MODE_SELECTED;
	return result;
}

gboolean
selection_is_sticker_selected (Selection* self,
                               Sticker* sticker)
{
	StickerMode _tmp0_;
	StickerMode _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sticker != NULL, FALSE);
	_tmp0_ = sticker_get_mode (sticker);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == STICKER_MODE_SELECTED;
	return result;
}

gboolean
selection_is_group_selected (Selection* self,
                             NodeGroup* group)
{
	GroupMode _tmp0_;
	GroupMode _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	_tmp0_ = node_group_get_mode (group);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == GROUP_MODE_SELECTED;
	return result;
}

gboolean
selection_is_callout_selected (Selection* self,
                               Callout* callout)
{
	CalloutMode _tmp0_;
	CalloutMode _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (callout != NULL, FALSE);
	_tmp0_ = callout_get_mode (callout);
	_tmp1_ = _tmp0_;
	result = callout_mode_is_selected (_tmp1_);
	return result;
}

gboolean
selection_is_current_node (Selection* self,
                           Node* node)
{
	gboolean _tmp0_ = FALSE;
	GArray* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp1_ = self->priv->_nodes;
	if (_tmp1_->len == ((guint) 1)) {
		GArray* _tmp2_;
		Node* _tmp3_;
		_tmp2_ = self->priv->_nodes;
		_tmp3_ = g_array_index (_tmp2_, Node*, (guint) 0);
		_tmp0_ = _tmp3_ == node;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
selection_is_current_connection (Selection* self,
                                 Connection* conn)
{
	gboolean _tmp0_ = FALSE;
	GArray* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (conn != NULL, FALSE);
	_tmp1_ = self->priv->_conns;
	if (_tmp1_->len == ((guint) 1)) {
		GArray* _tmp2_;
		Connection* _tmp3_;
		_tmp2_ = self->priv->_conns;
		_tmp3_ = g_array_index (_tmp2_, Connection*, (guint) 0);
		_tmp0_ = _tmp3_ == conn;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
selection_is_current_sticker (Selection* self,
                              Sticker* sticker)
{
	gboolean _tmp0_ = FALSE;
	GArray* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sticker != NULL, FALSE);
	_tmp1_ = self->priv->_stickers;
	if (_tmp1_->len == ((guint) 1)) {
		GArray* _tmp2_;
		Sticker* _tmp3_;
		_tmp2_ = self->priv->_stickers;
		_tmp3_ = g_array_index (_tmp2_, Sticker*, (guint) 0);
		_tmp0_ = _tmp3_ == sticker;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
selection_is_current_group (Selection* self,
                            NodeGroup* group)
{
	gboolean _tmp0_ = FALSE;
	GArray* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	_tmp1_ = self->priv->_groups;
	if (_tmp1_->len == ((guint) 1)) {
		GArray* _tmp2_;
		NodeGroup* _tmp3_;
		_tmp2_ = self->priv->_groups;
		_tmp3_ = g_array_index (_tmp2_, NodeGroup*, (guint) 0);
		_tmp0_ = _tmp3_ == group;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
selection_is_current_callout (Selection* self,
                              Callout* callout)
{
	gboolean _tmp0_ = FALSE;
	GArray* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (callout != NULL, FALSE);
	_tmp1_ = self->priv->_callouts;
	if (_tmp1_->len == ((guint) 1)) {
		GArray* _tmp2_;
		Callout* _tmp3_;
		_tmp2_ = self->priv->_callouts;
		_tmp3_ = g_array_index (_tmp2_, Callout*, (guint) 0);
		_tmp0_ = _tmp3_ == callout;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

Node*
selection_current_node (Selection* self)
{
	Node* _tmp0_ = NULL;
	GArray* _tmp1_;
	Node* _tmp4_;
	Node* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_nodes;
	if (_tmp1_->len == ((guint) 1)) {
		GArray* _tmp2_;
		Node* _tmp3_;
		_tmp2_ = self->priv->_nodes;
		_tmp3_ = g_array_index (_tmp2_, Node*, (guint) 0);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp4_ = _g_object_ref0 (_tmp0_);
	result = _tmp4_;
	return result;
}

Connection*
selection_current_connection (Selection* self)
{
	Connection* _tmp0_ = NULL;
	GArray* _tmp1_;
	Connection* _tmp4_;
	Connection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_conns;
	if (_tmp1_->len == ((guint) 1)) {
		GArray* _tmp2_;
		Connection* _tmp3_;
		_tmp2_ = self->priv->_conns;
		_tmp3_ = g_array_index (_tmp2_, Connection*, (guint) 0);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp4_ = _g_object_ref0 (_tmp0_);
	result = _tmp4_;
	return result;
}

static gpointer
_sticker_ref0 (gpointer self)
{
	return self ? sticker_ref (self) : NULL;
}

Sticker*
selection_current_sticker (Selection* self)
{
	Sticker* _tmp0_ = NULL;
	GArray* _tmp1_;
	Sticker* _tmp4_;
	Sticker* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_stickers;
	if (_tmp1_->len == ((guint) 1)) {
		GArray* _tmp2_;
		Sticker* _tmp3_;
		_tmp2_ = self->priv->_stickers;
		_tmp3_ = g_array_index (_tmp2_, Sticker*, (guint) 0);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp4_ = _sticker_ref0 (_tmp0_);
	result = _tmp4_;
	return result;
}

NodeGroup*
selection_current_group (Selection* self)
{
	NodeGroup* _tmp0_ = NULL;
	GArray* _tmp1_;
	NodeGroup* _tmp4_;
	NodeGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_groups;
	if (_tmp1_->len == ((guint) 1)) {
		GArray* _tmp2_;
		NodeGroup* _tmp3_;
		_tmp2_ = self->priv->_groups;
		_tmp3_ = g_array_index (_tmp2_, NodeGroup*, (guint) 0);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp4_ = _g_object_ref0 (_tmp0_);
	result = _tmp4_;
	return result;
}

Callout*
selection_current_callout (Selection* self)
{
	Callout* _tmp0_ = NULL;
	GArray* _tmp1_;
	Callout* _tmp4_;
	Callout* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->_callouts;
	if (_tmp1_->len == ((guint) 1)) {
		GArray* _tmp2_;
		Callout* _tmp3_;
		_tmp2_ = self->priv->_callouts;
		_tmp3_ = g_array_index (_tmp2_, Callout*, (guint) 0);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp4_ = _g_object_ref0 (_tmp0_);
	result = _tmp4_;
	return result;
}

void
selection_set_current_node (Selection* self,
                            Node* node,
                            gdouble clear_alpha)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	selection_clear (self, FALSE, clear_alpha);
	selection_add_node (self, node, TRUE);
}

void
selection_set_current_connection (Selection* self,
                                  Connection* conn,
                                  gdouble clear_alpha)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	selection_clear (self, FALSE, clear_alpha);
	selection_add_connection (self, conn);
}

void
selection_set_current_sticker (Selection* self,
                               Sticker* sticker,
                               gdouble clear_alpha)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (sticker != NULL);
	selection_clear (self, FALSE, clear_alpha);
	selection_add_sticker (self, sticker);
}

void
selection_set_current_group (Selection* self,
                             NodeGroup* group,
                             gdouble clear_alpha)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	selection_clear (self, FALSE, clear_alpha);
	selection_add_group (self, group);
}

void
selection_set_current_callout (Selection* self,
                               Callout* callout,
                               gdouble clear_alpha)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (callout != NULL);
	selection_clear (self, FALSE, clear_alpha);
	selection_add_callout (self, callout);
}

gboolean
selection_add_node (Selection* self,
                    Node* node,
                    gboolean signal_change)
{
	gboolean _tmp0_ = FALSE;
	NodeMode _tmp8_ = 0;
	GArray* _tmp9_;
	DrawArea* _tmp10_;
	GArray* _tmp11_;
	GArray* _tmp15_;
	Node* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	if (selection_is_node_selected (self, node)) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		Node* _tmp2_;
		Node* _tmp3_;
		_tmp2_ = node_get_parent (node);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			Node* _tmp4_;
			Node* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp4_ = node_get_parent (node);
			_tmp5_ = _tmp4_;
			_tmp6_ = node_get_folded (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp1_ = _tmp7_;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp9_ = self->priv->_nodes;
	if (_tmp9_->len == ((guint) 0)) {
		_tmp8_ = NODE_MODE_CURRENT;
	} else {
		_tmp8_ = NODE_MODE_SELECTED;
	}
	_tmp10_ = self->priv->_da;
	draw_area_set_node_mode (_tmp10_, node, _tmp8_, TRUE);
	_tmp11_ = self->priv->_nodes;
	if (_tmp11_->len == ((guint) 1)) {
		DrawArea* _tmp12_;
		GArray* _tmp13_;
		Node* _tmp14_;
		_tmp12_ = self->priv->_da;
		_tmp13_ = self->priv->_nodes;
		_tmp14_ = g_array_index (_tmp13_, Node*, (guint) 0);
		draw_area_set_node_mode (_tmp12_, _tmp14_, NODE_MODE_SELECTED, TRUE);
	}
	_tmp15_ = self->priv->_nodes;
	_tmp16_ = _g_object_ref0 (node);
	g_array_append_val (_tmp15_, _tmp16_);
	if (signal_change) {
		g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	}
	result = TRUE;
	return result;
}

gboolean
selection_add_child_nodes (Selection* self,
                           Node* node,
                           gboolean signal_change)
{
	GArray* children = NULL;
	GArray* _tmp0_;
	gboolean changed = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node_children (node);
	children = _tmp0_;
	changed = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				GArray* _tmp4_;
				Node* _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = children;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = children;
				_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
				changed |= selection_add_node (self, _tmp5_, FALSE);
			}
		}
	}
	if (changed) {
		_tmp6_ = signal_change;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	}
	result = changed;
	_g_array_unref0 (children);
	return result;
}

gboolean
selection_add_node_tree (Selection* self,
                         Node* node,
                         gboolean signal_change)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	if (selection_add_node_tree_helper (self, node)) {
		if (signal_change) {
			g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
selection_add_node_tree_helper (Selection* self,
                                Node* node)
{
	GArray* children = NULL;
	GArray* _tmp0_;
	gboolean changed = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node_children (node);
	children = _tmp0_;
	changed = selection_add_node (self, node, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				GArray* _tmp4_;
				Node* _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = children;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = children;
				_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
				changed |= selection_add_node_tree_helper (self, _tmp5_);
			}
		}
	}
	result = changed;
	_g_array_unref0 (children);
	return result;
}

gboolean
selection_add_nodes_at_level (Selection* self,
                              Node* node,
                              gboolean signal_change)
{
	guint level = 0U;
	Node* root = NULL;
	Node* _tmp0_;
	gboolean _tmp1_ = FALSE;
	Node* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	level = node_get_level (node);
	_tmp0_ = node_get_root (node);
	root = _tmp0_;
	_tmp2_ = root;
	if (selection_add_nodes_at_level_helper (self, _tmp2_, level, (guint) 0)) {
		_tmp1_ = signal_change;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		if (signal_change) {
			g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
		}
		result = TRUE;
		_g_object_unref0 (root);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (root);
	return result;
}

static gboolean
selection_add_nodes_at_level_helper (Selection* self,
                                     Node* node,
                                     guint level,
                                     guint curr_level)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	if (level == curr_level) {
		result = selection_add_node (self, node, FALSE);
		return result;
	} else {
		GArray* children = NULL;
		GArray* _tmp0_;
		gboolean changed = FALSE;
		_tmp0_ = node_children (node);
		children = _tmp0_;
		changed = FALSE;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					GArray* _tmp4_;
					Node* _tmp5_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = children;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = children;
					_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
					changed |= selection_add_nodes_at_level_helper (self, _tmp5_, level, curr_level + 1);
				}
			}
		}
		result = changed;
		_g_array_unref0 (children);
		return result;
	}
}

gboolean
selection_add_connection (Selection* self,
                          Connection* conn)
{
	DrawArea* _tmp0_;
	GArray* _tmp1_;
	Connection* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (conn != NULL, FALSE);
	if (selection_is_connection_selected (self, conn)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->_da;
	draw_area_set_connection_mode (_tmp0_, conn, CONN_MODE_SELECTED, TRUE);
	_tmp1_ = self->priv->_conns;
	_tmp2_ = _g_object_ref0 (conn);
	g_array_append_val (_tmp1_, _tmp2_);
	g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	result = TRUE;
	return result;
}

gboolean
selection_add_sticker (Selection* self,
                       Sticker* sticker)
{
	GArray* _tmp0_;
	Sticker* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sticker != NULL, FALSE);
	if (selection_is_sticker_selected (self, sticker)) {
		result = FALSE;
		return result;
	}
	sticker_set_mode (sticker, STICKER_MODE_SELECTED);
	_tmp0_ = self->priv->_stickers;
	_tmp1_ = _sticker_ref0 (sticker);
	g_array_append_val (_tmp0_, _tmp1_);
	g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	result = TRUE;
	return result;
}

gboolean
selection_add_group (Selection* self,
                     NodeGroup* group)
{
	GArray* _tmp0_;
	NodeGroup* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	if (selection_is_group_selected (self, group)) {
		result = FALSE;
		return result;
	}
	node_group_set_mode (group, GROUP_MODE_SELECTED);
	_tmp0_ = self->priv->_groups;
	_tmp1_ = _g_object_ref0 (group);
	g_array_append_val (_tmp0_, _tmp1_);
	g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	result = TRUE;
	return result;
}

gboolean
selection_add_callout (Selection* self,
                       Callout* callout)
{
	GArray* _tmp0_;
	Callout* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (callout != NULL, FALSE);
	if (selection_is_callout_selected (self, callout)) {
		result = FALSE;
		return result;
	}
	callout_set_mode (callout, CALLOUT_MODE_SELECTED);
	_tmp0_ = self->priv->_callouts;
	_tmp1_ = _g_object_ref0 (callout);
	g_array_append_val (_tmp0_, _tmp1_);
	g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	result = TRUE;
	return result;
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

gboolean
selection_remove_node (Selection* self,
                       Node* node,
                       gdouble alpha,
                       gboolean signal_change)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	if (selection_is_node_selected (self, node)) {
		DrawArea* _tmp0_;
		_tmp0_ = self->priv->_da;
		draw_area_set_node_mode (_tmp0_, node, NODE_MODE_NONE, TRUE);
		node_set_alpha (node, alpha);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					GArray* _tmp4_;
					Node* _tmp5_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = self->priv->_nodes;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = self->priv->_nodes;
					_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
					if (node == _tmp5_) {
						GArray* _tmp6_;
						Node* _tmp7_;
						Node* _tmp8_;
						GArray* _tmp9_;
						_tmp6_ = self->priv->_nodes;
						_tmp7_ = vala_g_array_remove_index (_tmp6_, (guint) i);
						_tmp8_ = _tmp7_;
						_g_object_unref0 (_tmp8_);
						_tmp9_ = self->priv->_nodes;
						if (_tmp9_->len == ((guint) 1)) {
							DrawArea* _tmp10_;
							GArray* _tmp11_;
							Node* _tmp12_;
							_tmp10_ = self->priv->_da;
							_tmp11_ = self->priv->_nodes;
							_tmp12_ = g_array_index (_tmp11_, Node*, (guint) 0);
							draw_area_set_node_mode (_tmp10_, _tmp12_, NODE_MODE_CURRENT, TRUE);
						}
						if (signal_change) {
							g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
						}
						result = TRUE;
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
selection_remove_child_nodes (Selection* self,
                              Node* node,
                              gdouble alpha)
{
	GArray* children = NULL;
	GArray* _tmp0_;
	gboolean retval = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node_children (node);
	children = _tmp0_;
	retval = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				GArray* _tmp4_;
				Node* _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = children;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = children;
				_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
				retval |= selection_remove_node (self, _tmp5_, alpha, FALSE);
			}
		}
	}
	if (retval) {
		g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	}
	result = retval;
	_g_array_unref0 (children);
	return result;
}

gboolean
selection_remove_node_tree (Selection* self,
                            Node* node,
                            gdouble alpha)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	if (selection_remove_node_tree_helper (self, node, alpha)) {
		g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

gboolean
selection_remove_node_tree_helper (Selection* self,
                                   Node* node,
                                   gdouble alpha)
{
	GArray* children = NULL;
	GArray* _tmp0_;
	gboolean retval = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = node_children (node);
	children = _tmp0_;
	retval = selection_remove_node (self, node, alpha, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				GArray* _tmp4_;
				Node* _tmp5_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = children;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = children;
				_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
				retval |= selection_remove_node_tree_helper (self, _tmp5_, alpha);
			}
		}
	}
	result = retval;
	_g_array_unref0 (children);
	return result;
}

gboolean
selection_remove_nodes_at_level (Selection* self,
                                 Node* node,
                                 gdouble alpha)
{
	guint level = 0U;
	Node* root = NULL;
	Node* _tmp0_;
	Node* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	level = node_get_level (node);
	_tmp0_ = node_get_root (node);
	root = _tmp0_;
	_tmp1_ = root;
	if (selection_remove_nodes_at_level_helper (self, _tmp1_, alpha, level, (guint) 0)) {
		g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
		result = TRUE;
		_g_object_unref0 (root);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (root);
	return result;
}

static gboolean
selection_remove_nodes_at_level_helper (Selection* self,
                                        Node* node,
                                        gdouble alpha,
                                        guint level,
                                        guint curr_level)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	if (level == curr_level) {
		result = selection_remove_node (self, node, alpha, FALSE);
		return result;
	} else {
		GArray* children = NULL;
		GArray* _tmp0_;
		gboolean retval = FALSE;
		_tmp0_ = node_children (node);
		children = _tmp0_;
		retval = FALSE;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					GArray* _tmp4_;
					Node* _tmp5_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = children;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = children;
					_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
					retval |= selection_remove_nodes_at_level_helper (self, _tmp5_, alpha, level, curr_level + 1);
				}
			}
		}
		result = retval;
		_g_array_unref0 (children);
		return result;
	}
}

gboolean
selection_remove_connection (Selection* self,
                             Connection* conn,
                             gdouble alpha)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (conn != NULL, FALSE);
	if (selection_is_connection_selected (self, conn)) {
		DrawArea* _tmp0_;
		_tmp0_ = self->priv->_da;
		draw_area_set_connection_mode (_tmp0_, conn, CONN_MODE_NONE, TRUE);
		connection_set_alpha (conn, alpha);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					GArray* _tmp4_;
					Connection* _tmp5_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = self->priv->_conns;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = self->priv->_conns;
					_tmp5_ = g_array_index (_tmp4_, Connection*, (guint) i);
					if (conn == _tmp5_) {
						GArray* _tmp6_;
						Connection* _tmp7_;
						Connection* _tmp8_;
						_tmp6_ = self->priv->_conns;
						_tmp7_ = vala_g_array_remove_index (_tmp6_, (guint) i);
						_tmp8_ = _tmp7_;
						_g_object_unref0 (_tmp8_);
						g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
						result = TRUE;
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
selection_remove_sticker (Selection* self,
                          Sticker* sticker,
                          gdouble alpha)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sticker != NULL, FALSE);
	if (selection_is_sticker_selected (self, sticker)) {
		sticker_set_mode (sticker, STICKER_MODE_NONE);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					GArray* _tmp2_;
					GArray* _tmp3_;
					Sticker* _tmp4_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = i;
						i = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					_tmp2_ = self->priv->_stickers;
					if (!(((guint) i) < _tmp2_->len)) {
						break;
					}
					_tmp3_ = self->priv->_stickers;
					_tmp4_ = g_array_index (_tmp3_, Sticker*, (guint) i);
					if (sticker == _tmp4_) {
						GArray* _tmp5_;
						Sticker* _tmp6_;
						Sticker* _tmp7_;
						_tmp5_ = self->priv->_stickers;
						_tmp6_ = vala_g_array_remove_index (_tmp5_, (guint) i);
						_tmp7_ = _tmp6_;
						_sticker_unref0 (_tmp7_);
						g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
						result = TRUE;
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
selection_remove_group (Selection* self,
                        NodeGroup* group,
                        gdouble alpha)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	if (selection_is_group_selected (self, group)) {
		node_group_set_mode (group, GROUP_MODE_NONE);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					GArray* _tmp2_;
					GArray* _tmp3_;
					NodeGroup* _tmp4_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = i;
						i = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					_tmp2_ = self->priv->_groups;
					if (!(((guint) i) < _tmp2_->len)) {
						break;
					}
					_tmp3_ = self->priv->_groups;
					_tmp4_ = g_array_index (_tmp3_, NodeGroup*, (guint) i);
					if (group == _tmp4_) {
						GArray* _tmp5_;
						NodeGroup* _tmp6_;
						NodeGroup* _tmp7_;
						_tmp5_ = self->priv->_groups;
						_tmp6_ = vala_g_array_remove_index (_tmp5_, (guint) i);
						_tmp7_ = _tmp6_;
						_g_object_unref0 (_tmp7_);
						g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
						result = TRUE;
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
selection_remove_callout (Selection* self,
                          Callout* callout,
                          gdouble alpha)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (callout != NULL, FALSE);
	if (selection_is_callout_selected (self, callout)) {
		callout_set_mode (callout, CALLOUT_MODE_NONE);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					GArray* _tmp2_;
					GArray* _tmp3_;
					Callout* _tmp4_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = i;
						i = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					_tmp2_ = self->priv->_callouts;
					if (!(((guint) i) < _tmp2_->len)) {
						break;
					}
					_tmp3_ = self->priv->_callouts;
					_tmp4_ = g_array_index (_tmp3_, Callout*, (guint) i);
					if (callout == _tmp4_) {
						GArray* _tmp5_;
						Callout* _tmp6_;
						Callout* _tmp7_;
						_tmp5_ = self->priv->_callouts;
						_tmp6_ = vala_g_array_remove_index (_tmp5_, (guint) i);
						_tmp7_ = _tmp6_;
						_g_object_unref0 (_tmp7_);
						g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
						result = TRUE;
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static gpointer*
vala_g_array_remove_range (GArray* self,
                           guint index,
                           guint length,
                           gint* result_length1)
{
	gpointer* ga = NULL;
	gpointer* _tmp0_;
	gint ga_length1;
	gint _ga_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len >= (index + length), "this.length >= index + length");
	_tmp0_ = g_new0 (gpointer, length);
	ga = _tmp0_;
	ga_length1 = length;
	_ga_size_ = ga_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = ga;
				_tmp3__length1 = ga_length1;
				_tmp4_ = self->data;
				_tmp4__length1 = self->len;
				_tmp5_ = _tmp4_[i + index];
				_tmp4_[i + index] = NULL;
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	g_array_remove_range (self, index, length);
	_tmp6_ = ga;
	_tmp6__length1 = ga_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

gboolean
selection_clear_nodes (Selection* self,
                       gboolean signal_change,
                       gdouble alpha)
{
	guint num = 0U;
	GArray* _tmp0_;
	GArray* _tmp8_;
	gint _tmp9_ = 0;
	gpointer* _tmp10_;
	Node** _tmp11_;
	gint _tmp11__length1;
	gboolean _tmp12_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_nodes;
	num = _tmp0_->len;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				DrawArea* _tmp3_;
				GArray* _tmp4_;
				Node* _tmp5_;
				GArray* _tmp6_;
				Node* _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < num)) {
					break;
				}
				_tmp3_ = self->priv->_da;
				_tmp4_ = self->priv->_nodes;
				_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
				draw_area_set_node_mode (_tmp3_, _tmp5_, NODE_MODE_NONE, TRUE);
				_tmp6_ = self->priv->_nodes;
				_tmp7_ = g_array_index (_tmp6_, Node*, (guint) i);
				node_set_alpha (_tmp7_, alpha);
			}
		}
	}
	_tmp8_ = self->priv->_nodes;
	_tmp10_ = vala_g_array_remove_range (_tmp8_, (guint) 0, num, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp9_;
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_object_unref), NULL);
	if (num > ((guint) 0)) {
		_tmp12_ = signal_change;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	}
	result = num > ((guint) 0);
	return result;
}

gboolean
selection_clear_connections (Selection* self,
                             gboolean signal_change,
                             gdouble alpha)
{
	guint num = 0U;
	GArray* _tmp0_;
	GArray* _tmp8_;
	gint _tmp9_ = 0;
	gpointer* _tmp10_;
	Connection** _tmp11_;
	gint _tmp11__length1;
	gboolean _tmp12_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_conns;
	num = _tmp0_->len;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				DrawArea* _tmp3_;
				GArray* _tmp4_;
				Connection* _tmp5_;
				GArray* _tmp6_;
				Connection* _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < num)) {
					break;
				}
				_tmp3_ = self->priv->_da;
				_tmp4_ = self->priv->_conns;
				_tmp5_ = g_array_index (_tmp4_, Connection*, (guint) i);
				draw_area_set_connection_mode (_tmp3_, _tmp5_, CONN_MODE_NONE, TRUE);
				_tmp6_ = self->priv->_conns;
				_tmp7_ = g_array_index (_tmp6_, Connection*, (guint) i);
				connection_set_alpha (_tmp7_, alpha);
			}
		}
	}
	_tmp8_ = self->priv->_conns;
	_tmp10_ = vala_g_array_remove_range (_tmp8_, (guint) 0, num, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp9_;
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_object_unref), NULL);
	if (num > ((guint) 0)) {
		_tmp12_ = signal_change;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	}
	result = num > ((guint) 0);
	return result;
}

gboolean
selection_clear_stickers (Selection* self,
                          gboolean signal_change)
{
	guint num = 0U;
	GArray* _tmp0_;
	GArray* _tmp5_;
	gint _tmp6_ = 0;
	gpointer* _tmp7_;
	Sticker** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp9_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_stickers;
	num = _tmp0_->len;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				Sticker* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < num)) {
					break;
				}
				_tmp3_ = self->priv->_stickers;
				_tmp4_ = g_array_index (_tmp3_, Sticker*, (guint) i);
				sticker_set_mode (_tmp4_, STICKER_MODE_NONE);
			}
		}
	}
	_tmp5_ = self->priv->_stickers;
	_tmp7_ = vala_g_array_remove_range (_tmp5_, (guint) 0, num, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) sticker_unref), NULL);
	if (num > ((guint) 0)) {
		_tmp9_ = signal_change;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	}
	result = num > ((guint) 0);
	return result;
}

gboolean
selection_clear_groups (Selection* self,
                        gboolean signal_change)
{
	guint num = 0U;
	GArray* _tmp0_;
	GArray* _tmp5_;
	gint _tmp6_ = 0;
	gpointer* _tmp7_;
	NodeGroup** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp9_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_groups;
	num = _tmp0_->len;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				NodeGroup* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < num)) {
					break;
				}
				_tmp3_ = self->priv->_groups;
				_tmp4_ = g_array_index (_tmp3_, NodeGroup*, (guint) i);
				node_group_set_mode (_tmp4_, GROUP_MODE_NONE);
			}
		}
	}
	_tmp5_ = self->priv->_groups;
	_tmp7_ = vala_g_array_remove_range (_tmp5_, (guint) 0, num, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_object_unref), NULL);
	if (num > ((guint) 0)) {
		_tmp9_ = signal_change;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	}
	result = num > ((guint) 0);
	return result;
}

gboolean
selection_clear_callouts (Selection* self,
                          gboolean signal_change,
                          gdouble alpha)
{
	guint num = 0U;
	GArray* _tmp0_;
	GArray* _tmp8_;
	gint _tmp9_ = 0;
	gpointer* _tmp10_;
	Callout** _tmp11_;
	gint _tmp11__length1;
	gboolean _tmp12_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_callouts;
	num = _tmp0_->len;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				DrawArea* _tmp3_;
				GArray* _tmp4_;
				Callout* _tmp5_;
				GArray* _tmp6_;
				Callout* _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < num)) {
					break;
				}
				_tmp3_ = self->priv->_da;
				_tmp4_ = self->priv->_callouts;
				_tmp5_ = g_array_index (_tmp4_, Callout*, (guint) i);
				draw_area_set_callout_mode (_tmp3_, _tmp5_, CALLOUT_MODE_NONE, TRUE);
				_tmp6_ = self->priv->_callouts;
				_tmp7_ = g_array_index (_tmp6_, Callout*, (guint) i);
				callout_set_alpha (_tmp7_, alpha);
			}
		}
	}
	_tmp8_ = self->priv->_callouts;
	_tmp10_ = vala_g_array_remove_range (_tmp8_, (guint) 0, num, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp9_;
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_object_unref), NULL);
	if (num > ((guint) 0)) {
		_tmp12_ = signal_change;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	}
	result = num > ((guint) 0);
	return result;
}

gboolean
selection_clear (Selection* self,
                 gboolean signal_change,
                 gdouble alpha)
{
	gboolean changed = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	changed = FALSE;
	changed |= selection_clear_nodes (self, FALSE, alpha);
	changed |= selection_clear_connections (self, FALSE, alpha);
	changed |= selection_clear_stickers (self, FALSE);
	changed |= selection_clear_groups (self, FALSE);
	changed |= selection_clear_callouts (self, FALSE, alpha);
	if (changed) {
		_tmp0_ = signal_change;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit (self, selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL], 0);
	}
	result = changed;
	return result;
}

gint
selection_num_nodes (Selection* self)
{
	GArray* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_nodes;
	result = (gint) _tmp0_->len;
	return result;
}

gint
selection_num_connections (Selection* self)
{
	GArray* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_conns;
	result = (gint) _tmp0_->len;
	return result;
}

gint
selection_num_stickers (Selection* self)
{
	GArray* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_stickers;
	result = (gint) _tmp0_->len;
	return result;
}

gint
selection_num_groups (Selection* self)
{
	GArray* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_groups;
	result = (gint) _tmp0_->len;
	return result;
}

gint
selection_num_callouts (Selection* self)
{
	GArray* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_callouts;
	result = (gint) _tmp0_->len;
	return result;
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

GArray*
selection_nodes (Selection* self)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	GArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nodes;
	_tmp1_ = _g_array_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GArray*
selection_nodes_copy (Selection* self)
{
	GArray* nodes = NULL;
	GArray* _tmp0_;
	GArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (Node*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_Node_free_function_content_of);
	nodes = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				GArray* _tmp4_;
				GArray* _tmp5_;
				Node* _tmp6_;
				Node* _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_nodes;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = nodes;
				_tmp5_ = self->priv->_nodes;
				_tmp6_ = g_array_index (_tmp5_, Node*, (guint) i);
				_tmp7_ = _g_object_ref0 (_tmp6_);
				g_array_append_val (_tmp4_, _tmp7_);
			}
		}
	}
	result = nodes;
	return result;
}

GArray*
selection_ordered_nodes (Selection* self)
{
	GArray* nodes = NULL;
	GArray* _tmp0_;
	DrawArea* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	GArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (Node*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_Node_free_function_content_of);
	nodes = _tmp0_;
	_tmp1_ = self->priv->_da;
	_tmp2_ = draw_area_get_nodes (_tmp1_);
	_tmp3_ = _tmp2_;
	selection_ordered_nodes_helper (self, _tmp3_, &nodes);
	_g_array_unref0 (_tmp3_);
	result = nodes;
	return result;
}

static void
selection_ordered_nodes_helper (Selection* self,
                                GArray* children,
                                GArray** nodes)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (children != NULL);
	g_return_if_fail (*nodes != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				Node* node = NULL;
				Node* _tmp2_;
				Node* _tmp3_;
				Node* _tmp4_;
				Node* _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < children->len)) {
					break;
				}
				_tmp2_ = g_array_index (children, Node*, (guint) i);
				_tmp3_ = _g_object_ref0 (_tmp2_);
				node = _tmp3_;
				_tmp4_ = node;
				if (node_traversable (_tmp4_)) {
					Node* _tmp5_;
					GArray* _tmp6_;
					GArray* _tmp7_;
					_tmp5_ = node;
					_tmp6_ = node_children (_tmp5_);
					_tmp7_ = _tmp6_;
					selection_ordered_nodes_helper (self, _tmp7_, nodes);
					_g_array_unref0 (_tmp7_);
				}
				_tmp8_ = node;
				if (selection_is_node_selected (self, _tmp8_)) {
					Node* _tmp9_;
					Node* _tmp10_;
					_tmp9_ = node;
					_tmp10_ = _g_object_ref0 (_tmp9_);
					g_array_append_val (*nodes, _tmp10_);
				}
				_g_object_unref0 (node);
			}
		}
	}
}

GArray*
selection_connections (Selection* self)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	GArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_conns;
	_tmp1_ = _g_array_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GArray*
selection_stickers (Selection* self)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	GArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stickers;
	_tmp1_ = _g_array_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GArray*
selection_groups (Selection* self)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	GArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_groups;
	_tmp1_ = _g_array_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GArray*
selection_callouts (Selection* self)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	GArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_callouts;
	_tmp1_ = _g_array_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
selection_get_parents (Selection* self,
                       GArray** parents)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*parents != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				Node* node = NULL;
				GArray* _tmp3_;
				Node* _tmp4_;
				Node* _tmp5_;
				Node* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_nodes;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_nodes;
				_tmp4_ = g_array_index (_tmp3_, Node*, (guint) i);
				_tmp5_ = _g_object_ref0 (_tmp4_);
				node = _tmp5_;
				_tmp6_ = node;
				if (node_is_root (_tmp6_)) {
					Node* _tmp7_;
					Node* _tmp8_;
					_tmp7_ = node;
					_tmp8_ = _g_object_ref0 (_tmp7_);
					g_array_append_val (*parents, _tmp8_);
				} else {
					Node* parent = NULL;
					Node* _tmp9_;
					Node* _tmp10_;
					Node* _tmp11_;
					Node* _tmp12_;
					Node* _tmp20_;
					_tmp9_ = node;
					_tmp10_ = node_get_parent (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = _g_object_ref0 (_tmp11_);
					parent = _tmp12_;
					while (TRUE) {
						gboolean _tmp13_ = FALSE;
						Node* _tmp14_;
						Node* _tmp16_;
						Node* _tmp17_;
						Node* _tmp18_;
						Node* _tmp19_;
						_tmp14_ = parent;
						if (_tmp14_ != NULL) {
							Node* _tmp15_;
							_tmp15_ = parent;
							_tmp13_ = !selection_is_node_selected (self, _tmp15_);
						} else {
							_tmp13_ = FALSE;
						}
						if (!_tmp13_) {
							break;
						}
						_tmp16_ = parent;
						_tmp17_ = node_get_parent (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp19_ = _g_object_ref0 (_tmp18_);
						_g_object_unref0 (parent);
						parent = _tmp19_;
					}
					_tmp20_ = parent;
					if (_tmp20_ == NULL) {
						Node* _tmp21_;
						Node* _tmp22_;
						_tmp21_ = node;
						_tmp22_ = _g_object_ref0 (_tmp21_);
						g_array_append_val (*parents, _tmp22_);
					}
					_g_object_unref0 (parent);
				}
				_g_object_unref0 (node);
			}
		}
	}
}

void
selection_get_subtrees (Selection* self,
                        GArray** subtrees,
                        ImageManager* im)
{
	GArray* parents = NULL;
	GArray* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*subtrees != NULL);
	g_return_if_fail (im != NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (Node*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_Node_free_function_content_of);
	parents = _tmp0_;
	selection_get_parents (self, &parents);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				Node* old_parent = NULL;
				GArray* _tmp4_;
				Node* _tmp5_;
				Node* _tmp6_;
				Node* node = NULL;
				DrawArea* _tmp7_;
				Node* _tmp8_;
				Layout* _tmp9_;
				Layout* _tmp10_;
				Node* _tmp11_;
				Node* _tmp12_;
				Node* _tmp13_;
				Node* _tmp14_;
				Node* _tmp15_;
				Node* _tmp16_;
				Node* _tmp17_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = parents;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = parents;
				_tmp5_ = g_array_index (_tmp4_, Node*, (guint) i);
				_tmp6_ = _g_object_ref0 (_tmp5_);
				old_parent = _tmp6_;
				_tmp7_ = self->priv->_da;
				_tmp8_ = old_parent;
				_tmp9_ = node_get_layout (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = node_new (_tmp7_, _tmp10_);
				node = _tmp11_;
				_tmp12_ = node;
				_tmp13_ = old_parent;
				node_copy_variables (_tmp12_, _tmp13_, im);
				_tmp14_ = node;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				g_array_append_val (*subtrees, _tmp15_);
				_tmp16_ = old_parent;
				_tmp17_ = node;
				selection_get_subtrees_helper (self, _tmp16_, _tmp17_, im);
				_g_object_unref0 (node);
				_g_object_unref0 (old_parent);
			}
		}
	}
	_g_array_unref0 (parents);
}

static void
selection_get_subtrees_helper (Selection* self,
                               Node* old_parent,
                               Node* new_parent,
                               ImageManager* im)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_parent != NULL);
	g_return_if_fail (new_parent != NULL);
	g_return_if_fail (im != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				gboolean _tmp4_;
				Node* old_child = NULL;
				GArray* _tmp5_;
				GArray* _tmp6_;
				Node* _tmp7_;
				Node* _tmp8_;
				Node* _tmp9_;
				Node* _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = node_children (old_parent);
				_tmp3_ = _tmp2_;
				_tmp4_ = !(((guint) i) < _tmp3_->len);
				_g_array_unref0 (_tmp3_);
				if (_tmp4_) {
					break;
				}
				_tmp5_ = node_children (old_parent);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_array_index (_tmp6_, Node*, (guint) i);
				_tmp8_ = _g_object_ref0 (_tmp7_);
				_tmp9_ = _tmp8_;
				_g_array_unref0 (_tmp6_);
				old_child = _tmp9_;
				_tmp10_ = old_child;
				if (selection_is_node_selected (self, _tmp10_)) {
					Node* node = NULL;
					DrawArea* _tmp11_;
					Node* _tmp12_;
					Layout* _tmp13_;
					Layout* _tmp14_;
					Node* _tmp15_;
					Node* _tmp16_;
					Node* _tmp17_;
					Node* _tmp18_;
					Node* _tmp19_;
					Node* _tmp20_;
					_tmp11_ = self->priv->_da;
					_tmp12_ = old_child;
					_tmp13_ = node_get_layout (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = node_new (_tmp11_, _tmp14_);
					node = _tmp15_;
					_tmp16_ = node;
					_tmp17_ = old_child;
					node_copy_variables (_tmp16_, _tmp17_, im);
					_tmp18_ = node;
					node_attach (_tmp18_, new_parent, -1, NULL, TRUE);
					_tmp19_ = old_child;
					_tmp20_ = node;
					selection_get_subtrees_helper (self, _tmp19_, _tmp20_, im);
					_g_object_unref0 (node);
				} else {
					Node* _tmp21_;
					_tmp21_ = old_child;
					selection_get_subtrees_helper (self, _tmp21_, new_parent, im);
				}
				_g_object_unref0 (old_child);
			}
		}
	}
}

static void
value_selection_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_selection_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		selection_unref (value->data[0].v_pointer);
	}
}

static void
value_selection_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = selection_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_selection_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_selection_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Selection * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = selection_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_selection_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	Selection ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = selection_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_selection (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecSelection* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SELECTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_selection (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SELECTION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_selection (GValue* value,
                     gpointer v_object)
{
	Selection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SELECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SELECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		selection_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		selection_unref (old);
	}
}

void
value_take_selection (GValue* value,
                      gpointer v_object)
{
	Selection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SELECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SELECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		selection_unref (old);
	}
}

static void
selection_class_init (SelectionClass * klass,
                      gpointer klass_data)
{
	selection_parent_class = g_type_class_peek_parent (klass);
	((SelectionClass *) klass)->finalize = selection_finalize;
	g_type_class_adjust_private_offset (klass, &Selection_private_offset);
	selection_signals[SELECTION_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", TYPE_SELECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
selection_instance_init (Selection * self,
                         gpointer klass)
{
	self->priv = selection_get_instance_private (self);
	self->ref_count = 1;
}

static void
selection_finalize (Selection * obj)
{
	Selection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SELECTION, Selection);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_da);
	_g_array_unref0 (self->priv->_nodes);
	_g_array_unref0 (self->priv->_conns);
	_g_array_unref0 (self->priv->_stickers);
	_g_array_unref0 (self->priv->_groups);
	_g_array_unref0 (self->priv->_callouts);
}

static GType
selection_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_selection_init, value_selection_free_value, value_selection_copy_value, value_selection_peek_pointer, "p", value_selection_collect_value, "p", value_selection_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SelectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) selection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Selection), 0, (GInstanceInitFunc) selection_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType selection_type_id;
	selection_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Selection", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Selection_private_offset = g_type_add_instance_private (selection_type_id, sizeof (SelectionPrivate));
	return selection_type_id;
}

GType
selection_get_type (void)
{
	static volatile gsize selection_type_id__once = 0;
	if (g_once_init_enter (&selection_type_id__once)) {
		GType selection_type_id;
		selection_type_id = selection_get_type_once ();
		g_once_init_leave (&selection_type_id__once, selection_type_id);
	}
	return selection_type_id__once;
}

gpointer
selection_ref (gpointer instance)
{
	Selection * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
selection_unref (gpointer instance)
{
	Selection * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SELECTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

