/* QuickEntry.c generated by valac 0.56.18, the Vala compiler
 * generated from QuickEntry.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <handy.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_QUICK_ENTRY (quick_entry_get_type ())
#define QUICK_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUICK_ENTRY, QuickEntry))
#define QUICK_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUICK_ENTRY, QuickEntryClass))
#define IS_QUICK_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUICK_ENTRY))
#define IS_QUICK_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUICK_ENTRY))
#define QUICK_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUICK_ENTRY, QuickEntryClass))

typedef struct _QuickEntry QuickEntry;
typedef struct _QuickEntryClass QuickEntryClass;
typedef struct _QuickEntryPrivate QuickEntryPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_NODE_HIER (node_hier_get_type ())
#define NODE_HIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_HIER, NodeHier))
#define NODE_HIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_HIER, NodeHierClass))
#define IS_NODE_HIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_HIER))
#define IS_NODE_HIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_HIER))
#define NODE_HIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_HIER, NodeHierClass))

typedef struct _NodeHier NodeHier;
typedef struct _NodeHierClass NodeHierClass;

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;

#define TYPE_EXPORT_TEXT (export_text_get_type ())
#define EXPORT_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_TEXT, ExportText))
#define EXPORT_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_TEXT, ExportTextClass))
#define IS_EXPORT_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_TEXT))
#define IS_EXPORT_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_TEXT))
#define EXPORT_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_TEXT, ExportTextClass))

typedef struct _ExportText ExportText;
typedef struct _ExportTextClass ExportTextClass;
enum  {
	QUICK_ENTRY_0_PROPERTY,
	QUICK_ENTRY_NUM_PROPERTIES
};
static GParamSpec* quick_entry_properties[QUICK_ENTRY_NUM_PROPERTIES];
typedef enum  {
	DRAG_TYPES_URI,
	DRAG_TYPES_STICKER
} DragTypes;

#define TYPE_DRAG_TYPES (drag_types_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _export_unref0(var) ((var == NULL) ? NULL : (var = (export_unref (var), NULL)))
typedef struct _Block36Data Block36Data;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_EXPORTS (exports_get_type ())
#define EXPORTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTS, Exports))
#define EXPORTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTS, ExportsClass))
#define IS_EXPORTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTS))
#define IS_EXPORTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTS))
#define EXPORTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTS, ExportsClass))

typedef struct _Exports Exports;
typedef struct _ExportsClass ExportsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _NodeHierPrivate NodeHierPrivate;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
#define _node_hier_unref0(var) ((var == NULL) ? NULL : (var = (node_hier_unref (var), NULL)))

#define TYPE_NODE_IMAGE (node_image_get_type ())
#define NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_IMAGE, NodeImage))
#define NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_IMAGE, NodeImageClass))
#define IS_NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_IMAGE))
#define IS_NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_IMAGE))
#define NODE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_IMAGE, NodeImageClass))

typedef struct _NodeImage NodeImage;
typedef struct _NodeImageClass NodeImageClass;

#define TYPE_IMAGE_MANAGER (image_manager_get_type ())
#define IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_MANAGER, ImageManager))
#define IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_MANAGER, ImageManagerClass))
#define IS_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_MANAGER))
#define IS_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_MANAGER))
#define IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_MANAGER, ImageManagerClass))

typedef struct _ImageManager ImageManager;
typedef struct _ImageManagerClass ImageManagerClass;
#define _node_image_unref0(var) ((var == NULL) ? NULL : (var = (node_image_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_GtkTextIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTextIter_free (var), NULL)))

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;

#define TYPE_UNDO_ITEM (undo_item_get_type ())
#define UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_ITEM, UndoItem))
#define UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_ITEM, UndoItemClass))
#define IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_ITEM))
#define IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_ITEM))
#define UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_ITEM, UndoItemClass))

typedef struct _UndoItem UndoItem;
typedef struct _UndoItemClass UndoItemClass;

#define TYPE_UNDO_NODES_INSERT (undo_nodes_insert_get_type ())
#define UNDO_NODES_INSERT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_NODES_INSERT, UndoNodesInsert))
#define UNDO_NODES_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_NODES_INSERT, UndoNodesInsertClass))
#define IS_UNDO_NODES_INSERT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_NODES_INSERT))
#define IS_UNDO_NODES_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_NODES_INSERT))
#define UNDO_NODES_INSERT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_NODES_INSERT, UndoNodesInsertClass))

typedef struct _UndoNodesInsert UndoNodesInsert;
typedef struct _UndoNodesInsertClass UndoNodesInsertClass;

#define TYPE_UNDO_NODES_REPLACE (undo_nodes_replace_get_type ())
#define UNDO_NODES_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_NODES_REPLACE, UndoNodesReplace))
#define UNDO_NODES_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_NODES_REPLACE, UndoNodesReplaceClass))
#define IS_UNDO_NODES_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_NODES_REPLACE))
#define IS_UNDO_NODES_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_NODES_REPLACE))
#define UNDO_NODES_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_NODES_REPLACE, UndoNodesReplaceClass))

typedef struct _UndoNodesReplace UndoNodesReplace;
typedef struct _UndoNodesReplaceClass UndoNodesReplaceClass;

struct _QuickEntry {
	GtkWindow parent_instance;
	QuickEntryPrivate * priv;
};

struct _QuickEntryClass {
	GtkWindowClass parent_class;
};

struct _QuickEntryPrivate {
	DrawArea* _da;
	GtkTextView* _entry;
	GtkButton* _apply;
	GArray* _node_stack;
	ExportText* _export;
};

struct _Block36Data {
	int _ref_count_;
	QuickEntry* self;
	GtkRevealer* helprev;
	GtkLabel* help_node0;
	GtkLabel* help_node1;
};

struct _NodeHier {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NodeHierPrivate * priv;
	gint spaces;
	Node* node;
	gboolean in_sequence;
	gint first_line;
	gint last_line;
};

struct _NodeHierClass {
	GTypeClass parent_class;
	void (*finalize) (NodeHier *self);
};

static gint QuickEntry_private_offset;
static gpointer quick_entry_parent_class = NULL;

VALA_EXTERN GType quick_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (QuickEntry, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN gpointer node_hier_ref (gpointer instance);
VALA_EXTERN void node_hier_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_hier (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_node_hier (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_node_hier (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_node_hier (const GValue* value);
VALA_EXTERN GType node_hier_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeHier, node_hier_unref)
VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType export_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportText, export_unref)
VALA_EXTERN GType drag_types_get_type (void) G_GNUC_CONST ;
VALA_EXTERN QuickEntry* quick_entry_new (DrawArea* da,
                             gboolean replace,
                             GSettings* settings);
VALA_EXTERN QuickEntry* quick_entry_construct (GType object_type,
                                   DrawArea* da,
                                   gboolean replace,
                                   GSettings* settings);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN MainWindow* draw_area_get_win (DrawArea* self);
VALA_EXTERN gpointer exports_ref (gpointer instance);
VALA_EXTERN void exports_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_exports (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_exports (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_exports (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_exports (const GValue* value);
VALA_EXTERN GType exports_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Exports, exports_unref)
VALA_EXTERN Exports* main_window_get_exports (MainWindow* self);
VALA_EXTERN Export* exports_get_by_name (Exports* self,
                             const gchar* name);
static gboolean quick_entry_on_keypress (QuickEntry* self,
                                  GdkEventKey* e);
static gboolean _quick_entry_on_keypress_gtk_widget_key_press_event (GtkWidget* _sender,
                                                              GdkEventKey* event,
                                                              gpointer self);
static void quick_entry_handle_text_insertion (QuickEntry* self,
                                        GtkTextIter* pos,
                                        const gchar* new_text,
                                        gint new_text_length);
static void _quick_entry_handle_text_insertion_gtk_text_buffer_insert_text (GtkTextBuffer* _sender,
                                                                     GtkTextIter* pos,
                                                                     const gchar* new_text,
                                                                     gint new_text_length,
                                                                     gpointer self);
VALA_EXTERN void utils_color_from_string (const gchar* value,
                              GdkRGBA* result);
static void __lambda133_ (QuickEntry* self,
                   GtkAllocation* alloc);
static void ___lambda133__gtk_widget_size_allocate (GtkWidget* _sender,
                                             GtkAllocation* allocation,
                                             gpointer self);
static GtkLabel* quick_entry_make_help_label (QuickEntry* self,
                                       const gchar* str);
static void __lambda134_ (Block36Data* _data36_);
static void ___lambda134__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void ___lambda135_ (Block36Data* _data36_);
static gboolean quick_entry_handle_replace (QuickEntry* self);
static void ____lambda135__gtk_button_clicked (GtkButton* _sender,
                                        gpointer self);
VALA_EXTERN gboolean draw_area_is_node_selected (DrawArea* self);
static void ___lambda136_ (Block36Data* _data36_);
static gboolean quick_entry_handle_insert (QuickEntry* self);
static void ____lambda136__gtk_button_clicked (GtkButton* _sender,
                                        gpointer self);
static void __lambda137_ (QuickEntry* self);
static void ___lambda137__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static gboolean quick_entry_handle_drag_motion (QuickEntry* self,
                                         GdkDragContext* ctx,
                                         gint x,
                                         gint y,
                                         guint t);
static gboolean _quick_entry_handle_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                                 GdkDragContext* context,
                                                                 gint x,
                                                                 gint y,
                                                                 guint time_,
                                                                 gpointer self);
static void quick_entry_handle_drag_data_received (QuickEntry* self,
                                            GdkDragContext* ctx,
                                            gint x,
                                            gint y,
                                            GtkSelectionData* data,
                                            guint info,
                                            guint t);
static void _quick_entry_handle_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                           GdkDragContext* context,
                                                                           gint x,
                                                                           gint y,
                                                                           GtkSelectionData* selection_data,
                                                                           guint info,
                                                                           guint time_,
                                                                           gpointer self);
static void quick_entry_clear_node_tag (QuickEntry* self);
static void _node_hier_unref0_ (gpointer var);
static void _vala_NodeHier_free_function_content_of (gpointer data);
VALA_EXTERN gboolean export_text_parse_text (ExportText* self,
                                 DrawArea* da,
                                 const gchar* txt,
                                 gint tab_spaces,
                                 GArray* stack);
VALA_EXTERN GSettings* draw_area_get_settings (DrawArea* self);
VALA_EXTERN NodeHier* export_text_get_node_at_line (ExportText* self,
                                        GArray* stack,
                                        gint current_line);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN gpointer node_image_ref (gpointer instance);
VALA_EXTERN void node_image_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_image (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_node_image (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_node_image (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_node_image (const GValue* value);
VALA_EXTERN GType node_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeImage, node_image_unref)
VALA_EXTERN gpointer image_manager_ref (gpointer instance);
VALA_EXTERN void image_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_image_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_image_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_image_manager (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_image_manager (const GValue* value);
VALA_EXTERN GType image_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageManager, image_manager_unref)
VALA_EXTERN ImageManager* draw_area_get_image_manager (DrawArea* self);
VALA_EXTERN NodeImage* node_image_new_from_uri (ImageManager* im,
                                    const gchar* uri,
                                    gint width);
VALA_EXTERN NodeImage* node_image_construct_from_uri (GType object_type,
                                          ImageManager* im,
                                          const gchar* uri,
                                          gint width);
VALA_EXTERN void node_set_image (Node* self,
                     ImageManager* im,
                     NodeImage* ni);
VALA_EXTERN gchar* export_text_export_node (ExportText* self,
                                DrawArea* da,
                                Node* node,
                                const gchar* prefix);
static gchar* quick_entry_get_line_text (QuickEntry* self,
                                  gint adjust);
static gchar* quick_entry_get_start_to_current_text (QuickEntry* self);
static gboolean quick_entry_get_whitespace (QuickEntry* self,
                                     const gchar* line,
                                     gchar** wspace);
static gboolean quick_entry_is_node_line (QuickEntry* self,
                                   const gchar* line);
static gboolean quick_entry_is_blank_line (QuickEntry* self,
                                    const gchar* line);
static gchar* quick_entry_tabs_to_spaces (QuickEntry* self,
                                   const gchar* wspace);
static gchar* quick_entry_align_to_tab (QuickEntry* self,
                                 const gchar* wspace);
static void quick_entry_delete_whitespace (QuickEntry* self,
                                    const gchar* ins_text);
static void _vala_GtkTextIter_free (GtkTextIter* self);
static gboolean quick_entry_handle_space (QuickEntry* self);
static gboolean quick_entry_handle_return (QuickEntry* self,
                                    gboolean control);
static gboolean quick_entry_handle_tab (QuickEntry* self,
                                 gboolean shift);
static gboolean quick_entry_handle_printable (QuickEntry* self,
                                       const gchar* str);
static void _g_object_unref0_ (gpointer var);
static void _vala_Node_free_function_content_of (gpointer data);
VALA_EXTERN Node* draw_area_get_current_node (DrawArea* self);
VALA_EXTERN void export_text_import_text (ExportText* self,
                              const gchar* txt,
                              gint tab_spaces,
                              DrawArea* da,
                              gboolean replace,
                              GArray* nodes);
VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN UndoBuffer* draw_area_get_undo_buffer (DrawArea* self);
VALA_EXTERN GType undo_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoItem, g_object_unref)
VALA_EXTERN void undo_buffer_add_item (UndoBuffer* self,
                           UndoItem* item);
VALA_EXTERN UndoNodesInsert* undo_nodes_insert_new (DrawArea* da,
                                        GArray* nodes);
VALA_EXTERN UndoNodesInsert* undo_nodes_insert_construct (GType object_type,
                                              DrawArea* da,
                                              GArray* nodes);
VALA_EXTERN GType undo_nodes_insert_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoNodesInsert, g_object_unref)
VALA_EXTERN void draw_area_set_current_node (DrawArea* self,
                                 Node* n);
VALA_EXTERN void draw_area_auto_save (DrawArea* self);
VALA_EXTERN void draw_area_see (DrawArea* self,
                    gboolean animate,
                    gdouble width_adjust,
                    gdouble pad);
VALA_EXTERN Node* node_get_parent (Node* self);
VALA_EXTERN UndoNodesReplace* undo_nodes_replace_new (Node* orig_node,
                                          GArray* new_nodes);
VALA_EXTERN UndoNodesReplace* undo_nodes_replace_construct (GType object_type,
                                                Node* orig_node,
                                                GArray* new_nodes);
VALA_EXTERN GType undo_nodes_replace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoNodesReplace, g_object_unref)
VALA_EXTERN void quick_entry_preload (QuickEntry* self,
                          const gchar* value);
static void quick_entry_finalize (GObject * obj);
static GType quick_entry_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const GtkTargetEntry QUICK_ENTRY_DRAG_TARGETS[1] = {{"text/uri-list", (guint) 0, (guint) DRAG_TYPES_URI}};

static inline gpointer
quick_entry_get_instance_private (QuickEntry* self)
{
	return G_STRUCT_MEMBER_P (self, QuickEntry_private_offset);
}

static Block36Data*
block36_data_ref (Block36Data* _data36_)
{
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}

static void
block36_data_unref (void * _userdata_)
{
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		QuickEntry* self;
		self = _data36_->self;
		_g_object_unref0 (_data36_->help_node1);
		_g_object_unref0 (_data36_->help_node0);
		_g_object_unref0 (_data36_->helprev);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_quick_entry_on_keypress_gtk_widget_key_press_event (GtkWidget* _sender,
                                                     GdkEventKey* event,
                                                     gpointer self)
{
	gboolean result;
	result = quick_entry_on_keypress ((QuickEntry*) self, event);
	return result;
}

static void
_quick_entry_handle_text_insertion_gtk_text_buffer_insert_text (GtkTextBuffer* _sender,
                                                                GtkTextIter* pos,
                                                                const gchar* new_text,
                                                                gint new_text_length,
                                                                gpointer self)
{
	quick_entry_handle_text_insertion ((QuickEntry*) self, pos, new_text, new_text_length);
}

static void
__lambda133_ (QuickEntry* self,
              GtkAllocation* alloc)
{
	gint _tmp0_ = 0;
	GtkAllocation _tmp1_;
	gint new_margin = 0;
	GtkTextView* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (alloc != NULL);
	_tmp1_ = *alloc;
	if ((_tmp1_.height - 100) < 0) {
		_tmp0_ = 0;
	} else {
		GtkAllocation _tmp2_;
		_tmp2_ = *alloc;
		_tmp0_ = _tmp2_.height - 100;
	}
	new_margin = _tmp0_;
	_tmp3_ = self->priv->_entry;
	_tmp4_ = gtk_text_view_get_bottom_margin (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != new_margin) {
		GtkTextView* _tmp6_;
		_tmp6_ = self->priv->_entry;
		gtk_text_view_set_bottom_margin (_tmp6_, new_margin);
	}
}

static void
___lambda133__gtk_widget_size_allocate (GtkWidget* _sender,
                                        GtkAllocation* allocation,
                                        gpointer self)
{
	__lambda133_ ((QuickEntry*) self, allocation);
}

static void
__lambda134_ (Block36Data* _data36_)
{
	QuickEntry* self;
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data36_->self;
	_tmp0_ = _data36_->helprev;
	_tmp1_ = _data36_->helprev;
	_tmp2_ = gtk_revealer_get_reveal_child (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_revealer_set_reveal_child (_tmp0_, !_tmp3_);
}

static void
___lambda134__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda134_ (self);
}

static void
___lambda135_ (Block36Data* _data36_)
{
	QuickEntry* self;
	self = _data36_->self;
	if (quick_entry_handle_replace (self)) {
		gtk_window_close ((GtkWindow*) self);
	} else {
		GtkRevealer* _tmp0_;
		GtkLabel* _tmp1_;
		GtkStyleContext* _tmp2_;
		GtkLabel* _tmp3_;
		GtkStyleContext* _tmp4_;
		_tmp0_ = _data36_->helprev;
		gtk_revealer_set_reveal_child (_tmp0_, TRUE);
		_tmp1_ = _data36_->help_node0;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
		gtk_style_context_add_class (_tmp2_, "highlighted");
		_tmp3_ = _data36_->help_node1;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		gtk_style_context_add_class (_tmp4_, "highlighted");
	}
}

static void
____lambda135__gtk_button_clicked (GtkButton* _sender,
                                   gpointer self)
{
	___lambda135_ (self);
}

static void
___lambda136_ (Block36Data* _data36_)
{
	QuickEntry* self;
	self = _data36_->self;
	if (quick_entry_handle_insert (self)) {
		gtk_window_close ((GtkWindow*) self);
	} else {
		GtkRevealer* _tmp0_;
		GtkLabel* _tmp1_;
		GtkStyleContext* _tmp2_;
		GtkLabel* _tmp3_;
		GtkStyleContext* _tmp4_;
		_tmp0_ = _data36_->helprev;
		gtk_revealer_set_reveal_child (_tmp0_, TRUE);
		_tmp1_ = _data36_->help_node0;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
		gtk_style_context_add_class (_tmp2_, "highlighted");
		_tmp3_ = _data36_->help_node1;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		gtk_style_context_add_class (_tmp4_, "highlighted");
	}
}

static void
____lambda136__gtk_button_clicked (GtkButton* _sender,
                                   gpointer self)
{
	___lambda136_ (self);
}

static void
__lambda137_ (QuickEntry* self)
{
	gtk_window_close ((GtkWindow*) self);
}

static void
___lambda137__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda137_ ((QuickEntry*) self);
}

static gboolean
_quick_entry_handle_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                        GdkDragContext* context,
                                                        gint x,
                                                        gint y,
                                                        guint time_,
                                                        gpointer self)
{
	gboolean result;
	result = quick_entry_handle_drag_motion ((QuickEntry*) self, context, x, y, time_);
	return result;
}

static void
_quick_entry_handle_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                      GdkDragContext* context,
                                                                      gint x,
                                                                      gint y,
                                                                      GtkSelectionData* selection_data,
                                                                      guint info,
                                                                      guint time_,
                                                                      gpointer self)
{
	quick_entry_handle_drag_data_received ((QuickEntry*) self, context, x, y, selection_data, info, time_);
}

QuickEntry*
quick_entry_construct (GType object_type,
                       DrawArea* da,
                       gboolean replace,
                       GSettings* settings)
{
	QuickEntry * self = NULL;
	Block36Data* _data36_;
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	DrawArea* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* _tmp4_;
	Exports* _tmp5_;
	Exports* _tmp6_;
	Export* _tmp7_;
	GtkBox* box = NULL;
	GtkBox* _tmp8_;
	GtkTextView* _tmp9_;
	GtkTextView* _tmp10_;
	GtkTextView* _tmp11_;
	GtkTextView* _tmp12_;
	GtkTextView* _tmp13_;
	GtkStyleContext* _tmp14_;
	GtkTextView* _tmp15_;
	GtkTextView* _tmp16_;
	GtkTextBuffer* _tmp17_;
	GtkTextBuffer* _tmp18_;
	GtkTextView* _tmp19_;
	GtkTextBuffer* _tmp20_;
	GtkTextBuffer* _tmp21_;
	GdkRGBA _tmp22_ = {0};
	GtkTextView* _tmp23_;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp24_;
	GtkScrolledWindow* _tmp25_;
	GtkTextView* _tmp26_;
	GtkRevealer* _tmp27_;
	GtkGrid* helpgrid = NULL;
	GtkGrid* _tmp28_;
	GtkGrid* _tmp29_;
	GtkLabel* help_title = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* help_line = NULL;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GtkLabel* _tmp36_;
	GtkLabel* _tmp37_;
	GtkLabel* help_tab0 = NULL;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GtkLabel* _tmp42_;
	GtkLabel* _tmp43_;
	GtkLabel* help_tab1 = NULL;
	gchar* _tmp44_;
	gchar* _tmp45_;
	GtkLabel* _tmp46_;
	GtkLabel* _tmp47_;
	GtkLabel* help_hdr0 = NULL;
	GtkLabel* _tmp48_;
	GtkLabel* help_hdr1 = NULL;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GtkLabel* _tmp51_;
	GtkLabel* _tmp52_;
	GtkLabel* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	GtkLabel* _tmp56_;
	GtkLabel* _tmp57_;
	GtkLabel* help_note0 = NULL;
	GtkLabel* _tmp58_;
	GtkLabel* help_note1 = NULL;
	gchar* _tmp59_;
	gchar* _tmp60_;
	GtkLabel* _tmp61_;
	GtkLabel* _tmp62_;
	GtkLabel* help_img0 = NULL;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	GtkLabel* _tmp67_;
	GtkLabel* _tmp68_;
	GtkLabel* help_img1 = NULL;
	gchar* _tmp69_;
	gchar* _tmp70_;
	GtkLabel* _tmp71_;
	GtkLabel* _tmp72_;
	GtkLabel* help_utsk0 = NULL;
	GtkLabel* _tmp73_;
	GtkLabel* help_utsk1 = NULL;
	gchar* _tmp74_;
	gchar* _tmp75_;
	GtkLabel* _tmp76_;
	GtkLabel* _tmp77_;
	GtkLabel* help_ctsk0 = NULL;
	GtkLabel* _tmp78_;
	GtkLabel* help_ctsk1 = NULL;
	gchar* _tmp79_;
	gchar* _tmp80_;
	GtkLabel* _tmp81_;
	GtkLabel* _tmp82_;
	GtkGrid* _tmp83_;
	GtkLabel* _tmp84_;
	GtkGrid* _tmp85_;
	GtkLabel* _tmp86_;
	GtkGrid* _tmp87_;
	GtkLabel* _tmp88_;
	GtkGrid* _tmp89_;
	GtkLabel* _tmp90_;
	GtkGrid* _tmp91_;
	GtkLabel* _tmp92_;
	GtkGrid* _tmp93_;
	GtkLabel* _tmp94_;
	GtkGrid* _tmp95_;
	GtkLabel* _tmp96_;
	GtkGrid* _tmp97_;
	GtkLabel* _tmp98_;
	GtkGrid* _tmp99_;
	GtkLabel* _tmp100_;
	GtkGrid* _tmp101_;
	GtkLabel* _tmp102_;
	GtkGrid* _tmp103_;
	GtkLabel* _tmp104_;
	GtkGrid* _tmp105_;
	GtkLabel* _tmp106_;
	GtkGrid* _tmp107_;
	GtkLabel* _tmp108_;
	GtkGrid* _tmp109_;
	GtkLabel* _tmp110_;
	GtkGrid* _tmp111_;
	GtkLabel* _tmp112_;
	GtkGrid* _tmp113_;
	GtkLabel* _tmp114_;
	GtkRevealer* _tmp115_;
	GtkRevealer* _tmp116_;
	GtkGrid* _tmp117_;
	GtkBox* bbox = NULL;
	GtkBox* _tmp118_;
	GtkBox* _tmp119_;
	GtkButton* info = NULL;
	GtkButton* _tmp120_;
	GtkButton* _tmp121_;
	GtkButton* _tmp122_;
	GtkBox* _tmp123_;
	GtkButton* _tmp124_;
	GtkButton* cancel = NULL;
	GtkButton* _tmp138_;
	GtkBox* _tmp139_;
	GtkBox* _tmp140_;
	GtkScrolledWindow* _tmp141_;
	GtkBox* _tmp142_;
	GtkBox* _tmp143_;
	GtkBox* _tmp144_;
	GtkRevealer* _tmp145_;
	GtkBox* _tmp146_;
	GtkTextView* _tmp147_;
	GtkTextView* _tmp148_;
	GtkTextView* _tmp149_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	self = (QuickEntry*) g_object_new (object_type, NULL);
	_data36_->self = g_object_ref (self);
	g_object_set ((GtkWindow*) self, "default-width", 500, NULL);
	g_object_set ((GtkWindow*) self, "default-height", 500, NULL);
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
	gtk_window_set_deletable ((GtkWindow*) self, FALSE);
	gtk_window_set_title ((GtkWindow*) self, _ ("Quick Entry"));
	_tmp0_ = draw_area_get_win (da);
	_tmp1_ = _tmp0_;
	gtk_window_set_transient_for ((GtkWindow*) self, (GtkWindow*) _tmp1_);
	g_object_set ((GtkWindow*) self, "window-position", GTK_WIN_POS_CENTER_ON_PARENT, NULL);
	_tmp2_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp2_;
	_tmp3_ = draw_area_get_win (da);
	_tmp4_ = _tmp3_;
	_tmp5_ = main_window_get_exports (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = exports_get_by_name (_tmp6_, "text");
	_export_unref0 (self->priv->_export);
	self->priv->_export = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_EXPORT_TEXT, ExportText);
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp8_);
	box = _tmp8_;
	_tmp9_ = (GtkTextView*) gtk_text_view_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->_entry);
	self->priv->_entry = _tmp9_;
	_tmp10_ = self->priv->_entry;
	gtk_container_set_border_width ((GtkContainer*) _tmp10_, (guint) 5);
	_tmp11_ = self->priv->_entry;
	gtk_text_view_set_bottom_margin (_tmp11_, 0);
	_tmp12_ = self->priv->_entry;
	gtk_text_view_set_wrap_mode (_tmp12_, GTK_WRAP_WORD);
	_tmp13_ = self->priv->_entry;
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
	gtk_style_context_add_class (_tmp14_, "textfield");
	_tmp15_ = self->priv->_entry;
	g_signal_connect_object ((GtkWidget*) _tmp15_, "key-press-event", (GCallback) _quick_entry_on_keypress_gtk_widget_key_press_event, self, 0);
	_tmp16_ = self->priv->_entry;
	_tmp17_ = gtk_text_view_get_buffer (_tmp16_);
	_tmp18_ = _tmp17_;
	g_signal_connect_object (_tmp18_, "insert-text", (GCallback) _quick_entry_handle_text_insertion_gtk_text_buffer_insert_text, self, 0);
	_tmp19_ = self->priv->_entry;
	_tmp20_ = gtk_text_view_get_buffer (_tmp19_);
	_tmp21_ = _tmp20_;
	utils_color_from_string ("grey90", &_tmp22_);
	gtk_text_buffer_create_tag (_tmp21_, "node", "background_rgba", &_tmp22_, NULL, NULL);
	_tmp23_ = self->priv->_entry;
	g_signal_connect_object ((GtkWidget*) _tmp23_, "size-allocate", (GCallback) ___lambda133__gtk_widget_size_allocate, self, 0);
	_tmp24_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp24_);
	sw = _tmp24_;
	_tmp25_ = sw;
	_tmp26_ = self->priv->_entry;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp27_);
	_data36_->helprev = _tmp27_;
	_tmp28_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp28_);
	helpgrid = _tmp28_;
	_tmp29_ = helpgrid;
	gtk_container_set_border_width ((GtkContainer*) _tmp29_, (guint) 5);
	_tmp30_ = g_strconcat (_ ("Help for inputting node information:"), "\n", NULL);
	_tmp31_ = _tmp30_;
	_tmp32_ = quick_entry_make_help_label (self, _tmp31_);
	_tmp33_ = _tmp32_;
	_g_free0 (_tmp31_);
	help_title = _tmp33_;
	_tmp34_ = g_strconcat ("  - ", _ ("Each line of text describes either the title of a node or note informa" \
"tion for a node."), NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = quick_entry_make_help_label (self, _tmp35_);
	_tmp37_ = _tmp36_;
	_g_free0 (_tmp35_);
	help_line = _tmp37_;
	_tmp38_ = g_strconcat ("  - <b>", _ ("Tab"), NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strconcat (_tmp39_, "</b>:", NULL);
	_tmp41_ = _tmp40_;
	_tmp42_ = quick_entry_make_help_label (self, _tmp41_);
	_tmp43_ = _tmp42_;
	_g_free0 (_tmp41_);
	_g_free0 (_tmp39_);
	help_tab0 = _tmp43_;
	_tmp44_ = g_strconcat ("  ", _ ("Creates a child node of the previous node."), NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = quick_entry_make_help_label (self, _tmp45_);
	_tmp47_ = _tmp46_;
	_g_free0 (_tmp45_);
	help_tab1 = _tmp47_;
	_tmp48_ = quick_entry_make_help_label (self, "  - <b>#</b>:");
	help_hdr0 = _tmp48_;
	_tmp49_ = g_strconcat ("  ", _ ("If this character is the first non-whitespace character, makes a new r" \
"oot node from the title that follows."), NULL);
	_tmp50_ = _tmp49_;
	_tmp51_ = quick_entry_make_help_label (self, _tmp50_);
	_tmp52_ = _tmp51_;
	_g_free0 (_tmp50_);
	help_hdr1 = _tmp52_;
	_tmp53_ = quick_entry_make_help_label (self, "  - <b>*, - or +</b>:");
	_data36_->help_node0 = _tmp53_;
	_tmp54_ = g_strconcat ("  ", _ ("If this character is the first non-whitespace character, make a new no" \
"de from the title that follows."), NULL);
	_tmp55_ = _tmp54_;
	_tmp56_ = quick_entry_make_help_label (self, _tmp55_);
	_tmp57_ = _tmp56_;
	_g_free0 (_tmp55_);
	_data36_->help_node1 = _tmp57_;
	_tmp58_ = quick_entry_make_help_label (self, "  - <b>&gt;</b>:");
	help_note0 = _tmp58_;
	_tmp59_ = g_strconcat ("  ", _ ("If this character is the first non-whitespace character, the following" \
" line is appended to the previous node's note."), NULL);
	_tmp60_ = _tmp59_;
	_tmp61_ = quick_entry_make_help_label (self, _tmp60_);
	_tmp62_ = _tmp61_;
	_g_free0 (_tmp60_);
	help_note1 = _tmp62_;
	_tmp63_ = g_strconcat ("  - <b>!</b> <i>", _ ("URI"), NULL);
	_tmp64_ = _tmp63_;
	_tmp65_ = g_strconcat (_tmp64_, "</i>:", NULL);
	_tmp66_ = _tmp65_;
	_tmp67_ = quick_entry_make_help_label (self, _tmp66_);
	_tmp68_ = _tmp67_;
	_g_free0 (_tmp66_);
	_g_free0 (_tmp64_);
	help_img0 = _tmp68_;
	_tmp69_ = g_strconcat ("  ", _ ("If this character is the first non-whitespace character, adds an image" \
" from the URI to the previous node"), NULL);
	_tmp70_ = _tmp69_;
	_tmp71_ = quick_entry_make_help_label (self, _tmp70_);
	_tmp72_ = _tmp71_;
	_g_free0 (_tmp70_);
	help_img1 = _tmp72_;
	_tmp73_ = quick_entry_make_help_label (self, "  - <b>[ ]</b>:");
	help_utsk0 = _tmp73_;
	_tmp74_ = g_strconcat ("  ", _ ("If this follows *, + or -, the node is made an uncompleted task."), NULL);
	_tmp75_ = _tmp74_;
	_tmp76_ = quick_entry_make_help_label (self, _tmp75_);
	_tmp77_ = _tmp76_;
	_g_free0 (_tmp75_);
	help_utsk1 = _tmp77_;
	_tmp78_ = quick_entry_make_help_label (self, "  - <b>[x] or [X]</b>:");
	help_ctsk0 = _tmp78_;
	_tmp79_ = g_strconcat ("  ", _ ("If this follows *, + or -, the node is made a completed task."), NULL);
	_tmp80_ = _tmp79_;
	_tmp81_ = quick_entry_make_help_label (self, _tmp80_);
	_tmp82_ = _tmp81_;
	_g_free0 (_tmp80_);
	help_ctsk1 = _tmp82_;
	_tmp83_ = helpgrid;
	_tmp84_ = help_title;
	gtk_grid_attach (_tmp83_, (GtkWidget*) _tmp84_, 0, 0, 2, 1);
	_tmp85_ = helpgrid;
	_tmp86_ = help_line;
	gtk_grid_attach (_tmp85_, (GtkWidget*) _tmp86_, 0, 1, 2, 1);
	_tmp87_ = helpgrid;
	_tmp88_ = help_tab0;
	gtk_grid_attach (_tmp87_, (GtkWidget*) _tmp88_, 0, 2, 1, 1);
	_tmp89_ = helpgrid;
	_tmp90_ = help_tab1;
	gtk_grid_attach (_tmp89_, (GtkWidget*) _tmp90_, 1, 2, 1, 1);
	_tmp91_ = helpgrid;
	_tmp92_ = help_hdr0;
	gtk_grid_attach (_tmp91_, (GtkWidget*) _tmp92_, 0, 3, 1, 1);
	_tmp93_ = helpgrid;
	_tmp94_ = help_hdr1;
	gtk_grid_attach (_tmp93_, (GtkWidget*) _tmp94_, 1, 3, 1, 1);
	_tmp95_ = helpgrid;
	_tmp96_ = _data36_->help_node0;
	gtk_grid_attach (_tmp95_, (GtkWidget*) _tmp96_, 0, 4, 1, 1);
	_tmp97_ = helpgrid;
	_tmp98_ = _data36_->help_node1;
	gtk_grid_attach (_tmp97_, (GtkWidget*) _tmp98_, 1, 4, 1, 1);
	_tmp99_ = helpgrid;
	_tmp100_ = help_note0;
	gtk_grid_attach (_tmp99_, (GtkWidget*) _tmp100_, 0, 5, 1, 1);
	_tmp101_ = helpgrid;
	_tmp102_ = help_note1;
	gtk_grid_attach (_tmp101_, (GtkWidget*) _tmp102_, 1, 5, 1, 1);
	_tmp103_ = helpgrid;
	_tmp104_ = help_img0;
	gtk_grid_attach (_tmp103_, (GtkWidget*) _tmp104_, 0, 6, 1, 1);
	_tmp105_ = helpgrid;
	_tmp106_ = help_img1;
	gtk_grid_attach (_tmp105_, (GtkWidget*) _tmp106_, 1, 6, 1, 1);
	_tmp107_ = helpgrid;
	_tmp108_ = help_utsk0;
	gtk_grid_attach (_tmp107_, (GtkWidget*) _tmp108_, 0, 7, 1, 1);
	_tmp109_ = helpgrid;
	_tmp110_ = help_utsk1;
	gtk_grid_attach (_tmp109_, (GtkWidget*) _tmp110_, 1, 7, 1, 1);
	_tmp111_ = helpgrid;
	_tmp112_ = help_ctsk0;
	gtk_grid_attach (_tmp111_, (GtkWidget*) _tmp112_, 0, 8, 1, 1);
	_tmp113_ = helpgrid;
	_tmp114_ = help_ctsk1;
	gtk_grid_attach (_tmp113_, (GtkWidget*) _tmp114_, 1, 8, 1, 1);
	_tmp115_ = _data36_->helprev;
	gtk_revealer_set_reveal_child (_tmp115_, FALSE);
	_tmp116_ = _data36_->helprev;
	_tmp117_ = helpgrid;
	gtk_container_add ((GtkContainer*) _tmp116_, (GtkWidget*) _tmp117_);
	_tmp118_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp118_);
	bbox = _tmp118_;
	_tmp119_ = bbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp119_, (guint) 5);
	_tmp120_ = (GtkButton*) gtk_button_new_from_icon_name ("dialog-information-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp120_);
	info = _tmp120_;
	_tmp121_ = info;
	gtk_button_set_relief (_tmp121_, GTK_RELIEF_NONE);
	_tmp122_ = info;
	g_signal_connect_data (_tmp122_, "clicked", (GCallback) ___lambda134__gtk_button_clicked, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_tmp123_ = bbox;
	_tmp124_ = info;
	gtk_box_pack_start (_tmp123_, (GtkWidget*) _tmp124_, FALSE, FALSE, (guint) 0);
	if (replace) {
		GtkButton* _tmp125_;
		GtkButton* _tmp126_;
		GtkStyleContext* _tmp127_;
		GtkButton* _tmp128_;
		GtkBox* _tmp130_;
		GtkButton* _tmp131_;
		_tmp125_ = (GtkButton*) gtk_button_new_with_label (_ ("Replace"));
		g_object_ref_sink (_tmp125_);
		_g_object_unref0 (self->priv->_apply);
		self->priv->_apply = _tmp125_;
		_tmp126_ = self->priv->_apply;
		_tmp127_ = gtk_widget_get_style_context ((GtkWidget*) _tmp126_);
		gtk_style_context_add_class (_tmp127_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
		_tmp128_ = self->priv->_apply;
		g_signal_connect_data (_tmp128_, "clicked", (GCallback) ____lambda135__gtk_button_clicked, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
		if (!draw_area_is_node_selected (da)) {
			GtkButton* _tmp129_;
			_tmp129_ = self->priv->_apply;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp129_, FALSE);
		}
		_tmp130_ = bbox;
		_tmp131_ = self->priv->_apply;
		gtk_box_pack_end (_tmp130_, (GtkWidget*) _tmp131_, FALSE, FALSE, (guint) 0);
	} else {
		GtkButton* _tmp132_;
		GtkButton* _tmp133_;
		GtkStyleContext* _tmp134_;
		GtkButton* _tmp135_;
		GtkBox* _tmp136_;
		GtkButton* _tmp137_;
		_tmp132_ = (GtkButton*) gtk_button_new_with_label (_ ("Insert"));
		g_object_ref_sink (_tmp132_);
		_g_object_unref0 (self->priv->_apply);
		self->priv->_apply = _tmp132_;
		_tmp133_ = self->priv->_apply;
		_tmp134_ = gtk_widget_get_style_context ((GtkWidget*) _tmp133_);
		gtk_style_context_add_class (_tmp134_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
		_tmp135_ = self->priv->_apply;
		g_signal_connect_data (_tmp135_, "clicked", (GCallback) ____lambda136__gtk_button_clicked, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
		_tmp136_ = bbox;
		_tmp137_ = self->priv->_apply;
		gtk_box_pack_end (_tmp136_, (GtkWidget*) _tmp137_, FALSE, FALSE, (guint) 0);
	}
	_tmp138_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp138_);
	cancel = _tmp138_;
	g_signal_connect_object (cancel, "clicked", (GCallback) ___lambda137__gtk_button_clicked, self, 0);
	_tmp139_ = bbox;
	gtk_box_pack_end (_tmp139_, (GtkWidget*) cancel, FALSE, FALSE, (guint) 0);
	_tmp140_ = box;
	_tmp141_ = sw;
	gtk_box_pack_start (_tmp140_, (GtkWidget*) _tmp141_, TRUE, TRUE, (guint) 0);
	_tmp142_ = box;
	_tmp143_ = bbox;
	gtk_box_pack_end (_tmp142_, (GtkWidget*) _tmp143_, FALSE, TRUE, (guint) 0);
	_tmp144_ = box;
	_tmp145_ = _data36_->helprev;
	gtk_box_pack_end (_tmp144_, (GtkWidget*) _tmp145_, FALSE, TRUE, (guint) 0);
	_tmp146_ = box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp146_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp147_ = self->priv->_entry;
	gtk_drag_dest_set ((GtkWidget*) _tmp147_, GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP, QUICK_ENTRY_DRAG_TARGETS, (gint) G_N_ELEMENTS (QUICK_ENTRY_DRAG_TARGETS), GDK_ACTION_COPY);
	_tmp148_ = self->priv->_entry;
	g_signal_connect_object ((GtkWidget*) _tmp148_, "drag-motion", (GCallback) _quick_entry_handle_drag_motion_gtk_widget_drag_motion, self, 0);
	_tmp149_ = self->priv->_entry;
	g_signal_connect_object ((GtkWidget*) _tmp149_, "drag-data-received", (GCallback) _quick_entry_handle_drag_data_received_gtk_widget_drag_data_received, self, 0);
	_g_object_unref0 (cancel);
	_g_object_unref0 (info);
	_g_object_unref0 (bbox);
	_g_object_unref0 (help_ctsk1);
	_g_object_unref0 (help_ctsk0);
	_g_object_unref0 (help_utsk1);
	_g_object_unref0 (help_utsk0);
	_g_object_unref0 (help_img1);
	_g_object_unref0 (help_img0);
	_g_object_unref0 (help_note1);
	_g_object_unref0 (help_note0);
	_g_object_unref0 (help_hdr1);
	_g_object_unref0 (help_hdr0);
	_g_object_unref0 (help_tab1);
	_g_object_unref0 (help_tab0);
	_g_object_unref0 (help_line);
	_g_object_unref0 (help_title);
	_g_object_unref0 (helpgrid);
	_g_object_unref0 (sw);
	_g_object_unref0 (box);
	block36_data_unref (_data36_);
	_data36_ = NULL;
	return self;
}

QuickEntry*
quick_entry_new (DrawArea* da,
                 gboolean replace,
                 GSettings* settings)
{
	return quick_entry_construct (TYPE_QUICK_ENTRY, da, replace, settings);
}

static GtkLabel*
quick_entry_make_help_label (QuickEntry* self,
                             const gchar* str)
{
	GtkLabel* lbl = NULL;
	GtkLabel* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (str);
	g_object_ref_sink (_tmp0_);
	lbl = _tmp0_;
	gtk_label_set_use_markup (lbl, TRUE);
	gtk_label_set_xalign (lbl, (gfloat) 0);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) lbl);
	gtk_style_context_add_class (_tmp1_, "greyed-label");
	result = lbl;
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static void
quick_entry_handle_text_insertion (QuickEntry* self,
                                   GtkTextIter* pos,
                                   const gchar* new_text,
                                   gint new_text_length)
{
	gchar* _tmp0_ = NULL;
	gchar* cleaned = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pos != NULL);
	g_return_if_fail (new_text != NULL);
	if (gtk_text_iter_get_offset (pos) == 0) {
		gchar* _tmp1_;
		_tmp1_ = string_chug (new_text);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (new_text);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = g_strdup (_tmp0_);
	cleaned = _tmp3_;
	_tmp4_ = cleaned;
	if (g_strcmp0 (_tmp4_, new_text) != 0) {
		void* void_entry = NULL;
		GtkTextView* _tmp5_;
		void* _tmp6_;
		GtkTextView* _tmp7_;
		GtkTextBuffer* _tmp8_;
		GtkTextBuffer* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		void* _tmp14_;
		GtkTextView* _tmp15_;
		GtkTextBuffer* _tmp16_;
		GtkTextBuffer* _tmp17_;
		_tmp5_ = self->priv->_entry;
		void_entry = (void*) _tmp5_;
		_tmp6_ = void_entry;
		g_signal_handlers_block_by_func (_tmp6_, (void*) quick_entry_handle_text_insertion, self);
		_tmp7_ = self->priv->_entry;
		_tmp8_ = gtk_text_view_get_buffer (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = cleaned;
		_tmp11_ = cleaned;
		_tmp12_ = strlen (_tmp11_);
		_tmp13_ = _tmp12_;
		g_signal_emit_by_name (_tmp9_, "insert-text", pos, _tmp10_, _tmp13_);
		_g_array_unref0 (self->priv->_node_stack);
		self->priv->_node_stack = NULL;
		_tmp14_ = void_entry;
		g_signal_handlers_unblock_by_func (_tmp14_, (void*) quick_entry_handle_text_insertion, self);
		_tmp15_ = self->priv->_entry;
		_tmp16_ = gtk_text_view_get_buffer (_tmp15_);
		_tmp17_ = _tmp16_;
		g_signal_stop_emission_by_name (_tmp17_, "insert_text");
	}
	_g_free0 (cleaned);
	_g_free0 (_tmp0_);
}

static void
quick_entry_clear_node_tag (QuickEntry* self)
{
	GtkTextIter first = {0};
	GtkTextIter last = {0};
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	GtkTextView* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GtkTextView* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextIter _tmp11_;
	GtkTextIter _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_entry;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_text_buffer_get_start_iter (_tmp2_, &_tmp3_);
	first = _tmp3_;
	_tmp4_ = self->priv->_entry;
	_tmp5_ = gtk_text_view_get_buffer (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_text_buffer_get_end_iter (_tmp6_, &_tmp7_);
	last = _tmp7_;
	_tmp8_ = self->priv->_entry;
	_tmp9_ = gtk_text_view_get_buffer (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = first;
	_tmp12_ = last;
	gtk_text_buffer_remove_tag_by_name (_tmp10_, "node", &_tmp11_, &_tmp12_);
}

static void
_node_hier_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (node_hier_unref (var), NULL));
}

static void
_vala_NodeHier_free_function_content_of (gpointer data)
{
	NodeHier* self;
	self = *((NodeHier**) data);
	_node_hier_unref0_ (self);
}

static gboolean
quick_entry_handle_drag_motion (QuickEntry* self,
                                GdkDragContext* ctx,
                                gint x,
                                gint y,
                                guint t)
{
	GArray* _tmp0_;
	GArray* _tmp15_;
	GArray* _tmp38_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->priv->_node_stack;
	if (_tmp0_ == NULL) {
		GArray* _tmp1_;
		ExportText* _tmp2_;
		DrawArea* _tmp3_;
		GtkTextView* _tmp4_;
		GtkTextBuffer* _tmp5_;
		GtkTextBuffer* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		DrawArea* _tmp10_;
		GSettings* _tmp11_;
		GSettings* _tmp12_;
		GArray* _tmp13_;
		gboolean _tmp14_;
		_tmp1_ = g_array_new (TRUE, TRUE, sizeof (NodeHier*));
		g_array_set_clear_func (_tmp1_, (GDestroyNotify) _vala_NodeHier_free_function_content_of);
		_g_array_unref0 (self->priv->_node_stack);
		self->priv->_node_stack = _tmp1_;
		_tmp2_ = self->priv->_export;
		_tmp3_ = self->priv->_da;
		_tmp4_ = self->priv->_entry;
		_tmp5_ = gtk_text_view_get_buffer (_tmp4_);
		_tmp6_ = _tmp5_;
		g_object_get (_tmp6_, "text", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_da;
		_tmp11_ = draw_area_get_settings (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->_node_stack;
		_tmp14_ = !export_text_parse_text (_tmp2_, _tmp3_, _tmp9_, g_settings_get_int (_tmp12_, "quick-entry-spaces-per-tab"), _tmp13_);
		_g_free0 (_tmp9_);
		if (_tmp14_) {
			_g_array_unref0 (self->priv->_node_stack);
			self->priv->_node_stack = NULL;
		}
	}
	quick_entry_clear_node_tag (self);
	_tmp15_ = self->priv->_node_stack;
	if (_tmp15_ != NULL) {
		GtkTextIter iter = {0};
		GtkTextIter first = {0};
		GtkTextIter last = {0};
		gint first_line = 0;
		gint last_line = 0;
		gint line_top = 0;
		GtkTextView* _tmp16_;
		GtkTextIter _tmp17_ = {0};
		gint _tmp18_ = 0;
		NodeHier* node_info = NULL;
		ExportText* _tmp19_;
		GArray* _tmp20_;
		NodeHier* _tmp21_;
		NodeHier* _tmp22_;
		_tmp16_ = self->priv->_entry;
		gtk_text_view_get_line_at_y (_tmp16_, &_tmp17_, y, &_tmp18_);
		iter = _tmp17_;
		line_top = _tmp18_;
		_tmp19_ = self->priv->_export;
		_tmp20_ = self->priv->_node_stack;
		_tmp21_ = export_text_get_node_at_line (_tmp19_, _tmp20_, gtk_text_iter_get_line (&iter));
		node_info = _tmp21_;
		_tmp22_ = node_info;
		if (_tmp22_ != NULL) {
			GtkTextView* _tmp23_;
			GtkTextBuffer* _tmp24_;
			GtkTextBuffer* _tmp25_;
			NodeHier* _tmp26_;
			GtkTextIter _tmp27_ = {0};
			GtkTextView* _tmp28_;
			GtkTextBuffer* _tmp29_;
			GtkTextBuffer* _tmp30_;
			NodeHier* _tmp31_;
			GtkTextIter _tmp32_ = {0};
			GtkTextView* _tmp33_;
			GtkTextBuffer* _tmp34_;
			GtkTextBuffer* _tmp35_;
			GtkTextIter _tmp36_;
			GtkTextIter _tmp37_;
			_tmp23_ = self->priv->_entry;
			_tmp24_ = gtk_text_view_get_buffer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = node_info;
			gtk_text_buffer_get_iter_at_line (_tmp25_, &_tmp27_, _tmp26_->first_line);
			first = _tmp27_;
			_tmp28_ = self->priv->_entry;
			_tmp29_ = gtk_text_view_get_buffer (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = node_info;
			gtk_text_buffer_get_iter_at_line (_tmp30_, &_tmp32_, _tmp31_->last_line + 1);
			last = _tmp32_;
			_tmp33_ = self->priv->_entry;
			_tmp34_ = gtk_text_view_get_buffer (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = first;
			_tmp37_ = last;
			gtk_text_buffer_apply_tag_by_name (_tmp35_, "node", &_tmp36_, &_tmp37_);
		}
		_node_hier_unref0 (node_info);
	}
	_tmp38_ = self->priv->_node_stack;
	result = _tmp38_ != NULL;
	return result;
}

static void
quick_entry_handle_drag_data_received (QuickEntry* self,
                                       GdkDragContext* ctx,
                                       gint x,
                                       gint y,
                                       GtkSelectionData* data,
                                       guint info,
                                       guint t)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (data != NULL);
	if (info == ((guint) DRAG_TYPES_URI)) {
		GtkTextIter iter = {0};
		Node* node = NULL;
		gint line_top = 0;
		gchar* prefix = NULL;
		GtkTextView* _tmp0_;
		GtkTextIter _tmp1_ = {0};
		gint _tmp2_ = 0;
		NodeHier* node_info = NULL;
		ExportText* _tmp3_;
		GArray* _tmp4_;
		NodeHier* _tmp5_;
		NodeHier* _tmp6_;
		_tmp0_ = self->priv->_entry;
		gtk_text_view_get_line_at_y (_tmp0_, &_tmp1_, y, &_tmp2_);
		iter = _tmp1_;
		line_top = _tmp2_;
		_tmp3_ = self->priv->_export;
		_tmp4_ = self->priv->_node_stack;
		_tmp5_ = export_text_get_node_at_line (_tmp3_, _tmp4_, gtk_text_iter_get_line (&iter));
		node_info = _tmp5_;
		_tmp6_ = node_info;
		if (_tmp6_ != NULL) {
			GtkTextIter first = {0};
			GtkTextIter last = {0};
			gchar* node_str = NULL;
			gchar* _tmp7_;
			gchar** _tmp8_;
			gchar** _tmp9_;
			GtkTextView* _tmp36_;
			GtkTextBuffer* _tmp37_;
			GtkTextBuffer* _tmp38_;
			NodeHier* _tmp39_;
			GtkTextIter _tmp40_ = {0};
			GtkTextView* _tmp41_;
			GtkTextBuffer* _tmp42_;
			GtkTextBuffer* _tmp43_;
			NodeHier* _tmp44_;
			GtkTextIter _tmp45_ = {0};
			GtkTextView* _tmp46_;
			GtkTextBuffer* _tmp47_;
			GtkTextBuffer* _tmp48_;
			GtkTextView* _tmp49_;
			GtkTextBuffer* _tmp50_;
			GtkTextBuffer* _tmp51_;
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			_tmp7_ = g_strdup ("");
			node_str = _tmp7_;
			_tmp9_ = _tmp8_ = gtk_selection_data_get_uris (data);
			{
				gchar** uri_collection = NULL;
				gint uri_collection_length1 = 0;
				gint _uri_collection_size_ = 0;
				gint uri_it = 0;
				uri_collection = _tmp9_;
				uri_collection_length1 = _vala_array_length (_tmp8_);
				for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
					gchar* _tmp10_;
					gchar* uri = NULL;
					_tmp10_ = g_strdup (uri_collection[uri_it]);
					uri = _tmp10_;
					{
						NodeImage* node_image = NULL;
						DrawArea* _tmp11_;
						ImageManager* _tmp12_;
						ImageManager* _tmp13_;
						const gchar* _tmp14_;
						NodeImage* _tmp15_;
						NodeHier* _tmp16_;
						Node* _tmp17_;
						DrawArea* _tmp18_;
						ImageManager* _tmp19_;
						ImageManager* _tmp20_;
						NodeImage* _tmp21_;
						const gchar* _tmp22_;
						const gchar* _tmp25_;
						ExportText* _tmp26_;
						DrawArea* _tmp27_;
						NodeHier* _tmp28_;
						Node* _tmp29_;
						NodeHier* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						gchar* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						_tmp11_ = self->priv->_da;
						_tmp12_ = draw_area_get_image_manager (_tmp11_);
						_tmp13_ = _tmp12_;
						_tmp14_ = uri;
						_tmp15_ = node_image_new_from_uri (_tmp13_, _tmp14_, 200);
						node_image = _tmp15_;
						_tmp16_ = node_info;
						_tmp17_ = _tmp16_->node;
						_tmp18_ = self->priv->_da;
						_tmp19_ = draw_area_get_image_manager (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp21_ = node_image;
						node_set_image (_tmp17_, _tmp20_, _tmp21_);
						_tmp22_ = node_str;
						if (g_strcmp0 (_tmp22_, "") != 0) {
							const gchar* _tmp23_;
							gchar* _tmp24_;
							_tmp23_ = node_str;
							_tmp24_ = g_strconcat (_tmp23_, "\n", NULL);
							_g_free0 (node_str);
							node_str = _tmp24_;
						}
						_tmp25_ = node_str;
						_tmp26_ = self->priv->_export;
						_tmp27_ = self->priv->_da;
						_tmp28_ = node_info;
						_tmp29_ = _tmp28_->node;
						_tmp30_ = node_info;
						_tmp31_ = g_strnfill ((gsize) _tmp30_->spaces, ' ');
						_tmp32_ = _tmp31_;
						_tmp33_ = export_text_export_node (_tmp26_, _tmp27_, _tmp29_, _tmp32_);
						_tmp34_ = _tmp33_;
						_tmp35_ = g_strconcat (_tmp25_, _tmp34_, NULL);
						_g_free0 (node_str);
						node_str = _tmp35_;
						_g_free0 (_tmp34_);
						_g_free0 (_tmp32_);
						_node_image_unref0 (node_image);
						_g_free0 (uri);
					}
				}
				uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_tmp36_ = self->priv->_entry;
			_tmp37_ = gtk_text_view_get_buffer (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = node_info;
			gtk_text_buffer_get_iter_at_line (_tmp38_, &_tmp40_, _tmp39_->first_line);
			first = _tmp40_;
			_tmp41_ = self->priv->_entry;
			_tmp42_ = gtk_text_view_get_buffer (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = node_info;
			gtk_text_buffer_get_iter_at_line (_tmp43_, &_tmp45_, _tmp44_->last_line + 1);
			last = _tmp45_;
			_tmp46_ = self->priv->_entry;
			_tmp47_ = gtk_text_view_get_buffer (_tmp46_);
			_tmp48_ = _tmp47_;
			gtk_text_buffer_delete (_tmp48_, &first, &last);
			_tmp49_ = self->priv->_entry;
			_tmp50_ = gtk_text_view_get_buffer (_tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = node_str;
			_tmp53_ = node_str;
			_tmp54_ = strlen (_tmp53_);
			_tmp55_ = _tmp54_;
			gtk_text_buffer_insert (_tmp51_, &first, _tmp52_, _tmp55_);
			_g_array_unref0 (self->priv->_node_stack);
			self->priv->_node_stack = NULL;
			_g_free0 (node_str);
		}
		_node_hier_unref0 (node_info);
		_g_free0 (prefix);
		_g_object_unref0 (node);
	}
	gtk_drag_finish (ctx, TRUE, FALSE, (guint32) t);
	quick_entry_clear_node_tag (self);
}

static gchar*
quick_entry_get_line_text (QuickEntry* self,
                           gint adjust)
{
	GtkTextIter current = {0};
	GtkTextIter startline = {0};
	GtkTextIter endline = {0};
	GtkTextBuffer* buf = NULL;
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextMark* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GtkTextBuffer* _tmp8_;
	GtkTextIter _tmp9_ = {0};
	GtkTextBuffer* _tmp10_;
	GtkTextIter _tmp11_ = {0};
	GtkTextBuffer* _tmp12_;
	GtkTextIter _tmp13_;
	GtkTextIter _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buf = _tmp3_;
	_tmp4_ = buf;
	_tmp5_ = buf;
	_tmp6_ = gtk_text_buffer_get_insert (_tmp5_);
	gtk_text_buffer_get_iter_at_mark (_tmp4_, &_tmp7_, _tmp6_);
	current = _tmp7_;
	if (adjust < 0) {
		gtk_text_iter_backward_lines (&current, 0 - adjust);
	} else {
		if (adjust > 0) {
			gtk_text_iter_backward_lines (&current, adjust);
		}
	}
	_tmp8_ = buf;
	gtk_text_buffer_get_iter_at_line (_tmp8_, &_tmp9_, gtk_text_iter_get_line (&current));
	startline = _tmp9_;
	_tmp10_ = buf;
	gtk_text_buffer_get_iter_at_line (_tmp10_, &_tmp11_, gtk_text_iter_get_line (&current) + 1);
	endline = _tmp11_;
	_tmp12_ = buf;
	_tmp13_ = startline;
	_tmp14_ = endline;
	_tmp15_ = gtk_text_buffer_get_text (_tmp12_, &_tmp13_, &_tmp14_, TRUE);
	result = _tmp15_;
	_g_object_unref0 (buf);
	return result;
}

static gchar*
quick_entry_get_start_to_current_text (QuickEntry* self)
{
	GtkTextIter startline = {0};
	GtkTextIter endline = {0};
	GtkTextBuffer* buf = NULL;
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buf = _tmp3_;
	_tmp4_ = gtk_text_buffer_get_insert (buf);
	gtk_text_buffer_get_iter_at_mark (buf, &_tmp5_, _tmp4_);
	endline = _tmp5_;
	gtk_text_buffer_get_iter_at_line (buf, &_tmp6_, gtk_text_iter_get_line (&endline));
	startline = _tmp6_;
	_tmp7_ = startline;
	_tmp8_ = endline;
	_tmp9_ = gtk_text_buffer_get_text (buf, &_tmp7_, &_tmp8_, TRUE);
	result = _tmp9_;
	_g_object_unref0 (buf);
	return result;
}

static gboolean
quick_entry_get_whitespace (QuickEntry* self,
                            const gchar* line,
                            gchar** wspace)
{
	gchar* _vala_wspace = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_wspace);
	_vala_wspace = _tmp0_;
	{
		GMatchInfo* match_info = NULL;
		GRegex* re = NULL;
		GRegex* _tmp1_;
		GMatchInfo* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp1_ = g_regex_new ("^([ \\t]*)", 0, 0, &_inner_error0_);
		re = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			_g_match_info_unref0 (match_info);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_free0 (_vala_wspace);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		_tmp4_ = g_regex_match (re, line, 0, &_tmp3_);
		_g_match_info_unref0 (match_info);
		match_info = _tmp3_;
		if (_tmp4_) {
			GMatchInfo* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = match_info;
			_tmp6_ = g_match_info_fetch (_tmp5_, 1);
			_g_free0 (_vala_wspace);
			_vala_wspace = _tmp6_;
			result = TRUE;
			_g_regex_unref0 (re);
			_g_match_info_unref0 (match_info);
			if (wspace) {
				*wspace = _vala_wspace;
			} else {
				_g_free0 (_vala_wspace);
			}
			return result;
		}
		_g_regex_unref0 (re);
		_g_match_info_unref0 (match_info);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		if (wspace) {
			*wspace = _vala_wspace;
		} else {
			_g_free0 (_vala_wspace);
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		_g_free0 (_vala_wspace);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = FALSE;
	if (wspace) {
		*wspace = _vala_wspace;
	} else {
		_g_free0 (_vala_wspace);
	}
	return result;
}

static gboolean
quick_entry_is_node_line (QuickEntry* self,
                          const gchar* line)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	result = g_regex_match_simple ("^[ \\t]*[+*#-]", line, 0, 0);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
quick_entry_is_blank_line (QuickEntry* self,
                           const gchar* line)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = string_strip (line);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "") == 0;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
quick_entry_tabs_to_spaces (QuickEntry* self,
                            const gchar* wspace)
{
	gchar* tspace = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (wspace != NULL, NULL);
	_tmp0_ = g_strnfill ((gsize) 8, ' ');
	tspace = _tmp0_;
	_tmp1_ = string_replace (wspace, "\t", tspace);
	result = _tmp1_;
	_g_free0 (tspace);
	return result;
}

static gchar*
quick_entry_align_to_tab (QuickEntry* self,
                          const gchar* wspace)
{
	gchar* ws = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (wspace != NULL, NULL);
	_tmp0_ = quick_entry_tabs_to_spaces (self, wspace);
	ws = _tmp0_;
	_tmp1_ = g_strnfill ((gsize) (g_utf8_strlen (ws, (gssize) -1) / 8), '\t');
	result = _tmp1_;
	_g_free0 (ws);
	return result;
}

static void
_vala_GtkTextIter_free (GtkTextIter* self)
{
	g_boxed_free (gtk_text_iter_get_type (), self);
}

static void
quick_entry_delete_whitespace (QuickEntry* self,
                               const gchar* ins_text)
{
	gchar* ws = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = quick_entry_get_line_text (self, 0);
	_tmp1_ = _tmp0_;
	_tmp3_ = quick_entry_get_whitespace (self, _tmp1_, &_tmp2_);
	_g_free0 (ws);
	ws = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp1_);
	if (_tmp4_) {
		GtkTextIter current = {0};
		GtkTextIter start = {0};
		GtkTextBuffer* buf = NULL;
		GtkTextView* _tmp5_;
		GtkTextBuffer* _tmp6_;
		GtkTextBuffer* _tmp7_;
		GtkTextBuffer* _tmp8_;
		GtkTextBuffer* _tmp9_;
		GtkTextBuffer* _tmp10_;
		GtkTextMark* _tmp11_;
		GtkTextIter _tmp12_ = {0};
		GtkTextBuffer* _tmp13_;
		GtkTextIter _tmp14_ = {0};
		GtkTextIter* end = NULL;
		GtkTextIter* _tmp15_;
		GtkTextIter* _tmp16_;
		const gchar* _tmp17_;
		GtkTextBuffer* _tmp18_;
		_tmp5_ = self->priv->_entry;
		_tmp6_ = gtk_text_view_get_buffer (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		buf = _tmp8_;
		_tmp9_ = buf;
		_tmp10_ = buf;
		_tmp11_ = gtk_text_buffer_get_insert (_tmp10_);
		gtk_text_buffer_get_iter_at_mark (_tmp9_, &_tmp12_, _tmp11_);
		current = _tmp12_;
		_tmp13_ = buf;
		gtk_text_buffer_get_iter_at_line (_tmp13_, &_tmp14_, gtk_text_iter_get_line (&current));
		start = _tmp14_;
		_tmp15_ = gtk_text_iter_copy (&start);
		end = _tmp15_;
		_tmp16_ = end;
		_tmp17_ = ws;
		gtk_text_iter_forward_chars (_tmp16_, g_utf8_strlen (_tmp17_, (gssize) -1));
		_tmp18_ = buf;
		gtk_text_buffer_delete (_tmp18_, &start, end);
		if (ins_text != NULL) {
			GtkTextBuffer* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			_tmp19_ = buf;
			_tmp20_ = strlen (ins_text);
			_tmp21_ = _tmp20_;
			g_signal_emit_by_name (_tmp19_, "insert-text", &start, ins_text, _tmp21_);
		}
		__vala_GtkTextIter_free0 (end);
		_g_object_unref0 (buf);
	}
	_g_free0 (ws);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gboolean
quick_entry_on_keypress (QuickEntry* self,
                         GdkEventKey* e)
{
	gboolean control = FALSE;
	gboolean shift = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	control = (gboolean) (e->state & GDK_CONTROL_MASK);
	shift = (gboolean) (e->state & GDK_SHIFT_MASK);
	switch (e->keyval) {
		case GDK_KEY_space:
		{
			result = quick_entry_handle_space (self);
			return result;
		}
		case GDK_KEY_Return:
		{
			result = quick_entry_handle_return (self, control);
			return result;
		}
		case GDK_KEY_Tab:
		{
			result = quick_entry_handle_tab (self, FALSE);
			return result;
		}
		case GDK_KEY_ISO_Left_Tab:
		{
			result = quick_entry_handle_tab (self, TRUE);
			return result;
		}
		default:
		{
			const gchar* _tmp0_;
			_tmp0_ = e->string;
			if (g_unichar_isprint (string_get_char (_tmp0_, (glong) 0))) {
				const gchar* _tmp1_;
				_tmp1_ = e->string;
				result = quick_entry_handle_printable (self, _tmp1_);
				return result;
			}
			break;
		}
	}
	result = FALSE;
	return result;
}

static gboolean
quick_entry_handle_space (QuickEntry* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = quick_entry_get_start_to_current_text (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") == 0;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static gboolean
quick_entry_handle_return (QuickEntry* self,
                           gboolean control)
{
	gchar* wspace = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (control) {
		GtkButton* _tmp0_;
		_tmp0_ = self->priv->_apply;
		gtk_button_clicked (_tmp0_);
		result = FALSE;
		return result;
	}
	_tmp1_ = quick_entry_get_line_text (self, 0);
	_tmp2_ = _tmp1_;
	_tmp4_ = quick_entry_get_whitespace (self, _tmp2_, &_tmp3_);
	_g_free0 (wspace);
	wspace = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	if (_tmp5_) {
		gchar* prefix = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* ins = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		GtkTextView* _tmp10_;
		GtkTextBuffer* _tmp11_;
		GtkTextBuffer* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp6_ = wspace;
		_tmp7_ = quick_entry_align_to_tab (self, _tmp6_);
		prefix = _tmp7_;
		_tmp8_ = prefix;
		_tmp9_ = g_strconcat ("\n", _tmp8_, NULL);
		ins = _tmp9_;
		_tmp10_ = self->priv->_entry;
		_tmp11_ = gtk_text_view_get_buffer (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = ins;
		_tmp14_ = ins;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		gtk_text_buffer_insert_at_cursor (_tmp12_, _tmp13_, _tmp16_);
		result = TRUE;
		_g_free0 (ins);
		_g_free0 (prefix);
		_g_free0 (wspace);
		return result;
	}
	result = FALSE;
	_g_free0 (wspace);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static gboolean
quick_entry_handle_tab (QuickEntry* self,
                        gboolean shift)
{
	GtkTextIter current = {0};
	gchar* prev = NULL;
	gchar* _tmp0_;
	gchar* curr = NULL;
	gchar* _tmp1_;
	gchar* line = NULL;
	gchar* _tmp2_;
	GtkTextView* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextView* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextMark* _tmp9_;
	GtkTextIter _tmp10_ = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	prev = _tmp0_;
	_tmp1_ = g_strdup ("");
	curr = _tmp1_;
	_tmp2_ = quick_entry_get_line_text (self, 0);
	line = _tmp2_;
	_tmp3_ = self->priv->_entry;
	_tmp4_ = gtk_text_view_get_buffer (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_entry;
	_tmp7_ = gtk_text_view_get_buffer (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = gtk_text_buffer_get_insert (_tmp8_);
	gtk_text_buffer_get_iter_at_mark (_tmp5_, &_tmp10_, _tmp9_);
	current = _tmp10_;
	if (!shift) {
		if (gtk_text_iter_get_line (&current) == 0) {
			result = TRUE;
			_g_free0 (line);
			_g_free0 (curr);
			_g_free0 (prev);
			return result;
		} else {
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			const gchar* _tmp13_;
			gchar* _tmp14_ = NULL;
			gboolean _tmp15_;
			_tmp13_ = line;
			_tmp15_ = quick_entry_get_whitespace (self, _tmp13_, &_tmp14_);
			_g_free0 (curr);
			curr = _tmp14_;
			if (_tmp15_) {
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_ = NULL;
				gboolean _tmp19_;
				_tmp16_ = quick_entry_get_line_text (self, -1);
				_tmp17_ = _tmp16_;
				_tmp19_ = quick_entry_get_whitespace (self, _tmp17_, &_tmp18_);
				_g_free0 (prev);
				prev = _tmp18_;
				_tmp12_ = _tmp19_;
				_g_free0 (_tmp17_);
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				gboolean _tmp20_ = FALSE;
				const gchar* _tmp21_;
				_tmp21_ = line;
				if (quick_entry_is_blank_line (self, _tmp21_)) {
					_tmp20_ = TRUE;
				} else {
					const gchar* _tmp22_;
					_tmp22_ = line;
					_tmp20_ = quick_entry_is_node_line (self, _tmp22_);
				}
				_tmp11_ = _tmp20_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gboolean _tmp33_;
				_tmp23_ = curr;
				_tmp24_ = quick_entry_tabs_to_spaces (self, _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = strlen (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = prev;
				_tmp29_ = quick_entry_tabs_to_spaces (self, _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = strlen (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = _tmp27_ <= _tmp32_;
				_g_free0 (_tmp30_);
				_g_free0 (_tmp25_);
				if (_tmp33_) {
					gchar* prefix = NULL;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp42_;
					_tmp34_ = curr;
					_tmp35_ = quick_entry_align_to_tab (self, _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = g_strconcat (_tmp36_, "\t", NULL);
					_tmp38_ = _tmp37_;
					_g_free0 (_tmp36_);
					prefix = _tmp38_;
					_tmp39_ = line;
					if (quick_entry_is_blank_line (self, _tmp39_)) {
						const gchar* _tmp40_;
						gchar* _tmp41_;
						_tmp40_ = prefix;
						_tmp41_ = g_strconcat (_tmp40_, "- ", NULL);
						_g_free0 (prefix);
						prefix = _tmp41_;
					}
					_tmp42_ = prefix;
					quick_entry_delete_whitespace (self, _tmp42_);
					_g_free0 (prefix);
				}
			}
		}
	} else {
		gboolean _tmp43_ = FALSE;
		const gchar* _tmp44_;
		gchar* _tmp45_ = NULL;
		gboolean _tmp46_;
		_tmp44_ = line;
		_tmp46_ = quick_entry_get_whitespace (self, _tmp44_, &_tmp45_);
		_g_free0 (curr);
		curr = _tmp45_;
		if (_tmp46_) {
			gboolean _tmp47_ = FALSE;
			const gchar* _tmp48_;
			_tmp48_ = line;
			if (quick_entry_is_blank_line (self, _tmp48_)) {
				_tmp47_ = TRUE;
			} else {
				const gchar* _tmp49_;
				_tmp49_ = line;
				_tmp47_ = quick_entry_is_node_line (self, _tmp49_);
			}
			_tmp43_ = _tmp47_;
		} else {
			_tmp43_ = FALSE;
		}
		if (_tmp43_) {
			gchar* prefix = NULL;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			const gchar* _tmp52_;
			const gchar* _tmp56_;
			const gchar* _tmp59_;
			_tmp50_ = curr;
			_tmp51_ = quick_entry_align_to_tab (self, _tmp50_);
			prefix = _tmp51_;
			_tmp52_ = prefix;
			if (g_utf8_strlen (_tmp52_, (gssize) -1) > 0) {
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				gchar* _tmp55_;
				_tmp53_ = prefix;
				_tmp54_ = prefix;
				_tmp55_ = string_substring (_tmp53_, (glong) string_index_of_nth_char (_tmp54_, (glong) 1), (glong) -1);
				_g_free0 (prefix);
				prefix = _tmp55_;
			}
			_tmp56_ = line;
			if (quick_entry_is_blank_line (self, _tmp56_)) {
				const gchar* _tmp57_;
				gchar* _tmp58_;
				_tmp57_ = prefix;
				_tmp58_ = g_strconcat (_tmp57_, "- ", NULL);
				_g_free0 (prefix);
				prefix = _tmp58_;
			}
			_tmp59_ = prefix;
			quick_entry_delete_whitespace (self, _tmp59_);
			_g_free0 (prefix);
		}
	}
	result = TRUE;
	_g_free0 (line);
	_g_free0 (curr);
	_g_free0 (prev);
	return result;
}

static gboolean
quick_entry_handle_printable (QuickEntry* self,
                              const gchar* str)
{
	GtkTextIter current = {0};
	gchar* prev = NULL;
	gchar* _tmp0_;
	gchar* curr = NULL;
	gchar* _tmp1_;
	GtkTextView* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextView* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextMark* _tmp8_;
	GtkTextIter _tmp9_ = {0};
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gboolean _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	prev = _tmp0_;
	_tmp1_ = g_strdup ("");
	curr = _tmp1_;
	_tmp2_ = self->priv->_entry;
	_tmp3_ = gtk_text_view_get_buffer (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_entry;
	_tmp6_ = gtk_text_view_get_buffer (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_text_buffer_get_insert (_tmp7_);
	gtk_text_buffer_get_iter_at_mark (_tmp4_, &_tmp9_, _tmp8_);
	current = _tmp9_;
	_tmp10_ = quick_entry_get_start_to_current_text (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_strip (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strcmp0 (_tmp13_, "") == 0;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	if (_tmp14_) {
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		if (g_strcmp0 (str, "-") == 0) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = g_strcmp0 (str, "+") == 0;
		}
		if (_tmp17_) {
			_tmp16_ = TRUE;
		} else {
			_tmp16_ = g_strcmp0 (str, "*") == 0;
		}
		if (_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			_tmp15_ = g_strcmp0 (str, "#") == 0;
		}
		if (_tmp15_) {
			gchar* ins = NULL;
			gchar* _tmp18_;
			GtkTextView* _tmp19_;
			GtkTextBuffer* _tmp20_;
			GtkTextBuffer* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			_tmp18_ = g_strconcat (str, " ", NULL);
			ins = _tmp18_;
			_tmp19_ = self->priv->_entry;
			_tmp20_ = gtk_text_view_get_buffer (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = ins;
			_tmp23_ = ins;
			_tmp24_ = strlen (_tmp23_);
			_tmp25_ = _tmp24_;
			gtk_text_buffer_insert_at_cursor (_tmp21_, _tmp22_, _tmp25_);
			result = TRUE;
			_g_free0 (ins);
			_g_free0 (curr);
			_g_free0 (prev);
			return result;
		} else {
			gboolean _tmp26_ = FALSE;
			if (g_strcmp0 (str, ">") == 0) {
				_tmp26_ = TRUE;
			} else {
				_tmp26_ = g_strcmp0 (str, "!") == 0;
			}
			if (_tmp26_) {
				gchar* ins = NULL;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				GtkTextView* _tmp31_;
				GtkTextBuffer* _tmp32_;
				GtkTextBuffer* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				_tmp27_ = g_strconcat ("  ", str, NULL);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp28_, " ", NULL);
				_tmp30_ = _tmp29_;
				_g_free0 (_tmp28_);
				ins = _tmp30_;
				_tmp31_ = self->priv->_entry;
				_tmp32_ = gtk_text_view_get_buffer (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = ins;
				_tmp35_ = ins;
				_tmp36_ = strlen (_tmp35_);
				_tmp37_ = _tmp36_;
				gtk_text_buffer_insert_at_cursor (_tmp33_, _tmp34_, _tmp37_);
				result = TRUE;
				_g_free0 (ins);
				_g_free0 (curr);
				_g_free0 (prev);
				return result;
			} else {
				gchar* ins = NULL;
				gchar* _tmp38_;
				GtkTextView* _tmp39_;
				GtkTextBuffer* _tmp40_;
				GtkTextBuffer* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				_tmp38_ = g_strdup ("  ");
				ins = _tmp38_;
				_tmp39_ = self->priv->_entry;
				_tmp40_ = gtk_text_view_get_buffer (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = ins;
				_tmp43_ = ins;
				_tmp44_ = strlen (_tmp43_);
				_tmp45_ = _tmp44_;
				gtk_text_buffer_insert_at_cursor (_tmp41_, _tmp42_, _tmp45_);
				_g_free0 (ins);
			}
		}
	}
	result = FALSE;
	_g_free0 (curr);
	_g_free0 (prev);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_Node_free_function_content_of (gpointer data)
{
	Node* self;
	self = *((Node**) data);
	_g_object_unref0_ (self);
}

static gboolean
quick_entry_handle_insert (QuickEntry* self)
{
	GArray* nodes = NULL;
	GArray* _tmp0_;
	Node* node = NULL;
	DrawArea* _tmp1_;
	Node* _tmp2_;
	ExportText* _tmp3_;
	GtkTextView* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	DrawArea* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	DrawArea* _tmp13_;
	GArray* _tmp14_;
	GArray* _tmp15_;
	DrawArea* _tmp16_;
	UndoBuffer* _tmp17_;
	UndoBuffer* _tmp18_;
	DrawArea* _tmp19_;
	GArray* _tmp20_;
	UndoNodesInsert* _tmp21_;
	UndoNodesInsert* _tmp22_;
	DrawArea* _tmp23_;
	GArray* _tmp24_;
	Node* _tmp25_;
	DrawArea* _tmp26_;
	DrawArea* _tmp27_;
	DrawArea* _tmp28_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (Node*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_Node_free_function_content_of);
	nodes = _tmp0_;
	_tmp1_ = self->priv->_da;
	_tmp2_ = draw_area_get_current_node (_tmp1_);
	node = _tmp2_;
	_tmp3_ = self->priv->_export;
	_tmp4_ = self->priv->_entry;
	_tmp5_ = gtk_text_view_get_buffer (_tmp4_);
	_tmp6_ = _tmp5_;
	g_object_get (_tmp6_, "text", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_da;
	_tmp11_ = draw_area_get_settings (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->_da;
	_tmp14_ = nodes;
	export_text_import_text (_tmp3_, _tmp9_, g_settings_get_int (_tmp12_, "quick-entry-spaces-per-tab"), _tmp13_, FALSE, _tmp14_);
	_g_free0 (_tmp9_);
	_tmp15_ = nodes;
	if (_tmp15_->len == ((guint) 0)) {
		result = FALSE;
		_g_object_unref0 (node);
		_g_array_unref0 (nodes);
		return result;
	}
	_tmp16_ = self->priv->_da;
	_tmp17_ = draw_area_get_undo_buffer (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->_da;
	_tmp20_ = nodes;
	_tmp21_ = undo_nodes_insert_new (_tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	undo_buffer_add_item (_tmp18_, (UndoItem*) _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = self->priv->_da;
	_tmp24_ = nodes;
	_tmp25_ = g_array_index (_tmp24_, Node*, (guint) 0);
	draw_area_set_current_node (_tmp23_, _tmp25_);
	_tmp26_ = self->priv->_da;
	gtk_widget_queue_draw ((GtkWidget*) _tmp26_);
	_tmp27_ = self->priv->_da;
	draw_area_auto_save (_tmp27_);
	_tmp28_ = self->priv->_da;
	draw_area_see (_tmp28_, TRUE, (gdouble) 0, 100.0);
	result = TRUE;
	_g_object_unref0 (node);
	_g_array_unref0 (nodes);
	return result;
}

static gboolean
quick_entry_handle_replace (QuickEntry* self)
{
	GArray* nodes = NULL;
	GArray* _tmp0_;
	Node* node = NULL;
	DrawArea* _tmp1_;
	Node* _tmp2_;
	Node* parent = NULL;
	Node* _tmp3_;
	Node* _tmp4_;
	Node* _tmp5_;
	Node* _tmp6_;
	ExportText* _tmp7_;
	GtkTextView* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	DrawArea* _tmp14_;
	GSettings* _tmp15_;
	GSettings* _tmp16_;
	DrawArea* _tmp17_;
	GArray* _tmp18_;
	GArray* _tmp19_;
	DrawArea* _tmp20_;
	UndoBuffer* _tmp21_;
	UndoBuffer* _tmp22_;
	Node* _tmp23_;
	GArray* _tmp24_;
	UndoNodesReplace* _tmp25_;
	UndoNodesReplace* _tmp26_;
	DrawArea* _tmp27_;
	GArray* _tmp28_;
	Node* _tmp29_;
	DrawArea* _tmp30_;
	DrawArea* _tmp31_;
	DrawArea* _tmp32_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (Node*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_Node_free_function_content_of);
	nodes = _tmp0_;
	_tmp1_ = self->priv->_da;
	_tmp2_ = draw_area_get_current_node (_tmp1_);
	node = _tmp2_;
	_tmp3_ = node;
	_tmp4_ = node_get_parent (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	parent = _tmp6_;
	_tmp7_ = self->priv->_export;
	_tmp8_ = self->priv->_entry;
	_tmp9_ = gtk_text_view_get_buffer (_tmp8_);
	_tmp10_ = _tmp9_;
	g_object_get (_tmp10_, "text", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->_da;
	_tmp15_ = draw_area_get_settings (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->_da;
	_tmp18_ = nodes;
	export_text_import_text (_tmp7_, _tmp13_, g_settings_get_int (_tmp16_, "quick-entry-spaces-per-tab"), _tmp17_, TRUE, _tmp18_);
	_g_free0 (_tmp13_);
	_tmp19_ = nodes;
	if (_tmp19_->len == ((guint) 0)) {
		result = FALSE;
		_g_object_unref0 (parent);
		_g_object_unref0 (node);
		_g_array_unref0 (nodes);
		return result;
	}
	_tmp20_ = self->priv->_da;
	_tmp21_ = draw_area_get_undo_buffer (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = node;
	_tmp24_ = nodes;
	_tmp25_ = undo_nodes_replace_new (_tmp23_, _tmp24_);
	_tmp26_ = _tmp25_;
	undo_buffer_add_item (_tmp22_, (UndoItem*) _tmp26_);
	_g_object_unref0 (_tmp26_);
	_tmp27_ = self->priv->_da;
	_tmp28_ = nodes;
	_tmp29_ = g_array_index (_tmp28_, Node*, (guint) 0);
	draw_area_set_current_node (_tmp27_, _tmp29_);
	_tmp30_ = self->priv->_da;
	gtk_widget_queue_draw ((GtkWidget*) _tmp30_);
	_tmp31_ = self->priv->_da;
	draw_area_auto_save (_tmp31_);
	_tmp32_ = self->priv->_da;
	draw_area_see (_tmp32_, TRUE, (gdouble) 0, 100.0);
	result = TRUE;
	_g_object_unref0 (parent);
	_g_object_unref0 (node);
	_g_array_unref0 (nodes);
	return result;
}

void
quick_entry_preload (QuickEntry* self,
                     const gchar* value)
{
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->_entry;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (value);
	_tmp4_ = _tmp3_;
	gtk_text_buffer_insert_at_cursor (_tmp2_, value, _tmp4_);
}

static void
quick_entry_class_init (QuickEntryClass * klass,
                        gpointer klass_data)
{
	quick_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &QuickEntry_private_offset);
	G_OBJECT_CLASS (klass)->finalize = quick_entry_finalize;
}

static void
quick_entry_instance_init (QuickEntry * self,
                           gpointer klass)
{
	self->priv = quick_entry_get_instance_private (self);
	self->priv->_node_stack = NULL;
}

static void
quick_entry_finalize (GObject * obj)
{
	QuickEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_QUICK_ENTRY, QuickEntry);
	_g_object_unref0 (self->priv->_da);
	_g_object_unref0 (self->priv->_entry);
	_g_object_unref0 (self->priv->_apply);
	_g_array_unref0 (self->priv->_node_stack);
	_export_unref0 (self->priv->_export);
	G_OBJECT_CLASS (quick_entry_parent_class)->finalize (obj);
}

static GType
quick_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (QuickEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) quick_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QuickEntry), 0, (GInstanceInitFunc) quick_entry_instance_init, NULL };
	GType quick_entry_type_id;
	quick_entry_type_id = g_type_register_static (gtk_window_get_type (), "QuickEntry", &g_define_type_info, 0);
	QuickEntry_private_offset = g_type_add_instance_private (quick_entry_type_id, sizeof (QuickEntryPrivate));
	return quick_entry_type_id;
}

GType
quick_entry_get_type (void)
{
	static volatile gsize quick_entry_type_id__once = 0;
	if (g_once_init_enter (&quick_entry_type_id__once)) {
		GType quick_entry_type_id;
		quick_entry_type_id = quick_entry_get_type_once ();
		g_once_init_leave (&quick_entry_type_id__once, quick_entry_type_id);
	}
	return quick_entry_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

