/* Export.c generated by valac 0.56.18, the Vala compiler
 * generated from Export.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block19Data Block19Data;
#define _export_unref0(var) ((var == NULL) ? NULL : (var = (export_unref (var), NULL)))

#define TYPE_ZOOM_WIDGET (zoom_widget_get_type ())
#define ZOOM_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ZOOM_WIDGET, ZoomWidget))
#define ZOOM_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ZOOM_WIDGET, ZoomWidgetClass))
#define IS_ZOOM_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ZOOM_WIDGET))
#define IS_ZOOM_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ZOOM_WIDGET))
#define ZOOM_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ZOOM_WIDGET, ZoomWidgetClass))

typedef struct _ZoomWidget ZoomWidget;
typedef struct _ZoomWidgetClass ZoomWidgetClass;
typedef struct _ParamSpecExport ParamSpecExport;
enum  {
	EXPORT_SETTINGS_CHANGED_SIGNAL,
	EXPORT_NUM_SIGNALS
};
static guint export_signals[EXPORT_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportPrivate {
	GeeHashMap* _settings;
	gchar* _name;
	gchar* _label;
	gchar** _extensions;
	gint _extensions_length1;
	gint __extensions_size_;
	gboolean _importable;
	gboolean _exportable;
	gboolean _dir;
};

struct _Block19Data {
	int _ref_count_;
	Export* self;
	GtkSwitch* sw;
};

struct _ParamSpecExport {
	GParamSpec parent_instance;
};

static gint Export_private_offset;
static gpointer export_parent_class = NULL;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN gboolean export_import (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN void export_add_settings (Export* self,
                          GtkGrid* grid);
VALA_EXTERN void export_save_settings (Export* self,
                           xmlNode* node);
VALA_EXTERN void export_load_settings (Export* self,
                           xmlNode* node);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static void export_set_name (Export* self,
                      const gchar* value);
static void export_set_label (Export* self,
                       const gchar* value);
static void export_set_extensions (Export* self,
                            gchar** value,
                            gint value_length1);
static void export_set_exportable (Export* self,
                            gboolean value);
static void export_set_importable (Export* self,
                            gboolean value);
static void export_set_dir (Export* self,
                     gboolean value);
static gboolean export_real_export (Export* self,
                             const gchar* fname,
                             DrawArea* da);
static gboolean export_real_import (Export* self,
                             const gchar* fname,
                             DrawArea* da);
VALA_EXTERN gboolean export_settings_available (Export* self);
static void export_real_add_settings (Export* self,
                               GtkGrid* grid);
static GtkLabel* export_make_help (Export* self,
                            const gchar* help);
VALA_EXTERN void export_add_setting_bool (Export* self,
                              const gchar* name,
                              GtkGrid* grid,
                              const gchar* label,
                              const gchar* help,
                              gboolean dflt);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
VALA_EXTERN gchar* utils_make_title (const gchar* str);
static gboolean __lambda44_ (Block19Data* _data19_,
                      GdkEventButton* e);
static gboolean ___lambda44__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
VALA_EXTERN void export_add_setting_scale (Export* self,
                               const gchar* name,
                               GtkGrid* grid,
                               const gchar* label,
                               const gchar* help,
                               gint min,
                               gint max,
                               gint step,
                               gint dflt);
static void __lambda45_ (Export* self);
static void ___lambda45__gtk_range_value_changed (GtkRange* _sender,
                                           gpointer self);
VALA_EXTERN void export_add_setting_zoom (Export* self,
                              const gchar* name,
                              GtkGrid* grid,
                              const gchar* label,
                              const gchar* help,
                              gint min,
                              gint max,
                              gint step,
                              gint dflt);
VALA_EXTERN GType zoom_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZoomWidget, g_object_unref)
VALA_EXTERN ZoomWidget* zoom_widget_new (gint min,
                             gint max,
                             gint step,
                             gboolean fill);
VALA_EXTERN ZoomWidget* zoom_widget_construct (GType object_type,
                                   gint min,
                                   gint max,
                                   gint step,
                                   gboolean fill);
VALA_EXTERN void zoom_widget_set_value (ZoomWidget* self,
                            gint value);
static void __lambda46_ (Export* self);
static void ___lambda46__zoom_widget_zoom_changed (ZoomWidget* _sender,
                                            gdouble factor,
                                            gpointer self);
VALA_EXTERN gboolean export_is_bool_setting (Export* self,
                                 const gchar* name);
VALA_EXTERN gboolean export_is_scale_setting (Export* self,
                                  const gchar* name);
VALA_EXTERN gboolean export_is_zoom_setting (Export* self,
                                 const gchar* name);
VALA_EXTERN void export_set_bool (Export* self,
                      const gchar* name,
                      gboolean value);
VALA_EXTERN gboolean export_get_bool (Export* self,
                          const gchar* name);
VALA_EXTERN void export_set_scale (Export* self,
                       const gchar* name,
                       gint value);
VALA_EXTERN gint export_get_scale (Export* self,
                       const gchar* name);
VALA_EXTERN void export_set_zoom (Export* self,
                      const gchar* name,
                      gint value);
VALA_EXTERN gint export_get_zoom (Export* self,
                      const gchar* name);
VALA_EXTERN gint zoom_widget_get_value (ZoomWidget* self);
static void export_real_save_settings (Export* self,
                                xmlNode* node);
static void export_real_load_settings (Export* self,
                                xmlNode* node);
VALA_EXTERN gboolean export_filename_matches (Export* self,
                                  const gchar* fname,
                                  gchar** basename);
VALA_EXTERN gboolean export_get_dir (Export* self);
VALA_EXTERN gchar** export_get_extensions (Export* self,
                               gint* result_length1);
VALA_EXTERN xmlNode* export_save (Export* self);
VALA_EXTERN const gchar* export_get_name (Export* self);
VALA_EXTERN void export_load (Export* self,
                  xmlNode* node);
VALA_EXTERN const gchar* export_get_label (Export* self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
VALA_EXTERN gboolean export_get_importable (Export* self);
VALA_EXTERN gboolean export_get_exportable (Export* self);
static void export_finalize (Export * obj);
static GType export_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
export_get_instance_private (Export* self)
{
	return G_STRUCT_MEMBER_P (self, Export_private_offset);
}

Export*
export_construct (GType object_type,
                  const gchar* name,
                  const gchar* label,
                  gchar** extensions,
                  gint extensions_length1,
                  gboolean exportable,
                  gboolean importable,
                  gboolean dir)
{
	Export* self = NULL;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	self = (Export*) g_type_create_instance (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	export_set_name (self, name);
	export_set_label (self, label);
	export_set_extensions (self, extensions, extensions_length1);
	export_set_exportable (self, exportable);
	export_set_importable (self, importable);
	export_set_dir (self, dir);
	return self;
}

Export*
export_new (const gchar* name,
            const gchar* label,
            gchar** extensions,
            gint extensions_length1,
            gboolean exportable,
            gboolean importable,
            gboolean dir)
{
	return export_construct (TYPE_EXPORT, name, label, extensions, extensions_length1, exportable, importable, dir);
}

static gboolean
export_real_export (Export* self,
                    const gchar* fname,
                    DrawArea* da)
{
	gboolean result;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
export_export (Export* self,
               const gchar* fname,
               DrawArea* da)
{
	ExportClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = EXPORT_GET_CLASS (self);
	if (_klass_->export) {
		return _klass_->export (self, fname, da);
	}
	return FALSE;
}

static gboolean
export_real_import (Export* self,
                    const gchar* fname,
                    DrawArea* da)
{
	gboolean result;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
export_import (Export* self,
               const gchar* fname,
               DrawArea* da)
{
	ExportClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = EXPORT_GET_CLASS (self);
	if (_klass_->import) {
		return _klass_->import (self, fname, da);
	}
	return FALSE;
}

gboolean
export_settings_available (Export* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}

static void
export_real_add_settings (Export* self,
                          GtkGrid* grid)
{
	g_return_if_fail (grid != NULL);
}

void
export_add_settings (Export* self,
                     GtkGrid* grid)
{
	ExportClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = EXPORT_GET_CLASS (self);
	if (_klass_->add_settings) {
		_klass_->add_settings (self, grid);
	}
}

static GtkLabel*
export_make_help (Export* self,
                  const gchar* help)
{
	GtkLabel* lbl = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (help != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (help);
	g_object_ref_sink (_tmp0_);
	lbl = _tmp0_;
	gtk_widget_set_margin_left ((GtkWidget*) lbl, 10);
	gtk_widget_set_margin_bottom ((GtkWidget*) lbl, 10);
	gtk_label_set_xalign (lbl, (gfloat) 0);
	gtk_label_set_justify (lbl, GTK_JUSTIFY_LEFT);
	gtk_label_set_max_width_chars (lbl, 40);
	g_object_set (lbl, "wrap-mode", PANGO_WRAP_WORD, NULL);
	gtk_label_set_line_wrap (lbl, TRUE);
	result = lbl;
	return result;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		Export* self;
		self = _data19_->self;
		_g_object_unref0 (_data19_->sw);
		_export_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static gboolean
__lambda44_ (Block19Data* _data19_,
             GdkEventButton* e)
{
	Export* self;
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = _data19_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data19_->sw;
	_tmp1_ = _data19_->sw;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_switch_set_active (_tmp0_, !_tmp3_);
	g_signal_emit (self, export_signals[EXPORT_SETTINGS_CHANGED_SIGNAL], 0);
	result = TRUE;
	return result;
}

static gboolean
___lambda44__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda44_ (self, event);
	return result;
}

void
export_add_setting_bool (Export* self,
                         const gchar* name,
                         GtkGrid* grid,
                         const gchar* label,
                         const gchar* help,
                         gboolean dflt)
{
	Block19Data* _data19_;
	gint row = 0;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkLabel* lbl = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkSwitch* _tmp9_;
	GtkSwitch* _tmp10_;
	GtkSwitch* _tmp11_;
	GtkSwitch* _tmp12_;
	GtkSwitch* _tmp13_;
	GtkLabel* _tmp14_;
	GtkSwitch* _tmp15_;
	GeeHashMap* _tmp18_;
	GtkSwitch* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (grid != NULL);
	g_return_if_fail (label != NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = export_ref (self);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	row = _tmp2_ * 2;
	_tmp3_ = utils_make_title (label);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	lbl = _tmp6_;
	_tmp7_ = lbl;
	gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_START);
	_tmp8_ = lbl;
	gtk_label_set_use_markup (_tmp8_, TRUE);
	_tmp9_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp9_);
	_data19_->sw = _tmp9_;
	_tmp10_ = _data19_->sw;
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_END);
	_tmp11_ = _data19_->sw;
	g_object_set ((GtkWidget*) _tmp11_, "expand", TRUE, NULL);
	_tmp12_ = _data19_->sw;
	gtk_switch_set_active (_tmp12_, dflt);
	_tmp13_ = _data19_->sw;
	g_signal_connect_data ((GtkWidget*) _tmp13_, "button-press-event", (GCallback) ___lambda44__gtk_widget_button_press_event, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
	_tmp14_ = lbl;
	gtk_grid_attach (grid, (GtkWidget*) _tmp14_, 0, row, 1, 1);
	_tmp15_ = _data19_->sw;
	gtk_grid_attach (grid, (GtkWidget*) _tmp15_, 1, row, 1, 1);
	if (help != NULL) {
		GtkLabel* hlp = NULL;
		GtkLabel* _tmp16_;
		GtkLabel* _tmp17_;
		_tmp16_ = export_make_help (self, help);
		hlp = _tmp16_;
		_tmp17_ = hlp;
		gtk_grid_attach (grid, (GtkWidget*) _tmp17_, 0, row + 1, 2, 1);
		_g_object_unref0 (hlp);
	}
	_tmp18_ = self->priv->_settings;
	_tmp19_ = _data19_->sw;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, name, (GtkWidget*) _tmp19_);
	_g_object_unref0 (lbl);
	block19_data_unref (_data19_);
	_data19_ = NULL;
}

static void
__lambda45_ (Export* self)
{
	g_signal_emit (self, export_signals[EXPORT_SETTINGS_CHANGED_SIGNAL], 0);
}

static void
___lambda45__gtk_range_value_changed (GtkRange* _sender,
                                      gpointer self)
{
	__lambda45_ ((Export*) self);
}

void
export_add_setting_scale (Export* self,
                          const gchar* name,
                          GtkGrid* grid,
                          const gchar* label,
                          const gchar* help,
                          gint min,
                          gint max,
                          gint step,
                          gint dflt)
{
	gint row = 0;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkLabel* lbl = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkScale* scale = NULL;
	GtkScale* _tmp9_;
	GtkScale* _tmp10_;
	GtkScale* _tmp11_;
	GtkScale* _tmp12_;
	GtkScale* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GtkScale* _tmp16_;
	GtkScale* _tmp17_;
	GtkLabel* _tmp18_;
	GtkScale* _tmp19_;
	GeeHashMap* _tmp22_;
	GtkScale* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (grid != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	row = _tmp2_ * 2;
	_tmp3_ = utils_make_title (label);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	lbl = _tmp6_;
	_tmp7_ = lbl;
	gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_START);
	_tmp8_ = lbl;
	gtk_label_set_use_markup (_tmp8_, TRUE);
	_tmp9_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) min, (gdouble) max, (gdouble) step);
	g_object_ref_sink (_tmp9_);
	scale = _tmp9_;
	_tmp10_ = scale;
	gtk_widget_set_halign ((GtkWidget*) _tmp10_, GTK_ALIGN_FILL);
	_tmp11_ = scale;
	g_object_set ((GtkWidget*) _tmp11_, "expand", TRUE, NULL);
	_tmp12_ = scale;
	gtk_scale_set_draw_value (_tmp12_, TRUE);
	_tmp13_ = scale;
	_tmp14_ = g_strdup_printf ("%i", max);
	_tmp15_ = _tmp14_;
	gtk_range_set_round_digits ((GtkRange*) _tmp13_, g_utf8_strlen (_tmp15_, (gssize) -1));
	_g_free0 (_tmp15_);
	_tmp16_ = scale;
	gtk_range_set_value ((GtkRange*) _tmp16_, (gdouble) dflt);
	_tmp17_ = scale;
	g_signal_connect ((GtkRange*) _tmp17_, "value-changed", (GCallback) ___lambda45__gtk_range_value_changed, self);
	_tmp18_ = lbl;
	gtk_grid_attach (grid, (GtkWidget*) _tmp18_, 0, row, 1, 1);
	_tmp19_ = scale;
	gtk_grid_attach (grid, (GtkWidget*) _tmp19_, 1, row, 1, 1);
	if (help != NULL) {
		GtkLabel* hlp = NULL;
		GtkLabel* _tmp20_;
		GtkLabel* _tmp21_;
		_tmp20_ = export_make_help (self, help);
		hlp = _tmp20_;
		_tmp21_ = hlp;
		gtk_grid_attach (grid, (GtkWidget*) _tmp21_, 0, row + 1, 2, 1);
		_g_object_unref0 (hlp);
	}
	_tmp22_ = self->priv->_settings;
	_tmp23_ = scale;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, name, (GtkWidget*) _tmp23_);
	_g_object_unref0 (scale);
	_g_object_unref0 (lbl);
}

static void
__lambda46_ (Export* self)
{
	g_signal_emit (self, export_signals[EXPORT_SETTINGS_CHANGED_SIGNAL], 0);
}

static void
___lambda46__zoom_widget_zoom_changed (ZoomWidget* _sender,
                                       gdouble factor,
                                       gpointer self)
{
	__lambda46_ ((Export*) self);
}

void
export_add_setting_zoom (Export* self,
                         const gchar* name,
                         GtkGrid* grid,
                         const gchar* label,
                         const gchar* help,
                         gint min,
                         gint max,
                         gint step,
                         gint dflt)
{
	gint row = 0;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkLabel* lbl = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	ZoomWidget* zoom = NULL;
	ZoomWidget* _tmp9_;
	ZoomWidget* _tmp10_;
	ZoomWidget* _tmp11_;
	GtkLabel* _tmp12_;
	ZoomWidget* _tmp13_;
	GeeHashMap* _tmp16_;
	ZoomWidget* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (grid != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	row = _tmp2_ * 2;
	_tmp3_ = utils_make_title (label);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	lbl = _tmp6_;
	_tmp7_ = lbl;
	gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_START);
	_tmp8_ = lbl;
	gtk_label_set_use_markup (_tmp8_, TRUE);
	_tmp9_ = zoom_widget_new (min, max, step, TRUE);
	g_object_ref_sink (_tmp9_);
	zoom = _tmp9_;
	_tmp10_ = zoom;
	zoom_widget_set_value (_tmp10_, dflt);
	_tmp11_ = zoom;
	g_signal_connect (_tmp11_, "zoom-changed", (GCallback) ___lambda46__zoom_widget_zoom_changed, self);
	_tmp12_ = lbl;
	gtk_grid_attach (grid, (GtkWidget*) _tmp12_, 0, row, 1, 1);
	_tmp13_ = zoom;
	gtk_grid_attach (grid, (GtkWidget*) _tmp13_, 1, row, 1, 1);
	if (help != NULL) {
		GtkLabel* hlp = NULL;
		GtkLabel* _tmp14_;
		GtkLabel* _tmp15_;
		_tmp14_ = export_make_help (self, help);
		hlp = _tmp14_;
		_tmp15_ = hlp;
		gtk_grid_attach (grid, (GtkWidget*) _tmp15_, 0, row + 1, 2, 1);
		_g_object_unref0 (hlp);
	}
	_tmp16_ = self->priv->_settings;
	_tmp17_ = zoom;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, name, (GtkWidget*) _tmp17_);
	_g_object_unref0 (zoom);
	_g_object_unref0 (lbl);
}

gboolean
export_is_bool_setting (Export* self,
                        const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp1_ = self->priv->_settings;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, name)) {
		GeeHashMap* _tmp2_;
		gpointer _tmp3_;
		GtkWidget* _tmp4_;
		GtkSwitch* _tmp5_;
		GtkSwitch* _tmp6_;
		_tmp2_ = self->priv->_settings;
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, name);
		_tmp4_ = (GtkWidget*) _tmp3_;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_switch_get_type ()) ? ((GtkSwitch*) _tmp4_) : NULL;
		if (_tmp5_ == NULL) {
			_g_object_unref0 (_tmp4_);
		}
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ != NULL;
		_g_object_unref0 (_tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
export_is_scale_setting (Export* self,
                         const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp1_ = self->priv->_settings;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, name)) {
		GeeHashMap* _tmp2_;
		gpointer _tmp3_;
		GtkWidget* _tmp4_;
		GtkScale* _tmp5_;
		GtkScale* _tmp6_;
		_tmp2_ = self->priv->_settings;
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, name);
		_tmp4_ = (GtkWidget*) _tmp3_;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_scale_get_type ()) ? ((GtkScale*) _tmp4_) : NULL;
		if (_tmp5_ == NULL) {
			_g_object_unref0 (_tmp4_);
		}
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ != NULL;
		_g_object_unref0 (_tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
export_is_zoom_setting (Export* self,
                        const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp1_ = self->priv->_settings;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, name)) {
		GeeHashMap* _tmp2_;
		gpointer _tmp3_;
		GtkWidget* _tmp4_;
		ZoomWidget* _tmp5_;
		ZoomWidget* _tmp6_;
		_tmp2_ = self->priv->_settings;
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, name);
		_tmp4_ = (GtkWidget*) _tmp3_;
		_tmp5_ = IS_ZOOM_WIDGET (_tmp4_) ? ((ZoomWidget*) _tmp4_) : NULL;
		if (_tmp5_ == NULL) {
			_g_object_unref0 (_tmp4_);
		}
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ != NULL;
		_g_object_unref0 (_tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
export_set_bool (Export* self,
                 const gchar* name,
                 gboolean value)
{
	GeeHashMap* _tmp0_;
	GtkSwitch* sw = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->_settings;
	_vala_assert (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name), "_settings.has_key( name )");
	_tmp1_ = self->priv->_settings;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, name);
	sw = G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp2_, gtk_switch_get_type (), GtkSwitch);
	gtk_switch_set_active (sw, value);
	_g_object_unref0 (sw);
}

gboolean
export_get_bool (Export* self,
                 const gchar* name)
{
	GeeHashMap* _tmp0_;
	GtkSwitch* sw = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->_settings;
	_vala_assert (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name), "_settings.has_key( name )");
	_tmp1_ = self->priv->_settings;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, name);
	sw = G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp2_, gtk_switch_get_type (), GtkSwitch);
	_tmp3_ = gtk_switch_get_active (sw);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	_g_object_unref0 (sw);
	return result;
}

void
export_set_scale (Export* self,
                  const gchar* name,
                  gint value)
{
	GeeHashMap* _tmp0_;
	GtkScale* scale = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gdouble double_value = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->_settings;
	_vala_assert (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name), "_settings.has_key( name )");
	_tmp1_ = self->priv->_settings;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, name);
	scale = G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp2_, gtk_scale_get_type (), GtkScale);
	double_value = (gdouble) value;
	gtk_range_set_value ((GtkRange*) scale, double_value);
	_g_object_unref0 (scale);
}

gint
export_get_scale (Export* self,
                  const gchar* name)
{
	GeeHashMap* _tmp0_;
	GtkScale* scale = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->_settings;
	_vala_assert (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name), "_settings.has_key( name )");
	_tmp1_ = self->priv->_settings;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, name);
	scale = G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp2_, gtk_scale_get_type (), GtkScale);
	result = (gint) gtk_range_get_value ((GtkRange*) scale);
	_g_object_unref0 (scale);
	return result;
}

void
export_set_zoom (Export* self,
                 const gchar* name,
                 gint value)
{
	GeeHashMap* _tmp0_;
	ZoomWidget* zoom = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->_settings;
	_vala_assert (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name), "_settings.has_key( name )");
	_tmp1_ = self->priv->_settings;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, name);
	zoom = G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp2_, TYPE_ZOOM_WIDGET, ZoomWidget);
	zoom_widget_set_value (zoom, value);
	_g_object_unref0 (zoom);
}

gint
export_get_zoom (Export* self,
                 const gchar* name)
{
	GeeHashMap* _tmp0_;
	ZoomWidget* zoom = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->_settings;
	_vala_assert (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, name), "_settings.has_key( name )");
	_tmp1_ = self->priv->_settings;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, name);
	zoom = G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp2_, TYPE_ZOOM_WIDGET, ZoomWidget);
	_tmp3_ = zoom_widget_get_value (zoom);
	_tmp4_ = _tmp3_;
	result = _tmp4_;
	_g_object_unref0 (zoom);
	return result;
}

static void
export_real_save_settings (Export* self,
                           xmlNode* node)
{
}

void
export_save_settings (Export* self,
                      xmlNode* node)
{
	ExportClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = EXPORT_GET_CLASS (self);
	if (_klass_->save_settings) {
		_klass_->save_settings (self, node);
	}
}

static void
export_real_load_settings (Export* self,
                           xmlNode* node)
{
}

void
export_load_settings (Export* self,
                      xmlNode* node)
{
	ExportClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = EXPORT_GET_CLASS (self);
	if (_klass_->load_settings) {
		_klass_->load_settings (self, node);
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gboolean
export_filename_matches (Export* self,
                         const gchar* fname,
                         gchar** basename)
{
	gchar* _vala_basename = NULL;
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (fname != NULL, FALSE);
	_tmp0_ = self->priv->_dir;
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (fname);
		_g_free0 (_vala_basename);
		_vala_basename = _tmp1_;
		result = TRUE;
		if (basename) {
			*basename = _vala_basename;
		} else {
			_g_free0 (_vala_basename);
		}
		return result;
	} else {
		gchar** _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_ = 0;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp2_ = export_get_extensions (self, &_tmp3_);
		_tmp2__length1 = _tmp3_;
		_tmp4_ = _tmp2_;
		_tmp4__length1 = _tmp2__length1;
		{
			gchar** extension_collection = NULL;
			gint extension_collection_length1 = 0;
			gint _extension_collection_size_ = 0;
			gint extension_it = 0;
			extension_collection = _tmp4_;
			extension_collection_length1 = _tmp4__length1;
			for (extension_it = 0; extension_it < extension_collection_length1; extension_it = extension_it + 1) {
				gchar* _tmp5_;
				gchar* extension = NULL;
				_tmp5_ = g_strdup (extension_collection[extension_it]);
				extension = _tmp5_;
				{
					const gchar* _tmp6_;
					_tmp6_ = extension;
					if (g_str_has_suffix (fname, _tmp6_)) {
						gint _tmp7_;
						gint _tmp8_;
						const gchar* _tmp9_;
						gint _tmp10_;
						gint _tmp11_;
						gchar* _tmp12_;
						_tmp7_ = strlen (fname);
						_tmp8_ = _tmp7_;
						_tmp9_ = extension;
						_tmp10_ = strlen (_tmp9_);
						_tmp11_ = _tmp10_;
						_tmp12_ = string_slice (fname, (glong) 0, (glong) (_tmp8_ - _tmp11_));
						_g_free0 (_vala_basename);
						_vala_basename = _tmp12_;
						result = TRUE;
						_g_free0 (extension);
						if (basename) {
							*basename = _vala_basename;
						} else {
							_g_free0 (_vala_basename);
						}
						return result;
					}
					_g_free0 (extension);
				}
			}
		}
		result = FALSE;
		if (basename) {
			*basename = _vala_basename;
		} else {
			_g_free0 (_vala_basename);
		}
		return result;
	}
}

xmlNode*
export_save (Export* self)
{
	xmlNode* node = NULL;
	xmlNode* _tmp0_;
	const gchar* _tmp1_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "export");
	node = _tmp0_;
	_tmp1_ = self->priv->_name;
	xmlSetProp (node, (xmlChar*) "name", (xmlChar*) _tmp1_);
	export_save_settings (self, node);
	result = node;
	return result;
}

void
export_load (Export* self,
             xmlNode* node)
{
	g_return_if_fail (self != NULL);
	export_load_settings (self, node);
}

const gchar*
export_get_name (Export* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
export_set_name (Export* self,
                 const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}

const gchar*
export_get_label (Export* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
export_set_label (Export* self,
                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_label);
	self->priv->_label = _tmp0_;
}

gchar**
export_get_extensions (Export* self,
                       gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_extensions;
	_tmp0__length1 = self->priv->_extensions_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
export_set_extensions (Export* self,
                       gchar** value,
                       gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->_extensions = (_vala_array_free (self->priv->_extensions, self->priv->_extensions_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_extensions = _tmp0_;
	self->priv->_extensions_length1 = _tmp0__length1;
	self->priv->__extensions_size_ = self->priv->_extensions_length1;
}

gboolean
export_get_importable (Export* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_importable;
	return result;
}

static void
export_set_importable (Export* self,
                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_importable = value;
}

gboolean
export_get_exportable (Export* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_exportable;
	return result;
}

static void
export_set_exportable (Export* self,
                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_exportable = value;
}

gboolean
export_get_dir (Export* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_dir;
	return result;
}

static void
export_set_dir (Export* self,
                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_dir = value;
}

static void
value_export_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_export_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		export_unref (value->data[0].v_pointer);
	}
}

static void
value_export_copy_value (const GValue* src_value,
                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = export_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_export_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_export_collect_value (GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Export * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = export_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_export_lcopy_value (const GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	Export ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = export_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_export (const gchar* name,
                   const gchar* nick,
                   const gchar* blurb,
                   GType object_type,
                   GParamFlags flags)
{
	ParamSpecExport* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EXPORT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_export (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPORT), NULL);
	return value->data[0].v_pointer;
}

void
value_set_export (GValue* value,
                  gpointer v_object)
{
	Export * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		export_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		export_unref (old);
	}
}

void
value_take_export (GValue* value,
                   gpointer v_object)
{
	Export * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EXPORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EXPORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		export_unref (old);
	}
}

static void
export_class_init (ExportClass * klass,
                   gpointer klass_data)
{
	export_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->finalize = export_finalize;
	g_type_class_adjust_private_offset (klass, &Export_private_offset);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_real_export;
	((ExportClass *) klass)->import = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_real_import;
	((ExportClass *) klass)->add_settings = (void (*) (Export*, GtkGrid*)) export_real_add_settings;
	((ExportClass *) klass)->save_settings = (void (*) (Export*, xmlNode*)) export_real_save_settings;
	((ExportClass *) klass)->load_settings = (void (*) (Export*, xmlNode*)) export_real_load_settings;
	export_signals[EXPORT_SETTINGS_CHANGED_SIGNAL] = g_signal_new ("settings-changed", TYPE_EXPORT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
export_instance_init (Export * self,
                      gpointer klass)
{
	self->priv = export_get_instance_private (self);
	self->ref_count = 1;
}

static void
export_finalize (Export * obj)
{
	Export * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPORT, Export);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_settings);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_label);
	self->priv->_extensions = (_vala_array_free (self->priv->_extensions, self->priv->_extensions_length1, (GDestroyNotify) g_free), NULL);
}

static GType
export_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_export_init, value_export_free_value, value_export_copy_value, value_export_peek_pointer, "p", value_export_collect_value, "p", value_export_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ExportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Export), 0, (GInstanceInitFunc) export_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType export_type_id;
	export_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Export", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Export_private_offset = g_type_add_instance_private (export_type_id, sizeof (ExportPrivate));
	return export_type_id;
}

GType
export_get_type (void)
{
	static volatile gsize export_type_id__once = 0;
	if (g_once_init_enter (&export_type_id__once)) {
		GType export_type_id;
		export_type_id = export_get_type_once ();
		g_once_init_leave (&export_type_id__once, export_type_id);
	}
	return export_type_id__once;
}

gpointer
export_ref (gpointer instance)
{
	Export * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
export_unref (gpointer instance)
{
	Export * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		EXPORT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

