/* ExportPortableMinder.c generated by valac 0.56.18, the Vala compiler
 * generated from ExportPortableMinder.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <archive.h>
#include <gio/gio.h>
#include <archive_entry.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EXPORT (export_get_type ())
#define EXPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT, Export))
#define EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT, ExportClass))
#define IS_EXPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT))
#define IS_EXPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT))
#define EXPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT, ExportClass))

typedef struct _Export Export;
typedef struct _ExportClass ExportClass;
typedef struct _ExportPrivate ExportPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_EXPORT_PORTABLE_MINDER (export_portable_minder_get_type ())
#define EXPORT_PORTABLE_MINDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORT_PORTABLE_MINDER, ExportPortableMinder))
#define EXPORT_PORTABLE_MINDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORT_PORTABLE_MINDER, ExportPortableMinderClass))
#define IS_EXPORT_PORTABLE_MINDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORT_PORTABLE_MINDER))
#define IS_EXPORT_PORTABLE_MINDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORT_PORTABLE_MINDER))
#define EXPORT_PORTABLE_MINDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORT_PORTABLE_MINDER, ExportPortableMinderClass))

typedef struct _ExportPortableMinder ExportPortableMinder;
typedef struct _ExportPortableMinderClass ExportPortableMinderClass;
typedef struct _ExportPortableMinderPrivate ExportPortableMinderPrivate;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_IMAGE_MANAGER (image_manager_get_type ())
#define IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_MANAGER, ImageManager))
#define IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_MANAGER, ImageManagerClass))
#define IS_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_MANAGER))
#define IS_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_MANAGER))
#define IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_MANAGER, ImageManagerClass))

typedef struct _ImageManager ImageManager;
typedef struct _ImageManagerClass ImageManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _archive_write_free0(var) ((var == NULL) ? NULL : (var = (archive_write_free (var), NULL)))
#define _archive_entry_free0(var) ((var == NULL) ? NULL : (var = (archive_entry_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _archive_read_free0(var) ((var == NULL) ? NULL : (var = (archive_read_free (var), NULL)))

struct _Export {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ExportPrivate * priv;
};

struct _ExportClass {
	GTypeClass parent_class;
	void (*finalize) (Export *self);
	gboolean (*export) (Export* self, const gchar* fname, DrawArea* da);
	gboolean (*import) (Export* self, const gchar* fname, DrawArea* da);
	void (*add_settings) (Export* self, GtkGrid* grid);
	void (*save_settings) (Export* self, xmlNode* node);
	void (*load_settings) (Export* self, xmlNode* node);
};

struct _ExportPortableMinder {
	Export parent_instance;
	ExportPortableMinderPrivate * priv;
};

struct _ExportPortableMinderClass {
	ExportClass parent_class;
};

static gpointer export_portable_minder_parent_class = NULL;

VALA_EXTERN gpointer export_ref (gpointer instance);
VALA_EXTERN void export_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_export (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_export (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_export (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_export (const GValue* value);
VALA_EXTERN GType export_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Export, export_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType export_portable_minder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ExportPortableMinder, export_unref)
VALA_EXTERN gboolean export_export (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN gboolean export_import (Export* self,
                        const gchar* fname,
                        DrawArea* da);
VALA_EXTERN ExportPortableMinder* export_portable_minder_new (void);
VALA_EXTERN ExportPortableMinder* export_portable_minder_construct (GType object_type);
VALA_EXTERN Export* export_new (const gchar* name,
                    const gchar* label,
                    gchar** extensions,
                    gint extensions_length1,
                    gboolean exportable,
                    gboolean importable,
                    gboolean dir);
VALA_EXTERN Export* export_construct (GType object_type,
                          const gchar* name,
                          const gchar* label,
                          gchar** extensions,
                          gint extensions_length1,
                          gboolean exportable,
                          gboolean importable,
                          gboolean dir);
static gboolean export_portable_minder_real_export (Export* base,
                                             const gchar* fname,
                                             DrawArea* da);
VALA_EXTERN gboolean export_portable_minder_archive_file (ExportPortableMinder* self,
                                              struct archive* archive,
                                              const gchar* fname,
                                              gint* image_id);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN Document* draw_area_get_doc (DrawArea* self);
VALA_EXTERN const gchar* document_get_filename (Document* self);
VALA_EXTERN gpointer image_manager_ref (gpointer instance);
VALA_EXTERN void image_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_image_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_image_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_image_manager (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_image_manager (const GValue* value);
VALA_EXTERN GType image_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageManager, image_manager_unref)
VALA_EXTERN ImageManager* draw_area_get_image_manager (DrawArea* self);
VALA_EXTERN GArray* image_manager_get_ids (ImageManager* self);
VALA_EXTERN gchar* image_manager_get_file (ImageManager* self,
                               gint id);
static gboolean export_portable_minder_real_import (Export* base,
                                             const gchar* fname,
                                             DrawArea* da);
static guint8* _vala_array_dup5 (guint8* self,
                          gssize length);
VALA_EXTERN gint image_manager_add_image (ImageManager* self,
                              const gchar* uri,
                              gint* orig_id);
VALA_EXTERN gboolean document_load (Document* self);
VALA_EXTERN void draw_area_auto_save (DrawArea* self);
static GType export_portable_minder_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

ExportPortableMinder*
export_portable_minder_construct (GType object_type)
{
	ExportPortableMinder* self = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_tmp0_ = g_strdup (".pminder");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	self = (ExportPortableMinder*) export_construct (object_type, "portable-minder", _ ("Portable Minder"), _tmp2_, (gint) 1, TRUE, TRUE, FALSE);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ExportPortableMinder*
export_portable_minder_new (void)
{
	return export_portable_minder_construct (TYPE_EXPORT_PORTABLE_MINDER);
}

static gboolean
export_portable_minder_real_export (Export* base,
                                    const gchar* fname,
                                    DrawArea* da)
{
	ExportPortableMinder * self;
	struct archive* archive = NULL;
	struct archive* _tmp0_;
	struct archive* _tmp1_;
	struct archive* _tmp2_;
	struct archive* _tmp3_;
	struct archive* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GArray* image_ids = NULL;
	ImageManager* _tmp9_;
	ImageManager* _tmp10_;
	GArray* _tmp11_;
	struct archive* _tmp21_;
	gboolean result;
	self = (ExportPortableMinder*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = archive_write_new ();
	archive = _tmp0_;
	_tmp1_ = archive;
	archive_write_add_filter_gzip (_tmp1_);
	_tmp2_ = archive;
	archive_write_set_format_pax_restricted (_tmp2_);
	_tmp3_ = archive;
	archive_write_open_filename (_tmp3_, fname);
	_tmp4_ = archive;
	_tmp5_ = draw_area_get_doc (da);
	_tmp6_ = _tmp5_;
	_tmp7_ = document_get_filename (_tmp6_);
	_tmp8_ = _tmp7_;
	export_portable_minder_archive_file (self, _tmp4_, _tmp8_, NULL);
	_g_object_unref0 (_tmp6_);
	_tmp9_ = draw_area_get_image_manager (da);
	_tmp10_ = _tmp9_;
	_tmp11_ = image_manager_get_ids (_tmp10_);
	image_ids = _tmp11_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				GArray* _tmp14_;
				gint id = 0;
				GArray* _tmp15_;
				struct archive* _tmp16_;
				ImageManager* _tmp17_;
				ImageManager* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = image_ids;
				if (!(((guint) i) < _tmp14_->len)) {
					break;
				}
				_tmp15_ = image_ids;
				id = g_array_index (_tmp15_, gint, (guint) i);
				_tmp16_ = archive;
				_tmp17_ = draw_area_get_image_manager (da);
				_tmp18_ = _tmp17_;
				_tmp19_ = image_manager_get_file (_tmp18_, id);
				_tmp20_ = _tmp19_;
				export_portable_minder_archive_file (self, _tmp16_, _tmp20_, &id);
				_g_free0 (_tmp20_);
			}
		}
	}
	_tmp21_ = archive;
	if (archive_write_close (_tmp21_) != ARCHIVE_OK) {
		struct archive* _tmp22_;
		const gchar* _tmp23_;
		struct archive* _tmp24_;
		_tmp22_ = archive;
		_tmp23_ = archive_error_string (_tmp22_);
		_tmp24_ = archive;
		g_error ("ExportPortableMinder.vala:55: Error : %s (%d)", _tmp23_, archive_errno (_tmp24_));
	}
	result = TRUE;
	_g_array_unref0 (image_ids);
	_archive_write_free0 (archive);
	return result;
}

gboolean
export_portable_minder_archive_file (ExportPortableMinder* self,
                                     struct archive* archive,
                                     const gchar* fname,
                                     gint* image_id)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (archive != NULL, FALSE);
	g_return_val_if_fail (fname != NULL, FALSE);
	{
		GFile* file = NULL;
		GFile* _tmp0_;
		GFileInfo* file_info = NULL;
		GFile* _tmp1_;
		GFileInfo* _tmp2_;
		GFileInputStream* input_stream = NULL;
		GFile* _tmp3_;
		GFileInputStream* _tmp4_;
		GDataInputStream* data_input_stream = NULL;
		GFileInputStream* _tmp5_;
		GDataInputStream* _tmp6_;
		struct archive_entry* entry = NULL;
		struct archive_entry* _tmp7_;
		struct archive_entry* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		struct archive_entry* _tmp12_;
		GFileInfo* _tmp13_;
		struct archive_entry* _tmp14_;
		struct archive_entry* _tmp15_;
		struct archive_entry* _tmp17_;
		gsize bytes_read = 0UL;
		guint8* buffer = NULL;
		guint8* _tmp22_;
		gint buffer_length1;
		gint _buffer_size_;
		_tmp0_ = g_file_new_for_path (fname);
		file = _tmp0_;
		_tmp1_ = file;
		_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		file_info = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp3_ = file;
		_tmp4_ = g_file_read (_tmp3_, NULL, &_inner_error0_);
		input_stream = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file_info);
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp5_ = input_stream;
		_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp5_);
		data_input_stream = _tmp6_;
		_tmp7_ = archive_entry_new2 (NULL);
		entry = _tmp7_;
		_tmp8_ = entry;
		_tmp9_ = file;
		_tmp10_ = g_file_get_basename (_tmp9_);
		_tmp11_ = _tmp10_;
		archive_entry_set_pathname (_tmp8_, _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = entry;
		_tmp13_ = file_info;
		archive_entry_set_size (_tmp12_, (la_int64_t) g_file_info_get_size (_tmp13_));
		_tmp14_ = entry;
		archive_entry_set_filetype (_tmp14_, AE_IFREG);
		_tmp15_ = entry;
		archive_entry_set_perm (_tmp15_, (__LA_MODE_T) 0644);
		if (image_id != NULL) {
			struct archive_entry* _tmp16_;
			_tmp16_ = entry;
			archive_entry_xattr_add_entry (_tmp16_, "image_id", (void*) image_id, (gsize) sizeof (gint));
		}
		_tmp17_ = entry;
		if (archive_write_header (archive, _tmp17_) != ARCHIVE_OK) {
			GFile* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			_tmp18_ = file;
			_tmp19_ = g_file_get_path (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = archive_error_string (archive);
			g_critical ("ExportPortableMinder.vala:90: Error writing '%s': %s (%d)", _tmp20_, _tmp21_, archive_errno (archive));
			_g_free0 (_tmp20_);
			result = FALSE;
			_archive_entry_free0 (entry);
			_g_object_unref0 (data_input_stream);
			_g_object_unref0 (input_stream);
			_g_object_unref0 (file_info);
			_g_object_unref0 (file);
			return result;
		}
		_tmp22_ = g_new0 (guint8, 64);
		buffer = _tmp22_;
		buffer_length1 = 64;
		_buffer_size_ = buffer_length1;
		while (TRUE) {
			gboolean _tmp23_ = FALSE;
			GDataInputStream* _tmp24_;
			guint8* _tmp25_;
			gint _tmp25__length1;
			gsize _tmp26_ = 0UL;
			gboolean _tmp27_;
			guint8* _tmp28_;
			gint _tmp28__length1;
			_tmp24_ = data_input_stream;
			_tmp25_ = buffer;
			_tmp25__length1 = buffer_length1;
			_tmp27_ = g_input_stream_read_all ((GInputStream*) _tmp24_, _tmp25_, (gsize) _tmp25__length1, &_tmp26_, NULL, &_inner_error0_);
			bytes_read = _tmp26_;
			_tmp23_ = _tmp27_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				buffer = (g_free (buffer), NULL);
				_archive_entry_free0 (entry);
				_g_object_unref0 (data_input_stream);
				_g_object_unref0 (input_stream);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file);
				goto __catch0_g_error;
			}
			if (!_tmp23_) {
				break;
			}
			if (bytes_read <= ((gsize) 0)) {
				break;
			}
			_tmp28_ = buffer;
			_tmp28__length1 = buffer_length1;
			archive_write_data (archive, _tmp28_, (size_t) _tmp28__length1);
		}
		buffer = (g_free (buffer), NULL);
		_archive_entry_free0 (entry);
		_g_object_unref0 (data_input_stream);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_critical ("ExportPortableMinder.vala:109: %s", _tmp30_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp31_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp31_;
	}
	result = TRUE;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static guint8*
_vala_array_dup5 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gboolean
export_portable_minder_real_import (Export* base,
                                    const gchar* fname,
                                    DrawArea* da)
{
	ExportPortableMinder * self;
	struct archive* archive = NULL;
	struct archive* _tmp0_;
	int flags = 0;
	struct archive* extractor = NULL;
	struct archive* _tmp1_;
	gchar* img_dir = NULL;
	gchar* _tmp2_;
	gchar* minder_path = NULL;
	struct archive_entry* entry = NULL;
	const gchar* _tmp62_;
	Document* _tmp63_;
	Document* _tmp64_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ExportPortableMinder*) base;
	g_return_val_if_fail (fname != NULL, FALSE);
	g_return_val_if_fail (da != NULL, FALSE);
	_tmp0_ = archive_read_new ();
	archive = _tmp0_;
	archive_read_support_filter_gzip (archive);
	archive_read_support_format_all (archive);
	flags = ARCHIVE_EXTRACT_TIME;
	flags |= ARCHIVE_EXTRACT_PERM;
	flags |= ARCHIVE_EXTRACT_ACL;
	flags |= ARCHIVE_EXTRACT_FFLAGS;
	_tmp1_ = archive_write_disk_new ();
	extractor = _tmp1_;
	archive_write_disk_set_options (extractor, flags);
	archive_write_disk_set_standard_lookup (extractor);
	_tmp2_ = g_strdup (".");
	img_dir = _tmp2_;
	{
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_dir_make_tmp ("minder-images-XXXXXX", &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (img_dir);
		img_dir = _tmp5_;
		_g_free0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("ExportPortableMinder.vala:144: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		_g_free0 (img_dir);
		_archive_write_free0 (extractor);
		_archive_read_free0 (archive);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	if (archive_read_open_filename (archive, fname, (gsize) 16384) != ARCHIVE_OK) {
		const gchar* _tmp9_;
		_tmp9_ = archive_error_string (archive);
		g_error ("ExportPortableMinder.vala:149: Error: %s (%d)", _tmp9_, archive_errno (archive));
	}
	minder_path = NULL;
	while (TRUE) {
		struct archive_entry* _tmp10_ = NULL;
		int _tmp11_;
		struct archive_entry* _tmp12_;
		const gchar* _tmp13_;
		struct archive_entry* _tmp35_;
		guint8* buffer = NULL;
		gint buffer_length1 = 0;
		gint _buffer_size_ = 0;
		la_int64_t offset = {0};
		struct archive_entry* _tmp42_;
		const gchar* _tmp43_;
		_tmp11_ = archive_read_next_header (archive, &_tmp10_);
		entry = _tmp10_;
		if (!(_tmp11_ == ARCHIVE_OK)) {
			break;
		}
		_tmp12_ = entry;
		_tmp13_ = archive_entry_pathname (_tmp12_);
		if (g_str_has_suffix (_tmp13_, ".minder")) {
			struct archive_entry* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			struct archive_entry* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp14_ = entry;
			_tmp15_ = strlen (fname);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_substring (fname, (glong) 0, (glong) (_tmp16_ - 8));
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, ".minder", NULL);
			_tmp20_ = _tmp19_;
			archive_entry_set_pathname (_tmp14_, _tmp20_);
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
			_tmp21_ = entry;
			_tmp22_ = archive_entry_pathname (_tmp21_);
			_tmp23_ = g_strdup (_tmp22_);
			_g_free0 (minder_path);
			minder_path = _tmp23_;
		} else {
			GFile* file = NULL;
			const gchar* _tmp24_;
			struct archive_entry* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			GFile* _tmp29_;
			GFile* _tmp30_;
			struct archive_entry* _tmp31_;
			GFile* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			_tmp24_ = img_dir;
			_tmp25_ = entry;
			_tmp26_ = archive_entry_pathname (_tmp25_);
			_tmp27_ = g_build_filename (_tmp24_, _tmp26_, NULL);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_file_new_for_path (_tmp28_);
			_tmp30_ = _tmp29_;
			_g_free0 (_tmp28_);
			file = _tmp30_;
			_tmp31_ = entry;
			_tmp32_ = file;
			_tmp33_ = g_file_get_path (_tmp32_);
			_tmp34_ = _tmp33_;
			archive_entry_set_pathname (_tmp31_, _tmp34_);
			_g_free0 (_tmp34_);
			_g_object_unref0 (file);
		}
		_tmp35_ = entry;
		if (archive_write_header (extractor, _tmp35_) != ARCHIVE_OK) {
			continue;
		}
		while (TRUE) {
			guint8* _tmp36_ = NULL;
			size_t _tmp37_ = 0;
			la_int64_t _tmp38_ = {0};
			int _tmp39_;
			guint8* _tmp40_;
			gint _tmp40__length1;
			guint8* _tmp41_;
			gint _tmp41__length1;
			_tmp39_ = archive_read_data_block (archive, &_tmp36_, &_tmp37_, &_tmp38_);
			buffer = (g_free (buffer), NULL);
			_tmp40_ = (_tmp36_ != NULL) ? _vala_array_dup5 (_tmp36_, _tmp37_) : _tmp36_;
			_tmp40__length1 = _tmp37_;
			buffer = _tmp40_;
			buffer_length1 = _tmp40__length1;
			_buffer_size_ = buffer_length1;
			offset = _tmp38_;
			if (!(_tmp39_ == ARCHIVE_OK)) {
				break;
			}
			_tmp41_ = buffer;
			_tmp41__length1 = buffer_length1;
			if (archive_write_data_block (extractor, _tmp41_, (size_t) _tmp41__length1, offset) != ((gssize) ARCHIVE_OK)) {
				break;
			}
		}
		_tmp42_ = entry;
		_tmp43_ = archive_entry_pathname (_tmp42_);
		if (!g_str_has_suffix (_tmp43_, ".minder")) {
			gchar* name = NULL;
			void* value = NULL;
			gsize size = 0UL;
			struct archive_entry* _tmp44_;
			gboolean _tmp45_ = FALSE;
			struct archive_entry* _tmp46_;
			const gchar* _tmp47_ = NULL;
			void* _tmp48_ = NULL;
			gsize _tmp49_ = 0UL;
			int _tmp50_;
			gchar* _tmp51_;
			_tmp44_ = entry;
			archive_entry_xattr_reset (_tmp44_);
			_tmp46_ = entry;
			_tmp50_ = archive_entry_xattr_next (_tmp46_, &_tmp47_, &_tmp48_, &_tmp49_);
			_g_free0 (name);
			_tmp51_ = g_strdup (_tmp47_);
			name = _tmp51_;
			value = _tmp48_;
			size = _tmp49_;
			if (_tmp50_ == ARCHIVE_OK) {
				const gchar* _tmp52_;
				_tmp52_ = name;
				_tmp45_ = g_strcmp0 (_tmp52_, "image_id") == 0;
			} else {
				_tmp45_ = FALSE;
			}
			if (_tmp45_) {
				gint* id = NULL;
				void* _tmp53_;
				ImageManager* _tmp54_;
				ImageManager* _tmp55_;
				struct archive_entry* _tmp56_;
				const gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				gint* _tmp60_;
				_tmp53_ = value;
				id = (gint*) _tmp53_;
				_tmp54_ = draw_area_get_image_manager (da);
				_tmp55_ = _tmp54_;
				_tmp56_ = entry;
				_tmp57_ = archive_entry_pathname (_tmp56_);
				_tmp58_ = g_strconcat ("file://", _tmp57_, NULL);
				_tmp59_ = _tmp58_;
				_tmp60_ = id;
				image_manager_add_image (_tmp55_, _tmp59_, _tmp60_);
				_g_free0 (_tmp59_);
			}
			_g_free0 (name);
		}
		buffer = (g_free (buffer), NULL);
	}
	if (archive_read_close (archive) != ARCHIVE_OK) {
		const gchar* _tmp61_;
		_tmp61_ = archive_error_string (archive);
		g_error ("ExportPortableMinder.vala:210: Error: %s (%d)", _tmp61_, archive_errno (archive));
	}
	_tmp62_ = img_dir;
	g_rmdir (_tmp62_);
	_tmp63_ = draw_area_get_doc (da);
	_tmp64_ = _tmp63_;
	document_load (_tmp64_);
	_g_object_unref0 (_tmp64_);
	draw_area_auto_save (da);
	result = TRUE;
	_g_free0 (minder_path);
	_g_free0 (img_dir);
	_archive_write_free0 (extractor);
	_archive_read_free0 (archive);
	return result;
}

static void
export_portable_minder_class_init (ExportPortableMinderClass * klass,
                                   gpointer klass_data)
{
	export_portable_minder_parent_class = g_type_class_peek_parent (klass);
	((ExportClass *) klass)->export = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_portable_minder_real_export;
	((ExportClass *) klass)->import = (gboolean (*) (Export*, const gchar*, DrawArea*)) export_portable_minder_real_import;
}

static void
export_portable_minder_instance_init (ExportPortableMinder * self,
                                      gpointer klass)
{
}

static GType
export_portable_minder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExportPortableMinderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) export_portable_minder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExportPortableMinder), 0, (GInstanceInitFunc) export_portable_minder_instance_init, NULL };
	GType export_portable_minder_type_id;
	export_portable_minder_type_id = g_type_register_static (TYPE_EXPORT, "ExportPortableMinder", &g_define_type_info, 0);
	return export_portable_minder_type_id;
}

GType
export_portable_minder_get_type (void)
{
	static volatile gsize export_portable_minder_type_id__once = 0;
	if (g_once_init_enter (&export_portable_minder_type_id__once)) {
		GType export_portable_minder_type_id;
		export_portable_minder_type_id = export_portable_minder_get_type_once ();
		g_once_init_leave (&export_portable_minder_type_id__once, export_portable_minder_type_id);
	}
	return export_portable_minder_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

