/* TextCompletion.c generated by valac 0.56.18, the Vala compiler
 * generated from TextCompletion.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <handy.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TEXT_COMPLETION_ITEM (text_completion_item_get_type ())
#define TEXT_COMPLETION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_COMPLETION_ITEM, TextCompletionItem))
#define TEXT_COMPLETION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_COMPLETION_ITEM, TextCompletionItemClass))
#define IS_TEXT_COMPLETION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_COMPLETION_ITEM))
#define IS_TEXT_COMPLETION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_COMPLETION_ITEM))
#define TEXT_COMPLETION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_COMPLETION_ITEM, TextCompletionItemClass))

typedef struct _TextCompletionItem TextCompletionItem;
typedef struct _TextCompletionItemClass TextCompletionItemClass;
typedef struct _TextCompletionItemPrivate TextCompletionItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecTextCompletionItem ParamSpecTextCompletionItem;

#define TYPE_TEXT_COMPLETION (text_completion_get_type ())
#define TEXT_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_COMPLETION, TextCompletion))
#define TEXT_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_COMPLETION, TextCompletionClass))
#define IS_TEXT_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_COMPLETION))
#define IS_TEXT_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_COMPLETION))
#define TEXT_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_COMPLETION, TextCompletionClass))

typedef struct _TextCompletion TextCompletion;
typedef struct _TextCompletionClass TextCompletionClass;
typedef struct _TextCompletionPrivate TextCompletionPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _text_completion_item_unref0(var) ((var == NULL) ? NULL : (var = (text_completion_item_unref (var), NULL)))

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;

#define TYPE_UNDO_TEXT_BUFFER (undo_text_buffer_get_type ())
#define UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBuffer))
#define UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))
#define IS_UNDO_TEXT_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_BUFFER))
#define IS_UNDO_TEXT_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_BUFFER))
#define UNDO_TEXT_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_BUFFER, UndoTextBufferClass))

typedef struct _UndoTextBuffer UndoTextBuffer;
typedef struct _UndoTextBufferClass UndoTextBufferClass;
typedef struct _ParamSpecTextCompletion ParamSpecTextCompletion;

struct _TextCompletionItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TextCompletionItemPrivate * priv;
};

struct _TextCompletionItemClass {
	GTypeClass parent_class;
	void (*finalize) (TextCompletionItem *self);
};

struct _TextCompletionItemPrivate {
	gchar* _label;
	gchar* _alt;
};

struct _ParamSpecTextCompletionItem {
	GParamSpec parent_instance;
};

struct _TextCompletion {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TextCompletionPrivate * priv;
};

struct _TextCompletionClass {
	GTypeClass parent_class;
	void (*finalize) (TextCompletion *self);
};

struct _TextCompletionPrivate {
	DrawArea* _da;
	CanvasText* _ct;
	GtkListBox* _list;
	gboolean _shown;
	gint _size;
	gint _start_pos;
	gint _end_pos;
};

struct _ParamSpecTextCompletion {
	GParamSpec parent_instance;
};

static gint TextCompletionItem_private_offset;
static gpointer text_completion_item_parent_class = NULL;
static gint TextCompletion_private_offset;
static gpointer text_completion_parent_class = NULL;

VALA_EXTERN gpointer text_completion_item_ref (gpointer instance);
VALA_EXTERN void text_completion_item_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_completion_item (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void value_set_text_completion_item (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void value_take_text_completion_item (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer value_get_text_completion_item (const GValue* value);
VALA_EXTERN GType text_completion_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextCompletionItem, text_completion_item_unref)
VALA_EXTERN TextCompletionItem* text_completion_item_new (const gchar* label);
VALA_EXTERN TextCompletionItem* text_completion_item_construct (GType object_type,
                                                    const gchar* label);
static void text_completion_item_set_label (TextCompletionItem* self,
                                     const gchar* value);
VALA_EXTERN TextCompletionItem* text_completion_item_new_with_alt (const gchar* label,
                                                       const gchar* alt);
VALA_EXTERN TextCompletionItem* text_completion_item_construct_with_alt (GType object_type,
                                                             const gchar* label,
                                                             const gchar* alt);
static void text_completion_item_set_alt (TextCompletionItem* self,
                                   const gchar* value);
VALA_EXTERN GtkBox* text_completion_item_create_row (TextCompletionItem* self);
VALA_EXTERN const gchar* text_completion_item_get_label (TextCompletionItem* self);
VALA_EXTERN const gchar* text_completion_item_get_alt (TextCompletionItem* self);
VALA_EXTERN gchar* text_completion_item_get_text (GtkBox* box);
VALA_EXTERN gint text_completion_item_compare (TextCompletionItem* a,
                                   TextCompletionItem* b);
static void text_completion_item_finalize (TextCompletionItem * obj);
static GType text_completion_item_get_type_once (void);
VALA_EXTERN gpointer text_completion_ref (gpointer instance);
VALA_EXTERN void text_completion_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_completion (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_text_completion (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_text_completion (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_text_completion (const GValue* value);
VALA_EXTERN GType text_completion_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextCompletion, text_completion_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN TextCompletion* text_completion_new (DrawArea* da);
VALA_EXTERN TextCompletion* text_completion_construct (GType object_type,
                                           DrawArea* da);
static void text_completion_activate_row (TextCompletion* self,
                                   GtkListBoxRow* row);
static void _text_completion_activate_row_gtk_list_box_row_activated (GtkListBox* _sender,
                                                               GtkListBoxRow* row,
                                                               gpointer self);
VALA_EXTERN void text_completion_show (TextCompletion* self,
                           CanvasText* ct,
                           GList* list,
                           gint start,
                           gint end);
VALA_EXTERN void text_completion_hide (TextCompletion* self);
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN MainWindow* draw_area_get_win (DrawArea* self);
VALA_EXTERN GSettings* main_window_get_settings (MainWindow* self);
VALA_EXTERN void canvas_text_get_cursor_pos (CanvasText* self,
                                 gint* x,
                                 gint* ytop,
                                 gint* ybot);
VALA_EXTERN gint main_window_get_label_height (MainWindow* self);
VALA_EXTERN void draw_area_get_window_ys (DrawArea* self,
                              gint* top,
                              gint* bottom);
static void __lambda111_ (TextCompletion* self,
                   GtkWidget* w);
static void ___lambda111__gtk_callback (GtkWidget* widget,
                                 gpointer self);
VALA_EXTERN void text_completion_down (TextCompletion* self);
VALA_EXTERN void text_completion_up (TextCompletion* self);
VALA_EXTERN void text_completion_select (TextCompletion* self);
VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN GType undo_text_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextBuffer, g_object_unref)
VALA_EXTERN void canvas_text_insert (CanvasText* self,
                         const gchar* s,
                         UndoTextBuffer* undo_buffer);
VALA_EXTERN UndoTextBuffer* draw_area_get_undo_text (DrawArea* self);
VALA_EXTERN void canvas_text_replace (CanvasText* self,
                          gint start,
                          gint end,
                          const gchar* s,
                          UndoTextBuffer* undo_buffer);
VALA_EXTERN gboolean text_completion_get_shown (TextCompletion* self);
static void text_completion_finalize (TextCompletion * obj);
static GType text_completion_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
text_completion_item_get_instance_private (TextCompletionItem* self)
{
	return G_STRUCT_MEMBER_P (self, TextCompletionItem_private_offset);
}

TextCompletionItem*
text_completion_item_construct (GType object_type,
                                const gchar* label)
{
	TextCompletionItem* self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (TextCompletionItem*) g_type_create_instance (object_type);
	text_completion_item_set_label (self, label);
	return self;
}

TextCompletionItem*
text_completion_item_new (const gchar* label)
{
	return text_completion_item_construct (TYPE_TEXT_COMPLETION_ITEM, label);
}

TextCompletionItem*
text_completion_item_construct_with_alt (GType object_type,
                                         const gchar* label,
                                         const gchar* alt)
{
	TextCompletionItem* self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (alt != NULL, NULL);
	self = (TextCompletionItem*) g_type_create_instance (object_type);
	text_completion_item_set_label (self, label);
	text_completion_item_set_alt (self, alt);
	return self;
}

TextCompletionItem*
text_completion_item_new_with_alt (const gchar* label,
                                   const gchar* alt)
{
	return text_completion_item_construct_with_alt (TYPE_TEXT_COMPLETION_ITEM, label, alt);
}

GtkBox*
text_completion_item_create_row (TextCompletionItem* self)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkLabel* lbl = NULL;
	const gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkBox* _tmp7_;
	GtkLabel* _tmp8_;
	const gchar* _tmp9_;
	GtkBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = self->priv->_label;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	lbl = _tmp2_;
	_tmp3_ = lbl;
	gtk_label_set_xalign (_tmp3_, (gfloat) 0);
	_tmp4_ = lbl;
	g_object_set ((GtkWidget*) _tmp4_, "margin", 5, NULL);
	_tmp5_ = lbl;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp5_, 10);
	_tmp6_ = lbl;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp6_, 10);
	_tmp7_ = box;
	_tmp8_ = lbl;
	gtk_box_pack_start (_tmp7_, (GtkWidget*) _tmp8_, FALSE, TRUE, (guint) 0);
	_tmp9_ = self->priv->_alt;
	if (g_strcmp0 (_tmp9_, "") != 0) {
		GtkLabel* albl = NULL;
		const gchar* _tmp10_;
		GtkLabel* _tmp11_;
		GtkLabel* _tmp12_;
		GtkLabel* _tmp13_;
		GtkLabel* _tmp14_;
		GtkLabel* _tmp15_;
		GtkBox* _tmp16_;
		GtkLabel* _tmp17_;
		_tmp10_ = self->priv->_alt;
		_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
		g_object_ref_sink (_tmp11_);
		albl = _tmp11_;
		_tmp12_ = albl;
		gtk_label_set_xalign (_tmp12_, (gfloat) 0);
		_tmp13_ = albl;
		g_object_set ((GtkWidget*) _tmp13_, "margin", 5, NULL);
		_tmp14_ = albl;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp14_, 10);
		_tmp15_ = albl;
		gtk_widget_set_margin_end ((GtkWidget*) _tmp15_, 10);
		_tmp16_ = box;
		_tmp17_ = albl;
		gtk_box_pack_start (_tmp16_, (GtkWidget*) _tmp17_, FALSE, TRUE, (guint) 0);
		_g_object_unref0 (albl);
	}
	result = box;
	_g_object_unref0 (lbl);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gchar*
text_completion_item_get_text (GtkBox* box)
{
	GList* children = NULL;
	GList* _tmp0_;
	GtkLabel* lbl = NULL;
	gconstpointer _tmp1_;
	GtkLabel* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (box != NULL, NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) box);
	children = _tmp0_;
	_tmp1_ = g_list_nth_data (children, g_list_length (children) - 1);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp1_, gtk_label_get_type (), GtkLabel));
	lbl = _tmp2_;
	_tmp3_ = gtk_label_get_text (lbl);
	_tmp4_ = g_strdup (_tmp3_);
	result = _tmp4_;
	_g_object_unref0 (lbl);
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
	return result;
}

gint
text_completion_item_compare (TextCompletionItem* a,
                              TextCompletionItem* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = a->priv->_label;
	_tmp2_ = b->priv->_label;
	result = _tmp0_ (_tmp1_, _tmp2_);
	return result;
}

const gchar*
text_completion_item_get_label (TextCompletionItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
text_completion_item_set_label (TextCompletionItem* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_label);
	self->priv->_label = _tmp0_;
}

const gchar*
text_completion_item_get_alt (TextCompletionItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_alt;
	result = _tmp0_;
	return result;
}

static void
text_completion_item_set_alt (TextCompletionItem* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_alt);
	self->priv->_alt = _tmp0_;
}

static void
value_text_completion_item_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_text_completion_item_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		text_completion_item_unref (value->data[0].v_pointer);
	}
}

static void
value_text_completion_item_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = text_completion_item_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_text_completion_item_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_text_completion_item_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TextCompletionItem * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = text_completion_item_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_text_completion_item_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	TextCompletionItem ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = text_completion_item_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_text_completion_item (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ParamSpecTextCompletionItem* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEXT_COMPLETION_ITEM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_text_completion_item (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_COMPLETION_ITEM), NULL);
	return value->data[0].v_pointer;
}

void
value_set_text_completion_item (GValue* value,
                                gpointer v_object)
{
	TextCompletionItem * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_COMPLETION_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_COMPLETION_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		text_completion_item_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		text_completion_item_unref (old);
	}
}

void
value_take_text_completion_item (GValue* value,
                                 gpointer v_object)
{
	TextCompletionItem * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_COMPLETION_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_COMPLETION_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		text_completion_item_unref (old);
	}
}

static void
text_completion_item_class_init (TextCompletionItemClass * klass,
                                 gpointer klass_data)
{
	text_completion_item_parent_class = g_type_class_peek_parent (klass);
	((TextCompletionItemClass *) klass)->finalize = text_completion_item_finalize;
	g_type_class_adjust_private_offset (klass, &TextCompletionItem_private_offset);
}

static void
text_completion_item_instance_init (TextCompletionItem * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = text_completion_item_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_label = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_alt = _tmp1_;
	self->ref_count = 1;
}

static void
text_completion_item_finalize (TextCompletionItem * obj)
{
	TextCompletionItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_COMPLETION_ITEM, TextCompletionItem);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_alt);
}

static GType
text_completion_item_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_text_completion_item_init, value_text_completion_item_free_value, value_text_completion_item_copy_value, value_text_completion_item_peek_pointer, "p", value_text_completion_item_collect_value, "p", value_text_completion_item_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TextCompletionItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_completion_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextCompletionItem), 0, (GInstanceInitFunc) text_completion_item_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType text_completion_item_type_id;
	text_completion_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TextCompletionItem", &g_define_type_info, &g_define_type_fundamental_info, 0);
	TextCompletionItem_private_offset = g_type_add_instance_private (text_completion_item_type_id, sizeof (TextCompletionItemPrivate));
	return text_completion_item_type_id;
}

GType
text_completion_item_get_type (void)
{
	static volatile gsize text_completion_item_type_id__once = 0;
	if (g_once_init_enter (&text_completion_item_type_id__once)) {
		GType text_completion_item_type_id;
		text_completion_item_type_id = text_completion_item_get_type_once ();
		g_once_init_leave (&text_completion_item_type_id__once, text_completion_item_type_id);
	}
	return text_completion_item_type_id__once;
}

gpointer
text_completion_item_ref (gpointer instance)
{
	TextCompletionItem * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
text_completion_item_unref (gpointer instance)
{
	TextCompletionItem * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEXT_COMPLETION_ITEM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
text_completion_get_instance_private (TextCompletion* self)
{
	return G_STRUCT_MEMBER_P (self, TextCompletion_private_offset);
}

static void
_text_completion_activate_row_gtk_list_box_row_activated (GtkListBox* _sender,
                                                          GtkListBoxRow* row,
                                                          gpointer self)
{
	text_completion_activate_row ((TextCompletion*) self, row);
}

TextCompletion*
text_completion_construct (GType object_type,
                           DrawArea* da)
{
	TextCompletion* self = NULL;
	DrawArea* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (TextCompletion*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_list);
	self->priv->_list = _tmp1_;
	_tmp2_ = self->priv->_list;
	gtk_list_box_set_selection_mode (_tmp2_, GTK_SELECTION_BROWSE);
	_tmp3_ = self->priv->_list;
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	_tmp4_ = self->priv->_list;
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_START);
	_tmp5_ = self->priv->_list;
	g_signal_connect (_tmp5_, "row-activated", (GCallback) _text_completion_activate_row_gtk_list_box_row_activated, self);
	return self;
}

TextCompletion*
text_completion_new (DrawArea* da)
{
	return text_completion_construct (TYPE_TEXT_COMPLETION, da);
}

static void
__lambda111_ (TextCompletion* self,
              GtkWidget* w)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->_list;
	gtk_container_remove ((GtkContainer*) _tmp0_, w);
}

static void
___lambda111__gtk_callback (GtkWidget* widget,
                            gpointer self)
{
	__lambda111_ ((TextCompletion*) self, widget);
}

static gpointer
_text_completion_item_ref0 (gpointer self)
{
	return self ? text_completion_item_ref (self) : NULL;
}

void
text_completion_show (TextCompletion* self,
                      CanvasText* ct,
                      GList* list,
                      gint start,
                      gint end)
{
	gint max_items = 0;
	DrawArea* _tmp0_;
	MainWindow* _tmp1_;
	MainWindow* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	CanvasText* _tmp5_;
	gint _tmp6_ = 0;
	gint x = 0;
	gint ytop = 0;
	gint ybot = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint lbl_height = 0;
	DrawArea* _tmp10_;
	MainWindow* _tmp11_;
	MainWindow* _tmp12_;
	gint height = 0;
	gint win_top = 0;
	gint win_bottom = 0;
	DrawArea* _tmp13_;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean below = FALSE;
	GtkListBox* _tmp16_;
	GtkListBox* _tmp19_;
	gint _tmp26_ = 0;
	GtkListBox* _tmp27_;
	GtkListBox* _tmp28_;
	GtkListBoxRow* _tmp29_;
	GtkListBox* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ct != NULL);
	if (g_list_length (list) == ((guint) 0)) {
		text_completion_hide (self);
		return;
	}
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_win (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = main_window_get_settings (_tmp2_);
	_tmp4_ = _tmp3_;
	max_items = g_settings_get_int (_tmp4_, "max-auto-completion-items");
	_tmp5_ = _g_object_ref0 (ct);
	_g_object_unref0 (self->priv->_ct);
	self->priv->_ct = _tmp5_;
	self->priv->_start_pos = start;
	self->priv->_end_pos = end;
	if (max_items < ((gint) g_list_length (list))) {
		_tmp6_ = max_items;
	} else {
		_tmp6_ = (gint) g_list_length (list);
	}
	self->priv->_size = _tmp6_;
	canvas_text_get_cursor_pos (ct, &_tmp7_, &_tmp8_, &_tmp9_);
	x = _tmp7_;
	ytop = _tmp8_;
	ybot = _tmp9_;
	_tmp10_ = self->priv->_da;
	_tmp11_ = draw_area_get_win (_tmp10_);
	_tmp12_ = _tmp11_;
	lbl_height = main_window_get_label_height (_tmp12_);
	height = self->priv->_size * (lbl_height + 10);
	_tmp13_ = self->priv->_da;
	draw_area_get_window_ys (_tmp13_, &_tmp14_, &_tmp15_);
	win_top = _tmp14_;
	win_bottom = _tmp15_;
	below = (ybot + (max_items * (lbl_height + 10))) <= win_bottom;
	_tmp16_ = self->priv->_list;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp16_, x);
	if (below) {
		GtkListBox* _tmp17_;
		_tmp17_ = self->priv->_list;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp17_, ybot + 5);
	} else {
		GtkListBox* _tmp18_;
		list = g_list_reverse (list);
		_tmp18_ = self->priv->_list;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp18_, (ytop - 5) - height);
	}
	_tmp19_ = self->priv->_list;
	gtk_container_foreach ((GtkContainer*) _tmp19_, ___lambda111__gtk_callback, self);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = list;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			TextCompletionItem* _tmp20_;
			TextCompletionItem* item = NULL;
			_tmp20_ = _text_completion_item_ref0 ((TextCompletionItem*) item_it->data);
			item = _tmp20_;
			{
				GtkListBox* _tmp21_;
				TextCompletionItem* _tmp22_;
				GtkBox* _tmp23_;
				GtkBox* _tmp24_;
				gint _tmp25_;
				_tmp21_ = self->priv->_list;
				_tmp22_ = item;
				_tmp23_ = text_completion_item_create_row (_tmp22_);
				_tmp24_ = _tmp23_;
				gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp24_);
				_g_object_unref0 (_tmp24_);
				max_items = max_items - 1;
				_tmp25_ = max_items;
				if (_tmp25_ <= 0) {
					_text_completion_item_unref0 (item);
					break;
				}
				_text_completion_item_unref0 (item);
			}
		}
	}
	if (below) {
		_tmp26_ = 0;
	} else {
		_tmp26_ = self->priv->_size - 1;
	}
	_tmp27_ = self->priv->_list;
	_tmp28_ = self->priv->_list;
	_tmp29_ = gtk_list_box_get_row_at_index (_tmp28_, _tmp26_);
	gtk_list_box_select_row (_tmp27_, _tmp29_);
	_tmp30_ = self->priv->_list;
	gtk_widget_show_all ((GtkWidget*) _tmp30_);
	if (!self->priv->_shown) {
		GtkOverlay* overlay = NULL;
		DrawArea* _tmp31_;
		GtkContainer* _tmp32_;
		GtkOverlay* _tmp33_;
		GtkOverlay* _tmp34_;
		GtkListBox* _tmp35_;
		_tmp31_ = self->priv->_da;
		_tmp32_ = gtk_widget_get_parent ((GtkWidget*) _tmp31_);
		_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_overlay_get_type (), GtkOverlay));
		overlay = _tmp33_;
		_tmp34_ = overlay;
		_tmp35_ = self->priv->_list;
		gtk_overlay_add_overlay (_tmp34_, (GtkWidget*) _tmp35_);
		_g_object_unref0 (overlay);
	}
	self->priv->_shown = TRUE;
}

void
text_completion_hide (TextCompletion* self)
{
	GtkListBox* _tmp0_;
	g_return_if_fail (self != NULL);
	if (!self->priv->_shown) {
		return;
	}
	_tmp0_ = self->priv->_list;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
	self->priv->_shown = FALSE;
}

void
text_completion_down (TextCompletion* self)
{
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	g_return_if_fail (self != NULL);
	if (!self->priv->_shown) {
		return;
	}
	_tmp0_ = self->priv->_list;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	row = _tmp2_;
	_tmp3_ = row;
	if ((gtk_list_box_row_get_index (_tmp3_) + 1) < self->priv->_size) {
		GtkListBox* _tmp4_;
		GtkListBox* _tmp5_;
		GtkListBoxRow* _tmp6_;
		GtkListBoxRow* _tmp7_;
		_tmp4_ = self->priv->_list;
		_tmp5_ = self->priv->_list;
		_tmp6_ = row;
		_tmp7_ = gtk_list_box_get_row_at_index (_tmp5_, gtk_list_box_row_get_index (_tmp6_) + 1);
		gtk_list_box_select_row (_tmp4_, _tmp7_);
	}
	_g_object_unref0 (row);
}

void
text_completion_up (TextCompletion* self)
{
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp3_;
	g_return_if_fail (self != NULL);
	if (!self->priv->_shown) {
		return;
	}
	_tmp0_ = self->priv->_list;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	row = _tmp2_;
	_tmp3_ = row;
	if (gtk_list_box_row_get_index (_tmp3_) > 0) {
		GtkListBox* _tmp4_;
		GtkListBox* _tmp5_;
		GtkListBoxRow* _tmp6_;
		GtkListBoxRow* _tmp7_;
		_tmp4_ = self->priv->_list;
		_tmp5_ = self->priv->_list;
		_tmp6_ = row;
		_tmp7_ = gtk_list_box_get_row_at_index (_tmp5_, gtk_list_box_row_get_index (_tmp6_) - 1);
		gtk_list_box_select_row (_tmp4_, _tmp7_);
	}
	_g_object_unref0 (row);
}

void
text_completion_select (TextCompletion* self)
{
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	g_return_if_fail (self != NULL);
	if (!self->priv->_shown) {
		return;
	}
	_tmp0_ = self->priv->_list;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	text_completion_activate_row (self, _tmp1_);
}

static void
text_completion_activate_row (TextCompletion* self,
                              GtkListBoxRow* row)
{
	GtkBox* box = NULL;
	GtkWidget* _tmp0_;
	GtkBox* _tmp1_;
	gchar* value = NULL;
	GtkBox* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_box_get_type (), GtkBox));
	box = _tmp1_;
	_tmp2_ = box;
	_tmp3_ = text_completion_item_get_text (_tmp2_);
	value = _tmp3_;
	if (self->priv->_start_pos == self->priv->_end_pos) {
		CanvasText* _tmp4_;
		const gchar* _tmp5_;
		DrawArea* _tmp6_;
		UndoTextBuffer* _tmp7_;
		UndoTextBuffer* _tmp8_;
		_tmp4_ = self->priv->_ct;
		_tmp5_ = value;
		_tmp6_ = self->priv->_da;
		_tmp7_ = draw_area_get_undo_text (_tmp6_);
		_tmp8_ = _tmp7_;
		canvas_text_insert (_tmp4_, _tmp5_, _tmp8_);
	} else {
		CanvasText* _tmp9_;
		const gchar* _tmp10_;
		DrawArea* _tmp11_;
		UndoTextBuffer* _tmp12_;
		UndoTextBuffer* _tmp13_;
		_tmp9_ = self->priv->_ct;
		_tmp10_ = value;
		_tmp11_ = self->priv->_da;
		_tmp12_ = draw_area_get_undo_text (_tmp11_);
		_tmp13_ = _tmp12_;
		canvas_text_replace (_tmp9_, self->priv->_start_pos, self->priv->_end_pos, _tmp10_, _tmp13_);
	}
	text_completion_hide (self);
	_g_free0 (value);
	_g_object_unref0 (box);
}

gboolean
text_completion_get_shown (TextCompletion* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_shown;
	return result;
}

static void
value_text_completion_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_text_completion_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		text_completion_unref (value->data[0].v_pointer);
	}
}

static void
value_text_completion_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = text_completion_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_text_completion_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_text_completion_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TextCompletion * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = text_completion_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_text_completion_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	TextCompletion ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = text_completion_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_text_completion (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecTextCompletion* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEXT_COMPLETION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_text_completion (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_COMPLETION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_text_completion (GValue* value,
                           gpointer v_object)
{
	TextCompletion * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_COMPLETION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_COMPLETION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		text_completion_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		text_completion_unref (old);
	}
}

void
value_take_text_completion (GValue* value,
                            gpointer v_object)
{
	TextCompletion * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEXT_COMPLETION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEXT_COMPLETION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		text_completion_unref (old);
	}
}

static void
text_completion_class_init (TextCompletionClass * klass,
                            gpointer klass_data)
{
	text_completion_parent_class = g_type_class_peek_parent (klass);
	((TextCompletionClass *) klass)->finalize = text_completion_finalize;
	g_type_class_adjust_private_offset (klass, &TextCompletion_private_offset);
}

static void
text_completion_instance_init (TextCompletion * self,
                               gpointer klass)
{
	self->priv = text_completion_get_instance_private (self);
	self->priv->_shown = FALSE;
	self->priv->_size = 0;
	self->priv->_start_pos = 0;
	self->priv->_end_pos = 0;
	self->ref_count = 1;
}

static void
text_completion_finalize (TextCompletion * obj)
{
	TextCompletion * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEXT_COMPLETION, TextCompletion);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_da);
	_g_object_unref0 (self->priv->_ct);
	_g_object_unref0 (self->priv->_list);
}

static GType
text_completion_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_text_completion_init, value_text_completion_free_value, value_text_completion_copy_value, value_text_completion_peek_pointer, "p", value_text_completion_collect_value, "p", value_text_completion_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TextCompletionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_completion_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextCompletion), 0, (GInstanceInitFunc) text_completion_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType text_completion_type_id;
	text_completion_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TextCompletion", &g_define_type_info, &g_define_type_fundamental_info, 0);
	TextCompletion_private_offset = g_type_add_instance_private (text_completion_type_id, sizeof (TextCompletionPrivate));
	return text_completion_type_id;
}

GType
text_completion_get_type (void)
{
	static volatile gsize text_completion_type_id__once = 0;
	if (g_once_init_enter (&text_completion_type_id__once)) {
		GType text_completion_type_id;
		text_completion_type_id = text_completion_get_type_once ();
		g_once_init_leave (&text_completion_type_id__once, text_completion_type_id);
	}
	return text_completion_type_id__once;
}

gpointer
text_completion_ref (gpointer instance)
{
	TextCompletion * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
text_completion_unref (gpointer instance)
{
	TextCompletion * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEXT_COMPLETION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

