/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_41 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 8111, "epsg", 8111,
        "NAD83(HARN) / WISCRS Vernon (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.5750329397222 +lat_0=43.575032939722");
    add_proj4text (p, 1,
        "2 +lon_0=-90.7833333333333 +k_0=1.0000408158 +x_0=222504");
    add_proj4text (p, 2,
        ".4451 +y_0=47532.0602 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Vernon (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.57503");
    add_srs_wkt (p, 8,
        "29397222],PARAMETER[\"central_meridian\",-90.78333333333");
    add_srs_wkt (p, 9,
        "33],PARAMETER[\"scale_factor\",1.0000408158],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",222504.4451],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",47532.0602],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"8111\"]]");
    p = add_epsg_def_ex (filter, first, last, 8112, "epsg", 8112,
        "NAD83(HARN) / WISCRS Vernon (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.5750329397222 +lat_0=43.575032939722");
    add_proj4text (p, 1,
        "2 +lon_0=-90.7833333333333 +k_0=1.0000408158 +x_0=222504");
    add_proj4text (p, 2,
        ".44500889 +y_0=47532.0603505207 +ellps=GRS80 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Vernon (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.");
    add_srs_wkt (p, 8,
        "5750329397222],PARAMETER[\"central_meridian\",-90.783333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"scale_factor\",1.0000408158],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",730000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",155944.768],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8112\"]]");
    p = add_epsg_def_ex (filter, first, last, 8113, "epsg", 8113,
        "NAD83(HARN) / WISCRS Trempealeau (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.1611111111111 +lon_0=-91.366666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000361538 +x_0=256946.9138 +y_0=0.0041 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Trempealeau (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",43.1611111");
    add_srs_wkt (p, 8,
        "111111],PARAMETER[\"central_meridian\",-91.3666666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.0000361538],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",256946.9138],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.0041],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"8113\"]]");
    p = add_epsg_def_ex (filter, first, last, 8114, "epsg", 8114,
        "NAD83(HARN) / WISCRS Trempealeau (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.1611111111111 +lon_0=-91.366666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000361538 +x_0=256946.913893828 +y_0=0.003962");
    add_proj4text (p, 2,
        "40792481585 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Trempealeau (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_");
    add_srs_wkt (p, 2,
        "Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Trans");
    add_srs_wkt (p, 7,
        "verse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.16");
    add_srs_wkt (p, 8,
        "11111111111],PARAMETER[\"central_meridian\",-91.36666666");
    add_srs_wkt (p, 9,
        "66667],PARAMETER[\"scale_factor\",1.0000361538],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",843000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.013],UNIT[\"US survey foot\",0.304800609601219,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"8114\"]]");
    p = add_epsg_def_ex (filter, first, last, 8115, "epsg", 8115,
        "NAD83(HARN) / WISCRS Taylor (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.1778220858333 +lat_0=45.177822085833");
    add_proj4text (p, 1,
        "3 +lon_0=-90.4833333333333 +k_0=1.0000597566 +x_0=187147");
    add_proj4text (p, 2,
        ".5744 +y_0=107746.7522 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Taylor (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.17782");
    add_srs_wkt (p, 8,
        "20858333],PARAMETER[\"central_meridian\",-90.48333333333");
    add_srs_wkt (p, 9,
        "33],PARAMETER[\"scale_factor\",1.0000597566],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",187147.5744],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",107746.7522],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"8115\"]]");
    p = add_epsg_def_ex (filter, first, last, 8116, "epsg", 8116,
        "NAD83(HARN) / WISCRS Taylor (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.1778220858333 +lat_0=45.177822085833");
    add_proj4text (p, 1,
        "3 +lon_0=-90.4833333333333 +k_0=1.0000597566 +x_0=187147");
    add_proj4text (p, 2,
        ".574295149 +y_0=107746.752146304 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Taylor (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.");
    add_srs_wkt (p, 8,
        "1778220858333],PARAMETER[\"central_meridian\",-90.483333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"scale_factor\",1.0000597566],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",614000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",353499.136],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8116\"]]");
    p = add_epsg_def_ex (filter, first, last, 8117, "epsg", 8117,
        "NAD83(HARN) / WISCRS St. Croix (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.0361111111111 +lon_0=-92.633333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000381803 +x_0=165506.7302 +y_0=0.0103 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS St. Croix (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",44.03611111");
    add_srs_wkt (p, 8,
        "11111],PARAMETER[\"central_meridian\",-92.6333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.0000381803],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",165506.7302],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0.0103],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"8117\"]]");
    p = add_epsg_def_ex (filter, first, last, 8118, "epsg", 8118,
        "NAD83(HARN) / WISCRS St. Croix (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.0361111111111 +lon_0=-92.633333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000381803 +x_0=165506.73009906 +y_0=0.0103632");
    add_proj4text (p, 2,
        "207264415 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS St. Croix (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.0361");
    add_srs_wkt (p, 8,
        "111111111],PARAMETER[\"central_meridian\",-92.6333333333");
    add_srs_wkt (p, 9,
        "333],PARAMETER[\"scale_factor\",1.0000381803],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",542999.997],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0.034],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"8118\"]]");
    p = add_epsg_def_ex (filter, first, last, 8119, "epsg", 8119,
        "NAD83(HARN) / WISCRS Shawano (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.0361111111111 +lon_0=-88.605555555");
    add_proj4text (p, 1,
        "5556 +k=1.000032144 +x_0=262433.3253 +y_0=0.0096 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Shawano (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",44.036111111");
    add_srs_wkt (p, 8,
        "1111],PARAMETER[\"central_meridian\",-88.6055555555556],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.000032144],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",262433.3253],PARAMETER[\"false_northing\",0.");
    add_srs_wkt (p, 11,
        "0096],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"8119\"]]");
    p = add_epsg_def_ex (filter, first, last, 8120, "epsg", 8120,
        "NAD83(HARN) / WISCRS Shawano (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.0361111111111 +lon_0=-88.605555555");
    add_proj4text (p, 1,
        "5556 +k=1.000032144 +x_0=262433.32517145 +y_0=0.00944881");
    add_proj4text (p, 2,
        "88976378 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Shawano (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",44.0361111");
    add_srs_wkt (p, 8,
        "111111],PARAMETER[\"central_meridian\",-88.6055555555556");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.000032144],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",861000.001],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        ".031],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"8120\"]]");
    p = add_epsg_def_ex (filter, first, last, 8121, "epsg", 8121,
        "NAD83(HARN) / WISCRS Sawyer (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.9000991313889 +lat_0=45.900099131388");
    add_proj4text (p, 1,
        "9 +lon_0=-91.1166666666667 +k_0=1.0000573461 +x_0=216713");
    add_proj4text (p, 2,
        ".2336 +y_0=120734.1631 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Sawyer (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.90009");
    add_srs_wkt (p, 8,
        "91313889],PARAMETER[\"central_meridian\",-91.11666666666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"scale_factor\",1.0000573461],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",216713.2336],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",120734.1631],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"8121\"]]");
    p = add_epsg_def_ex (filter, first, last, 8122, "epsg", 8122,
        "NAD83(HARN) / WISCRS Sawyer (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.9000991313889 +lat_0=45.900099131388");
    add_proj4text (p, 1,
        "9 +lon_0=-91.1166666666667 +k_0=1.0000573461 +x_0=216713");
    add_proj4text (p, 2,
        ".233731268 +y_0=120734.163169926 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Sawyer (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.");
    add_srs_wkt (p, 8,
        "9000991313889],PARAMETER[\"central_meridian\",-91.116666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"scale_factor\",1.0000573461],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",711000.001],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",396108.667],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 12,
        "1219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8122\"]]");
    p = add_epsg_def_ex (filter, first, last, 8123, "epsg", 8123,
        "NAD83(HARN) / WISCRS Sauk (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.8194444444444 +lon_0=-89.9 +k=1.00");
    add_proj4text (p, 1,
        "00373868 +x_0=185623.5716 +y_0=0.0051 +ellps=GRS80 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Sauk (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",42.8194444444444");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-89.9],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.0000373868],PARAMETER[\"false_easting\",185");
    add_srs_wkt (p, 10,
        "623.5716],PARAMETER[\"false_northing\",0.0051],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8123\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 8124, "epsg", 8124,
        "NAD83(HARN) / WISCRS Sauk (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.8194444444444 +lon_0=-89.9 +k=1.00");
    add_proj4text (p, 1,
        "00373868 +x_0=185623.571551943 +y_0=0.00518161036322073 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Sauk (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",42.819444444");
    add_srs_wkt (p, 8,
        "4444],PARAMETER[\"central_meridian\",-89.9],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.0000373868],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",609000.001],PARAMETER[\"false_northing\",0.017],UNIT[\"");
    add_srs_wkt (p, 11,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"8124\"]]");
    p = add_epsg_def_ex (filter, first, last, 8125, "epsg", 8125,
        "NAD83(HARN) / WISCRS Rusk (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.9194444444444 +lon_0=-91.066666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000495976 +x_0=250546.1013 +y_0=0.0234 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Rusk (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",43.9194444444444");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-91.0666666666667],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.0000495976],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",250546.1013],PARAMETER[\"false_northing\",0.023");
    add_srs_wkt (p, 11,
        "4],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"8125\"]]");
    p = add_epsg_def_ex (filter, first, last, 8126, "epsg", 8126,
        "NAD83(HARN) / WISCRS Rusk (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.9194444444444 +lon_0=-91.066666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000495976 +x_0=250546.101397003 +y_0=0.023469");
    add_proj4text (p, 2,
        "6469392939 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Rusk (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",43.919444444");
    add_srs_wkt (p, 8,
        "4444],PARAMETER[\"central_meridian\",-91.0666666666667],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000495976],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",822000.001],PARAMETER[\"false_northing\",0.");
    add_srs_wkt (p, 11,
        "077],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8126\"]]");
    p = add_epsg_def_ex (filter, first, last, 8127, "epsg", 8127,
        "NAD83(HARN) / WISCRS Rock (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.9444444444444 +lon_0=-89.072222222");
    add_proj4text (p, 1,
        "2222 +k=1.0000337311 +x_0=146304.2926 +y_0=0.0068 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Rock (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",41.9444444444444");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-89.0722222222222],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.0000337311],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",146304.2926],PARAMETER[\"false_northing\",0.006");
    add_srs_wkt (p, 11,
        "8],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"8127\"]]");
    p = add_epsg_def_ex (filter, first, last, 8128, "epsg", 8128,
        "NAD83(HARN) / WISCRS Rock (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.9444444444444 +lon_0=-89.072222222");
    add_proj4text (p, 1,
        "2222 +k=1.0000337311 +x_0=146304.292608585 +y_0=0.006705");
    add_proj4text (p, 2,
        "61341122682 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Rock (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",41.944444444");
    add_srs_wkt (p, 8,
        "4444],PARAMETER[\"central_meridian\",-89.0722222222222],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000337311],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",480000],PARAMETER[\"false_northing\",0.022]");
    add_srs_wkt (p, 11,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"8128\"]]");
    p = add_epsg_def_ex (filter, first, last, 8129, "epsg", 8129,
        "NAD83(HARN) / WISCRS Richland (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.3223129275 +lat_0=43.3223129275 +lon");
    add_proj4text (p, 1,
        "_0=-90.4305555555556 +k_0=1.0000375653 +x_0=202387.6048 ");
    add_proj4text (p, 2,
        "+y_0=134255.4253 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Richland (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.");
    add_srs_wkt (p, 8,
        "3223129275],PARAMETER[\"central_meridian\",-90.430555555");
    add_srs_wkt (p, 9,
        "5556],PARAMETER[\"scale_factor\",1.0000375653],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",202387.6048],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",134255.4253],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"8129\"]]");
    p = add_epsg_def_ex (filter, first, last, 8130, "epsg", 8130,
        "NAD83(HARN) / WISCRS Richland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.3223129275 +lat_0=43.3223129275 +lon");
    add_proj4text (p, 1,
        "_0=-90.4305555555556 +k_0=1.0000375653 +x_0=202387.60477");
    add_proj4text (p, 2,
        "521 +y_0=134255.425450851 +ellps=GRS80 +units=us-ft +no_");
    add_proj4text (p, 3,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Richland (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 8,
        ".3223129275],PARAMETER[\"central_meridian\",-90.43055555");
    add_srs_wkt (p, 9,
        "55556],PARAMETER[\"scale_factor\",1.0000375653],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",664000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",440469.675],UNIT[\"US survey foot\",0.304800609601219,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8130\"]]");
    p = add_epsg_def_ex (filter, first, last, 8131, "epsg", 8131,
        "NAD83(HARN) / WISCRS Price (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5555555555556 +lon_0=-90.488888888");
    add_proj4text (p, 1,
        "8889 +k=1.0000649554 +x_0=227990.8546 +y_0=0.0109 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Price (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",44.5555555555556");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-90.4888888888889],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.0000649554],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",227990.8546],PARAMETER[\"false_northing\",0.010");
    add_srs_wkt (p, 11,
        "9],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"8131\"]]");
    p = add_epsg_def_ex (filter, first, last, 8132, "epsg", 8132,
        "NAD83(HARN) / WISCRS Price (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5555555555556 +lon_0=-90.488888888");
    add_proj4text (p, 1,
        "8889 +k=1.0000649554 +x_0=227990.854457709 +y_0=0.010972");
    add_proj4text (p, 2,
        "8219456439 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Price (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",44.55555555");
    add_srs_wkt (p, 8,
        "55556],PARAMETER[\"central_meridian\",-90.4888888888889]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.0000649554],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",747999.995],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        ".036],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"8132\"]]");
    p = add_epsg_def_ex (filter, first, last, 8133, "epsg", 8133,
        "NAD83(HARN) / WISCRS Portage (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4168239752778 +lat_0=44.416823975277");
    add_proj4text (p, 1,
        "8 +lon_0=-89.5 +k_0=1.000039936 +x_0=56388.1128 +y_0=500");
    add_proj4text (p, 2,
        "22.1874 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Portage (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44.4");
    add_srs_wkt (p, 8,
        "168239752778],PARAMETER[\"central_meridian\",-89.5],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.000039936],PARAMETER[\"false_ea");
    add_srs_wkt (p, 10,
        "sting\",56388.1128],PARAMETER[\"false_northing\",50022.1");
    add_srs_wkt (p, 11,
        "874],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 12,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"8133\"]]");
    p = add_epsg_def_ex (filter, first, last, 8134, "epsg", 8134,
        "NAD83(HARN) / WISCRS Portage (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.4168239752778 +lat_0=44.416823975277");
    add_proj4text (p, 1,
        "8 +lon_0=-89.5 +k_0=1.000039936 +x_0=56388.1127762256 +y");
    add_proj4text (p, 2,
        "_0=50022.1874523749 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Portage (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 8,
        ".4168239752778],PARAMETER[\"central_meridian\",-89.5],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.000039936],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",185000],PARAMETER[\"false_northing\",164114.46");
    add_srs_wkt (p, 11,
        "],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8134\"]]");
    p = add_epsg_def_ex (filter, first, last, 8135, "epsg", 8135,
        "NAD83(HARN) / WISCRS Polk (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.6611111111111 +lon_0=-92.633333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000433849 +x_0=141732.2823 +y_0=0.0059 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Polk (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",44.6611111111111");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-92.6333333333333],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.0000433849],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",141732.2823],PARAMETER[\"false_northing\",0.005");
    add_srs_wkt (p, 11,
        "9],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"8135\"]]");
    p = add_epsg_def_ex (filter, first, last, 8136, "epsg", 8136,
        "NAD83(HARN) / WISCRS Polk (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.6611111111111 +lon_0=-92.633333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000433849 +x_0=141732.282245365 +y_0=0.005791");
    add_proj4text (p, 2,
        "21158242317 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Polk (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",44.661111111");
    add_srs_wkt (p, 8,
        "1111],PARAMETER[\"central_meridian\",-92.6333333333333],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000433849],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",464999.996],PARAMETER[\"false_northing\",0.");
    add_srs_wkt (p, 11,
        "019],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8136\"]]");
    p = add_epsg_def_ex (filter, first, last, 8137, "epsg", 8137,
        "NAD83(HARN) / WISCRS Pepin and Pierce (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.6361488719444 +lat_0=44.636148871944");
    add_proj4text (p, 1,
        "4 +lon_0=-92.2277777777778 +k_0=1.0000362977 +x_0=167640");
    add_proj4text (p, 2,
        ".3354 +y_0=86033.0876 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Pepin and Pierce (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Referenc");
    add_srs_wkt (p, 2,
        "e_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 8,
        "n\",44.6361488719444],PARAMETER[\"central_meridian\",-92");
    add_srs_wkt (p, 9,
        ".2277777777778],PARAMETER[\"scale_factor\",1.0000362977]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",167640.3354],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",86033.0876],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8137\"]]");
    p = add_epsg_def_ex (filter, first, last, 8138, "epsg", 8138,
        "NAD83(HARN) / WISCRS Pepin and Pierce (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.6361488719444 +lat_0=44.636148871944");
    add_proj4text (p, 1,
        "4 +lon_0=-92.2277777777778 +k_0=1.0000362977 +x_0=167640");
    add_proj4text (p, 2,
        ".335280671 +y_0=86033.0877317755 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Pepin and Pierce (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 2,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"61");
    add_srs_wkt (p, 4,
        "52\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",44.6361488719444],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-92.2277777777778],PARAMETER[\"scale_factor\",1.00003629");
    add_srs_wkt (p, 10,
        "77],PARAMETER[\"false_easting\",550000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",282260.222],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "0609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"813");
    add_srs_wkt (p, 14,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 8139, "epsg", 8139,
        "NAD83(HARN) / WISCRS Oneida (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.7042237702778 +lat_0=45.704223770277");
    add_proj4text (p, 1,
        "8 +lon_0=-89.5444444444444 +k_0=1.0000686968 +x_0=70104.");
    add_proj4text (p, 2,
        "1401 +y_0=57588.0346 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Oneida (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.70422");
    add_srs_wkt (p, 8,
        "37702778],PARAMETER[\"central_meridian\",-89.54444444444");
    add_srs_wkt (p, 9,
        "44],PARAMETER[\"scale_factor\",1.0000686968],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",70104.1401],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",57588.0346],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"8139\"]]");
    p = add_epsg_def_ex (filter, first, last, 8140, "epsg", 8140,
        "NAD83(HARN) / WISCRS Oneida (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.7042237702778 +lat_0=45.704223770277");
    add_proj4text (p, 1,
        "8 +lon_0=-89.5444444444444 +k_0=1.0000686968 +x_0=70104.");
    add_proj4text (p, 2,
        "1402082804 +y_0=57588.0347472695 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Oneida (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.");
    add_srs_wkt (p, 8,
        "7042237702778],PARAMETER[\"central_meridian\",-89.544444");
    add_srs_wkt (p, 9,
        "4444444],PARAMETER[\"scale_factor\",1.0000686968],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",230000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",188936.744],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8140\"]]");
    p = add_epsg_def_ex (filter, first, last, 8141, "epsg", 8141,
        "NAD83(HARN) / WISCRS Oconto (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.3972222222222 +lon_0=-87.908333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000236869 +x_0=182880.3676 +y_0=0.0033 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Oconto (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",44.3972222222222");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-87.9083333333333],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.0000236869],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",182880.3676],PARAMETER[\"false_northing\",0.003");
    add_srs_wkt (p, 11,
        "3],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"8141\"]]");
    p = add_epsg_def_ex (filter, first, last, 8142, "epsg", 8142,
        "NAD83(HARN) / WISCRS Oconto (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.3972222222222 +lon_0=-87.908333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000236869 +x_0=182880.367589535 +y_0=0.003352");
    add_proj4text (p, 2,
        "80670561341 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Oconto (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",44.39722222");
    add_srs_wkt (p, 8,
        "22222],PARAMETER[\"central_meridian\",-87.9083333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.0000236869],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",600000.006],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        ".011],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"8142\"]]");
    p = add_epsg_def_ex (filter, first, last, 8143, "epsg", 8143,
        "NAD83(HARN) / WISCRS Monroe (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.0000739286111 +lat_0=44.000073928611");
    add_proj4text (p, 1,
        "1 +lon_0=-90.6416666666667 +k_0=1.0000434122 +x_0=204521");
    add_proj4text (p, 2,
        ".209 +y_0=121923.9861 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Monroe (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44.00007");
    add_srs_wkt (p, 8,
        "39286111],PARAMETER[\"central_meridian\",-90.64166666666");
    add_srs_wkt (p, 9,
        "67],PARAMETER[\"scale_factor\",1.0000434122],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",204521.209],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",121923.9861],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"8143\"]]");
    p = add_epsg_def_ex (filter, first, last, 8144, "epsg", 8144,
        "NAD83(HARN) / WISCRS Monroe (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.0000739286111 +lat_0=44.000073928611");
    add_proj4text (p, 1,
        "1 +lon_0=-90.6416666666667 +k_0=1.0000434122 +x_0=204521");
    add_proj4text (p, 2,
        ".209042418 +y_0=121923.986182372 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Monroe (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44.");
    add_srs_wkt (p, 8,
        "0000739286111],PARAMETER[\"central_meridian\",-90.641666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"scale_factor\",1.0000434122],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",671000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",400012.278],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8144\"]]");
    p = add_epsg_def_ex (filter, first, last, 8145, "epsg", 8145,
        "NAD83(HARN) / WISCRS Menominee (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.7166666666667 +lon_0=-88.416666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000362499 +x_0=105461.0121 +y_0=0.0029 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Menominee (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",44.71666666");
    add_srs_wkt (p, 8,
        "66667],PARAMETER[\"central_meridian\",-88.4166666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.0000362499],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",105461.0121],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0.0029],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"8145\"]]");
    p = add_epsg_def_ex (filter, first, last, 8146, "epsg", 8146,
        "NAD83(HARN) / WISCRS Menominee (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.7166666666667 +lon_0=-88.416666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000362499 +x_0=105461.012141224 +y_0=0.003048");
    add_proj4text (p, 2,
        "00609601219 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Menominee (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.7166");
    add_srs_wkt (p, 8,
        "666666667],PARAMETER[\"central_meridian\",-88.4166666666");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"scale_factor\",1.0000362499],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",346000.004],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0.01],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 13,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"8146\"]]");
    p = add_epsg_def_ex (filter, first, last, 8147, "epsg", 8147,
        "NAD83(HARN) / WISCRS Marinette (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.6916666666667 +lon_0=-87.711111111");
    add_proj4text (p, 1,
        "1111 +k=1.0000234982 +x_0=238658.8794 +y_0=0.0032 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Marinette (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",44.69166666");
    add_srs_wkt (p, 8,
        "66667],PARAMETER[\"central_meridian\",-87.7111111111111]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.0000234982],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",238658.8794],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0.0032],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"8147\"]]");
    p = add_epsg_def_ex (filter, first, last, 8148, "epsg", 8148,
        "NAD83(HARN) / WISCRS Marinette (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.6916666666667 +lon_0=-87.711111111");
    add_proj4text (p, 1,
        "1111 +k=1.0000234982 +x_0=238658.879451359 +y_0=0.003048");
    add_proj4text (p, 2,
        "00609601219 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Marinette (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.6916");
    add_srs_wkt (p, 8,
        "666666667],PARAMETER[\"central_meridian\",-87.7111111111");
    add_srs_wkt (p, 9,
        "111],PARAMETER[\"scale_factor\",1.0000234982],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",783000.007],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0.01],UNIT[\"US survey foot\",0.304800609601219,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"N");
    add_srs_wkt (p, 13,
        "orthing\",NORTH],AUTHORITY[\"EPSG\",\"8148\"]]");
    p = add_epsg_def_ex (filter, first, last, 8149, "epsg", 8149,
        "NAD83(HARN) / WISCRS Marathon (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.9009044236111 +lat_0=44.900904423611");
    add_proj4text (p, 1,
        "1 +lon_0=-89.77 +k_0=1.000053289 +x_0=74676.1493 +y_0=55");
    add_proj4text (p, 2,
        "049.2669 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Marathon (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44.");
    add_srs_wkt (p, 8,
        "9009044236111],PARAMETER[\"central_meridian\",-89.77],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"scale_factor\",1.000053289],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",74676.1493],PARAMETER[\"false_northing\",55049");
    add_srs_wkt (p, 11,
        ".2669],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"8149\"]]");
    p = add_epsg_def_ex (filter, first, last, 8150, "epsg", 8150,
        "NAD83(HARN) / WISCRS Marathon (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.9009044236111 +lat_0=44.900904423611");
    add_proj4text (p, 1,
        "1 +lon_0=-89.77 +k_0=1.000053289 +x_0=74676.1493522987 +");
    add_proj4text (p, 2,
        "y_0=55049.2669545339 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Marathon (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 8,
        ".9009044236111],PARAMETER[\"central_meridian\",-89.77],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"scale_factor\",1.000053289],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_easting\",245000],PARAMETER[\"false_northing\",180607.4");
    add_srs_wkt (p, 11,
        "7],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8150\"]]");
    p = add_epsg_def_ex (filter, first, last, 8151, "epsg", 8151,
        "NAD83(HARN) / WISCRS Lincoln (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.8444444444444 +lon_0=-89.733333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000599003 +x_0=116129.0323 +y_0=0.0058 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Lincoln (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",44.844444444");
    add_srs_wkt (p, 8,
        "4444],PARAMETER[\"central_meridian\",-89.7333333333333],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000599003],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",116129.0323],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        ".0058],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"8151\"]]");
    p = add_epsg_def_ex (filter, first, last, 8152, "epsg", 8152,
        "NAD83(HARN) / WISCRS Lincoln (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.8444444444444 +lon_0=-89.733333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000599003 +x_0=116129.032258065 +y_0=0.005791");
    add_proj4text (p, 2,
        "21158242317 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Lincoln (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",44.8444444");
    add_srs_wkt (p, 8,
        "444444],PARAMETER[\"central_meridian\",-89.7333333333333");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.0000599003],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",381000],PARAMETER[\"false_northing\",0.01");
    add_srs_wkt (p, 11,
        "9],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8152\"]]");
    p = add_epsg_def_ex (filter, first, last, 8153, "epsg", 8153,
        "NAD83(HARN) / WISCRS Langlade (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.1542371052778 +lat_0=45.154237105277");
    add_proj4text (p, 1,
        "8 +lon_0=-89.0333333333333 +k_0=1.0000627024 +x_0=198425");
    add_proj4text (p, 2,
        ".197 +y_0=105279.7829 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Langlade (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.");
    add_srs_wkt (p, 8,
        "1542371052778],PARAMETER[\"central_meridian\",-89.033333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"scale_factor\",1.0000627024],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",198425.197],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",105279.7829],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"8153\"]]");
    p = add_epsg_def_ex (filter, first, last, 8154, "epsg", 8154,
        "NAD83(HARN) / WISCRS Langlade (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.1542371052778 +lat_0=45.154237105277");
    add_proj4text (p, 1,
        "8 +lon_0=-89.0333333333333 +k_0=1.0000627024 +x_0=198425");
    add_proj4text (p, 2,
        ".196850394 +y_0=105279.782880366 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Langlade (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45");
    add_srs_wkt (p, 8,
        ".1542371052778],PARAMETER[\"central_meridian\",-89.03333");
    add_srs_wkt (p, 9,
        "33333333],PARAMETER[\"scale_factor\",1.0000627024],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",651000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",345405.421],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8154\"]]");
    p = add_epsg_def_ex (filter, first, last, 8155, "epsg", 8155,
        "NAD83(HARN) / WISCRS La Crosse (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.4511111111111 +lon_0=-91.316666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000319985 +x_0=130454.6598 +y_0=0.0033 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS La Crosse (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",43.45111111");
    add_srs_wkt (p, 8,
        "11111],PARAMETER[\"central_meridian\",-91.3166666666667]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.0000319985],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",130454.6598],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0.0033],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"8155\"]]");
    p = add_epsg_def_ex (filter, first, last, 8156, "epsg", 8156,
        "NAD83(HARN) / WISCRS La Crosse (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.4511111111111 +lon_0=-91.316666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000319985 +x_0=130454.659690119 +y_0=0.003352");
    add_proj4text (p, 2,
        "80670561341 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS La Crosse (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Ne");
    add_srs_wkt (p, 2,
        "twork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 7,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.4511");
    add_srs_wkt (p, 8,
        "111111111],PARAMETER[\"central_meridian\",-91.3166666666");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"scale_factor\",1.0000319985],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",427999.996],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0.011],UNIT[\"US survey foot\",0.304800609601219,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"8156\"]]");
    p = add_epsg_def_ex (filter, first, last, 8157, "epsg", 8157,
        "NAD83(HARN) / WISCRS Kewaunee, Manitowoc and Sheboygan (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.2666666666667 +lon_0=-87.55 +k=1.0");
    add_proj4text (p, 1,
        "000233704 +x_0=79857.7614 +y_0=0.0012 +ellps=GRS80 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Kewaunee, Manitowoc and Sh");
    add_srs_wkt (p, 1,
        "eboygan (m)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_");
    add_srs_wkt (p, 2,
        "Accuracy_Reference_Network\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",43.2666666666667],PARAMETER[\"central_meri");
    add_srs_wkt (p, 9,
        "dian\",-87.55],PARAMETER[\"scale_factor\",1.0000233704],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",79857.7614],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0.0012],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"8157\"]]");
    p = add_epsg_def_ex (filter, first, last, 8158, "epsg", 8158,
        "NAD83(HARN) / WISCRS Kewaunee, Manitowoc and Sheboygan (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.2666666666667 +lon_0=-87.55 +k=1.0");
    add_proj4text (p, 1,
        "000233704 +x_0=79857.7615443231 +y_0=0.00121920243840488");
    add_proj4text (p, 2,
        " +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Kewaunee, Manitowoc and Sh");
    add_srs_wkt (p, 1,
        "eboygan (ftUS)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_Hi");
    add_srs_wkt (p, 2,
        "gh_Accuracy_Reference_Network\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 3,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",43.2666666666667],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-87.55],PARAMETER[\"scale_factor\",1.0000233704");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_easting\",262000.006],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0.004],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 12,
        "9601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8158\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 8159, "epsg", 8159,
        "NAD83(HARN) / WISCRS Kenosha, Milwaukee, Ozaukee and Racine (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.2166666666667 +lon_0=-87.894444444");
    add_proj4text (p, 1,
        "4444 +k=1.0000260649 +x_0=185928.3728 +y_0=0.0009 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Kenosha, Milwaukee, Ozauke");
    add_srs_wkt (p, 1,
        "e and Racine (m)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_");
    add_srs_wkt (p, 2,
        "High_Accuracy_Reference_Network\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 3,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"415");
    add_srs_wkt (p, 7,
        "2\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 8,
        "titude_of_origin\",42.2166666666667],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-87.8944444444444],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.0000260649],PARAMETER[\"false_easting\",185928.3728],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",0.0009],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8159\"]]");
    p = add_epsg_def_ex (filter, first, last, 8160, "epsg", 8160,
        "NAD83(HARN) / WISCRS Kenosha, Milwaukee, Ozaukee and Racine (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.2166666666667 +lon_0=-87.894444444");
    add_proj4text (p, 1,
        "4444 +k=1.0000260649 +x_0=185928.372771146 +y_0=0.000914");
    add_proj4text (p, 2,
        "401828803658 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Kenosha, Milwaukee, Ozauke");
    add_srs_wkt (p, 1,
        "e and Racine (ftUS)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD");
    add_srs_wkt (p, 2,
        "83_High_Accuracy_Reference_Network\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4152\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",42.2166666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-87.8944444444444],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.0000260649],PARAMETER[\"false_easting\",610000.003");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",0.003],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"8160\"]]");
    p = add_epsg_def_ex (filter, first, last, 8161, "epsg", 8161,
        "NAD83(HARN) / WISCRS Jackson (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.2533351277778 +lon_0=-90.844296519");
    add_proj4text (p, 1,
        "4444 +k=1.0000353 +x_0=27000 +y_0=25000 +ellps=GRS80 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Jackson (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",44.253335127");
    add_srs_wkt (p, 8,
        "7778],PARAMETER[\"central_meridian\",-90.8442965194444],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000353],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",27000],PARAMETER[\"false_northing\",25000],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 12,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "8161\"]]");
    p = add_epsg_def_ex (filter, first, last, 8162, "epsg", 8162,
        "NAD83(HARN) / WISCRS Jackson (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.2533351277778 +lon_0=-90.844296519");
    add_proj4text (p, 1,
        "4444 +k=1.0000353 +x_0=27000 +y_0=24999.9998983998 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Jackson (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",44.2533351");
    add_srs_wkt (p, 8,
        "277778],PARAMETER[\"central_meridian\",-90.8442965194444");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.0000353],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_easting\",88582.5],PARAMETER[\"false_northing\",82020.");
    add_srs_wkt (p, 11,
        "833],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"North");
    add_srs_wkt (p, 13,
        "ing\",NORTH],AUTHORITY[\"EPSG\",\"8162\"]]");
    p = add_epsg_def_ex (filter, first, last, 8163, "epsg", 8163,
        "NAD83(HARN) / WISCRS Iron (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.4333333333333 +lon_0=-90.255555555");
    add_proj4text (p, 1,
        "5556 +k=1.0000677153 +x_0=220980.4419 +y_0=0.0085 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Iron (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",45.4333333333333");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-90.2555555555556],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.0000677153],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",220980.4419],PARAMETER[\"false_northing\",0.008");
    add_srs_wkt (p, 11,
        "5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"8163\"]]");
    p = add_epsg_def_ex (filter, first, last, 8164, "epsg", 8164,
        "NAD83(HARN) / WISCRS Iron (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.4333333333333 +lon_0=-90.255555555");
    add_proj4text (p, 1,
        "5556 +k=1.0000677153 +x_0=220980.441960884 +y_0=0.008534");
    add_proj4text (p, 2,
        "41706883414 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Iron (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",45.433333333");
    add_srs_wkt (p, 8,
        "3333],PARAMETER[\"central_meridian\",-90.2555555555556],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000677153],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",725000],PARAMETER[\"false_northing\",0.028]");
    add_srs_wkt (p, 11,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"8164\"]]");
    p = add_epsg_def_ex (filter, first, last, 8165, "epsg", 8165,
        "NAD83(HARN) / WISCRS Iowa (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5388888888889 +lon_0=-90.161111111");
    add_proj4text (p, 1,
        "1111 +k=1.0000394961 +x_0=113081.0261 +y_0=0.0045 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Iowa (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",42.5388888888889");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-90.1611111111111],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.0000394961],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",113081.0261],PARAMETER[\"false_northing\",0.004");
    add_srs_wkt (p, 11,
        "5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"8165\"]]");
    p = add_epsg_def_ex (filter, first, last, 8166, "epsg", 8166,
        "NAD83(HARN) / WISCRS Iowa (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5388888888889 +lon_0=-90.161111111");
    add_proj4text (p, 1,
        "1111 +k=1.0000394961 +x_0=113081.026162052 +y_0=0.004572");
    add_proj4text (p, 2,
        "00914401829 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Iowa (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",42.538888888");
    add_srs_wkt (p, 8,
        "8889],PARAMETER[\"central_meridian\",-90.1611111111111],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000394961],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",371000],PARAMETER[\"false_northing\",0.015]");
    add_srs_wkt (p, 11,
        ",UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"8166\"]]");
    p = add_epsg_def_ex (filter, first, last, 8167, "epsg", 8167,
        "NAD83(HARN) / WISCRS Green Lake and Marquette (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.8070001177778 +lat_0=43.807000117777");
    add_proj4text (p, 1,
        "8 +lon_0=-89.2416666666667 +k_0=1.0000344057 +x_0=150876");
    add_proj4text (p, 2,
        ".3018 +y_0=79170.7795 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Green Lake and Marquette (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_");
    add_srs_wkt (p, 2,
        "Reference_Network\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTI");
    add_srs_wkt (p, 7,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 8,
        "_of_origin\",43.8070001177778],PARAMETER[\"central_merid");
    add_srs_wkt (p, 9,
        "ian\",-89.2416666666667],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "00344057],PARAMETER[\"false_easting\",150876.3018],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",79170.7795],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"8167\"]]");
    p = add_epsg_def_ex (filter, first, last, 8168, "epsg", 8168,
        "NAD83(HARN) / WISCRS Green Lake and Marquette (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.8070001177778 +lat_0=43.807000117777");
    add_proj4text (p, 1,
        "8 +lon_0=-89.2416666666667 +k_0=1.0000344057 +x_0=150876");
    add_proj4text (p, 2,
        ".301752604 +y_0=79170.7793751588 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Green Lake and Marquette (");
    add_srs_wkt (p, 1,
        "ftUS)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accura");
    add_srs_wkt (p, 2,
        "cy_Reference_Network\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 7,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 8,
        "ude_of_origin\",43.8070001177778],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-89.2416666666667],PARAMETER[\"scale_factor\",1");
    add_srs_wkt (p, 10,
        ".0000344057],PARAMETER[\"false_easting\",495000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",259746.132],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"8168\"]]");
    p = add_epsg_def_ex (filter, first, last, 8169, "epsg", 8169,
        "NAD83(HARN) / WISCRS Green and Lafayette (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.6375622769444 +lat_0=42.637562276944");
    add_proj4text (p, 1,
        "4 +lon_0=-89.8388888888889 +k_0=1.0000390487 +x_0=170078");
    add_proj4text (p, 2,
        ".7403 +y_0=45830.2947 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Green and Lafayette (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 2,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"61");
    add_srs_wkt (p, 4,
        "52\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"L");
    add_srs_wkt (p, 7,
        "ambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 8,
        "igin\",42.6375622769444],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 9,
        "-89.8388888888889],PARAMETER[\"scale_factor\",1.00003904");
    add_srs_wkt (p, 10,
        "87],PARAMETER[\"false_easting\",170078.7403],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",45830.2947],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"8169\"]]");
    p = add_epsg_def_ex (filter, first, last, 8170, "epsg", 8170,
        "NAD83(HARN) / WISCRS Green and Lafayette (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.6375622769444 +lat_0=42.637562276944");
    add_proj4text (p, 1,
        "4 +lon_0=-89.8388888888889 +k_0=1.0000390487 +x_0=170078");
    add_proj4text (p, 2,
        ".74015748 +y_0=45830.2948437897 +ellps=GRS80 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Green and Lafayette (ftUS)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Re");
    add_srs_wkt (p, 2,
        "ference_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",42.6375622769444],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 9,
        "\",-89.8388888888889],PARAMETER[\"scale_factor\",1.00003");
    add_srs_wkt (p, 10,
        "90487],PARAMETER[\"false_easting\",558000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",150361.559],UNIT[\"US survey foot\",0.30");
    add_srs_wkt (p, 12,
        "4800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easti");
    add_srs_wkt (p, 13,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "8170\"]]");
    p = add_epsg_def_ex (filter, first, last, 8171, "epsg", 8171,
        "NAD83(HARN) / WISCRS Grant (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.4111111111111 +lon_0=-90.8 +k=1.00");
    add_proj4text (p, 1,
        "00349452 +x_0=242316.4841 +y_0=0.01 +ellps=GRS80 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Grant (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",41.4111111111111");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-90.8],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.0000349452],PARAMETER[\"false_easting\",242");
    add_srs_wkt (p, 10,
        "316.4841],PARAMETER[\"false_northing\",0.01],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 12,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8171\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 8172, "epsg", 8172,
        "NAD83(HARN) / WISCRS Grant (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.4111111111111 +lon_0=-90.8 +k=1.00");
    add_proj4text (p, 1,
        "00349452 +x_0=242316.484023368 +y_0=0.0100584201168402 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Grant (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",41.41111111");
    add_srs_wkt (p, 8,
        "11111],PARAMETER[\"central_meridian\",-90.8],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.0000349452],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",794999.998],PARAMETER[\"false_northing\",0.033],UNIT[\"");
    add_srs_wkt (p, 11,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"8172\"]]");
    p = add_epsg_def_ex (filter, first, last, 8173, "epsg", 8173,
        "NAD83(HARN) / WISCRS Forest (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.0055555555556 +lon_0=-88.633333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000673004 +x_0=275844.5533 +y_0=0.0157 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Forest (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",44.0055555555556");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-88.6333333333333],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.0000673004],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",275844.5533],PARAMETER[\"false_northing\",0.015");
    add_srs_wkt (p, 11,
        "7],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"8173\"]]");
    p = add_epsg_def_ex (filter, first, last, 8177, "epsg", 8177,
        "NAD83(HARN) / WISCRS Forest (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.0055555555556 +lon_0=-88.633333333");
    add_proj4text (p, 1,
        "3333 +k=1.0000673004 +x_0=275844.553213106 +y_0=0.015849");
    add_proj4text (p, 2,
        "6316992634 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Forest (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",44.00555555");
    add_srs_wkt (p, 8,
        "55556],PARAMETER[\"central_meridian\",-88.6333333333333]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.0000673004],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",905000.005],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        ".052],UNIT[\"US survey foot\",0.304800609601219,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"8177\"]]");
    p = add_epsg_def_ex (filter, first, last, 8179, "epsg", 8179,
        "NAD83(HARN) / WISCRS Dunn (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.4083333333333 +lon_0=-91.894444444");
    add_proj4text (p, 1,
        "4444 +k=1.0000410324 +x_0=51816.104 +y_0=0.003 +ellps=GR");
    add_proj4text (p, 2,
        "S80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Dunn (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",44.4083333333333");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-91.8944444444444],PARA");
    add_srs_wkt (p, 9,
        "METER[\"scale_factor\",1.0000410324],PARAMETER[\"false_e");
    add_srs_wkt (p, 10,
        "asting\",51816.104],PARAMETER[\"false_northing\",0.003],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Ea");
    add_srs_wkt (p, 12,
        "sting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"8179\"]]");
    p = add_epsg_def_ex (filter, first, last, 8180, "epsg", 8180,
        "NAD83(HARN) / WISCRS Dunn (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.4083333333333 +lon_0=-91.894444444");
    add_proj4text (p, 1,
        "4444 +k=1.0000410324 +x_0=51816.1039370079 +y_0=0.003048");
    add_proj4text (p, 2,
        "00609601219 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Dunn (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",44.408333333");
    add_srs_wkt (p, 8,
        "3333],PARAMETER[\"central_meridian\",-91.8944444444444],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000410324],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",170000.001],PARAMETER[\"false_northing\",0.");
    add_srs_wkt (p, 11,
        "01],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"8180\"]]");
    p = add_epsg_def_ex (filter, first, last, 8181, "epsg", 8181,
        "NAD83(HARN) / WISCRS Douglas (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.8833333333333 +lon_0=-91.916666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000385418 +x_0=59131.3183 +y_0=0.0041 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Douglas (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",45.883333333");
    add_srs_wkt (p, 8,
        "3333],PARAMETER[\"central_meridian\",-91.9166666666667],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000385418],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",59131.3183],PARAMETER[\"false_northing\",0.");
    add_srs_wkt (p, 11,
        "0041],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"8181\"]]");
    p = add_epsg_def_ex (filter, first, last, 8182, "epsg", 8182,
        "NAD83(HARN) / WISCRS Douglas (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.8833333333333 +lon_0=-91.916666666");
    add_proj4text (p, 1,
        "6667 +k=1.0000385418 +x_0=59131.3182626365 +y_0=0.003962");
    add_proj4text (p, 2,
        "40792481585 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Douglas (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",45.8833333");
    add_srs_wkt (p, 8,
        "333333],PARAMETER[\"central_meridian\",-91.9166666666667");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.0000385418],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",194000],PARAMETER[\"false_northing\",0.01");
    add_srs_wkt (p, 11,
        "3],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8182\"]]");
    p = add_epsg_def_ex (filter, first, last, 8184, "epsg", 8184,
        "NAD83(HARN) / WISCRS Door (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.4 +lon_0=-87.2722222222222 +k=1.00");
    add_proj4text (p, 1,
        "00187521 +x_0=158801.1176 +y_0=0.0023 +ellps=GRS80 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Door (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",44.4],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-87.2722222222222],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.0000187521],PARAMETER[\"false_easting\",158");
    add_srs_wkt (p, 10,
        "801.1176],PARAMETER[\"false_northing\",0.0023],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8184\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 8185, "epsg", 8185,
        "NAD83(HARN) / WISCRS Door (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.4 +lon_0=-87.2722222222222 +k=1.00");
    add_proj4text (p, 1,
        "00187521 +x_0=158801.117602235 +y_0=0.00243840487680975 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Door (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",44.4],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"central_meridian\",-87.2722222222222],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.0000187521],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",521000],PARAMETER[\"false_northing\",0.008],UNIT[\"US s");
    add_srs_wkt (p, 11,
        "urvey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"8185\"]]");
    p = add_epsg_def_ex (filter, first, last, 8187, "epsg", 8187,
        "NAD83(HARN) / WISCRS Dodge and Jefferson (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.4722222222222 +lon_0=-88.775 +k=1.");
    add_proj4text (p, 1,
        "0000346418 +x_0=263347.7263 +y_0=0.0076 +ellps=GRS80 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Dodge and Jefferson (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 2,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"61");
    add_srs_wkt (p, 4,
        "52\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "1.4722222222222],PARAMETER[\"central_meridian\",-88.775]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.0000346418],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",263347.7263],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0.0076],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"8187\"]]");
    p = add_epsg_def_ex (filter, first, last, 8189, "epsg", 8189,
        "NAD83(HARN) / WISCRS Dodge and Jefferson (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.4722222222222 +lon_0=-88.775 +k=1.");
    add_proj4text (p, 1,
        "0000346418 +x_0=263347.726390653 +y_0=0.0076200152400304");
    add_proj4text (p, 2,
        "8 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Dodge and Jefferson (ftUS)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Re");
    add_srs_wkt (p, 2,
        "ference_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",41.4722222222222],PARAMETER[\"central_meridian\",-88.77");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",1.0000346418],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_easting\",863999.999],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0.025],UNIT[\"US survey foot\",0.304800609601219,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"8189\"]]");
    p = add_epsg_def_ex (filter, first, last, 8191, "epsg", 8191,
        "NAD83(HARN) / WISCRS Dane (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.0695160375 +lat_0=43.0695160375 +lon");
    add_proj4text (p, 1,
        "_0=-89.4222222222222 +k_0=1.0000384786 +x_0=247193.2944 ");
    add_proj4text (p, 2,
        "+y_0=146591.9896 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Dane (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 7,
        "l_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.06951");
    add_srs_wkt (p, 8,
        "60375],PARAMETER[\"central_meridian\",-89.4222222222222]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"scale_factor\",1.0000384786],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_easting\",247193.2944],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "146591.9896],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"8191\"]]");
    p = add_epsg_def_ex (filter, first, last, 8193, "epsg", 8193,
        "NAD83(HARN) / WISCRS Dane (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.0695160375 +lat_0=43.0695160375 +lon");
    add_proj4text (p, 1,
        "_0=-89.4222222222222 +k_0=1.0000384786 +x_0=247193.29438");
    add_proj4text (p, 2,
        "6589 +y_0=146591.989636779 +ellps=GRS80 +units=us-ft +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Dane (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.0");
    add_srs_wkt (p, 8,
        "695160375],PARAMETER[\"central_meridian\",-89.4222222222");
    add_srs_wkt (p, 9,
        "222],PARAMETER[\"scale_factor\",1.0000384786],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",811000],PARAMETER[\"false_northing\",4");
    add_srs_wkt (p, 11,
        "80943.886],UNIT[\"US survey foot\",0.304800609601219,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"8193\"]]");
    p = add_epsg_def_ex (filter, first, last, 8196, "epsg", 8196,
        "NAD83(HARN) / WISCRS Crawford (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.200055605 +lat_0=43.200055605 +lon_0");
    add_proj4text (p, 1,
        "=-90.9388888888889 +k_0=1.0000349151 +x_0=113690.6274 +y");
    add_proj4text (p, 2,
        "_0=53703.1201 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Crawford (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.");
    add_srs_wkt (p, 8,
        "200055605],PARAMETER[\"central_meridian\",-90.9388888888");
    add_srs_wkt (p, 9,
        "889],PARAMETER[\"scale_factor\",1.0000349151],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"false_easting\",113690.6274],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",53703.1201],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"8196\"]]");
    p = add_epsg_def_ex (filter, first, last, 8197, "epsg", 8197,
        "NAD83(HARN) / WISCRS Crawford (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.200055605 +lat_0=43.200055605 +lon_0");
    add_proj4text (p, 1,
        "=-90.9388888888889 +k_0=1.0000349151 +x_0=113690.6273812");
    add_proj4text (p, 2,
        "55 +y_0=53703.1202438405 +ellps=GRS80 +units=us-ft +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Crawford (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 8,
        ".200055605],PARAMETER[\"central_meridian\",-90.938888888");
    add_srs_wkt (p, 9,
        "8889],PARAMETER[\"scale_factor\",1.0000349151],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",373000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "176190.987],UNIT[\"US survey foot\",0.304800609601219,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8197\"]]");
    p = add_epsg_def_ex (filter, first, last, 8198, "epsg", 8198,
        "NAD83(HARN) / WISCRS Columbia (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.4625466458333 +lat_0=43.462546645833");
    add_proj4text (p, 1,
        "3 +lon_0=-89.3944444444444 +k_0=1.00003498 +x_0=169164.3");
    add_proj4text (p, 2,
        "381 +y_0=111569.6134 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Columbia (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.");
    add_srs_wkt (p, 8,
        "4625466458333],PARAMETER[\"central_meridian\",-89.394444");
    add_srs_wkt (p, 9,
        "4444444],PARAMETER[\"scale_factor\",1.00003498],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",169164.3381],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",111569.6134],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"8198\"]]");
    p = add_epsg_def_ex (filter, first, last, 8200, "epsg", 8200,
        "NAD83(HARN) / WISCRS Columbia (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.4625466458333 +lat_0=43.462546645833");
    add_proj4text (p, 1,
        "3 +lon_0=-89.3944444444444 +k_0=1.00003498 +x_0=169164.3");
    add_proj4text (p, 2,
        "38023876 +y_0=111569.613512827 +ellps=GRS80 +units=us-ft");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Columbia (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 8,
        ".4625466458333],PARAMETER[\"central_meridian\",-89.39444");
    add_srs_wkt (p, 9,
        "44444444],PARAMETER[\"scale_factor\",1.00003498],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",554999.999],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",366041.307],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 12,
        "219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8200\"]]");
    p = add_epsg_def_ex (filter, first, last, 8201, "epsg", 8201,
        "NAD83(HARN) / WISCRS Clark (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.6 +lon_0=-90.7083333333333 +k=1.00");
    add_proj4text (p, 1,
        "00463003 +x_0=199949.1989 +y_0=0.0086 +ellps=GRS80 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Clark (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",43.6],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-90.7083333333333],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1.0000463003],PARAMETER[\"false_easting\",199");
    add_srs_wkt (p, 10,
        "949.1989],PARAMETER[\"false_northing\",0.0086],UNIT[\"me");
    add_srs_wkt (p, 11,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",E");
    add_srs_wkt (p, 12,
        "AST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8201\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 8202, "epsg", 8202,
        "NAD83(HARN) / WISCRS Clark (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.6 +lon_0=-90.7083333333333 +k=1.00");
    add_proj4text (p, 1,
        "00463003 +x_0=199949.198983998 +y_0=0.00853441706883414 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Clark (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",43.6],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"central_meridian\",-90.7083333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "scale_factor\",1.0000463003],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",655999.997],PARAMETER[\"false_northing\",0.028],UNIT[\"");
    add_srs_wkt (p, 11,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"8202\"]]");
    p = add_epsg_def_ex (filter, first, last, 8203, "epsg", 8203,
        "NAD83(HARN) / WISCRS Chippewa (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.9778568986111 +lat_0=44.977856898611");
    add_proj4text (p, 1,
        "1 +lon_0=-91.2944444444444 +k_0=1.0000391127 +x_0=60045.");
    add_proj4text (p, 2,
        "72 +y_0=44091.4346 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Chippewa (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44.");
    add_srs_wkt (p, 8,
        "9778568986111],PARAMETER[\"central_meridian\",-91.294444");
    add_srs_wkt (p, 9,
        "4444444],PARAMETER[\"scale_factor\",1.0000391127],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",60045.72],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",44091.4346],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"8203\"]]");
    p = add_epsg_def_ex (filter, first, last, 8204, "epsg", 8204,
        "NAD83(HARN) / WISCRS Chippewa (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.9778568986111 +lat_0=44.977856898611");
    add_proj4text (p, 1,
        "1 +lon_0=-91.2944444444444 +k_0=1.0000391127 +x_0=60045.");
    add_proj4text (p, 2,
        "7200914402 +y_0=44091.434493269 +ellps=GRS80 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Chippewa (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 8,
        ".9778568986111],PARAMETER[\"central_meridian\",-91.29444");
    add_srs_wkt (p, 9,
        "44444444],PARAMETER[\"scale_factor\",1.0000391127],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",197000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",144656.648],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 12,
        "9,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8204\"]]");
    p = add_epsg_def_ex (filter, first, last, 8205, "epsg", 8205,
        "NAD83(HARN) / WISCRS Calumet, Fond du Lac, Outagamie and Winnebago (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.7194444444444 +lon_0=-88.5 +k=1.00");
    add_proj4text (p, 1,
        "00286569 +x_0=244754.8893 +y_0=0.0049 +ellps=GRS80 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Calumet, Fond du Lac, Outa");
    add_srs_wkt (p, 1,
        "gamie and Winnebago (m)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"");
    add_srs_wkt (p, 2,
        "NAD83_High_Accuracy_Reference_Network\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4152\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"latitude_of_origin\",42.7194444444444],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",-88.5],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 10,
        "00286569],PARAMETER[\"false_easting\",244754.8893],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",0.0049],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"8205\"]]");
    p = add_epsg_def_ex (filter, first, last, 8206, "epsg", 8206,
        "NAD83(HARN) / WISCRS Calumet, Fond du Lac, Outagamie and Winnebago (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.7194444444444 +lon_0=-88.5 +k=1.00");
    add_proj4text (p, 1,
        "00286569 +x_0=244754.889204978 +y_0=0.00487680975361951 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Calumet, Fond du Lac, Outa");
    add_srs_wkt (p, 1,
        "gamie and Winnebago (ftUS)\",GEOGCS[\"NAD83(HARN)\",DATU");
    add_srs_wkt (p, 2,
        "M[\"NAD83_High_Accuracy_Reference_Network\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"4152\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 8,
        "METER[\"latitude_of_origin\",42.7194444444444],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-88.5],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "1.0000286569],PARAMETER[\"false_easting\",802999.999],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0.016],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"8206\"]]");
    p = add_epsg_def_ex (filter, first, last, 8207, "epsg", 8207,
        "NAD83(HARN) / WISCRS Burnett (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.8987148658333 +lat_0=45.898714865833");
    add_proj4text (p, 1,
        "3 +lon_0=-92.4577777777778 +k_0=1.0000383841 +x_0=64008.");
    add_proj4text (p, 2,
        "1276 +y_0=59445.9043 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Burnett (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 7,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.8");
    add_srs_wkt (p, 8,
        "987148658333],PARAMETER[\"central_meridian\",-92.4577777");
    add_srs_wkt (p, 9,
        "777778],PARAMETER[\"scale_factor\",1.0000383841],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",64008.1276],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",59445.9043],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"8207\"]]");
    p = add_epsg_def_ex (filter, first, last, 8208, "epsg", 8208,
        "NAD83(HARN) / WISCRS Burnett (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.8987148658333 +lat_0=45.898714865833");
    add_proj4text (p, 1,
        "3 +lon_0=-92.4577777777778 +k_0=1.0000383841 +x_0=64008.");
    add_proj4text (p, 2,
        "1277114554 +y_0=59445.9041910084 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Burnett (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45");
    add_srs_wkt (p, 8,
        ".8987148658333],PARAMETER[\"central_meridian\",-92.45777");
    add_srs_wkt (p, 9,
        "77777778],PARAMETER[\"scale_factor\",1.0000383841],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",209999.999],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",195032.104],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8208\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 8209, "epsg", 8209,
        "NAD83(HARN) / WISCRS Buffalo (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.4813888888889 +lon_0=-91.797222222");
    add_proj4text (p, 1,
        "2222 +k=1.0000382778 +x_0=175260.3502 +y_0=0.0048 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Buffalo (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",43.481388888");
    add_srs_wkt (p, 8,
        "8889],PARAMETER[\"central_meridian\",-91.7972222222222],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000382778],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",175260.3502],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        ".0048],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"8209\"]]");
    p = add_epsg_def_ex (filter, first, last, 8210, "epsg", 8210,
        "NAD83(HARN) / WISCRS Buffalo (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.4813888888889 +lon_0=-91.797222222");
    add_proj4text (p, 1,
        "2222 +k=1.0000382778 +x_0=175260.3502159 +y_0=0.00487680");
    add_proj4text (p, 2,
        "975361951 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Buffalo (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",43.4813888");
    add_srs_wkt (p, 8,
        "888889],PARAMETER[\"central_meridian\",-91.7972222222222");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.0000382778],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",574999.999],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0.016],UNIT[\"US survey foot\",0.304800609601219,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"8210\"]]");
    p = add_epsg_def_ex (filter, first, last, 8212, "epsg", 8212,
        "NAD83(HARN) / WISCRS Brown (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43 +lon_0=-88 +k=1.00002 +x_0=31600 +");
    add_proj4text (p, 1,
        "y_0=4600 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Brown (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",43],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "central_meridian\",-88],PARAMETER[\"scale_factor\",1.000");
    add_srs_wkt (p, 9,
        "02],PARAMETER[\"false_easting\",31600],PARAMETER[\"false");
    add_srs_wkt (p, 10,
        "_northing\",4600],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"8212\"]]");
    p = add_epsg_def_ex (filter, first, last, 8213, "epsg", 8213,
        "NAD83(HARN) / WISCRS Brown (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43 +lon_0=-88 +k=1.00002 +x_0=31599.9");
    add_proj4text (p, 1,
        "998983998 +y_0=4599.9998983998 +ellps=GRS80 +units=us-ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Brown (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",43],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",-88],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 9,
        "1.00002],PARAMETER[\"false_easting\",103674.333],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_northing\",15091.833],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 11,
        ",0.304800609601219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"8213\"]]");
    p = add_epsg_def_ex (filter, first, last, 8214, "epsg", 8214,
        "NAD83(HARN) / WISCRS Bayfield (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.6696483772222 +lat_0=46.669648377222");
    add_proj4text (p, 1,
        "2 +lon_0=-91.1527777777778 +k_0=1.0000331195 +x_0=228600");
    add_proj4text (p, 2,
        ".4575 +y_0=148551.4837 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Bayfield (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Networ");
    add_srs_wkt (p, 2,
        "k\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 7,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",46.");
    add_srs_wkt (p, 8,
        "6696483772222],PARAMETER[\"central_meridian\",-91.152777");
    add_srs_wkt (p, 9,
        "7777778],PARAMETER[\"scale_factor\",1.0000331195],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_easting\",228600.4575],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",148551.4837],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"8214\"]]");
    p = add_epsg_def_ex (filter, first, last, 8216, "epsg", 8216,
        "NAD83(HARN) / WISCRS Bayfield (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.6696483772222 +lat_0=46.669648377222");
    add_proj4text (p, 1,
        "2 +lon_0=-91.1527777777778 +k_0=1.0000331195 +x_0=228600");
    add_proj4text (p, 2,
        ".457505715 +y_0=148551.483566167 +ellps=GRS80 +units=us-");
    add_proj4text (p, 3,
        "ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Bayfield (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 7,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",46");
    add_srs_wkt (p, 8,
        ".6696483772222],PARAMETER[\"central_meridian\",-91.15277");
    add_srs_wkt (p, 9,
        "77777778],PARAMETER[\"scale_factor\",1.0000331195],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",750000.001],PARAMETER[\"false_nor");
    add_srs_wkt (p, 11,
        "thing\",487372.659],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 12,
        "01219,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8216\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 8218, "epsg", 8218,
        "NAD83(HARN) / WISCRS Barron (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.1333333333333 +lon_0=-91.85 +k=1.0");
    add_proj4text (p, 1,
        "000486665 +x_0=93150 +y_0=0.0029 +ellps=GRS80 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Barron (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",45.1333333333333");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-91.85],PARAMETER[\"sca");
    add_srs_wkt (p, 9,
        "le_factor\",1.0000486665],PARAMETER[\"false_easting\",93");
    add_srs_wkt (p, 10,
        "150],PARAMETER[\"false_northing\",0.0029],UNIT[\"metre\"");
    add_srs_wkt (p, 11,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 12,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"8218\"]]");
    p = add_epsg_def_ex (filter, first, last, 8220, "epsg", 8220,
        "NAD83(HARN) / WISCRS Barron (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.1333333333333 +lon_0=-91.85 +k=1.0");
    add_proj4text (p, 1,
        "000486665 +x_0=93150 +y_0=0.00304800609601219 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Barron (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netwo");
    add_srs_wkt (p, 2,
        "rk\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRI");
    add_srs_wkt (p, 4,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 7,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",45.13333333");
    add_srs_wkt (p, 8,
        "33333],PARAMETER[\"central_meridian\",-91.85],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"scale_factor\",1.0000486665],PARAMETER[\"false_easting");
    add_srs_wkt (p, 10,
        "\",305609.625],PARAMETER[\"false_northing\",0.01],UNIT[\"");
    add_srs_wkt (p, 11,
        "US survey foot\",0.304800609601219,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"8220\"]]");
    p = add_epsg_def_ex (filter, first, last, 8222, "epsg", 8222,
        "NAD83(HARN) / WISCRS Ashland (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.7061111111111 +lon_0=-90.622222222");
    add_proj4text (p, 1,
        "2222 +k=1.0000495683 +x_0=172821.9461 +y_0=0.0017 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Ashland (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network");
    add_srs_wkt (p, 2,
        "\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 7,
        "ercator\"],PARAMETER[\"latitude_of_origin\",45.706111111");
    add_srs_wkt (p, 8,
        "1111],PARAMETER[\"central_meridian\",-90.6222222222222],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"scale_factor\",1.0000495683],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_easting\",172821.9461],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        ".0017],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"8222\"]]");
    p = add_epsg_def_ex (filter, first, last, 8224, "epsg", 8224,
        "NAD83(HARN) / WISCRS Ashland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.7061111111111 +lon_0=-90.622222222");
    add_proj4text (p, 1,
        "2222 +k=1.0000495683 +x_0=172821.945948692 +y_0=0.001828");
    add_proj4text (p, 2,
        "80365760732 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Ashland (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 7,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",45.7061111");
    add_srs_wkt (p, 8,
        "111111],PARAMETER[\"central_meridian\",-90.6222222222222");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"scale_factor\",1.0000495683],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_easting\",567000.001],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0.006],UNIT[\"US survey foot\",0.304800609601219,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"8224\"]]");
    p = add_epsg_def_ex (filter, first, last, 8225, "epsg", 8225,
        "NAD83(HARN) / WISCRS Adams and Juneau (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.3666666666667 +lon_0=-90 +k=1.0000");
    add_proj4text (p, 1,
        "365285 +x_0=147218.6942 +y_0=0.0037 +ellps=GRS80 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Adams and Juneau (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Referenc");
    add_srs_wkt (p, 2,
        "e_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6152\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 7,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.3");
    add_srs_wkt (p, 8,
        "666666666667],PARAMETER[\"central_meridian\",-90],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1.0000365285],PARAMETER[\"false_eas");
    add_srs_wkt (p, 10,
        "ting\",147218.6942],PARAMETER[\"false_northing\",0.0037]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"8225\"]]");
    p = add_epsg_def_ex (filter, first, last, 8226, "epsg", 8226,
        "NAD83(HARN) / WISCRS Adams and Juneau (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.3666666666667 +lon_0=-90 +k=1.0000");
    add_proj4text (p, 1,
        "365285 +x_0=147218.694132588 +y_0=0.00365760731521463 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / WISCRS Adams and Juneau (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 2,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"61");
    add_srs_wkt (p, 4,
        "52\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 8,
        "3.3666666666667],PARAMETER[\"central_meridian\",-90],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",1.0000365285],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",482999.999],PARAMETER[\"false_northing\",0.012");
    add_srs_wkt (p, 11,
        "],UNIT[\"US survey foot\",0.304800609601219,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9003\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"8226\"]]");
    p = add_epsg_def_ex (filter, first, last, 8231, "epsg", 8231,
        "NAD83(CSRS96)", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS96", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(CSRS96)\",DATUM[\"North American Datum o");
    add_srs_wkt (p, 1,
        "f 1983 (CSRS96)\",ELLIPSOID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 2,
        "222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 3,
        "ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ellipsoidal");
    add_srs_wkt (p, 4,
        ",3],AXIS[\"geodetic latitude (Lat)\",north,ORDER[1],ANGL");
    add_srs_wkt (p, 5,
        "EUNIT[\"degree\",0.0174532925199433]],AXIS[\"geodetic lo");
    add_srs_wkt (p, 6,
        "ngitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree\",0.017");
    add_srs_wkt (p, 7,
        "4532925199433]],AXIS[\"ellipsoidal height (h)\",up,ORDER");
    add_srs_wkt (p, 8,
        "[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geodesy.\"],A");
    add_srs_wkt (p, 9,
        "REA[\"Canada - onshore and offshore - Alberta; British C");
    add_srs_wkt (p, 10,
        "olumbia; Manitoba; New Brunswick; Newfoundland and Labra");
    add_srs_wkt (p, 11,
        "dor; Northwest Territories; Nova Scotia; Nunavut; Ontari");
    add_srs_wkt (p, 12,
        "o; Prince Edward Island; Quebec; Saskatchewan; Yukon.\"]");
    add_srs_wkt (p, 13,
        ",BBOX[38.21,-141.01,86.46,-40.73]],ID[\"EPSG\",8231]]");
    p = add_epsg_def_ex (filter, first, last, 8232, "epsg", 8232,
        "NAD83(CSRS96)", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS96", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CSRS96)\",DATUM[\"North_American_Datum_of");
    add_srs_wkt (p, 1,
        "_1983_CSRS96\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 2,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 3,
        "92\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"8232\"]]");
    p = add_epsg_def_ex (filter, first, last, 8235, "epsg", 8235,
        "NAD83(CSRS)v2", 1, 1,
        "GRS 1980", "Greenwich",
        "North_American_Datum_of_1983_CSRS_version_2", "none", "degree",
        "Geodetic latitude", "North", "Geodetic longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCRS[\"NAD83(CSRS)v2\",DATUM[\"North American Datum o");
    add_srs_wkt (p, 1,
        "f 1983 (CSRS) version 2\",ELLIPSOID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 2,
        ",298.257222101,LENGTHUNIT[\"metre\",1]]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 3,
        "ich\",0,ANGLEUNIT[\"degree\",0.0174532925199433]],CS[ell");
    add_srs_wkt (p, 4,
        "ipsoidal,3],AXIS[\"geodetic latitude (Lat)\",north,ORDER");
    add_srs_wkt (p, 5,
        "[1],ANGLEUNIT[\"degree\",0.0174532925199433]],AXIS[\"geo");
    add_srs_wkt (p, 6,
        "detic longitude (Lon)\",east,ORDER[2],ANGLEUNIT[\"degree");
    add_srs_wkt (p, 7,
        "\",0.0174532925199433]],AXIS[\"ellipsoidal height (h)\",");
    add_srs_wkt (p, 8,
        "up,ORDER[3],LENGTHUNIT[\"metre\",1]],USAGE[SCOPE[\"Geode");
    add_srs_wkt (p, 9,
        "sy.\"],AREA[\"Canada - onshore and offshore - Alberta; B");
    add_srs_wkt (p, 10,
        "ritish Columbia; Manitoba; New Brunswick; Newfoundland a");
    add_srs_wkt (p, 11,
        "nd Labrador; Northwest Territories; Nova Scotia; Nunavut");
    add_srs_wkt (p, 12,
        "; Ontario; Prince Edward Island; Quebec; Saskatchewan; Y");
    add_srs_wkt (p, 13,
        "ukon.\"],BBOX[38.21,-141.01,86.46,-40.73]],ID[\"EPSG\",8");
    add_srs_wkt (p, 14,
        "235]]");
}

#endif /* full EPSG initialization enabled/disabled */

