
#include <sbkpep.h>
#include <shiboken.h>
#include <sbkbindingutils.h>
#include <algorithm>
#include <signature.h>
#include <sbkcontainer.h>
#include <sbkstaticstrings.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysidecleanup.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <pysidestaticstrings.h>
#include "kwidgetsaddons_python.h"

#include <QHash>
#include <QList>
#include <QMap>
#include <QString>
#include <kguiitem.h>
#include <qabstractitemmodel.h>
#include <qaction.h>
#include <qbytearray.h>
#include <qchar.h>
#include <qcolor.h>
#include <qdatetime.h>
#include <qlocale.h>
#include <qtimezone.h>
#include <qurl.h>
#include <qvariant.h>
#include <utility>


// Current module's type array.
Shiboken::Module::TypeInitStruct *SbkKWidgetsAddonsTypeStructs = nullptr;
// Backwards compatible structure with identical indexing.
PyTypeObject **SbkKWidgetsAddonsTypes = nullptr;
// Current module's converter array.
SbkConverter **SbkKWidgetsAddonsTypeConverters = nullptr;

void cleanTypesAttributes() {
    static PyObject *attrName = Shiboken::PyName::qtStaticMetaObject();
    const int imax = SBK_KWidgetsAddons_IDX_COUNT;
    for (int i = 0; i < imax && SbkKWidgetsAddonsTypeStructs[i].fullName != nullptr; ++i) {
        auto *pyType = reinterpret_cast<PyObject *>(SbkKWidgetsAddonsTypeStructs[i].type);
        if (pyType != nullptr && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}

// Global functions ------------------------------------------------------------

static PyMethodDef KWidgetsAddonsMethods[] = {
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
PyTypeObject *init_KXYSelector(PyObject *enclosing);
PyTypeObject *init_KViewStateSerializer(PyObject *enclosing);
PyTypeObject *init_KUrlLabel(PyObject *enclosing);
PyTypeObject *init_KTwoFingerTapRecognizer(PyObject *enclosing);
PyTypeObject *init_KTwoFingerTap(PyObject *enclosing);
PyTypeObject *init_KTwoFingerSwipeRecognizer(PyObject *enclosing);
PyTypeObject *init_KTwoFingerSwipe(PyObject *enclosing);
PyTypeObject *init_KToolTipWidget(PyObject *enclosing);
PyTypeObject *init_KToolBarSpacerAction(PyObject *enclosing);
PyTypeObject *init_KToolBarPopupAction(PyObject *enclosing);
PyTypeObject *init_KToolBarLabelAction(PyObject *enclosing);
PyTypeObject *init_KToggleAction(PyObject *enclosing);
PyTypeObject *init_KToggleFullScreenAction(PyObject *enclosing);
PyTypeObject *init_KTitleWidget(PyObject *enclosing);
PyTypeObject *init_KTimeComboBox(PyObject *enclosing);
PyTypeObject *init_KWidgetsAddonsKStyleExtensions(PyObject *enclosing);
PyTypeObject *init_KWidgetsAddonsKStandardGuiItem(PyObject *enclosing);
PyTypeObject *init_KSqueezedTextLabel(PyObject *enclosing);
PyTypeObject *init_KSplitterCollapserButton(PyObject *enclosing);
PyTypeObject *init_KSeparator(PyObject *enclosing);
PyTypeObject *init_KSelector(PyObject *enclosing);
PyTypeObject *init_KSelectAction(PyObject *enclosing);
PyTypeObject *init_KRuler(PyObject *enclosing);
PyTypeObject *init_KRecentFilesMenu(PyObject *enclosing);
PyTypeObject *init_KRatingWidget(PyObject *enclosing);
PyTypeObject *init_KRatingPainter(PyObject *enclosing);
PyTypeObject *init_KPopupFrame(PyObject *enclosing);
PyTypeObject *init_KPixmapSequenceWidget(PyObject *enclosing);
PyTypeObject *init_KPixmapSequenceOverlayPainter(PyObject *enclosing);
PyTypeObject *init_KPixmapSequence(PyObject *enclosing);
PyTypeObject *init_KPixmapRegionSelectorWidget(PyObject *enclosing);
PyTypeObject *init_KPixmapRegionSelectorDialog(PyObject *enclosing);
PyTypeObject *init_KPasswordLineEdit(PyObject *enclosing);
PyTypeObject *init_KPasswordDialog(PyObject *enclosing);
PyTypeObject *init_KWidgetsAddonsKPassword(PyObject *enclosing);
PyTypeObject *init_KPageWidgetItem(PyObject *enclosing);
PyTypeObject *init_KPageView(PyObject *enclosing);
PyTypeObject *init_KPageWidget(PyObject *enclosing);
PyTypeObject *init_KPageModel(PyObject *enclosing);
PyTypeObject *init_KPageWidgetModel(PyObject *enclosing);
PyTypeObject *init_KPageDialog(PyObject *enclosing);
PyTypeObject *init_KNewPasswordWidget(PyObject *enclosing);
PyTypeObject *init_KNewPasswordDialog(PyObject *enclosing);
PyTypeObject *init_KMultiTabBarButton(PyObject *enclosing);
PyTypeObject *init_KMultiTabBarTab(PyObject *enclosing);
PyTypeObject *init_KMultiTabBar(PyObject *enclosing);
PyTypeObject *init_KWidgetsAddonsKMimeTypeEditor(PyObject *enclosing);
PyTypeObject *init_KMimeTypeChooserDialog(PyObject *enclosing);
PyTypeObject *init_KMimeTypeChooser(PyObject *enclosing);
PyTypeObject *init_KMessageWidget(PyObject *enclosing);
PyTypeObject *init_KMessageDialog(PyObject *enclosing);
PyTypeObject *init_KMessageBoxNotifyInterface(PyObject *enclosing);
PyTypeObject *init_KWidgetsAddonsKMessageBox(PyObject *enclosing);
PyTypeObject *init_KLineEditUrlDropEventFilter(PyObject *enclosing);
PyTypeObject *init_KWidgetsAddonsKLineEditEventHandler(PyObject *enclosing);
PyTypeObject *init_KLed(PyObject *enclosing);
PyTypeObject *init_KWidgetsAddonsKJobWidgets(PyObject *enclosing);
PyTypeObject *init_KGuiItem(PyObject *enclosing);
PyTypeObject *init_KGradientSelector(PyObject *enclosing);
PyTypeObject *init_KFontSizeAction(PyObject *enclosing);
PyTypeObject *init_KFontRequester(PyObject *enclosing);
PyTypeObject *init_KFontChooserDialog(PyObject *enclosing);
PyTypeObject *init_KFontChooser(PyObject *enclosing);
PyTypeObject *init_KFontAction(PyObject *enclosing);
PyTypeObject *init_KEditListWidget(PyObject *enclosing);
PyTypeObject *init_KDualAction(PyObject *enclosing);
PyTypeObject *init_KDragWidgetDecoratorBase(PyObject *enclosing);
PyTypeObject *init_KDateTimeEdit(PyObject *enclosing);
PyTypeObject *init_KDatePickerPopup(PyObject *enclosing);
PyTypeObject *init_KDatePicker(PyObject *enclosing);
PyTypeObject *init_KDateComboBox(PyObject *enclosing);
PyTypeObject *init_KCursor(PyObject *enclosing);
PyTypeObject *init_KContextualHelpButton(PyObject *enclosing);
PyTypeObject *init_KColumnResizer(PyObject *enclosing);
PyTypeObject *init_KColorCombo(PyObject *enclosing);
PyTypeObject *init_KColorButton(PyObject *enclosing);
PyTypeObject *init_KCollapsibleGroupBox(PyObject *enclosing);
PyTypeObject *init_KCharSelect(PyObject *enclosing);
PyTypeObject *init_KCapacityBar(PyObject *enclosing);
PyTypeObject *init_KBusyIndicatorWidget(PyObject *enclosing);
PyTypeObject *init_KAssistantDialog(PyObject *enclosing);
PyTypeObject *init_KAnimatedButton(PyObject *enclosing);
PyTypeObject *init_KActionSelector(PyObject *enclosing);
PyTypeObject *init_KActionMenu(PyObject *enclosing);
PyTypeObject *init_KAcceleratorManager(PyObject *enclosing);

// Required modules' type and converter arrays.
Shiboken::Module::TypeInitStruct *SbkPySide6_QtWidgetsTypeStructs;
SbkConverter **SbkPySide6_QtWidgetsTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtGuiTypeStructs;
SbkConverter **SbkPySide6_QtGuiTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtCoreTypeStructs;
SbkConverter **SbkPySide6_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for container type 'QList<int>'.
static PyObject *_QList_int__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<int> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_int_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<int> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_int__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return PySequence_PythonToCpp__QList_int_;
    return {};
}


// Binding for QList<int>

template <>
struct ShibokenContainerValueConverter<int>
{
    static bool checkValue(PyObject *pyArg)
    {
        return PyLong_Check(pyArg);
    }

    static PyObject *convertValueToPython(int cppArg)
    {
        return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppArg);
    }

    static std::optional<int> convertValueToCpp(PyObject *pyArg)
    {
        Shiboken::Conversions::PythonToCppConversion pythonToCpp;
        if (!(PyLong_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg))))) {
            Shiboken::Errors::setWrongContainerType();
            return {};
        }
        int cppArg;
        pythonToCpp(pyArg, &cppArg);
        return cppArg;
    }
};

static PyMethodDef QIntList_methods[] = {
    {"push_back", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_back), METH_O, "push_back"},
    {"append", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_back), METH_O, "append"},
    {"clear", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::clear), METH_NOARGS, "clear"},
    {"pop_back", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_back), METH_NOARGS, "pop_back"},
    {"removeLast", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_back), METH_NOARGS, "removeLast"},
    {"push_front", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_front), METH_O, "push_front"},
    {"prepend", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_front), METH_O, "prepend"},
    {"pop_front", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_front), METH_NOARGS, "pop_front"},
    {"removeFirst", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_front), METH_O, "removeFirst"},
    {"reserve", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::reserve), METH_O, "reserve"},
    {"capacity", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::capacity), METH_NOARGS, "capacity"},
    {"data", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::data), METH_NOARGS, "data"},
    {"constData", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::constData), METH_NOARGS, "constData"},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyType_Slot QIntList_slots[] = {
    {Py_tp_init, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpInit)},
    {Py_tp_new, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpNew)},
    {Py_tp_free, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpFree)},
    {Py_tp_dealloc, reinterpret_cast<void *>(Sbk_object_dealloc)},
    {Py_tp_methods, reinterpret_cast<void *>(QIntList_methods)},
    {Py_sq_ass_item, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqSetItem)},
    {Py_sq_length, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqLen)},
    {Py_sq_item, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqGetItem)},
    {0, nullptr}
};

static PyType_Spec QIntList_spec = {
    "1:KWidgetsAddons.QIntList",
    sizeof(ShibokenContainer),
    0,
    Py_TPFLAGS_DEFAULT,
    QIntList_slots
};

static inline PyTypeObject *createQIntListType()
{
    auto *result = SbkType_FromSpec(&QIntList_spec);
    Py_INCREF(Py_True);
    Shiboken::AutoDecRef tpDict(PepType_GetDict(result));
    PyDict_SetItem(tpDict.object(), Shiboken::PyMagicName::opaque_container(), Py_True);
    return result;
}

static PyTypeObject *QIntList_TypeF()
{
    static PyTypeObject *type = createQIntListType();
    return type;
}

extern "C" PyObject *createQIntList(QList<int>* ct)
{
    auto *container = PyObject_New(ShibokenContainer, QIntList_TypeF());
    auto *d = new ShibokenSequenceContainerPrivate<QList<int>>();
    d->m_list = ct;
    container->d = d;
    return reinterpret_cast<PyObject *>(container);
}

extern "C" PyObject *createConstQIntList(const QList<int>* ct)
{
    auto *container = PyObject_New(ShibokenContainer, QIntList_TypeF());
    auto *d = new ShibokenSequenceContainerPrivate<QList<int>>();
    d->m_list = const_cast<QList<int> *>(ct);
    d->m_const = true;
    container->d = d;
    return reinterpret_cast<PyObject *>(container);
}

extern "C" int QIntList_Check(PyObject *pyArg)
{
    return pyArg != nullptr && pyArg != Py_None && pyArg->ob_type == QIntList_TypeF();
}

extern "C" void PythonToCppQIntList(PyObject *pyArg, void *cppOut)
{
    auto *d = ShibokenSequenceContainerPrivate<QList<int>>::get(pyArg);
    *reinterpret_cast<QList<int>**>(cppOut) = d->m_list;
}

extern "C" PythonToCppFunc isQIntListPythonToCppConvertible(PyObject *pyArg)
{
    if (QIntList_Check(pyArg))
        return PythonToCppQIntList;
    return {};
}

extern "C" void PythonToQVariantQIntList(PyObject *pyArg, void *cppOut)
{
    auto *d = ShibokenSequenceContainerPrivate<QList<int>>::get(pyArg);
    *reinterpret_cast<QVariant *>(cppOut) = QVariant::fromValue(*d->m_list);
}

extern "C" PythonToCppFunc isQIntListPythonToQVariantConvertible(PyObject *pyArg)
{
    if (QIntList_Check(pyArg))
        return PythonToQVariantQIntList;
    return {};
}

// C++ to Python conversion for container type 'std::pair<int,int>'.
static PyObject *std_pair_int_int__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const std::pair<int,int> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cpppair_to_pytuple - START
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SetItem(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppInRef.first));
    PyTuple_SetItem(pyOut, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppInRef.second));
    return pyOut;
    // TEMPLATE - shiboken_conversion_cpppair_to_pytuple - END

}
static void PySequence_PythonToCpp_std_pair_int_int_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<std::pair<int,int> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pysequence_to_cpppair - START
    Shiboken::AutoDecRef objfirst(PySequence_GetItem(pyIn, 0));
    Shiboken::AutoDecRef objsecond(PySequence_GetItem(pyIn, 1));
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), objfirst, &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), objsecond, &(cppOutRef.second));
    // TEMPLATE - shiboken_conversion_pysequence_to_cpppair - END

}
static PythonToCppFunc is_PySequence_PythonToCpp_std_pair_int_int__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertiblePairTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, pyIn))
        return PySequence_PythonToCpp_std_pair_int_int_;
    return {};
}

// C++ to Python conversion for container type 'QList<QTime>'.
static PyObject *_QList_QTime__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QTime> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QTime_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QTime> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTime cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QTime__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTime_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QTime_;
    return {};
}

// C++ to Python conversion for container type 'std::pair<KGuiItem,KGuiItem>'.
static PyObject *std_pair_KGuiItem_KGuiItem__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const std::pair<KGuiItem,KGuiItem> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cpppair_to_pytuple - START
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SetItem(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), &cppInRef.first));
    PyTuple_SetItem(pyOut, 1, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), &cppInRef.second));
    return pyOut;
    // TEMPLATE - shiboken_conversion_cpppair_to_pytuple - END

}
static void PySequence_PythonToCpp_std_pair_KGuiItem_KGuiItem_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<std::pair<KGuiItem,KGuiItem> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pysequence_to_cpppair - START
    Shiboken::AutoDecRef objfirst(PySequence_GetItem(pyIn, 0));
    Shiboken::AutoDecRef objsecond(PySequence_GetItem(pyIn, 1));
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), objfirst, &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), objsecond, &(cppOutRef.second));
    // TEMPLATE - shiboken_conversion_pysequence_to_cpppair - END

}
static PythonToCppFunc is_PySequence_PythonToCpp_std_pair_KGuiItem_KGuiItem__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertiblePairTypes(PepType_SOTP(reinterpret_cast<PyTypeObject *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX])))->converter, false, PepType_SOTP(reinterpret_cast<PyTypeObject *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX])))->converter, false, pyIn))
        return PySequence_PythonToCpp_std_pair_KGuiItem_KGuiItem_;
    return {};
}

// C++ to Python conversion for container type 'QList<QAction*>'.
static PyObject *_QList_QActionPTR__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QAction*> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QActionPTR_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QAction*> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAction* cppItem{nullptr};
    Shiboken::Conversions::pythonToCppPointer(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QActionPTR__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::checkSequenceTypes(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QActionPTR_;
    return {};
}

// C++ to Python conversion for container type 'QList<QUrl>'.
static PyObject *_QList_QUrl__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QUrl> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QUrl_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QUrl> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QUrl cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QUrl__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QUrl_;
    return {};
}

// C++ to Python conversion for container type 'QMap<QString,QString>'.
static PyObject *_QMap_QString_QString__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<QString,QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_QString_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QString cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_QString_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, pyIn))
        return PyDict_PythonToCpp__QMap_QString_QString_;
    return {};
}

// C++ to Python conversion for container type 'QMap<int,QVariant>'.
static PyObject *_QMap_int_QVariant__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<int,QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_int_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<int,QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QVariant cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_int_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], false, pyIn))
        return PyDict_PythonToCpp__QMap_int_QVariant_;
    return {};
}

// C++ to Python conversion for container type 'QList<QModelIndex>'.
static PyObject *_QList_QModelIndex__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QModelIndex> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QModelIndex_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QModelIndex> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QModelIndex cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QModelIndex__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QModelIndex_;
    return {};
}

// C++ to Python conversion for container type 'QHash<int,QByteArray>'.
static PyObject *_QHash_int_QByteArray__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QHash<int,QByteArray> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QHash_int_QByteArray_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QHash<int,QByteArray> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QByteArray cppValue;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QHash_int_QByteArray__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, PepType_SOTP(reinterpret_cast<PyTypeObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX])))->converter, false, pyIn))
        return PyDict_PythonToCpp__QHash_int_QByteArray_;
    return {};
}

// C++ to Python conversion for container type 'std::pair<qreal,QColor>'.
static PyObject *std_pair_qreal_QColor__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const std::pair<qreal,QColor> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cpppair_to_pytuple - START
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SetItem(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppInRef.first));
    PyTuple_SetItem(pyOut, 1, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppInRef.second));
    return pyOut;
    // TEMPLATE - shiboken_conversion_cpppair_to_pytuple - END

}
static void PySequence_PythonToCpp_std_pair_qreal_QColor_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<std::pair<qreal,QColor> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pysequence_to_cpppair - START
    Shiboken::AutoDecRef objfirst(PySequence_GetItem(pyIn, 0));
    Shiboken::AutoDecRef objsecond(PySequence_GetItem(pyIn, 1));
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), objfirst, &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), objsecond, &(cppOutRef.second));
    // TEMPLATE - shiboken_conversion_pysequence_to_cpppair - END

}
static PythonToCppFunc is_PySequence_PythonToCpp_std_pair_qreal_QColor__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertiblePairTypes(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), false, PepType_SOTP(reinterpret_cast<PyTypeObject *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX])))->converter, false, pyIn))
        return PySequence_PythonToCpp_std_pair_qreal_QColor_;
    return {};
}

// C++ to Python conversion for container type 'QList<std::pair<qreal,QColor>>'.
static PyObject *_QList_std_pair_qreal_QColor___CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<std::pair<qreal,QColor>> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_qreal_QColor_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_std_pair_qreal_QColor__(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<std::pair<qreal,QColor>> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        std::pair<qreal,QColor> cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_qreal_QColor_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_std_pair_qreal_QColor___Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_qreal_QColor_IDX], pyIn))
        return PySequence_PythonToCpp__QList_std_pair_qreal_QColor__;
    return {};
}

// C++ to Python conversion for container type 'QList<QLocale>'.
static PyObject *_QList_QLocale__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QLocale> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QLocale_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QLocale> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QLocale cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QLocale__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QLocale_;
    return {};
}

// C++ to Python conversion for container type 'QMap<QDate,QString>'.
static PyObject *_QMap_QDate_QString__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<QDate,QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_QDate_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<QDate,QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QDate cppKey;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), key, &(cppKey));
        ::QString cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_QDate_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(PepType_SOTP(reinterpret_cast<PyTypeObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX])))->converter, false, SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, pyIn))
        return PyDict_PythonToCpp__QMap_QDate_QString_;
    return {};
}

// C++ to Python conversion for container type 'QList<QTimeZone>'.
static PyObject *_QList_QTimeZone__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QTimeZone> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimeZone_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QTimeZone_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QTimeZone> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTimeZone cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimeZone_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QTimeZone__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimeZone_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QTimeZone_;
    return {};
}

// C++ to Python conversion for container type 'QList<QColor>'.
static PyObject *_QList_QColor__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QColor> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QColor_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QColor> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QColor cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QColor__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), pyIn))
        return PySequence_PythonToCpp__QList_QColor_;
    return {};
}

// C++ to Python conversion for container type 'QList<QChar>'.
static PyObject *_QList_QChar__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QChar> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QChar_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QChar> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QChar cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QChar__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QChar_;
    return {};
}

// C++ to Python conversion for container type 'QList<uint>'.
static PyObject *_QList_uint__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<uint> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_uint_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<uint> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        uint cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_uint__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), pyIn))
        return PySequence_PythonToCpp__QList_uint_;
    return {};
}

// C++ to Python conversion for container type 'QList<QVariant>'.
static PyObject *_QList_QVariant__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for container type 'QList<QString>'.
static PyObject *_QList_QString__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for container type 'QMap<QString,QVariant>'.
static PyObject *_QMap_QString_QVariant__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<QString,QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QVariant cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], false, pyIn))
        return PyDict_PythonToCpp__QMap_QString_QVariant_;
    return {};
}


// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KWidgetsAddons_SignatureStrings[] = {
    nullptr}; // Sentinel
#else
static constexpr size_t KWidgetsAddons_SignatureByteSize = 0;
static constexpr uint8_t KWidgetsAddons_SignatureBytes[1] = {
    0x00
};
#endif

static void initInheritance()
{
    auto &bm = Shiboken::BindingManager::instance();
    SBK_UNUSED(bm)
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KXYSelector_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KViewStateSerializer_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KUrlLabel_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QGestureRecognizer_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTapRecognizer_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QGestureRecognizer_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipeRecognizer_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerSwipe_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KToolTipWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidgetAction_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KToolBarSpacerAction_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidgetAction_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KToolBarPopupAction_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidgetAction_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KToolBarLabelAction_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX]);
    bm.addClassInheritance(&SbkKWidgetsAddonsTypeStructs[SBK_KToggleAction_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KToggleFullScreenAction_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KTitleWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QComboBox_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KTimeComboBox_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KSqueezedTextLabel_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QToolButton_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KSplitterCollapserButton_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KSeparator_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractSlider_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KSelector_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidgetAction_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QAbstractSlider_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KRuler_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KRecentFilesMenu_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KRatingWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPopupFrame_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPixmapSequenceOverlayPainter_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPixmapRegionSelectorDialog_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPasswordLineEdit_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPasswordDialog_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetItem_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX]);
    bm.addClassInheritance(&SbkKWidgetsAddonsTypeStructs[SBK_KPageView_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPageWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX]);
    bm.addClassInheritance(&SbkKWidgetsAddonsTypeStructs[SBK_KPageModel_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPageWidgetModel_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KPageDialog_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KNewPasswordDialog_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX]);
    bm.addClassInheritance(&SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarButton_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBarTab_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KMultiTabBar_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooserDialog_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KMessageWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KMessageDialog_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KLineEditUrlDropEventFilter_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KLed_IDX]);
    bm.addClassInheritance(&SbkKWidgetsAddonsTypeStructs[SBK_KSelector_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KGradientSelector_IDX]);
    bm.addClassInheritance(&SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KFontRequester_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDialog_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KFontChooserDialog_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KFontChooser_IDX]);
    bm.addClassInheritance(&SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KFontAction_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KEditListWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KDateTimeEdit_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KDatePickerPopup_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QComboBox_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QToolButton_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KContextualHelpButton_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KColumnResizer_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QComboBox_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KColorCombo_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QPushButton_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KColorButton_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KCollapsibleGroupBox_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KCharSelect_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KCapacityBar_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KBusyIndicatorWidget_IDX]);
    bm.addClassInheritance(&SbkKWidgetsAddonsTypeStructs[SBK_KPageDialog_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KAssistantDialog_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QToolButton_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KAnimatedButton_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KActionSelector_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QWidgetAction_IDX],
                           &SbkKWidgetsAddonsTypeStructs[SBK_KActionMenu_IDX]);
}

static void initConverters_KWidgetsAddons()
{
    // Register primitive types converters.
    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "MultipleInheritanceInitFunction");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "PyCode_WatchCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "PyDict_WatchCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "PyFunction_WatchCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "PyRefTracer");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "PyTime_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "PyType_WatchCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "Py_AuditHookFunction");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "Py_UCS1");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "Py_UCS2");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "Py_UCS4");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "Py_hash_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "Py_intptr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "Py_ssize_clean_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "Py_ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "Py_tracefunc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<size_t>(), "Py_uhash_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "Py_uintptr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "QRgb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blksize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "__caddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__clock_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__clockid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__compar_d_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__compar_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__daddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__dev_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsblkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsblkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsfilcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsfilcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__fsword_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__gid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__id_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__ino64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__ino_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "__int16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__int32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__int64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "__int8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "__int_least16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__int_least32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__int_least64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "__int_least8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__intmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__intptr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__key_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__loff_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__mode_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__nlink_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__off64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__off_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__pid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__poll_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__rlim64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__rlim_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__sig_atomic_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__socklen_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__suseconds64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__suseconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__syscall_slong_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__syscall_ulong_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__time_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__u_char");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__u_int");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__u_long");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__u_quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__u_short");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__uint16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uint32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uint64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__uint8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__uint_least16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uint_least32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uint_least64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__uint_least8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uintmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__useconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blksize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "caddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "comparison_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "daddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "descrsetfunc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "dev_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "digit");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsblkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsblkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsfilcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsfilcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "gcvisitobjects_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "getbufferproc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "gid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "hashfunc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "id_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "initproc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ino64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ino_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "inquiry");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "int_fast8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "intmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "key_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "lenfunc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "loff_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "mode_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "nlink_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "objobjargproc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "objobjproc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "off64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "off_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "pid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "printfunc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "qInternalCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "register_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "sdigit");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "setattrfunc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "setattrofunc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "setter");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "ssizeobjargproc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "ssizessizeobjargproc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "stwodigits");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "suseconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "traverseproc");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "twodigits");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "u_char");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "u_int");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "u_int16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "u_int32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_int64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "u_int8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_long");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "u_short");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "uid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "uint_fast8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uintmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "useconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "visitproc");

}

static void initContainerConverters_KWidgetsAddons()
{
    // Register converter for type 'QList<int>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_int_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_int__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_int_IDX], "QList<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_int_IDX],
        PySequence_PythonToCpp__QList_int_,
        is_PySequence_PythonToCpp__QList_int__Convertible);
    Shiboken::Conversions::setPythonToCppPointerFunctions(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_int_IDX],
        PythonToCppQIntList,
        isQIntListPythonToCppConvertible);

    // Register converter for type 'std::pair<int,int>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_int_int_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, std_pair_int_int__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_int_int_IDX], "std::pair<int,int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_int_int_IDX],
        PySequence_PythonToCpp_std_pair_int_int_,
        is_PySequence_PythonToCpp_std_pair_int_int__Convertible);

    // Register converter for type 'QList<QTime>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QTime_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QTime__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QTime_IDX], "QList<QTime>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QTime_IDX],
        PySequence_PythonToCpp__QList_QTime_,
        is_PySequence_PythonToCpp__QList_QTime__Convertible);

    // Register converter for type 'std::pair<KGuiItem,KGuiItem>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_KGuiItem_KGuiItem_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, std_pair_KGuiItem_KGuiItem__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_KGuiItem_KGuiItem_IDX], "std::pair<KGuiItem,KGuiItem>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_KGuiItem_KGuiItem_IDX],
        PySequence_PythonToCpp_std_pair_KGuiItem_KGuiItem_,
        is_PySequence_PythonToCpp_std_pair_KGuiItem_KGuiItem__Convertible);

    // Register converter for type 'QList<QAction*>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QActionPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QActionPTR__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QActionPTR_IDX], "QList<QAction*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QActionPTR_IDX],
        PySequence_PythonToCpp__QList_QActionPTR_,
        is_PySequence_PythonToCpp__QList_QActionPTR__Convertible);

    // Register converter for type 'QList<QUrl>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QUrl_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QUrl__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QUrl_IDX], "QList<QUrl>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QUrl_IDX],
        PySequence_PythonToCpp__QList_QUrl_,
        is_PySequence_PythonToCpp__QList_QUrl__Convertible);

    // Register converter for type 'QMap<QString,QString>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QString_QString_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QString__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QString_QString_IDX], "QMap<QString,QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QString_QString_IDX],
        PyDict_PythonToCpp__QMap_QString_QString_,
        is_PyDict_PythonToCpp__QMap_QString_QString__Convertible);

    // Register converter for type 'QMap<int,QVariant>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_int_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_int_QVariant__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_int_QVariant_IDX], "QMap<int,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_int_QVariant_IDX],
        PyDict_PythonToCpp__QMap_int_QVariant_,
        is_PyDict_PythonToCpp__QMap_int_QVariant__Convertible);

    // Register converter for type 'QList<QModelIndex>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QModelIndex_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QModelIndex__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QModelIndex_IDX], "QList<QModelIndex>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QModelIndex_IDX],
        PySequence_PythonToCpp__QList_QModelIndex_,
        is_PySequence_PythonToCpp__QList_QModelIndex__Convertible);
    // Register converters for type aliases of QList<QModelIndex>'.
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QModelIndex_IDX], "QModelIndexList");

    // Register converter for type 'QHash<int,QByteArray>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QHash_int_QByteArray_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_int_QByteArray__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QHash_int_QByteArray_IDX], "QHash<int,QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QHash_int_QByteArray_IDX],
        PyDict_PythonToCpp__QHash_int_QByteArray_,
        is_PyDict_PythonToCpp__QHash_int_QByteArray__Convertible);

    // Register converter for type 'std::pair<qreal,QColor>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_qreal_QColor_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, std_pair_qreal_QColor__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_qreal_QColor_IDX], "std::pair<qreal,QColor>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_qreal_QColor_IDX],
        PySequence_PythonToCpp_std_pair_qreal_QColor_,
        is_PySequence_PythonToCpp_std_pair_qreal_QColor__Convertible);
    // Register converters for type aliases of std::pair<qreal,QColor>'.
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_std_pair_qreal_QColor_IDX], "QGradientStop");

    // Register converter for type 'QList<std::pair<qreal,QColor>>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_std_pair_qreal_QColor_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_std_pair_qreal_QColor___CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_std_pair_qreal_QColor_IDX], "QList<std::pair<qreal,QColor>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_std_pair_qreal_QColor_IDX],
        PySequence_PythonToCpp__QList_std_pair_qreal_QColor__,
        is_PySequence_PythonToCpp__QList_std_pair_qreal_QColor___Convertible);

    // Register converter for type 'QList<QLocale>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QLocale_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QLocale__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QLocale_IDX], "QList<QLocale>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QLocale_IDX],
        PySequence_PythonToCpp__QList_QLocale_,
        is_PySequence_PythonToCpp__QList_QLocale__Convertible);

    // Register converter for type 'QMap<QDate,QString>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QDate_QString_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QDate_QString__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QDate_QString_IDX], "QMap<QDate,QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QDate_QString_IDX],
        PyDict_PythonToCpp__QMap_QDate_QString_,
        is_PyDict_PythonToCpp__QMap_QDate_QString__Convertible);

    // Register converter for type 'QList<QTimeZone>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QTimeZone_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QTimeZone__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QTimeZone_IDX], "QList<QTimeZone>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QTimeZone_IDX],
        PySequence_PythonToCpp__QList_QTimeZone_,
        is_PySequence_PythonToCpp__QList_QTimeZone__Convertible);

    // Register converter for type 'QList<QColor>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QColor_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QColor__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QColor_IDX], "QList<QColor>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QColor_IDX],
        PySequence_PythonToCpp__QList_QColor_,
        is_PySequence_PythonToCpp__QList_QColor__Convertible);

    // Register converter for type 'QList<QChar>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QChar_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QChar__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QChar_IDX], "QList<QChar>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QChar_IDX],
        PySequence_PythonToCpp__QList_QChar_,
        is_PySequence_PythonToCpp__QList_QChar__Convertible);

    // Register converter for type 'QList<uint>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_uint_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_uint__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_uint_IDX], "QList<uint>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_uint_IDX],
        PySequence_PythonToCpp__QList_uint_,
        is_PySequence_PythonToCpp__QList_uint__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QVariant_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QVariant_IDX],
        PySequence_PythonToCpp__QList_QVariant_,
        is_PySequence_PythonToCpp__QList_QVariant__Convertible);
    // Register converters for type aliases of QList<QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QVariant_IDX], "QVariantList");

    // Register converter for type 'QList<QString>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QString_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QString_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QList_QString_IDX],
        PySequence_PythonToCpp__QList_QString_,
        is_PySequence_PythonToCpp__QList_QString__Convertible);
    // Register converters for type aliases of QList<QString>'.

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QString_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QString_QVariant_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QString_QVariant_IDX],
        PyDict_PythonToCpp__QMap_QString_QVariant_,
        is_PyDict_PythonToCpp__QMap_QString_QVariant__Convertible);
    // Register converters for type aliases of QMap<QString,QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QString_QVariant_IDX], "QVariantMap");

}

static void registerOpaqueContainers_KWidgetsAddons(PyObject *module)
{
    PyTypeObject *pyType{};
    auto *qVariantConverter = Shiboken::Conversions::getConverter("QVariant");
    Q_ASSERT(qVariantConverter != nullptr);
    pyType = QIntList_TypeF();
    Py_XINCREF(reinterpret_cast<PyObject *>(pyType));
    PepModule_AddType(module, pyType);
    if constexpr (QMetaTypeId2<int>::Defined) {
        Shiboken::Conversions::prependPythonToCppValueConversion(qVariantConverter,
            PythonToQVariantQIntList, isQIntListPythonToQVariantConvertible);
    }
}

extern "C" {
static int exec_KWidgetsAddons(PyObject *module)
{
    Shiboken::Module::exec(module);

    // Initialize classes in the type system
    Shiboken::Module::AddTypeCreationFunction(module, "KXYSelector", init_KXYSelector);
    Shiboken::Module::AddTypeCreationFunction(module, "KViewStateSerializer", init_KViewStateSerializer);
    Shiboken::Module::AddTypeCreationFunction(module, "KUrlLabel", init_KUrlLabel);
    Shiboken::Module::AddTypeCreationFunction(module, "KTwoFingerTapRecognizer", init_KTwoFingerTapRecognizer);
    Shiboken::Module::AddTypeCreationFunction(module, "KTwoFingerTap", init_KTwoFingerTap);
    Shiboken::Module::AddTypeCreationFunction(module, "KTwoFingerSwipeRecognizer", init_KTwoFingerSwipeRecognizer);
    Shiboken::Module::AddTypeCreationFunction(module, "KTwoFingerSwipe", init_KTwoFingerSwipe);
    Shiboken::Module::AddTypeCreationFunction(module, "KToolTipWidget", init_KToolTipWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "KToolBarSpacerAction", init_KToolBarSpacerAction);
    Shiboken::Module::AddTypeCreationFunction(module, "KToolBarPopupAction", init_KToolBarPopupAction);
    Shiboken::Module::AddTypeCreationFunction(module, "KToolBarLabelAction", init_KToolBarLabelAction);
    Shiboken::Module::AddTypeCreationFunction(module, "KToggleAction", init_KToggleAction);
    Shiboken::Module::AddTypeCreationFunction(module, "KToggleFullScreenAction", init_KToggleFullScreenAction);
    Shiboken::Module::AddTypeCreationFunction(module, "KTitleWidget", init_KTitleWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "KTimeComboBox", init_KTimeComboBox);
    Shiboken::Module::AddTypeCreationFunction(module, "KStyleExtensions", init_KWidgetsAddonsKStyleExtensions);
    Shiboken::Module::AddTypeCreationFunction(module, "KStandardGuiItem", init_KWidgetsAddonsKStandardGuiItem);
    Shiboken::Module::AddTypeCreationFunction(module, "KSqueezedTextLabel", init_KSqueezedTextLabel);
    Shiboken::Module::AddTypeCreationFunction(module, "KSplitterCollapserButton", init_KSplitterCollapserButton);
    Shiboken::Module::AddTypeCreationFunction(module, "KSeparator", init_KSeparator);
    Shiboken::Module::AddTypeCreationFunction(module, "KSelector", init_KSelector);
    Shiboken::Module::AddTypeCreationFunction(module, "KSelectAction", init_KSelectAction);
    Shiboken::Module::AddTypeCreationFunction(module, "KRuler", init_KRuler);
    Shiboken::Module::AddTypeCreationFunction(module, "KRecentFilesMenu", init_KRecentFilesMenu);
    Shiboken::Module::AddTypeCreationFunction(module, "KRatingWidget", init_KRatingWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "KRatingPainter", init_KRatingPainter);
    Shiboken::Module::AddTypeCreationFunction(module, "KPopupFrame", init_KPopupFrame);
    Shiboken::Module::AddTypeCreationFunction(module, "KPixmapSequenceWidget", init_KPixmapSequenceWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "KPixmapSequenceOverlayPainter", init_KPixmapSequenceOverlayPainter);
    Shiboken::Module::AddTypeCreationFunction(module, "KPixmapSequence", init_KPixmapSequence);
    Shiboken::Module::AddTypeCreationFunction(module, "KPixmapRegionSelectorWidget", init_KPixmapRegionSelectorWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "KPixmapRegionSelectorDialog", init_KPixmapRegionSelectorDialog);
    Shiboken::Module::AddTypeCreationFunction(module, "KPasswordLineEdit", init_KPasswordLineEdit);
    Shiboken::Module::AddTypeCreationFunction(module, "KPasswordDialog", init_KPasswordDialog);
    Shiboken::Module::AddTypeCreationFunction(module, "KPassword", init_KWidgetsAddonsKPassword);
    Shiboken::Module::AddTypeCreationFunction(module, "KPageWidgetItem", init_KPageWidgetItem);
    Shiboken::Module::AddTypeCreationFunction(module, "KPageView", init_KPageView);
    Shiboken::Module::AddTypeCreationFunction(module, "KPageWidget", init_KPageWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "KPageModel", init_KPageModel);
    Shiboken::Module::AddTypeCreationFunction(module, "KPageWidgetModel", init_KPageWidgetModel);
    Shiboken::Module::AddTypeCreationFunction(module, "KPageDialog", init_KPageDialog);
    Shiboken::Module::AddTypeCreationFunction(module, "KNewPasswordWidget", init_KNewPasswordWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "KNewPasswordDialog", init_KNewPasswordDialog);
    Shiboken::Module::AddTypeCreationFunction(module, "KMultiTabBarButton", init_KMultiTabBarButton);
    Shiboken::Module::AddTypeCreationFunction(module, "KMultiTabBarTab", init_KMultiTabBarTab);
    Shiboken::Module::AddTypeCreationFunction(module, "KMultiTabBar", init_KMultiTabBar);
    Shiboken::Module::AddTypeCreationFunction(module, "KMimeTypeEditor", init_KWidgetsAddonsKMimeTypeEditor);
    Shiboken::Module::AddTypeCreationFunction(module, "KMimeTypeChooserDialog", init_KMimeTypeChooserDialog);
    Shiboken::Module::AddTypeCreationFunction(module, "KMimeTypeChooser", init_KMimeTypeChooser);
    Shiboken::Module::AddTypeCreationFunction(module, "KMessageWidget", init_KMessageWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "KMessageDialog", init_KMessageDialog);
    Shiboken::Module::AddTypeCreationFunction(module, "KMessageBoxNotifyInterface", init_KMessageBoxNotifyInterface);
    Shiboken::Module::AddTypeCreationFunction(module, "KMessageBox", init_KWidgetsAddonsKMessageBox);
    Shiboken::Module::AddTypeCreationFunction(module, "KLineEditUrlDropEventFilter", init_KLineEditUrlDropEventFilter);
    Shiboken::Module::AddTypeCreationFunction(module, "KLineEditEventHandler", init_KWidgetsAddonsKLineEditEventHandler);
    Shiboken::Module::AddTypeCreationFunction(module, "KLed", init_KLed);
    Shiboken::Module::AddTypeCreationFunction(module, "KJobWidgets", init_KWidgetsAddonsKJobWidgets);
    Shiboken::Module::AddTypeCreationFunction(module, "KGuiItem", init_KGuiItem);
    Shiboken::Module::AddTypeCreationFunction(module, "KGradientSelector", init_KGradientSelector);
    Shiboken::Module::AddTypeCreationFunction(module, "KFontSizeAction", init_KFontSizeAction);
    Shiboken::Module::AddTypeCreationFunction(module, "KFontRequester", init_KFontRequester);
    Shiboken::Module::AddTypeCreationFunction(module, "KFontChooserDialog", init_KFontChooserDialog);
    Shiboken::Module::AddTypeCreationFunction(module, "KFontChooser", init_KFontChooser);
    Shiboken::Module::AddTypeCreationFunction(module, "KFontAction", init_KFontAction);
    Shiboken::Module::AddTypeCreationFunction(module, "KEditListWidget", init_KEditListWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "KDualAction", init_KDualAction);
    Shiboken::Module::AddTypeCreationFunction(module, "KDragWidgetDecoratorBase", init_KDragWidgetDecoratorBase);
    Shiboken::Module::AddTypeCreationFunction(module, "KDateTimeEdit", init_KDateTimeEdit);
    Shiboken::Module::AddTypeCreationFunction(module, "KDatePickerPopup", init_KDatePickerPopup);
    Shiboken::Module::AddTypeCreationFunction(module, "KDatePicker", init_KDatePicker);
    Shiboken::Module::AddTypeCreationFunction(module, "KDateComboBox", init_KDateComboBox);
    Shiboken::Module::AddTypeCreationFunction(module, "KCursor", init_KCursor);
    Shiboken::Module::AddTypeCreationFunction(module, "KContextualHelpButton", init_KContextualHelpButton);
    Shiboken::Module::AddTypeCreationFunction(module, "KColumnResizer", init_KColumnResizer);
    Shiboken::Module::AddTypeCreationFunction(module, "KColorCombo", init_KColorCombo);
    Shiboken::Module::AddTypeCreationFunction(module, "KColorButton", init_KColorButton);
    Shiboken::Module::AddTypeCreationFunction(module, "KCollapsibleGroupBox", init_KCollapsibleGroupBox);
    Shiboken::Module::AddTypeCreationFunction(module, "KCharSelect", init_KCharSelect);
    Shiboken::Module::AddTypeCreationFunction(module, "KCapacityBar", init_KCapacityBar);
    Shiboken::Module::AddTypeCreationFunction(module, "KBusyIndicatorWidget", init_KBusyIndicatorWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "KAssistantDialog", init_KAssistantDialog);
    Shiboken::Module::AddTypeCreationFunction(module, "KAnimatedButton", init_KAnimatedButton);
    Shiboken::Module::AddTypeCreationFunction(module, "KActionSelector", init_KActionSelector);
    Shiboken::Module::AddTypeCreationFunction(module, "KActionMenu", init_KActionMenu);
    Shiboken::Module::AddTypeCreationFunction(module, "KAcceleratorManager", init_KAcceleratorManager);

    registerOpaqueContainers_KWidgetsAddons(module);

    Shiboken::Module::registerTypes(module, SbkKWidgetsAddonsTypeStructs);
    Shiboken::Module::registerTypeConverters(module, SbkKWidgetsAddonsTypeConverters);

    initInheritance();

    if (Shiboken::Errors::occurred() != nullptr) {
        PyErr_Print();
        Py_FatalError("shiboken: can't initialize module KWidgetsAddons");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

#if PYSIDE6_COMOPT_COMPRESS == 0
    FinishSignatureInitialization(module, KWidgetsAddons_SignatureStrings);
#else
    if (FinishSignatureInitBytes(module, KWidgetsAddons_SignatureBytes, KWidgetsAddons_SignatureByteSize) < 0)
        return -1;
#endif

    return 0;
}
} // extern "C"

static PyModuleDef_Slot KWidgetsAddonsModuleSlots[] = {
    {Py_mod_exec, reinterpret_cast<void *>(exec_KWidgetsAddons)},
#if !defined(PYPY_VERSION) && ((!defined(Py_LIMITED_API) && PY_VERSION_HEX >= 0x030C0000) || (defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030C0000))
    {Py_mod_multiple_interpreters, Py_MOD_MULTIPLE_INTERPRETERS_NOT_SUPPORTED},
#endif
#ifdef Py_GIL_DISABLED
    {Py_mod_gil, Py_MOD_GIL_USED},
#endif
    {0, nullptr}
};

static struct PyModuleDef KWidgetsAddonsModuleDef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "KWidgetsAddons",
    /* m_doc      */ nullptr,
    /* m_size     */ 0,
    /* m_methods  */ KWidgetsAddonsMethods,
    /* m_slots    */ KWidgetsAddonsModuleSlots,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

extern "C" LIBSHIBOKEN_EXPORT PyObject *PyInit_KWidgetsAddons()
{
    Shiboken::init();

    // Create an array of wrapper types/names for the current module.
    static Shiboken::Module::TypeInitStruct cppApi[] = {
        {nullptr, "+++ unknown entry #0 in KWidgetsAddons"},
        {nullptr, "KWidgetsAddons.KAcceleratorManager"},
        {nullptr, "KWidgetsAddons.KActionMenu"},
        {nullptr, "KWidgetsAddons.KActionSelector"},
        {nullptr, "KWidgetsAddons.KActionSelector.InsertionPolicy"},
        {nullptr, "KWidgetsAddons.KActionSelector.MoveButton"},
        {nullptr, "KWidgetsAddons.KAnimatedButton"},
        {nullptr, "KWidgetsAddons.KAssistantDialog"},
        {nullptr, "KWidgetsAddons.KBusyIndicatorWidget"},
        {nullptr, "KWidgetsAddons.KCapacityBar"},
        {nullptr, "KWidgetsAddons.KCapacityBar.DrawTextMode"},
        {nullptr, "KWidgetsAddons.KCharSelect"},
        {nullptr, "KWidgetsAddons.KCharSelect.Control"},
        {nullptr, "KWidgetsAddons.KCollapsibleGroupBox"},
        {nullptr, "KWidgetsAddons.KColorButton"},
        {nullptr, "KWidgetsAddons.KColorCombo"},
        {nullptr, "KWidgetsAddons.KColumnResizer"},
        {nullptr, "KWidgetsAddons.KContextualHelpButton"},
        {nullptr, "KWidgetsAddons.KCursor"},
        {nullptr, "KWidgetsAddons.KDateComboBox"},
        {nullptr, "KWidgetsAddons.KDateComboBox.Option"},
        {nullptr, "KWidgetsAddons.KDatePicker"},
        {nullptr, "KWidgetsAddons.KDatePickerPopup"},
        {nullptr, "KWidgetsAddons.KDatePickerPopup.Mode"},
        {nullptr, "KWidgetsAddons.KDateTimeEdit"},
        {nullptr, "KWidgetsAddons.KDateTimeEdit.Option"},
        {nullptr, "KWidgetsAddons.KDragWidgetDecoratorBase"},
        {nullptr, "KWidgetsAddons.KDualAction"},
        {nullptr, "KWidgetsAddons.KEditListWidget"},
        {nullptr, "KWidgetsAddons.KEditListWidget.Button"},
        {nullptr, "KWidgetsAddons.KFontAction"},
        {nullptr, "KWidgetsAddons.KFontChooser"},
        {nullptr, "KWidgetsAddons.KFontChooser.DisplayFlag"},
        {nullptr, "KWidgetsAddons.KFontChooser.FontColumn"},
        {nullptr, "KWidgetsAddons.KFontChooser.FontDiff"},
        {nullptr, "KWidgetsAddons.KFontChooser.FontListCriteria"},
        {nullptr, "KWidgetsAddons.KFontChooserDialog"},
        {nullptr, "KWidgetsAddons.KFontRequester"},
        {nullptr, "KWidgetsAddons.KFontSizeAction"},
        {nullptr, "KWidgetsAddons.KGradientSelector"},
        {nullptr, "KWidgetsAddons.KGuiItem"},
        {nullptr, "KWidgetsAddons.KJobWidgets"},
        {nullptr, "KWidgetsAddons.KLed"},
        {nullptr, "KWidgetsAddons.KLed.Look"},
        {nullptr, "KWidgetsAddons.KLed.Shape"},
        {nullptr, "KWidgetsAddons.KLed.State"},
        {nullptr, "KWidgetsAddons.KLineEditEventHandler"},
        {nullptr, "KWidgetsAddons.KLineEditUrlDropEventFilter"},
        {nullptr, "KWidgetsAddons.KMessageBox"},
        {nullptr, "KWidgetsAddons.KMessageBox.ButtonCode"},
        {nullptr, "KWidgetsAddons.KMessageBox.DialogType"},
        {nullptr, "KWidgetsAddons.KMessageBox.Option"},
        {nullptr, "KWidgetsAddons.KMessageBoxNotifyInterface"},
        {nullptr, "KWidgetsAddons.KMessageDialog"},
        {nullptr, "KWidgetsAddons.KMessageDialog.ButtonType"},
        {nullptr, "KWidgetsAddons.KMessageDialog.Type"},
        {nullptr, "KWidgetsAddons.KMessageWidget"},
        {nullptr, "KWidgetsAddons.KMessageWidget.MessageType"},
        {nullptr, "KWidgetsAddons.KMessageWidget.Position"},
        {nullptr, "KWidgetsAddons.KMimeTypeChooser"},
        {nullptr, "KWidgetsAddons.KMimeTypeChooser.Visuals"},
        {nullptr, "KWidgetsAddons.KMimeTypeChooserDialog"},
        {nullptr, "KWidgetsAddons.KMimeTypeEditor"},
        {nullptr, "KWidgetsAddons.KMultiTabBar"},
        {nullptr, "KWidgetsAddons.KMultiTabBar.KMultiTabBarPosition"},
        {nullptr, "KWidgetsAddons.KMultiTabBar.KMultiTabBarStyle"},
        {nullptr, "KWidgetsAddons.KMultiTabBarButton"},
        {nullptr, "KWidgetsAddons.KMultiTabBarTab"},
        {nullptr, "KWidgetsAddons.KNewPasswordDialog"},
        {nullptr, "KWidgetsAddons.KNewPasswordWidget"},
        {nullptr, "KWidgetsAddons.KNewPasswordWidget.PasswordStatus"},
        {nullptr, "KWidgetsAddons.KNewPasswordWidget.RevealPasswordMode"},
        {nullptr, "KWidgetsAddons.KPageDialog"},
        {nullptr, "KWidgetsAddons.KPageDialog.FaceType"},
        {nullptr, "KWidgetsAddons.KPageModel"},
        {nullptr, "KWidgetsAddons.KPageModel.Role"},
        {nullptr, "KWidgetsAddons.KPageView"},
        {nullptr, "KWidgetsAddons.KPageView.FaceType"},
        {nullptr, "KWidgetsAddons.KPageWidget"},
        {nullptr, "KWidgetsAddons.KPageWidgetItem"},
        {nullptr, "KWidgetsAddons.KPageWidgetModel"},
        {nullptr, "KWidgetsAddons.KPassword"},
        {nullptr, "KWidgetsAddons.KPassword.RevealMode"},
        {nullptr, "KWidgetsAddons.KPasswordDialog"},
        {nullptr, "KWidgetsAddons.KPasswordDialog.ErrorType"},
        {nullptr, "KWidgetsAddons.KPasswordDialog.KPasswordDialogFlag"},
        {nullptr, "KWidgetsAddons.KPasswordLineEdit"},
        {nullptr, "KWidgetsAddons.KPixmapRegionSelectorDialog"},
        {nullptr, "KWidgetsAddons.KPixmapRegionSelectorWidget"},
        {nullptr, "KWidgetsAddons.KPixmapRegionSelectorWidget.RotateDirection"},
        {nullptr, "KWidgetsAddons.KPixmapSequence"},
        {nullptr, "KWidgetsAddons.KPixmapSequenceOverlayPainter"},
        {nullptr, "KWidgetsAddons.KPixmapSequenceWidget"},
        {nullptr, "KWidgetsAddons.KPopupFrame"},
        {nullptr, "KWidgetsAddons.KRatingPainter"},
        {nullptr, "KWidgetsAddons.KRatingWidget"},
        {nullptr, "KWidgetsAddons.KRecentFilesMenu"},
        {nullptr, "KWidgetsAddons.KRuler"},
        {nullptr, "KWidgetsAddons.KRuler.MetricStyle"},
        {nullptr, "KWidgetsAddons.KSelectAction"},
        {nullptr, "KWidgetsAddons.KSelectAction.ToolBarMode"},
        {nullptr, "KWidgetsAddons.KSelector"},
        {nullptr, "KWidgetsAddons.KSeparator"},
        {nullptr, "KWidgetsAddons.KSplitterCollapserButton"},
        {nullptr, "KWidgetsAddons.KSqueezedTextLabel"},
        {nullptr, "KWidgetsAddons.KStandardGuiItem"},
        {nullptr, "KWidgetsAddons.KStandardGuiItem.BidiMode"},
        {nullptr, "KWidgetsAddons.KStandardGuiItem.StandardItem"},
        {nullptr, "KWidgetsAddons.KStyleExtensions"},
        {nullptr, "KWidgetsAddons.KTimeComboBox"},
        {nullptr, "KWidgetsAddons.KTimeComboBox.Option"},
        {nullptr, "KWidgetsAddons.KTitleWidget"},
        {nullptr, "KWidgetsAddons.KTitleWidget.ImageAlignment"},
        {nullptr, "KWidgetsAddons.KTitleWidget.MessageType"},
        {nullptr, "KWidgetsAddons.KToggleAction"},
        {nullptr, "KWidgetsAddons.KToggleFullScreenAction"},
        {nullptr, "KWidgetsAddons.KToolBarLabelAction"},
        {nullptr, "KWidgetsAddons.KToolBarPopupAction"},
        {nullptr, "KWidgetsAddons.KToolBarPopupAction.PopupMode"},
        {nullptr, "KWidgetsAddons.KToolBarSpacerAction"},
        {nullptr, "KWidgetsAddons.KToolTipWidget"},
        {nullptr, "KWidgetsAddons.KTwoFingerSwipe"},
        {nullptr, "KWidgetsAddons.KTwoFingerSwipeRecognizer"},
        {nullptr, "KWidgetsAddons.KTwoFingerTap"},
        {nullptr, "KWidgetsAddons.KTwoFingerTapRecognizer"},
        {nullptr, "KWidgetsAddons.KUrlLabel"},
        {nullptr, "KWidgetsAddons.KViewStateSerializer"},
        {nullptr, "KWidgetsAddons.KXYSelector"},
        {nullptr, "KWidgetsAddons.KCharSelect.Controls"},
        {nullptr, "KWidgetsAddons.KDateComboBox.Options"},
        {nullptr, "KWidgetsAddons.KDatePickerPopup.Modes"},
        {nullptr, "KWidgetsAddons.KDateTimeEdit.Options"},
        {nullptr, "KWidgetsAddons.KEditListWidget.Buttons"},
        {nullptr, "KWidgetsAddons.KFontChooser.DisplayFlags"},
        {nullptr, "KWidgetsAddons.KFontChooser.FontDiffFlags"},
        {nullptr, "KWidgetsAddons.KMessageBox.Options"},
        {nullptr, "KWidgetsAddons.KPasswordDialog.KPasswordDialogFlags"},
        {nullptr, "KWidgetsAddons.KTimeComboBox.Options"},
        {nullptr, nullptr}
    };
    // The new global structure consisting of (type, name) pairs.
    SbkKWidgetsAddonsTypeStructs = cppApi;
    QT_WARNING_PUSH
    QT_WARNING_DISABLE_DEPRECATED
    // The backward compatible alias with upper case indexes.
    SbkKWidgetsAddonsTypes = reinterpret_cast<PyTypeObject **>(cppApi);
    QT_WARNING_POP

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_KWidgetsAddons_CONVERTERS_IDX_COUNT];
    SbkKWidgetsAddonsTypeConverters = sbkConverters;

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtWidgets"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtWidgetsTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtWidgetsTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtGui"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtGuiTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtCore"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtCoreTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    initConverters_KWidgetsAddons();
    initContainerConverters_KWidgetsAddons();

    PyObject *module = nullptr;
    if (Shiboken::isCompiled()) {
        KWidgetsAddonsModuleDef.m_size = -1;
        KWidgetsAddonsModuleDef.m_slots = nullptr;
        module = Shiboken::Module::createOnly("KWidgetsAddons", &KWidgetsAddonsModuleDef);
        if (module == nullptr)
            return nullptr;
#ifdef Py_GIL_DISABLED
        PyUnstable_Module_SetGIL(module, Py_MOD_GIL_NOT_USED);
#endif
        if (exec_KWidgetsAddons(module) != 0)
            return nullptr;
    } else {
        module = PyModuleDef_Init(&KWidgetsAddonsModuleDef);
    }
    return module;
}

