
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kdatepicker_wrapper.h"

// Wrappers providing overrides
#include "kurllabel_wrapper.h"
#include "kxyselector_wrapper.h"

// Argument includes
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatetime.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KDatePicker_Type = nullptr;
static PyTypeObject *Sbk_KDatePicker_TypeF(void)
{
    return _Sbk_KDatePicker_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KDatePickerWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KDatePickerWrapper::KDatePickerWrapper(::QWidget * parent) : KDatePicker(parent)
{
}

KDatePickerWrapper::KDatePickerWrapper(const ::QDate & dt, ::QWidget * parent) : KDatePicker(dt, parent)
{
}

void KDatePickerWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDatePicker::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KDatePicker", funcName, gil, pyOverride, signal);
}

void KDatePickerWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KDatePicker", funcName, gil, pyOverride, event);
}

int KDatePickerWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KDatePicker", funcName, gil, pyOverride);
}

void KDatePickerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KDatePicker", funcName, gil, pyOverride, signal);
}

void KDatePickerWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KDatePicker", funcName, gil, pyOverride, event);
}

bool KDatePickerWrapper::event(::QEvent * e)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFrame::event(e);
    }
    return KXYSelectorWrapper::sbk_o_event("KDatePicker", funcName, gil, pyOverride, e);
}

bool KDatePickerWrapper::eventFilter(::QObject * o, ::QEvent * e)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDatePicker::eventFilter(o, e);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KDatePicker", funcName, gil, pyOverride, o, e);
}

void KDatePickerWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KDatePicker", funcName, gil, pyOverride, event);
}

bool KDatePickerWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KDatePicker", funcName, gil, pyOverride, next);
}

void KDatePickerWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KDatePicker", funcName, gil, pyOverride, event);
}

bool KDatePickerWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KDatePicker", funcName, gil, pyOverride);
}

int KDatePickerWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KDatePicker", funcName, gil, pyOverride, arg__1);
}

void KDatePickerWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KDatePicker", funcName, gil, pyOverride, painter);
}

void KDatePickerWrapper::initStyleOption(::QStyleOptionFrame * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFrame::initStyleOption(option);
    }
    KUrlLabelWrapper::sbk_o_initStyleOption("KDatePicker", funcName, gil, pyOverride, option);
}

void KDatePickerWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KDatePicker", funcName, gil, pyOverride, event);
}

::QVariant KDatePickerWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KDatePicker", funcName, gil, pyOverride, arg__1);
}

void KDatePickerWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KDatePicker", funcName, gil, pyOverride, event);
}

int KDatePickerWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KDatePicker", funcName, gil, pyOverride, arg__1);
}

::QSize KDatePickerWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KDatePicker", funcName, gil, pyOverride);
}

void KDatePickerWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KDatePicker", funcName, gil, pyOverride, event);
}

bool KDatePickerWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KDatePicker", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KDatePickerWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KDatePicker", funcName, gil, pyOverride);
}

void KDatePickerWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFrame::paintEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KDatePicker", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * KDatePickerWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KDatePicker", funcName, gil, pyOverride, offset);
}

void KDatePickerWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDatePicker::resizeEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KDatePicker", funcName, gil, pyOverride, arg__1);
}

void KDatePickerWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KDatePicker", funcName, gil, pyOverride, visible);
}

::QPainter * KDatePickerWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KDatePicker", funcName, gil, pyOverride);
}

void KDatePickerWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KDatePicker", funcName, gil, pyOverride, event);
}

::QSize KDatePickerWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDatePicker::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KDatePicker", funcName, gil, pyOverride);
}

void KDatePickerWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KDatePicker", funcName, gil, pyOverride, event);
}

void KDatePickerWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDatePicker_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KDatePicker", funcName, gil, pyOverride, event);
}

const QMetaObject *KDatePickerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KDatePicker::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KDatePickerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KDatePicker::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KDatePickerWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KDatePickerWrapper *>(this));
    }
    return KDatePicker::qt_metacast(_clname);
}

KDatePickerWrapper::~KDatePickerWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KDatePicker_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KDatePicker_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KDatePicker >()))
        return -1;

    KDatePickerWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KDatePicker", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KDatePicker::KDatePicker(QWidget*=)
    // 1: KDatePicker::KDatePicker(QDate,QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KDatePicker(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KDatePicker(QDate,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 1; // KDatePicker(QDate,QWidget*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KDatePicker(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KDatePicker(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KDatePicker(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KDatePickerWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KDatePickerWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KDatePicker(const QDate &dt, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDate cppArg0_local;
            ::QDate *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KDatePicker(QDate,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KDatePickerWrapper(*cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KDatePickerWrapper(*cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KDatePicker >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KDatePickerFunc_changeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::changeEvent(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArg)))) {
        overloadId = 0; // changeEvent(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "changeEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // changeEvent(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDatePicker::changeEvent(cppArg0)
                : cppSelf->changeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_date(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // date()const
        const QDate & cppResult = const_cast<const ::KDatePicker *>(cppSelf)->date();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDatePickerFunc_dateChangedSlot(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDatePicker::dateChangedSlot(QDate)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArg)))) {
        overloadId = 0; // dateChangedSlot(QDate)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "dateChangedSlot", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // dateChangedSlot(QDate)
            cppSelf->dateChangedSlot(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDatePicker::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDatePickerFunc_fontSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // fontSize()const
        int cppResult = const_cast<const ::KDatePicker *>(cppSelf)->fontSize();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDatePickerFunc_hasCloseButton(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // hasCloseButton()const
        bool cppResult = const_cast<const ::KDatePicker *>(cppSelf)->hasCloseButton();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDatePickerFunc_lineEnterPressed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // lineEnterPressed()
        cppSelf->lineEnterPressed();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_monthBackwardClicked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // monthBackwardClicked()
        cppSelf->monthBackwardClicked();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_monthForwardClicked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // monthForwardClicked()
        cppSelf->monthForwardClicked();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDatePicker::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_selectMonthClicked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // selectMonthClicked()
        cppSelf->selectMonthClicked();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_selectYearClicked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // selectYearClicked()
        cppSelf->selectYearClicked();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_setCloseButton(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDatePicker::setCloseButton(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setCloseButton(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCloseButton", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCloseButton(bool)
            cppSelf->setCloseButton(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_setDate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDatePicker::setDate(QDate)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArg)))) {
        overloadId = 0; // setDate(QDate)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setDate(QDate)
            bool cppResult = cppSelf->setDate(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDatePickerFunc_setDateRange(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setDateRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setDateRange", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KDatePicker::setDateRange(QDate,const QDate&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setDateRange(QDate,QDate)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[1])))) {
            overloadId = 0; // setDateRange(QDate,QDate)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setDateRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxDate", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setDateRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QDate cppArg1_local = QDate();
        ::QDate *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
            if (pythonToCpp[1].isValue())
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDateRange(QDate,QDate)
            cppSelf->setDateRange(*cppArg0, *cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_setFontSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDatePicker::setFontSize(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setFontSize(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFontSize", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFontSize(int)
            cppSelf->setFontSize(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const ::KDatePicker *>(cppSelf)->::KDatePicker::sizeHint()
            : const_cast<const ::KDatePicker *>(cppSelf)->sizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDatePickerFunc_tableClickedSlot(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tableClickedSlot()
        cppSelf->tableClickedSlot();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_todayButtonClicked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // todayButtonClicked()
        cppSelf->todayButtonClicked();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_uncheckYearSelector(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // uncheckYearSelector()
        cppSelf->uncheckYearSelector();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_weekSelected(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDatePicker::weekSelected(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // weekSelected(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "weekSelected", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // weekSelected(int)
            cppSelf->weekSelected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_yearBackwardClicked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // yearBackwardClicked()
        cppSelf->yearBackwardClicked();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDatePickerFunc_yearForwardClicked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // yearForwardClicked()
        cppSelf->yearForwardClicked();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KDatePicker_PropertyStrings[] = {
    "closeButton:hasCloseButton:",
    "date::",
    "fontSize::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KDatePicker_methods[] = {
    {"changeEvent", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_changeEvent), METH_O, nullptr},
    {"date", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_date), METH_NOARGS, nullptr},
    {"dateChangedSlot", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_dateChangedSlot), METH_O, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_eventFilter), METH_VARARGS, nullptr},
    {"fontSize", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_fontSize), METH_NOARGS, nullptr},
    {"hasCloseButton", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_hasCloseButton), METH_NOARGS, nullptr},
    {"lineEnterPressed", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_lineEnterPressed), METH_NOARGS, nullptr},
    {"monthBackwardClicked", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_monthBackwardClicked), METH_NOARGS, nullptr},
    {"monthForwardClicked", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_monthForwardClicked), METH_NOARGS, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_resizeEvent), METH_O, nullptr},
    {"selectMonthClicked", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_selectMonthClicked), METH_NOARGS, nullptr},
    {"selectYearClicked", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_selectYearClicked), METH_NOARGS, nullptr},
    {"setCloseButton", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_setCloseButton), METH_O, nullptr},
    {"setDate", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_setDate), METH_O, nullptr},
    {"setDateRange", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_setDateRange), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setFontSize", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_setFontSize), METH_O, nullptr},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_sizeHint), METH_NOARGS, nullptr},
    {"tableClickedSlot", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_tableClickedSlot), METH_NOARGS, nullptr},
    {"todayButtonClicked", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_todayButtonClicked), METH_NOARGS, nullptr},
    {"uncheckYearSelector", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_uncheckYearSelector), METH_NOARGS, nullptr},
    {"weekSelected", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_weekSelected), METH_O, nullptr},
    {"yearBackwardClicked", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_yearBackwardClicked), METH_NOARGS, nullptr},
    {"yearForwardClicked", reinterpret_cast<PyCFunction>(Sbk_KDatePickerFunc_yearForwardClicked), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KDatePicker_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KDatePicker *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KDatePickerWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KDatePicker_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KDatePicker_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KDatePickerSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KDatePicker *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX]))
        return static_cast< ::QFrame *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KDatePicker_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KDatePicker_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KDatePicker_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KDatePicker_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KDatePicker_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KDatePicker_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KDatePicker_spec = {
    "1:KWidgetsAddons.KDatePicker",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KDatePicker_slots
};

} //extern "C"

static void *Sbk_KDatePicker_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KDatePicker *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KDatePicker *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KDatePicker *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KDatePicker_PythonToCpp_KDatePicker_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KDatePicker_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KDatePicker_PythonToCpp_KDatePicker_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KDatePicker_TypeF()))
        return KDatePicker_PythonToCpp_KDatePicker_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KDatePicker_PTR_CppToPython_KDatePicker(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KDatePicker *>(const_cast<void *>(cppIn)), Sbk_KDatePicker_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KDatePicker_SignatureStrings[] = {
    "1:KWidgetsAddons.KDatePicker(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,date:QDate=None,closeButton:bool=None,fontSize:int=None)",
    "0:KWidgetsAddons.KDatePicker(self,dt:PySide6.QtCore.QDate,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,date:QDate=None,closeButton:bool=None,fontSize:int=None)",
    "KWidgetsAddons.KDatePicker.changeEvent(self,event:PySide6.QtCore.QEvent)",
    "KWidgetsAddons.KDatePicker.date(self)->PySide6.QtCore.QDate",
    "KWidgetsAddons.KDatePicker.dateChangedSlot(self,date:PySide6.QtCore.QDate)",
    "KWidgetsAddons.KDatePicker.eventFilter(self,o:PySide6.QtCore.QObject,e:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KDatePicker.fontSize(self)->int",
    "KWidgetsAddons.KDatePicker.hasCloseButton(self)->bool",
    "KWidgetsAddons.KDatePicker.lineEnterPressed(self)",
    "KWidgetsAddons.KDatePicker.monthBackwardClicked(self)",
    "KWidgetsAddons.KDatePicker.monthForwardClicked(self)",
    "KWidgetsAddons.KDatePicker.resizeEvent(self,arg__1:PySide6.QtGui.QResizeEvent)",
    "KWidgetsAddons.KDatePicker.selectMonthClicked(self)",
    "KWidgetsAddons.KDatePicker.selectYearClicked(self)",
    "KWidgetsAddons.KDatePicker.setCloseButton(self,enable:bool)",
    "KWidgetsAddons.KDatePicker.setDate(self,date:PySide6.QtCore.QDate)->bool",
    "KWidgetsAddons.KDatePicker.setDateRange(self,minDate:PySide6.QtCore.QDate,maxDate:PySide6.QtCore.QDate=QDate())",
    "KWidgetsAddons.KDatePicker.setFontSize(self,arg__1:int)",
    "KWidgetsAddons.KDatePicker.sizeHint(self)->PySide6.QtCore.QSize",
    "KWidgetsAddons.KDatePicker.tableClickedSlot(self)",
    "KWidgetsAddons.KDatePicker.todayButtonClicked(self)",
    "KWidgetsAddons.KDatePicker.uncheckYearSelector(self)",
    "KWidgetsAddons.KDatePicker.weekSelected(self,arg__1:int)",
    "KWidgetsAddons.KDatePicker.yearBackwardClicked(self)",
    "KWidgetsAddons.KDatePicker.yearForwardClicked(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KDatePicker_SignatureByteSize = 430;
static constexpr uint8_t KDatePicker_SignatureBytes[430] = {
    0x78, 0xda, 0xc5, 0x93, 0x5f, 0x4f, 0xc2, 0x30, 0x14, 0xc5, 0xdf, 0xfd, 0x24, 0x60, 0xc6, 0x22,
    0x2f, 0x3e, 0x2c, 0x81, 0x44, 0x06, 0x68, 0x42, 0x14, 0xc6, 0x1e, 0x8c, 0x4f, 0xa4, 0xac, 0x17,
    0xa8, 0x2b, 0x2d, 0xe9, 0x0a, 0x38, 0x3f, 0xbd, 0xfd, 0xb3, 0x09, 0xea, 0xd6, 0xc1, 0x93, 0x2f,
    0x04, 0x4a, 0xcf, 0xb9, 0xbf, 0x7b, 0xcf, 0x6d, 0x37, 0x98, 0xbc, 0x12, 0xbc, 0x06, 0x99, 0x3d,
    0x60, 0xcc, 0x59, 0xe6, 0x4f, 0x86, 0x48, 0xc2, 0x8c, 0x24, 0x29, 0x88, 0x56, 0x06, 0x74, 0xe5,
    0xed, 0x90, 0x00, 0x26, 0x83, 0x59, 0x1e, 0x13, 0x0c, 0xf7, 0x7e, 0x24, 0x8b, 0xfb, 0x7e, 0x64,
    0xbf, 0xf4, 0xd8, 0x9e, 0xd2, 0x9d, 0x14, 0xde, 0x6d, 0x30, 0x81, 0xfc, 0xc8, 0x05, 0x9e, 0x32,
    0x9a, 0xf7, 0x5e, 0x38, 0x03, 0x0f, 0x2b, 0xaf, 0x20, 0xd2, 0x8e, 0xf6, 0x77, 0x42, 0x79, 0x06,
    0x83, 0xbd, 0x94, 0x9c, 0x05, 0x4b, 0xce, 0xa9, 0x3d, 0x5d, 0x71, 0x26, 0x63, 0xf2, 0x09, 0x01,
    0x61, 0xd2, 0x9c, 0xb4, 0x6f, 0xee, 0x1a, 0xb1, 0xf0, 0x39, 0x52, 0xc8, 0x05, 0xf8, 0xa6, 0xce,
    0xff, 0xe0, 0xd6, 0xc3, 0xfa, 0xc9, 0x06, 0xb1, 0x35, 0x8c, 0x0e, 0x0a, 0xca, 0x82, 0xc3, 0xe1,
    0x27, 0x9f, 0x65, 0x37, 0x17, 0x9c, 0x46, 0x1a, 0xce, 0x38, 0xb4, 0x3b, 0xfd, 0xaa, 0xce, 0x9b,
    0xb4, 0xa1, 0x01, 0xc1, 0x31, 0xe5, 0x05, 0x88, 0xe9, 0xb6, 0xca, 0xc9, 0x89, 0x61, 0xf0, 0xc7,
    0x84, 0xca, 0x32, 0x08, 0xfe, 0xc7, 0x63, 0xba, 0x7c, 0x87, 0x44, 0x7a, 0x50, 0xd3, 0x64, 0xa7,
    0xaf, 0x67, 0xe9, 0xaa, 0x51, 0x4e, 0xb8, 0x6c, 0x57, 0x0d, 0xda, 0x75, 0x7d, 0x83, 0xb2, 0xf0,
    0x94, 0x54, 0x29, 0x6a, 0x2a, 0x42, 0x09, 0x83, 0x11, 0x53, 0x6d, 0xcc, 0x04, 0x64, 0x19, 0x60,
    0xab, 0x73, 0x29, 0xb6, 0x0a, 0x6b, 0x33, 0x40, 0x49, 0x7a, 0x44, 0x02, 0x87, 0x54, 0x1f, 0x5e,
    0xaa, 0x1a, 0x73, 0x71, 0x95, 0x48, 0x21, 0xa9, 0xfe, 0xcf, 0xb6, 0x06, 0x89, 0xf5, 0x62, 0xd1,
    0x3d, 0x9b, 0xe8, 0xe3, 0x9e, 0xf8, 0xd1, 0xfc, 0x74, 0xcd, 0x69, 0xa7, 0x2c, 0x54, 0x22, 0xcf,
    0x9a, 0xe4, 0x62, 0x04, 0xab, 0x79, 0x03, 0x24, 0xae, 0x90, 0xc8, 0xdf, 0x41, 0x78, 0xc0, 0xd0,
    0x92, 0x82, 0x79, 0x3e, 0x4d, 0xda, 0x61, 0xb9, 0xe1, 0x8e, 0xd5, 0x6c, 0xce, 0xb5, 0x30, 0x9a,
    0xeb, 0x6d, 0xb7, 0x6e, 0x5b, 0xc2, 0x86, 0x75, 0x86, 0xde, 0x16, 0x7d, 0xd4, 0xfe, 0xd9, 0x33,
    0x9f, 0xad, 0x76, 0x13, 0xf8, 0xf8, 0x7c, 0x5f, 0xcb, 0xa8, 0x48, 0x53, 0x26, 0x4a, 0xf0, 0x44,
    0x8a, 0x7c, 0x2b, 0xde, 0xb4, 0x36, 0x74, 0xe9, 0xa5, 0x9e, 0x6b, 0x11, 0xcd, 0xf7, 0xa3, 0x76,
    0x56, 0x94, 0x1c, 0xa3, 0xdc, 0x66, 0x73, 0x71, 0xa4, 0x7b, 0x96, 0x6c, 0x20, 0x49, 0xf5, 0x1a,
    0xc4, 0x66, 0x21, 0xb8, 0x68, 0x16, 0x1d, 0x01, 0x52, 0x7b, 0xbb, 0x28, 0x71, 0xe9, 0x4c, 0x72,
    0x55, 0xe6, 0xea, 0x07, 0xa6, 0x45, 0x95, 0xef, 0xeb, 0x0b, 0x9c, 0x76, 0x7e, 0x6b
};
#endif

PyTypeObject *init_KDatePicker(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX].type;

    Shiboken::AutoDecRef Sbk_KDatePicker_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX]))));

    _Sbk_KDatePicker_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KDatePicker",
        "KDatePicker*",
        &Sbk_KDatePicker_spec,
        &Shiboken::callCppDestructor< KDatePicker >,
        Sbk_KDatePicker_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KDatePicker_Type; // references _Sbk_KDatePicker_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KDatePicker_SignatureStrings);
#else
    InitSignatureBytes(pyType, KDatePicker_SignatureBytes, KDatePicker_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KDatePicker_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KDatePicker_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KDatePicker_PythonToCpp_KDatePicker_PTR,
        is_KDatePicker_PythonToCpp_KDatePicker_PTR_Convertible,
        KDatePicker_PTR_CppToPython_KDatePicker);

    Shiboken::Conversions::registerConverterName(converter, "KDatePicker");
    Shiboken::Conversions::registerConverterName(converter, "KDatePicker*");
    Shiboken::Conversions::registerConverterName(converter, "KDatePicker&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KDatePicker).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KDatePickerWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KDatePicker_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KDatePicker_TypeF(), &Sbk_KDatePickerSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KDatePicker_TypeF(), &Sbk_KDatePicker_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KDatePicker::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KDatePicker::staticMetaObject, sizeof(KDatePickerWrapper));

    return pyType;
}
