

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GModule.Flags
    ( 

 -- * Flags


-- ** ModuleFlags #flag:ModuleFlags#

    ModuleFlags(..)                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Flags ModuleFlags
-- | Flags passed to @/g_module_open()/@.
-- Note that these flags are not supported on all platforms.
data ModuleFlags = 
      ModuleFlagsLazy
    -- ^ specifies that symbols are only resolved when
    --     needed. The default action is to bind all symbols when the module
    --     is loaded.
    | ModuleFlagsLocal
    -- ^ specifies that symbols in the module should
    --     not be added to the global name space. The default action on most
    --     platforms is to place symbols in the module in the global name space,
    --     which may cause conflicts with existing symbols.
    | ModuleFlagsMask
    -- ^ mask for all flags.
    | AnotherModuleFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ModuleFlags where
    fromEnum ModuleFlagsLazy = 1
    fromEnum ModuleFlagsLocal = 2
    fromEnum ModuleFlagsMask = 3
    fromEnum (AnotherModuleFlags k) = k

    toEnum 1 = ModuleFlagsLazy
    toEnum 2 = ModuleFlagsLocal
    toEnum 3 = ModuleFlagsMask
    toEnum k = AnotherModuleFlags k

instance P.Ord ModuleFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

instance IsGFlag ModuleFlags


