static const char* weighted_blend_cl_source =
"__kernel void cl_copy_weigthed_blend(__global const float4 *in,               \n"
"                                     __global       float4 *out)              \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v = in[gid];                                                      \n"
"  out[gid] = in_v;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"__kernel void cl_weighted_blend(__global const float4 *in,                    \n"
"                                __global const float4 *aux,                   \n"
"                                __global       float4 *out)                   \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v = in[gid];                                                      \n"
"  float4 aux_v = aux[gid];                                                    \n"
"  float4 out_v;                                                               \n"
"  float in_weight;                                                            \n"
"  float aux_weight;                                                           \n"
"  float total_alpha = in_v.w + aux_v.w;                                       \n"
"                                                                              \n"
"  total_alpha = total_alpha == 0 ? 1 : total_alpha;                           \n"
"                                                                              \n"
"  in_weight = in_v.w / total_alpha;                                           \n"
"  aux_weight = 1.0f - in_weight;                                              \n"
"                                                                              \n"
"  out_v.xyz = in_weight * in_v.xyz + aux_weight * aux_v.xyz;                  \n"
"  out_v.w = total_alpha;                                                      \n"
"  out[gid] = out_v * ((in_v.w + aux_v.w) > 0.f);                              \n"
"}                                                                             \n"
;
