/* plugin-ollama-client.h
 *
 * Copyright 2025 Christian Hergert <chergert@redhat.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <foundry.h>
#include <libsoup/soup.h>

G_BEGIN_DECLS

#define PLUGIN_TYPE_OLLAMA_CLIENT (plugin_ollama_client_get_type())

G_DECLARE_FINAL_TYPE (PluginOllamaClient, plugin_ollama_client, PLUGIN, OLLAMA_CLIENT, FoundryContextual)

PluginOllamaClient *plugin_ollama_client_new         (FoundryContext     *context,
                                                      SoupSession        *session,
                                                      const char         *url_base);
DexFuture          *plugin_ollama_client_list_models (PluginOllamaClient *self);
DexFuture          *plugin_ollama_client_post        (PluginOllamaClient *self,
                                                      const char         *path,
                                                      JsonNode           *body);

G_END_DECLS
