/* MainWindow.c generated by valac 0.56.18, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/* MainWindow.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include "font-manager.h"
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include "vala-common.h"
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_FONT_VIEWER_TYPE_MAIN_WINDOW (font_manager_font_viewer_main_window_get_type ())
#define FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_FONT_VIEWER_TYPE_MAIN_WINDOW, FontManagerFontViewerMainWindow))
#define FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_FONT_VIEWER_TYPE_MAIN_WINDOW, FontManagerFontViewerMainWindowClass))
#define FONT_MANAGER_FONT_VIEWER_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_FONT_VIEWER_TYPE_MAIN_WINDOW))
#define FONT_MANAGER_FONT_VIEWER_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_FONT_VIEWER_TYPE_MAIN_WINDOW))
#define FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_FONT_VIEWER_TYPE_MAIN_WINDOW, FontManagerFontViewerMainWindowClass))

typedef struct _FontManagerFontViewerMainWindow FontManagerFontViewerMainWindow;
typedef struct _FontManagerFontViewerMainWindowClass FontManagerFontViewerMainWindowClass;
typedef struct _FontManagerFontViewerMainWindowPrivate FontManagerFontViewerMainWindowPrivate;
typedef enum  {
	FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_NOT_INSTALLED,
	FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_INSTALLED,
	FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_SYSTEM_FONT,
	FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_WOULD_DOWNGRADE,
	FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_WOULD_UPGRADE
} FontManagerFontViewerMainWindowFileStatus;

#define FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_TYPE_FILE_STATUS (font_manager_font_viewer_main_window_file_status_get_type ())
enum  {
	FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_0_PROPERTY,
	FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_PREDEFINED_SIZE_PROPERTY,
	FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_SHOW_LINE_SIZE_PROPERTY,
	FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* font_manager_font_viewer_main_window_properties[FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerFontViewerMainWindow {
	FontManagerApplicationWindow parent_instance;
	FontManagerFontViewerMainWindowPrivate * priv;
};

struct _FontManagerFontViewerMainWindowClass {
	FontManagerApplicationWindowClass parent_class;
};

struct _FontManagerFontViewerMainWindowPrivate {
	gint _predefined_size;
	gboolean _show_line_size;
	GtkLabel* title_label;
	GtkDropDown* title_widget;
	GtkStack* stack;
	GtkButton* action_button;
	GtkToggleButton* preference_toggle;
	GtkListBox* preference_list;
	FontManagerPreviewPane* preview_pane;
	FontManagerFontViewerMainWindowFileStatus file_status;
	GList* installed_files;
	GdkRectangle clicked_area;
	GtkSwitch* prefer_dark_theme;
	GtkSwitch* use_adwaita_stylesheet;
	FontManagerPreviewColors* preview_colors;
	FontManagerWaterfallSettings* waterfall_settings;
	FontManagerFont* font;
	FontManagerFamily* family;
	GFile* current_file;
	GFile* current_target;
};

struct _Block1Data {
	int _ref_count_;
	FontManagerFontViewerMainWindow* self;
	GtkStringList* model;
};

struct _Block2Data {
	int _ref_count_;
	FontManagerFontViewerMainWindow* self;
	GtkSpinButton* spacing;
};

static gint FontManagerFontViewerMainWindow_private_offset;
static gpointer font_manager_font_viewer_main_window_parent_class = NULL;

VALA_EXTERN GType font_manager_font_viewer_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontViewerMainWindow, g_object_unref)
static GType font_manager_font_viewer_main_window_file_status_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN FontManagerFontViewerMainWindow* font_manager_font_viewer_main_window_new (GSettings* settings);
VALA_EXTERN FontManagerFontViewerMainWindow* font_manager_font_viewer_main_window_construct (GType object_type,
                                                                                 GSettings* settings);
static gboolean font_manager_font_viewer_main_window_on_drop (FontManagerFontViewerMainWindow* self,
                                                       GValue* val,
                                                       gdouble x,
                                                       gdouble y);
static gboolean _font_manager_font_viewer_main_window_on_drop_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                                             GValue* value,
                                                                             gdouble x,
                                                                             gdouble y,
                                                                             gpointer self);
VALA_EXTERN void font_manager_font_viewer_main_window_update (FontManagerFontViewerMainWindow* self);
static void _font_manager_font_viewer_main_window_update_font_manager_preview_pane_changed (FontManagerPreviewPane* _sender,
                                                                                     gpointer self);
static void __lambda5_ (FontManagerFontViewerMainWindow* self);
static void ___lambda5__gtk_widget_realize (GtkWidget* _sender,
                                     gpointer self);
static void font_manager_font_viewer_main_window_on_show_context_menu (FontManagerFontViewerMainWindow* self,
                                                                gint n_press,
                                                                gdouble x,
                                                                gdouble y);
static void _font_manager_font_viewer_main_window_on_show_context_menu_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                                           gint n_press,
                                                                                           gdouble x,
                                                                                           gdouble y,
                                                                                           gpointer self);
static void font_manager_font_viewer_main_window_update_action_button (FontManagerFontViewerMainWindow* self);
static void __lambda6_ (FontManagerFontViewerMainWindow* self);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void font_manager_font_viewer_main_window_populate_preference_list (FontManagerFontViewerMainWindow* self);
static void font_manager_font_viewer_main_window_on_variation_selected (FontManagerFontViewerMainWindow* self);
static void _font_manager_font_viewer_main_window_on_variation_selected_g_object_notify (GObject* _sender,
                                                                                  GParamSpec* pspec,
                                                                                  gpointer self);
VALA_EXTERN void font_manager_font_viewer_main_window_show_uri (FontManagerFontViewerMainWindow* self,
                                                    const gchar* uri);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 JsonArray* array,
                 guint index,
                 JsonNode* element);
static void ___lambda4__json_array_foreach (JsonArray* array,
                                     guint index_,
                                     JsonNode* element_node,
                                     gpointer self);
VALA_EXTERN void font_manager_font_viewer_main_window_open (FontManagerFontViewerMainWindow* self,
                                                GFile* file);
static FontManagerFontViewerMainWindowFileStatus font_manager_font_viewer_main_window_get_file_status (FontManagerFontViewerMainWindow* self);
static void font_manager_font_viewer_main_window_update_title_widget (FontManagerFontViewerMainWindow* self);
VALA_EXTERN void font_manager_font_viewer_main_window_on_preferences_toggled (FontManagerFontViewerMainWindow* self);
static void _font_manager_font_viewer_main_window_on_preferences_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                             gpointer self);
VALA_EXTERN void font_manager_font_viewer_main_window_on_action_button_clicked (FontManagerFontViewerMainWindow* self);
static gboolean font_manager_font_viewer_main_window_remove_directory_tree_if_empty (FontManagerFontViewerMainWindow* self,
                                                                              GFile* dir);
static void _font_manager_font_viewer_main_window_on_action_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                        gpointer self);
static void font_manager_font_viewer_main_window_bind_settings (FontManagerFontViewerMainWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda7_ (Block2Data* _data2_);
static void ___lambda7__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                gpointer self);
VALA_EXTERN gint font_manager_font_viewer_main_window_get_predefined_size (FontManagerFontViewerMainWindow* self);
VALA_EXTERN void font_manager_font_viewer_main_window_set_predefined_size (FontManagerFontViewerMainWindow* self,
                                                               gint value);
VALA_EXTERN gboolean font_manager_font_viewer_main_window_get_show_line_size (FontManagerFontViewerMainWindow* self);
VALA_EXTERN void font_manager_font_viewer_main_window_set_show_line_size (FontManagerFontViewerMainWindow* self,
                                                              gboolean value);
static void font_manager_font_viewer_main_window_finalize (GObject * obj);
static GType font_manager_font_viewer_main_window_get_type_once (void);
static void _vala_font_manager_font_viewer_main_window_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_font_manager_font_viewer_main_window_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);

static inline gpointer
font_manager_font_viewer_main_window_get_instance_private (FontManagerFontViewerMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerFontViewerMainWindow_private_offset);
}

 G_GNUC_NO_INLINE static GType
font_manager_font_viewer_main_window_file_status_get_type_once (void)
{
	static const GEnumValue values[] = {{FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_NOT_INSTALLED, "FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_NOT_INSTALLED", "not-installed"}, {FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_INSTALLED, "FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_INSTALLED", "installed"}, {FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_SYSTEM_FONT, "FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_SYSTEM_FONT", "system-font"}, {FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_WOULD_DOWNGRADE, "FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_WOULD_DOWNGRADE", "would-downgrade"}, {FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_WOULD_UPGRADE, "FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_WOULD_UPGRADE", "would-upgrade"}, {0, NULL, NULL}};
	GType font_manager_font_viewer_main_window_file_status_type_id;
	font_manager_font_viewer_main_window_file_status_type_id = g_enum_register_static ("FontManagerFontViewerMainWindowFileStatus", values);
	return font_manager_font_viewer_main_window_file_status_type_id;
}

static GType
font_manager_font_viewer_main_window_file_status_get_type (void)
{
	static volatile gsize font_manager_font_viewer_main_window_file_status_type_id__once = 0;
	if (g_once_init_enter (&font_manager_font_viewer_main_window_file_status_type_id__once)) {
		GType font_manager_font_viewer_main_window_file_status_type_id;
		font_manager_font_viewer_main_window_file_status_type_id = font_manager_font_viewer_main_window_file_status_get_type_once ();
		g_once_init_leave (&font_manager_font_viewer_main_window_file_status_type_id__once, font_manager_font_viewer_main_window_file_status_type_id);
	}
	return font_manager_font_viewer_main_window_file_status_type_id__once;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static gboolean
_font_manager_font_viewer_main_window_on_drop_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                                    GValue* value,
                                                                    gdouble x,
                                                                    gdouble y,
                                                                    gpointer self)
{
	gboolean result;
	result = font_manager_font_viewer_main_window_on_drop ((FontManagerFontViewerMainWindow*) self, value, x, y);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_font_manager_font_viewer_main_window_update_font_manager_preview_pane_changed (FontManagerPreviewPane* _sender,
                                                                                gpointer self)
{
	font_manager_font_viewer_main_window_update ((FontManagerFontViewerMainWindow*) self);
}

static void
__lambda5_ (FontManagerFontViewerMainWindow* self)
{
	FontManagerPreviewPane* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	_tmp0_ = self->priv->preview_pane;
	_tmp1_ = font_manager_get_gsettings (FONT_MANAGER_FONT_VIEWER_BUS_ID);
	_tmp2_ = _tmp1_;
	font_manager_preview_pane_restore_state (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
___lambda5__gtk_widget_realize (GtkWidget* _sender,
                                gpointer self)
{
	__lambda5_ ((FontManagerFontViewerMainWindow*) self);
}

static void
_font_manager_font_viewer_main_window_on_show_context_menu_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                                      gint n_press,
                                                                                      gdouble x,
                                                                                      gdouble y,
                                                                                      gpointer self)
{
	font_manager_font_viewer_main_window_on_show_context_menu ((FontManagerFontViewerMainWindow*) self, n_press, x, y);
}

static void
__lambda6_ (FontManagerFontViewerMainWindow* self)
{
	FontManagerWaterfallSettings* _tmp0_;
	FontManagerPreviewPane* _tmp1_;
	FontManagerWaterfallSettings* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	FontManagerWaterfallSettings* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	FontManagerWaterfallSettings* _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	_tmp0_ = self->priv->waterfall_settings;
	font_manager_waterfall_settings_on_selection_changed (_tmp0_);
	_tmp1_ = self->priv->preview_pane;
	_tmp2_ = self->priv->waterfall_settings;
	_tmp3_ = font_manager_waterfall_settings_get_minimum (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->waterfall_settings;
	_tmp6_ = font_manager_waterfall_settings_get_maximum (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->waterfall_settings;
	_tmp9_ = font_manager_waterfall_settings_get_ratio (_tmp8_);
	_tmp10_ = _tmp9_;
	font_manager_preview_pane_set_waterfall_size (_tmp1_, _tmp4_, _tmp7_, _tmp10_);
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ ((FontManagerFontViewerMainWindow*) self);
}

static void
_font_manager_font_viewer_main_window_on_variation_selected_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self)
{
	font_manager_font_viewer_main_window_on_variation_selected ((FontManagerFontViewerMainWindow*) self);
}

FontManagerFontViewerMainWindow*
font_manager_font_viewer_main_window_construct (GType object_type,
                                                GSettings* settings)
{
	FontManagerFontViewerMainWindow * self = NULL;
	FontManagerFamily* _tmp0_;
	GtkDropTarget* target = NULL;
	GtkDropTarget* _tmp1_;
	GtkStack* _tmp2_;
	GtkEventController* _tmp3_;
	GtkStack* _tmp4_;
	FontManagerPreviewPane* _tmp5_;
	GtkButton* _tmp6_;
	FontManagerPreviewPane* _tmp7_;
	FontManagerPreviewPane* _tmp8_;
	GtkGesture* right_click = NULL;
	GtkGestureClick* _tmp9_ = NULL;
	FontManagerPreviewPane* _tmp10_;
	GtkEventController* _tmp11_;
	FontManagerWaterfallSettings* _tmp12_;
	GBindingFlags flags = 0U;
	FontManagerWaterfallSettings* _tmp13_;
	FontManagerWaterfallSettings* _tmp14_;
	FontManagerPreviewPane* _tmp15_;
	FontManagerWaterfallSettings* _tmp16_;
	GtkDropDown* _tmp17_;
	GtkPopover* popup = NULL;
	GtkDropDown* _tmp18_;
	GtkWidget* _tmp19_;
	GtkPopover* _tmp20_;
	self = (FontManagerFontViewerMainWindow*) g_object_new (object_type, "settings", settings, NULL);
	_tmp0_ = font_manager_family_new ();
	_g_object_unref0 (self->priv->family);
	self->priv->family = _tmp0_;
	_tmp1_ = gtk_drop_target_new (gdk_file_list_get_type (), GDK_ACTION_COPY);
	target = _tmp1_;
	g_signal_connect_object (target, "drop", (GCallback) _font_manager_font_viewer_main_window_on_drop_gtk_drop_target_drop, self, 0);
	_tmp2_ = self->priv->stack;
	_tmp3_ = _g_object_ref0 ((GtkEventController*) target);
	gtk_widget_add_controller ((GtkWidget*) _tmp2_, _tmp3_);
	_tmp4_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp4_, "PlaceHolder");
	_tmp5_ = self->priv->preview_pane;
	_tmp6_ = self->priv->action_button;
	font_manager_preview_pane_add_action_widget (_tmp5_, (GtkWidget*) _tmp6_, GTK_PACK_END);
	_tmp7_ = self->priv->preview_pane;
	g_signal_connect_object (_tmp7_, "changed", (GCallback) _font_manager_font_viewer_main_window_update_font_manager_preview_pane_changed, self, 0);
	_tmp8_ = self->priv->preview_pane;
	g_signal_connect_object ((GtkWidget*) _tmp8_, "realize", (GCallback) ___lambda5__gtk_widget_realize, self, G_CONNECT_AFTER);
	memset (&self->priv->clicked_area, 0, sizeof (GdkRectangle));
	_tmp9_ = (GtkGestureClick*) gtk_gesture_click_new ();
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp9_, (guint) GDK_BUTTON_SECONDARY);
	right_click = (GtkGesture*) _tmp9_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (right_click, gtk_gesture_click_get_type (), GtkGestureClick), "pressed", (GCallback) _font_manager_font_viewer_main_window_on_show_context_menu_gtk_gesture_click_pressed, self, 0);
	_tmp10_ = self->priv->preview_pane;
	_tmp11_ = _g_object_ref0 ((GtkEventController*) right_click);
	gtk_widget_add_controller ((GtkWidget*) _tmp10_, _tmp11_);
	font_manager_font_viewer_main_window_update_action_button (self);
	_tmp12_ = font_manager_waterfall_settings_new (settings);
	_g_object_unref0 (self->priv->waterfall_settings);
	self->priv->waterfall_settings = _tmp12_;
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp13_ = self->priv->waterfall_settings;
	g_object_bind_property_with_closures ((GObject*) _tmp13_, "predefined-size", (GObject*) self, "predefined-size", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp14_ = self->priv->waterfall_settings;
	g_object_bind_property_with_closures ((GObject*) _tmp14_, "show-line-size", (GObject*) self, "show-line-size", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp15_ = self->priv->preview_pane;
	g_object_bind_property_with_closures ((GObject*) self, "show-line-size", (GObject*) _tmp15_, "show-line-size", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp16_ = self->priv->waterfall_settings;
	g_signal_connect_object ((GObject*) _tmp16_, "notify::predefined-size", (GCallback) ___lambda6__g_object_notify, self, G_CONNECT_AFTER);
	font_manager_font_viewer_main_window_populate_preference_list (self);
	_tmp17_ = self->priv->title_widget;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::selected", (GCallback) _font_manager_font_viewer_main_window_on_variation_selected_g_object_notify, self, 0);
	_tmp18_ = self->priv->title_widget;
	_tmp19_ = gtk_widget_get_last_child ((GtkWidget*) _tmp18_);
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_popover_get_type (), GtkPopover));
	popup = _tmp20_;
	gtk_widget_set_halign ((GtkWidget*) popup, GTK_ALIGN_CENTER);
	gtk_popover_set_has_arrow (popup, TRUE);
	_g_object_unref0 (popup);
	_g_object_unref0 (right_click);
	_g_object_unref0 (target);
	return self;
}

FontManagerFontViewerMainWindow*
font_manager_font_viewer_main_window_new (GSettings* settings)
{
	return font_manager_font_viewer_main_window_construct (FONT_MANAGER_FONT_VIEWER_TYPE_MAIN_WINDOW, settings);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FontManagerFontViewerMainWindow* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->model);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
__lambda4_ (Block1Data* _data1_,
            JsonArray* array,
            guint index,
            JsonNode* element)
{
	FontManagerFontViewerMainWindow* self;
	JsonObject* json_object = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	gchar* font_desc = NULL;
	JsonObject* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	FontManagerFamily* _tmp6_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	gchar* sample = NULL;
	JsonObject* _tmp16_;
	gchar* _tmp17_;
	JsonObject* _tmp18_;
	self = _data1_->self;
	g_return_if_fail (array != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = json_node_get_object (element);
	_tmp1_ = _json_object_ref0 (_tmp0_);
	json_object = _tmp1_;
	_tmp2_ = json_object;
	_tmp3_ = json_object_get_string_member (_tmp2_, "description");
	_tmp4_ = g_strdup (_tmp3_);
	font_desc = _tmp4_;
	_tmp6_ = self->priv->family;
	g_object_get (_tmp6_, "n-variations", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == ((gint64) 1)) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp9_;
		FontManagerFamily* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp9_ = font_desc;
		_tmp10_ = self->priv->family;
		g_object_get (_tmp10_, "family", &_tmp11_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp5_ = g_strcmp0 (_tmp9_, _tmp13_) != 0;
		_g_free0 (_tmp13_);
	}
	if (_tmp5_) {
		GtkStringList* _tmp14_;
		const gchar* _tmp15_;
		_tmp14_ = _data1_->model;
		_tmp15_ = font_desc;
		gtk_string_list_append (_tmp14_, _tmp15_);
	}
	_tmp16_ = json_object;
	_tmp17_ = font_manager_get_sample_string (_tmp16_);
	sample = _tmp17_;
	_tmp18_ = json_object;
	json_object_set_string_member (_tmp18_, "preview-text", sample);
	_g_free0 (sample);
	_g_free0 (font_desc);
	_json_object_unref0 (json_object);
}

static void
___lambda4__json_array_foreach (JsonArray* array,
                                guint index_,
                                JsonNode* element_node,
                                gpointer self)
{
	__lambda4_ (self, array, index_, element_node);
}

void
font_manager_font_viewer_main_window_show_uri (FontManagerFontViewerMainWindow* self,
                                               const gchar* uri)
{
	Block1Data* _data1_;
	GList* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	gchar* path = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	PangoContext* _tmp5_;
	JsonObject* source = NULL;
	JsonObject* _tmp12_;
	FontManagerFamily* _tmp13_;
	FontManagerFont* _tmp14_;
	FontManagerFamily* _tmp15_;
	JsonObject* _tmp16_;
	FontManagerFont* _tmp17_;
	FontManagerFamily* _tmp18_;
	JsonObject* _tmp19_;
	GtkStringList* _tmp20_;
	FontManagerFamily* _tmp21_;
	JsonArray* _tmp22_;
	JsonArray* _tmp23_;
	JsonArray* _tmp24_;
	GtkDropDown* _tmp25_;
	GtkStringList* _tmp26_;
	GtkDropDown* _tmp27_;
	FontManagerFamily* _tmp28_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	if (uri == NULL) {
		_g_object_unref0 (self->priv->family);
		self->priv->family = NULL;
		_g_object_unref0 (self->priv->font);
		self->priv->font = NULL;
		_g_object_unref0 (self->priv->current_file);
		self->priv->current_file = NULL;
		_g_object_unref0 (self->priv->current_target);
		self->priv->current_target = NULL;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp0_ = font_manager_list_available_font_files ();
	(self->priv->installed_files == NULL) ? NULL : (self->priv->installed_files = (_g_list_free__g_free0_ (self->priv->installed_files), NULL));
	self->priv->installed_files = _tmp0_;
	_tmp1_ = g_file_new_for_commandline_arg (uri);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_path (_tmp2_);
	path = _tmp3_;
	_tmp4_ = path;
	font_manager_add_application_font (_tmp4_);
	_tmp5_ = gtk_widget_get_pango_context ((GtkWidget*) self);
	font_manager_clear_pango_cache (_tmp5_);
	source = NULL;
	{
		JsonObject* _tmp6_ = NULL;
		const gchar* _tmp7_;
		JsonObject* _tmp8_;
		JsonObject* _tmp9_;
		_tmp7_ = path;
		_tmp8_ = font_manager_get_attributes_from_filepath (_tmp7_, &_inner_error0_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_json_object_unref0 (source);
		source = _tmp9_;
		_json_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("MainWindow.vala:123: %s", _tmp11_);
		_g_error_free0 (e);
		_json_object_unref0 (source);
		_g_free0 (path);
		_g_object_unref0 (file);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_json_object_unref0 (source);
		_g_free0 (path);
		_g_object_unref0 (file);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp12_ = source;
	_vala_assert (_tmp12_ != NULL, "source != null");
	_tmp13_ = font_manager_family_new ();
	_g_object_unref0 (self->priv->family);
	self->priv->family = _tmp13_;
	_tmp14_ = font_manager_font_new ();
	_g_object_unref0 (self->priv->font);
	self->priv->font = _tmp14_;
	_tmp15_ = self->priv->family;
	_tmp16_ = source;
	g_object_set (_tmp15_, "source-object", _tmp16_, NULL);
	_tmp17_ = self->priv->font;
	_tmp18_ = self->priv->family;
	_tmp19_ = font_manager_family_get_default_variant (_tmp18_);
	g_object_set (_tmp17_, "source-object", _tmp19_, NULL);
	_tmp20_ = gtk_string_list_new (NULL);
	_data1_->model = _tmp20_;
	_tmp21_ = self->priv->family;
	g_object_get (_tmp21_, "variations", &_tmp22_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_;
	json_array_foreach_element (_tmp24_, ___lambda4__json_array_foreach, _data1_);
	_json_array_unref0 (_tmp24_);
	_tmp25_ = self->priv->title_widget;
	_tmp26_ = _data1_->model;
	gtk_drop_down_set_model (_tmp25_, (GListModel*) _tmp26_);
	_tmp27_ = self->priv->title_widget;
	_tmp28_ = self->priv->family;
	gtk_drop_down_set_selected (_tmp27_, (guint) font_manager_family_get_default_index (_tmp28_));
	_json_object_unref0 (source);
	_g_free0 (path);
	_g_object_unref0 (file);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return;
}

void
font_manager_font_viewer_main_window_open (FontManagerFontViewerMainWindow* self,
                                           GFile* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	font_manager_font_viewer_main_window_show_uri (self, _tmp1_);
	_g_free0 (_tmp1_);
	return;
}

void
font_manager_font_viewer_main_window_update (FontManagerFontViewerMainWindow* self)
{
	FontManagerPreviewPane* _tmp0_;
	FontManagerFont* _tmp1_;
	FontManagerFont* _tmp2_;
	FontManagerFont* _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp17_ = NULL;
	FontManagerPreviewPane* _tmp18_;
	FontManagerFont* _tmp19_;
	FontManagerFont* _tmp20_;
	FontManagerFont* _tmp21_;
	gboolean _tmp22_;
	GtkStack* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preview_pane;
	g_object_get (_tmp0_, "font", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		FontManagerPreviewPane* _tmp5_;
		FontManagerFont* _tmp6_;
		FontManagerFont* _tmp7_;
		FontManagerFont* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GFile* _tmp12_;
		_tmp5_ = self->priv->preview_pane;
		g_object_get (_tmp5_, "font", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		g_object_get (_tmp8_, "filepath", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp12_ = g_file_new_for_path (_tmp11_);
		_g_object_unref0 (self->priv->current_file);
		self->priv->current_file = _tmp12_;
		_g_free0 (_tmp11_);
		_g_object_unref0 (_tmp8_);
	} else {
		GtkStringList* model = NULL;
		GtkStringList* _tmp13_;
		GtkStringList* _tmp14_;
		GtkDropDown* _tmp15_;
		GtkStringList* _tmp16_;
		_g_object_unref0 (self->priv->current_file);
		self->priv->current_file = NULL;
		_tmp13_ = gtk_string_list_new (NULL);
		model = _tmp13_;
		_tmp14_ = model;
		gtk_string_list_append (_tmp14_, _ ("Font Viewer"));
		_tmp15_ = self->priv->title_widget;
		_tmp16_ = model;
		gtk_drop_down_set_model (_tmp15_, (GListModel*) _tmp16_);
		_g_object_unref0 (model);
	}
	_tmp18_ = self->priv->preview_pane;
	g_object_get (_tmp18_, "font", &_tmp19_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp22_ = _tmp21_ != NULL;
	_g_object_unref0 (_tmp21_);
	if (_tmp22_) {
		_tmp17_ = "Preview";
	} else {
		_tmp17_ = "PlaceHolder";
	}
	_tmp23_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp23_, _tmp17_);
	_g_object_unref0 (self->priv->current_target);
	self->priv->current_target = NULL;
	self->priv->file_status = font_manager_font_viewer_main_window_get_file_status (self);
	font_manager_font_viewer_main_window_update_action_button (self);
	font_manager_font_viewer_main_window_update_title_widget (self);
	return;
}

void
font_manager_font_viewer_main_window_on_preferences_toggled (FontManagerFontViewerMainWindow* self)
{
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preference_toggle;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkStack* _tmp3_;
		_tmp3_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp3_, "Preferences");
	} else {
		const gchar* _tmp4_ = NULL;
		FontManagerPreviewPane* _tmp5_;
		FontManagerFont* _tmp6_;
		FontManagerFont* _tmp7_;
		FontManagerFont* _tmp8_;
		gboolean _tmp9_;
		GtkStack* _tmp10_;
		_tmp5_ = self->priv->preview_pane;
		g_object_get (_tmp5_, "font", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_ != NULL;
		_g_object_unref0 (_tmp8_);
		if (_tmp9_) {
			_tmp4_ = "Preview";
		} else {
			_tmp4_ = "PlaceHolder";
		}
		_tmp10_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp10_, _tmp4_);
	}
	return;
}

static void
_font_manager_font_viewer_main_window_on_preferences_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                        gpointer self)
{
	font_manager_font_viewer_main_window_on_preferences_toggled ((FontManagerFontViewerMainWindow*) self);
}

void
font_manager_font_viewer_main_window_on_action_button_clicked (FontManagerFontViewerMainWindow* self)
{
	GFile* font_dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = font_manager_get_user_font_directory ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	font_dir = _tmp3_;
	switch (self->priv->file_status) {
		case FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_SYSTEM_FONT:
		{
			gchar* directory = NULL;
			GFile* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			GFile* file = NULL;
			const gchar* _tmp9_;
			GFile* _tmp10_;
			GtkFileLauncher* launcher = NULL;
			GFile* _tmp11_;
			GtkFileLauncher* _tmp12_;
			GtkFileLauncher* _tmp13_;
			_tmp4_ = self->priv->current_file;
			_tmp5_ = g_file_get_path (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_path_get_dirname (_tmp6_);
			_tmp8_ = _tmp7_;
			_g_free0 (_tmp6_);
			directory = _tmp8_;
			_tmp9_ = directory;
			_tmp10_ = g_file_new_for_path (_tmp9_);
			file = _tmp10_;
			_tmp11_ = file;
			_tmp12_ = gtk_file_launcher_new (_tmp11_);
			launcher = _tmp12_;
			_tmp13_ = launcher;
			gtk_file_launcher_launch (_tmp13_, NULL, NULL, NULL, NULL);
			_g_object_unref0 (launcher);
			_g_object_unref0 (file);
			_g_free0 (directory);
			break;
		}
		case FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_INSTALLED:
		{
			{
				GFile* parent = NULL;
				GFile* _tmp14_;
				GFile* _tmp15_;
				GFile* _tmp16_;
				GFile* _tmp17_;
				FontManagerPreviewPane* _tmp18_;
				_tmp14_ = self->priv->current_target;
				_tmp15_ = g_file_get_parent (_tmp14_);
				parent = _tmp15_;
				_tmp16_ = self->priv->current_target;
				g_file_delete (_tmp16_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (parent);
					goto __catch0_g_error;
				}
				_tmp17_ = parent;
				font_manager_font_viewer_main_window_remove_directory_tree_if_empty (self, _tmp17_);
				_g_object_unref0 (self->priv->font);
				self->priv->font = NULL;
				_tmp18_ = self->priv->preview_pane;
				g_object_set (_tmp18_, "font", NULL, NULL);
				font_manager_font_viewer_main_window_update (self);
				_g_object_unref0 (parent);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GFile* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				g_clear_error (&_inner_error0_);
				_tmp19_ = self->priv->current_target;
				_tmp20_ = g_file_get_path (_tmp19_);
				_tmp21_ = _tmp20_;
				g_critical ("MainWindow.vala:195: Failed to remove %s", _tmp21_);
				_g_free0 (_tmp21_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (font_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			break;
		}
		default:
		{
			{
				GFile* _tmp22_;
				GFile* _tmp23_;
				_tmp22_ = self->priv->current_file;
				_tmp23_ = font_dir;
				font_manager_install_file (_tmp22_, _tmp23_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				font_manager_font_viewer_main_window_update (self);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GFile* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				g_clear_error (&_inner_error0_);
				_tmp24_ = self->priv->current_file;
				_tmp25_ = g_file_get_path (_tmp24_);
				_tmp26_ = _tmp25_;
				g_critical ("MainWindow.vala:203: Failed to install %s", _tmp26_);
				_g_free0 (_tmp26_);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (font_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			break;
		}
	}
	_g_object_unref0 (font_dir);
	return;
}

static void
_font_manager_font_viewer_main_window_on_action_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                   gpointer self)
{
	font_manager_font_viewer_main_window_on_action_button_clicked ((FontManagerFontViewerMainWindow*) self);
}

static gboolean
font_manager_font_viewer_main_window_on_drop (FontManagerFontViewerMainWindow* self,
                                              GValue* val,
                                              gdouble x,
                                              gdouble y)
{
	GSList* files = NULL;
	void* _tmp0_;
	GSList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (val != NULL, FALSE);
	_tmp0_ = g_value_get_boxed (val);
	files = (GSList*) _tmp0_;
	_tmp1_ = files;
	if (g_slist_length (_tmp1_) > ((guint) 0)) {
		GSList* _tmp2_;
		gconstpointer _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = files;
		_tmp3_ = g_slist_nth_data (_tmp2_, (guint) 0);
		_tmp4_ = g_file_get_uri ((GFile*) _tmp3_);
		_tmp5_ = _tmp4_;
		font_manager_font_viewer_main_window_show_uri (self, _tmp5_);
		_g_free0 (_tmp5_);
	}
	result = TRUE;
	return result;
}

static void
font_manager_font_viewer_main_window_on_variation_selected (FontManagerFontViewerMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	FontManagerFamily* _tmp1_;
	FontManagerFamily* _tmp3_;
	JsonArray* _tmp4_;
	JsonArray* _tmp5_;
	JsonArray* _tmp6_;
	GtkDropDown* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	JsonObject* _tmp10_;
	JsonObject* _tmp11_;
	FontManagerFont* _tmp12_ = NULL;
	FontManagerPreviewPane* _tmp13_;
	FontManagerFont* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->family;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		FontManagerFont* _tmp2_;
		_tmp2_ = self->priv->font;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->family;
	g_object_get (_tmp3_, "variations", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->title_widget;
	_tmp8_ = gtk_drop_down_get_selected (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = json_array_get_object_element (_tmp6_, _tmp9_);
	_tmp11_ = _json_object_ref0 (_tmp10_);
	_tmp12_ = font_manager_font_new ();
	g_object_set (_tmp12_, "source-object", _tmp11_, NULL);
	_json_object_unref0 (_tmp11_);
	_g_object_unref0 (self->priv->font);
	self->priv->font = _tmp12_;
	_json_array_unref0 (_tmp6_);
	_tmp13_ = self->priv->preview_pane;
	_tmp14_ = self->priv->font;
	font_manager_preview_pane_set_font (_tmp13_, _tmp14_);
	return;
}

static void
font_manager_font_viewer_main_window_update_title_widget (FontManagerFontViewerMainWindow* self)
{
	gint64 _tmp0_ = 0LL;
	gboolean _tmp1_ = FALSE;
	FontManagerFamily* _tmp2_;
	gint64 n_items = 0LL;
	GtkDropDown* _tmp7_;
	GtkDropDown* _tmp8_;
	GtkDropDown* _tmp9_;
	GtkLabel* _tmp10_;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp2_ = self->priv->family;
	if (_tmp2_ != NULL) {
		FontManagerFont* _tmp3_;
		_tmp3_ = self->priv->font;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		FontManagerFamily* _tmp4_;
		gint64 _tmp5_;
		gint64 _tmp6_;
		_tmp4_ = self->priv->family;
		g_object_get (_tmp4_, "n-variations", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = (gint64) 0;
	}
	n_items = _tmp0_;
	_tmp7_ = self->priv->title_widget;
	gtk_drop_down_set_show_arrow (_tmp7_, n_items > ((gint64) 1));
	_tmp8_ = self->priv->title_widget;
	gtk_widget_set_can_target ((GtkWidget*) _tmp8_, n_items > ((gint64) 1));
	_tmp9_ = self->priv->title_widget;
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, n_items > ((gint64) 1));
	_tmp10_ = self->priv->title_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp10_, n_items <= ((gint64) 1));
	if (n_items == ((gint64) 1)) {
		FontManagerFont* _tmp12_;
		_tmp12_ = self->priv->font;
		_tmp11_ = _tmp12_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GtkLabel* _tmp13_;
		FontManagerFont* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp13_ = self->priv->title_label;
		_tmp14_ = self->priv->font;
		g_object_get (_tmp14_, "description", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		gtk_label_set_label (_tmp13_, _tmp17_);
		_g_free0 (_tmp17_);
	} else {
		GtkLabel* _tmp18_;
		_tmp18_ = self->priv->title_label;
		gtk_label_set_label (_tmp18_, _ ("Font Viewer"));
	}
	return;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static FontManagerFontViewerMainWindowFileStatus
font_manager_font_viewer_main_window_get_file_status (FontManagerFontViewerMainWindow* self)
{
	GFile* _tmp0_;
	gchar* current_path = NULL;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GList* _tmp4_;
	const gchar* _tmp5_;
	GCompareFunc _tmp6_;
	GList* _tmp7_;
	GFile* font_dir = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	GFile* _tmp22_;
	GFile* _tmp28_;
	GError* _inner_error0_ = NULL;
	FontManagerFontViewerMainWindowFileStatus result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current_file;
	if (_tmp0_ == NULL) {
		result = FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_NOT_INSTALLED;
		return result;
	}
	_tmp1_ = self->priv->current_file;
	_tmp2_ = g_file_get_path (_tmp1_);
	current_path = _tmp2_;
	_tmp4_ = self->priv->installed_files;
	_tmp5_ = current_path;
	_tmp6_ = ((GCompareFunc) g_strcmp0);
	_tmp7_ = g_list_find_custom (_tmp4_, _tmp5_, _tmp6_);
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = current_path;
		_tmp3_ = font_manager_get_file_owner (_tmp8_) != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_SYSTEM_FONT;
		_g_free0 (current_path);
		return result;
	}
	_tmp9_ = font_manager_get_user_font_directory ();
	_tmp10_ = _tmp9_;
	_tmp11_ = g_file_new_for_path (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	font_dir = _tmp12_;
	_tmp13_ = self->priv->current_file;
	_tmp14_ = g_file_get_path (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = font_dir;
	_tmp17_ = g_file_get_path (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = string_contains (_tmp15_, _tmp18_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	if (_tmp19_) {
		GFile* _tmp20_;
		GFile* _tmp21_;
		_tmp20_ = self->priv->current_file;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_g_object_unref0 (self->priv->current_target);
		self->priv->current_target = _tmp21_;
	}
	_tmp22_ = self->priv->current_target;
	if (_tmp22_ == NULL) {
		{
			GFile* _tmp23_ = NULL;
			GFile* _tmp24_;
			GFile* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
			_tmp24_ = self->priv->current_file;
			_tmp25_ = font_dir;
			_tmp26_ = font_manager_get_installation_target (_tmp24_, _tmp25_, FALSE, &_inner_error0_);
			_tmp23_ = _tmp26_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp27_ = _tmp23_;
			_tmp23_ = NULL;
			_g_object_unref0 (self->priv->current_target);
			self->priv->current_target = _tmp27_;
			_g_object_unref0 (_tmp23_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			result = FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_NOT_INSTALLED;
			_g_object_unref0 (font_dir);
			_g_free0 (current_path);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (font_dir);
			_g_free0 (current_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
	}
	_tmp28_ = self->priv->current_target;
	if (g_file_query_exists (_tmp28_, NULL)) {
		gfloat a = 0.0F;
		GFile* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gfloat _tmp32_;
		gfloat b = 0.0F;
		GFile* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gfloat _tmp36_;
		_tmp29_ = self->priv->current_target;
		_tmp30_ = g_file_get_path (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = font_manager_get_font_revision (_tmp31_);
		_g_free0 (_tmp31_);
		a = _tmp32_;
		_tmp33_ = self->priv->current_file;
		_tmp34_ = g_file_get_path (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = font_manager_get_font_revision (_tmp35_);
		_g_free0 (_tmp35_);
		b = _tmp36_;
		if (a < b) {
			result = FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_WOULD_UPGRADE;
			_g_object_unref0 (font_dir);
			_g_free0 (current_path);
			return result;
		} else {
			if (a > b) {
				result = FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_WOULD_DOWNGRADE;
				_g_object_unref0 (font_dir);
				_g_free0 (current_path);
				return result;
			} else {
				result = FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_INSTALLED;
				_g_object_unref0 (font_dir);
				_g_free0 (current_path);
				return result;
			}
		}
	} else {
		result = FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_NOT_INSTALLED;
		_g_object_unref0 (font_dir);
		_g_free0 (current_path);
		return result;
	}
}

static void
font_manager_font_viewer_main_window_update_action_button (FontManagerFontViewerMainWindow* self)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	FontManagerPreviewPane* _tmp5_;
	FontManagerFont* _tmp6_;
	FontManagerFont* _tmp7_;
	FontManagerFont* _tmp8_;
	FontManagerPreviewPane* _tmp9_;
	FontManagerFont* _tmp10_;
	FontManagerFont* _tmp11_;
	FontManagerFont* _tmp12_;
	gboolean _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->action_button;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp0_, FONT_MANAGER_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp1_ = self->priv->action_button;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp1_, FONT_MANAGER_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp2_ = self->priv->action_button;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp2_, FONT_MANAGER_STYLE_CLASS_DIM_LABEL);
	_tmp3_ = self->priv->action_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp3_, NULL);
	_tmp4_ = self->priv->action_button;
	_tmp5_ = self->priv->preview_pane;
	g_object_get (_tmp5_, "font", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, _tmp8_ != NULL);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->preview_pane;
	g_object_get (_tmp9_, "font", &_tmp10_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_ == NULL;
	_g_object_unref0 (_tmp12_);
	if (_tmp13_) {
		return;
	}
	switch (self->priv->file_status) {
		case FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_SYSTEM_FONT:
		{
			GtkButton* _tmp14_;
			GtkButton* _tmp15_;
			GtkButton* _tmp16_;
			_tmp14_ = self->priv->action_button;
			gtk_button_set_label (_tmp14_, _ ("System Font"));
			_tmp15_ = self->priv->action_button;
			gtk_widget_add_css_class ((GtkWidget*) _tmp15_, FONT_MANAGER_STYLE_CLASS_DIM_LABEL);
			_tmp16_ = self->priv->action_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp16_, _ ("Selected font file is either installed in a system directory or is not" \
" writable by the current user.\n" \
"\n" \
"If you wish to remove this font from the list of available fonts use t" \
"he system package manager to remove the package containing this font f" \
"ile, ask the system administrator to remove it or use a font managemen" \
"t application to disable it."));
			break;
		}
		case FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_WOULD_DOWNGRADE:
		{
			GtkButton* _tmp17_;
			GtkButton* _tmp18_;
			GtkButton* _tmp19_;
			_tmp17_ = self->priv->action_button;
			gtk_button_set_label (_tmp17_, _ ("Newer version already installed"));
			_tmp18_ = self->priv->action_button;
			gtk_widget_add_css_class ((GtkWidget*) _tmp18_, FONT_MANAGER_STYLE_CLASS_DESTRUCTIVE_ACTION);
			_tmp19_ = self->priv->action_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp19_, _ ("Click to overwrite"));
			break;
		}
		case FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_WOULD_UPGRADE:
		{
			GtkButton* _tmp20_;
			GtkButton* _tmp21_;
			GtkButton* _tmp22_;
			_tmp20_ = self->priv->action_button;
			gtk_button_set_label (_tmp20_, _ ("Update Font"));
			_tmp21_ = self->priv->action_button;
			gtk_widget_add_css_class ((GtkWidget*) _tmp21_, FONT_MANAGER_STYLE_CLASS_SUGGESTED_ACTION);
			_tmp22_ = self->priv->action_button;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp22_, _ ("Click to overwrite"));
			break;
		}
		case FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_FILE_STATUS_INSTALLED:
		{
			GtkButton* _tmp23_;
			GtkButton* _tmp24_;
			_tmp23_ = self->priv->action_button;
			gtk_button_set_label (_tmp23_, _ ("Remove Font"));
			_tmp24_ = self->priv->action_button;
			gtk_widget_add_css_class ((GtkWidget*) _tmp24_, FONT_MANAGER_STYLE_CLASS_DESTRUCTIVE_ACTION);
			break;
		}
		default:
		{
			GtkButton* _tmp25_;
			GtkButton* _tmp26_;
			_tmp25_ = self->priv->action_button;
			gtk_button_set_label (_tmp25_, _ ("Install Font"));
			_tmp26_ = self->priv->action_button;
			gtk_widget_add_css_class ((GtkWidget*) _tmp26_, FONT_MANAGER_STYLE_CLASS_SUGGESTED_ACTION);
			break;
		}
	}
	return;
}

static void
font_manager_font_viewer_main_window_bind_settings (FontManagerFontViewerMainWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettingsBindFlags flags = 0U;
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp3_;
	GtkSettings* _tmp4_;
	static const char gtk_prefer_dark[] = "gtk-application-prefer-dark-theme";
	GtkSettings* _tmp5_;
	GtkSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GtkSwitch* _tmp14_;
	g_return_if_fail (self != NULL);
	g_object_get ((FontManagerApplicationWindow*) self, "settings", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_g_object_unref0 (_tmp2_);
	flags = G_SETTINGS_BIND_DEFAULT;
	_tmp3_ = gtk_settings_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	gtk_settings = _tmp4_;
	_tmp5_ = gtk_settings;
	if (_tmp5_ != NULL) {
		GSettings* _tmp6_;
		GSettings* _tmp7_;
		GSettings* _tmp8_;
		GtkSettings* _tmp9_;
		g_object_get ((FontManagerApplicationWindow*) self, "settings", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = gtk_settings;
		g_settings_bind (_tmp8_, "prefer-dark-theme", (GObject*) _tmp9_, gtk_prefer_dark, flags);
		_g_object_unref0 (_tmp8_);
	}
	_tmp10_ = gtk_settings;
	g_warn_if_fail (_tmp10_ != NULL);
	g_object_get ((FontManagerApplicationWindow*) self, "settings", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->prefer_dark_theme;
	g_settings_bind (_tmp13_, "prefer-dark-theme", (GObject*) _tmp14_, "active", flags);
	_g_object_unref0 (_tmp13_);
	_g_object_unref0 (gtk_settings);
	return;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FontManagerFontViewerMainWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->spacing);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda7_ (Block2Data* _data2_)
{
	FontManagerFontViewerMainWindow* self;
	FontManagerWaterfallSettings* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	self = _data2_->self;
	_tmp0_ = self->priv->waterfall_settings;
	_tmp1_ = gtk_spin_button_get_value (_data2_->spacing);
	_tmp2_ = _tmp1_;
	font_manager_waterfall_settings_set_line_spacing (_tmp0_, (gint) _tmp2_);
}

static void
___lambda7__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                           gpointer self)
{
	__lambda7_ (self);
}

static void
font_manager_font_viewer_main_window_populate_preference_list (FontManagerFontViewerMainWindow* self)
{
	Block2Data* _data2_;
	GtkListBox* _tmp0_;
	GtkSwitch* _tmp1_;
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp2_ = NULL;
	GtkListBoxRow* _tmp3_;
	GtkSwitch* _tmp4_;
	FontManagerPreferenceRow* _tmp5_;
	FontManagerPreferenceRow* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBoxRow* _tmp8_;
	FontManagerPreviewColors* _tmp9_;
	FontManagerPreviewColors* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	FontManagerPreviewColors* _tmp14_;
	GtkListBoxRow* _tmp15_ = NULL;
	GtkListBoxRow* _tmp16_;
	FontManagerPreviewColors* _tmp17_;
	FontManagerPreferenceRow* _tmp18_;
	FontManagerPreferenceRow* _tmp19_;
	GtkListBox* _tmp20_;
	GtkListBoxRow* _tmp21_;
	GtkAdjustment* adjustment = NULL;
	GtkAdjustment* _tmp22_;
	GtkSpinButton* _tmp23_;
	FontManagerWaterfallSettings* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	GtkListBoxRow* _tmp27_ = NULL;
	GtkListBoxRow* _tmp28_;
	FontManagerPreferenceRow* _tmp29_;
	FontManagerPreferenceRow* _tmp30_;
	GtkListBoxRow* _tmp31_;
	GtkListBox* _tmp32_;
	GtkListBoxRow* _tmp33_;
	GtkListBoxRow* _tmp34_ = NULL;
	GtkSwitch* show_line_size = NULL;
	GtkSwitch* _tmp35_;
	GtkListBoxRow* _tmp36_;
	FontManagerPreferenceRow* _tmp37_;
	FontManagerPreferenceRow* _tmp38_;
	GBindingFlags flags = 0U;
	GtkListBox* _tmp39_;
	GtkListBoxRow* _tmp40_;
	GtkListBoxRow* _tmp41_ = NULL;
	GtkListBoxRow* _tmp42_;
	FontManagerWaterfallSettings* _tmp43_;
	FontManagerPreferenceRow* _tmp44_;
	FontManagerPreferenceRow* _tmp45_;
	FontManagerWaterfallSettings* _tmp46_;
	FontManagerPreferenceRow* _tmp47_;
	FontManagerPreferenceRow* _tmp48_;
	GtkListBox* _tmp49_;
	GtkListBoxRow* _tmp50_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->preference_list;
	gtk_list_box_set_selection_mode (_tmp0_, GTK_SELECTION_NONE);
	_tmp1_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->prefer_dark_theme);
	self->priv->prefer_dark_theme = _tmp1_;
	_tmp2_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	gtk_list_box_row_set_activatable (_tmp2_, FALSE);
	gtk_list_box_row_set_selectable (_tmp2_, FALSE);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp2_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp2_, 6);
	g_object_ref_sink (_tmp2_);
	row = _tmp2_;
	_tmp3_ = row;
	_tmp4_ = self->priv->prefer_dark_theme;
	_tmp5_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (_ ("Prefer Dark Theme"), NULL, NULL, (GtkWidget*) _tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	gtk_list_box_row_set_child (_tmp3_, (GtkWidget*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->preference_list;
	_tmp8_ = row;
	gtk_list_box_insert (_tmp7_, (GtkWidget*) _tmp8_, -1);
	_tmp9_ = font_manager_preview_colors_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->preview_colors);
	self->priv->preview_colors = _tmp9_;
	_tmp10_ = self->priv->preview_colors;
	g_object_get ((FontManagerApplicationWindow*) self, "settings", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	font_manager_preview_colors_restore_state (_tmp10_, _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = self->priv->preview_colors;
	font_manager_widget_set_margin ((GtkWidget*) _tmp14_, 0);
	_tmp15_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	gtk_list_box_row_set_activatable (_tmp15_, FALSE);
	gtk_list_box_row_set_selectable (_tmp15_, FALSE);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp15_, 6);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (row);
	row = _tmp15_;
	_tmp16_ = row;
	_tmp17_ = self->priv->preview_colors;
	_tmp18_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (_ ("Preview Area Colors"), NULL, NULL, (GtkWidget*) _tmp17_);
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	gtk_list_box_row_set_child (_tmp16_, (GtkWidget*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = self->priv->preference_list;
	_tmp21_ = row;
	gtk_list_box_insert (_tmp20_, (GtkWidget*) _tmp21_, -1);
	_tmp22_ = gtk_adjustment_new (0.0, 0.0, DBL_MAX, 1.0, 1.0, 1.0);
	g_object_ref_sink (_tmp22_);
	adjustment = _tmp22_;
	_tmp23_ = (GtkSpinButton*) gtk_spin_button_new (adjustment, 1.0, (guint) 0);
	g_object_ref_sink (_tmp23_);
	_data2_->spacing = _tmp23_;
	_tmp24_ = self->priv->waterfall_settings;
	_tmp25_ = font_manager_waterfall_settings_get_line_spacing (_tmp24_);
	_tmp26_ = _tmp25_;
	gtk_spin_button_set_value (_data2_->spacing, (gdouble) _tmp26_);
	_tmp27_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	gtk_list_box_row_set_activatable (_tmp27_, FALSE);
	gtk_list_box_row_set_selectable (_tmp27_, FALSE);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp27_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp27_, 6);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (row);
	row = _tmp27_;
	_tmp28_ = row;
	_tmp29_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (_ ("Waterfall Line Spacing"), NULL, NULL, (GtkWidget*) _data2_->spacing);
	g_object_ref_sink (_tmp29_);
	_tmp30_ = _tmp29_;
	gtk_list_box_row_set_child (_tmp28_, (GtkWidget*) _tmp30_);
	_g_object_unref0 (_tmp30_);
	_tmp31_ = row;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp31_, _ ("Padding in pixels to insert above and below rows"));
	_tmp32_ = self->priv->preference_list;
	_tmp33_ = row;
	gtk_list_box_insert (_tmp32_, (GtkWidget*) _tmp33_, -1);
	_tmp34_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	gtk_list_box_row_set_activatable (_tmp34_, FALSE);
	gtk_list_box_row_set_selectable (_tmp34_, FALSE);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp34_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp34_, 6);
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (row);
	row = _tmp34_;
	_tmp35_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp35_);
	show_line_size = _tmp35_;
	_tmp36_ = row;
	_tmp37_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (_ ("Display line size in Waterfall Preview"), NULL, NULL, (GtkWidget*) show_line_size);
	g_object_ref_sink (_tmp37_);
	_tmp38_ = _tmp37_;
	gtk_list_box_row_set_child (_tmp36_, (GtkWidget*) _tmp38_);
	_g_object_unref0 (_tmp38_);
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	g_object_bind_property_with_closures ((GObject*) self, "show-line-size", (GObject*) show_line_size, "active", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp39_ = self->priv->preference_list;
	_tmp40_ = row;
	gtk_list_box_insert (_tmp39_, (GtkWidget*) _tmp40_, -1);
	g_signal_connect_data (_data2_->spacing, "value-changed", (GCallback) ___lambda7__gtk_spin_button_value_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp41_ = (GtkListBoxRow*) gtk_list_box_row_new ();
	gtk_list_box_row_set_activatable (_tmp41_, FALSE);
	gtk_list_box_row_set_selectable (_tmp41_, FALSE);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp41_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp41_, 6);
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (row);
	row = _tmp41_;
	_tmp42_ = row;
	_tmp43_ = self->priv->waterfall_settings;
	_tmp44_ = font_manager_waterfall_settings_get_preference_row (_tmp43_);
	_tmp45_ = _tmp44_;
	gtk_list_box_row_set_child (_tmp42_, (GtkWidget*) _tmp45_);
	_tmp46_ = self->priv->waterfall_settings;
	_tmp47_ = font_manager_waterfall_settings_get_preference_row (_tmp46_);
	_tmp48_ = _tmp47_;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp48_, 12);
	_tmp49_ = self->priv->preference_list;
	_tmp50_ = row;
	gtk_list_box_insert (_tmp49_, (GtkWidget*) _tmp50_, -1);
	font_manager_font_viewer_main_window_bind_settings (self);
	_g_object_unref0 (show_line_size);
	_g_object_unref0 (adjustment);
	_g_object_unref0 (row);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return;
}

static void
font_manager_font_viewer_main_window_on_show_context_menu (FontManagerFontViewerMainWindow* self,
                                                           gint n_press,
                                                           gdouble x,
                                                           gdouble y)
{
	FontManagerWaterfallSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	FontManagerPreviewPane* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	FontManagerWaterfallSettings* _tmp8_;
	GtkPopoverMenu* _tmp9_;
	GtkPopoverMenu* _tmp10_;
	GtkWidget* _tmp11_;
	FontManagerWaterfallSettings* _tmp15_;
	GtkPopoverMenu* _tmp16_;
	GtkPopoverMenu* _tmp17_;
	FontManagerPreviewPane* _tmp18_;
	FontManagerWaterfallSettings* _tmp19_;
	GtkPopoverMenu* _tmp20_;
	GtkPopoverMenu* _tmp21_;
	GdkRectangle _tmp22_;
	FontManagerWaterfallSettings* _tmp23_;
	GtkPopoverMenu* _tmp24_;
	GtkPopoverMenu* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->waterfall_settings;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->preview_pane;
	g_object_get (_tmp2_, "page", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != ((gint) FONT_MANAGER_PREVIEW_PANE_PAGE_PREVIEW)) {
		_tmp1_ = TRUE;
	} else {
		FontManagerPreviewPane* _tmp5_;
		FontManagerPreviewPageMode _tmp6_;
		FontManagerPreviewPageMode _tmp7_;
		_tmp5_ = self->priv->preview_pane;
		g_object_get (_tmp5_, "preview-mode", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ != FONT_MANAGER_PREVIEW_PAGE_MODE_WATERFALL;
	}
	if (_tmp1_) {
		return;
	}
	self->priv->clicked_area.x = (gint) x;
	self->priv->clicked_area.y = (gint) y;
	self->priv->clicked_area.width = 2;
	self->priv->clicked_area.height = 2;
	_tmp8_ = self->priv->waterfall_settings;
	_tmp9_ = font_manager_waterfall_settings_get_context_menu (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_widget_get_parent ((GtkWidget*) _tmp10_);
	if (_tmp11_ != NULL) {
		FontManagerWaterfallSettings* _tmp12_;
		GtkPopoverMenu* _tmp13_;
		GtkPopoverMenu* _tmp14_;
		_tmp12_ = self->priv->waterfall_settings;
		_tmp13_ = font_manager_waterfall_settings_get_context_menu (_tmp12_);
		_tmp14_ = _tmp13_;
		gtk_widget_unparent ((GtkWidget*) _tmp14_);
	}
	_tmp15_ = self->priv->waterfall_settings;
	_tmp16_ = font_manager_waterfall_settings_get_context_menu (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->preview_pane;
	gtk_widget_set_parent ((GtkWidget*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->waterfall_settings;
	_tmp20_ = font_manager_waterfall_settings_get_context_menu (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->clicked_area;
	gtk_popover_set_pointing_to ((GtkPopover*) _tmp21_, &_tmp22_);
	_tmp23_ = self->priv->waterfall_settings;
	_tmp24_ = font_manager_waterfall_settings_get_context_menu (_tmp23_);
	_tmp25_ = _tmp24_;
	gtk_popover_popup ((GtkPopover*) _tmp25_);
	return;
}

static gboolean
font_manager_font_viewer_main_window_remove_directory_tree_if_empty (FontManagerFontViewerMainWindow* self,
                                                                     GFile* dir)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir != NULL, FALSE);
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		GFileInfo* _tmp1_ = NULL;
		GFileEnumerator* _tmp2_;
		GFileInfo* _tmp3_;
		GFile* parent = NULL;
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp0_ = g_file_enumerate_children (dir, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = enumerator;
		_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (enumerator);
			goto __catch0_g_error;
		}
		if (_tmp1_ != NULL) {
			result = FALSE;
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (enumerator);
			return result;
		}
		_tmp4_ = g_file_get_parent (dir);
		parent = _tmp4_;
		g_file_delete (dir, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parent);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (enumerator);
			goto __catch0_g_error;
		}
		_tmp5_ = parent;
		if (_tmp5_ != NULL) {
			GFile* _tmp6_;
			_tmp6_ = parent;
			font_manager_font_viewer_main_window_remove_directory_tree_if_empty (self, _tmp6_);
		}
		result = TRUE;
		_g_object_unref0 (parent);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (enumerator);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("MainWindow.vala:420: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = FALSE;
	return result;
}

gint
font_manager_font_viewer_main_window_get_predefined_size (FontManagerFontViewerMainWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_predefined_size;
	return result;
}

void
font_manager_font_viewer_main_window_set_predefined_size (FontManagerFontViewerMainWindow* self,
                                                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_font_viewer_main_window_get_predefined_size (self);
	if (old_value != value) {
		self->priv->_predefined_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_font_viewer_main_window_properties[FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_PREDEFINED_SIZE_PROPERTY]);
	}
}

gboolean
font_manager_font_viewer_main_window_get_show_line_size (FontManagerFontViewerMainWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_line_size;
	return result;
}

void
font_manager_font_viewer_main_window_set_show_line_size (FontManagerFontViewerMainWindow* self,
                                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_font_viewer_main_window_get_show_line_size (self);
	if (old_value != value) {
		self->priv->_show_line_size = value;
		g_object_notify_by_pspec ((GObject *) self, font_manager_font_viewer_main_window_properties[FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_SHOW_LINE_SIZE_PROPERTY]);
	}
}

static void
font_manager_font_viewer_main_window_class_init (FontManagerFontViewerMainWindowClass * klass,
                                                 gpointer klass_data)
{
	font_manager_font_viewer_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerFontViewerMainWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_font_viewer_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_font_viewer_main_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_font_viewer_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_PREDEFINED_SIZE_PROPERTY, font_manager_font_viewer_main_window_properties[FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_PREDEFINED_SIZE_PROPERTY] = g_param_spec_int ("predefined-size", "predefined-size", "predefined-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_SHOW_LINE_SIZE_PROPERTY, font_manager_font_viewer_main_window_properties[FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_SHOW_LINE_SIZE_PROPERTY] = g_param_spec_boolean ("show-line-size", "show-line-size", "show-line-size", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-viewer-main-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_label", FALSE, FontManagerFontViewerMainWindow_private_offset + G_STRUCT_OFFSET (FontManagerFontViewerMainWindowPrivate, title_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_widget", FALSE, FontManagerFontViewerMainWindow_private_offset + G_STRUCT_OFFSET (FontManagerFontViewerMainWindowPrivate, title_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, FontManagerFontViewerMainWindow_private_offset + G_STRUCT_OFFSET (FontManagerFontViewerMainWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_button", FALSE, FontManagerFontViewerMainWindow_private_offset + G_STRUCT_OFFSET (FontManagerFontViewerMainWindowPrivate, action_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preference_toggle", FALSE, FontManagerFontViewerMainWindow_private_offset + G_STRUCT_OFFSET (FontManagerFontViewerMainWindowPrivate, preference_toggle));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preference_list", FALSE, FontManagerFontViewerMainWindow_private_offset + G_STRUCT_OFFSET (FontManagerFontViewerMainWindowPrivate, preference_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "preview_pane", FALSE, FontManagerFontViewerMainWindow_private_offset + G_STRUCT_OFFSET (FontManagerFontViewerMainWindowPrivate, preview_pane));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_preferences_toggled", G_CALLBACK(_font_manager_font_viewer_main_window_on_preferences_toggled_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_action_button_clicked", G_CALLBACK(_font_manager_font_viewer_main_window_on_action_button_clicked_gtk_button_clicked));
	gtk_widget_class_install_property_action (GTK_WIDGET_CLASS (klass), "predefined-size", "predefined-size");
	gtk_widget_class_install_property_action (GTK_WIDGET_CLASS (klass), "show-line-size", "show-line-size");
}

static void
font_manager_font_viewer_main_window_instance_init (FontManagerFontViewerMainWindow * self,
                                                    gpointer klass)
{
	self->priv = font_manager_font_viewer_main_window_get_instance_private (self);
	self->priv->_show_line_size = TRUE;
	self->priv->font = NULL;
	self->priv->family = NULL;
	self->priv->current_file = NULL;
	self->priv->current_target = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_font_viewer_main_window_finalize (GObject * obj)
{
	FontManagerFontViewerMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_FONT_VIEWER_TYPE_MAIN_WINDOW, FontManagerFontViewerMainWindow);
	(self->priv->installed_files == NULL) ? NULL : (self->priv->installed_files = (_g_list_free__g_free0_ (self->priv->installed_files), NULL));
	_g_object_unref0 (self->priv->prefer_dark_theme);
	_g_object_unref0 (self->priv->use_adwaita_stylesheet);
	_g_object_unref0 (self->priv->preview_colors);
	_g_object_unref0 (self->priv->waterfall_settings);
	_g_object_unref0 (self->priv->font);
	_g_object_unref0 (self->priv->family);
	_g_object_unref0 (self->priv->current_file);
	_g_object_unref0 (self->priv->current_target);
	G_OBJECT_CLASS (font_manager_font_viewer_main_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_font_viewer_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerFontViewerMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_font_viewer_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerFontViewerMainWindow), 0, (GInstanceInitFunc) font_manager_font_viewer_main_window_instance_init, NULL };
	GType font_manager_font_viewer_main_window_type_id;
	font_manager_font_viewer_main_window_type_id = g_type_register_static (font_manager_application_window_get_type (), "FontManagerFontViewerMainWindow", &g_define_type_info, 0);
	FontManagerFontViewerMainWindow_private_offset = g_type_add_instance_private (font_manager_font_viewer_main_window_type_id, sizeof (FontManagerFontViewerMainWindowPrivate));
	return font_manager_font_viewer_main_window_type_id;
}

GType
font_manager_font_viewer_main_window_get_type (void)
{
	static volatile gsize font_manager_font_viewer_main_window_type_id__once = 0;
	if (g_once_init_enter (&font_manager_font_viewer_main_window_type_id__once)) {
		GType font_manager_font_viewer_main_window_type_id;
		font_manager_font_viewer_main_window_type_id = font_manager_font_viewer_main_window_get_type_once ();
		g_once_init_leave (&font_manager_font_viewer_main_window_type_id__once, font_manager_font_viewer_main_window_type_id);
	}
	return font_manager_font_viewer_main_window_type_id__once;
}

static void
_vala_font_manager_font_viewer_main_window_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	FontManagerFontViewerMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_FONT_VIEWER_TYPE_MAIN_WINDOW, FontManagerFontViewerMainWindow);
	switch (property_id) {
		case FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_PREDEFINED_SIZE_PROPERTY:
		g_value_set_int (value, font_manager_font_viewer_main_window_get_predefined_size (self));
		break;
		case FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_SHOW_LINE_SIZE_PROPERTY:
		g_value_set_boolean (value, font_manager_font_viewer_main_window_get_show_line_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_font_viewer_main_window_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	FontManagerFontViewerMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_FONT_VIEWER_TYPE_MAIN_WINDOW, FontManagerFontViewerMainWindow);
	switch (property_id) {
		case FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_PREDEFINED_SIZE_PROPERTY:
		font_manager_font_viewer_main_window_set_predefined_size (self, g_value_get_int (value));
		break;
		case FONT_MANAGER_FONT_VIEWER_MAIN_WINDOW_SHOW_LINE_SIZE_PROPERTY:
		font_manager_font_viewer_main_window_set_show_line_size (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

