/* modifications-revealer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from modifications-revealer.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define MODEL_UTILS_dconf_context_id ((guint16) 2)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_MODIFICATIONS_REVEALER (modifications_revealer_get_type ())
#define MODIFICATIONS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealer))
#define MODIFICATIONS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealerClass))
#define IS_MODIFICATIONS_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFICATIONS_REVEALER))
#define IS_MODIFICATIONS_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFICATIONS_REVEALER))
#define MODIFICATIONS_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFICATIONS_REVEALER, ModificationsRevealerClass))

typedef struct _ModificationsRevealer ModificationsRevealer;
typedef struct _ModificationsRevealerClass ModificationsRevealerClass;
typedef struct _ModificationsRevealerPrivate ModificationsRevealerPrivate;

#define TYPE_MODIFICATIONS_HANDLER (modifications_handler_get_type ())
#define MODIFICATIONS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFICATIONS_HANDLER, ModificationsHandler))
#define MODIFICATIONS_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFICATIONS_HANDLER, ModificationsHandlerClass))
#define IS_MODIFICATIONS_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFICATIONS_HANDLER))
#define IS_MODIFICATIONS_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFICATIONS_HANDLER))
#define MODIFICATIONS_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFICATIONS_HANDLER, ModificationsHandlerClass))

typedef struct _ModificationsHandler ModificationsHandler;
typedef struct _ModificationsHandlerClass ModificationsHandlerClass;

#define TYPE_OVERLAYED_LIST (overlayed_list_get_type ())
#define OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAYED_LIST, OverlayedList))
#define OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAYED_LIST, OverlayedListClass))
#define IS_OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAYED_LIST))
#define IS_OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAYED_LIST))
#define OVERLAYED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAYED_LIST, OverlayedListClass))

typedef struct _OverlayedList OverlayedList;
typedef struct _OverlayedListClass OverlayedListClass;

#define TYPE_MODIFICATIONS_LIST (modifications_list_get_type ())
#define MODIFICATIONS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFICATIONS_LIST, ModificationsList))
#define MODIFICATIONS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFICATIONS_LIST, ModificationsListClass))
#define IS_MODIFICATIONS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFICATIONS_LIST))
#define IS_MODIFICATIONS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFICATIONS_LIST))
#define MODIFICATIONS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFICATIONS_LIST, ModificationsListClass))

typedef struct _ModificationsList ModificationsList;
typedef struct _ModificationsListClass ModificationsListClass;
enum  {
	MODIFICATIONS_REVEALER_0_PROPERTY,
	MODIFICATIONS_REVEALER_MODIFICATIONS_HANDLER_PROPERTY,
	MODIFICATIONS_REVEALER_NUM_PROPERTIES
};
static GParamSpec* modifications_revealer_properties[MODIFICATIONS_REVEALER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SETTINGS_MODEL_CORE (settings_model_core_get_type ())
#define SETTINGS_MODEL_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL_CORE, SettingsModelCore))
#define SETTINGS_MODEL_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL_CORE, SettingsModelCoreClass))
#define IS_SETTINGS_MODEL_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL_CORE))
#define IS_SETTINGS_MODEL_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL_CORE))
#define SETTINGS_MODEL_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL_CORE, SettingsModelCoreClass))

typedef struct _SettingsModelCore SettingsModelCore;
typedef struct _SettingsModelCoreClass SettingsModelCoreClass;

#define TYPE_SETTINGS_MODEL (settings_model_get_type ())
#define SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL, SettingsModel))
#define SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL, SettingsModelClass))
#define IS_SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL))
#define IS_SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL))
#define SETTINGS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL, SettingsModelClass))

typedef struct _SettingsModel SettingsModel;
typedef struct _SettingsModelClass SettingsModelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_REGISTRY_VARIANT_DICT (registry_variant_dict_get_type ())
#define REGISTRY_VARIANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDict))
#define REGISTRY_VARIANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDictClass))
#define IS_REGISTRY_VARIANT_DICT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGISTRY_VARIANT_DICT))
#define IS_REGISTRY_VARIANT_DICT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGISTRY_VARIANT_DICT))
#define REGISTRY_VARIANT_DICT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGISTRY_VARIANT_DICT, RegistryVariantDictClass))

typedef struct _RegistryVariantDict RegistryVariantDict;
typedef struct _RegistryVariantDictClass RegistryVariantDictClass;
typedef enum  {
	PROPERTY_QUERY_HASH = 1 << 0,
	PROPERTY_QUERY_HAS_SCHEMA = 1 << 1,
	PROPERTY_QUERY_KEY_NAME = 1 << 2,
	PROPERTY_QUERY_TYPE_CODE = 1 << 3,
	PROPERTY_QUERY_KEY_VALUE = 1 << 4,
	PROPERTY_QUERY_FIXED_SCHEMA = 1 << 5,
	PROPERTY_QUERY_SCHEMA_ID = 1 << 6,
	PROPERTY_QUERY_SUMMARY = 1 << 7,
	PROPERTY_QUERY_DESCRIPTION = 1 << 8,
	PROPERTY_QUERY_DEFAULT_VALUE = 1 << 9,
	PROPERTY_QUERY_RANGE_TYPE = 1 << 10,
	PROPERTY_QUERY_RANGE_CONTENT = 1 << 11,
	PROPERTY_QUERY_MAXIMUM = 1 << 12,
	PROPERTY_QUERY_MINIMUM = 1 << 13,
	PROPERTY_QUERY_KEY_CONFLICT = 1 << 14,
	PROPERTY_QUERY_IS_DEFAULT = 1 << 15
} PropertyQuery;

#define TYPE_PROPERTY_QUERY (property_query_get_type ())
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))

#define TYPE_SIMPLE_SETTING_OBJECT (simple_setting_object_get_type ())
#define SIMPLE_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject))
#define SIMPLE_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObjectClass))
#define IS_SIMPLE_SETTING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SETTING_OBJECT))
#define IS_SIMPLE_SETTING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SETTING_OBJECT))
#define SIMPLE_SETTING_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObjectClass))

typedef struct _SimpleSettingObject SimpleSettingObject;
typedef struct _SimpleSettingObjectClass SimpleSettingObjectClass;

#define TYPE_OVERLAYED_LIST_ROW (overlayed_list_row_get_type ())
#define OVERLAYED_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAYED_LIST_ROW, OverlayedListRow))
#define OVERLAYED_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAYED_LIST_ROW, OverlayedListRowClass))
#define IS_OVERLAYED_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAYED_LIST_ROW))
#define IS_OVERLAYED_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAYED_LIST_ROW))
#define OVERLAYED_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAYED_LIST_ROW, OverlayedListRowClass))

typedef struct _OverlayedListRow OverlayedListRow;
typedef struct _OverlayedListRowClass OverlayedListRowClass;

#define TYPE_DELAYED_SETTING_VIEW (delayed_setting_view_get_type ())
#define DELAYED_SETTING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELAYED_SETTING_VIEW, DelayedSettingView))
#define DELAYED_SETTING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELAYED_SETTING_VIEW, DelayedSettingViewClass))
#define IS_DELAYED_SETTING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELAYED_SETTING_VIEW))
#define IS_DELAYED_SETTING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELAYED_SETTING_VIEW))
#define DELAYED_SETTING_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELAYED_SETTING_VIEW, DelayedSettingViewClass))

typedef struct _DelayedSettingView DelayedSettingView;
typedef struct _DelayedSettingViewClass DelayedSettingViewClass;
typedef enum  {
	MODIFICATIONS_MODE_NONE,
	MODIFICATIONS_MODE_TEMPORARY,
	MODIFICATIONS_MODE_DELAYED
} ModificationsMode;

#define TYPE_MODIFICATIONS_MODE (modifications_mode_get_type ())
typedef enum  {
	BEHAVIOUR_UNSAFE,
	BEHAVIOUR_SAFE,
	BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT,
	BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT,
	BEHAVIOUR_ALWAYS_DELAY
} Behaviour;

#define TYPE_BEHAVIOUR (behaviour_get_type ())

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _ModificationsRevealer {
	GtkRevealer parent_instance;
	ModificationsRevealerPrivate * priv;
};

struct _ModificationsRevealerClass {
	GtkRevealerClass parent_class;
};

struct _ModificationsRevealerPrivate {
	ModificationsHandler* _modifications_handler;
	GtkStyleContext* apply_button_context;
	gboolean disable_action_bar;
	gboolean short_size_button;
	GtkLabel* label;
	GtkModelButton* apply_button;
	GtkMenuButton* delayed_list_button;
	GtkPopover* delayed_settings_list_popover;
	ModificationsList* modifications_list;
	GThemedIcon* apply_button_icon;
};

static gint ModificationsRevealer_private_offset;
static gpointer modifications_revealer_parent_class = NULL;
static AdaptativeWidgetIface * modifications_revealer_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType modifications_revealer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ModificationsRevealer, g_object_unref)
VALA_EXTERN GType modifications_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ModificationsHandler, g_object_unref)
VALA_EXTERN GType overlayed_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayedList, g_object_unref)
VALA_EXTERN GType modifications_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ModificationsList, g_object_unref)
static void modifications_revealer_real_set_window_size (AdaptativeWidget* base,
                                                  AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_thin (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_flat (AdaptativeWidgetWindowSize window_size);
static void modifications_revealer_update (ModificationsRevealer* self);
VALA_EXTERN gboolean adaptative_widget_window_size_is_quite_thin (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN void modifications_revealer_reset_objects (ModificationsRevealer* self,
                                           const gchar* base_path,
                                           GVariant* objects,
                                           gboolean recursively);
static void _modifications_revealer_reset_objects (ModificationsRevealer* self,
                                            const gchar* base_path,
                                            GVariant* objects,
                                            gboolean recursively);
static void modifications_revealer_warn_if_no_planned_changes (ModificationsRevealer* self);
VALA_EXTERN GType settings_model_core_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsModelCore, g_object_unref)
VALA_EXTERN GType settings_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SettingsModel, g_object_unref)
static ModificationsHandler* modifications_revealer_get_modifications_handler (ModificationsRevealer* self);
VALA_EXTERN SettingsModel* modifications_handler_get_model (ModificationsHandler* self);
VALA_EXTERN gboolean model_utils_is_folder_context_id (guint16 context_id);
VALA_EXTERN gchar* model_utils_recreate_full_name (const gchar* base_path,
                                       const gchar* name,
                                       gboolean is_folder);
VALA_EXTERN GVariant* settings_model_get_children (SettingsModel* self,
                                       const gchar* folder_path,
                                       gboolean watch,
                                       gboolean clean_watched);
VALA_EXTERN gboolean model_utils_is_dconf_context_id (guint16 context_id);
VALA_EXTERN gboolean settings_model_is_key_ghost (SettingsModel* self,
                                      const gchar* key_path);
VALA_EXTERN void modifications_handler_add_delayed_setting (ModificationsHandler* self,
                                                const gchar* key_path,
                                                GVariant* new_value,
                                                guint16 context_id);
VALA_EXTERN GType registry_variant_dict_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RegistryVariantDict, g_object_unref)
VALA_EXTERN GVariant* settings_model_get_key_properties (SettingsModel* self,
                                             const gchar* key_path,
                                             guint16 key_context_id,
                                             guint16 query);
VALA_EXTERN GType property_query_get_type (void) G_GNUC_CONST ;
VALA_EXTERN RegistryVariantDict* registry_variant_dict_new_from_aqv (GVariant* variant);
VALA_EXTERN RegistryVariantDict* registry_variant_dict_construct_from_aqv (GType object_type,
                                                               GVariant* variant);
VALA_EXTERN gboolean registry_variant_dict_lookup (RegistryVariantDict* self,
                                       guint16 key,
                                       const gchar* format_string,
                                       ...);
VALA_EXTERN void registry_variant_dict_clear (RegistryVariantDict* self);
VALA_EXTERN guint modifications_handler_get_dconf_changes_count (ModificationsHandler* self);
VALA_EXTERN guint modifications_handler_get_gsettings_changes_count (ModificationsHandler* self);
VALA_EXTERN gboolean modifications_revealer_next_match (ModificationsRevealer* self);
VALA_EXTERN gboolean overlayed_list_next_match (OverlayedList* self);
VALA_EXTERN gboolean modifications_revealer_previous_match (ModificationsRevealer* self);
VALA_EXTERN gboolean overlayed_list_previous_match (OverlayedList* self);
VALA_EXTERN gboolean modifications_revealer_handle_copy_text (ModificationsRevealer* self,
                                                  gchar** copy_text);
VALA_EXTERN gboolean overlayed_list_handle_copy_text (OverlayedList* self,
                                          gchar** copy_text);
VALA_EXTERN gboolean base_window_no_copy_text (gchar** copy_text);
VALA_EXTERN gboolean modifications_revealer_dismiss_selected_modification (ModificationsRevealer* self);
VALA_EXTERN gchar* modifications_list_get_selected_row_name (ModificationsList* self);
VALA_EXTERN void modifications_handler_dismiss_change (ModificationsHandler* self,
                                           const gchar* key_path);
VALA_EXTERN void modifications_revealer_hide_modifications_list (ModificationsRevealer* self);
VALA_EXTERN void modifications_revealer_toggle_modifications_list (ModificationsRevealer* self);
VALA_EXTERN gboolean modifications_revealer_get_modifications_list_state (ModificationsRevealer* self);
static GtkWidget* modifications_revealer_delayed_setting_row_create (ModificationsRevealer* self,
                                                              GObject* object);
VALA_EXTERN GType simple_setting_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SimpleSettingObject, g_object_unref)
VALA_EXTERN GtkWidget* modifications_revealer_create_delayed_setting_row (ModificationsHandler* modifications_handler,
                                                              const gchar* name,
                                                              const gchar* full_name,
                                                              guint16 context_id);
VALA_EXTERN const gchar* simple_setting_object_get_name (SimpleSettingObject* self);
VALA_EXTERN const gchar* simple_setting_object_get_full_name (SimpleSettingObject* self);
VALA_EXTERN guint16 simple_setting_object_get_context_id (SimpleSettingObject* self);
VALA_EXTERN GVariant* modifications_handler_get_key_planned_value (ModificationsHandler* self,
                                                       const gchar* key_path);
VALA_EXTERN gchar* key_cool_text_value_from_variant (GVariant* variant);
VALA_EXTERN GType overlayed_list_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayedListRow, g_object_unref)
VALA_EXTERN GType delayed_setting_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DelayedSettingView, g_object_unref)
VALA_EXTERN DelayedSettingView* delayed_setting_view_new (const gchar* name,
                                              const gchar* _full_name,
                                              guint16 _context_id,
                                              gboolean has_schema_and_is_default,
                                              GVariant* key_value,
                                              const gchar* cool_planned_value,
                                              const gchar* cool_default_value);
VALA_EXTERN DelayedSettingView* delayed_setting_view_construct (GType object_type,
                                                    const gchar* name,
                                                    const gchar* _full_name,
                                                    guint16 _context_id,
                                                    gboolean has_schema_and_is_default,
                                                    GVariant* key_value,
                                                    const gchar* cool_planned_value,
                                                    const gchar* cool_default_value);
VALA_EXTERN gboolean modifications_handler_get_current_delay_mode (ModificationsHandler* self);
VALA_EXTERN void modifications_revealer_gkey_value_push (ModificationsRevealer* self,
                                             const gchar* full_name,
                                             guint16 context_id,
                                             GVariant* key_value,
                                             gboolean is_key_default);
VALA_EXTERN void modifications_list_gkey_value_push (ModificationsList* self,
                                         const gchar* full_name,
                                         guint16 context_id,
                                         GVariant* key_value,
                                         gboolean is_key_default);
VALA_EXTERN void modifications_revealer_dkey_value_push (ModificationsRevealer* self,
                                             const gchar* full_name,
                                             GVariant* key_value_or_null);
VALA_EXTERN void modifications_list_dkey_value_push (ModificationsList* self,
                                         const gchar* full_name,
                                         GVariant* key_value_or_null);
VALA_EXTERN GListStore* modifications_handler_get_delayed_settings (ModificationsHandler* self);
VALA_EXTERN void modifications_list_bind_model (ModificationsList* self,
                                    GListStore* modifications,
                                    GtkListBoxCreateWidgetFunc delayed_setting_row_create,
                                    gpointer delayed_setting_row_create_target);
static GtkWidget* _modifications_revealer_delayed_setting_row_create_gtk_list_box_create_widget_func (GObject* item,
                                                                                               gpointer self);
VALA_EXTERN GType modifications_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ModificationsMode modifications_handler_get_mode (ModificationsHandler* self);
VALA_EXTERN GType behaviour_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Behaviour modifications_handler_get_behaviour (ModificationsHandler* self);
static gchar* modifications_revealer_get_text (guint dconf,
                                        guint gsettings);
VALA_EXTERN ModificationsRevealer* modifications_revealer_new (void);
VALA_EXTERN ModificationsRevealer* modifications_revealer_construct (GType object_type);
VALA_EXTERN void modifications_revealer_set_modifications_handler (ModificationsRevealer* self,
                                                       ModificationsHandler* value);
static void _modifications_revealer_update_modifications_handler_delayed_changes_changed (ModificationsHandler* _sender,
                                                                                   gpointer self);
static GObject * modifications_revealer_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void modifications_revealer_finalize (GObject * obj);
static GType modifications_revealer_get_type_once (void);
static void _vala_modifications_revealer_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_modifications_revealer_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
modifications_revealer_get_instance_private (ModificationsRevealer* self)
{
	return G_STRUCT_MEMBER_P (self, ModificationsRevealer_private_offset);
}

static void
modifications_revealer_real_set_window_size (AdaptativeWidget* base,
                                             AdaptativeWidgetWindowSize new_size)
{
	ModificationsRevealer * self;
	gboolean _tmp0_ = FALSE;
	gboolean _disable_action_bar = FALSE;
	gboolean _short_size_button = FALSE;
	self = (ModificationsRevealer*) base;
	if (adaptative_widget_window_size_is_extra_thin (new_size)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = adaptative_widget_window_size_is_extra_flat (new_size);
	}
	_disable_action_bar = _tmp0_;
	if (self->priv->disable_action_bar != _disable_action_bar) {
		self->priv->disable_action_bar = _disable_action_bar;
		modifications_revealer_update (self);
	}
	_short_size_button = adaptative_widget_window_size_is_quite_thin (new_size);
	if (self->priv->short_size_button != _short_size_button) {
		self->priv->short_size_button = _short_size_button;
		if (_short_size_button) {
			GtkStyleContext* _tmp1_;
			GtkModelButton* _tmp2_;
			GThemedIcon* _tmp3_;
			GtkStyleContext* _tmp4_;
			_tmp1_ = self->priv->apply_button_context;
			gtk_style_context_remove_class (_tmp1_, "text-button");
			_tmp2_ = self->priv->apply_button;
			_tmp3_ = self->priv->apply_button_icon;
			g_object_set (_tmp2_, "icon", (GIcon*) _tmp3_, NULL);
			_tmp4_ = self->priv->apply_button_context;
			gtk_style_context_add_class (_tmp4_, "image-button");
		} else {
			GtkStyleContext* _tmp5_;
			GtkModelButton* _tmp6_;
			GtkStyleContext* _tmp7_;
			_tmp5_ = self->priv->apply_button_context;
			gtk_style_context_remove_class (_tmp5_, "image-button");
			_tmp6_ = self->priv->apply_button;
			g_object_set (_tmp6_, "icon", NULL, NULL);
			_tmp7_ = self->priv->apply_button_context;
			gtk_style_context_add_class (_tmp7_, "text-button");
		}
	}
}

void
modifications_revealer_reset_objects (ModificationsRevealer* self,
                                      const gchar* base_path,
                                      GVariant* objects,
                                      gboolean recursively)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (base_path != NULL);
	_modifications_revealer_reset_objects (self, base_path, objects, recursively);
	modifications_revealer_warn_if_no_planned_changes (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_modifications_revealer_reset_objects (ModificationsRevealer* self,
                                       const gchar* base_path,
                                       GVariant* objects,
                                       gboolean recursively)
{
	SettingsModel* model = NULL;
	ModificationsHandler* _tmp0_;
	ModificationsHandler* _tmp1_;
	SettingsModel* _tmp2_;
	SettingsModel* _tmp3_;
	SettingsModel* _tmp4_;
	GVariantIter* iter = NULL;
	GVariantIter* _tmp5_;
	guint16 context_id = 0U;
	gchar* name = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (base_path != NULL);
	if (objects == NULL) {
		return;
	}
	_tmp0_ = modifications_revealer_get_modifications_handler (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = modifications_handler_get_model (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	model = _tmp4_;
	_tmp5_ = g_variant_iter_new ((GVariant*) objects);
	iter = _tmp5_;
	while (TRUE) {
		GVariantIter* _tmp6_;
		guint16 _tmp7_ = 0U;
		gchar* _tmp8_ = NULL;
		gboolean _tmp9_;
		_tmp6_ = iter;
		_tmp9_ = g_variant_iter_next (_tmp6_, "(qs)", &_tmp7_, &_tmp8_, NULL);
		context_id = _tmp7_;
		_g_free0 (name);
		name = _tmp8_;
		if (!_tmp9_) {
			break;
		}
		if (model_utils_is_folder_context_id (context_id)) {
			gchar* full_name = NULL;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = name;
			_tmp11_ = model_utils_recreate_full_name (base_path, _tmp10_, TRUE);
			full_name = _tmp11_;
			if (recursively) {
				const gchar* _tmp12_;
				SettingsModel* _tmp13_;
				const gchar* _tmp14_;
				GVariant* _tmp15_;
				GVariant* _tmp16_;
				_tmp12_ = full_name;
				_tmp13_ = model;
				_tmp14_ = full_name;
				_tmp15_ = settings_model_get_children (_tmp13_, _tmp14_, FALSE, FALSE);
				_tmp16_ = _tmp15_;
				_modifications_revealer_reset_objects (self, _tmp12_, _tmp16_, TRUE);
				_g_variant_unref0 (_tmp16_);
			}
			_g_free0 (full_name);
		} else {
			if (model_utils_is_dconf_context_id (context_id)) {
				gchar* full_name = NULL;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				SettingsModel* _tmp19_;
				const gchar* _tmp20_;
				_tmp17_ = name;
				_tmp18_ = model_utils_recreate_full_name (base_path, _tmp17_, FALSE);
				full_name = _tmp18_;
				_tmp19_ = model;
				_tmp20_ = full_name;
				if (!settings_model_is_key_ghost (_tmp19_, _tmp20_)) {
					ModificationsHandler* _tmp21_;
					ModificationsHandler* _tmp22_;
					const gchar* _tmp23_;
					_tmp21_ = modifications_revealer_get_modifications_handler (self);
					_tmp22_ = _tmp21_;
					_tmp23_ = full_name;
					modifications_handler_add_delayed_setting (_tmp22_, _tmp23_, NULL, MODEL_UTILS_dconf_context_id);
				}
				_g_free0 (full_name);
			} else {
				gchar* full_name = NULL;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				RegistryVariantDict* properties = NULL;
				SettingsModel* _tmp26_;
				const gchar* _tmp27_;
				GVariant* _tmp28_;
				GVariant* _tmp29_;
				RegistryVariantDict* _tmp30_;
				RegistryVariantDict* _tmp31_;
				gboolean is_key_default = FALSE;
				RegistryVariantDict* _tmp32_;
				gboolean _tmp33_ = FALSE;
				gboolean _tmp34_;
				RegistryVariantDict* _tmp35_;
				_tmp24_ = name;
				_tmp25_ = model_utils_recreate_full_name (base_path, _tmp24_, FALSE);
				full_name = _tmp25_;
				_tmp26_ = model;
				_tmp27_ = full_name;
				_tmp28_ = settings_model_get_key_properties (_tmp26_, _tmp27_, context_id, (guint16) PROPERTY_QUERY_IS_DEFAULT);
				_tmp29_ = _tmp28_;
				_tmp30_ = registry_variant_dict_new_from_aqv (_tmp29_);
				_tmp31_ = _tmp30_;
				_g_variant_unref0 (_tmp29_);
				properties = _tmp31_;
				_tmp32_ = properties;
				_tmp34_ = registry_variant_dict_lookup (_tmp32_, (guint16) PROPERTY_QUERY_IS_DEFAULT, "b", &_tmp33_, NULL);
				is_key_default = _tmp33_;
				if (!_tmp34_) {
					g_assert_not_reached ();
				}
				_tmp35_ = properties;
				registry_variant_dict_clear (_tmp35_);
				if (!is_key_default) {
					ModificationsHandler* _tmp36_;
					ModificationsHandler* _tmp37_;
					const gchar* _tmp38_;
					_tmp36_ = modifications_revealer_get_modifications_handler (self);
					_tmp37_ = _tmp36_;
					_tmp38_ = full_name;
					modifications_handler_add_delayed_setting (_tmp37_, _tmp38_, NULL, context_id);
				}
				_g_object_unref0 (properties);
				_g_free0 (full_name);
			}
		}
	}
	_g_free0 (name);
	_g_variant_iter_free0 (iter);
	_g_object_unref0 (model);
}

static void
modifications_revealer_warn_if_no_planned_changes (ModificationsRevealer* self)
{
	gboolean _tmp0_ = FALSE;
	ModificationsHandler* _tmp1_;
	ModificationsHandler* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp1_ = modifications_revealer_get_modifications_handler (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = modifications_handler_get_dconf_changes_count (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == ((guint) 0)) {
		ModificationsHandler* _tmp5_;
		ModificationsHandler* _tmp6_;
		guint _tmp7_;
		guint _tmp8_;
		_tmp5_ = modifications_revealer_get_modifications_handler (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = modifications_handler_get_gsettings_changes_count (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = _tmp8_ == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkLabel* _tmp9_;
		_tmp9_ = self->priv->label;
		gtk_label_set_text (_tmp9_, _ ("Nothing to reset."));
	}
}

gboolean
modifications_revealer_next_match (ModificationsRevealer* self)
{
	ModificationsList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->modifications_list;
	result = overlayed_list_next_match ((OverlayedList*) _tmp0_);
	return result;
}

gboolean
modifications_revealer_previous_match (ModificationsRevealer* self)
{
	ModificationsList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->modifications_list;
	result = overlayed_list_previous_match ((OverlayedList*) _tmp0_);
	return result;
}

gboolean
modifications_revealer_handle_copy_text (ModificationsRevealer* self,
                                         gchar** copy_text)
{
	gchar* _vala_copy_text = NULL;
	GtkMenuButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->delayed_list_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ModificationsList* _tmp3_;
		gchar* _tmp4_ = NULL;
		gboolean _tmp5_;
		_tmp3_ = self->priv->modifications_list;
		_tmp5_ = overlayed_list_handle_copy_text ((OverlayedList*) _tmp3_, &_tmp4_);
		_g_free0 (_vala_copy_text);
		_vala_copy_text = _tmp4_;
		result = _tmp5_;
		if (copy_text) {
			*copy_text = _vala_copy_text;
		} else {
			_g_free0 (_vala_copy_text);
		}
		return result;
	}
	_tmp7_ = base_window_no_copy_text (&_tmp6_);
	_g_free0 (_vala_copy_text);
	_vala_copy_text = _tmp6_;
	result = _tmp7_;
	if (copy_text) {
		*copy_text = _vala_copy_text;
	} else {
		_g_free0 (_vala_copy_text);
	}
	return result;
}

gboolean
modifications_revealer_dismiss_selected_modification (ModificationsRevealer* self)
{
	GtkMenuButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* selected_row_name = NULL;
	ModificationsList* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	ModificationsHandler* _tmp6_;
	ModificationsHandler* _tmp7_;
	const gchar* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->delayed_list_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->modifications_list;
	_tmp4_ = modifications_list_get_selected_row_name (_tmp3_);
	selected_row_name = _tmp4_;
	_tmp5_ = selected_row_name;
	if (_tmp5_ == NULL) {
		result = FALSE;
		_g_free0 (selected_row_name);
		return result;
	}
	_tmp6_ = modifications_revealer_get_modifications_handler (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = selected_row_name;
	modifications_handler_dismiss_change (_tmp7_, (const gchar*) _tmp8_);
	modifications_revealer_update (self);
	result = TRUE;
	_g_free0 (selected_row_name);
	return result;
}

void
modifications_revealer_hide_modifications_list (ModificationsRevealer* self)
{
	GtkPopover* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->delayed_settings_list_popover;
	gtk_popover_popdown (_tmp0_);
}

void
modifications_revealer_toggle_modifications_list (ModificationsRevealer* self)
{
	GtkMenuButton* _tmp0_;
	GtkPopover* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->delayed_list_button;
	_tmp1_ = self->priv->delayed_settings_list_popover;
	_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, !_tmp3_);
}

gboolean
modifications_revealer_get_modifications_list_state (ModificationsRevealer* self)
{
	GtkMenuButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->delayed_list_button;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static GtkWidget*
modifications_revealer_delayed_setting_row_create (ModificationsRevealer* self,
                                                   GObject* object)
{
	SimpleSettingObject* sso = NULL;
	SimpleSettingObject* _tmp0_;
	ModificationsHandler* _tmp1_;
	ModificationsHandler* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	guint16 _tmp7_;
	guint16 _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object != NULL, NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SIMPLE_SETTING_OBJECT, SimpleSettingObject));
	sso = _tmp0_;
	_tmp1_ = modifications_revealer_get_modifications_handler (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = simple_setting_object_get_name (sso);
	_tmp4_ = _tmp3_;
	_tmp5_ = simple_setting_object_get_full_name (sso);
	_tmp6_ = _tmp5_;
	_tmp7_ = simple_setting_object_get_context_id (sso);
	_tmp8_ = _tmp7_;
	_tmp9_ = modifications_revealer_create_delayed_setting_row (_tmp2_, _tmp4_, _tmp6_, _tmp8_);
	result = _tmp9_;
	_g_object_unref0 (sso);
	return result;
}

GtkWidget*
modifications_revealer_create_delayed_setting_row (ModificationsHandler* modifications_handler,
                                                   const gchar* name,
                                                   const gchar* full_name,
                                                   guint16 context_id)
{
	SettingsModel* model = NULL;
	SettingsModel* _tmp0_;
	SettingsModel* _tmp1_;
	SettingsModel* _tmp2_;
	RegistryVariantDict* properties = NULL;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	RegistryVariantDict* _tmp5_;
	RegistryVariantDict* _tmp6_;
	gboolean has_schema = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	gboolean has_schema_and_is_default = FALSE;
	GVariant* planned_value = NULL;
	GVariant* _tmp11_;
	gchar* cool_planned_value = NULL;
	GVariant* _tmp12_;
	gchar* cool_default_value = NULL;
	gboolean _tmp15_ = FALSE;
	GVariant* key_value = NULL;
	GVariant* _tmp18_ = NULL;
	gboolean _tmp19_;
	DelayedSettingView* view = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	DelayedSettingView* _tmp22_;
	DelayedSettingView* _tmp32_;
	GtkWidget* result;
	g_return_val_if_fail (modifications_handler != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (full_name != NULL, NULL);
	_tmp0_ = modifications_handler_get_model (modifications_handler);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = settings_model_get_key_properties (model, full_name, context_id, (guint16) (((PROPERTY_QUERY_HAS_SCHEMA & PROPERTY_QUERY_IS_DEFAULT) & PROPERTY_QUERY_DEFAULT_VALUE) & PROPERTY_QUERY_KEY_VALUE));
	_tmp4_ = _tmp3_;
	_tmp5_ = registry_variant_dict_new_from_aqv (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_variant_unref0 (_tmp4_);
	properties = _tmp6_;
	_tmp8_ = registry_variant_dict_lookup (properties, (guint16) PROPERTY_QUERY_HAS_SCHEMA, "b", &_tmp7_, NULL);
	has_schema = _tmp7_;
	if (!_tmp8_) {
		g_assert_not_reached ();
	}
	if (!has_schema) {
		has_schema_and_is_default = FALSE;
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_;
		_tmp10_ = registry_variant_dict_lookup (properties, (guint16) PROPERTY_QUERY_IS_DEFAULT, "b", &_tmp9_, NULL);
		has_schema_and_is_default = _tmp9_;
		if (!_tmp10_) {
			g_assert_not_reached ();
		}
	}
	_tmp11_ = modifications_handler_get_key_planned_value (modifications_handler, full_name);
	planned_value = _tmp11_;
	cool_planned_value = NULL;
	_tmp12_ = planned_value;
	if (_tmp12_ != NULL) {
		GVariant* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = planned_value;
		_tmp14_ = key_cool_text_value_from_variant ((GVariant*) _tmp13_);
		_g_free0 (cool_planned_value);
		cool_planned_value = _tmp14_;
	}
	cool_default_value = NULL;
	if (has_schema) {
		gchar* _tmp16_ = NULL;
		gboolean _tmp17_;
		_tmp17_ = registry_variant_dict_lookup (properties, (guint16) PROPERTY_QUERY_DEFAULT_VALUE, "s", &_tmp16_, NULL);
		_g_free0 (cool_default_value);
		cool_default_value = _tmp16_;
		_tmp15_ = !_tmp17_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		g_assert_not_reached ();
	}
	_tmp19_ = registry_variant_dict_lookup (properties, (guint16) PROPERTY_QUERY_KEY_VALUE, "v", &_tmp18_, NULL);
	_g_variant_unref0 (key_value);
	key_value = _tmp18_;
	if (!_tmp19_) {
		g_assert_not_reached ();
	}
	registry_variant_dict_clear (properties);
	_tmp20_ = cool_planned_value;
	_tmp21_ = cool_default_value;
	_tmp22_ = delayed_setting_view_new (name, full_name, context_id, has_schema_and_is_default, key_value, _tmp20_, _tmp21_);
	g_object_ref_sink (_tmp22_);
	view = _tmp22_;
	if (modifications_handler_get_current_delay_mode (modifications_handler)) {
		GVariant* variant = NULL;
		GVariant* _tmp23_;
		DelayedSettingView* _tmp24_;
		GVariant* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp23_ = g_variant_new ("(sq)", full_name, context_id, NULL);
		g_variant_ref_sink (_tmp23_);
		variant = _tmp23_;
		_tmp24_ = view;
		_tmp25_ = variant;
		_tmp26_ = g_variant_print (_tmp25_, TRUE);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat ("browser.open-object(", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp29_, ")", NULL);
		_tmp31_ = _tmp30_;
		gtk_actionable_set_detailed_action_name ((GtkActionable*) _tmp24_, _tmp31_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_variant_unref0 (variant);
	}
	_tmp32_ = view;
	gtk_widget_show ((GtkWidget*) _tmp32_);
	result = (GtkWidget*) view;
	_g_variant_unref0 (key_value);
	_g_free0 (cool_default_value);
	_g_free0 (cool_planned_value);
	_g_variant_unref0 (planned_value);
	_g_object_unref0 (properties);
	_g_object_unref0 (model);
	return result;
}

void
modifications_revealer_gkey_value_push (ModificationsRevealer* self,
                                        const gchar* full_name,
                                        guint16 context_id,
                                        GVariant* key_value,
                                        gboolean is_key_default)
{
	ModificationsList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	g_return_if_fail (key_value != NULL);
	_tmp0_ = self->priv->modifications_list;
	modifications_list_gkey_value_push (_tmp0_, full_name, context_id, key_value, is_key_default);
}

void
modifications_revealer_dkey_value_push (ModificationsRevealer* self,
                                        const gchar* full_name,
                                        GVariant* key_value_or_null)
{
	ModificationsList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (full_name != NULL);
	_tmp0_ = self->priv->modifications_list;
	modifications_list_dkey_value_push (_tmp0_, full_name, key_value_or_null);
}

static GtkWidget*
_modifications_revealer_delayed_setting_row_create_gtk_list_box_create_widget_func (GObject* item,
                                                                                    gpointer self)
{
	GtkWidget* result;
	result = modifications_revealer_delayed_setting_row_create ((ModificationsRevealer*) self, item);
	return result;
}

static void
modifications_revealer_update (ModificationsRevealer* self)
{
	GListStore* modifications_liststore = NULL;
	ModificationsHandler* _tmp0_;
	ModificationsHandler* _tmp1_;
	GListStore* _tmp2_;
	ModificationsList* _tmp3_;
	GListStore* _tmp4_;
	GListStore* _tmp5_;
	ModificationsHandler* _tmp7_;
	ModificationsHandler* _tmp8_;
	ModificationsMode _tmp9_;
	ModificationsMode _tmp10_;
	guint total_changes_count = 0U;
	ModificationsHandler* _tmp13_;
	ModificationsHandler* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	ModificationsHandler* _tmp17_;
	ModificationsHandler* _tmp18_;
	guint _tmp19_;
	guint _tmp20_;
	ModificationsHandler* _tmp21_;
	ModificationsHandler* _tmp22_;
	ModificationsMode _tmp23_;
	ModificationsMode _tmp24_;
	g_return_if_fail (self != NULL);
	if (self->priv->disable_action_bar) {
		gtk_revealer_set_reveal_child ((GtkRevealer*) self, FALSE);
		return;
	}
	_tmp0_ = modifications_revealer_get_modifications_handler (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = modifications_handler_get_delayed_settings (_tmp1_);
	modifications_liststore = _tmp2_;
	_tmp3_ = self->priv->modifications_list;
	_tmp4_ = modifications_liststore;
	modifications_list_bind_model (_tmp3_, _tmp4_, _modifications_revealer_delayed_setting_row_create_gtk_list_box_create_widget_func, self);
	_tmp5_ = modifications_liststore;
	if (g_list_model_get_n_items ((GListModel*) _tmp5_) == ((guint) 0)) {
		GtkPopover* _tmp6_;
		_tmp6_ = self->priv->delayed_settings_list_popover;
		gtk_popover_popdown (_tmp6_);
	}
	_tmp7_ = modifications_revealer_get_modifications_handler (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = modifications_handler_get_mode (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == MODIFICATIONS_MODE_NONE) {
		GtkModelButton* _tmp11_;
		GtkLabel* _tmp12_;
		gtk_revealer_set_reveal_child ((GtkRevealer*) self, FALSE);
		_tmp11_ = self->priv->apply_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
		_tmp12_ = self->priv->label;
		gtk_label_set_text (_tmp12_, "");
		_g_object_unref0 (modifications_liststore);
		return;
	}
	_tmp13_ = modifications_revealer_get_modifications_handler (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = modifications_handler_get_dconf_changes_count (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = modifications_revealer_get_modifications_handler (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = modifications_handler_get_gsettings_changes_count (_tmp18_);
	_tmp20_ = _tmp19_;
	total_changes_count = _tmp16_ + _tmp20_;
	_tmp21_ = modifications_revealer_get_modifications_handler (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = modifications_handler_get_mode (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ == MODIFICATIONS_MODE_TEMPORARY) {
		if (total_changes_count == ((guint) 0)) {
			GtkModelButton* _tmp25_;
			GtkLabel* _tmp26_;
			_tmp25_ = self->priv->apply_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, FALSE);
			_tmp26_ = self->priv->label;
			gtk_label_set_text (_tmp26_, _ ("The value is invalid."));
		} else {
			if (total_changes_count != ((guint) 1)) {
				g_assert_not_reached ();
			} else {
				ModificationsHandler* _tmp27_;
				ModificationsHandler* _tmp28_;
				Behaviour _tmp29_;
				Behaviour _tmp30_;
				_tmp27_ = modifications_revealer_get_modifications_handler (self);
				_tmp28_ = _tmp27_;
				_tmp29_ = modifications_handler_get_behaviour (_tmp28_);
				_tmp30_ = _tmp29_;
				if (_tmp30_ == BEHAVIOUR_ALWAYS_CONFIRM_EXPLICIT) {
					GtkModelButton* _tmp31_;
					GtkLabel* _tmp32_;
					_tmp31_ = self->priv->apply_button;
					gtk_widget_set_sensitive ((GtkWidget*) _tmp31_, TRUE);
					_tmp32_ = self->priv->label;
					gtk_label_set_text (_tmp32_, _ ("The change will be dismissed if you quit this view without applying."));
				} else {
					gboolean _tmp33_ = FALSE;
					ModificationsHandler* _tmp34_;
					ModificationsHandler* _tmp35_;
					Behaviour _tmp36_;
					Behaviour _tmp37_;
					_tmp34_ = modifications_revealer_get_modifications_handler (self);
					_tmp35_ = _tmp34_;
					_tmp36_ = modifications_handler_get_behaviour (_tmp35_);
					_tmp37_ = _tmp36_;
					if (_tmp37_ == BEHAVIOUR_ALWAYS_CONFIRM_IMPLICIT) {
						_tmp33_ = TRUE;
					} else {
						ModificationsHandler* _tmp38_;
						ModificationsHandler* _tmp39_;
						Behaviour _tmp40_;
						Behaviour _tmp41_;
						_tmp38_ = modifications_revealer_get_modifications_handler (self);
						_tmp39_ = _tmp38_;
						_tmp40_ = modifications_handler_get_behaviour (_tmp39_);
						_tmp41_ = _tmp40_;
						_tmp33_ = _tmp41_ == BEHAVIOUR_SAFE;
					}
					if (_tmp33_) {
						GtkModelButton* _tmp42_;
						GtkLabel* _tmp43_;
						_tmp42_ = self->priv->apply_button;
						gtk_widget_set_sensitive ((GtkWidget*) _tmp42_, TRUE);
						_tmp43_ = self->priv->label;
						gtk_label_set_text (_tmp43_, _ ("The change will be applied on such request or if you quit this view."));
					} else {
						g_assert_not_reached ();
					}
				}
			}
		}
		gtk_revealer_set_reveal_child ((GtkRevealer*) self, TRUE);
	} else {
		GtkModelButton* _tmp45_;
		GtkLabel* _tmp46_;
		ModificationsHandler* _tmp47_;
		ModificationsHandler* _tmp48_;
		guint _tmp49_;
		guint _tmp50_;
		ModificationsHandler* _tmp51_;
		ModificationsHandler* _tmp52_;
		guint _tmp53_;
		guint _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		if (total_changes_count == ((guint) 0)) {
			GtkLabel* _tmp44_;
			_tmp44_ = self->priv->label;
			gtk_label_set_text (_tmp44_, _ ("Nothing to reset."));
		}
		_tmp45_ = self->priv->apply_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp45_, total_changes_count > ((guint) 0));
		_tmp46_ = self->priv->label;
		_tmp47_ = modifications_revealer_get_modifications_handler (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = modifications_handler_get_dconf_changes_count (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = modifications_revealer_get_modifications_handler (self);
		_tmp52_ = _tmp51_;
		_tmp53_ = modifications_handler_get_gsettings_changes_count (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = modifications_revealer_get_text (_tmp50_, _tmp54_);
		_tmp56_ = _tmp55_;
		gtk_label_set_text (_tmp46_, _tmp56_);
		_g_free0 (_tmp56_);
		gtk_revealer_set_reveal_child ((GtkRevealer*) self, TRUE);
	}
	_g_object_unref0 (modifications_liststore);
}

static gchar*
modifications_revealer_get_text (guint dconf,
                                 guint gsettings)
{
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	if (dconf == ((guint) 0)) {
		gchar* _tmp1_;
		if (gsettings == ((guint) 0)) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Changes will be delayed until you request it."));
			result = _tmp0_;
			return result;
		}
		_tmp1_ = g_strdup_printf (ngettext ("One gsettings operation delayed.", "%u gsettings operations delayed.", (gulong) gsettings), gsettings);
		result = _tmp1_;
		return result;
	}
	if (gsettings == ((guint) 0)) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup_printf (ngettext ("One dconf operation delayed.", "%u dconf operations delayed.", (gulong) dconf), dconf);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_strdup_printf (ngettext ("One gsettings operation", "%u gsettings operations", (gulong) gsettings), gsettings);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf (ngettext (" and one dconf operation delayed.", " and %u dconf operations delayed.", (gulong) dconf), dconf);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf (_ ("%s%s"), _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	result = _tmp8_;
	return result;
}

ModificationsRevealer*
modifications_revealer_construct (GType object_type)
{
	ModificationsRevealer * self = NULL;
	self = (ModificationsRevealer*) g_object_new (object_type, NULL);
	return self;
}

ModificationsRevealer*
modifications_revealer_new (void)
{
	return modifications_revealer_construct (TYPE_MODIFICATIONS_REVEALER);
}

static ModificationsHandler*
modifications_revealer_get_modifications_handler (ModificationsRevealer* self)
{
	ModificationsHandler* result;
	ModificationsHandler* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_modifications_handler;
	result = _tmp0_;
	return result;
}

static void
_modifications_revealer_update_modifications_handler_delayed_changes_changed (ModificationsHandler* _sender,
                                                                              gpointer self)
{
	modifications_revealer_update ((ModificationsRevealer*) self);
}

void
modifications_revealer_set_modifications_handler (ModificationsRevealer* self,
                                                  ModificationsHandler* value)
{
	ModificationsHandler* _tmp0_;
	ModificationsHandler* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_modifications_handler);
	self->priv->_modifications_handler = _tmp0_;
	_tmp1_ = self->priv->_modifications_handler;
	g_signal_connect_object (_tmp1_, "delayed-changes-changed", (GCallback) _modifications_revealer_update_modifications_handler_delayed_changes_changed, self, 0);
}

static GObject *
modifications_revealer_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ModificationsRevealer * self;
	GtkModelButton* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkModelButton* _tmp3_;
	GtkModelButton* _tmp4_;
	GtkStyleContext* _tmp5_;
	parent_class = G_OBJECT_CLASS (modifications_revealer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MODIFICATIONS_REVEALER, ModificationsRevealer);
	_tmp0_ = self->priv->apply_button;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->apply_button_context);
	self->priv->apply_button_context = _tmp2_;
	_tmp3_ = self->priv->apply_button;
	g_object_set (_tmp3_, "icon", NULL, NULL);
	_tmp4_ = self->priv->apply_button;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, "text-button");
	return obj;
}

static void
modifications_revealer_class_init (ModificationsRevealerClass * klass,
                                   gpointer klass_data)
{
	modifications_revealer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ModificationsRevealer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_modifications_revealer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_modifications_revealer_set_property;
	G_OBJECT_CLASS (klass)->constructor = modifications_revealer_constructor;
	G_OBJECT_CLASS (klass)->finalize = modifications_revealer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MODIFICATIONS_REVEALER_MODIFICATIONS_HANDLER_PROPERTY, modifications_revealer_properties[MODIFICATIONS_REVEALER_MODIFICATIONS_HANDLER_PROPERTY] = g_param_spec_object ("modifications-handler", "modifications-handler", "modifications-handler", TYPE_MODIFICATIONS_HANDLER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/modifications-revealer.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label", FALSE, ModificationsRevealer_private_offset + G_STRUCT_OFFSET (ModificationsRevealerPrivate, label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "apply_button", FALSE, ModificationsRevealer_private_offset + G_STRUCT_OFFSET (ModificationsRevealerPrivate, apply_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delayed_list_button", FALSE, ModificationsRevealer_private_offset + G_STRUCT_OFFSET (ModificationsRevealerPrivate, delayed_list_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delayed_settings_list_popover", FALSE, ModificationsRevealer_private_offset + G_STRUCT_OFFSET (ModificationsRevealerPrivate, delayed_settings_list_popover));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "modifications_list", FALSE, ModificationsRevealer_private_offset + G_STRUCT_OFFSET (ModificationsRevealerPrivate, modifications_list));
}

static void
modifications_revealer_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                         gpointer iface_data)
{
	modifications_revealer_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) modifications_revealer_real_set_window_size;
}

static void
modifications_revealer_instance_init (ModificationsRevealer * self,
                                      gpointer klass)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GThemedIcon* _tmp3_;
	self->priv = modifications_revealer_get_instance_private (self);
	self->priv->disable_action_bar = FALSE;
	self->priv->short_size_button = FALSE;
	_tmp0_ = g_strdup ("object-select-symbolic");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = (GThemedIcon*) g_themed_icon_new_from_names (_tmp2_, 1);
	self->priv->apply_button_icon = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	g_type_ensure (TYPE_MODIFICATIONS_LIST);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
modifications_revealer_finalize (GObject * obj)
{
	ModificationsRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MODIFICATIONS_REVEALER, ModificationsRevealer);
	_g_object_unref0 (self->priv->_modifications_handler);
	_g_object_unref0 (self->priv->apply_button_context);
	_g_object_unref0 (self->priv->apply_button_icon);
	G_OBJECT_CLASS (modifications_revealer_parent_class)->finalize (obj);
}

static GType
modifications_revealer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ModificationsRevealerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) modifications_revealer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ModificationsRevealer), 0, (GInstanceInitFunc) modifications_revealer_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) modifications_revealer_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType modifications_revealer_type_id;
	modifications_revealer_type_id = g_type_register_static (gtk_revealer_get_type (), "ModificationsRevealer", &g_define_type_info, 0);
	g_type_add_interface_static (modifications_revealer_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	ModificationsRevealer_private_offset = g_type_add_instance_private (modifications_revealer_type_id, sizeof (ModificationsRevealerPrivate));
	return modifications_revealer_type_id;
}

GType
modifications_revealer_get_type (void)
{
	static volatile gsize modifications_revealer_type_id__once = 0;
	if (g_once_init_enter (&modifications_revealer_type_id__once)) {
		GType modifications_revealer_type_id;
		modifications_revealer_type_id = modifications_revealer_get_type_once ();
		g_once_init_leave (&modifications_revealer_type_id__once, modifications_revealer_type_id);
	}
	return modifications_revealer_type_id__once;
}

static void
_vala_modifications_revealer_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	ModificationsRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MODIFICATIONS_REVEALER, ModificationsRevealer);
	switch (property_id) {
		case MODIFICATIONS_REVEALER_MODIFICATIONS_HANDLER_PROPERTY:
		g_value_set_object (value, modifications_revealer_get_modifications_handler (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_modifications_revealer_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	ModificationsRevealer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MODIFICATIONS_REVEALER, ModificationsRevealer);
	switch (property_id) {
		case MODIFICATIONS_REVEALER_MODIFICATIONS_HANDLER_PROPERTY:
		modifications_revealer_set_modifications_handler (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

