/* adaptative-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from adaptative-window.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>

#define LARGE_WINDOW_SIZE 1042
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_ADAPTATIVE_WINDOW (adaptative_window_get_type ())
#define ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow))
#define ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))
#define IS_ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WINDOW))
#define IS_ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADAPTATIVE_WINDOW))
#define ADAPTATIVE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))

typedef struct _AdaptativeWindow AdaptativeWindow;
typedef struct _AdaptativeWindowClass AdaptativeWindowClass;
typedef struct _AdaptativeWindowPrivate AdaptativeWindowPrivate;

#define TYPE_BASE_HEADER_BAR (base_header_bar_get_type ())
#define BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBar))
#define BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))
#define IS_BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_HEADER_BAR))
#define IS_BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_HEADER_BAR))
#define BASE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))

typedef struct _BaseHeaderBar BaseHeaderBar;
typedef struct _BaseHeaderBarClass BaseHeaderBarClass;
enum  {
	ADAPTATIVE_WINDOW_0_PROPERTY,
	ADAPTATIVE_WINDOW_NTA_HEADERBAR_PROPERTY,
	ADAPTATIVE_WINDOW_WINDOW_TITLE_PROPERTY,
	ADAPTATIVE_WINDOW_SPECIFIC_CSS_CLASS_OR_EMPTY_PROPERTY,
	ADAPTATIVE_WINDOW_SCHEMA_PATH_PROPERTY,
	ADAPTATIVE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* adaptative_window_properties[ADAPTATIVE_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
enum  {
	ADAPTATIVE_WINDOW_GTK_THEME_CHANGED_SIGNAL,
	ADAPTATIVE_WINDOW_NUM_SIGNALS
};
static guint adaptative_window_signals[ADAPTATIVE_WINDOW_NUM_SIGNALS] = {0};

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _AdaptativeWindow {
	GtkApplicationWindow parent_instance;
	AdaptativeWindowPrivate * priv;
};

struct _AdaptativeWindowClass {
	GtkApplicationWindowClass parent_class;
	void (*before_destroy) (AdaptativeWindow* self);
};

struct _AdaptativeWindowPrivate {
	BaseHeaderBar* headerbar;
	GtkStyleContext* window_style_context;
	AdaptativeWidgetWindowSize window_size;
	GList* adaptative_children;
	gboolean has_extra_thin_window_class;
	gboolean has_thin_window_class;
	gboolean has_large_window_class;
	gboolean has_extra_flat_window_class;
	gboolean has_flat_window_class;
	GSettings* settings;
	gint window_width;
	gint window_height;
	gboolean window_is_maximized;
	gboolean window_is_tiled;
	gboolean highcontrast_state;
};

struct _Block1Data {
	int _ref_count_;
	AdaptativeWindow* self;
	AdaptativeWidgetWindowSize new_window_size;
};

static gint AdaptativeWindow_private_offset;
static gpointer adaptative_window_parent_class = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN gboolean adaptative_widget_window_size_is_phone_size (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_thin (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_flat (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_quite_thin (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static GType adaptative_widget_get_type_once (void);
VALA_EXTERN GType adaptative_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWindow, g_object_unref)
VALA_EXTERN GType base_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseHeaderBar, g_object_unref)
VALA_EXTERN void adaptative_window_before_destroy (AdaptativeWindow* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean adaptative_window_on_window_state_event (AdaptativeWindow* self,
                                                  GtkWidget* widget,
                                                  GdkEventWindowState* event);
static gboolean _adaptative_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                                 GdkEventWindowState* event,
                                                                                 gpointer self);
static void adaptative_window_on_size_allocate (AdaptativeWindow* self,
                                         GtkAllocation* allocation);
static void adaptative_window_update_adaptative_children (AdaptativeWindow* self,
                                                   gint* width,
                                                   gint* height);
static void adaptative_window_update_window_state (AdaptativeWindow* self);
static void _adaptative_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                   GtkAllocation* allocation,
                                                                   gpointer self);
static void adaptative_window_on_destroy (AdaptativeWindow* self);
static void adaptative_window_save_window_state (AdaptativeWindow* self);
static void _adaptative_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender,
                                                       gpointer self);
static void adaptative_window_real_before_destroy (AdaptativeWindow* self);
VALA_EXTERN void adaptative_window_add_adaptative_child (AdaptativeWindow* self,
                                             AdaptativeWidget* child);
static void adaptative_window_change_window_size (AdaptativeWindow* self,
                                           AdaptativeWidgetWindowSize new_window_size);
static void adaptative_window_set_style_classes (AdaptativeWindow* self,
                                          gboolean extra_thin_window,
                                          gboolean thin_window,
                                          gboolean large_window,
                                          gboolean extra_flat_window,
                                          gboolean flat_window);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_,
                 AdaptativeWidget* adaptative_child);
static void ___lambda5__gfunc (gconstpointer data,
                        gpointer self);
static inline void adaptative_window_set_style_class (AdaptativeWindow* self,
                                        const gchar* class_name,
                                        gboolean new_state,
                                        gboolean* old_state);
static void adaptative_window_load_window_state (AdaptativeWindow* self);
static gint* _int_dup (gint* self);
static void adaptative_window_manage_high_contrast (AdaptativeWindow* self);
static void adaptative_window_update_highcontrast_state (AdaptativeWindow* self,
                                                  GObject* gtk_settings,
                                                  GParamSpec* unused);
static void _adaptative_window_update_highcontrast_state_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void _adaptative_window_update_highcontrast_state (AdaptativeWindow* self,
                                                   const gchar* theme_name);
VALA_EXTERN void base_header_bar_update_hamburger_menu (BaseHeaderBar* self);
VALA_EXTERN AdaptativeWindow* adaptative_window_construct (GType object_type);
VALA_EXTERN BaseHeaderBar* adaptative_window_get_nta_headerbar (AdaptativeWindow* self);
static void adaptative_window_set_nta_headerbar (AdaptativeWindow* self,
                                          BaseHeaderBar* value);
static void adaptative_window_set_window_title (AdaptativeWindow* self,
                                         const gchar* value);
static void adaptative_window_set_specific_css_class_or_empty (AdaptativeWindow* self,
                                                        const gchar* value);
static void adaptative_window_set_schema_path (AdaptativeWindow* self,
                                        const gchar* value);
static GObject * adaptative_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static gboolean _adaptative_window___lambda6_ (AdaptativeWindow* self);
static gboolean __adaptative_window___lambda6__gsource_func (gpointer self);
static void adaptative_window_finalize (GObject * obj);
static GType adaptative_window_get_type_once (void);
static void _vala_adaptative_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_adaptative_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

inline gboolean
adaptative_widget_window_size_is_phone_size (AdaptativeWidgetWindowSize window_size)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if (window_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = window_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = window_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL;
	}
	result = _tmp0_;
	return result;
}

inline gboolean
adaptative_widget_window_size_is_extra_thin (AdaptativeWidgetWindowSize window_size)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if (window_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = window_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = window_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN;
	}
	result = _tmp0_;
	return result;
}

inline gboolean
adaptative_widget_window_size_is_extra_flat (AdaptativeWidgetWindowSize window_size)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if (window_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = window_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = window_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT;
	}
	result = _tmp0_;
	return result;
}

inline gboolean
adaptative_widget_window_size_is_quite_thin (AdaptativeWidgetWindowSize window_size)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if (adaptative_widget_window_size_is_extra_thin (window_size)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = window_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = window_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN;
	}
	result = _tmp0_;
	return result;
}

static GType
adaptative_widget_window_size_get_type_once (void)
{
	static const GEnumValue values[] = {{ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE, "ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE", "start-size"}, {ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE, "ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE", "usual-size"}, {ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN, "ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN", "quite-thin"}, {ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT, "ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT", "phone-vert"}, {ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL, "ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL", "phone-hztl"}, {ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH, "ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH", "phone-both"}, {ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN, "ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN", "extra-thin"}, {ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT, "ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT", "extra-flat"}, {0, NULL, NULL}};
	GType adaptative_widget_window_size_type_id;
	adaptative_widget_window_size_type_id = g_enum_register_static ("AdaptativeWidgetWindowSize", values);
	return adaptative_widget_window_size_type_id;
}

GType
adaptative_widget_window_size_get_type (void)
{
	static volatile gsize adaptative_widget_window_size_type_id__once = 0;
	if (g_once_init_enter (&adaptative_widget_window_size_type_id__once)) {
		GType adaptative_widget_window_size_type_id;
		adaptative_widget_window_size_type_id = adaptative_widget_window_size_get_type_once ();
		g_once_init_leave (&adaptative_widget_window_size_type_id__once, adaptative_widget_window_size_type_id);
	}
	return adaptative_widget_window_size_type_id__once;
}

void
adaptative_widget_set_window_size (AdaptativeWidget* self,
                                   AdaptativeWidgetWindowSize new_size)
{
	AdaptativeWidgetIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ADAPTATIVE_WIDGET_GET_INTERFACE (self);
	if (_iface_->set_window_size) {
		_iface_->set_window_size (self, new_size);
	}
}

static void
adaptative_widget_default_init (AdaptativeWidgetIface * iface,
                                gpointer iface_data)
{
}

static GType
adaptative_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AdaptativeWidgetIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) adaptative_widget_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType adaptative_widget_type_id;
	adaptative_widget_type_id = g_type_register_static (G_TYPE_INTERFACE, "AdaptativeWidget", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (adaptative_widget_type_id, G_TYPE_OBJECT);
	return adaptative_widget_type_id;
}

GType
adaptative_widget_get_type (void)
{
	static volatile gsize adaptative_widget_type_id__once = 0;
	if (g_once_init_enter (&adaptative_widget_type_id__once)) {
		GType adaptative_widget_type_id;
		adaptative_widget_type_id = adaptative_widget_get_type_once ();
		g_once_init_leave (&adaptative_widget_type_id__once, adaptative_widget_type_id);
	}
	return adaptative_widget_type_id__once;
}

static inline gpointer
adaptative_window_get_instance_private (AdaptativeWindow* self)
{
	return G_STRUCT_MEMBER_P (self, AdaptativeWindow_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
adaptative_window_on_window_state_event (AdaptativeWindow* self,
                                         GtkWidget* widget,
                                         GdkEventWindowState* event)
{
	GdkWindowState tiled_state = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if ((event->changed_mask & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		self->priv->window_is_maximized = (event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	tiled_state = (((GDK_WINDOW_STATE_TILED | GDK_WINDOW_STATE_TOP_TILED) | GDK_WINDOW_STATE_BOTTOM_TILED) | GDK_WINDOW_STATE_LEFT_TILED) | GDK_WINDOW_STATE_RIGHT_TILED;
	if ((event->changed_mask & tiled_state) != 0) {
		self->priv->window_is_tiled = (event->new_window_state & tiled_state) != 0;
	}
	result = FALSE;
	return result;
}

static gboolean
_adaptative_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                        GdkEventWindowState* event,
                                                                        gpointer self)
{
	gboolean result;
	result = adaptative_window_on_window_state_event ((AdaptativeWindow*) self, _sender, event);
	return result;
}

static void
adaptative_window_on_size_allocate (AdaptativeWindow* self,
                                    GtkAllocation* allocation)
{
	gint height = 0;
	GtkAllocation _tmp0_;
	gint width = 0;
	GtkAllocation _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	height = _tmp0_.height;
	_tmp1_ = *allocation;
	width = _tmp1_.width;
	adaptative_window_update_adaptative_children (self, &width, &height);
	adaptative_window_update_window_state (self);
}

static void
_adaptative_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                              GtkAllocation* allocation,
                                                              gpointer self)
{
	adaptative_window_on_size_allocate ((AdaptativeWindow*) self, allocation);
}

static void
adaptative_window_on_destroy (AdaptativeWindow* self)
{
	g_return_if_fail (self != NULL);
	adaptative_window_before_destroy (self);
	adaptative_window_save_window_state (self);
	GTK_WIDGET_CLASS (adaptative_window_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow));
}

static void
_adaptative_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender,
                                                  gpointer self)
{
	adaptative_window_on_destroy ((AdaptativeWindow*) self);
}

static void
adaptative_window_real_before_destroy (AdaptativeWindow* self)
{
}

void
adaptative_window_before_destroy (AdaptativeWindow* self)
{
	AdaptativeWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ADAPTATIVE_WINDOW_GET_CLASS (self);
	if (_klass_->before_destroy) {
		_klass_->before_destroy (self);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
adaptative_window_add_adaptative_child (AdaptativeWindow* self,
                                        AdaptativeWidget* child)
{
	AdaptativeWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (child);
	self->priv->adaptative_children = g_list_append (self->priv->adaptative_children, _tmp0_);
}

static void
adaptative_window_update_adaptative_children (AdaptativeWindow* self,
                                              gint* width,
                                              gint* height)
{
	gboolean extra_flat = FALSE;
	gboolean flat = FALSE;
	g_return_if_fail (self != NULL);
	extra_flat = (*height) < 400;
	flat = (*height) < 500;
	if ((*width) < 590) {
		if (extra_flat) {
			adaptative_window_change_window_size (self, ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH);
		} else {
			if ((*height) < 787) {
				adaptative_window_change_window_size (self, ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT);
			} else {
				adaptative_window_change_window_size (self, ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN);
			}
		}
		adaptative_window_set_style_classes (self, TRUE, TRUE, FALSE, extra_flat, flat);
	} else {
		if ((*width) < 787) {
			if (extra_flat) {
				adaptative_window_change_window_size (self, ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL);
			} else {
				adaptative_window_change_window_size (self, ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN);
			}
			adaptative_window_set_style_classes (self, FALSE, TRUE, FALSE, extra_flat, flat);
		} else {
			if (extra_flat) {
				adaptative_window_change_window_size (self, ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT);
			} else {
				adaptative_window_change_window_size (self, ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE);
			}
			adaptative_window_set_style_classes (self, FALSE, FALSE, (*width) > LARGE_WINDOW_SIZE, extra_flat, flat);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		AdaptativeWindow* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda5_ (Block1Data* _data1_,
            AdaptativeWidget* adaptative_child)
{
	AdaptativeWindow* self;
	self = _data1_->self;
	g_return_if_fail (adaptative_child != NULL);
	adaptative_widget_set_window_size (adaptative_child, _data1_->new_window_size);
}

static void
___lambda5__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda5_ (self, (AdaptativeWidget*) data);
}

static void
adaptative_window_change_window_size (AdaptativeWindow* self,
                                      AdaptativeWidgetWindowSize new_window_size)
{
	Block1Data* _data1_;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->new_window_size = new_window_size;
	if (self->priv->window_size == _data1_->new_window_size) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	self->priv->window_size = _data1_->new_window_size;
	_tmp0_ = self->priv->adaptative_children;
	g_list_foreach (_tmp0_, ___lambda5__gfunc, _data1_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
adaptative_window_set_style_classes (AdaptativeWindow* self,
                                     gboolean extra_thin_window,
                                     gboolean thin_window,
                                     gboolean large_window,
                                     gboolean extra_flat_window,
                                     gboolean flat_window)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->has_extra_thin_window_class) {
		_tmp0_ = !extra_thin_window;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		adaptative_window_set_style_class (self, "extra-thin-window", FALSE, &self->priv->has_extra_thin_window_class);
	}
	if (self->priv->has_thin_window_class) {
		_tmp1_ = !thin_window;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		adaptative_window_set_style_class (self, "thin-window", FALSE, &self->priv->has_thin_window_class);
	}
	if (large_window != self->priv->has_large_window_class) {
		adaptative_window_set_style_class (self, "large-window", large_window, &self->priv->has_large_window_class);
	}
	if (thin_window != self->priv->has_thin_window_class) {
		adaptative_window_set_style_class (self, "thin-window", thin_window, &self->priv->has_thin_window_class);
	}
	if (extra_thin_window != self->priv->has_extra_thin_window_class) {
		adaptative_window_set_style_class (self, "extra-thin-window", extra_thin_window, &self->priv->has_extra_thin_window_class);
	}
	if (self->priv->has_extra_flat_window_class) {
		_tmp2_ = !extra_flat_window;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		adaptative_window_set_style_class (self, "extra-flat-window", FALSE, &self->priv->has_extra_flat_window_class);
	}
	if (flat_window != self->priv->has_flat_window_class) {
		adaptative_window_set_style_class (self, "flat-window", flat_window, &self->priv->has_flat_window_class);
	}
	if (extra_flat_window != self->priv->has_extra_flat_window_class) {
		adaptative_window_set_style_class (self, "extra-flat-window", extra_flat_window, &self->priv->has_extra_flat_window_class);
	}
}

static inline void
adaptative_window_set_style_class (AdaptativeWindow* self,
                                   const gchar* class_name,
                                   gboolean new_state,
                                   gboolean* old_state)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_name != NULL);
	*old_state = new_state;
	if (new_state) {
		GtkStyleContext* _tmp0_;
		_tmp0_ = self->priv->window_style_context;
		gtk_style_context_add_class (_tmp0_, class_name);
	} else {
		GtkStyleContext* _tmp1_;
		_tmp1_ = self->priv->window_style_context;
		gtk_style_context_remove_class (_tmp1_, class_name);
	}
}

static void
adaptative_window_load_window_state (AdaptativeWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp0_, "window-is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp1_ = self->priv->settings;
	_tmp2_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (_tmp1_, "window-width"), g_settings_get_int (_tmp2_, "window-height"));
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static void
adaptative_window_update_window_state (AdaptativeWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gint* _window_width = NULL;
	gint* _window_height = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_;
	gint* _tmp4_;
	gint _tmp5_;
	gint* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gint* _tmp8_;
	gint* _tmp10_;
	gint* _tmp11_;
	g_return_if_fail (self != NULL);
	if (self->priv->window_is_maximized) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->window_is_tiled;
	}
	if (_tmp0_) {
		return;
	}
	_window_width = NULL;
	_window_height = NULL;
	gtk_window_get_size ((GtkWindow*) self, &_tmp1_, &_tmp2_);
	_g_free0 (_window_width);
	_tmp3_ = _tmp1_;
	_tmp4_ = __int_dup0 (&_tmp3_);
	_window_width = _tmp4_;
	_g_free0 (_window_height);
	_tmp5_ = _tmp2_;
	_tmp6_ = __int_dup0 (&_tmp5_);
	_window_height = _tmp6_;
	_tmp8_ = _window_width;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		gint* _tmp9_;
		_tmp9_ = _window_height;
		_tmp7_ = _tmp9_ == NULL;
	}
	if (_tmp7_) {
		_g_free0 (_window_height);
		_g_free0 (_window_width);
		return;
	}
	_tmp10_ = _window_width;
	self->priv->window_width = (gint) (*_tmp10_);
	_tmp11_ = _window_height;
	self->priv->window_height = (gint) (*_tmp11_);
	_g_free0 (_window_height);
	_g_free0 (_window_width);
}

static void
adaptative_window_save_window_state (AdaptativeWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_set_int (_tmp1_, "window-width", self->priv->window_width);
	_tmp2_ = self->priv->settings;
	g_settings_set_int (_tmp2_, "window-height", self->priv->window_height);
	_tmp3_ = self->priv->settings;
	g_settings_set_boolean (_tmp3_, "window-is-maximized", self->priv->window_is_maximized);
	_tmp4_ = self->priv->settings;
	g_settings_apply (_tmp4_);
}

static void
_adaptative_window_update_highcontrast_state_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	adaptative_window_update_highcontrast_state ((AdaptativeWindow*) self, _sender, pspec);
}

static void
adaptative_window_manage_high_contrast (AdaptativeWindow* self)
{
	GtkSettings* nullable_gtk_settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	GtkSettings* _tmp2_;
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp3_;
	GtkSettings* _tmp4_;
	GtkSettings* _tmp5_;
	GtkSettings* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	nullable_gtk_settings = _tmp1_;
	_tmp2_ = nullable_gtk_settings;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (nullable_gtk_settings);
		return;
	}
	_tmp3_ = nullable_gtk_settings;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_settings_get_type (), GtkSettings));
	gtk_settings = _tmp4_;
	_tmp5_ = gtk_settings;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::gtk-theme-name", (GCallback) _adaptative_window_update_highcontrast_state_g_object_notify, self, 0);
	_tmp6_ = gtk_settings;
	g_object_get (_tmp6_, "gtk-theme-name", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_adaptative_window_update_highcontrast_state (self, _tmp9_);
	_g_free0 (_tmp9_);
	_g_object_unref0 (gtk_settings);
	_g_object_unref0 (nullable_gtk_settings);
}

static void
adaptative_window_update_highcontrast_state (AdaptativeWindow* self,
                                             GObject* gtk_settings,
                                             GParamSpec* unused)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gtk_settings != NULL);
	g_return_if_fail (unused != NULL);
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (gtk_settings, gtk_settings_get_type (), GtkSettings), "gtk-theme-name", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_adaptative_window_update_highcontrast_state (self, _tmp2_);
	_g_free0 (_tmp2_);
	g_signal_emit (self, adaptative_window_signals[ADAPTATIVE_WINDOW_GTK_THEME_CHANGED_SIGNAL], 0);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_adaptative_window_update_highcontrast_state (AdaptativeWindow* self,
                                              const gchar* theme_name)
{
	gboolean highcontrast_new_state = FALSE;
	BaseHeaderBar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme_name != NULL);
	highcontrast_new_state = string_contains (theme_name, "HighContrast");
	if (highcontrast_new_state == self->priv->highcontrast_state) {
		return;
	}
	self->priv->highcontrast_state = highcontrast_new_state;
	_tmp0_ = self->priv->headerbar;
	base_header_bar_update_hamburger_menu (_tmp0_);
	if (highcontrast_new_state) {
		GtkStyleContext* _tmp1_;
		_tmp1_ = self->priv->window_style_context;
		gtk_style_context_add_class (_tmp1_, "hc-theme");
	} else {
		GtkStyleContext* _tmp2_;
		_tmp2_ = self->priv->window_style_context;
		gtk_style_context_remove_class (_tmp2_, "hc-theme");
	}
}

AdaptativeWindow*
adaptative_window_construct (GType object_type)
{
	AdaptativeWindow * self = NULL;
	self = (AdaptativeWindow*) g_object_new (object_type, NULL);
	return self;
}

BaseHeaderBar*
adaptative_window_get_nta_headerbar (AdaptativeWindow* self)
{
	BaseHeaderBar* result;
	BaseHeaderBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->headerbar;
	result = _tmp0_;
	return result;
}

static void
adaptative_window_set_nta_headerbar (AdaptativeWindow* self,
                                     BaseHeaderBar* value)
{
	BaseHeaderBar* _value = NULL;
	BaseHeaderBar* _tmp0_;
	BaseHeaderBar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_value = _tmp0_;
	if (_value == NULL) {
		g_assert_not_reached ();
	}
	_tmp1_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp1_;
	gtk_widget_show ((GtkWidget*) value);
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) value);
	_g_object_unref0 (_value);
}

static void
adaptative_window_set_window_title (AdaptativeWindow* self,
                                    const gchar* value)
{
	gchar* _value = NULL;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_value = _tmp0_;
	if (_value == NULL) {
		g_assert_not_reached ();
	}
	gtk_window_set_title ((GtkWindow*) self, value);
	_g_free0 (_value);
}

static void
adaptative_window_set_specific_css_class_or_empty (AdaptativeWindow* self,
                                                   const gchar* value)
{
	gchar* _value = NULL;
	gchar* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_value = _tmp0_;
	if (_value == NULL) {
		g_assert_not_reached ();
	}
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->window_style_context);
	self->priv->window_style_context = _tmp2_;
	if (g_strcmp0 (value, "") != 0) {
		GtkStyleContext* _tmp3_;
		_tmp3_ = self->priv->window_style_context;
		gtk_style_context_add_class (_tmp3_, value);
	}
	_g_free0 (_value);
}

static void
adaptative_window_set_schema_path (AdaptativeWindow* self,
                                   const gchar* value)
{
	gchar* _value = NULL;
	gchar* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_value = _tmp0_;
	if (_value == NULL) {
		g_assert_not_reached ();
	}
	_tmp1_ = g_settings_new_with_path ("ca.desrt.dconf-editor.Lib", value);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_g_free0 (_value);
}

static gboolean
_adaptative_window___lambda6_ (AdaptativeWindow* self)
{
	GtkStyleContext* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->window_style_context;
	gtk_style_context_remove_class (_tmp0_, "startup");
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
__adaptative_window___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = _adaptative_window___lambda6_ ((AdaptativeWindow*) self);
	return result;
}

static GObject *
adaptative_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AdaptativeWindow * self;
	GtkStyleContext* _tmp0_;
	parent_class = G_OBJECT_CLASS (adaptative_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow);
	_tmp0_ = self->priv->window_style_context;
	gtk_style_context_add_class (_tmp0_, "startup");
	adaptative_window_manage_high_contrast (self);
	adaptative_window_load_window_state (self);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, __adaptative_window___lambda6__gsource_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
adaptative_window_class_init (AdaptativeWindowClass * klass,
                              gpointer klass_data)
{
	adaptative_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AdaptativeWindow_private_offset);
	((AdaptativeWindowClass *) klass)->before_destroy = (void (*) (AdaptativeWindow*)) adaptative_window_real_before_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_adaptative_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_adaptative_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = adaptative_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = adaptative_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ADAPTATIVE_WINDOW_NTA_HEADERBAR_PROPERTY, adaptative_window_properties[ADAPTATIVE_WINDOW_NTA_HEADERBAR_PROPERTY] = g_param_spec_object ("nta-headerbar", "nta-headerbar", "nta-headerbar", TYPE_BASE_HEADER_BAR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ADAPTATIVE_WINDOW_WINDOW_TITLE_PROPERTY, adaptative_window_properties[ADAPTATIVE_WINDOW_WINDOW_TITLE_PROPERTY] = g_param_spec_string ("window-title", "window-title", "window-title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ADAPTATIVE_WINDOW_SPECIFIC_CSS_CLASS_OR_EMPTY_PROPERTY, adaptative_window_properties[ADAPTATIVE_WINDOW_SPECIFIC_CSS_CLASS_OR_EMPTY_PROPERTY] = g_param_spec_string ("specific-css-class-or-empty", "specific-css-class-or-empty", "specific-css-class-or-empty", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ADAPTATIVE_WINDOW_SCHEMA_PATH_PROPERTY, adaptative_window_properties[ADAPTATIVE_WINDOW_SCHEMA_PATH_PROPERTY] = g_param_spec_string ("schema-path", "schema-path", "schema-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/ca/desrt/dconf-editor/ui/adaptative-window.ui");
	adaptative_window_signals[ADAPTATIVE_WINDOW_GTK_THEME_CHANGED_SIGNAL] = g_signal_new ("gtk-theme-changed", TYPE_ADAPTATIVE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_state_event", G_CALLBACK(_adaptative_window_on_window_state_event_gtk_widget_window_state_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_size_allocate", G_CALLBACK(_adaptative_window_on_size_allocate_gtk_widget_size_allocate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_destroy", G_CALLBACK(_adaptative_window_on_destroy_gtk_widget_destroy));
}

static void
adaptative_window_instance_init (AdaptativeWindow * self,
                                 gpointer klass)
{
	self->priv = adaptative_window_get_instance_private (self);
	self->priv->window_size = ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE;
	self->priv->adaptative_children = NULL;
	self->priv->has_extra_thin_window_class = FALSE;
	self->priv->has_thin_window_class = FALSE;
	self->priv->has_large_window_class = FALSE;
	self->priv->has_extra_flat_window_class = FALSE;
	self->priv->has_flat_window_class = FALSE;
	self->priv->window_width = 0;
	self->priv->window_height = 0;
	self->priv->window_is_maximized = FALSE;
	self->priv->window_is_tiled = FALSE;
	self->priv->highcontrast_state = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
adaptative_window_finalize (GObject * obj)
{
	AdaptativeWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->window_style_context);
	(self->priv->adaptative_children == NULL) ? NULL : (self->priv->adaptative_children = (_g_list_free__g_object_unref0_ (self->priv->adaptative_children), NULL));
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (adaptative_window_parent_class)->finalize (obj);
}

static GType
adaptative_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AdaptativeWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) adaptative_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AdaptativeWindow), 0, (GInstanceInitFunc) adaptative_window_instance_init, NULL };
	GType adaptative_window_type_id;
	adaptative_window_type_id = g_type_register_static (gtk_application_window_get_type (), "AdaptativeWindow", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	AdaptativeWindow_private_offset = g_type_add_instance_private (adaptative_window_type_id, sizeof (AdaptativeWindowPrivate));
	return adaptative_window_type_id;
}

GType
adaptative_window_get_type (void)
{
	static volatile gsize adaptative_window_type_id__once = 0;
	if (g_once_init_enter (&adaptative_window_type_id__once)) {
		GType adaptative_window_type_id;
		adaptative_window_type_id = adaptative_window_get_type_once ();
		g_once_init_leave (&adaptative_window_type_id__once, adaptative_window_type_id);
	}
	return adaptative_window_type_id__once;
}

static void
_vala_adaptative_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	AdaptativeWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow);
	switch (property_id) {
		case ADAPTATIVE_WINDOW_NTA_HEADERBAR_PROPERTY:
		g_value_set_object (value, adaptative_window_get_nta_headerbar (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_adaptative_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	AdaptativeWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow);
	switch (property_id) {
		case ADAPTATIVE_WINDOW_NTA_HEADERBAR_PROPERTY:
		adaptative_window_set_nta_headerbar (self, g_value_get_object (value));
		break;
		case ADAPTATIVE_WINDOW_WINDOW_TITLE_PROPERTY:
		adaptative_window_set_window_title (self, g_value_get_string (value));
		break;
		case ADAPTATIVE_WINDOW_SPECIFIC_CSS_CLASS_OR_EMPTY_PROPERTY:
		adaptative_window_set_specific_css_class_or_empty (self, g_value_get_string (value));
		break;
		case ADAPTATIVE_WINDOW_SCHEMA_PATH_PROPERTY:
		adaptative_window_set_schema_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

