#include "clisp.h"

extern gcv_object_t module__readline__object_tab[];
#include "config.h"
#include <stdio.h>
#include <readline/readline.h>
#if RL_VERSION_MAJOR >= 7
typedef unsigned long rl_readline_state_t;
#else
typedef int rl_readline_state_t;
#endif
#define HAVE_RL_READLINE_STATE_T 1
#include <readline/rlconf.h>
#include <readline/history.h>
#include <readline/tilde.h>

subr_t module__readline__subr_tab[1];
uintC module__readline__subr_tab_size = 0;
subr_initdata_t module__readline__subr_tab_initdata[1];

gcv_object_t module__readline__object_tab[1];
object_initdata_t module__readline__object_tab_initdata[1];
uintC module__readline__object_tab_size = 0;

const char* module__readline__constant_map_c_string (int number, int *definedp);
const char* module__readline__constant_map_c_string (int number, int *definedp) {
  *definedp=1;
  switch (number) {
# if defined(DEFAULT_INPUTRC)
    case 0: return DEFAULT_INPUTRC;
# endif
# if defined(SYS_INPUTRC)
    case 1: return SYS_INPUTRC;
# endif
    default: *definedp=0; return 0;
  }
}
long module__readline__constant_map_long (int number, int *definedp);
long module__readline__constant_map_long (int number, int *definedp) {
  *definedp=1;
  switch (number) {
# if defined(RL_READLINE_VERSION)
    case 0: return RL_READLINE_VERSION;
# endif
# if defined(RL_VERSION_MAJOR)
    case 1: return RL_VERSION_MAJOR;
# endif
# if defined(RL_VERSION_MINOR)
    case 2: return RL_VERSION_MINOR;
# endif
# if defined(RL_STATE_NONE)
    case 3: return RL_STATE_NONE;
# endif
# if defined(RL_STATE_INITIALIZING)
    case 4: return RL_STATE_INITIALIZING;
# endif
# if defined(RL_STATE_INITIALIZED)
    case 5: return RL_STATE_INITIALIZED;
# endif
# if defined(RL_STATE_TERMPREPPED)
    case 6: return RL_STATE_TERMPREPPED;
# endif
# if defined(RL_STATE_READCMD)
    case 7: return RL_STATE_READCMD;
# endif
# if defined(RL_STATE_METANEXT)
    case 8: return RL_STATE_METANEXT;
# endif
# if defined(RL_STATE_DISPATCHING)
    case 9: return RL_STATE_DISPATCHING;
# endif
# if defined(RL_STATE_MOREINPUT)
    case 10: return RL_STATE_MOREINPUT;
# endif
# if defined(RL_STATE_ISEARCH)
    case 11: return RL_STATE_ISEARCH;
# endif
# if defined(RL_STATE_NSEARCH)
    case 12: return RL_STATE_NSEARCH;
# endif
# if defined(RL_STATE_SEARCH)
    case 13: return RL_STATE_SEARCH;
# endif
# if defined(RL_STATE_NUMERICARG)
    case 14: return RL_STATE_NUMERICARG;
# endif
# if defined(RL_STATE_MACROINPUT)
    case 15: return RL_STATE_MACROINPUT;
# endif
# if defined(RL_STATE_MACRODEF)
    case 16: return RL_STATE_MACRODEF;
# endif
# if defined(RL_STATE_OVERWRITE)
    case 17: return RL_STATE_OVERWRITE;
# endif
# if defined(RL_STATE_COMPLETING)
    case 18: return RL_STATE_COMPLETING;
# endif
# if defined(RL_STATE_SIGHANDLER)
    case 19: return RL_STATE_SIGHANDLER;
# endif
# if defined(RL_STATE_UNDOING)
    case 20: return RL_STATE_UNDOING;
# endif
# if defined(RL_STATE_INPUTPENDING)
    case 21: return RL_STATE_INPUTPENDING;
# endif
# if defined(RL_STATE_TTYCSAVED)
    case 22: return RL_STATE_TTYCSAVED;
# endif
# if defined(RL_STATE_CALLBACK)
    case 23: return RL_STATE_CALLBACK;
# endif
# if defined(RL_STATE_VIMOTION)
    case 24: return RL_STATE_VIMOTION;
# endif
# if defined(RL_STATE_MULTIKEY)
    case 25: return RL_STATE_MULTIKEY;
# endif
# if defined(RL_STATE_VICMDONCE)
    case 26: return RL_STATE_VICMDONCE;
# endif
# if defined(RL_STATE_REDISPLAYING)
    case 27: return RL_STATE_REDISPLAYING;
# endif
# if defined(RL_STATE_DONE)
    case 28: return RL_STATE_DONE;
# endif
# if defined(READERR)
    case 29: return READERR;
# endif
    default: *definedp=0; return 0;
  }
}

void module__readline__init_function_1 (module_t* module);
void module__readline__init_function_2 (module_t* module);
void module__readline__fini_function (module_t* module);

void module__readline__init_function_1 (module_t* module)
{
  (void)module; /* avoid -Wunused-parameter */

# if HAVE_RL_READLINE_STATE_T
  register_foreign_inttype("rl_readline_state_t",sizeof(rl_readline_state_t),(rl_readline_state_t)-1<=(rl_readline_state_t)0);
# endif
}

void module__readline__init_function_2 (module_t* module)
{
  (void)module; /* avoid -Wunused-parameter */

# if HAVE_DECL_RL_LIBRARY_VERSION
  register_foreign_variable((void*)&rl_library_version,"rl_library_version",1,sizeof(rl_library_version));
# endif
# if HAVE_DECL_RL_READLINE_VERSION
  register_foreign_variable((void*)&rl_readline_version,"rl_readline_version",1,sizeof(rl_readline_version));
# endif
# if HAVE_DECL_RL_GNU_READLINE_P
  register_foreign_variable((void*)&rl_gnu_readline_p,"rl_gnu_readline_p",0,sizeof(rl_gnu_readline_p));
# endif
# if HAVE_DECL_RL_READLINE_STATE
  register_foreign_variable((void*)&rl_readline_state,"rl_readline_state",0,sizeof(rl_readline_state));
# endif
# if HAVE_DECL_RL_EDITING_MODE
  register_foreign_variable((void*)&rl_editing_mode,"rl_editing_mode",0,sizeof(rl_editing_mode));
# endif
# if HAVE_DECL_RL_INSERT_MODE
  register_foreign_variable((void*)&rl_insert_mode,"rl_insert_mode",0,sizeof(rl_insert_mode));
# endif
# if HAVE_DECL_RL_READLINE_NAME
  register_foreign_variable((void*)&rl_readline_name,"rl_readline_name",2,sizeof(rl_readline_name));
# endif
# if HAVE_DECL_RL_PROMPT
  register_foreign_variable((void*)&rl_prompt,"rl_prompt",1,sizeof(rl_prompt));
# endif
# if HAVE_DECL_RL_DISPLAY_PROMPT
  register_foreign_variable((void*)&rl_display_prompt,"rl_display_prompt",1,sizeof(rl_display_prompt));
# endif
# if HAVE_DECL_RL_LINE_BUFFER
  register_foreign_variable((void*)&rl_line_buffer,"rl_line_buffer",0,sizeof(rl_line_buffer));
# endif
# if HAVE_DECL_RL_POINT
  register_foreign_variable((void*)&rl_point,"rl_point",0,sizeof(rl_point));
# endif
# if HAVE_DECL_RL_END
  register_foreign_variable((void*)&rl_end,"rl_end",0,sizeof(rl_end));
# endif
# if HAVE_DECL_RL_MARK
  register_foreign_variable((void*)&rl_mark,"rl_mark",0,sizeof(rl_mark));
# endif
# if HAVE_DECL_RL_DONE
  register_foreign_variable((void*)&rl_done,"rl_done",0,sizeof(rl_done));
# endif
# if HAVE_DECL_RL_PENDING_INPUT
  register_foreign_variable((void*)&rl_pending_input,"rl_pending_input",0,sizeof(rl_pending_input));
# endif
# if HAVE_DECL_RL_DISPATCHING
  register_foreign_variable((void*)&rl_dispatching,"rl_dispatching",1,sizeof(rl_dispatching));
# endif
# if HAVE_DECL_RL_EXPLICIT_ARG
  register_foreign_variable((void*)&rl_explicit_arg,"rl_explicit_arg",0,sizeof(rl_explicit_arg));
# endif
# if HAVE_DECL_RL_NUMERIC_ARG
  register_foreign_variable((void*)&rl_numeric_arg,"rl_numeric_arg",0,sizeof(rl_numeric_arg));
# endif
# if HAVE_DECL_RL_LAST_FUNC
  register_foreign_variable((void*)&rl_last_func,"rl_last_func",0,sizeof(rl_last_func));
# endif
# if HAVE_DECL_RL_TERMINAL_NAME
  register_foreign_variable((void*)&rl_terminal_name,"rl_terminal_name",0,sizeof(rl_terminal_name));
# endif
# if HAVE_DECL_RL_INSTREAM
  register_foreign_variable((void*)&rl_instream,"rl_instream",0,sizeof(rl_instream));
# endif
# if HAVE_DECL_RL_OUTSTREAM
  register_foreign_variable((void*)&rl_outstream,"rl_outstream",0,sizeof(rl_outstream));
# endif
# if HAVE_DECL_RL_PREFER_ENV_WINSIZE
  register_foreign_variable((void*)&rl_prefer_env_winsize,"rl_prefer_env_winsize",0,sizeof(rl_prefer_env_winsize));
# endif
# if HAVE_DECL_RL_STARTUP_HOOK
  register_foreign_variable((void*)&rl_startup_hook,"rl_startup_hook",0,sizeof(rl_startup_hook));
# endif
# if HAVE_DECL_RL_PRE_INPUT_HOOK
  register_foreign_variable((void*)&rl_pre_input_hook,"rl_pre_input_hook",0,sizeof(rl_pre_input_hook));
# endif
# if HAVE_DECL_RL_EVENT_HOOK
  register_foreign_variable((void*)&rl_event_hook,"rl_event_hook",0,sizeof(rl_event_hook));
# endif
# if HAVE_DECL_RL_GETC_FUNCTION
  register_foreign_variable((void*)&rl_getc_function,"rl_getc_function",0,sizeof(rl_getc_function));
# endif
# if HAVE_DECL_RL_INPUT_AVAILABLE_HOOK
  register_foreign_variable((void*)&rl_input_available_hook,"rl_input_available_hook",0,sizeof(rl_input_available_hook));
# endif
# if HAVE_DECL_RL_ERASE_EMPTY_LINE
  register_foreign_variable((void*)&rl_erase_empty_line,"rl_erase_empty_line",0,sizeof(rl_erase_empty_line));
# endif
# if HAVE_DECL_RL_ALREADY_PROMPTED
  register_foreign_variable((void*)&rl_already_prompted,"rl_already_prompted",0,sizeof(rl_already_prompted));
# endif
# if HAVE_DECL_RL_NUM_CHARS_TO_READ
  register_foreign_variable((void*)&rl_num_chars_to_read,"rl_num_chars_to_read",0,sizeof(rl_num_chars_to_read));
# endif
# if HAVE_DECL_RL_EXECUTING_MACRO
  register_foreign_variable((void*)&rl_executing_macro,"rl_executing_macro",0,sizeof(rl_executing_macro));
# endif
# if HAVE_DECL_RL_FILENAME_QUOTING_DESIRED
  register_foreign_variable((void*)&rl_filename_quoting_desired,"rl_filename_quoting_desired",0,sizeof(rl_filename_quoting_desired));
# endif
# if HAVE_DECL_RL_ATTEMPTED_COMPLETION_OVER
  register_foreign_variable((void*)&rl_attempted_completion_over,"rl_attempted_completion_over",0,sizeof(rl_attempted_completion_over));
# endif
# if HAVE_DECL_RL_COMPLETION_TYPE
  register_foreign_variable((void*)&rl_completion_type,"rl_completion_type",0,sizeof(rl_completion_type));
# endif
# if HAVE_DECL_RL_COMPLETION_INVOKING_KEY
  register_foreign_variable((void*)&rl_completion_invoking_key,"rl_completion_invoking_key",0,sizeof(rl_completion_invoking_key));
# endif
# if HAVE_DECL_RL_COMPLETION_QUERY_ITEMS
  register_foreign_variable((void*)&rl_completion_query_items,"rl_completion_query_items",0,sizeof(rl_completion_query_items));
# endif
# if HAVE_DECL_RL_COMPLETION_APPEND_CHARACTER
  register_foreign_variable((void*)&rl_completion_append_character,"rl_completion_append_character",0,sizeof(rl_completion_append_character));
# endif
# if HAVE_DECL_RL_COMPLETION_SUPPRESS_APPEND
  register_foreign_variable((void*)&rl_completion_suppress_append,"rl_completion_suppress_append",0,sizeof(rl_completion_suppress_append));
# endif
# if HAVE_DECL_RL_COMPLETION_QUOTE_CHARACTER
  register_foreign_variable((void*)&rl_completion_quote_character,"rl_completion_quote_character",0,sizeof(rl_completion_quote_character));
# endif
# if HAVE_DECL_RL_COMPLETION_FOUND_QUOTE
  register_foreign_variable((void*)&rl_completion_found_quote,"rl_completion_found_quote",0,sizeof(rl_completion_found_quote));
# endif
# if HAVE_DECL_RL_COMPLETION_SUPPRESS_QUOTE
  register_foreign_variable((void*)&rl_completion_suppress_quote,"rl_completion_suppress_quote",0,sizeof(rl_completion_suppress_quote));
# endif
# if HAVE_DECL_RL_SORT_COMPLETION_MATCHES
  register_foreign_variable((void*)&rl_sort_completion_matches,"rl_sort_completion_matches",0,sizeof(rl_sort_completion_matches));
# endif
# if HAVE_DECL_RL_COMPLETION_MARK_SYMLINK_DIRS
  register_foreign_variable((void*)&rl_completion_mark_symlink_dirs,"rl_completion_mark_symlink_dirs",0,sizeof(rl_completion_mark_symlink_dirs));
# endif
# if HAVE_DECL_RL_IGNORE_COMPLETION_DUPLICATES
  register_foreign_variable((void*)&rl_ignore_completion_duplicates,"rl_ignore_completion_duplicates",0,sizeof(rl_ignore_completion_duplicates));
# endif
# if HAVE_DECL_RL_INHIBIT_COMPLETION
  register_foreign_variable((void*)&rl_inhibit_completion,"rl_inhibit_completion",0,sizeof(rl_inhibit_completion));
# endif
# if defined(HAVE_READLINE)
  register_foreign_function((void*)&readline,"readline",1026);
# endif
# if defined(HAVE_RL_SET_PROMPT)
  register_foreign_function((void*)&rl_set_prompt,"rl_set_prompt",1024);
# endif
# if defined(HAVE_RL_INITIALIZE)
  register_foreign_function((void*)&rl_initialize,"rl_initialize",1024);
# endif
# if defined(HAVE_RL_READ_INIT_FILE)
  register_foreign_function((void*)&rl_read_init_file,"rl_read_init_file",1024);
# endif
# if defined(HAVE_RL_ADD_DEFUN)
  register_foreign_function((void*)&rl_add_defun,"rl_add_defun",1024);
# endif
# if defined(HAVE_RL_MAKE_BARE_KEYMAP)
  register_foreign_function((void*)&rl_make_bare_keymap,"rl_make_bare_keymap",1024);
# endif
# if defined(HAVE_RL_COPY_KEYMAP)
  register_foreign_function((void*)&rl_copy_keymap,"rl_copy_keymap",1024);
# endif
# if defined(HAVE_RL_MAKE_KEYMAP)
  register_foreign_function((void*)&rl_make_keymap,"rl_make_keymap",1024);
# endif
# if defined(HAVE_RL_DISCARD_KEYMAP)
  register_foreign_function((void*)&rl_discard_keymap,"rl_discard_keymap",1024);
# endif
# if defined(HAVE_RL_FREE_KEYMAP)
  register_foreign_function((void*)&rl_free_keymap,"rl_free_keymap",1024);
# endif
# if defined(HAVE_RL_GET_KEYMAP)
  register_foreign_function((void*)&rl_get_keymap,"rl_get_keymap",1024);
# endif
# if defined(HAVE_RL_SET_KEYMAP)
  register_foreign_function((void*)&rl_set_keymap,"rl_set_keymap",1024);
# endif
# if defined(HAVE_RL_GET_KEYMAP_BY_NAME)
  register_foreign_function((void*)&rl_get_keymap_by_name,"rl_get_keymap_by_name",1024);
# endif
# if defined(HAVE_RL_BIND_KEY)
  register_foreign_function((void*)&rl_bind_key,"rl_bind_key",1024);
# endif
# if defined(HAVE_RL_BIND_KEY_IN_MAP)
  register_foreign_function((void*)&rl_bind_key_in_map,"rl_bind_key_in_map",1024);
# endif
# if defined(HAVE_RL_BIND_KEY_IF_UNBOUND)
  register_foreign_function((void*)&rl_bind_key_if_unbound,"rl_bind_key_if_unbound",1024);
# endif
# if defined(HAVE_RL_BIND_KEY_IF_UNBOUND_IN_MAP)
  register_foreign_function((void*)&rl_bind_key_if_unbound_in_map,"rl_bind_key_if_unbound_in_map",1024);
# endif
# if defined(HAVE_RL_UNBIND_KEY)
  register_foreign_function((void*)&rl_unbind_key,"rl_unbind_key",1024);
# endif
# if defined(HAVE_RL_UNBIND_KEY_IN_MAP)
  register_foreign_function((void*)&rl_unbind_key_in_map,"rl_unbind_key_in_map",1024);
# endif
# if defined(HAVE_RL_UNBIND_FUNCTION_IN_MAP)
  register_foreign_function((void*)&rl_unbind_function_in_map,"rl_unbind_function_in_map",1024);
# endif
# if defined(HAVE_RL_UNBIND_COMMAND_IN_MAP)
  register_foreign_function((void*)&rl_unbind_command_in_map,"rl_unbind_command_in_map",1024);
# endif
# if defined(HAVE_RL_BIND_KEYSEQ)
  register_foreign_function((void*)&rl_bind_keyseq,"rl_bind_keyseq",1024);
# endif
# if defined(HAVE_RL_BIND_KEYSEQ_IN_MAP)
  register_foreign_function((void*)&rl_bind_keyseq_in_map,"rl_bind_keyseq_in_map",1024);
# endif
# if defined(HAVE_RL_BIND_KEYSEQ_IF_UNBOUND)
  register_foreign_function((void*)&rl_bind_keyseq_if_unbound,"rl_bind_keyseq_if_unbound",1024);
# endif
# if defined(HAVE_RL_BIND_KEYSEQ_IF_UNBOUND_IN_MAP)
  register_foreign_function((void*)&rl_bind_keyseq_if_unbound_in_map,"rl_bind_keyseq_if_unbound_in_map",1024);
# endif
# if defined(HAVE_RL_GENERIC_BIND)
  register_foreign_function((void*)&rl_generic_bind,"rl_generic_bind",1024);
# endif
# if defined(HAVE_RL_PARSE_AND_BIND)
  register_foreign_function((void*)&rl_parse_and_bind,"rl_parse_and_bind",1024);
# endif
# if defined(HAVE_RL_NAMED_FUNCTION)
  register_foreign_function((void*)&rl_named_function,"rl_named_function",1024);
# endif
# if defined(HAVE_RL_FUNCTION_OF_KEYSEQ)
  register_foreign_function((void*)&rl_function_of_keyseq,"rl_function_of_keyseq",1024);
# endif
# if defined(HAVE_RL_INVOKING_KEYSEQS)
  register_foreign_function((void*)&rl_invoking_keyseqs,"rl_invoking_keyseqs",1024);
# endif
# if defined(HAVE_RL_INVOKING_KEYSEQS_IN_MAP)
  register_foreign_function((void*)&rl_invoking_keyseqs_in_map,"rl_invoking_keyseqs_in_map",1024);
# endif
# if defined(HAVE_RL_FUNCTION_DUMPER)
  register_foreign_function((void*)&rl_function_dumper,"rl_function_dumper",1024);
# endif
# if defined(HAVE_RL_LIST_FUNMAP_NAMES)
  register_foreign_function((void*)&rl_list_funmap_names,"rl_list_funmap_names",1024);
# endif
# if defined(HAVE_RL_FUNMAP_NAMES)
  register_foreign_function((void*)&rl_funmap_names,"rl_funmap_names",1024);
# endif
# if defined(HAVE_RL_ADD_FUNMAP_ENTRY)
  register_foreign_function((void*)&rl_add_funmap_entry,"rl_add_funmap_entry",1024);
# endif
# if defined(HAVE_RL_BEGIN_UNDO_GROUP)
  register_foreign_function((void*)&rl_begin_undo_group,"rl_begin_undo_group",1024);
# endif
# if defined(HAVE_RL_END_UNDO_GROUP)
  register_foreign_function((void*)&rl_end_undo_group,"rl_end_undo_group",1024);
# endif
# if defined(HAVE_RL_ADD_UNDO)
  register_foreign_function((void*)&rl_add_undo,"rl_add_undo",1024);
# endif
# if defined(HAVE_RL_FREE_UNDO_LIST)
  register_foreign_function((void*)&rl_free_undo_list,"rl_free_undo_list",1024);
# endif
# if defined(HAVE_RL_DO_UNDO)
  register_foreign_function((void*)&rl_do_undo,"rl_do_undo",1024);
# endif
# if defined(HAVE_RL_MODIFYING)
  register_foreign_function((void*)&rl_modifying,"rl_modifying",1024);
# endif
# if defined(HAVE_RL_REDISPLAY)
  register_foreign_function((void*)&rl_redisplay,"rl_redisplay",1024);
# endif
# if defined(HAVE_RL_FORCED_UPDATE_DISPLAY)
  register_foreign_function((void*)&rl_forced_update_display,"rl_forced_update_display",1024);
# endif
# if defined(HAVE_RL_ON_NEW_LINE)
  register_foreign_function((void*)&rl_on_new_line,"rl_on_new_line",1024);
# endif
# if defined(HAVE_RL_ON_NEW_LINE_WITH_PROMPT)
  register_foreign_function((void*)&rl_on_new_line_with_prompt,"rl_on_new_line_with_prompt",1024);
# endif
# if defined(HAVE_RL_CLEAR_VISIBLE_LINE)
  register_foreign_function((void*)&rl_clear_visible_line,"rl_clear_visible_line",1024);
# endif
# if defined(HAVE_RL_RESET_LINE_STATE)
  register_foreign_function((void*)&rl_reset_line_state,"rl_reset_line_state",1024);
# endif
# if defined(HAVE_RL_CRLF)
  register_foreign_function((void*)&rl_crlf,"rl_crlf",1024);
# endif
# if defined(HAVE_RL_SHOW_CHAR)
  register_foreign_function((void*)&rl_show_char,"rl_show_char",1024);
# endif
# if defined(HAVE_RL_MESSAGE)
  register_foreign_function((void*)&rl_message,"rl_message",1024);
# endif
# if defined(HAVE_RL_CLEAR_MESSAGE)
  register_foreign_function((void*)&rl_clear_message,"rl_clear_message",1024);
# endif
# if defined(HAVE_RL_SAVE_PROMPT)
  register_foreign_function((void*)&rl_save_prompt,"rl_save_prompt",1024);
# endif
# if defined(HAVE_RL_RESTORE_PROMPT)
  register_foreign_function((void*)&rl_restore_prompt,"rl_restore_prompt",1024);
# endif
# if defined(HAVE_RL_EXPAND_PROMPT)
  register_foreign_function((void*)&rl_expand_prompt,"rl_expand_prompt",1024);
# endif
# if defined(HAVE_RL_INSERT_TEXT)
  register_foreign_function((void*)&rl_insert_text,"rl_insert_text",1024);
# endif
# if defined(HAVE_RL_DELETE_TEXT)
  register_foreign_function((void*)&rl_delete_text,"rl_delete_text",1024);
# endif
# if defined(HAVE_RL_COPY_TEXT)
  register_foreign_function((void*)&rl_copy_text,"rl_copy_text",1024);
# endif
# if defined(HAVE_RL_KILL_TEXT)
  register_foreign_function((void*)&rl_kill_text,"rl_kill_text",1024);
# endif
# if defined(HAVE_RL_PUSH_MACRO_INPUT)
  register_foreign_function((void*)&rl_push_macro_input,"rl_push_macro_input",1024);
# endif
# if defined(HAVE_RL_READ_KEY)
  register_foreign_function((void*)&rl_read_key,"rl_read_key",1024);
# endif
# if defined(HAVE_RL_GETC)
  register_foreign_function((void*)&rl_getc,"rl_getc",1024);
# endif
# if defined(HAVE_RL_STUFF_CHAR)
  register_foreign_function((void*)&rl_stuff_char,"rl_stuff_char",1024);
# endif
# if defined(HAVE_RL_EXECUTE_NEXT)
  register_foreign_function((void*)&rl_execute_next,"rl_execute_next",1024);
# endif
# if defined(HAVE_RL_CLEAR_PENDING_INPUT)
  register_foreign_function((void*)&rl_clear_pending_input,"rl_clear_pending_input",1024);
# endif
# if defined(HAVE_RL_SET_KEYBOARD_INPUT_TIMEOUT)
  register_foreign_function((void*)&rl_set_keyboard_input_timeout,"rl_set_keyboard_input_timeout",1024);
# endif
# if defined(HAVE_RL_PREP_TERMINAL)
  register_foreign_function((void*)&rl_prep_terminal,"rl_prep_terminal",1024);
# endif
# if defined(HAVE_RL_DEPREP_TERMINAL)
  register_foreign_function((void*)&rl_deprep_terminal,"rl_deprep_terminal",1024);
# endif
# if defined(HAVE_RL_TTY_SET_DEFAULT_BINDINGS)
  register_foreign_function((void*)&rl_tty_set_default_bindings,"rl_tty_set_default_bindings",1024);
# endif
# if defined(HAVE_RL_RESET_TERMINAL)
  register_foreign_function((void*)&rl_reset_terminal,"rl_reset_terminal",1024);
# endif
# if defined(HAVE_RL_REPLACE_LINE)
  register_foreign_function((void*)&rl_replace_line,"rl_replace_line",1024);
# endif
# if defined(HAVE_RL_EXTEND_LINE_BUFFER)
  register_foreign_function((void*)&rl_extend_line_buffer,"rl_extend_line_buffer",1024);
# endif
# if defined(HAVE_RL_DING)
  register_foreign_function((void*)&rl_ding,"rl_ding",1024);
# endif
# if defined(HAVE_RL_ALPHABETIC)
  register_foreign_function((void*)&rl_alphabetic,"rl_alphabetic",1024);
# endif
# if defined(HAVE_RL_FREE)
  register_foreign_function((void*)&rl_free,"rl_free",1024);
# endif
# if defined(HAVE_RL_DISPLAY_MATCH_LIST)
  register_foreign_function((void*)&rl_display_match_list,"rl_display_match_list",1024);
# endif
# if defined(HAVE_RL_VARIABLE_VALUE)
  register_foreign_function((void*)&rl_variable_value,"rl_variable_value",1024);
# endif
# if defined(HAVE_RL_VARIABLE_BIND)
  register_foreign_function((void*)&rl_variable_bind,"rl_variable_bind",1024);
# endif
# if defined(HAVE_RL_MACRO_DUMPER)
  register_foreign_function((void*)&rl_macro_dumper,"rl_macro_dumper",1024);
# endif
# if defined(HAVE_RL_VARIABLE_DUMPER)
  register_foreign_function((void*)&rl_variable_dumper,"rl_variable_dumper",1024);
# endif
# if defined(HAVE_RL_ECHO_SIGNAL_CHAR)
  register_foreign_function((void*)&rl_echo_signal_char,"rl_echo_signal_char",1024);
# endif
# if defined(HAVE_RL_SET_PAREN_BLINK_TIMEOUT)
  register_foreign_function((void*)&rl_set_paren_blink_timeout,"rl_set_paren_blink_timeout",1024);
# endif
# if defined(HAVE_RL_CLEAR_HISTORY)
  register_foreign_function((void*)&rl_clear_history,"rl_clear_history",1024);
# endif
# if defined(HAVE_RL_GET_TERMCAP)
  register_foreign_function((void*)&rl_get_termcap,"rl_get_termcap",1024);
# endif
# if defined(HAVE_RL_RESIZE_TERMINAL)
  register_foreign_function((void*)&rl_resize_terminal,"rl_resize_terminal",1024);
# endif
# if defined(HAVE_RL_SET_SCREEN_SIZE)
  register_foreign_function((void*)&rl_set_screen_size,"rl_set_screen_size",1024);
# endif
# if defined(HAVE_RL_GET_SCREEN_SIZE)
  register_foreign_function((void*)&rl_get_screen_size,"rl_get_screen_size",1024);
# endif
# if defined(HAVE_RL_RESET_SCREEN_SIZE)
  register_foreign_function((void*)&rl_reset_screen_size,"rl_reset_screen_size",1024);
# endif
# if defined(HAVE_RL_CALLBACK_HANDLER_INSTALL)
  register_foreign_function((void*)&rl_callback_handler_install,"rl_callback_handler_install",1024);
# endif
# if defined(HAVE_RL_CALLBACK_READ_CHAR)
  register_foreign_function((void*)&rl_callback_read_char,"rl_callback_read_char",1024);
# endif
# if defined(HAVE_RL_CALLBACK_HANDLER_REMOVE)
  register_foreign_function((void*)&rl_callback_handler_remove,"rl_callback_handler_remove",1024);
# endif
# if defined(HAVE_USING_HISTORY)
  register_foreign_function((void*)&using_history,"using_history",1024);
# endif
# if defined(HAVE_ADD_HISTORY)
  register_foreign_function((void*)&add_history,"add_history",1024);
# endif
# if defined(HAVE_STIFLE_HISTORY)
  register_foreign_function((void*)&stifle_history,"stifle_history",1024);
# endif
# if defined(HAVE_UNSTIFLE_HISTORY)
  register_foreign_function((void*)&unstifle_history,"unstifle_history",1024);
# endif
# if defined(HAVE_HISTORY_IS_STIFLED)
  register_foreign_function((void*)&history_is_stifled,"history_is_stifled",1024);
# endif
# if defined(HAVE_WHERE_HISTORY)
  register_foreign_function((void*)&where_history,"where_history",1024);
# endif
# if defined(HAVE_HISTORY_TOTAL_BYTES)
  register_foreign_function((void*)&history_total_bytes,"history_total_bytes",1024);
# endif
# if defined(HAVE_HISTORY_SET_POS)
  register_foreign_function((void*)&history_set_pos,"history_set_pos",1024);
# endif
# if defined(HAVE_HISTORY_SEARCH)
  register_foreign_function((void*)&history_search,"history_search",1024);
# endif
# if defined(HAVE_HISTORY_SEARCH_PREFIX)
  register_foreign_function((void*)&history_search_prefix,"history_search_prefix",1024);
# endif
# if defined(HAVE_HISTORY_SEARCH_POS)
  register_foreign_function((void*)&history_search_pos,"history_search_pos",1024);
# endif
# if defined(HAVE_READ_HISTORY)
  register_foreign_function((void*)&read_history,"read_history",1024);
# endif
# if defined(HAVE_READ_HISTORY_RANGE)
  register_foreign_function((void*)&read_history_range,"read_history_range",1024);
# endif
# if defined(HAVE_WRITE_HISTORY)
  register_foreign_function((void*)&write_history,"write_history",1024);
# endif
# if defined(HAVE_APPEND_HISTORY)
  register_foreign_function((void*)&append_history,"append_history",1024);
# endif
# if defined(HAVE_HISTORY_TRUNCATE_FILE)
  register_foreign_function((void*)&history_truncate_file,"history_truncate_file",1024);
# endif
# if defined(HAVE_TILDE_EXPAND)
  register_foreign_function((void*)&tilde_expand,"tilde_expand",1024);
# endif
  register_foreign_function((void*)&module__readline__constant_map_c_string,"module__readline__constant_map_c_string",1024);
  register_foreign_function((void*)&module__readline__constant_map_long,"module__readline__constant_map_long",1024);
}

void module__readline__fini_function (module_t* module)
{
  (void)module; /* avoid -Wunused-parameter */

}
