from enum import Enum


class IpFwOpcode(Enum):
    O_NOP = 0
    O_IP_SRC = 1
    O_IP_SRC_MASK = 2
    O_IP_SRC_ME = 3
    O_IP_SRC_SET = 4
    O_IP_DST = 5
    O_IP_DST_MASK = 6
    O_IP_DST_ME = 7
    O_IP_DST_SET = 8
    O_IP_SRCPORT = 9
    O_IP_DSTPORT = 10
    O_PROTO = 11
    O_MACADDR2 = 12
    O_MAC_TYPE = 13
    O_LAYER2 = 14
    O_IN = 15
    O_FRAG = 16
    O_RECV = 17
    O_XMIT = 18
    O_VIA = 19
    O_IPOPT = 20
    O_IPLEN = 21
    O_IPID = 22
    O_IPTOS = 23
    O_IPPRECEDENCE = 24
    O_IPTTL = 25
    O_IPVER = 26
    O_UID = 27
    O_GID = 28
    O_ESTAB = 29
    O_TCPFLAGS = 30
    O_TCPWIN = 31
    O_TCPSEQ = 32
    O_TCPACK = 33
    O_ICMPTYPE = 34
    O_TCPOPTS = 35
    O_VERREVPATH = 36
    O_VERSRCREACH = 37
    O_PROBE_STATE = 38
    O_KEEP_STATE = 39
    O_LIMIT = 40
    O_LIMIT_PARENT = 41
    O_LOG = 42
    O_PROB = 43
    O_CHECK_STATE = 44
    O_ACCEPT = 45
    O_DENY = 46
    O_REJECT = 47
    O_COUNT = 48
    O_SKIPTO = 49
    O_PIPE = 50
    O_QUEUE = 51
    O_DIVERT = 52
    O_TEE = 53
    O_FORWARD_IP = 54
    O_FORWARD_MAC = 55
    O_NAT = 56
    O_REASS = 57
    O_IPSEC = 58
    O_IP_SRC_LOOKUP = 59
    O_IP_DST_LOOKUP = 60
    O_ANTISPOOF = 61
    O_JAIL = 62
    O_ALTQ = 63
    O_DIVERTED = 64
    O_TCPDATALEN = 65
    O_IP6_SRC = 66
    O_IP6_SRC_ME = 67
    O_IP6_SRC_MASK = 68
    O_IP6_DST = 69
    O_IP6_DST_ME = 70
    O_IP6_DST_MASK = 71
    O_FLOW6ID = 72
    O_ICMP6TYPE = 73
    O_EXT_HDR = 74
    O_IP6 = 75
    O_NETGRAPH = 76
    O_NGTEE = 77
    O_IP4 = 78
    O_UNREACH6 = 79
    O_TAG = 80
    O_TAGGED = 81
    O_SETFIB = 82
    O_FIB = 83
    O_SOCKARG = 84
    O_CALLRETURN = 85
    O_FORWARD_IP6 = 86
    O_DSCP = 87
    O_SETDSCP = 88
    O_IP_FLOW_LOOKUP = 89
    O_EXTERNAL_ACTION = 90
    O_EXTERNAL_INSTANCE = 91
    O_EXTERNAL_DATA = 92
    O_SKIP_ACTION = 93
    O_TCPMSS = 94
    O_MAC_SRC_LOOKUP = 95
    O_MAC_DST_LOOKUP = 96
    O_SETMARK = 97
    O_MARK = 98
    O_LAST_OPCODE = 99


class Op3CmdType(Enum):
    IP_FW_TABLE_XADD = 86
    IP_FW_TABLE_XDEL = 87
    IP_FW_TABLE_XGETSIZE = 88
    IP_FW_TABLE_XLIST = 89
    IP_FW_TABLE_XDESTROY = 90
    IP_FW_TABLES_XLIST = 92
    IP_FW_TABLE_XINFO = 93
    IP_FW_TABLE_XFLUSH = 94
    IP_FW_TABLE_XCREATE = 95
    IP_FW_TABLE_XMODIFY = 96
    IP_FW_XGET = 97
    IP_FW_XADD = 98
    IP_FW_XDEL = 99
    IP_FW_XMOVE = 100
    IP_FW_XZERO = 101
    IP_FW_XRESETLOG = 102
    IP_FW_SET_SWAP = 103
    IP_FW_SET_MOVE = 104
    IP_FW_SET_ENABLE = 105
    IP_FW_TABLE_XFIND = 106
    IP_FW_XIFLIST = 107
    IP_FW_TABLES_ALIST = 108
    IP_FW_TABLE_XSWAP = 109
    IP_FW_TABLE_VLIST = 110
    IP_FW_NAT44_XCONFIG = 111
    IP_FW_NAT44_DESTROY = 112
    IP_FW_NAT44_XGETCONFIG = 113
    IP_FW_NAT44_LIST_NAT = 114
    IP_FW_NAT44_XGETLOG = 115
    IP_FW_DUMP_SOPTCODES = 116
    IP_FW_DUMP_SRVOBJECTS = 117
    IP_FW_NAT64STL_CREATE = 130
    IP_FW_NAT64STL_DESTROY = 131
    IP_FW_NAT64STL_CONFIG = 132
    IP_FW_NAT64STL_LIST = 133
    IP_FW_NAT64STL_STATS = 134
    IP_FW_NAT64STL_RESET_STATS = 135
    IP_FW_NAT64LSN_CREATE = 140
    IP_FW_NAT64LSN_DESTROY = 141
    IP_FW_NAT64LSN_CONFIG = 142
    IP_FW_NAT64LSN_LIST = 143
    IP_FW_NAT64LSN_STATS = 144
    IP_FW_NAT64LSN_LIST_STATES = 145
    IP_FW_NAT64LSN_RESET_STATS = 146
    IP_FW_NPTV6_CREATE = 150
    IP_FW_NPTV6_DESTROY = 151
    IP_FW_NPTV6_CONFIG = 152
    IP_FW_NPTV6_LIST = 153
    IP_FW_NPTV6_STATS = 154
    IP_FW_NPTV6_RESET_STATS = 155
    IP_FW_NAT64CLAT_CREATE = 160
    IP_FW_NAT64CLAT_DESTROY = 161
    IP_FW_NAT64CLAT_CONFIG = 162
    IP_FW_NAT64CLAT_LIST = 163
    IP_FW_NAT64CLAT_STATS = 164
    IP_FW_NAT64CLAT_RESET_STATS = 165


class IcmpRejectCode(Enum):
    ICMP_UNREACH_NET = 0
    ICMP_UNREACH_HOST = 1
    ICMP_UNREACH_PROTOCOL = 2
    ICMP_UNREACH_PORT = 3
    ICMP_UNREACH_NEEDFRAG = 4
    ICMP_UNREACH_SRCFAIL = 5
    ICMP_UNREACH_NET_UNKNOWN = 6
    ICMP_UNREACH_HOST_UNKNOWN = 7
    ICMP_UNREACH_ISOLATED = 8
    ICMP_UNREACH_NET_PROHIB = 9
    ICMP_UNREACH_HOST_PROHIB = 10
    ICMP_UNREACH_TOSNET = 11
    ICMP_UNREACH_TOSHOST = 12
    ICMP_UNREACH_FILTER_PROHIB = 13
    ICMP_UNREACH_HOST_PRECEDENCE = 14
    ICMP_UNREACH_PRECEDENCE_CUTOFF = 15
    ICMP_REJECT_RST = 256
    ICMP_REJECT_ABORT = 257


class Icmp6RejectCode(Enum):
    ICMP6_DST_UNREACH_NOROUTE = 0
    ICMP6_DST_UNREACH_ADMIN = 1
    ICMP6_DST_UNREACH_BEYONDSCOPE = 2
    ICMP6_DST_UNREACH_NOTNEIGHBOR = 2
    ICMP6_DST_UNREACH_ADDR = 3
    ICMP6_DST_UNREACH_NOPORT = 4
    ICMP6_DST_UNREACH_POLICY = 5
    ICMP6_DST_UNREACH_REJECT = 6
    ICMP6_DST_UNREACH_SRCROUTE = 7
    ICMP6_UNREACH_RST = 256
    ICMP6_UNREACH_ABORT = 257
