/*
	trf-nwid.c - routine to try to figure out the width of an en
	in the current point size.  This is used by the table writing
	code in an attempt to get cells the right width.

	If you're trying to figure out widths for another version of
	troff, run nwidth.trf through it and look at the result.
*/

# include	<stdio.h>
# include	<sys/types.h>
# include	"rtf.h"
# include	"rtf2troff.h"

typedef	struct EnVal	EnVal;

struct	EnVal
{
	int	size;
	double	width;
};

# define	uXroff	300.0	/* xroff dpi */

EnVal	enXroff [] =
{
	3,	9./uXroff,	/* xroff uses 4 */
	4,	9./uXroff,
	5,	11./uXroff,
	6,	13./uXroff,
	7,	16./uXroff,
	8,	18./uXroff,
	9,	20./uXroff,
	10,	22./uXroff,
	11,	25./uXroff,
	12,	27./uXroff,
	13,	29./uXroff,
	14,	31./uXroff,
	15,	34./uXroff,
	16,	36./uXroff,
	17,	36./uXroff,	/* xroff uses 16 */
	18,	40./uXroff,
	19,	40./uXroff,	/* xroff uses 18 */
	20,	45./uXroff,
	22,	45./uXroff,	/* xroff uses 20 */
	24,	54./uXroff,
	26,	54./uXroff,	/* xroff uses 24
	28,	63./uXroff,
	30,	67./uXroff,
	32,	67./uXroff,	/* xroff uses 0?!? Use 30 instead */
	34,	67./uXroff,	/* xroff uses 0?!? Use 30 instead */
	36,	81./uXroff,
	38,	81./uXroff,	/* xroff uses 36 */
	40,	81./uXroff,	/* xroff uses 36
	44,	107./uXroff,	/* xroff uses 48 */
	48,	107./uXroff,
	72,	107./uXroff,	/* xroff uses 48 */
	0,	50./uXroff	/* 0 = end of table; 50 = default size */
};


static double	EVTabLookup ();


static double EVTabLookup (tab)
EnVal	tab[];
{
int	ps = ics->fontSize;
EnVal	*p;

	for (p = tab; p->size != 0; p++)
	{
		if (p->size >= ps)
			return (p->width);
	}
	return (p->width);	/* use last width as default */
}


double EnWidth ()
{
	/*
		Our tpscript uses 720 as resolution base, and character
		sizes are 5 times the point size.
	*/
	if (tvers == PSTROFF)
		return (ics->fontSize * 5. / 720.);

	/* default - covers troff and xroff */
	return (EVTabLookup (enXroff));
}
