package Daje::Database::Model::Super::Users;
use Mojo::Base 'Daje::Database::Model::Super::Common::Base', -base, -signatures;

# Autogenerated class Thu Mar  6 17:15:18 2025
# Any manual changes to this class will be overwritten next time its generated

has 'fields' => "users_pkey, editnum, insby, insdatetime, modby, moddatetime, active, is_admin, password, phone, support, userid, username, workflow_fkey";
has 'primary_key_name' => "users_pkey";
has 'table_name' => "users";




sub load_pkey($self, $users_pkey) {

    my $result = $self->load_pk(
        $self->table_name,
        $self->fields,
        $self->primary_key_name,
        $users_pkey
    );
    return $result;
}


sub load_workflow_fkey($self, $workflow_fkey ) {

    my $result = $self->load_fkey(
        $self->table_name,
        $self->fields,
        'workflow_fkey',
        $workflow_fkey
    );
    return $result;
}




sub insert_users($self, $data) {
    my $result = $self->insert($self->table_name, $data, $self->primary_key_name);
    return $result;
}


sub update_users($self, $data, $keys) {
    my $result = $self->update($self->table_name, $data, $keys);
    return $result;
}


sub load_list($self, $key_value) {
    my $result = $self->load_a_list(
        $self->table_name,
        $self->fields,
        $key_value
    );
    return $result;
}


sub load_users_userid ($self, $userid) {

    my $result = $self->load_from_index(
        $self->table_name,
        $self->fields,
        {userid  =>  $userid}
    );
    return $result;
};



1;

